package securityinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/securityinsight/mgmt/2019-01-01-preview/securityinsight"

// AlertRuleKind enumerates the values for alert rule kind.
type AlertRuleKind string

const (
	// Fusion ...
	Fusion AlertRuleKind = "Fusion"
	// MicrosoftSecurityIncidentCreation ...
	MicrosoftSecurityIncidentCreation AlertRuleKind = "MicrosoftSecurityIncidentCreation"
	// Scheduled ...
	Scheduled AlertRuleKind = "Scheduled"
)

// PossibleAlertRuleKindValues returns an array of possible values for the AlertRuleKind const type.
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return []AlertRuleKind{Fusion, MicrosoftSecurityIncidentCreation, Scheduled}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// High High severity
	High AlertSeverity = "High"
	// Informational Informational severity
	Informational AlertSeverity = "Informational"
	// Low Low severity
	Low AlertSeverity = "Low"
	// Medium Medium severity
	Medium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{High, Informational, Low, Medium}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// AlertStatusDismissed Alert dismissed as false positive
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusInProgress Alert is being handled
	AlertStatusInProgress AlertStatus = "InProgress"
	// AlertStatusNew New alert
	AlertStatusNew AlertStatus = "New"
	// AlertStatusResolved Alert closed after handling
	AlertStatusResolved AlertStatus = "Resolved"
	// AlertStatusUnknown Unknown value
	AlertStatusUnknown AlertStatus = "Unknown"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{AlertStatusDismissed, AlertStatusInProgress, AlertStatusNew, AlertStatusResolved, AlertStatusUnknown}
}

// AttackTactic enumerates the values for attack tactic.
type AttackTactic string

const (
	// Collection ...
	Collection AttackTactic = "Collection"
	// CommandAndControl ...
	CommandAndControl AttackTactic = "CommandAndControl"
	// CredentialAccess ...
	CredentialAccess AttackTactic = "CredentialAccess"
	// DefenseEvasion ...
	DefenseEvasion AttackTactic = "DefenseEvasion"
	// Discovery ...
	Discovery AttackTactic = "Discovery"
	// Execution ...
	Execution AttackTactic = "Execution"
	// Exfiltration ...
	Exfiltration AttackTactic = "Exfiltration"
	// Impact ...
	Impact AttackTactic = "Impact"
	// InitialAccess ...
	InitialAccess AttackTactic = "InitialAccess"
	// LateralMovement ...
	LateralMovement AttackTactic = "LateralMovement"
	// Persistence ...
	Persistence AttackTactic = "Persistence"
	// PrivilegeEscalation ...
	PrivilegeEscalation AttackTactic = "PrivilegeEscalation"
)

// PossibleAttackTacticValues returns an array of possible values for the AttackTactic const type.
func PossibleAttackTacticValues() []AttackTactic {
	return []AttackTactic{Collection, CommandAndControl, CredentialAccess, DefenseEvasion, Discovery, Execution, Exfiltration, Impact, InitialAccess, LateralMovement, Persistence, PrivilegeEscalation}
}

// CaseSeverity enumerates the values for case severity.
type CaseSeverity string

const (
	// CaseSeverityCritical Critical severity
	CaseSeverityCritical CaseSeverity = "Critical"
	// CaseSeverityHigh High severity
	CaseSeverityHigh CaseSeverity = "High"
	// CaseSeverityInformational Informational severity
	CaseSeverityInformational CaseSeverity = "Informational"
	// CaseSeverityLow Low severity
	CaseSeverityLow CaseSeverity = "Low"
	// CaseSeverityMedium Medium severity
	CaseSeverityMedium CaseSeverity = "Medium"
)

// PossibleCaseSeverityValues returns an array of possible values for the CaseSeverity const type.
func PossibleCaseSeverityValues() []CaseSeverity {
	return []CaseSeverity{CaseSeverityCritical, CaseSeverityHigh, CaseSeverityInformational, CaseSeverityLow, CaseSeverityMedium}
}

// CaseStatus enumerates the values for case status.
type CaseStatus string

const (
	// CaseStatusClosed A non active case
	CaseStatusClosed CaseStatus = "Closed"
	// CaseStatusDraft Case that wasn't promoted yet to active
	CaseStatusDraft CaseStatus = "Draft"
	// CaseStatusInProgress An active case which is handled
	CaseStatusInProgress CaseStatus = "InProgress"
	// CaseStatusNew An active case which isn't handled currently
	CaseStatusNew CaseStatus = "New"
)

// PossibleCaseStatusValues returns an array of possible values for the CaseStatus const type.
func PossibleCaseStatusValues() []CaseStatus {
	return []CaseStatus{CaseStatusClosed, CaseStatusDraft, CaseStatusInProgress, CaseStatusNew}
}

// CloseReason enumerates the values for close reason.
type CloseReason string

const (
	// Dismissed Case was dismissed
	Dismissed CloseReason = "Dismissed"
	// FalsePositive Case was false positive
	FalsePositive CloseReason = "FalsePositive"
	// Other Case was closed for another reason
	Other CloseReason = "Other"
	// Resolved Case was resolved
	Resolved CloseReason = "Resolved"
	// TruePositive Case was true positive
	TruePositive CloseReason = "TruePositive"
)

// PossibleCloseReasonValues returns an array of possible values for the CloseReason const type.
func PossibleCloseReasonValues() []CloseReason {
	return []CloseReason{Dismissed, FalsePositive, Other, Resolved, TruePositive}
}

// ConfidenceLevel enumerates the values for confidence level.
type ConfidenceLevel string

const (
	// ConfidenceLevelHigh High confidence that the alert is true positive malicious
	ConfidenceLevelHigh ConfidenceLevel = "High"
	// ConfidenceLevelLow Low confidence, meaning we have some doubts this is indeed malicious or part of an
	// attack
	ConfidenceLevelLow ConfidenceLevel = "Low"
	// ConfidenceLevelUnknown Unknown confidence, the is the default value
	ConfidenceLevelUnknown ConfidenceLevel = "Unknown"
)

// PossibleConfidenceLevelValues returns an array of possible values for the ConfidenceLevel const type.
func PossibleConfidenceLevelValues() []ConfidenceLevel {
	return []ConfidenceLevel{ConfidenceLevelHigh, ConfidenceLevelLow, ConfidenceLevelUnknown}
}

// ConfidenceScoreStatus enumerates the values for confidence score status.
type ConfidenceScoreStatus string

const (
	// Final Final score was calculated and available
	Final ConfidenceScoreStatus = "Final"
	// InProcess No score was set yet and calculation is in progress
	InProcess ConfidenceScoreStatus = "InProcess"
	// NotApplicable Score will not be calculated for this alert as it is not supported by virtual analyst
	NotApplicable ConfidenceScoreStatus = "NotApplicable"
	// NotFinal Score is calculated and shown as part of the alert, but may be updated again at a later time
	// following the processing of additional data
	NotFinal ConfidenceScoreStatus = "NotFinal"
)

// PossibleConfidenceScoreStatusValues returns an array of possible values for the ConfidenceScoreStatus const type.
func PossibleConfidenceScoreStatusValues() []ConfidenceScoreStatus {
	return []ConfidenceScoreStatus{Final, InProcess, NotApplicable, NotFinal}
}

// DataConnectorAuthorizationState enumerates the values for data connector authorization state.
type DataConnectorAuthorizationState string

const (
	// Invalid ...
	Invalid DataConnectorAuthorizationState = "Invalid"
	// Valid ...
	Valid DataConnectorAuthorizationState = "Valid"
)

// PossibleDataConnectorAuthorizationStateValues returns an array of possible values for the DataConnectorAuthorizationState const type.
func PossibleDataConnectorAuthorizationStateValues() []DataConnectorAuthorizationState {
	return []DataConnectorAuthorizationState{Invalid, Valid}
}

// DataConnectorKind enumerates the values for data connector kind.
type DataConnectorKind string

const (
	// DataConnectorKindAmazonWebServicesCloudTrail ...
	DataConnectorKindAmazonWebServicesCloudTrail DataConnectorKind = "AmazonWebServicesCloudTrail"
	// DataConnectorKindAzureActiveDirectory ...
	DataConnectorKindAzureActiveDirectory DataConnectorKind = "AzureActiveDirectory"
	// DataConnectorKindAzureAdvancedThreatProtection ...
	DataConnectorKindAzureAdvancedThreatProtection DataConnectorKind = "AzureAdvancedThreatProtection"
	// DataConnectorKindAzureSecurityCenter ...
	DataConnectorKindAzureSecurityCenter DataConnectorKind = "AzureSecurityCenter"
	// DataConnectorKindMicrosoftCloudAppSecurity ...
	DataConnectorKindMicrosoftCloudAppSecurity DataConnectorKind = "MicrosoftCloudAppSecurity"
	// DataConnectorKindMicrosoftDefenderAdvancedThreatProtection ...
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = "MicrosoftDefenderAdvancedThreatProtection"
	// DataConnectorKindOffice365 ...
	DataConnectorKindOffice365 DataConnectorKind = "Office365"
	// DataConnectorKindThreatIntelligence ...
	DataConnectorKindThreatIntelligence DataConnectorKind = "ThreatIntelligence"
	// DataConnectorKindThreatIntelligenceTaxii ...
	DataConnectorKindThreatIntelligenceTaxii DataConnectorKind = "ThreatIntelligenceTaxii"
)

// PossibleDataConnectorKindValues returns an array of possible values for the DataConnectorKind const type.
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return []DataConnectorKind{DataConnectorKindAmazonWebServicesCloudTrail, DataConnectorKindAzureActiveDirectory, DataConnectorKindAzureAdvancedThreatProtection, DataConnectorKindAzureSecurityCenter, DataConnectorKindMicrosoftCloudAppSecurity, DataConnectorKindMicrosoftDefenderAdvancedThreatProtection, DataConnectorKindOffice365, DataConnectorKindThreatIntelligence, DataConnectorKindThreatIntelligenceTaxii}
}

// DataConnectorLicenseState enumerates the values for data connector license state.
type DataConnectorLicenseState string

const (
	// DataConnectorLicenseStateInvalid ...
	DataConnectorLicenseStateInvalid DataConnectorLicenseState = "Invalid"
	// DataConnectorLicenseStateUnknown ...
	DataConnectorLicenseStateUnknown DataConnectorLicenseState = "Unknown"
	// DataConnectorLicenseStateValid ...
	DataConnectorLicenseStateValid DataConnectorLicenseState = "Valid"
)

// PossibleDataConnectorLicenseStateValues returns an array of possible values for the DataConnectorLicenseState const type.
func PossibleDataConnectorLicenseStateValues() []DataConnectorLicenseState {
	return []DataConnectorLicenseState{DataConnectorLicenseStateInvalid, DataConnectorLicenseStateUnknown, DataConnectorLicenseStateValid}
}

// DataTypeState enumerates the values for data type state.
type DataTypeState string

const (
	// Disabled ...
	Disabled DataTypeState = "Disabled"
	// Enabled ...
	Enabled DataTypeState = "Enabled"
)

// PossibleDataTypeStateValues returns an array of possible values for the DataTypeState const type.
func PossibleDataTypeStateValues() []DataTypeState {
	return []DataTypeState{Disabled, Enabled}
}

// ElevationToken enumerates the values for elevation token.
type ElevationToken string

const (
	// Default Default elevation token
	Default ElevationToken = "Default"
	// Full Full elevation token
	Full ElevationToken = "Full"
	// Limited Limited elevation token
	Limited ElevationToken = "Limited"
)

// PossibleElevationTokenValues returns an array of possible values for the ElevationToken const type.
func PossibleElevationTokenValues() []ElevationToken {
	return []ElevationToken{Default, Full, Limited}
}

// EntitiesMatchingMethod enumerates the values for entities matching method.
type EntitiesMatchingMethod string

const (
	// All Grouping alerts into a single incident if all the entities match
	All EntitiesMatchingMethod = "All"
	// Custom Grouping alerts into a single incident if the selected entities match
	Custom EntitiesMatchingMethod = "Custom"
	// None Grouping all alerts triggered by this rule into a single incident
	None EntitiesMatchingMethod = "None"
)

// PossibleEntitiesMatchingMethodValues returns an array of possible values for the EntitiesMatchingMethod const type.
func PossibleEntitiesMatchingMethodValues() []EntitiesMatchingMethod {
	return []EntitiesMatchingMethod{All, Custom, None}
}

// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// EntityKindAccount Entity represents account in the system.
	EntityKindAccount EntityKind = "Account"
	// EntityKindAzureResource Entity represents azure resource in the system.
	EntityKindAzureResource EntityKind = "AzureResource"
	// EntityKindBookmark Entity represents bookmark in the system.
	EntityKindBookmark EntityKind = "Bookmark"
	// EntityKindCloudApplication Entity represents cloud application in the system.
	EntityKindCloudApplication EntityKind = "CloudApplication"
	// EntityKindDNSResolution Entity represents dns resolution in the system.
	EntityKindDNSResolution EntityKind = "DnsResolution"
	// EntityKindFile Entity represents file in the system.
	EntityKindFile EntityKind = "File"
	// EntityKindFileHash Entity represents file hash in the system.
	EntityKindFileHash EntityKind = "FileHash"
	// EntityKindHost Entity represents host in the system.
	EntityKindHost EntityKind = "Host"
	// EntityKindIoTDevice Entity represents IoT device in the system.
	EntityKindIoTDevice EntityKind = "IoTDevice"
	// EntityKindIP Entity represents ip in the system.
	EntityKindIP EntityKind = "Ip"
	// EntityKindMalware Entity represents malware in the system.
	EntityKindMalware EntityKind = "Malware"
	// EntityKindProcess Entity represents process in the system.
	EntityKindProcess EntityKind = "Process"
	// EntityKindRegistryKey Entity represents registry key in the system.
	EntityKindRegistryKey EntityKind = "RegistryKey"
	// EntityKindRegistryValue Entity represents registry value in the system.
	EntityKindRegistryValue EntityKind = "RegistryValue"
	// EntityKindSecurityAlert Entity represents security alert in the system.
	EntityKindSecurityAlert EntityKind = "SecurityAlert"
	// EntityKindSecurityGroup Entity represents security group in the system.
	EntityKindSecurityGroup EntityKind = "SecurityGroup"
	// EntityKindURL Entity represents url in the system.
	EntityKindURL EntityKind = "Url"
)

// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{EntityKindAccount, EntityKindAzureResource, EntityKindBookmark, EntityKindCloudApplication, EntityKindDNSResolution, EntityKindFile, EntityKindFileHash, EntityKindHost, EntityKindIoTDevice, EntityKindIP, EntityKindMalware, EntityKindProcess, EntityKindRegistryKey, EntityKindRegistryValue, EntityKindSecurityAlert, EntityKindSecurityGroup, EntityKindURL}
}

// EntityType enumerates the values for entity type.
type EntityType string

const (
	// EntityTypeAccount Entity represents account in the system.
	EntityTypeAccount EntityType = "Account"
	// EntityTypeAzureResource Entity represents azure resource in the system.
	EntityTypeAzureResource EntityType = "AzureResource"
	// EntityTypeCloudApplication Entity represents cloud application in the system.
	EntityTypeCloudApplication EntityType = "CloudApplication"
	// EntityTypeDNS Entity represents dns in the system.
	EntityTypeDNS EntityType = "DNS"
	// EntityTypeFile Entity represents file in the system.
	EntityTypeFile EntityType = "File"
	// EntityTypeFileHash Entity represents file hash in the system.
	EntityTypeFileHash EntityType = "FileHash"
	// EntityTypeHost Entity represents host in the system.
	EntityTypeHost EntityType = "Host"
	// EntityTypeHuntingBookmark Entity represents HuntingBookmark in the system.
	EntityTypeHuntingBookmark EntityType = "HuntingBookmark"
	// EntityTypeIoTDevice Entity represents IoT device in the system.
	EntityTypeIoTDevice EntityType = "IoTDevice"
	// EntityTypeIP Entity represents ip in the system.
	EntityTypeIP EntityType = "IP"
	// EntityTypeMalware Entity represents malware in the system.
	EntityTypeMalware EntityType = "Malware"
	// EntityTypeProcess Entity represents process in the system.
	EntityTypeProcess EntityType = "Process"
	// EntityTypeRegistryKey Entity represents registry key in the system.
	EntityTypeRegistryKey EntityType = "RegistryKey"
	// EntityTypeRegistryValue Entity represents registry value in the system.
	EntityTypeRegistryValue EntityType = "RegistryValue"
	// EntityTypeSecurityAlert Entity represents security alert in the system.
	EntityTypeSecurityAlert EntityType = "SecurityAlert"
	// EntityTypeSecurityGroup Entity represents security group in the system.
	EntityTypeSecurityGroup EntityType = "SecurityGroup"
	// EntityTypeURL Entity represents url in the system.
	EntityTypeURL EntityType = "URL"
)

// PossibleEntityTypeValues returns an array of possible values for the EntityType const type.
func PossibleEntityTypeValues() []EntityType {
	return []EntityType{EntityTypeAccount, EntityTypeAzureResource, EntityTypeCloudApplication, EntityTypeDNS, EntityTypeFile, EntityTypeFileHash, EntityTypeHost, EntityTypeHuntingBookmark, EntityTypeIoTDevice, EntityTypeIP, EntityTypeMalware, EntityTypeProcess, EntityTypeRegistryKey, EntityTypeRegistryValue, EntityTypeSecurityAlert, EntityTypeSecurityGroup, EntityTypeURL}
}

// FileHashAlgorithm enumerates the values for file hash algorithm.
type FileHashAlgorithm string

const (
	// MD5 MD5 hash type
	MD5 FileHashAlgorithm = "MD5"
	// SHA1 SHA1 hash type
	SHA1 FileHashAlgorithm = "SHA1"
	// SHA256 SHA256 hash type
	SHA256 FileHashAlgorithm = "SHA256"
	// SHA256AC SHA256 Authenticode hash type
	SHA256AC FileHashAlgorithm = "SHA256AC"
	// Unknown Unknown hash algorithm
	Unknown FileHashAlgorithm = "Unknown"
)

// PossibleFileHashAlgorithmValues returns an array of possible values for the FileHashAlgorithm const type.
func PossibleFileHashAlgorithmValues() []FileHashAlgorithm {
	return []FileHashAlgorithm{MD5, SHA1, SHA256, SHA256AC, Unknown}
}

// GroupingEntityType enumerates the values for grouping entity type.
type GroupingEntityType string

const (
	// Account Account entity
	Account GroupingEntityType = "Account"
	// Host Host entity
	Host GroupingEntityType = "Host"
	// IP Ip entity
	IP GroupingEntityType = "Ip"
	// URL Url entity
	URL GroupingEntityType = "Url"
)

// PossibleGroupingEntityTypeValues returns an array of possible values for the GroupingEntityType const type.
func PossibleGroupingEntityTypeValues() []GroupingEntityType {
	return []GroupingEntityType{Account, Host, IP, URL}
}

// IncidentClassification enumerates the values for incident classification.
type IncidentClassification string

const (
	// IncidentClassificationBenignPositive Incident was benign positive
	IncidentClassificationBenignPositive IncidentClassification = "BenignPositive"
	// IncidentClassificationFalsePositive Incident was false positive
	IncidentClassificationFalsePositive IncidentClassification = "FalsePositive"
	// IncidentClassificationTruePositive Incident was true positive
	IncidentClassificationTruePositive IncidentClassification = "TruePositive"
	// IncidentClassificationUndetermined Incident classification was undetermined
	IncidentClassificationUndetermined IncidentClassification = "Undetermined"
)

// PossibleIncidentClassificationValues returns an array of possible values for the IncidentClassification const type.
func PossibleIncidentClassificationValues() []IncidentClassification {
	return []IncidentClassification{IncidentClassificationBenignPositive, IncidentClassificationFalsePositive, IncidentClassificationTruePositive, IncidentClassificationUndetermined}
}

// IncidentClassificationReason enumerates the values for incident classification reason.
type IncidentClassificationReason string

const (
	// InaccurateData Classification reason was inaccurate data
	InaccurateData IncidentClassificationReason = "InaccurateData"
	// IncorrectAlertLogic Classification reason was incorrect alert logic
	IncorrectAlertLogic IncidentClassificationReason = "IncorrectAlertLogic"
	// SuspiciousActivity Classification reason was suspicious activity
	SuspiciousActivity IncidentClassificationReason = "SuspiciousActivity"
	// SuspiciousButExpected Classification reason was suspicious but expected
	SuspiciousButExpected IncidentClassificationReason = "SuspiciousButExpected"
)

// PossibleIncidentClassificationReasonValues returns an array of possible values for the IncidentClassificationReason const type.
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return []IncidentClassificationReason{InaccurateData, IncorrectAlertLogic, SuspiciousActivity, SuspiciousButExpected}
}

// IncidentLabelType enumerates the values for incident label type.
type IncidentLabelType string

const (
	// System Label automatically created by the system
	System IncidentLabelType = "System"
	// User Label manually created by a user
	User IncidentLabelType = "User"
)

// PossibleIncidentLabelTypeValues returns an array of possible values for the IncidentLabelType const type.
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return []IncidentLabelType{System, User}
}

// IncidentSeverity enumerates the values for incident severity.
type IncidentSeverity string

const (
	// IncidentSeverityHigh High severity
	IncidentSeverityHigh IncidentSeverity = "High"
	// IncidentSeverityInformational Informational severity
	IncidentSeverityInformational IncidentSeverity = "Informational"
	// IncidentSeverityLow Low severity
	IncidentSeverityLow IncidentSeverity = "Low"
	// IncidentSeverityMedium Medium severity
	IncidentSeverityMedium IncidentSeverity = "Medium"
)

// PossibleIncidentSeverityValues returns an array of possible values for the IncidentSeverity const type.
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return []IncidentSeverity{IncidentSeverityHigh, IncidentSeverityInformational, IncidentSeverityLow, IncidentSeverityMedium}
}

// IncidentStatus enumerates the values for incident status.
type IncidentStatus string

const (
	// IncidentStatusActive An active incident which is being handled
	IncidentStatusActive IncidentStatus = "Active"
	// IncidentStatusClosed A non-active incident
	IncidentStatusClosed IncidentStatus = "Closed"
	// IncidentStatusNew An active incident which isn't being handled currently
	IncidentStatusNew IncidentStatus = "New"
)

// PossibleIncidentStatusValues returns an array of possible values for the IncidentStatus const type.
func PossibleIncidentStatusValues() []IncidentStatus {
	return []IncidentStatus{IncidentStatusActive, IncidentStatusClosed, IncidentStatusNew}
}

// KillChainIntent enumerates the values for kill chain intent.
type KillChainIntent string

const (
	// KillChainIntentCollection Collection consists of techniques used to identify and gather information,
	// such as sensitive files, from a target network prior to exfiltration. This category also covers
	// locations on a system or network where the adversary may look for information to exfiltrate.
	KillChainIntentCollection KillChainIntent = "Collection"
	// KillChainIntentCommandAndControl The command and control tactic represents how adversaries communicate
	// with systems under their control within a target network.
	KillChainIntentCommandAndControl KillChainIntent = "CommandAndControl"
	// KillChainIntentCredentialAccess Credential access represents techniques resulting in access to or
	// control over system, domain, or service credentials that are used within an enterprise environment.
	// Adversaries will likely attempt to obtain legitimate credentials from users or administrator accounts
	// (local system administrator or domain users with administrator access) to use within the network. With
	// sufficient access within a network, an adversary can create accounts for later use within the
	// environment.
	KillChainIntentCredentialAccess KillChainIntent = "CredentialAccess"
	// KillChainIntentDefenseEvasion Defense evasion consists of techniques an adversary may use to evade
	// detection or avoid other defenses. Sometimes these actions are the same as or variations of techniques
	// in other categories that have the added benefit of subverting a particular defense or mitigation.
	KillChainIntentDefenseEvasion KillChainIntent = "DefenseEvasion"
	// KillChainIntentDiscovery Discovery consists of techniques that allow the adversary to gain knowledge
	// about the system and internal network. When adversaries gain access to a new system, they must orient
	// themselves to what they now have control of and what benefits operating from that system give to their
	// current objective or overall goals during the intrusion. The operating system provides many native tools
	// that aid in this post-compromise information-gathering phase.
	KillChainIntentDiscovery KillChainIntent = "Discovery"
	// KillChainIntentExecution The execution tactic represents techniques that result in execution of
	// adversary-controlled code on a local or remote system. This tactic is often used in conjunction with
	// lateral movement to expand access to remote systems on a network.
	KillChainIntentExecution KillChainIntent = "Execution"
	// KillChainIntentExfiltration Exfiltration refers to techniques and attributes that result or aid in the
	// adversary removing files and information from a target network. This category also covers locations on a
	// system or network where the adversary may look for information to exfiltrate.
	KillChainIntentExfiltration KillChainIntent = "Exfiltration"
	// KillChainIntentExploitation Exploitation is the stage where an attacker manage to get foothold on the
	// attacked resource. This stage is applicable not only for compute hosts, but also for resources such as
	// user accounts, certificates etc. Adversaries will often be able to control the resource after this
	// stage.
	KillChainIntentExploitation KillChainIntent = "Exploitation"
	// KillChainIntentImpact The impact intent primary objective is to directly reduce the availability or
	// integrity of a system, service, or network; including manipulation of data to impact a business or
	// operational process. This would often refer to techniques such as ransom-ware, defacement, data
	// manipulation and others.
	KillChainIntentImpact KillChainIntent = "Impact"
	// KillChainIntentLateralMovement Lateral movement consists of techniques that enable an adversary to
	// access and control remote systems on a network and could, but does not necessarily, include execution of
	// tools on remote systems. The lateral movement techniques could allow an adversary to gather information
	// from a system without needing additional tools, such as a remote access tool. An adversary can use
	// lateral movement for many purposes, including remote Execution of tools, pivoting to additional systems,
	// access to specific information or files, access to additional credentials, or to cause an effect.
	KillChainIntentLateralMovement KillChainIntent = "LateralMovement"
	// KillChainIntentPersistence Persistence is any access, action, or configuration change to a system that
	// gives an adversary a persistent presence on that system. Adversaries will often need to maintain access
	// to systems through interruptions such as system restarts, loss of credentials, or other failures that
	// would require a remote access tool to restart or alternate backdoor for them to regain access.
	KillChainIntentPersistence KillChainIntent = "Persistence"
	// KillChainIntentPrivilegeEscalation Privilege escalation is the result of actions that allow an adversary
	// to obtain a higher level of permissions on a system or network. Certain tools or actions require a
	// higher level of privilege to work and are likely necessary at many points throughout an operation. User
	// accounts with permissions to access specific systems or perform specific functions necessary for
	// adversaries to achieve their objective may also be considered an escalation of privilege.
	KillChainIntentPrivilegeEscalation KillChainIntent = "PrivilegeEscalation"
	// KillChainIntentProbing Probing could be an attempt to access a certain resource regardless of a
	// malicious intent or a failed attempt to gain access to a target system to gather information prior to
	// exploitation. This step is usually detected as an attempt originating from outside the network in
	// attempt to scan the target system and find a way in.
	KillChainIntentProbing KillChainIntent = "Probing"
	// KillChainIntentUnknown The default value.
	KillChainIntentUnknown KillChainIntent = "Unknown"
)

// PossibleKillChainIntentValues returns an array of possible values for the KillChainIntent const type.
func PossibleKillChainIntentValues() []KillChainIntent {
	return []KillChainIntent{KillChainIntentCollection, KillChainIntentCommandAndControl, KillChainIntentCredentialAccess, KillChainIntentDefenseEvasion, KillChainIntentDiscovery, KillChainIntentExecution, KillChainIntentExfiltration, KillChainIntentExploitation, KillChainIntentImpact, KillChainIntentLateralMovement, KillChainIntentPersistence, KillChainIntentPrivilegeEscalation, KillChainIntentProbing, KillChainIntentUnknown}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindAggregations ...
	KindAggregations Kind = "Aggregations"
	// KindCasesAggregation ...
	KindCasesAggregation Kind = "CasesAggregation"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindAggregations, KindCasesAggregation}
}

// KindBasicAlertRule enumerates the values for kind basic alert rule.
type KindBasicAlertRule string

const (
	// KindAlertRule ...
	KindAlertRule KindBasicAlertRule = "AlertRule"
	// KindFusion ...
	KindFusion KindBasicAlertRule = "Fusion"
	// KindMicrosoftSecurityIncidentCreation ...
	KindMicrosoftSecurityIncidentCreation KindBasicAlertRule = "MicrosoftSecurityIncidentCreation"
	// KindScheduled ...
	KindScheduled KindBasicAlertRule = "Scheduled"
)

// PossibleKindBasicAlertRuleValues returns an array of possible values for the KindBasicAlertRule const type.
func PossibleKindBasicAlertRuleValues() []KindBasicAlertRule {
	return []KindBasicAlertRule{KindAlertRule, KindFusion, KindMicrosoftSecurityIncidentCreation, KindScheduled}
}

// KindBasicAlertRuleTemplate enumerates the values for kind basic alert rule template.
type KindBasicAlertRuleTemplate string

const (
	// KindBasicAlertRuleTemplateKindAlertRuleTemplate ...
	KindBasicAlertRuleTemplateKindAlertRuleTemplate KindBasicAlertRuleTemplate = "AlertRuleTemplate"
	// KindBasicAlertRuleTemplateKindFusion ...
	KindBasicAlertRuleTemplateKindFusion KindBasicAlertRuleTemplate = "Fusion"
	// KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation ...
	KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation KindBasicAlertRuleTemplate = "MicrosoftSecurityIncidentCreation"
	// KindBasicAlertRuleTemplateKindScheduled ...
	KindBasicAlertRuleTemplateKindScheduled KindBasicAlertRuleTemplate = "Scheduled"
)

// PossibleKindBasicAlertRuleTemplateValues returns an array of possible values for the KindBasicAlertRuleTemplate const type.
func PossibleKindBasicAlertRuleTemplateValues() []KindBasicAlertRuleTemplate {
	return []KindBasicAlertRuleTemplate{KindBasicAlertRuleTemplateKindAlertRuleTemplate, KindBasicAlertRuleTemplateKindFusion, KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation, KindBasicAlertRuleTemplateKindScheduled}
}

// KindBasicDataConnector enumerates the values for kind basic data connector.
type KindBasicDataConnector string

const (
	// KindAmazonWebServicesCloudTrail ...
	KindAmazonWebServicesCloudTrail KindBasicDataConnector = "AmazonWebServicesCloudTrail"
	// KindAzureActiveDirectory ...
	KindAzureActiveDirectory KindBasicDataConnector = "AzureActiveDirectory"
	// KindAzureAdvancedThreatProtection ...
	KindAzureAdvancedThreatProtection KindBasicDataConnector = "AzureAdvancedThreatProtection"
	// KindAzureSecurityCenter ...
	KindAzureSecurityCenter KindBasicDataConnector = "AzureSecurityCenter"
	// KindDataConnector ...
	KindDataConnector KindBasicDataConnector = "DataConnector"
	// KindMicrosoftCloudAppSecurity ...
	KindMicrosoftCloudAppSecurity KindBasicDataConnector = "MicrosoftCloudAppSecurity"
	// KindMicrosoftDefenderAdvancedThreatProtection ...
	KindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnector = "MicrosoftDefenderAdvancedThreatProtection"
	// KindOffice365 ...
	KindOffice365 KindBasicDataConnector = "Office365"
	// KindThreatIntelligence ...
	KindThreatIntelligence KindBasicDataConnector = "ThreatIntelligence"
	// KindThreatIntelligenceTaxii ...
	KindThreatIntelligenceTaxii KindBasicDataConnector = "ThreatIntelligenceTaxii"
)

// PossibleKindBasicDataConnectorValues returns an array of possible values for the KindBasicDataConnector const type.
func PossibleKindBasicDataConnectorValues() []KindBasicDataConnector {
	return []KindBasicDataConnector{KindAmazonWebServicesCloudTrail, KindAzureActiveDirectory, KindAzureAdvancedThreatProtection, KindAzureSecurityCenter, KindDataConnector, KindMicrosoftCloudAppSecurity, KindMicrosoftDefenderAdvancedThreatProtection, KindOffice365, KindThreatIntelligence, KindThreatIntelligenceTaxii}
}

// KindBasicDataConnectorsCheckRequirements enumerates the values for kind basic data connectors check
// requirements.
type KindBasicDataConnectorsCheckRequirements string

const (
	// KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail ...
	KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail KindBasicDataConnectorsCheckRequirements = "AmazonWebServicesCloudTrail"
	// KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory ...
	KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory KindBasicDataConnectorsCheckRequirements = "AzureActiveDirectory"
	// KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection ...
	KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = "AzureAdvancedThreatProtection"
	// KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter ...
	KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter KindBasicDataConnectorsCheckRequirements = "AzureSecurityCenter"
	// KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements ...
	KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements KindBasicDataConnectorsCheckRequirements = "DataConnectorsCheckRequirements"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity KindBasicDataConnectorsCheckRequirements = "MicrosoftCloudAppSecurity"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = "MicrosoftDefenderAdvancedThreatProtection"
	// KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence ...
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence KindBasicDataConnectorsCheckRequirements = "ThreatIntelligence"
	// KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii ...
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii KindBasicDataConnectorsCheckRequirements = "ThreatIntelligenceTaxii"
)

// PossibleKindBasicDataConnectorsCheckRequirementsValues returns an array of possible values for the KindBasicDataConnectorsCheckRequirements const type.
func PossibleKindBasicDataConnectorsCheckRequirementsValues() []KindBasicDataConnectorsCheckRequirements {
	return []KindBasicDataConnectorsCheckRequirements{KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail, KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory, KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection, KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter, KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements, KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity, KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection, KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence, KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii}
}

// KindBasicEntity enumerates the values for kind basic entity.
type KindBasicEntity string

const (
	// KindAccount ...
	KindAccount KindBasicEntity = "Account"
	// KindAzureResource ...
	KindAzureResource KindBasicEntity = "AzureResource"
	// KindCloudApplication ...
	KindCloudApplication KindBasicEntity = "CloudApplication"
	// KindDNSResolution ...
	KindDNSResolution KindBasicEntity = "DnsResolution"
	// KindEntity ...
	KindEntity KindBasicEntity = "Entity"
	// KindFile ...
	KindFile KindBasicEntity = "File"
	// KindFileHash ...
	KindFileHash KindBasicEntity = "FileHash"
	// KindHost ...
	KindHost KindBasicEntity = "Host"
	// KindIoTDevice ...
	KindIoTDevice KindBasicEntity = "IoTDevice"
	// KindIP ...
	KindIP KindBasicEntity = "Ip"
	// KindMalware ...
	KindMalware KindBasicEntity = "Malware"
	// KindProcess ...
	KindProcess KindBasicEntity = "Process"
	// KindRegistryKey ...
	KindRegistryKey KindBasicEntity = "RegistryKey"
	// KindRegistryValue ...
	KindRegistryValue KindBasicEntity = "RegistryValue"
	// KindSecurityAlert ...
	KindSecurityAlert KindBasicEntity = "SecurityAlert"
	// KindSecurityGroup ...
	KindSecurityGroup KindBasicEntity = "SecurityGroup"
	// KindURL ...
	KindURL KindBasicEntity = "Url"
)

// PossibleKindBasicEntityValues returns an array of possible values for the KindBasicEntity const type.
func PossibleKindBasicEntityValues() []KindBasicEntity {
	return []KindBasicEntity{KindAccount, KindAzureResource, KindCloudApplication, KindDNSResolution, KindEntity, KindFile, KindFileHash, KindHost, KindIoTDevice, KindIP, KindMalware, KindProcess, KindRegistryKey, KindRegistryValue, KindSecurityAlert, KindSecurityGroup, KindURL}
}

// KindBasicSettings enumerates the values for kind basic settings.
type KindBasicSettings string

const (
	// KindEyesOn ...
	KindEyesOn KindBasicSettings = "EyesOn"
	// KindSettings ...
	KindSettings KindBasicSettings = "Settings"
)

// PossibleKindBasicSettingsValues returns an array of possible values for the KindBasicSettings const type.
func PossibleKindBasicSettingsValues() []KindBasicSettings {
	return []KindBasicSettings{KindEyesOn, KindSettings}
}

// MicrosoftSecurityProductName enumerates the values for microsoft security product name.
type MicrosoftSecurityProductName string

const (
	// AzureActiveDirectoryIdentityProtection ...
	AzureActiveDirectoryIdentityProtection MicrosoftSecurityProductName = "Azure Active Directory Identity Protection"
	// AzureAdvancedThreatProtection ...
	AzureAdvancedThreatProtection MicrosoftSecurityProductName = "Azure Advanced Threat Protection"
	// AzureSecurityCenter ...
	AzureSecurityCenter MicrosoftSecurityProductName = "Azure Security Center"
	// AzureSecurityCenterforIoT ...
	AzureSecurityCenterforIoT MicrosoftSecurityProductName = "Azure Security Center for IoT"
	// MicrosoftCloudAppSecurity ...
	MicrosoftCloudAppSecurity MicrosoftSecurityProductName = "Microsoft Cloud App Security"
)

// PossibleMicrosoftSecurityProductNameValues returns an array of possible values for the MicrosoftSecurityProductName const type.
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return []MicrosoftSecurityProductName{AzureActiveDirectoryIdentityProtection, AzureAdvancedThreatProtection, AzureSecurityCenter, AzureSecurityCenterforIoT, MicrosoftCloudAppSecurity}
}

// OSFamily enumerates the values for os family.
type OSFamily string

const (
	// Android Host with Android operating system.
	Android OSFamily = "Android"
	// IOS Host with IOS operating system.
	IOS OSFamily = "IOS"
	// Linux Host with Linux operating system.
	Linux OSFamily = "Linux"
	// Windows Host with Windows operating system.
	Windows OSFamily = "Windows"
)

// PossibleOSFamilyValues returns an array of possible values for the OSFamily const type.
func PossibleOSFamilyValues() []OSFamily {
	return []OSFamily{Android, IOS, Linux, Windows}
}

// RegistryHive enumerates the values for registry hive.
type RegistryHive string

const (
	// HKEYA HKEY_A
	HKEYA RegistryHive = "HKEY_A"
	// HKEYCLASSESROOT HKEY_CLASSES_ROOT
	HKEYCLASSESROOT RegistryHive = "HKEY_CLASSES_ROOT"
	// HKEYCURRENTCONFIG HKEY_CURRENT_CONFIG
	HKEYCURRENTCONFIG RegistryHive = "HKEY_CURRENT_CONFIG"
	// HKEYCURRENTUSER HKEY_CURRENT_USER
	HKEYCURRENTUSER RegistryHive = "HKEY_CURRENT_USER"
	// HKEYCURRENTUSERLOCALSETTINGS HKEY_CURRENT_USER_LOCAL_SETTINGS
	HKEYCURRENTUSERLOCALSETTINGS RegistryHive = "HKEY_CURRENT_USER_LOCAL_SETTINGS"
	// HKEYLOCALMACHINE HKEY_LOCAL_MACHINE
	HKEYLOCALMACHINE RegistryHive = "HKEY_LOCAL_MACHINE"
	// HKEYPERFORMANCEDATA HKEY_PERFORMANCE_DATA
	HKEYPERFORMANCEDATA RegistryHive = "HKEY_PERFORMANCE_DATA"
	// HKEYPERFORMANCENLSTEXT HKEY_PERFORMANCE_NLSTEXT
	HKEYPERFORMANCENLSTEXT RegistryHive = "HKEY_PERFORMANCE_NLSTEXT"
	// HKEYPERFORMANCETEXT HKEY_PERFORMANCE_TEXT
	HKEYPERFORMANCETEXT RegistryHive = "HKEY_PERFORMANCE_TEXT"
	// HKEYUSERS HKEY_USERS
	HKEYUSERS RegistryHive = "HKEY_USERS"
)

// PossibleRegistryHiveValues returns an array of possible values for the RegistryHive const type.
func PossibleRegistryHiveValues() []RegistryHive {
	return []RegistryHive{HKEYA, HKEYCLASSESROOT, HKEYCURRENTCONFIG, HKEYCURRENTUSER, HKEYCURRENTUSERLOCALSETTINGS, HKEYLOCALMACHINE, HKEYPERFORMANCEDATA, HKEYPERFORMANCENLSTEXT, HKEYPERFORMANCETEXT, HKEYUSERS}
}

// RegistryValueKind enumerates the values for registry value kind.
type RegistryValueKind string

const (
	// RegistryValueKindBinary Binary value type
	RegistryValueKindBinary RegistryValueKind = "Binary"
	// RegistryValueKindDWord DWord value type
	RegistryValueKindDWord RegistryValueKind = "DWord"
	// RegistryValueKindExpandString ExpandString value type
	RegistryValueKindExpandString RegistryValueKind = "ExpandString"
	// RegistryValueKindMultiString MultiString value type
	RegistryValueKindMultiString RegistryValueKind = "MultiString"
	// RegistryValueKindNone None
	RegistryValueKindNone RegistryValueKind = "None"
	// RegistryValueKindQWord QWord value type
	RegistryValueKindQWord RegistryValueKind = "QWord"
	// RegistryValueKindString String value type
	RegistryValueKindString RegistryValueKind = "String"
	// RegistryValueKindUnknown Unknown value type
	RegistryValueKindUnknown RegistryValueKind = "Unknown"
)

// PossibleRegistryValueKindValues returns an array of possible values for the RegistryValueKind const type.
func PossibleRegistryValueKindValues() []RegistryValueKind {
	return []RegistryValueKind{RegistryValueKindBinary, RegistryValueKindDWord, RegistryValueKindExpandString, RegistryValueKindMultiString, RegistryValueKindNone, RegistryValueKindQWord, RegistryValueKindString, RegistryValueKindUnknown}
}

// RelationNodeKind enumerates the values for relation node kind.
type RelationNodeKind string

const (
	// RelationNodeKindBookmark Bookmark node part of the relation
	RelationNodeKindBookmark RelationNodeKind = "Bookmark"
	// RelationNodeKindCase Case node part of the relation
	RelationNodeKindCase RelationNodeKind = "Case"
)

// PossibleRelationNodeKindValues returns an array of possible values for the RelationNodeKind const type.
func PossibleRelationNodeKindValues() []RelationNodeKind {
	return []RelationNodeKind{RelationNodeKindBookmark, RelationNodeKindCase}
}

// RelationTypes enumerates the values for relation types.
type RelationTypes string

const (
	// CasesToBookmarks Relations between cases and bookmarks
	CasesToBookmarks RelationTypes = "CasesToBookmarks"
)

// PossibleRelationTypesValues returns an array of possible values for the RelationTypes const type.
func PossibleRelationTypesValues() []RelationTypes {
	return []RelationTypes{CasesToBookmarks}
}

// TemplateStatus enumerates the values for template status.
type TemplateStatus string

const (
	// Available Alert rule template is available.
	Available TemplateStatus = "Available"
	// Installed Alert rule template installed. and can not use more then once
	Installed TemplateStatus = "Installed"
	// NotAvailable Alert rule template is not available
	NotAvailable TemplateStatus = "NotAvailable"
)

// PossibleTemplateStatusValues returns an array of possible values for the TemplateStatus const type.
func PossibleTemplateStatusValues() []TemplateStatus {
	return []TemplateStatus{Available, Installed, NotAvailable}
}

// TriggerOperator enumerates the values for trigger operator.
type TriggerOperator string

const (
	// Equal ...
	Equal TriggerOperator = "Equal"
	// GreaterThan ...
	GreaterThan TriggerOperator = "GreaterThan"
	// LessThan ...
	LessThan TriggerOperator = "LessThan"
	// NotEqual ...
	NotEqual TriggerOperator = "NotEqual"
)

// PossibleTriggerOperatorValues returns an array of possible values for the TriggerOperator const type.
func PossibleTriggerOperatorValues() []TriggerOperator {
	return []TriggerOperator{Equal, GreaterThan, LessThan, NotEqual}
}

// AADCheckRequirements represents AAD (Azure Active Directory) requirements check request.
type AADCheckRequirements struct {
	// AADCheckRequirementsProperties - AAD (Azure Active Directory) requirements check properties.
	*AADCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AADCheckRequirements.
func (acr AADCheckRequirements) MarshalJSON() ([]byte, error) {
	acr.Kind = KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory
	objectMap := make(map[string]interface{})
	if acr.AADCheckRequirementsProperties != nil {
		objectMap["properties"] = acr.AADCheckRequirementsProperties
	}
	if acr.Kind != "" {
		objectMap["kind"] = acr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return &acr, true
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &acr, true
}

// UnmarshalJSON is the custom unmarshaler for AADCheckRequirements struct.
func (acr *AADCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aADCheckRequirementsProperties AADCheckRequirementsProperties
				err = json.Unmarshal(*v, &aADCheckRequirementsProperties)
				if err != nil {
					return err
				}
				acr.AADCheckRequirementsProperties = &aADCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acr.Kind = kind
			}
		}
	}

	return nil
}

// AADCheckRequirementsProperties AAD (Azure Active Directory) requirements check properties.
type AADCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// AADDataConnector represents AAD (Azure Active Directory) data connector.
type AADDataConnector struct {
	// AADDataConnectorProperties - AAD (Azure Active Directory) data connector properties.
	*AADDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AADDataConnector.
func (adc AADDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindAzureActiveDirectory
	objectMap := make(map[string]interface{})
	if adc.AADDataConnectorProperties != nil {
		objectMap["properties"] = adc.AADDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return &adc, true
}

// AsAATPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for AADDataConnector struct.
func (adc *AADDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aADDataConnectorProperties AADDataConnectorProperties
				err = json.Unmarshal(*v, &aADDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.AADDataConnectorProperties = &aADDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// AADDataConnectorProperties AAD (Azure Active Directory) data connector properties.
type AADDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AATPCheckRequirements represents AATP (Azure Advanced Threat Protection) requirements check request.
type AATPCheckRequirements struct {
	// AATPCheckRequirementsProperties - AATP (Azure Advanced Threat Protection) requirements check properties.
	*AATPCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AATPCheckRequirements.
func (acr AATPCheckRequirements) MarshalJSON() ([]byte, error) {
	acr.Kind = KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if acr.AATPCheckRequirementsProperties != nil {
		objectMap["properties"] = acr.AATPCheckRequirementsProperties
	}
	if acr.Kind != "" {
		objectMap["kind"] = acr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return &acr, true
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &acr, true
}

// UnmarshalJSON is the custom unmarshaler for AATPCheckRequirements struct.
func (acr *AATPCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aATPCheckRequirementsProperties AATPCheckRequirementsProperties
				err = json.Unmarshal(*v, &aATPCheckRequirementsProperties)
				if err != nil {
					return err
				}
				acr.AATPCheckRequirementsProperties = &aATPCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acr.Kind = kind
			}
		}
	}

	return nil
}

// AATPCheckRequirementsProperties AATP (Azure Advanced Threat Protection) requirements check properties.
type AATPCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// AATPDataConnector represents AATP (Azure Advanced Threat Protection) data connector.
type AATPDataConnector struct {
	// AATPDataConnectorProperties - AATP (Azure Advanced Threat Protection) data connector properties.
	*AATPDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AATPDataConnector.
func (adc AATPDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindAzureAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if adc.AATPDataConnectorProperties != nil {
		objectMap["properties"] = adc.AATPDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return &adc, true
}

// AsASCDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for AATPDataConnector struct.
func (adc *AATPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aATPDataConnectorProperties AATPDataConnectorProperties
				err = json.Unmarshal(*v, &aATPDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.AATPDataConnectorProperties = &aATPDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// AATPDataConnectorProperties AATP (Azure Advanced Threat Protection) data connector properties.
type AATPDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AccountEntity represents an account entity.
type AccountEntity struct {
	// AccountEntityProperties - Account entity properties
	*AccountEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEntity.
func (ae AccountEntity) MarshalJSON() ([]byte, error) {
	ae.Kind = KindAccount
	objectMap := make(map[string]interface{})
	if ae.AccountEntityProperties != nil {
		objectMap["properties"] = ae.AccountEntityProperties
	}
	if ae.Kind != "" {
		objectMap["kind"] = ae.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsAccountEntity() (*AccountEntity, bool) {
	return &ae, true
}

// AsAzureResourceEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsBasicEntity() (BasicEntity, bool) {
	return &ae, true
}

// UnmarshalJSON is the custom unmarshaler for AccountEntity struct.
func (ae *AccountEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountEntityProperties AccountEntityProperties
				err = json.Unmarshal(*v, &accountEntityProperties)
				if err != nil {
					return err
				}
				ae.AccountEntityProperties = &accountEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ae.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ae.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ae.Kind = kind
			}
		}
	}

	return nil
}

// AccountEntityProperties account entity property bag.
type AccountEntityProperties struct {
	// AadTenantID - READ-ONLY; The Azure Active Directory tenant id.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// AadUserID - READ-ONLY; The Azure Active Directory user id.
	AadUserID *string `json:"aadUserId,omitempty"`
	// AccountName - READ-ONLY; The name of the account. This field should hold only the name without any domain added to it, i.e. administrator.
	AccountName *string `json:"accountName,omitempty"`
	// DisplayName - READ-ONLY; The display name of the account.
	DisplayName *string `json:"displayName,omitempty"`
	// HostEntityID - READ-ONLY; The Host entity id that contains the account in case it is a local account (not domain joined)
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// IsDomainJoined - READ-ONLY; Determines whether this is a domain account.
	IsDomainJoined *bool `json:"isDomainJoined,omitempty"`
	// NtDomain - READ-ONLY; The NetBIOS domain name as it appears in the alert format – domain\username. Examples: NT AUTHORITY.
	NtDomain *string `json:"ntDomain,omitempty"`
	// ObjectGUID - READ-ONLY; The objectGUID attribute is a single-value attribute that is the unique identifier for the object, assigned by active directory.
	ObjectGUID *uuid.UUID `json:"objectGuid,omitempty"`
	// Puid - READ-ONLY; The Azure Active Directory Passport User ID.
	Puid *string `json:"puid,omitempty"`
	// Sid - READ-ONLY; The account security identifier, e.g. S-1-5-18.
	Sid *string `json:"sid,omitempty"`
	// UpnSuffix - READ-ONLY; The user principal name suffix for the account, in some cases it is also the domain name. Examples: contoso.com.
	UpnSuffix *string `json:"upnSuffix,omitempty"`
	// DNSDomain - READ-ONLY; The fully qualified domain DNS name.
	DNSDomain *string `json:"dnsDomain,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEntityProperties.
func (aep AccountEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ActionPropertiesBase action property bag base.
type ActionPropertiesBase struct {
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionRequest action for alert rule.
type ActionRequest struct {
	// ActionRequestProperties - Action properties for put request
	*ActionRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionRequest.
func (ar ActionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.ActionRequestProperties != nil {
		objectMap["properties"] = ar.ActionRequestProperties
	}
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionRequest struct.
func (ar *ActionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var actionRequestProperties ActionRequestProperties
				err = json.Unmarshal(*v, &actionRequestProperties)
				if err != nil {
					return err
				}
				ar.ActionRequestProperties = &actionRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		}
	}

	return nil
}

// ActionRequestProperties action property bag.
type ActionRequestProperties struct {
	// TriggerURI - Logic App Callback URL for this specific workflow.
	TriggerURI *string `json:"triggerUri,omitempty"`
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionResponse action for alert rule.
type ActionResponse struct {
	autorest.Response `json:"-"`
	// Etag - Etag of the action.
	Etag *string `json:"etag,omitempty"`
	// ActionResponseProperties - Action properties for get request
	*ActionResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionResponse.
func (ar ActionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	if ar.ActionResponseProperties != nil {
		objectMap["properties"] = ar.ActionResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionResponse struct.
func (ar *ActionResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		case "properties":
			if v != nil {
				var actionResponseProperties ActionResponseProperties
				err = json.Unmarshal(*v, &actionResponseProperties)
				if err != nil {
					return err
				}
				ar.ActionResponseProperties = &actionResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		}
	}

	return nil
}

// ActionResponseProperties action property bag.
type ActionResponseProperties struct {
	// WorkflowID - The name of the logic app's workflow.
	WorkflowID *string `json:"workflowId,omitempty"`
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionsList list all the actions.
type ActionsList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of actions.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of actions.
	Value *[]ActionResponse `json:"value,omitempty"`
}

// ActionsListIterator provides access to a complete listing of ActionResponse values.
type ActionsListIterator struct {
	i    int
	page ActionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ActionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActionsListIterator) Response() ActionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActionsListIterator) Value() ActionResponse {
	if !iter.page.NotDone() {
		return ActionResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ActionsListIterator type.
func NewActionsListIterator(page ActionsListPage) ActionsListIterator {
	return ActionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ActionsList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// actionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ActionsList) actionsListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ActionsListPage contains a page of ActionResponse values.
type ActionsListPage struct {
	fn func(context.Context, ActionsList) (ActionsList, error)
	al ActionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ActionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActionsListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActionsListPage) Response() ActionsList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActionsListPage) Values() []ActionResponse {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ActionsListPage type.
func NewActionsListPage(getNextPage func(context.Context, ActionsList) (ActionsList, error)) ActionsListPage {
	return ActionsListPage{fn: getNextPage}
}

// BasicAggregations the aggregation.
type BasicAggregations interface {
	AsCasesAggregation() (*CasesAggregation, bool)
	AsAggregations() (*Aggregations, bool)
}

// Aggregations the aggregation.
type Aggregations struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindAggregations', 'KindCasesAggregation'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicAggregations(body []byte) (BasicAggregations, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCasesAggregation):
		var ca CasesAggregation
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Aggregations
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAggregationsArray(body []byte) ([]BasicAggregations, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAggregations, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAggregations(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Aggregations.
func (a Aggregations) MarshalJSON() ([]byte, error) {
	a.Kind = KindAggregations
	objectMap := make(map[string]interface{})
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	return json.Marshal(objectMap)
}

// AsCasesAggregation is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsCasesAggregation() (*CasesAggregation, bool) {
	return nil, false
}

// AsAggregations is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsAggregations() (*Aggregations, bool) {
	return &a, true
}

// AsBasicAggregations is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsBasicAggregations() (BasicAggregations, bool) {
	return &a, true
}

// AggregationsKind describes an Azure resource with kind.
type AggregationsKind struct {
	// Kind - The kind of the setting
	Kind *string `json:"kind,omitempty"`
}

// AggregationsModel ...
type AggregationsModel struct {
	autorest.Response `json:"-"`
	Value             BasicAggregations `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AggregationsModel struct.
func (am *AggregationsModel) UnmarshalJSON(body []byte) error {
	a, err := unmarshalBasicAggregations(body)
	if err != nil {
		return err
	}
	am.Value = a

	return nil
}

// BasicAlertRule alert rule.
type BasicAlertRule interface {
	AsFusionAlertRule() (*FusionAlertRule, bool)
	AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool)
	AsScheduledAlertRule() (*ScheduledAlertRule, bool)
	AsAlertRule() (*AlertRule, bool)
}

// AlertRule alert rule.
type AlertRule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindAlertRule', 'KindFusion', 'KindMicrosoftSecurityIncidentCreation', 'KindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

func unmarshalBasicAlertRule(body []byte) (BasicAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindFusion):
		var far FusionAlertRule
		err := json.Unmarshal(body, &far)
		return far, err
	case string(KindMicrosoftSecurityIncidentCreation):
		var msicar MicrosoftSecurityIncidentCreationAlertRule
		err := json.Unmarshal(body, &msicar)
		return msicar, err
	case string(KindScheduled):
		var sar ScheduledAlertRule
		err := json.Unmarshal(body, &sar)
		return sar, err
	default:
		var ar AlertRule
		err := json.Unmarshal(body, &ar)
		return ar, err
	}
}
func unmarshalBasicAlertRuleArray(body []byte) ([]BasicAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arArray := make([]BasicAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ar, err := unmarshalBasicAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		arArray[index] = ar
	}
	return arArray, nil
}

// MarshalJSON is the custom marshaler for AlertRule.
func (ar AlertRule) MarshalJSON() ([]byte, error) {
	ar.Kind = KindAlertRule
	objectMap := make(map[string]interface{})
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	if ar.Kind != "" {
		objectMap["kind"] = ar.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsAlertRule() (*AlertRule, bool) {
	return &ar, true
}

// AsBasicAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &ar, true
}

// AlertRuleKind1 describes an Azure resource with kind.
type AlertRuleKind1 struct {
	// Kind - The kind of the alert rule. Possible values include: 'Scheduled', 'MicrosoftSecurityIncidentCreation', 'Fusion'
	Kind AlertRuleKind `json:"kind,omitempty"`
}

// AlertRuleModel ...
type AlertRuleModel struct {
	autorest.Response `json:"-"`
	Value             BasicAlertRule `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleModel struct.
func (arm *AlertRuleModel) UnmarshalJSON(body []byte) error {
	ar, err := unmarshalBasicAlertRule(body)
	if err != nil {
		return err
	}
	arm.Value = ar

	return nil
}

// AlertRulesList list all the alert rules.
type AlertRulesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of alert rules.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of alert rules.
	Value *[]BasicAlertRule `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRulesList struct.
func (arl *AlertRulesList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				arl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicAlertRuleArray(*v)
				if err != nil {
					return err
				}
				arl.Value = &value
			}
		}
	}

	return nil
}

// AlertRulesListIterator provides access to a complete listing of AlertRule values.
type AlertRulesListIterator struct {
	i    int
	page AlertRulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRulesListIterator) Response() AlertRulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRulesListIterator) Value() BasicAlertRule {
	if !iter.page.NotDone() {
		return AlertRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRulesListIterator type.
func NewAlertRulesListIterator(page AlertRulesListPage) AlertRulesListIterator {
	return AlertRulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AlertRulesList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// alertRulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AlertRulesList) alertRulesListPreparer(ctx context.Context) (*http.Request, error) {
	if arl.NextLink == nil || len(to.String(arl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AlertRulesListPage contains a page of BasicAlertRule values.
type AlertRulesListPage struct {
	fn  func(context.Context, AlertRulesList) (AlertRulesList, error)
	arl AlertRulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.arl)
	if err != nil {
		return err
	}
	page.arl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRulesListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRulesListPage) Response() AlertRulesList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRulesListPage) Values() []BasicAlertRule {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AlertRulesListPage type.
func NewAlertRulesListPage(getNextPage func(context.Context, AlertRulesList) (AlertRulesList, error)) AlertRulesListPage {
	return AlertRulesListPage{fn: getNextPage}
}

// BasicAlertRuleTemplate alert rule template.
type BasicAlertRuleTemplate interface {
	AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool)
	AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool)
	AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool)
	AsAlertRuleTemplate() (*AlertRuleTemplate, bool)
}

// AlertRuleTemplate alert rule template.
type AlertRuleTemplate struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

func unmarshalBasicAlertRuleTemplate(body []byte) (BasicAlertRuleTemplate, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicAlertRuleTemplateKindFusion):
		var fart FusionAlertRuleTemplate
		err := json.Unmarshal(body, &fart)
		return fart, err
	case string(KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation):
		var msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate
		err := json.Unmarshal(body, &msicart)
		return msicart, err
	case string(KindBasicAlertRuleTemplateKindScheduled):
		var sart ScheduledAlertRuleTemplate
		err := json.Unmarshal(body, &sart)
		return sart, err
	default:
		var art AlertRuleTemplate
		err := json.Unmarshal(body, &art)
		return art, err
	}
}
func unmarshalBasicAlertRuleTemplateArray(body []byte) ([]BasicAlertRuleTemplate, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	artArray := make([]BasicAlertRuleTemplate, len(rawMessages))

	for index, rawMessage := range rawMessages {
		art, err := unmarshalBasicAlertRuleTemplate(*rawMessage)
		if err != nil {
			return nil, err
		}
		artArray[index] = art
	}
	return artArray, nil
}

// MarshalJSON is the custom marshaler for AlertRuleTemplate.
func (art AlertRuleTemplate) MarshalJSON() ([]byte, error) {
	art.Kind = KindBasicAlertRuleTemplateKindAlertRuleTemplate
	objectMap := make(map[string]interface{})
	if art.Kind != "" {
		objectMap["kind"] = art.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return &art, true
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &art, true
}

// AlertRuleTemplateDataSource alert rule template data sources
type AlertRuleTemplateDataSource struct {
	// ConnectorID - The connector id that provides the following data types
	ConnectorID *string `json:"connectorId,omitempty"`
	// DataTypes - The data types used by the alert rule template
	DataTypes *[]string `json:"dataTypes,omitempty"`
}

// AlertRuleTemplateModel ...
type AlertRuleTemplateModel struct {
	autorest.Response `json:"-"`
	Value             BasicAlertRuleTemplate `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleTemplateModel struct.
func (artm *AlertRuleTemplateModel) UnmarshalJSON(body []byte) error {
	art, err := unmarshalBasicAlertRuleTemplate(body)
	if err != nil {
		return err
	}
	artm.Value = art

	return nil
}

// AlertRuleTemplatePropertiesBase base alert rule template property bag.
type AlertRuleTemplatePropertiesBase struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'Installed', 'Available', 'NotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
}

// AlertRuleTemplatesList list all the alert rule templates.
type AlertRuleTemplatesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of alert rule templates.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of alert rule templates.
	Value *[]BasicAlertRuleTemplate `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleTemplatesList struct.
func (artl *AlertRuleTemplatesList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				artl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicAlertRuleTemplateArray(*v)
				if err != nil {
					return err
				}
				artl.Value = &value
			}
		}
	}

	return nil
}

// AlertRuleTemplatesListIterator provides access to a complete listing of AlertRuleTemplate values.
type AlertRuleTemplatesListIterator struct {
	i    int
	page AlertRuleTemplatesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRuleTemplatesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleTemplatesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRuleTemplatesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRuleTemplatesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRuleTemplatesListIterator) Response() AlertRuleTemplatesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRuleTemplatesListIterator) Value() BasicAlertRuleTemplate {
	if !iter.page.NotDone() {
		return AlertRuleTemplate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRuleTemplatesListIterator type.
func NewAlertRuleTemplatesListIterator(page AlertRuleTemplatesListPage) AlertRuleTemplatesListIterator {
	return AlertRuleTemplatesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (artl AlertRuleTemplatesList) IsEmpty() bool {
	return artl.Value == nil || len(*artl.Value) == 0
}

// alertRuleTemplatesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (artl AlertRuleTemplatesList) alertRuleTemplatesListPreparer(ctx context.Context) (*http.Request, error) {
	if artl.NextLink == nil || len(to.String(artl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(artl.NextLink)))
}

// AlertRuleTemplatesListPage contains a page of BasicAlertRuleTemplate values.
type AlertRuleTemplatesListPage struct {
	fn   func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)
	artl AlertRuleTemplatesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRuleTemplatesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleTemplatesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.artl)
	if err != nil {
		return err
	}
	page.artl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRuleTemplatesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRuleTemplatesListPage) NotDone() bool {
	return !page.artl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRuleTemplatesListPage) Response() AlertRuleTemplatesList {
	return page.artl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRuleTemplatesListPage) Values() []BasicAlertRuleTemplate {
	if page.artl.IsEmpty() {
		return nil
	}
	return *page.artl.Value
}

// Creates a new instance of the AlertRuleTemplatesListPage type.
func NewAlertRuleTemplatesListPage(getNextPage func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)) AlertRuleTemplatesListPage {
	return AlertRuleTemplatesListPage{fn: getNextPage}
}

// AlertsDataTypeOfDataConnector alerts data type for data connectors.
type AlertsDataTypeOfDataConnector struct {
	// Alerts - Alerts data type connection.
	Alerts *AlertsDataTypeOfDataConnectorAlerts `json:"alerts,omitempty"`
}

// AlertsDataTypeOfDataConnectorAlerts alerts data type connection.
type AlertsDataTypeOfDataConnectorAlerts struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// ASCCheckRequirements represents ASC (Azure Security Center) requirements check request.
type ASCCheckRequirements struct {
	// ASCCheckRequirementsProperties - ASC (Azure Security Center) requirements check properties.
	*ASCCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ASCCheckRequirements.
func (acr ASCCheckRequirements) MarshalJSON() ([]byte, error) {
	acr.Kind = KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter
	objectMap := make(map[string]interface{})
	if acr.ASCCheckRequirementsProperties != nil {
		objectMap["properties"] = acr.ASCCheckRequirementsProperties
	}
	if acr.Kind != "" {
		objectMap["kind"] = acr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return &acr, true
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &acr, true
}

// UnmarshalJSON is the custom unmarshaler for ASCCheckRequirements struct.
func (acr *ASCCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aSCCheckRequirementsProperties ASCCheckRequirementsProperties
				err = json.Unmarshal(*v, &aSCCheckRequirementsProperties)
				if err != nil {
					return err
				}
				acr.ASCCheckRequirementsProperties = &aSCCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acr.Kind = kind
			}
		}
	}

	return nil
}

// ASCCheckRequirementsProperties ASC (Azure Security Center) requirements check properties.
type ASCCheckRequirementsProperties struct {
	// SubscriptionID - The subscription id to connect to, and get the data from.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// ASCDataConnector represents ASC (Azure Security Center) data connector.
type ASCDataConnector struct {
	// ASCDataConnectorProperties - ASC (Azure Security Center) data connector properties.
	*ASCDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ASCDataConnector.
func (adc ASCDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindAzureSecurityCenter
	objectMap := make(map[string]interface{})
	if adc.ASCDataConnectorProperties != nil {
		objectMap["properties"] = adc.ASCDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return &adc, true
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for ASCDataConnector struct.
func (adc *ASCDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aSCDataConnectorProperties ASCDataConnectorProperties
				err = json.Unmarshal(*v, &aSCDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.ASCDataConnectorProperties = &aSCDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// ASCDataConnectorProperties ASC (Azure Security Center) data connector properties.
type ASCDataConnectorProperties struct {
	// SubscriptionID - The subscription id to connect to, and get the data from.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AwsCloudTrailCheckRequirements amazon Web Services CloudTrail requirements check request.
type AwsCloudTrailCheckRequirements struct {
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) MarshalJSON() ([]byte, error) {
	actcr.Kind = KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail
	objectMap := make(map[string]interface{})
	if actcr.Kind != "" {
		objectMap["kind"] = actcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return &actcr, true
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &actcr, true
}

// AwsCloudTrailDataConnector represents Amazon Web Services CloudTrail data connector.
type AwsCloudTrailDataConnector struct {
	// AwsCloudTrailDataConnectorProperties - Amazon Web Services CloudTrail data connector properties.
	*AwsCloudTrailDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) MarshalJSON() ([]byte, error) {
	actdc.Kind = KindAmazonWebServicesCloudTrail
	objectMap := make(map[string]interface{})
	if actdc.AwsCloudTrailDataConnectorProperties != nil {
		objectMap["properties"] = actdc.AwsCloudTrailDataConnectorProperties
	}
	if actdc.Etag != nil {
		objectMap["etag"] = actdc.Etag
	}
	if actdc.Kind != "" {
		objectMap["kind"] = actdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return &actdc, true
}

// AsMCASDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &actdc, true
}

// UnmarshalJSON is the custom unmarshaler for AwsCloudTrailDataConnector struct.
func (actdc *AwsCloudTrailDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var awsCloudTrailDataConnectorProperties AwsCloudTrailDataConnectorProperties
				err = json.Unmarshal(*v, &awsCloudTrailDataConnectorProperties)
				if err != nil {
					return err
				}
				actdc.AwsCloudTrailDataConnectorProperties = &awsCloudTrailDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				actdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				actdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				actdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				actdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				actdc.Kind = kind
			}
		}
	}

	return nil
}

// AwsCloudTrailDataConnectorDataTypes the available data types for Amazon Web Services CloudTrail data
// connector.
type AwsCloudTrailDataConnectorDataTypes struct {
	// Logs - Logs data type.
	Logs *AwsCloudTrailDataConnectorDataTypesLogs `json:"logs,omitempty"`
}

// AwsCloudTrailDataConnectorDataTypesLogs logs data type.
type AwsCloudTrailDataConnectorDataTypesLogs struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// AwsCloudTrailDataConnectorProperties amazon Web Services CloudTrail data connector properties.
type AwsCloudTrailDataConnectorProperties struct {
	// AwsRoleArn - The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
	AwsRoleArn *string `json:"awsRoleArn,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AwsCloudTrailDataConnectorDataTypes `json:"dataTypes,omitempty"`
}

// AzureResourceEntity represents an azure resource entity.
type AzureResourceEntity struct {
	// AzureResourceEntityProperties - AzureResource entity properties
	*AzureResourceEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceEntity.
func (are AzureResourceEntity) MarshalJSON() ([]byte, error) {
	are.Kind = KindAzureResource
	objectMap := make(map[string]interface{})
	if are.AzureResourceEntityProperties != nil {
		objectMap["properties"] = are.AzureResourceEntityProperties
	}
	if are.Kind != "" {
		objectMap["kind"] = are.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return &are, true
}

// AsCloudApplicationEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsBasicEntity() (BasicEntity, bool) {
	return &are, true
}

// UnmarshalJSON is the custom unmarshaler for AzureResourceEntity struct.
func (are *AzureResourceEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureResourceEntityProperties AzureResourceEntityProperties
				err = json.Unmarshal(*v, &azureResourceEntityProperties)
				if err != nil {
					return err
				}
				are.AzureResourceEntityProperties = &azureResourceEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				are.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				are.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				are.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				are.Kind = kind
			}
		}
	}

	return nil
}

// AzureResourceEntityProperties azureResource entity property bag.
type AzureResourceEntityProperties struct {
	// ResourceID - READ-ONLY; The azure resource id of the resource
	ResourceID *string `json:"resourceId,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceEntityProperties.
func (arep AzureResourceEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Bookmark represents a bookmark in Azure Security Insights.
type Bookmark struct {
	autorest.Response `json:"-"`
	// BookmarkProperties - Bookmark properties
	*BookmarkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Bookmark.
func (b Bookmark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BookmarkProperties != nil {
		objectMap["properties"] = b.BookmarkProperties
	}
	if b.Etag != nil {
		objectMap["etag"] = b.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Bookmark struct.
func (b *Bookmark) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bookmarkProperties BookmarkProperties
				err = json.Unmarshal(*v, &bookmarkProperties)
				if err != nil {
					return err
				}
				b.BookmarkProperties = &bookmarkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				b.Etag = &etag
			}
		}
	}

	return nil
}

// BookmarkExpandParameters the parameters required to execute an expand operation on the given bookmark.
type BookmarkExpandParameters struct {
	// EndTime - The end date filter, so the only expansion results returned are before this date.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExpansionID - The Id of the expansion to perform.
	ExpansionID *uuid.UUID `json:"expansionId,omitempty"`
	// StartTime - The start date filter, so the only expansion results returned are after this date.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// BookmarkExpandResponse the entity expansion result operation response.
type BookmarkExpandResponse struct {
	autorest.Response `json:"-"`
	// MetaData - The metadata from the expansion operation results.
	MetaData *ExpansionResultsMetadata `json:"metaData,omitempty"`
	// Value - The expansion result values.
	Value *BookmarkExpandResponseValue `json:"value,omitempty"`
}

// BookmarkExpandResponseValue the expansion result values.
type BookmarkExpandResponseValue struct {
	// Entities - Array of the expansion result entities.
	Entities *[]BasicEntity `json:"entities,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BookmarkExpandResponseValue struct.
func (ber *BookmarkExpandResponseValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "entities":
			if v != nil {
				entities, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				ber.Entities = &entities
			}
		}
	}

	return nil
}

// BookmarkList list all the bookmarks.
type BookmarkList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of cases.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of bookmarks.
	Value *[]Bookmark `json:"value,omitempty"`
}

// BookmarkListIterator provides access to a complete listing of Bookmark values.
type BookmarkListIterator struct {
	i    int
	page BookmarkListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BookmarkListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BookmarkListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BookmarkListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BookmarkListIterator) Response() BookmarkList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BookmarkListIterator) Value() Bookmark {
	if !iter.page.NotDone() {
		return Bookmark{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BookmarkListIterator type.
func NewBookmarkListIterator(page BookmarkListPage) BookmarkListIterator {
	return BookmarkListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bl BookmarkList) IsEmpty() bool {
	return bl.Value == nil || len(*bl.Value) == 0
}

// bookmarkListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bl BookmarkList) bookmarkListPreparer(ctx context.Context) (*http.Request, error) {
	if bl.NextLink == nil || len(to.String(bl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bl.NextLink)))
}

// BookmarkListPage contains a page of Bookmark values.
type BookmarkListPage struct {
	fn func(context.Context, BookmarkList) (BookmarkList, error)
	bl BookmarkList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BookmarkListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bl)
	if err != nil {
		return err
	}
	page.bl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BookmarkListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BookmarkListPage) NotDone() bool {
	return !page.bl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BookmarkListPage) Response() BookmarkList {
	return page.bl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BookmarkListPage) Values() []Bookmark {
	if page.bl.IsEmpty() {
		return nil
	}
	return *page.bl.Value
}

// Creates a new instance of the BookmarkListPage type.
func NewBookmarkListPage(getNextPage func(context.Context, BookmarkList) (BookmarkList, error)) BookmarkListPage {
	return BookmarkListPage{fn: getNextPage}
}

// BookmarkProperties describes bookmark properties
type BookmarkProperties struct {
	// Created - The time the bookmark was created
	Created *date.Time `json:"created,omitempty"`
	// CreatedBy - Describes a user that created the bookmark
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// DisplayName - The display name of the bookmark
	DisplayName *string `json:"displayName,omitempty"`
	// Labels - List of labels relevant to this bookmark
	Labels *[]string `json:"labels,omitempty"`
	// Notes - The notes of the bookmark
	Notes *string `json:"notes,omitempty"`
	// Query - The query of the bookmark.
	Query *string `json:"query,omitempty"`
	// QueryResult - The query result of the bookmark.
	QueryResult *string `json:"queryResult,omitempty"`
	// Updated - The last time the bookmark was updated
	Updated *date.Time `json:"updated,omitempty"`
	// UpdatedBy - Describes a user that updated the bookmark
	UpdatedBy *UserInfo `json:"updatedBy,omitempty"`
	// IncidentInfo - Describes an incident that relates to bookmark
	IncidentInfo *IncidentInfo `json:"incidentInfo,omitempty"`
}

// Case represents a case in Azure Security Insights.
type Case struct {
	autorest.Response `json:"-"`
	// CaseProperties - Case properties
	*CaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Case.
func (c Case) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CaseProperties != nil {
		objectMap["properties"] = c.CaseProperties
	}
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Case struct.
func (c *Case) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var caseProperties CaseProperties
				err = json.Unmarshal(*v, &caseProperties)
				if err != nil {
					return err
				}
				c.CaseProperties = &caseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		}
	}

	return nil
}

// CaseComment represents a case comment
type CaseComment struct {
	autorest.Response `json:"-"`
	// CaseCommentProperties - Case comment properties
	*CaseCommentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseComment.
func (cc CaseComment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.CaseCommentProperties != nil {
		objectMap["properties"] = cc.CaseCommentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CaseComment struct.
func (cc *CaseComment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var caseCommentProperties CaseCommentProperties
				err = json.Unmarshal(*v, &caseCommentProperties)
				if err != nil {
					return err
				}
				cc.CaseCommentProperties = &caseCommentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cc.Type = &typeVar
			}
		}
	}

	return nil
}

// CaseCommentList list of case comments.
type CaseCommentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of comments.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of comments.
	Value *[]CaseComment `json:"value,omitempty"`
}

// CaseCommentListIterator provides access to a complete listing of CaseComment values.
type CaseCommentListIterator struct {
	i    int
	page CaseCommentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CaseCommentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseCommentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CaseCommentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CaseCommentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CaseCommentListIterator) Response() CaseCommentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CaseCommentListIterator) Value() CaseComment {
	if !iter.page.NotDone() {
		return CaseComment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CaseCommentListIterator type.
func NewCaseCommentListIterator(page CaseCommentListPage) CaseCommentListIterator {
	return CaseCommentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ccl CaseCommentList) IsEmpty() bool {
	return ccl.Value == nil || len(*ccl.Value) == 0
}

// caseCommentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ccl CaseCommentList) caseCommentListPreparer(ctx context.Context) (*http.Request, error) {
	if ccl.NextLink == nil || len(to.String(ccl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ccl.NextLink)))
}

// CaseCommentListPage contains a page of CaseComment values.
type CaseCommentListPage struct {
	fn  func(context.Context, CaseCommentList) (CaseCommentList, error)
	ccl CaseCommentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CaseCommentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseCommentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ccl)
	if err != nil {
		return err
	}
	page.ccl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CaseCommentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CaseCommentListPage) NotDone() bool {
	return !page.ccl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CaseCommentListPage) Response() CaseCommentList {
	return page.ccl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CaseCommentListPage) Values() []CaseComment {
	if page.ccl.IsEmpty() {
		return nil
	}
	return *page.ccl.Value
}

// Creates a new instance of the CaseCommentListPage type.
func NewCaseCommentListPage(getNextPage func(context.Context, CaseCommentList) (CaseCommentList, error)) CaseCommentListPage {
	return CaseCommentListPage{fn: getNextPage}
}

// CaseCommentProperties case comment property bag.
type CaseCommentProperties struct {
	// CreatedTimeUtc - READ-ONLY; The time the comment was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Message - The comment message
	Message *string `json:"message,omitempty"`
	// UserInfo - READ-ONLY; Describes the user that created the comment
	UserInfo *UserInfo `json:"userInfo,omitempty"`
}

// CaseList list all the cases.
type CaseList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of cases.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of cases.
	Value *[]Case `json:"value,omitempty"`
}

// CaseListIterator provides access to a complete listing of Case values.
type CaseListIterator struct {
	i    int
	page CaseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CaseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CaseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CaseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CaseListIterator) Response() CaseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CaseListIterator) Value() Case {
	if !iter.page.NotDone() {
		return Case{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CaseListIterator type.
func NewCaseListIterator(page CaseListPage) CaseListIterator {
	return CaseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl CaseList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// caseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl CaseList) caseListPreparer(ctx context.Context) (*http.Request, error) {
	if cl.NextLink == nil || len(to.String(cl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// CaseListPage contains a page of Case values.
type CaseListPage struct {
	fn func(context.Context, CaseList) (CaseList, error)
	cl CaseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CaseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cl)
	if err != nil {
		return err
	}
	page.cl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CaseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CaseListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CaseListPage) Response() CaseList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CaseListPage) Values() []Case {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the CaseListPage type.
func NewCaseListPage(getNextPage func(context.Context, CaseList) (CaseList, error)) CaseListPage {
	return CaseListPage{fn: getNextPage}
}

// CaseProperties describes case properties
type CaseProperties struct {
	// CaseNumber - READ-ONLY; a sequential number
	CaseNumber *int32 `json:"caseNumber,omitempty"`
	// CloseReason - The reason the case was closed. Possible values include: 'Resolved', 'Dismissed', 'TruePositive', 'FalsePositive', 'Other'
	CloseReason CloseReason `json:"closeReason,omitempty"`
	// ClosedReasonText - the case close reason details
	ClosedReasonText *string `json:"closedReasonText,omitempty"`
	// CreatedTimeUtc - READ-ONLY; The time the case was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Description - The description of the case
	Description *string `json:"description,omitempty"`
	// EndTimeUtc - The end time of the case
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Labels - List of labels relevant to this case
	Labels *[]string `json:"labels,omitempty"`
	// LastComment - READ-ONLY; the last comment in the case
	LastComment *string `json:"lastComment,omitempty"`
	// LastUpdatedTimeUtc - READ-ONLY; The last time the case was updated
	LastUpdatedTimeUtc *date.Time `json:"lastUpdatedTimeUtc,omitempty"`
	// Owner - Describes a user that the case is assigned to
	Owner *UserInfo `json:"owner,omitempty"`
	// RelatedAlertIds - READ-ONLY; List of related alert identifiers
	RelatedAlertIds *[]string `json:"relatedAlertIds,omitempty"`
	// Tactics - READ-ONLY; The tactics associated with case
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// Severity - The severity of the case. Possible values include: 'CaseSeverityCritical', 'CaseSeverityHigh', 'CaseSeverityMedium', 'CaseSeverityLow', 'CaseSeverityInformational'
	Severity CaseSeverity `json:"severity,omitempty"`
	// StartTimeUtc - The start time of the case
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Status - The status of the case. Possible values include: 'CaseStatusDraft', 'CaseStatusNew', 'CaseStatusInProgress', 'CaseStatusClosed'
	Status CaseStatus `json:"status,omitempty"`
	// Title - The title of the case
	Title *string `json:"title,omitempty"`
	// TotalComments - READ-ONLY; the number of total comments in the case
	TotalComments *int32 `json:"totalComments,omitempty"`
}

// CaseRelation represents a case relation
type CaseRelation struct {
	autorest.Response `json:"-"`
	// CaseRelationProperties - Case relation properties
	*CaseRelationProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; The type of relation node. Possible values include: 'CasesToBookmarks'
	Kind RelationTypes `json:"kind,omitempty"`
	// Etag - ETag for relation
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseRelation.
func (cr CaseRelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.CaseRelationProperties != nil {
		objectMap["properties"] = cr.CaseRelationProperties
	}
	if cr.Etag != nil {
		objectMap["etag"] = cr.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CaseRelation struct.
func (cr *CaseRelation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var caseRelationProperties CaseRelationProperties
				err = json.Unmarshal(*v, &caseRelationProperties)
				if err != nil {
					return err
				}
				cr.CaseRelationProperties = &caseRelationProperties
			}
		case "kind":
			if v != nil {
				var kind RelationTypes
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cr.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		}
	}

	return nil
}

// CaseRelationList list of case relations.
type CaseRelationList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of relations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of relations.
	Value *[]CaseRelation `json:"value,omitempty"`
}

// CaseRelationListIterator provides access to a complete listing of CaseRelation values.
type CaseRelationListIterator struct {
	i    int
	page CaseRelationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CaseRelationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseRelationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CaseRelationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CaseRelationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CaseRelationListIterator) Response() CaseRelationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CaseRelationListIterator) Value() CaseRelation {
	if !iter.page.NotDone() {
		return CaseRelation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CaseRelationListIterator type.
func NewCaseRelationListIterator(page CaseRelationListPage) CaseRelationListIterator {
	return CaseRelationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crl CaseRelationList) IsEmpty() bool {
	return crl.Value == nil || len(*crl.Value) == 0
}

// caseRelationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crl CaseRelationList) caseRelationListPreparer(ctx context.Context) (*http.Request, error) {
	if crl.NextLink == nil || len(to.String(crl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crl.NextLink)))
}

// CaseRelationListPage contains a page of CaseRelation values.
type CaseRelationListPage struct {
	fn  func(context.Context, CaseRelationList) (CaseRelationList, error)
	crl CaseRelationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CaseRelationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseRelationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.crl)
	if err != nil {
		return err
	}
	page.crl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CaseRelationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CaseRelationListPage) NotDone() bool {
	return !page.crl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CaseRelationListPage) Response() CaseRelationList {
	return page.crl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CaseRelationListPage) Values() []CaseRelation {
	if page.crl.IsEmpty() {
		return nil
	}
	return *page.crl.Value
}

// Creates a new instance of the CaseRelationListPage type.
func NewCaseRelationListPage(getNextPage func(context.Context, CaseRelationList) (CaseRelationList, error)) CaseRelationListPage {
	return CaseRelationListPage{fn: getNextPage}
}

// CaseRelationProperties case relation properties
type CaseRelationProperties struct {
	// RelationName - Name of relation
	RelationName *string `json:"relationName,omitempty"`
	// BookmarkID - The case related bookmark id
	BookmarkID *string `json:"bookmarkId,omitempty"`
	// CaseIdentifier - The case identifier
	CaseIdentifier *string `json:"caseIdentifier,omitempty"`
	// BookmarkName - The case related bookmark name
	BookmarkName *string `json:"bookmarkName,omitempty"`
}

// CasesAggregation represents aggregations results for cases.
type CasesAggregation struct {
	// CasesAggregationProperties - Properties of aggregations results of cases.
	*CasesAggregationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindAggregations', 'KindCasesAggregation'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CasesAggregation.
func (ca CasesAggregation) MarshalJSON() ([]byte, error) {
	ca.Kind = KindCasesAggregation
	objectMap := make(map[string]interface{})
	if ca.CasesAggregationProperties != nil {
		objectMap["properties"] = ca.CasesAggregationProperties
	}
	if ca.Kind != "" {
		objectMap["kind"] = ca.Kind
	}
	return json.Marshal(objectMap)
}

// AsCasesAggregation is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsCasesAggregation() (*CasesAggregation, bool) {
	return &ca, true
}

// AsAggregations is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsAggregations() (*Aggregations, bool) {
	return nil, false
}

// AsBasicAggregations is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsBasicAggregations() (BasicAggregations, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for CasesAggregation struct.
func (ca *CasesAggregation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var casesAggregationProperties CasesAggregationProperties
				err = json.Unmarshal(*v, &casesAggregationProperties)
				if err != nil {
					return err
				}
				ca.CasesAggregationProperties = &casesAggregationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ca.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ca.Kind = kind
			}
		}
	}

	return nil
}

// CasesAggregationBySeverityProperties aggregative results of cases by severity property bag.
type CasesAggregationBySeverityProperties struct {
	// TotalCriticalSeverity - READ-ONLY; Total amount of open cases with severity Critical
	TotalCriticalSeverity *int32 `json:"totalCriticalSeverity,omitempty"`
	// TotalHighSeverity - READ-ONLY; Total amount of open cases with severity High
	TotalHighSeverity *int32 `json:"totalHighSeverity,omitempty"`
	// TotalInformationalSeverity - READ-ONLY; Total amount of open cases with severity Informational
	TotalInformationalSeverity *int32 `json:"totalInformationalSeverity,omitempty"`
	// TotalLowSeverity - READ-ONLY; Total amount of open cases with severity Low
	TotalLowSeverity *int32 `json:"totalLowSeverity,omitempty"`
	// TotalMediumSeverity - READ-ONLY; Total amount of open cases with severity medium
	TotalMediumSeverity *int32 `json:"totalMediumSeverity,omitempty"`
}

// CasesAggregationByStatusProperties aggregative results of cases by status property bag.
type CasesAggregationByStatusProperties struct {
	// TotalDismissedStatus - READ-ONLY; Total amount of open cases with status Dismissed
	TotalDismissedStatus *int32 `json:"totalDismissedStatus,omitempty"`
	// TotalInProgressStatus - READ-ONLY; Total amount of open cases with status InProgress
	TotalInProgressStatus *int32 `json:"totalInProgressStatus,omitempty"`
	// TotalNewStatus - READ-ONLY; Total amount of open cases with status New
	TotalNewStatus *int32 `json:"totalNewStatus,omitempty"`
	// TotalResolvedStatus - READ-ONLY; Total amount of open cases with status Resolved
	TotalResolvedStatus *int32 `json:"totalResolvedStatus,omitempty"`
}

// CasesAggregationProperties aggregative results of cases property bag.
type CasesAggregationProperties struct {
	// AggregationBySeverity - Aggregations results by case severity.
	AggregationBySeverity *CasesAggregationBySeverityProperties `json:"aggregationBySeverity,omitempty"`
	// AggregationByStatus - Aggregations results by case status.
	AggregationByStatus *CasesAggregationByStatusProperties `json:"aggregationByStatus,omitempty"`
}

// ClientInfo information on the client (user or application) that made some action
type ClientInfo struct {
	// Email - The email of the client.
	Email *string `json:"email,omitempty"`
	// Name - The name of the client.
	Name *string `json:"name,omitempty"`
	// ObjectID - The object id of the client.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// UserPrincipalName - The user principal name of the client.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// CloudApplicationEntity represents a cloud application entity.
type CloudApplicationEntity struct {
	// CloudApplicationEntityProperties - CloudApplication entity properties
	*CloudApplicationEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudApplicationEntity.
func (cae CloudApplicationEntity) MarshalJSON() ([]byte, error) {
	cae.Kind = KindCloudApplication
	objectMap := make(map[string]interface{})
	if cae.CloudApplicationEntityProperties != nil {
		objectMap["properties"] = cae.CloudApplicationEntityProperties
	}
	if cae.Kind != "" {
		objectMap["kind"] = cae.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return &cae, true
}

// AsDNSEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsBasicEntity() (BasicEntity, bool) {
	return &cae, true
}

// UnmarshalJSON is the custom unmarshaler for CloudApplicationEntity struct.
func (cae *CloudApplicationEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloudApplicationEntityProperties CloudApplicationEntityProperties
				err = json.Unmarshal(*v, &cloudApplicationEntityProperties)
				if err != nil {
					return err
				}
				cae.CloudApplicationEntityProperties = &cloudApplicationEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cae.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cae.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cae.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cae.Kind = kind
			}
		}
	}

	return nil
}

// CloudApplicationEntityProperties cloudApplication entity property bag.
type CloudApplicationEntityProperties struct {
	// AppID - READ-ONLY; The technical identifier of the application.
	AppID *int32 `json:"appId,omitempty"`
	// AppName - READ-ONLY; The name of the related cloud application.
	AppName *string `json:"appName,omitempty"`
	// InstanceName - READ-ONLY; The user defined instance name of the cloud application. It is often used to distinguish between several applications of the same type that a customer has.
	InstanceName *string `json:"instanceName,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudApplicationEntityProperties.
func (caep CloudApplicationEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError error response structure.
type CloudError struct {
	// CloudErrorBody - Error data
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody error details.
type CloudErrorBody struct {
	// Code - READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// BasicDataConnector data connector.
type BasicDataConnector interface {
	AsAADDataConnector() (*AADDataConnector, bool)
	AsAATPDataConnector() (*AATPDataConnector, bool)
	AsASCDataConnector() (*ASCDataConnector, bool)
	AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool)
	AsMCASDataConnector() (*MCASDataConnector, bool)
	AsMDATPDataConnector() (*MDATPDataConnector, bool)
	AsOfficeDataConnector() (*OfficeDataConnector, bool)
	AsTIDataConnector() (*TIDataConnector, bool)
	AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool)
	AsDataConnector() (*DataConnector, bool)
}

// DataConnector data connector.
type DataConnector struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

func unmarshalBasicDataConnector(body []byte) (BasicDataConnector, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAzureActiveDirectory):
		var adc AADDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindAzureAdvancedThreatProtection):
		var adc AATPDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindAzureSecurityCenter):
		var adc ASCDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindAmazonWebServicesCloudTrail):
		var actdc AwsCloudTrailDataConnector
		err := json.Unmarshal(body, &actdc)
		return actdc, err
	case string(KindMicrosoftCloudAppSecurity):
		var mdc MCASDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindMicrosoftDefenderAdvancedThreatProtection):
		var mdc MDATPDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindOffice365):
		var odc OfficeDataConnector
		err := json.Unmarshal(body, &odc)
		return odc, err
	case string(KindThreatIntelligence):
		var tdc TIDataConnector
		err := json.Unmarshal(body, &tdc)
		return tdc, err
	case string(KindThreatIntelligenceTaxii):
		var ttdc TiTaxiiDataConnector
		err := json.Unmarshal(body, &ttdc)
		return ttdc, err
	default:
		var dc DataConnector
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDataConnectorArray(body []byte) ([]BasicDataConnector, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDataConnector, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDataConnector(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DataConnector.
func (dc DataConnector) MarshalJSON() ([]byte, error) {
	dc.Kind = KindDataConnector
	objectMap := make(map[string]interface{})
	if dc.Etag != nil {
		objectMap["etag"] = dc.Etag
	}
	if dc.Kind != "" {
		objectMap["kind"] = dc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsDataConnector() (*DataConnector, bool) {
	return &dc, true
}

// AsBasicDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &dc, true
}

// DataConnectorDataTypeCommon common field for data type in data connectors.
type DataConnectorDataTypeCommon struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// DataConnectorKind1 describes an Azure resource with kind.
type DataConnectorKind1 struct {
	// Kind - The kind of the data connector. Possible values include: 'DataConnectorKindAzureActiveDirectory', 'DataConnectorKindAzureSecurityCenter', 'DataConnectorKindMicrosoftCloudAppSecurity', 'DataConnectorKindThreatIntelligence', 'DataConnectorKindThreatIntelligenceTaxii', 'DataConnectorKindOffice365', 'DataConnectorKindAmazonWebServicesCloudTrail', 'DataConnectorKindAzureAdvancedThreatProtection', 'DataConnectorKindMicrosoftDefenderAdvancedThreatProtection'
	Kind DataConnectorKind `json:"kind,omitempty"`
}

// DataConnectorList list all the data connectors.
type DataConnectorList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of data connectors.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of data connectors.
	Value *[]BasicDataConnector `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorList struct.
func (dcl *DataConnectorList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				dcl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicDataConnectorArray(*v)
				if err != nil {
					return err
				}
				dcl.Value = &value
			}
		}
	}

	return nil
}

// DataConnectorListIterator provides access to a complete listing of DataConnector values.
type DataConnectorListIterator struct {
	i    int
	page DataConnectorListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataConnectorListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataConnectorListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataConnectorListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataConnectorListIterator) Response() DataConnectorList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataConnectorListIterator) Value() BasicDataConnector {
	if !iter.page.NotDone() {
		return DataConnector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataConnectorListIterator type.
func NewDataConnectorListIterator(page DataConnectorListPage) DataConnectorListIterator {
	return DataConnectorListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcl DataConnectorList) IsEmpty() bool {
	return dcl.Value == nil || len(*dcl.Value) == 0
}

// dataConnectorListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcl DataConnectorList) dataConnectorListPreparer(ctx context.Context) (*http.Request, error) {
	if dcl.NextLink == nil || len(to.String(dcl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcl.NextLink)))
}

// DataConnectorListPage contains a page of BasicDataConnector values.
type DataConnectorListPage struct {
	fn  func(context.Context, DataConnectorList) (DataConnectorList, error)
	dcl DataConnectorList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataConnectorListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dcl)
	if err != nil {
		return err
	}
	page.dcl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataConnectorListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataConnectorListPage) NotDone() bool {
	return !page.dcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataConnectorListPage) Response() DataConnectorList {
	return page.dcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataConnectorListPage) Values() []BasicDataConnector {
	if page.dcl.IsEmpty() {
		return nil
	}
	return *page.dcl.Value
}

// Creates a new instance of the DataConnectorListPage type.
func NewDataConnectorListPage(getNextPage func(context.Context, DataConnectorList) (DataConnectorList, error)) DataConnectorListPage {
	return DataConnectorListPage{fn: getNextPage}
}

// DataConnectorModel ...
type DataConnectorModel struct {
	autorest.Response `json:"-"`
	Value             BasicDataConnector `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorModel struct.
func (dcm *DataConnectorModel) UnmarshalJSON(body []byte) error {
	dc, err := unmarshalBasicDataConnector(body)
	if err != nil {
		return err
	}
	dcm.Value = dc

	return nil
}

// DataConnectorRequirementsState data connector requirements status.
type DataConnectorRequirementsState struct {
	autorest.Response `json:"-"`
	// AuthorizationState - Authorization state for this connector. Possible values include: 'Valid', 'Invalid'
	AuthorizationState DataConnectorAuthorizationState `json:"authorizationState,omitempty"`
	// LicenseState - License state for this connector. Possible values include: 'DataConnectorLicenseStateValid', 'DataConnectorLicenseStateInvalid', 'DataConnectorLicenseStateUnknown'
	LicenseState DataConnectorLicenseState `json:"licenseState,omitempty"`
}

// BasicDataConnectorsCheckRequirements data connector requirements properties.
type BasicDataConnectorsCheckRequirements interface {
	AsAADCheckRequirements() (*AADCheckRequirements, bool)
	AsAATPCheckRequirements() (*AATPCheckRequirements, bool)
	AsASCCheckRequirements() (*ASCCheckRequirements, bool)
	AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool)
	AsMCASCheckRequirements() (*MCASCheckRequirements, bool)
	AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool)
	AsTICheckRequirements() (*TICheckRequirements, bool)
	AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool)
	AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool)
}

// DataConnectorsCheckRequirements data connector requirements properties.
type DataConnectorsCheckRequirements struct {
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

func unmarshalBasicDataConnectorsCheckRequirements(body []byte) (BasicDataConnectorsCheckRequirements, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory):
		var acr AADCheckRequirements
		err := json.Unmarshal(body, &acr)
		return acr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection):
		var acr AATPCheckRequirements
		err := json.Unmarshal(body, &acr)
		return acr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter):
		var acr ASCCheckRequirements
		err := json.Unmarshal(body, &acr)
		return acr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail):
		var actcr AwsCloudTrailCheckRequirements
		err := json.Unmarshal(body, &actcr)
		return actcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity):
		var mcr MCASCheckRequirements
		err := json.Unmarshal(body, &mcr)
		return mcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection):
		var mcr MDATPCheckRequirements
		err := json.Unmarshal(body, &mcr)
		return mcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence):
		var tcr TICheckRequirements
		err := json.Unmarshal(body, &tcr)
		return tcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii):
		var ttcr TiTaxiiCheckRequirements
		err := json.Unmarshal(body, &ttcr)
		return ttcr, err
	default:
		var dccr DataConnectorsCheckRequirements
		err := json.Unmarshal(body, &dccr)
		return dccr, err
	}
}
func unmarshalBasicDataConnectorsCheckRequirementsArray(body []byte) ([]BasicDataConnectorsCheckRequirements, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dccrArray := make([]BasicDataConnectorsCheckRequirements, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dccr, err := unmarshalBasicDataConnectorsCheckRequirements(*rawMessage)
		if err != nil {
			return nil, err
		}
		dccrArray[index] = dccr
	}
	return dccrArray, nil
}

// MarshalJSON is the custom marshaler for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) MarshalJSON() ([]byte, error) {
	dccr.Kind = KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements
	objectMap := make(map[string]interface{})
	if dccr.Kind != "" {
		objectMap["kind"] = dccr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return &dccr, true
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &dccr, true
}

// DataConnectorTenantID properties data connector on tenant level.
type DataConnectorTenantID struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// DataConnectorWithAlertsProperties data connector properties.
type DataConnectorWithAlertsProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// DNSEntity represents a dns entity.
type DNSEntity struct {
	// DNSEntityProperties - Dns entity properties
	*DNSEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for DNSEntity.
func (de DNSEntity) MarshalJSON() ([]byte, error) {
	de.Kind = KindDNSResolution
	objectMap := make(map[string]interface{})
	if de.DNSEntityProperties != nil {
		objectMap["properties"] = de.DNSEntityProperties
	}
	if de.Kind != "" {
		objectMap["kind"] = de.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsDNSEntity() (*DNSEntity, bool) {
	return &de, true
}

// AsFileEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsBasicEntity() (BasicEntity, bool) {
	return &de, true
}

// UnmarshalJSON is the custom unmarshaler for DNSEntity struct.
func (de *DNSEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var DNSEntityProperties DNSEntityProperties
				err = json.Unmarshal(*v, &DNSEntityProperties)
				if err != nil {
					return err
				}
				de.DNSEntityProperties = &DNSEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				de.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				de.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				de.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				de.Kind = kind
			}
		}
	}

	return nil
}

// DNSEntityProperties dns entity property bag.
type DNSEntityProperties struct {
	// DNSServerIPEntityID - READ-ONLY; An ip entity id for the dns server resolving the request
	DNSServerIPEntityID *string `json:"dnsServerIpEntityId,omitempty"`
	// DomainName - READ-ONLY; The name of the dns record associated with the alert
	DomainName *string `json:"domainName,omitempty"`
	// HostIPAddressEntityID - READ-ONLY; An ip entity id for the dns request client
	HostIPAddressEntityID *string `json:"hostIpAddressEntityId,omitempty"`
	// IPAddressEntityIds - READ-ONLY; Ip entity identifiers for the resolved ip address.
	IPAddressEntityIds *[]string `json:"ipAddressEntityIds,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for DNSEntityProperties.
func (dep DNSEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicEntity specific entity.
type BasicEntity interface {
	AsAccountEntity() (*AccountEntity, bool)
	AsAzureResourceEntity() (*AzureResourceEntity, bool)
	AsCloudApplicationEntity() (*CloudApplicationEntity, bool)
	AsDNSEntity() (*DNSEntity, bool)
	AsFileEntity() (*FileEntity, bool)
	AsFileHashEntity() (*FileHashEntity, bool)
	AsHostEntity() (*HostEntity, bool)
	AsIPEntity() (*IPEntity, bool)
	AsMalwareEntity() (*MalwareEntity, bool)
	AsProcessEntity() (*ProcessEntity, bool)
	AsRegistryKeyEntity() (*RegistryKeyEntity, bool)
	AsRegistryValueEntity() (*RegistryValueEntity, bool)
	AsSecurityAlert() (*SecurityAlert, bool)
	AsSecurityGroupEntity() (*SecurityGroupEntity, bool)
	AsURLEntity() (*URLEntity, bool)
	AsIoTDeviceEntity() (*IoTDeviceEntity, bool)
	AsEntity() (*Entity, bool)
}

// Entity specific entity.
type Entity struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

func unmarshalBasicEntity(body []byte) (BasicEntity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAccount):
		var ae AccountEntity
		err := json.Unmarshal(body, &ae)
		return ae, err
	case string(KindAzureResource):
		var are AzureResourceEntity
		err := json.Unmarshal(body, &are)
		return are, err
	case string(KindCloudApplication):
		var cae CloudApplicationEntity
		err := json.Unmarshal(body, &cae)
		return cae, err
	case string(KindDNSResolution):
		var de DNSEntity
		err := json.Unmarshal(body, &de)
		return de, err
	case string(KindFile):
		var fe FileEntity
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(KindFileHash):
		var fhe FileHashEntity
		err := json.Unmarshal(body, &fhe)
		return fhe, err
	case string(KindHost):
		var he HostEntity
		err := json.Unmarshal(body, &he)
		return he, err
	case string(KindIP):
		var ie IPEntity
		err := json.Unmarshal(body, &ie)
		return ie, err
	case string(KindMalware):
		var me MalwareEntity
		err := json.Unmarshal(body, &me)
		return me, err
	case string(KindProcess):
		var peVar ProcessEntity
		err := json.Unmarshal(body, &peVar)
		return peVar, err
	case string(KindRegistryKey):
		var rke RegistryKeyEntity
		err := json.Unmarshal(body, &rke)
		return rke, err
	case string(KindRegistryValue):
		var rve RegistryValueEntity
		err := json.Unmarshal(body, &rve)
		return rve, err
	case string(KindSecurityAlert):
		var sa SecurityAlert
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(KindSecurityGroup):
		var sge SecurityGroupEntity
		err := json.Unmarshal(body, &sge)
		return sge, err
	case string(KindURL):
		var ue URLEntity
		err := json.Unmarshal(body, &ue)
		return ue, err
	case string(KindIoTDevice):
		var itde IoTDeviceEntity
		err := json.Unmarshal(body, &itde)
		return itde, err
	default:
		var e Entity
		err := json.Unmarshal(body, &e)
		return e, err
	}
}
func unmarshalBasicEntityArray(body []byte) ([]BasicEntity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eArray := make([]BasicEntity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		e, err := unmarshalBasicEntity(*rawMessage)
		if err != nil {
			return nil, err
		}
		eArray[index] = e
	}
	return eArray, nil
}

// MarshalJSON is the custom marshaler for Entity.
func (e Entity) MarshalJSON() ([]byte, error) {
	e.Kind = KindEntity
	objectMap := make(map[string]interface{})
	if e.Kind != "" {
		objectMap["kind"] = e.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for Entity.
func (e Entity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for Entity.
func (e Entity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for Entity.
func (e Entity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for Entity.
func (e Entity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for Entity.
func (e Entity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for Entity.
func (e Entity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for Entity.
func (e Entity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for Entity.
func (e Entity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for Entity.
func (e Entity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for Entity.
func (e Entity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for Entity.
func (e Entity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for Entity.
func (e Entity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for Entity.
func (e Entity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for Entity.
func (e Entity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for Entity.
func (e Entity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for Entity.
func (e Entity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for Entity.
func (e Entity) AsEntity() (*Entity, bool) {
	return &e, true
}

// AsBasicEntity is the BasicEntity implementation for Entity.
func (e Entity) AsBasicEntity() (BasicEntity, bool) {
	return &e, true
}

// EntityCommonProperties entity common property bag.
type EntityCommonProperties struct {
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityCommonProperties.
func (ecp EntityCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EntityExpandParameters the parameters required to execute an expand operation on the given entity.
type EntityExpandParameters struct {
	// EndTime - The end date filter, so the only expansion results returned are before this date.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExpansionID - The Id of the expansion to perform.
	ExpansionID *uuid.UUID `json:"expansionId,omitempty"`
	// StartTime - The start date filter, so the only expansion results returned are after this date.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// EntityExpandResponse the entity expansion result operation response.
type EntityExpandResponse struct {
	autorest.Response `json:"-"`
	// MetaData - The metadata from the expansion operation results.
	MetaData *ExpansionResultsMetadata `json:"metaData,omitempty"`
	// Value - The expansion result values.
	Value *EntityExpandResponseValue `json:"value,omitempty"`
}

// EntityExpandResponseValue the expansion result values.
type EntityExpandResponseValue struct {
	// Entities - Array of the expansion result entities.
	Entities *[]BasicEntity `json:"entities,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityExpandResponseValue struct.
func (eer *EntityExpandResponseValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "entities":
			if v != nil {
				entities, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				eer.Entities = &entities
			}
		}
	}

	return nil
}

// EntityKind1 describes an entity with kind.
type EntityKind1 struct {
	// Kind - The kind of the entity. Possible values include: 'EntityKindAccount', 'EntityKindHost', 'EntityKindFile', 'EntityKindAzureResource', 'EntityKindCloudApplication', 'EntityKindDNSResolution', 'EntityKindFileHash', 'EntityKindIP', 'EntityKindMalware', 'EntityKindProcess', 'EntityKindRegistryKey', 'EntityKindRegistryValue', 'EntityKindSecurityGroup', 'EntityKindURL', 'EntityKindIoTDevice', 'EntityKindSecurityAlert', 'EntityKindBookmark'
	Kind EntityKind `json:"kind,omitempty"`
}

// EntityList list of all the entities.
type EntityList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of entities.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of entities.
	Value *[]BasicEntity `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityList struct.
func (el *EntityList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				el.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				el.Value = &value
			}
		}
	}

	return nil
}

// EntityListIterator provides access to a complete listing of Entity values.
type EntityListIterator struct {
	i    int
	page EntityListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EntityListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EntityListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EntityListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EntityListIterator) Response() EntityList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EntityListIterator) Value() BasicEntity {
	if !iter.page.NotDone() {
		return Entity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EntityListIterator type.
func NewEntityListIterator(page EntityListPage) EntityListIterator {
	return EntityListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (el EntityList) IsEmpty() bool {
	return el.Value == nil || len(*el.Value) == 0
}

// entityListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (el EntityList) entityListPreparer(ctx context.Context) (*http.Request, error) {
	if el.NextLink == nil || len(to.String(el.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(el.NextLink)))
}

// EntityListPage contains a page of BasicEntity values.
type EntityListPage struct {
	fn func(context.Context, EntityList) (EntityList, error)
	el EntityList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EntityListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.el)
	if err != nil {
		return err
	}
	page.el = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EntityListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EntityListPage) NotDone() bool {
	return !page.el.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EntityListPage) Response() EntityList {
	return page.el
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EntityListPage) Values() []BasicEntity {
	if page.el.IsEmpty() {
		return nil
	}
	return *page.el.Value
}

// Creates a new instance of the EntityListPage type.
func NewEntityListPage(getNextPage func(context.Context, EntityList) (EntityList, error)) EntityListPage {
	return EntityListPage{fn: getNextPage}
}

// EntityModel ...
type EntityModel struct {
	autorest.Response `json:"-"`
	Value             BasicEntity `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityModel struct.
func (em *EntityModel) UnmarshalJSON(body []byte) error {
	e, err := unmarshalBasicEntity(body)
	if err != nil {
		return err
	}
	em.Value = e

	return nil
}

// EntityQuery specific entity query.
type EntityQuery struct {
	autorest.Response `json:"-"`
	// EntityQueryProperties - Entity query properties
	*EntityQueryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityQuery.
func (eq EntityQuery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eq.EntityQueryProperties != nil {
		objectMap["properties"] = eq.EntityQueryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EntityQuery struct.
func (eq *EntityQuery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var entityQueryProperties EntityQueryProperties
				err = json.Unmarshal(*v, &entityQueryProperties)
				if err != nil {
					return err
				}
				eq.EntityQueryProperties = &entityQueryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eq.Type = &typeVar
			}
		}
	}

	return nil
}

// EntityQueryList list of all the entity queries.
type EntityQueryList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of entity queries.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of entity queries.
	Value *[]EntityQuery `json:"value,omitempty"`
}

// EntityQueryListIterator provides access to a complete listing of EntityQuery values.
type EntityQueryListIterator struct {
	i    int
	page EntityQueryListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EntityQueryListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityQueryListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EntityQueryListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EntityQueryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EntityQueryListIterator) Response() EntityQueryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EntityQueryListIterator) Value() EntityQuery {
	if !iter.page.NotDone() {
		return EntityQuery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EntityQueryListIterator type.
func NewEntityQueryListIterator(page EntityQueryListPage) EntityQueryListIterator {
	return EntityQueryListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eql EntityQueryList) IsEmpty() bool {
	return eql.Value == nil || len(*eql.Value) == 0
}

// entityQueryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eql EntityQueryList) entityQueryListPreparer(ctx context.Context) (*http.Request, error) {
	if eql.NextLink == nil || len(to.String(eql.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eql.NextLink)))
}

// EntityQueryListPage contains a page of EntityQuery values.
type EntityQueryListPage struct {
	fn  func(context.Context, EntityQueryList) (EntityQueryList, error)
	eql EntityQueryList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EntityQueryListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityQueryListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.eql)
	if err != nil {
		return err
	}
	page.eql = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EntityQueryListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EntityQueryListPage) NotDone() bool {
	return !page.eql.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EntityQueryListPage) Response() EntityQueryList {
	return page.eql
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EntityQueryListPage) Values() []EntityQuery {
	if page.eql.IsEmpty() {
		return nil
	}
	return *page.eql.Value
}

// Creates a new instance of the EntityQueryListPage type.
func NewEntityQueryListPage(getNextPage func(context.Context, EntityQueryList) (EntityQueryList, error)) EntityQueryListPage {
	return EntityQueryListPage{fn: getNextPage}
}

// EntityQueryProperties describes entity query properties
type EntityQueryProperties struct {
	// DataSources - List of the data sources that are required to run the query
	DataSources *[]string `json:"dataSources,omitempty"`
	// DisplayName - The query display name
	DisplayName *string `json:"displayName,omitempty"`
	// InputEntityType - The type of the query's source entity. Possible values include: 'EntityTypeAccount', 'EntityTypeHost', 'EntityTypeFile', 'EntityTypeAzureResource', 'EntityTypeCloudApplication', 'EntityTypeDNS', 'EntityTypeFileHash', 'EntityTypeIP', 'EntityTypeMalware', 'EntityTypeProcess', 'EntityTypeRegistryKey', 'EntityTypeRegistryValue', 'EntityTypeSecurityGroup', 'EntityTypeURL', 'EntityTypeIoTDevice', 'EntityTypeSecurityAlert', 'EntityTypeHuntingBookmark'
	InputEntityType EntityType `json:"inputEntityType,omitempty"`
	// InputFields - List of the fields of the source entity that are required to run the query
	InputFields *[]string `json:"inputFields,omitempty"`
	// OutputEntityTypes - List of the desired output types to be constructed from the result
	OutputEntityTypes *[]EntityType `json:"outputEntityTypes,omitempty"`
	// QueryTemplate - The template query string to be parsed and formatted
	QueryTemplate *string `json:"queryTemplate,omitempty"`
}

// ExpansionResultAggregation information of a specific aggregation in the expansion result.
type ExpansionResultAggregation struct {
	// AggregationType - The common type of the aggregation. (for e.g. entity field name)
	AggregationType *string `json:"aggregationType,omitempty"`
	// Count - Total number of aggregations of the given kind (and aggregationType if given) in the expansion result.
	Count *int32 `json:"count,omitempty"`
	// DisplayName - The display name of the aggregation by type.
	DisplayName *string `json:"displayName,omitempty"`
	// EntityKind - The kind of the aggregated entity. Possible values include: 'EntityKindAccount', 'EntityKindHost', 'EntityKindFile', 'EntityKindAzureResource', 'EntityKindCloudApplication', 'EntityKindDNSResolution', 'EntityKindFileHash', 'EntityKindIP', 'EntityKindMalware', 'EntityKindProcess', 'EntityKindRegistryKey', 'EntityKindRegistryValue', 'EntityKindSecurityGroup', 'EntityKindURL', 'EntityKindIoTDevice', 'EntityKindSecurityAlert', 'EntityKindBookmark'
	EntityKind EntityKind `json:"entityKind,omitempty"`
}

// ExpansionResultsMetadata expansion result metadata.
type ExpansionResultsMetadata struct {
	// Aggregations - Information of the aggregated nodes in the expansion result.
	Aggregations *[]ExpansionResultAggregation `json:"aggregations,omitempty"`
}

// EyesOn settings with single toggle.
type EyesOn struct {
	// EyesOnSettingsProperties - EyesOn properties
	*EyesOnSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindSettings', 'KindEyesOn'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EyesOn.
func (eo EyesOn) MarshalJSON() ([]byte, error) {
	eo.Kind = KindEyesOn
	objectMap := make(map[string]interface{})
	if eo.EyesOnSettingsProperties != nil {
		objectMap["properties"] = eo.EyesOnSettingsProperties
	}
	if eo.Etag != nil {
		objectMap["etag"] = eo.Etag
	}
	if eo.Kind != "" {
		objectMap["kind"] = eo.Kind
	}
	return json.Marshal(objectMap)
}

// AsEyesOn is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsEyesOn() (*EyesOn, bool) {
	return &eo, true
}

// AsSettings is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsBasicSettings() (BasicSettings, bool) {
	return &eo, true
}

// UnmarshalJSON is the custom unmarshaler for EyesOn struct.
func (eo *EyesOn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eyesOnSettingsProperties EyesOnSettingsProperties
				err = json.Unmarshal(*v, &eyesOnSettingsProperties)
				if err != nil {
					return err
				}
				eo.EyesOnSettingsProperties = &eyesOnSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eo.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				eo.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				eo.Kind = kind
			}
		}
	}

	return nil
}

// EyesOnSettingsProperties eyesOn property bag.
type EyesOnSettingsProperties struct {
	// IsEnabled - READ-ONLY; Determines whether the setting is enable or disabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// FileEntity represents a file entity.
type FileEntity struct {
	// FileEntityProperties - File entity properties
	*FileEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEntity.
func (fe FileEntity) MarshalJSON() ([]byte, error) {
	fe.Kind = KindFile
	objectMap := make(map[string]interface{})
	if fe.FileEntityProperties != nil {
		objectMap["properties"] = fe.FileEntityProperties
	}
	if fe.Kind != "" {
		objectMap["kind"] = fe.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsFileEntity() (*FileEntity, bool) {
	return &fe, true
}

// AsFileHashEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsBasicEntity() (BasicEntity, bool) {
	return &fe, true
}

// UnmarshalJSON is the custom unmarshaler for FileEntity struct.
func (fe *FileEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileEntityProperties FileEntityProperties
				err = json.Unmarshal(*v, &fileEntityProperties)
				if err != nil {
					return err
				}
				fe.FileEntityProperties = &fileEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fe.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fe.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fe.Kind = kind
			}
		}
	}

	return nil
}

// FileEntityProperties file entity property bag.
type FileEntityProperties struct {
	// Directory - READ-ONLY; The full path to the file.
	Directory *string `json:"directory,omitempty"`
	// FileHashEntityIds - READ-ONLY; The file hash entity identifiers associated with this file
	FileHashEntityIds *[]string `json:"fileHashEntityIds,omitempty"`
	// FileName - READ-ONLY; The file name without path (some alerts might not include path).
	FileName *string `json:"fileName,omitempty"`
	// HostEntityID - READ-ONLY; The Host entity id which the file belongs to
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEntityProperties.
func (fep FileEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FileHashEntity represents a file hash entity.
type FileHashEntity struct {
	// FileHashEntityProperties - FileHash entity properties
	*FileHashEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileHashEntity.
func (fhe FileHashEntity) MarshalJSON() ([]byte, error) {
	fhe.Kind = KindFileHash
	objectMap := make(map[string]interface{})
	if fhe.FileHashEntityProperties != nil {
		objectMap["properties"] = fhe.FileHashEntityProperties
	}
	if fhe.Kind != "" {
		objectMap["kind"] = fhe.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return &fhe, true
}

// AsHostEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsBasicEntity() (BasicEntity, bool) {
	return &fhe, true
}

// UnmarshalJSON is the custom unmarshaler for FileHashEntity struct.
func (fhe *FileHashEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileHashEntityProperties FileHashEntityProperties
				err = json.Unmarshal(*v, &fileHashEntityProperties)
				if err != nil {
					return err
				}
				fhe.FileHashEntityProperties = &fileHashEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fhe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fhe.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fhe.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fhe.Kind = kind
			}
		}
	}

	return nil
}

// FileHashEntityProperties fileHash entity property bag.
type FileHashEntityProperties struct {
	// Algorithm - READ-ONLY; The hash algorithm type. Possible values include: 'Unknown', 'MD5', 'SHA1', 'SHA256', 'SHA256AC'
	Algorithm FileHashAlgorithm `json:"algorithm,omitempty"`
	// HashValue - READ-ONLY; The file hash value.
	HashValue *string `json:"hashValue,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for FileHashEntityProperties.
func (fhep FileHashEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FusionAlertRule represents Fusion alert rule.
type FusionAlertRule struct {
	// FusionAlertRuleProperties - Fusion alert rule properties
	*FusionAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindAlertRule', 'KindFusion', 'KindMicrosoftSecurityIncidentCreation', 'KindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRule.
func (far FusionAlertRule) MarshalJSON() ([]byte, error) {
	far.Kind = KindFusion
	objectMap := make(map[string]interface{})
	if far.FusionAlertRuleProperties != nil {
		objectMap["properties"] = far.FusionAlertRuleProperties
	}
	if far.Etag != nil {
		objectMap["etag"] = far.Etag
	}
	if far.Kind != "" {
		objectMap["kind"] = far.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return &far, true
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &far, true
}

// UnmarshalJSON is the custom unmarshaler for FusionAlertRule struct.
func (far *FusionAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fusionAlertRuleProperties FusionAlertRuleProperties
				err = json.Unmarshal(*v, &fusionAlertRuleProperties)
				if err != nil {
					return err
				}
				far.FusionAlertRuleProperties = &fusionAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				far.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				far.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				far.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				far.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				far.Kind = kind
			}
		}
	}

	return nil
}

// FusionAlertRuleProperties fusion alert rule base property bag.
type FusionAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - READ-ONLY; The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Severity - READ-ONLY; The severity for alerts created by this alert rule. Possible values include: 'High', 'Medium', 'Low', 'Informational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - READ-ONLY; The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// FusionAlertRuleTemplate represents Fusion alert rule template.
type FusionAlertRuleTemplate struct {
	// FusionAlertRuleTemplateProperties - Fusion alert rule template properties
	*FusionAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	fart.Kind = KindBasicAlertRuleTemplateKindFusion
	objectMap := make(map[string]interface{})
	if fart.FusionAlertRuleTemplateProperties != nil {
		objectMap["properties"] = fart.FusionAlertRuleTemplateProperties
	}
	if fart.Kind != "" {
		objectMap["kind"] = fart.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return &fart, true
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &fart, true
}

// UnmarshalJSON is the custom unmarshaler for FusionAlertRuleTemplate struct.
func (fart *FusionAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fusionAlertRuleTemplateProperties FusionAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &fusionAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				fart.FusionAlertRuleTemplateProperties = &fusionAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fart.Kind = kind
			}
		}
	}

	return nil
}

// FusionAlertRuleTemplateProperties fusion alert rule template properties
type FusionAlertRuleTemplateProperties struct {
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'High', 'Medium', 'Low', 'Informational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - The tactics of the alert rule template
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'Installed', 'Available', 'NotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
}

// GeoLocation the geo-location context attached to the ip entity
type GeoLocation struct {
	// Asn - READ-ONLY; Autonomous System Number
	Asn *int32 `json:"asn,omitempty"`
	// City - READ-ONLY; City name
	City *string `json:"city,omitempty"`
	// CountryCode - READ-ONLY; The country code according to ISO 3166 format
	CountryCode *string `json:"countryCode,omitempty"`
	// CountryName - READ-ONLY; Country name according to ISO 3166 Alpha 2: the lowercase of the English Short Name
	CountryName *string `json:"countryName,omitempty"`
	// Latitude - READ-ONLY; The longitude of the identified location, expressed as a floating point number with range of -180 to 180, with positive numbers representing East and negative numbers representing West. Latitude and longitude are derived from the city or postal code.
	Latitude *float64 `json:"latitude,omitempty"`
	// Longitude - READ-ONLY; The latitude of the identified location, expressed as a floating point number with range of - 90 to 90, with positive numbers representing North and negative numbers representing South. Latitude and longitude are derived from the city or postal code.
	Longitude *float64 `json:"longitude,omitempty"`
	// State - READ-ONLY; State name
	State *string `json:"state,omitempty"`
}

// GroupingConfiguration grouping configuration property bag.
type GroupingConfiguration struct {
	// Enabled - Grouping enabled
	Enabled *bool `json:"enabled,omitempty"`
	// ReopenClosedIncident - Re-open closed matching incidents
	ReopenClosedIncident *bool `json:"reopenClosedIncident,omitempty"`
	// LookbackDuration - Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
	LookbackDuration *string `json:"lookbackDuration,omitempty"`
	// EntitiesMatchingMethod - Grouping matching method. Possible values include: 'All', 'None', 'Custom'
	EntitiesMatchingMethod EntitiesMatchingMethod `json:"entitiesMatchingMethod,omitempty"`
	// GroupByEntities - A list of entity types to group by (when entitiesMatchingMethod is Custom)
	GroupByEntities *[]GroupingEntityType `json:"groupByEntities,omitempty"`
}

// HostEntity represents a host entity.
type HostEntity struct {
	// HostEntityProperties - Host entity properties
	*HostEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for HostEntity.
func (he HostEntity) MarshalJSON() ([]byte, error) {
	he.Kind = KindHost
	objectMap := make(map[string]interface{})
	if he.HostEntityProperties != nil {
		objectMap["properties"] = he.HostEntityProperties
	}
	if he.Kind != "" {
		objectMap["kind"] = he.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsHostEntity() (*HostEntity, bool) {
	return &he, true
}

// AsIPEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsBasicEntity() (BasicEntity, bool) {
	return &he, true
}

// UnmarshalJSON is the custom unmarshaler for HostEntity struct.
func (he *HostEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostEntityProperties HostEntityProperties
				err = json.Unmarshal(*v, &hostEntityProperties)
				if err != nil {
					return err
				}
				he.HostEntityProperties = &hostEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				he.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				he.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				he.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				he.Kind = kind
			}
		}
	}

	return nil
}

// HostEntityProperties host entity property bag.
type HostEntityProperties struct {
	// AzureID - READ-ONLY; The azure resource id of the VM.
	AzureID *string `json:"azureID,omitempty"`
	// DNSDomain - READ-ONLY; The DNS domain that this host belongs to. Should contain the compete DNS suffix for the domain
	DNSDomain *string `json:"dnsDomain,omitempty"`
	// HostName - READ-ONLY; The hostname without the domain suffix.
	HostName *string `json:"hostName,omitempty"`
	// IsDomainJoined - READ-ONLY; Determines whether this host belongs to a domain.
	IsDomainJoined *bool `json:"isDomainJoined,omitempty"`
	// NetBiosName - READ-ONLY; The host name (pre-windows2000).
	NetBiosName *string `json:"netBiosName,omitempty"`
	// NtDomain - READ-ONLY; The NT domain that this host belongs to.
	NtDomain *string `json:"ntDomain,omitempty"`
	// OmsAgentID - READ-ONLY; The OMS agent id, if the host has OMS agent installed.
	OmsAgentID *string `json:"omsAgentID,omitempty"`
	// OsFamily - The operating system type. Possible values include: 'Linux', 'Windows', 'Android', 'IOS'
	OsFamily OSFamily `json:"osFamily,omitempty"`
	// OsVersion - READ-ONLY; A free text representation of the operating system. This field is meant to hold specific versions the are more fine grained than OSFamily or future values not supported by OSFamily enumeration
	OsVersion *string `json:"osVersion,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for HostEntityProperties.
func (hep HostEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hep.OsFamily != "" {
		objectMap["osFamily"] = hep.OsFamily
	}
	return json.Marshal(objectMap)
}

// Incident represents an incident in Azure Security Insights.
type Incident struct {
	autorest.Response `json:"-"`
	// IncidentProperties - Incident properties
	*IncidentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Incident.
func (i Incident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.IncidentProperties != nil {
		objectMap["properties"] = i.IncidentProperties
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Incident struct.
func (i *Incident) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var incidentProperties IncidentProperties
				err = json.Unmarshal(*v, &incidentProperties)
				if err != nil {
					return err
				}
				i.IncidentProperties = &incidentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		}
	}

	return nil
}

// IncidentAdditionalData incident additional data property bag.
type IncidentAdditionalData struct {
	// AlertsCount - READ-ONLY; The number of alerts in the incident
	AlertsCount *int32 `json:"alertsCount,omitempty"`
	// BookmarksCount - READ-ONLY; The number of bookmarks in the incident
	BookmarksCount *int32 `json:"bookmarksCount,omitempty"`
	// CommentsCount - READ-ONLY; The number of comments in the incident
	CommentsCount *int32 `json:"commentsCount,omitempty"`
	// AlertProductNames - READ-ONLY; List of product names of alerts in the incident
	AlertProductNames *[]string `json:"alertProductNames,omitempty"`
	// Tactics - READ-ONLY; The tactics associated with incident
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// IncidentComment represents an incident comment
type IncidentComment struct {
	autorest.Response `json:"-"`
	// IncidentCommentProperties - Incident comment properties
	*IncidentCommentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentComment.
func (ic IncidentComment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IncidentCommentProperties != nil {
		objectMap["properties"] = ic.IncidentCommentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IncidentComment struct.
func (ic *IncidentComment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var incidentCommentProperties IncidentCommentProperties
				err = json.Unmarshal(*v, &incidentCommentProperties)
				if err != nil {
					return err
				}
				ic.IncidentCommentProperties = &incidentCommentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ic.Type = &typeVar
			}
		}
	}

	return nil
}

// IncidentCommentList list of incident comments.
type IncidentCommentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of comments.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of comments.
	Value *[]IncidentComment `json:"value,omitempty"`
}

// IncidentCommentListIterator provides access to a complete listing of IncidentComment values.
type IncidentCommentListIterator struct {
	i    int
	page IncidentCommentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IncidentCommentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentCommentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IncidentCommentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IncidentCommentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IncidentCommentListIterator) Response() IncidentCommentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IncidentCommentListIterator) Value() IncidentComment {
	if !iter.page.NotDone() {
		return IncidentComment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IncidentCommentListIterator type.
func NewIncidentCommentListIterator(page IncidentCommentListPage) IncidentCommentListIterator {
	return IncidentCommentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (icl IncidentCommentList) IsEmpty() bool {
	return icl.Value == nil || len(*icl.Value) == 0
}

// incidentCommentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (icl IncidentCommentList) incidentCommentListPreparer(ctx context.Context) (*http.Request, error) {
	if icl.NextLink == nil || len(to.String(icl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(icl.NextLink)))
}

// IncidentCommentListPage contains a page of IncidentComment values.
type IncidentCommentListPage struct {
	fn  func(context.Context, IncidentCommentList) (IncidentCommentList, error)
	icl IncidentCommentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IncidentCommentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentCommentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.icl)
	if err != nil {
		return err
	}
	page.icl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IncidentCommentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IncidentCommentListPage) NotDone() bool {
	return !page.icl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IncidentCommentListPage) Response() IncidentCommentList {
	return page.icl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IncidentCommentListPage) Values() []IncidentComment {
	if page.icl.IsEmpty() {
		return nil
	}
	return *page.icl.Value
}

// Creates a new instance of the IncidentCommentListPage type.
func NewIncidentCommentListPage(getNextPage func(context.Context, IncidentCommentList) (IncidentCommentList, error)) IncidentCommentListPage {
	return IncidentCommentListPage{fn: getNextPage}
}

// IncidentCommentProperties incident comment property bag.
type IncidentCommentProperties struct {
	// CreatedTimeUtc - READ-ONLY; The time the comment was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Message - The comment message
	Message *string `json:"message,omitempty"`
	// Author - READ-ONLY; Describes the client that created the comment
	Author *ClientInfo `json:"author,omitempty"`
}

// IncidentConfiguration incident Configuration property bag.
type IncidentConfiguration struct {
	// CreateIncident - Create incidents from alerts triggered by this analytics rule
	CreateIncident *bool `json:"createIncident,omitempty"`
	// GroupingConfiguration - Set how the alerts that are triggered by this analytics rule, are grouped into incidents
	GroupingConfiguration *GroupingConfiguration `json:"groupingConfiguration,omitempty"`
}

// IncidentInfo describes related incident information for the bookmark
type IncidentInfo struct {
	// IncidentID - Incident Id
	IncidentID *string `json:"incidentId,omitempty"`
	// Severity - The severity of the incident. Possible values include: 'CaseSeverityCritical', 'CaseSeverityHigh', 'CaseSeverityMedium', 'CaseSeverityLow', 'CaseSeverityInformational'
	Severity CaseSeverity `json:"severity,omitempty"`
	// Title - The title of the incident
	Title *string `json:"title,omitempty"`
	// RelationName - Relation Name
	RelationName *string `json:"relationName,omitempty"`
}

// IncidentLabel represents an incident label
type IncidentLabel struct {
	// LabelName - The name of the label
	LabelName *string `json:"labelName,omitempty"`
	// LabelType - READ-ONLY; The type of the label. Possible values include: 'User', 'System'
	LabelType IncidentLabelType `json:"labelType,omitempty"`
}

// IncidentList list all the incidents.
type IncidentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of incidents.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of incidents.
	Value *[]Incident `json:"value,omitempty"`
}

// IncidentListIterator provides access to a complete listing of Incident values.
type IncidentListIterator struct {
	i    int
	page IncidentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IncidentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IncidentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IncidentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IncidentListIterator) Response() IncidentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IncidentListIterator) Value() Incident {
	if !iter.page.NotDone() {
		return Incident{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IncidentListIterator type.
func NewIncidentListIterator(page IncidentListPage) IncidentListIterator {
	return IncidentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (il IncidentList) IsEmpty() bool {
	return il.Value == nil || len(*il.Value) == 0
}

// incidentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (il IncidentList) incidentListPreparer(ctx context.Context) (*http.Request, error) {
	if il.NextLink == nil || len(to.String(il.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(il.NextLink)))
}

// IncidentListPage contains a page of Incident values.
type IncidentListPage struct {
	fn func(context.Context, IncidentList) (IncidentList, error)
	il IncidentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IncidentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.il)
	if err != nil {
		return err
	}
	page.il = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IncidentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IncidentListPage) NotDone() bool {
	return !page.il.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IncidentListPage) Response() IncidentList {
	return page.il
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IncidentListPage) Values() []Incident {
	if page.il.IsEmpty() {
		return nil
	}
	return *page.il.Value
}

// Creates a new instance of the IncidentListPage type.
func NewIncidentListPage(getNextPage func(context.Context, IncidentList) (IncidentList, error)) IncidentListPage {
	return IncidentListPage{fn: getNextPage}
}

// IncidentOwnerInfo information on the user an incident is assigned to
type IncidentOwnerInfo struct {
	// Email - The email of the user the incident is assigned to.
	Email *string `json:"email,omitempty"`
	// AssignedTo - The name of the user the incident is assigned to.
	AssignedTo *string `json:"assignedTo,omitempty"`
	// ObjectID - The object id of the user the incident is assigned to.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// UserPrincipalName - The user principal name of the user the incident is assigned to.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// IncidentProperties describes incident properties
type IncidentProperties struct {
	// AdditionalData - READ-ONLY; Additional data on the incident
	AdditionalData *IncidentAdditionalData `json:"additionalData,omitempty"`
	// Classification - The reason the incident was closed. Possible values include: 'IncidentClassificationUndetermined', 'IncidentClassificationTruePositive', 'IncidentClassificationBenignPositive', 'IncidentClassificationFalsePositive'
	Classification IncidentClassification `json:"classification,omitempty"`
	// ClassificationComment - Describes the reason the incident was closed
	ClassificationComment *string `json:"classificationComment,omitempty"`
	// ClassificationReason - The classification reason the incident was closed with. Possible values include: 'SuspiciousActivity', 'SuspiciousButExpected', 'IncorrectAlertLogic', 'InaccurateData'
	ClassificationReason IncidentClassificationReason `json:"classificationReason,omitempty"`
	// CreatedTimeUtc - READ-ONLY; The time the incident was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Description - The description of the incident
	Description *string `json:"description,omitempty"`
	// FirstActivityTimeUtc - The time of the first activity in the incident
	FirstActivityTimeUtc *date.Time `json:"firstActivityTimeUtc,omitempty"`
	// IncidentURL - READ-ONLY; The deep-link url to the incident in Azure portal
	IncidentURL *string `json:"incidentUrl,omitempty"`
	// IncidentNumber - READ-ONLY; A sequential number
	IncidentNumber *int32 `json:"incidentNumber,omitempty"`
	// Labels - List of labels relevant to this incident
	Labels *[]IncidentLabel `json:"labels,omitempty"`
	// LastActivityTimeUtc - The time of the last activity in the incident
	LastActivityTimeUtc *date.Time `json:"lastActivityTimeUtc,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; The last time the incident was updated
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// Owner - Describes a user that the incident is assigned to
	Owner *IncidentOwnerInfo `json:"owner,omitempty"`
	// RelatedAnalyticRuleIds - READ-ONLY; List of resource ids of Analytic rules related to the incident
	RelatedAnalyticRuleIds *[]string `json:"relatedAnalyticRuleIds,omitempty"`
	// Severity - The severity of the incident. Possible values include: 'IncidentSeverityHigh', 'IncidentSeverityMedium', 'IncidentSeverityLow', 'IncidentSeverityInformational'
	Severity IncidentSeverity `json:"severity,omitempty"`
	// Status - The status of the incident. Possible values include: 'IncidentStatusNew', 'IncidentStatusActive', 'IncidentStatusClosed'
	Status IncidentStatus `json:"status,omitempty"`
	// Title - The title of the incident
	Title *string `json:"title,omitempty"`
}

// IoTDeviceEntity represents an IoT device entity.
type IoTDeviceEntity struct {
	// IoTDeviceEntityProperties - IoTDevice entity properties
	*IoTDeviceEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTDeviceEntity.
func (itde IoTDeviceEntity) MarshalJSON() ([]byte, error) {
	itde.Kind = KindIoTDevice
	objectMap := make(map[string]interface{})
	if itde.IoTDeviceEntityProperties != nil {
		objectMap["properties"] = itde.IoTDeviceEntityProperties
	}
	if itde.Kind != "" {
		objectMap["kind"] = itde.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return &itde, true
}

// AsEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsBasicEntity() (BasicEntity, bool) {
	return &itde, true
}

// UnmarshalJSON is the custom unmarshaler for IoTDeviceEntity struct.
func (itde *IoTDeviceEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTDeviceEntityProperties IoTDeviceEntityProperties
				err = json.Unmarshal(*v, &ioTDeviceEntityProperties)
				if err != nil {
					return err
				}
				itde.IoTDeviceEntityProperties = &ioTDeviceEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itde.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				itde.Kind = kind
			}
		}
	}

	return nil
}

// IoTDeviceEntityProperties ioTDevice entity property bag.
type IoTDeviceEntityProperties struct {
	// DeviceID - READ-ONLY; The ID of the IoT Device in the IoT Hub
	DeviceID *string `json:"deviceId,omitempty"`
	// IotSecurityAgentID - READ-ONLY; The ID of the security agent running on the device
	IotSecurityAgentID *uuid.UUID `json:"iotSecurityAgentId,omitempty"`
	// DeviceType - READ-ONLY; The type of the device
	DeviceType *string `json:"deviceType,omitempty"`
	// Vendor - READ-ONLY; The vendor of the device
	Vendor *string `json:"vendor,omitempty"`
	// EdgeID - READ-ONLY; The ID of the edge device
	EdgeID *string `json:"edgeId,omitempty"`
	// IotHubEntityID - READ-ONLY; The AzureResource entity id of the IoT Hub
	IotHubEntityID *string `json:"iotHubEntityId,omitempty"`
	// HostEntityID - READ-ONLY; The Host entity id of this device
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// ThreatIntelligence - READ-ONLY; A list of TI contexts attached to the IoTDevice entity.
	ThreatIntelligence *[]ThreatIntelligence `json:"threatIntelligence,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTDeviceEntityProperties.
func (itdep IoTDeviceEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IPEntity represents an ip entity.
type IPEntity struct {
	// IPEntityProperties - Ip entity properties
	*IPEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for IPEntity.
func (ie IPEntity) MarshalJSON() ([]byte, error) {
	ie.Kind = KindIP
	objectMap := make(map[string]interface{})
	if ie.IPEntityProperties != nil {
		objectMap["properties"] = ie.IPEntityProperties
	}
	if ie.Kind != "" {
		objectMap["kind"] = ie.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsIPEntity() (*IPEntity, bool) {
	return &ie, true
}

// AsMalwareEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsBasicEntity() (BasicEntity, bool) {
	return &ie, true
}

// UnmarshalJSON is the custom unmarshaler for IPEntity struct.
func (ie *IPEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPEntityProperties IPEntityProperties
				err = json.Unmarshal(*v, &IPEntityProperties)
				if err != nil {
					return err
				}
				ie.IPEntityProperties = &IPEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ie.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ie.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ie.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ie.Kind = kind
			}
		}
	}

	return nil
}

// IPEntityProperties ip entity property bag.
type IPEntityProperties struct {
	// Address - READ-ONLY; The IP address as string, e.g. 127.0.0.1 (either in Ipv4 or Ipv6)
	Address *string `json:"address,omitempty"`
	// Location - The geo-location context attached to the ip entity
	Location *GeoLocation `json:"location,omitempty"`
	// ThreatIntelligence - READ-ONLY; A list of TI contexts attached to the ip entity.
	ThreatIntelligence *[]ThreatIntelligence `json:"threatIntelligence,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for IPEntityProperties.
func (iep IPEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iep.Location != nil {
		objectMap["location"] = iep.Location
	}
	return json.Marshal(objectMap)
}

// MalwareEntity represents a malware entity.
type MalwareEntity struct {
	// MalwareEntityProperties - File entity properties
	*MalwareEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MalwareEntity.
func (me MalwareEntity) MarshalJSON() ([]byte, error) {
	me.Kind = KindMalware
	objectMap := make(map[string]interface{})
	if me.MalwareEntityProperties != nil {
		objectMap["properties"] = me.MalwareEntityProperties
	}
	if me.Kind != "" {
		objectMap["kind"] = me.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return &me, true
}

// AsProcessEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsBasicEntity() (BasicEntity, bool) {
	return &me, true
}

// UnmarshalJSON is the custom unmarshaler for MalwareEntity struct.
func (me *MalwareEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var malwareEntityProperties MalwareEntityProperties
				err = json.Unmarshal(*v, &malwareEntityProperties)
				if err != nil {
					return err
				}
				me.MalwareEntityProperties = &malwareEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				me.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				me.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				me.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				me.Kind = kind
			}
		}
	}

	return nil
}

// MalwareEntityProperties malware entity property bag.
type MalwareEntityProperties struct {
	// Category - READ-ONLY; The malware category by the vendor, e.g. Trojan
	Category *string `json:"category,omitempty"`
	// FileEntityIds - READ-ONLY; List of linked file entity identifiers on which the malware was found
	FileEntityIds *[]string `json:"fileEntityIds,omitempty"`
	// MalwareName - READ-ONLY; The malware name by the vendor, e.g. Win32/Toga!rfn
	MalwareName *string `json:"malwareName,omitempty"`
	// ProcessEntityIds - READ-ONLY; List of linked process entity identifiers on which the malware was found.
	ProcessEntityIds *[]string `json:"processEntityIds,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for MalwareEntityProperties.
func (mep MalwareEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MCASCheckRequirements represents MCAS (Microsoft Cloud App Security) requirements check request.
type MCASCheckRequirements struct {
	// MCASCheckRequirementsProperties - MCAS (Microsoft Cloud App Security) requirements check properties.
	*MCASCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MCASCheckRequirements.
func (mcr MCASCheckRequirements) MarshalJSON() ([]byte, error) {
	mcr.Kind = KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity
	objectMap := make(map[string]interface{})
	if mcr.MCASCheckRequirementsProperties != nil {
		objectMap["properties"] = mcr.MCASCheckRequirementsProperties
	}
	if mcr.Kind != "" {
		objectMap["kind"] = mcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return &mcr, true
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &mcr, true
}

// UnmarshalJSON is the custom unmarshaler for MCASCheckRequirements struct.
func (mcr *MCASCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mCASCheckRequirementsProperties MCASCheckRequirementsProperties
				err = json.Unmarshal(*v, &mCASCheckRequirementsProperties)
				if err != nil {
					return err
				}
				mcr.MCASCheckRequirementsProperties = &mCASCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mcr.Kind = kind
			}
		}
	}

	return nil
}

// MCASCheckRequirementsProperties MCAS (Microsoft Cloud App Security) requirements check properties.
type MCASCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MCASDataConnector represents MCAS (Microsoft Cloud App Security) data connector.
type MCASDataConnector struct {
	// MCASDataConnectorProperties - MCAS (Microsoft Cloud App Security) data connector properties.
	*MCASDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MCASDataConnector.
func (mdc MCASDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindMicrosoftCloudAppSecurity
	objectMap := make(map[string]interface{})
	if mdc.MCASDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MCASDataConnectorProperties
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return &mdc, true
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MCASDataConnector struct.
func (mdc *MCASDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mCASDataConnectorProperties MCASDataConnectorProperties
				err = json.Unmarshal(*v, &mCASDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MCASDataConnectorProperties = &mCASDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		}
	}

	return nil
}

// MCASDataConnectorDataTypes the available data types for MCAS (Microsoft Cloud App Security) data
// connector.
type MCASDataConnectorDataTypes struct {
	// DiscoveryLogs - Discovery log data type connection.
	DiscoveryLogs *MCASDataConnectorDataTypesDiscoveryLogs `json:"discoveryLogs,omitempty"`
	// Alerts - Alerts data type connection.
	Alerts *AlertsDataTypeOfDataConnectorAlerts `json:"alerts,omitempty"`
}

// MCASDataConnectorDataTypesDiscoveryLogs discovery log data type connection.
type MCASDataConnectorDataTypesDiscoveryLogs struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// MCASDataConnectorProperties MCAS (Microsoft Cloud App Security) data connector properties.
type MCASDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *MCASDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MDATPCheckRequirements represents MDATP (Microsoft Defender Advanced Threat Protection) requirements
// check request.
type MDATPCheckRequirements struct {
	// MDATPCheckRequirementsProperties - MDATP (Microsoft Defender Advanced Threat Protection) requirements check properties.
	*MDATPCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) MarshalJSON() ([]byte, error) {
	mcr.Kind = KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if mcr.MDATPCheckRequirementsProperties != nil {
		objectMap["properties"] = mcr.MDATPCheckRequirementsProperties
	}
	if mcr.Kind != "" {
		objectMap["kind"] = mcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return &mcr, true
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &mcr, true
}

// UnmarshalJSON is the custom unmarshaler for MDATPCheckRequirements struct.
func (mcr *MDATPCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mDATPCheckRequirementsProperties MDATPCheckRequirementsProperties
				err = json.Unmarshal(*v, &mDATPCheckRequirementsProperties)
				if err != nil {
					return err
				}
				mcr.MDATPCheckRequirementsProperties = &mDATPCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mcr.Kind = kind
			}
		}
	}

	return nil
}

// MDATPCheckRequirementsProperties MDATP (Microsoft Defender Advanced Threat Protection) requirements
// check properties.
type MDATPCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MDATPDataConnector represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.
type MDATPDataConnector struct {
	// MDATPDataConnectorProperties - MDATP (Microsoft Defender Advanced Threat Protection) data connector properties.
	*MDATPDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MDATPDataConnector.
func (mdc MDATPDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindMicrosoftDefenderAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if mdc.MDATPDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MDATPDataConnectorProperties
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return &mdc, true
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MDATPDataConnector struct.
func (mdc *MDATPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mDATPDataConnectorProperties MDATPDataConnectorProperties
				err = json.Unmarshal(*v, &mDATPDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MDATPDataConnectorProperties = &mDATPDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		}
	}

	return nil
}

// MDATPDataConnectorProperties MDATP (Microsoft Defender Advanced Threat Protection) data connector
// properties.
type MDATPDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// MicrosoftSecurityIncidentCreationAlertRule represents MicrosoftSecurityIncidentCreation rule.
type MicrosoftSecurityIncidentCreationAlertRule struct {
	// MicrosoftSecurityIncidentCreationAlertRuleProperties - MicrosoftSecurityIncidentCreation rule properties
	*MicrosoftSecurityIncidentCreationAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindAlertRule', 'KindFusion', 'KindMicrosoftSecurityIncidentCreation', 'KindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) MarshalJSON() ([]byte, error) {
	msicar.Kind = KindMicrosoftSecurityIncidentCreation
	objectMap := make(map[string]interface{})
	if msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties != nil {
		objectMap["properties"] = msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties
	}
	if msicar.Etag != nil {
		objectMap["etag"] = msicar.Etag
	}
	if msicar.Kind != "" {
		objectMap["kind"] = msicar.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return &msicar, true
}

// AsScheduledAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &msicar, true
}

// UnmarshalJSON is the custom unmarshaler for MicrosoftSecurityIncidentCreationAlertRule struct.
func (msicar *MicrosoftSecurityIncidentCreationAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var microsoftSecurityIncidentCreationAlertRuleProperties MicrosoftSecurityIncidentCreationAlertRuleProperties
				err = json.Unmarshal(*v, &microsoftSecurityIncidentCreationAlertRuleProperties)
				if err != nil {
					return err
				}
				msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties = &microsoftSecurityIncidentCreationAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msicar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msicar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msicar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				msicar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				msicar.Kind = kind
			}
		}
	}

	return nil
}

// MicrosoftSecurityIncidentCreationAlertRuleCommonProperties microsoftSecurityIncidentCreation rule common
// property bag.
type MicrosoftSecurityIncidentCreationAlertRuleCommonProperties struct {
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftCloudAppSecurity', 'AzureSecurityCenter', 'AzureAdvancedThreatProtection', 'AzureActiveDirectoryIdentityProtection', 'AzureSecurityCenterforIoT'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MicrosoftSecurityIncidentCreationAlertRuleProperties microsoftSecurityIncidentCreation rule property
// bag.
type MicrosoftSecurityIncidentCreationAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftCloudAppSecurity', 'AzureSecurityCenter', 'AzureAdvancedThreatProtection', 'AzureActiveDirectoryIdentityProtection', 'AzureSecurityCenterforIoT'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplate represents MicrosoftSecurityIncidentCreation rule
// template.
type MicrosoftSecurityIncidentCreationAlertRuleTemplate struct {
	// MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties - MicrosoftSecurityIncidentCreation rule template properties
	*MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	msicart.Kind = KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation
	objectMap := make(map[string]interface{})
	if msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties != nil {
		objectMap["properties"] = msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
	}
	if msicart.Kind != "" {
		objectMap["kind"] = msicart.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return &msicart, true
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &msicart, true
}

// UnmarshalJSON is the custom unmarshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplate struct.
func (msicart *MicrosoftSecurityIncidentCreationAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var microsoftSecurityIncidentCreationAlertRuleTemplateProperties MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &microsoftSecurityIncidentCreationAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties = &microsoftSecurityIncidentCreationAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msicart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msicart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msicart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				msicart.Kind = kind
			}
		}
	}

	return nil
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties microsoftSecurityIncidentCreation rule
// template properties
type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'Installed', 'Available', 'NotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftCloudAppSecurity', 'AzureSecurityCenter', 'AzureAdvancedThreatProtection', 'AzureActiveDirectoryIdentityProtection', 'AzureSecurityCenterforIoT'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// OfficeConsent consent for Office365 tenant that already made.
type OfficeConsent struct {
	autorest.Response `json:"-"`
	// OfficeConsentProperties - Office consent properties
	*OfficeConsentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeConsent.
func (oc OfficeConsent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oc.OfficeConsentProperties != nil {
		objectMap["properties"] = oc.OfficeConsentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OfficeConsent struct.
func (oc *OfficeConsent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeConsentProperties OfficeConsentProperties
				err = json.Unmarshal(*v, &officeConsentProperties)
				if err != nil {
					return err
				}
				oc.OfficeConsentProperties = &officeConsentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oc.Type = &typeVar
			}
		}
	}

	return nil
}

// OfficeConsentList list of all the office365 consents.
type OfficeConsentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of office consents.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of the consents.
	Value *[]OfficeConsent `json:"value,omitempty"`
}

// OfficeConsentListIterator provides access to a complete listing of OfficeConsent values.
type OfficeConsentListIterator struct {
	i    int
	page OfficeConsentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OfficeConsentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfficeConsentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OfficeConsentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OfficeConsentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OfficeConsentListIterator) Response() OfficeConsentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OfficeConsentListIterator) Value() OfficeConsent {
	if !iter.page.NotDone() {
		return OfficeConsent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OfficeConsentListIterator type.
func NewOfficeConsentListIterator(page OfficeConsentListPage) OfficeConsentListIterator {
	return OfficeConsentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ocl OfficeConsentList) IsEmpty() bool {
	return ocl.Value == nil || len(*ocl.Value) == 0
}

// officeConsentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ocl OfficeConsentList) officeConsentListPreparer(ctx context.Context) (*http.Request, error) {
	if ocl.NextLink == nil || len(to.String(ocl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ocl.NextLink)))
}

// OfficeConsentListPage contains a page of OfficeConsent values.
type OfficeConsentListPage struct {
	fn  func(context.Context, OfficeConsentList) (OfficeConsentList, error)
	ocl OfficeConsentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OfficeConsentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfficeConsentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ocl)
	if err != nil {
		return err
	}
	page.ocl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OfficeConsentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OfficeConsentListPage) NotDone() bool {
	return !page.ocl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OfficeConsentListPage) Response() OfficeConsentList {
	return page.ocl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OfficeConsentListPage) Values() []OfficeConsent {
	if page.ocl.IsEmpty() {
		return nil
	}
	return *page.ocl.Value
}

// Creates a new instance of the OfficeConsentListPage type.
func NewOfficeConsentListPage(getNextPage func(context.Context, OfficeConsentList) (OfficeConsentList, error)) OfficeConsentListPage {
	return OfficeConsentListPage{fn: getNextPage}
}

// OfficeConsentProperties consent property bag.
type OfficeConsentProperties struct {
	// TenantID - The tenantId of the Office365 with the consent.
	TenantID *string `json:"tenantId,omitempty"`
	// TenantName - READ-ONLY; The tenant name of the Office365 with the consent.
	TenantName *string `json:"tenantName,omitempty"`
}

// OfficeDataConnector represents office data connector.
type OfficeDataConnector struct {
	// OfficeDataConnectorProperties - Office data connector properties.
	*OfficeDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeDataConnector.
func (odc OfficeDataConnector) MarshalJSON() ([]byte, error) {
	odc.Kind = KindOffice365
	objectMap := make(map[string]interface{})
	if odc.OfficeDataConnectorProperties != nil {
		objectMap["properties"] = odc.OfficeDataConnectorProperties
	}
	if odc.Etag != nil {
		objectMap["etag"] = odc.Etag
	}
	if odc.Kind != "" {
		objectMap["kind"] = odc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return &odc, true
}

// AsTIDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &odc, true
}

// UnmarshalJSON is the custom unmarshaler for OfficeDataConnector struct.
func (odc *OfficeDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeDataConnectorProperties OfficeDataConnectorProperties
				err = json.Unmarshal(*v, &officeDataConnectorProperties)
				if err != nil {
					return err
				}
				odc.OfficeDataConnectorProperties = &officeDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				odc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				odc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				odc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				odc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				odc.Kind = kind
			}
		}
	}

	return nil
}

// OfficeDataConnectorDataTypes the available data types for office data connector.
type OfficeDataConnectorDataTypes struct {
	// Exchange - Exchange data type connection.
	Exchange *OfficeDataConnectorDataTypesExchange `json:"exchange,omitempty"`
	// SharePoint - SharePoint data type connection.
	SharePoint *OfficeDataConnectorDataTypesSharePoint `json:"sharePoint,omitempty"`
}

// OfficeDataConnectorDataTypesExchange exchange data type connection.
type OfficeDataConnectorDataTypesExchange struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorDataTypesSharePoint sharePoint data type connection.
type OfficeDataConnectorDataTypesSharePoint struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorProperties office data connector properties.
type OfficeDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *OfficeDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// Operation operation provided by provider
type Operation struct {
	// Display - Properties of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
}

// OperationDisplay properties of the operation
type OperationDisplay struct {
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
	// Provider - Provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name
	Resource *string `json:"resource,omitempty"`
}

// OperationsList lists the operations available in the SecurityInsights RP.
type OperationsList struct {
	autorest.Response `json:"-"`
	// NextLink - URL to fetch the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of operations
	Value *[]Operation `json:"value,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{fn: getNextPage}
}

// ProcessEntity represents a process entity.
type ProcessEntity struct {
	// ProcessEntityProperties - Process entity properties
	*ProcessEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessEntity.
func (peVar ProcessEntity) MarshalJSON() ([]byte, error) {
	peVar.Kind = KindProcess
	objectMap := make(map[string]interface{})
	if peVar.ProcessEntityProperties != nil {
		objectMap["properties"] = peVar.ProcessEntityProperties
	}
	if peVar.Kind != "" {
		objectMap["kind"] = peVar.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return &peVar, true
}

// AsRegistryKeyEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsBasicEntity() (BasicEntity, bool) {
	return &peVar, true
}

// UnmarshalJSON is the custom unmarshaler for ProcessEntity struct.
func (peVar *ProcessEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processEntityProperties ProcessEntityProperties
				err = json.Unmarshal(*v, &processEntityProperties)
				if err != nil {
					return err
				}
				peVar.ProcessEntityProperties = &processEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				peVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				peVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				peVar.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				peVar.Kind = kind
			}
		}
	}

	return nil
}

// ProcessEntityProperties process entity property bag.
type ProcessEntityProperties struct {
	// AccountEntityID - READ-ONLY; The account entity id running the processes.
	AccountEntityID *string `json:"accountEntityId,omitempty"`
	// CommandLine - READ-ONLY; The command line used to create the process
	CommandLine *string `json:"commandLine,omitempty"`
	// CreationTimeUtc - READ-ONLY; The time when the process started to run
	CreationTimeUtc *date.Time `json:"creationTimeUtc,omitempty"`
	// ElevationToken - The elevation token associated with the process. Possible values include: 'Default', 'Full', 'Limited'
	ElevationToken ElevationToken `json:"elevationToken,omitempty"`
	// HostEntityID - READ-ONLY; The host entity id on which the process was running
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// HostLogonSessionEntityID - READ-ONLY; The session entity id in which the process was running
	HostLogonSessionEntityID *string `json:"hostLogonSessionEntityId,omitempty"`
	// ImageFileEntityID - READ-ONLY; Image file entity id
	ImageFileEntityID *string `json:"imageFileEntityId,omitempty"`
	// ParentProcessEntityID - READ-ONLY; The parent process entity id.
	ParentProcessEntityID *string `json:"parentProcessEntityId,omitempty"`
	// ProcessID - READ-ONLY; The process ID
	ProcessID *string `json:"processId,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessEntityProperties.
func (pep ProcessEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pep.ElevationToken != "" {
		objectMap["elevationToken"] = pep.ElevationToken
	}
	return json.Marshal(objectMap)
}

// RegistryKeyEntity represents a registry key entity.
type RegistryKeyEntity struct {
	// RegistryKeyEntityProperties - RegistryKey entity properties
	*RegistryKeyEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryKeyEntity.
func (rke RegistryKeyEntity) MarshalJSON() ([]byte, error) {
	rke.Kind = KindRegistryKey
	objectMap := make(map[string]interface{})
	if rke.RegistryKeyEntityProperties != nil {
		objectMap["properties"] = rke.RegistryKeyEntityProperties
	}
	if rke.Kind != "" {
		objectMap["kind"] = rke.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return &rke, true
}

// AsRegistryValueEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsBasicEntity() (BasicEntity, bool) {
	return &rke, true
}

// UnmarshalJSON is the custom unmarshaler for RegistryKeyEntity struct.
func (rke *RegistryKeyEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registryKeyEntityProperties RegistryKeyEntityProperties
				err = json.Unmarshal(*v, &registryKeyEntityProperties)
				if err != nil {
					return err
				}
				rke.RegistryKeyEntityProperties = &registryKeyEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rke.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rke.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rke.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rke.Kind = kind
			}
		}
	}

	return nil
}

// RegistryKeyEntityProperties registryKey entity property bag.
type RegistryKeyEntityProperties struct {
	// Hive - READ-ONLY; the hive that holds the registry key. Possible values include: 'HKEYLOCALMACHINE', 'HKEYCLASSESROOT', 'HKEYCURRENTCONFIG', 'HKEYUSERS', 'HKEYCURRENTUSERLOCALSETTINGS', 'HKEYPERFORMANCEDATA', 'HKEYPERFORMANCENLSTEXT', 'HKEYPERFORMANCETEXT', 'HKEYA', 'HKEYCURRENTUSER'
	Hive RegistryHive `json:"hive,omitempty"`
	// Key - READ-ONLY; The registry key path.
	Key *string `json:"key,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryKeyEntityProperties.
func (rkep RegistryKeyEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RegistryValueEntity represents a registry value entity.
type RegistryValueEntity struct {
	// RegistryValueEntityProperties - RegistryKey entity properties
	*RegistryValueEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryValueEntity.
func (rve RegistryValueEntity) MarshalJSON() ([]byte, error) {
	rve.Kind = KindRegistryValue
	objectMap := make(map[string]interface{})
	if rve.RegistryValueEntityProperties != nil {
		objectMap["properties"] = rve.RegistryValueEntityProperties
	}
	if rve.Kind != "" {
		objectMap["kind"] = rve.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return &rve, true
}

// AsSecurityAlert is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsBasicEntity() (BasicEntity, bool) {
	return &rve, true
}

// UnmarshalJSON is the custom unmarshaler for RegistryValueEntity struct.
func (rve *RegistryValueEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registryValueEntityProperties RegistryValueEntityProperties
				err = json.Unmarshal(*v, &registryValueEntityProperties)
				if err != nil {
					return err
				}
				rve.RegistryValueEntityProperties = &registryValueEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rve.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rve.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rve.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rve.Kind = kind
			}
		}
	}

	return nil
}

// RegistryValueEntityProperties registryValue entity property bag.
type RegistryValueEntityProperties struct {
	// KeyEntityID - READ-ONLY; The registry key entity id.
	KeyEntityID *string `json:"keyEntityId,omitempty"`
	// ValueData - READ-ONLY; String formatted representation of the value data.
	ValueData *string `json:"valueData,omitempty"`
	// ValueName - READ-ONLY; The registry value name.
	ValueName *string `json:"valueName,omitempty"`
	// ValueType - READ-ONLY; Specifies the data types to use when storing values in the registry, or identifies the data type of a value in the registry. Possible values include: 'RegistryValueKindNone', 'RegistryValueKindUnknown', 'RegistryValueKindString', 'RegistryValueKindExpandString', 'RegistryValueKindBinary', 'RegistryValueKindDWord', 'RegistryValueKindMultiString', 'RegistryValueKindQWord'
	ValueType RegistryValueKind `json:"valueType,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryValueEntityProperties.
func (rvep RegistryValueEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Relation represents a relation between two resources
type Relation struct {
	autorest.Response `json:"-"`
	// RelationProperties - Relation properties
	*RelationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Relation.
func (r Relation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RelationProperties != nil {
		objectMap["properties"] = r.RelationProperties
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Relation struct.
func (r *Relation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relationProperties RelationProperties
				err = json.Unmarshal(*v, &relationProperties)
				if err != nil {
					return err
				}
				r.RelationProperties = &relationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		}
	}

	return nil
}

// RelationBase represents a relation
type RelationBase struct {
	// Kind - READ-ONLY; The type of relation node. Possible values include: 'CasesToBookmarks'
	Kind RelationTypes `json:"kind,omitempty"`
	// Etag - ETag for relation
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// RelationList list of relations.
type RelationList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of relations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of relations.
	Value *[]Relation `json:"value,omitempty"`
}

// RelationListIterator provides access to a complete listing of Relation values.
type RelationListIterator struct {
	i    int
	page RelationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RelationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RelationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RelationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RelationListIterator) Response() RelationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RelationListIterator) Value() Relation {
	if !iter.page.NotDone() {
		return Relation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RelationListIterator type.
func NewRelationListIterator(page RelationListPage) RelationListIterator {
	return RelationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rl RelationList) IsEmpty() bool {
	return rl.Value == nil || len(*rl.Value) == 0
}

// relationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rl RelationList) relationListPreparer(ctx context.Context) (*http.Request, error) {
	if rl.NextLink == nil || len(to.String(rl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rl.NextLink)))
}

// RelationListPage contains a page of Relation values.
type RelationListPage struct {
	fn func(context.Context, RelationList) (RelationList, error)
	rl RelationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RelationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rl)
	if err != nil {
		return err
	}
	page.rl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RelationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RelationListPage) NotDone() bool {
	return !page.rl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RelationListPage) Response() RelationList {
	return page.rl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RelationListPage) Values() []Relation {
	if page.rl.IsEmpty() {
		return nil
	}
	return *page.rl.Value
}

// Creates a new instance of the RelationListPage type.
func NewRelationListPage(getNextPage func(context.Context, RelationList) (RelationList, error)) RelationListPage {
	return RelationListPage{fn: getNextPage}
}

// RelationNode relation node
type RelationNode struct {
	// RelationNodeID - Relation Node Id
	RelationNodeID *string `json:"relationNodeId,omitempty"`
	// RelationNodeKind - READ-ONLY; The type of relation node. Possible values include: 'RelationNodeKindCase', 'RelationNodeKindBookmark'
	RelationNodeKind RelationNodeKind `json:"relationNodeKind,omitempty"`
	// Etag - Etag for relation node
	Etag *string `json:"etag,omitempty"`
	// RelationAdditionalProperties - Additional set of properties
	RelationAdditionalProperties map[string]*string `json:"relationAdditionalProperties"`
}

// MarshalJSON is the custom marshaler for RelationNode.
func (rn RelationNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rn.RelationNodeID != nil {
		objectMap["relationNodeId"] = rn.RelationNodeID
	}
	if rn.Etag != nil {
		objectMap["etag"] = rn.Etag
	}
	if rn.RelationAdditionalProperties != nil {
		objectMap["relationAdditionalProperties"] = rn.RelationAdditionalProperties
	}
	return json.Marshal(objectMap)
}

// RelationProperties relation property bag.
type RelationProperties struct {
	// RelatedResourceID - The resource ID of the related resource
	RelatedResourceID *string `json:"relatedResourceId,omitempty"`
	// RelatedResourceName - READ-ONLY; The name of the related resource
	RelatedResourceName *string `json:"relatedResourceName,omitempty"`
	// RelatedResourceType - READ-ONLY; The resource type of the related resource
	RelatedResourceType *string `json:"relatedResourceType,omitempty"`
	// RelatedResourceKind - READ-ONLY; The resource kind of the related resource
	RelatedResourceKind *string `json:"relatedResourceKind,omitempty"`
}

// RelationsModelInput relation input model
type RelationsModelInput struct {
	// RelationsModelInputProperties - Relation input properties
	*RelationsModelInputProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; The type of relation node. Possible values include: 'CasesToBookmarks'
	Kind RelationTypes `json:"kind,omitempty"`
	// Etag - ETag for relation
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationsModelInput.
func (rmi RelationsModelInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmi.RelationsModelInputProperties != nil {
		objectMap["properties"] = rmi.RelationsModelInputProperties
	}
	if rmi.Etag != nil {
		objectMap["etag"] = rmi.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RelationsModelInput struct.
func (rmi *RelationsModelInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relationsModelInputProperties RelationsModelInputProperties
				err = json.Unmarshal(*v, &relationsModelInputProperties)
				if err != nil {
					return err
				}
				rmi.RelationsModelInputProperties = &relationsModelInputProperties
			}
		case "kind":
			if v != nil {
				var kind RelationTypes
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rmi.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rmi.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmi.Type = &typeVar
			}
		}
	}

	return nil
}

// RelationsModelInputProperties relation input properties
type RelationsModelInputProperties struct {
	// RelationName - Name of relation
	RelationName *string `json:"relationName,omitempty"`
	// SourceRelationNode - Relation source node
	SourceRelationNode *RelationNode `json:"sourceRelationNode,omitempty"`
	// TargetRelationNode - Relation target node
	TargetRelationNode *RelationNode `json:"targetRelationNode,omitempty"`
}

// Resource an azure resource object
type Resource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// ResourceWithEtag an azure resource object with an Etag property
type ResourceWithEtag struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// ScheduledAlertRule represents scheduled alert rule.
type ScheduledAlertRule struct {
	// ScheduledAlertRuleProperties - Scheduled alert rule properties
	*ScheduledAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindAlertRule', 'KindFusion', 'KindMicrosoftSecurityIncidentCreation', 'KindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRule.
func (sar ScheduledAlertRule) MarshalJSON() ([]byte, error) {
	sar.Kind = KindScheduled
	objectMap := make(map[string]interface{})
	if sar.ScheduledAlertRuleProperties != nil {
		objectMap["properties"] = sar.ScheduledAlertRuleProperties
	}
	if sar.Etag != nil {
		objectMap["etag"] = sar.Etag
	}
	if sar.Kind != "" {
		objectMap["kind"] = sar.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return &sar, true
}

// AsAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &sar, true
}

// UnmarshalJSON is the custom unmarshaler for ScheduledAlertRule struct.
func (sar *ScheduledAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduledAlertRuleProperties ScheduledAlertRuleProperties
				err = json.Unmarshal(*v, &scheduledAlertRuleProperties)
				if err != nil {
					return err
				}
				sar.ScheduledAlertRuleProperties = &scheduledAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sar.Kind = kind
			}
		}
	}

	return nil
}

// ScheduledAlertRuleCommonProperties schedule alert rule template property bag.
type ScheduledAlertRuleCommonProperties struct {
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'High', 'Medium', 'Low', 'Informational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'GreaterThan', 'LessThan', 'Equal', 'NotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
}

// ScheduledAlertRuleProperties scheduled alert rule base property bag.
type ScheduledAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert rule has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// SuppressionDuration - The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
	SuppressionDuration *string `json:"suppressionDuration,omitempty"`
	// SuppressionEnabled - Determines whether the suppression for this alert rule is enabled or disabled.
	SuppressionEnabled *bool `json:"suppressionEnabled,omitempty"`
	// Tactics - The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// IncidentConfiguration - The settings of the incidents that created from alerts triggered by this analytics rule
	IncidentConfiguration *IncidentConfiguration `json:"incidentConfiguration,omitempty"`
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'High', 'Medium', 'Low', 'Informational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'GreaterThan', 'LessThan', 'Equal', 'NotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
}

// ScheduledAlertRuleTemplate represents scheduled alert rule template.
type ScheduledAlertRuleTemplate struct {
	// ScheduledAlertRuleTemplateProperties - Scheduled alert rule template properties
	*ScheduledAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	sart.Kind = KindBasicAlertRuleTemplateKindScheduled
	objectMap := make(map[string]interface{})
	if sart.ScheduledAlertRuleTemplateProperties != nil {
		objectMap["properties"] = sart.ScheduledAlertRuleTemplateProperties
	}
	if sart.Kind != "" {
		objectMap["kind"] = sart.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return &sart, true
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &sart, true
}

// UnmarshalJSON is the custom unmarshaler for ScheduledAlertRuleTemplate struct.
func (sart *ScheduledAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduledAlertRuleTemplateProperties ScheduledAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &scheduledAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				sart.ScheduledAlertRuleTemplateProperties = &scheduledAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sart.Kind = kind
			}
		}
	}

	return nil
}

// ScheduledAlertRuleTemplateProperties scheduled alert rule template properties
type ScheduledAlertRuleTemplateProperties struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'Installed', 'Available', 'NotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'High', 'Medium', 'Low', 'Informational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'GreaterThan', 'LessThan', 'Equal', 'NotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
	// Tactics - The tactics of the alert rule template
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// SecurityAlert represents a security alert entity.
type SecurityAlert struct {
	// SecurityAlertProperties - SecurityAlert entity properties
	*SecurityAlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlert.
func (sa SecurityAlert) MarshalJSON() ([]byte, error) {
	sa.Kind = KindSecurityAlert
	objectMap := make(map[string]interface{})
	if sa.SecurityAlertProperties != nil {
		objectMap["properties"] = sa.SecurityAlertProperties
	}
	if sa.Kind != "" {
		objectMap["kind"] = sa.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsSecurityAlert() (*SecurityAlert, bool) {
	return &sa, true
}

// AsSecurityGroupEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsBasicEntity() (BasicEntity, bool) {
	return &sa, true
}

// UnmarshalJSON is the custom unmarshaler for SecurityAlert struct.
func (sa *SecurityAlert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertProperties SecurityAlertProperties
				err = json.Unmarshal(*v, &securityAlertProperties)
				if err != nil {
					return err
				}
				sa.SecurityAlertProperties = &securityAlertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sa.Kind = kind
			}
		}
	}

	return nil
}

// SecurityAlertProperties securityAlert entity property bag.
type SecurityAlertProperties struct {
	// AlertDisplayName - READ-ONLY; The display name of the alert.
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// AlertType - READ-ONLY; The type name of the alert.
	AlertType *string `json:"alertType,omitempty"`
	// CompromisedEntity - READ-ONLY; Display name of the main entity being reported on.
	CompromisedEntity *string `json:"compromisedEntity,omitempty"`
	// ConfidenceLevel - READ-ONLY; The confidence level of this alert. Possible values include: 'ConfidenceLevelUnknown', 'ConfidenceLevelLow', 'ConfidenceLevelHigh'
	ConfidenceLevel ConfidenceLevel `json:"confidenceLevel,omitempty"`
	// ConfidenceReasons - READ-ONLY; The confidence reasons
	ConfidenceReasons *[]SecurityAlertPropertiesConfidenceReasonsItem `json:"confidenceReasons,omitempty"`
	// ConfidenceScore - READ-ONLY; The confidence score of the alert.
	ConfidenceScore *float64 `json:"confidenceScore,omitempty"`
	// ConfidenceScoreStatus - READ-ONLY; The confidence score calculation status, i.e. indicating if score calculation is pending for this alert, not applicable or final. Possible values include: 'NotApplicable', 'InProcess', 'NotFinal', 'Final'
	ConfidenceScoreStatus ConfidenceScoreStatus `json:"confidenceScoreStatus,omitempty"`
	// Description - READ-ONLY; Alert description.
	Description *string `json:"description,omitempty"`
	// EndTimeUtc - READ-ONLY; The impact end time of the alert (the time of the last event contributing to the alert).
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Intent - READ-ONLY; Holds the alert intent stage(s) mapping for this alert. Possible values include: 'KillChainIntentUnknown', 'KillChainIntentProbing', 'KillChainIntentExploitation', 'KillChainIntentPersistence', 'KillChainIntentPrivilegeEscalation', 'KillChainIntentDefenseEvasion', 'KillChainIntentCredentialAccess', 'KillChainIntentDiscovery', 'KillChainIntentLateralMovement', 'KillChainIntentExecution', 'KillChainIntentCollection', 'KillChainIntentExfiltration', 'KillChainIntentCommandAndControl', 'KillChainIntentImpact'
	Intent KillChainIntent `json:"intent,omitempty"`
	// ProviderAlertID - READ-ONLY; The identifier of the alert inside the product which generated the alert.
	ProviderAlertID *string `json:"providerAlertId,omitempty"`
	// ProcessingEndTime - READ-ONLY; The time the alert was made available for consumption.
	ProcessingEndTime *date.Time `json:"processingEndTime,omitempty"`
	// ProductComponentName - READ-ONLY; The name of a component inside the product which generated the alert.
	ProductComponentName *string `json:"productComponentName,omitempty"`
	// ProductName - READ-ONLY; The name of the product which published this alert.
	ProductName *string `json:"productName,omitempty"`
	// ProductVersion - READ-ONLY; The version of the product generating the alert.
	ProductVersion *string `json:"productVersion,omitempty"`
	// RemediationSteps - READ-ONLY; Manual action items to take to remediate the alert.
	RemediationSteps *[]string `json:"remediationSteps,omitempty"`
	// Severity - The severity of the alert. Possible values include: 'High', 'Medium', 'Low', 'Informational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// StartTimeUtc - READ-ONLY; The impact start time of the alert (the time of the first event contributing to the alert).
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Status - READ-ONLY; The lifecycle status of the alert. Possible values include: 'AlertStatusUnknown', 'AlertStatusNew', 'AlertStatusResolved', 'AlertStatusDismissed', 'AlertStatusInProgress'
	Status AlertStatus `json:"status,omitempty"`
	// SystemAlertID - READ-ONLY; Holds the product identifier of the alert for the product.
	SystemAlertID *string `json:"systemAlertId,omitempty"`
	// Tactics - READ-ONLY; The tactics of the alert
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// TimeGenerated - READ-ONLY; The time the alert was generated.
	TimeGenerated *date.Time `json:"timeGenerated,omitempty"`
	// VendorName - READ-ONLY; The name of the vendor that raise the alert.
	VendorName *string `json:"vendorName,omitempty"`
	// AlertLink - READ-ONLY; The uri link of the alert.
	AlertLink *string `json:"alertLink,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlertProperties.
func (sap SecurityAlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.Severity != "" {
		objectMap["severity"] = sap.Severity
	}
	return json.Marshal(objectMap)
}

// SecurityAlertPropertiesConfidenceReasonsItem confidence reason item
type SecurityAlertPropertiesConfidenceReasonsItem struct {
	// Reason - READ-ONLY; The reason's description
	Reason *string `json:"reason,omitempty"`
	// ReasonType - READ-ONLY; The type (category) of the reason
	ReasonType *string `json:"reasonType,omitempty"`
}

// SecurityGroupEntity represents a security group entity.
type SecurityGroupEntity struct {
	// SecurityGroupEntityProperties - SecurityGroup entity properties
	*SecurityGroupEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityGroupEntity.
func (sge SecurityGroupEntity) MarshalJSON() ([]byte, error) {
	sge.Kind = KindSecurityGroup
	objectMap := make(map[string]interface{})
	if sge.SecurityGroupEntityProperties != nil {
		objectMap["properties"] = sge.SecurityGroupEntityProperties
	}
	if sge.Kind != "" {
		objectMap["kind"] = sge.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return &sge, true
}

// AsURLEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsBasicEntity() (BasicEntity, bool) {
	return &sge, true
}

// UnmarshalJSON is the custom unmarshaler for SecurityGroupEntity struct.
func (sge *SecurityGroupEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityGroupEntityProperties SecurityGroupEntityProperties
				err = json.Unmarshal(*v, &securityGroupEntityProperties)
				if err != nil {
					return err
				}
				sge.SecurityGroupEntityProperties = &securityGroupEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sge.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sge.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sge.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sge.Kind = kind
			}
		}
	}

	return nil
}

// SecurityGroupEntityProperties securityGroup entity property bag.
type SecurityGroupEntityProperties struct {
	// DistinguishedName - READ-ONLY; The group distinguished name
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// ObjectGUID - READ-ONLY; A single-value attribute that is the unique identifier for the object, assigned by active directory.
	ObjectGUID *uuid.UUID `json:"objectGuid,omitempty"`
	// Sid - READ-ONLY; The SID attribute is a single-value attribute that specifies the security identifier (SID) of the group
	Sid *string `json:"sid,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityGroupEntityProperties.
func (sgep SecurityGroupEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SettingList list of all the settings.
type SettingList struct {
	autorest.Response `json:"-"`
	// Value - Array of settings.
	Value *[]BasicSettings `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SettingList struct.
func (sl *SettingList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicSettingsArray(*v)
				if err != nil {
					return err
				}
				sl.Value = &value
			}
		}
	}

	return nil
}

// BasicSettings the Setting.
type BasicSettings interface {
	AsEyesOn() (*EyesOn, bool)
	AsSettings() (*Settings, bool)
}

// Settings the Setting.
type Settings struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindSettings', 'KindEyesOn'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

func unmarshalBasicSettings(body []byte) (BasicSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindEyesOn):
		var eo EyesOn
		err := json.Unmarshal(body, &eo)
		return eo, err
	default:
		var s Settings
		err := json.Unmarshal(body, &s)
		return s, err
	}
}
func unmarshalBasicSettingsArray(body []byte) ([]BasicSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]BasicSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalBasicSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// MarshalJSON is the custom marshaler for Settings.
func (s Settings) MarshalJSON() ([]byte, error) {
	s.Kind = KindSettings
	objectMap := make(map[string]interface{})
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.Kind != "" {
		objectMap["kind"] = s.Kind
	}
	return json.Marshal(objectMap)
}

// AsEyesOn is the BasicSettings implementation for Settings.
func (s Settings) AsEyesOn() (*EyesOn, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for Settings.
func (s Settings) AsSettings() (*Settings, bool) {
	return &s, true
}

// AsBasicSettings is the BasicSettings implementation for Settings.
func (s Settings) AsBasicSettings() (BasicSettings, bool) {
	return &s, true
}

// SettingsKind describes an Azure resource with kind.
type SettingsKind struct {
	// Kind - The kind of the setting
	Kind *string `json:"kind,omitempty"`
}

// SettingsModel ...
type SettingsModel struct {
	autorest.Response `json:"-"`
	Value             BasicSettings `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SettingsModel struct.
func (sm *SettingsModel) UnmarshalJSON(body []byte) error {
	s, err := unmarshalBasicSettings(body)
	if err != nil {
		return err
	}
	sm.Value = s

	return nil
}

// ThreatIntelligence threatIntelligence property bag.
type ThreatIntelligence struct {
	// Confidence - READ-ONLY; Confidence (must be between 0 and 1)
	Confidence *float64 `json:"confidence,omitempty"`
	// ProviderName - READ-ONLY; Name of the provider from whom this Threat Intelligence information was received
	ProviderName *string `json:"providerName,omitempty"`
	// ReportLink - READ-ONLY; Report link
	ReportLink *string `json:"reportLink,omitempty"`
	// ThreatDescription - READ-ONLY; Threat description (free text)
	ThreatDescription *string `json:"threatDescription,omitempty"`
	// ThreatName - READ-ONLY; Threat name (e.g. "Jedobot malware")
	ThreatName *string `json:"threatName,omitempty"`
	// ThreatType - READ-ONLY; Threat type (e.g. "Botnet")
	ThreatType *string `json:"threatType,omitempty"`
}

// TICheckRequirements represents threat intelligence requirements check request.
type TICheckRequirements struct {
	// TICheckRequirementsProperties - TI (Threat Intelligence) requirements check properties.
	*TICheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TICheckRequirements.
func (tcr TICheckRequirements) MarshalJSON() ([]byte, error) {
	tcr.Kind = KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tcr.TICheckRequirementsProperties != nil {
		objectMap["properties"] = tcr.TICheckRequirementsProperties
	}
	if tcr.Kind != "" {
		objectMap["kind"] = tcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return &tcr, true
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &tcr, true
}

// UnmarshalJSON is the custom unmarshaler for TICheckRequirements struct.
func (tcr *TICheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tICheckRequirementsProperties TICheckRequirementsProperties
				err = json.Unmarshal(*v, &tICheckRequirementsProperties)
				if err != nil {
					return err
				}
				tcr.TICheckRequirementsProperties = &tICheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tcr.Kind = kind
			}
		}
	}

	return nil
}

// TICheckRequirementsProperties TI (Threat Intelligence) requirements check properties.
type TICheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// TIDataConnector represents threat intelligence data connector.
type TIDataConnector struct {
	// TIDataConnectorProperties - TI (Threat Intelligence) data connector properties.
	*TIDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TIDataConnector.
func (tdc TIDataConnector) MarshalJSON() ([]byte, error) {
	tdc.Kind = KindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tdc.TIDataConnectorProperties != nil {
		objectMap["properties"] = tdc.TIDataConnectorProperties
	}
	if tdc.Etag != nil {
		objectMap["etag"] = tdc.Etag
	}
	if tdc.Kind != "" {
		objectMap["kind"] = tdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return &tdc, true
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &tdc, true
}

// UnmarshalJSON is the custom unmarshaler for TIDataConnector struct.
func (tdc *TIDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tIDataConnectorProperties TIDataConnectorProperties
				err = json.Unmarshal(*v, &tIDataConnectorProperties)
				if err != nil {
					return err
				}
				tdc.TIDataConnectorProperties = &tIDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				tdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tdc.Kind = kind
			}
		}
	}

	return nil
}

// TIDataConnectorDataTypes the available data types for TI (Threat Intelligence) data connector.
type TIDataConnectorDataTypes struct {
	// Indicators - Data type for indicators connection.
	Indicators *TIDataConnectorDataTypesIndicators `json:"indicators,omitempty"`
}

// TIDataConnectorDataTypesIndicators data type for indicators connection.
type TIDataConnectorDataTypesIndicators struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// TIDataConnectorProperties TI (Threat Intelligence) data connector properties.
type TIDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *TIDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// TiTaxiiCheckRequirements represents threat intelligence requirements check request.
type TiTaxiiCheckRequirements struct {
	// TiTaxiiCheckRequirementsProperties - Ti Taxii (Threat Intelligence Taxii) requirements check properties.
	*TiTaxiiCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) MarshalJSON() ([]byte, error) {
	ttcr.Kind = KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii
	objectMap := make(map[string]interface{})
	if ttcr.TiTaxiiCheckRequirementsProperties != nil {
		objectMap["properties"] = ttcr.TiTaxiiCheckRequirementsProperties
	}
	if ttcr.Kind != "" {
		objectMap["kind"] = ttcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return &ttcr, true
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &ttcr, true
}

// UnmarshalJSON is the custom unmarshaler for TiTaxiiCheckRequirements struct.
func (ttcr *TiTaxiiCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tiTaxiiCheckRequirementsProperties TiTaxiiCheckRequirementsProperties
				err = json.Unmarshal(*v, &tiTaxiiCheckRequirementsProperties)
				if err != nil {
					return err
				}
				ttcr.TiTaxiiCheckRequirementsProperties = &tiTaxiiCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ttcr.Kind = kind
			}
		}
	}

	return nil
}

// TiTaxiiCheckRequirementsProperties threat Intelligence taxii client data connector properties.
type TiTaxiiCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// TiTaxiiDataConnector represents threat intelligence taxii data connector.
type TiTaxiiDataConnector struct {
	// TiTaxiiDataConnectorProperties - Threat intelligence taxii client data connector properties.
	*TiTaxiiDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindAzureActiveDirectory', 'KindAzureAdvancedThreatProtection', 'KindAzureSecurityCenter', 'KindAmazonWebServicesCloudTrail', 'KindMicrosoftCloudAppSecurity', 'KindMicrosoftDefenderAdvancedThreatProtection', 'KindOffice365', 'KindThreatIntelligence', 'KindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) MarshalJSON() ([]byte, error) {
	ttdc.Kind = KindThreatIntelligenceTaxii
	objectMap := make(map[string]interface{})
	if ttdc.TiTaxiiDataConnectorProperties != nil {
		objectMap["properties"] = ttdc.TiTaxiiDataConnectorProperties
	}
	if ttdc.Etag != nil {
		objectMap["etag"] = ttdc.Etag
	}
	if ttdc.Kind != "" {
		objectMap["kind"] = ttdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return &ttdc, true
}

// AsDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &ttdc, true
}

// UnmarshalJSON is the custom unmarshaler for TiTaxiiDataConnector struct.
func (ttdc *TiTaxiiDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tiTaxiiDataConnectorProperties TiTaxiiDataConnectorProperties
				err = json.Unmarshal(*v, &tiTaxiiDataConnectorProperties)
				if err != nil {
					return err
				}
				ttdc.TiTaxiiDataConnectorProperties = &tiTaxiiDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ttdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ttdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ttdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ttdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ttdc.Kind = kind
			}
		}
	}

	return nil
}

// TiTaxiiDataConnectorDataTypes the available data types for Threat Intelligence taxii client data
// connector.
type TiTaxiiDataConnectorDataTypes struct {
	// TaxiiClient - Data type for taxii client.
	TaxiiClient *TiTaxiiDataConnectorDataTypesTaxiiClient `json:"taxiiClient,omitempty"`
}

// TiTaxiiDataConnectorDataTypesTaxiiClient data type for taxii client.
type TiTaxiiDataConnectorDataTypesTaxiiClient struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// TiTaxiiDataConnectorProperties threat Intelligence taxii client data connector properties.
type TiTaxiiDataConnectorProperties struct {
	// WorkspaceID - The workspace id.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// FriendlyName - The friendly name for taxii client connector.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// TaxiiServer - The API root server for taxii client.
	TaxiiServer *string `json:"taxiiServer,omitempty"`
	// CollectionID - The taxii collection id.
	CollectionID *string `json:"collectionId,omitempty"`
	// UserName - The taxii server user name.
	UserName *string `json:"userName,omitempty"`
	// Password - The taxii server password.
	Password *string `json:"password,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *TiTaxiiDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// URLEntity represents a url entity.
type URLEntity struct {
	// URLEntityProperties - Url entity properties
	*URLEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindAzureResource', 'KindCloudApplication', 'KindDNSResolution', 'KindFile', 'KindFileHash', 'KindHost', 'KindIP', 'KindMalware', 'KindProcess', 'KindRegistryKey', 'KindRegistryValue', 'KindSecurityAlert', 'KindSecurityGroup', 'KindURL', 'KindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for URLEntity.
func (ue URLEntity) MarshalJSON() ([]byte, error) {
	ue.Kind = KindURL
	objectMap := make(map[string]interface{})
	if ue.URLEntityProperties != nil {
		objectMap["properties"] = ue.URLEntityProperties
	}
	if ue.Kind != "" {
		objectMap["kind"] = ue.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsURLEntity() (*URLEntity, bool) {
	return &ue, true
}

// AsIoTDeviceEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsBasicEntity() (BasicEntity, bool) {
	return &ue, true
}

// UnmarshalJSON is the custom unmarshaler for URLEntity struct.
func (ue *URLEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var URLEntityProperties URLEntityProperties
				err = json.Unmarshal(*v, &URLEntityProperties)
				if err != nil {
					return err
				}
				ue.URLEntityProperties = &URLEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ue.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ue.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ue.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ue.Kind = kind
			}
		}
	}

	return nil
}

// URLEntityProperties url entity property bag.
type URLEntityProperties struct {
	// URL - READ-ONLY; A full URL the entity points to
	URL *string `json:"url,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for URLEntityProperties.
func (uep URLEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserInfo user information that made some action
type UserInfo struct {
	// Email - READ-ONLY; The email of the user.
	Email *string `json:"email,omitempty"`
	// Name - READ-ONLY; The name of the user.
	Name *string `json:"name,omitempty"`
	// ObjectID - The object id of the user.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
}
