package siterecovery

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ReplicationRecoveryPlansClient is the client for the ReplicationRecoveryPlans methods of the Siterecovery service.
type ReplicationRecoveryPlansClient struct {
	BaseClient
}

// NewReplicationRecoveryPlansClient creates an instance of the ReplicationRecoveryPlansClient client.
func NewReplicationRecoveryPlansClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryPlansClient {
	return NewReplicationRecoveryPlansClientWithBaseURI(DefaultBaseURI, subscriptionID, resourceGroupName, resourceName)
}

// NewReplicationRecoveryPlansClientWithBaseURI creates an instance of the ReplicationRecoveryPlansClient client using
// a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewReplicationRecoveryPlansClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryPlansClient {
	return ReplicationRecoveryPlansClient{NewWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)}
}

// Create the operation to create a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
// input - recovery Plan creation input.
func (client ReplicationRecoveryPlansClient) Create(ctx context.Context, recoveryPlanName string, input CreateRecoveryPlanInput) (result ReplicationRecoveryPlansCreateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.Create")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: input,
			Constraints: []validation.Constraint{{Target: "input.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "input.Properties.PrimaryFabricID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "input.Properties.RecoveryFabricID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "input.Properties.Groups", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationRecoveryPlansClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, recoveryPlanName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Create", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client ReplicationRecoveryPlansClient) CreatePreparer(ctx context.Context, recoveryPlanName string, input CreateRecoveryPlanInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) CreateSender(req *http.Request) (future ReplicationRecoveryPlansCreateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) CreateResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
func (client ReplicationRecoveryPlansClient) Delete(ctx context.Context, recoveryPlanName string) (result ReplicationRecoveryPlansDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, recoveryPlanName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ReplicationRecoveryPlansClient) DeletePreparer(ctx context.Context, recoveryPlanName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) DeleteSender(req *http.Request) (future ReplicationRecoveryPlansDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// FailoverCommit the operation to commit the fail over of a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
func (client ReplicationRecoveryPlansClient) FailoverCommit(ctx context.Context, recoveryPlanName string) (result ReplicationRecoveryPlansFailoverCommitFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.FailoverCommit")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.FailoverCommitPreparer(ctx, recoveryPlanName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "FailoverCommit", nil, "Failure preparing request")
		return
	}

	result, err = client.FailoverCommitSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "FailoverCommit", result.Response(), "Failure sending request")
		return
	}

	return
}

// FailoverCommitPreparer prepares the FailoverCommit request.
func (client ReplicationRecoveryPlansClient) FailoverCommitPreparer(ctx context.Context, recoveryPlanName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/failoverCommit", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// FailoverCommitSender sends the FailoverCommit request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) FailoverCommitSender(req *http.Request) (future ReplicationRecoveryPlansFailoverCommitFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// FailoverCommitResponder handles the response to the FailoverCommit request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) FailoverCommitResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets the details of the recovery plan.
// Parameters:
// recoveryPlanName - name of the recovery plan.
func (client ReplicationRecoveryPlansClient) Get(ctx context.Context, recoveryPlanName string) (result RecoveryPlan, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, recoveryPlanName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReplicationRecoveryPlansClient) GetPreparer(ctx context.Context, recoveryPlanName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) GetResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists the recovery plans in the vault.
func (client ReplicationRecoveryPlansClient) List(ctx context.Context) (result RecoveryPlanCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.List")
		defer func() {
			sc := -1
			if result.RPCVar.Response.Response != nil {
				sc = result.RPCVar.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.RPCVar.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "List", resp, "Failure sending request")
		return
	}

	result.RPCVar, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ReplicationRecoveryPlansClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) ListResponder(resp *http.Response) (result RecoveryPlanCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ReplicationRecoveryPlansClient) listNextResults(ctx context.Context, lastResults RecoveryPlanCollection) (result RecoveryPlanCollection, err error) {
	req, err := lastResults.recoveryPlanCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReplicationRecoveryPlansClient) ListComplete(ctx context.Context) (result RecoveryPlanCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// PlannedFailover the operation to start the planned failover of a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
// input - failover input.
func (client ReplicationRecoveryPlansClient) PlannedFailover(ctx context.Context, recoveryPlanName string, input RecoveryPlanPlannedFailoverInput) (result ReplicationRecoveryPlansPlannedFailoverFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.PlannedFailover")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: input,
			Constraints: []validation.Constraint{{Target: "input.Properties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationRecoveryPlansClient", "PlannedFailover", err.Error())
	}

	req, err := client.PlannedFailoverPreparer(ctx, recoveryPlanName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "PlannedFailover", nil, "Failure preparing request")
		return
	}

	result, err = client.PlannedFailoverSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "PlannedFailover", result.Response(), "Failure sending request")
		return
	}

	return
}

// PlannedFailoverPreparer prepares the PlannedFailover request.
func (client ReplicationRecoveryPlansClient) PlannedFailoverPreparer(ctx context.Context, recoveryPlanName string, input RecoveryPlanPlannedFailoverInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/plannedFailover", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PlannedFailoverSender sends the PlannedFailover request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) PlannedFailoverSender(req *http.Request) (future ReplicationRecoveryPlansPlannedFailoverFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// PlannedFailoverResponder handles the response to the PlannedFailover request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) PlannedFailoverResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Reprotect the operation to reprotect(reverse replicate) a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
func (client ReplicationRecoveryPlansClient) Reprotect(ctx context.Context, recoveryPlanName string) (result ReplicationRecoveryPlansReprotectFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.Reprotect")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ReprotectPreparer(ctx, recoveryPlanName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Reprotect", nil, "Failure preparing request")
		return
	}

	result, err = client.ReprotectSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Reprotect", result.Response(), "Failure sending request")
		return
	}

	return
}

// ReprotectPreparer prepares the Reprotect request.
func (client ReplicationRecoveryPlansClient) ReprotectPreparer(ctx context.Context, recoveryPlanName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/reProtect", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReprotectSender sends the Reprotect request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) ReprotectSender(req *http.Request) (future ReplicationRecoveryPlansReprotectFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ReprotectResponder handles the response to the Reprotect request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) ReprotectResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestFailover the operation to start the test failover of a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
// input - failover input.
func (client ReplicationRecoveryPlansClient) TestFailover(ctx context.Context, recoveryPlanName string, input RecoveryPlanTestFailoverInput) (result ReplicationRecoveryPlansTestFailoverFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.TestFailover")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: input,
			Constraints: []validation.Constraint{{Target: "input.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "input.Properties.NetworkType", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationRecoveryPlansClient", "TestFailover", err.Error())
	}

	req, err := client.TestFailoverPreparer(ctx, recoveryPlanName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "TestFailover", nil, "Failure preparing request")
		return
	}

	result, err = client.TestFailoverSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "TestFailover", result.Response(), "Failure sending request")
		return
	}

	return
}

// TestFailoverPreparer prepares the TestFailover request.
func (client ReplicationRecoveryPlansClient) TestFailoverPreparer(ctx context.Context, recoveryPlanName string, input RecoveryPlanTestFailoverInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/testFailover", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestFailoverSender sends the TestFailover request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) TestFailoverSender(req *http.Request) (future ReplicationRecoveryPlansTestFailoverFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// TestFailoverResponder handles the response to the TestFailover request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) TestFailoverResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestFailoverCleanup the operation to cleanup test failover of a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
// input - test failover cleanup input.
func (client ReplicationRecoveryPlansClient) TestFailoverCleanup(ctx context.Context, recoveryPlanName string, input RecoveryPlanTestFailoverCleanupInput) (result ReplicationRecoveryPlansTestFailoverCleanupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.TestFailoverCleanup")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: input,
			Constraints: []validation.Constraint{{Target: "input.Properties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationRecoveryPlansClient", "TestFailoverCleanup", err.Error())
	}

	req, err := client.TestFailoverCleanupPreparer(ctx, recoveryPlanName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "TestFailoverCleanup", nil, "Failure preparing request")
		return
	}

	result, err = client.TestFailoverCleanupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "TestFailoverCleanup", result.Response(), "Failure sending request")
		return
	}

	return
}

// TestFailoverCleanupPreparer prepares the TestFailoverCleanup request.
func (client ReplicationRecoveryPlansClient) TestFailoverCleanupPreparer(ctx context.Context, recoveryPlanName string, input RecoveryPlanTestFailoverCleanupInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/testFailoverCleanup", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestFailoverCleanupSender sends the TestFailoverCleanup request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) TestFailoverCleanupSender(req *http.Request) (future ReplicationRecoveryPlansTestFailoverCleanupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// TestFailoverCleanupResponder handles the response to the TestFailoverCleanup request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) TestFailoverCleanupResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UnplannedFailover the operation to start the failover of a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
// input - failover input.
func (client ReplicationRecoveryPlansClient) UnplannedFailover(ctx context.Context, recoveryPlanName string, input RecoveryPlanUnplannedFailoverInput) (result ReplicationRecoveryPlansUnplannedFailoverFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.UnplannedFailover")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: input,
			Constraints: []validation.Constraint{{Target: "input.Properties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationRecoveryPlansClient", "UnplannedFailover", err.Error())
	}

	req, err := client.UnplannedFailoverPreparer(ctx, recoveryPlanName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "UnplannedFailover", nil, "Failure preparing request")
		return
	}

	result, err = client.UnplannedFailoverSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "UnplannedFailover", result.Response(), "Failure sending request")
		return
	}

	return
}

// UnplannedFailoverPreparer prepares the UnplannedFailover request.
func (client ReplicationRecoveryPlansClient) UnplannedFailoverPreparer(ctx context.Context, recoveryPlanName string, input RecoveryPlanUnplannedFailoverInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/unplannedFailover", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UnplannedFailoverSender sends the UnplannedFailover request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) UnplannedFailoverSender(req *http.Request) (future ReplicationRecoveryPlansUnplannedFailoverFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UnplannedFailoverResponder handles the response to the UnplannedFailover request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) UnplannedFailoverResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update the operation to update a recovery plan.
// Parameters:
// recoveryPlanName - recovery plan name.
// input - update recovery plan input
func (client ReplicationRecoveryPlansClient) Update(ctx context.Context, recoveryPlanName string, input UpdateRecoveryPlanInput) (result ReplicationRecoveryPlansUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationRecoveryPlansClient.Update")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, recoveryPlanName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ReplicationRecoveryPlansClient) UpdatePreparer(ctx context.Context, recoveryPlanName string, input UpdateRecoveryPlanInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"recoveryPlanName":  autorest.Encode("path", recoveryPlanName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationRecoveryPlansClient) UpdateSender(req *http.Request) (future ReplicationRecoveryPlansUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ReplicationRecoveryPlansClient) UpdateResponder(resp *http.Response) (result RecoveryPlan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
