// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchPutScheduledUpdateGroupActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more scheduled actions. The maximum number allowed is 50.
	//
	// ScheduledUpdateGroupActions is a required field
	ScheduledUpdateGroupActions []ScheduledUpdateGroupActionRequest `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutScheduledUpdateGroupActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutScheduledUpdateGroupActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchPutScheduledUpdateGroupActionInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.ScheduledUpdateGroupActions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduledUpdateGroupActions"))
	}
	if s.ScheduledUpdateGroupActions != nil {
		for i, v := range s.ScheduledUpdateGroupActions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScheduledUpdateGroupActions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchPutScheduledUpdateGroupActionOutput struct {
	_ struct{} `type:"structure"`

	// The names of the scheduled actions that could not be created or updated,
	// including an error message.
	FailedScheduledUpdateGroupActions []FailedScheduledUpdateGroupActionRequest `type:"list"`
}

// String returns the string representation
func (s BatchPutScheduledUpdateGroupActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchPutScheduledUpdateGroupAction = "BatchPutScheduledUpdateGroupAction"

// BatchPutScheduledUpdateGroupActionRequest returns a request value for making API operation for
// Auto Scaling.
//
// Creates or updates one or more scheduled scaling actions for an Auto Scaling
// group. If you leave a parameter unspecified when updating a scheduled scaling
// action, the corresponding value remains unchanged.
//
//    // Example sending a request using BatchPutScheduledUpdateGroupActionRequest.
//    req := client.BatchPutScheduledUpdateGroupActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction
func (c *Client) BatchPutScheduledUpdateGroupActionRequest(input *BatchPutScheduledUpdateGroupActionInput) BatchPutScheduledUpdateGroupActionRequest {
	op := &aws.Operation{
		Name:       opBatchPutScheduledUpdateGroupAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchPutScheduledUpdateGroupActionInput{}
	}

	req := c.newRequest(op, input, &BatchPutScheduledUpdateGroupActionOutput{})
	return BatchPutScheduledUpdateGroupActionRequest{Request: req, Input: input, Copy: c.BatchPutScheduledUpdateGroupActionRequest}
}

// BatchPutScheduledUpdateGroupActionRequest is the request type for the
// BatchPutScheduledUpdateGroupAction API operation.
type BatchPutScheduledUpdateGroupActionRequest struct {
	*aws.Request
	Input *BatchPutScheduledUpdateGroupActionInput
	Copy  func(*BatchPutScheduledUpdateGroupActionInput) BatchPutScheduledUpdateGroupActionRequest
}

// Send marshals and sends the BatchPutScheduledUpdateGroupAction API request.
func (r BatchPutScheduledUpdateGroupActionRequest) Send(ctx context.Context) (*BatchPutScheduledUpdateGroupActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchPutScheduledUpdateGroupActionResponse{
		BatchPutScheduledUpdateGroupActionOutput: r.Request.Data.(*BatchPutScheduledUpdateGroupActionOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchPutScheduledUpdateGroupActionResponse is the response type for the
// BatchPutScheduledUpdateGroupAction API operation.
type BatchPutScheduledUpdateGroupActionResponse struct {
	*BatchPutScheduledUpdateGroupActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchPutScheduledUpdateGroupAction request.
func (r *BatchPutScheduledUpdateGroupActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
