// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartMigrationInput struct {
	_ struct{} `type:"structure"`

	// List of endpoints from which data should be migrated. For Redis (cluster
	// mode disabled), list should have only one element.
	//
	// CustomerNodeEndpointList is a required field
	CustomerNodeEndpointList []CustomerNodeEndpoint `type:"list" required:"true"`

	// The ID of the replication group to which data should be migrated.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartMigrationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMigrationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartMigrationInput"}

	if s.CustomerNodeEndpointList == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomerNodeEndpointList"))
	}

	if s.ReplicationGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartMigrationOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s StartMigrationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartMigration = "StartMigration"

// StartMigrationRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Start the migration of data.
//
//    // Example sending a request using StartMigrationRequest.
//    req := client.StartMigrationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/StartMigration
func (c *Client) StartMigrationRequest(input *StartMigrationInput) StartMigrationRequest {
	op := &aws.Operation{
		Name:       opStartMigration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMigrationInput{}
	}

	req := c.newRequest(op, input, &StartMigrationOutput{})
	return StartMigrationRequest{Request: req, Input: input, Copy: c.StartMigrationRequest}
}

// StartMigrationRequest is the request type for the
// StartMigration API operation.
type StartMigrationRequest struct {
	*aws.Request
	Input *StartMigrationInput
	Copy  func(*StartMigrationInput) StartMigrationRequest
}

// Send marshals and sends the StartMigration API request.
func (r StartMigrationRequest) Send(ctx context.Context) (*StartMigrationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartMigrationResponse{
		StartMigrationOutput: r.Request.Data.(*StartMigrationOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartMigrationResponse is the response type for the
// StartMigration API operation.
type StartMigrationResponse struct {
	*StartMigrationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartMigration request.
func (r *StartMigrationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
