// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetBotVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of bot versions to return in the response. The default
	// is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the bot for which versions should be returned.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"2" type:"string" required:"true"`

	// A pagination token for fetching the next page of bot versions. If the response
	// to this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of versions, specify the pagination token in the next
	// request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBotVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBotVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetBotVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of BotMetadata objects, one for each numbered version of the bot
	// plus one for the $LATEST version.
	Bots []BotMetadata `locationName:"bots" type:"list"`

	// A pagination token for fetching the next page of bot versions. If the response
	// to this call is truncated, Amazon Lex returns a pagination token in the response.
	// To fetch the next page of versions, specify the pagination token in the next
	// request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetBotVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBotVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bots != nil {
		v := s.Bots

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "bots", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetBotVersions = "GetBotVersions"

// GetBotVersionsRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Gets information about all of the versions of a bot.
//
// The GetBotVersions operation returns a BotMetadata object for each version
// of a bot. For example, if a bot has three numbered versions, the GetBotVersions
// operation returns four BotMetadata objects in the response, one for each
// numbered version and one for the $LATEST version.
//
// The GetBotVersions operation always returns at least one version, the $LATEST
// version.
//
// This operation requires permissions for the lex:GetBotVersions action.
//
//    // Example sending a request using GetBotVersionsRequest.
//    req := client.GetBotVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotVersions
func (c *Client) GetBotVersionsRequest(input *GetBotVersionsInput) GetBotVersionsRequest {
	op := &aws.Operation{
		Name:       opGetBotVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{name}/versions/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBotVersionsInput{}
	}

	req := c.newRequest(op, input, &GetBotVersionsOutput{})
	return GetBotVersionsRequest{Request: req, Input: input, Copy: c.GetBotVersionsRequest}
}

// GetBotVersionsRequest is the request type for the
// GetBotVersions API operation.
type GetBotVersionsRequest struct {
	*aws.Request
	Input *GetBotVersionsInput
	Copy  func(*GetBotVersionsInput) GetBotVersionsRequest
}

// Send marshals and sends the GetBotVersions API request.
func (r GetBotVersionsRequest) Send(ctx context.Context) (*GetBotVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBotVersionsResponse{
		GetBotVersionsOutput: r.Request.Data.(*GetBotVersionsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetBotVersionsRequestPaginator returns a paginator for GetBotVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetBotVersionsRequest(input)
//   p := lexmodelbuildingservice.NewGetBotVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetBotVersionsPaginator(req GetBotVersionsRequest) GetBotVersionsPaginator {
	return GetBotVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetBotVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetBotVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetBotVersionsPaginator struct {
	aws.Pager
}

func (p *GetBotVersionsPaginator) CurrentPage() *GetBotVersionsOutput {
	return p.Pager.CurrentPage().(*GetBotVersionsOutput)
}

// GetBotVersionsResponse is the response type for the
// GetBotVersions API operation.
type GetBotVersionsResponse struct {
	*GetBotVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBotVersions request.
func (r *GetBotVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
