package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// GlobalClient is the webSite Management Client
type GlobalClient struct {
	BaseClient
}

// NewGlobalClient creates an instance of the GlobalClient client.
func NewGlobalClient(subscriptionID string) GlobalClient {
	return NewGlobalClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewGlobalClientWithBaseURI creates an instance of the GlobalClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewGlobalClientWithBaseURI(baseURI string, subscriptionID string) GlobalClient {
	return GlobalClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckNameAvailability sends the check name availability request.
// Parameters:
// request - name availability request
func (client GlobalClient) CheckNameAvailability(ctx context.Context, request ResourceNameAvailabilityRequest) (result ResourceNameAvailability, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.CheckNameAvailability")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CheckNameAvailabilityPreparer(ctx, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "CheckNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "CheckNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "CheckNameAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client GlobalClient) CheckNameAvailabilityPreparer(ctx context.Context, request ResourceNameAvailabilityRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/checknameavailability", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client GlobalClient) CheckNameAvailabilityResponder(resp *http.Response) (result ResourceNameAvailability, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAllCertificates sends the get all certificates request.
func (client GlobalClient) GetAllCertificates(ctx context.Context) (result CertificateCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllCertificates")
		defer func() {
			sc := -1
			if result.cc.Response.Response != nil {
				sc = result.cc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getAllCertificatesNextResults
	req, err := client.GetAllCertificatesPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllCertificates", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllCertificatesSender(req)
	if err != nil {
		result.cc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllCertificates", resp, "Failure sending request")
		return
	}

	result.cc, err = client.GetAllCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllCertificates", resp, "Failure responding to request")
	}

	return
}

// GetAllCertificatesPreparer prepares the GetAllCertificates request.
func (client GlobalClient) GetAllCertificatesPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/certificates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllCertificatesSender sends the GetAllCertificates request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetAllCertificatesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAllCertificatesResponder handles the response to the GetAllCertificates request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetAllCertificatesResponder(resp *http.Response) (result CertificateCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getAllCertificatesNextResults retrieves the next set of results, if any.
func (client GlobalClient) getAllCertificatesNextResults(ctx context.Context, lastResults CertificateCollection) (result CertificateCollection, err error) {
	req, err := lastResults.certificateCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllCertificatesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetAllCertificatesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllCertificatesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetAllCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "getAllCertificatesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetAllCertificatesComplete enumerates all values, automatically crossing page boundaries as required.
func (client GlobalClient) GetAllCertificatesComplete(ctx context.Context) (result CertificateCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllCertificates")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetAllCertificates(ctx)
	return
}

// GetAllClassicMobileServices sends the get all classic mobile services request.
func (client GlobalClient) GetAllClassicMobileServices(ctx context.Context) (result ClassicMobileServiceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllClassicMobileServices")
		defer func() {
			sc := -1
			if result.cmsc.Response.Response != nil {
				sc = result.cmsc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getAllClassicMobileServicesNextResults
	req, err := client.GetAllClassicMobileServicesPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllClassicMobileServices", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllClassicMobileServicesSender(req)
	if err != nil {
		result.cmsc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllClassicMobileServices", resp, "Failure sending request")
		return
	}

	result.cmsc, err = client.GetAllClassicMobileServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllClassicMobileServices", resp, "Failure responding to request")
	}

	return
}

// GetAllClassicMobileServicesPreparer prepares the GetAllClassicMobileServices request.
func (client GlobalClient) GetAllClassicMobileServicesPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/classicMobileServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllClassicMobileServicesSender sends the GetAllClassicMobileServices request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetAllClassicMobileServicesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAllClassicMobileServicesResponder handles the response to the GetAllClassicMobileServices request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetAllClassicMobileServicesResponder(resp *http.Response) (result ClassicMobileServiceCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getAllClassicMobileServicesNextResults retrieves the next set of results, if any.
func (client GlobalClient) getAllClassicMobileServicesNextResults(ctx context.Context, lastResults ClassicMobileServiceCollection) (result ClassicMobileServiceCollection, err error) {
	req, err := lastResults.classicMobileServiceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllClassicMobileServicesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetAllClassicMobileServicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllClassicMobileServicesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetAllClassicMobileServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "getAllClassicMobileServicesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetAllClassicMobileServicesComplete enumerates all values, automatically crossing page boundaries as required.
func (client GlobalClient) GetAllClassicMobileServicesComplete(ctx context.Context) (result ClassicMobileServiceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllClassicMobileServices")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetAllClassicMobileServices(ctx)
	return
}

// GetAllHostingEnvironments sends the get all hosting environments request.
func (client GlobalClient) GetAllHostingEnvironments(ctx context.Context) (result HostingEnvironmentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllHostingEnvironments")
		defer func() {
			sc := -1
			if result.hec.Response.Response != nil {
				sc = result.hec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getAllHostingEnvironmentsNextResults
	req, err := client.GetAllHostingEnvironmentsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllHostingEnvironments", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllHostingEnvironmentsSender(req)
	if err != nil {
		result.hec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllHostingEnvironments", resp, "Failure sending request")
		return
	}

	result.hec, err = client.GetAllHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllHostingEnvironments", resp, "Failure responding to request")
	}

	return
}

// GetAllHostingEnvironmentsPreparer prepares the GetAllHostingEnvironments request.
func (client GlobalClient) GetAllHostingEnvironmentsPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllHostingEnvironmentsSender sends the GetAllHostingEnvironments request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetAllHostingEnvironmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAllHostingEnvironmentsResponder handles the response to the GetAllHostingEnvironments request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetAllHostingEnvironmentsResponder(resp *http.Response) (result HostingEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getAllHostingEnvironmentsNextResults retrieves the next set of results, if any.
func (client GlobalClient) getAllHostingEnvironmentsNextResults(ctx context.Context, lastResults HostingEnvironmentCollection) (result HostingEnvironmentCollection, err error) {
	req, err := lastResults.hostingEnvironmentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllHostingEnvironmentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetAllHostingEnvironmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllHostingEnvironmentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetAllHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "getAllHostingEnvironmentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetAllHostingEnvironmentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client GlobalClient) GetAllHostingEnvironmentsComplete(ctx context.Context) (result HostingEnvironmentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllHostingEnvironments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetAllHostingEnvironments(ctx)
	return
}

// GetAllManagedHostingEnvironments sends the get all managed hosting environments request.
func (client GlobalClient) GetAllManagedHostingEnvironments(ctx context.Context) (result ManagedHostingEnvironmentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllManagedHostingEnvironments")
		defer func() {
			sc := -1
			if result.mhec.Response.Response != nil {
				sc = result.mhec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getAllManagedHostingEnvironmentsNextResults
	req, err := client.GetAllManagedHostingEnvironmentsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllManagedHostingEnvironments", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllManagedHostingEnvironmentsSender(req)
	if err != nil {
		result.mhec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllManagedHostingEnvironments", resp, "Failure sending request")
		return
	}

	result.mhec, err = client.GetAllManagedHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllManagedHostingEnvironments", resp, "Failure responding to request")
	}

	return
}

// GetAllManagedHostingEnvironmentsPreparer prepares the GetAllManagedHostingEnvironments request.
func (client GlobalClient) GetAllManagedHostingEnvironmentsPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/managedHostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllManagedHostingEnvironmentsSender sends the GetAllManagedHostingEnvironments request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetAllManagedHostingEnvironmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAllManagedHostingEnvironmentsResponder handles the response to the GetAllManagedHostingEnvironments request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetAllManagedHostingEnvironmentsResponder(resp *http.Response) (result ManagedHostingEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getAllManagedHostingEnvironmentsNextResults retrieves the next set of results, if any.
func (client GlobalClient) getAllManagedHostingEnvironmentsNextResults(ctx context.Context, lastResults ManagedHostingEnvironmentCollection) (result ManagedHostingEnvironmentCollection, err error) {
	req, err := lastResults.managedHostingEnvironmentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllManagedHostingEnvironmentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetAllManagedHostingEnvironmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllManagedHostingEnvironmentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetAllManagedHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "getAllManagedHostingEnvironmentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetAllManagedHostingEnvironmentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client GlobalClient) GetAllManagedHostingEnvironmentsComplete(ctx context.Context) (result ManagedHostingEnvironmentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllManagedHostingEnvironments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetAllManagedHostingEnvironments(ctx)
	return
}

// GetAllServerFarms sends the get all server farms request.
// Parameters:
// detailed - false to return a subset of App Service Plan properties, true to return all of the properties.
// Retrieval of all properties may increase the API latency.
func (client GlobalClient) GetAllServerFarms(ctx context.Context, detailed *bool) (result ServerFarmCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllServerFarms")
		defer func() {
			sc := -1
			if result.sfc.Response.Response != nil {
				sc = result.sfc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getAllServerFarmsNextResults
	req, err := client.GetAllServerFarmsPreparer(ctx, detailed)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllServerFarms", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllServerFarmsSender(req)
	if err != nil {
		result.sfc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllServerFarms", resp, "Failure sending request")
		return
	}

	result.sfc, err = client.GetAllServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllServerFarms", resp, "Failure responding to request")
	}

	return
}

// GetAllServerFarmsPreparer prepares the GetAllServerFarms request.
func (client GlobalClient) GetAllServerFarmsPreparer(ctx context.Context, detailed *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if detailed != nil {
		queryParameters["detailed"] = autorest.Encode("query", *detailed)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllServerFarmsSender sends the GetAllServerFarms request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetAllServerFarmsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAllServerFarmsResponder handles the response to the GetAllServerFarms request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetAllServerFarmsResponder(resp *http.Response) (result ServerFarmCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getAllServerFarmsNextResults retrieves the next set of results, if any.
func (client GlobalClient) getAllServerFarmsNextResults(ctx context.Context, lastResults ServerFarmCollection) (result ServerFarmCollection, err error) {
	req, err := lastResults.serverFarmCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllServerFarmsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetAllServerFarmsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllServerFarmsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetAllServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "getAllServerFarmsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetAllServerFarmsComplete enumerates all values, automatically crossing page boundaries as required.
func (client GlobalClient) GetAllServerFarmsComplete(ctx context.Context, detailed *bool) (result ServerFarmCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllServerFarms")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetAllServerFarms(ctx, detailed)
	return
}

// GetAllSites sends the get all sites request.
func (client GlobalClient) GetAllSites(ctx context.Context) (result SiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllSites")
		defer func() {
			sc := -1
			if result.sc.Response.Response != nil {
				sc = result.sc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getAllSitesNextResults
	req, err := client.GetAllSitesPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllSites", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllSitesSender(req)
	if err != nil {
		result.sc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllSites", resp, "Failure sending request")
		return
	}

	result.sc, err = client.GetAllSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetAllSites", resp, "Failure responding to request")
	}

	return
}

// GetAllSitesPreparer prepares the GetAllSites request.
func (client GlobalClient) GetAllSitesPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllSitesSender sends the GetAllSites request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetAllSitesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAllSitesResponder handles the response to the GetAllSites request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetAllSitesResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getAllSitesNextResults retrieves the next set of results, if any.
func (client GlobalClient) getAllSitesNextResults(ctx context.Context, lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.siteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllSitesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetAllSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getAllSitesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetAllSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "getAllSitesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetAllSitesComplete enumerates all values, automatically crossing page boundaries as required.
func (client GlobalClient) GetAllSitesComplete(ctx context.Context) (result SiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetAllSites")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetAllSites(ctx)
	return
}

// GetSubscriptionGeoRegions sends the get subscription geo regions request.
// Parameters:
// sku - filter only to regions that support this sku
// linuxWorkersEnabled - filter only to regions that support linux workers
func (client GlobalClient) GetSubscriptionGeoRegions(ctx context.Context, sku string, linuxWorkersEnabled *bool) (result GeoRegionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetSubscriptionGeoRegions")
		defer func() {
			sc := -1
			if result.grc.Response.Response != nil {
				sc = result.grc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSubscriptionGeoRegionsNextResults
	req, err := client.GetSubscriptionGeoRegionsPreparer(ctx, sku, linuxWorkersEnabled)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionGeoRegions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSubscriptionGeoRegionsSender(req)
	if err != nil {
		result.grc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionGeoRegions", resp, "Failure sending request")
		return
	}

	result.grc, err = client.GetSubscriptionGeoRegionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionGeoRegions", resp, "Failure responding to request")
	}

	return
}

// GetSubscriptionGeoRegionsPreparer prepares the GetSubscriptionGeoRegions request.
func (client GlobalClient) GetSubscriptionGeoRegionsPreparer(ctx context.Context, sku string, linuxWorkersEnabled *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(sku) > 0 {
		queryParameters["sku"] = autorest.Encode("query", sku)
	}
	if linuxWorkersEnabled != nil {
		queryParameters["linuxWorkersEnabled"] = autorest.Encode("query", *linuxWorkersEnabled)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSubscriptionGeoRegionsSender sends the GetSubscriptionGeoRegions request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetSubscriptionGeoRegionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSubscriptionGeoRegionsResponder handles the response to the GetSubscriptionGeoRegions request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetSubscriptionGeoRegionsResponder(resp *http.Response) (result GeoRegionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSubscriptionGeoRegionsNextResults retrieves the next set of results, if any.
func (client GlobalClient) getSubscriptionGeoRegionsNextResults(ctx context.Context, lastResults GeoRegionCollection) (result GeoRegionCollection, err error) {
	req, err := lastResults.geoRegionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getSubscriptionGeoRegionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSubscriptionGeoRegionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.GlobalClient", "getSubscriptionGeoRegionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSubscriptionGeoRegionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "getSubscriptionGeoRegionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSubscriptionGeoRegionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client GlobalClient) GetSubscriptionGeoRegionsComplete(ctx context.Context, sku string, linuxWorkersEnabled *bool) (result GeoRegionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetSubscriptionGeoRegions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSubscriptionGeoRegions(ctx, sku, linuxWorkersEnabled)
	return
}

// GetSubscriptionPublishingCredentials sends the get subscription publishing credentials request.
func (client GlobalClient) GetSubscriptionPublishingCredentials(ctx context.Context) (result User, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetSubscriptionPublishingCredentials")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSubscriptionPublishingCredentialsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionPublishingCredentials", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSubscriptionPublishingCredentialsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionPublishingCredentials", resp, "Failure sending request")
		return
	}

	result, err = client.GetSubscriptionPublishingCredentialsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionPublishingCredentials", resp, "Failure responding to request")
	}

	return
}

// GetSubscriptionPublishingCredentialsPreparer prepares the GetSubscriptionPublishingCredentials request.
func (client GlobalClient) GetSubscriptionPublishingCredentialsPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/publishingCredentials", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSubscriptionPublishingCredentialsSender sends the GetSubscriptionPublishingCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetSubscriptionPublishingCredentialsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSubscriptionPublishingCredentialsResponder handles the response to the GetSubscriptionPublishingCredentials request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetSubscriptionPublishingCredentialsResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsHostingEnvironmentNameAvailable sends the is hosting environment name available request.
// Parameters:
// name - hosting environment name
func (client GlobalClient) IsHostingEnvironmentNameAvailable(ctx context.Context, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.IsHostingEnvironmentNameAvailable")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.IsHostingEnvironmentNameAvailablePreparer(ctx, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "IsHostingEnvironmentNameAvailable", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsHostingEnvironmentNameAvailableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "IsHostingEnvironmentNameAvailable", resp, "Failure sending request")
		return
	}

	result, err = client.IsHostingEnvironmentNameAvailableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "IsHostingEnvironmentNameAvailable", resp, "Failure responding to request")
	}

	return
}

// IsHostingEnvironmentNameAvailablePreparer prepares the IsHostingEnvironmentNameAvailable request.
func (client GlobalClient) IsHostingEnvironmentNameAvailablePreparer(ctx context.Context, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"name":        autorest.Encode("query", name),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/ishostingenvironmentnameavailable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// IsHostingEnvironmentNameAvailableSender sends the IsHostingEnvironmentNameAvailable request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) IsHostingEnvironmentNameAvailableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// IsHostingEnvironmentNameAvailableResponder handles the response to the IsHostingEnvironmentNameAvailable request. The method always
// closes the http.Response Body.
func (client GlobalClient) IsHostingEnvironmentNameAvailableResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsHostingEnvironmentWithLegacyNameAvailable sends the is hosting environment with legacy name available request.
// Parameters:
// name - hosting environment name
func (client GlobalClient) IsHostingEnvironmentWithLegacyNameAvailable(ctx context.Context, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.IsHostingEnvironmentWithLegacyNameAvailable")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.IsHostingEnvironmentWithLegacyNameAvailablePreparer(ctx, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "IsHostingEnvironmentWithLegacyNameAvailable", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsHostingEnvironmentWithLegacyNameAvailableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "IsHostingEnvironmentWithLegacyNameAvailable", resp, "Failure sending request")
		return
	}

	result, err = client.IsHostingEnvironmentWithLegacyNameAvailableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "IsHostingEnvironmentWithLegacyNameAvailable", resp, "Failure responding to request")
	}

	return
}

// IsHostingEnvironmentWithLegacyNameAvailablePreparer prepares the IsHostingEnvironmentWithLegacyNameAvailable request.
func (client GlobalClient) IsHostingEnvironmentWithLegacyNameAvailablePreparer(ctx context.Context, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":           autorest.Encode("path", name),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/ishostingenvironmentnameavailable/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// IsHostingEnvironmentWithLegacyNameAvailableSender sends the IsHostingEnvironmentWithLegacyNameAvailable request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) IsHostingEnvironmentWithLegacyNameAvailableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// IsHostingEnvironmentWithLegacyNameAvailableResponder handles the response to the IsHostingEnvironmentWithLegacyNameAvailable request. The method always
// closes the http.Response Body.
func (client GlobalClient) IsHostingEnvironmentWithLegacyNameAvailableResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPremierAddOnOffers sends the list premier add on offers request.
func (client GlobalClient) ListPremierAddOnOffers(ctx context.Context) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.ListPremierAddOnOffers")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPremierAddOnOffersPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "ListPremierAddOnOffers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnOffersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "ListPremierAddOnOffers", resp, "Failure sending request")
		return
	}

	result, err = client.ListPremierAddOnOffersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "ListPremierAddOnOffers", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnOffersPreparer prepares the ListPremierAddOnOffers request.
func (client GlobalClient) ListPremierAddOnOffersPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPremierAddOnOffersSender sends the ListPremierAddOnOffers request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) ListPremierAddOnOffersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPremierAddOnOffersResponder handles the response to the ListPremierAddOnOffers request. The method always
// closes the http.Response Body.
func (client GlobalClient) ListPremierAddOnOffersResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSubscriptionPublishingCredentials sends the update subscription publishing credentials request.
// Parameters:
// requestMessage - requestMessage with new publishing credentials
func (client GlobalClient) UpdateSubscriptionPublishingCredentials(ctx context.Context, requestMessage User) (result User, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.UpdateSubscriptionPublishingCredentials")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSubscriptionPublishingCredentialsPreparer(ctx, requestMessage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "UpdateSubscriptionPublishingCredentials", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubscriptionPublishingCredentialsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "UpdateSubscriptionPublishingCredentials", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubscriptionPublishingCredentialsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "UpdateSubscriptionPublishingCredentials", resp, "Failure responding to request")
	}

	return
}

// UpdateSubscriptionPublishingCredentialsPreparer prepares the UpdateSubscriptionPublishingCredentials request.
func (client GlobalClient) UpdateSubscriptionPublishingCredentialsPreparer(ctx context.Context, requestMessage User) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/publishingCredentials", pathParameters),
		autorest.WithJSON(requestMessage),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubscriptionPublishingCredentialsSender sends the UpdateSubscriptionPublishingCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) UpdateSubscriptionPublishingCredentialsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSubscriptionPublishingCredentialsResponder handles the response to the UpdateSubscriptionPublishingCredentials request. The method always
// closes the http.Response Body.
func (client GlobalClient) UpdateSubscriptionPublishingCredentialsResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
