package vmwarecloudsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SkusAvailabilityClient is the description of the new service
type SkusAvailabilityClient struct {
	BaseClient
}

// NewSkusAvailabilityClient creates an instance of the SkusAvailabilityClient client.
func NewSkusAvailabilityClient(subscriptionID string, referer string) SkusAvailabilityClient {
	return NewSkusAvailabilityClientWithBaseURI(DefaultBaseURI, subscriptionID, referer)
}

// NewSkusAvailabilityClientWithBaseURI creates an instance of the SkusAvailabilityClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewSkusAvailabilityClientWithBaseURI(baseURI string, subscriptionID string, referer string) SkusAvailabilityClient {
	return SkusAvailabilityClient{NewWithBaseURI(baseURI, subscriptionID, referer)}
}

// List returns list of available resources in region
// Parameters:
// regionID - the region Id (westus, eastus)
// skuID - sku id, if no sku is passed availability for all skus will be returned
func (client SkusAvailabilityClient) List(ctx context.Context, regionID string, skuID string) (result SkuAvailabilityListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkusAvailabilityClient.List")
		defer func() {
			sc := -1
			if result.salr.Response.Response != nil {
				sc = result.salr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, regionID, skuID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.salr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityClient", "List", resp, "Failure sending request")
		return
	}

	result.salr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client SkusAvailabilityClient) ListPreparer(ctx context.Context, regionID string, skuID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"regionId":       autorest.Encode("path", regionID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skuID) > 0 {
		queryParameters["skuId"] = autorest.Encode("query", skuID)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.VMwareCloudSimple/locations/{regionId}/availabilities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SkusAvailabilityClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SkusAvailabilityClient) ListResponder(resp *http.Response) (result SkuAvailabilityListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client SkusAvailabilityClient) listNextResults(ctx context.Context, lastResults SkuAvailabilityListResponse) (result SkuAvailabilityListResponse, err error) {
	req, err := lastResults.skuAvailabilityListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client SkusAvailabilityClient) ListComplete(ctx context.Context, regionID string, skuID string) (result SkuAvailabilityListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkusAvailabilityClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, regionID, skuID)
	return
}
