// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarnotifications

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UnsubscribeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The ARN of the SNS topic to unsubscribe from the notification rule.
	//
	// TargetAddress is a required field
	TargetAddress *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s UnsubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnsubscribeInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if s.TargetAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetAddress"))
	}
	if s.TargetAddress != nil && len(*s.TargetAddress) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnsubscribeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetAddress != nil {
		v := *s.TargetAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UnsubscribeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the the notification rule from which you
	// have removed a subscription.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UnsubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnsubscribeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUnsubscribe = "Unsubscribe"

// UnsubscribeRequest returns a request value for making API operation for
// AWS CodeStar Notifications.
//
// Removes an association between a notification rule and an Amazon SNS topic
// so that subscribers to that topic stop receiving notifications when the events
// described in the rule are triggered.
//
//    // Example sending a request using UnsubscribeRequest.
//    req := client.UnsubscribeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Unsubscribe
func (c *Client) UnsubscribeRequest(input *UnsubscribeInput) UnsubscribeRequest {
	op := &aws.Operation{
		Name:       opUnsubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/unsubscribe",
	}

	if input == nil {
		input = &UnsubscribeInput{}
	}

	req := c.newRequest(op, input, &UnsubscribeOutput{})
	return UnsubscribeRequest{Request: req, Input: input, Copy: c.UnsubscribeRequest}
}

// UnsubscribeRequest is the request type for the
// Unsubscribe API operation.
type UnsubscribeRequest struct {
	*aws.Request
	Input *UnsubscribeInput
	Copy  func(*UnsubscribeInput) UnsubscribeRequest
}

// Send marshals and sends the Unsubscribe API request.
func (r UnsubscribeRequest) Send(ctx context.Context) (*UnsubscribeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnsubscribeResponse{
		UnsubscribeOutput: r.Request.Data.(*UnsubscribeOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnsubscribeResponse is the response type for the
// Unsubscribe API operation.
type UnsubscribeResponse struct {
	*UnsubscribeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Unsubscribe request.
func (r *UnsubscribeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
