// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateBatchPredictionInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the BatchPrediction during creation.
	//
	// BatchPredictionId is a required field
	BatchPredictionId *string `min:"1" type:"string" required:"true"`

	// A new user-supplied name or description of the BatchPrediction.
	//
	// BatchPredictionName is a required field
	BatchPredictionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBatchPredictionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateBatchPredictionInput"}

	if s.BatchPredictionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BatchPredictionId"))
	}
	if s.BatchPredictionId != nil && len(*s.BatchPredictionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BatchPredictionId", 1))
	}

	if s.BatchPredictionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BatchPredictionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of an UpdateBatchPrediction operation.
//
// You can see the updated content by using the GetBatchPrediction operation.
type UpdateBatchPredictionOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the BatchPrediction during creation. This value should
	// be identical to the value of the BatchPredictionId in the request.
	BatchPredictionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateBatchPrediction = "UpdateBatchPrediction"

// UpdateBatchPredictionRequest returns a request value for making API operation for
// Amazon Machine Learning.
//
// Updates the BatchPredictionName of a BatchPrediction.
//
// You can use the GetBatchPrediction operation to view the contents of the
// updated data element.
//
//    // Example sending a request using UpdateBatchPredictionRequest.
//    req := client.UpdateBatchPredictionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateBatchPredictionRequest(input *UpdateBatchPredictionInput) UpdateBatchPredictionRequest {
	op := &aws.Operation{
		Name:       opUpdateBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBatchPredictionInput{}
	}

	req := c.newRequest(op, input, &UpdateBatchPredictionOutput{})
	return UpdateBatchPredictionRequest{Request: req, Input: input, Copy: c.UpdateBatchPredictionRequest}
}

// UpdateBatchPredictionRequest is the request type for the
// UpdateBatchPrediction API operation.
type UpdateBatchPredictionRequest struct {
	*aws.Request
	Input *UpdateBatchPredictionInput
	Copy  func(*UpdateBatchPredictionInput) UpdateBatchPredictionRequest
}

// Send marshals and sends the UpdateBatchPrediction API request.
func (r UpdateBatchPredictionRequest) Send(ctx context.Context) (*UpdateBatchPredictionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateBatchPredictionResponse{
		UpdateBatchPredictionOutput: r.Request.Data.(*UpdateBatchPredictionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateBatchPredictionResponse is the response type for the
// UpdateBatchPrediction API operation.
type UpdateBatchPredictionResponse struct {
	*UpdateBatchPredictionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateBatchPrediction request.
func (r *UpdateBatchPredictionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
