// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RestoreWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreWorkspaceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreWorkspaceInput"}

	if s.WorkspaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RestoreWorkspaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestoreWorkspace = "RestoreWorkspace"

// RestoreWorkspaceRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Restores the specified WorkSpace to its last known healthy state.
//
// You cannot restore a WorkSpace unless its state is AVAILABLE, ERROR, or UNHEALTHY.
//
// Restoring a WorkSpace is a potentially destructive action that can result
// in the loss of data. For more information, see Restore a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html).
//
// This operation is asynchronous and returns before the WorkSpace is completely
// restored.
//
//    // Example sending a request using RestoreWorkspaceRequest.
//    req := client.RestoreWorkspaceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace
func (c *Client) RestoreWorkspaceRequest(input *RestoreWorkspaceInput) RestoreWorkspaceRequest {
	op := &aws.Operation{
		Name:       opRestoreWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreWorkspaceInput{}
	}

	req := c.newRequest(op, input, &RestoreWorkspaceOutput{})
	return RestoreWorkspaceRequest{Request: req, Input: input, Copy: c.RestoreWorkspaceRequest}
}

// RestoreWorkspaceRequest is the request type for the
// RestoreWorkspace API operation.
type RestoreWorkspaceRequest struct {
	*aws.Request
	Input *RestoreWorkspaceInput
	Copy  func(*RestoreWorkspaceInput) RestoreWorkspaceRequest
}

// Send marshals and sends the RestoreWorkspace API request.
func (r RestoreWorkspaceRequest) Send(ctx context.Context) (*RestoreWorkspaceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreWorkspaceResponse{
		RestoreWorkspaceOutput: r.Request.Data.(*RestoreWorkspaceOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreWorkspaceResponse is the response type for the
// RestoreWorkspace API operation.
type RestoreWorkspaceResponse struct {
	*RestoreWorkspaceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreWorkspace request.
func (r *RestoreWorkspaceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
