// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package managedblockchain

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListProposalsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of proposals to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The unique identifier of the network.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListProposalsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProposalsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProposalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.NetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProposalsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.NetworkId != nil {
		v := *s.NetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "networkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListProposalsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`

	// The summary of each proposal made on the network.
	Proposals []ProposalSummary `type:"list"`
}

// String returns the string representation
func (s ListProposalsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProposalsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Proposals != nil {
		v := s.Proposals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Proposals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListProposals = "ListProposals"

// ListProposalsRequest returns a request value for making API operation for
// Amazon Managed Blockchain.
//
// Returns a listing of proposals for the network.
//
//    // Example sending a request using ListProposalsRequest.
//    req := client.ListProposalsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals
func (c *Client) ListProposalsRequest(input *ListProposalsInput) ListProposalsRequest {
	op := &aws.Operation{
		Name:       opListProposals,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/proposals",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProposalsInput{}
	}

	req := c.newRequest(op, input, &ListProposalsOutput{})
	return ListProposalsRequest{Request: req, Input: input, Copy: c.ListProposalsRequest}
}

// ListProposalsRequest is the request type for the
// ListProposals API operation.
type ListProposalsRequest struct {
	*aws.Request
	Input *ListProposalsInput
	Copy  func(*ListProposalsInput) ListProposalsRequest
}

// Send marshals and sends the ListProposals API request.
func (r ListProposalsRequest) Send(ctx context.Context) (*ListProposalsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProposalsResponse{
		ListProposalsOutput: r.Request.Data.(*ListProposalsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProposalsRequestPaginator returns a paginator for ListProposals.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProposalsRequest(input)
//   p := managedblockchain.NewListProposalsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProposalsPaginator(req ListProposalsRequest) ListProposalsPaginator {
	return ListProposalsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProposalsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProposalsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProposalsPaginator struct {
	aws.Pager
}

func (p *ListProposalsPaginator) CurrentPage() *ListProposalsOutput {
	return p.Pager.CurrentPage().(*ListProposalsOutput)
}

// ListProposalsResponse is the response type for the
// ListProposals API operation.
type ListProposalsResponse struct {
	*ListProposalsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProposals request.
func (r *ListProposalsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
