// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateSkillWithUsersInput struct {
	_ struct{} `type:"structure"`

	// The private skill ID you want to make available to enrolled users.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateSkillWithUsersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSkillWithUsersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateSkillWithUsersInput"}

	if s.SkillId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateSkillWithUsersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateSkillWithUsersOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateSkillWithUsers = "AssociateSkillWithUsers"

// AssociateSkillWithUsersRequest returns a request value for making API operation for
// Alexa For Business.
//
// Makes a private skill available for enrolled users to enable on their devices.
//
//    // Example sending a request using AssociateSkillWithUsersRequest.
//    req := client.AssociateSkillWithUsersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers
func (c *Client) AssociateSkillWithUsersRequest(input *AssociateSkillWithUsersInput) AssociateSkillWithUsersRequest {
	op := &aws.Operation{
		Name:       opAssociateSkillWithUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSkillWithUsersInput{}
	}

	req := c.newRequest(op, input, &AssociateSkillWithUsersOutput{})
	return AssociateSkillWithUsersRequest{Request: req, Input: input, Copy: c.AssociateSkillWithUsersRequest}
}

// AssociateSkillWithUsersRequest is the request type for the
// AssociateSkillWithUsers API operation.
type AssociateSkillWithUsersRequest struct {
	*aws.Request
	Input *AssociateSkillWithUsersInput
	Copy  func(*AssociateSkillWithUsersInput) AssociateSkillWithUsersRequest
}

// Send marshals and sends the AssociateSkillWithUsers API request.
func (r AssociateSkillWithUsersRequest) Send(ctx context.Context) (*AssociateSkillWithUsersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateSkillWithUsersResponse{
		AssociateSkillWithUsersOutput: r.Request.Data.(*AssociateSkillWithUsersOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateSkillWithUsersResponse is the response type for the
// AssociateSkillWithUsers API operation.
type AssociateSkillWithUsersResponse struct {
	*AssociateSkillWithUsersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateSkillWithUsers request.
func (r *AssociateSkillWithUsersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
