// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type PutBackupVaultAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// The backup vault access policy document in JSON format.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s PutBackupVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBackupVaultAccessPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBackupVaultAccessPolicyInput"}

	if s.BackupVaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupVaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBackupVaultAccessPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "backupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutBackupVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBackupVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBackupVaultAccessPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBackupVaultAccessPolicy = "PutBackupVaultAccessPolicy"

// PutBackupVaultAccessPolicyRequest returns a request value for making API operation for
// AWS Backup.
//
// Sets a resource-based policy that is used to manage access permissions on
// the target backup vault. Requires a backup vault name and an access policy
// document in JSON format.
//
//    // Example sending a request using PutBackupVaultAccessPolicyRequest.
//    req := client.PutBackupVaultAccessPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy
func (c *Client) PutBackupVaultAccessPolicyRequest(input *PutBackupVaultAccessPolicyInput) PutBackupVaultAccessPolicyRequest {
	op := &aws.Operation{
		Name:       opPutBackupVaultAccessPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-vaults/{backupVaultName}/access-policy",
	}

	if input == nil {
		input = &PutBackupVaultAccessPolicyInput{}
	}

	req := c.newRequest(op, input, &PutBackupVaultAccessPolicyOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBackupVaultAccessPolicyRequest{Request: req, Input: input, Copy: c.PutBackupVaultAccessPolicyRequest}
}

// PutBackupVaultAccessPolicyRequest is the request type for the
// PutBackupVaultAccessPolicy API operation.
type PutBackupVaultAccessPolicyRequest struct {
	*aws.Request
	Input *PutBackupVaultAccessPolicyInput
	Copy  func(*PutBackupVaultAccessPolicyInput) PutBackupVaultAccessPolicyRequest
}

// Send marshals and sends the PutBackupVaultAccessPolicy API request.
func (r PutBackupVaultAccessPolicyRequest) Send(ctx context.Context) (*PutBackupVaultAccessPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBackupVaultAccessPolicyResponse{
		PutBackupVaultAccessPolicyOutput: r.Request.Data.(*PutBackupVaultAccessPolicyOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBackupVaultAccessPolicyResponse is the response type for the
// PutBackupVaultAccessPolicy API operation.
type PutBackupVaultAccessPolicyResponse struct {
	*PutBackupVaultAccessPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBackupVaultAccessPolicy request.
func (r *PutBackupVaultAccessPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
