// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeComplianceByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and INSUFFICIENT_DATA.
	ComplianceTypes []ComplianceType `type:"list"`

	// The maximum number of evaluation results returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the AWS resource for which you want compliance information. You
	// can specify only one resource ID. If you specify a resource ID, you must
	// also specify a type for ResourceType.
	ResourceId *string `min:"1" type:"string"`

	// The types of AWS resources for which you want compliance information (for
	// example, AWS::EC2::Instance). For this action, you can specify that the resource
	// type is an AWS account by specifying AWS::::Account.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComplianceByResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeComplianceByResourceInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeComplianceByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified AWS resource complies with all of the AWS
	// Config rules that evaluate it.
	ComplianceByResources []ComplianceByResource `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeComplianceByResource = "DescribeComplianceByResource"

// DescribeComplianceByResourceRequest returns a request value for making API operation for
// AWS Config.
//
// Indicates whether the specified AWS resources are compliant. If a resource
// is noncompliant, this action returns the number of AWS Config rules that
// the resource does not comply with.
//
// A resource is compliant if it complies with all the AWS Config rules that
// evaluate it. It is noncompliant if it does not comply with one or more of
// these rules.
//
// If AWS Config has no current evaluation results for the resource, it returns
// INSUFFICIENT_DATA. This result might indicate one of the following conditions
// about the rules that evaluate the resource:
//
//    * AWS Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's AWS Lambda function is failing to send evaluation results
//    to AWS Config. Verify that the role that you assigned to your configuration
//    recorder includes the config:PutEvaluations permission. If the rule is
//    a custom rule, verify that the AWS Lambda execution role includes the
//    config:PutEvaluations permission.
//
//    * The rule's AWS Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
//    // Example sending a request using DescribeComplianceByResourceRequest.
//    req := client.DescribeComplianceByResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource
func (c *Client) DescribeComplianceByResourceRequest(input *DescribeComplianceByResourceInput) DescribeComplianceByResourceRequest {
	op := &aws.Operation{
		Name:       opDescribeComplianceByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComplianceByResourceInput{}
	}

	req := c.newRequest(op, input, &DescribeComplianceByResourceOutput{})
	return DescribeComplianceByResourceRequest{Request: req, Input: input, Copy: c.DescribeComplianceByResourceRequest}
}

// DescribeComplianceByResourceRequest is the request type for the
// DescribeComplianceByResource API operation.
type DescribeComplianceByResourceRequest struct {
	*aws.Request
	Input *DescribeComplianceByResourceInput
	Copy  func(*DescribeComplianceByResourceInput) DescribeComplianceByResourceRequest
}

// Send marshals and sends the DescribeComplianceByResource API request.
func (r DescribeComplianceByResourceRequest) Send(ctx context.Context) (*DescribeComplianceByResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeComplianceByResourceResponse{
		DescribeComplianceByResourceOutput: r.Request.Data.(*DescribeComplianceByResourceOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeComplianceByResourceResponse is the response type for the
// DescribeComplianceByResource API operation.
type DescribeComplianceByResourceResponse struct {
	*DescribeComplianceByResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeComplianceByResource request.
func (r *DescribeComplianceByResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
