// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DisableKeyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key (CMK).
	//
	// Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableKeyInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableKey = "DisableKey"

// DisableKeyRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Sets the state of a customer master key (CMK) to disabled, thereby preventing
// its use for cryptographic operations. You cannot perform this operation on
// a CMK in a different AWS account.
//
// For more information about how key state affects the use of a CMK, see How
// Key State Affects the Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide .
//
// The CMK that you use for this operation must be in a compatible key state.
// For details, see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using DisableKeyRequest.
//    req := client.DisableKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKey
func (c *Client) DisableKeyRequest(input *DisableKeyInput) DisableKeyRequest {
	op := &aws.Operation{
		Name:       opDisableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyInput{}
	}

	req := c.newRequest(op, input, &DisableKeyOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DisableKeyRequest{Request: req, Input: input, Copy: c.DisableKeyRequest}
}

// DisableKeyRequest is the request type for the
// DisableKey API operation.
type DisableKeyRequest struct {
	*aws.Request
	Input *DisableKeyInput
	Copy  func(*DisableKeyInput) DisableKeyRequest
}

// Send marshals and sends the DisableKey API request.
func (r DisableKeyRequest) Send(ctx context.Context) (*DisableKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableKeyResponse{
		DisableKeyOutput: r.Request.Data.(*DisableKeyOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableKeyResponse is the response type for the
// DisableKey API operation.
type DisableKeyResponse struct {
	*DisableKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableKey request.
func (r *DisableKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
