// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateExperimentInput struct {
	_ struct{} `type:"structure"`

	// The description of the experiment.
	Description *string `type:"string"`

	// The name of the experiment as displayed. The name doesn't need to be unique.
	// If you don't specify DisplayName, the value in ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The name of the experiment. The name must be unique in your AWS account and
	// is not case-sensitive.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`

	// A list of tags to associate with the experiment. You can use Search API to
	// search on the tags.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateExperimentInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DisplayName", 1))
	}

	if s.ExperimentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExperimentName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateExperimentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`
}

// String returns the string representation
func (s CreateExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateExperiment = "CreateExperiment"

// CreateExperimentRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates an Amazon SageMaker experiment. An experiment is a collection of
// trials that are observed, compared and evaluated as a group. A trial is a
// set of steps, called trial components, that produce a machine learning model.
//
// The goal of an experiment is to determine the components that produce the
// best model. Multiple trials are performed, each one isolating and measuring
// the impact of a change to one or more inputs, while keeping the remaining
// inputs constant.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to experiments, trials, trial components and then use the
// Search API to search for the tags.
//
// To add a description to an experiment, specify the optional Description parameter.
// To add a description later, or to change the description, call the UpdateExperiment
// API.
//
// To get a list of all your experiments, call the ListExperiments API. To view
// an experiment's properties, call the DescribeExperiment API. To get a list
// of all the trials associated with an experiment, call the ListTrials API.
// To create a trial call the CreateTrial API.
//
//    // Example sending a request using CreateExperimentRequest.
//    req := client.CreateExperimentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment
func (c *Client) CreateExperimentRequest(input *CreateExperimentInput) CreateExperimentRequest {
	op := &aws.Operation{
		Name:       opCreateExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateExperimentInput{}
	}

	req := c.newRequest(op, input, &CreateExperimentOutput{})
	return CreateExperimentRequest{Request: req, Input: input, Copy: c.CreateExperimentRequest}
}

// CreateExperimentRequest is the request type for the
// CreateExperiment API operation.
type CreateExperimentRequest struct {
	*aws.Request
	Input *CreateExperimentInput
	Copy  func(*CreateExperimentInput) CreateExperimentRequest
}

// Send marshals and sends the CreateExperiment API request.
func (r CreateExperimentRequest) Send(ctx context.Context) (*CreateExperimentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateExperimentResponse{
		CreateExperimentOutput: r.Request.Data.(*CreateExperimentOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateExperimentResponse is the response type for the
// CreateExperiment API operation.
type CreateExperimentResponse struct {
	*CreateExperimentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateExperiment request.
func (r *CreateExperimentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
