// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The POST request to create a usage plan with the name, description, throttle
// limits and quota limits, as well as the associated API stages, specified
// in the payload.
type CreateUsagePlanInput struct {
	_ struct{} `type:"structure"`

	// The associated API stages of the usage plan.
	ApiStages []ApiStage `locationName:"apiStages" type:"list"`

	// The description of the usage plan.
	Description *string `locationName:"description" type:"string"`

	// [Required] The name of the usage plan.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The quota of the usage plan.
	Quota *QuotaSettings `locationName:"quota" type:"structure"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The throttling limits of the usage plan.
	Throttle *ThrottleSettings `locationName:"throttle" type:"structure"`
}

// String returns the string representation
func (s CreateUsagePlanInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUsagePlanInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateUsagePlanInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateUsagePlanInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiStages != nil {
		v := s.ApiStages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "apiStages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Quota != nil {
		v := s.Quota

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "quota", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Throttle != nil {
		v := s.Throttle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "throttle", v, metadata)
	}
	return nil
}

// Represents a usage plan than can specify who can assess associated API stages
// with specified request limits and quotas.
//
// In a usage plan, you associate an API by specifying the API's Id and a stage
// name of the specified API. You add plan customers by adding API keys to the
// plan.
//
// Create and Use Usage Plans (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html)
type CreateUsagePlanOutput struct {
	_ struct{} `type:"structure"`

	// The associated API stages of a usage plan.
	ApiStages []ApiStage `locationName:"apiStages" type:"list"`

	// The description of a usage plan.
	Description *string `locationName:"description" type:"string"`

	// The identifier of a UsagePlan resource.
	Id *string `locationName:"id" type:"string"`

	// The name of a usage plan.
	Name *string `locationName:"name" type:"string"`

	// The AWS Markeplace product identifier to associate with the usage plan as
	// a SaaS product on AWS Marketplace.
	ProductCode *string `locationName:"productCode" type:"string"`

	// The maximum number of permitted requests per a given unit time interval.
	Quota *QuotaSettings `locationName:"quota" type:"structure"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The request throttle limits of a usage plan.
	Throttle *ThrottleSettings `locationName:"throttle" type:"structure"`
}

// String returns the string representation
func (s CreateUsagePlanOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateUsagePlanOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiStages != nil {
		v := s.ApiStages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "apiStages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductCode != nil {
		v := *s.ProductCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "productCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Quota != nil {
		v := s.Quota

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "quota", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Throttle != nil {
		v := s.Throttle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "throttle", v, metadata)
	}
	return nil
}

const opCreateUsagePlan = "CreateUsagePlan"

// CreateUsagePlanRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Creates a usage plan with the throttle and quota limits, as well as the associated
// API stages, specified in the payload.
//
//    // Example sending a request using CreateUsagePlanRequest.
//    req := client.CreateUsagePlanRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateUsagePlanRequest(input *CreateUsagePlanInput) CreateUsagePlanRequest {
	op := &aws.Operation{
		Name:       opCreateUsagePlan,
		HTTPMethod: "POST",
		HTTPPath:   "/usageplans",
	}

	if input == nil {
		input = &CreateUsagePlanInput{}
	}

	req := c.newRequest(op, input, &CreateUsagePlanOutput{})
	return CreateUsagePlanRequest{Request: req, Input: input, Copy: c.CreateUsagePlanRequest}
}

// CreateUsagePlanRequest is the request type for the
// CreateUsagePlan API operation.
type CreateUsagePlanRequest struct {
	*aws.Request
	Input *CreateUsagePlanInput
	Copy  func(*CreateUsagePlanInput) CreateUsagePlanRequest
}

// Send marshals and sends the CreateUsagePlan API request.
func (r CreateUsagePlanRequest) Send(ctx context.Context) (*CreateUsagePlanResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateUsagePlanResponse{
		CreateUsagePlanOutput: r.Request.Data.(*CreateUsagePlanOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateUsagePlanResponse is the response type for the
// CreateUsagePlan API operation.
type CreateUsagePlanResponse struct {
	*CreateUsagePlanOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateUsagePlan request.
func (r *CreateUsagePlanResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
