// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The route settings map.
	RouteSettings map[string]RouteSettings `locationName:"routeSettings" type:"map"`

	// StageName is a required field
	StageName *string `location:"uri" locationName:"stageName" type:"string" required:"true"`

	// The stage variable map.
	StageVariables map[string]string `locationName:"stageVariables" type:"map"`
}

// String returns the string representation
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateStageInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.StageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateStageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessLogSettings != nil {
		v := s.AccessLogSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLogSettings", v, metadata)
	}
	if s.AutoDeploy != nil {
		v := *s.AutoDeploy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoDeploy", protocol.BoolValue(v), metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultRouteSettings != nil {
		v := s.DefaultRouteSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultRouteSettings", v, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteSettings != nil {
		v := s.RouteSettings

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "routeSettings", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.StageVariables != nil {
		v := s.StageVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateStageOutput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	LastDeploymentStatusMessage *string `locationName:"lastDeploymentStatusMessage" type:"string"`

	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// The route settings map.
	RouteSettings map[string]RouteSettings `locationName:"routeSettings" type:"map"`

	// A string with a length between [1-128].
	StageName *string `locationName:"stageName" type:"string"`

	// The stage variable map.
	StageVariables map[string]string `locationName:"stageVariables" type:"map"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s UpdateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateStageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessLogSettings != nil {
		v := s.AccessLogSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLogSettings", v, metadata)
	}
	if s.ApiGatewayManaged != nil {
		v := *s.ApiGatewayManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiGatewayManaged", protocol.BoolValue(v), metadata)
	}
	if s.AutoDeploy != nil {
		v := *s.AutoDeploy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoDeploy", protocol.BoolValue(v), metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DefaultRouteSettings != nil {
		v := s.DefaultRouteSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultRouteSettings", v, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeploymentStatusMessage != nil {
		v := *s.LastDeploymentStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.RouteSettings != nil {
		v := s.RouteSettings

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "routeSettings", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageVariables != nil {
		v := s.StageVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Updates a Stage.
//
//    // Example sending a request using UpdateStageRequest.
//    req := client.UpdateStageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateStage
func (c *Client) UpdateStageRequest(input *UpdateStageInput) UpdateStageRequest {
	op := &aws.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/stages/{stageName}",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	req := c.newRequest(op, input, &UpdateStageOutput{})
	return UpdateStageRequest{Request: req, Input: input, Copy: c.UpdateStageRequest}
}

// UpdateStageRequest is the request type for the
// UpdateStage API operation.
type UpdateStageRequest struct {
	*aws.Request
	Input *UpdateStageInput
	Copy  func(*UpdateStageInput) UpdateStageRequest
}

// Send marshals and sends the UpdateStage API request.
func (r UpdateStageRequest) Send(ctx context.Context) (*UpdateStageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateStageResponse{
		UpdateStageOutput: r.Request.Data.(*UpdateStageOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateStageResponse is the response type for the
// UpdateStage API operation.
type UpdateStageResponse struct {
	*UpdateStageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateStage request.
func (r *UpdateStageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
