// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateBotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`

	// When true, stops the specified bot from running in your account.
	Disabled *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateBotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateBotInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.BotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateBotInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Disabled != nil {
		v := *s.Disabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Disabled", protocol.BoolValue(v), metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BotId != nil {
		v := *s.BotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "botId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateBotOutput struct {
	_ struct{} `type:"structure"`

	// The updated bot details.
	Bot *Bot `type:"structure"`
}

// String returns the string representation
func (s UpdateBotOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateBotOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bot != nil {
		v := s.Bot

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Bot", v, metadata)
	}
	return nil
}

const opUpdateBot = "UpdateBot"

// UpdateBotRequest returns a request value for making API operation for
// Amazon Chime.
//
// Updates the status of the specified bot, such as starting or stopping the
// bot from running in your Amazon Chime Enterprise account.
//
//    // Example sending a request using UpdateBotRequest.
//    req := client.UpdateBotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateBot
func (c *Client) UpdateBotRequest(input *UpdateBotInput) UpdateBotRequest {
	op := &aws.Operation{
		Name:       opUpdateBot,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}",
	}

	if input == nil {
		input = &UpdateBotInput{}
	}

	req := c.newRequest(op, input, &UpdateBotOutput{})
	return UpdateBotRequest{Request: req, Input: input, Copy: c.UpdateBotRequest}
}

// UpdateBotRequest is the request type for the
// UpdateBot API operation.
type UpdateBotRequest struct {
	*aws.Request
	Input *UpdateBotInput
	Copy  func(*UpdateBotInput) UpdateBotRequest
}

// Send marshals and sends the UpdateBot API request.
func (r UpdateBotRequest) Send(ctx context.Context) (*UpdateBotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateBotResponse{
		UpdateBotOutput: r.Request.Data.(*UpdateBotOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateBotResponse is the response type for the
// UpdateBot API operation.
type UpdateBotResponse struct {
	*UpdateBotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateBot request.
func (r *UpdateBotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
