// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RecordHandlerProgressInput struct {
	_ struct{} `type:"structure"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	//
	// BearerToken is a required field
	BearerToken *string `min:"1" type:"string" required:"true"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	ClientRequestToken *string `min:"1" type:"string"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	CurrentOperationStatus OperationStatus `type:"string" enum:"true"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	ErrorCode HandlerErrorCode `type:"string" enum:"true"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	//
	// OperationStatus is a required field
	OperationStatus OperationStatus `type:"string" required:"true" enum:"true"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	ResourceModel *string `min:"1" type:"string"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s RecordHandlerProgressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordHandlerProgressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordHandlerProgressInput"}

	if s.BearerToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("BearerToken"))
	}
	if s.BearerToken != nil && len(*s.BearerToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BearerToken", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if len(s.OperationStatus) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("OperationStatus"))
	}
	if s.ResourceModel != nil && len(*s.ResourceModel) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceModel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RecordHandlerProgressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RecordHandlerProgressOutput) String() string {
	return awsutil.Prettify(s)
}

const opRecordHandlerProgress = "RecordHandlerProgress"

// RecordHandlerProgressRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Reports progress of a resource handler to CloudFormation.
//
// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
// Do not use this API in your code.
//
//    // Example sending a request using RecordHandlerProgressRequest.
//    req := client.RecordHandlerProgressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress
func (c *Client) RecordHandlerProgressRequest(input *RecordHandlerProgressInput) RecordHandlerProgressRequest {
	op := &aws.Operation{
		Name:       opRecordHandlerProgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordHandlerProgressInput{}
	}

	req := c.newRequest(op, input, &RecordHandlerProgressOutput{})
	return RecordHandlerProgressRequest{Request: req, Input: input, Copy: c.RecordHandlerProgressRequest}
}

// RecordHandlerProgressRequest is the request type for the
// RecordHandlerProgress API operation.
type RecordHandlerProgressRequest struct {
	*aws.Request
	Input *RecordHandlerProgressInput
	Copy  func(*RecordHandlerProgressInput) RecordHandlerProgressRequest
}

// Send marshals and sends the RecordHandlerProgress API request.
func (r RecordHandlerProgressRequest) Send(ctx context.Context) (*RecordHandlerProgressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RecordHandlerProgressResponse{
		RecordHandlerProgressOutput: r.Request.Data.(*RecordHandlerProgressOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RecordHandlerProgressResponse is the response type for the
// RecordHandlerProgress API operation.
type RecordHandlerProgressResponse struct {
	*RecordHandlerProgressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RecordHandlerProgress request.
func (r *RecordHandlerProgressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
