// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to modify.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`

	// The new label for the high-availability partition group.
	Label *string `type:"string"`

	// The list of partition serial numbers to make members of the high-availability
	// partition group.
	PartitionSerialList []string `type:"list"`
}

// String returns the string representation
func (s ModifyHapgInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyHapgInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyHapgInput"}

	if s.HapgArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyHapgOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyHapg = "ModifyHapg"

// ModifyHapgRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Modifies an existing high-availability partition group.
//
//    // Example sending a request using ModifyHapgRequest.
//    req := client.ModifyHapgRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapg
func (c *Client) ModifyHapgRequest(input *ModifyHapgInput) ModifyHapgRequest {
	op := &aws.Operation{
		Name:       opModifyHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHapgInput{}
	}

	req := c.newRequest(op, input, &ModifyHapgOutput{})
	return ModifyHapgRequest{Request: req, Input: input, Copy: c.ModifyHapgRequest}
}

// ModifyHapgRequest is the request type for the
// ModifyHapg API operation.
type ModifyHapgRequest struct {
	*aws.Request
	Input *ModifyHapgInput
	Copy  func(*ModifyHapgInput) ModifyHapgRequest
}

// Send marshals and sends the ModifyHapg API request.
func (r ModifyHapgRequest) Send(ctx context.Context) (*ModifyHapgResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyHapgResponse{
		ModifyHapgOutput: r.Request.Data.(*ModifyHapgOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyHapgResponse is the response type for the
// ModifyHapg API operation.
type ModifyHapgResponse struct {
	*ModifyHapgOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyHapg request.
func (r *ModifyHapgResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
