// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DisableRuleInput struct {
	_ struct{} `type:"structure"`

	// The event bus associated with the rule. If you omit this, the default event
	// bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableRuleInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EventBusName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableRule = "DisableRule"

// DisableRuleRequest returns a request value for making API operation for
// Amazon CloudWatch Events.
//
// Disables the specified rule. A disabled rule won't match any events and won't
// self-trigger if it has a schedule expression.
//
// When you disable a rule, incoming events might continue to match to the disabled
// rule. Allow a short period of time for changes to take effect.
//
//    // Example sending a request using DisableRuleRequest.
//    req := client.DisableRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule
func (c *Client) DisableRuleRequest(input *DisableRuleInput) DisableRuleRequest {
	op := &aws.Operation{
		Name:       opDisableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRuleInput{}
	}

	req := c.newRequest(op, input, &DisableRuleOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DisableRuleRequest{Request: req, Input: input, Copy: c.DisableRuleRequest}
}

// DisableRuleRequest is the request type for the
// DisableRule API operation.
type DisableRuleRequest struct {
	*aws.Request
	Input *DisableRuleInput
	Copy  func(*DisableRuleInput) DisableRuleRequest
}

// Send marshals and sends the DisableRule API request.
func (r DisableRuleRequest) Send(ctx context.Context) (*DisableRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableRuleResponse{
		DisableRuleOutput: r.Request.Data.(*DisableRuleOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableRuleResponse is the response type for the
// DisableRule API operation.
type DisableRuleResponse struct {
	*DisableRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableRule request.
func (r *DisableRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
