// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListRepositoriesForApprovalRuleTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the approval rule template for which you want to list repositories
	// that are associated with that template.
	//
	// ApprovalRuleTemplateName is a required field
	ApprovalRuleTemplateName *string `locationName:"approvalRuleTemplateName" min:"1" type:"string" required:"true"`

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListRepositoriesForApprovalRuleTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoriesForApprovalRuleTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRepositoriesForApprovalRuleTemplateInput"}

	if s.ApprovalRuleTemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApprovalRuleTemplateName"))
	}
	if s.ApprovalRuleTemplateName != nil && len(*s.ApprovalRuleTemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApprovalRuleTemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListRepositoriesForApprovalRuleTemplateOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the next results
	// of the operation.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of repository names that are associated with the specified approval
	// rule template.
	RepositoryNames []string `locationName:"repositoryNames" type:"list"`
}

// String returns the string representation
func (s ListRepositoriesForApprovalRuleTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opListRepositoriesForApprovalRuleTemplate = "ListRepositoriesForApprovalRuleTemplate"

// ListRepositoriesForApprovalRuleTemplateRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Lists all repositories associated with the specified approval rule template.
//
//    // Example sending a request using ListRepositoriesForApprovalRuleTemplateRequest.
//    req := client.ListRepositoriesForApprovalRuleTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesForApprovalRuleTemplate
func (c *Client) ListRepositoriesForApprovalRuleTemplateRequest(input *ListRepositoriesForApprovalRuleTemplateInput) ListRepositoriesForApprovalRuleTemplateRequest {
	op := &aws.Operation{
		Name:       opListRepositoriesForApprovalRuleTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesForApprovalRuleTemplateInput{}
	}

	req := c.newRequest(op, input, &ListRepositoriesForApprovalRuleTemplateOutput{})
	return ListRepositoriesForApprovalRuleTemplateRequest{Request: req, Input: input, Copy: c.ListRepositoriesForApprovalRuleTemplateRequest}
}

// ListRepositoriesForApprovalRuleTemplateRequest is the request type for the
// ListRepositoriesForApprovalRuleTemplate API operation.
type ListRepositoriesForApprovalRuleTemplateRequest struct {
	*aws.Request
	Input *ListRepositoriesForApprovalRuleTemplateInput
	Copy  func(*ListRepositoriesForApprovalRuleTemplateInput) ListRepositoriesForApprovalRuleTemplateRequest
}

// Send marshals and sends the ListRepositoriesForApprovalRuleTemplate API request.
func (r ListRepositoriesForApprovalRuleTemplateRequest) Send(ctx context.Context) (*ListRepositoriesForApprovalRuleTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRepositoriesForApprovalRuleTemplateResponse{
		ListRepositoriesForApprovalRuleTemplateOutput: r.Request.Data.(*ListRepositoriesForApprovalRuleTemplateOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRepositoriesForApprovalRuleTemplateRequestPaginator returns a paginator for ListRepositoriesForApprovalRuleTemplate.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRepositoriesForApprovalRuleTemplateRequest(input)
//   p := codecommit.NewListRepositoriesForApprovalRuleTemplateRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRepositoriesForApprovalRuleTemplatePaginator(req ListRepositoriesForApprovalRuleTemplateRequest) ListRepositoriesForApprovalRuleTemplatePaginator {
	return ListRepositoriesForApprovalRuleTemplatePaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRepositoriesForApprovalRuleTemplateInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRepositoriesForApprovalRuleTemplatePaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRepositoriesForApprovalRuleTemplatePaginator struct {
	aws.Pager
}

func (p *ListRepositoriesForApprovalRuleTemplatePaginator) CurrentPage() *ListRepositoriesForApprovalRuleTemplateOutput {
	return p.Pager.CurrentPage().(*ListRepositoriesForApprovalRuleTemplateOutput)
}

// ListRepositoriesForApprovalRuleTemplateResponse is the response type for the
// ListRepositoriesForApprovalRuleTemplate API operation.
type ListRepositoriesForApprovalRuleTemplateResponse struct {
	*ListRepositoriesForApprovalRuleTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRepositoriesForApprovalRuleTemplate request.
func (r *ListRepositoriesForApprovalRuleTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
