// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about an AWS CodeCommit repository.
type CodeCommitRepository struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeCommit repository.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeCommitRepository) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeCommitRepository) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeCommitRepository"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeCommitRepository) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a repository.
type Repository struct {
	_ struct{} `type:"structure"`

	// Information about an AWS CodeCommit repository.
	CodeCommit *CodeCommitRepository `type:"structure"`
}

// String returns the string representation
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Repository) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Repository"}
	if s.CodeCommit != nil {
		if err := s.CodeCommit.Validate(); err != nil {
			invalidParams.AddNested("CodeCommit", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Repository) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeCommit != nil {
		v := s.CodeCommit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CodeCommit", v, metadata)
	}
	return nil
}

// Information about a repository association.
type RepositoryAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the repository association.
	AssociationArn *string `min:"1" type:"string"`

	// The id of the repository association.
	AssociationId *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the repository association
	// was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository.
	Name *string `min:"1" type:"string"`

	// The owner of the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType ProviderType `type:"string" enum:"true"`

	// The state of the repository association.
	State RepositoryAssociationState `type:"string" enum:"true"`

	// A description of why the repository association is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation
func (s RepositoryAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RepositoryAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociationArn != nil {
		v := *s.AssociationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssociationId != nil {
		v := *s.AssociationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimeStamp != nil {
		v := *s.CreatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedTimeStamp != nil {
		v := *s.LastUpdatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProviderType) > 0 {
		v := s.ProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StateReason != nil {
		v := *s.StateReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a repository association.
type RepositoryAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the repository association.
	AssociationArn *string `min:"1" type:"string"`

	// The repository association ID.
	AssociationId *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, since the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository association.
	Name *string `min:"1" type:"string"`

	// The owner of the repository association.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType ProviderType `type:"string" enum:"true"`

	// The state of the repository association.
	//
	// Associated
	//
	// Amazon CodeGuru Reviewer is associated with the repository.
	//
	// Associating
	//
	// The association is in progress.
	//
	// Failed
	//
	// The association failed. For more information about troubleshooting (or why
	// it failed), see [troubleshooting topic].
	//
	// Disassociating
	//
	// Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
	State RepositoryAssociationState `type:"string" enum:"true"`
}

// String returns the string representation
func (s RepositoryAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RepositoryAssociationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociationArn != nil {
		v := *s.AssociationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssociationId != nil {
		v := *s.AssociationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedTimeStamp != nil {
		v := *s.LastUpdatedTimeStamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimeStamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProviderType) > 0 {
		v := s.ProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
