// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the delete device pool operation.
type DeleteDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm device pool
	// you wish to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDevicePoolInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDevicePoolInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a delete device pool request.
type DeleteDevicePoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDevicePool = "DeleteDevicePool"

// DeleteDevicePoolRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Deletes a device pool given the pool ARN. Does not allow deletion of curated
// pools owned by the system.
//
//    // Example sending a request using DeleteDevicePoolRequest.
//    req := client.DeleteDevicePoolRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool
func (c *Client) DeleteDevicePoolRequest(input *DeleteDevicePoolInput) DeleteDevicePoolRequest {
	op := &aws.Operation{
		Name:       opDeleteDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDevicePoolInput{}
	}

	req := c.newRequest(op, input, &DeleteDevicePoolOutput{})
	return DeleteDevicePoolRequest{Request: req, Input: input, Copy: c.DeleteDevicePoolRequest}
}

// DeleteDevicePoolRequest is the request type for the
// DeleteDevicePool API operation.
type DeleteDevicePoolRequest struct {
	*aws.Request
	Input *DeleteDevicePoolInput
	Copy  func(*DeleteDevicePoolInput) DeleteDevicePoolRequest
}

// Send marshals and sends the DeleteDevicePool API request.
func (r DeleteDevicePoolRequest) Send(ctx context.Context) (*DeleteDevicePoolResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDevicePoolResponse{
		DeleteDevicePoolOutput: r.Request.Data.(*DeleteDevicePoolOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDevicePoolResponse is the response type for the
// DeleteDevicePool API operation.
type DeleteDevicePoolResponse struct {
	*DeleteDevicePoolOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDevicePool request.
func (r *DeleteDevicePoolResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
