// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyVpnTunnelCertificateInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the AWS Site-to-Site VPN connection.
	//
	// VpnConnectionId is a required field
	VpnConnectionId *string `type:"string" required:"true"`

	// The external IP address of the VPN tunnel.
	//
	// VpnTunnelOutsideIpAddress is a required field
	VpnTunnelOutsideIpAddress *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyVpnTunnelCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyVpnTunnelCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyVpnTunnelCertificateInput"}

	if s.VpnConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpnConnectionId"))
	}

	if s.VpnTunnelOutsideIpAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpnTunnelOutsideIpAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyVpnTunnelCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Describes a VPN connection.
	VpnConnection *VpnConnection `locationName:"vpnConnection" type:"structure"`
}

// String returns the string representation
func (s ModifyVpnTunnelCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyVpnTunnelCertificate = "ModifyVpnTunnelCertificate"

// ModifyVpnTunnelCertificateRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modifies the VPN tunnel endpoint certificate.
//
//    // Example sending a request using ModifyVpnTunnelCertificateRequest.
//    req := client.ModifyVpnTunnelCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpnTunnelCertificate
func (c *Client) ModifyVpnTunnelCertificateRequest(input *ModifyVpnTunnelCertificateInput) ModifyVpnTunnelCertificateRequest {
	op := &aws.Operation{
		Name:       opModifyVpnTunnelCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpnTunnelCertificateInput{}
	}

	req := c.newRequest(op, input, &ModifyVpnTunnelCertificateOutput{})
	return ModifyVpnTunnelCertificateRequest{Request: req, Input: input, Copy: c.ModifyVpnTunnelCertificateRequest}
}

// ModifyVpnTunnelCertificateRequest is the request type for the
// ModifyVpnTunnelCertificate API operation.
type ModifyVpnTunnelCertificateRequest struct {
	*aws.Request
	Input *ModifyVpnTunnelCertificateInput
	Copy  func(*ModifyVpnTunnelCertificateInput) ModifyVpnTunnelCertificateRequest
}

// Send marshals and sends the ModifyVpnTunnelCertificate API request.
func (r ModifyVpnTunnelCertificateRequest) Send(ctx context.Context) (*ModifyVpnTunnelCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyVpnTunnelCertificateResponse{
		ModifyVpnTunnelCertificateOutput: r.Request.Data.(*ModifyVpnTunnelCertificateOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyVpnTunnelCertificateResponse is the response type for the
// ModifyVpnTunnelCertificate API operation.
type ModifyVpnTunnelCertificateResponse struct {
	*ModifyVpnTunnelCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyVpnTunnelCertificate request.
func (r *ModifyVpnTunnelCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
