// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Provides options for deleting an archive from an Amazon S3 Glacier vault.
type DeleteArchiveInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The ID of the archive to delete.
	//
	// ArchiveId is a required field
	ArchiveId *string `location:"uri" locationName:"archiveId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteArchiveInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteArchiveInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.ArchiveId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ArchiveId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteArchiveInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ArchiveId != nil {
		v := *s.ArchiveId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "archiveId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteArchiveOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteArchiveOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteArchive = "DeleteArchive"

// DeleteArchiveRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation deletes an archive from a vault. Subsequent requests to initiate
// a retrieval of this archive will fail. Archive retrievals that are in progress
// for this archive ID may or may not succeed according to the following scenarios:
//
//    * If the archive retrieval job is actively preparing the data for download
//    when Amazon S3 Glacier receives the delete archive request, the archival
//    retrieval operation might fail.
//
//    * If the archive retrieval job has successfully prepared the archive for
//    download when Amazon S3 Glacier receives the delete archive request, you
//    will be able to download the output.
//
// This operation is idempotent. Attempting to delete an already-deleted archive
// does not result in an error.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Deleting an Archive
// in Amazon Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-an-archive.html)
// and Delete Archive (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html)
// in the Amazon Glacier Developer Guide.
//
//    // Example sending a request using DeleteArchiveRequest.
//    req := client.DeleteArchiveRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteArchiveRequest(input *DeleteArchiveInput) DeleteArchiveRequest {
	op := &aws.Operation{
		Name:       opDeleteArchive,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/archives/{archiveId}",
	}

	if input == nil {
		input = &DeleteArchiveInput{}
	}

	req := c.newRequest(op, input, &DeleteArchiveOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteArchiveRequest{Request: req, Input: input, Copy: c.DeleteArchiveRequest}
}

// DeleteArchiveRequest is the request type for the
// DeleteArchive API operation.
type DeleteArchiveRequest struct {
	*aws.Request
	Input *DeleteArchiveInput
	Copy  func(*DeleteArchiveInput) DeleteArchiveRequest
}

// Send marshals and sends the DeleteArchive API request.
func (r DeleteArchiveRequest) Send(ctx context.Context) (*DeleteArchiveResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteArchiveResponse{
		DeleteArchiveOutput: r.Request.Data.(*DeleteArchiveOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteArchiveResponse is the response type for the
// DeleteArchive API operation.
type DeleteArchiveResponse struct {
	*DeleteArchiveOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteArchive request.
func (r *DeleteArchiveResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
