// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies the status and settings of the ADM (Amazon Device Messaging) channel
// for an application.
type ADMChannelRequest struct {
	_ struct{} `type:"structure"`

	// The Client ID that you received from Amazon to send messages by using ADM.
	//
	// ClientId is a required field
	ClientId *string `type:"string" required:"true"`

	// The Client Secret that you received from Amazon to send messages by using
	// ADM.
	//
	// ClientSecret is a required field
	ClientSecret *string `type:"string" required:"true"`

	// Specifies whether to enable the ADM channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ADMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ADMChannelRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ADMChannelRequest"}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}

	if s.ClientSecret == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientSecret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ADMChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientId != nil {
		v := *s.ClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientSecret != nil {
		v := *s.ClientSecret

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientSecret", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Provides information about the status and settings of the ADM (Amazon Device
// Messaging) channel for an application.
type ADMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the ADM channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the ADM channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the ADM channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the ADM channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the ADM channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the ADM channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the ADM channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the ADM
	// channel, this value is ADM.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the ADM channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ADMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ADMChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the ADM (Amazon Device Messaging) channel.
type ADMMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The body of the notification message.
	Body *string `type:"string"`

	// An arbitrary string that indicates that multiple messages are logically the
	// same and that Amazon Device Messaging (ADM) can drop previously enqueued
	// messages in favor of this message.
	ConsolidationKey *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]string `type:"map"`

	// The amount of time, in seconds, that ADM should store the message if the
	// recipient's device is offline. Amazon Pinpoint specifies this value in the
	// expiresAfter parameter when it sends the notification message to ADM.
	ExpiresAfter *string `type:"string"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The base64-encoded, MD5 checksum of the value specified by the Data property.
	// ADM uses the MD5 value to verify the integrity of the data.
	MD5 *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s ADMMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ADMMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConsolidationKey != nil {
		v := *s.ConsolidationKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConsolidationKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ExpiresAfter != nil {
		v := *s.ExpiresAfter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpiresAfter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IconReference != nil {
		v := *s.IconReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IconReference", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MD5 != nil {
		v := *s.MD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MD5", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.SmallImageIconUrl != nil {
		v := *s.SmallImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmallImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// channel for an application.
type APNSChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with APNs by using an APNs certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with APNs, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with APNs.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with APNs by using APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) channel for an application.
type APNSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with APNs for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs channel is configured to communicate with APNs
	// by using APNs tokens. To provide an authentication key for APNs tokens, set
	// the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// channel, this value is APNS.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the APNs (Apple Push Notification service) channel.
type APNSMessage struct {
	_ struct{} `type:"structure"`

	// The type of push notification to send. Valid values are:
	//
	//    * alert - For a standard notification that's displayed on recipients'
	//    devices and prompts a recipient to interact with the notification.
	//
	//    * background - For a silent notification that delivers content in the
	//    background and isn't displayed on recipients' devices.
	//
	//    * complication - For a notification that contains update information for
	//    an app’s complication timeline.
	//
	//    * fileprovider - For a notification that signals changes to a File Provider
	//    extension.
	//
	//    * mdm - For a notification that tells managed devices to contact the MDM
	//    server.
	//
	//    * voip - For a notification that provides information about an incoming
	//    VoIP call.
	//
	// Amazon Pinpoint specifies this value in the apns-push-type request header
	// when it sends the notification message to APNs. If you don't specify a value
	// for this property, Amazon Pinpoint sets the value to alert or background
	// automatically, based on the value that you specify for the SilentPush or
	// RawContent property of the message.
	//
	// For more information about the apns-push-type request header, see Sending
	// Notification Requests to APNs (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/sending_notification_requests_to_apns)
	// on the Apple Developer website.
	APNSPushType *string `type:"string"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The key that indicates whether and how to modify the badge of your app's
	// icon when the recipient receives the push notification. If this key isn't
	// included in the dictionary, the badge doesn't change. To remove the badge,
	// set this value to 0.
	Badge *int64 `type:"integer"`

	// The body of the notification message.
	Body *string `type:"string"`

	// The key that indicates the notification type for the push notification. This
	// key is a value that's defined by the identifier property of one of your app's
	// registered categories.
	Category *string `type:"string"`

	// An arbitrary identifier that, if assigned to multiple messages, APNs uses
	// to coalesce the messages into a single push notification instead of delivering
	// each message individually. This value can't exceed 64 bytes.
	//
	// Amazon Pinpoint specifies this value in the apns-collapse-id request header
	// when it sends the notification message to APNs.
	CollapseId *string `type:"string"`

	// The JSON payload to use for a silent push notification. This payload is added
	// to the data.pinpoint.jsonBody object of the notification.
	Data map[string]string `type:"map"`

	// The URL of an image or video to display in the push notification.
	MediaUrl *string `type:"string"`

	// The authentication method that you want Amazon Pinpoint to use when authenticating
	// with APNs, CERTIFICATE or TOKEN.
	PreferredAuthenticationMethod *string `type:"string"`

	// para>5 - Low priority, the notification might be delayed, delivered as part
	// of a group, or throttled.
	// /listitem>
	// 10 - High priority, the notification is sent immediately. This is the default
	// value. A high priority notification should trigger an alert, play a sound,
	// or badge your app's icon on the recipient's device.
	// /para>
	// Amazon Pinpoint specifies this value in the apns-priority request header
	// when it sends the notification message to APNs.
	//
	// The equivalent values for Firebase Cloud Messaging (FCM), formerly Google
	// Cloud Messaging (GCM), are normal, for 5, and high, for 10. If you specify
	// an FCM value for this property, Amazon Pinpoint accepts and converts the
	// value to the corresponding APNs value.
	Priority *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	//
	// If you specify the raw content of an APNs push notification, the message
	// payload has to include the content-available key. The value of the content-available
	// key has to be an integer, and can only be 0 or 1. If you're sending a standard
	// notification, set the value of content-available to 0. If you're sending
	// a silent (background) notification, set the value of content-available to
	// 1. Additionally, silent notification payloads can't include the alert, badge,
	// or sound keys. For more information, see Generating a Remote Notification
	// (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification)
	// and Pushing Background Updates to Your App (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app)
	// on the Apple Developer website.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification. A silent
	// (or background) push notification isn't displayed on recipients' devices.
	// You can use silent push notifications to make small updates to your app,
	// or to display messages in an in-app message center.
	//
	// Amazon Pinpoint uses this property to determine the correct value for the
	// apns-push-type request header when it sends the notification message to APNs.
	// If you specify a value of true for this property, Amazon Pinpoint sets the
	// value for the apns-push-type header field to background.
	//
	// If you specify the raw content of an APNs push notification, the message
	// payload has to include the content-available key. For silent (background)
	// notifications, set the value of content-available to 1. Additionally, the
	// message payload for a silent notification can't include the alert, badge,
	// or sound keys. For more information, see Generating a Remote Notification
	// (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification)
	// and Pushing Background Updates to Your App (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app)
	// on the Apple Developer website.
	//
	// Apple has indicated that they will throttle "excessive" background notifications
	// based on current traffic volumes. To prevent your notifications being throttled,
	// Apple recommends that you send no more than 3 silent push notifications to
	// each recipient per hour.
	SilentPush *bool `type:"boolean"`

	// The key for the sound to play when the recipient receives the push notification.
	// The value for this key is the name of a sound file in your app's main bundle
	// or the Library/Sounds folder in your app's data container. If the sound file
	// can't be found or you specify default for the value, the system plays the
	// default alert sound.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override these default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`

	// The key that represents your app-specific identifier for grouping notifications.
	// If you provide a Notification Content app extension, you can use this value
	// to group your notifications together.
	ThreadId *string `type:"string"`

	// The amount of time, in seconds, that APNs should store and attempt to deliver
	// the push notification, if the service is unable to deliver the notification
	// the first time. If this value is 0, APNs treats the notification as if it
	// expires immediately and the service doesn't store or try to deliver the notification
	// again.
	//
	// Amazon Pinpoint specifies this value in the apns-expiration request header
	// when it sends the notification message to APNs.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s APNSMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.APNSPushType != nil {
		v := *s.APNSPushType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "APNSPushType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Badge != nil {
		v := *s.Badge

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Badge", protocol.Int64Value(v), metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Category != nil {
		v := *s.Category

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Category", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CollapseId != nil {
		v := *s.CollapseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CollapseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.MediaUrl != nil {
		v := *s.MediaUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MediaUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PreferredAuthenticationMethod != nil {
		v := *s.PreferredAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PreferredAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.ThreadId != nil {
		v := *s.ThreadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThreadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies channel-specific content and settings for a message template that
// can be used in push notifications that are sent through the APNs (Apple Push
// Notification service) channel.
type APNSPushNotificationTemplate struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps a push notification that's based
	// on the message template. Valid values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The message body to use in push notifications that are based on the message
	// template.
	Body *string `type:"string"`

	// The URL of an image or video to display in push notifications that are based
	// on the message template.
	MediaUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for push notifications
	// that are based on the message template. If specified, this value overrides
	// all other content for the message template.
	RawContent *string `type:"string"`

	// The key for the sound to play when the recipient receives a push notification
	// that's based on the message template. The value for this key is the name
	// of a sound file in your app's main bundle or the Library/Sounds folder in
	// your app's data container. If the sound file can't be found or you specify
	// default for the value, the system plays the default alert sound.
	Sound *string `type:"string"`

	// The title to use in push notifications that are based on the message template.
	// This title appears above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps a push notification that's based on the message template and the value
	// of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s APNSPushNotificationTemplate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSPushNotificationTemplate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MediaUrl != nil {
		v := *s.MediaUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MediaUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// sandbox channel for an application.
type APNSSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with the APNs sandbox environment by using an APNs
	// certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with the APNs sandbox environment, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs sandbox channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with the APNs sandbox environment.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with the APNs sandbox environment by using
	// APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSSandboxChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) sandbox channel for an application.
type APNSSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs sandbox channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs sandbox channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with the APNs sandbox environment for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs sandbox channel is configured to communicate with
	// APNs by using APNs tokens. To provide an authentication key for APNs tokens,
	// set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs sandbox channel. This property is
	// retained only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs sandbox channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs sandbox channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs sandbox channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// sandbox channel, this value is APNS_SANDBOX.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs sandbox channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSSandboxChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// VoIP channel for an application.
type APNSVoipChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with APNs by using an APNs certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with APNs, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs VoIP channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with APNs.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with APNs by using APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) VoIP channel for an application.
type APNSVoipChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs VoIP channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs VoIP channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with APNs for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs VoIP channel is configured to communicate with
	// APNs by using APNs tokens. To provide an authentication key for APNs tokens,
	// set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs VoIP channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs VoIP channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs VoIP channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs VoIP channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// VoIP channel, this value is APNS_VOIP.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs VoIP channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// VoIP sandbox channel for an application.
type APNSVoipSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with the APNs sandbox environment by using an APNs
	// certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with the APNs sandbox environment for this channel, key or
	// certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with the APNs sandbox environment.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with the APNs sandbox environment by using
	// APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipSandboxChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) VoIP sandbox channel for an application.
type APNSVoipSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs VoIP sandbox channel
	// applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs VoIP sandbox channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with the APNs sandbox environment for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs VoIP sandbox channel is configured to communicate
	// with APNs by using APNs tokens. To provide an authentication key for APNs
	// tokens, set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs VoIP sandbox channel. This property
	// is retained only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs VoIP sandbox channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs VoIP sandbox channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs VoIP sandbox channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipSandboxChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the activities that were performed by a campaign.
type ActivitiesResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each activity that was performed by the campaign.
	//
	// Item is a required field
	Item []ActivityResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ActivitiesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActivitiesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the configuration and other settings for an activity in a journey.
type Activity struct {
	_ struct{} `type:"structure"`

	// The settings for a yes/no split activity. This type of activity sends participants
	// down one of two paths in a journey, based on conditions that you specify.
	ConditionalSplit *ConditionalSplitActivity `type:"structure"`

	// The custom description of the activity.
	Description *string `type:"string"`

	// The settings for an email activity. This type of activity sends an email
	// message to participants.
	EMAIL *EmailMessageActivity `type:"structure"`

	// The settings for a holdout activity. This type of activity stops a journey
	// for a specified percentage of participants.
	Holdout *HoldoutActivity `type:"structure"`

	// The settings for a multivariate split activity. This type of activity sends
	// participants down one of as many as five paths in a journey, based on conditions
	// that you specify.
	MultiCondition *MultiConditionalSplitActivity `type:"structure"`

	// The settings for a random split activity. This type of activity randomly
	// sends specified percentages of participants down one of as many as five paths
	// in a journey, based on conditions that you specify.
	RandomSplit *RandomSplitActivity `type:"structure"`

	// The settings for a wait activity. This type of activity waits for a certain
	// amount of time or until a specific date and time before moving participants
	// to the next activity in a journey.
	Wait *WaitActivity `type:"structure"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Activity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Activity"}
	if s.ConditionalSplit != nil {
		if err := s.ConditionalSplit.Validate(); err != nil {
			invalidParams.AddNested("ConditionalSplit", err.(aws.ErrInvalidParams))
		}
	}
	if s.Holdout != nil {
		if err := s.Holdout.Validate(); err != nil {
			invalidParams.AddNested("Holdout", err.(aws.ErrInvalidParams))
		}
	}
	if s.MultiCondition != nil {
		if err := s.MultiCondition.Validate(); err != nil {
			invalidParams.AddNested("MultiCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Activity) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConditionalSplit != nil {
		v := s.ConditionalSplit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ConditionalSplit", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EMAIL != nil {
		v := s.EMAIL

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EMAIL", v, metadata)
	}
	if s.Holdout != nil {
		v := s.Holdout

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Holdout", v, metadata)
	}
	if s.MultiCondition != nil {
		v := s.MultiCondition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MultiCondition", v, metadata)
	}
	if s.RandomSplit != nil {
		v := s.RandomSplit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RandomSplit", v, metadata)
	}
	if s.Wait != nil {
		v := s.Wait

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Wait", v, metadata)
	}
	return nil
}

// Provides information about an activity that was performed by a campaign.
type ActivityResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the campaign applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the campaign that the activity applies to.
	//
	// CampaignId is a required field
	CampaignId *string `type:"string" required:"true"`

	// The actual time, in ISO 8601 format, when the activity was marked CANCELLED
	// or COMPLETED.
	End *string `type:"string"`

	// The unique identifier for the activity.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies whether the activity succeeded. Possible values are SUCCESS and
	// FAIL.
	Result *string `type:"string"`

	// The scheduled start time, in ISO 8601 format, for the activity.
	ScheduledStart *string `type:"string"`

	// The actual start time, in ISO 8601 format, of the activity.
	Start *string `type:"string"`

	// The current status of the activity. Possible values are: PENDING, INITIALIZING,
	// RUNNING, PAUSED, CANCELLED, and COMPLETED.
	State *string `type:"string"`

	// The total number of endpoints that the campaign successfully delivered messages
	// to.
	SuccessfulEndpointCount *int64 `type:"integer"`

	// The total number of time zones that were completed.
	TimezonesCompletedCount *int64 `type:"integer"`

	// The total number of unique time zones that are in the segment for the campaign.
	TimezonesTotalCount *int64 `type:"integer"`

	// The total number of endpoints that the campaign attempted to deliver messages
	// to.
	TotalEndpointCount *int64 `type:"integer"`

	// The unique identifier for the campaign treatment that the activity applies
	// to. A treatment is a variation of a campaign that's used for A/B testing
	// of a campaign.
	TreatmentId *string `type:"string"`
}

// String returns the string representation
func (s ActivityResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActivityResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CampaignId != nil {
		v := *s.CampaignId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CampaignId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "End", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Result != nil {
		v := *s.Result

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Result", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScheduledStart != nil {
		v := *s.ScheduledStart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScheduledStart", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SuccessfulEndpointCount != nil {
		v := *s.SuccessfulEndpointCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SuccessfulEndpointCount", protocol.Int64Value(v), metadata)
	}
	if s.TimezonesCompletedCount != nil {
		v := *s.TimezonesCompletedCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimezonesCompletedCount", protocol.Int64Value(v), metadata)
	}
	if s.TimezonesTotalCount != nil {
		v := *s.TimezonesTotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimezonesTotalCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalEndpointCount != nil {
		v := *s.TotalEndpointCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalEndpointCount", protocol.Int64Value(v), metadata)
	}
	if s.TreatmentId != nil {
		v := *s.TreatmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies address-based configuration settings for a message that's sent
// directly to an endpoint.
type AddressConfiguration struct {
	_ struct{} `type:"structure"`

	// The message body to use instead of the default message body. This value overrides
	// the default message body.
	BodyOverride *string `type:"string"`

	// The channel to use when sending the message.
	ChannelType ChannelType `type:"string" enum:"true"`

	// An object that maps custom attributes to attributes for the address and is
	// attached to the message. For a push notification, this payload is added to
	// the data.pinpoint object. For an email or text message, this payload is added
	// to email/SMS delivery receipt event attributes.
	Context map[string]string `type:"map"`

	// The raw, JSON-formatted string to use as the payload for the message. If
	// specified, this value overrides all other values for the message.
	RawContent *string `type:"string"`

	// A map of the message variables to merge with the variables specified by properties
	// of the DefaultMessage object. The variables specified in this map take precedence
	// over all other variables.
	Substitutions map[string][]string `type:"map"`

	// The message title to use instead of the default message title. This value
	// overrides the default message title.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s AddressConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddressConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BodyOverride != nil {
		v := *s.BodyOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BodyOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Context != nil {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TitleOverride != nil {
		v := *s.TitleOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TitleOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies channel-specific content and settings for a message template that
// can be used in push notifications that are sent through the ADM (Amazon Device
// Messaging), Baidu (Baidu Cloud Push), or GCM (Firebase Cloud Messaging, formerly
// Google Cloud Messaging) channel.
type AndroidPushNotificationTemplate struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps a push notification that's based
	// on the message template. Valid values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The message body to use in a push notification that's based on the message
	// template.
	Body *string `type:"string"`

	// The URL of the large icon image to display in the content view of a push
	// notification that's based on the message template.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in a push notification that's based on the
	// message template.
	ImageUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for a push notification
	// that's based on the message template. If specified, this value overrides
	// all other content for the message template.
	RawContent *string `type:"string"`

	// The URL of the small icon image to display in the status bar and the content
	// view of a push notification that's based on the message template.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when a recipient receives a push notification that's based
	// on the message template. You can use the default stream or specify the file
	// name of a sound resource that's bundled in your app. On an Android platform,
	// the sound file must reside in /res/raw/.
	Sound *string `type:"string"`

	// The title to use in a push notification that's based on the message template.
	// This title appears above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in a recipient's default mobile browser, if a recipient taps
	// a a push notification that's based on the message template and the value
	// of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s AndroidPushNotificationTemplate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AndroidPushNotificationTemplate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SmallImageIconUrl != nil {
		v := *s.SmallImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmallImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application, and provides information about that query.
type ApplicationDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of possible values, see the
	// Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the Application Metrics resource
	// because the resource returns all results in a single page.
	NextToken *string `type:"string"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ApplicationDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationDateRangeKpiResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.KpiName != nil {
		v := *s.KpiName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KpiName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KpiResult != nil {
		v := s.KpiResult

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "KpiResult", v, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Provides information about an application.
type ApplicationResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The unique identifier for the application. This identifier is displayed as
	// the Project ID on the Amazon Pinpoint console.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The display name of the application. This name is displayed as the Project
	// name on the Amazon Pinpoint console.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the application. Each tag consists of a required tag key
	// and an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ApplicationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides information about an application, including the default settings
// for an application.
type ApplicationSettingsResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application. This identifier is displayed as
	// the Project ID on the Amazon Pinpoint console.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The settings for the AWS Lambda function to use by default as a code hook
	// for campaigns in the application.
	CampaignHook *CampaignHook `type:"structure"`

	// The date and time, in ISO 8601 format, when the application's settings were
	// last modified.
	LastModifiedDate *string `type:"string"`

	// The default sending limits for campaigns in the application.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for campaigns and journeys in the application. Quiet
	// time is a specific time range when messages aren't sent to endpoints, if
	// all the following conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the application
	//    (or a campaign or journey that has custom quiet time settings).
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the application
	//    (or a campaign or journey that has custom quiet time settings).
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from a campaign or journey, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s ApplicationSettingsResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationSettingsResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CampaignHook != nil {
		v := s.CampaignHook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CampaignHook", v, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	return nil
}

// Provides information about all of your applications.
type ApplicationsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each application that was returned.
	Item []ApplicationResponse `type:"list"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ApplicationsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies attribute-based criteria for including or excluding endpoints from
// a segment.
type AttributeDimension struct {
	_ struct{} `type:"structure"`

	// The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints
	// that match the criteria are included in the segment; and, EXCLUSIVE, endpoints
	// that match the criteria are excluded from the segment.
	AttributeType AttributeType `type:"string" enum:"true"`

	// The criteria values to use for the segment dimension. Depending on the value
	// of the AttributeType property, endpoints are included or excluded from the
	// segment if their attribute values match the criteria values.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s AttributeDimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeDimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeDimension"}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributeDimension) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeType) > 0 {
		v := s.AttributeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttributeType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Provides information about the type and the names of attributes that were
// removed from all the endpoints that are associated with an application.
type AttributesResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The type of attribute or attributes that were removed from the endpoints.
	// Valid values are:
	//
	//    * endpoint-custom-attributes - Custom attributes that describe endpoints.
	//
	//    * endpoint-metric-attributes - Custom metrics that your app reports to
	//    Amazon Pinpoint for endpoints.
	//
	//    * endpoint-user-attributes - Custom attributes that describe users.
	//
	// AttributeType is a required field
	AttributeType *string `type:"string" required:"true"`

	// An array that specifies the names of the attributes that were removed from
	// the endpoints.
	Attributes []string `type:"list"`
}

// String returns the string representation
func (s AttributesResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributesResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AttributeType != nil {
		v := *s.AttributeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttributeType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies the status and settings of the Baidu (Baidu Cloud Push) channel
// for an application.
type BaiduChannelRequest struct {
	_ struct{} `type:"structure"`

	// The API key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// ApiKey is a required field
	ApiKey *string `type:"string" required:"true"`

	// Specifies whether to enable the Baidu channel for the application.
	Enabled *bool `type:"boolean"`

	// The secret key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// SecretKey is a required field
	SecretKey *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BaiduChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BaiduChannelRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BaiduChannelRequest"}

	if s.ApiKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiKey"))
	}

	if s.SecretKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BaiduChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKey != nil {
		v := *s.ApiKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApiKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.SecretKey != nil {
		v := *s.SecretKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SecretKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of the Baidu (Baidu Cloud
// Push) channel for an application.
type BaiduChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the Baidu channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the Baidu channel was enabled.
	CreationDate *string `type:"string"`

	// The API key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// Credential is a required field
	Credential *string `type:"string" required:"true"`

	// Specifies whether the Baidu channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the Baidu channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the Baidu channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the Baidu channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the Baidu channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the Baidu
	// channel, this value is BAIDU.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the Baidu channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s BaiduChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BaiduChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Credential != nil {
		v := *s.Credential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Credential", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the Baidu (Baidu Cloud Push) channel.
type BaiduMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The body of the notification message.
	Body *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]string `type:"map"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`

	// The amount of time, in seconds, that the Baidu Cloud Push service should
	// store the message if the recipient's device is offline. The default value
	// and maximum supported time is 604,800 seconds (7 days).
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s BaiduMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BaiduMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.IconReference != nil {
		v := *s.IconReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IconReference", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.SmallImageIconUrl != nil {
		v := *s.SmallImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmallImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application, campaign, or journey.
type BaseKpiResult struct {
	_ struct{} `type:"structure"`

	// An array of objects that provides the results of a query that retrieved the
	// data for a standard metric that applies to an application, campaign, or journey.
	//
	// Rows is a required field
	Rows []ResultRow `type:"list" required:"true"`
}

// String returns the string representation
func (s BaseKpiResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BaseKpiResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rows != nil {
		v := s.Rows

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Rows", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to a campaign, and provides information about that query.
type CampaignDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the campaign that the metric applies to.
	//
	// CampaignId is a required field
	CampaignId *string `type:"string" required:"true"`

	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of possible values, see the
	// Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the Campaign Metrics resource
	// because the resource returns all results in a single page.
	NextToken *string `type:"string"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s CampaignDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignDateRangeKpiResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CampaignId != nil {
		v := *s.CampaignId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CampaignId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.KpiName != nil {
		v := *s.KpiName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KpiName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KpiResult != nil {
		v := s.KpiResult

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "KpiResult", v, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Specifies the content and "From" address for an email message that's sent
// to recipients of a campaign.
type CampaignEmailMessage struct {
	_ struct{} `type:"structure"`

	// The body of the email for recipients whose email clients don't render HTML
	// content.
	Body *string `type:"string"`

	// The verified email address to send the email from. The default address is
	// the FromAddress specified for the email channel for the application.
	FromAddress *string `type:"string"`

	// The body of the email, in HTML format, for recipients whose email clients
	// render HTML content.
	HtmlBody *string `type:"string"`

	// The subject line, or title, of the email.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CampaignEmailMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CampaignEmailMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CampaignEmailMessage"}

	if s.Title == nil {
		invalidParams.Add(aws.NewErrParamRequired("Title"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignEmailMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HtmlBody != nil {
		v := *s.HtmlBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HtmlBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the settings for events that cause a campaign to be sent.
type CampaignEventFilter struct {
	_ struct{} `type:"structure"`

	// The dimension settings of the event filter for the campaign.
	//
	// Dimensions is a required field
	Dimensions *EventDimensions `type:"structure" required:"true"`

	// The type of event that causes the campaign to be sent. Valid values are:
	// SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends
	// the campaign when an endpoint event (Events resource) occurs.
	//
	// FilterType is a required field
	FilterType FilterType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CampaignEventFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CampaignEventFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CampaignEventFilter"}

	if s.Dimensions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Dimensions"))
	}
	if len(s.FilterType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FilterType"))
	}
	if s.Dimensions != nil {
		if err := s.Dimensions.Validate(); err != nil {
			invalidParams.AddNested("Dimensions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignEventFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	if len(s.FilterType) > 0 {
		v := s.FilterType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FilterType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the AWS Lambda function to use as a code hook for a campaign.
type CampaignHook struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon
	// Pinpoint invokes to send messages for a campaign.
	LambdaFunctionName *string `type:"string"`

	// Specifies which Lambda mode to use when invoking the AWS Lambda function.
	Mode Mode `type:"string" enum:"true"`

	// The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function
	// over HTTPS.
	WebUrl *string `type:"string"`
}

// String returns the string representation
func (s CampaignHook) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignHook) MarshalFields(e protocol.FieldEncoder) error {
	if s.LambdaFunctionName != nil {
		v := *s.LambdaFunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LambdaFunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.WebUrl != nil {
		v := *s.WebUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies limits on the messages that a campaign can send.
type CampaignLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that a campaign can send to a single endpoint
	// during a 24-hour period. The maximum value is 100.
	Daily *int64 `type:"integer"`

	// The maximum amount of time, in seconds, that a campaign can attempt to deliver
	// a message after the scheduled start time for the campaign. The minimum value
	// is 60 seconds.
	MaximumDuration *int64 `type:"integer"`

	// The maximum number of messages that a campaign can send each second. The
	// minimum value is 50. The maximum value is 20,000.
	MessagesPerSecond *int64 `type:"integer"`

	// The maximum number of messages that a campaign can send to a single endpoint
	// during the course of the campaign. The maximum value is 100.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignLimits) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignLimits) MarshalFields(e protocol.FieldEncoder) error {
	if s.Daily != nil {
		v := *s.Daily

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Daily", protocol.Int64Value(v), metadata)
	}
	if s.MaximumDuration != nil {
		v := *s.MaximumDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumDuration", protocol.Int64Value(v), metadata)
	}
	if s.MessagesPerSecond != nil {
		v := *s.MessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.Total != nil {
		v := *s.Total

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Total", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the status, configuration, and other settings
// for a campaign.
type CampaignResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each treatment that you defined for the campaign,
	// in addition to the default treatment.
	AdditionalTreatments []TreatmentResource `type:"list"`

	// The unique identifier for the application that the campaign applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date, ISO 8601 format, when the campaign was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The current status of the campaign's default treatment. This value exists
	// only for campaigns that have more than one treatment, to support A/B testing.
	DefaultState *CampaignState `type:"structure"`

	// The custom description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of users (segment members) who shouldn't receive
	// messages from the campaign.
	HoldoutPercent *int64 `type:"integer"`

	// The settings for the AWS Lambda function to use as a code hook for the campaign.
	Hook *CampaignHook `type:"structure"`

	// The unique identifier for the campaign.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies whether the campaign is paused. A paused campaign doesn't run unless
	// you resume it by changing this value to false.
	IsPaused *bool `type:"boolean"`

	// The date, in ISO 8601 format, when the campaign was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The messaging limits for the campaign.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings for the campaign.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The name of the campaign.
	Name *string `type:"string"`

	// The schedule settings for the campaign.
	Schedule *Schedule `type:"structure"`

	// The unique identifier for the segment that's associated with the campaign.
	//
	// SegmentId is a required field
	SegmentId *string `type:"string" required:"true"`

	// The version number of the segment that's associated with the campaign.
	//
	// SegmentVersion is a required field
	SegmentVersion *int64 `type:"integer" required:"true"`

	// The current status of the campaign.
	State *CampaignState `type:"structure"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the campaign. Each tag consists of a required tag key and
	// an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The message template that’s used for the campaign.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// The custom description of a variation of the campaign that's used for A/B
	// testing.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign that's used for A/B testing.
	TreatmentName *string `type:"string"`

	// The version number of the campaign.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdditionalTreatments != nil {
		v := s.AdditionalTreatments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AdditionalTreatments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultState != nil {
		v := s.DefaultState

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultState", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HoldoutPercent != nil {
		v := *s.HoldoutPercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HoldoutPercent", protocol.Int64Value(v), metadata)
	}
	if s.Hook != nil {
		v := s.Hook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Hook", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsPaused != nil {
		v := *s.IsPaused

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPaused", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "State", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateConfiguration != nil {
		v := s.TemplateConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TemplateConfiguration", v, metadata)
	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the content and settings for an SMS message that's sent to recipients
// of a campaign.
type CampaignSmsMessage struct {
	_ struct{} `type:"structure"`

	// The body of the SMS message.
	Body *string `type:"string"`

	// The type of SMS message. Valid values are: TRANSACTIONAL, the message is
	// critical or time-sensitive, such as a one-time password that supports a customer
	// transaction; and, PROMOTIONAL, the message isn't critical or time-sensitive,
	// such as a marketing message.
	MessageType MessageType `type:"string" enum:"true"`

	// The sender ID to display on recipients' devices when they receive the SMS
	// message.
	SenderId *string `type:"string"`
}

// String returns the string representation
func (s CampaignSmsMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignSmsMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.MessageType) > 0 {
		v := s.MessageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status of a campaign.
type CampaignState struct {
	_ struct{} `type:"structure"`

	// The current status of the campaign, or the current status of a treatment
	// that belongs to an A/B test campaign. If a campaign uses A/B testing, the
	// campaign has a status of COMPLETED only if all campaign treatments have a
	// status of COMPLETED.
	CampaignStatus CampaignStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s CampaignState) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignState) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CampaignStatus) > 0 {
		v := s.CampaignStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CampaignStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about the configuration and other settings for all the
// campaigns that are associated with an application.
type CampaignsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each campaign that's associated with the application.
	//
	// Item is a required field
	Item []CampaignResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s CampaignsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the general settings and status of a channel for
// an application.
type ChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the channel. This property is retained only
	// for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The current version of the channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the general settings and status of all channels
// for an application, including channels that aren't enabled for the application.
type ChannelsResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a multipart response for each channel. For each item
	// in this object, the ChannelType is the key and the Channel is the value.
	//
	// Channels is a required field
	Channels map[string]ChannelResponse `type:"map" required:"true"`
}

// String returns the string representation
func (s ChannelsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Channels != nil {
		v := s.Channels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Channels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Specifies the conditions to evaluate for an activity in a journey, and how
// to evaluate those conditions.
type Condition struct {
	_ struct{} `type:"structure"`

	// The conditions to evaluate for the activity.
	Conditions []SimpleCondition `type:"list"`

	// Specifies how to handle multiple conditions for the activity. For example,
	// if you specify two conditions for an activity, whether both or only one of
	// the conditions must be met for the activity to be performed.
	Operator Operator `type:"string" enum:"true"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Condition"}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Condition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Conditions != nil {
		v := s.Conditions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Conditions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Operator) > 0 {
		v := s.Operator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Operator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the settings for a yes/no split activity in a journey. This type
// of activity sends participants down one of two paths in a journey, based
// on conditions that you specify.
type ConditionalSplitActivity struct {
	_ struct{} `type:"structure"`

	// The conditions that define the paths for the activity, and the relationship
	// between the conditions.
	Condition *Condition `type:"structure"`

	// The amount of time to wait before determining whether the conditions are
	// met, or the date and time when Amazon Pinpoint determines whether the conditions
	// are met.
	EvaluationWaitTime *WaitTime `type:"structure"`

	// The unique identifier for the activity to perform if the condition isn't
	// met.
	FalseActivity *string `type:"string"`

	// The unique identifier for the activity to perform if the condition is met.
	TrueActivity *string `type:"string"`
}

// String returns the string representation
func (s ConditionalSplitActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalSplitActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConditionalSplitActivity"}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConditionalSplitActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Condition != nil {
		v := s.Condition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Condition", v, metadata)
	}
	if s.EvaluationWaitTime != nil {
		v := s.EvaluationWaitTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EvaluationWaitTime", v, metadata)
	}
	if s.FalseActivity != nil {
		v := *s.FalseActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FalseActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TrueActivity != nil {
		v := *s.TrueActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrueActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the display name of an application and the tags to associate with
// the application.
type CreateApplicationRequest struct {
	_ struct{} `type:"structure"`

	// The display name of the application. This name is displayed as the Project
	// name on the Amazon Pinpoint console.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the application. Each tag consists of a required tag key and an associated
	// tag value.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateApplicationRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateApplicationRequest"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApplicationRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides information about a request to create a message template.
type CreateTemplateMessageBody struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template that was created.
	Arn *string `type:"string"`

	// The message that's returned from the API for the request to create the message
	// template.
	Message *string `type:"string"`

	// The unique identifier for the request to create the message template.
	RequestID *string `type:"string"`
}

// String returns the string representation
func (s CreateTemplateMessageBody) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateTemplateMessageBody) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestID != nil {
		v := *s.RequestID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the default message for all channels.
type DefaultMessage struct {
	_ struct{} `type:"structure"`

	// The default body of the message.
	Body *string `type:"string"`

	// The default message variables to use in the message. You can override these
	// default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`
}

// String returns the string representation
func (s DefaultMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	return nil
}

// Specifies the default settings and content for a push notification that's
// sent directly to an endpoint.
type DefaultPushNotificationMessage struct {
	_ struct{} `type:"structure"`

	// The default action to occur if a recipient taps the push notification. Valid
	// values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS and
	//    Android platforms.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The default body of the notification message.
	Body *string `type:"string"`

	// The JSON data payload to use for the default push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]string `type:"map"`

	// Specifies whether the default notification is a silent push notification,
	// which is a push notification that doesn't display on a recipient's device.
	// Silent push notifications can be used for cases such as updating an app's
	// configuration or delivering messages to an in-app notification center.
	SilentPush *bool `type:"boolean"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`

	// The default title to display above the notification message on a recipient's
	// device.
	Title *string `type:"string"`

	// The default URL to open in a recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DefaultPushNotificationMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultPushNotificationMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the default settings and content for a message template that can
// be used in messages that are sent through a push notification channel.
type DefaultPushNotificationTemplate struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps a push notification that's based
	// on the message template. Valid values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS and
	//    Android platforms.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The message body to use in push notifications that are based on the message
	// template.
	Body *string `type:"string"`

	// The sound to play when a recipient receives a push notification that's based
	// on the message template. You can use the default stream or specify the file
	// name of a sound resource that's bundled in your app. On an Android platform,
	// the sound file must reside in /res/raw/.
	//
	// For an iOS platform, this value is the key for the name of a sound file in
	// your app's main bundle or the Library/Sounds folder in your app's data container.
	// If the sound file can't be found or you specify default for the value, the
	// system plays the default alert sound.
	Sound *string `type:"string"`

	// The title to use in push notifications that are based on the message template.
	// This title appears above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in a recipient's default mobile browser, if a recipient taps
	// a push notification that's based on the message template and the value of
	// the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DefaultPushNotificationTemplate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultPushNotificationTemplate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the settings and content for the default message and any default
// messages that you tailored for specific channels.
type DirectMessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The default push notification message for the ADM (Amazon Device Messaging)
	// channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
	ADMMessage *ADMMessage `type:"structure"`

	// The default push notification message for the APNs (Apple Push Notification
	// service) channel. This message overrides the default push notification message
	// (DefaultPushNotificationMessage).
	APNSMessage *APNSMessage `type:"structure"`

	// The default push notification message for the Baidu (Baidu Cloud Push) channel.
	// This message overrides the default push notification message (DefaultPushNotificationMessage).
	BaiduMessage *BaiduMessage `type:"structure"`

	// The default message for all channels.
	DefaultMessage *DefaultMessage `type:"structure"`

	// The default push notification message for all push notification channels.
	DefaultPushNotificationMessage *DefaultPushNotificationMessage `type:"structure"`

	// The default message for the email channel. This message overrides the default
	// message (DefaultMessage).
	EmailMessage *EmailMessage `type:"structure"`

	// The default push notification message for the GCM channel, which is used
	// to send notifications through the Firebase Cloud Messaging (FCM), formerly
	// Google Cloud Messaging (GCM), service. This message overrides the default
	// push notification message (DefaultPushNotificationMessage).
	GCMMessage *GCMMessage `type:"structure"`

	// The default message for the SMS channel. This message overrides the default
	// message (DefaultMessage).
	SMSMessage *SMSMessage `type:"structure"`

	// The default message for the voice channel. This message overrides the default
	// message (DefaultMessage).
	VoiceMessage *VoiceMessage `type:"structure"`
}

// String returns the string representation
func (s DirectMessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DirectMessageConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADMMessage != nil {
		v := s.ADMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ADMMessage", v, metadata)
	}
	if s.APNSMessage != nil {
		v := s.APNSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "APNSMessage", v, metadata)
	}
	if s.BaiduMessage != nil {
		v := s.BaiduMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BaiduMessage", v, metadata)
	}
	if s.DefaultMessage != nil {
		v := s.DefaultMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultMessage", v, metadata)
	}
	if s.DefaultPushNotificationMessage != nil {
		v := s.DefaultPushNotificationMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultPushNotificationMessage", v, metadata)
	}
	if s.EmailMessage != nil {
		v := s.EmailMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EmailMessage", v, metadata)
	}
	if s.GCMMessage != nil {
		v := s.GCMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GCMMessage", v, metadata)
	}
	if s.SMSMessage != nil {
		v := s.SMSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SMSMessage", v, metadata)
	}
	if s.VoiceMessage != nil {
		v := s.VoiceMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceMessage", v, metadata)
	}
	return nil
}

// Specifies the status and settings of the email channel for an application.
type EmailChannelRequest struct {
	_ struct{} `type:"structure"`

	// The configuration set that you want to apply to email that you send through
	// the channel by using the Amazon Pinpoint Email API (emailAPIreference.html).
	ConfigurationSet *string `type:"string"`

	// Specifies whether to enable the email channel for the application.
	Enabled *bool `type:"boolean"`

	// The verified email address that you want to send email from when you send
	// email through the channel.
	//
	// FromAddress is a required field
	FromAddress *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple
	// Email Service (Amazon SES), that you want to use when you send email through
	// the channel.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that you want
	// Amazon Pinpoint to use when it submits email-related event data for the channel.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s EmailChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailChannelRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EmailChannelRequest"}

	if s.FromAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("FromAddress"))
	}

	if s.Identity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigurationSet != nil {
		v := *s.ConfigurationSet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationSet", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Identity != nil {
		v := *s.Identity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Identity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of the email channel for
// an application.
type EmailChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the email channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The configuration set that's applied to email that's sent through the channel
	// by using the Amazon Pinpoint Email API (emailAPIreference.html).
	ConfigurationSet *string `type:"string"`

	// The date and time, in ISO 8601 format, when the email channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the email channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// The verified email address that you send email from when you send email through
	// the channel.
	FromAddress *string `type:"string"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the email channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple
	// Email Service (Amazon SES), that you use when you send email through the
	// channel.
	Identity *string `type:"string"`

	// Specifies whether the email channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the email channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the email channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The maximum number of emails that you can send through the channel each second.
	MessagesPerSecond *int64 `type:"integer"`

	// The type of messaging or notification platform for the channel. For the email
	// channel, this value is EMAIL.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that Amazon
	// Pinpoint uses to submit email-related event data for the channel.
	RoleArn *string `type:"string"`

	// The current version of the email channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s EmailChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationSet != nil {
		v := *s.ConfigurationSet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationSet", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Identity != nil {
		v := *s.Identity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Identity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessagesPerSecond != nil {
		v := *s.MessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the default settings and content for a one-time email message that's
// sent directly to an endpoint.
type EmailMessage struct {
	_ struct{} `type:"structure"`

	// The body of the email message.
	Body *string `type:"string"`

	// The email address to forward bounces and complaints to, if feedback forwarding
	// is enabled.
	FeedbackForwardingAddress *string `type:"string"`

	// The verified email address to send the email message from. The default value
	// is the FromAddress specified for the email channel.
	FromAddress *string `type:"string"`

	// The email message, represented as a raw MIME message.
	RawEmail *RawEmail `type:"structure"`

	// The reply-to email address(es) for the email message. If a recipient replies
	// to the email, each reply-to address receives the reply.
	ReplyToAddresses []string `type:"list"`

	// The email message, composed of a subject, a text part, and an HTML part.
	SimpleEmail *SimpleEmail `type:"structure"`

	// The default message variables to use in the email message. You can override
	// the default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`
}

// String returns the string representation
func (s EmailMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FeedbackForwardingAddress != nil {
		v := *s.FeedbackForwardingAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FeedbackForwardingAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawEmail != nil {
		v := s.RawEmail

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RawEmail", v, metadata)
	}
	if s.ReplyToAddresses != nil {
		v := s.ReplyToAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ReplyToAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SimpleEmail != nil {
		v := s.SimpleEmail

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SimpleEmail", v, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	return nil
}

// Specifies the settings for an email activity in a journey. This type of activity
// sends an email message to participants.
type EmailMessageActivity struct {
	_ struct{} `type:"structure"`

	// The "From" address to use for the message.
	MessageConfig *JourneyEmailMessage `type:"structure"`

	// The unique identifier for the next activity to perform, after the message
	// is sent.
	NextActivity *string `type:"string"`

	// The name of the email template to use for the message.
	TemplateName *string `type:"string"`
}

// String returns the string representation
func (s EmailMessageActivity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailMessageActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageConfig != nil {
		v := s.MessageConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfig", v, metadata)
	}
	if s.NextActivity != nil {
		v := *s.NextActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the content and settings for a message template that can be used
// in messages that are sent through the email channel.
type EmailTemplateRequest struct {
	_ struct{} `type:"structure"`

	// A JSON object that specifies the default values to use for message variables
	// in the message template. This object is a set of key-value pairs. Each key
	// defines a message variable in the template. The corresponding value defines
	// the default value for that variable. When you create a message that's based
	// on the template, you can override these defaults with message-specific and
	// address-specific variables and values.
	DefaultSubstitutions *string `type:"string"`

	// The message body, in HTML format, to use in email messages that are based
	// on the message template. We recommend using HTML format for email clients
	// that render HTML content. You can include links, formatted text, and more
	// in an HTML message.
	HtmlPart *string `type:"string"`

	// The subject line, or title, to use in email messages that are based on the
	// message template.
	Subject *string `type:"string"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the message template. Each tag consists of a required tag key and an
	// associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The message body, in plain text format, to use in email messages that are
	// based on the message template. We recommend using plain text format for email
	// clients that don't render HTML content and clients that are connected to
	// high-latency networks, such as mobile devices.
	TextPart *string `type:"string"`
}

// String returns the string representation
func (s EmailTemplateRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailTemplateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HtmlPart != nil {
		v := *s.HtmlPart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HtmlPart", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subject != nil {
		v := *s.Subject

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Subject", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TextPart != nil {
		v := *s.TextPart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TextPart", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the content and settings for a message template
// that can be used in messages that are sent through the email channel.
type EmailTemplateResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The date when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The message body, in HTML format, that's used in email messages that are
	// based on the message template.
	HtmlPart *string `type:"string"`

	// The date when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The subject line, or title, that's used in email messages that are based
	// on the message template.
	Subject *string `type:"string"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for. For an email
	// template, this value is EMAIL.
	//
	// TemplateType is a required field
	TemplateType TemplateType `type:"string" required:"true" enum:"true"`

	// The message body, in plain text format, that's used in email messages that
	// are based on the message template.
	TextPart *string `type:"string"`
}

// String returns the string representation
func (s EmailTemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailTemplateResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HtmlPart != nil {
		v := *s.HtmlPart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HtmlPart", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subject != nil {
		v := *s.Subject

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Subject", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TemplateType) > 0 {
		v := s.TemplateType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TextPart != nil {
		v := *s.TextPart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TextPart", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies an endpoint to create or update and the settings and attributes
// to set or change for the endpoint.
type EndpointBatchItem struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For a push-notification channel,
	// use the token provided by the push notification service, such as an Apple
	// Push Notification service (APNs) device token or a Firebase Cloud Messaging
	// (FCM) registration token. For the SMS channel, use a phone number in E.164
	// format, such as +12065550100. For the email channel, use an email address.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["science", "music", "travel"]. You can use these
	// attributes as filter criteria when you create segments.
	//
	// When you define the name of a custom attribute, avoid using the following
	// characters: number sign (#), colon (:), question mark (?), backslash (\),
	// and slash (/). The Amazon Pinpoint console can't display attribute names
	// that contain these characters. This limitation doesn't apply to attribute
	// values.
	Attributes map[string][]string `type:"map"`

	// The channel to use when sending messages or push notifications to the endpoint.
	ChannelType ChannelType `type:"string" enum:"true"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was created or updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether to send messages or push notifications to the endpoint.
	// Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The unique identifier for the endpoint in the context of the batch.
	Id *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the request to create or update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointBatchItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointBatchItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Specifies a batch of endpoints to create or update and the settings and attributes
// to set or change for each endpoint.
type EndpointBatchRequest struct {
	_ struct{} `type:"structure"`

	// An array that defines the endpoints to create or update and, for each endpoint,
	// the property values to set or change. An array can contain a maximum of 100
	// items.
	//
	// Item is a required field
	Item []EndpointBatchItem `type:"list" required:"true"`
}

// String returns the string representation
func (s EndpointBatchRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointBatchRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EndpointBatchRequest"}

	if s.Item == nil {
		invalidParams.Add(aws.NewErrParamRequired("Item"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointBatchRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies demographic information about an endpoint, such as the applicable
// time zone and platform.
type EndpointDemographic struct {
	_ struct{} `type:"structure"`

	// The version of the app that's associated with the endpoint.
	AppVersion *string `type:"string"`

	// The locale of the endpoint, in the following format: the ISO 639-1 alpha-2
	// code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.
	Locale *string `type:"string"`

	// The manufacturer of the endpoint device, such as Apple or Samsung.
	Make *string `type:"string"`

	// The model name or number of the endpoint device, such as iPhone.
	Model *string `type:"string"`

	// The model version of the endpoint device.
	ModelVersion *string `type:"string"`

	// The platform of the endpoint device, such as iOS or Android.
	Platform *string `type:"string"`

	// The platform version of the endpoint device.
	PlatformVersion *string `type:"string"`

	// The time zone of the endpoint, specified as a tz database name value, such
	// as America/Los_Angeles.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EndpointDemographic) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointDemographic) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppVersion != nil {
		v := *s.AppVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Locale != nil {
		v := *s.Locale

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Locale", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Make != nil {
		v := *s.Make

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Make", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Model != nil {
		v := *s.Model

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Model", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelVersion != nil {
		v := *s.ModelVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModelVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PlatformVersion != nil {
		v := *s.PlatformVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PlatformVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timezone != nil {
		v := *s.Timezone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timezone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides the status code and message that result from processing data for
// an endpoint.
type EndpointItemResponse struct {
	_ struct{} `type:"structure"`

	// The custom message that's returned in the response as a result of processing
	// the endpoint data.
	Message *string `type:"string"`

	// The status code that's returned in the response as a result of processing
	// the endpoint data.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EndpointItemResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointItemResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies geographic information about an endpoint.
type EndpointLocation struct {
	_ struct{} `type:"structure"`

	// The name of the city where the endpoint is located.
	City *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the endpoint is located. For example, US for the United States.
	Country *string `type:"string"`

	// The latitude coordinate of the endpoint location, rounded to one decimal
	// place.
	Latitude *float64 `type:"double"`

	// The longitude coordinate of the endpoint location, rounded to one decimal
	// place.
	Longitude *float64 `type:"double"`

	// The postal or ZIP code for the area where the endpoint is located.
	PostalCode *string `type:"string"`

	// The name of the region where the endpoint is located. For locations in the
	// United States, this value is the name of a state.
	Region *string `type:"string"`
}

// String returns the string representation
func (s EndpointLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.City != nil {
		v := *s.City

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "City", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Country != nil {
		v := *s.Country

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Country", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Latitude != nil {
		v := *s.Latitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Latitude", protocol.Float64Value(v), metadata)
	}
	if s.Longitude != nil {
		v := *s.Longitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Longitude", protocol.Float64Value(v), metadata)
	}
	if s.PostalCode != nil {
		v := *s.PostalCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PostalCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the delivery status and results of sending a message
// directly to an endpoint.
type EndpointMessageResult struct {
	_ struct{} `type:"structure"`

	// The endpoint address that the message was delivered to.
	Address *string `type:"string"`

	// The delivery status of the message. Possible values are:
	//
	//    * DUPLICATE - The endpoint address is a duplicate of another endpoint
	//    address. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * OPT_OUT - The user who's associated with the endpoint has opted out
	//    of receiving messages from you. Amazon Pinpoint won't attempt to send
	//    the message again.
	//
	//    * PERMANENT_FAILURE - An error occurred when delivering the message to
	//    the endpoint. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * SUCCESSFUL - The message was successfully delivered to the endpoint.
	//
	//    * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint will
	//    attempt to deliver the message again later.
	//
	//    * THROTTLED - Amazon Pinpoint throttled the operation to send the message
	//    to the endpoint.
	//
	//    * TIMEOUT - The message couldn't be sent within the timeout period.
	//
	//    * UNKNOWN_FAILURE - An unknown error occurred.
	//
	// DeliveryStatus is a required field
	DeliveryStatus DeliveryStatus `type:"string" required:"true" enum:"true"`

	// The unique identifier for the message that was sent.
	MessageId *string `type:"string"`

	// The downstream service status code for delivering the message.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The status message for delivering the message.
	StatusMessage *string `type:"string"`

	// For push notifications that are sent through the GCM channel, specifies whether
	// the endpoint's device registration token was updated as part of delivering
	// the message.
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s EndpointMessageResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointMessageResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DeliveryStatus) > 0 {
		v := s.DeliveryStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeliveryStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedToken != nil {
		v := *s.UpdatedToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the channel type and other settings for an endpoint.
type EndpointRequest struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For a push-notification channel,
	// use the token provided by the push notification service, such as an Apple
	// Push Notification service (APNs) device token or a Firebase Cloud Messaging
	// (FCM) registration token. For the SMS channel, use a phone number in E.164
	// format, such as +12065550100. For the email channel, use an email address.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["science", "music", "travel"]. You can use these
	// attributes as filter criteria when you create segments.
	//
	// When you define the name of a custom attribute, avoid using the following
	// characters: number sign (#), colon (:), question mark (?), backslash (\),
	// and slash (/). The Amazon Pinpoint console can't display attribute names
	// that contain these characters. This limitation doesn't apply to attribute
	// values.
	Attributes map[string][]string `type:"map"`

	// The channel to use when sending messages or push notifications to the endpoint.
	ChannelType ChannelType `type:"string" enum:"true"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint is updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether to send messages or push notifications to the endpoint.
	// Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom user attributes that describe the user who's associated
	// with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Provides information about the channel type and other settings for an endpoint.
type EndpointResponse struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For example, the address
	// for a push-notification channel is typically the token provided by a push
	// notification service, such as an Apple Push Notification service (APNs) device
	// token or a Firebase Cloud Messaging (FCM) registration token. The address
	// for the SMS channel is a phone number in E.164 format, such as +12065550100.
	// The address for the email channel is an email address.
	Address *string `type:"string"`

	// The unique identifier for the application that's associated with the endpoint.
	ApplicationId *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["science", "music", "travel"]. You can use these
	// attributes as filter criteria when you create segments.
	Attributes map[string][]string `type:"map"`

	// The channel that's used when sending messages or push notifications to the
	// endpoint.
	ChannelType ChannelType `type:"string" enum:"true"`

	// A number from 0-99 that represents the cohort that the endpoint is assigned
	// to. Endpoints are grouped into cohorts randomly, and each cohort contains
	// approximately 1 percent of the endpoints for an application. Amazon Pinpoint
	// assigns cohorts to the holdout or treatment allocations for campaigns.
	CohortId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the endpoint was created.
	CreationDate *string `type:"string"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was last updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether messages or push notifications are sent to the endpoint.
	// Possible values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The unique identifier that you assigned to the endpoint. The identifier should
	// be a globally unique identifier (GUID) to ensure that it doesn't conflict
	// with other endpoint identifiers that are associated with the application.
	Id *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CohortId != nil {
		v := *s.CohortId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CohortId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Specifies the content, including message variables and attributes, to use
// in a message that's sent directly to an endpoint.
type EndpointSendConfiguration struct {
	_ struct{} `type:"structure"`

	// The body of the message. If specified, this value overrides the default message
	// body.
	BodyOverride *string `type:"string"`

	// A map of custom attributes to attach to the message for the address. For
	// a push notification, this payload is added to the data.pinpoint object. For
	// an email or text message, this payload is added to email/SMS delivery receipt
	// event attributes.
	Context map[string]string `type:"map"`

	// The raw, JSON-formatted string to use as the payload for the message. If
	// specified, this value overrides all other values for the message.
	RawContent *string `type:"string"`

	// A map of the message variables to merge with the variables specified for
	// the default message (DefaultMessage.Substitutions). The variables specified
	// in this map take precedence over all other variables.
	Substitutions map[string][]string `type:"map"`

	// The title or subject line of the message. If specified, this value overrides
	// the default message title or subject line.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s EndpointSendConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointSendConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BodyOverride != nil {
		v := *s.BodyOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BodyOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Context != nil {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TitleOverride != nil {
		v := *s.TitleOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TitleOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies data for one or more attributes that describe the user who's associated
// with an endpoint.
type EndpointUser struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes that describe the user by associating a name
	// with an array of values. For example, the value of an attribute named Interests
	// might be: ["science", "music", "travel"]. You can use these attributes as
	// filter criteria when you create segments.
	//
	// When you define the name of a custom attribute, avoid using the following
	// characters: number sign (#), colon (:), question mark (?), backslash (\),
	// and slash (/). The Amazon Pinpoint console can't display attribute names
	// that contain these characters. This limitation doesn't apply to attribute
	// values.
	UserAttributes map[string][]string `type:"map"`

	// The unique identifier for the user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s EndpointUser) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointUser) MarshalFields(e protocol.FieldEncoder) error {
	if s.UserAttributes != nil {
		v := s.UserAttributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserAttributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about all the endpoints that are associated with a user
// ID.
type EndpointsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each endpoint that's associated with the user
	// ID.
	//
	// Item is a required field
	Item []EndpointResponse `type:"list" required:"true"`
}

// String returns the string representation
func (s EndpointsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies information about an event that reports data to Amazon Pinpoint.
type Event struct {
	_ struct{} `type:"structure"`

	// The package name of the app that's recording the event.
	AppPackageName *string `type:"string"`

	// The title of the app that's recording the event.
	AppTitle *string `type:"string"`

	// The version number of the app that's recording the event.
	AppVersionCode *string `type:"string"`

	// One or more custom attributes that are associated with the event.
	Attributes map[string]string `type:"map"`

	// The version of the SDK that's running on the client device.
	ClientSdkVersion *string `type:"string"`

	// The name of the event.
	//
	// EventType is a required field
	EventType *string `type:"string" required:"true"`

	// One or more custom metrics that are associated with the event.
	Metrics map[string]float64 `type:"map"`

	// The name of the SDK that's being used to record the event.
	SdkName *string `type:"string"`

	// Information about the session in which the event occurred.
	Session *Session `type:"structure"`

	// The date and time, in ISO 8601 format, when the event occurred.
	//
	// Timestamp is a required field
	Timestamp *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Event) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Event"}

	if s.EventType == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventType"))
	}

	if s.Timestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("Timestamp"))
	}
	if s.Session != nil {
		if err := s.Session.Validate(); err != nil {
			invalidParams.AddNested("Session", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Event) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppPackageName != nil {
		v := *s.AppPackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppPackageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppTitle != nil {
		v := *s.AppTitle

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppTitle", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppVersionCode != nil {
		v := *s.AppVersionCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppVersionCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ClientSdkVersion != nil {
		v := *s.ClientSdkVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientSdkVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventType != nil {
		v := *s.EventType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.SdkName != nil {
		v := *s.SdkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SdkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Session != nil {
		v := s.Session

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Session", v, metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the conditions to evaluate for an event that applies to an activity
// in a journey.
type EventCondition struct {
	_ struct{} `type:"structure"`

	// The dimensions for the event filter to use for the activity.
	//
	// Dimensions is a required field
	Dimensions *EventDimensions `type:"structure" required:"true"`

	// The message identifier (message_id) for the message to use when determining
	// whether message events meet the condition.
	MessageActivity *string `type:"string"`
}

// String returns the string representation
func (s EventCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EventCondition"}

	if s.Dimensions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Dimensions"))
	}
	if s.Dimensions != nil {
		if err := s.Dimensions.Validate(); err != nil {
			invalidParams.AddNested("Dimensions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventCondition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	if s.MessageActivity != nil {
		v := *s.MessageActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the dimensions for an event filter that determines when a campaign
// is sent or a journey activity is performed.
type EventDimensions struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes that your application reports to Amazon Pinpoint.
	// You can use these attributes as selection criteria when you create an event
	// filter.
	Attributes map[string]AttributeDimension `type:"map"`

	// The name of the event that causes the campaign to be sent or the journey
	// activity to be performed. This can be a standard type of event that Amazon
	// Pinpoint generates, such as _email.delivered, or a custom event that's specific
	// to your application.
	EventType *SetDimension `type:"structure"`

	// One or more custom metrics that your application reports to Amazon Pinpoint.
	// You can use these metrics as selection criteria when you create an event
	// filter.
	Metrics map[string]MetricDimension `type:"map"`
}

// String returns the string representation
func (s EventDimensions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDimensions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EventDimensions"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.EventType != nil {
		if err := s.EventType.Validate(); err != nil {
			invalidParams.AddNested("EventType", err.(aws.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventDimensions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.EventType != nil {
		v := s.EventType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EventType", v, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Provides the status code and message that result from processing an event.
type EventItemResponse struct {
	_ struct{} `type:"structure"`

	// A custom message that's returned in the response as a result of processing
	// the event.
	Message *string `type:"string"`

	// The status code that's returned in the response as a result of processing
	// the event. Possible values are: 202, for events that were accepted; and,
	// 400, for events that weren't valid.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EventItemResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventItemResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies settings for publishing event data to an Amazon Kinesis data stream
// or an Amazon Kinesis Data Firehose delivery stream.
type EventStream struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application to publish event data for.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon
	// Kinesis Data Firehose delivery stream to publish event data to.
	//
	// For a Kinesis data stream, the ARN format is: arn:aws:kinesis:region:account-id:stream/stream_name
	//
	// For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:region:account-id:deliverystream/stream_name
	//
	// DestinationStreamArn is a required field
	DestinationStreamArn *string `type:"string" required:"true"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when publishing event data, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The date, in ISO 8601 format, when the event stream was last modified.
	LastModifiedDate *string `type:"string"`

	// The IAM user who last modified the event stream.
	LastUpdatedBy *string `type:"string"`

	// The AWS Identity and Access Management (IAM) role that authorizes Amazon
	// Pinpoint to publish event data to the stream in your AWS account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EventStream) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventStream) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationStreamArn != nil {
		v := *s.DestinationStreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationStreamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedBy != nil {
		v := *s.LastUpdatedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies a batch of endpoints and events to process.
type EventsBatch struct {
	_ struct{} `type:"structure"`

	// A set of properties and attributes that are associated with the endpoint.
	//
	// Endpoint is a required field
	Endpoint *PublicEndpoint `type:"structure" required:"true"`

	// A set of properties that are associated with the event.
	//
	// Events is a required field
	Events map[string]Event `type:"map" required:"true"`
}

// String returns the string representation
func (s EventsBatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventsBatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EventsBatch"}

	if s.Endpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("Endpoint"))
	}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventsBatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.Endpoint != nil {
		v := s.Endpoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Endpoint", v, metadata)
	}
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Events", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Specifies a batch of events to process.
type EventsRequest struct {
	_ struct{} `type:"structure"`

	// The batch of events to process. For each item in a batch, the endpoint ID
	// acts as a key that has an EventsBatch object as its value.
	//
	// BatchItem is a required field
	BatchItem map[string]EventsBatch `type:"map" required:"true"`
}

// String returns the string representation
func (s EventsRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventsRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EventsRequest"}

	if s.BatchItem == nil {
		invalidParams.Add(aws.NewErrParamRequired("BatchItem"))
	}
	if s.BatchItem != nil {
		for i, v := range s.BatchItem {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BatchItem", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventsRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchItem != nil {
		v := s.BatchItem

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "BatchItem", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Provides information about endpoints and the events that they're associated
// with.
type EventsResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a multipart response for each endpoint. For each item
	// in this object, the endpoint ID is the key and the item response is the value.
	// If no item response exists, the value can also be one of the following: 202,
	// the request was processed successfully; or 400, the payload wasn't valid
	// or required fields were missing.
	Results map[string]ItemResponse `type:"map"`
}

// String returns the string representation
func (s EventsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Results != nil {
		v := s.Results

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Results", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Specifies the settings for a job that exports endpoint definitions to an
// Amazon Simple Storage Service (Amazon S3) bucket.
type ExportJobRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// where you want to export endpoint definitions to.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket
	// where you want to export endpoint definitions to. This location is typically
	// a folder that contains multiple files. The URL should be in the following
	// format: s3://bucket-name/folder-name/.
	//
	// S3UrlPrefix is a required field
	S3UrlPrefix *string `type:"string" required:"true"`

	// The identifier for the segment to export endpoint definitions from. If you
	// don't specify this value, Amazon Pinpoint exports definitions for all the
	// endpoints that are associated with the application.
	SegmentId *string `type:"string"`

	// The version of the segment to export endpoint definitions from, if specified.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportJobRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportJobRequest"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.S3UrlPrefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3UrlPrefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3UrlPrefix != nil {
		v := *s.S3UrlPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3UrlPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the resource settings for a job that exports endpoint
// definitions to a file. The file can be added directly to an Amazon Simple
// Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded
// directly to a computer by using the Amazon Pinpoint console.
type ExportJobResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location
	// where the endpoint definitions were exported to.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket
	// where the endpoint definitions were exported to. This location is typically
	// a folder that contains multiple files. The URL should be in the following
	// format: s3://bucket-name/folder-name/.
	//
	// S3UrlPrefix is a required field
	S3UrlPrefix *string `type:"string" required:"true"`

	// The identifier for the segment that the endpoint definitions were exported
	// from. If this value isn't present, Amazon Pinpoint exported definitions for
	// all the endpoints that are associated with the application.
	SegmentId *string `type:"string"`

	// The version of the segment that the endpoint definitions were exported from.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3UrlPrefix != nil {
		v := *s.S3UrlPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3UrlPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the status and settings of a job that exports
// endpoint definitions to a file. The file can be added directly to an Amazon
// Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API
// or downloaded directly to a computer by using the Amazon Pinpoint console.
type ExportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that's associated with the export
	// job.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The number of pieces that were processed successfully (completed) by the
	// export job, as of the time of the request.
	CompletedPieces *int64 `type:"integer"`

	// The date, in ISO 8601 format, when the export job was completed.
	CompletionDate *string `type:"string"`

	// The date, in ISO 8601 format, when the export job was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The resource settings that apply to the export job.
	//
	// Definition is a required field
	Definition *ExportJobResource `type:"structure" required:"true"`

	// The number of pieces that weren't processed successfully (failed) by the
	// export job, as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// An array of entries, one for each of the first 100 entries that weren't processed
	// successfully (failed) by the export job, if any.
	Failures []string `type:"list"`

	// The unique identifier for the export job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of the export job. The job status is FAILED if Amazon Pinpoint
	// wasn't able to process one or more pieces in the job.
	//
	// JobStatus is a required field
	JobStatus JobStatus `type:"string" required:"true" enum:"true"`

	// The total number of endpoint definitions that weren't processed successfully
	// (failed) by the export job, typically because an error, such as a syntax
	// error, occurred.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to complete the export
	// job. Each piece consists of an approximately equal portion of the endpoint
	// definitions that are part of the export job.
	TotalPieces *int64 `type:"integer"`

	// The total number of endpoint definitions that were processed by the export
	// job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. This value is EXPORT for export jobs.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CompletedPieces != nil {
		v := *s.CompletedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletedPieces", protocol.Int64Value(v), metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Definition != nil {
		v := s.Definition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Definition", v, metadata)
	}
	if s.FailedPieces != nil {
		v := *s.FailedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailedPieces", protocol.Int64Value(v), metadata)
	}
	if s.Failures != nil {
		v := s.Failures

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Failures", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.JobStatus) > 0 {
		v := s.JobStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TotalFailures != nil {
		v := *s.TotalFailures

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalFailures", protocol.Int64Value(v), metadata)
	}
	if s.TotalPieces != nil {
		v := *s.TotalPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalPieces", protocol.Int64Value(v), metadata)
	}
	if s.TotalProcessed != nil {
		v := *s.TotalProcessed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalProcessed", protocol.Int64Value(v), metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about all the export jobs that are associated with an
// application or segment. An export job is a job that exports endpoint definitions
// to a file.
type ExportJobsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each export job that's associated with the
	// application (Export Jobs resource) or segment (Segment Export Jobs resource).
	//
	// Item is a required field
	Item []ExportJobResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ExportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the status and settings of the GCM channel for an application.
// This channel enables Amazon Pinpoint to send push notifications through the
// Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
type GCMChannelRequest struct {
	_ struct{} `type:"structure"`

	// The Web API Key, also referred to as an API_KEY or server key, that you received
	// from Google to communicate with Google services.
	//
	// ApiKey is a required field
	ApiKey *string `type:"string" required:"true"`

	// Specifies whether to enable the GCM channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GCMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GCMChannelRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GCMChannelRequest"}

	if s.ApiKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GCMChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKey != nil {
		v := *s.ApiKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApiKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Provides information about the status and settings of the GCM channel for
// an application. The GCM channel enables Amazon Pinpoint to send push notifications
// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
// (GCM), service.
type GCMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the GCM channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the GCM channel was enabled.
	CreationDate *string `type:"string"`

	// The Web API Key, also referred to as an API_KEY or server key, that you received
	// from Google to communicate with Google services.
	//
	// Credential is a required field
	Credential *string `type:"string" required:"true"`

	// Specifies whether the GCM channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the GCM channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the GCM channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the GCM channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the GCM channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the GCM
	// channel, this value is GCM.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the GCM channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s GCMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GCMChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Credential != nil {
		v := *s.Credential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Credential", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the GCM channel. The GCM channel enables Amazon Pinpoint
// to send messages to the Firebase Cloud Messaging (FCM), formerly Google Cloud
// Messaging (GCM), service.
type GCMMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The body of the notification message.
	Body *string `type:"string"`

	// An arbitrary string that identifies a group of messages that can be collapsed
	// to ensure that only the last message is sent when delivery can resume. This
	// helps avoid sending too many instances of the same messages when the recipient's
	// device comes online again or becomes active.
	//
	// Amazon Pinpoint specifies this value in the Firebase Cloud Messaging (FCM)
	// collapse_key parameter when it sends the notification message to FCM.
	CollapseKey *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]string `type:"map"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// para>normal - The notification might be delayed. Delivery is optimized for
	// battery usage on the recipient's device. Use this value unless immediate
	// delivery is required.
	// /listitem>
	// high - The notification is sent immediately and might wake a sleeping device.
	// /para>
	// Amazon Pinpoint specifies this value in the FCM priority parameter when it
	// sends the notification message to FCM.
	//
	// The equivalent values for Apple Push Notification service (APNs) are 5, for
	// normal, and 10, for high. If you specify an APNs value for this property,
	// Amazon Pinpoint accepts and converts the value to the corresponding FCM value.
	Priority *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// The package name of the application where registration tokens must match
	// in order for the recipient to receive the message.
	RestrictedPackageName *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`

	// The amount of time, in seconds, that FCM should store and attempt to deliver
	// the push notification, if the service is unable to deliver the notification
	// the first time. If you don't specify this value, FCM defaults to the maximum
	// value, which is 2,419,200 seconds (28 days).
	//
	// Amazon Pinpoint specifies this value in the FCM time_to_live parameter when
	// it sends the notification message to FCM.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s GCMMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GCMMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CollapseKey != nil {
		v := *s.CollapseKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CollapseKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.IconReference != nil {
		v := *s.IconReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IconReference", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestrictedPackageName != nil {
		v := *s.RestrictedPackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestrictedPackageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.SmallImageIconUrl != nil {
		v := *s.SmallImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmallImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the GPS coordinates of a location.
type GPSCoordinates struct {
	_ struct{} `type:"structure"`

	// The latitude coordinate of the location.
	//
	// Latitude is a required field
	Latitude *float64 `type:"double" required:"true"`

	// The longitude coordinate of the location.
	//
	// Longitude is a required field
	Longitude *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s GPSCoordinates) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GPSCoordinates) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GPSCoordinates"}

	if s.Latitude == nil {
		invalidParams.Add(aws.NewErrParamRequired("Latitude"))
	}

	if s.Longitude == nil {
		invalidParams.Add(aws.NewErrParamRequired("Longitude"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GPSCoordinates) MarshalFields(e protocol.FieldEncoder) error {
	if s.Latitude != nil {
		v := *s.Latitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Latitude", protocol.Float64Value(v), metadata)
	}
	if s.Longitude != nil {
		v := *s.Longitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Longitude", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Specifies GPS-based criteria for including or excluding endpoints from a
// segment.
type GPSPointDimension struct {
	_ struct{} `type:"structure"`

	// The GPS coordinates to measure distance from.
	//
	// Coordinates is a required field
	Coordinates *GPSCoordinates `type:"structure" required:"true"`

	// The range, in kilometers, from the GPS coordinates.
	RangeInKilometers *float64 `type:"double"`
}

// String returns the string representation
func (s GPSPointDimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GPSPointDimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GPSPointDimension"}

	if s.Coordinates == nil {
		invalidParams.Add(aws.NewErrParamRequired("Coordinates"))
	}
	if s.Coordinates != nil {
		if err := s.Coordinates.Validate(); err != nil {
			invalidParams.AddNested("Coordinates", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GPSPointDimension) MarshalFields(e protocol.FieldEncoder) error {
	if s.Coordinates != nil {
		v := s.Coordinates

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Coordinates", v, metadata)
	}
	if s.RangeInKilometers != nil {
		v := *s.RangeInKilometers

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RangeInKilometers", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Specifies the settings for a holdout activity in a journey. This type of
// activity stops a journey for a specified percentage of participants.
type HoldoutActivity struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the next activity to perform, after performing
	// the holdout activity.
	NextActivity *string `type:"string"`

	// The percentage of participants who shouldn't continue the journey.
	//
	// Percentage is a required field
	Percentage *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s HoldoutActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HoldoutActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HoldoutActivity"}

	if s.Percentage == nil {
		invalidParams.Add(aws.NewErrParamRequired("Percentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HoldoutActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextActivity != nil {
		v := *s.NextActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Percentage != nil {
		v := *s.Percentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Percentage", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the settings for a job that imports endpoint definitions from an
// Amazon Simple Storage Service (Amazon S3) bucket.
type ImportJobRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to create a segment that contains the endpoints, when the
	// endpoint definitions are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions to import.
	// Valid values are: CSV, for comma-separated values format; and, JSON, for
	// newline-delimited JSON format. If the Amazon S3 location stores multiple
	// files that use different formats, Amazon Pinpoint imports data only from
	// the files that use the specified format.
	//
	// Format is a required field
	Format Format `type:"string" required:"true" enum:"true"`

	// Specifies whether to register the endpoints with Amazon Pinpoint, when the
	// endpoint definitions are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains
	// the endpoint definitions to import. This location can be a folder or a single
	// file. If the location is a folder, Amazon Pinpoint imports endpoint definitions
	// from the files in this location, including any subfolders that the folder
	// contains.
	//
	// The URL should be in the following format: s3://bucket-name/folder-name/file-name.
	// The location can end with the key for an individual object or a prefix that
	// qualifies multiple objects.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The identifier for the segment to update or add the imported endpoint definitions
	// to, if the import job is meant to update an existing segment.
	SegmentId *string `type:"string"`

	// The custom name for the segment that's created by the import job, if the
	// value of the DefineSegment property is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportJobRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportJobRequest"}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.S3Url == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefineSegment != nil {
		v := *s.DefineSegment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefineSegment", protocol.BoolValue(v), metadata)
	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RegisterEndpoints != nil {
		v := *s.RegisterEndpoints

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegisterEndpoints", protocol.BoolValue(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Url != nil {
		v := *s.S3Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentName != nil {
		v := *s.SegmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the resource settings for a job that imports endpoint
// definitions from one or more files. The files can be stored in an Amazon
// Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer
// by using the Amazon Pinpoint console.
type ImportJobResource struct {
	_ struct{} `type:"structure"`

	// Specifies whether the import job creates a segment that contains the endpoints,
	// when the endpoint definitions are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions to import.
	// Valid values are: CSV, for comma-separated values format; and, JSON, for
	// newline-delimited JSON format.
	//
	// If the files are stored in an Amazon S3 location and that location contains
	// multiple files that use different formats, Amazon Pinpoint imports data only
	// from the files that use the specified format.
	//
	// Format is a required field
	Format Format `type:"string" required:"true" enum:"true"`

	// Specifies whether the import job registers the endpoints with Amazon Pinpoint,
	// when the endpoint definitions are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains
	// the endpoint definitions to import. This location can be a folder or a single
	// file. If the location is a folder, Amazon Pinpoint imports endpoint definitions
	// from the files in this location, including any subfolders that the folder
	// contains.
	//
	// The URL should be in the following format: s3://bucket-name/folder-name/file-name.
	// The location can end with the key for an individual object or a prefix that
	// qualifies multiple objects.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The identifier for the segment that the import job updates or adds endpoint
	// definitions to, if the import job updates an existing segment.
	SegmentId *string `type:"string"`

	// The custom name for the segment that's created by the import job, if the
	// value of the DefineSegment property is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefineSegment != nil {
		v := *s.DefineSegment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefineSegment", protocol.BoolValue(v), metadata)
	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RegisterEndpoints != nil {
		v := *s.RegisterEndpoints

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegisterEndpoints", protocol.BoolValue(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Url != nil {
		v := *s.S3Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentName != nil {
		v := *s.SegmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of a job that imports
// endpoint definitions from one or more files. The files can be stored in an
// Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from
// a computer by using the Amazon Pinpoint console.
type ImportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that's associated with the import
	// job.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The number of pieces that were processed successfully (completed) by the
	// import job, as of the time of the request.
	CompletedPieces *int64 `type:"integer"`

	// The date, in ISO 8601 format, when the import job was completed.
	CompletionDate *string `type:"string"`

	// The date, in ISO 8601 format, when the import job was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The resource settings that apply to the import job.
	//
	// Definition is a required field
	Definition *ImportJobResource `type:"structure" required:"true"`

	// The number of pieces that weren't processed successfully (failed) by the
	// import job, as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// An array of entries, one for each of the first 100 entries that weren't processed
	// successfully (failed) by the import job, if any.
	Failures []string `type:"list"`

	// The unique identifier for the import job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of the import job. The job status is FAILED if Amazon Pinpoint
	// wasn't able to process one or more pieces in the job.
	//
	// JobStatus is a required field
	JobStatus JobStatus `type:"string" required:"true" enum:"true"`

	// The total number of endpoint definitions that weren't processed successfully
	// (failed) by the import job, typically because an error, such as a syntax
	// error, occurred.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to complete the import
	// job. Each piece consists of an approximately equal portion of the endpoint
	// definitions that are part of the import job.
	TotalPieces *int64 `type:"integer"`

	// The total number of endpoint definitions that were processed by the import
	// job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. This value is IMPORT for import jobs.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CompletedPieces != nil {
		v := *s.CompletedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletedPieces", protocol.Int64Value(v), metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Definition != nil {
		v := s.Definition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Definition", v, metadata)
	}
	if s.FailedPieces != nil {
		v := *s.FailedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailedPieces", protocol.Int64Value(v), metadata)
	}
	if s.Failures != nil {
		v := s.Failures

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Failures", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.JobStatus) > 0 {
		v := s.JobStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TotalFailures != nil {
		v := *s.TotalFailures

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalFailures", protocol.Int64Value(v), metadata)
	}
	if s.TotalPieces != nil {
		v := *s.TotalPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalPieces", protocol.Int64Value(v), metadata)
	}
	if s.TotalProcessed != nil {
		v := *s.TotalProcessed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalProcessed", protocol.Int64Value(v), metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of all the import jobs
// that are associated with an application or segment. An import job is a job
// that imports endpoint definitions from one or more files.
type ImportJobsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each import job that's associated with the
	// application (Import Jobs resource) or segment (Segment Import Jobs resource).
	//
	// Item is a required field
	Item []ImportJobResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ImportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the results of a request to create or update an
// endpoint that's associated with an event.
type ItemResponse struct {
	_ struct{} `type:"structure"`

	// The response that was received after the endpoint data was accepted.
	EndpointItemResponse *EndpointItemResponse `type:"structure"`

	// A multipart response object that contains a key and a value for each event
	// in the request. In each object, the event ID is the key and an EventItemResponse
	// object is the value.
	EventsItemResponse map[string]EventItemResponse `type:"map"`
}

// String returns the string representation
func (s ItemResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ItemResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndpointItemResponse != nil {
		v := s.EndpointItemResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EndpointItemResponse", v, metadata)
	}
	if s.EventsItemResponse != nil {
		v := s.EventsItemResponse

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "EventsItemResponse", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Provides the results of a query that retrieved the data for a standard engagement
// metric that applies to a journey, and provides information about that query.
type JourneyDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier for the journey that the metric applies to.
	//
	// JourneyId is a required field
	JourneyId *string `type:"string" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of possible values, see the
	// Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the Journey Engagement Metrics
	// resource because the resource returns all results in a single page.
	NextToken *string `type:"string"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s JourneyDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneyDateRangeKpiResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JourneyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KpiName != nil {
		v := *s.KpiName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KpiName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KpiResult != nil {
		v := s.KpiResult

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "KpiResult", v, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Specifies the "From" address for an email message that's sent to participants
// in a journey.
type JourneyEmailMessage struct {
	_ struct{} `type:"structure"`

	// The verified email address to send the email message from. The default address
	// is the FromAddress specified for the email channel for the application.
	FromAddress *string `type:"string"`
}

// String returns the string representation
func (s JourneyEmailMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneyEmailMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides the results of a query that retrieved the data for a standard execution
// metric that applies to a journey activity, and provides information about
// that query.
type JourneyExecutionActivityMetricsResponse struct {
	_ struct{} `type:"structure"`

	// The type of activity that the metric applies to. Possible values are:
	//
	//    * CONDITIONAL_SPLIT - For a yes/no split activity, which is an activity
	//    that sends participants down one of two paths in a journey.
	//
	//    * HOLDOUT - For a holdout activity, which is an activity that stops a
	//    journey for a specified percentage of participants.
	//
	//    * MESSAGE - For an email activity, which is an activity that sends an
	//    email message to participants.
	//
	//    * MULTI_CONDITIONAL_SPLIT - For a multivariate split activity, which is
	//    an activity that sends participants down one of as many as five paths
	//    in a journey.
	//
	//    * RANDOM_SPLIT - For a random split activity, which is an activity that
	//    sends specified percentages of participants down one of as many as five
	//    paths in a journey.
	//
	//    * WAIT - For a wait activity, which is an activity that waits for a certain
	//    amount of time or until a specific date and time before moving participants
	//    to the next activity in a journey.
	//
	// ActivityType is a required field
	ActivityType *string `type:"string" required:"true"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the activity that the metric applies to.
	//
	// JourneyActivityId is a required field
	JourneyActivityId *string `type:"string" required:"true"`

	// The unique identifier for the journey that the metric applies to.
	//
	// JourneyId is a required field
	JourneyId *string `type:"string" required:"true"`

	// The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated
	// the execution status of the activity and updated the data for the metric.
	//
	// LastEvaluatedTime is a required field
	LastEvaluatedTime *string `type:"string" required:"true"`

	// A JSON object that contains the results of the query. The results vary depending
	// on the type of activity (ActivityType). For information about the structure
	// and contents of the results, see the Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html).
	//
	// Metrics is a required field
	Metrics map[string]string `type:"map" required:"true"`
}

// String returns the string representation
func (s JourneyExecutionActivityMetricsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneyExecutionActivityMetricsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActivityType != nil {
		v := *s.ActivityType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ActivityType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyActivityId != nil {
		v := *s.JourneyActivityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JourneyActivityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JourneyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastEvaluatedTime != nil {
		v := *s.LastEvaluatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastEvaluatedTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides the results of a query that retrieved the data for a standard execution
// metric that applies to a journey.
type JourneyExecutionMetricsResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the journey that the metric applies to.
	//
	// JourneyId is a required field
	JourneyId *string `type:"string" required:"true"`

	// The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated
	// the journey and updated the data for the metric.
	//
	// LastEvaluatedTime is a required field
	LastEvaluatedTime *string `type:"string" required:"true"`

	// A JSON object that contains the results of the query. For information about
	// the structure and contents of the results, see the Amazon Pinpoint Developer
	// Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html).
	//
	// Metrics is a required field
	Metrics map[string]string `type:"map" required:"true"`
}

// String returns the string representation
func (s JourneyExecutionMetricsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneyExecutionMetricsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JourneyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastEvaluatedTime != nil {
		v := *s.LastEvaluatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastEvaluatedTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Specifies limits on the messages that a journey can send and the number of
// times participants can enter a journey.
type JourneyLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that the journey can send to a single participant
	// during a 24-hour period. The maximum value is 100.
	DailyCap *int64 `type:"integer"`

	// The maximum number of times that a participant can enter the journey. The
	// maximum value is 100. To allow participants to enter the journey an unlimited
	// number of times, set this value to 0.
	EndpointReentryCap *int64 `type:"integer"`

	// The maximum number of messages that the journey can send each second.
	MessagesPerSecond *int64 `type:"integer"`
}

// String returns the string representation
func (s JourneyLimits) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneyLimits) MarshalFields(e protocol.FieldEncoder) error {
	if s.DailyCap != nil {
		v := *s.DailyCap

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DailyCap", protocol.Int64Value(v), metadata)
	}
	if s.EndpointReentryCap != nil {
		v := *s.EndpointReentryCap

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointReentryCap", protocol.Int64Value(v), metadata)
	}
	if s.MessagesPerSecond != nil {
		v := *s.MessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the status, configuration, and other settings
// for a journey.
type JourneyResponse struct {
	_ struct{} `type:"structure"`

	// The configuration and other settings for the activities that comprise the
	// journey.
	Activities map[string]Activity `type:"map"`

	// The unique identifier for the application that the journey applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The date, in ISO 8601 format, when the journey was created.
	CreationDate *string `type:"string"`

	// The unique identifier for the journey.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date, in ISO 8601 format, when the journey was last modified.
	LastModifiedDate *string `type:"string"`

	// The messaging and entry limits for the journey.
	Limits *JourneyLimits `type:"structure"`

	// Specifies whether the journey's scheduled start and end times use each participant's
	// local time. If this value is true, the schedule uses each participant's local
	// time.
	LocalTime *bool `type:"boolean"`

	// The name of the journey.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The quiet time settings for the journey. Quiet time is a specific time range
	// when a journey doesn't send messages to participants, if all the following
	// conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint for the participant
	//    is set to a valid value.
	//
	//    * The current time in the participant's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the journey.
	//
	//    * The current time in the participant's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the journey.
	//
	// If any of the preceding conditions isn't met, the participant will receive
	// messages from the journey, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`

	// The frequency with which Amazon Pinpoint evaluates segment and event data
	// for the journey, as a duration in ISO 8601 format.
	RefreshFrequency *string `type:"string"`

	// The schedule settings for the journey.
	Schedule *JourneySchedule `type:"structure"`

	// The unique identifier for the first activity in the journey.
	StartActivity *string `type:"string"`

	// The segment that defines which users are participants in the journey.
	StartCondition *StartCondition `type:"structure"`

	// The current status of the journey. Possible values are:
	//
	//    * DRAFT - The journey is being developed and hasn't been published yet.
	//
	//    * ACTIVE - The journey has been developed and published. Depending on
	//    the journey's schedule, the journey may currently be running or scheduled
	//    to start running at a later time. If a journey's status is ACTIVE, you
	//    can't add, change, or remove activities from it.
	//
	//    * COMPLETED - The journey has been published and has finished running.
	//    All participants have entered the journey and no participants are waiting
	//    to complete the journey or any activities in the journey.
	//
	//    * CANCELLED - The journey has been stopped. If a journey's status is CANCELLED,
	//    you can't add, change, or remove activities or segment settings from the
	//    journey.
	//
	//    * CLOSED - The journey has been published and has started running. It
	//    may have also passed its scheduled end time, or passed its scheduled start
	//    time and a refresh frequency hasn't been specified for it. If a journey's
	//    status is CLOSED, you can't add participants to it, and no existing participants
	//    can enter the journey for the first time. However, any existing participants
	//    who are currently waiting to start an activity may resume the journey.
	State State `type:"string" enum:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the journey. Each tag consists of a required tag key and
	// an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s JourneyResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneyResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Activities != nil {
		v := s.Activities

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Activities", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.LocalTime != nil {
		v := *s.LocalTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocalTime", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	if s.RefreshFrequency != nil {
		v := *s.RefreshFrequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RefreshFrequency", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.StartActivity != nil {
		v := *s.StartActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartCondition != nil {
		v := s.StartCondition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StartCondition", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Specifies the schedule settings for a journey.
type JourneySchedule struct {
	_ struct{} `type:"structure"`

	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The starting UTC offset for the journey schedule, if the value of the journey's
	// LocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03,
	// UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30,
	// UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11,
	// UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02, UTC-02:30, UTC-03, UTC-03:30,
	// UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-09:30, UTC-10, and UTC-11.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s JourneySchedule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneySchedule) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Timezone != nil {
		v := *s.Timezone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timezone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Changes the status of a journey.
type JourneyStateRequest struct {
	_ struct{} `type:"structure"`

	// The status of the journey. Currently, the only supported value is CANCELLED.
	//
	// If you cancel a journey, Amazon Pinpoint continues to perform activities
	// that are currently in progress, until those activities are complete. Amazon
	// Pinpoint also continues to collect and aggregate analytics data for those
	// activities, until they are complete, and any activities that were complete
	// when you cancelled the journey.
	//
	// After you cancel a journey, you can't add, change, or remove any activities
	// from the journey. In addition, Amazon Pinpoint stops evaluating the journey
	// and doesn't perform any activities that haven't started.
	State State `type:"string" enum:"true"`
}

// String returns the string representation
func (s JourneyStateRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneyStateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about the status, configuration, and other settings
// for all the journeys that are associated with an application.
type JourneysResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each journey that's associated with the application.
	//
	// Item is a required field
	Item []JourneyResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s JourneysResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JourneysResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the content and settings for a push notification that's sent to
// recipients of a campaign.
type Message struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of iOS and Android.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action Action `type:"string" enum:"true"`

	// The body of the notification message. The maximum number of characters is
	// 200.
	Body *string `type:"string"`

	// The URL of the image to display as the push-notification icon, such as the
	// icon for the app.
	ImageIconUrl *string `type:"string"`

	// The URL of the image to display as the small, push-notification icon, such
	// as a small version of the icon for the app.
	ImageSmallIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The JSON payload to use for a silent push notification.
	JsonBody *string `type:"string"`

	// The URL of the image or video to display in the push notification.
	MediaUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration,
	// displaying messages in an in-app message center, or supporting phone home
	// functionality.
	SilentPush *bool `type:"boolean"`

	// The number of seconds that the push-notification service should keep the
	// message, if the service is unable to deliver the notification the first time.
	// This value is converted to an expiration value when it's sent to a push-notification
	// service. If this value is 0, the service treats the notification as if it
	// expires immediately and the service doesn't store or try to deliver the notification
	// again.
	//
	// This value doesn't apply to messages that are sent through the Amazon Device
	// Messaging (ADM) service.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in a recipient's default mobile browser, if a recipient taps
	// the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Message) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageSmallIconUrl != nil {
		v := *s.ImageSmallIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageSmallIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JsonBody != nil {
		v := *s.JsonBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JsonBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MediaUrl != nil {
		v := *s.MediaUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MediaUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an API request or response.
type MessageBody struct {
	_ struct{} `type:"structure"`

	// The message that's returned from the API.
	Message *string `type:"string"`

	// The unique identifier for the request or response.
	RequestID *string `type:"string"`
}

// String returns the string representation
func (s MessageBody) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageBody) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestID != nil {
		v := *s.RequestID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the message configuration settings for a campaign.
type MessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message that the campaign sends through the ADM (Amazon Device Messaging)
	// channel. This message overrides the default message.
	ADMMessage *Message `type:"structure"`

	// The message that the campaign sends through the APNs (Apple Push Notification
	// service) channel. This message overrides the default message.
	APNSMessage *Message `type:"structure"`

	// The message that the campaign sends through the Baidu (Baidu Cloud Push)
	// channel. This message overrides the default message.
	BaiduMessage *Message `type:"structure"`

	// The default message that the campaign sends through all the channels that
	// are configured for the campaign.
	DefaultMessage *Message `type:"structure"`

	// The message that the campaign sends through the email channel.
	EmailMessage *CampaignEmailMessage `type:"structure"`

	// The message that the campaign sends through the GCM channel, which enables
	// Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging
	// (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides
	// the default message.
	GCMMessage *Message `type:"structure"`

	// The message that the campaign sends through the SMS channel.
	SMSMessage *CampaignSmsMessage `type:"structure"`
}

// String returns the string representation
func (s MessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MessageConfiguration"}
	if s.EmailMessage != nil {
		if err := s.EmailMessage.Validate(); err != nil {
			invalidParams.AddNested("EmailMessage", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADMMessage != nil {
		v := s.ADMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ADMMessage", v, metadata)
	}
	if s.APNSMessage != nil {
		v := s.APNSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "APNSMessage", v, metadata)
	}
	if s.BaiduMessage != nil {
		v := s.BaiduMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BaiduMessage", v, metadata)
	}
	if s.DefaultMessage != nil {
		v := s.DefaultMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultMessage", v, metadata)
	}
	if s.EmailMessage != nil {
		v := s.EmailMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EmailMessage", v, metadata)
	}
	if s.GCMMessage != nil {
		v := s.GCMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GCMMessage", v, metadata)
	}
	if s.SMSMessage != nil {
		v := s.SMSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SMSMessage", v, metadata)
	}
	return nil
}

// Specifies the configuration and other settings for a message.
type MessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of key-value pairs, where each key is an address and each value is
	// an AddressConfiguration object. An address can be a push notification token,
	// a phone number, or an email address. You can use an AddressConfiguration
	// object to tailor the message for an address by specifying settings such as
	// content overrides and message variables.
	Addresses map[string]AddressConfiguration `type:"map"`

	// A map of custom attributes to attach to the message. For a push notification,
	// this payload is added to the data.pinpoint object. For an email or text message,
	// this payload is added to email/SMS delivery receipt event attributes.
	Context map[string]string `type:"map"`

	// A map of key-value pairs, where each key is an endpoint ID and each value
	// is an EndpointSendConfiguration object. You can use an EndpointSendConfiguration
	// object to tailor the message for an endpoint by specifying settings such
	// as content overrides and message variables.
	Endpoints map[string]EndpointSendConfiguration `type:"map"`

	// The settings and content for the default message and any default messages
	// that you defined for specific channels.
	//
	// MessageConfiguration is a required field
	MessageConfiguration *DirectMessageConfiguration `type:"structure" required:"true"`

	// The message template to use for the message.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// The unique identifier for tracing the message. This identifier is visible
	// to message recipients.
	TraceId *string `type:"string"`
}

// String returns the string representation
func (s MessageRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MessageRequest"}

	if s.MessageConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Addresses != nil {
		v := s.Addresses

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Addresses", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.Context != nil {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Endpoints != nil {
		v := s.Endpoints

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Endpoints", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.TemplateConfiguration != nil {
		v := s.TemplateConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TemplateConfiguration", v, metadata)
	}
	if s.TraceId != nil {
		v := *s.TraceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TraceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the results of a request to send a message to
// an endpoint address.
type MessageResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that was used to send the message.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// A map that contains a multipart response for each address that the message
	// was sent to. In the map, the endpoint ID is the key and the result is the
	// value.
	EndpointResult map[string]EndpointMessageResult `type:"map"`

	// The identifier for the original request that the message was delivered for.
	RequestId *string `type:"string"`

	// A map that contains a multipart response for each address (email address,
	// phone number, or push notification token) that the message was sent to. In
	// the map, the address is the key and the result is the value.
	Result map[string]MessageResult `type:"map"`
}

// String returns the string representation
func (s MessageResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointResult != nil {
		v := s.EndpointResult

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "EndpointResult", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Result != nil {
		v := s.Result

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Result", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Provides information about the results of sending a message directly to an
// endpoint address.
type MessageResult struct {
	_ struct{} `type:"structure"`

	// The delivery status of the message. Possible values are:
	//
	//    * DUPLICATE - The endpoint address is a duplicate of another endpoint
	//    address. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * OPT_OUT - The user who's associated with the endpoint address has opted
	//    out of receiving messages from you. Amazon Pinpoint won't attempt to send
	//    the message again.
	//
	//    * PERMANENT_FAILURE - An error occurred when delivering the message to
	//    the endpoint address. Amazon Pinpoint won't attempt to send the message
	//    again.
	//
	//    * SUCCESSFUL - The message was successfully delivered to the endpoint
	//    address.
	//
	//    * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint will
	//    attempt to deliver the message again later.
	//
	//    * THROTTLED - Amazon Pinpoint throttled the operation to send the message
	//    to the endpoint address.
	//
	//    * TIMEOUT - The message couldn't be sent within the timeout period.
	//
	//    * UNKNOWN_FAILURE - An unknown error occurred.
	//
	// DeliveryStatus is a required field
	DeliveryStatus DeliveryStatus `type:"string" required:"true" enum:"true"`

	// The unique identifier for the message that was sent.
	MessageId *string `type:"string"`

	// The downstream service status code for delivering the message.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The status message for delivering the message.
	StatusMessage *string `type:"string"`

	// For push notifications that are sent through the GCM channel, specifies whether
	// the endpoint's device registration token was updated as part of delivering
	// the message.
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s MessageResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageResult) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DeliveryStatus) > 0 {
		v := s.DeliveryStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeliveryStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedToken != nil {
		v := *s.UpdatedToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies metric-based criteria for including or excluding endpoints from
// a segment. These criteria derive from custom metrics that you define for
// endpoints.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The operator to use when comparing metric values. Valid values are: GREATER_THAN,
	// LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true"`

	// The value to compare.
	//
	// Value is a required field
	Value *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricDimension"}

	if s.ComparisonOperator == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComparisonOperator"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricDimension) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComparisonOperator != nil {
		v := *s.ComparisonOperator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ComparisonOperator", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Specifies a condition to evaluate for an activity path in a journey.
type MultiConditionalBranch struct {
	_ struct{} `type:"structure"`

	// The condition to evaluate for the activity path.
	Condition *SimpleCondition `type:"structure"`

	// The unique identifier for the next activity to perform, after completing
	// the activity for the path.
	NextActivity *string `type:"string"`
}

// String returns the string representation
func (s MultiConditionalBranch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiConditionalBranch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MultiConditionalBranch"}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MultiConditionalBranch) MarshalFields(e protocol.FieldEncoder) error {
	if s.Condition != nil {
		v := s.Condition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Condition", v, metadata)
	}
	if s.NextActivity != nil {
		v := *s.NextActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the settings for a multivariate split activity in a journey. This
// type of activity sends participants down one of as many as five paths in
// a journey, based on conditions that you specify.
type MultiConditionalSplitActivity struct {
	_ struct{} `type:"structure"`

	// The paths for the activity, including the conditions for entering each path
	// and the activity to perform for each path.
	Branches []MultiConditionalBranch `type:"list"`

	// The activity to perform by default for any path in the activity.
	DefaultActivity *string `type:"string"`

	// The amount of time to wait or the date and time when Amazon Pinpoint determines
	// whether the conditions are met.
	EvaluationWaitTime *WaitTime `type:"structure"`
}

// String returns the string representation
func (s MultiConditionalSplitActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiConditionalSplitActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MultiConditionalSplitActivity"}
	if s.Branches != nil {
		for i, v := range s.Branches {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Branches", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MultiConditionalSplitActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Branches != nil {
		v := s.Branches

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Branches", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DefaultActivity != nil {
		v := *s.DefaultActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EvaluationWaitTime != nil {
		v := s.EvaluationWaitTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EvaluationWaitTime", v, metadata)
	}
	return nil
}

// Specifies a phone number to validate and retrieve information about.
type NumberValidateRequest struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the phone number was originally registered.
	IsoCountryCode *string `type:"string"`

	// The phone number to retrieve information about. The phone number that you
	// provide should include a valid numeric country code. Otherwise, the operation
	// might result in an error.
	PhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NumberValidateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsoCountryCode != nil {
		v := *s.IsoCountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsoCountryCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumber != nil {
		v := *s.PhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about a phone number.
type NumberValidateResponse struct {
	_ struct{} `type:"structure"`

	// The carrier or service provider that the phone number is currently registered
	// with. In some countries and regions, this value may be the carrier or service
	// provider that the phone number was originally registered with.
	Carrier *string `type:"string"`

	// The name of the city where the phone number was originally registered.
	City *string `type:"string"`

	// The cleansed phone number, in E.164 format, for the location where the phone
	// number was originally registered.
	CleansedPhoneNumberE164 *string `type:"string"`

	// The cleansed phone number, in the format for the location where the phone
	// number was originally registered.
	CleansedPhoneNumberNational *string `type:"string"`

	// The name of the country or region where the phone number was originally registered.
	Country *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the phone number was originally registered.
	CountryCodeIso2 *string `type:"string"`

	// The numeric code for the country or region where the phone number was originally
	// registered.
	CountryCodeNumeric *string `type:"string"`

	// The name of the county where the phone number was originally registered.
	County *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, that was sent in the
	// request body.
	OriginalCountryCodeIso2 *string `type:"string"`

	// The phone number that was sent in the request body.
	OriginalPhoneNumber *string `type:"string"`

	// The description of the phone type. Valid values are: MOBILE, LANDLINE, VOIP,
	// INVALID, PREPAID, and OTHER.
	PhoneType *string `type:"string"`

	// The phone type, represented by an integer. Valid values are: 0 (mobile),
	// 1 (landline), 2 (VoIP), 3 (invalid), 4 (other), and 5 (prepaid).
	PhoneTypeCode *int64 `type:"integer"`

	// The time zone for the location where the phone number was originally registered.
	Timezone *string `type:"string"`

	// The postal or ZIP code for the location where the phone number was originally
	// registered.
	ZipCode *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NumberValidateResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Carrier != nil {
		v := *s.Carrier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Carrier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.City != nil {
		v := *s.City

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "City", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CleansedPhoneNumberE164 != nil {
		v := *s.CleansedPhoneNumberE164

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CleansedPhoneNumberE164", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CleansedPhoneNumberNational != nil {
		v := *s.CleansedPhoneNumberNational

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CleansedPhoneNumberNational", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Country != nil {
		v := *s.Country

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Country", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CountryCodeIso2 != nil {
		v := *s.CountryCodeIso2

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryCodeIso2", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CountryCodeNumeric != nil {
		v := *s.CountryCodeNumeric

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryCodeNumeric", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.County != nil {
		v := *s.County

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "County", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginalCountryCodeIso2 != nil {
		v := *s.OriginalCountryCodeIso2

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginalCountryCodeIso2", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginalPhoneNumber != nil {
		v := *s.OriginalPhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginalPhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneType != nil {
		v := *s.PhoneType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneTypeCode != nil {
		v := *s.PhoneTypeCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneTypeCode", protocol.Int64Value(v), metadata)
	}
	if s.Timezone != nil {
		v := *s.Timezone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timezone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipCode != nil {
		v := *s.ZipCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the properties and attributes of an endpoint that's associated
// with an event.
type PublicEndpoint struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the recipient, such as a device token, email address,
	// or mobile phone number.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. You can use these attributes as filter criteria
	// when you create segments.
	Attributes map[string][]string `type:"map"`

	// The channel that's used when sending messages or push notifications to the
	// endpoint.
	ChannelType ChannelType `type:"string" enum:"true"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was last updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether to send messages or push notifications to the endpoint.
	// Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// A unique identifier that's generated each time the endpoint is updated.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s PublicEndpoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Specifies the content and settings for a message template that can be used
// in messages that are sent through a push notification channel.
type PushNotificationTemplateRequest struct {
	_ struct{} `type:"structure"`

	// The message template to use for the ADM (Amazon Device Messaging) channel.
	// This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	ADM *AndroidPushNotificationTemplate `type:"structure"`

	// The message template to use for the APNs (Apple Push Notification service)
	// channel. This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	APNS *APNSPushNotificationTemplate `type:"structure"`

	// The message template to use for the Baidu (Baidu Cloud Push) channel. This
	// message template overrides the default template for push notification channels
	// (DefaultPushNotificationTemplate).
	Baidu *AndroidPushNotificationTemplate `type:"structure"`

	// The default message template to use for push notification channels.
	Default *DefaultPushNotificationTemplate `type:"structure"`

	// A JSON object that specifies the default values to use for message variables
	// in the message template. This object is a set of key-value pairs. Each key
	// defines a message variable in the template. The corresponding value defines
	// the default value for that variable. When you create a message that's based
	// on the template, you can override these defaults with message-specific and
	// address-specific variables and values.
	DefaultSubstitutions *string `type:"string"`

	// The message template to use for the GCM channel, which is used to send notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service. This message template overrides the default template for
	// push notification channels (DefaultPushNotificationTemplate).
	GCM *AndroidPushNotificationTemplate `type:"structure"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the message template. Each tag consists of a required tag key and an
	// associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A custom description of the message template.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s PushNotificationTemplateRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PushNotificationTemplateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADM != nil {
		v := s.ADM

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ADM", v, metadata)
	}
	if s.APNS != nil {
		v := s.APNS

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "APNS", v, metadata)
	}
	if s.Baidu != nil {
		v := s.Baidu

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Baidu", v, metadata)
	}
	if s.Default != nil {
		v := s.Default

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Default", v, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GCM != nil {
		v := s.GCM

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GCM", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the content and settings for a message template
// that can be used in messages that are sent through a push notification channel.
type PushNotificationTemplateResponse struct {
	_ struct{} `type:"structure"`

	// The message template that's used for the ADM (Amazon Device Messaging) channel.
	// This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	ADM *AndroidPushNotificationTemplate `type:"structure"`

	// The message template that's used for the APNs (Apple Push Notification service)
	// channel. This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	APNS *APNSPushNotificationTemplate `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The message template that's used for the Baidu (Baidu Cloud Push) channel.
	// This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	Baidu *AndroidPushNotificationTemplate `type:"structure"`

	// The date when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The default message template that's used for push notification channels.
	Default *DefaultPushNotificationTemplate `type:"structure"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The message template that's used for the GCM channel, which is used to send
	// notifications through the Firebase Cloud Messaging (FCM), formerly Google
	// Cloud Messaging (GCM), service. This message template overrides the default
	// template for push notification channels (DefaultPushNotificationTemplate).
	GCM *AndroidPushNotificationTemplate `type:"structure"`

	// The date when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for. For a push
	// notification template, this value is PUSH.
	//
	// TemplateType is a required field
	TemplateType TemplateType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PushNotificationTemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PushNotificationTemplateResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADM != nil {
		v := s.ADM

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ADM", v, metadata)
	}
	if s.APNS != nil {
		v := s.APNS

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "APNS", v, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Baidu != nil {
		v := s.Baidu

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Baidu", v, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Default != nil {
		v := s.Default

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Default", v, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GCM != nil {
		v := s.GCM

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GCM", v, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TemplateType) > 0 {
		v := s.TemplateType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the start and end times that define a time range when messages
// aren't sent to endpoints.
type QuietTime struct {
	_ struct{} `type:"structure"`

	// The specific time when quiet time ends. This value has to use 24-hour notation
	// and be in HH:MM format, where HH is the hour (with a leading zero, if applicable)
	// and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30
	// to represent 2:30 PM.
	End *string `type:"string"`

	// The specific time when quiet time begins. This value has to use 24-hour notation
	// and be in HH:MM format, where HH is the hour (with a leading zero, if applicable)
	// and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30
	// to represent 2:30 PM.
	Start *string `type:"string"`
}

// String returns the string representation
func (s QuietTime) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QuietTime) MarshalFields(e protocol.FieldEncoder) error {
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "End", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the settings for a random split activity in a journey. This type
// of activity randomly sends specified percentages of participants down one
// of as many as five paths in a journey, based on conditions that you specify.
type RandomSplitActivity struct {
	_ struct{} `type:"structure"`

	// The paths for the activity, including the percentage of participants to enter
	// each path and the activity to perform for each path.
	Branches []RandomSplitEntry `type:"list"`
}

// String returns the string representation
func (s RandomSplitActivity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RandomSplitActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Branches != nil {
		v := s.Branches

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Branches", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the settings for a path in a random split activity in a journey.
type RandomSplitEntry struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the next activity to perform, after completing
	// the activity for the path.
	NextActivity *string `type:"string"`

	// The percentage of participants to send down the activity path.
	Percentage *int64 `type:"integer"`
}

// String returns the string representation
func (s RandomSplitEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RandomSplitEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextActivity != nil {
		v := *s.NextActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Percentage != nil {
		v := *s.Percentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Percentage", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the contents of an email message, represented as a raw MIME message.
type RawEmail struct {
	_ struct{} `type:"structure"`

	// Data is automatically base64 encoded/decoded by the SDK.
	Data []byte `type:"blob"`
}

// String returns the string representation
func (s RawEmail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RawEmail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Data", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// Specifies criteria for including or excluding endpoints from a segment based
// on how recently an endpoint was active.
type RecencyDimension struct {
	_ struct{} `type:"structure"`

	// The duration to use when determining whether an endpoint is active or inactive.
	//
	// Duration is a required field
	Duration Duration `type:"string" required:"true" enum:"true"`

	// The type of recency dimension to use for the segment. Valid values are: ACTIVE,
	// endpoints that were active within the specified duration are included in
	// the segment; and, INACTIVE, endpoints that weren't active within the specified
	// duration are included in the segment.
	//
	// RecencyType is a required field
	RecencyType RecencyType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RecencyDimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecencyDimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecencyDimension"}
	if len(s.Duration) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Duration"))
	}
	if len(s.RecencyType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RecencyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecencyDimension) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Duration) > 0 {
		v := s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.RecencyType) > 0 {
		v := s.RecencyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecencyType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application, campaign, or journey.
type ResultRow struct {
	_ struct{} `type:"structure"`

	// An array of objects that defines the field and field values that were used
	// to group data in a result set that contains multiple results. This value
	// is null if the data in a result set isn’t grouped.
	//
	// GroupedBys is a required field
	GroupedBys []ResultRowValue `type:"list" required:"true"`

	// An array of objects that provides pre-aggregated values for a standard metric
	// that applies to an application, campaign, or journey.
	//
	// Values is a required field
	Values []ResultRowValue `type:"list" required:"true"`
}

// String returns the string representation
func (s ResultRow) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResultRow) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupedBys != nil {
		v := s.GroupedBys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "GroupedBys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Provides a single value and metadata about that value as part of an array
// of query results for a standard metric that applies to an application, campaign,
// or journey.
type ResultRowValue struct {
	_ struct{} `type:"structure"`

	// The friendly name of the metric whose value is specified by the Value property.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The data type of the value specified by the Value property.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`

	// In a Values object, the value for the metric that the query retrieved data
	// for. In a GroupedBys object, the value for the field that was used to group
	// data in a result set that contains multiple results (Values objects).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResultRowValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResultRowValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the status and settings of the SMS channel for an application.
type SMSChannelRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the SMS channel for the application.
	Enabled *bool `type:"boolean"`

	// The identity that you want to display on recipients' devices when they receive
	// messages from the SMS channel.
	SenderId *string `type:"string"`

	// The registered short code that you want to use when you send messages through
	// the SMS channel.
	ShortCode *string `type:"string"`
}

// String returns the string representation
func (s SMSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ShortCode != nil {
		v := *s.ShortCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ShortCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status and settings of the SMS channel for
// an application.
type SMSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the SMS channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the SMS channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the SMS channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the SMS channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the SMS channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the SMS channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the SMS channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the SMS
	// channel, this value is SMS.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The maximum number of promotional messages that you can send through the
	// SMS channel each second.
	PromotionalMessagesPerSecond *int64 `type:"integer"`

	// The identity that displays on recipients' devices when they receive messages
	// from the SMS channel.
	SenderId *string `type:"string"`

	// The registered short code to use when you send messages through the SMS channel.
	ShortCode *string `type:"string"`

	// The maximum number of transactional messages that you can send through the
	// SMS channel each second.
	TransactionalMessagesPerSecond *int64 `type:"integer"`

	// The current version of the SMS channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SMSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PromotionalMessagesPerSecond != nil {
		v := *s.PromotionalMessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PromotionalMessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ShortCode != nil {
		v := *s.ShortCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ShortCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TransactionalMessagesPerSecond != nil {
		v := *s.TransactionalMessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TransactionalMessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the default settings for a one-time SMS message that's sent directly
// to an endpoint.
type SMSMessage struct {
	_ struct{} `type:"structure"`

	// The body of the SMS message.
	Body *string `type:"string"`

	// The SMS program name that you provided to AWS Support when you requested
	// your dedicated number.
	Keyword *string `type:"string"`

	// The SMS message type. Valid values are: TRANSACTIONAL, the message is critical
	// or time-sensitive, such as a one-time password that supports a customer transaction;
	// and, PROMOTIONAL, the message is not critical or time-sensitive, such as
	// a marketing message.
	MessageType MessageType `type:"string" enum:"true"`

	// The number to send the SMS message from. This value should be one of the
	// dedicated long or short codes that's assigned to your AWS account. If you
	// don't specify a long or short code, Amazon Pinpoint assigns a random long
	// code to the SMS message and sends the message from that code.
	OriginationNumber *string `type:"string"`

	// The sender ID to display as the sender of the message on a recipient's device.
	// Support for sender IDs varies by country or region.
	SenderId *string `type:"string"`

	// The message variables to use in the SMS message. You can override the default
	// variables with individual address variables.
	Substitutions map[string][]string `type:"map"`
}

// String returns the string representation
func (s SMSMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Keyword != nil {
		v := *s.Keyword

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Keyword", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.MessageType) > 0 {
		v := s.MessageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OriginationNumber != nil {
		v := *s.OriginationNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginationNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	return nil
}

// Specifies the content and settings for a message template that can be used
// in text messages that are sent through the SMS channel.
type SMSTemplateRequest struct {
	_ struct{} `type:"structure"`

	// The message body to use in text messages that are based on the message template.
	Body *string `type:"string"`

	// A JSON object that specifies the default values to use for message variables
	// in the message template. This object is a set of key-value pairs. Each key
	// defines a message variable in the template. The corresponding value defines
	// the default value for that variable. When you create a message that's based
	// on the template, you can override these defaults with message-specific and
	// address-specific variables and values.
	DefaultSubstitutions *string `type:"string"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the message template. Each tag consists of a required tag key and an
	// associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A custom description of the message template.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s SMSTemplateRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSTemplateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the content and settings for a message template
// that can be used in text messages that are sent through the SMS channel.
type SMSTemplateResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The message body that's used in text messages that are based on the message
	// template.
	Body *string `type:"string"`

	// The date when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The date when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for. For an SMS
	// template, this value is SMS.
	//
	// TemplateType is a required field
	TemplateType TemplateType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SMSTemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSTemplateResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TemplateType) > 0 {
		v := s.TemplateType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the schedule settings for a campaign.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The scheduled time, in ISO 8601 format, when the campaign ended or will end.
	EndTime *string `type:"string"`

	// The type of event that causes the campaign to be sent, if the value of the
	// Frequency property is EVENT.
	EventFilter *CampaignEventFilter `type:"structure"`

	// Specifies how often the campaign is sent or whether the campaign is sent
	// in response to a specific event.
	Frequency Frequency `type:"string" enum:"true"`

	// Specifies whether the start and end times for the campaign schedule use each
	// recipient's local time. To base the schedule on each recipient's local time,
	// set this value to true.
	IsLocalTime *bool `type:"boolean"`

	// The default quiet time for the campaign. Quiet time is a specific time range
	// when a campaign doesn't send messages to endpoints, if all the following
	// conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the campaign.
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the campaign.
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from the campaign, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`

	// The scheduled time, in ISO 8601 format, when the campaign began or will begin.
	//
	// StartTime is a required field
	StartTime *string `type:"string" required:"true"`

	// The starting UTC offset for the campaign schedule, if the value of the IsLocalTime
	// property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30,
	// UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07,
	// UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02,
	// UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Schedule"}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}
	if s.EventFilter != nil {
		if err := s.EventFilter.Validate(); err != nil {
			invalidParams.AddNested("EventFilter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Schedule) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventFilter != nil {
		v := s.EventFilter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EventFilter", v, metadata)
	}
	if len(s.Frequency) > 0 {
		v := s.Frequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Frequency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IsLocalTime != nil {
		v := *s.IsLocalTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLocalTime", protocol.BoolValue(v), metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timezone != nil {
		v := *s.Timezone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timezone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies dimension settings for including or excluding endpoints from a
// segment based on how recently an endpoint was active.
type SegmentBehaviors struct {
	_ struct{} `type:"structure"`

	// The dimension settings that are based on how recently an endpoint was active.
	Recency *RecencyDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentBehaviors) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentBehaviors) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentBehaviors"}
	if s.Recency != nil {
		if err := s.Recency.Validate(); err != nil {
			invalidParams.AddNested("Recency", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentBehaviors) MarshalFields(e protocol.FieldEncoder) error {
	if s.Recency != nil {
		v := s.Recency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Recency", v, metadata)
	}
	return nil
}

// Specifies a segment to associate with an activity in a journey.
type SegmentCondition struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the segment to associate with the activity.
	//
	// SegmentId is a required field
	SegmentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SegmentCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentCondition"}

	if s.SegmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentCondition) MarshalFields(e protocol.FieldEncoder) error {
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies demographic-based dimension settings for including or excluding
// endpoints from a segment. These settings derive from characteristics of endpoint
// devices, such as platform, make, and model.
type SegmentDemographics struct {
	_ struct{} `type:"structure"`

	// The app version criteria for the segment.
	AppVersion *SetDimension `type:"structure"`

	// The channel criteria for the segment.
	Channel *SetDimension `type:"structure"`

	// The device type criteria for the segment.
	DeviceType *SetDimension `type:"structure"`

	// The device make criteria for the segment.
	Make *SetDimension `type:"structure"`

	// The device model criteria for the segment.
	Model *SetDimension `type:"structure"`

	// The device platform criteria for the segment.
	Platform *SetDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentDemographics) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentDemographics) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentDemographics"}
	if s.AppVersion != nil {
		if err := s.AppVersion.Validate(); err != nil {
			invalidParams.AddNested("AppVersion", err.(aws.ErrInvalidParams))
		}
	}
	if s.Channel != nil {
		if err := s.Channel.Validate(); err != nil {
			invalidParams.AddNested("Channel", err.(aws.ErrInvalidParams))
		}
	}
	if s.DeviceType != nil {
		if err := s.DeviceType.Validate(); err != nil {
			invalidParams.AddNested("DeviceType", err.(aws.ErrInvalidParams))
		}
	}
	if s.Make != nil {
		if err := s.Make.Validate(); err != nil {
			invalidParams.AddNested("Make", err.(aws.ErrInvalidParams))
		}
	}
	if s.Model != nil {
		if err := s.Model.Validate(); err != nil {
			invalidParams.AddNested("Model", err.(aws.ErrInvalidParams))
		}
	}
	if s.Platform != nil {
		if err := s.Platform.Validate(); err != nil {
			invalidParams.AddNested("Platform", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentDemographics) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppVersion != nil {
		v := s.AppVersion

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AppVersion", v, metadata)
	}
	if s.Channel != nil {
		v := s.Channel

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Channel", v, metadata)
	}
	if s.DeviceType != nil {
		v := s.DeviceType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeviceType", v, metadata)
	}
	if s.Make != nil {
		v := s.Make

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Make", v, metadata)
	}
	if s.Model != nil {
		v := s.Model

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Model", v, metadata)
	}
	if s.Platform != nil {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Platform", v, metadata)
	}
	return nil
}

// Specifies the dimension settings for a segment.
type SegmentDimensions struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes to use as criteria for the segment.
	Attributes map[string]AttributeDimension `type:"map"`

	// The behavior-based criteria, such as how recently users have used your app,
	// for the segment.
	Behavior *SegmentBehaviors `type:"structure"`

	// The demographic-based criteria, such as device platform, for the segment.
	Demographic *SegmentDemographics `type:"structure"`

	// The location-based criteria, such as region or GPS coordinates, for the segment.
	Location *SegmentLocation `type:"structure"`

	// One or more custom metrics to use as criteria for the segment.
	Metrics map[string]MetricDimension `type:"map"`

	// One or more custom user attributes to use as criteria for the segment.
	UserAttributes map[string]AttributeDimension `type:"map"`
}

// String returns the string representation
func (s SegmentDimensions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentDimensions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentDimensions"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Behavior != nil {
		if err := s.Behavior.Validate(); err != nil {
			invalidParams.AddNested("Behavior", err.(aws.ErrInvalidParams))
		}
	}
	if s.Demographic != nil {
		if err := s.Demographic.Validate(); err != nil {
			invalidParams.AddNested("Demographic", err.(aws.ErrInvalidParams))
		}
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(aws.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentDimensions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.Behavior != nil {
		v := s.Behavior

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Behavior", v, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.UserAttributes != nil {
		v := s.UserAttributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserAttributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Specifies the base segments and dimensions for a segment, and the relationships
// between these base segments and dimensions.
type SegmentGroup struct {
	_ struct{} `type:"structure"`

	// An array that defines the dimensions for the segment.
	Dimensions []SegmentDimensions `type:"list"`

	// The base segment to build the segment on. A base segment, also referred to
	// as a source segment, defines the initial population of endpoints for a segment.
	// When you add dimensions to a segment, Amazon Pinpoint filters the base segment
	// by using the dimensions that you specify.
	//
	// You can specify more than one dimensional segment or only one imported segment.
	// If you specify an imported segment, the Amazon Pinpoint console displays
	// a segment size estimate that indicates the size of the imported segment without
	// any filters applied to it.
	SourceSegments []SegmentReference `type:"list"`

	// Specifies how to handle multiple base segments for the segment. For example,
	// if you specify three base segments for the segment, whether the resulting
	// segment is based on all, any, or none of the base segments.
	SourceType SourceType `type:"string" enum:"true"`

	// Specifies how to handle multiple dimensions for the segment. For example,
	// if you specify three dimensions for the segment, whether the resulting segment
	// includes endpoints that match all, any, or none of the dimensions.
	Type Type `type:"string" enum:"true"`
}

// String returns the string representation
func (s SegmentGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentGroup"}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SourceSegments != nil {
		for i, v := range s.SourceSegments {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceSegments", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Dimensions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceSegments != nil {
		v := s.SourceSegments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SourceSegments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SourceType) > 0 {
		v := s.SourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the settings that define the relationships between segment groups
// for a segment.
type SegmentGroupList struct {
	_ struct{} `type:"structure"`

	// An array that defines the set of segment criteria to evaluate when handling
	// segment groups for the segment.
	Groups []SegmentGroup `type:"list"`

	// Specifies how to handle multiple segment groups for the segment. For example,
	// if the segment includes three segment groups, whether the resulting segment
	// includes endpoints that match all, any, or none of the segment groups.
	Include Include `type:"string" enum:"true"`
}

// String returns the string representation
func (s SegmentGroupList) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentGroupList) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentGroupList"}
	if s.Groups != nil {
		for i, v := range s.Groups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Groups", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentGroupList) MarshalFields(e protocol.FieldEncoder) error {
	if s.Groups != nil {
		v := s.Groups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Groups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Include) > 0 {
		v := s.Include

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Include", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about the import job that created a segment. An import
// job is a job that creates a user segment by importing endpoint definitions.
type SegmentImportResource struct {
	_ struct{} `type:"structure"`

	// The number of channel types in the endpoint definitions that were imported
	// to create the segment.
	ChannelCounts map[string]int64 `type:"map"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	//
	// ExternalId is a required field
	ExternalId *string `type:"string" required:"true"`

	// The format of the files that were imported to create the segment. Valid values
	// are: CSV, for comma-separated values format; and, JSON, for newline-delimited
	// JSON format.
	//
	// Format is a required field
	Format Format `type:"string" required:"true" enum:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the
	// endpoint definitions were imported from to create the segment.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The number of endpoint definitions that were imported successfully to create
	// the segment.
	//
	// Size is a required field
	Size *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s SegmentImportResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentImportResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelCounts != nil {
		v := s.ChannelCounts

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "ChannelCounts", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Int64Value(v1))
		}
		ms0.End()

	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Url != nil {
		v := *s.S3Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies geographical dimension settings for a segment.
type SegmentLocation struct {
	_ struct{} `type:"structure"`

	// The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
	Country *SetDimension `type:"structure"`

	// The GPS location and range for the segment.
	GPSPoint *GPSPointDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentLocation"}
	if s.Country != nil {
		if err := s.Country.Validate(); err != nil {
			invalidParams.AddNested("Country", err.(aws.ErrInvalidParams))
		}
	}
	if s.GPSPoint != nil {
		if err := s.GPSPoint.Validate(); err != nil {
			invalidParams.AddNested("GPSPoint", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Country != nil {
		v := s.Country

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Country", v, metadata)
	}
	if s.GPSPoint != nil {
		v := s.GPSPoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GPSPoint", v, metadata)
	}
	return nil
}

// Specifies the segment identifier and version of a segment.
type SegmentReference struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the segment.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The version number of the segment.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentReference) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentReference) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SegmentReference"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the configuration, dimension, and other settings
// for a segment.
type SegmentResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the segment is associated
	// with.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the segment.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date and time when the segment was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The dimension settings for the segment.
	Dimensions *SegmentDimensions `type:"structure"`

	// The unique identifier for the segment.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The settings for the import job that's associated with the segment.
	ImportDefinition *SegmentImportResource `type:"structure"`

	// The date and time when the segment was last modified.
	LastModifiedDate *string `type:"string"`

	// The name of the segment.
	Name *string `type:"string"`

	// A list of one or more segment groups that apply to the segment. Each segment
	// group consists of zero or more base segments and the dimensions that are
	// applied to those base segments.
	SegmentGroups *SegmentGroupList `type:"structure"`

	// The segment type. Valid values are:
	//
	//    * DIMENSIONAL - A dynamic segment, which is a segment that uses selection
	//    criteria that you specify and is based on endpoint data that's reported
	//    by your app. Dynamic segments can change over time.
	//
	//    * IMPORT - A static segment, which is a segment that uses selection criteria
	//    that you specify and is based on endpoint definitions that you import
	//    from a file. Imported segments are static; they don't change over time.
	//
	// SegmentType is a required field
	SegmentType SegmentType `type:"string" required:"true" enum:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the segment. Each tag consists of a required tag key and
	// an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The version number of the segment.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImportDefinition != nil {
		v := s.ImportDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ImportDefinition", v, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentGroups != nil {
		v := s.SegmentGroups

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SegmentGroups", v, metadata)
	}
	if len(s.SegmentType) > 0 {
		v := s.SegmentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about all the segments that are associated with an application.
type SegmentsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each segment that's associated with the application
	// (Segments resource) or each version of a segment that's associated with the
	// application (Segment Versions resource).
	//
	// Item is a required field
	Item []SegmentResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SegmentsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the configuration and other settings for a message to send to all
// the endpoints that are associated with a list of users.
type SendUsersMessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of custom attribute-value pairs. For a push notification, Amazon Pinpoint
	// adds these attributes to the data.pinpoint object in the body of the notification
	// payload. Amazon Pinpoint also provides these attributes in the events that
	// it generates for users-messages deliveries.
	Context map[string]string `type:"map"`

	// The settings and content for the default message and any default messages
	// that you defined for specific channels.
	//
	// MessageConfiguration is a required field
	MessageConfiguration *DirectMessageConfiguration `type:"structure" required:"true"`

	// The message template to use for the message.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// The unique identifier for tracing the message. This identifier is visible
	// to message recipients.
	TraceId *string `type:"string"`

	// A map that associates user IDs with EndpointSendConfiguration objects. You
	// can use an EndpointSendConfiguration object to tailor the message for a user
	// by specifying settings such as content overrides and message variables.
	//
	// Users is a required field
	Users map[string]EndpointSendConfiguration `type:"map" required:"true"`
}

// String returns the string representation
func (s SendUsersMessageRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendUsersMessageRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendUsersMessageRequest"}

	if s.MessageConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageConfiguration"))
	}

	if s.Users == nil {
		invalidParams.Add(aws.NewErrParamRequired("Users"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendUsersMessageRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Context != nil {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.TemplateConfiguration != nil {
		v := s.TemplateConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TemplateConfiguration", v, metadata)
	}
	if s.TraceId != nil {
		v := *s.TraceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TraceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Users != nil {
		v := s.Users

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Users", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Provides information about which users and endpoints a message was sent to.
type SendUsersMessageResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that was used to send the message.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier that was assigned to the message request.
	RequestId *string `type:"string"`

	// An object that indicates which endpoints the message was sent to, for each
	// user. The object lists user IDs and, for each user ID, provides the endpoint
	// IDs that the message was sent to. For each endpoint ID, it provides an EndpointMessageResult
	// object.
	Result map[string]map[string]EndpointMessageResult `type:"map"`
}

// String returns the string representation
func (s SendUsersMessageResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendUsersMessageResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Result != nil {
		v := s.Result

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Result", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms1 := ms0.Map(k1)
			ms1.Start()
			for k2, v2 := range v1 {
				ms1.MapSetFields(k2, v2)
			}
			ms1.End()
		}
		ms0.End()

	}
	return nil
}

// Provides information about a session.
type Session struct {
	_ struct{} `type:"structure"`

	// The duration of the session, in milliseconds.
	Duration *int64 `type:"integer"`

	// The unique identifier for the session.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time when the session began.
	//
	// StartTimestamp is a required field
	StartTimestamp *string `type:"string" required:"true"`

	// The date and time when the session ended.
	StopTimestamp *string `type:"string"`
}

// String returns the string representation
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Session) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Session"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.StartTimestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Session) MarshalFields(e protocol.FieldEncoder) error {
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.Int64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTimestamp != nil {
		v := *s.StartTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StopTimestamp != nil {
		v := *s.StopTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StopTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the dimension type and values for a segment dimension.
type SetDimension struct {
	_ struct{} `type:"structure"`

	// The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints
	// that match the criteria are included in the segment; and, EXCLUSIVE, endpoints
	// that match the criteria are excluded from the segment.
	DimensionType DimensionType `type:"string" enum:"true"`

	// The criteria values to use for the segment dimension. Depending on the value
	// of the DimensionType property, endpoints are included or excluded from the
	// segment if their values match the criteria values.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s SetDimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetDimension"}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetDimension) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DimensionType) > 0 {
		v := s.DimensionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DimensionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies a condition to evaluate for an activity in a journey.
type SimpleCondition struct {
	_ struct{} `type:"structure"`

	// The dimension settings for the event that's associated with the activity.
	EventCondition *EventCondition `type:"structure"`

	// The segment that's associated with the activity.
	SegmentCondition *SegmentCondition `type:"structure"`

	// The dimension settings for the segment that's associated with the activity.
	SegmentDimensions *SegmentDimensions `locationName:"segmentDimensions" type:"structure"`
}

// String returns the string representation
func (s SimpleCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimpleCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SimpleCondition"}
	if s.EventCondition != nil {
		if err := s.EventCondition.Validate(); err != nil {
			invalidParams.AddNested("EventCondition", err.(aws.ErrInvalidParams))
		}
	}
	if s.SegmentCondition != nil {
		if err := s.SegmentCondition.Validate(); err != nil {
			invalidParams.AddNested("SegmentCondition", err.(aws.ErrInvalidParams))
		}
	}
	if s.SegmentDimensions != nil {
		if err := s.SegmentDimensions.Validate(); err != nil {
			invalidParams.AddNested("SegmentDimensions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimpleCondition) MarshalFields(e protocol.FieldEncoder) error {
	if s.EventCondition != nil {
		v := s.EventCondition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EventCondition", v, metadata)
	}
	if s.SegmentCondition != nil {
		v := s.SegmentCondition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SegmentCondition", v, metadata)
	}
	if s.SegmentDimensions != nil {
		v := s.SegmentDimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "segmentDimensions", v, metadata)
	}
	return nil
}

// Specifies the contents of an email message, composed of a subject, a text
// part, and an HTML part.
type SimpleEmail struct {
	_ struct{} `type:"structure"`

	// The body of the email message, in HTML format. We recommend using HTML format
	// for email clients that render HTML content. You can include links, formatted
	// text, and more in an HTML message.
	HtmlPart *SimpleEmailPart `type:"structure"`

	// The subject line, or title, of the email.
	Subject *SimpleEmailPart `type:"structure"`

	// The body of the email message, in plain text format. We recommend using plain
	// text format for email clients that don't render HTML content and clients
	// that are connected to high-latency networks, such as mobile devices.
	TextPart *SimpleEmailPart `type:"structure"`
}

// String returns the string representation
func (s SimpleEmail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimpleEmail) MarshalFields(e protocol.FieldEncoder) error {
	if s.HtmlPart != nil {
		v := s.HtmlPart

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HtmlPart", v, metadata)
	}
	if s.Subject != nil {
		v := s.Subject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Subject", v, metadata)
	}
	if s.TextPart != nil {
		v := s.TextPart

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TextPart", v, metadata)
	}
	return nil
}

// Specifies the subject or body of an email message, represented as textual
// email data and the applicable character set.
type SimpleEmailPart struct {
	_ struct{} `type:"structure"`

	// The applicable character set for the message content.
	Charset *string `type:"string"`

	// The textual data of the message content.
	Data *string `type:"string"`
}

// String returns the string representation
func (s SimpleEmailPart) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimpleEmailPart) MarshalFields(e protocol.FieldEncoder) error {
	if s.Charset != nil {
		v := *s.Charset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Charset", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := *s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Data", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the conditions for the first activity in a journey. This activity
// and its conditions determine which users are participants in a journey.
type StartCondition struct {
	_ struct{} `type:"structure"`

	// The custom description of the condition.
	Description *string `type:"string"`

	// The segment that's associated with the first activity in the journey. This
	// segment determines which users are participants in the journey.
	SegmentStartCondition *SegmentCondition `type:"structure"`
}

// String returns the string representation
func (s StartCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartCondition"}
	if s.SegmentStartCondition != nil {
		if err := s.SegmentStartCondition.Validate(); err != nil {
			invalidParams.AddNested("SegmentStartCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartCondition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentStartCondition != nil {
		v := s.SegmentStartCondition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SegmentStartCondition", v, metadata)
	}
	return nil
}

// Specifies the tags (keys and values) for an application, campaign, journey,
// message template, or segment.
type TagsModel struct {
	_ struct{} `type:"structure"`

	// A string-to-string map of key-value pairs that defines the tags for an application,
	// campaign, journey, message template, or segment. Each of these resources
	// can have a maximum of 50 tags.
	//
	// Each tag consists of a required tag key and an associated tag value. The
	// maximum length of a tag key is 128 characters. The maximum length of a tag
	// value is 256 characters.
	//
	// Tags is a required field
	Tags map[string]string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagsModel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagsModel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagsModel"}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagsModel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Specifies the name of the message template to use for the message.
type Template struct {
	_ struct{} `type:"structure"`

	// The name of the message template to use for the message. If specified, this
	// value must match the name of an existing message template.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Template) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the message template to use for the message, for each type of channel.
type TemplateConfiguration struct {
	_ struct{} `type:"structure"`

	// The email template to use for the message.
	EmailTemplate *Template `type:"structure"`

	// The push notification template to use for the message.
	PushTemplate *Template `type:"structure"`

	// The SMS template to use for the message.
	SMSTemplate *Template `type:"structure"`

	// The voice template to use for the message.
	VoiceTemplate *Template `type:"structure"`
}

// String returns the string representation
func (s TemplateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmailTemplate != nil {
		v := s.EmailTemplate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EmailTemplate", v, metadata)
	}
	if s.PushTemplate != nil {
		v := s.PushTemplate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PushTemplate", v, metadata)
	}
	if s.SMSTemplate != nil {
		v := s.SMSTemplate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SMSTemplate", v, metadata)
	}
	if s.VoiceTemplate != nil {
		v := s.VoiceTemplate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceTemplate", v, metadata)
	}
	return nil
}

// Provides information about a message template that's associated with your
// Amazon Pinpoint account.
type TemplateResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The date when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The date when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for.
	//
	// TemplateType is a required field
	TemplateType TemplateType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplateResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TemplateType) > 0 {
		v := s.TemplateType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about all the message templates that are associated
// with your Amazon Pinpoint account.
type TemplatesResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each message template that's associated with
	// your Amazon Pinpoint account and meets any filter criteria that you specified
	// in the request.
	//
	// Item is a required field
	Item []TemplateResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s TemplatesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TemplatesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Item != nil {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the settings for a campaign treatment. A treatment is a variation
// of a campaign that's used for A/B testing of a campaign.
type TreatmentResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the treatment.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The message configuration settings for the treatment.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The schedule settings for the treatment.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users (segment members) that the treatment is
	// sent to.
	//
	// SizePercent is a required field
	SizePercent *int64 `type:"integer" required:"true"`

	// The current status of the treatment.
	State *CampaignState `type:"structure"`

	// The message template to use for the treatment.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// The custom description of the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of the treatment. A treatment is a variation of a campaign
	// that's used for A/B testing of a campaign.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s TreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TreatmentResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SizePercent != nil {
		v := *s.SizePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SizePercent", protocol.Int64Value(v), metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "State", v, metadata)
	}
	if s.TemplateConfiguration != nil {
		v := s.TemplateConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TemplateConfiguration", v, metadata)
	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies one or more attributes to remove from all the endpoints that are
// associated with an application.
type UpdateAttributesRequest struct {
	_ struct{} `type:"structure"`

	// An array of the attributes to remove from all the endpoints that are associated
	// with the application. The array can specify the complete, exact name of each
	// attribute to remove or it can specify a glob pattern that an attribute name
	// must match in order for the attribute to be removed.
	Blacklist []string `type:"list"`
}

// String returns the string representation
func (s UpdateAttributesRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAttributesRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Blacklist != nil {
		v := s.Blacklist

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Blacklist", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies the status and settings of the voice channel for an application.
type VoiceChannelRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the voice channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s VoiceChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Provides information about the status and settings of the voice channel for
// an application.
type VoiceChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the voice channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the voice channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the voice channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the voice channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the voice channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the voice channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the voice channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the voice
	// channel, this value is VOICE.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the voice channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s VoiceChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the settings for a one-time voice message that's sent directly
// to an endpoint through the voice channel.
type VoiceMessage struct {
	_ struct{} `type:"structure"`

	// The text of the script to use for the voice message.
	Body *string `type:"string"`

	// The code for the language to use when synthesizing the text of the message
	// script. For a list of supported languages and the code for each one, see
	// the Amazon Polly Developer Guide (https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
	LanguageCode *string `type:"string"`

	// The long code to send the voice message from. This value should be one of
	// the dedicated long codes that's assigned to your AWS account. Although it
	// isn't required, we recommend that you specify the long code in E.164 format,
	// for example +12065550100, to ensure prompt and accurate delivery of the message.
	OriginationNumber *string `type:"string"`

	// The default message variables to use in the voice message. You can override
	// the default variables with individual address variables.
	Substitutions map[string][]string `type:"map"`

	// The name of the voice to use when delivering the message. For a list of supported
	// voices, see the Amazon Polly Developer Guide (https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
	VoiceId *string `type:"string"`
}

// String returns the string representation
func (s VoiceMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LanguageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginationNumber != nil {
		v := *s.OriginationNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginationNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Substitutions != nil {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.VoiceId != nil {
		v := *s.VoiceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VoiceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the content and settings for a message template that can be used
// in messages that are sent through the voice channel.
type VoiceTemplateRequest struct {
	_ struct{} `type:"structure"`

	// The text of the script to use in messages that are based on the message template,
	// in plain text format.
	Body *string `type:"string"`

	// A JSON object that specifies the default values to use for message variables
	// in the message template. This object is a set of key-value pairs. Each key
	// defines a message variable in the template. The corresponding value defines
	// the default value for that variable. When you create a message that's based
	// on the template, you can override these defaults with message-specific and
	// address-specific variables and values.
	DefaultSubstitutions *string `type:"string"`

	// The code for the language to use when synthesizing the text of the script
	// in messages that are based on the message template. For a list of supported
	// languages and the code for each one, see the Amazon Polly Developer Guide
	// (https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
	LanguageCode *string `type:"string"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the message template. Each tag consists of a required tag key and an
	// associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the voice to use when delivering messages that are based on the
	// message template. For a list of supported voices, see the Amazon Polly Developer
	// Guide (https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
	VoiceId *string `type:"string"`
}

// String returns the string representation
func (s VoiceTemplateRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceTemplateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LanguageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VoiceId != nil {
		v := *s.VoiceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VoiceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the content and settings for a message template
// that can be used in messages that are sent through the voice channel.
type VoiceTemplateResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The text of the script that's used in messages that are based on the message
	// template, in plain text format.
	Body *string `type:"string"`

	// The date when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The code for the language that's used when synthesizing the text of the script
	// in messages that are based on the message template. For a list of supported
	// languages and the code for each one, see the Amazon Polly Developer Guide
	// (https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
	LanguageCode *string `type:"string"`

	// The date when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for. For a voice
	// template, this value is VOICE.
	//
	// TemplateType is a required field
	TemplateType TemplateType `type:"string" required:"true" enum:"true"`

	// The name of the voice that's used when delivering messages that are based
	// on the message template. For a list of supported voices, see the Amazon Polly
	// Developer Guide (https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
	VoiceId *string `type:"string"`
}

// String returns the string representation
func (s VoiceTemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceTemplateResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultSubstitutions != nil {
		v := *s.DefaultSubstitutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultSubstitutions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LanguageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateDescription != nil {
		v := *s.TemplateDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TemplateType) > 0 {
		v := s.TemplateType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TemplateType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VoiceId != nil {
		v := *s.VoiceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VoiceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the settings for a wait activity in a journey. This type of activity
// waits for a certain amount of time or until a specific date and time before
// moving participants to the next activity in a journey.
type WaitActivity struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the next activity to perform, after performing
	// the wait activity.
	NextActivity *string `type:"string"`

	// The amount of time to wait or the date and time when the activity moves participants
	// to the next activity in the journey.
	WaitTime *WaitTime `type:"structure"`
}

// String returns the string representation
func (s WaitActivity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WaitActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextActivity != nil {
		v := *s.NextActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WaitTime != nil {
		v := s.WaitTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "WaitTime", v, metadata)
	}
	return nil
}

// Specifies a duration or a date and time that indicates when Amazon Pinpoint
// determines whether an activity's conditions have been met or an activity
// moves participants to the next activity in a journey.
type WaitTime struct {
	_ struct{} `type:"structure"`

	// The amount of time to wait, as a duration in ISO 8601 format, before determining
	// whether the activity's conditions have been met or moving participants to
	// the next activity in the journey.
	WaitFor *string `type:"string"`

	// The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether
	// the activity's conditions have been met or the activity moves participants
	// to the next activity in the journey.
	WaitUntil *string `type:"string"`
}

// String returns the string representation
func (s WaitTime) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WaitTime) MarshalFields(e protocol.FieldEncoder) error {
	if s.WaitFor != nil {
		v := *s.WaitFor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WaitFor", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WaitUntil != nil {
		v := *s.WaitUntil

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WaitUntil", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the default settings for an application.
type WriteApplicationSettingsRequest struct {
	_ struct{} `type:"structure"`

	// The settings for the AWS Lambda function to use by default as a code hook
	// for campaigns in the application. To override these settings for a specific
	// campaign, use the Campaign resource to define custom Lambda function settings
	// for the campaign.
	CampaignHook *CampaignHook `type:"structure"`

	// Specifies whether to enable application-related alarms in Amazon CloudWatch.
	CloudWatchMetricsEnabled *bool `type:"boolean"`

	// The default sending limits for campaigns in the application. To override
	// these limits for a specific campaign, use the Campaign resource to define
	// custom limits for the campaign.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for campaigns and journeys in the application. Quiet
	// time is a specific time range when messages aren't sent to endpoints, if
	// all the following conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the application
	//    (or a campaign or journey that has custom quiet time settings).
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the application
	//    (or a campaign or journey that has custom quiet time settings).
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from a campaign or journey, even if quiet time is enabled.
	//
	// To override the default quiet time settings for a specific campaign or journey,
	// use the Campaign resource or the Journey resource to define a custom quiet
	// time for the campaign or journey.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s WriteApplicationSettingsRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteApplicationSettingsRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.CampaignHook != nil {
		v := s.CampaignHook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CampaignHook", v, metadata)
	}
	if s.CloudWatchMetricsEnabled != nil {
		v := *s.CloudWatchMetricsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudWatchMetricsEnabled", protocol.BoolValue(v), metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	return nil
}

// Specifies the configuration and other settings for a campaign.
type WriteCampaignRequest struct {
	_ struct{} `type:"structure"`

	// An array of requests that defines additional treatments for the campaign,
	// in addition to the default treatment for the campaign.
	AdditionalTreatments []WriteTreatmentResource `type:"list"`

	// A custom description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of users (segment members) who shouldn't receive
	// messages from the campaign.
	HoldoutPercent *int64 `type:"integer"`

	// The settings for the AWS Lambda function to use as a code hook for the campaign.
	Hook *CampaignHook `type:"structure"`

	// Specifies whether to pause the campaign. A paused campaign doesn't run unless
	// you resume it by setting this value to false.
	IsPaused *bool `type:"boolean"`

	// The messaging limits for the campaign.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings for the campaign.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The schedule settings for the campaign.
	Schedule *Schedule `type:"structure"`

	// The unique identifier for the segment to associate with the campaign.
	SegmentId *string `type:"string"`

	// The version of the segment to associate with the campaign.
	SegmentVersion *int64 `type:"integer"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the campaign. Each tag consists of a required tag key and an associated
	// tag value.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The message template to use for the campaign.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// A custom description of a variation of the campaign to use for A/B testing.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign to use for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteCampaignRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteCampaignRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WriteCampaignRequest"}
	if s.AdditionalTreatments != nil {
		for i, v := range s.AdditionalTreatments {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdditionalTreatments", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.MessageConfiguration != nil {
		if err := s.MessageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MessageConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteCampaignRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdditionalTreatments != nil {
		v := s.AdditionalTreatments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AdditionalTreatments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HoldoutPercent != nil {
		v := *s.HoldoutPercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HoldoutPercent", protocol.Int64Value(v), metadata)
	}
	if s.Hook != nil {
		v := s.Hook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Hook", v, metadata)
	}
	if s.IsPaused != nil {
		v := *s.IsPaused

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPaused", protocol.BoolValue(v), metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateConfiguration != nil {
		v := s.TemplateConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TemplateConfiguration", v, metadata)
	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the Amazon Resource Name (ARN) of an event stream to publish events
// to and the AWS Identity and Access Management (IAM) role to use when publishing
// those events.
type WriteEventStream struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon
	// Kinesis Data Firehose delivery stream that you want to publish event data
	// to.
	//
	// For a Kinesis data stream, the ARN format is: arn:aws:kinesis:region:account-id:stream/stream_name
	//
	// For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:region:account-id:deliverystream/stream_name
	//
	// DestinationStreamArn is a required field
	DestinationStreamArn *string `type:"string" required:"true"`

	// The AWS Identity and Access Management (IAM) role that authorizes Amazon
	// Pinpoint to publish event data to the stream in your AWS account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s WriteEventStream) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteEventStream) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WriteEventStream"}

	if s.DestinationStreamArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationStreamArn"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteEventStream) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationStreamArn != nil {
		v := *s.DestinationStreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationStreamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the configuration and other settings for a journey.
type WriteJourneyRequest struct {
	_ struct{} `type:"structure"`

	// The configuration and other settings for the activities that comprise the
	// journey.
	Activities map[string]Activity `type:"map"`

	// The date, in ISO 8601 format, when the journey was created.
	CreationDate *string `type:"string"`

	// The date, in ISO 8601 format, when the journey was last modified.
	LastModifiedDate *string `type:"string"`

	// The messaging and entry limits for the journey.
	Limits *JourneyLimits `type:"structure"`

	// Specifies whether the journey's scheduled start and end times use each participant's
	// local time. To base the schedule on each participant's local time, set this
	// value to true.
	LocalTime *bool `type:"boolean"`

	// The name of the journey. A journey name can contain a maximum of 150 characters.
	// The characters can be alphanumeric characters or symbols, such as underscores
	// (_) or hyphens (-). A journey name can't contain any spaces.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The quiet time settings for the journey. Quiet time is a specific time range
	// when a journey doesn't send messages to participants, if all the following
	// conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint for the participant
	//    is set to a valid value.
	//
	//    * The current time in the participant's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the journey.
	//
	//    * The current time in the participant's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the journey.
	//
	// If any of the preceding conditions isn't met, the participant will receive
	// messages from the journey, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`

	// The frequency with which Amazon Pinpoint evaluates segment and event data
	// for the journey, as a duration in ISO 8601 format.
	RefreshFrequency *string `type:"string"`

	// The schedule settings for the journey.
	Schedule *JourneySchedule `type:"structure"`

	// The unique identifier for the first activity in the journey.
	StartActivity *string `type:"string"`

	// The segment that defines which users are participants in the journey.
	StartCondition *StartCondition `type:"structure"`

	// The status of the journey. Valid values are:
	//
	//    * DRAFT - Saves the journey and doesn't publish it.
	//
	//    * ACTIVE - Saves and publishes the journey. Depending on the journey's
	//    schedule, the journey starts running immediately or at the scheduled start
	//    time. If a journey's status is ACTIVE, you can't add, change, or remove
	//    activities from it.
	//
	// The CANCELLED, COMPLETED, and CLOSED values are not supported in requests
	// to create or update a journey. To cancel a journey, use the Journey State
	// resource.
	State State `type:"string" enum:"true"`
}

// String returns the string representation
func (s WriteJourneyRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteJourneyRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WriteJourneyRequest"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Activities != nil {
		for i, v := range s.Activities {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Activities", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.StartCondition != nil {
		if err := s.StartCondition.Validate(); err != nil {
			invalidParams.AddNested("StartCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteJourneyRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Activities != nil {
		v := s.Activities

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Activities", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.LocalTime != nil {
		v := *s.LocalTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocalTime", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	if s.RefreshFrequency != nil {
		v := *s.RefreshFrequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RefreshFrequency", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.StartActivity != nil {
		v := *s.StartActivity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartActivity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartCondition != nil {
		v := s.StartCondition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StartCondition", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the configuration, dimension, and other settings for a segment.
// A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups
// object, but not both.
type WriteSegmentRequest struct {
	_ struct{} `type:"structure"`

	// The criteria that define the dimensions for the segment.
	Dimensions *SegmentDimensions `type:"structure"`

	// The name of the segment.
	Name *string `type:"string"`

	// The segment group to use and the dimensions to apply to the group's base
	// segments in order to build the segment. A segment group can consist of zero
	// or more base segments. Your request can include only one segment group.
	SegmentGroups *SegmentGroupList `type:"structure"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the segment. Each tag consists of a required tag key and an associated
	// tag value.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s WriteSegmentRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteSegmentRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WriteSegmentRequest"}
	if s.Dimensions != nil {
		if err := s.Dimensions.Validate(); err != nil {
			invalidParams.AddNested("Dimensions", err.(aws.ErrInvalidParams))
		}
	}
	if s.SegmentGroups != nil {
		if err := s.SegmentGroups.Validate(); err != nil {
			invalidParams.AddNested("SegmentGroups", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteSegmentRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentGroups != nil {
		v := s.SegmentGroups

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SegmentGroups", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Specifies the settings for a campaign treatment. A treatment is a variation
// of a campaign that's used for A/B testing of a campaign.
type WriteTreatmentResource struct {
	_ struct{} `type:"structure"`

	// The message configuration settings for the treatment.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The schedule settings for the treatment.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users (segment members) to send the treatment
	// to.
	//
	// SizePercent is a required field
	SizePercent *int64 `type:"integer" required:"true"`

	// The message template to use for the treatment.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// A custom description of the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of the treatment. A treatment is a variation of a campaign
	// that's used for A/B testing of a campaign.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteTreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteTreatmentResource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WriteTreatmentResource"}

	if s.SizePercent == nil {
		invalidParams.Add(aws.NewErrParamRequired("SizePercent"))
	}
	if s.MessageConfiguration != nil {
		if err := s.MessageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MessageConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteTreatmentResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SizePercent != nil {
		v := *s.SizePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SizePercent", protocol.Int64Value(v), metadata)
	}
	if s.TemplateConfiguration != nil {
		v := s.TemplateConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TemplateConfiguration", v, metadata)
	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
