// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchAssociateServiceActionWithProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// One or more associations, each consisting of the Action ID, the Product ID,
	// and the Provisioning Artifact ID.
	//
	// ServiceActionAssociations is a required field
	ServiceActionAssociations []ServiceActionAssociation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchAssociateServiceActionWithProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateServiceActionWithProvisioningArtifactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAssociateServiceActionWithProvisioningArtifactInput"}

	if s.ServiceActionAssociations == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceActionAssociations"))
	}
	if s.ServiceActionAssociations != nil && len(s.ServiceActionAssociations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceActionAssociations", 1))
	}
	if s.ServiceActionAssociations != nil {
		for i, v := range s.ServiceActionAssociations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServiceActionAssociations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchAssociateServiceActionWithProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains a list of errors, along with information to help
	// you identify the self-service action.
	FailedServiceActionAssociations []FailedServiceActionAssociation `type:"list"`
}

// String returns the string representation
func (s BatchAssociateServiceActionWithProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchAssociateServiceActionWithProvisioningArtifact = "BatchAssociateServiceActionWithProvisioningArtifact"

// BatchAssociateServiceActionWithProvisioningArtifactRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Associates multiple self-service actions with provisioning artifacts.
//
//    // Example sending a request using BatchAssociateServiceActionWithProvisioningArtifactRequest.
//    req := client.BatchAssociateServiceActionWithProvisioningArtifactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchAssociateServiceActionWithProvisioningArtifact
func (c *Client) BatchAssociateServiceActionWithProvisioningArtifactRequest(input *BatchAssociateServiceActionWithProvisioningArtifactInput) BatchAssociateServiceActionWithProvisioningArtifactRequest {
	op := &aws.Operation{
		Name:       opBatchAssociateServiceActionWithProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchAssociateServiceActionWithProvisioningArtifactInput{}
	}

	req := c.newRequest(op, input, &BatchAssociateServiceActionWithProvisioningArtifactOutput{})
	return BatchAssociateServiceActionWithProvisioningArtifactRequest{Request: req, Input: input, Copy: c.BatchAssociateServiceActionWithProvisioningArtifactRequest}
}

// BatchAssociateServiceActionWithProvisioningArtifactRequest is the request type for the
// BatchAssociateServiceActionWithProvisioningArtifact API operation.
type BatchAssociateServiceActionWithProvisioningArtifactRequest struct {
	*aws.Request
	Input *BatchAssociateServiceActionWithProvisioningArtifactInput
	Copy  func(*BatchAssociateServiceActionWithProvisioningArtifactInput) BatchAssociateServiceActionWithProvisioningArtifactRequest
}

// Send marshals and sends the BatchAssociateServiceActionWithProvisioningArtifact API request.
func (r BatchAssociateServiceActionWithProvisioningArtifactRequest) Send(ctx context.Context) (*BatchAssociateServiceActionWithProvisioningArtifactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchAssociateServiceActionWithProvisioningArtifactResponse{
		BatchAssociateServiceActionWithProvisioningArtifactOutput: r.Request.Data.(*BatchAssociateServiceActionWithProvisioningArtifactOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchAssociateServiceActionWithProvisioningArtifactResponse is the response type for the
// BatchAssociateServiceActionWithProvisioningArtifact API operation.
type BatchAssociateServiceActionWithProvisioningArtifactResponse struct {
	*BatchAssociateServiceActionWithProvisioningArtifactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchAssociateServiceActionWithProvisioningArtifact request.
func (r *BatchAssociateServiceActionWithProvisioningArtifactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
