// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DisableGatewayInput
type DisableGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableGatewayInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DisableGatewayOutput
type DisableGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) of the disabled gateway.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DisableGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableGateway = "DisableGateway"

// DisableGatewayRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Disables a tape gateway when the gateway is no longer functioning. For example,
// if your gateway VM is damaged, you can disable the gateway so you can recover
// virtual tapes.
//
// Use this operation for a tape gateway that is not reachable or not functioning.
// This operation is only supported in the tape gateway type.
//
// Once a gateway is disabled it cannot be enabled.
//
//    // Example sending a request using DisableGatewayRequest.
//    req := client.DisableGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway
func (c *Client) DisableGatewayRequest(input *DisableGatewayInput) DisableGatewayRequest {
	op := &aws.Operation{
		Name:       opDisableGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableGatewayInput{}
	}

	req := c.newRequest(op, input, &DisableGatewayOutput{})
	return DisableGatewayRequest{Request: req, Input: input, Copy: c.DisableGatewayRequest}
}

// DisableGatewayRequest is the request type for the
// DisableGateway API operation.
type DisableGatewayRequest struct {
	*aws.Request
	Input *DisableGatewayInput
	Copy  func(*DisableGatewayInput) DisableGatewayRequest
}

// Send marshals and sends the DisableGateway API request.
func (r DisableGatewayRequest) Send(ctx context.Context) (*DisableGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableGatewayResponse{
		DisableGatewayOutput: r.Request.Data.(*DisableGatewayOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableGatewayResponse is the response type for the
// DisableGateway API operation.
type DisableGatewayResponse struct {
	*DisableGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableGateway request.
func (r *DisableGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
