// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A JSON object containing the of the gateway.
type ListLocalDisksInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLocalDisksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLocalDisksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLocalDisksInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListLocalDisksOutput struct {
	_ struct{} `type:"structure"`

	// A JSON object containing the following fields:
	//
	//    * ListLocalDisksOutput$Disks
	Disks []Disk `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ListLocalDisksOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLocalDisks = "ListLocalDisks"

// ListLocalDisksRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Returns a list of the gateway's local disks. To specify which gateway to
// describe, you use the Amazon Resource Name (ARN) of the gateway in the body
// of the request.
//
// The request returns a list of all disks, specifying which are configured
// as working storage, cache storage, or stored volume or not configured at
// all. The response includes a DiskStatus field. This field can have a value
// of present (the disk is available to use), missing (the disk is no longer
// connected to the gateway), or mismatch (the disk node is occupied by a disk
// that has incorrect metadata or the disk content is corrupted).
//
//    // Example sending a request using ListLocalDisksRequest.
//    req := client.ListLocalDisksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks
func (c *Client) ListLocalDisksRequest(input *ListLocalDisksInput) ListLocalDisksRequest {
	op := &aws.Operation{
		Name:       opListLocalDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLocalDisksInput{}
	}

	req := c.newRequest(op, input, &ListLocalDisksOutput{})
	return ListLocalDisksRequest{Request: req, Input: input, Copy: c.ListLocalDisksRequest}
}

// ListLocalDisksRequest is the request type for the
// ListLocalDisks API operation.
type ListLocalDisksRequest struct {
	*aws.Request
	Input *ListLocalDisksInput
	Copy  func(*ListLocalDisksInput) ListLocalDisksRequest
}

// Send marshals and sends the ListLocalDisks API request.
func (r ListLocalDisksRequest) Send(ctx context.Context) (*ListLocalDisksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLocalDisksResponse{
		ListLocalDisksOutput: r.Request.Data.(*ListLocalDisksOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListLocalDisksResponse is the response type for the
// ListLocalDisks API operation.
type ListLocalDisksResponse struct {
	*ListLocalDisksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLocalDisks request.
func (r *ListLocalDisksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
