// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeNotificationSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return with this call.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The ID of the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `location:"uri" locationName:"OrganizationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotificationSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotificationSubscriptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeNotificationSubscriptionsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeNotificationSubscriptionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.OrganizationId != nil {
		v := *s.OrganizationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "OrganizationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeNotificationSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`

	// The subscriptions.
	Subscriptions []Subscription `type:"list"`
}

// String returns the string representation
func (s DescribeNotificationSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeNotificationSubscriptionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subscriptions != nil {
		v := s.Subscriptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Subscriptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeNotificationSubscriptions = "DescribeNotificationSubscriptions"

// DescribeNotificationSubscriptionsRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Lists the specified notification subscriptions.
//
//    // Example sending a request using DescribeNotificationSubscriptionsRequest.
//    req := client.DescribeNotificationSubscriptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions
func (c *Client) DescribeNotificationSubscriptionsRequest(input *DescribeNotificationSubscriptionsInput) DescribeNotificationSubscriptionsRequest {
	op := &aws.Operation{
		Name:       opDescribeNotificationSubscriptions,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/organizations/{OrganizationId}/subscriptions",
	}

	if input == nil {
		input = &DescribeNotificationSubscriptionsInput{}
	}

	req := c.newRequest(op, input, &DescribeNotificationSubscriptionsOutput{})
	return DescribeNotificationSubscriptionsRequest{Request: req, Input: input, Copy: c.DescribeNotificationSubscriptionsRequest}
}

// DescribeNotificationSubscriptionsRequest is the request type for the
// DescribeNotificationSubscriptions API operation.
type DescribeNotificationSubscriptionsRequest struct {
	*aws.Request
	Input *DescribeNotificationSubscriptionsInput
	Copy  func(*DescribeNotificationSubscriptionsInput) DescribeNotificationSubscriptionsRequest
}

// Send marshals and sends the DescribeNotificationSubscriptions API request.
func (r DescribeNotificationSubscriptionsRequest) Send(ctx context.Context) (*DescribeNotificationSubscriptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeNotificationSubscriptionsResponse{
		DescribeNotificationSubscriptionsOutput: r.Request.Data.(*DescribeNotificationSubscriptionsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeNotificationSubscriptionsResponse is the response type for the
// DescribeNotificationSubscriptions API operation.
type DescribeNotificationSubscriptionsResponse struct {
	*DescribeNotificationSubscriptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeNotificationSubscriptions request.
func (r *DescribeNotificationSubscriptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
