package blockchain

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/blockchain/mgmt/2018-06-01-preview/blockchain"

// APIKey API key payload which is exposed in the request/response of the resource provider.
type APIKey struct {
	// KeyName - Gets or sets the API key name.
	KeyName *string `json:"keyName,omitempty"`
	// Value - Gets or sets the API key value.
	Value *string `json:"value,omitempty"`
}

// APIKeyCollection collection of the API key payload which is exposed in the response of the resource
// provider.
type APIKeyCollection struct {
	autorest.Response `json:"-"`
	// Keys - Gets or sets the collection of API key.
	Keys *[]APIKey `json:"keys,omitempty"`
}

// Consortium consortium payload
type Consortium struct {
	// Name - Gets or sets the blockchain member name.
	Name *string `json:"name,omitempty"`
	// Protocol - Gets or sets the protocol for the consortium. Possible values include: 'ProtocolNotSpecified', 'ProtocolParity', 'ProtocolQuorum', 'ProtocolCorda'
	Protocol Protocol `json:"protocol,omitempty"`
}

// ConsortiumCollection collection of the consortium payload.
type ConsortiumCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the collection of consortiums.
	Value *[]Consortium `json:"value,omitempty"`
}

// ConsortiumMember consortium approval
type ConsortiumMember struct {
	// Name - Gets the consortium member name.
	Name *string `json:"name,omitempty"`
	// DisplayName - Gets the consortium member display name.
	DisplayName *string `json:"displayName,omitempty"`
	// SubscriptionID - Gets the consortium member subscription id.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// Role - Gets the consortium member role.
	Role *string `json:"role,omitempty"`
	// Status - Gets the consortium member status.
	Status *string `json:"status,omitempty"`
	// JoinDate - Gets the consortium member join date.
	JoinDate *date.Time `json:"joinDate,omitempty"`
	// DateModified - Gets the consortium member modified date.
	DateModified *date.Time `json:"dateModified,omitempty"`
}

// ConsortiumMemberCollection collection of consortium payload.
type ConsortiumMemberCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the collection of consortiums.
	Value *[]ConsortiumMember `json:"value,omitempty"`
	// NextLink - Gets or sets the URL, that the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConsortiumMemberCollectionIterator provides access to a complete listing of ConsortiumMember values.
type ConsortiumMemberCollectionIterator struct {
	i    int
	page ConsortiumMemberCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConsortiumMemberCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConsortiumMemberCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConsortiumMemberCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConsortiumMemberCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConsortiumMemberCollectionIterator) Response() ConsortiumMemberCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConsortiumMemberCollectionIterator) Value() ConsortiumMember {
	if !iter.page.NotDone() {
		return ConsortiumMember{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConsortiumMemberCollectionIterator type.
func NewConsortiumMemberCollectionIterator(page ConsortiumMemberCollectionPage) ConsortiumMemberCollectionIterator {
	return ConsortiumMemberCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cmc ConsortiumMemberCollection) IsEmpty() bool {
	return cmc.Value == nil || len(*cmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cmc ConsortiumMemberCollection) hasNextLink() bool {
	return cmc.NextLink != nil && len(*cmc.NextLink) != 0
}

// consortiumMemberCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cmc ConsortiumMemberCollection) consortiumMemberCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cmc.NextLink)))
}

// ConsortiumMemberCollectionPage contains a page of ConsortiumMember values.
type ConsortiumMemberCollectionPage struct {
	fn  func(context.Context, ConsortiumMemberCollection) (ConsortiumMemberCollection, error)
	cmc ConsortiumMemberCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConsortiumMemberCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConsortiumMemberCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cmc)
		if err != nil {
			return err
		}
		page.cmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConsortiumMemberCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConsortiumMemberCollectionPage) NotDone() bool {
	return !page.cmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConsortiumMemberCollectionPage) Response() ConsortiumMemberCollection {
	return page.cmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConsortiumMemberCollectionPage) Values() []ConsortiumMember {
	if page.cmc.IsEmpty() {
		return nil
	}
	return *page.cmc.Value
}

// Creates a new instance of the ConsortiumMemberCollectionPage type.
func NewConsortiumMemberCollectionPage(cur ConsortiumMemberCollection, getNextPage func(context.Context, ConsortiumMemberCollection) (ConsortiumMemberCollection, error)) ConsortiumMemberCollectionPage {
	return ConsortiumMemberCollectionPage{
		fn:  getNextPage,
		cmc: cur,
	}
}

// FirewallRule ip range for firewall rules
type FirewallRule struct {
	// RuleName - Gets or sets the name of the firewall rules.
	RuleName *string `json:"ruleName,omitempty"`
	// StartIPAddress - Gets or sets the start IP address of the firewall rule range.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - Gets or sets the end IP address of the firewall rule range.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// Member payload of the blockchain member which is exposed in the request/response of the resource
// provider.
type Member struct {
	autorest.Response `json:"-"`
	// MemberProperties - Gets or sets the blockchain member properties.
	*MemberProperties `json:"properties,omitempty"`
	// Sku - Gets or sets the blockchain member Sku.
	Sku *Sku `json:"sku,omitempty"`
	// Location - The GEO location of the blockchain service.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describes the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the service - e.g. "Microsoft.Blockchain"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Member.
func (mVar Member) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.MemberProperties != nil {
		objectMap["properties"] = mVar.MemberProperties
	}
	if mVar.Sku != nil {
		objectMap["sku"] = mVar.Sku
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Member struct.
func (mVar *Member) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var memberProperties MemberProperties
				err = json.Unmarshal(*v, &memberProperties)
				if err != nil {
					return err
				}
				mVar.MemberProperties = &memberProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mVar.Sku = &sku
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// MemberCollection collection of the blockchain member payload which is exposed in the request/response of
// the resource provider.
type MemberCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the collection of blockchain members.
	Value *[]Member `json:"value,omitempty"`
	// NextLink - Gets or sets the URL, that the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// MemberCollectionIterator provides access to a complete listing of Member values.
type MemberCollectionIterator struct {
	i    int
	page MemberCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MemberCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MemberCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MemberCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MemberCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MemberCollectionIterator) Response() MemberCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MemberCollectionIterator) Value() Member {
	if !iter.page.NotDone() {
		return Member{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MemberCollectionIterator type.
func NewMemberCollectionIterator(page MemberCollectionPage) MemberCollectionIterator {
	return MemberCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mc MemberCollection) IsEmpty() bool {
	return mc.Value == nil || len(*mc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mc MemberCollection) hasNextLink() bool {
	return mc.NextLink != nil && len(*mc.NextLink) != 0
}

// memberCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mc MemberCollection) memberCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !mc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mc.NextLink)))
}

// MemberCollectionPage contains a page of Member values.
type MemberCollectionPage struct {
	fn func(context.Context, MemberCollection) (MemberCollection, error)
	mc MemberCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MemberCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MemberCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mc)
		if err != nil {
			return err
		}
		page.mc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MemberCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MemberCollectionPage) NotDone() bool {
	return !page.mc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MemberCollectionPage) Response() MemberCollection {
	return page.mc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MemberCollectionPage) Values() []Member {
	if page.mc.IsEmpty() {
		return nil
	}
	return *page.mc.Value
}

// Creates a new instance of the MemberCollectionPage type.
func NewMemberCollectionPage(cur MemberCollection, getNextPage func(context.Context, MemberCollection) (MemberCollection, error)) MemberCollectionPage {
	return MemberCollectionPage{
		fn: getNextPage,
		mc: cur,
	}
}

// MemberNodesSku payload of the blockchain member nodes Sku for a blockchain member.
type MemberNodesSku struct {
	// Capacity - Gets or sets the nodes capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// MemberProperties payload of the blockchain member properties for a blockchain member.
type MemberProperties struct {
	// Protocol - Gets or sets the blockchain protocol. Possible values include: 'ProtocolNotSpecified', 'ProtocolParity', 'ProtocolQuorum', 'ProtocolCorda'
	Protocol Protocol `json:"protocol,omitempty"`
	// ValidatorNodesSku - Gets or sets the blockchain validator nodes Sku.
	ValidatorNodesSku *MemberNodesSku `json:"validatorNodesSku,omitempty"`
	// ProvisioningState - READ-ONLY; Gets or sets the blockchain member provision state. Possible values include: 'NotSpecified', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Stale'
	ProvisioningState MemberProvisioningState `json:"provisioningState,omitempty"`
	// DNS - READ-ONLY; Gets the dns endpoint of the blockchain member.
	DNS *string `json:"dns,omitempty"`
	// UserName - READ-ONLY; Gets the auth user name of the blockchain member.
	UserName *string `json:"userName,omitempty"`
	// Password - Sets the basic auth password of the blockchain member.
	Password *string `json:"password,omitempty"`
	// Consortium - Gets or sets the consortium for the blockchain member.
	Consortium *string `json:"consortium,omitempty"`
	// ConsortiumManagementAccountAddress - READ-ONLY; Gets the managed consortium management account address.
	ConsortiumManagementAccountAddress *string `json:"consortiumManagementAccountAddress,omitempty"`
	// ConsortiumManagementAccountPassword - Sets the managed consortium management account password.
	ConsortiumManagementAccountPassword *string `json:"consortiumManagementAccountPassword,omitempty"`
	// ConsortiumRole - Gets the role of the member in the consortium.
	ConsortiumRole *string `json:"consortiumRole,omitempty"`
	// ConsortiumMemberDisplayName - Gets the display name of the member in the consortium.
	ConsortiumMemberDisplayName *string `json:"consortiumMemberDisplayName,omitempty"`
	// RootContractAddress - READ-ONLY; Gets the Ethereum root contract address of the blockchain.
	RootContractAddress *string `json:"rootContractAddress,omitempty"`
	// PublicKey - READ-ONLY; Gets the public key of the blockchain member (default transaction node).
	PublicKey *string `json:"publicKey,omitempty"`
	// FirewallRules - Gets or sets firewall rules
	FirewallRules *[]FirewallRule `json:"firewallRules,omitempty"`
}

// MarshalJSON is the custom marshaler for MemberProperties.
func (mp MemberProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.Protocol != "" {
		objectMap["protocol"] = mp.Protocol
	}
	if mp.ValidatorNodesSku != nil {
		objectMap["validatorNodesSku"] = mp.ValidatorNodesSku
	}
	if mp.Password != nil {
		objectMap["password"] = mp.Password
	}
	if mp.Consortium != nil {
		objectMap["consortium"] = mp.Consortium
	}
	if mp.ConsortiumManagementAccountPassword != nil {
		objectMap["consortiumManagementAccountPassword"] = mp.ConsortiumManagementAccountPassword
	}
	if mp.ConsortiumRole != nil {
		objectMap["consortiumRole"] = mp.ConsortiumRole
	}
	if mp.ConsortiumMemberDisplayName != nil {
		objectMap["consortiumMemberDisplayName"] = mp.ConsortiumMemberDisplayName
	}
	if mp.FirewallRules != nil {
		objectMap["firewallRules"] = mp.FirewallRules
	}
	return json.Marshal(objectMap)
}

// MemberPropertiesUpdate update the payload of the blockchain member properties for a blockchain member.
type MemberPropertiesUpdate struct {
	// ConsortiumManagementAccountPassword - Sets the managed consortium management account password.
	ConsortiumManagementAccountPassword *string `json:"consortiumManagementAccountPassword,omitempty"`
	// Password - Sets the transaction node dns endpoint basic auth password.
	Password *string `json:"password,omitempty"`
	// FirewallRules - Gets or sets the firewall rules.
	FirewallRules *[]FirewallRule `json:"firewallRules,omitempty"`
}

// MembersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MembersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MembersClient) (Member, error)
}

// MembersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MembersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MembersClient) (autorest.Response, error)
}

// MemberUpdate update the payload of the blockchain member which is exposed in the request/response of the
// resource provider.
type MemberUpdate struct {
	// Tags - Tags of the service which is a list of key value pairs that describes the resource.
	Tags map[string]*string `json:"tags"`
	// MemberPropertiesUpdate - Gets or sets the blockchain member update properties.
	*MemberPropertiesUpdate `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MemberUpdate.
func (mu MemberUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mu.Tags != nil {
		objectMap["tags"] = mu.Tags
	}
	if mu.MemberPropertiesUpdate != nil {
		objectMap["properties"] = mu.MemberPropertiesUpdate
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MemberUpdate struct.
func (mu *MemberUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mu.Tags = tags
			}
		case "properties":
			if v != nil {
				var memberPropertiesUpdate MemberPropertiesUpdate
				err = json.Unmarshal(*v, &memberPropertiesUpdate)
				if err != nil {
					return err
				}
				mu.MemberPropertiesUpdate = &memberPropertiesUpdate
			}
		}
	}

	return nil
}

// NameAvailability name availability payload which is exposed in the response of the resource provider.
type NameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - Gets or sets the value indicating whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Message - Gets or sets the message.
	Message *string `json:"message,omitempty"`
	// Reason - Gets or sets the name availability reason. Possible values include: 'NameAvailabilityReasonNotSpecified', 'NameAvailabilityReasonAlreadyExists', 'NameAvailabilityReasonInvalid'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
}

// NameAvailabilityRequest name availability request payload which is exposed in the request of the
// resource provider.
type NameAvailabilityRequest struct {
	// Name - Gets or sets the name to check.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the resource to check.
	Type *string `json:"type,omitempty"`
}

// OperationResult operation result payload which is exposed in the response of the resource provider.
type OperationResult struct {
	autorest.Response `json:"-"`
	// Name - Gets or sets the operation name.
	Name *string `json:"name,omitempty"`
	// StartTime - Gets or sets the operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets or sets the operation end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// Resource the core properties of the resources.
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the service - e.g. "Microsoft.Blockchain"
	Type *string `json:"type,omitempty"`
}

// ResourceProviderOperation operation payload which is exposed in the response of the resource provider.
type ResourceProviderOperation struct {
	// Origin - Gets or sets the origin.
	Origin *string `json:"origin,omitempty"`
	// Name - Gets or sets the operation name.
	Name *string `json:"name,omitempty"`
	// IsDataAction - Gets or sets a value indicating whether the operation is a data action or not.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Gets or sets operation display
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
}

// ResourceProviderOperationCollection collection of operation payload which is exposed in the response of
// the resource provider.
type ResourceProviderOperationCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the collection of operations.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
	// NextLink - Gets or sets the URL, that the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceProviderOperationCollectionIterator provides access to a complete listing of
// ResourceProviderOperation values.
type ResourceProviderOperationCollectionIterator struct {
	i    int
	page ResourceProviderOperationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceProviderOperationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceProviderOperationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceProviderOperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceProviderOperationCollectionIterator) Response() ResourceProviderOperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceProviderOperationCollectionIterator) Value() ResourceProviderOperation {
	if !iter.page.NotDone() {
		return ResourceProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceProviderOperationCollectionIterator type.
func NewResourceProviderOperationCollectionIterator(page ResourceProviderOperationCollectionPage) ResourceProviderOperationCollectionIterator {
	return ResourceProviderOperationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rpoc ResourceProviderOperationCollection) IsEmpty() bool {
	return rpoc.Value == nil || len(*rpoc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rpoc ResourceProviderOperationCollection) hasNextLink() bool {
	return rpoc.NextLink != nil && len(*rpoc.NextLink) != 0
}

// resourceProviderOperationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpoc ResourceProviderOperationCollection) resourceProviderOperationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rpoc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpoc.NextLink)))
}

// ResourceProviderOperationCollectionPage contains a page of ResourceProviderOperation values.
type ResourceProviderOperationCollectionPage struct {
	fn   func(context.Context, ResourceProviderOperationCollection) (ResourceProviderOperationCollection, error)
	rpoc ResourceProviderOperationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceProviderOperationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rpoc)
		if err != nil {
			return err
		}
		page.rpoc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceProviderOperationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceProviderOperationCollectionPage) NotDone() bool {
	return !page.rpoc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceProviderOperationCollectionPage) Response() ResourceProviderOperationCollection {
	return page.rpoc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceProviderOperationCollectionPage) Values() []ResourceProviderOperation {
	if page.rpoc.IsEmpty() {
		return nil
	}
	return *page.rpoc.Value
}

// Creates a new instance of the ResourceProviderOperationCollectionPage type.
func NewResourceProviderOperationCollectionPage(cur ResourceProviderOperationCollection, getNextPage func(context.Context, ResourceProviderOperationCollection) (ResourceProviderOperationCollection, error)) ResourceProviderOperationCollectionPage {
	return ResourceProviderOperationCollectionPage{
		fn:   getNextPage,
		rpoc: cur,
	}
}

// ResourceProviderOperationDisplay operation display payload which is exposed in the response of the
// resource provider.
type ResourceProviderOperationDisplay struct {
	// Provider - Gets or sets the name of the provider for display purposes.
	Provider *string `json:"provider,omitempty"`
	// Resource - Gets or sets the name of the resource type for display purposes.
	Resource *string `json:"resource,omitempty"`
	// Operation - Gets or sets the name of the operation for display purposes.
	Operation *string `json:"operation,omitempty"`
	// Description - Gets or sets the description of the provider for display purposes.
	Description *string `json:"description,omitempty"`
}

// ResourceTypeSku resource type Sku.
type ResourceTypeSku struct {
	// ResourceType - Gets or sets the resource type
	ResourceType *string `json:"resourceType,omitempty"`
	// Skus - Gets or sets the Skus
	Skus *[]SkuSetting `json:"skus,omitempty"`
}

// ResourceTypeSkuCollection collection of the resource type Sku.
type ResourceTypeSkuCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the collection of resource type Sku.
	Value *[]ResourceTypeSku `json:"value,omitempty"`
}

// Sku blockchain member Sku in payload
type Sku struct {
	// Name - Gets or sets Sku name
	Name *string `json:"name,omitempty"`
	// Tier - Gets or sets Sku tier
	Tier *string `json:"tier,omitempty"`
}

// SkuSetting sku Setting.
type SkuSetting struct {
	// Name - Gets or sets the Sku name.
	Name *string `json:"name,omitempty"`
	// Tier - Gets or sets the Sku tier.
	Tier *string `json:"tier,omitempty"`
	// Locations - Gets or sets the locations.
	Locations *[]string `json:"locations,omitempty"`
	// RequiredFeatures - Gets or sets the required features.
	RequiredFeatures *[]string `json:"requiredFeatures,omitempty"`
}

// TrackedResource the resource model definition for a top level resource.
type TrackedResource struct {
	// Location - The GEO location of the blockchain service.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describes the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the service - e.g. "Microsoft.Blockchain"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TransactionNode payload of the transaction node which is the request/response of the resource provider.
type TransactionNode struct {
	autorest.Response `json:"-"`
	// Location - Gets or sets the transaction node location.
	Location *string `json:"location,omitempty"`
	// TransactionNodeProperties - Gets or sets the blockchain member properties.
	*TransactionNodeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the service - e.g. "Microsoft.Blockchain"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransactionNode.
func (tn TransactionNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tn.Location != nil {
		objectMap["location"] = tn.Location
	}
	if tn.TransactionNodeProperties != nil {
		objectMap["properties"] = tn.TransactionNodeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransactionNode struct.
func (tn *TransactionNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tn.Location = &location
			}
		case "properties":
			if v != nil {
				var transactionNodeProperties TransactionNodeProperties
				err = json.Unmarshal(*v, &transactionNodeProperties)
				if err != nil {
					return err
				}
				tn.TransactionNodeProperties = &transactionNodeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tn.Type = &typeVar
			}
		}
	}

	return nil
}

// TransactionNodeCollection collection of transaction node payload which is exposed in the
// request/response of the resource provider.
type TransactionNodeCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the collection of transaction nodes.
	Value *[]TransactionNode `json:"value,omitempty"`
	// NextLink - Gets or sets the URL, that the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// TransactionNodeCollectionIterator provides access to a complete listing of TransactionNode values.
type TransactionNodeCollectionIterator struct {
	i    int
	page TransactionNodeCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransactionNodeCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionNodeCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransactionNodeCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransactionNodeCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransactionNodeCollectionIterator) Response() TransactionNodeCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransactionNodeCollectionIterator) Value() TransactionNode {
	if !iter.page.NotDone() {
		return TransactionNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransactionNodeCollectionIterator type.
func NewTransactionNodeCollectionIterator(page TransactionNodeCollectionPage) TransactionNodeCollectionIterator {
	return TransactionNodeCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tnc TransactionNodeCollection) IsEmpty() bool {
	return tnc.Value == nil || len(*tnc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tnc TransactionNodeCollection) hasNextLink() bool {
	return tnc.NextLink != nil && len(*tnc.NextLink) != 0
}

// transactionNodeCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tnc TransactionNodeCollection) transactionNodeCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !tnc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tnc.NextLink)))
}

// TransactionNodeCollectionPage contains a page of TransactionNode values.
type TransactionNodeCollectionPage struct {
	fn  func(context.Context, TransactionNodeCollection) (TransactionNodeCollection, error)
	tnc TransactionNodeCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransactionNodeCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionNodeCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tnc)
		if err != nil {
			return err
		}
		page.tnc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransactionNodeCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransactionNodeCollectionPage) NotDone() bool {
	return !page.tnc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransactionNodeCollectionPage) Response() TransactionNodeCollection {
	return page.tnc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransactionNodeCollectionPage) Values() []TransactionNode {
	if page.tnc.IsEmpty() {
		return nil
	}
	return *page.tnc.Value
}

// Creates a new instance of the TransactionNodeCollectionPage type.
func NewTransactionNodeCollectionPage(cur TransactionNodeCollection, getNextPage func(context.Context, TransactionNodeCollection) (TransactionNodeCollection, error)) TransactionNodeCollectionPage {
	return TransactionNodeCollectionPage{
		fn:  getNextPage,
		tnc: cur,
	}
}

// TransactionNodeProperties payload of transaction node properties payload in the transaction node
// payload.
type TransactionNodeProperties struct {
	// ProvisioningState - READ-ONLY; Gets or sets the blockchain member provision state. Possible values include: 'NodeProvisioningStateNotSpecified', 'NodeProvisioningStateUpdating', 'NodeProvisioningStateDeleting', 'NodeProvisioningStateSucceeded', 'NodeProvisioningStateFailed'
	ProvisioningState NodeProvisioningState `json:"provisioningState,omitempty"`
	// DNS - READ-ONLY; Gets or sets the transaction node dns endpoint.
	DNS *string `json:"dns,omitempty"`
	// PublicKey - READ-ONLY; Gets or sets the transaction node public key.
	PublicKey *string `json:"publicKey,omitempty"`
	// UserName - READ-ONLY; Gets or sets the transaction node dns endpoint basic auth user name.
	UserName *string `json:"userName,omitempty"`
	// Password - Sets the transaction node dns endpoint basic auth password.
	Password *string `json:"password,omitempty"`
	// FirewallRules - Gets or sets the firewall rules.
	FirewallRules *[]FirewallRule `json:"firewallRules,omitempty"`
}

// MarshalJSON is the custom marshaler for TransactionNodeProperties.
func (tnp TransactionNodeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tnp.Password != nil {
		objectMap["password"] = tnp.Password
	}
	if tnp.FirewallRules != nil {
		objectMap["firewallRules"] = tnp.FirewallRules
	}
	return json.Marshal(objectMap)
}

// TransactionNodePropertiesUpdate update the payload of the transaction node properties in the transaction
// node payload.
type TransactionNodePropertiesUpdate struct {
	// Password - Sets the transaction node dns endpoint basic auth password.
	Password *string `json:"password,omitempty"`
	// FirewallRules - Gets or sets the firewall rules.
	FirewallRules *[]FirewallRule `json:"firewallRules,omitempty"`
}

// TransactionNodesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TransactionNodesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TransactionNodesClient) (TransactionNode, error)
}

// TransactionNodesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TransactionNodesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TransactionNodesClient) (autorest.Response, error)
}

// TransactionNodeUpdate update the transaction node payload which is exposed in the request/response of
// the resource provider.
type TransactionNodeUpdate struct {
	// TransactionNodePropertiesUpdate - Gets or sets the transaction node update properties.
	*TransactionNodePropertiesUpdate `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TransactionNodeUpdate.
func (tnu TransactionNodeUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tnu.TransactionNodePropertiesUpdate != nil {
		objectMap["properties"] = tnu.TransactionNodePropertiesUpdate
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransactionNodeUpdate struct.
func (tnu *TransactionNodeUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transactionNodePropertiesUpdate TransactionNodePropertiesUpdate
				err = json.Unmarshal(*v, &transactionNodePropertiesUpdate)
				if err != nil {
					return err
				}
				tnu.TransactionNodePropertiesUpdate = &transactionNodePropertiesUpdate
			}
		}
	}

	return nil
}
