package artifacts

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DataFlowClient is the client for the DataFlow methods of the Artifacts service.
type DataFlowClient struct {
	BaseClient
}

// NewDataFlowClient creates an instance of the DataFlowClient client.
func NewDataFlowClient(endpoint string) DataFlowClient {
	return DataFlowClient{New(endpoint)}
}

// CreateOrUpdateDataFlow creates or updates a data flow.
// Parameters:
// dataFlowName - the data flow name.
// dataFlow - data flow resource definition.
// ifMatch - eTag of the data flow entity. Should only be specified for update, for which it should match
// existing entity or can be * for unconditional update.
func (client DataFlowClient) CreateOrUpdateDataFlow(ctx context.Context, dataFlowName string, dataFlow DataFlowResource, ifMatch string) (result DataFlowCreateOrUpdateDataFlowFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowClient.CreateOrUpdateDataFlow")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: dataFlowName,
			Constraints: []validation.Constraint{{Target: "dataFlowName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "dataFlowName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "dataFlowName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.DataFlowClient", "CreateOrUpdateDataFlow", err.Error())
	}

	req, err := client.CreateOrUpdateDataFlowPreparer(ctx, dataFlowName, dataFlow, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "CreateOrUpdateDataFlow", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateDataFlowSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "CreateOrUpdateDataFlow", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateDataFlowPreparer prepares the CreateOrUpdateDataFlow request.
func (client DataFlowClient) CreateOrUpdateDataFlowPreparer(ctx context.Context, dataFlowName string, dataFlow DataFlowResource, ifMatch string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"dataFlowName": autorest.Encode("path", dataFlowName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/dataflows/{dataFlowName}", pathParameters),
		autorest.WithJSON(dataFlow),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateDataFlowSender sends the CreateOrUpdateDataFlow request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowClient) CreateOrUpdateDataFlowSender(req *http.Request) (future DataFlowCreateOrUpdateDataFlowFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client DataFlowClient) (dfr DataFlowResource, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "artifacts.DataFlowCreateOrUpdateDataFlowFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("artifacts.DataFlowCreateOrUpdateDataFlowFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		dfr.Response.Response, err = future.GetResult(sender)
		if dfr.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "artifacts.DataFlowCreateOrUpdateDataFlowFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && dfr.Response.Response.StatusCode != http.StatusNoContent {
			dfr, err = client.CreateOrUpdateDataFlowResponder(dfr.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "artifacts.DataFlowCreateOrUpdateDataFlowFuture", "Result", dfr.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateDataFlowResponder handles the response to the CreateOrUpdateDataFlow request. The method always
// closes the http.Response Body.
func (client DataFlowClient) CreateOrUpdateDataFlowResponder(resp *http.Response) (result DataFlowResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteDataFlow deletes a data flow.
// Parameters:
// dataFlowName - the data flow name.
func (client DataFlowClient) DeleteDataFlow(ctx context.Context, dataFlowName string) (result DataFlowDeleteDataFlowFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowClient.DeleteDataFlow")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: dataFlowName,
			Constraints: []validation.Constraint{{Target: "dataFlowName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "dataFlowName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "dataFlowName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.DataFlowClient", "DeleteDataFlow", err.Error())
	}

	req, err := client.DeleteDataFlowPreparer(ctx, dataFlowName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "DeleteDataFlow", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteDataFlowSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "DeleteDataFlow", nil, "Failure sending request")
		return
	}

	return
}

// DeleteDataFlowPreparer prepares the DeleteDataFlow request.
func (client DataFlowClient) DeleteDataFlowPreparer(ctx context.Context, dataFlowName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"dataFlowName": autorest.Encode("path", dataFlowName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/dataflows/{dataFlowName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDataFlowSender sends the DeleteDataFlow request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowClient) DeleteDataFlowSender(req *http.Request) (future DataFlowDeleteDataFlowFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client DataFlowClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "artifacts.DataFlowDeleteDataFlowFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("artifacts.DataFlowDeleteDataFlowFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// DeleteDataFlowResponder handles the response to the DeleteDataFlow request. The method always
// closes the http.Response Body.
func (client DataFlowClient) DeleteDataFlowResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetDataFlow gets a data flow.
// Parameters:
// dataFlowName - the data flow name.
// ifNoneMatch - eTag of the data flow entity. Should only be specified for get. If the ETag matches the
// existing entity tag, or if * was provided, then no content will be returned.
func (client DataFlowClient) GetDataFlow(ctx context.Context, dataFlowName string, ifNoneMatch string) (result DataFlowResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowClient.GetDataFlow")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: dataFlowName,
			Constraints: []validation.Constraint{{Target: "dataFlowName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "dataFlowName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "dataFlowName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.DataFlowClient", "GetDataFlow", err.Error())
	}

	req, err := client.GetDataFlowPreparer(ctx, dataFlowName, ifNoneMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "GetDataFlow", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDataFlowSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "GetDataFlow", resp, "Failure sending request")
		return
	}

	result, err = client.GetDataFlowResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "GetDataFlow", resp, "Failure responding to request")
		return
	}

	return
}

// GetDataFlowPreparer prepares the GetDataFlow request.
func (client DataFlowClient) GetDataFlowPreparer(ctx context.Context, dataFlowName string, ifNoneMatch string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"dataFlowName": autorest.Encode("path", dataFlowName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/dataflows/{dataFlowName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDataFlowSender sends the GetDataFlow request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowClient) GetDataFlowSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetDataFlowResponder handles the response to the GetDataFlow request. The method always
// closes the http.Response Body.
func (client DataFlowClient) GetDataFlowResponder(resp *http.Response) (result DataFlowResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDataFlowsByWorkspace lists data flows.
func (client DataFlowClient) GetDataFlowsByWorkspace(ctx context.Context) (result DataFlowListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowClient.GetDataFlowsByWorkspace")
		defer func() {
			sc := -1
			if result.dflr.Response.Response != nil {
				sc = result.dflr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getDataFlowsByWorkspaceNextResults
	req, err := client.GetDataFlowsByWorkspacePreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "GetDataFlowsByWorkspace", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDataFlowsByWorkspaceSender(req)
	if err != nil {
		result.dflr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "GetDataFlowsByWorkspace", resp, "Failure sending request")
		return
	}

	result.dflr, err = client.GetDataFlowsByWorkspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "GetDataFlowsByWorkspace", resp, "Failure responding to request")
		return
	}
	if result.dflr.hasNextLink() && result.dflr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetDataFlowsByWorkspacePreparer prepares the GetDataFlowsByWorkspace request.
func (client DataFlowClient) GetDataFlowsByWorkspacePreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/dataflows"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDataFlowsByWorkspaceSender sends the GetDataFlowsByWorkspace request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowClient) GetDataFlowsByWorkspaceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetDataFlowsByWorkspaceResponder handles the response to the GetDataFlowsByWorkspace request. The method always
// closes the http.Response Body.
func (client DataFlowClient) GetDataFlowsByWorkspaceResponder(resp *http.Response) (result DataFlowListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getDataFlowsByWorkspaceNextResults retrieves the next set of results, if any.
func (client DataFlowClient) getDataFlowsByWorkspaceNextResults(ctx context.Context, lastResults DataFlowListResponse) (result DataFlowListResponse, err error) {
	req, err := lastResults.dataFlowListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "getDataFlowsByWorkspaceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetDataFlowsByWorkspaceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "getDataFlowsByWorkspaceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetDataFlowsByWorkspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "getDataFlowsByWorkspaceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetDataFlowsByWorkspaceComplete enumerates all values, automatically crossing page boundaries as required.
func (client DataFlowClient) GetDataFlowsByWorkspaceComplete(ctx context.Context) (result DataFlowListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowClient.GetDataFlowsByWorkspace")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetDataFlowsByWorkspace(ctx)
	return
}

// RenameDataFlow renames a dataflow.
// Parameters:
// dataFlowName - the data flow name.
// request - proposed new name.
func (client DataFlowClient) RenameDataFlow(ctx context.Context, dataFlowName string, request RenameRequest) (result DataFlowRenameDataFlowFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowClient.RenameDataFlow")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: dataFlowName,
			Constraints: []validation.Constraint{{Target: "dataFlowName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "dataFlowName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "dataFlowName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.NewName", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.NewName", Name: validation.MaxLength, Rule: 260, Chain: nil},
					{Target: "request.NewName", Name: validation.MinLength, Rule: 1, Chain: nil},
					{Target: "request.NewName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("artifacts.DataFlowClient", "RenameDataFlow", err.Error())
	}

	req, err := client.RenameDataFlowPreparer(ctx, dataFlowName, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "RenameDataFlow", nil, "Failure preparing request")
		return
	}

	result, err = client.RenameDataFlowSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowClient", "RenameDataFlow", nil, "Failure sending request")
		return
	}

	return
}

// RenameDataFlowPreparer prepares the RenameDataFlow request.
func (client DataFlowClient) RenameDataFlowPreparer(ctx context.Context, dataFlowName string, request RenameRequest) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"dataFlowName": autorest.Encode("path", dataFlowName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/dataflows/{dataFlowName}/rename", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RenameDataFlowSender sends the RenameDataFlow request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowClient) RenameDataFlowSender(req *http.Request) (future DataFlowRenameDataFlowFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client DataFlowClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "artifacts.DataFlowRenameDataFlowFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("artifacts.DataFlowRenameDataFlowFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// RenameDataFlowResponder handles the response to the RenameDataFlow request. The method always
// closes the http.Response Body.
func (client DataFlowClient) RenameDataFlowResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
