package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ServerFarmsClient is the webSite Management Client
type ServerFarmsClient struct {
	BaseClient
}

// NewServerFarmsClient creates an instance of the ServerFarmsClient client.
func NewServerFarmsClient(subscriptionID string) ServerFarmsClient {
	return NewServerFarmsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewServerFarmsClientWithBaseURI creates an instance of the ServerFarmsClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewServerFarmsClientWithBaseURI(baseURI string, subscriptionID string) ServerFarmsClient {
	return ServerFarmsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateServerFarm sends the create or update server farm request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// serverFarmEnvelope - details of App Service Plan
// allowPendingState - oBSOLETE: If true, allow pending state for App Service Plan
func (client ServerFarmsClient) CreateOrUpdateServerFarm(ctx context.Context, resourceGroupName string, name string, serverFarmEnvelope ServerFarmWithRichSku, allowPendingState *bool) (result ServerFarmsCreateOrUpdateServerFarmFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.CreateOrUpdateServerFarm")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateServerFarmPreparer(ctx, resourceGroupName, name, serverFarmEnvelope, allowPendingState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateServerFarm", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateServerFarmSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateServerFarm", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateServerFarmPreparer prepares the CreateOrUpdateServerFarm request.
func (client ServerFarmsClient) CreateOrUpdateServerFarmPreparer(ctx context.Context, resourceGroupName string, name string, serverFarmEnvelope ServerFarmWithRichSku, allowPendingState *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if allowPendingState != nil {
		queryParameters["allowPendingState"] = autorest.Encode("query", *allowPendingState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithJSON(serverFarmEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateServerFarmSender sends the CreateOrUpdateServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) CreateOrUpdateServerFarmSender(req *http.Request) (future ServerFarmsCreateOrUpdateServerFarmFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client ServerFarmsClient) (sfwrs ServerFarmWithRichSku, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.ServerFarmsCreateOrUpdateServerFarmFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.ServerFarmsCreateOrUpdateServerFarmFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		sfwrs.Response.Response, err = future.GetResult(sender)
		if sfwrs.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.ServerFarmsCreateOrUpdateServerFarmFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && sfwrs.Response.Response.StatusCode != http.StatusNoContent {
			sfwrs, err = client.CreateOrUpdateServerFarmResponder(sfwrs.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.ServerFarmsCreateOrUpdateServerFarmFuture", "Result", sfwrs.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateServerFarmResponder handles the response to the CreateOrUpdateServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) CreateOrUpdateServerFarmResponder(resp *http.Response) (result ServerFarmWithRichSku, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetRoute sends the create or update vnet route request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// vnetName - name of virtual network
// routeName - name of the virtual network route
// route - the route object
func (client ServerFarmsClient) CreateOrUpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.CreateOrUpdateVnetRoute")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateVnetRoutePreparer(ctx, resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateVnetRoute", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateVnetRoutePreparer prepares the CreateOrUpdateVnetRoute request.
func (client ServerFarmsClient) CreateOrUpdateVnetRoutePreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithJSON(route),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateVnetRouteSender sends the CreateOrUpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) CreateOrUpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetRouteResponder handles the response to the CreateOrUpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) CreateOrUpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteServerFarm sends the delete server farm request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
func (client ServerFarmsClient) DeleteServerFarm(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.DeleteServerFarm")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteServerFarmPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteServerFarm", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteServerFarmPreparer prepares the DeleteServerFarm request.
func (client ServerFarmsClient) DeleteServerFarmPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteServerFarmSender sends the DeleteServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) DeleteServerFarmSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteServerFarmResponder handles the response to the DeleteServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) DeleteServerFarmResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteVnetRoute sends the delete vnet route request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// vnetName - name of virtual network
// routeName - name of the virtual network route
func (client ServerFarmsClient) DeleteVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.DeleteVnetRoute")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteVnetRoutePreparer(ctx, resourceGroupName, name, vnetName, routeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteVnetRoute", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteVnetRoutePreparer prepares the DeleteVnetRoute request.
func (client ServerFarmsClient) DeleteVnetRoutePreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteVnetRouteSender sends the DeleteVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) DeleteVnetRouteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteVnetRouteResponder handles the response to the DeleteVnetRoute request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) DeleteVnetRouteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRouteForVnet sends the get route for vnet request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// vnetName - name of virtual network
// routeName - name of the virtual network route
func (client ServerFarmsClient) GetRouteForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result ListVnetRoute, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetRouteForVnet")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRouteForVnetPreparer(ctx, resourceGroupName, name, vnetName, routeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRouteForVnet", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRouteForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRouteForVnet", resp, "Failure sending request")
		return
	}

	result, err = client.GetRouteForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRouteForVnet", resp, "Failure responding to request")
		return
	}

	return
}

// GetRouteForVnetPreparer prepares the GetRouteForVnet request.
func (client ServerFarmsClient) GetRouteForVnetPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRouteForVnetSender sends the GetRouteForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetRouteForVnetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetRouteForVnetResponder handles the response to the GetRouteForVnet request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetRouteForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRoutesForVnet sends the get routes for vnet request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// vnetName - name of virtual network
func (client ServerFarmsClient) GetRoutesForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string) (result ListVnetRoute, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetRoutesForVnet")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRoutesForVnetPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRoutesForVnet", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRoutesForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRoutesForVnet", resp, "Failure sending request")
		return
	}

	result, err = client.GetRoutesForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRoutesForVnet", resp, "Failure responding to request")
		return
	}

	return
}

// GetRoutesForVnetPreparer prepares the GetRoutesForVnet request.
func (client ServerFarmsClient) GetRoutesForVnetPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRoutesForVnetSender sends the GetRoutesForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetRoutesForVnetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetRoutesForVnetResponder handles the response to the GetRoutesForVnet request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetRoutesForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarm sends the get server farm request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
func (client ServerFarmsClient) GetServerFarm(ctx context.Context, resourceGroupName string, name string) (result ServerFarmWithRichSku, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarm")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetServerFarmPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.GetServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarm", resp, "Failure responding to request")
		return
	}

	return
}

// GetServerFarmPreparer prepares the GetServerFarm request.
func (client ServerFarmsClient) GetServerFarmPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmSender sends the GetServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmResponder handles the response to the GetServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmResponder(resp *http.Response) (result ServerFarmWithRichSku, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarmMetricDefintions sends the get server farm metric defintions request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
func (client ServerFarmsClient) GetServerFarmMetricDefintions(ctx context.Context, resourceGroupName string, name string) (result MetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmMetricDefintions")
		defer func() {
			sc := -1
			if result.mdc.Response.Response != nil {
				sc = result.mdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getServerFarmMetricDefintionsNextResults
	req, err := client.GetServerFarmMetricDefintionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetricDefintions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmMetricDefintionsSender(req)
	if err != nil {
		result.mdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetricDefintions", resp, "Failure sending request")
		return
	}

	result.mdc, err = client.GetServerFarmMetricDefintionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetricDefintions", resp, "Failure responding to request")
		return
	}
	if result.mdc.hasNextLink() && result.mdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetServerFarmMetricDefintionsPreparer prepares the GetServerFarmMetricDefintions request.
func (client ServerFarmsClient) GetServerFarmMetricDefintionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmMetricDefintionsSender sends the GetServerFarmMetricDefintions request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmMetricDefintionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmMetricDefintionsResponder handles the response to the GetServerFarmMetricDefintions request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmMetricDefintionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getServerFarmMetricDefintionsNextResults retrieves the next set of results, if any.
func (client ServerFarmsClient) getServerFarmMetricDefintionsNextResults(ctx context.Context, lastResults MetricDefinitionCollection) (result MetricDefinitionCollection, err error) {
	req, err := lastResults.metricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmMetricDefintionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetServerFarmMetricDefintionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmMetricDefintionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetServerFarmMetricDefintionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmMetricDefintionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetServerFarmMetricDefintionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServerFarmsClient) GetServerFarmMetricDefintionsComplete(ctx context.Context, resourceGroupName string, name string) (result MetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmMetricDefintions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetServerFarmMetricDefintions(ctx, resourceGroupName, name)
	return
}

// GetServerFarmMetrics sends the get server farm metrics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// details - if true, metrics are broken down per App Service Plan instance
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client ServerFarmsClient) GetServerFarmMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getServerFarmMetricsNextResults
	req, err := client.GetServerFarmMetricsPreparer(ctx, resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.GetServerFarmMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetrics", resp, "Failure responding to request")
		return
	}
	if result.rmc.hasNextLink() && result.rmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetServerFarmMetricsPreparer prepares the GetServerFarmMetrics request.
func (client ServerFarmsClient) GetServerFarmMetricsPreparer(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmMetricsSender sends the GetServerFarmMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmMetricsResponder handles the response to the GetServerFarmMetrics request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getServerFarmMetricsNextResults retrieves the next set of results, if any.
func (client ServerFarmsClient) getServerFarmMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetServerFarmMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetServerFarmMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetServerFarmMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServerFarmsClient) GetServerFarmMetricsComplete(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetServerFarmMetrics(ctx, resourceGroupName, name, details, filter)
	return
}

// GetServerFarmOperation sends the get server farm operation request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of server farm
// operationID - id of Server farm operation"&gt;
func (client ServerFarmsClient) GetServerFarmOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result ServerFarmWithRichSku, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmOperation")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetServerFarmOperationPreparer(ctx, resourceGroupName, name, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmOperation", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmOperationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmOperation", resp, "Failure sending request")
		return
	}

	result, err = client.GetServerFarmOperationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmOperation", resp, "Failure responding to request")
		return
	}

	return
}

// GetServerFarmOperationPreparer prepares the GetServerFarmOperation request.
func (client ServerFarmsClient) GetServerFarmOperationPreparer(ctx context.Context, resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmOperationSender sends the GetServerFarmOperation request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmOperationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmOperationResponder handles the response to the GetServerFarmOperation request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmOperationResponder(resp *http.Response) (result ServerFarmWithRichSku, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarms sends the get server farms request.
// Parameters:
// resourceGroupName - name of resource group
func (client ServerFarmsClient) GetServerFarms(ctx context.Context, resourceGroupName string) (result ServerFarmCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarms")
		defer func() {
			sc := -1
			if result.sfc.Response.Response != nil {
				sc = result.sfc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getServerFarmsNextResults
	req, err := client.GetServerFarmsPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarms", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmsSender(req)
	if err != nil {
		result.sfc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarms", resp, "Failure sending request")
		return
	}

	result.sfc, err = client.GetServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarms", resp, "Failure responding to request")
		return
	}
	if result.sfc.hasNextLink() && result.sfc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetServerFarmsPreparer prepares the GetServerFarms request.
func (client ServerFarmsClient) GetServerFarmsPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmsSender sends the GetServerFarms request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmsResponder handles the response to the GetServerFarms request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmsResponder(resp *http.Response) (result ServerFarmCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getServerFarmsNextResults retrieves the next set of results, if any.
func (client ServerFarmsClient) getServerFarmsNextResults(ctx context.Context, lastResults ServerFarmCollection) (result ServerFarmCollection, err error) {
	req, err := lastResults.serverFarmCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetServerFarmsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetServerFarmsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServerFarmsClient) GetServerFarmsComplete(ctx context.Context, resourceGroupName string) (result ServerFarmCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarms")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetServerFarms(ctx, resourceGroupName)
	return
}

// GetServerFarmSites sends the get server farm sites request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// skipToken - skip to of web apps in a list. If specified, the resulting list will contain web apps starting
// from (including) the skipToken. Else, the resulting list contains web apps from the start of the list
// filter - supported filter: $filter=state eq running. Returns only web apps that are currently running
// top - list page size. If specified, results are paged.
func (client ServerFarmsClient) GetServerFarmSites(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result SiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmSites")
		defer func() {
			sc := -1
			if result.sc.Response.Response != nil {
				sc = result.sc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getServerFarmSitesNextResults
	req, err := client.GetServerFarmSitesPreparer(ctx, resourceGroupName, name, skipToken, filter, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmSitesSender(req)
	if err != nil {
		result.sc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", resp, "Failure sending request")
		return
	}

	result.sc, err = client.GetServerFarmSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", resp, "Failure responding to request")
		return
	}
	if result.sc.hasNextLink() && result.sc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetServerFarmSitesPreparer prepares the GetServerFarmSites request.
func (client ServerFarmsClient) GetServerFarmSitesPreparer(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(top) > 0 {
		queryParameters["$top"] = autorest.Encode("query", top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmSitesSender sends the GetServerFarmSites request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmSitesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmSitesResponder handles the response to the GetServerFarmSites request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmSitesResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getServerFarmSitesNextResults retrieves the next set of results, if any.
func (client ServerFarmsClient) getServerFarmSitesNextResults(ctx context.Context, lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.siteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmSitesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetServerFarmSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmSitesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetServerFarmSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "getServerFarmSitesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetServerFarmSitesComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServerFarmsClient) GetServerFarmSitesComplete(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result SiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmSites")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetServerFarmSites(ctx, resourceGroupName, name, skipToken, filter, top)
	return
}

// GetServerFarmVnetGateway sends the get server farm vnet gateway request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of the App Service Plan
// vnetName - name of the virtual network
// gatewayName - name of the gateway. Only the 'primary' gateway is supported.
func (client ServerFarmsClient) GetServerFarmVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetServerFarmVnetGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetServerFarmVnetGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmVnetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmVnetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetServerFarmVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmVnetGateway", resp, "Failure responding to request")
		return
	}

	return
}

// GetServerFarmVnetGatewayPreparer prepares the GetServerFarmVnetGateway request.
func (client ServerFarmsClient) GetServerFarmVnetGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmVnetGatewaySender sends the GetServerFarmVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmVnetGatewayResponder handles the response to the GetServerFarmVnetGateway request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetFromServerFarm sends the get vnet from server farm request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// vnetName - name of virtual network
func (client ServerFarmsClient) GetVnetFromServerFarm(ctx context.Context, resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetVnetFromServerFarm")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetVnetFromServerFarmPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetFromServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetFromServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetFromServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetFromServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetFromServerFarm", resp, "Failure responding to request")
		return
	}

	return
}

// GetVnetFromServerFarmPreparer prepares the GetVnetFromServerFarm request.
func (client ServerFarmsClient) GetVnetFromServerFarmPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetFromServerFarmSender sends the GetVnetFromServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetVnetFromServerFarmSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVnetFromServerFarmResponder handles the response to the GetVnetFromServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetVnetFromServerFarmResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetsForServerFarm sends the get vnets for server farm request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
func (client ServerFarmsClient) GetVnetsForServerFarm(ctx context.Context, resourceGroupName string, name string) (result ListVnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.GetVnetsForServerFarm")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetVnetsForServerFarmPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetsForServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetsForServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetsForServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetsForServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetsForServerFarm", resp, "Failure responding to request")
		return
	}

	return
}

// GetVnetsForServerFarmPreparer prepares the GetVnetsForServerFarm request.
func (client ServerFarmsClient) GetVnetsForServerFarmPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetsForServerFarmSender sends the GetVnetsForServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetVnetsForServerFarmSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVnetsForServerFarmResponder handles the response to the GetVnetsForServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetVnetsForServerFarmResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RebootWorkerForServerFarm sends the reboot worker for server farm request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of server farm
// workerName - name of worker machine, typically starts with RD
func (client ServerFarmsClient) RebootWorkerForServerFarm(ctx context.Context, resourceGroupName string, name string, workerName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.RebootWorkerForServerFarm")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RebootWorkerForServerFarmPreparer(ctx, resourceGroupName, name, workerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RebootWorkerForServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.RebootWorkerForServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RebootWorkerForServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.RebootWorkerForServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RebootWorkerForServerFarm", resp, "Failure responding to request")
		return
	}

	return
}

// RebootWorkerForServerFarmPreparer prepares the RebootWorkerForServerFarm request.
func (client ServerFarmsClient) RebootWorkerForServerFarmPreparer(ctx context.Context, resourceGroupName string, name string, workerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerName":        autorest.Encode("path", workerName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RebootWorkerForServerFarmSender sends the RebootWorkerForServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) RebootWorkerForServerFarmSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RebootWorkerForServerFarmResponder handles the response to the RebootWorkerForServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) RebootWorkerForServerFarmResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestartSitesForServerFarm sends the restart sites for server farm request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// softRestart - soft restart applies the configuration settings and restarts the apps if necessary. Hard
// restart always restarts and reprovisions the apps
func (client ServerFarmsClient) RestartSitesForServerFarm(ctx context.Context, resourceGroupName string, name string, softRestart *bool) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.RestartSitesForServerFarm")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RestartSitesForServerFarmPreparer(ctx, resourceGroupName, name, softRestart)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RestartSitesForServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartSitesForServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RestartSitesForServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.RestartSitesForServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RestartSitesForServerFarm", resp, "Failure responding to request")
		return
	}

	return
}

// RestartSitesForServerFarmPreparer prepares the RestartSitesForServerFarm request.
func (client ServerFarmsClient) RestartSitesForServerFarmPreparer(ctx context.Context, resourceGroupName string, name string, softRestart *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RestartSitesForServerFarmSender sends the RestartSitesForServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) RestartSitesForServerFarmSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RestartSitesForServerFarmResponder handles the response to the RestartSitesForServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) RestartSitesForServerFarmResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateServerFarmVnetGateway sends the update server farm vnet gateway request.
// Parameters:
// resourceGroupName - the resource group
// name - the name of the App Service Plan
// vnetName - the name of the virtual network
// gatewayName - the name of the gateway. Only 'primary' is supported.
// connectionEnvelope - the gateway entity.
func (client ServerFarmsClient) UpdateServerFarmVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.UpdateServerFarmVnetGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateServerFarmVnetGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateServerFarmVnetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateServerFarmVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateServerFarmVnetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateServerFarmVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateServerFarmVnetGateway", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateServerFarmVnetGatewayPreparer prepares the UpdateServerFarmVnetGateway request.
func (client ServerFarmsClient) UpdateServerFarmVnetGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateServerFarmVnetGatewaySender sends the UpdateServerFarmVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) UpdateServerFarmVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateServerFarmVnetGatewayResponder handles the response to the UpdateServerFarmVnetGateway request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) UpdateServerFarmVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetRoute sends the update vnet route request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of App Service Plan
// vnetName - name of virtual network
// routeName - name of the virtual network route
// route - the route object
func (client ServerFarmsClient) UpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerFarmsClient.UpdateVnetRoute")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateVnetRoutePreparer(ctx, resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateVnetRoute", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateVnetRoutePreparer prepares the UpdateVnetRoute request.
func (client ServerFarmsClient) UpdateVnetRoutePreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithJSON(route),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateVnetRouteSender sends the UpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) UpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateVnetRouteResponder handles the response to the UpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) UpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
