// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetNamedQuery = "BatchGetNamedQuery"

// BatchGetNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetNamedQuery for more information on using the BatchGetNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetNamedQueryRequest method.
//    req, resp := client.BatchGetNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery
func (c *Athena) BatchGetNamedQueryRequest(input *BatchGetNamedQueryInput) (req *request.Request, output *BatchGetNamedQueryOutput) {
	op := &request.Operation{
		Name:       opBatchGetNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetNamedQueryInput{}
	}

	output = &BatchGetNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetNamedQuery API operation for Amazon Athena.
//
// Returns the details of a single named query or a list of up to 50 queries,
// which you provide as an array of query ID strings. Requires you to have access
// to the workgroup in which the queries were saved. Use ListNamedQueriesInput
// to get the list of named query IDs in the specified workgroup. If information
// could not be retrieved for a submitted query ID, information about the query
// ID submitted is listed under UnprocessedNamedQueryId. Named queries differ
// from executed queries. Use BatchGetQueryExecutionInput to get details about
// each unique query execution, and ListQueryExecutionsInput to get a list of
// query execution IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation BatchGetNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery
func (c *Athena) BatchGetNamedQuery(input *BatchGetNamedQueryInput) (*BatchGetNamedQueryOutput, error) {
	req, out := c.BatchGetNamedQueryRequest(input)
	return out, req.Send()
}

// BatchGetNamedQueryWithContext is the same as BatchGetNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) BatchGetNamedQueryWithContext(ctx aws.Context, input *BatchGetNamedQueryInput, opts ...request.Option) (*BatchGetNamedQueryOutput, error) {
	req, out := c.BatchGetNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetQueryExecution = "BatchGetQueryExecution"

// BatchGetQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetQueryExecution for more information on using the BatchGetQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetQueryExecutionRequest method.
//    req, resp := client.BatchGetQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution
func (c *Athena) BatchGetQueryExecutionRequest(input *BatchGetQueryExecutionInput) (req *request.Request, output *BatchGetQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opBatchGetQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetQueryExecutionInput{}
	}

	output = &BatchGetQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetQueryExecution API operation for Amazon Athena.
//
// Returns the details of a single query execution or a list of up to 50 query
// executions, which you provide as an array of query execution ID strings.
// Requires you to have access to the workgroup in which the queries ran. To
// get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup.
// Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput
// to get details about named queries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation BatchGetQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution
func (c *Athena) BatchGetQueryExecution(input *BatchGetQueryExecutionInput) (*BatchGetQueryExecutionOutput, error) {
	req, out := c.BatchGetQueryExecutionRequest(input)
	return out, req.Send()
}

// BatchGetQueryExecutionWithContext is the same as BatchGetQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) BatchGetQueryExecutionWithContext(ctx aws.Context, input *BatchGetQueryExecutionInput, opts ...request.Option) (*BatchGetQueryExecutionOutput, error) {
	req, out := c.BatchGetQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataCatalog = "CreateDataCatalog"

// CreateDataCatalogRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataCatalog for more information on using the CreateDataCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataCatalogRequest method.
//    req, resp := client.CreateDataCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateDataCatalog
func (c *Athena) CreateDataCatalogRequest(input *CreateDataCatalogInput) (req *request.Request, output *CreateDataCatalogOutput) {
	op := &request.Operation{
		Name:       opCreateDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataCatalogInput{}
	}

	output = &CreateDataCatalogOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDataCatalog API operation for Amazon Athena.
//
// Creates (registers) a data catalog with the specified name and properties.
// Catalogs created are visible to all users of the same AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation CreateDataCatalog for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateDataCatalog
func (c *Athena) CreateDataCatalog(input *CreateDataCatalogInput) (*CreateDataCatalogOutput, error) {
	req, out := c.CreateDataCatalogRequest(input)
	return out, req.Send()
}

// CreateDataCatalogWithContext is the same as CreateDataCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) CreateDataCatalogWithContext(ctx aws.Context, input *CreateDataCatalogInput, opts ...request.Option) (*CreateDataCatalogOutput, error) {
	req, out := c.CreateDataCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNamedQuery = "CreateNamedQuery"

// CreateNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the CreateNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNamedQuery for more information on using the CreateNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNamedQueryRequest method.
//    req, resp := client.CreateNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery
func (c *Athena) CreateNamedQueryRequest(input *CreateNamedQueryInput) (req *request.Request, output *CreateNamedQueryOutput) {
	op := &request.Operation{
		Name:       opCreateNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNamedQueryInput{}
	}

	output = &CreateNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNamedQuery API operation for Amazon Athena.
//
// Creates a named query in the specified workgroup. Requires that you have
// access to the workgroup.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation CreateNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery
func (c *Athena) CreateNamedQuery(input *CreateNamedQueryInput) (*CreateNamedQueryOutput, error) {
	req, out := c.CreateNamedQueryRequest(input)
	return out, req.Send()
}

// CreateNamedQueryWithContext is the same as CreateNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) CreateNamedQueryWithContext(ctx aws.Context, input *CreateNamedQueryInput, opts ...request.Option) (*CreateNamedQueryOutput, error) {
	req, out := c.CreateNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkGroup = "CreateWorkGroup"

// CreateWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkGroup for more information on using the CreateWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkGroupRequest method.
//    req, resp := client.CreateWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup
func (c *Athena) CreateWorkGroupRequest(input *CreateWorkGroupInput) (req *request.Request, output *CreateWorkGroupOutput) {
	op := &request.Operation{
		Name:       opCreateWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkGroupInput{}
	}

	output = &CreateWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateWorkGroup API operation for Amazon Athena.
//
// Creates a workgroup with the specified name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation CreateWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup
func (c *Athena) CreateWorkGroup(input *CreateWorkGroupInput) (*CreateWorkGroupOutput, error) {
	req, out := c.CreateWorkGroupRequest(input)
	return out, req.Send()
}

// CreateWorkGroupWithContext is the same as CreateWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) CreateWorkGroupWithContext(ctx aws.Context, input *CreateWorkGroupInput, opts ...request.Option) (*CreateWorkGroupOutput, error) {
	req, out := c.CreateWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataCatalog = "DeleteDataCatalog"

// DeleteDataCatalogRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataCatalog for more information on using the DeleteDataCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataCatalogRequest method.
//    req, resp := client.DeleteDataCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteDataCatalog
func (c *Athena) DeleteDataCatalogRequest(input *DeleteDataCatalogInput) (req *request.Request, output *DeleteDataCatalogOutput) {
	op := &request.Operation{
		Name:       opDeleteDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDataCatalogInput{}
	}

	output = &DeleteDataCatalogOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataCatalog API operation for Amazon Athena.
//
// Deletes a data catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation DeleteDataCatalog for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteDataCatalog
func (c *Athena) DeleteDataCatalog(input *DeleteDataCatalogInput) (*DeleteDataCatalogOutput, error) {
	req, out := c.DeleteDataCatalogRequest(input)
	return out, req.Send()
}

// DeleteDataCatalogWithContext is the same as DeleteDataCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) DeleteDataCatalogWithContext(ctx aws.Context, input *DeleteDataCatalogInput, opts ...request.Option) (*DeleteDataCatalogOutput, error) {
	req, out := c.DeleteDataCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamedQuery = "DeleteNamedQuery"

// DeleteNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamedQuery for more information on using the DeleteNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNamedQueryRequest method.
//    req, resp := client.DeleteNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery
func (c *Athena) DeleteNamedQueryRequest(input *DeleteNamedQueryInput) (req *request.Request, output *DeleteNamedQueryOutput) {
	op := &request.Operation{
		Name:       opDeleteNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamedQueryInput{}
	}

	output = &DeleteNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNamedQuery API operation for Amazon Athena.
//
// Deletes the named query if you have access to the workgroup in which the
// query was saved.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation DeleteNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery
func (c *Athena) DeleteNamedQuery(input *DeleteNamedQueryInput) (*DeleteNamedQueryOutput, error) {
	req, out := c.DeleteNamedQueryRequest(input)
	return out, req.Send()
}

// DeleteNamedQueryWithContext is the same as DeleteNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) DeleteNamedQueryWithContext(ctx aws.Context, input *DeleteNamedQueryInput, opts ...request.Option) (*DeleteNamedQueryOutput, error) {
	req, out := c.DeleteNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkGroup = "DeleteWorkGroup"

// DeleteWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkGroup for more information on using the DeleteWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkGroupRequest method.
//    req, resp := client.DeleteWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup
func (c *Athena) DeleteWorkGroupRequest(input *DeleteWorkGroupInput) (req *request.Request, output *DeleteWorkGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkGroupInput{}
	}

	output = &DeleteWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkGroup API operation for Amazon Athena.
//
// Deletes the workgroup with the specified name. The primary workgroup cannot
// be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation DeleteWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup
func (c *Athena) DeleteWorkGroup(input *DeleteWorkGroupInput) (*DeleteWorkGroupOutput, error) {
	req, out := c.DeleteWorkGroupRequest(input)
	return out, req.Send()
}

// DeleteWorkGroupWithContext is the same as DeleteWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) DeleteWorkGroupWithContext(ctx aws.Context, input *DeleteWorkGroupInput, opts ...request.Option) (*DeleteWorkGroupOutput, error) {
	req, out := c.DeleteWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataCatalog = "GetDataCatalog"

// GetDataCatalogRequest generates a "aws/request.Request" representing the
// client's request for the GetDataCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataCatalog for more information on using the GetDataCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataCatalogRequest method.
//    req, resp := client.GetDataCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDataCatalog
func (c *Athena) GetDataCatalogRequest(input *GetDataCatalogInput) (req *request.Request, output *GetDataCatalogOutput) {
	op := &request.Operation{
		Name:       opGetDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataCatalogInput{}
	}

	output = &GetDataCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataCatalog API operation for Amazon Athena.
//
// Returns the specified data catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetDataCatalog for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDataCatalog
func (c *Athena) GetDataCatalog(input *GetDataCatalogInput) (*GetDataCatalogOutput, error) {
	req, out := c.GetDataCatalogRequest(input)
	return out, req.Send()
}

// GetDataCatalogWithContext is the same as GetDataCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetDataCatalogWithContext(ctx aws.Context, input *GetDataCatalogInput, opts ...request.Option) (*GetDataCatalogOutput, error) {
	req, out := c.GetDataCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatabase = "GetDatabase"

// GetDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the GetDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatabase for more information on using the GetDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDatabaseRequest method.
//    req, resp := client.GetDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDatabase
func (c *Athena) GetDatabaseRequest(input *GetDatabaseInput) (req *request.Request, output *GetDatabaseOutput) {
	op := &request.Operation{
		Name:       opGetDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDatabaseInput{}
	}

	output = &GetDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatabase API operation for Amazon Athena.
//
// Returns a database object for the specified database and data catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetDatabase for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * MetadataException
//   An exception that Athena received when it called a custom metastore. Occurs
//   if the error is not caused by user input (InvalidRequestException) or from
//   the Athena platform (InternalServerException). For example, if a user-created
//   Lambda function is missing permissions, the Lambda 4XX exception is returned
//   in a MetadataException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDatabase
func (c *Athena) GetDatabase(input *GetDatabaseInput) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	return out, req.Send()
}

// GetDatabaseWithContext is the same as GetDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetDatabaseWithContext(ctx aws.Context, input *GetDatabaseInput, opts ...request.Option) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNamedQuery = "GetNamedQuery"

// GetNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNamedQuery for more information on using the GetNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNamedQueryRequest method.
//    req, resp := client.GetNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery
func (c *Athena) GetNamedQueryRequest(input *GetNamedQueryInput) (req *request.Request, output *GetNamedQueryOutput) {
	op := &request.Operation{
		Name:       opGetNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamedQueryInput{}
	}

	output = &GetNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNamedQuery API operation for Amazon Athena.
//
// Returns information about a single query. Requires that you have access to
// the workgroup in which the query was saved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery
func (c *Athena) GetNamedQuery(input *GetNamedQueryInput) (*GetNamedQueryOutput, error) {
	req, out := c.GetNamedQueryRequest(input)
	return out, req.Send()
}

// GetNamedQueryWithContext is the same as GetNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetNamedQueryWithContext(ctx aws.Context, input *GetNamedQueryInput, opts ...request.Option) (*GetNamedQueryOutput, error) {
	req, out := c.GetNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryExecution = "GetQueryExecution"

// GetQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryExecution for more information on using the GetQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQueryExecutionRequest method.
//    req, resp := client.GetQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution
func (c *Athena) GetQueryExecutionRequest(input *GetQueryExecutionInput) (req *request.Request, output *GetQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opGetQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQueryExecutionInput{}
	}

	output = &GetQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQueryExecution API operation for Amazon Athena.
//
// Returns information about a single execution of a query if you have access
// to the workgroup in which the query ran. Each time a query executes, information
// about the query execution is saved with a unique ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution
func (c *Athena) GetQueryExecution(input *GetQueryExecutionInput) (*GetQueryExecutionOutput, error) {
	req, out := c.GetQueryExecutionRequest(input)
	return out, req.Send()
}

// GetQueryExecutionWithContext is the same as GetQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryExecutionWithContext(ctx aws.Context, input *GetQueryExecutionInput, opts ...request.Option) (*GetQueryExecutionOutput, error) {
	req, out := c.GetQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryResults = "GetQueryResults"

// GetQueryResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryResults for more information on using the GetQueryResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQueryResultsRequest method.
//    req, resp := client.GetQueryResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults
func (c *Athena) GetQueryResultsRequest(input *GetQueryResultsInput) (req *request.Request, output *GetQueryResultsOutput) {
	op := &request.Operation{
		Name:       opGetQueryResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetQueryResultsInput{}
	}

	output = &GetQueryResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQueryResults API operation for Amazon Athena.
//
// Streams the results of a single query execution specified by QueryExecutionId
// from the Athena query results location in Amazon S3. For more information,
// see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html)
// in the Amazon Athena User Guide. This request does not execute the query
// but returns results. Use StartQueryExecution to run a query.
//
// To stream query results successfully, the IAM principal with permission to
// call GetQueryResults also must have permissions to the Amazon S3 GetObject
// action for the Athena query results location.
//
// IAM principals with permission to the Amazon S3 GetObject action for the
// query results location are able to retrieve query results from Amazon S3
// even if permission to the GetQueryResults action is denied. To restrict user
// or role access, ensure that Amazon S3 permissions to the Athena query location
// are denied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetQueryResults for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults
func (c *Athena) GetQueryResults(input *GetQueryResultsInput) (*GetQueryResultsOutput, error) {
	req, out := c.GetQueryResultsRequest(input)
	return out, req.Send()
}

// GetQueryResultsWithContext is the same as GetQueryResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryResultsWithContext(ctx aws.Context, input *GetQueryResultsInput, opts ...request.Option) (*GetQueryResultsOutput, error) {
	req, out := c.GetQueryResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetQueryResultsPages iterates over the pages of a GetQueryResults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetQueryResults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetQueryResults operation.
//    pageNum := 0
//    err := client.GetQueryResultsPages(params,
//        func(page *athena.GetQueryResultsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) GetQueryResultsPages(input *GetQueryResultsInput, fn func(*GetQueryResultsOutput, bool) bool) error {
	return c.GetQueryResultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetQueryResultsPagesWithContext same as GetQueryResultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryResultsPagesWithContext(ctx aws.Context, input *GetQueryResultsInput, fn func(*GetQueryResultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetQueryResultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetQueryResultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetQueryResultsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTableMetadata = "GetTableMetadata"

// GetTableMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetTableMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTableMetadata for more information on using the GetTableMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTableMetadataRequest method.
//    req, resp := client.GetTableMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetTableMetadata
func (c *Athena) GetTableMetadataRequest(input *GetTableMetadataInput) (req *request.Request, output *GetTableMetadataOutput) {
	op := &request.Operation{
		Name:       opGetTableMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableMetadataInput{}
	}

	output = &GetTableMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTableMetadata API operation for Amazon Athena.
//
// Returns table metadata for the specified catalog, database, and table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetTableMetadata for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * MetadataException
//   An exception that Athena received when it called a custom metastore. Occurs
//   if the error is not caused by user input (InvalidRequestException) or from
//   the Athena platform (InternalServerException). For example, if a user-created
//   Lambda function is missing permissions, the Lambda 4XX exception is returned
//   in a MetadataException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetTableMetadata
func (c *Athena) GetTableMetadata(input *GetTableMetadataInput) (*GetTableMetadataOutput, error) {
	req, out := c.GetTableMetadataRequest(input)
	return out, req.Send()
}

// GetTableMetadataWithContext is the same as GetTableMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetTableMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetTableMetadataWithContext(ctx aws.Context, input *GetTableMetadataInput, opts ...request.Option) (*GetTableMetadataOutput, error) {
	req, out := c.GetTableMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkGroup = "GetWorkGroup"

// GetWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkGroup for more information on using the GetWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkGroupRequest method.
//    req, resp := client.GetWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup
func (c *Athena) GetWorkGroupRequest(input *GetWorkGroupInput) (req *request.Request, output *GetWorkGroupOutput) {
	op := &request.Operation{
		Name:       opGetWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWorkGroupInput{}
	}

	output = &GetWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkGroup API operation for Amazon Athena.
//
// Returns information about the workgroup with the specified name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup
func (c *Athena) GetWorkGroup(input *GetWorkGroupInput) (*GetWorkGroupOutput, error) {
	req, out := c.GetWorkGroupRequest(input)
	return out, req.Send()
}

// GetWorkGroupWithContext is the same as GetWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetWorkGroupWithContext(ctx aws.Context, input *GetWorkGroupInput, opts ...request.Option) (*GetWorkGroupOutput, error) {
	req, out := c.GetWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataCatalogs = "ListDataCatalogs"

// ListDataCatalogsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataCatalogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataCatalogs for more information on using the ListDataCatalogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataCatalogsRequest method.
//    req, resp := client.ListDataCatalogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs
func (c *Athena) ListDataCatalogsRequest(input *ListDataCatalogsInput) (req *request.Request, output *ListDataCatalogsOutput) {
	op := &request.Operation{
		Name:       opListDataCatalogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataCatalogsInput{}
	}

	output = &ListDataCatalogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataCatalogs API operation for Amazon Athena.
//
// Lists the data catalogs in the current AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListDataCatalogs for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs
func (c *Athena) ListDataCatalogs(input *ListDataCatalogsInput) (*ListDataCatalogsOutput, error) {
	req, out := c.ListDataCatalogsRequest(input)
	return out, req.Send()
}

// ListDataCatalogsWithContext is the same as ListDataCatalogs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataCatalogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListDataCatalogsWithContext(ctx aws.Context, input *ListDataCatalogsInput, opts ...request.Option) (*ListDataCatalogsOutput, error) {
	req, out := c.ListDataCatalogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataCatalogsPages iterates over the pages of a ListDataCatalogs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataCatalogs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataCatalogs operation.
//    pageNum := 0
//    err := client.ListDataCatalogsPages(params,
//        func(page *athena.ListDataCatalogsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListDataCatalogsPages(input *ListDataCatalogsInput, fn func(*ListDataCatalogsOutput, bool) bool) error {
	return c.ListDataCatalogsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataCatalogsPagesWithContext same as ListDataCatalogsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListDataCatalogsPagesWithContext(ctx aws.Context, input *ListDataCatalogsInput, fn func(*ListDataCatalogsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataCatalogsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataCatalogsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataCatalogsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatabases = "ListDatabases"

// ListDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatabases for more information on using the ListDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatabasesRequest method.
//    req, resp := client.ListDatabasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases
func (c *Athena) ListDatabasesRequest(input *ListDatabasesInput) (req *request.Request, output *ListDatabasesOutput) {
	op := &request.Operation{
		Name:       opListDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatabasesInput{}
	}

	output = &ListDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatabases API operation for Amazon Athena.
//
// Lists the databases in the specified data catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListDatabases for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * MetadataException
//   An exception that Athena received when it called a custom metastore. Occurs
//   if the error is not caused by user input (InvalidRequestException) or from
//   the Athena platform (InternalServerException). For example, if a user-created
//   Lambda function is missing permissions, the Lambda 4XX exception is returned
//   in a MetadataException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases
func (c *Athena) ListDatabases(input *ListDatabasesInput) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	return out, req.Send()
}

// ListDatabasesWithContext is the same as ListDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListDatabasesWithContext(ctx aws.Context, input *ListDatabasesInput, opts ...request.Option) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatabasesPages iterates over the pages of a ListDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatabases operation.
//    pageNum := 0
//    err := client.ListDatabasesPages(params,
//        func(page *athena.ListDatabasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListDatabasesPages(input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool) error {
	return c.ListDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatabasesPagesWithContext same as ListDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListDatabasesPagesWithContext(ctx aws.Context, input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEngineVersions = "ListEngineVersions"

// ListEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEngineVersions for more information on using the ListEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEngineVersionsRequest method.
//    req, resp := client.ListEngineVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions
func (c *Athena) ListEngineVersionsRequest(input *ListEngineVersionsInput) (req *request.Request, output *ListEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opListEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEngineVersionsInput{}
	}

	output = &ListEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEngineVersions API operation for Amazon Athena.
//
// Returns a list of engine versions that are available to choose from, including
// the Auto option.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListEngineVersions for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions
func (c *Athena) ListEngineVersions(input *ListEngineVersionsInput) (*ListEngineVersionsOutput, error) {
	req, out := c.ListEngineVersionsRequest(input)
	return out, req.Send()
}

// ListEngineVersionsWithContext is the same as ListEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListEngineVersionsWithContext(ctx aws.Context, input *ListEngineVersionsInput, opts ...request.Option) (*ListEngineVersionsOutput, error) {
	req, out := c.ListEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNamedQueries = "ListNamedQueries"

// ListNamedQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamedQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamedQueries for more information on using the ListNamedQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNamedQueriesRequest method.
//    req, resp := client.ListNamedQueriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries
func (c *Athena) ListNamedQueriesRequest(input *ListNamedQueriesInput) (req *request.Request, output *ListNamedQueriesOutput) {
	op := &request.Operation{
		Name:       opListNamedQueries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamedQueriesInput{}
	}

	output = &ListNamedQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamedQueries API operation for Amazon Athena.
//
// Provides a list of available query IDs only for queries saved in the specified
// workgroup. Requires that you have access to the specified workgroup. If a
// workgroup is not specified, lists the saved queries for the primary workgroup.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListNamedQueries for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries
func (c *Athena) ListNamedQueries(input *ListNamedQueriesInput) (*ListNamedQueriesOutput, error) {
	req, out := c.ListNamedQueriesRequest(input)
	return out, req.Send()
}

// ListNamedQueriesWithContext is the same as ListNamedQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamedQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListNamedQueriesWithContext(ctx aws.Context, input *ListNamedQueriesInput, opts ...request.Option) (*ListNamedQueriesOutput, error) {
	req, out := c.ListNamedQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamedQueriesPages iterates over the pages of a ListNamedQueries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamedQueries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNamedQueries operation.
//    pageNum := 0
//    err := client.ListNamedQueriesPages(params,
//        func(page *athena.ListNamedQueriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListNamedQueriesPages(input *ListNamedQueriesInput, fn func(*ListNamedQueriesOutput, bool) bool) error {
	return c.ListNamedQueriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamedQueriesPagesWithContext same as ListNamedQueriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListNamedQueriesPagesWithContext(ctx aws.Context, input *ListNamedQueriesInput, fn func(*ListNamedQueriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamedQueriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamedQueriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNamedQueriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueryExecutions = "ListQueryExecutions"

// ListQueryExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListQueryExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueryExecutions for more information on using the ListQueryExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQueryExecutionsRequest method.
//    req, resp := client.ListQueryExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions
func (c *Athena) ListQueryExecutionsRequest(input *ListQueryExecutionsInput) (req *request.Request, output *ListQueryExecutionsOutput) {
	op := &request.Operation{
		Name:       opListQueryExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueryExecutionsInput{}
	}

	output = &ListQueryExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQueryExecutions API operation for Amazon Athena.
//
// Provides a list of available query execution IDs for the queries in the specified
// workgroup. If a workgroup is not specified, returns a list of query execution
// IDs for the primary workgroup. Requires you to have access to the workgroup
// in which the queries ran.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListQueryExecutions for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions
func (c *Athena) ListQueryExecutions(input *ListQueryExecutionsInput) (*ListQueryExecutionsOutput, error) {
	req, out := c.ListQueryExecutionsRequest(input)
	return out, req.Send()
}

// ListQueryExecutionsWithContext is the same as ListQueryExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueryExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListQueryExecutionsWithContext(ctx aws.Context, input *ListQueryExecutionsInput, opts ...request.Option) (*ListQueryExecutionsOutput, error) {
	req, out := c.ListQueryExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueryExecutionsPages iterates over the pages of a ListQueryExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueryExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListQueryExecutions operation.
//    pageNum := 0
//    err := client.ListQueryExecutionsPages(params,
//        func(page *athena.ListQueryExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListQueryExecutionsPages(input *ListQueryExecutionsInput, fn func(*ListQueryExecutionsOutput, bool) bool) error {
	return c.ListQueryExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueryExecutionsPagesWithContext same as ListQueryExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListQueryExecutionsPagesWithContext(ctx aws.Context, input *ListQueryExecutionsInput, fn func(*ListQueryExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueryExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueryExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueryExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTableMetadata = "ListTableMetadata"

// ListTableMetadataRequest generates a "aws/request.Request" representing the
// client's request for the ListTableMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTableMetadata for more information on using the ListTableMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTableMetadataRequest method.
//    req, resp := client.ListTableMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata
func (c *Athena) ListTableMetadataRequest(input *ListTableMetadataInput) (req *request.Request, output *ListTableMetadataOutput) {
	op := &request.Operation{
		Name:       opListTableMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTableMetadataInput{}
	}

	output = &ListTableMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTableMetadata API operation for Amazon Athena.
//
// Lists the metadata for the tables in the specified data catalog database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListTableMetadata for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * MetadataException
//   An exception that Athena received when it called a custom metastore. Occurs
//   if the error is not caused by user input (InvalidRequestException) or from
//   the Athena platform (InternalServerException). For example, if a user-created
//   Lambda function is missing permissions, the Lambda 4XX exception is returned
//   in a MetadataException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata
func (c *Athena) ListTableMetadata(input *ListTableMetadataInput) (*ListTableMetadataOutput, error) {
	req, out := c.ListTableMetadataRequest(input)
	return out, req.Send()
}

// ListTableMetadataWithContext is the same as ListTableMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See ListTableMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListTableMetadataWithContext(ctx aws.Context, input *ListTableMetadataInput, opts ...request.Option) (*ListTableMetadataOutput, error) {
	req, out := c.ListTableMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTableMetadataPages iterates over the pages of a ListTableMetadata operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTableMetadata method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTableMetadata operation.
//    pageNum := 0
//    err := client.ListTableMetadataPages(params,
//        func(page *athena.ListTableMetadataOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListTableMetadataPages(input *ListTableMetadataInput, fn func(*ListTableMetadataOutput, bool) bool) error {
	return c.ListTableMetadataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTableMetadataPagesWithContext same as ListTableMetadataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListTableMetadataPagesWithContext(ctx aws.Context, input *ListTableMetadataInput, fn func(*ListTableMetadataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTableMetadataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTableMetadataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTableMetadataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource
func (c *Athena) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Athena.
//
// Lists the tags associated with an Athena workgroup or data catalog resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * ResourceNotFoundException
//   A resource, such as a workgroup, was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource
func (c *Athena) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *athena.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkGroups = "ListWorkGroups"

// ListWorkGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkGroups for more information on using the ListWorkGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkGroupsRequest method.
//    req, resp := client.ListWorkGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups
func (c *Athena) ListWorkGroupsRequest(input *ListWorkGroupsInput) (req *request.Request, output *ListWorkGroupsOutput) {
	op := &request.Operation{
		Name:       opListWorkGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkGroupsInput{}
	}

	output = &ListWorkGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkGroups API operation for Amazon Athena.
//
// Lists available workgroups for the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListWorkGroups for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups
func (c *Athena) ListWorkGroups(input *ListWorkGroupsInput) (*ListWorkGroupsOutput, error) {
	req, out := c.ListWorkGroupsRequest(input)
	return out, req.Send()
}

// ListWorkGroupsWithContext is the same as ListWorkGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListWorkGroupsWithContext(ctx aws.Context, input *ListWorkGroupsInput, opts ...request.Option) (*ListWorkGroupsOutput, error) {
	req, out := c.ListWorkGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkGroupsPages iterates over the pages of a ListWorkGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkGroups operation.
//    pageNum := 0
//    err := client.ListWorkGroupsPages(params,
//        func(page *athena.ListWorkGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListWorkGroupsPages(input *ListWorkGroupsInput, fn func(*ListWorkGroupsOutput, bool) bool) error {
	return c.ListWorkGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkGroupsPagesWithContext same as ListWorkGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListWorkGroupsPagesWithContext(ctx aws.Context, input *ListWorkGroupsInput, fn func(*ListWorkGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartQueryExecution = "StartQueryExecution"

// StartQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartQueryExecution for more information on using the StartQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartQueryExecutionRequest method.
//    req, resp := client.StartQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution
func (c *Athena) StartQueryExecutionRequest(input *StartQueryExecutionInput) (req *request.Request, output *StartQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opStartQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartQueryExecutionInput{}
	}

	output = &StartQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartQueryExecution API operation for Amazon Athena.
//
// Runs the SQL query statements contained in the Query. Requires you to have
// access to the workgroup in which the query ran. Running queries against an
// external catalog requires GetDataCatalog permission to the catalog. For code
// samples using the AWS SDK for Java, see Examples and Code Samples (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
// in the Amazon Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation StartQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * TooManyRequestsException
//   Indicates that the request was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution
func (c *Athena) StartQueryExecution(input *StartQueryExecutionInput) (*StartQueryExecutionOutput, error) {
	req, out := c.StartQueryExecutionRequest(input)
	return out, req.Send()
}

// StartQueryExecutionWithContext is the same as StartQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) StartQueryExecutionWithContext(ctx aws.Context, input *StartQueryExecutionInput, opts ...request.Option) (*StartQueryExecutionOutput, error) {
	req, out := c.StartQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopQueryExecution = "StopQueryExecution"

// StopQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopQueryExecution for more information on using the StopQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopQueryExecutionRequest method.
//    req, resp := client.StopQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution
func (c *Athena) StopQueryExecutionRequest(input *StopQueryExecutionInput) (req *request.Request, output *StopQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opStopQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopQueryExecutionInput{}
	}

	output = &StopQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopQueryExecution API operation for Amazon Athena.
//
// Stops a query execution. Requires you to have access to the workgroup in
// which the query ran.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation StopQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution
func (c *Athena) StopQueryExecution(input *StopQueryExecutionInput) (*StopQueryExecutionOutput, error) {
	req, out := c.StopQueryExecutionRequest(input)
	return out, req.Send()
}

// StopQueryExecutionWithContext is the same as StopQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) StopQueryExecutionWithContext(ctx aws.Context, input *StopQueryExecutionInput, opts ...request.Option) (*StopQueryExecutionOutput, error) {
	req, out := c.StopQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource
func (c *Athena) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Athena.
//
// Adds one or more tags to an Athena resource. A tag is a label that you assign
// to a resource. In Athena, a resource can be a workgroup or data catalog.
// Each tag consists of a key and an optional value, both of which you define.
// For example, you can use tags to categorize Athena workgroups or data catalogs
// by purpose, owner, or environment. Use a consistent set of tag keys to make
// it easier to search and filter workgroups or data catalogs in your account.
// For best practices, see Tagging Best Practices (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
// Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can
// be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers
// representable in UTF-8, and the following characters: + - = . _ : / @. Tag
// keys and values are case-sensitive. Tag keys must be unique per resource.
// If you specify more than one tag, separate them by commas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * ResourceNotFoundException
//   A resource, such as a workgroup, was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource
func (c *Athena) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource
func (c *Athena) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Athena.
//
// Removes one or more tags from a data catalog or workgroup resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * ResourceNotFoundException
//   A resource, such as a workgroup, was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource
func (c *Athena) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataCatalog = "UpdateDataCatalog"

// UpdateDataCatalogRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataCatalog for more information on using the UpdateDataCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataCatalogRequest method.
//    req, resp := client.UpdateDataCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateDataCatalog
func (c *Athena) UpdateDataCatalogRequest(input *UpdateDataCatalogInput) (req *request.Request, output *UpdateDataCatalogOutput) {
	op := &request.Operation{
		Name:       opUpdateDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDataCatalogInput{}
	}

	output = &UpdateDataCatalogOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataCatalog API operation for Amazon Athena.
//
// Updates the data catalog that has the specified name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation UpdateDataCatalog for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateDataCatalog
func (c *Athena) UpdateDataCatalog(input *UpdateDataCatalogInput) (*UpdateDataCatalogOutput, error) {
	req, out := c.UpdateDataCatalogRequest(input)
	return out, req.Send()
}

// UpdateDataCatalogWithContext is the same as UpdateDataCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) UpdateDataCatalogWithContext(ctx aws.Context, input *UpdateDataCatalogInput, opts ...request.Option) (*UpdateDataCatalogOutput, error) {
	req, out := c.UpdateDataCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkGroup = "UpdateWorkGroup"

// UpdateWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkGroup for more information on using the UpdateWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkGroupRequest method.
//    req, resp := client.UpdateWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup
func (c *Athena) UpdateWorkGroupRequest(input *UpdateWorkGroupInput) (req *request.Request, output *UpdateWorkGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkGroupInput{}
	}

	output = &UpdateWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkGroup API operation for Amazon Athena.
//
// Updates the workgroup with the specified name. The workgroup's name cannot
// be changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation UpdateWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup
func (c *Athena) UpdateWorkGroup(input *UpdateWorkGroupInput) (*UpdateWorkGroupOutput, error) {
	req, out := c.UpdateWorkGroupRequest(input)
	return out, req.Send()
}

// UpdateWorkGroupWithContext is the same as UpdateWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) UpdateWorkGroupWithContext(ctx aws.Context, input *UpdateWorkGroupInput, opts ...request.Option) (*UpdateWorkGroupOutput, error) {
	req, out := c.UpdateWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BatchGetNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// An array of query IDs.
	//
	// NamedQueryIds is a required field
	NamedQueryIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetNamedQueryInput"}
	if s.NamedQueryIds == nil {
		invalidParams.Add(request.NewErrParamRequired("NamedQueryIds"))
	}
	if s.NamedQueryIds != nil && len(s.NamedQueryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamedQueryIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamedQueryIds sets the NamedQueryIds field's value.
func (s *BatchGetNamedQueryInput) SetNamedQueryIds(v []*string) *BatchGetNamedQueryInput {
	s.NamedQueryIds = v
	return s
}

type BatchGetNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the named query IDs submitted.
	NamedQueries []*NamedQuery `type:"list"`

	// Information about provided query IDs.
	UnprocessedNamedQueryIds []*UnprocessedNamedQueryId `type:"list"`
}

// String returns the string representation
func (s BatchGetNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQueries sets the NamedQueries field's value.
func (s *BatchGetNamedQueryOutput) SetNamedQueries(v []*NamedQuery) *BatchGetNamedQueryOutput {
	s.NamedQueries = v
	return s
}

// SetUnprocessedNamedQueryIds sets the UnprocessedNamedQueryIds field's value.
func (s *BatchGetNamedQueryOutput) SetUnprocessedNamedQueryIds(v []*UnprocessedNamedQueryId) *BatchGetNamedQueryOutput {
	s.UnprocessedNamedQueryIds = v
	return s
}

type BatchGetQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// An array of query execution IDs.
	//
	// QueryExecutionIds is a required field
	QueryExecutionIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetQueryExecutionInput"}
	if s.QueryExecutionIds == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionIds"))
	}
	if s.QueryExecutionIds != nil && len(s.QueryExecutionIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryExecutionIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryExecutionIds sets the QueryExecutionIds field's value.
func (s *BatchGetQueryExecutionInput) SetQueryExecutionIds(v []*string) *BatchGetQueryExecutionInput {
	s.QueryExecutionIds = v
	return s
}

type BatchGetQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about a query execution.
	QueryExecutions []*QueryExecution `type:"list"`

	// Information about the query executions that failed to run.
	UnprocessedQueryExecutionIds []*UnprocessedQueryExecutionId `type:"list"`
}

// String returns the string representation
func (s BatchGetQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecutions sets the QueryExecutions field's value.
func (s *BatchGetQueryExecutionOutput) SetQueryExecutions(v []*QueryExecution) *BatchGetQueryExecutionOutput {
	s.QueryExecutions = v
	return s
}

// SetUnprocessedQueryExecutionIds sets the UnprocessedQueryExecutionIds field's value.
func (s *BatchGetQueryExecutionOutput) SetUnprocessedQueryExecutionIds(v []*UnprocessedQueryExecutionId) *BatchGetQueryExecutionOutput {
	s.UnprocessedQueryExecutionIds = v
	return s
}

// Contains metadata for a column in a table.
type Column struct {
	_ struct{} `type:"structure"`

	// Optional information about the column.
	Comment *string `type:"string"`

	// The name of the column.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The data type of the column.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Column) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Column) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *Column) SetComment(v string) *Column {
	s.Comment = &v
	return s
}

// SetName sets the Name field's value.
func (s *Column) SetName(v string) *Column {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Column) SetType(v string) *Column {
	s.Type = &v
	return s
}

// Information about the columns in a query execution result.
type ColumnInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether values in the column are case-sensitive.
	CaseSensitive *bool `type:"boolean"`

	// The catalog to which the query results belong.
	CatalogName *string `type:"string"`

	// A column label.
	Label *string `type:"string"`

	// The name of the column.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Indicates the column's nullable status.
	Nullable *string `type:"string" enum:"ColumnNullable"`

	// For DECIMAL data types, specifies the total number of digits, up to 38. For
	// performance reasons, we recommend up to 18 digits.
	Precision *int64 `type:"integer"`

	// For DECIMAL data types, specifies the total number of digits in the fractional
	// part of the value. Defaults to 0.
	Scale *int64 `type:"integer"`

	// The schema name (database name) to which the query results belong.
	SchemaName *string `type:"string"`

	// The table name for the query results.
	TableName *string `type:"string"`

	// The data type of the column.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ColumnInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnInfo) GoString() string {
	return s.String()
}

// SetCaseSensitive sets the CaseSensitive field's value.
func (s *ColumnInfo) SetCaseSensitive(v bool) *ColumnInfo {
	s.CaseSensitive = &v
	return s
}

// SetCatalogName sets the CatalogName field's value.
func (s *ColumnInfo) SetCatalogName(v string) *ColumnInfo {
	s.CatalogName = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ColumnInfo) SetLabel(v string) *ColumnInfo {
	s.Label = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnInfo) SetName(v string) *ColumnInfo {
	s.Name = &v
	return s
}

// SetNullable sets the Nullable field's value.
func (s *ColumnInfo) SetNullable(v string) *ColumnInfo {
	s.Nullable = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ColumnInfo) SetPrecision(v int64) *ColumnInfo {
	s.Precision = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *ColumnInfo) SetScale(v int64) *ColumnInfo {
	s.Scale = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ColumnInfo) SetSchemaName(v string) *ColumnInfo {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ColumnInfo) SetTableName(v string) *ColumnInfo {
	s.TableName = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnInfo) SetType(v string) *ColumnInfo {
	s.Type = &v
	return s
}

type CreateDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// A description of the data catalog to be created.
	Description *string `min:"1" type:"string"`

	// The name of the data catalog to create. The catalog name must be unique for
	// the AWS account and can use a maximum of 128 alphanumeric, underscore, at
	// sign, or hyphen characters.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the Lambda function or functions to use for creating the data catalog.
	// This is a mapping whose values depend on the catalog type.
	//
	//    * For the HIVE data catalog type, use the following syntax. The metadata-function
	//    parameter is required. The sdk-version parameter is optional and defaults
	//    to the currently supported version. metadata-function=lambda_arn, sdk-version=version_number
	//
	//    * For the LAMBDA data catalog type, use one of the following sets of required
	//    parameters, but not both. If you have one Lambda function that processes
	//    metadata and another for reading the actual data, use the following syntax.
	//    Both parameters are required. metadata-function=lambda_arn, record-function=lambda_arn
	//    If you have a composite Lambda function that processes both metadata and
	//    data, use the following syntax to specify your Lambda function. function=lambda_arn
	Parameters map[string]*string `type:"map"`

	// A list of comma separated tags to add to the data catalog that is created.
	Tags []*Tag `type:"list"`

	// The type of data catalog to create: LAMBDA for a federated catalog or HIVE
	// for an external hive metastore.
	//
	// Do not use the GLUE type. This refers to the AwsDataCatalog that already
	// exists in your account, of which you can have only one. Specifying the GLUE
	// type will result in an INVALID_INPUT error.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataCatalogType"`
}

// String returns the string representation
func (s CreateDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataCatalogInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDataCatalogInput) SetDescription(v string) *CreateDataCatalogInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataCatalogInput) SetName(v string) *CreateDataCatalogInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateDataCatalogInput) SetParameters(v map[string]*string) *CreateDataCatalogInput {
	s.Parameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataCatalogInput) SetTags(v []*Tag) *CreateDataCatalogInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataCatalogInput) SetType(v string) *CreateDataCatalogInput {
	s.Type = &v
	return s
}

type CreateDataCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataCatalogOutput) GoString() string {
	return s.String()
}

type CreateNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure the request to create the query
	// is idempotent (executes only once). If another CreateNamedQuery request is
	// received, the same response is returned and another query is not created.
	// If a parameter has changed, for example, the QueryString, an error is returned.
	//
	// This token is listed as not required because AWS SDKs (for example the AWS
	// SDK for Java) auto-generate the token for users. If you are not using the
	// AWS SDK or the AWS CLI, you must provide this token or the action will fail.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The database to which the query belongs.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The query description.
	Description *string `min:"1" type:"string"`

	// The query name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The contents of the query with all query statements.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// The name of the workgroup in which the named query is being created.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s CreateNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNamedQueryInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNamedQueryInput) SetClientRequestToken(v string) *CreateNamedQueryInput {
	s.ClientRequestToken = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *CreateNamedQueryInput) SetDatabase(v string) *CreateNamedQueryInput {
	s.Database = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNamedQueryInput) SetDescription(v string) *CreateNamedQueryInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNamedQueryInput) SetName(v string) *CreateNamedQueryInput {
	s.Name = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateNamedQueryInput) SetQueryString(v string) *CreateNamedQueryInput {
	s.QueryString = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *CreateNamedQueryInput) SetWorkGroup(v string) *CreateNamedQueryInput {
	s.WorkGroup = &v
	return s
}

type CreateNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query.
	NamedQueryId *string `type:"string"`
}

// String returns the string representation
func (s CreateNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *CreateNamedQueryOutput) SetNamedQueryId(v string) *CreateNamedQueryOutput {
	s.NamedQueryId = &v
	return s
}

type CreateWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The configuration for the workgroup, which includes the location in Amazon
	// S3 where query results are stored, the encryption configuration, if any,
	// used for encrypting query results, whether the Amazon CloudWatch Metrics
	// are enabled for the workgroup, the limit for the amount of bytes scanned
	// (cutoff) per query, if it is specified, and whether workgroup's settings
	// (specified with EnforceWorkGroupConfiguration) in the WorkGroupConfiguration
	// override client-side settings. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	Configuration *WorkGroupConfiguration `type:"structure"`

	// The workgroup description.
	Description *string `type:"string"`

	// The workgroup name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A list of comma separated tags to add to the workgroup that is created.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateWorkGroupInput) SetConfiguration(v *WorkGroupConfiguration) *CreateWorkGroupInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkGroupInput) SetDescription(v string) *CreateWorkGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkGroupInput) SetName(v string) *CreateWorkGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkGroupInput) SetTags(v []*Tag) *CreateWorkGroupInput {
	s.Tags = v
	return s
}

type CreateWorkGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkGroupOutput) GoString() string {
	return s.String()
}

// Contains information about a data catalog in an AWS account.
type DataCatalog struct {
	_ struct{} `type:"structure"`

	// An optional description of the data catalog.
	Description *string `min:"1" type:"string"`

	// The name of the data catalog. The catalog name must be unique for the AWS
	// account and can use a maximum of 128 alphanumeric, underscore, at sign, or
	// hyphen characters.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the Lambda function or functions to use for the data catalog. This
	// is a mapping whose values depend on the catalog type.
	//
	//    * For the HIVE data catalog type, use the following syntax. The metadata-function
	//    parameter is required. The sdk-version parameter is optional and defaults
	//    to the currently supported version. metadata-function=lambda_arn, sdk-version=version_number
	//
	//    * For the LAMBDA data catalog type, use one of the following sets of required
	//    parameters, but not both. If you have one Lambda function that processes
	//    metadata and another for reading the actual data, use the following syntax.
	//    Both parameters are required. metadata-function=lambda_arn, record-function=lambda_arn
	//    If you have a composite Lambda function that processes both metadata and
	//    data, use the following syntax to specify your Lambda function. function=lambda_arn
	Parameters map[string]*string `type:"map"`

	// The type of data catalog: LAMBDA for a federated catalog or HIVE for an external
	// hive metastore. GLUE refers to the AwsDataCatalog that already exists in
	// your account, of which you can have only one.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataCatalogType"`
}

// String returns the string representation
func (s DataCatalog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataCatalog) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DataCatalog) SetDescription(v string) *DataCatalog {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataCatalog) SetName(v string) *DataCatalog {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DataCatalog) SetParameters(v map[string]*string) *DataCatalog {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *DataCatalog) SetType(v string) *DataCatalog {
	s.Type = &v
	return s
}

// The summary information for the data catalog, which includes its name and
// type.
type DataCatalogSummary struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog.
	CatalogName *string `min:"1" type:"string"`

	// The data catalog type.
	Type *string `type:"string" enum:"DataCatalogType"`
}

// String returns the string representation
func (s DataCatalogSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataCatalogSummary) GoString() string {
	return s.String()
}

// SetCatalogName sets the CatalogName field's value.
func (s *DataCatalogSummary) SetCatalogName(v string) *DataCatalogSummary {
	s.CatalogName = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataCatalogSummary) SetType(v string) *DataCatalogSummary {
	s.Type = &v
	return s
}

// Contains metadata information for a database in a data catalog.
type Database struct {
	_ struct{} `type:"structure"`

	// An optional description of the database.
	Description *string `min:"1" type:"string"`

	// The name of the database.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A set of custom key/value pairs.
	Parameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Database) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Database) SetDescription(v string) *Database {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Database) SetName(v string) *Database {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Database) SetParameters(v map[string]*string) *Database {
	s.Parameters = v
	return s
}

// A piece of data (a field in the table).
type Datum struct {
	_ struct{} `type:"structure"`

	// The value of the datum.
	VarCharValue *string `type:"string"`
}

// String returns the string representation
func (s Datum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datum) GoString() string {
	return s.String()
}

// SetVarCharValue sets the VarCharValue field's value.
func (s *Datum) SetVarCharValue(v string) *Datum {
	s.VarCharValue = &v
	return s
}

type DeleteDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataCatalogInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteDataCatalogInput) SetName(v string) *DeleteDataCatalogInput {
	s.Name = &v
	return s
}

type DeleteDataCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataCatalogOutput) GoString() string {
	return s.String()
}

type DeleteNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query to delete.
	NamedQueryId *string `type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamedQueryInput) GoString() string {
	return s.String()
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *DeleteNamedQueryInput) SetNamedQueryId(v string) *DeleteNamedQueryInput {
	s.NamedQueryId = &v
	return s
}

type DeleteNamedQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamedQueryOutput) GoString() string {
	return s.String()
}

type DeleteWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The option to delete the workgroup and its contents even if the workgroup
	// contains any named queries or query executions.
	RecursiveDeleteOption *bool `type:"boolean"`

	// The unique name of the workgroup to delete.
	//
	// WorkGroup is a required field
	WorkGroup *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkGroupInput"}
	if s.WorkGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecursiveDeleteOption sets the RecursiveDeleteOption field's value.
func (s *DeleteWorkGroupInput) SetRecursiveDeleteOption(v bool) *DeleteWorkGroupInput {
	s.RecursiveDeleteOption = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *DeleteWorkGroupInput) SetWorkGroup(v string) *DeleteWorkGroupInput {
	s.WorkGroup = &v
	return s
}

type DeleteWorkGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkGroupOutput) GoString() string {
	return s.String()
}

// If query results are encrypted in Amazon S3, indicates the encryption option
// used (for example, SSE-KMS or CSE-KMS) and key information.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon S3 server-side encryption with Amazon S3-managed
	// keys (SSE-S3), server-side encryption with KMS-managed keys (SSE-KMS), or
	// client-side encryption with KMS-managed keys (CSE-KMS) is used.
	//
	// If a query runs in a workgroup and the workgroup overrides client-side settings,
	// then the workgroup's setting for encryption is used. It specifies whether
	// query results must be encrypted, for all queries that run in this workgroup.
	//
	// EncryptionOption is a required field
	EncryptionOption *string `type:"string" required:"true" enum:"EncryptionOption"`

	// For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
	KmsKey *string `type:"string"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.EncryptionOption == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionOption"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionOption sets the EncryptionOption field's value.
func (s *EncryptionConfiguration) SetEncryptionOption(v string) *EncryptionConfiguration {
	s.EncryptionOption = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *EncryptionConfiguration) SetKmsKey(v string) *EncryptionConfiguration {
	s.KmsKey = &v
	return s
}

// The Athena engine version for running queries.
type EngineVersion struct {
	_ struct{} `type:"structure"`

	// Read only. The engine version on which the query runs. If the user requests
	// a valid engine version other than Auto, the effective engine version is the
	// same as the engine version that the user requested. If the user requests
	// Auto, the effective engine version is chosen by Athena. When a request to
	// update the engine version is made by a CreateWorkGroup or UpdateWorkGroup
	// operation, the EffectiveEngineVersion field is ignored.
	EffectiveEngineVersion *string `min:"1" type:"string"`

	// The engine version requested by the user. Possible values are determined
	// by the output of ListEngineVersions, including Auto. The default is Auto.
	SelectedEngineVersion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EngineVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EngineVersion"}
	if s.EffectiveEngineVersion != nil && len(*s.EffectiveEngineVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EffectiveEngineVersion", 1))
	}
	if s.SelectedEngineVersion != nil && len(*s.SelectedEngineVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SelectedEngineVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEffectiveEngineVersion sets the EffectiveEngineVersion field's value.
func (s *EngineVersion) SetEffectiveEngineVersion(v string) *EngineVersion {
	s.EffectiveEngineVersion = &v
	return s
}

// SetSelectedEngineVersion sets the SelectedEngineVersion field's value.
func (s *EngineVersion) SetSelectedEngineVersion(v string) *EngineVersion {
	s.SelectedEngineVersion = &v
	return s
}

type GetDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog to return.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataCatalogInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetDataCatalogInput) SetName(v string) *GetDataCatalogInput {
	s.Name = &v
	return s
}

type GetDataCatalogOutput struct {
	_ struct{} `type:"structure"`

	// The data catalog returned.
	DataCatalog *DataCatalog `type:"structure"`
}

// String returns the string representation
func (s GetDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataCatalogOutput) GoString() string {
	return s.String()
}

// SetDataCatalog sets the DataCatalog field's value.
func (s *GetDataCatalogOutput) SetDataCatalog(v *DataCatalog) *GetDataCatalogOutput {
	s.DataCatalog = v
	return s
}

type GetDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog that contains the database to return.
	//
	// CatalogName is a required field
	CatalogName *string `min:"1" type:"string" required:"true"`

	// The name of the database to return.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDatabaseInput"}
	if s.CatalogName == nil {
		invalidParams.Add(request.NewErrParamRequired("CatalogName"))
	}
	if s.CatalogName != nil && len(*s.CatalogName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogName", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogName sets the CatalogName field's value.
func (s *GetDatabaseInput) SetCatalogName(v string) *GetDatabaseInput {
	s.CatalogName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetDatabaseInput) SetDatabaseName(v string) *GetDatabaseInput {
	s.DatabaseName = &v
	return s
}

type GetDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The database returned.
	Database *Database `type:"structure"`
}

// String returns the string representation
func (s GetDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *GetDatabaseOutput) SetDatabase(v *Database) *GetDatabaseOutput {
	s.Database = v
	return s
}

type GetNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query. Use ListNamedQueries to get query IDs.
	//
	// NamedQueryId is a required field
	NamedQueryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNamedQueryInput"}
	if s.NamedQueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("NamedQueryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *GetNamedQueryInput) SetNamedQueryId(v string) *GetNamedQueryInput {
	s.NamedQueryId = &v
	return s
}

type GetNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query.
	NamedQuery *NamedQuery `type:"structure"`
}

// String returns the string representation
func (s GetNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQuery sets the NamedQuery field's value.
func (s *GetNamedQueryOutput) SetNamedQuery(v *NamedQuery) *GetNamedQueryOutput {
	s.NamedQuery = v
	return s
}

type GetQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query execution.
	//
	// QueryExecutionId is a required field
	QueryExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryExecutionInput"}
	if s.QueryExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *GetQueryExecutionInput) SetQueryExecutionId(v string) *GetQueryExecutionInput {
	s.QueryExecutionId = &v
	return s
}

type GetQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query execution.
	QueryExecution *QueryExecution `type:"structure"`
}

// String returns the string representation
func (s GetQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecution sets the QueryExecution field's value.
func (s *GetQueryExecutionOutput) SetQueryExecution(v *QueryExecution) *GetQueryExecutionOutput {
	s.QueryExecution = v
	return s
}

type GetQueryResultsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results (rows) to return in this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`

	// The unique ID of the query execution.
	//
	// QueryExecutionId is a required field
	QueryExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueryResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryResultsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QueryExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetQueryResultsInput) SetMaxResults(v int64) *GetQueryResultsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetQueryResultsInput) SetNextToken(v string) *GetQueryResultsInput {
	s.NextToken = &v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *GetQueryResultsInput) SetQueryExecutionId(v string) *GetQueryResultsInput {
	s.QueryExecutionId = &v
	return s
}

type GetQueryResultsOutput struct {
	_ struct{} `type:"structure"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`

	// The results of the query execution.
	ResultSet *ResultSet `type:"structure"`

	// The number of rows inserted with a CREATE TABLE AS SELECT statement.
	UpdateCount *int64 `type:"long"`
}

// String returns the string representation
func (s GetQueryResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryResultsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetQueryResultsOutput) SetNextToken(v string) *GetQueryResultsOutput {
	s.NextToken = &v
	return s
}

// SetResultSet sets the ResultSet field's value.
func (s *GetQueryResultsOutput) SetResultSet(v *ResultSet) *GetQueryResultsOutput {
	s.ResultSet = v
	return s
}

// SetUpdateCount sets the UpdateCount field's value.
func (s *GetQueryResultsOutput) SetUpdateCount(v int64) *GetQueryResultsOutput {
	s.UpdateCount = &v
	return s
}

type GetTableMetadataInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog that contains the database and table metadata
	// to return.
	//
	// CatalogName is a required field
	CatalogName *string `min:"1" type:"string" required:"true"`

	// The name of the database that contains the table metadata to return.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table for which metadata is returned.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTableMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableMetadataInput"}
	if s.CatalogName == nil {
		invalidParams.Add(request.NewErrParamRequired("CatalogName"))
	}
	if s.CatalogName != nil && len(*s.CatalogName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogName", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogName sets the CatalogName field's value.
func (s *GetTableMetadataInput) SetCatalogName(v string) *GetTableMetadataInput {
	s.CatalogName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetTableMetadataInput) SetDatabaseName(v string) *GetTableMetadataInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetTableMetadataInput) SetTableName(v string) *GetTableMetadataInput {
	s.TableName = &v
	return s
}

type GetTableMetadataOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains table metadata.
	TableMetadata *TableMetadata `type:"structure"`
}

// String returns the string representation
func (s GetTableMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableMetadataOutput) GoString() string {
	return s.String()
}

// SetTableMetadata sets the TableMetadata field's value.
func (s *GetTableMetadataOutput) SetTableMetadata(v *TableMetadata) *GetTableMetadataOutput {
	s.TableMetadata = v
	return s
}

type GetWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the workgroup.
	//
	// WorkGroup is a required field
	WorkGroup *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkGroupInput"}
	if s.WorkGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *GetWorkGroupInput) SetWorkGroup(v string) *GetWorkGroupInput {
	s.WorkGroup = &v
	return s
}

type GetWorkGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the workgroup.
	WorkGroup *WorkGroup `type:"structure"`
}

// String returns the string representation
func (s GetWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkGroupOutput) GoString() string {
	return s.String()
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *GetWorkGroupOutput) SetWorkGroup(v *WorkGroup) *GetWorkGroupOutput {
	s.WorkGroup = v
	return s
}

// Indicates a platform issue, which may be due to a transient condition or
// outage.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates that something is wrong with the input to the request. For example,
// a required parameter may be missing or out of range.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code returned when the query execution failed to process, or when
	// the processing request for the named query failed.
	AthenaErrorCode *string `min:"1" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDataCatalogsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of data catalogs to return.
	MaxResults *int64 `min:"2" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDataCatalogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataCatalogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataCatalogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataCatalogsInput"}
	if s.MaxResults != nil && *s.MaxResults < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 2))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataCatalogsInput) SetMaxResults(v int64) *ListDataCatalogsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataCatalogsInput) SetNextToken(v string) *ListDataCatalogsInput {
	s.NextToken = &v
	return s
}

type ListDataCatalogsOutput struct {
	_ struct{} `type:"structure"`

	// A summary list of data catalogs.
	DataCatalogsSummary []*DataCatalogSummary `type:"list"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDataCatalogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataCatalogsOutput) GoString() string {
	return s.String()
}

// SetDataCatalogsSummary sets the DataCatalogsSummary field's value.
func (s *ListDataCatalogsOutput) SetDataCatalogsSummary(v []*DataCatalogSummary) *ListDataCatalogsOutput {
	s.DataCatalogsSummary = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataCatalogsOutput) SetNextToken(v string) *ListDataCatalogsOutput {
	s.NextToken = &v
	return s
}

type ListDatabasesInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog that contains the databases to return.
	//
	// CatalogName is a required field
	CatalogName *string `min:"1" type:"string" required:"true"`

	// Specifies the maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatabasesInput"}
	if s.CatalogName == nil {
		invalidParams.Add(request.NewErrParamRequired("CatalogName"))
	}
	if s.CatalogName != nil && len(*s.CatalogName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogName sets the CatalogName field's value.
func (s *ListDatabasesInput) SetCatalogName(v string) *ListDatabasesInput {
	s.CatalogName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatabasesInput) SetMaxResults(v int64) *ListDatabasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesInput) SetNextToken(v string) *ListDatabasesInput {
	s.NextToken = &v
	return s
}

type ListDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of databases from a data catalog.
	DatabaseList []*Database `type:"list"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabaseList sets the DatabaseList field's value.
func (s *ListDatabasesOutput) SetDatabaseList(v []*Database) *ListDatabasesOutput {
	s.DatabaseList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesOutput) SetNextToken(v string) *ListDatabasesOutput {
	s.NextToken = &v
	return s
}

type ListEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of engine versions to return in this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEngineVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEngineVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEngineVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEngineVersionsInput) SetMaxResults(v int64) *ListEngineVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngineVersionsInput) SetNextToken(v string) *ListEngineVersionsInput {
	s.NextToken = &v
	return s
}

type ListEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of engine versions that are available to choose from.
	EngineVersions []*EngineVersion `type:"list"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetEngineVersions sets the EngineVersions field's value.
func (s *ListEngineVersionsOutput) SetEngineVersions(v []*EngineVersion) *ListEngineVersionsOutput {
	s.EngineVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngineVersionsOutput) SetNextToken(v string) *ListEngineVersionsOutput {
	s.NextToken = &v
	return s
}

type ListNamedQueriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of queries to return in this request.
	MaxResults *int64 `type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`

	// The name of the workgroup from which the named queries are being returned.
	// If a workgroup is not specified, the saved queries for the primary workgroup
	// are returned.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s ListNamedQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamedQueriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamedQueriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNamedQueriesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNamedQueriesInput) SetMaxResults(v int64) *ListNamedQueriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedQueriesInput) SetNextToken(v string) *ListNamedQueriesInput {
	s.NextToken = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *ListNamedQueriesInput) SetWorkGroup(v string) *ListNamedQueriesInput {
	s.WorkGroup = &v
	return s
}

type ListNamedQueriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of unique query IDs.
	NamedQueryIds []*string `min:"1" type:"list"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListNamedQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamedQueriesOutput) GoString() string {
	return s.String()
}

// SetNamedQueryIds sets the NamedQueryIds field's value.
func (s *ListNamedQueriesOutput) SetNamedQueryIds(v []*string) *ListNamedQueriesOutput {
	s.NamedQueryIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedQueriesOutput) SetNextToken(v string) *ListNamedQueriesOutput {
	s.NextToken = &v
	return s
}

type ListQueryExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of query executions to return in this request.
	MaxResults *int64 `type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`

	// The name of the workgroup from which queries are being returned. If a workgroup
	// is not specified, a list of available query execution IDs for the queries
	// in the primary workgroup is returned.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s ListQueryExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueryExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQueryExecutionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueryExecutionsInput) SetMaxResults(v int64) *ListQueryExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryExecutionsInput) SetNextToken(v string) *ListQueryExecutionsInput {
	s.NextToken = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *ListQueryExecutionsInput) SetWorkGroup(v string) *ListQueryExecutionsInput {
	s.WorkGroup = &v
	return s
}

type ListQueryExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`

	// The unique IDs of each query execution as an array of strings.
	QueryExecutionIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s ListQueryExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryExecutionsOutput) SetNextToken(v string) *ListQueryExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetQueryExecutionIds sets the QueryExecutionIds field's value.
func (s *ListQueryExecutionsOutput) SetQueryExecutionIds(v []*string) *ListQueryExecutionsOutput {
	s.QueryExecutionIds = v
	return s
}

type ListTableMetadataInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog for which table metadata should be returned.
	//
	// CatalogName is a required field
	CatalogName *string `min:"1" type:"string" required:"true"`

	// The name of the database for which table metadata should be returned.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A regex filter that pattern-matches table names. If no expression is supplied,
	// metadata for all tables are listed.
	Expression *string `type:"string"`

	// Specifies the maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTableMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTableMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTableMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTableMetadataInput"}
	if s.CatalogName == nil {
		invalidParams.Add(request.NewErrParamRequired("CatalogName"))
	}
	if s.CatalogName != nil && len(*s.CatalogName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogName", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogName sets the CatalogName field's value.
func (s *ListTableMetadataInput) SetCatalogName(v string) *ListTableMetadataInput {
	s.CatalogName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ListTableMetadataInput) SetDatabaseName(v string) *ListTableMetadataInput {
	s.DatabaseName = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *ListTableMetadataInput) SetExpression(v string) *ListTableMetadataInput {
	s.Expression = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTableMetadataInput) SetMaxResults(v int64) *ListTableMetadataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableMetadataInput) SetNextToken(v string) *ListTableMetadataInput {
	s.NextToken = &v
	return s
}

type ListTableMetadataOutput struct {
	_ struct{} `type:"structure"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`

	// A list of table metadata.
	TableMetadataList []*TableMetadata `type:"list"`
}

// String returns the string representation
func (s ListTableMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTableMetadataOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableMetadataOutput) SetNextToken(v string) *ListTableMetadataOutput {
	s.NextToken = &v
	return s
}

// SetTableMetadataList sets the TableMetadataList field's value.
func (s *ListTableMetadataOutput) SetTableMetadataList(v []*TableMetadata) *ListTableMetadataOutput {
	s.TableMetadataList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per request that lists the tags
	// for the resource.
	MaxResults *int64 `min:"75" type:"integer"`

	// The token for the next set of results, or null if there are no additional
	// results for this request, where the request lists the tags for the resource
	// with the specified ARN.
	NextToken *string `min:"1" type:"string"`

	// Lists the tags for the resource with the specified ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 75 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 75))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`

	// The list of tags associated with the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWorkGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of workgroups to return in this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorkGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkGroupsInput) SetMaxResults(v int64) *ListWorkGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkGroupsInput) SetNextToken(v string) *ListWorkGroupsInput {
	s.NextToken = &v
	return s
}

type ListWorkGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`

	// A list of WorkGroupSummary objects that include the names, descriptions,
	// creation times, and states for each workgroup.
	WorkGroups []*WorkGroupSummary `type:"list"`
}

// String returns the string representation
func (s ListWorkGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkGroupsOutput) SetNextToken(v string) *ListWorkGroupsOutput {
	s.NextToken = &v
	return s
}

// SetWorkGroups sets the WorkGroups field's value.
func (s *ListWorkGroupsOutput) SetWorkGroups(v []*WorkGroupSummary) *ListWorkGroupsOutput {
	s.WorkGroups = v
	return s
}

// An exception that Athena received when it called a custom metastore. Occurs
// if the error is not caused by user input (InvalidRequestException) or from
// the Athena platform (InternalServerException). For example, if a user-created
// Lambda function is missing permissions, the Lambda 4XX exception is returned
// in a MetadataException.
type MetadataException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s MetadataException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetadataException) GoString() string {
	return s.String()
}

func newErrorMetadataException(v protocol.ResponseMetadata) error {
	return &MetadataException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MetadataException) Code() string {
	return "MetadataException"
}

// Message returns the exception's message.
func (s *MetadataException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MetadataException) OrigErr() error {
	return nil
}

func (s *MetadataException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MetadataException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MetadataException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A query, where QueryString is the list of SQL query statements that comprise
// the query.
type NamedQuery struct {
	_ struct{} `type:"structure"`

	// The database to which the query belongs.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The query description.
	Description *string `min:"1" type:"string"`

	// The query name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the query.
	NamedQueryId *string `type:"string"`

	// The SQL query statements that comprise the query.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// The name of the workgroup that contains the named query.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s NamedQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamedQuery) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *NamedQuery) SetDatabase(v string) *NamedQuery {
	s.Database = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NamedQuery) SetDescription(v string) *NamedQuery {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *NamedQuery) SetName(v string) *NamedQuery {
	s.Name = &v
	return s
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *NamedQuery) SetNamedQueryId(v string) *NamedQuery {
	s.NamedQueryId = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *NamedQuery) SetQueryString(v string) *NamedQuery {
	s.QueryString = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *NamedQuery) SetWorkGroup(v string) *NamedQuery {
	s.WorkGroup = &v
	return s
}

// Information about a single instance of a query execution.
type QueryExecution struct {
	_ struct{} `type:"structure"`

	// The engine version that executed the query.
	EngineVersion *EngineVersion `type:"structure"`

	// The SQL query statements which the query execution ran.
	Query *string `min:"1" type:"string"`

	// The database in which the query execution occurred.
	QueryExecutionContext *QueryExecutionContext `type:"structure"`

	// The unique identifier for each query execution.
	QueryExecutionId *string `type:"string"`

	// The location in Amazon S3 where query results were stored and the encryption
	// option, if any, used for query results. These are known as "client-side settings".
	// If workgroup settings override client-side settings, then the query uses
	// the location for the query results and the encryption configuration that
	// are specified for the workgroup.
	ResultConfiguration *ResultConfiguration `type:"structure"`

	// The type of query statement that was run. DDL indicates DDL query statements.
	// DML indicates DML (Data Manipulation Language) query statements, such as
	// CREATE TABLE AS SELECT. UTILITY indicates query statements other than DDL
	// and DML, such as SHOW CREATE TABLE, or DESCRIBE <table>.
	StatementType *string `type:"string" enum:"StatementType"`

	// Query execution statistics, such as the amount of data scanned, the amount
	// of time that the query took to process, and the type of statement that was
	// run.
	Statistics *QueryExecutionStatistics `type:"structure"`

	// The completion date, current state, submission time, and state change reason
	// (if applicable) for the query execution.
	Status *QueryExecutionStatus `type:"structure"`

	// The name of the workgroup in which the query ran.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s QueryExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecution) GoString() string {
	return s.String()
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *QueryExecution) SetEngineVersion(v *EngineVersion) *QueryExecution {
	s.EngineVersion = v
	return s
}

// SetQuery sets the Query field's value.
func (s *QueryExecution) SetQuery(v string) *QueryExecution {
	s.Query = &v
	return s
}

// SetQueryExecutionContext sets the QueryExecutionContext field's value.
func (s *QueryExecution) SetQueryExecutionContext(v *QueryExecutionContext) *QueryExecution {
	s.QueryExecutionContext = v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *QueryExecution) SetQueryExecutionId(v string) *QueryExecution {
	s.QueryExecutionId = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *QueryExecution) SetResultConfiguration(v *ResultConfiguration) *QueryExecution {
	s.ResultConfiguration = v
	return s
}

// SetStatementType sets the StatementType field's value.
func (s *QueryExecution) SetStatementType(v string) *QueryExecution {
	s.StatementType = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *QueryExecution) SetStatistics(v *QueryExecutionStatistics) *QueryExecution {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *QueryExecution) SetStatus(v *QueryExecutionStatus) *QueryExecution {
	s.Status = v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *QueryExecution) SetWorkGroup(v string) *QueryExecution {
	s.WorkGroup = &v
	return s
}

// The database and data catalog context in which the query execution occurs.
type QueryExecutionContext struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog used in the query execution.
	Catalog *string `min:"1" type:"string"`

	// The name of the database used in the query execution.
	Database *string `min:"1" type:"string"`
}

// String returns the string representation
func (s QueryExecutionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryExecutionContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryExecutionContext"}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *QueryExecutionContext) SetCatalog(v string) *QueryExecutionContext {
	s.Catalog = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *QueryExecutionContext) SetDatabase(v string) *QueryExecutionContext {
	s.Database = &v
	return s
}

// The amount of data scanned during the query execution and the amount of time
// that it took to execute, and the type of statement that was run.
type QueryExecutionStatistics struct {
	_ struct{} `type:"structure"`

	// The location and file name of a data manifest file. The manifest file is
	// saved to the Athena query results location in Amazon S3. The manifest file
	// tracks files that the query wrote to Amazon S3. If the query fails, the manifest
	// file also tracks files that the query intended to write. The manifest is
	// useful for identifying orphaned files resulting from a failed query. For
	// more information, see Working with Query Results, Output Files, and Query
	// History (https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the
	// Amazon Athena User Guide.
	DataManifestLocation *string `type:"string"`

	// The number of bytes in the data that was queried.
	DataScannedInBytes *int64 `type:"long"`

	// The number of milliseconds that the query took to execute.
	EngineExecutionTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that Athena took to plan the query processing
	// flow. This includes the time spent retrieving table partitions from the data
	// source. Note that because the query engine performs the query planning, query
	// planning time is a subset of engine processing time.
	QueryPlanningTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that the query was in your query queue waiting
	// for resources. Note that if transient errors occur, Athena might automatically
	// add the query back to the queue.
	QueryQueueTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that Athena took to finalize and publish the query
	// results after the query engine finished running the query.
	ServiceProcessingTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that Athena took to run the query.
	TotalExecutionTimeInMillis *int64 `type:"long"`
}

// String returns the string representation
func (s QueryExecutionStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionStatistics) GoString() string {
	return s.String()
}

// SetDataManifestLocation sets the DataManifestLocation field's value.
func (s *QueryExecutionStatistics) SetDataManifestLocation(v string) *QueryExecutionStatistics {
	s.DataManifestLocation = &v
	return s
}

// SetDataScannedInBytes sets the DataScannedInBytes field's value.
func (s *QueryExecutionStatistics) SetDataScannedInBytes(v int64) *QueryExecutionStatistics {
	s.DataScannedInBytes = &v
	return s
}

// SetEngineExecutionTimeInMillis sets the EngineExecutionTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetEngineExecutionTimeInMillis(v int64) *QueryExecutionStatistics {
	s.EngineExecutionTimeInMillis = &v
	return s
}

// SetQueryPlanningTimeInMillis sets the QueryPlanningTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetQueryPlanningTimeInMillis(v int64) *QueryExecutionStatistics {
	s.QueryPlanningTimeInMillis = &v
	return s
}

// SetQueryQueueTimeInMillis sets the QueryQueueTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetQueryQueueTimeInMillis(v int64) *QueryExecutionStatistics {
	s.QueryQueueTimeInMillis = &v
	return s
}

// SetServiceProcessingTimeInMillis sets the ServiceProcessingTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetServiceProcessingTimeInMillis(v int64) *QueryExecutionStatistics {
	s.ServiceProcessingTimeInMillis = &v
	return s
}

// SetTotalExecutionTimeInMillis sets the TotalExecutionTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetTotalExecutionTimeInMillis(v int64) *QueryExecutionStatistics {
	s.TotalExecutionTimeInMillis = &v
	return s
}

// The completion date, current state, submission time, and state change reason
// (if applicable) for the query execution.
type QueryExecutionStatus struct {
	_ struct{} `type:"structure"`

	// The date and time that the query completed.
	CompletionDateTime *time.Time `type:"timestamp"`

	// The state of query execution. QUEUED indicates that the query has been submitted
	// to the service, and Athena will execute the query as soon as resources are
	// available. RUNNING indicates that the query is in execution phase. SUCCEEDED
	// indicates that the query completed without errors. FAILED indicates that
	// the query experienced an error and did not complete processing. CANCELLED
	// indicates that a user input interrupted query execution.
	//
	// Athena automatically retries your queries in cases of certain transient errors.
	// As a result, you may see the query state transition from RUNNING or FAILED
	// to QUEUED.
	State *string `type:"string" enum:"QueryExecutionState"`

	// Further detail about the status of the query.
	StateChangeReason *string `type:"string"`

	// The date and time that the query was submitted.
	SubmissionDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s QueryExecutionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionStatus) GoString() string {
	return s.String()
}

// SetCompletionDateTime sets the CompletionDateTime field's value.
func (s *QueryExecutionStatus) SetCompletionDateTime(v time.Time) *QueryExecutionStatus {
	s.CompletionDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *QueryExecutionStatus) SetState(v string) *QueryExecutionStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *QueryExecutionStatus) SetStateChangeReason(v string) *QueryExecutionStatus {
	s.StateChangeReason = &v
	return s
}

// SetSubmissionDateTime sets the SubmissionDateTime field's value.
func (s *QueryExecutionStatus) SetSubmissionDateTime(v time.Time) *QueryExecutionStatus {
	s.SubmissionDateTime = &v
	return s
}

// A resource, such as a workgroup, was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The location in Amazon S3 where query results are stored and the encryption
// option, if any, used for query results. These are known as "client-side settings".
// If workgroup settings override client-side settings, then the query uses
// the workgroup settings.
type ResultConfiguration struct {
	_ struct{} `type:"structure"`

	// If query results are encrypted in Amazon S3, indicates the encryption option
	// used (for example, SSE-KMS or CSE-KMS) and key information. This is a client-side
	// setting. If workgroup settings override client-side settings, then the query
	// uses the encryption configuration that is specified for the workgroup, and
	// also uses the location for storing query results specified in the workgroup.
	// See WorkGroupConfiguration$EnforceWorkGroupConfiguration and Workgroup Settings
	// Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The location in Amazon S3 where your query results are stored, such as s3://path/to/query/bucket/.
	// To run the query, you must specify the query results location using one of
	// the ways: either for individual queries using either this setting (client-side),
	// or in the workgroup, using WorkGroupConfiguration. If none of them is set,
	// Athena issues an error that no output location is provided. For more information,
	// see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html).
	// If workgroup settings override client-side settings, then the query uses
	// the settings specified for the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	OutputLocation *string `type:"string"`
}

// String returns the string representation
func (s ResultConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResultConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResultConfiguration"}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ResultConfiguration) SetEncryptionConfiguration(v *EncryptionConfiguration) *ResultConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *ResultConfiguration) SetOutputLocation(v string) *ResultConfiguration {
	s.OutputLocation = &v
	return s
}

// The information about the updates in the query results, such as output location
// and encryption configuration for the query results.
type ResultConfigurationUpdates struct {
	_ struct{} `type:"structure"`

	// The encryption configuration for the query results.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The location in Amazon S3 where your query results are stored, such as s3://path/to/query/bucket/.
	// For more information, see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html)
	// If workgroup settings override client-side settings, then the query uses
	// the location for the query results and the encryption configuration that
	// are specified for the workgroup. The "workgroup settings override" is specified
	// in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration.
	// See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	OutputLocation *string `type:"string"`

	// If set to "true", indicates that the previously-specified encryption configuration
	// (also known as the client-side setting) for queries in this workgroup should
	// be ignored and set to null. If set to "false" or not set, and a value is
	// present in the EncryptionConfiguration in ResultConfigurationUpdates (the
	// client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration
	// will be updated with the new value. For more information, see Workgroup Settings
	// Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	RemoveEncryptionConfiguration *bool `type:"boolean"`

	// If set to "true", indicates that the previously-specified query results location
	// (also known as a client-side setting) for queries in this workgroup should
	// be ignored and set to null. If set to "false" or not set, and a value is
	// present in the OutputLocation in ResultConfigurationUpdates (the client-side
	// setting), the OutputLocation in the workgroup's ResultConfiguration will
	// be updated with the new value. For more information, see Workgroup Settings
	// Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	RemoveOutputLocation *bool `type:"boolean"`
}

// String returns the string representation
func (s ResultConfigurationUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultConfigurationUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResultConfigurationUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResultConfigurationUpdates"}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ResultConfigurationUpdates) SetEncryptionConfiguration(v *EncryptionConfiguration) *ResultConfigurationUpdates {
	s.EncryptionConfiguration = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *ResultConfigurationUpdates) SetOutputLocation(v string) *ResultConfigurationUpdates {
	s.OutputLocation = &v
	return s
}

// SetRemoveEncryptionConfiguration sets the RemoveEncryptionConfiguration field's value.
func (s *ResultConfigurationUpdates) SetRemoveEncryptionConfiguration(v bool) *ResultConfigurationUpdates {
	s.RemoveEncryptionConfiguration = &v
	return s
}

// SetRemoveOutputLocation sets the RemoveOutputLocation field's value.
func (s *ResultConfigurationUpdates) SetRemoveOutputLocation(v bool) *ResultConfigurationUpdates {
	s.RemoveOutputLocation = &v
	return s
}

// The metadata and rows that comprise a query result set. The metadata describes
// the column structure and data types. To return a ResultSet object, use GetQueryResults.
type ResultSet struct {
	_ struct{} `type:"structure"`

	// The metadata that describes the column structure and data types of a table
	// of query results.
	ResultSetMetadata *ResultSetMetadata `type:"structure"`

	// The rows in the table.
	Rows []*Row `type:"list"`
}

// String returns the string representation
func (s ResultSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSet) GoString() string {
	return s.String()
}

// SetResultSetMetadata sets the ResultSetMetadata field's value.
func (s *ResultSet) SetResultSetMetadata(v *ResultSetMetadata) *ResultSet {
	s.ResultSetMetadata = v
	return s
}

// SetRows sets the Rows field's value.
func (s *ResultSet) SetRows(v []*Row) *ResultSet {
	s.Rows = v
	return s
}

// The metadata that describes the column structure and data types of a table
// of query results. To return a ResultSetMetadata object, use GetQueryResults.
type ResultSetMetadata struct {
	_ struct{} `type:"structure"`

	// Information about the columns returned in a query result metadata.
	ColumnInfo []*ColumnInfo `type:"list"`
}

// String returns the string representation
func (s ResultSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSetMetadata) GoString() string {
	return s.String()
}

// SetColumnInfo sets the ColumnInfo field's value.
func (s *ResultSetMetadata) SetColumnInfo(v []*ColumnInfo) *ResultSetMetadata {
	s.ColumnInfo = v
	return s
}

// The rows that comprise a query result table.
type Row struct {
	_ struct{} `type:"structure"`

	// The data that populates a row in a query result table.
	Data []*Datum `type:"list"`
}

// String returns the string representation
func (s Row) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Row) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Row) SetData(v []*Datum) *Row {
	s.Data = v
	return s
}

type StartQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure the request to create the query
	// is idempotent (executes only once). If another StartQueryExecution request
	// is received, the same response is returned and another query is not created.
	// If a parameter has changed, for example, the QueryString, an error is returned.
	//
	// This token is listed as not required because AWS SDKs (for example the AWS
	// SDK for Java) auto-generate the token for users. If you are not using the
	// AWS SDK or the AWS CLI, you must provide this token or the action will fail.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The database within which the query executes.
	QueryExecutionContext *QueryExecutionContext `type:"structure"`

	// The SQL query statements to be executed.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// Specifies information about where and how to save the results of the query
	// execution. If the query runs in a workgroup, then workgroup's settings may
	// override query settings. This affects the query results location. The workgroup
	// settings override is specified in EnforceWorkGroupConfiguration (true/false)
	// in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	ResultConfiguration *ResultConfiguration `type:"structure"`

	// The name of the workgroup in which the query is being started.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s StartQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartQueryExecutionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.QueryExecutionContext != nil {
		if err := s.QueryExecutionContext.Validate(); err != nil {
			invalidParams.AddNested("QueryExecutionContext", err.(request.ErrInvalidParams))
		}
	}
	if s.ResultConfiguration != nil {
		if err := s.ResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResultConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartQueryExecutionInput) SetClientRequestToken(v string) *StartQueryExecutionInput {
	s.ClientRequestToken = &v
	return s
}

// SetQueryExecutionContext sets the QueryExecutionContext field's value.
func (s *StartQueryExecutionInput) SetQueryExecutionContext(v *QueryExecutionContext) *StartQueryExecutionInput {
	s.QueryExecutionContext = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *StartQueryExecutionInput) SetQueryString(v string) *StartQueryExecutionInput {
	s.QueryString = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *StartQueryExecutionInput) SetResultConfiguration(v *ResultConfiguration) *StartQueryExecutionInput {
	s.ResultConfiguration = v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *StartQueryExecutionInput) SetWorkGroup(v string) *StartQueryExecutionInput {
	s.WorkGroup = &v
	return s
}

type StartQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query that ran as a result of this request.
	QueryExecutionId *string `type:"string"`
}

// String returns the string representation
func (s StartQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *StartQueryExecutionOutput) SetQueryExecutionId(v string) *StartQueryExecutionOutput {
	s.QueryExecutionId = &v
	return s
}

type StopQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query execution to stop.
	QueryExecutionId *string `type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s StopQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopQueryExecutionInput) GoString() string {
	return s.String()
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *StopQueryExecutionInput) SetQueryExecutionId(v string) *StopQueryExecutionInput {
	s.QueryExecutionId = &v
	return s
}

type StopQueryExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopQueryExecutionOutput) GoString() string {
	return s.String()
}

// Contains metadata for a table.
type TableMetadata struct {
	_ struct{} `type:"structure"`

	// A list of the columns in the table.
	Columns []*Column `type:"list"`

	// The time that the table was created.
	CreateTime *time.Time `type:"timestamp"`

	// The last time the table was accessed.
	LastAccessTime *time.Time `type:"timestamp"`

	// The name of the table.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A set of custom key/value pairs for table properties.
	Parameters map[string]*string `type:"map"`

	// A list of the partition keys in the table.
	PartitionKeys []*Column `type:"list"`

	// The type of table. In Athena, only EXTERNAL_TABLE is supported.
	TableType *string `type:"string"`
}

// String returns the string representation
func (s TableMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableMetadata) GoString() string {
	return s.String()
}

// SetColumns sets the Columns field's value.
func (s *TableMetadata) SetColumns(v []*Column) *TableMetadata {
	s.Columns = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *TableMetadata) SetCreateTime(v time.Time) *TableMetadata {
	s.CreateTime = &v
	return s
}

// SetLastAccessTime sets the LastAccessTime field's value.
func (s *TableMetadata) SetLastAccessTime(v time.Time) *TableMetadata {
	s.LastAccessTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *TableMetadata) SetName(v string) *TableMetadata {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *TableMetadata) SetParameters(v map[string]*string) *TableMetadata {
	s.Parameters = v
	return s
}

// SetPartitionKeys sets the PartitionKeys field's value.
func (s *TableMetadata) SetPartitionKeys(v []*Column) *TableMetadata {
	s.PartitionKeys = v
	return s
}

// SetTableType sets the TableType field's value.
func (s *TableMetadata) SetTableType(v string) *TableMetadata {
	s.TableType = &v
	return s
}

// A label that you assign to a resource. In Athena, a resource can be a workgroup
// or data catalog. Each tag consists of a key and an optional value, both of
// which you define. For example, you can use tags to categorize Athena workgroups
// or data catalogs by purpose, owner, or environment. Use a consistent set
// of tag keys to make it easier to search and filter workgroups or data catalogs
// in your account. For best practices, see Tagging Best Practices (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
// Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can
// be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers
// representable in UTF-8, and the following characters: + - = . _ : / @. Tag
// keys and values are case-sensitive. Tag keys must be unique per resource.
// If you specify more than one tag, separate them by commas.
type Tag struct {
	_ struct{} `type:"structure"`

	// A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8.
	// You can use letters and numbers representable in UTF-8, and the following
	// characters: + - = . _ : / @. Tag keys are case-sensitive and must be unique
	// per resource.
	Key *string `min:"1" type:"string"`

	// A tag value. The tag value length is from 0 to 256 Unicode characters in
	// UTF-8. You can use letters and numbers representable in UTF-8, and the following
	// characters: + - = . _ : / @. Tag values are case-sensitive.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the Athena resource (workgroup or data catalog) to which
	// tags are to be added.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A collection of one or more tags, separated by commas, to be added to an
	// Athena workgroup or data catalog resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Indicates that the request was throttled.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the query throttling, for example, when it exceeds the concurrent
	// query limit.
	Reason *string `type:"string" enum:"ThrottleReason"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a named query ID that could not be processed.
type UnprocessedNamedQueryId struct {
	_ struct{} `type:"structure"`

	// The error code returned when the processing request for the named query failed,
	// if applicable.
	ErrorCode *string `min:"1" type:"string"`

	// The error message returned when the processing request for the named query
	// failed, if applicable.
	ErrorMessage *string `type:"string"`

	// The unique identifier of the named query.
	NamedQueryId *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedNamedQueryId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedNamedQueryId) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedNamedQueryId) SetErrorCode(v string) *UnprocessedNamedQueryId {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedNamedQueryId) SetErrorMessage(v string) *UnprocessedNamedQueryId {
	s.ErrorMessage = &v
	return s
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *UnprocessedNamedQueryId) SetNamedQueryId(v string) *UnprocessedNamedQueryId {
	s.NamedQueryId = &v
	return s
}

// Describes a query execution that failed to process.
type UnprocessedQueryExecutionId struct {
	_ struct{} `type:"structure"`

	// The error code returned when the query execution failed to process, if applicable.
	ErrorCode *string `min:"1" type:"string"`

	// The error message returned when the query execution failed to process, if
	// applicable.
	ErrorMessage *string `type:"string"`

	// The unique identifier of the query execution.
	QueryExecutionId *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedQueryExecutionId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedQueryExecutionId) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedQueryExecutionId) SetErrorCode(v string) *UnprocessedQueryExecutionId {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedQueryExecutionId) SetErrorMessage(v string) *UnprocessedQueryExecutionId {
	s.ErrorMessage = &v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *UnprocessedQueryExecutionId) SetQueryExecutionId(v string) *UnprocessedQueryExecutionId {
	s.QueryExecutionId = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the resource from which tags are to be removed.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A comma-separated list of one or more tag keys whose tags are to be removed
	// from the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// New or modified text that describes the data catalog.
	Description *string `min:"1" type:"string"`

	// The name of the data catalog to update. The catalog name must be unique for
	// the AWS account and can use a maximum of 128 alphanumeric, underscore, at
	// sign, or hyphen characters.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the Lambda function or functions to use for updating the data catalog.
	// This is a mapping whose values depend on the catalog type.
	//
	//    * For the HIVE data catalog type, use the following syntax. The metadata-function
	//    parameter is required. The sdk-version parameter is optional and defaults
	//    to the currently supported version. metadata-function=lambda_arn, sdk-version=version_number
	//
	//    * For the LAMBDA data catalog type, use one of the following sets of required
	//    parameters, but not both. If you have one Lambda function that processes
	//    metadata and another for reading the actual data, use the following syntax.
	//    Both parameters are required. metadata-function=lambda_arn, record-function=lambda_arn
	//    If you have a composite Lambda function that processes both metadata and
	//    data, use the following syntax to specify your Lambda function. function=lambda_arn
	Parameters map[string]*string `type:"map"`

	// Specifies the type of data catalog to update. Specify LAMBDA for a federated
	// catalog or HIVE for an external hive metastore.
	//
	// Do not use the GLUE type. This refers to the AwsDataCatalog that already
	// exists in your account, of which you can have only one. Specifying the GLUE
	// type will result in an INVALID_INPUT error.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataCatalogType"`
}

// String returns the string representation
func (s UpdateDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataCatalogInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDataCatalogInput) SetDescription(v string) *UpdateDataCatalogInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataCatalogInput) SetName(v string) *UpdateDataCatalogInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateDataCatalogInput) SetParameters(v map[string]*string) *UpdateDataCatalogInput {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateDataCatalogInput) SetType(v string) *UpdateDataCatalogInput {
	s.Type = &v
	return s
}

type UpdateDataCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataCatalogOutput) GoString() string {
	return s.String()
}

type UpdateWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The workgroup configuration that will be updated for the given workgroup.
	ConfigurationUpdates *WorkGroupConfigurationUpdates `type:"structure"`

	// The workgroup description.
	Description *string `type:"string"`

	// The workgroup state that will be updated for the given workgroup.
	State *string `type:"string" enum:"WorkGroupState"`

	// The specified workgroup that will be updated.
	//
	// WorkGroup is a required field
	WorkGroup *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkGroupInput"}
	if s.WorkGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkGroup"))
	}
	if s.ConfigurationUpdates != nil {
		if err := s.ConfigurationUpdates.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationUpdates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationUpdates sets the ConfigurationUpdates field's value.
func (s *UpdateWorkGroupInput) SetConfigurationUpdates(v *WorkGroupConfigurationUpdates) *UpdateWorkGroupInput {
	s.ConfigurationUpdates = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkGroupInput) SetDescription(v string) *UpdateWorkGroupInput {
	s.Description = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateWorkGroupInput) SetState(v string) *UpdateWorkGroupInput {
	s.State = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *UpdateWorkGroupInput) SetWorkGroup(v string) *UpdateWorkGroupInput {
	s.WorkGroup = &v
	return s
}

type UpdateWorkGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorkGroupOutput) GoString() string {
	return s.String()
}

// A workgroup, which contains a name, description, creation time, state, and
// other configuration, listed under WorkGroup$Configuration. Each workgroup
// enables you to isolate queries for you or your group of users from other
// queries in the same account, to configure the query results location and
// the encryption configuration (known as workgroup settings), to enable sending
// query metrics to Amazon CloudWatch, and to establish per-query data usage
// control limits for all queries in a workgroup. The workgroup settings override
// is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration.
// See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
type WorkGroup struct {
	_ struct{} `type:"structure"`

	// The configuration of the workgroup, which includes the location in Amazon
	// S3 where query results are stored, the encryption configuration, if any,
	// used for query results; whether the Amazon CloudWatch Metrics are enabled
	// for the workgroup; whether workgroup settings override client-side settings;
	// and the data usage limits for the amount of data scanned per query or per
	// workgroup. The workgroup settings override is specified in EnforceWorkGroupConfiguration
	// (true/false) in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	Configuration *WorkGroupConfiguration `type:"structure"`

	// The date and time the workgroup was created.
	CreationTime *time.Time `type:"timestamp"`

	// The workgroup description.
	Description *string `type:"string"`

	// The workgroup name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The state of the workgroup: ENABLED or DISABLED.
	State *string `type:"string" enum:"WorkGroupState"`
}

// String returns the string representation
func (s WorkGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroup) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *WorkGroup) SetConfiguration(v *WorkGroupConfiguration) *WorkGroup {
	s.Configuration = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkGroup) SetCreationTime(v time.Time) *WorkGroup {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkGroup) SetDescription(v string) *WorkGroup {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkGroup) SetName(v string) *WorkGroup {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkGroup) SetState(v string) *WorkGroup {
	s.State = &v
	return s
}

// The configuration of the workgroup, which includes the location in Amazon
// S3 where query results are stored, the encryption option, if any, used for
// query results, whether the Amazon CloudWatch Metrics are enabled for the
// workgroup and whether workgroup settings override query settings, and the
// data usage limits for the amount of data scanned per query or per workgroup.
// The workgroup settings override is specified in EnforceWorkGroupConfiguration
// (true/false) in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
type WorkGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The upper data usage limit (cutoff) for the amount of bytes a single query
	// in a workgroup is allowed to scan.
	BytesScannedCutoffPerQuery *int64 `min:"1e+07" type:"long"`

	// If set to "true", the settings for the workgroup override client-side settings.
	// If set to "false", client-side settings are used. For more information, see
	// Workgroup Settings Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	EnforceWorkGroupConfiguration *bool `type:"boolean"`

	// The engine version that all queries running on the workgroup use. Queries
	// on the AmazonAthenaPreviewFunctionality workgroup run on the preview engine
	// regardless of this setting.
	EngineVersion *EngineVersion `type:"structure"`

	// Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
	PublishCloudWatchMetricsEnabled *bool `type:"boolean"`

	// If set to true, allows members assigned to a workgroup to reference Amazon
	// S3 Requester Pays buckets in queries. If set to false, workgroup members
	// cannot query data from Requester Pays buckets, and queries that retrieve
	// data from Requester Pays buckets cause an error. The default is false. For
	// more information about Requester Pays buckets, see Requester Pays Buckets
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html)
	// in the Amazon Simple Storage Service Developer Guide.
	RequesterPaysEnabled *bool `type:"boolean"`

	// The configuration for the workgroup, which includes the location in Amazon
	// S3 where query results are stored and the encryption option, if any, used
	// for query results. To run the query, you must specify the query results location
	// using one of the ways: either in the workgroup using this setting, or for
	// individual queries (client-side), using ResultConfiguration$OutputLocation.
	// If none of them is set, Athena issues an error that no output location is
	// provided. For more information, see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html).
	ResultConfiguration *ResultConfiguration `type:"structure"`
}

// String returns the string representation
func (s WorkGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkGroupConfiguration"}
	if s.BytesScannedCutoffPerQuery != nil && *s.BytesScannedCutoffPerQuery < 1e+07 {
		invalidParams.Add(request.NewErrParamMinValue("BytesScannedCutoffPerQuery", 1e+07))
	}
	if s.EngineVersion != nil {
		if err := s.EngineVersion.Validate(); err != nil {
			invalidParams.AddNested("EngineVersion", err.(request.ErrInvalidParams))
		}
	}
	if s.ResultConfiguration != nil {
		if err := s.ResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResultConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytesScannedCutoffPerQuery sets the BytesScannedCutoffPerQuery field's value.
func (s *WorkGroupConfiguration) SetBytesScannedCutoffPerQuery(v int64) *WorkGroupConfiguration {
	s.BytesScannedCutoffPerQuery = &v
	return s
}

// SetEnforceWorkGroupConfiguration sets the EnforceWorkGroupConfiguration field's value.
func (s *WorkGroupConfiguration) SetEnforceWorkGroupConfiguration(v bool) *WorkGroupConfiguration {
	s.EnforceWorkGroupConfiguration = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *WorkGroupConfiguration) SetEngineVersion(v *EngineVersion) *WorkGroupConfiguration {
	s.EngineVersion = v
	return s
}

// SetPublishCloudWatchMetricsEnabled sets the PublishCloudWatchMetricsEnabled field's value.
func (s *WorkGroupConfiguration) SetPublishCloudWatchMetricsEnabled(v bool) *WorkGroupConfiguration {
	s.PublishCloudWatchMetricsEnabled = &v
	return s
}

// SetRequesterPaysEnabled sets the RequesterPaysEnabled field's value.
func (s *WorkGroupConfiguration) SetRequesterPaysEnabled(v bool) *WorkGroupConfiguration {
	s.RequesterPaysEnabled = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *WorkGroupConfiguration) SetResultConfiguration(v *ResultConfiguration) *WorkGroupConfiguration {
	s.ResultConfiguration = v
	return s
}

// The configuration information that will be updated for this workgroup, which
// includes the location in Amazon S3 where query results are stored, the encryption
// option, if any, used for query results, whether the Amazon CloudWatch Metrics
// are enabled for the workgroup, whether the workgroup settings override the
// client-side settings, and the data usage limit for the amount of bytes scanned
// per query, if it is specified.
type WorkGroupConfigurationUpdates struct {
	_ struct{} `type:"structure"`

	// The upper limit (cutoff) for the amount of bytes a single query in a workgroup
	// is allowed to scan.
	BytesScannedCutoffPerQuery *int64 `min:"1e+07" type:"long"`

	// If set to "true", the settings for the workgroup override client-side settings.
	// If set to "false" client-side settings are used. For more information, see
	// Workgroup Settings Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	EnforceWorkGroupConfiguration *bool `type:"boolean"`

	// The engine version requested when a workgroup is updated. After the update,
	// all queries on the workgroup run on the requested engine version. If no value
	// was previously set, the default is Auto. Queries on the AmazonAthenaPreviewFunctionality
	// workgroup run on the preview engine regardless of this setting.
	EngineVersion *EngineVersion `type:"structure"`

	// Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
	PublishCloudWatchMetricsEnabled *bool `type:"boolean"`

	// Indicates that the data usage control limit per query is removed. WorkGroupConfiguration$BytesScannedCutoffPerQuery
	RemoveBytesScannedCutoffPerQuery *bool `type:"boolean"`

	// If set to true, allows members assigned to a workgroup to specify Amazon
	// S3 Requester Pays buckets in queries. If set to false, workgroup members
	// cannot query data from Requester Pays buckets, and queries that retrieve
	// data from Requester Pays buckets cause an error. The default is false. For
	// more information about Requester Pays buckets, see Requester Pays Buckets
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html)
	// in the Amazon Simple Storage Service Developer Guide.
	RequesterPaysEnabled *bool `type:"boolean"`

	// The result configuration information about the queries in this workgroup
	// that will be updated. Includes the updated results location and an updated
	// option for encrypting query results.
	ResultConfigurationUpdates *ResultConfigurationUpdates `type:"structure"`
}

// String returns the string representation
func (s WorkGroupConfigurationUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroupConfigurationUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkGroupConfigurationUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkGroupConfigurationUpdates"}
	if s.BytesScannedCutoffPerQuery != nil && *s.BytesScannedCutoffPerQuery < 1e+07 {
		invalidParams.Add(request.NewErrParamMinValue("BytesScannedCutoffPerQuery", 1e+07))
	}
	if s.EngineVersion != nil {
		if err := s.EngineVersion.Validate(); err != nil {
			invalidParams.AddNested("EngineVersion", err.(request.ErrInvalidParams))
		}
	}
	if s.ResultConfigurationUpdates != nil {
		if err := s.ResultConfigurationUpdates.Validate(); err != nil {
			invalidParams.AddNested("ResultConfigurationUpdates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytesScannedCutoffPerQuery sets the BytesScannedCutoffPerQuery field's value.
func (s *WorkGroupConfigurationUpdates) SetBytesScannedCutoffPerQuery(v int64) *WorkGroupConfigurationUpdates {
	s.BytesScannedCutoffPerQuery = &v
	return s
}

// SetEnforceWorkGroupConfiguration sets the EnforceWorkGroupConfiguration field's value.
func (s *WorkGroupConfigurationUpdates) SetEnforceWorkGroupConfiguration(v bool) *WorkGroupConfigurationUpdates {
	s.EnforceWorkGroupConfiguration = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *WorkGroupConfigurationUpdates) SetEngineVersion(v *EngineVersion) *WorkGroupConfigurationUpdates {
	s.EngineVersion = v
	return s
}

// SetPublishCloudWatchMetricsEnabled sets the PublishCloudWatchMetricsEnabled field's value.
func (s *WorkGroupConfigurationUpdates) SetPublishCloudWatchMetricsEnabled(v bool) *WorkGroupConfigurationUpdates {
	s.PublishCloudWatchMetricsEnabled = &v
	return s
}

// SetRemoveBytesScannedCutoffPerQuery sets the RemoveBytesScannedCutoffPerQuery field's value.
func (s *WorkGroupConfigurationUpdates) SetRemoveBytesScannedCutoffPerQuery(v bool) *WorkGroupConfigurationUpdates {
	s.RemoveBytesScannedCutoffPerQuery = &v
	return s
}

// SetRequesterPaysEnabled sets the RequesterPaysEnabled field's value.
func (s *WorkGroupConfigurationUpdates) SetRequesterPaysEnabled(v bool) *WorkGroupConfigurationUpdates {
	s.RequesterPaysEnabled = &v
	return s
}

// SetResultConfigurationUpdates sets the ResultConfigurationUpdates field's value.
func (s *WorkGroupConfigurationUpdates) SetResultConfigurationUpdates(v *ResultConfigurationUpdates) *WorkGroupConfigurationUpdates {
	s.ResultConfigurationUpdates = v
	return s
}

// The summary information for the workgroup, which includes its name, state,
// description, and the date and time it was created.
type WorkGroupSummary struct {
	_ struct{} `type:"structure"`

	// The workgroup creation date and time.
	CreationTime *time.Time `type:"timestamp"`

	// The workgroup description.
	Description *string `type:"string"`

	// The engine version setting for all queries on the workgroup. Queries on the
	// AmazonAthenaPreviewFunctionality workgroup run on the preview engine regardless
	// of this setting.
	EngineVersion *EngineVersion `type:"structure"`

	// The name of the workgroup.
	Name *string `type:"string"`

	// The state of the workgroup.
	State *string `type:"string" enum:"WorkGroupState"`
}

// String returns the string representation
func (s WorkGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroupSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkGroupSummary) SetCreationTime(v time.Time) *WorkGroupSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkGroupSummary) SetDescription(v string) *WorkGroupSummary {
	s.Description = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *WorkGroupSummary) SetEngineVersion(v *EngineVersion) *WorkGroupSummary {
	s.EngineVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *WorkGroupSummary) SetName(v string) *WorkGroupSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkGroupSummary) SetState(v string) *WorkGroupSummary {
	s.State = &v
	return s
}

const (
	// ColumnNullableNotNull is a ColumnNullable enum value
	ColumnNullableNotNull = "NOT_NULL"

	// ColumnNullableNullable is a ColumnNullable enum value
	ColumnNullableNullable = "NULLABLE"

	// ColumnNullableUnknown is a ColumnNullable enum value
	ColumnNullableUnknown = "UNKNOWN"
)

// ColumnNullable_Values returns all elements of the ColumnNullable enum
func ColumnNullable_Values() []string {
	return []string{
		ColumnNullableNotNull,
		ColumnNullableNullable,
		ColumnNullableUnknown,
	}
}

const (
	// DataCatalogTypeLambda is a DataCatalogType enum value
	DataCatalogTypeLambda = "LAMBDA"

	// DataCatalogTypeGlue is a DataCatalogType enum value
	DataCatalogTypeGlue = "GLUE"

	// DataCatalogTypeHive is a DataCatalogType enum value
	DataCatalogTypeHive = "HIVE"
)

// DataCatalogType_Values returns all elements of the DataCatalogType enum
func DataCatalogType_Values() []string {
	return []string{
		DataCatalogTypeLambda,
		DataCatalogTypeGlue,
		DataCatalogTypeHive,
	}
}

const (
	// EncryptionOptionSseS3 is a EncryptionOption enum value
	EncryptionOptionSseS3 = "SSE_S3"

	// EncryptionOptionSseKms is a EncryptionOption enum value
	EncryptionOptionSseKms = "SSE_KMS"

	// EncryptionOptionCseKms is a EncryptionOption enum value
	EncryptionOptionCseKms = "CSE_KMS"
)

// EncryptionOption_Values returns all elements of the EncryptionOption enum
func EncryptionOption_Values() []string {
	return []string{
		EncryptionOptionSseS3,
		EncryptionOptionSseKms,
		EncryptionOptionCseKms,
	}
}

const (
	// QueryExecutionStateQueued is a QueryExecutionState enum value
	QueryExecutionStateQueued = "QUEUED"

	// QueryExecutionStateRunning is a QueryExecutionState enum value
	QueryExecutionStateRunning = "RUNNING"

	// QueryExecutionStateSucceeded is a QueryExecutionState enum value
	QueryExecutionStateSucceeded = "SUCCEEDED"

	// QueryExecutionStateFailed is a QueryExecutionState enum value
	QueryExecutionStateFailed = "FAILED"

	// QueryExecutionStateCancelled is a QueryExecutionState enum value
	QueryExecutionStateCancelled = "CANCELLED"
)

// QueryExecutionState_Values returns all elements of the QueryExecutionState enum
func QueryExecutionState_Values() []string {
	return []string{
		QueryExecutionStateQueued,
		QueryExecutionStateRunning,
		QueryExecutionStateSucceeded,
		QueryExecutionStateFailed,
		QueryExecutionStateCancelled,
	}
}

const (
	// StatementTypeDdl is a StatementType enum value
	StatementTypeDdl = "DDL"

	// StatementTypeDml is a StatementType enum value
	StatementTypeDml = "DML"

	// StatementTypeUtility is a StatementType enum value
	StatementTypeUtility = "UTILITY"
)

// StatementType_Values returns all elements of the StatementType enum
func StatementType_Values() []string {
	return []string{
		StatementTypeDdl,
		StatementTypeDml,
		StatementTypeUtility,
	}
}

// The reason for the query throttling, for example, when it exceeds the concurrent
// query limit.
const (
	// ThrottleReasonConcurrentQueryLimitExceeded is a ThrottleReason enum value
	ThrottleReasonConcurrentQueryLimitExceeded = "CONCURRENT_QUERY_LIMIT_EXCEEDED"
)

// ThrottleReason_Values returns all elements of the ThrottleReason enum
func ThrottleReason_Values() []string {
	return []string{
		ThrottleReasonConcurrentQueryLimitExceeded,
	}
}

const (
	// WorkGroupStateEnabled is a WorkGroupState enum value
	WorkGroupStateEnabled = "ENABLED"

	// WorkGroupStateDisabled is a WorkGroupState enum value
	WorkGroupStateDisabled = "DISABLED"
)

// WorkGroupState_Values returns all elements of the WorkGroupState enum
func WorkGroupState_Values() []string {
	return []string{
		WorkGroupStateEnabled,
		WorkGroupStateDisabled,
	}
}
