package guestconfiguration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// HCRPAssignmentsClient is the guest Configuration Client
type HCRPAssignmentsClient struct {
	BaseClient
}

// NewHCRPAssignmentsClient creates an instance of the HCRPAssignmentsClient client.
func NewHCRPAssignmentsClient(subscriptionID string) HCRPAssignmentsClient {
	return NewHCRPAssignmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewHCRPAssignmentsClientWithBaseURI creates an instance of the HCRPAssignmentsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewHCRPAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) HCRPAssignmentsClient {
	return HCRPAssignmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates an association between a ARC machine and guest configuration
// Parameters:
// guestConfigurationAssignmentName - name of the guest configuration assignment.
// parameters - parameters supplied to the create or update guest configuration assignment.
// resourceGroupName - the resource group name.
// machineName - the name of the ARC machine.
func (client HCRPAssignmentsClient) CreateOrUpdate(ctx context.Context, guestConfigurationAssignmentName string, parameters Assignment, resourceGroupName string, machineName string) (result HCRPAssignmentsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HCRPAssignmentsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("guestconfiguration.HCRPAssignmentsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, guestConfigurationAssignmentName, parameters, resourceGroupName, machineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "CreateOrUpdate", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client HCRPAssignmentsClient) CreateOrUpdatePreparer(ctx context.Context, guestConfigurationAssignmentName string, parameters Assignment, resourceGroupName string, machineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"guestConfigurationAssignmentName": autorest.Encode("path", guestConfigurationAssignmentName),
		"machineName":                      autorest.Encode("path", machineName),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-06-25"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/{guestConfigurationAssignmentName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client HCRPAssignmentsClient) CreateOrUpdateSender(req *http.Request) (future HCRPAssignmentsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client HCRPAssignmentsClient) (a Assignment, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("guestconfiguration.HCRPAssignmentsCreateOrUpdateFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		a.Response.Response, err = future.GetResult(sender)
		if a.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsCreateOrUpdateFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
			a, err = client.CreateOrUpdateResponder(a.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client HCRPAssignmentsClient) CreateOrUpdateResponder(resp *http.Response) (result Assignment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a guest configuration assignment
// Parameters:
// resourceGroupName - the resource group name.
// guestConfigurationAssignmentName - name of the guest configuration assignment
// machineName - the name of the ARC machine.
func (client HCRPAssignmentsClient) Delete(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result HCRPAssignmentsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HCRPAssignmentsClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("guestconfiguration.HCRPAssignmentsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, guestConfigurationAssignmentName, machineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "Delete", nil, "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client HCRPAssignmentsClient) DeletePreparer(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"guestConfigurationAssignmentName": autorest.Encode("path", guestConfigurationAssignmentName),
		"machineName":                      autorest.Encode("path", machineName),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-06-25"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/{guestConfigurationAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client HCRPAssignmentsClient) DeleteSender(req *http.Request) (future HCRPAssignmentsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client HCRPAssignmentsClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsDeleteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("guestconfiguration.HCRPAssignmentsDeleteFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client HCRPAssignmentsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get information about a guest configuration assignment
// Parameters:
// resourceGroupName - the resource group name.
// guestConfigurationAssignmentName - the guest configuration assignment name.
// machineName - the name of the ARC machine.
func (client HCRPAssignmentsClient) Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result Assignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HCRPAssignmentsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("guestconfiguration.HCRPAssignmentsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, guestConfigurationAssignmentName, machineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client HCRPAssignmentsClient) GetPreparer(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"guestConfigurationAssignmentName": autorest.Encode("path", guestConfigurationAssignmentName),
		"machineName":                      autorest.Encode("path", machineName),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-06-25"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/{guestConfigurationAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client HCRPAssignmentsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client HCRPAssignmentsClient) GetResponder(resp *http.Response) (result Assignment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list all guest configuration assignments for an ARC machine.
// Parameters:
// resourceGroupName - the resource group name.
// machineName - the name of the ARC machine.
func (client HCRPAssignmentsClient) List(ctx context.Context, resourceGroupName string, machineName string) (result AssignmentList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HCRPAssignmentsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("guestconfiguration.HCRPAssignmentsClient", "List", err.Error())
	}

	req, err := client.ListPreparer(ctx, resourceGroupName, machineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentsClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client HCRPAssignmentsClient) ListPreparer(ctx context.Context, resourceGroupName string, machineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"machineName":       autorest.Encode("path", machineName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-06-25"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client HCRPAssignmentsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client HCRPAssignmentsClient) ListResponder(resp *http.Response) (result AssignmentList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
