package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2019-07-01/network"

// AddressSpace addressSpace contains an array of IP address ranges that can be used by subnets of the
// virtual network.
type AddressSpace struct {
	// AddressPrefixes - A list of address blocks reserved for this virtual network in CIDR notation.
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ApplicationGateway application gateway resource.
type ApplicationGateway struct {
	autorest.Response `json:"-"`
	// ApplicationGatewayPropertiesFormat - Properties of the application gateway.
	*ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Zones - A list of availability zones denoting where the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// Identity - The identity of the application gateway, if configured.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGateway.
func (ag ApplicationGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ApplicationGatewayPropertiesFormat != nil {
		objectMap["properties"] = ag.ApplicationGatewayPropertiesFormat
	}
	if ag.Etag != nil {
		objectMap["etag"] = ag.Etag
	}
	if ag.Zones != nil {
		objectMap["zones"] = ag.Zones
	}
	if ag.Identity != nil {
		objectMap["identity"] = ag.Identity
	}
	if ag.ID != nil {
		objectMap["id"] = ag.ID
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGateway struct.
func (ag *ApplicationGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPropertiesFormat ApplicationGatewayPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				ag.ApplicationGatewayPropertiesFormat = &applicationGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ag.Etag = &etag
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				ag.Zones = &zones
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ag.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificate authentication certificates of an application gateway.
type ApplicationGatewayAuthenticationCertificate struct {
	// ApplicationGatewayAuthenticationCertificatePropertiesFormat - Properties of the application gateway authentication certificate.
	*ApplicationGatewayAuthenticationCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the authentication certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayAuthenticationCertificate.
func (agac ApplicationGatewayAuthenticationCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat != nil {
		objectMap["properties"] = agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat
	}
	if agac.Name != nil {
		objectMap["name"] = agac.Name
	}
	if agac.Etag != nil {
		objectMap["etag"] = agac.Etag
	}
	if agac.Type != nil {
		objectMap["type"] = agac.Type
	}
	if agac.ID != nil {
		objectMap["id"] = agac.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayAuthenticationCertificate struct.
func (agac *ApplicationGatewayAuthenticationCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayAuthenticationCertificatePropertiesFormat ApplicationGatewayAuthenticationCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayAuthenticationCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat = &applicationGatewayAuthenticationCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agac.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agac.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agac.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agac.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat authentication certificates properties of an
// application gateway.
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	// Data - Certificate public data.
	Data *string `json:"data,omitempty"`
	// ProvisioningState - The provisioning state of the authentication certificate resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayAutoscaleConfiguration application Gateway autoscale configuration.
type ApplicationGatewayAutoscaleConfiguration struct {
	// MinCapacity - Lower bound on number of Application Gateway capacity.
	MinCapacity *int32 `json:"minCapacity,omitempty"`
	// MaxCapacity - Upper bound on number of Application Gateway capacity.
	MaxCapacity *int32 `json:"maxCapacity,omitempty"`
}

// ApplicationGatewayAvailableSslOptions response for ApplicationGatewayAvailableSslOptions API service
// call.
type ApplicationGatewayAvailableSslOptions struct {
	autorest.Response `json:"-"`
	// ApplicationGatewayAvailableSslOptionsPropertiesFormat - Properties of the application gateway available SSL options.
	*ApplicationGatewayAvailableSslOptionsPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayAvailableSslOptions.
func (agaso ApplicationGatewayAvailableSslOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agaso.ApplicationGatewayAvailableSslOptionsPropertiesFormat != nil {
		objectMap["properties"] = agaso.ApplicationGatewayAvailableSslOptionsPropertiesFormat
	}
	if agaso.ID != nil {
		objectMap["id"] = agaso.ID
	}
	if agaso.Location != nil {
		objectMap["location"] = agaso.Location
	}
	if agaso.Tags != nil {
		objectMap["tags"] = agaso.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayAvailableSslOptions struct.
func (agaso *ApplicationGatewayAvailableSslOptions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayAvailableSslOptionsPropertiesFormat ApplicationGatewayAvailableSslOptionsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayAvailableSslOptionsPropertiesFormat)
				if err != nil {
					return err
				}
				agaso.ApplicationGatewayAvailableSslOptionsPropertiesFormat = &applicationGatewayAvailableSslOptionsPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agaso.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agaso.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agaso.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agaso.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agaso.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayAvailableSslOptionsPropertiesFormat properties of
// ApplicationGatewayAvailableSslOptions.
type ApplicationGatewayAvailableSslOptionsPropertiesFormat struct {
	// PredefinedPolicies - List of available Ssl predefined policy.
	PredefinedPolicies *[]SubResource `json:"predefinedPolicies,omitempty"`
	// DefaultPolicy - Name of the Ssl predefined policy applied by default to application gateway. Possible values include: 'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401', 'AppGwSslPolicy20170401S'
	DefaultPolicy ApplicationGatewaySslPolicyName `json:"defaultPolicy,omitempty"`
	// AvailableCipherSuites - List of available Ssl cipher suites.
	AvailableCipherSuites *[]ApplicationGatewaySslCipherSuite `json:"availableCipherSuites,omitempty"`
	// AvailableProtocols - List of available Ssl protocols.
	AvailableProtocols *[]ApplicationGatewaySslProtocol `json:"availableProtocols,omitempty"`
}

// ApplicationGatewayAvailableSslPredefinedPolicies response for ApplicationGatewayAvailableSslOptions API
// service call.
type ApplicationGatewayAvailableSslPredefinedPolicies struct {
	autorest.Response `json:"-"`
	// Value - List of available Ssl predefined policy.
	Value *[]ApplicationGatewaySslPredefinedPolicy `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayAvailableSslPredefinedPoliciesIterator provides access to a complete listing of
// ApplicationGatewaySslPredefinedPolicy values.
type ApplicationGatewayAvailableSslPredefinedPoliciesIterator struct {
	i    int
	page ApplicationGatewayAvailableSslPredefinedPoliciesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayAvailableSslPredefinedPoliciesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayAvailableSslPredefinedPoliciesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayAvailableSslPredefinedPoliciesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayAvailableSslPredefinedPoliciesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayAvailableSslPredefinedPoliciesIterator) Response() ApplicationGatewayAvailableSslPredefinedPolicies {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayAvailableSslPredefinedPoliciesIterator) Value() ApplicationGatewaySslPredefinedPolicy {
	if !iter.page.NotDone() {
		return ApplicationGatewaySslPredefinedPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayAvailableSslPredefinedPoliciesIterator type.
func NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page ApplicationGatewayAvailableSslPredefinedPoliciesPage) ApplicationGatewayAvailableSslPredefinedPoliciesIterator {
	return ApplicationGatewayAvailableSslPredefinedPoliciesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agaspp ApplicationGatewayAvailableSslPredefinedPolicies) IsEmpty() bool {
	return agaspp.Value == nil || len(*agaspp.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (agaspp ApplicationGatewayAvailableSslPredefinedPolicies) hasNextLink() bool {
	return agaspp.NextLink != nil && len(*agaspp.NextLink) != 0
}

// applicationGatewayAvailableSslPredefinedPoliciesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agaspp ApplicationGatewayAvailableSslPredefinedPolicies) applicationGatewayAvailableSslPredefinedPoliciesPreparer(ctx context.Context) (*http.Request, error) {
	if !agaspp.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agaspp.NextLink)))
}

// ApplicationGatewayAvailableSslPredefinedPoliciesPage contains a page of
// ApplicationGatewaySslPredefinedPolicy values.
type ApplicationGatewayAvailableSslPredefinedPoliciesPage struct {
	fn     func(context.Context, ApplicationGatewayAvailableSslPredefinedPolicies) (ApplicationGatewayAvailableSslPredefinedPolicies, error)
	agaspp ApplicationGatewayAvailableSslPredefinedPolicies
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayAvailableSslPredefinedPoliciesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayAvailableSslPredefinedPoliciesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.agaspp)
		if err != nil {
			return err
		}
		page.agaspp = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayAvailableSslPredefinedPoliciesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayAvailableSslPredefinedPoliciesPage) NotDone() bool {
	return !page.agaspp.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayAvailableSslPredefinedPoliciesPage) Response() ApplicationGatewayAvailableSslPredefinedPolicies {
	return page.agaspp
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayAvailableSslPredefinedPoliciesPage) Values() []ApplicationGatewaySslPredefinedPolicy {
	if page.agaspp.IsEmpty() {
		return nil
	}
	return *page.agaspp.Value
}

// Creates a new instance of the ApplicationGatewayAvailableSslPredefinedPoliciesPage type.
func NewApplicationGatewayAvailableSslPredefinedPoliciesPage(cur ApplicationGatewayAvailableSslPredefinedPolicies, getNextPage func(context.Context, ApplicationGatewayAvailableSslPredefinedPolicies) (ApplicationGatewayAvailableSslPredefinedPolicies, error)) ApplicationGatewayAvailableSslPredefinedPoliciesPage {
	return ApplicationGatewayAvailableSslPredefinedPoliciesPage{
		fn:     getNextPage,
		agaspp: cur,
	}
}

// ApplicationGatewayAvailableWafRuleSetsResult response for ApplicationGatewayAvailableWafRuleSets API
// service call.
type ApplicationGatewayAvailableWafRuleSetsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of application gateway rule sets.
	Value *[]ApplicationGatewayFirewallRuleSet `json:"value,omitempty"`
}

// ApplicationGatewayBackendAddress backend address of an application gateway.
type ApplicationGatewayBackendAddress struct {
	// Fqdn - Fully qualified domain name (FQDN).
	Fqdn *string `json:"fqdn,omitempty"`
	// IPAddress - IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPool struct {
	// ApplicationGatewayBackendAddressPoolPropertiesFormat - Properties of the application gateway backend address pool.
	*ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the backend address pool that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendAddressPool.
func (agbap ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat
	}
	if agbap.Name != nil {
		objectMap["name"] = agbap.Name
	}
	if agbap.Etag != nil {
		objectMap["etag"] = agbap.Etag
	}
	if agbap.Type != nil {
		objectMap["type"] = agbap.Type
	}
	if agbap.ID != nil {
		objectMap["id"] = agbap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendAddressPool struct.
func (agbap *ApplicationGatewayBackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendAddressPoolPropertiesFormat ApplicationGatewayBackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat = &applicationGatewayBackendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbap.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agbap.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbap.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat properties of Backend Address Pool of an
// application gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Collection of references to IPs defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// BackendAddresses - Backend addresses.
	BackendAddresses *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	// ProvisioningState - The provisioning state of the backend address pool resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendHealth response for ApplicationGatewayBackendHealth API service call.
type ApplicationGatewayBackendHealth struct {
	autorest.Response `json:"-"`
	// BackendAddressPools - A list of ApplicationGatewayBackendHealthPool resources.
	BackendAddressPools *[]ApplicationGatewayBackendHealthPool `json:"backendAddressPools,omitempty"`
}

// ApplicationGatewayBackendHealthHTTPSettings application gateway BackendHealthHttp settings.
type ApplicationGatewayBackendHealthHTTPSettings struct {
	// BackendHTTPSettings - Reference of an ApplicationGatewayBackendHttpSettings resource.
	BackendHTTPSettings *ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettings,omitempty"`
	// Servers - List of ApplicationGatewayBackendHealthServer resources.
	Servers *[]ApplicationGatewayBackendHealthServer `json:"servers,omitempty"`
}

// ApplicationGatewayBackendHealthOnDemand result of on demand test probe.
type ApplicationGatewayBackendHealthOnDemand struct {
	autorest.Response `json:"-"`
	// BackendAddressPool - Reference of an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool `json:"backendAddressPool,omitempty"`
	// BackendHealthHTTPSettings - Application gateway BackendHealthHttp settings.
	BackendHealthHTTPSettings *ApplicationGatewayBackendHealthHTTPSettings `json:"backendHealthHttpSettings,omitempty"`
}

// ApplicationGatewayBackendHealthPool application gateway BackendHealth pool.
type ApplicationGatewayBackendHealthPool struct {
	// BackendAddressPool - Reference of an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettingsCollection - List of ApplicationGatewayBackendHealthHttpSettings resources.
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHealthHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
}

// ApplicationGatewayBackendHealthServer application gateway backendhealth http settings.
type ApplicationGatewayBackendHealthServer struct {
	// Address - IP address or FQDN of backend server.
	Address *string `json:"address,omitempty"`
	// IPConfiguration - Reference of IP configuration of backend server.
	IPConfiguration *InterfaceIPConfiguration `json:"ipConfiguration,omitempty"`
	// Health - Health of backend server. Possible values include: 'Unknown', 'Up', 'Down', 'Partial', 'Draining'
	Health ApplicationGatewayBackendHealthServerHealth `json:"health,omitempty"`
	// HealthProbeLog - Health Probe Log.
	HealthProbeLog *string `json:"healthProbeLog,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettings struct {
	// ApplicationGatewayBackendHTTPSettingsPropertiesFormat - Properties of the application gateway backend HTTP settings.
	*ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the backend http settings that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendHTTPSettings.
func (agbhs ApplicationGatewayBackendHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat != nil {
		objectMap["properties"] = agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
	}
	if agbhs.Name != nil {
		objectMap["name"] = agbhs.Name
	}
	if agbhs.Etag != nil {
		objectMap["etag"] = agbhs.Etag
	}
	if agbhs.Type != nil {
		objectMap["type"] = agbhs.Type
	}
	if agbhs.ID != nil {
		objectMap["id"] = agbhs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendHTTPSettings struct.
func (agbhs *ApplicationGatewayBackendHTTPSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendHTTPSettingsPropertiesFormat ApplicationGatewayBackendHTTPSettingsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendHTTPSettingsPropertiesFormat)
				if err != nil {
					return err
				}
				agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat = &applicationGatewayBackendHTTPSettingsPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbhs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbhs.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agbhs.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbhs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat properties of Backend address pool settings of an
// application gateway.
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Port - The destination port on the backend.
	Port *int32 `json:"port,omitempty"`
	// Protocol - The protocol used to communicate with the backend. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// CookieBasedAffinity - Cookie based affinity. Possible values include: 'Enabled', 'Disabled'
	CookieBasedAffinity ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	// RequestTimeout - Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
	RequestTimeout *int32 `json:"requestTimeout,omitempty"`
	// Probe - Probe resource of an application gateway.
	Probe *SubResource `json:"probe,omitempty"`
	// AuthenticationCertificates - Array of references to application gateway authentication certificates.
	AuthenticationCertificates *[]SubResource `json:"authenticationCertificates,omitempty"`
	// TrustedRootCertificates - Array of references to application gateway trusted root certificates.
	TrustedRootCertificates *[]SubResource `json:"trustedRootCertificates,omitempty"`
	// ConnectionDraining - Connection draining of the backend http settings resource.
	ConnectionDraining *ApplicationGatewayConnectionDraining `json:"connectionDraining,omitempty"`
	// HostName - Host header to be sent to the backend servers.
	HostName *string `json:"hostName,omitempty"`
	// PickHostNameFromBackendAddress - Whether to pick host header should be picked from the host name of the backend server. Default value is false.
	PickHostNameFromBackendAddress *bool `json:"pickHostNameFromBackendAddress,omitempty"`
	// AffinityCookieName - Cookie name to use for the affinity cookie.
	AffinityCookieName *string `json:"affinityCookieName,omitempty"`
	// ProbeEnabled - Whether the probe is enabled. Default value is false.
	ProbeEnabled *bool `json:"probeEnabled,omitempty"`
	// Path - Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
	Path *string `json:"path,omitempty"`
	// ProvisioningState - The provisioning state of the backend HTTP settings resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayConnectionDraining connection draining allows open connections to a backend server to
// be active for a specified time after the backend server got removed from the configuration.
type ApplicationGatewayConnectionDraining struct {
	// Enabled - Whether connection draining is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// DrainTimeoutInSec - The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
	DrainTimeoutInSec *int32 `json:"drainTimeoutInSec,omitempty"`
}

// ApplicationGatewayCustomError customer error of an application gateway.
type ApplicationGatewayCustomError struct {
	// StatusCode - Status code of the application gateway customer error. Possible values include: 'HTTPStatus403', 'HTTPStatus502'
	StatusCode ApplicationGatewayCustomErrorStatusCode `json:"statusCode,omitempty"`
	// CustomErrorPageURL - Error page URL of the application gateway customer error.
	CustomErrorPageURL *string `json:"customErrorPageUrl,omitempty"`
}

// ApplicationGatewayFirewallDisabledRuleGroup allows to disable rules within a rule group or an entire
// rule group.
type ApplicationGatewayFirewallDisabledRuleGroup struct {
	// RuleGroupName - The name of the rule group that will be disabled.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Rules - The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
	Rules *[]int32 `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallExclusion allow to exclude some variable satisfy the condition for the WAF
// check.
type ApplicationGatewayFirewallExclusion struct {
	// MatchVariable - The variable to be excluded.
	MatchVariable *string `json:"matchVariable,omitempty"`
	// SelectorMatchOperator - When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
	SelectorMatchOperator *string `json:"selectorMatchOperator,omitempty"`
	// Selector - When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
	Selector *string `json:"selector,omitempty"`
}

// ApplicationGatewayFirewallRule a web application firewall rule.
type ApplicationGatewayFirewallRule struct {
	// RuleID - The identifier of the web application firewall rule.
	RuleID *int32 `json:"ruleId,omitempty"`
	// Description - The description of the web application firewall rule.
	Description *string `json:"description,omitempty"`
}

// ApplicationGatewayFirewallRuleGroup a web application firewall rule group.
type ApplicationGatewayFirewallRuleGroup struct {
	// RuleGroupName - The name of the web application firewall rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Description - The description of the web application firewall rule group.
	Description *string `json:"description,omitempty"`
	// Rules - The rules of the web application firewall rule group.
	Rules *[]ApplicationGatewayFirewallRule `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallRuleSet a web application firewall rule set.
type ApplicationGatewayFirewallRuleSet struct {
	// ApplicationGatewayFirewallRuleSetPropertiesFormat - Properties of the application gateway firewall rule set.
	*ApplicationGatewayFirewallRuleSetPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFirewallRuleSet.
func (agfrs ApplicationGatewayFirewallRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat != nil {
		objectMap["properties"] = agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat
	}
	if agfrs.ID != nil {
		objectMap["id"] = agfrs.ID
	}
	if agfrs.Location != nil {
		objectMap["location"] = agfrs.Location
	}
	if agfrs.Tags != nil {
		objectMap["tags"] = agfrs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFirewallRuleSet struct.
func (agfrs *ApplicationGatewayFirewallRuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFirewallRuleSetPropertiesFormat ApplicationGatewayFirewallRuleSetPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFirewallRuleSetPropertiesFormat)
				if err != nil {
					return err
				}
				agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat = &applicationGatewayFirewallRuleSetPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfrs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfrs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agfrs.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agfrs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agfrs.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayFirewallRuleSetPropertiesFormat properties of the web application firewall rule set.
type ApplicationGatewayFirewallRuleSetPropertiesFormat struct {
	// ProvisioningState - The provisioning state of the web application firewall rule set. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// RuleSetType - The type of the web application firewall rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the web application firewall rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// RuleGroups - The rule groups of the web application firewall rule set.
	RuleGroups *[]ApplicationGatewayFirewallRuleGroup `json:"ruleGroups,omitempty"`
}

// ApplicationGatewayFrontendIPConfiguration frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfiguration struct {
	// ApplicationGatewayFrontendIPConfigurationPropertiesFormat - Properties of the application gateway frontend IP configuration.
	*ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the frontend IP configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendIPConfiguration.
func (agfic ApplicationGatewayFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
	}
	if agfic.Name != nil {
		objectMap["name"] = agfic.Name
	}
	if agfic.Etag != nil {
		objectMap["etag"] = agfic.Etag
	}
	if agfic.Type != nil {
		objectMap["type"] = agfic.Type
	}
	if agfic.ID != nil {
		objectMap["id"] = agfic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendIPConfiguration struct.
func (agfic *ApplicationGatewayFrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendIPConfigurationPropertiesFormat ApplicationGatewayFrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat = &applicationGatewayFrontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agfic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat properties of Frontend IP configuration of an
// application gateway.
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - PrivateIPAddress of the network interface IP Configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference of the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - The provisioning state of the frontend IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendPort frontend port of an application gateway.
type ApplicationGatewayFrontendPort struct {
	// ApplicationGatewayFrontendPortPropertiesFormat - Properties of the application gateway frontend port.
	*ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the frontend port that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendPort.
func (agfp ApplicationGatewayFrontendPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfp.ApplicationGatewayFrontendPortPropertiesFormat != nil {
		objectMap["properties"] = agfp.ApplicationGatewayFrontendPortPropertiesFormat
	}
	if agfp.Name != nil {
		objectMap["name"] = agfp.Name
	}
	if agfp.Etag != nil {
		objectMap["etag"] = agfp.Etag
	}
	if agfp.Type != nil {
		objectMap["type"] = agfp.Type
	}
	if agfp.ID != nil {
		objectMap["id"] = agfp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendPort struct.
func (agfp *ApplicationGatewayFrontendPort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendPortPropertiesFormat ApplicationGatewayFrontendPortPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendPortPropertiesFormat)
				if err != nil {
					return err
				}
				agfp.ApplicationGatewayFrontendPortPropertiesFormat = &applicationGatewayFrontendPortPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agfp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendPortPropertiesFormat properties of Frontend port of an application gateway.
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Port - Frontend port.
	Port *int32 `json:"port,omitempty"`
	// ProvisioningState - The provisioning state of the frontend port resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayHeaderConfiguration header configuration of the Actions set in Application Gateway.
type ApplicationGatewayHeaderConfiguration struct {
	// HeaderName - Header name of the header configuration.
	HeaderName *string `json:"headerName,omitempty"`
	// HeaderValue - Header value of the header configuration.
	HeaderValue *string `json:"headerValue,omitempty"`
}

// ApplicationGatewayHTTPListener http listener of an application gateway.
type ApplicationGatewayHTTPListener struct {
	// ApplicationGatewayHTTPListenerPropertiesFormat - Properties of the application gateway HTTP listener.
	*ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the HTTP listener that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayHTTPListener.
func (aghl ApplicationGatewayHTTPListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghl.ApplicationGatewayHTTPListenerPropertiesFormat != nil {
		objectMap["properties"] = aghl.ApplicationGatewayHTTPListenerPropertiesFormat
	}
	if aghl.Name != nil {
		objectMap["name"] = aghl.Name
	}
	if aghl.Etag != nil {
		objectMap["etag"] = aghl.Etag
	}
	if aghl.Type != nil {
		objectMap["type"] = aghl.Type
	}
	if aghl.ID != nil {
		objectMap["id"] = aghl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayHTTPListener struct.
func (aghl *ApplicationGatewayHTTPListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayHTTPListenerPropertiesFormat ApplicationGatewayHTTPListenerPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayHTTPListenerPropertiesFormat)
				if err != nil {
					return err
				}
				aghl.ApplicationGatewayHTTPListenerPropertiesFormat = &applicationGatewayHTTPListenerPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aghl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				aghl.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aghl.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aghl.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayHTTPListenerPropertiesFormat properties of HTTP listener of an application gateway.
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// FrontendIPConfiguration - Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// FrontendPort - Frontend port resource of an application gateway.
	FrontendPort *SubResource `json:"frontendPort,omitempty"`
	// Protocol - Protocol of the HTTP listener. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// HostName - Host name of HTTP listener.
	HostName *string `json:"hostName,omitempty"`
	// SslCertificate - SSL certificate resource of an application gateway.
	SslCertificate *SubResource `json:"sslCertificate,omitempty"`
	// RequireServerNameIndication - Applicable only if protocol is https. Enables SNI for multi-hosting.
	RequireServerNameIndication *bool `json:"requireServerNameIndication,omitempty"`
	// ProvisioningState - The provisioning state of the HTTP listener resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CustomErrorConfigurations - Custom error configurations of the HTTP listener.
	CustomErrorConfigurations *[]ApplicationGatewayCustomError `json:"customErrorConfigurations,omitempty"`
}

// ApplicationGatewayIPConfiguration IP configuration of an application gateway. Currently 1 public and 1
// private IP configuration is allowed.
type ApplicationGatewayIPConfiguration struct {
	// ApplicationGatewayIPConfigurationPropertiesFormat - Properties of the application gateway IP configuration.
	*ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the IP configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayIPConfiguration.
func (agic ApplicationGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agic.ApplicationGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agic.ApplicationGatewayIPConfigurationPropertiesFormat
	}
	if agic.Name != nil {
		objectMap["name"] = agic.Name
	}
	if agic.Etag != nil {
		objectMap["etag"] = agic.Etag
	}
	if agic.Type != nil {
		objectMap["type"] = agic.Type
	}
	if agic.ID != nil {
		objectMap["id"] = agic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayIPConfiguration struct.
func (agic *ApplicationGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayIPConfigurationPropertiesFormat ApplicationGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agic.ApplicationGatewayIPConfigurationPropertiesFormat = &applicationGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayIPConfigurationPropertiesFormat properties of IP configuration of an application
// gateway.
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Subnet - Reference of the subnet resource. A subnet from where application gateway gets its private address.
	Subnet *SubResource `json:"subnet,omitempty"`
	// ProvisioningState - The provisioning state of the application gateway IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayListResult response for ListApplicationGateways API service call.
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - List of an application gateways in a resource group.
	Value *[]ApplicationGateway `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultIterator provides access to a complete listing of ApplicationGateway values.
type ApplicationGatewayListResultIterator struct {
	i    int
	page ApplicationGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayListResultIterator) Response() ApplicationGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayListResultIterator) Value() ApplicationGateway {
	if !iter.page.NotDone() {
		return ApplicationGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayListResultIterator type.
func NewApplicationGatewayListResultIterator(page ApplicationGatewayListResultPage) ApplicationGatewayListResultIterator {
	return ApplicationGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aglr ApplicationGatewayListResult) IsEmpty() bool {
	return aglr.Value == nil || len(*aglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aglr ApplicationGatewayListResult) hasNextLink() bool {
	return aglr.NextLink != nil && len(*aglr.NextLink) != 0
}

// applicationGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aglr ApplicationGatewayListResult) applicationGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aglr.NextLink)))
}

// ApplicationGatewayListResultPage contains a page of ApplicationGateway values.
type ApplicationGatewayListResultPage struct {
	fn   func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)
	aglr ApplicationGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aglr)
		if err != nil {
			return err
		}
		page.aglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayListResultPage) NotDone() bool {
	return !page.aglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayListResultPage) Response() ApplicationGatewayListResult {
	return page.aglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayListResultPage) Values() []ApplicationGateway {
	if page.aglr.IsEmpty() {
		return nil
	}
	return *page.aglr.Value
}

// Creates a new instance of the ApplicationGatewayListResultPage type.
func NewApplicationGatewayListResultPage(cur ApplicationGatewayListResult, getNextPage func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)) ApplicationGatewayListResultPage {
	return ApplicationGatewayListResultPage{
		fn:   getNextPage,
		aglr: cur,
	}
}

// ApplicationGatewayOnDemandProbe details of on demand test probe request.
type ApplicationGatewayOnDemandProbe struct {
	// Protocol - The protocol used for the probe. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Host - Host name to send the probe to.
	Host *string `json:"host,omitempty"`
	// Path - Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
	Path *string `json:"path,omitempty"`
	// Timeout - The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// PickHostNameFromBackendHTTPSettings - Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool `json:"pickHostNameFromBackendHttpSettings,omitempty"`
	// Match - Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch `json:"match,omitempty"`
	// BackendAddressPool - Reference of backend pool of application gateway to which probe request will be sent.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Reference of backend http setting of application gateway to be used for test probe.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
}

// ApplicationGatewayPathRule path rule of URL path map of an application gateway.
type ApplicationGatewayPathRule struct {
	// ApplicationGatewayPathRulePropertiesFormat - Properties of the application gateway path rule.
	*ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the path rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPathRule.
func (agpr ApplicationGatewayPathRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpr.ApplicationGatewayPathRulePropertiesFormat != nil {
		objectMap["properties"] = agpr.ApplicationGatewayPathRulePropertiesFormat
	}
	if agpr.Name != nil {
		objectMap["name"] = agpr.Name
	}
	if agpr.Etag != nil {
		objectMap["etag"] = agpr.Etag
	}
	if agpr.Type != nil {
		objectMap["type"] = agpr.Type
	}
	if agpr.ID != nil {
		objectMap["id"] = agpr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPathRule struct.
func (agpr *ApplicationGatewayPathRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPathRulePropertiesFormat ApplicationGatewayPathRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPathRulePropertiesFormat)
				if err != nil {
					return err
				}
				agpr.ApplicationGatewayPathRulePropertiesFormat = &applicationGatewayPathRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agpr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agpr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agpr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agpr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPathRulePropertiesFormat properties of path rule of an application gateway.
type ApplicationGatewayPathRulePropertiesFormat struct {
	// Paths - Path rules of URL path map.
	Paths *[]string `json:"paths,omitempty"`
	// BackendAddressPool - Backend address pool resource of URL path map path rule.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Backend http settings resource of URL path map path rule.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// RedirectConfiguration - Redirect configuration resource of URL path map path rule.
	RedirectConfiguration *SubResource `json:"redirectConfiguration,omitempty"`
	// RewriteRuleSet - Rewrite rule set resource of URL path map path rule.
	RewriteRuleSet *SubResource `json:"rewriteRuleSet,omitempty"`
	// ProvisioningState - The provisioning state of the path rule resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayProbe probe of the application gateway.
type ApplicationGatewayProbe struct {
	// ApplicationGatewayProbePropertiesFormat - Properties of the application gateway probe.
	*ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the probe that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayProbe.
func (agp ApplicationGatewayProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.ApplicationGatewayProbePropertiesFormat != nil {
		objectMap["properties"] = agp.ApplicationGatewayProbePropertiesFormat
	}
	if agp.Name != nil {
		objectMap["name"] = agp.Name
	}
	if agp.Etag != nil {
		objectMap["etag"] = agp.Etag
	}
	if agp.Type != nil {
		objectMap["type"] = agp.Type
	}
	if agp.ID != nil {
		objectMap["id"] = agp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayProbe struct.
func (agp *ApplicationGatewayProbe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayProbePropertiesFormat ApplicationGatewayProbePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayProbePropertiesFormat)
				if err != nil {
					return err
				}
				agp.ApplicationGatewayProbePropertiesFormat = &applicationGatewayProbePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayProbeHealthResponseMatch application gateway probe health response match.
type ApplicationGatewayProbeHealthResponseMatch struct {
	// Body - Body that must be contained in the health response. Default value is empty.
	Body *string `json:"body,omitempty"`
	// StatusCodes - Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
	StatusCodes *[]string `json:"statusCodes,omitempty"`
}

// ApplicationGatewayProbePropertiesFormat properties of probe of an application gateway.
type ApplicationGatewayProbePropertiesFormat struct {
	// Protocol - The protocol used for the probe. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Host - Host name to send the probe to.
	Host *string `json:"host,omitempty"`
	// Path - Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
	Path *string `json:"path,omitempty"`
	// Interval - The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
	Interval *int32 `json:"interval,omitempty"`
	// Timeout - The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// UnhealthyThreshold - The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
	UnhealthyThreshold *int32 `json:"unhealthyThreshold,omitempty"`
	// PickHostNameFromBackendHTTPSettings - Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool `json:"pickHostNameFromBackendHttpSettings,omitempty"`
	// MinServers - Minimum number of servers that are always marked healthy. Default value is 0.
	MinServers *int32 `json:"minServers,omitempty"`
	// Match - Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch `json:"match,omitempty"`
	// ProvisioningState - The provisioning state of the probe resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Port - Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
	Port *int32 `json:"port,omitempty"`
}

// ApplicationGatewayPropertiesFormat properties of the application gateway.
type ApplicationGatewayPropertiesFormat struct {
	// Sku - SKU of the application gateway resource.
	Sku *ApplicationGatewaySku `json:"sku,omitempty"`
	// SslPolicy - SSL policy of the application gateway resource.
	SslPolicy *ApplicationGatewaySslPolicy `json:"sslPolicy,omitempty"`
	// OperationalState - READ-ONLY; Operational state of the application gateway resource. Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping'
	OperationalState ApplicationGatewayOperationalState `json:"operationalState,omitempty"`
	// GatewayIPConfigurations - Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	GatewayIPConfigurations *[]ApplicationGatewayIPConfiguration `json:"gatewayIPConfigurations,omitempty"`
	// AuthenticationCertificates - Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	AuthenticationCertificates *[]ApplicationGatewayAuthenticationCertificate `json:"authenticationCertificates,omitempty"`
	// TrustedRootCertificates - Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	TrustedRootCertificates *[]ApplicationGatewayTrustedRootCertificate `json:"trustedRootCertificates,omitempty"`
	// SslCertificates - SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	SslCertificates *[]ApplicationGatewaySslCertificate `json:"sslCertificates,omitempty"`
	// FrontendIPConfigurations - Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	FrontendIPConfigurations *[]ApplicationGatewayFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// FrontendPorts - Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	FrontendPorts *[]ApplicationGatewayFrontendPort `json:"frontendPorts,omitempty"`
	// Probes - Probes of the application gateway resource.
	Probes *[]ApplicationGatewayProbe `json:"probes,omitempty"`
	// BackendAddressPools - Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	BackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"backendAddressPools,omitempty"`
	// BackendHTTPSettingsCollection - Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
	// HTTPListeners - Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	HTTPListeners *[]ApplicationGatewayHTTPListener `json:"httpListeners,omitempty"`
	// URLPathMaps - URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	URLPathMaps *[]ApplicationGatewayURLPathMap `json:"urlPathMaps,omitempty"`
	// RequestRoutingRules - Request routing rules of the application gateway resource.
	RequestRoutingRules *[]ApplicationGatewayRequestRoutingRule `json:"requestRoutingRules,omitempty"`
	// RewriteRuleSets - Rewrite rules for the application gateway resource.
	RewriteRuleSets *[]ApplicationGatewayRewriteRuleSet `json:"rewriteRuleSets,omitempty"`
	// RedirectConfigurations - Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	RedirectConfigurations *[]ApplicationGatewayRedirectConfiguration `json:"redirectConfigurations,omitempty"`
	// WebApplicationFirewallConfiguration - Web application firewall configuration.
	WebApplicationFirewallConfiguration *ApplicationGatewayWebApplicationFirewallConfiguration `json:"webApplicationFirewallConfiguration,omitempty"`
	// FirewallPolicy - Reference of the FirewallPolicy resource.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`
	// EnableHTTP2 - Whether HTTP2 is enabled on the application gateway resource.
	EnableHTTP2 *bool `json:"enableHttp2,omitempty"`
	// EnableFips - Whether FIPS is enabled on the application gateway resource.
	EnableFips *bool `json:"enableFips,omitempty"`
	// AutoscaleConfiguration - Autoscale Configuration.
	AutoscaleConfiguration *ApplicationGatewayAutoscaleConfiguration `json:"autoscaleConfiguration,omitempty"`
	// ResourceGUID - The resource GUID property of the application gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the application gateway resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CustomErrorConfigurations - Custom error configurations of the application gateway resource.
	CustomErrorConfigurations *[]ApplicationGatewayCustomError `json:"customErrorConfigurations,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPropertiesFormat.
func (agpf ApplicationGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpf.Sku != nil {
		objectMap["sku"] = agpf.Sku
	}
	if agpf.SslPolicy != nil {
		objectMap["sslPolicy"] = agpf.SslPolicy
	}
	if agpf.GatewayIPConfigurations != nil {
		objectMap["gatewayIPConfigurations"] = agpf.GatewayIPConfigurations
	}
	if agpf.AuthenticationCertificates != nil {
		objectMap["authenticationCertificates"] = agpf.AuthenticationCertificates
	}
	if agpf.TrustedRootCertificates != nil {
		objectMap["trustedRootCertificates"] = agpf.TrustedRootCertificates
	}
	if agpf.SslCertificates != nil {
		objectMap["sslCertificates"] = agpf.SslCertificates
	}
	if agpf.FrontendIPConfigurations != nil {
		objectMap["frontendIPConfigurations"] = agpf.FrontendIPConfigurations
	}
	if agpf.FrontendPorts != nil {
		objectMap["frontendPorts"] = agpf.FrontendPorts
	}
	if agpf.Probes != nil {
		objectMap["probes"] = agpf.Probes
	}
	if agpf.BackendAddressPools != nil {
		objectMap["backendAddressPools"] = agpf.BackendAddressPools
	}
	if agpf.BackendHTTPSettingsCollection != nil {
		objectMap["backendHttpSettingsCollection"] = agpf.BackendHTTPSettingsCollection
	}
	if agpf.HTTPListeners != nil {
		objectMap["httpListeners"] = agpf.HTTPListeners
	}
	if agpf.URLPathMaps != nil {
		objectMap["urlPathMaps"] = agpf.URLPathMaps
	}
	if agpf.RequestRoutingRules != nil {
		objectMap["requestRoutingRules"] = agpf.RequestRoutingRules
	}
	if agpf.RewriteRuleSets != nil {
		objectMap["rewriteRuleSets"] = agpf.RewriteRuleSets
	}
	if agpf.RedirectConfigurations != nil {
		objectMap["redirectConfigurations"] = agpf.RedirectConfigurations
	}
	if agpf.WebApplicationFirewallConfiguration != nil {
		objectMap["webApplicationFirewallConfiguration"] = agpf.WebApplicationFirewallConfiguration
	}
	if agpf.FirewallPolicy != nil {
		objectMap["firewallPolicy"] = agpf.FirewallPolicy
	}
	if agpf.EnableHTTP2 != nil {
		objectMap["enableHttp2"] = agpf.EnableHTTP2
	}
	if agpf.EnableFips != nil {
		objectMap["enableFips"] = agpf.EnableFips
	}
	if agpf.AutoscaleConfiguration != nil {
		objectMap["autoscaleConfiguration"] = agpf.AutoscaleConfiguration
	}
	if agpf.ResourceGUID != nil {
		objectMap["resourceGuid"] = agpf.ResourceGUID
	}
	if agpf.ProvisioningState != "" {
		objectMap["provisioningState"] = agpf.ProvisioningState
	}
	if agpf.CustomErrorConfigurations != nil {
		objectMap["customErrorConfigurations"] = agpf.CustomErrorConfigurations
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayRedirectConfiguration redirect configuration of an application gateway.
type ApplicationGatewayRedirectConfiguration struct {
	// ApplicationGatewayRedirectConfigurationPropertiesFormat - Properties of the application gateway redirect configuration.
	*ApplicationGatewayRedirectConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the redirect configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRedirectConfiguration.
func (agrc ApplicationGatewayRedirectConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrc.ApplicationGatewayRedirectConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agrc.ApplicationGatewayRedirectConfigurationPropertiesFormat
	}
	if agrc.Name != nil {
		objectMap["name"] = agrc.Name
	}
	if agrc.Etag != nil {
		objectMap["etag"] = agrc.Etag
	}
	if agrc.Type != nil {
		objectMap["type"] = agrc.Type
	}
	if agrc.ID != nil {
		objectMap["id"] = agrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRedirectConfiguration struct.
func (agrc *ApplicationGatewayRedirectConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRedirectConfigurationPropertiesFormat ApplicationGatewayRedirectConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRedirectConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agrc.ApplicationGatewayRedirectConfigurationPropertiesFormat = &applicationGatewayRedirectConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agrc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRedirectConfigurationPropertiesFormat properties of redirect configuration of the
// application gateway.
type ApplicationGatewayRedirectConfigurationPropertiesFormat struct {
	// RedirectType - HTTP redirection type. Possible values include: 'Permanent', 'Found', 'SeeOther', 'Temporary'
	RedirectType ApplicationGatewayRedirectType `json:"redirectType,omitempty"`
	// TargetListener - Reference to a listener to redirect the request to.
	TargetListener *SubResource `json:"targetListener,omitempty"`
	// TargetURL - Url to redirect the request to.
	TargetURL *string `json:"targetUrl,omitempty"`
	// IncludePath - Include path in the redirected url.
	IncludePath *bool `json:"includePath,omitempty"`
	// IncludeQueryString - Include query string in the redirected url.
	IncludeQueryString *bool `json:"includeQueryString,omitempty"`
	// RequestRoutingRules - Request routing specifying redirect configuration.
	RequestRoutingRules *[]SubResource `json:"requestRoutingRules,omitempty"`
	// URLPathMaps - Url path maps specifying default redirect configuration.
	URLPathMaps *[]SubResource `json:"urlPathMaps,omitempty"`
	// PathRules - Path rules specifying redirect configuration.
	PathRules *[]SubResource `json:"pathRules,omitempty"`
}

// ApplicationGatewayRequestRoutingRule request routing rule of an application gateway.
type ApplicationGatewayRequestRoutingRule struct {
	// ApplicationGatewayRequestRoutingRulePropertiesFormat - Properties of the application gateway request routing rule.
	*ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the request routing rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRequestRoutingRule.
func (agrrr ApplicationGatewayRequestRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat != nil {
		objectMap["properties"] = agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat
	}
	if agrrr.Name != nil {
		objectMap["name"] = agrrr.Name
	}
	if agrrr.Etag != nil {
		objectMap["etag"] = agrrr.Etag
	}
	if agrrr.Type != nil {
		objectMap["type"] = agrrr.Type
	}
	if agrrr.ID != nil {
		objectMap["id"] = agrrr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRequestRoutingRule struct.
func (agrrr *ApplicationGatewayRequestRoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRequestRoutingRulePropertiesFormat ApplicationGatewayRequestRoutingRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRequestRoutingRulePropertiesFormat)
				if err != nil {
					return err
				}
				agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat = &applicationGatewayRequestRoutingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agrrr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat properties of request routing rule of the
// application gateway.
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// RuleType - Rule type. Possible values include: 'Basic', 'PathBasedRouting'
	RuleType ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	// Priority - Priority of the request routing rule.
	Priority *int32 `json:"priority,omitempty"`
	// BackendAddressPool - Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Backend http settings resource of the application gateway.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// HTTPListener - Http listener resource of the application gateway.
	HTTPListener *SubResource `json:"httpListener,omitempty"`
	// URLPathMap - URL path map resource of the application gateway.
	URLPathMap *SubResource `json:"urlPathMap,omitempty"`
	// RewriteRuleSet - Rewrite Rule Set resource in Basic rule of the application gateway.
	RewriteRuleSet *SubResource `json:"rewriteRuleSet,omitempty"`
	// RedirectConfiguration - Redirect configuration resource of the application gateway.
	RedirectConfiguration *SubResource `json:"redirectConfiguration,omitempty"`
	// ProvisioningState - The provisioning state of the request routing rule resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayRewriteRule rewrite rule of an application gateway.
type ApplicationGatewayRewriteRule struct {
	// Name - Name of the rewrite rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// RuleSequence - Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
	RuleSequence *int32 `json:"ruleSequence,omitempty"`
	// Conditions - Conditions based on which the action set execution will be evaluated.
	Conditions *[]ApplicationGatewayRewriteRuleCondition `json:"conditions,omitempty"`
	// ActionSet - Set of actions to be done as part of the rewrite Rule.
	ActionSet *ApplicationGatewayRewriteRuleActionSet `json:"actionSet,omitempty"`
}

// ApplicationGatewayRewriteRuleActionSet set of actions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleActionSet struct {
	// RequestHeaderConfigurations - Request Header Actions in the Action Set.
	RequestHeaderConfigurations *[]ApplicationGatewayHeaderConfiguration `json:"requestHeaderConfigurations,omitempty"`
	// ResponseHeaderConfigurations - Response Header Actions in the Action Set.
	ResponseHeaderConfigurations *[]ApplicationGatewayHeaderConfiguration `json:"responseHeaderConfigurations,omitempty"`
}

// ApplicationGatewayRewriteRuleCondition set of conditions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleCondition struct {
	// Variable - The condition parameter of the RewriteRuleCondition.
	Variable *string `json:"variable,omitempty"`
	// Pattern - The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
	Pattern *string `json:"pattern,omitempty"`
	// IgnoreCase - Setting this paramter to truth value with force the pattern to do a case in-sensitive comparison.
	IgnoreCase *bool `json:"ignoreCase,omitempty"`
	// Negate - Setting this value as truth will force to check the negation of the condition given by the user.
	Negate *bool `json:"negate,omitempty"`
}

// ApplicationGatewayRewriteRuleSet rewrite rule set of an application gateway.
type ApplicationGatewayRewriteRuleSet struct {
	// ApplicationGatewayRewriteRuleSetPropertiesFormat - Properties of the application gateway rewrite rule set.
	*ApplicationGatewayRewriteRuleSetPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the rewrite rule set that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRewriteRuleSet.
func (agrrs ApplicationGatewayRewriteRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrs.ApplicationGatewayRewriteRuleSetPropertiesFormat != nil {
		objectMap["properties"] = agrrs.ApplicationGatewayRewriteRuleSetPropertiesFormat
	}
	if agrrs.Name != nil {
		objectMap["name"] = agrrs.Name
	}
	if agrrs.ID != nil {
		objectMap["id"] = agrrs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRewriteRuleSet struct.
func (agrrs *ApplicationGatewayRewriteRuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRewriteRuleSetPropertiesFormat ApplicationGatewayRewriteRuleSetPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRewriteRuleSetPropertiesFormat)
				if err != nil {
					return err
				}
				agrrs.ApplicationGatewayRewriteRuleSetPropertiesFormat = &applicationGatewayRewriteRuleSetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRewriteRuleSetPropertiesFormat properties of rewrite rule set of the application
// gateway.
type ApplicationGatewayRewriteRuleSetPropertiesFormat struct {
	// RewriteRules - Rewrite rules in the rewrite rule set.
	RewriteRules *[]ApplicationGatewayRewriteRule `json:"rewriteRules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the rewrite rule set resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRewriteRuleSetPropertiesFormat.
func (agrrspf ApplicationGatewayRewriteRuleSetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrspf.RewriteRules != nil {
		objectMap["rewriteRules"] = agrrspf.RewriteRules
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewaysBackendHealthFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysBackendHealthFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGatewayBackendHealth, error)
}

// ApplicationGatewaysBackendHealthOnDemandFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ApplicationGatewaysBackendHealthOnDemandFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGatewayBackendHealthOnDemand, error)
}

// ApplicationGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGateway, error)
}

// ApplicationGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// ApplicationGatewaySku SKU of an application gateway.
type ApplicationGatewaySku struct {
	// Name - Name of an application gateway SKU. Possible values include: 'StandardSmall', 'StandardMedium', 'StandardLarge', 'WAFMedium', 'WAFLarge', 'StandardV2', 'WAFV2'
	Name ApplicationGatewaySkuName `json:"name,omitempty"`
	// Tier - Tier of an application gateway. Possible values include: 'ApplicationGatewayTierStandard', 'ApplicationGatewayTierWAF', 'ApplicationGatewayTierStandardV2', 'ApplicationGatewayTierWAFV2'
	Tier ApplicationGatewayTier `json:"tier,omitempty"`
	// Capacity - Capacity (instance count) of an application gateway.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate SSL certificates of an application gateway.
type ApplicationGatewaySslCertificate struct {
	// ApplicationGatewaySslCertificatePropertiesFormat - Properties of the application gateway SSL certificate.
	*ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the SSL certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslCertificate.
func (agsc ApplicationGatewaySslCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsc.ApplicationGatewaySslCertificatePropertiesFormat != nil {
		objectMap["properties"] = agsc.ApplicationGatewaySslCertificatePropertiesFormat
	}
	if agsc.Name != nil {
		objectMap["name"] = agsc.Name
	}
	if agsc.Etag != nil {
		objectMap["etag"] = agsc.Etag
	}
	if agsc.Type != nil {
		objectMap["type"] = agsc.Type
	}
	if agsc.ID != nil {
		objectMap["id"] = agsc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslCertificate struct.
func (agsc *ApplicationGatewaySslCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewaySslCertificatePropertiesFormat ApplicationGatewaySslCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agsc.ApplicationGatewaySslCertificatePropertiesFormat = &applicationGatewaySslCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agsc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agsc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agsc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agsc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslCertificatePropertiesFormat properties of SSL certificates of an application
// gateway.
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	// Data - Base-64 encoded pfx certificate. Only applicable in PUT Request.
	Data *string `json:"data,omitempty"`
	// Password - Password for the pfx file specified in data. Only applicable in PUT request.
	Password *string `json:"password,omitempty"`
	// PublicCertData - Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
	PublicCertData *string `json:"publicCertData,omitempty"`
	// KeyVaultSecretID - Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`
	// ProvisioningState - The provisioning state of the SSL certificate resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySslPolicy application Gateway Ssl policy.
type ApplicationGatewaySslPolicy struct {
	// DisabledSslProtocols - Ssl protocols to be disabled on application gateway.
	DisabledSslProtocols *[]ApplicationGatewaySslProtocol `json:"disabledSslProtocols,omitempty"`
	// PolicyType - Type of Ssl Policy. Possible values include: 'Predefined', 'Custom'
	PolicyType ApplicationGatewaySslPolicyType `json:"policyType,omitempty"`
	// PolicyName - Name of Ssl predefined policy. Possible values include: 'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401', 'AppGwSslPolicy20170401S'
	PolicyName ApplicationGatewaySslPolicyName `json:"policyName,omitempty"`
	// CipherSuites - Ssl cipher suites to be enabled in the specified order to application gateway.
	CipherSuites *[]ApplicationGatewaySslCipherSuite `json:"cipherSuites,omitempty"`
	// MinProtocolVersion - Minimum version of Ssl protocol to be supported on application gateway. Possible values include: 'TLSv10', 'TLSv11', 'TLSv12'
	MinProtocolVersion ApplicationGatewaySslProtocol `json:"minProtocolVersion,omitempty"`
}

// ApplicationGatewaySslPredefinedPolicy an Ssl predefined policy.
type ApplicationGatewaySslPredefinedPolicy struct {
	autorest.Response `json:"-"`
	// Name - Name of the Ssl predefined policy.
	Name *string `json:"name,omitempty"`
	// ApplicationGatewaySslPredefinedPolicyPropertiesFormat - Properties of the application gateway SSL predefined policy.
	*ApplicationGatewaySslPredefinedPolicyPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslPredefinedPolicy.
func (agspp ApplicationGatewaySslPredefinedPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agspp.Name != nil {
		objectMap["name"] = agspp.Name
	}
	if agspp.ApplicationGatewaySslPredefinedPolicyPropertiesFormat != nil {
		objectMap["properties"] = agspp.ApplicationGatewaySslPredefinedPolicyPropertiesFormat
	}
	if agspp.ID != nil {
		objectMap["id"] = agspp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslPredefinedPolicy struct.
func (agspp *ApplicationGatewaySslPredefinedPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agspp.Name = &name
			}
		case "properties":
			if v != nil {
				var applicationGatewaySslPredefinedPolicyPropertiesFormat ApplicationGatewaySslPredefinedPolicyPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslPredefinedPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				agspp.ApplicationGatewaySslPredefinedPolicyPropertiesFormat = &applicationGatewaySslPredefinedPolicyPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agspp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslPredefinedPolicyPropertiesFormat properties of
// ApplicationGatewaySslPredefinedPolicy.
type ApplicationGatewaySslPredefinedPolicyPropertiesFormat struct {
	// CipherSuites - Ssl cipher suites to be enabled in the specified order for application gateway.
	CipherSuites *[]ApplicationGatewaySslCipherSuite `json:"cipherSuites,omitempty"`
	// MinProtocolVersion - Minimum version of Ssl protocol to be supported on application gateway. Possible values include: 'TLSv10', 'TLSv11', 'TLSv12'
	MinProtocolVersion ApplicationGatewaySslProtocol `json:"minProtocolVersion,omitempty"`
}

// ApplicationGatewaysStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// ApplicationGatewaysStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// ApplicationGatewaysUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGateway, error)
}

// ApplicationGatewayTrustedRootCertificate trusted Root certificates of an application gateway.
type ApplicationGatewayTrustedRootCertificate struct {
	// ApplicationGatewayTrustedRootCertificatePropertiesFormat - Properties of the application gateway trusted root certificate.
	*ApplicationGatewayTrustedRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the trusted root certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayTrustedRootCertificate.
func (agtrc ApplicationGatewayTrustedRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agtrc.ApplicationGatewayTrustedRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = agtrc.ApplicationGatewayTrustedRootCertificatePropertiesFormat
	}
	if agtrc.Name != nil {
		objectMap["name"] = agtrc.Name
	}
	if agtrc.Etag != nil {
		objectMap["etag"] = agtrc.Etag
	}
	if agtrc.Type != nil {
		objectMap["type"] = agtrc.Type
	}
	if agtrc.ID != nil {
		objectMap["id"] = agtrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayTrustedRootCertificate struct.
func (agtrc *ApplicationGatewayTrustedRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayTrustedRootCertificatePropertiesFormat ApplicationGatewayTrustedRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayTrustedRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agtrc.ApplicationGatewayTrustedRootCertificatePropertiesFormat = &applicationGatewayTrustedRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agtrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agtrc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agtrc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agtrc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayTrustedRootCertificatePropertiesFormat trusted Root certificates properties of an
// application gateway.
type ApplicationGatewayTrustedRootCertificatePropertiesFormat struct {
	// Data - Certificate public data.
	Data *string `json:"data,omitempty"`
	// KeyVaultSecretID - Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`
	// ProvisioningState - The provisioning state of the trusted root certificate resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayURLPathMap urlPathMaps give a url path to the backend mapping information for
// PathBasedRouting.
type ApplicationGatewayURLPathMap struct {
	// ApplicationGatewayURLPathMapPropertiesFormat - Properties of the application gateway URL path map.
	*ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the URL path map that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayURLPathMap.
func (agupm ApplicationGatewayURLPathMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agupm.ApplicationGatewayURLPathMapPropertiesFormat != nil {
		objectMap["properties"] = agupm.ApplicationGatewayURLPathMapPropertiesFormat
	}
	if agupm.Name != nil {
		objectMap["name"] = agupm.Name
	}
	if agupm.Etag != nil {
		objectMap["etag"] = agupm.Etag
	}
	if agupm.Type != nil {
		objectMap["type"] = agupm.Type
	}
	if agupm.ID != nil {
		objectMap["id"] = agupm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayURLPathMap struct.
func (agupm *ApplicationGatewayURLPathMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayURLPathMapPropertiesFormat ApplicationGatewayURLPathMapPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayURLPathMapPropertiesFormat)
				if err != nil {
					return err
				}
				agupm.ApplicationGatewayURLPathMapPropertiesFormat = &applicationGatewayURLPathMapPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agupm.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agupm.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agupm.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agupm.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayURLPathMapPropertiesFormat properties of UrlPathMap of the application gateway.
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	// DefaultBackendAddressPool - Default backend address pool resource of URL path map.
	DefaultBackendAddressPool *SubResource `json:"defaultBackendAddressPool,omitempty"`
	// DefaultBackendHTTPSettings - Default backend http settings resource of URL path map.
	DefaultBackendHTTPSettings *SubResource `json:"defaultBackendHttpSettings,omitempty"`
	// DefaultRewriteRuleSet - Default Rewrite rule set resource of URL path map.
	DefaultRewriteRuleSet *SubResource `json:"defaultRewriteRuleSet,omitempty"`
	// DefaultRedirectConfiguration - Default redirect configuration resource of URL path map.
	DefaultRedirectConfiguration *SubResource `json:"defaultRedirectConfiguration,omitempty"`
	// PathRules - Path rule of URL path map resource.
	PathRules *[]ApplicationGatewayPathRule `json:"pathRules,omitempty"`
	// ProvisioningState - The provisioning state of the URL path map resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationGatewayWebApplicationFirewallConfiguration application gateway web application firewall
// configuration.
type ApplicationGatewayWebApplicationFirewallConfiguration struct {
	// Enabled - Whether the web application firewall is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// FirewallMode - Web application firewall mode. Possible values include: 'Detection', 'Prevention'
	FirewallMode ApplicationGatewayFirewallMode `json:"firewallMode,omitempty"`
	// RuleSetType - The type of the web application firewall rule set. Possible values are: 'OWASP'.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// DisabledRuleGroups - The disabled rule groups.
	DisabledRuleGroups *[]ApplicationGatewayFirewallDisabledRuleGroup `json:"disabledRuleGroups,omitempty"`
	// RequestBodyCheck - Whether allow WAF to check request Body.
	RequestBodyCheck *bool `json:"requestBodyCheck,omitempty"`
	// MaxRequestBodySize - Maximum request body size for WAF.
	MaxRequestBodySize *int32 `json:"maxRequestBodySize,omitempty"`
	// MaxRequestBodySizeInKb - Maximum request body size in Kb for WAF.
	MaxRequestBodySizeInKb *int32 `json:"maxRequestBodySizeInKb,omitempty"`
	// FileUploadLimitInMb - Maximum file upload size in Mb for WAF.
	FileUploadLimitInMb *int32 `json:"fileUploadLimitInMb,omitempty"`
	// Exclusions - The exclusion list.
	Exclusions *[]ApplicationGatewayFirewallExclusion `json:"exclusions,omitempty"`
}

// ApplicationRuleCondition rule condition of type application.
type ApplicationRuleCondition struct {
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses or Service Tags.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// Protocols - Array of Application Protocols.
	Protocols *[]FirewallPolicyRuleConditionApplicationProtocol `json:"protocols,omitempty"`
	// TargetFqdns - List of FQDNs for this rule condition.
	TargetFqdns *[]string `json:"targetFqdns,omitempty"`
	// FqdnTags - List of FQDN Tags for this rule condition.
	FqdnTags *[]string `json:"fqdnTags,omitempty"`
	// Name - Name of the rule condition.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule condition.
	Description *string `json:"description,omitempty"`
	// RuleConditionType - Possible values include: 'RuleConditionTypeFirewallPolicyRuleCondition', 'RuleConditionTypeApplicationRuleCondition', 'RuleConditionTypeNetworkRuleCondition'
	RuleConditionType RuleConditionType `json:"ruleConditionType,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationRuleCondition.
func (arc ApplicationRuleCondition) MarshalJSON() ([]byte, error) {
	arc.RuleConditionType = RuleConditionTypeApplicationRuleCondition
	objectMap := make(map[string]interface{})
	if arc.SourceAddresses != nil {
		objectMap["sourceAddresses"] = arc.SourceAddresses
	}
	if arc.DestinationAddresses != nil {
		objectMap["destinationAddresses"] = arc.DestinationAddresses
	}
	if arc.Protocols != nil {
		objectMap["protocols"] = arc.Protocols
	}
	if arc.TargetFqdns != nil {
		objectMap["targetFqdns"] = arc.TargetFqdns
	}
	if arc.FqdnTags != nil {
		objectMap["fqdnTags"] = arc.FqdnTags
	}
	if arc.Name != nil {
		objectMap["name"] = arc.Name
	}
	if arc.Description != nil {
		objectMap["description"] = arc.Description
	}
	if arc.RuleConditionType != "" {
		objectMap["ruleConditionType"] = arc.RuleConditionType
	}
	return json.Marshal(objectMap)
}

// AsApplicationRuleCondition is the BasicFirewallPolicyRuleCondition implementation for ApplicationRuleCondition.
func (arc ApplicationRuleCondition) AsApplicationRuleCondition() (*ApplicationRuleCondition, bool) {
	return &arc, true
}

// AsRuleCondition is the BasicFirewallPolicyRuleCondition implementation for ApplicationRuleCondition.
func (arc ApplicationRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsFirewallPolicyRuleCondition is the BasicFirewallPolicyRuleCondition implementation for ApplicationRuleCondition.
func (arc ApplicationRuleCondition) AsFirewallPolicyRuleCondition() (*FirewallPolicyRuleCondition, bool) {
	return nil, false
}

// AsBasicFirewallPolicyRuleCondition is the BasicFirewallPolicyRuleCondition implementation for ApplicationRuleCondition.
func (arc ApplicationRuleCondition) AsBasicFirewallPolicyRuleCondition() (BasicFirewallPolicyRuleCondition, bool) {
	return &arc, true
}

// ApplicationSecurityGroup an application security group in a resource group.
type ApplicationSecurityGroup struct {
	autorest.Response `json:"-"`
	// ApplicationSecurityGroupPropertiesFormat - Properties of the application security group.
	*ApplicationSecurityGroupPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationSecurityGroup.
func (asg ApplicationSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asg.ApplicationSecurityGroupPropertiesFormat != nil {
		objectMap["properties"] = asg.ApplicationSecurityGroupPropertiesFormat
	}
	if asg.ID != nil {
		objectMap["id"] = asg.ID
	}
	if asg.Location != nil {
		objectMap["location"] = asg.Location
	}
	if asg.Tags != nil {
		objectMap["tags"] = asg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationSecurityGroup struct.
func (asg *ApplicationSecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationSecurityGroupPropertiesFormat ApplicationSecurityGroupPropertiesFormat
				err = json.Unmarshal(*v, &applicationSecurityGroupPropertiesFormat)
				if err != nil {
					return err
				}
				asg.ApplicationSecurityGroupPropertiesFormat = &applicationSecurityGroupPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				asg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asg.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationSecurityGroupListResult a list of application security groups.
type ApplicationSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of application security groups.
	Value *[]ApplicationSecurityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationSecurityGroupListResult.
func (asglr ApplicationSecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asglr.Value != nil {
		objectMap["value"] = asglr.Value
	}
	return json.Marshal(objectMap)
}

// ApplicationSecurityGroupListResultIterator provides access to a complete listing of
// ApplicationSecurityGroup values.
type ApplicationSecurityGroupListResultIterator struct {
	i    int
	page ApplicationSecurityGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationSecurityGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationSecurityGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationSecurityGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationSecurityGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationSecurityGroupListResultIterator) Response() ApplicationSecurityGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationSecurityGroupListResultIterator) Value() ApplicationSecurityGroup {
	if !iter.page.NotDone() {
		return ApplicationSecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationSecurityGroupListResultIterator type.
func NewApplicationSecurityGroupListResultIterator(page ApplicationSecurityGroupListResultPage) ApplicationSecurityGroupListResultIterator {
	return ApplicationSecurityGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asglr ApplicationSecurityGroupListResult) IsEmpty() bool {
	return asglr.Value == nil || len(*asglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asglr ApplicationSecurityGroupListResult) hasNextLink() bool {
	return asglr.NextLink != nil && len(*asglr.NextLink) != 0
}

// applicationSecurityGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asglr ApplicationSecurityGroupListResult) applicationSecurityGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !asglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asglr.NextLink)))
}

// ApplicationSecurityGroupListResultPage contains a page of ApplicationSecurityGroup values.
type ApplicationSecurityGroupListResultPage struct {
	fn    func(context.Context, ApplicationSecurityGroupListResult) (ApplicationSecurityGroupListResult, error)
	asglr ApplicationSecurityGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationSecurityGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationSecurityGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asglr)
		if err != nil {
			return err
		}
		page.asglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationSecurityGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationSecurityGroupListResultPage) NotDone() bool {
	return !page.asglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationSecurityGroupListResultPage) Response() ApplicationSecurityGroupListResult {
	return page.asglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationSecurityGroupListResultPage) Values() []ApplicationSecurityGroup {
	if page.asglr.IsEmpty() {
		return nil
	}
	return *page.asglr.Value
}

// Creates a new instance of the ApplicationSecurityGroupListResultPage type.
func NewApplicationSecurityGroupListResultPage(cur ApplicationSecurityGroupListResult, getNextPage func(context.Context, ApplicationSecurityGroupListResult) (ApplicationSecurityGroupListResult, error)) ApplicationSecurityGroupListResultPage {
	return ApplicationSecurityGroupListResultPage{
		fn:    getNextPage,
		asglr: cur,
	}
}

// ApplicationSecurityGroupPropertiesFormat application security group properties.
type ApplicationSecurityGroupPropertiesFormat struct {
	// ResourceGUID - READ-ONLY; The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application security group resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ApplicationSecurityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ApplicationSecurityGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationSecurityGroupsClient) (ApplicationSecurityGroup, error)
}

// ApplicationSecurityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationSecurityGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationSecurityGroupsClient) (autorest.Response, error)
}

// ApplicationSecurityGroupsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationSecurityGroupsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationSecurityGroupsClient) (ApplicationSecurityGroup, error)
}

// AuthorizationListResult response for ListAuthorizations API service call retrieves all authorizations
// that belongs to an ExpressRouteCircuit.
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	// Value - The authorizations in an ExpressRoute Circuit.
	Value *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationListResultIterator provides access to a complete listing of
// ExpressRouteCircuitAuthorization values.
type AuthorizationListResultIterator struct {
	i    int
	page AuthorizationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationListResultIterator) Response() AuthorizationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationListResultIterator) Value() ExpressRouteCircuitAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationListResultIterator type.
func NewAuthorizationListResultIterator(page AuthorizationListResultPage) AuthorizationListResultIterator {
	return AuthorizationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AuthorizationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AuthorizationListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// authorizationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AuthorizationListResult) authorizationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AuthorizationListResultPage contains a page of ExpressRouteCircuitAuthorization values.
type AuthorizationListResultPage struct {
	fn  func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)
	alr AuthorizationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationListResultPage) Response() AuthorizationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationListResultPage) Values() []ExpressRouteCircuitAuthorization {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AuthorizationListResultPage type.
func NewAuthorizationListResultPage(cur AuthorizationListResult, getNextPage func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)) AuthorizationListResultPage {
	return AuthorizationListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AuthorizationPropertiesFormat properties of ExpressRouteCircuitAuthorization.
type AuthorizationPropertiesFormat struct {
	// AuthorizationKey - The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// AuthorizationUseStatus - The authorization use status. Possible values include: 'Available', 'InUse'
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	// ProvisioningState - The provisioning state of the authorization resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// AutoApprovedPrivateLinkService the information of an AutoApprovedPrivateLinkService.
type AutoApprovedPrivateLinkService struct {
	// PrivateLinkService - The id of the private link service resource.
	PrivateLinkService *string `json:"privateLinkService,omitempty"`
}

// AutoApprovedPrivateLinkServicesResult an array of private link service id that can be linked to a
// private end point with auto approved.
type AutoApprovedPrivateLinkServicesResult struct {
	autorest.Response `json:"-"`
	// Value - An array of auto approved private link service.
	Value *[]AutoApprovedPrivateLinkService `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoApprovedPrivateLinkServicesResult.
func (aaplsr AutoApprovedPrivateLinkServicesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aaplsr.Value != nil {
		objectMap["value"] = aaplsr.Value
	}
	return json.Marshal(objectMap)
}

// AutoApprovedPrivateLinkServicesResultIterator provides access to a complete listing of
// AutoApprovedPrivateLinkService values.
type AutoApprovedPrivateLinkServicesResultIterator struct {
	i    int
	page AutoApprovedPrivateLinkServicesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoApprovedPrivateLinkServicesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoApprovedPrivateLinkServicesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoApprovedPrivateLinkServicesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoApprovedPrivateLinkServicesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoApprovedPrivateLinkServicesResultIterator) Response() AutoApprovedPrivateLinkServicesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoApprovedPrivateLinkServicesResultIterator) Value() AutoApprovedPrivateLinkService {
	if !iter.page.NotDone() {
		return AutoApprovedPrivateLinkService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoApprovedPrivateLinkServicesResultIterator type.
func NewAutoApprovedPrivateLinkServicesResultIterator(page AutoApprovedPrivateLinkServicesResultPage) AutoApprovedPrivateLinkServicesResultIterator {
	return AutoApprovedPrivateLinkServicesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aaplsr AutoApprovedPrivateLinkServicesResult) IsEmpty() bool {
	return aaplsr.Value == nil || len(*aaplsr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aaplsr AutoApprovedPrivateLinkServicesResult) hasNextLink() bool {
	return aaplsr.NextLink != nil && len(*aaplsr.NextLink) != 0
}

// autoApprovedPrivateLinkServicesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aaplsr AutoApprovedPrivateLinkServicesResult) autoApprovedPrivateLinkServicesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aaplsr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aaplsr.NextLink)))
}

// AutoApprovedPrivateLinkServicesResultPage contains a page of AutoApprovedPrivateLinkService values.
type AutoApprovedPrivateLinkServicesResultPage struct {
	fn     func(context.Context, AutoApprovedPrivateLinkServicesResult) (AutoApprovedPrivateLinkServicesResult, error)
	aaplsr AutoApprovedPrivateLinkServicesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoApprovedPrivateLinkServicesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoApprovedPrivateLinkServicesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aaplsr)
		if err != nil {
			return err
		}
		page.aaplsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoApprovedPrivateLinkServicesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoApprovedPrivateLinkServicesResultPage) NotDone() bool {
	return !page.aaplsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoApprovedPrivateLinkServicesResultPage) Response() AutoApprovedPrivateLinkServicesResult {
	return page.aaplsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoApprovedPrivateLinkServicesResultPage) Values() []AutoApprovedPrivateLinkService {
	if page.aaplsr.IsEmpty() {
		return nil
	}
	return *page.aaplsr.Value
}

// Creates a new instance of the AutoApprovedPrivateLinkServicesResultPage type.
func NewAutoApprovedPrivateLinkServicesResultPage(cur AutoApprovedPrivateLinkServicesResult, getNextPage func(context.Context, AutoApprovedPrivateLinkServicesResult) (AutoApprovedPrivateLinkServicesResult, error)) AutoApprovedPrivateLinkServicesResultPage {
	return AutoApprovedPrivateLinkServicesResultPage{
		fn:     getNextPage,
		aaplsr: cur,
	}
}

// Availability availability of the metric.
type Availability struct {
	// TimeGrain - The time grain of the availability.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - The retention of the availability.
	Retention *string `json:"retention,omitempty"`
	// BlobDuration - Duration of the availability blob.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// AvailableDelegation the serviceName of an AvailableDelegation indicates a possible delegation for a
// subnet.
type AvailableDelegation struct {
	// Name - The name of the AvailableDelegation resource.
	Name *string `json:"name,omitempty"`
	// ID - A unique identifier of the AvailableDelegation resource.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ServiceName - The name of the service and resource.
	ServiceName *string `json:"serviceName,omitempty"`
	// Actions - Describes the actions permitted to the service upon delegation.
	Actions *[]string `json:"actions,omitempty"`
}

// AvailableDelegationsResult an array of available delegations.
type AvailableDelegationsResult struct {
	autorest.Response `json:"-"`
	// Value - An array of available delegations.
	Value *[]AvailableDelegation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableDelegationsResult.
func (adr AvailableDelegationsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adr.Value != nil {
		objectMap["value"] = adr.Value
	}
	return json.Marshal(objectMap)
}

// AvailableDelegationsResultIterator provides access to a complete listing of AvailableDelegation values.
type AvailableDelegationsResultIterator struct {
	i    int
	page AvailableDelegationsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableDelegationsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableDelegationsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableDelegationsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableDelegationsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableDelegationsResultIterator) Response() AvailableDelegationsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableDelegationsResultIterator) Value() AvailableDelegation {
	if !iter.page.NotDone() {
		return AvailableDelegation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableDelegationsResultIterator type.
func NewAvailableDelegationsResultIterator(page AvailableDelegationsResultPage) AvailableDelegationsResultIterator {
	return AvailableDelegationsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (adr AvailableDelegationsResult) IsEmpty() bool {
	return adr.Value == nil || len(*adr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (adr AvailableDelegationsResult) hasNextLink() bool {
	return adr.NextLink != nil && len(*adr.NextLink) != 0
}

// availableDelegationsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (adr AvailableDelegationsResult) availableDelegationsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !adr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(adr.NextLink)))
}

// AvailableDelegationsResultPage contains a page of AvailableDelegation values.
type AvailableDelegationsResultPage struct {
	fn  func(context.Context, AvailableDelegationsResult) (AvailableDelegationsResult, error)
	adr AvailableDelegationsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableDelegationsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableDelegationsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.adr)
		if err != nil {
			return err
		}
		page.adr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableDelegationsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableDelegationsResultPage) NotDone() bool {
	return !page.adr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableDelegationsResultPage) Response() AvailableDelegationsResult {
	return page.adr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableDelegationsResultPage) Values() []AvailableDelegation {
	if page.adr.IsEmpty() {
		return nil
	}
	return *page.adr.Value
}

// Creates a new instance of the AvailableDelegationsResultPage type.
func NewAvailableDelegationsResultPage(cur AvailableDelegationsResult, getNextPage func(context.Context, AvailableDelegationsResult) (AvailableDelegationsResult, error)) AvailableDelegationsResultPage {
	return AvailableDelegationsResultPage{
		fn:  getNextPage,
		adr: cur,
	}
}

// AvailablePrivateEndpointType the information of an AvailablePrivateEndpointType.
type AvailablePrivateEndpointType struct {
	// Name - The name of the service and resource.
	Name *string `json:"name,omitempty"`
	// ID - A unique identifier of the AvailablePrivateEndpoint Type resource.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ResourceName - The name of the service and resource.
	ResourceName *string `json:"resourceName,omitempty"`
}

// AvailablePrivateEndpointTypesResult an array of available PrivateEndpoint types.
type AvailablePrivateEndpointTypesResult struct {
	autorest.Response `json:"-"`
	// Value - An array of available privateEndpoint type.
	Value *[]AvailablePrivateEndpointType `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailablePrivateEndpointTypesResult.
func (apetr AvailablePrivateEndpointTypesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apetr.Value != nil {
		objectMap["value"] = apetr.Value
	}
	return json.Marshal(objectMap)
}

// AvailablePrivateEndpointTypesResultIterator provides access to a complete listing of
// AvailablePrivateEndpointType values.
type AvailablePrivateEndpointTypesResultIterator struct {
	i    int
	page AvailablePrivateEndpointTypesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailablePrivateEndpointTypesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailablePrivateEndpointTypesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailablePrivateEndpointTypesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailablePrivateEndpointTypesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailablePrivateEndpointTypesResultIterator) Response() AvailablePrivateEndpointTypesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailablePrivateEndpointTypesResultIterator) Value() AvailablePrivateEndpointType {
	if !iter.page.NotDone() {
		return AvailablePrivateEndpointType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailablePrivateEndpointTypesResultIterator type.
func NewAvailablePrivateEndpointTypesResultIterator(page AvailablePrivateEndpointTypesResultPage) AvailablePrivateEndpointTypesResultIterator {
	return AvailablePrivateEndpointTypesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apetr AvailablePrivateEndpointTypesResult) IsEmpty() bool {
	return apetr.Value == nil || len(*apetr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apetr AvailablePrivateEndpointTypesResult) hasNextLink() bool {
	return apetr.NextLink != nil && len(*apetr.NextLink) != 0
}

// availablePrivateEndpointTypesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apetr AvailablePrivateEndpointTypesResult) availablePrivateEndpointTypesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !apetr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apetr.NextLink)))
}

// AvailablePrivateEndpointTypesResultPage contains a page of AvailablePrivateEndpointType values.
type AvailablePrivateEndpointTypesResultPage struct {
	fn    func(context.Context, AvailablePrivateEndpointTypesResult) (AvailablePrivateEndpointTypesResult, error)
	apetr AvailablePrivateEndpointTypesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailablePrivateEndpointTypesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailablePrivateEndpointTypesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apetr)
		if err != nil {
			return err
		}
		page.apetr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailablePrivateEndpointTypesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailablePrivateEndpointTypesResultPage) NotDone() bool {
	return !page.apetr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailablePrivateEndpointTypesResultPage) Response() AvailablePrivateEndpointTypesResult {
	return page.apetr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailablePrivateEndpointTypesResultPage) Values() []AvailablePrivateEndpointType {
	if page.apetr.IsEmpty() {
		return nil
	}
	return *page.apetr.Value
}

// Creates a new instance of the AvailablePrivateEndpointTypesResultPage type.
func NewAvailablePrivateEndpointTypesResultPage(cur AvailablePrivateEndpointTypesResult, getNextPage func(context.Context, AvailablePrivateEndpointTypesResult) (AvailablePrivateEndpointTypesResult, error)) AvailablePrivateEndpointTypesResultPage {
	return AvailablePrivateEndpointTypesResultPage{
		fn:    getNextPage,
		apetr: cur,
	}
}

// AvailableProvidersList list of available countries with details.
type AvailableProvidersList struct {
	autorest.Response `json:"-"`
	// Countries - List of available countries.
	Countries *[]AvailableProvidersListCountry `json:"countries,omitempty"`
}

// AvailableProvidersListCity city or town details.
type AvailableProvidersListCity struct {
	// CityName - The city or town name.
	CityName *string `json:"cityName,omitempty"`
	// Providers - A list of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
}

// AvailableProvidersListCountry country details.
type AvailableProvidersListCountry struct {
	// CountryName - The country name.
	CountryName *string `json:"countryName,omitempty"`
	// Providers - A list of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
	// States - List of available states in the country.
	States *[]AvailableProvidersListState `json:"states,omitempty"`
}

// AvailableProvidersListParameters constraints that determine the list of available Internet service
// providers.
type AvailableProvidersListParameters struct {
	// AzureLocations - A list of Azure regions.
	AzureLocations *[]string `json:"azureLocations,omitempty"`
	// Country - The country for available providers list.
	Country *string `json:"country,omitempty"`
	// State - The state for available providers list.
	State *string `json:"state,omitempty"`
	// City - The city or town for available providers list.
	City *string `json:"city,omitempty"`
}

// AvailableProvidersListState state details.
type AvailableProvidersListState struct {
	// StateName - The state name.
	StateName *string `json:"stateName,omitempty"`
	// Providers - A list of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
	// Cities - List of available cities or towns in the state.
	Cities *[]AvailableProvidersListCity `json:"cities,omitempty"`
}

// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct
// from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous
// operation succeeded, the response body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request
// and error information regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the Azure async operation. Possible values include: 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusFailed'
	Status OperationStatus `json:"status,omitempty"`
	// Error - Details of the error occurred during specified asynchronous operation.
	Error *Error `json:"error,omitempty"`
}

// AzureFirewall azure Firewall resource.
type AzureFirewall struct {
	autorest.Response `json:"-"`
	// AzureFirewallPropertiesFormat - Properties of the azure firewall.
	*AzureFirewallPropertiesFormat `json:"properties,omitempty"`
	// Zones - A list of availability zones denoting where the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureFirewall.
func (af AzureFirewall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if af.AzureFirewallPropertiesFormat != nil {
		objectMap["properties"] = af.AzureFirewallPropertiesFormat
	}
	if af.Zones != nil {
		objectMap["zones"] = af.Zones
	}
	if af.ID != nil {
		objectMap["id"] = af.ID
	}
	if af.Location != nil {
		objectMap["location"] = af.Location
	}
	if af.Tags != nil {
		objectMap["tags"] = af.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewall struct.
func (af *AzureFirewall) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallPropertiesFormat AzureFirewallPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallPropertiesFormat)
				if err != nil {
					return err
				}
				af.AzureFirewallPropertiesFormat = &azureFirewallPropertiesFormat
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				af.Zones = &zones
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				af.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				af.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				af.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				af.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				af.Tags = tags
			}
		}
	}

	return nil
}

// AzureFirewallApplicationRule properties of an application rule.
type AzureFirewallApplicationRule struct {
	// Name - Name of the application rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// Protocols - Array of ApplicationRuleProtocols.
	Protocols *[]AzureFirewallApplicationRuleProtocol `json:"protocols,omitempty"`
	// TargetFqdns - List of FQDNs for this rule.
	TargetFqdns *[]string `json:"targetFqdns,omitempty"`
	// FqdnTags - List of FQDN Tags for this rule.
	FqdnTags *[]string `json:"fqdnTags,omitempty"`
}

// AzureFirewallApplicationRuleCollection application rule collection resource.
type AzureFirewallApplicationRuleCollection struct {
	// AzureFirewallApplicationRuleCollectionPropertiesFormat - Properties of the azure firewall application rule collection.
	*AzureFirewallApplicationRuleCollectionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallApplicationRuleCollection.
func (afarc AzureFirewallApplicationRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afarc.AzureFirewallApplicationRuleCollectionPropertiesFormat != nil {
		objectMap["properties"] = afarc.AzureFirewallApplicationRuleCollectionPropertiesFormat
	}
	if afarc.Name != nil {
		objectMap["name"] = afarc.Name
	}
	if afarc.ID != nil {
		objectMap["id"] = afarc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallApplicationRuleCollection struct.
func (afarc *AzureFirewallApplicationRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallApplicationRuleCollectionPropertiesFormat AzureFirewallApplicationRuleCollectionPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallApplicationRuleCollectionPropertiesFormat)
				if err != nil {
					return err
				}
				afarc.AzureFirewallApplicationRuleCollectionPropertiesFormat = &azureFirewallApplicationRuleCollectionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afarc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afarc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afarc.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallApplicationRuleCollectionPropertiesFormat properties of the application rule collection.
type AzureFirewallApplicationRuleCollectionPropertiesFormat struct {
	// Priority - Priority of the application rule collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// Action - The action type of a rule collection.
	Action *AzureFirewallRCAction `json:"action,omitempty"`
	// Rules - Collection of rules used by a application rule collection.
	Rules *[]AzureFirewallApplicationRule `json:"rules,omitempty"`
	// ProvisioningState - The provisioning state of the application rule collection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// AzureFirewallApplicationRuleProtocol properties of the application rule protocol.
type AzureFirewallApplicationRuleProtocol struct {
	// ProtocolType - Protocol type. Possible values include: 'AzureFirewallApplicationRuleProtocolTypeHTTP', 'AzureFirewallApplicationRuleProtocolTypeHTTPS', 'AzureFirewallApplicationRuleProtocolTypeMssql'
	ProtocolType AzureFirewallApplicationRuleProtocolType `json:"protocolType,omitempty"`
	// Port - Port number for the protocol, cannot be greater than 64000. This field is optional.
	Port *int32 `json:"port,omitempty"`
}

// AzureFirewallFqdnTag azure Firewall FQDN Tag Resource.
type AzureFirewallFqdnTag struct {
	// AzureFirewallFqdnTagPropertiesFormat - Properties of the azure firewall FQDN tag.
	*AzureFirewallFqdnTagPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureFirewallFqdnTag.
func (afft AzureFirewallFqdnTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afft.AzureFirewallFqdnTagPropertiesFormat != nil {
		objectMap["properties"] = afft.AzureFirewallFqdnTagPropertiesFormat
	}
	if afft.ID != nil {
		objectMap["id"] = afft.ID
	}
	if afft.Location != nil {
		objectMap["location"] = afft.Location
	}
	if afft.Tags != nil {
		objectMap["tags"] = afft.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallFqdnTag struct.
func (afft *AzureFirewallFqdnTag) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallFqdnTagPropertiesFormat AzureFirewallFqdnTagPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallFqdnTagPropertiesFormat)
				if err != nil {
					return err
				}
				afft.AzureFirewallFqdnTagPropertiesFormat = &azureFirewallFqdnTagPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afft.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afft.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afft.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				afft.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				afft.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				afft.Tags = tags
			}
		}
	}

	return nil
}

// AzureFirewallFqdnTagListResult response for ListAzureFirewallFqdnTags API service call.
type AzureFirewallFqdnTagListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Firewall FQDN Tags in a resource group.
	Value *[]AzureFirewallFqdnTag `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureFirewallFqdnTagListResultIterator provides access to a complete listing of AzureFirewallFqdnTag
// values.
type AzureFirewallFqdnTagListResultIterator struct {
	i    int
	page AzureFirewallFqdnTagListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureFirewallFqdnTagListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallFqdnTagListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureFirewallFqdnTagListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureFirewallFqdnTagListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureFirewallFqdnTagListResultIterator) Response() AzureFirewallFqdnTagListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureFirewallFqdnTagListResultIterator) Value() AzureFirewallFqdnTag {
	if !iter.page.NotDone() {
		return AzureFirewallFqdnTag{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureFirewallFqdnTagListResultIterator type.
func NewAzureFirewallFqdnTagListResultIterator(page AzureFirewallFqdnTagListResultPage) AzureFirewallFqdnTagListResultIterator {
	return AzureFirewallFqdnTagListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (afftlr AzureFirewallFqdnTagListResult) IsEmpty() bool {
	return afftlr.Value == nil || len(*afftlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (afftlr AzureFirewallFqdnTagListResult) hasNextLink() bool {
	return afftlr.NextLink != nil && len(*afftlr.NextLink) != 0
}

// azureFirewallFqdnTagListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (afftlr AzureFirewallFqdnTagListResult) azureFirewallFqdnTagListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !afftlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(afftlr.NextLink)))
}

// AzureFirewallFqdnTagListResultPage contains a page of AzureFirewallFqdnTag values.
type AzureFirewallFqdnTagListResultPage struct {
	fn     func(context.Context, AzureFirewallFqdnTagListResult) (AzureFirewallFqdnTagListResult, error)
	afftlr AzureFirewallFqdnTagListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureFirewallFqdnTagListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallFqdnTagListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.afftlr)
		if err != nil {
			return err
		}
		page.afftlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureFirewallFqdnTagListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureFirewallFqdnTagListResultPage) NotDone() bool {
	return !page.afftlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureFirewallFqdnTagListResultPage) Response() AzureFirewallFqdnTagListResult {
	return page.afftlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureFirewallFqdnTagListResultPage) Values() []AzureFirewallFqdnTag {
	if page.afftlr.IsEmpty() {
		return nil
	}
	return *page.afftlr.Value
}

// Creates a new instance of the AzureFirewallFqdnTagListResultPage type.
func NewAzureFirewallFqdnTagListResultPage(cur AzureFirewallFqdnTagListResult, getNextPage func(context.Context, AzureFirewallFqdnTagListResult) (AzureFirewallFqdnTagListResult, error)) AzureFirewallFqdnTagListResultPage {
	return AzureFirewallFqdnTagListResultPage{
		fn:     getNextPage,
		afftlr: cur,
	}
}

// AzureFirewallFqdnTagPropertiesFormat azure Firewall FQDN Tag Properties.
type AzureFirewallFqdnTagPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the Azure firewall FQDN tag resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// FqdnTagName - READ-ONLY; The name of this FQDN Tag.
	FqdnTagName *string `json:"fqdnTagName,omitempty"`
}

// AzureFirewallIPConfiguration IP configuration of an Azure Firewall.
type AzureFirewallIPConfiguration struct {
	// AzureFirewallIPConfigurationPropertiesFormat - Properties of the azure firewall IP configuration.
	*AzureFirewallIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallIPConfiguration.
func (afic AzureFirewallIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afic.AzureFirewallIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = afic.AzureFirewallIPConfigurationPropertiesFormat
	}
	if afic.Name != nil {
		objectMap["name"] = afic.Name
	}
	if afic.ID != nil {
		objectMap["id"] = afic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallIPConfiguration struct.
func (afic *AzureFirewallIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallIPConfigurationPropertiesFormat AzureFirewallIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				afic.AzureFirewallIPConfigurationPropertiesFormat = &azureFirewallIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afic.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallIPConfigurationPropertiesFormat properties of IP configuration of an Azure Firewall.
type AzureFirewallIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - READ-ONLY; The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// Subnet - Reference of the subnet resource. This resource must be named 'AzureFirewallSubnet'.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference of the PublicIP resource. This field is a mandatory input if subnet is not null.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - The provisioning state of the Azure firewall IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallIPConfigurationPropertiesFormat.
func (aficpf AzureFirewallIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aficpf.Subnet != nil {
		objectMap["subnet"] = aficpf.Subnet
	}
	if aficpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = aficpf.PublicIPAddress
	}
	if aficpf.ProvisioningState != "" {
		objectMap["provisioningState"] = aficpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// AzureFirewallListResult response for ListAzureFirewalls API service call.
type AzureFirewallListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Firewalls in a resource group.
	Value *[]AzureFirewall `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureFirewallListResultIterator provides access to a complete listing of AzureFirewall values.
type AzureFirewallListResultIterator struct {
	i    int
	page AzureFirewallListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureFirewallListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureFirewallListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureFirewallListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureFirewallListResultIterator) Response() AzureFirewallListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureFirewallListResultIterator) Value() AzureFirewall {
	if !iter.page.NotDone() {
		return AzureFirewall{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureFirewallListResultIterator type.
func NewAzureFirewallListResultIterator(page AzureFirewallListResultPage) AzureFirewallListResultIterator {
	return AzureFirewallListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aflr AzureFirewallListResult) IsEmpty() bool {
	return aflr.Value == nil || len(*aflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aflr AzureFirewallListResult) hasNextLink() bool {
	return aflr.NextLink != nil && len(*aflr.NextLink) != 0
}

// azureFirewallListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aflr AzureFirewallListResult) azureFirewallListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aflr.NextLink)))
}

// AzureFirewallListResultPage contains a page of AzureFirewall values.
type AzureFirewallListResultPage struct {
	fn   func(context.Context, AzureFirewallListResult) (AzureFirewallListResult, error)
	aflr AzureFirewallListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureFirewallListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aflr)
		if err != nil {
			return err
		}
		page.aflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureFirewallListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureFirewallListResultPage) NotDone() bool {
	return !page.aflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureFirewallListResultPage) Response() AzureFirewallListResult {
	return page.aflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureFirewallListResultPage) Values() []AzureFirewall {
	if page.aflr.IsEmpty() {
		return nil
	}
	return *page.aflr.Value
}

// Creates a new instance of the AzureFirewallListResultPage type.
func NewAzureFirewallListResultPage(cur AzureFirewallListResult, getNextPage func(context.Context, AzureFirewallListResult) (AzureFirewallListResult, error)) AzureFirewallListResultPage {
	return AzureFirewallListResultPage{
		fn:   getNextPage,
		aflr: cur,
	}
}

// AzureFirewallNatRCAction azureFirewall NAT Rule Collection Action.
type AzureFirewallNatRCAction struct {
	// Type - The type of action. Possible values include: 'Snat', 'Dnat'
	Type AzureFirewallNatRCActionType `json:"type,omitempty"`
}

// AzureFirewallNatRule properties of a NAT rule.
type AzureFirewallNatRule struct {
	// Name - Name of the NAT rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// DestinationPorts - List of destination ports.
	DestinationPorts *[]string `json:"destinationPorts,omitempty"`
	// Protocols - Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
	Protocols *[]AzureFirewallNetworkRuleProtocol `json:"protocols,omitempty"`
	// TranslatedAddress - The translated address for this NAT rule.
	TranslatedAddress *string `json:"translatedAddress,omitempty"`
	// TranslatedPort - The translated port for this NAT rule.
	TranslatedPort *string `json:"translatedPort,omitempty"`
}

// AzureFirewallNatRuleCollection NAT rule collection resource.
type AzureFirewallNatRuleCollection struct {
	// AzureFirewallNatRuleCollectionProperties - Properties of the azure firewall NAT rule collection.
	*AzureFirewallNatRuleCollectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallNatRuleCollection.
func (afnrc AzureFirewallNatRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afnrc.AzureFirewallNatRuleCollectionProperties != nil {
		objectMap["properties"] = afnrc.AzureFirewallNatRuleCollectionProperties
	}
	if afnrc.Name != nil {
		objectMap["name"] = afnrc.Name
	}
	if afnrc.ID != nil {
		objectMap["id"] = afnrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallNatRuleCollection struct.
func (afnrc *AzureFirewallNatRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallNatRuleCollectionProperties AzureFirewallNatRuleCollectionProperties
				err = json.Unmarshal(*v, &azureFirewallNatRuleCollectionProperties)
				if err != nil {
					return err
				}
				afnrc.AzureFirewallNatRuleCollectionProperties = &azureFirewallNatRuleCollectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afnrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afnrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afnrc.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallNatRuleCollectionProperties properties of the NAT rule collection.
type AzureFirewallNatRuleCollectionProperties struct {
	// Priority - Priority of the NAT rule collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// Action - The action type of a NAT rule collection.
	Action *AzureFirewallNatRCAction `json:"action,omitempty"`
	// Rules - Collection of rules used by a NAT rule collection.
	Rules *[]AzureFirewallNatRule `json:"rules,omitempty"`
	// ProvisioningState - The provisioning state of the NAT rule collection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// AzureFirewallNetworkRule properties of the network rule.
type AzureFirewallNetworkRule struct {
	// Name - Name of the network rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// Protocols - Array of AzureFirewallNetworkRuleProtocols.
	Protocols *[]AzureFirewallNetworkRuleProtocol `json:"protocols,omitempty"`
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// DestinationPorts - List of destination ports.
	DestinationPorts *[]string `json:"destinationPorts,omitempty"`
}

// AzureFirewallNetworkRuleCollection network rule collection resource.
type AzureFirewallNetworkRuleCollection struct {
	// AzureFirewallNetworkRuleCollectionPropertiesFormat - Properties of the azure firewall network rule collection.
	*AzureFirewallNetworkRuleCollectionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallNetworkRuleCollection.
func (afnrc AzureFirewallNetworkRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afnrc.AzureFirewallNetworkRuleCollectionPropertiesFormat != nil {
		objectMap["properties"] = afnrc.AzureFirewallNetworkRuleCollectionPropertiesFormat
	}
	if afnrc.Name != nil {
		objectMap["name"] = afnrc.Name
	}
	if afnrc.ID != nil {
		objectMap["id"] = afnrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallNetworkRuleCollection struct.
func (afnrc *AzureFirewallNetworkRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallNetworkRuleCollectionPropertiesFormat AzureFirewallNetworkRuleCollectionPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallNetworkRuleCollectionPropertiesFormat)
				if err != nil {
					return err
				}
				afnrc.AzureFirewallNetworkRuleCollectionPropertiesFormat = &azureFirewallNetworkRuleCollectionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afnrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afnrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afnrc.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallNetworkRuleCollectionPropertiesFormat properties of the network rule collection.
type AzureFirewallNetworkRuleCollectionPropertiesFormat struct {
	// Priority - Priority of the network rule collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// Action - The action type of a rule collection.
	Action *AzureFirewallRCAction `json:"action,omitempty"`
	// Rules - Collection of rules used by a network rule collection.
	Rules *[]AzureFirewallNetworkRule `json:"rules,omitempty"`
	// ProvisioningState - The provisioning state of the network rule collection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// AzureFirewallPropertiesFormat properties of the Azure Firewall.
type AzureFirewallPropertiesFormat struct {
	// ApplicationRuleCollections - Collection of application rule collections used by Azure Firewall.
	ApplicationRuleCollections *[]AzureFirewallApplicationRuleCollection `json:"applicationRuleCollections,omitempty"`
	// NatRuleCollections - Collection of NAT rule collections used by Azure Firewall.
	NatRuleCollections *[]AzureFirewallNatRuleCollection `json:"natRuleCollections,omitempty"`
	// NetworkRuleCollections - Collection of network rule collections used by Azure Firewall.
	NetworkRuleCollections *[]AzureFirewallNetworkRuleCollection `json:"networkRuleCollections,omitempty"`
	// IPConfigurations - IP configuration of the Azure Firewall resource.
	IPConfigurations *[]AzureFirewallIPConfiguration `json:"ipConfigurations,omitempty"`
	// ProvisioningState - The provisioning state of the Azure firewall resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ThreatIntelMode - The operation mode for Threat Intelligence. Possible values include: 'AzureFirewallThreatIntelModeAlert', 'AzureFirewallThreatIntelModeDeny', 'AzureFirewallThreatIntelModeOff'
	ThreatIntelMode AzureFirewallThreatIntelMode `json:"threatIntelMode,omitempty"`
	// VirtualHub - The virtualHub to which the firewall belongs.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`
	// FirewallPolicy - The firewallPolicy associated with this azure firewall.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`
	// HubIPAddresses - READ-ONLY; IP addresses associated with AzureFirewall.
	HubIPAddresses *HubIPAddresses `json:"hubIpAddresses,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallPropertiesFormat.
func (afpf AzureFirewallPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afpf.ApplicationRuleCollections != nil {
		objectMap["applicationRuleCollections"] = afpf.ApplicationRuleCollections
	}
	if afpf.NatRuleCollections != nil {
		objectMap["natRuleCollections"] = afpf.NatRuleCollections
	}
	if afpf.NetworkRuleCollections != nil {
		objectMap["networkRuleCollections"] = afpf.NetworkRuleCollections
	}
	if afpf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = afpf.IPConfigurations
	}
	if afpf.ProvisioningState != "" {
		objectMap["provisioningState"] = afpf.ProvisioningState
	}
	if afpf.ThreatIntelMode != "" {
		objectMap["threatIntelMode"] = afpf.ThreatIntelMode
	}
	if afpf.VirtualHub != nil {
		objectMap["virtualHub"] = afpf.VirtualHub
	}
	if afpf.FirewallPolicy != nil {
		objectMap["firewallPolicy"] = afpf.FirewallPolicy
	}
	return json.Marshal(objectMap)
}

// AzureFirewallPublicIPAddress public IP Address associated with azure firewall.
type AzureFirewallPublicIPAddress struct {
	// Address - Public IP Address value.
	Address *string `json:"address,omitempty"`
}

// AzureFirewallRCAction properties of the AzureFirewallRCAction.
type AzureFirewallRCAction struct {
	// Type - The type of action. Possible values include: 'AzureFirewallRCActionTypeAllow', 'AzureFirewallRCActionTypeDeny'
	Type AzureFirewallRCActionType `json:"type,omitempty"`
}

// AzureFirewallsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureFirewallsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureFirewallsClient) (AzureFirewall, error)
}

// AzureFirewallsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AzureFirewallsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureFirewallsClient) (autorest.Response, error)
}

// AzureReachabilityReport azure reachability report details.
type AzureReachabilityReport struct {
	autorest.Response `json:"-"`
	// AggregationLevel - The aggregation level of Azure reachability report. Can be Country, State or City.
	AggregationLevel *string `json:"aggregationLevel,omitempty"`
	// ProviderLocation - Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation `json:"providerLocation,omitempty"`
	// ReachabilityReport - List of Azure reachability report items.
	ReachabilityReport *[]AzureReachabilityReportItem `json:"reachabilityReport,omitempty"`
}

// AzureReachabilityReportItem azure reachability report details for a given provider location.
type AzureReachabilityReportItem struct {
	// Provider - The Internet service provider.
	Provider *string `json:"provider,omitempty"`
	// AzureLocation - The Azure region.
	AzureLocation *string `json:"azureLocation,omitempty"`
	// Latencies - List of latency details for each of the time series.
	Latencies *[]AzureReachabilityReportLatencyInfo `json:"latencies,omitempty"`
}

// AzureReachabilityReportLatencyInfo details on latency for a time series.
type AzureReachabilityReportLatencyInfo struct {
	// TimeStamp - The time stamp.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// Score - The relative latency score between 1 and 100, higher values indicating a faster connection.
	Score *int32 `json:"score,omitempty"`
}

// AzureReachabilityReportLocation parameters that define a geographic location.
type AzureReachabilityReportLocation struct {
	// Country - The name of the country.
	Country *string `json:"country,omitempty"`
	// State - The name of the state.
	State *string `json:"state,omitempty"`
	// City - The name of the city or town.
	City *string `json:"city,omitempty"`
}

// AzureReachabilityReportParameters geographic and time constraints for Azure reachability report.
type AzureReachabilityReportParameters struct {
	// ProviderLocation - Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation `json:"providerLocation,omitempty"`
	// Providers - List of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
	// AzureLocations - Optional Azure regions to scope the query to.
	AzureLocations *[]string `json:"azureLocations,omitempty"`
	// StartTime - The start time for the Azure reachability report.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time for the Azure reachability report.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// BackendAddressPool pool of backend IP addresses.
type BackendAddressPool struct {
	autorest.Response `json:"-"`
	// BackendAddressPoolPropertiesFormat - Properties of load balancer backend address pool.
	*BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPool.
func (bap BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bap.BackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = bap.BackendAddressPoolPropertiesFormat
	}
	if bap.Name != nil {
		objectMap["name"] = bap.Name
	}
	if bap.Etag != nil {
		objectMap["etag"] = bap.Etag
	}
	if bap.ID != nil {
		objectMap["id"] = bap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendAddressPool struct.
func (bap *BackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendAddressPoolPropertiesFormat BackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &backendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				bap.BackendAddressPoolPropertiesFormat = &backendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bap.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bap.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bap.ID = &ID
			}
		}
	}

	return nil
}

// BackendAddressPoolPropertiesFormat properties of the backend address pool.
type BackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - READ-ONLY; An array of references to IP addresses defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// LoadBalancingRules - READ-ONLY; An array of references to load balancing rules that use this backend address pool.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// OutboundRule - READ-ONLY; A reference to an outbound rule that uses this backend address pool.
	OutboundRule *SubResource `json:"outboundRule,omitempty"`
	// OutboundRules - READ-ONLY; An array of references to outbound rules that use this backend address pool.
	OutboundRules *[]SubResource `json:"outboundRules,omitempty"`
	// ProvisioningState - The provisioning state of the backend address pool resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPoolPropertiesFormat.
func (bappf BackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bappf.ProvisioningState != "" {
		objectMap["provisioningState"] = bappf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// BastionHost bastion Host resource.
type BastionHost struct {
	autorest.Response `json:"-"`
	// BastionHostPropertiesFormat - Represents the bastion host resource.
	*BastionHostPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BastionHost.
func (bh BastionHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bh.BastionHostPropertiesFormat != nil {
		objectMap["properties"] = bh.BastionHostPropertiesFormat
	}
	if bh.ID != nil {
		objectMap["id"] = bh.ID
	}
	if bh.Location != nil {
		objectMap["location"] = bh.Location
	}
	if bh.Tags != nil {
		objectMap["tags"] = bh.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BastionHost struct.
func (bh *BastionHost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bastionHostPropertiesFormat BastionHostPropertiesFormat
				err = json.Unmarshal(*v, &bastionHostPropertiesFormat)
				if err != nil {
					return err
				}
				bh.BastionHostPropertiesFormat = &bastionHostPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bh.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bh.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bh.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bh.Tags = tags
			}
		}
	}

	return nil
}

// BastionHostIPConfiguration IP configuration of an Bastion Host.
type BastionHostIPConfiguration struct {
	// BastionHostIPConfigurationPropertiesFormat - Represents the ip configuration associated with the resource.
	*BastionHostIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Ip configuration type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BastionHostIPConfiguration.
func (bhic BastionHostIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bhic.BastionHostIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = bhic.BastionHostIPConfigurationPropertiesFormat
	}
	if bhic.Name != nil {
		objectMap["name"] = bhic.Name
	}
	if bhic.ID != nil {
		objectMap["id"] = bhic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BastionHostIPConfiguration struct.
func (bhic *BastionHostIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bastionHostIPConfigurationPropertiesFormat BastionHostIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &bastionHostIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				bhic.BastionHostIPConfigurationPropertiesFormat = &bastionHostIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bhic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bhic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bhic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bhic.ID = &ID
			}
		}
	}

	return nil
}

// BastionHostIPConfigurationPropertiesFormat properties of IP configuration of an Bastion Host.
type BastionHostIPConfigurationPropertiesFormat struct {
	// Subnet - Reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference of the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - The provisioning state of the bastion host IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateIPAllocationMethod - Private IP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
}

// BastionHostListResult response for ListBastionHosts API service call.
type BastionHostListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Bastion Hosts in a resource group.
	Value *[]BastionHost `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BastionHostListResultIterator provides access to a complete listing of BastionHost values.
type BastionHostListResultIterator struct {
	i    int
	page BastionHostListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BastionHostListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionHostListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BastionHostListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BastionHostListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BastionHostListResultIterator) Response() BastionHostListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BastionHostListResultIterator) Value() BastionHost {
	if !iter.page.NotDone() {
		return BastionHost{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BastionHostListResultIterator type.
func NewBastionHostListResultIterator(page BastionHostListResultPage) BastionHostListResultIterator {
	return BastionHostListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bhlr BastionHostListResult) IsEmpty() bool {
	return bhlr.Value == nil || len(*bhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bhlr BastionHostListResult) hasNextLink() bool {
	return bhlr.NextLink != nil && len(*bhlr.NextLink) != 0
}

// bastionHostListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bhlr BastionHostListResult) bastionHostListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bhlr.NextLink)))
}

// BastionHostListResultPage contains a page of BastionHost values.
type BastionHostListResultPage struct {
	fn   func(context.Context, BastionHostListResult) (BastionHostListResult, error)
	bhlr BastionHostListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BastionHostListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionHostListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bhlr)
		if err != nil {
			return err
		}
		page.bhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BastionHostListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BastionHostListResultPage) NotDone() bool {
	return !page.bhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BastionHostListResultPage) Response() BastionHostListResult {
	return page.bhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BastionHostListResultPage) Values() []BastionHost {
	if page.bhlr.IsEmpty() {
		return nil
	}
	return *page.bhlr.Value
}

// Creates a new instance of the BastionHostListResultPage type.
func NewBastionHostListResultPage(cur BastionHostListResult, getNextPage func(context.Context, BastionHostListResult) (BastionHostListResult, error)) BastionHostListResultPage {
	return BastionHostListResultPage{
		fn:   getNextPage,
		bhlr: cur,
	}
}

// BastionHostPropertiesFormat properties of the Bastion Host.
type BastionHostPropertiesFormat struct {
	// IPConfigurations - IP configuration of the Bastion Host resource.
	IPConfigurations *[]BastionHostIPConfiguration `json:"ipConfigurations,omitempty"`
	// DNSName - FQDN for the endpoint on which bastion host is accessible.
	DNSName *string `json:"dnsName,omitempty"`
	// ProvisioningState - The provisioning state of the bastion host resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// BastionHostsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BastionHostsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BastionHostsClient) (BastionHost, error)
}

// BastionHostsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BastionHostsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BastionHostsClient) (autorest.Response, error)
}

// BGPCommunity contains bgp community information offered in Service Community resources.
type BGPCommunity struct {
	// ServiceSupportedRegion - The region which the service support. e.g. For O365, region is Global.
	ServiceSupportedRegion *string `json:"serviceSupportedRegion,omitempty"`
	// CommunityName - The name of the bgp community. e.g. Skype.
	CommunityName *string `json:"communityName,omitempty"`
	// CommunityValue - The value of the bgp community. For more information: https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
	CommunityValue *string `json:"communityValue,omitempty"`
	// CommunityPrefixes - The prefixes that the bgp community contains.
	CommunityPrefixes *[]string `json:"communityPrefixes,omitempty"`
	// IsAuthorizedToUse - Customer is authorized to use bgp community or not.
	IsAuthorizedToUse *bool `json:"isAuthorizedToUse,omitempty"`
	// ServiceGroup - The service group of the bgp community contains.
	ServiceGroup *string `json:"serviceGroup,omitempty"`
}

// BgpPeerStatus BGP peer status details.
type BgpPeerStatus struct {
	// LocalAddress - READ-ONLY; The virtual network gateway's local address.
	LocalAddress *string `json:"localAddress,omitempty"`
	// Neighbor - READ-ONLY; The remote BGP peer.
	Neighbor *string `json:"neighbor,omitempty"`
	// Asn - READ-ONLY; The autonomous system number of the remote BGP peer.
	Asn *int32 `json:"asn,omitempty"`
	// State - READ-ONLY; The BGP peer state. Possible values include: 'BgpPeerStateUnknown', 'BgpPeerStateStopped', 'BgpPeerStateIdle', 'BgpPeerStateConnecting', 'BgpPeerStateConnected'
	State BgpPeerState `json:"state,omitempty"`
	// ConnectedDuration - READ-ONLY; For how long the peering has been up.
	ConnectedDuration *string `json:"connectedDuration,omitempty"`
	// RoutesReceived - READ-ONLY; The number of routes learned from this peer.
	RoutesReceived *int64 `json:"routesReceived,omitempty"`
	// MessagesSent - READ-ONLY; The number of BGP messages sent.
	MessagesSent *int64 `json:"messagesSent,omitempty"`
	// MessagesReceived - READ-ONLY; The number of BGP messages received.
	MessagesReceived *int64 `json:"messagesReceived,omitempty"`
}

// BgpPeerStatusListResult response for list BGP peer status API service call.
type BgpPeerStatusListResult struct {
	autorest.Response `json:"-"`
	// Value - List of BGP peers.
	Value *[]BgpPeerStatus `json:"value,omitempty"`
}

// BgpServiceCommunity service Community Properties.
type BgpServiceCommunity struct {
	// BgpServiceCommunityPropertiesFormat - Properties of the BGP service community.
	*BgpServiceCommunityPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BgpServiceCommunity.
func (bsc BgpServiceCommunity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsc.BgpServiceCommunityPropertiesFormat != nil {
		objectMap["properties"] = bsc.BgpServiceCommunityPropertiesFormat
	}
	if bsc.ID != nil {
		objectMap["id"] = bsc.ID
	}
	if bsc.Location != nil {
		objectMap["location"] = bsc.Location
	}
	if bsc.Tags != nil {
		objectMap["tags"] = bsc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BgpServiceCommunity struct.
func (bsc *BgpServiceCommunity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bgpServiceCommunityPropertiesFormat BgpServiceCommunityPropertiesFormat
				err = json.Unmarshal(*v, &bgpServiceCommunityPropertiesFormat)
				if err != nil {
					return err
				}
				bsc.BgpServiceCommunityPropertiesFormat = &bgpServiceCommunityPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bsc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bsc.Tags = tags
			}
		}
	}

	return nil
}

// BgpServiceCommunityListResult response for the ListServiceCommunity API service call.
type BgpServiceCommunityListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of service community resources.
	Value *[]BgpServiceCommunity `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BgpServiceCommunityListResultIterator provides access to a complete listing of BgpServiceCommunity
// values.
type BgpServiceCommunityListResultIterator struct {
	i    int
	page BgpServiceCommunityListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BgpServiceCommunityListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BgpServiceCommunityListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BgpServiceCommunityListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BgpServiceCommunityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BgpServiceCommunityListResultIterator) Response() BgpServiceCommunityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BgpServiceCommunityListResultIterator) Value() BgpServiceCommunity {
	if !iter.page.NotDone() {
		return BgpServiceCommunity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BgpServiceCommunityListResultIterator type.
func NewBgpServiceCommunityListResultIterator(page BgpServiceCommunityListResultPage) BgpServiceCommunityListResultIterator {
	return BgpServiceCommunityListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsclr BgpServiceCommunityListResult) IsEmpty() bool {
	return bsclr.Value == nil || len(*bsclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsclr BgpServiceCommunityListResult) hasNextLink() bool {
	return bsclr.NextLink != nil && len(*bsclr.NextLink) != 0
}

// bgpServiceCommunityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsclr BgpServiceCommunityListResult) bgpServiceCommunityListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bsclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsclr.NextLink)))
}

// BgpServiceCommunityListResultPage contains a page of BgpServiceCommunity values.
type BgpServiceCommunityListResultPage struct {
	fn    func(context.Context, BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)
	bsclr BgpServiceCommunityListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BgpServiceCommunityListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BgpServiceCommunityListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsclr)
		if err != nil {
			return err
		}
		page.bsclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BgpServiceCommunityListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BgpServiceCommunityListResultPage) NotDone() bool {
	return !page.bsclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BgpServiceCommunityListResultPage) Response() BgpServiceCommunityListResult {
	return page.bsclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BgpServiceCommunityListResultPage) Values() []BgpServiceCommunity {
	if page.bsclr.IsEmpty() {
		return nil
	}
	return *page.bsclr.Value
}

// Creates a new instance of the BgpServiceCommunityListResultPage type.
func NewBgpServiceCommunityListResultPage(cur BgpServiceCommunityListResult, getNextPage func(context.Context, BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)) BgpServiceCommunityListResultPage {
	return BgpServiceCommunityListResultPage{
		fn:    getNextPage,
		bsclr: cur,
	}
}

// BgpServiceCommunityPropertiesFormat properties of Service Community.
type BgpServiceCommunityPropertiesFormat struct {
	// ServiceName - The name of the bgp community. e.g. Skype.
	ServiceName *string `json:"serviceName,omitempty"`
	// BgpCommunities - A list of bgp communities.
	BgpCommunities *[]BGPCommunity `json:"bgpCommunities,omitempty"`
}

// BgpSettings BGP settings details.
type BgpSettings struct {
	// Asn - The BGP speaker's ASN.
	Asn *int64 `json:"asn,omitempty"`
	// BgpPeeringAddress - The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
	// PeerWeight - The weight added to routes learned from this BGP speaker.
	PeerWeight *int32 `json:"peerWeight,omitempty"`
}

// CheckPrivateLinkServiceVisibilityRequest request body of the CheckPrivateLinkServiceVisibility API
// service call.
type CheckPrivateLinkServiceVisibilityRequest struct {
	// PrivateLinkServiceAlias - The alias of the private link service.
	PrivateLinkServiceAlias *string `json:"privateLinkServiceAlias,omitempty"`
}

// CloudError an error response from the Batch service.
type CloudError struct {
	// Error - Cloud error body.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Batch service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ConfigurationDiagnosticParameters parameters to get network configuration diagnostic.
type ConfigurationDiagnosticParameters struct {
	// TargetResourceID - The ID of the target resource to perform network configuration diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application Gateway.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// VerbosityLevel - Verbosity level. Possible values include: 'Normal', 'Minimum', 'Full'
	VerbosityLevel VerbosityLevel `json:"verbosityLevel,omitempty"`
	// Profiles - List of network configuration diagnostic profiles.
	Profiles *[]ConfigurationDiagnosticProfile `json:"profiles,omitempty"`
}

// ConfigurationDiagnosticProfile parameters to compare with network configuration.
type ConfigurationDiagnosticProfile struct {
	// Direction - The direction of the traffic. Possible values include: 'Inbound', 'Outbound'
	Direction Direction `json:"direction,omitempty"`
	// Protocol - Protocol to be verified on. Accepted values are '*', TCP, UDP.
	Protocol *string `json:"protocol,omitempty"`
	// Source - Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag.
	Source *string `json:"source,omitempty"`
	// Destination - Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag.
	Destination *string `json:"destination,omitempty"`
	// DestinationPort - Traffic destination port. Accepted values are '*', port (for example, 3389) and port range (for example, 80-100).
	DestinationPort *string `json:"destinationPort,omitempty"`
}

// ConfigurationDiagnosticResponse results of network configuration diagnostic on the target resource.
type ConfigurationDiagnosticResponse struct {
	autorest.Response `json:"-"`
	// Results - READ-ONLY; List of network configuration diagnostic results.
	Results *[]ConfigurationDiagnosticResult `json:"results,omitempty"`
}

// ConfigurationDiagnosticResult network configuration diagnostic result corresponded to provided traffic
// query.
type ConfigurationDiagnosticResult struct {
	// Profile - Network configuration diagnostic profile.
	Profile *ConfigurationDiagnosticProfile `json:"profile,omitempty"`
	// NetworkSecurityGroupResult - Network security group result.
	NetworkSecurityGroupResult *SecurityGroupResult `json:"networkSecurityGroupResult,omitempty"`
}

// ConnectionMonitor parameters that define the operation to create a connection monitor.
type ConnectionMonitor struct {
	// Location - Connection monitor location.
	Location *string `json:"location,omitempty"`
	// Tags - Connection monitor tags.
	Tags map[string]*string `json:"tags"`
	// ConnectionMonitorParameters - Properties of the connection monitor.
	*ConnectionMonitorParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionMonitor.
func (cm ConnectionMonitor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cm.Location != nil {
		objectMap["location"] = cm.Location
	}
	if cm.Tags != nil {
		objectMap["tags"] = cm.Tags
	}
	if cm.ConnectionMonitorParameters != nil {
		objectMap["properties"] = cm.ConnectionMonitorParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionMonitor struct.
func (cm *ConnectionMonitor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cm.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cm.Tags = tags
			}
		case "properties":
			if v != nil {
				var connectionMonitorParameters ConnectionMonitorParameters
				err = json.Unmarshal(*v, &connectionMonitorParameters)
				if err != nil {
					return err
				}
				cm.ConnectionMonitorParameters = &connectionMonitorParameters
			}
		}
	}

	return nil
}

// ConnectionMonitorDestination describes the destination of connection monitor.
type ConnectionMonitorDestination struct {
	// ResourceID - The ID of the resource used as the destination by connection monitor.
	ResourceID *string `json:"resourceId,omitempty"`
	// Address - Address of the connection monitor destination (IP or domain name).
	Address *string `json:"address,omitempty"`
	// Port - The destination port used by connection monitor.
	Port *int32 `json:"port,omitempty"`
}

// ConnectionMonitorListResult list of connection monitors.
type ConnectionMonitorListResult struct {
	autorest.Response `json:"-"`
	// Value - Information about connection monitors.
	Value *[]ConnectionMonitorResult `json:"value,omitempty"`
}

// ConnectionMonitorParameters parameters that define the operation to create a connection monitor.
type ConnectionMonitorParameters struct {
	// Source - Describes the source of connection monitor.
	Source *ConnectionMonitorSource `json:"source,omitempty"`
	// Destination - Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination `json:"destination,omitempty"`
	// AutoStart - Determines if the connection monitor will start automatically once created.
	AutoStart *bool `json:"autoStart,omitempty"`
	// MonitoringIntervalInSeconds - Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32 `json:"monitoringIntervalInSeconds,omitempty"`
}

// ConnectionMonitorQueryResult list of connection states snapshots.
type ConnectionMonitorQueryResult struct {
	autorest.Response `json:"-"`
	// SourceStatus - Status of connection monitor source. Possible values include: 'ConnectionMonitorSourceStatusUnknown', 'ConnectionMonitorSourceStatusActive', 'ConnectionMonitorSourceStatusInactive'
	SourceStatus ConnectionMonitorSourceStatus `json:"sourceStatus,omitempty"`
	// States - Information about connection states.
	States *[]ConnectionStateSnapshot `json:"states,omitempty"`
}

// ConnectionMonitorResult information about the connection monitor.
type ConnectionMonitorResult struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the connection monitor.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; ID of the connection monitor.
	ID *string `json:"id,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Connection monitor type.
	Type *string `json:"type,omitempty"`
	// Location - Connection monitor location.
	Location *string `json:"location,omitempty"`
	// Tags - Connection monitor tags.
	Tags map[string]*string `json:"tags"`
	// ConnectionMonitorResultProperties - Properties of the connection monitor result.
	*ConnectionMonitorResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionMonitorResult.
func (cmr ConnectionMonitorResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmr.Etag != nil {
		objectMap["etag"] = cmr.Etag
	}
	if cmr.Location != nil {
		objectMap["location"] = cmr.Location
	}
	if cmr.Tags != nil {
		objectMap["tags"] = cmr.Tags
	}
	if cmr.ConnectionMonitorResultProperties != nil {
		objectMap["properties"] = cmr.ConnectionMonitorResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionMonitorResult struct.
func (cmr *ConnectionMonitorResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cmr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cmr.ID = &ID
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cmr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cmr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cmr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cmr.Tags = tags
			}
		case "properties":
			if v != nil {
				var connectionMonitorResultProperties ConnectionMonitorResultProperties
				err = json.Unmarshal(*v, &connectionMonitorResultProperties)
				if err != nil {
					return err
				}
				cmr.ConnectionMonitorResultProperties = &connectionMonitorResultProperties
			}
		}
	}

	return nil
}

// ConnectionMonitorResultProperties describes the properties of a connection monitor.
type ConnectionMonitorResultProperties struct {
	// ProvisioningState - The provisioning state of the connection monitor. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StartTime - The date and time when the connection monitor was started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// MonitoringStatus - The monitoring status of the connection monitor.
	MonitoringStatus *string `json:"monitoringStatus,omitempty"`
	// Source - Describes the source of connection monitor.
	Source *ConnectionMonitorSource `json:"source,omitempty"`
	// Destination - Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination `json:"destination,omitempty"`
	// AutoStart - Determines if the connection monitor will start automatically once created.
	AutoStart *bool `json:"autoStart,omitempty"`
	// MonitoringIntervalInSeconds - Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32 `json:"monitoringIntervalInSeconds,omitempty"`
}

// ConnectionMonitorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectionMonitorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (ConnectionMonitorResult, error)
}

// ConnectionMonitorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectionMonitorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (autorest.Response, error)
}

// ConnectionMonitorSource describes the source of connection monitor.
type ConnectionMonitorSource struct {
	// ResourceID - The ID of the resource used as the source by connection monitor.
	ResourceID *string `json:"resourceId,omitempty"`
	// Port - The source port used by connection monitor.
	Port *int32 `json:"port,omitempty"`
}

// ConnectionMonitorsQueryFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConnectionMonitorsQueryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (ConnectionMonitorQueryResult, error)
}

// ConnectionMonitorsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConnectionMonitorsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (autorest.Response, error)
}

// ConnectionMonitorsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConnectionMonitorsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (autorest.Response, error)
}

// ConnectionResetSharedKey the virtual network connection reset shared key.
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	// KeyLength - The virtual network connection reset shared key length, should between 1 and 128.
	KeyLength *int32 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey response for GetConnectionSharedKey API service call.
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value.
	Value *string `json:"value,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// ConnectionStateSnapshot connection state snapshot.
type ConnectionStateSnapshot struct {
	// ConnectionState - The connection state. Possible values include: 'ConnectionStateReachable', 'ConnectionStateUnreachable', 'ConnectionStateUnknown'
	ConnectionState ConnectionState `json:"connectionState,omitempty"`
	// StartTime - The start time of the connection snapshot.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the connection snapshot.
	EndTime *date.Time `json:"endTime,omitempty"`
	// EvaluationState - Connectivity analysis evaluation state. Possible values include: 'NotStarted', 'InProgress', 'Completed'
	EvaluationState EvaluationState `json:"evaluationState,omitempty"`
	// AvgLatencyInMs - Average latency in ms.
	AvgLatencyInMs *int32 `json:"avgLatencyInMs,omitempty"`
	// MinLatencyInMs - Minimum latency in ms.
	MinLatencyInMs *int32 `json:"minLatencyInMs,omitempty"`
	// MaxLatencyInMs - Maximum latency in ms.
	MaxLatencyInMs *int32 `json:"maxLatencyInMs,omitempty"`
	// ProbesSent - The number of sent probes.
	ProbesSent *int32 `json:"probesSent,omitempty"`
	// ProbesFailed - The number of failed probes.
	ProbesFailed *int32 `json:"probesFailed,omitempty"`
	// Hops - READ-ONLY; List of hops between the source and the destination.
	Hops *[]ConnectivityHop `json:"hops,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionStateSnapshot.
func (CSS ConnectionStateSnapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if CSS.ConnectionState != "" {
		objectMap["connectionState"] = CSS.ConnectionState
	}
	if CSS.StartTime != nil {
		objectMap["startTime"] = CSS.StartTime
	}
	if CSS.EndTime != nil {
		objectMap["endTime"] = CSS.EndTime
	}
	if CSS.EvaluationState != "" {
		objectMap["evaluationState"] = CSS.EvaluationState
	}
	if CSS.AvgLatencyInMs != nil {
		objectMap["avgLatencyInMs"] = CSS.AvgLatencyInMs
	}
	if CSS.MinLatencyInMs != nil {
		objectMap["minLatencyInMs"] = CSS.MinLatencyInMs
	}
	if CSS.MaxLatencyInMs != nil {
		objectMap["maxLatencyInMs"] = CSS.MaxLatencyInMs
	}
	if CSS.ProbesSent != nil {
		objectMap["probesSent"] = CSS.ProbesSent
	}
	if CSS.ProbesFailed != nil {
		objectMap["probesFailed"] = CSS.ProbesFailed
	}
	return json.Marshal(objectMap)
}

// ConnectivityDestination parameters that define destination of connection.
type ConnectivityDestination struct {
	// ResourceID - The ID of the resource to which a connection attempt will be made.
	ResourceID *string `json:"resourceId,omitempty"`
	// Address - The IP address or URI the resource to which a connection attempt will be made.
	Address *string `json:"address,omitempty"`
	// Port - Port on which check connectivity will be performed.
	Port *int32 `json:"port,omitempty"`
}

// ConnectivityHop information about a hop between the source and the destination.
type ConnectivityHop struct {
	// Type - READ-ONLY; The type of the hop.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; The ID of the hop.
	ID *string `json:"id,omitempty"`
	// Address - READ-ONLY; The IP address of the hop.
	Address *string `json:"address,omitempty"`
	// ResourceID - READ-ONLY; The ID of the resource corresponding to this hop.
	ResourceID *string `json:"resourceId,omitempty"`
	// NextHopIds - READ-ONLY; List of next hop identifiers.
	NextHopIds *[]string `json:"nextHopIds,omitempty"`
	// Issues - READ-ONLY; List of issues.
	Issues *[]ConnectivityIssue `json:"issues,omitempty"`
}

// ConnectivityInformation information on the connectivity status.
type ConnectivityInformation struct {
	autorest.Response `json:"-"`
	// Hops - READ-ONLY; List of hops between the source and the destination.
	Hops *[]ConnectivityHop `json:"hops,omitempty"`
	// ConnectionStatus - READ-ONLY; The connection status. Possible values include: 'ConnectionStatusUnknown', 'ConnectionStatusConnected', 'ConnectionStatusDisconnected', 'ConnectionStatusDegraded'
	ConnectionStatus ConnectionStatus `json:"connectionStatus,omitempty"`
	// AvgLatencyInMs - READ-ONLY; Average latency in milliseconds.
	AvgLatencyInMs *int32 `json:"avgLatencyInMs,omitempty"`
	// MinLatencyInMs - READ-ONLY; Minimum latency in milliseconds.
	MinLatencyInMs *int32 `json:"minLatencyInMs,omitempty"`
	// MaxLatencyInMs - READ-ONLY; Maximum latency in milliseconds.
	MaxLatencyInMs *int32 `json:"maxLatencyInMs,omitempty"`
	// ProbesSent - READ-ONLY; Total number of probes sent.
	ProbesSent *int32 `json:"probesSent,omitempty"`
	// ProbesFailed - READ-ONLY; Number of failed probes.
	ProbesFailed *int32 `json:"probesFailed,omitempty"`
}

// ConnectivityIssue information about an issue encountered in the process of checking for connectivity.
type ConnectivityIssue struct {
	// Origin - READ-ONLY; The origin of the issue. Possible values include: 'OriginLocal', 'OriginInbound', 'OriginOutbound'
	Origin Origin `json:"origin,omitempty"`
	// Severity - READ-ONLY; The severity of the issue. Possible values include: 'SeverityError', 'SeverityWarning'
	Severity Severity `json:"severity,omitempty"`
	// Type - READ-ONLY; The type of issue. Possible values include: 'IssueTypeUnknown', 'IssueTypeAgentStopped', 'IssueTypeGuestFirewall', 'IssueTypeDNSResolution', 'IssueTypeSocketBind', 'IssueTypeNetworkSecurityRule', 'IssueTypeUserDefinedRoute', 'IssueTypePortThrottled', 'IssueTypePlatform'
	Type IssueType `json:"type,omitempty"`
	// Context - READ-ONLY; Provides additional context on the issue.
	Context *[]map[string]*string `json:"context,omitempty"`
}

// ConnectivityParameters parameters that determine how the connectivity check will be performed.
type ConnectivityParameters struct {
	// Source - Describes the source of the connection.
	Source *ConnectivitySource `json:"source,omitempty"`
	// Destination - Describes the destination of connection.
	Destination *ConnectivityDestination `json:"destination,omitempty"`
	// Protocol - Network protocol. Possible values include: 'ProtocolTCP', 'ProtocolHTTP', 'ProtocolHTTPS', 'ProtocolIcmp'
	Protocol Protocol `json:"protocol,omitempty"`
	// ProtocolConfiguration - Configuration of the protocol.
	ProtocolConfiguration *ProtocolConfiguration `json:"protocolConfiguration,omitempty"`
}

// ConnectivitySource parameters that define the source of the connection.
type ConnectivitySource struct {
	// ResourceID - The ID of the resource from which a connectivity check will be initiated.
	ResourceID *string `json:"resourceId,omitempty"`
	// Port - The source port from which a connectivity check will be performed.
	Port *int32 `json:"port,omitempty"`
}

// Container reference to container resource in remote resource provider.
type Container struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// ContainerNetworkInterface container network interface child resource.
type ContainerNetworkInterface struct {
	// ContainerNetworkInterfacePropertiesFormat - Container network interface properties.
	*ContainerNetworkInterfacePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterface.
func (cni ContainerNetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cni.ContainerNetworkInterfacePropertiesFormat != nil {
		objectMap["properties"] = cni.ContainerNetworkInterfacePropertiesFormat
	}
	if cni.Name != nil {
		objectMap["name"] = cni.Name
	}
	if cni.Etag != nil {
		objectMap["etag"] = cni.Etag
	}
	if cni.ID != nil {
		objectMap["id"] = cni.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerNetworkInterface struct.
func (cni *ContainerNetworkInterface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerNetworkInterfacePropertiesFormat ContainerNetworkInterfacePropertiesFormat
				err = json.Unmarshal(*v, &containerNetworkInterfacePropertiesFormat)
				if err != nil {
					return err
				}
				cni.ContainerNetworkInterfacePropertiesFormat = &containerNetworkInterfacePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cni.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cni.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cni.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cni.ID = &ID
			}
		}
	}

	return nil
}

// ContainerNetworkInterfaceConfiguration container network interface configuration child resource.
type ContainerNetworkInterfaceConfiguration struct {
	// ContainerNetworkInterfaceConfigurationPropertiesFormat - Container network interface configuration properties.
	*ContainerNetworkInterfaceConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfaceConfiguration.
func (cnic ContainerNetworkInterfaceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnic.ContainerNetworkInterfaceConfigurationPropertiesFormat != nil {
		objectMap["properties"] = cnic.ContainerNetworkInterfaceConfigurationPropertiesFormat
	}
	if cnic.Name != nil {
		objectMap["name"] = cnic.Name
	}
	if cnic.Etag != nil {
		objectMap["etag"] = cnic.Etag
	}
	if cnic.ID != nil {
		objectMap["id"] = cnic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerNetworkInterfaceConfiguration struct.
func (cnic *ContainerNetworkInterfaceConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerNetworkInterfaceConfigurationPropertiesFormat ContainerNetworkInterfaceConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &containerNetworkInterfaceConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				cnic.ContainerNetworkInterfaceConfigurationPropertiesFormat = &containerNetworkInterfaceConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cnic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cnic.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cnic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cnic.ID = &ID
			}
		}
	}

	return nil
}

// ContainerNetworkInterfaceConfigurationPropertiesFormat container network interface configuration
// properties.
type ContainerNetworkInterfaceConfigurationPropertiesFormat struct {
	// IPConfigurations - A list of ip configurations of the container network interface configuration.
	IPConfigurations *[]IPConfigurationProfile `json:"ipConfigurations,omitempty"`
	// ContainerNetworkInterfaces - A list of container network interfaces created from this container network interface configuration.
	ContainerNetworkInterfaces *[]SubResource `json:"containerNetworkInterfaces,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container network interface configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfaceConfigurationPropertiesFormat.
func (cnicpf ContainerNetworkInterfaceConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnicpf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = cnicpf.IPConfigurations
	}
	if cnicpf.ContainerNetworkInterfaces != nil {
		objectMap["containerNetworkInterfaces"] = cnicpf.ContainerNetworkInterfaces
	}
	return json.Marshal(objectMap)
}

// ContainerNetworkInterfaceIPConfiguration the ip configuration for a container network interface.
type ContainerNetworkInterfaceIPConfiguration struct {
	// ContainerNetworkInterfaceIPConfigurationPropertiesFormat - Properties of the container network interface IP configuration.
	*ContainerNetworkInterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfaceIPConfiguration.
func (cniic ContainerNetworkInterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cniic.ContainerNetworkInterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = cniic.ContainerNetworkInterfaceIPConfigurationPropertiesFormat
	}
	if cniic.Name != nil {
		objectMap["name"] = cniic.Name
	}
	if cniic.Etag != nil {
		objectMap["etag"] = cniic.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerNetworkInterfaceIPConfiguration struct.
func (cniic *ContainerNetworkInterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerNetworkInterfaceIPConfigurationPropertiesFormat ContainerNetworkInterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &containerNetworkInterfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				cniic.ContainerNetworkInterfaceIPConfigurationPropertiesFormat = &containerNetworkInterfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cniic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cniic.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cniic.Etag = &etag
			}
		}
	}

	return nil
}

// ContainerNetworkInterfaceIPConfigurationPropertiesFormat properties of the container network interface
// IP configuration.
type ContainerNetworkInterfaceIPConfigurationPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the container network interface IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ContainerNetworkInterfacePropertiesFormat properties of container network interface.
type ContainerNetworkInterfacePropertiesFormat struct {
	// ContainerNetworkInterfaceConfiguration - Container network interface configuration from which this container network interface is created.
	ContainerNetworkInterfaceConfiguration *ContainerNetworkInterfaceConfiguration `json:"containerNetworkInterfaceConfiguration,omitempty"`
	// Container - Reference to the container to which this container network interface is attached.
	Container *Container `json:"container,omitempty"`
	// IPConfigurations - Reference to the ip configuration on this container nic.
	IPConfigurations *[]ContainerNetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container network interface resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfacePropertiesFormat.
func (cnipf ContainerNetworkInterfacePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnipf.ContainerNetworkInterfaceConfiguration != nil {
		objectMap["containerNetworkInterfaceConfiguration"] = cnipf.ContainerNetworkInterfaceConfiguration
	}
	if cnipf.Container != nil {
		objectMap["container"] = cnipf.Container
	}
	if cnipf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = cnipf.IPConfigurations
	}
	return json.Marshal(objectMap)
}

// DdosCustomPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosCustomPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosCustomPoliciesClient) (DdosCustomPolicy, error)
}

// DdosCustomPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosCustomPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosCustomPoliciesClient) (autorest.Response, error)
}

// DdosCustomPoliciesUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosCustomPoliciesUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosCustomPoliciesClient) (DdosCustomPolicy, error)
}

// DdosCustomPolicy a DDoS custom policy in a resource group.
type DdosCustomPolicy struct {
	autorest.Response `json:"-"`
	// DdosCustomPolicyPropertiesFormat - Properties of the DDoS custom policy.
	*DdosCustomPolicyPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DdosCustomPolicy.
func (dcp DdosCustomPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcp.DdosCustomPolicyPropertiesFormat != nil {
		objectMap["properties"] = dcp.DdosCustomPolicyPropertiesFormat
	}
	if dcp.ID != nil {
		objectMap["id"] = dcp.ID
	}
	if dcp.Location != nil {
		objectMap["location"] = dcp.Location
	}
	if dcp.Tags != nil {
		objectMap["tags"] = dcp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DdosCustomPolicy struct.
func (dcp *DdosCustomPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ddosCustomPolicyPropertiesFormat DdosCustomPolicyPropertiesFormat
				err = json.Unmarshal(*v, &ddosCustomPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				dcp.DdosCustomPolicyPropertiesFormat = &ddosCustomPolicyPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dcp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcp.Tags = tags
			}
		}
	}

	return nil
}

// DdosCustomPolicyPropertiesFormat dDoS custom policy properties.
type DdosCustomPolicyPropertiesFormat struct {
	// ResourceGUID - READ-ONLY; The resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the DDoS custom policy resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PublicIPAddresses - READ-ONLY; The list of public IPs associated with the DDoS custom policy resource. This list is read-only.
	PublicIPAddresses *[]SubResource `json:"publicIPAddresses,omitempty"`
	// ProtocolCustomSettings - The protocol-specific DDoS policy customization parameters.
	ProtocolCustomSettings *[]ProtocolCustomSettingsFormat `json:"protocolCustomSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for DdosCustomPolicyPropertiesFormat.
func (dcppf DdosCustomPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcppf.ProtocolCustomSettings != nil {
		objectMap["protocolCustomSettings"] = dcppf.ProtocolCustomSettings
	}
	return json.Marshal(objectMap)
}

// DdosProtectionPlan a DDoS protection plan in a resource group.
type DdosProtectionPlan struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// DdosProtectionPlanPropertiesFormat - Properties of the DDoS protection plan.
	*DdosProtectionPlanPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for DdosProtectionPlan.
func (dpp DdosProtectionPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpp.Location != nil {
		objectMap["location"] = dpp.Location
	}
	if dpp.Tags != nil {
		objectMap["tags"] = dpp.Tags
	}
	if dpp.DdosProtectionPlanPropertiesFormat != nil {
		objectMap["properties"] = dpp.DdosProtectionPlanPropertiesFormat
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DdosProtectionPlan struct.
func (dpp *DdosProtectionPlan) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dpp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dpp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dpp.Tags = tags
			}
		case "properties":
			if v != nil {
				var ddosProtectionPlanPropertiesFormat DdosProtectionPlanPropertiesFormat
				err = json.Unmarshal(*v, &ddosProtectionPlanPropertiesFormat)
				if err != nil {
					return err
				}
				dpp.DdosProtectionPlanPropertiesFormat = &ddosProtectionPlanPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dpp.Etag = &etag
			}
		}
	}

	return nil
}

// DdosProtectionPlanListResult a list of DDoS protection plans.
type DdosProtectionPlanListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of DDoS protection plans.
	Value *[]DdosProtectionPlan `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DdosProtectionPlanListResult.
func (dpplr DdosProtectionPlanListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpplr.Value != nil {
		objectMap["value"] = dpplr.Value
	}
	return json.Marshal(objectMap)
}

// DdosProtectionPlanListResultIterator provides access to a complete listing of DdosProtectionPlan values.
type DdosProtectionPlanListResultIterator struct {
	i    int
	page DdosProtectionPlanListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DdosProtectionPlanListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DdosProtectionPlanListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DdosProtectionPlanListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DdosProtectionPlanListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DdosProtectionPlanListResultIterator) Response() DdosProtectionPlanListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DdosProtectionPlanListResultIterator) Value() DdosProtectionPlan {
	if !iter.page.NotDone() {
		return DdosProtectionPlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DdosProtectionPlanListResultIterator type.
func NewDdosProtectionPlanListResultIterator(page DdosProtectionPlanListResultPage) DdosProtectionPlanListResultIterator {
	return DdosProtectionPlanListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dpplr DdosProtectionPlanListResult) IsEmpty() bool {
	return dpplr.Value == nil || len(*dpplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dpplr DdosProtectionPlanListResult) hasNextLink() bool {
	return dpplr.NextLink != nil && len(*dpplr.NextLink) != 0
}

// ddosProtectionPlanListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dpplr DdosProtectionPlanListResult) ddosProtectionPlanListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dpplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dpplr.NextLink)))
}

// DdosProtectionPlanListResultPage contains a page of DdosProtectionPlan values.
type DdosProtectionPlanListResultPage struct {
	fn    func(context.Context, DdosProtectionPlanListResult) (DdosProtectionPlanListResult, error)
	dpplr DdosProtectionPlanListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DdosProtectionPlanListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DdosProtectionPlanListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dpplr)
		if err != nil {
			return err
		}
		page.dpplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DdosProtectionPlanListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DdosProtectionPlanListResultPage) NotDone() bool {
	return !page.dpplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DdosProtectionPlanListResultPage) Response() DdosProtectionPlanListResult {
	return page.dpplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DdosProtectionPlanListResultPage) Values() []DdosProtectionPlan {
	if page.dpplr.IsEmpty() {
		return nil
	}
	return *page.dpplr.Value
}

// Creates a new instance of the DdosProtectionPlanListResultPage type.
func NewDdosProtectionPlanListResultPage(cur DdosProtectionPlanListResult, getNextPage func(context.Context, DdosProtectionPlanListResult) (DdosProtectionPlanListResult, error)) DdosProtectionPlanListResultPage {
	return DdosProtectionPlanListResultPage{
		fn:    getNextPage,
		dpplr: cur,
	}
}

// DdosProtectionPlanPropertiesFormat dDoS protection plan properties.
type DdosProtectionPlanPropertiesFormat struct {
	// ResourceGUID - READ-ONLY; The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the DDoS protection plan resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VirtualNetworks - READ-ONLY; The list of virtual networks associated with the DDoS protection plan resource. This list is read-only.
	VirtualNetworks *[]SubResource `json:"virtualNetworks,omitempty"`
}

// DdosProtectionPlansCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosProtectionPlansCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosProtectionPlansClient) (DdosProtectionPlan, error)
}

// DdosProtectionPlansDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosProtectionPlansDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosProtectionPlansClient) (autorest.Response, error)
}

// DdosProtectionPlansUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosProtectionPlansUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosProtectionPlansClient) (DdosProtectionPlan, error)
}

// DdosSettings contains the DDoS protection settings of the public IP.
type DdosSettings struct {
	// DdosCustomPolicy - The DDoS custom policy associated with the public IP.
	DdosCustomPolicy *SubResource `json:"ddosCustomPolicy,omitempty"`
	// ProtectionCoverage - The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized. Possible values include: 'DdosSettingsProtectionCoverageBasic', 'DdosSettingsProtectionCoverageStandard'
	ProtectionCoverage DdosSettingsProtectionCoverage `json:"protectionCoverage,omitempty"`
}

// Delegation details the service to which the subnet is delegated.
type Delegation struct {
	// ServiceDelegationPropertiesFormat - Properties of the subnet.
	*ServiceDelegationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a subnet. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Delegation.
func (d Delegation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.ServiceDelegationPropertiesFormat != nil {
		objectMap["properties"] = d.ServiceDelegationPropertiesFormat
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Etag != nil {
		objectMap["etag"] = d.Etag
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Delegation struct.
func (d *Delegation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceDelegationPropertiesFormat ServiceDelegationPropertiesFormat
				err = json.Unmarshal(*v, &serviceDelegationPropertiesFormat)
				if err != nil {
					return err
				}
				d.ServiceDelegationPropertiesFormat = &serviceDelegationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				d.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		}
	}

	return nil
}

// DeviceProperties list of properties of the device.
type DeviceProperties struct {
	// DeviceVendor - Name of the device Vendor.
	DeviceVendor *string `json:"deviceVendor,omitempty"`
	// DeviceModel - Model of the device.
	DeviceModel *string `json:"deviceModel,omitempty"`
	// LinkSpeedInMbps - Link speed.
	LinkSpeedInMbps *int32 `json:"linkSpeedInMbps,omitempty"`
}

// DhcpOptions dhcpOptions contains an array of DNS servers available to VMs deployed in the virtual
// network. Standard DHCP option for a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// DNSServers - The list of DNS servers IP addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// Dimension dimension of the metric.
type Dimension struct {
	// Name - The name of the dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// InternalName - The internal name of the dimension.
	InternalName *string `json:"internalName,omitempty"`
}

// DNSNameAvailabilityResult response for the CheckDnsNameAvailability API service call.
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Domain availability (True/False).
	Available *bool `json:"available,omitempty"`
}

// EffectiveNetworkSecurityGroup effective network security group.
type EffectiveNetworkSecurityGroup struct {
	// NetworkSecurityGroup - The ID of network security group that is applied.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`
	// Association - Associated resources.
	Association *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`
	// EffectiveSecurityRules - A collection of effective security rules.
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
	// TagMap - Mapping of tags to list of IP Addresses included within the tag.
	TagMap map[string][]string `json:"tagMap"`
}

// MarshalJSON is the custom marshaler for EffectiveNetworkSecurityGroup.
func (ensg EffectiveNetworkSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ensg.NetworkSecurityGroup != nil {
		objectMap["networkSecurityGroup"] = ensg.NetworkSecurityGroup
	}
	if ensg.Association != nil {
		objectMap["association"] = ensg.Association
	}
	if ensg.EffectiveSecurityRules != nil {
		objectMap["effectiveSecurityRules"] = ensg.EffectiveSecurityRules
	}
	if ensg.TagMap != nil {
		objectMap["tagMap"] = ensg.TagMap
	}
	return json.Marshal(objectMap)
}

// EffectiveNetworkSecurityGroupAssociation the effective network security group association.
type EffectiveNetworkSecurityGroupAssociation struct {
	// Subnet - The ID of the subnet if assigned.
	Subnet *SubResource `json:"subnet,omitempty"`
	// NetworkInterface - The ID of the network interface if assigned.
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult response for list effective network security groups API service
// call.
type EffectiveNetworkSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of effective network security groups.
	Value *[]EffectiveNetworkSecurityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EffectiveNetworkSecurityGroupListResult.
func (ensglr EffectiveNetworkSecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ensglr.Value != nil {
		objectMap["value"] = ensglr.Value
	}
	return json.Marshal(objectMap)
}

// EffectiveNetworkSecurityRule effective network security rules.
type EffectiveNetworkSecurityRule struct {
	// Name - The name of the security rule specified by the user (if created by the user).
	Name *string `json:"name,omitempty"`
	// Protocol - The network protocol this rule applies to. Possible values include: 'EffectiveSecurityRuleProtocolTCP', 'EffectiveSecurityRuleProtocolUDP', 'EffectiveSecurityRuleProtocolAll'
	Protocol EffectiveSecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - The source port or range.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - The destination port or range.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourcePortRanges - The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
	SourcePortRanges *[]string `json:"sourcePortRanges,omitempty"`
	// DestinationPortRanges - The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
	DestinationPortRanges *[]string `json:"destinationPortRanges,omitempty"`
	// SourceAddressPrefix - The source address prefix.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - The destination address prefix.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// SourceAddressPrefixes - The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
	SourceAddressPrefixes *[]string `json:"sourceAddressPrefixes,omitempty"`
	// DestinationAddressPrefixes - The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
	DestinationAddressPrefixes *[]string `json:"destinationAddressPrefixes,omitempty"`
	// ExpandedSourceAddressPrefix - The expanded source address prefix.
	ExpandedSourceAddressPrefix *[]string `json:"expandedSourceAddressPrefix,omitempty"`
	// ExpandedDestinationAddressPrefix - Expanded destination address prefix.
	ExpandedDestinationAddressPrefix *[]string `json:"expandedDestinationAddressPrefix,omitempty"`
	// Access - Whether network traffic is allowed or denied. Possible values include: 'SecurityRuleAccessAllow', 'SecurityRuleAccessDeny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - The priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - The direction of the rule. Possible values include: 'SecurityRuleDirectionInbound', 'SecurityRuleDirectionOutbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
}

// EffectiveRoute effective Route.
type EffectiveRoute struct {
	// Name - The name of the user defined route. This is optional.
	Name *string `json:"name,omitempty"`
	// DisableBgpRoutePropagation - If true, on-premises routes are not propagated to the network interfaces in the subnet.
	DisableBgpRoutePropagation *bool `json:"disableBgpRoutePropagation,omitempty"`
	// Source - Who created the route. Possible values include: 'EffectiveRouteSourceUnknown', 'EffectiveRouteSourceUser', 'EffectiveRouteSourceVirtualNetworkGateway', 'EffectiveRouteSourceDefault'
	Source EffectiveRouteSource `json:"source,omitempty"`
	// State - The value of effective route. Possible values include: 'Active', 'Invalid'
	State EffectiveRouteState `json:"state,omitempty"`
	// AddressPrefix - The address prefixes of the effective routes in CIDR notation.
	AddressPrefix *[]string `json:"addressPrefix,omitempty"`
	// NextHopIPAddress - The IP address of the next hop of the effective route.
	NextHopIPAddress *[]string `json:"nextHopIpAddress,omitempty"`
	// NextHopType - The type of Azure hop the packet should be sent to. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
}

// EffectiveRouteListResult response for list effective route API service call.
type EffectiveRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of effective routes.
	Value *[]EffectiveRoute `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EffectiveRouteListResult.
func (erlr EffectiveRouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erlr.Value != nil {
		objectMap["value"] = erlr.Value
	}
	return json.Marshal(objectMap)
}

// EndpointServiceResult endpoint service.
type EndpointServiceResult struct {
	// Name - READ-ONLY; Name of the endpoint service.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the endpoint service.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointServiceResult.
func (esr EndpointServiceResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esr.ID != nil {
		objectMap["id"] = esr.ID
	}
	return json.Marshal(objectMap)
}

// EndpointServicesListResult response for the ListAvailableEndpointServices API service call.
type EndpointServicesListResult struct {
	autorest.Response `json:"-"`
	// Value - List of available endpoint services in a region.
	Value *[]EndpointServiceResult `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointServicesListResultIterator provides access to a complete listing of EndpointServiceResult
// values.
type EndpointServicesListResultIterator struct {
	i    int
	page EndpointServicesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointServicesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointServicesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointServicesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointServicesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointServicesListResultIterator) Response() EndpointServicesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointServicesListResultIterator) Value() EndpointServiceResult {
	if !iter.page.NotDone() {
		return EndpointServiceResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointServicesListResultIterator type.
func NewEndpointServicesListResultIterator(page EndpointServicesListResultPage) EndpointServicesListResultIterator {
	return EndpointServicesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eslr EndpointServicesListResult) IsEmpty() bool {
	return eslr.Value == nil || len(*eslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eslr EndpointServicesListResult) hasNextLink() bool {
	return eslr.NextLink != nil && len(*eslr.NextLink) != 0
}

// endpointServicesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eslr EndpointServicesListResult) endpointServicesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eslr.NextLink)))
}

// EndpointServicesListResultPage contains a page of EndpointServiceResult values.
type EndpointServicesListResultPage struct {
	fn   func(context.Context, EndpointServicesListResult) (EndpointServicesListResult, error)
	eslr EndpointServicesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointServicesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointServicesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eslr)
		if err != nil {
			return err
		}
		page.eslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointServicesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointServicesListResultPage) NotDone() bool {
	return !page.eslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointServicesListResultPage) Response() EndpointServicesListResult {
	return page.eslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointServicesListResultPage) Values() []EndpointServiceResult {
	if page.eslr.IsEmpty() {
		return nil
	}
	return *page.eslr.Value
}

// Creates a new instance of the EndpointServicesListResultPage type.
func NewEndpointServicesListResultPage(cur EndpointServicesListResult, getNextPage func(context.Context, EndpointServicesListResult) (EndpointServicesListResult, error)) EndpointServicesListResultPage {
	return EndpointServicesListResultPage{
		fn:   getNextPage,
		eslr: cur,
	}
}

// Error common error representation.
type Error struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// Target - Error target.
	Target *string `json:"target,omitempty"`
	// Details - Error details.
	Details *[]ErrorDetails `json:"details,omitempty"`
	// InnerError - Inner error message.
	InnerError *string `json:"innerError,omitempty"`
}

// ErrorDetails common error details representation.
type ErrorDetails struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Target - Error target.
	Target *string `json:"target,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse the error object.
type ErrorResponse struct {
	// Error - The error details object.
	Error *ErrorDetails `json:"error,omitempty"`
}

// EvaluatedNetworkSecurityGroup results of network security group evaluation.
type EvaluatedNetworkSecurityGroup struct {
	// NetworkSecurityGroupID - Network security group ID.
	NetworkSecurityGroupID *string `json:"networkSecurityGroupId,omitempty"`
	// AppliedTo - Resource ID of nic or subnet to which network security group is applied.
	AppliedTo *string `json:"appliedTo,omitempty"`
	// MatchedRule - Matched network security rule.
	MatchedRule *MatchedRule `json:"matchedRule,omitempty"`
	// RulesEvaluationResult - READ-ONLY; List of network security rules evaluation results.
	RulesEvaluationResult *[]SecurityRulesEvaluationResult `json:"rulesEvaluationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for EvaluatedNetworkSecurityGroup.
func (ensg EvaluatedNetworkSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ensg.NetworkSecurityGroupID != nil {
		objectMap["networkSecurityGroupId"] = ensg.NetworkSecurityGroupID
	}
	if ensg.AppliedTo != nil {
		objectMap["appliedTo"] = ensg.AppliedTo
	}
	if ensg.MatchedRule != nil {
		objectMap["matchedRule"] = ensg.MatchedRule
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuit expressRouteCircuit resource.
type ExpressRouteCircuit struct {
	autorest.Response `json:"-"`
	// Sku - The SKU.
	Sku *ExpressRouteCircuitSku `json:"sku,omitempty"`
	// ExpressRouteCircuitPropertiesFormat - Properties of the express route circuit.
	*ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuit.
func (erc ExpressRouteCircuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.Sku != nil {
		objectMap["sku"] = erc.Sku
	}
	if erc.ExpressRouteCircuitPropertiesFormat != nil {
		objectMap["properties"] = erc.ExpressRouteCircuitPropertiesFormat
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	if erc.Location != nil {
		objectMap["location"] = erc.Location
	}
	if erc.Tags != nil {
		objectMap["tags"] = erc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuit struct.
func (erc *ExpressRouteCircuit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ExpressRouteCircuitSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				erc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var expressRouteCircuitPropertiesFormat ExpressRouteCircuitPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPropertiesFormat)
				if err != nil {
					return err
				}
				erc.ExpressRouteCircuitPropertiesFormat = &expressRouteCircuitPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erc.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteCircuitArpTable the ARP table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitArpTable struct {
	// Age - Entry age in minutes.
	Age *int32 `json:"age,omitempty"`
	// Interface - Interface address.
	Interface *string `json:"interface,omitempty"`
	// IPAddress - The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// MacAddress - The MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization authorization in an ExpressRouteCircuit resource.
type ExpressRouteCircuitAuthorization struct {
	autorest.Response `json:"-"`
	// AuthorizationPropertiesFormat - Properties of the express route circuit authorization.
	*AuthorizationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitAuthorization.
func (erca ExpressRouteCircuitAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erca.AuthorizationPropertiesFormat != nil {
		objectMap["properties"] = erca.AuthorizationPropertiesFormat
	}
	if erca.Name != nil {
		objectMap["name"] = erca.Name
	}
	if erca.ID != nil {
		objectMap["id"] = erca.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitAuthorization struct.
func (erca *ExpressRouteCircuitAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationPropertiesFormat AuthorizationPropertiesFormat
				err = json.Unmarshal(*v, &authorizationPropertiesFormat)
				if err != nil {
					return err
				}
				erca.AuthorizationPropertiesFormat = &authorizationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erca.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erca.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erca.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erca.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitAuthorizationsClient) (ExpressRouteCircuitAuthorization, error)
}

// ExpressRouteCircuitAuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitAuthorizationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitAuthorizationsClient) (autorest.Response, error)
}

// ExpressRouteCircuitConnection express Route Circuit Connection in an ExpressRouteCircuitPeering
// resource.
type ExpressRouteCircuitConnection struct {
	autorest.Response `json:"-"`
	// ExpressRouteCircuitConnectionPropertiesFormat - Properties of the express route circuit connection.
	*ExpressRouteCircuitConnectionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitConnection.
func (ercc ExpressRouteCircuitConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercc.ExpressRouteCircuitConnectionPropertiesFormat != nil {
		objectMap["properties"] = ercc.ExpressRouteCircuitConnectionPropertiesFormat
	}
	if ercc.Name != nil {
		objectMap["name"] = ercc.Name
	}
	if ercc.ID != nil {
		objectMap["id"] = ercc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitConnection struct.
func (ercc *ExpressRouteCircuitConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitConnectionPropertiesFormat ExpressRouteCircuitConnectionPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				ercc.ExpressRouteCircuitConnectionPropertiesFormat = &expressRouteCircuitConnectionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ercc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercc.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitConnectionListResult response for ListConnections API service call retrieves all
// global reach connections that belongs to a Private Peering for an ExpressRouteCircuit.
type ExpressRouteCircuitConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The global reach connection associated with Private Peering in an ExpressRoute Circuit.
	Value *[]ExpressRouteCircuitConnection `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitConnectionListResultIterator provides access to a complete listing of
// ExpressRouteCircuitConnection values.
type ExpressRouteCircuitConnectionListResultIterator struct {
	i    int
	page ExpressRouteCircuitConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitConnectionListResultIterator) Response() ExpressRouteCircuitConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitConnectionListResultIterator) Value() ExpressRouteCircuitConnection {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitConnectionListResultIterator type.
func NewExpressRouteCircuitConnectionListResultIterator(page ExpressRouteCircuitConnectionListResultPage) ExpressRouteCircuitConnectionListResultIterator {
	return ExpressRouteCircuitConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercclr ExpressRouteCircuitConnectionListResult) IsEmpty() bool {
	return ercclr.Value == nil || len(*ercclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ercclr ExpressRouteCircuitConnectionListResult) hasNextLink() bool {
	return ercclr.NextLink != nil && len(*ercclr.NextLink) != 0
}

// expressRouteCircuitConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercclr ExpressRouteCircuitConnectionListResult) expressRouteCircuitConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ercclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercclr.NextLink)))
}

// ExpressRouteCircuitConnectionListResultPage contains a page of ExpressRouteCircuitConnection values.
type ExpressRouteCircuitConnectionListResultPage struct {
	fn     func(context.Context, ExpressRouteCircuitConnectionListResult) (ExpressRouteCircuitConnectionListResult, error)
	ercclr ExpressRouteCircuitConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ercclr)
		if err != nil {
			return err
		}
		page.ercclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitConnectionListResultPage) NotDone() bool {
	return !page.ercclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitConnectionListResultPage) Response() ExpressRouteCircuitConnectionListResult {
	return page.ercclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitConnectionListResultPage) Values() []ExpressRouteCircuitConnection {
	if page.ercclr.IsEmpty() {
		return nil
	}
	return *page.ercclr.Value
}

// Creates a new instance of the ExpressRouteCircuitConnectionListResultPage type.
func NewExpressRouteCircuitConnectionListResultPage(cur ExpressRouteCircuitConnectionListResult, getNextPage func(context.Context, ExpressRouteCircuitConnectionListResult) (ExpressRouteCircuitConnectionListResult, error)) ExpressRouteCircuitConnectionListResultPage {
	return ExpressRouteCircuitConnectionListResultPage{
		fn:     getNextPage,
		ercclr: cur,
	}
}

// ExpressRouteCircuitConnectionPropertiesFormat properties of the express route circuit connection.
type ExpressRouteCircuitConnectionPropertiesFormat struct {
	// ExpressRouteCircuitPeering - Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
	ExpressRouteCircuitPeering *SubResource `json:"expressRouteCircuitPeering,omitempty"`
	// PeerExpressRouteCircuitPeering - Reference to Express Route Circuit Private Peering Resource of the peered circuit.
	PeerExpressRouteCircuitPeering *SubResource `json:"peerExpressRouteCircuitPeering,omitempty"`
	// AddressPrefix - /29 IP address space to carve out Customer addresses for tunnels.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// AuthorizationKey - The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// CircuitConnectionStatus - Express Route Circuit connection state. Possible values include: 'Connected', 'Connecting', 'Disconnected'
	CircuitConnectionStatus CircuitConnectionStatus `json:"circuitConnectionStatus,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route circuit connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitConnectionPropertiesFormat.
func (erccpf ExpressRouteCircuitConnectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccpf.ExpressRouteCircuitPeering != nil {
		objectMap["expressRouteCircuitPeering"] = erccpf.ExpressRouteCircuitPeering
	}
	if erccpf.PeerExpressRouteCircuitPeering != nil {
		objectMap["peerExpressRouteCircuitPeering"] = erccpf.PeerExpressRouteCircuitPeering
	}
	if erccpf.AddressPrefix != nil {
		objectMap["addressPrefix"] = erccpf.AddressPrefix
	}
	if erccpf.AuthorizationKey != nil {
		objectMap["authorizationKey"] = erccpf.AuthorizationKey
	}
	if erccpf.CircuitConnectionStatus != "" {
		objectMap["circuitConnectionStatus"] = erccpf.CircuitConnectionStatus
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuitConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitConnectionsClient) (ExpressRouteCircuitConnection, error)
}

// ExpressRouteCircuitConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitConnectionsClient) (autorest.Response, error)
}

// ExpressRouteCircuitListResult response for ListExpressRouteCircuit API service call.
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteCircuits in a resource group.
	Value *[]ExpressRouteCircuit `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitListResultIterator provides access to a complete listing of ExpressRouteCircuit
// values.
type ExpressRouteCircuitListResultIterator struct {
	i    int
	page ExpressRouteCircuitListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitListResultIterator) Response() ExpressRouteCircuitListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitListResultIterator) Value() ExpressRouteCircuit {
	if !iter.page.NotDone() {
		return ExpressRouteCircuit{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitListResultIterator type.
func NewExpressRouteCircuitListResultIterator(page ExpressRouteCircuitListResultPage) ExpressRouteCircuitListResultIterator {
	return ExpressRouteCircuitListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erclr ExpressRouteCircuitListResult) IsEmpty() bool {
	return erclr.Value == nil || len(*erclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erclr ExpressRouteCircuitListResult) hasNextLink() bool {
	return erclr.NextLink != nil && len(*erclr.NextLink) != 0
}

// expressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erclr ExpressRouteCircuitListResult) expressRouteCircuitListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erclr.NextLink)))
}

// ExpressRouteCircuitListResultPage contains a page of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultPage struct {
	fn    func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)
	erclr ExpressRouteCircuitListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erclr)
		if err != nil {
			return err
		}
		page.erclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitListResultPage) NotDone() bool {
	return !page.erclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitListResultPage) Response() ExpressRouteCircuitListResult {
	return page.erclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitListResultPage) Values() []ExpressRouteCircuit {
	if page.erclr.IsEmpty() {
		return nil
	}
	return *page.erclr.Value
}

// Creates a new instance of the ExpressRouteCircuitListResultPage type.
func NewExpressRouteCircuitListResultPage(cur ExpressRouteCircuitListResult, getNextPage func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)) ExpressRouteCircuitListResultPage {
	return ExpressRouteCircuitListResultPage{
		fn:    getNextPage,
		erclr: cur,
	}
}

// ExpressRouteCircuitPeering peering in an ExpressRouteCircuit resource.
type ExpressRouteCircuitPeering struct {
	autorest.Response `json:"-"`
	// ExpressRouteCircuitPeeringPropertiesFormat - Properties of the express route circuit peering.
	*ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeering.
func (ercp ExpressRouteCircuitPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercp.ExpressRouteCircuitPeeringPropertiesFormat != nil {
		objectMap["properties"] = ercp.ExpressRouteCircuitPeeringPropertiesFormat
	}
	if ercp.Name != nil {
		objectMap["name"] = ercp.Name
	}
	if ercp.ID != nil {
		objectMap["id"] = ercp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitPeering struct.
func (ercp *ExpressRouteCircuitPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitPeeringPropertiesFormat ExpressRouteCircuitPeeringPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				ercp.ExpressRouteCircuitPeeringPropertiesFormat = &expressRouteCircuitPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ercp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercp.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitPeeringConfig specifies the peering configuration.
type ExpressRouteCircuitPeeringConfig struct {
	// AdvertisedPublicPrefixes - The reference of AdvertisedPublicPrefixes.
	AdvertisedPublicPrefixes *[]string `json:"advertisedPublicPrefixes,omitempty"`
	// AdvertisedCommunities - The communities of bgp peering. Specified for microsoft peering.
	AdvertisedCommunities *[]string `json:"advertisedCommunities,omitempty"`
	// AdvertisedPublicPrefixesState - The advertised public prefix state of the Peering resource. Possible values include: 'NotConfigured', 'Configuring', 'Configured', 'ValidationNeeded'
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	// LegacyMode - The legacy mode of the peering.
	LegacyMode *int32 `json:"legacyMode,omitempty"`
	// CustomerASN - The CustomerASN of the peering.
	CustomerASN *int32 `json:"customerASN,omitempty"`
	// RoutingRegistryName - The RoutingRegistryName of the configuration.
	RoutingRegistryName *string `json:"routingRegistryName,omitempty"`
}

// ExpressRouteCircuitPeeringID expressRoute circuit peering identifier.
type ExpressRouteCircuitPeeringID struct {
	// ID - The ID of the ExpressRoute circuit peering.
	ID *string `json:"id,omitempty"`
}

// ExpressRouteCircuitPeeringListResult response for ListPeering API service call retrieves all peerings
// that belong to an ExpressRouteCircuit.
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - The peerings in an express route circuit.
	Value *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitPeeringListResultIterator provides access to a complete listing of
// ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultIterator struct {
	i    int
	page ExpressRouteCircuitPeeringListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitPeeringListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitPeeringListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitPeeringListResultIterator) Response() ExpressRouteCircuitPeeringListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitPeeringListResultIterator) Value() ExpressRouteCircuitPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultIterator type.
func NewExpressRouteCircuitPeeringListResultIterator(page ExpressRouteCircuitPeeringListResultPage) ExpressRouteCircuitPeeringListResultIterator {
	return ExpressRouteCircuitPeeringListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercplr ExpressRouteCircuitPeeringListResult) IsEmpty() bool {
	return ercplr.Value == nil || len(*ercplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ercplr ExpressRouteCircuitPeeringListResult) hasNextLink() bool {
	return ercplr.NextLink != nil && len(*ercplr.NextLink) != 0
}

// expressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercplr ExpressRouteCircuitPeeringListResult) expressRouteCircuitPeeringListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ercplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercplr.NextLink)))
}

// ExpressRouteCircuitPeeringListResultPage contains a page of ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultPage struct {
	fn     func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)
	ercplr ExpressRouteCircuitPeeringListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitPeeringListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ercplr)
		if err != nil {
			return err
		}
		page.ercplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitPeeringListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitPeeringListResultPage) NotDone() bool {
	return !page.ercplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitPeeringListResultPage) Response() ExpressRouteCircuitPeeringListResult {
	return page.ercplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitPeeringListResultPage) Values() []ExpressRouteCircuitPeering {
	if page.ercplr.IsEmpty() {
		return nil
	}
	return *page.ercplr.Value
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultPage type.
func NewExpressRouteCircuitPeeringListResultPage(cur ExpressRouteCircuitPeeringListResult, getNextPage func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)) ExpressRouteCircuitPeeringListResultPage {
	return ExpressRouteCircuitPeeringListResultPage{
		fn:     getNextPage,
		ercplr: cur,
	}
}

// ExpressRouteCircuitPeeringPropertiesFormat properties of the express route circuit peering.
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// PeeringType - The peering type. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRoutePeeringType `json:"peeringType,omitempty"`
	// State - The peering state. Possible values include: 'ExpressRoutePeeringStateDisabled', 'ExpressRoutePeeringStateEnabled'
	State ExpressRoutePeeringState `json:"state,omitempty"`
	// AzureASN - The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - The peer ASN.
	PeerASN *int64 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// Stats - The peering stats of express route circuit.
	Stats *ExpressRouteCircuitStats `json:"stats,omitempty"`
	// ProvisioningState - The provisioning state of the express route circuit peering resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// LastModifiedBy - Who was the last to modify the peering.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// RouteFilter - The reference of the RouteFilter resource.
	RouteFilter *SubResource `json:"routeFilter,omitempty"`
	// Ipv6PeeringConfig - The IPv6 peering configuration.
	Ipv6PeeringConfig *Ipv6ExpressRouteCircuitPeeringConfig `json:"ipv6PeeringConfig,omitempty"`
	// ExpressRouteConnection - The ExpressRoute connection.
	ExpressRouteConnection *ExpressRouteConnectionID `json:"expressRouteConnection,omitempty"`
	// Connections - The list of circuit connections associated with Azure Private Peering for this circuit.
	Connections *[]ExpressRouteCircuitConnection `json:"connections,omitempty"`
	// PeeredConnections - READ-ONLY; The list of peered circuit connections associated with Azure Private Peering for this circuit.
	PeeredConnections *[]PeerExpressRouteCircuitConnection `json:"peeredConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeeringPropertiesFormat.
func (ercppf ExpressRouteCircuitPeeringPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercppf.PeeringType != "" {
		objectMap["peeringType"] = ercppf.PeeringType
	}
	if ercppf.State != "" {
		objectMap["state"] = ercppf.State
	}
	if ercppf.AzureASN != nil {
		objectMap["azureASN"] = ercppf.AzureASN
	}
	if ercppf.PeerASN != nil {
		objectMap["peerASN"] = ercppf.PeerASN
	}
	if ercppf.PrimaryPeerAddressPrefix != nil {
		objectMap["primaryPeerAddressPrefix"] = ercppf.PrimaryPeerAddressPrefix
	}
	if ercppf.SecondaryPeerAddressPrefix != nil {
		objectMap["secondaryPeerAddressPrefix"] = ercppf.SecondaryPeerAddressPrefix
	}
	if ercppf.PrimaryAzurePort != nil {
		objectMap["primaryAzurePort"] = ercppf.PrimaryAzurePort
	}
	if ercppf.SecondaryAzurePort != nil {
		objectMap["secondaryAzurePort"] = ercppf.SecondaryAzurePort
	}
	if ercppf.SharedKey != nil {
		objectMap["sharedKey"] = ercppf.SharedKey
	}
	if ercppf.VlanID != nil {
		objectMap["vlanId"] = ercppf.VlanID
	}
	if ercppf.MicrosoftPeeringConfig != nil {
		objectMap["microsoftPeeringConfig"] = ercppf.MicrosoftPeeringConfig
	}
	if ercppf.Stats != nil {
		objectMap["stats"] = ercppf.Stats
	}
	if ercppf.ProvisioningState != "" {
		objectMap["provisioningState"] = ercppf.ProvisioningState
	}
	if ercppf.GatewayManagerEtag != nil {
		objectMap["gatewayManagerEtag"] = ercppf.GatewayManagerEtag
	}
	if ercppf.LastModifiedBy != nil {
		objectMap["lastModifiedBy"] = ercppf.LastModifiedBy
	}
	if ercppf.RouteFilter != nil {
		objectMap["routeFilter"] = ercppf.RouteFilter
	}
	if ercppf.Ipv6PeeringConfig != nil {
		objectMap["ipv6PeeringConfig"] = ercppf.Ipv6PeeringConfig
	}
	if ercppf.ExpressRouteConnection != nil {
		objectMap["expressRouteConnection"] = ercppf.ExpressRouteConnection
	}
	if ercppf.Connections != nil {
		objectMap["connections"] = ercppf.Connections
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuitPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitPeeringsClient) (ExpressRouteCircuitPeering, error)
}

// ExpressRouteCircuitPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitPeeringsClient) (autorest.Response, error)
}

// ExpressRouteCircuitPropertiesFormat properties of ExpressRouteCircuit.
type ExpressRouteCircuitPropertiesFormat struct {
	// AllowClassicOperations - Allow classic operations.
	AllowClassicOperations *bool `json:"allowClassicOperations,omitempty"`
	// CircuitProvisioningState - The CircuitProvisioningState state of the resource.
	CircuitProvisioningState *string `json:"circuitProvisioningState,omitempty"`
	// ServiceProviderProvisioningState - The ServiceProviderProvisioningState state of the resource. Possible values include: 'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// Authorizations - The list of authorizations.
	Authorizations *[]ExpressRouteCircuitAuthorization `json:"authorizations,omitempty"`
	// Peerings - The list of peerings.
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// ServiceKey - The ServiceKey.
	ServiceKey *string `json:"serviceKey,omitempty"`
	// ServiceProviderNotes - The ServiceProviderNotes.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ServiceProviderProperties - The ServiceProviderProperties.
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	// ExpressRoutePort - The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
	ExpressRoutePort *SubResource `json:"expressRoutePort,omitempty"`
	// BandwidthInGbps - The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
	BandwidthInGbps *float64 `json:"bandwidthInGbps,omitempty"`
	// Stag - READ-ONLY; The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
	Stag *int32 `json:"stag,omitempty"`
	// ProvisioningState - The provisioning state of the express route circuit resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// GlobalReachEnabled - Flag denoting Global reach status.
	GlobalReachEnabled *bool `json:"globalReachEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPropertiesFormat.
func (ercpf ExpressRouteCircuitPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercpf.AllowClassicOperations != nil {
		objectMap["allowClassicOperations"] = ercpf.AllowClassicOperations
	}
	if ercpf.CircuitProvisioningState != nil {
		objectMap["circuitProvisioningState"] = ercpf.CircuitProvisioningState
	}
	if ercpf.ServiceProviderProvisioningState != "" {
		objectMap["serviceProviderProvisioningState"] = ercpf.ServiceProviderProvisioningState
	}
	if ercpf.Authorizations != nil {
		objectMap["authorizations"] = ercpf.Authorizations
	}
	if ercpf.Peerings != nil {
		objectMap["peerings"] = ercpf.Peerings
	}
	if ercpf.ServiceKey != nil {
		objectMap["serviceKey"] = ercpf.ServiceKey
	}
	if ercpf.ServiceProviderNotes != nil {
		objectMap["serviceProviderNotes"] = ercpf.ServiceProviderNotes
	}
	if ercpf.ServiceProviderProperties != nil {
		objectMap["serviceProviderProperties"] = ercpf.ServiceProviderProperties
	}
	if ercpf.ExpressRoutePort != nil {
		objectMap["expressRoutePort"] = ercpf.ExpressRoutePort
	}
	if ercpf.BandwidthInGbps != nil {
		objectMap["bandwidthInGbps"] = ercpf.BandwidthInGbps
	}
	if ercpf.ProvisioningState != "" {
		objectMap["provisioningState"] = ercpf.ProvisioningState
	}
	if ercpf.GatewayManagerEtag != nil {
		objectMap["gatewayManagerEtag"] = ercpf.GatewayManagerEtag
	}
	if ercpf.GlobalReachEnabled != nil {
		objectMap["globalReachEnabled"] = ercpf.GlobalReachEnabled
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuitReference reference to an express route circuit.
type ExpressRouteCircuitReference struct {
	// ID - Corresponding Express Route Circuit Id.
	ID *string `json:"id,omitempty"`
}

// ExpressRouteCircuitRoutesTable the routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTable struct {
	// NetworkProperty - IP address of a network entity.
	NetworkProperty *string `json:"network,omitempty"`
	// NextHop - NextHop address.
	NextHop *string `json:"nextHop,omitempty"`
	// LocPrf - Local preference value as set with the set local-preference route-map configuration command.
	LocPrf *string `json:"locPrf,omitempty"`
	// Weight - Route Weight.
	Weight *int32 `json:"weight,omitempty"`
	// Path - Autonomous system paths to the destination network.
	Path *string `json:"path,omitempty"`
}

// ExpressRouteCircuitRoutesTableSummary the routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTableSummary struct {
	// Neighbor - IP address of the neighbor.
	Neighbor *string `json:"neighbor,omitempty"`
	// V - BGP version number spoken to the neighbor.
	V *int32 `json:"v,omitempty"`
	// As - Autonomous system number.
	As *int32 `json:"as,omitempty"`
	// UpDown - The length of time that the BGP session has been in the Established state, or the current status if not in the Established state.
	UpDown *string `json:"upDown,omitempty"`
	// StatePfxRcd - Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StatePfxRcd *string `json:"statePfxRcd,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult response for ListArpTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of the ARP tables.
	Value *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuit, error)
}

// ExpressRouteCircuitsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (autorest.Response, error)
}

// ExpressRouteCircuitServiceProviderProperties contains ServiceProviderProperties in an
// ExpressRouteCircuit.
type ExpressRouteCircuitServiceProviderProperties struct {
	// ServiceProviderName - The serviceProviderName.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	// PeeringLocation - The peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - The BandwidthInMbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
}

// ExpressRouteCircuitSku contains SKU in an ExpressRouteCircuit.
type ExpressRouteCircuitSku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU. Possible values include: 'ExpressRouteCircuitSkuTierStandard', 'ExpressRouteCircuitSkuTierPremium', 'ExpressRouteCircuitSkuTierBasic', 'ExpressRouteCircuitSkuTierLocal'
	Tier ExpressRouteCircuitSkuTier `json:"tier,omitempty"`
	// Family - The family of the SKU. Possible values include: 'UnlimitedData', 'MeteredData'
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// ExpressRouteCircuitsListArpTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListArpTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsArpTableListResult, error)
}

// ExpressRouteCircuitsListRoutesTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListRoutesTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsRoutesTableListResult, error)
}

// ExpressRouteCircuitsListRoutesTableSummaryFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitsListRoutesTableSummaryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsRoutesTableSummaryListResult, error)
}

// ExpressRouteCircuitsRoutesTableListResult response for ListRoutesTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of routes table.
	Value *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsRoutesTableSummaryListResult response for ListRoutesTable associated with the
// Express Route Circuits API.
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of the routes table.
	Value *[]ExpressRouteCircuitRoutesTableSummary `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitStats contains stats associated with the peering.
type ExpressRouteCircuitStats struct {
	autorest.Response `json:"-"`
	// PrimarybytesIn - The Primary BytesIn of the peering.
	PrimarybytesIn *int64 `json:"primarybytesIn,omitempty"`
	// PrimarybytesOut - The primary BytesOut of the peering.
	PrimarybytesOut *int64 `json:"primarybytesOut,omitempty"`
	// SecondarybytesIn - The secondary BytesIn of the peering.
	SecondarybytesIn *int64 `json:"secondarybytesIn,omitempty"`
	// SecondarybytesOut - The secondary BytesOut of the peering.
	SecondarybytesOut *int64 `json:"secondarybytesOut,omitempty"`
}

// ExpressRouteCircuitsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuit, error)
}

// ExpressRouteConnection expressRouteConnection resource.
type ExpressRouteConnection struct {
	autorest.Response `json:"-"`
	// ExpressRouteConnectionProperties - Properties of the express route connection.
	*ExpressRouteConnectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteConnection.
func (erc ExpressRouteConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.ExpressRouteConnectionProperties != nil {
		objectMap["properties"] = erc.ExpressRouteConnectionProperties
	}
	if erc.Name != nil {
		objectMap["name"] = erc.Name
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteConnection struct.
func (erc *ExpressRouteConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteConnectionProperties ExpressRouteConnectionProperties
				err = json.Unmarshal(*v, &expressRouteConnectionProperties)
				if err != nil {
					return err
				}
				erc.ExpressRouteConnectionProperties = &expressRouteConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteConnectionID the ID of the ExpressRouteConnection.
type ExpressRouteConnectionID struct {
	// ID - READ-ONLY; The ID of the ExpressRouteConnection.
	ID *string `json:"id,omitempty"`
}

// ExpressRouteConnectionList expressRouteConnection list.
type ExpressRouteConnectionList struct {
	autorest.Response `json:"-"`
	// Value - The list of ExpressRoute connections.
	Value *[]ExpressRouteConnection `json:"value,omitempty"`
}

// ExpressRouteConnectionProperties properties of the ExpressRouteConnection subresource.
type ExpressRouteConnectionProperties struct {
	// ProvisioningState - The provisioning state of the express route connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ExpressRouteCircuitPeering - The ExpressRoute circuit peering.
	ExpressRouteCircuitPeering *ExpressRouteCircuitPeeringID `json:"expressRouteCircuitPeering,omitempty"`
	// AuthorizationKey - Authorization key to establish the connection.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// RoutingWeight - The routing weight associated to the connection.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`
}

// ExpressRouteConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ExpressRouteConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteConnectionsClient) (ExpressRouteConnection, error)
}

// ExpressRouteConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteConnectionsClient) (autorest.Response, error)
}

// ExpressRouteCrossConnection expressRouteCrossConnection resource.
type ExpressRouteCrossConnection struct {
	autorest.Response `json:"-"`
	// ExpressRouteCrossConnectionProperties - Properties of the express route cross connection.
	*ExpressRouteCrossConnectionProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnection.
func (ercc ExpressRouteCrossConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercc.ExpressRouteCrossConnectionProperties != nil {
		objectMap["properties"] = ercc.ExpressRouteCrossConnectionProperties
	}
	if ercc.ID != nil {
		objectMap["id"] = ercc.ID
	}
	if ercc.Location != nil {
		objectMap["location"] = ercc.Location
	}
	if ercc.Tags != nil {
		objectMap["tags"] = ercc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCrossConnection struct.
func (ercc *ExpressRouteCrossConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCrossConnectionProperties ExpressRouteCrossConnectionProperties
				err = json.Unmarshal(*v, &expressRouteCrossConnectionProperties)
				if err != nil {
					return err
				}
				ercc.ExpressRouteCrossConnectionProperties = &expressRouteCrossConnectionProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ercc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ercc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ercc.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteCrossConnectionListResult response for ListExpressRouteCrossConnection API service call.
type ExpressRouteCrossConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteCrossConnection resources.
	Value *[]ExpressRouteCrossConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionListResult.
func (ercclr ExpressRouteCrossConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercclr.Value != nil {
		objectMap["value"] = ercclr.Value
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionListResultIterator provides access to a complete listing of
// ExpressRouteCrossConnection values.
type ExpressRouteCrossConnectionListResultIterator struct {
	i    int
	page ExpressRouteCrossConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCrossConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCrossConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCrossConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCrossConnectionListResultIterator) Response() ExpressRouteCrossConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCrossConnectionListResultIterator) Value() ExpressRouteCrossConnection {
	if !iter.page.NotDone() {
		return ExpressRouteCrossConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCrossConnectionListResultIterator type.
func NewExpressRouteCrossConnectionListResultIterator(page ExpressRouteCrossConnectionListResultPage) ExpressRouteCrossConnectionListResultIterator {
	return ExpressRouteCrossConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercclr ExpressRouteCrossConnectionListResult) IsEmpty() bool {
	return ercclr.Value == nil || len(*ercclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ercclr ExpressRouteCrossConnectionListResult) hasNextLink() bool {
	return ercclr.NextLink != nil && len(*ercclr.NextLink) != 0
}

// expressRouteCrossConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercclr ExpressRouteCrossConnectionListResult) expressRouteCrossConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ercclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercclr.NextLink)))
}

// ExpressRouteCrossConnectionListResultPage contains a page of ExpressRouteCrossConnection values.
type ExpressRouteCrossConnectionListResultPage struct {
	fn     func(context.Context, ExpressRouteCrossConnectionListResult) (ExpressRouteCrossConnectionListResult, error)
	ercclr ExpressRouteCrossConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCrossConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ercclr)
		if err != nil {
			return err
		}
		page.ercclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCrossConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCrossConnectionListResultPage) NotDone() bool {
	return !page.ercclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCrossConnectionListResultPage) Response() ExpressRouteCrossConnectionListResult {
	return page.ercclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCrossConnectionListResultPage) Values() []ExpressRouteCrossConnection {
	if page.ercclr.IsEmpty() {
		return nil
	}
	return *page.ercclr.Value
}

// Creates a new instance of the ExpressRouteCrossConnectionListResultPage type.
func NewExpressRouteCrossConnectionListResultPage(cur ExpressRouteCrossConnectionListResult, getNextPage func(context.Context, ExpressRouteCrossConnectionListResult) (ExpressRouteCrossConnectionListResult, error)) ExpressRouteCrossConnectionListResultPage {
	return ExpressRouteCrossConnectionListResultPage{
		fn:     getNextPage,
		ercclr: cur,
	}
}

// ExpressRouteCrossConnectionPeering peering in an ExpressRoute Cross Connection resource.
type ExpressRouteCrossConnectionPeering struct {
	autorest.Response `json:"-"`
	// ExpressRouteCrossConnectionPeeringProperties - Properties of the express route cross connection peering.
	*ExpressRouteCrossConnectionPeeringProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionPeering.
func (erccp ExpressRouteCrossConnectionPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccp.ExpressRouteCrossConnectionPeeringProperties != nil {
		objectMap["properties"] = erccp.ExpressRouteCrossConnectionPeeringProperties
	}
	if erccp.Name != nil {
		objectMap["name"] = erccp.Name
	}
	if erccp.ID != nil {
		objectMap["id"] = erccp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCrossConnectionPeering struct.
func (erccp *ExpressRouteCrossConnectionPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCrossConnectionPeeringProperties ExpressRouteCrossConnectionPeeringProperties
				err = json.Unmarshal(*v, &expressRouteCrossConnectionPeeringProperties)
				if err != nil {
					return err
				}
				erccp.ExpressRouteCrossConnectionPeeringProperties = &expressRouteCrossConnectionPeeringProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erccp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erccp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erccp.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCrossConnectionPeeringList response for ListPeering API service call retrieves all peerings
// that belong to an ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionPeeringList struct {
	autorest.Response `json:"-"`
	// Value - The peerings in an express route cross connection.
	Value *[]ExpressRouteCrossConnectionPeering `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionPeeringList.
func (erccpl ExpressRouteCrossConnectionPeeringList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccpl.Value != nil {
		objectMap["value"] = erccpl.Value
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionPeeringListIterator provides access to a complete listing of
// ExpressRouteCrossConnectionPeering values.
type ExpressRouteCrossConnectionPeeringListIterator struct {
	i    int
	page ExpressRouteCrossConnectionPeeringListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCrossConnectionPeeringListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionPeeringListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCrossConnectionPeeringListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCrossConnectionPeeringListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCrossConnectionPeeringListIterator) Response() ExpressRouteCrossConnectionPeeringList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCrossConnectionPeeringListIterator) Value() ExpressRouteCrossConnectionPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCrossConnectionPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCrossConnectionPeeringListIterator type.
func NewExpressRouteCrossConnectionPeeringListIterator(page ExpressRouteCrossConnectionPeeringListPage) ExpressRouteCrossConnectionPeeringListIterator {
	return ExpressRouteCrossConnectionPeeringListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erccpl ExpressRouteCrossConnectionPeeringList) IsEmpty() bool {
	return erccpl.Value == nil || len(*erccpl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erccpl ExpressRouteCrossConnectionPeeringList) hasNextLink() bool {
	return erccpl.NextLink != nil && len(*erccpl.NextLink) != 0
}

// expressRouteCrossConnectionPeeringListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erccpl ExpressRouteCrossConnectionPeeringList) expressRouteCrossConnectionPeeringListPreparer(ctx context.Context) (*http.Request, error) {
	if !erccpl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erccpl.NextLink)))
}

// ExpressRouteCrossConnectionPeeringListPage contains a page of ExpressRouteCrossConnectionPeering values.
type ExpressRouteCrossConnectionPeeringListPage struct {
	fn     func(context.Context, ExpressRouteCrossConnectionPeeringList) (ExpressRouteCrossConnectionPeeringList, error)
	erccpl ExpressRouteCrossConnectionPeeringList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCrossConnectionPeeringListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionPeeringListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erccpl)
		if err != nil {
			return err
		}
		page.erccpl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCrossConnectionPeeringListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCrossConnectionPeeringListPage) NotDone() bool {
	return !page.erccpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCrossConnectionPeeringListPage) Response() ExpressRouteCrossConnectionPeeringList {
	return page.erccpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCrossConnectionPeeringListPage) Values() []ExpressRouteCrossConnectionPeering {
	if page.erccpl.IsEmpty() {
		return nil
	}
	return *page.erccpl.Value
}

// Creates a new instance of the ExpressRouteCrossConnectionPeeringListPage type.
func NewExpressRouteCrossConnectionPeeringListPage(cur ExpressRouteCrossConnectionPeeringList, getNextPage func(context.Context, ExpressRouteCrossConnectionPeeringList) (ExpressRouteCrossConnectionPeeringList, error)) ExpressRouteCrossConnectionPeeringListPage {
	return ExpressRouteCrossConnectionPeeringListPage{
		fn:     getNextPage,
		erccpl: cur,
	}
}

// ExpressRouteCrossConnectionPeeringProperties properties of express route cross connection peering.
type ExpressRouteCrossConnectionPeeringProperties struct {
	// PeeringType - The peering type. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRoutePeeringType `json:"peeringType,omitempty"`
	// State - The peering state. Possible values include: 'ExpressRoutePeeringStateDisabled', 'ExpressRoutePeeringStateEnabled'
	State ExpressRoutePeeringState `json:"state,omitempty"`
	// AzureASN - READ-ONLY; The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - The peer ASN.
	PeerASN *int64 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - READ-ONLY; The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - READ-ONLY; The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route cross connection peering resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// LastModifiedBy - Who was the last to modify the peering.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// Ipv6PeeringConfig - The IPv6 peering configuration.
	Ipv6PeeringConfig *Ipv6ExpressRouteCircuitPeeringConfig `json:"ipv6PeeringConfig,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionPeeringProperties.
func (erccpp ExpressRouteCrossConnectionPeeringProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccpp.PeeringType != "" {
		objectMap["peeringType"] = erccpp.PeeringType
	}
	if erccpp.State != "" {
		objectMap["state"] = erccpp.State
	}
	if erccpp.PeerASN != nil {
		objectMap["peerASN"] = erccpp.PeerASN
	}
	if erccpp.PrimaryPeerAddressPrefix != nil {
		objectMap["primaryPeerAddressPrefix"] = erccpp.PrimaryPeerAddressPrefix
	}
	if erccpp.SecondaryPeerAddressPrefix != nil {
		objectMap["secondaryPeerAddressPrefix"] = erccpp.SecondaryPeerAddressPrefix
	}
	if erccpp.SharedKey != nil {
		objectMap["sharedKey"] = erccpp.SharedKey
	}
	if erccpp.VlanID != nil {
		objectMap["vlanId"] = erccpp.VlanID
	}
	if erccpp.MicrosoftPeeringConfig != nil {
		objectMap["microsoftPeeringConfig"] = erccpp.MicrosoftPeeringConfig
	}
	if erccpp.GatewayManagerEtag != nil {
		objectMap["gatewayManagerEtag"] = erccpp.GatewayManagerEtag
	}
	if erccpp.LastModifiedBy != nil {
		objectMap["lastModifiedBy"] = erccpp.LastModifiedBy
	}
	if erccpp.Ipv6PeeringConfig != nil {
		objectMap["ipv6PeeringConfig"] = erccpp.Ipv6PeeringConfig
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionPeeringsClient) (ExpressRouteCrossConnectionPeering, error)
}

// ExpressRouteCrossConnectionPeeringsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCrossConnectionPeeringsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionPeeringsClient) (autorest.Response, error)
}

// ExpressRouteCrossConnectionProperties properties of ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionProperties struct {
	// PrimaryAzurePort - READ-ONLY; The name of the primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - READ-ONLY; The name of the secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// STag - READ-ONLY; The identifier of the circuit traffic.
	STag *int32 `json:"sTag,omitempty"`
	// PeeringLocation - The peering location of the ExpressRoute circuit.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - The circuit bandwidth In Mbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
	// ExpressRouteCircuit - The ExpressRouteCircuit.
	ExpressRouteCircuit *ExpressRouteCircuitReference `json:"expressRouteCircuit,omitempty"`
	// ServiceProviderProvisioningState - The provisioning state of the circuit in the connectivity provider system. Possible values include: 'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// ServiceProviderNotes - Additional read only notes set by the connectivity provider.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route cross connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Peerings - The list of peerings.
	Peerings *[]ExpressRouteCrossConnectionPeering `json:"peerings,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionProperties.
func (erccp ExpressRouteCrossConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccp.PeeringLocation != nil {
		objectMap["peeringLocation"] = erccp.PeeringLocation
	}
	if erccp.BandwidthInMbps != nil {
		objectMap["bandwidthInMbps"] = erccp.BandwidthInMbps
	}
	if erccp.ExpressRouteCircuit != nil {
		objectMap["expressRouteCircuit"] = erccp.ExpressRouteCircuit
	}
	if erccp.ServiceProviderProvisioningState != "" {
		objectMap["serviceProviderProvisioningState"] = erccp.ServiceProviderProvisioningState
	}
	if erccp.ServiceProviderNotes != nil {
		objectMap["serviceProviderNotes"] = erccp.ServiceProviderNotes
	}
	if erccp.Peerings != nil {
		objectMap["peerings"] = erccp.Peerings
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionRoutesTableSummary the routes table associated with the ExpressRouteCircuit.
type ExpressRouteCrossConnectionRoutesTableSummary struct {
	// Neighbor - IP address of Neighbor router.
	Neighbor *string `json:"neighbor,omitempty"`
	// Asn - Autonomous system number.
	Asn *int32 `json:"asn,omitempty"`
	// UpDown - The length of time that the BGP session has been in the Established state, or the current status if not in the Established state.
	UpDown *string `json:"upDown,omitempty"`
	// StateOrPrefixesReceived - Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StateOrPrefixesReceived *string `json:"stateOrPrefixesReceived,omitempty"`
}

// ExpressRouteCrossConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCrossConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCrossConnection, error)
}

// ExpressRouteCrossConnectionsListArpTableFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCrossConnectionsListArpTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCircuitsArpTableListResult, error)
}

// ExpressRouteCrossConnectionsListRoutesTableFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCrossConnectionsListRoutesTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCircuitsRoutesTableListResult, error)
}

// ExpressRouteCrossConnectionsListRoutesTableSummaryFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ExpressRouteCrossConnectionsListRoutesTableSummaryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCrossConnectionsRoutesTableSummaryListResult, error)
}

// ExpressRouteCrossConnectionsRoutesTableSummaryListResult response for ListRoutesTable associated with
// the Express Route Cross Connections.
type ExpressRouteCrossConnectionsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of the routes table.
	Value *[]ExpressRouteCrossConnectionRoutesTableSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionsRoutesTableSummaryListResult.
func (erccrtslr ExpressRouteCrossConnectionsRoutesTableSummaryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccrtslr.Value != nil {
		objectMap["value"] = erccrtslr.Value
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionsUpdateTagsFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ExpressRouteCrossConnectionsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCrossConnection, error)
}

// ExpressRouteGateway expressRoute gateway resource.
type ExpressRouteGateway struct {
	autorest.Response `json:"-"`
	// ExpressRouteGatewayProperties - Properties of the express route gateway.
	*ExpressRouteGatewayProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteGateway.
func (erg ExpressRouteGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erg.ExpressRouteGatewayProperties != nil {
		objectMap["properties"] = erg.ExpressRouteGatewayProperties
	}
	if erg.ID != nil {
		objectMap["id"] = erg.ID
	}
	if erg.Location != nil {
		objectMap["location"] = erg.Location
	}
	if erg.Tags != nil {
		objectMap["tags"] = erg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteGateway struct.
func (erg *ExpressRouteGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteGatewayProperties ExpressRouteGatewayProperties
				err = json.Unmarshal(*v, &expressRouteGatewayProperties)
				if err != nil {
					return err
				}
				erg.ExpressRouteGatewayProperties = &expressRouteGatewayProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erg.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteGatewayList list of ExpressRoute gateways.
type ExpressRouteGatewayList struct {
	autorest.Response `json:"-"`
	// Value - List of ExpressRoute gateways.
	Value *[]ExpressRouteGateway `json:"value,omitempty"`
}

// ExpressRouteGatewayProperties expressRoute gateway resource properties.
type ExpressRouteGatewayProperties struct {
	// AutoScaleConfiguration - Configuration for auto scaling.
	AutoScaleConfiguration *ExpressRouteGatewayPropertiesAutoScaleConfiguration `json:"autoScaleConfiguration,omitempty"`
	// ExpressRouteConnections - READ-ONLY; List of ExpressRoute connections to the ExpressRoute gateway.
	ExpressRouteConnections *[]ExpressRouteConnection `json:"expressRouteConnections,omitempty"`
	// ProvisioningState - The provisioning state of the express route gateway resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VirtualHub - The Virtual Hub where the ExpressRoute gateway is or will be deployed.
	VirtualHub *VirtualHubID `json:"virtualHub,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteGatewayProperties.
func (ergp ExpressRouteGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ergp.AutoScaleConfiguration != nil {
		objectMap["autoScaleConfiguration"] = ergp.AutoScaleConfiguration
	}
	if ergp.ProvisioningState != "" {
		objectMap["provisioningState"] = ergp.ProvisioningState
	}
	if ergp.VirtualHub != nil {
		objectMap["virtualHub"] = ergp.VirtualHub
	}
	return json.Marshal(objectMap)
}

// ExpressRouteGatewayPropertiesAutoScaleConfiguration configuration for auto scaling.
type ExpressRouteGatewayPropertiesAutoScaleConfiguration struct {
	// Bounds - Minimum and maximum number of scale units to deploy.
	Bounds *ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds `json:"bounds,omitempty"`
}

// ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds minimum and maximum number of scale units to
// deploy.
type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds struct {
	// Min - Minimum number of scale units deployed for ExpressRoute gateway.
	Min *int32 `json:"min,omitempty"`
	// Max - Maximum number of scale units deployed for ExpressRoute gateway.
	Max *int32 `json:"max,omitempty"`
}

// ExpressRouteGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteGatewaysClient) (ExpressRouteGateway, error)
}

// ExpressRouteGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteGatewaysClient) (autorest.Response, error)
}

// ExpressRouteLink expressRouteLink child resource definition.
type ExpressRouteLink struct {
	autorest.Response `json:"-"`
	// ExpressRouteLinkPropertiesFormat - ExpressRouteLink properties.
	*ExpressRouteLinkPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of child port resource that is unique among child port resources of the parent.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteLink.
func (erl ExpressRouteLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erl.ExpressRouteLinkPropertiesFormat != nil {
		objectMap["properties"] = erl.ExpressRouteLinkPropertiesFormat
	}
	if erl.Name != nil {
		objectMap["name"] = erl.Name
	}
	if erl.ID != nil {
		objectMap["id"] = erl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteLink struct.
func (erl *ExpressRouteLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteLinkPropertiesFormat ExpressRouteLinkPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteLinkPropertiesFormat)
				if err != nil {
					return err
				}
				erl.ExpressRouteLinkPropertiesFormat = &expressRouteLinkPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erl.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteLinkListResult response for ListExpressRouteLinks API service call.
type ExpressRouteLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of ExpressRouteLink sub-resources.
	Value *[]ExpressRouteLink `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteLinkListResultIterator provides access to a complete listing of ExpressRouteLink values.
type ExpressRouteLinkListResultIterator struct {
	i    int
	page ExpressRouteLinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteLinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteLinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteLinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteLinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteLinkListResultIterator) Response() ExpressRouteLinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteLinkListResultIterator) Value() ExpressRouteLink {
	if !iter.page.NotDone() {
		return ExpressRouteLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteLinkListResultIterator type.
func NewExpressRouteLinkListResultIterator(page ExpressRouteLinkListResultPage) ExpressRouteLinkListResultIterator {
	return ExpressRouteLinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erllr ExpressRouteLinkListResult) IsEmpty() bool {
	return erllr.Value == nil || len(*erllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erllr ExpressRouteLinkListResult) hasNextLink() bool {
	return erllr.NextLink != nil && len(*erllr.NextLink) != 0
}

// expressRouteLinkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erllr ExpressRouteLinkListResult) expressRouteLinkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erllr.NextLink)))
}

// ExpressRouteLinkListResultPage contains a page of ExpressRouteLink values.
type ExpressRouteLinkListResultPage struct {
	fn    func(context.Context, ExpressRouteLinkListResult) (ExpressRouteLinkListResult, error)
	erllr ExpressRouteLinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteLinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteLinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erllr)
		if err != nil {
			return err
		}
		page.erllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteLinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteLinkListResultPage) NotDone() bool {
	return !page.erllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteLinkListResultPage) Response() ExpressRouteLinkListResult {
	return page.erllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteLinkListResultPage) Values() []ExpressRouteLink {
	if page.erllr.IsEmpty() {
		return nil
	}
	return *page.erllr.Value
}

// Creates a new instance of the ExpressRouteLinkListResultPage type.
func NewExpressRouteLinkListResultPage(cur ExpressRouteLinkListResult, getNextPage func(context.Context, ExpressRouteLinkListResult) (ExpressRouteLinkListResult, error)) ExpressRouteLinkListResultPage {
	return ExpressRouteLinkListResultPage{
		fn:    getNextPage,
		erllr: cur,
	}
}

// ExpressRouteLinkMacSecConfig expressRouteLink Mac Security Configuration.
type ExpressRouteLinkMacSecConfig struct {
	// CknSecretIdentifier - Keyvault Secret Identifier URL containing Mac security CKN key.
	CknSecretIdentifier *string `json:"cknSecretIdentifier,omitempty"`
	// CakSecretIdentifier - Keyvault Secret Identifier URL containing Mac security CAK key.
	CakSecretIdentifier *string `json:"cakSecretIdentifier,omitempty"`
	// Cipher - Mac security cipher. Possible values include: 'GcmAes128', 'GcmAes256'
	Cipher ExpressRouteLinkMacSecCipher `json:"cipher,omitempty"`
}

// ExpressRouteLinkPropertiesFormat properties specific to ExpressRouteLink resources.
type ExpressRouteLinkPropertiesFormat struct {
	// RouterName - READ-ONLY; Name of Azure router associated with physical port.
	RouterName *string `json:"routerName,omitempty"`
	// InterfaceName - READ-ONLY; Name of Azure router interface.
	InterfaceName *string `json:"interfaceName,omitempty"`
	// PatchPanelID - READ-ONLY; Mapping between physical port to patch panel port.
	PatchPanelID *string `json:"patchPanelId,omitempty"`
	// RackID - READ-ONLY; Mapping of physical patch panel to rack.
	RackID *string `json:"rackId,omitempty"`
	// ConnectorType - READ-ONLY; Physical fiber port type. Possible values include: 'LC', 'SC'
	ConnectorType ExpressRouteLinkConnectorType `json:"connectorType,omitempty"`
	// AdminState - Administrative state of the physical port. Possible values include: 'ExpressRouteLinkAdminStateEnabled', 'ExpressRouteLinkAdminStateDisabled'
	AdminState ExpressRouteLinkAdminState `json:"adminState,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route link resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// MacSecConfig - MacSec configuration.
	MacSecConfig *ExpressRouteLinkMacSecConfig `json:"macSecConfig,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteLinkPropertiesFormat.
func (erlpf ExpressRouteLinkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erlpf.AdminState != "" {
		objectMap["adminState"] = erlpf.AdminState
	}
	if erlpf.MacSecConfig != nil {
		objectMap["macSecConfig"] = erlpf.MacSecConfig
	}
	return json.Marshal(objectMap)
}

// ExpressRoutePort expressRoutePort resource definition.
type ExpressRoutePort struct {
	autorest.Response `json:"-"`
	// ExpressRoutePortPropertiesFormat - ExpressRoutePort properties.
	*ExpressRoutePortPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Identity - The identity of ExpressRoutePort, if configured.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePort.
func (erp ExpressRoutePort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erp.ExpressRoutePortPropertiesFormat != nil {
		objectMap["properties"] = erp.ExpressRoutePortPropertiesFormat
	}
	if erp.Identity != nil {
		objectMap["identity"] = erp.Identity
	}
	if erp.ID != nil {
		objectMap["id"] = erp.ID
	}
	if erp.Location != nil {
		objectMap["location"] = erp.Location
	}
	if erp.Tags != nil {
		objectMap["tags"] = erp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRoutePort struct.
func (erp *ExpressRoutePort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRoutePortPropertiesFormat ExpressRoutePortPropertiesFormat
				err = json.Unmarshal(*v, &expressRoutePortPropertiesFormat)
				if err != nil {
					return err
				}
				erp.ExpressRoutePortPropertiesFormat = &expressRoutePortPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erp.Etag = &etag
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				erp.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRoutePortListResult response for ListExpressRoutePorts API service call.
type ExpressRoutePortListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRoutePort resources.
	Value *[]ExpressRoutePort `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRoutePortListResultIterator provides access to a complete listing of ExpressRoutePort values.
type ExpressRoutePortListResultIterator struct {
	i    int
	page ExpressRoutePortListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRoutePortListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRoutePortListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRoutePortListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRoutePortListResultIterator) Response() ExpressRoutePortListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRoutePortListResultIterator) Value() ExpressRoutePort {
	if !iter.page.NotDone() {
		return ExpressRoutePort{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRoutePortListResultIterator type.
func NewExpressRoutePortListResultIterator(page ExpressRoutePortListResultPage) ExpressRoutePortListResultIterator {
	return ExpressRoutePortListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erplr ExpressRoutePortListResult) IsEmpty() bool {
	return erplr.Value == nil || len(*erplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erplr ExpressRoutePortListResult) hasNextLink() bool {
	return erplr.NextLink != nil && len(*erplr.NextLink) != 0
}

// expressRoutePortListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erplr ExpressRoutePortListResult) expressRoutePortListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erplr.NextLink)))
}

// ExpressRoutePortListResultPage contains a page of ExpressRoutePort values.
type ExpressRoutePortListResultPage struct {
	fn    func(context.Context, ExpressRoutePortListResult) (ExpressRoutePortListResult, error)
	erplr ExpressRoutePortListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRoutePortListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erplr)
		if err != nil {
			return err
		}
		page.erplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRoutePortListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRoutePortListResultPage) NotDone() bool {
	return !page.erplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRoutePortListResultPage) Response() ExpressRoutePortListResult {
	return page.erplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRoutePortListResultPage) Values() []ExpressRoutePort {
	if page.erplr.IsEmpty() {
		return nil
	}
	return *page.erplr.Value
}

// Creates a new instance of the ExpressRoutePortListResultPage type.
func NewExpressRoutePortListResultPage(cur ExpressRoutePortListResult, getNextPage func(context.Context, ExpressRoutePortListResult) (ExpressRoutePortListResult, error)) ExpressRoutePortListResultPage {
	return ExpressRoutePortListResultPage{
		fn:    getNextPage,
		erplr: cur,
	}
}

// ExpressRoutePortPropertiesFormat properties specific to ExpressRoutePort resources.
type ExpressRoutePortPropertiesFormat struct {
	// PeeringLocation - The name of the peering location that the ExpressRoutePort is mapped to physically.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInGbps - Bandwidth of procured ports in Gbps.
	BandwidthInGbps *int32 `json:"bandwidthInGbps,omitempty"`
	// ProvisionedBandwidthInGbps - READ-ONLY; Aggregate Gbps of associated circuit bandwidths.
	ProvisionedBandwidthInGbps *float64 `json:"provisionedBandwidthInGbps,omitempty"`
	// Mtu - READ-ONLY; Maximum transmission unit of the physical port pair(s).
	Mtu *string `json:"mtu,omitempty"`
	// Encapsulation - Encapsulation method on physical ports. Possible values include: 'Dot1Q', 'QinQ'
	Encapsulation ExpressRoutePortsEncapsulation `json:"encapsulation,omitempty"`
	// EtherType - READ-ONLY; Ether type of the physical port.
	EtherType *string `json:"etherType,omitempty"`
	// AllocationDate - READ-ONLY; Date of the physical port allocation to be used in Letter of Authorization.
	AllocationDate *string `json:"allocationDate,omitempty"`
	// Links - The set of physical links of the ExpressRoutePort resource.
	Links *[]ExpressRouteLink `json:"links,omitempty"`
	// Circuits - READ-ONLY; Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource.
	Circuits *[]SubResource `json:"circuits,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route port resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ResourceGUID - The resource GUID property of the express route port resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortPropertiesFormat.
func (erppf ExpressRoutePortPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erppf.PeeringLocation != nil {
		objectMap["peeringLocation"] = erppf.PeeringLocation
	}
	if erppf.BandwidthInGbps != nil {
		objectMap["bandwidthInGbps"] = erppf.BandwidthInGbps
	}
	if erppf.Encapsulation != "" {
		objectMap["encapsulation"] = erppf.Encapsulation
	}
	if erppf.Links != nil {
		objectMap["links"] = erppf.Links
	}
	if erppf.ResourceGUID != nil {
		objectMap["resourceGuid"] = erppf.ResourceGUID
	}
	return json.Marshal(objectMap)
}

// ExpressRoutePortsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRoutePortsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRoutePortsClient) (ExpressRoutePort, error)
}

// ExpressRoutePortsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExpressRoutePortsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRoutePortsClient) (autorest.Response, error)
}

// ExpressRoutePortsLocation definition of the ExpressRoutePorts peering location resource.
type ExpressRoutePortsLocation struct {
	autorest.Response `json:"-"`
	// ExpressRoutePortsLocationPropertiesFormat - ExpressRoutePort peering location properties.
	*ExpressRoutePortsLocationPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortsLocation.
func (erpl ExpressRoutePortsLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erpl.ExpressRoutePortsLocationPropertiesFormat != nil {
		objectMap["properties"] = erpl.ExpressRoutePortsLocationPropertiesFormat
	}
	if erpl.ID != nil {
		objectMap["id"] = erpl.ID
	}
	if erpl.Location != nil {
		objectMap["location"] = erpl.Location
	}
	if erpl.Tags != nil {
		objectMap["tags"] = erpl.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRoutePortsLocation struct.
func (erpl *ExpressRoutePortsLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRoutePortsLocationPropertiesFormat ExpressRoutePortsLocationPropertiesFormat
				err = json.Unmarshal(*v, &expressRoutePortsLocationPropertiesFormat)
				if err != nil {
					return err
				}
				erpl.ExpressRoutePortsLocationPropertiesFormat = &expressRoutePortsLocationPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erpl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erpl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erpl.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erpl.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erpl.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRoutePortsLocationBandwidths real-time inventory of available ExpressRoute port bandwidths.
type ExpressRoutePortsLocationBandwidths struct {
	// OfferName - READ-ONLY; Bandwidth descriptive name.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInGbps - READ-ONLY; Bandwidth value in Gbps.
	ValueInGbps *int32 `json:"valueInGbps,omitempty"`
}

// ExpressRoutePortsLocationListResult response for ListExpressRoutePortsLocations API service call.
type ExpressRoutePortsLocationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of all ExpressRoutePort peering locations.
	Value *[]ExpressRoutePortsLocation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRoutePortsLocationListResultIterator provides access to a complete listing of
// ExpressRoutePortsLocation values.
type ExpressRoutePortsLocationListResultIterator struct {
	i    int
	page ExpressRoutePortsLocationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRoutePortsLocationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortsLocationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRoutePortsLocationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRoutePortsLocationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRoutePortsLocationListResultIterator) Response() ExpressRoutePortsLocationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRoutePortsLocationListResultIterator) Value() ExpressRoutePortsLocation {
	if !iter.page.NotDone() {
		return ExpressRoutePortsLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRoutePortsLocationListResultIterator type.
func NewExpressRoutePortsLocationListResultIterator(page ExpressRoutePortsLocationListResultPage) ExpressRoutePortsLocationListResultIterator {
	return ExpressRoutePortsLocationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erpllr ExpressRoutePortsLocationListResult) IsEmpty() bool {
	return erpllr.Value == nil || len(*erpllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erpllr ExpressRoutePortsLocationListResult) hasNextLink() bool {
	return erpllr.NextLink != nil && len(*erpllr.NextLink) != 0
}

// expressRoutePortsLocationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erpllr ExpressRoutePortsLocationListResult) expressRoutePortsLocationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erpllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erpllr.NextLink)))
}

// ExpressRoutePortsLocationListResultPage contains a page of ExpressRoutePortsLocation values.
type ExpressRoutePortsLocationListResultPage struct {
	fn     func(context.Context, ExpressRoutePortsLocationListResult) (ExpressRoutePortsLocationListResult, error)
	erpllr ExpressRoutePortsLocationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRoutePortsLocationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortsLocationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erpllr)
		if err != nil {
			return err
		}
		page.erpllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRoutePortsLocationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRoutePortsLocationListResultPage) NotDone() bool {
	return !page.erpllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRoutePortsLocationListResultPage) Response() ExpressRoutePortsLocationListResult {
	return page.erpllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRoutePortsLocationListResultPage) Values() []ExpressRoutePortsLocation {
	if page.erpllr.IsEmpty() {
		return nil
	}
	return *page.erpllr.Value
}

// Creates a new instance of the ExpressRoutePortsLocationListResultPage type.
func NewExpressRoutePortsLocationListResultPage(cur ExpressRoutePortsLocationListResult, getNextPage func(context.Context, ExpressRoutePortsLocationListResult) (ExpressRoutePortsLocationListResult, error)) ExpressRoutePortsLocationListResultPage {
	return ExpressRoutePortsLocationListResultPage{
		fn:     getNextPage,
		erpllr: cur,
	}
}

// ExpressRoutePortsLocationPropertiesFormat properties specific to ExpressRoutePorts peering location
// resources.
type ExpressRoutePortsLocationPropertiesFormat struct {
	// Address - READ-ONLY; Address of peering location.
	Address *string `json:"address,omitempty"`
	// Contact - READ-ONLY; Contact details of peering locations.
	Contact *string `json:"contact,omitempty"`
	// AvailableBandwidths - The inventory of available ExpressRoutePort bandwidths.
	AvailableBandwidths *[]ExpressRoutePortsLocationBandwidths `json:"availableBandwidths,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route port location resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortsLocationPropertiesFormat.
func (erplpf ExpressRoutePortsLocationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erplpf.AvailableBandwidths != nil {
		objectMap["availableBandwidths"] = erplpf.AvailableBandwidths
	}
	return json.Marshal(objectMap)
}

// ExpressRoutePortsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRoutePortsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRoutePortsClient) (ExpressRoutePort, error)
}

// ExpressRouteServiceProvider a ExpressRouteResourceProvider object.
type ExpressRouteServiceProvider struct {
	// ExpressRouteServiceProviderPropertiesFormat - Properties of the express route service provider.
	*ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteServiceProvider.
func (ersp ExpressRouteServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ersp.ExpressRouteServiceProviderPropertiesFormat != nil {
		objectMap["properties"] = ersp.ExpressRouteServiceProviderPropertiesFormat
	}
	if ersp.ID != nil {
		objectMap["id"] = ersp.ID
	}
	if ersp.Location != nil {
		objectMap["location"] = ersp.Location
	}
	if ersp.Tags != nil {
		objectMap["tags"] = ersp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteServiceProvider struct.
func (ersp *ExpressRouteServiceProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteServiceProviderPropertiesFormat ExpressRouteServiceProviderPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteServiceProviderPropertiesFormat)
				if err != nil {
					return err
				}
				ersp.ExpressRouteServiceProviderPropertiesFormat = &expressRouteServiceProviderPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ersp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ersp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ersp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ersp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ersp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteServiceProviderBandwidthsOffered contains bandwidths offered in ExpressRouteServiceProvider
// resources.
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// OfferName - The OfferName.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - The ValueInMbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult response for the ListExpressRouteServiceProvider API service call.
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteResourceProvider resources.
	Value *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteServiceProviderListResultIterator provides access to a complete listing of
// ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultIterator struct {
	i    int
	page ExpressRouteServiceProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteServiceProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteServiceProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteServiceProviderListResultIterator) Response() ExpressRouteServiceProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteServiceProviderListResultIterator) Value() ExpressRouteServiceProvider {
	if !iter.page.NotDone() {
		return ExpressRouteServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteServiceProviderListResultIterator type.
func NewExpressRouteServiceProviderListResultIterator(page ExpressRouteServiceProviderListResultPage) ExpressRouteServiceProviderListResultIterator {
	return ExpressRouteServiceProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ersplr ExpressRouteServiceProviderListResult) IsEmpty() bool {
	return ersplr.Value == nil || len(*ersplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ersplr ExpressRouteServiceProviderListResult) hasNextLink() bool {
	return ersplr.NextLink != nil && len(*ersplr.NextLink) != 0
}

// expressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ersplr ExpressRouteServiceProviderListResult) expressRouteServiceProviderListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ersplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ersplr.NextLink)))
}

// ExpressRouteServiceProviderListResultPage contains a page of ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultPage struct {
	fn     func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)
	ersplr ExpressRouteServiceProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteServiceProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ersplr)
		if err != nil {
			return err
		}
		page.ersplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteServiceProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteServiceProviderListResultPage) NotDone() bool {
	return !page.ersplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteServiceProviderListResultPage) Response() ExpressRouteServiceProviderListResult {
	return page.ersplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteServiceProviderListResultPage) Values() []ExpressRouteServiceProvider {
	if page.ersplr.IsEmpty() {
		return nil
	}
	return *page.ersplr.Value
}

// Creates a new instance of the ExpressRouteServiceProviderListResultPage type.
func NewExpressRouteServiceProviderListResultPage(cur ExpressRouteServiceProviderListResult, getNextPage func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)) ExpressRouteServiceProviderListResultPage {
	return ExpressRouteServiceProviderListResultPage{
		fn:     getNextPage,
		ersplr: cur,
	}
}

// ExpressRouteServiceProviderPropertiesFormat properties of ExpressRouteServiceProvider.
type ExpressRouteServiceProviderPropertiesFormat struct {
	// PeeringLocations - A list of peering locations.
	PeeringLocations *[]string `json:"peeringLocations,omitempty"`
	// BandwidthsOffered - A list of bandwidths offered.
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	// ProvisioningState - The provisioning state of the express route service provider resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// FirewallPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FirewallPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPoliciesClient) (FirewallPolicy, error)
}

// FirewallPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FirewallPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPoliciesClient) (autorest.Response, error)
}

// FirewallPolicy firewallPolicy Resource.
type FirewallPolicy struct {
	autorest.Response `json:"-"`
	// FirewallPolicyPropertiesFormat - Properties of the firewall policy.
	*FirewallPolicyPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FirewallPolicy.
func (fp FirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.FirewallPolicyPropertiesFormat != nil {
		objectMap["properties"] = fp.FirewallPolicyPropertiesFormat
	}
	if fp.ID != nil {
		objectMap["id"] = fp.ID
	}
	if fp.Location != nil {
		objectMap["location"] = fp.Location
	}
	if fp.Tags != nil {
		objectMap["tags"] = fp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicy struct.
func (fp *FirewallPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallPolicyPropertiesFormat FirewallPolicyPropertiesFormat
				err = json.Unmarshal(*v, &firewallPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				fp.FirewallPolicyPropertiesFormat = &firewallPolicyPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fp.Tags = tags
			}
		}
	}

	return nil
}

// FirewallPolicyFilterRule firewall Policy Filter Rule.
type FirewallPolicyFilterRule struct {
	// Action - The action type of a Filter rule.
	Action *FirewallPolicyFilterRuleAction `json:"action,omitempty"`
	// RuleConditions - Collection of rule conditions used by a rule.
	RuleConditions *[]BasicFirewallPolicyRuleCondition `json:"ruleConditions,omitempty"`
	// Name - The name of the rule.
	Name *string `json:"name,omitempty"`
	// Priority - Priority of the Firewall Policy Rule resource.
	Priority *int32 `json:"priority,omitempty"`
	// RuleType - Possible values include: 'RuleTypeFirewallPolicyRule', 'RuleTypeFirewallPolicyNatRule', 'RuleTypeFirewallPolicyFilterRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyFilterRule.
func (fpfr FirewallPolicyFilterRule) MarshalJSON() ([]byte, error) {
	fpfr.RuleType = RuleTypeFirewallPolicyFilterRule
	objectMap := make(map[string]interface{})
	if fpfr.Action != nil {
		objectMap["action"] = fpfr.Action
	}
	if fpfr.RuleConditions != nil {
		objectMap["ruleConditions"] = fpfr.RuleConditions
	}
	if fpfr.Name != nil {
		objectMap["name"] = fpfr.Name
	}
	if fpfr.Priority != nil {
		objectMap["priority"] = fpfr.Priority
	}
	if fpfr.RuleType != "" {
		objectMap["ruleType"] = fpfr.RuleType
	}
	return json.Marshal(objectMap)
}

// AsFirewallPolicyNatRule is the BasicFirewallPolicyRule implementation for FirewallPolicyFilterRule.
func (fpfr FirewallPolicyFilterRule) AsFirewallPolicyNatRule() (*FirewallPolicyNatRule, bool) {
	return nil, false
}

// AsFirewallPolicyFilterRule is the BasicFirewallPolicyRule implementation for FirewallPolicyFilterRule.
func (fpfr FirewallPolicyFilterRule) AsFirewallPolicyFilterRule() (*FirewallPolicyFilterRule, bool) {
	return &fpfr, true
}

// AsFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyFilterRule.
func (fpfr FirewallPolicyFilterRule) AsFirewallPolicyRule() (*FirewallPolicyRule, bool) {
	return nil, false
}

// AsBasicFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyFilterRule.
func (fpfr FirewallPolicyFilterRule) AsBasicFirewallPolicyRule() (BasicFirewallPolicyRule, bool) {
	return &fpfr, true
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyFilterRule struct.
func (fpfr *FirewallPolicyFilterRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "action":
			if v != nil {
				var action FirewallPolicyFilterRuleAction
				err = json.Unmarshal(*v, &action)
				if err != nil {
					return err
				}
				fpfr.Action = &action
			}
		case "ruleConditions":
			if v != nil {
				ruleConditions, err := unmarshalBasicFirewallPolicyRuleConditionArray(*v)
				if err != nil {
					return err
				}
				fpfr.RuleConditions = &ruleConditions
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fpfr.Name = &name
			}
		case "priority":
			if v != nil {
				var priority int32
				err = json.Unmarshal(*v, &priority)
				if err != nil {
					return err
				}
				fpfr.Priority = &priority
			}
		case "ruleType":
			if v != nil {
				var ruleType RuleType
				err = json.Unmarshal(*v, &ruleType)
				if err != nil {
					return err
				}
				fpfr.RuleType = ruleType
			}
		}
	}

	return nil
}

// FirewallPolicyFilterRuleAction properties of the FirewallPolicyFilterRuleAction.
type FirewallPolicyFilterRuleAction struct {
	// Type - The type of action. Possible values include: 'FirewallPolicyFilterRuleActionTypeAllow', 'FirewallPolicyFilterRuleActionTypeDeny', 'FirewallPolicyFilterRuleActionTypeAlert'
	Type FirewallPolicyFilterRuleActionType `json:"type,omitempty"`
}

// FirewallPolicyListResult response for ListFirewallPolicies API service call.
type FirewallPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Firewall Policies in a resource group.
	Value *[]FirewallPolicy `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallPolicyListResultIterator provides access to a complete listing of FirewallPolicy values.
type FirewallPolicyListResultIterator struct {
	i    int
	page FirewallPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallPolicyListResultIterator) Response() FirewallPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallPolicyListResultIterator) Value() FirewallPolicy {
	if !iter.page.NotDone() {
		return FirewallPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallPolicyListResultIterator type.
func NewFirewallPolicyListResultIterator(page FirewallPolicyListResultPage) FirewallPolicyListResultIterator {
	return FirewallPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fplr FirewallPolicyListResult) IsEmpty() bool {
	return fplr.Value == nil || len(*fplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fplr FirewallPolicyListResult) hasNextLink() bool {
	return fplr.NextLink != nil && len(*fplr.NextLink) != 0
}

// firewallPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fplr FirewallPolicyListResult) firewallPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fplr.NextLink)))
}

// FirewallPolicyListResultPage contains a page of FirewallPolicy values.
type FirewallPolicyListResultPage struct {
	fn   func(context.Context, FirewallPolicyListResult) (FirewallPolicyListResult, error)
	fplr FirewallPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fplr)
		if err != nil {
			return err
		}
		page.fplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallPolicyListResultPage) NotDone() bool {
	return !page.fplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallPolicyListResultPage) Response() FirewallPolicyListResult {
	return page.fplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallPolicyListResultPage) Values() []FirewallPolicy {
	if page.fplr.IsEmpty() {
		return nil
	}
	return *page.fplr.Value
}

// Creates a new instance of the FirewallPolicyListResultPage type.
func NewFirewallPolicyListResultPage(cur FirewallPolicyListResult, getNextPage func(context.Context, FirewallPolicyListResult) (FirewallPolicyListResult, error)) FirewallPolicyListResultPage {
	return FirewallPolicyListResultPage{
		fn:   getNextPage,
		fplr: cur,
	}
}

// FirewallPolicyNatRule firewall Policy NAT Rule.
type FirewallPolicyNatRule struct {
	// Action - The action type of a Nat rule.
	Action *FirewallPolicyNatRuleAction `json:"action,omitempty"`
	// TranslatedAddress - The translated address for this NAT rule.
	TranslatedAddress *string `json:"translatedAddress,omitempty"`
	// TranslatedPort - The translated port for this NAT rule.
	TranslatedPort *string `json:"translatedPort,omitempty"`
	// RuleCondition - The match conditions for incoming traffic.
	RuleCondition BasicFirewallPolicyRuleCondition `json:"ruleCondition,omitempty"`
	// Name - The name of the rule.
	Name *string `json:"name,omitempty"`
	// Priority - Priority of the Firewall Policy Rule resource.
	Priority *int32 `json:"priority,omitempty"`
	// RuleType - Possible values include: 'RuleTypeFirewallPolicyRule', 'RuleTypeFirewallPolicyNatRule', 'RuleTypeFirewallPolicyFilterRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyNatRule.
func (fpnr FirewallPolicyNatRule) MarshalJSON() ([]byte, error) {
	fpnr.RuleType = RuleTypeFirewallPolicyNatRule
	objectMap := make(map[string]interface{})
	if fpnr.Action != nil {
		objectMap["action"] = fpnr.Action
	}
	if fpnr.TranslatedAddress != nil {
		objectMap["translatedAddress"] = fpnr.TranslatedAddress
	}
	if fpnr.TranslatedPort != nil {
		objectMap["translatedPort"] = fpnr.TranslatedPort
	}
	objectMap["ruleCondition"] = fpnr.RuleCondition
	if fpnr.Name != nil {
		objectMap["name"] = fpnr.Name
	}
	if fpnr.Priority != nil {
		objectMap["priority"] = fpnr.Priority
	}
	if fpnr.RuleType != "" {
		objectMap["ruleType"] = fpnr.RuleType
	}
	return json.Marshal(objectMap)
}

// AsFirewallPolicyNatRule is the BasicFirewallPolicyRule implementation for FirewallPolicyNatRule.
func (fpnr FirewallPolicyNatRule) AsFirewallPolicyNatRule() (*FirewallPolicyNatRule, bool) {
	return &fpnr, true
}

// AsFirewallPolicyFilterRule is the BasicFirewallPolicyRule implementation for FirewallPolicyNatRule.
func (fpnr FirewallPolicyNatRule) AsFirewallPolicyFilterRule() (*FirewallPolicyFilterRule, bool) {
	return nil, false
}

// AsFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyNatRule.
func (fpnr FirewallPolicyNatRule) AsFirewallPolicyRule() (*FirewallPolicyRule, bool) {
	return nil, false
}

// AsBasicFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyNatRule.
func (fpnr FirewallPolicyNatRule) AsBasicFirewallPolicyRule() (BasicFirewallPolicyRule, bool) {
	return &fpnr, true
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyNatRule struct.
func (fpnr *FirewallPolicyNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "action":
			if v != nil {
				var action FirewallPolicyNatRuleAction
				err = json.Unmarshal(*v, &action)
				if err != nil {
					return err
				}
				fpnr.Action = &action
			}
		case "translatedAddress":
			if v != nil {
				var translatedAddress string
				err = json.Unmarshal(*v, &translatedAddress)
				if err != nil {
					return err
				}
				fpnr.TranslatedAddress = &translatedAddress
			}
		case "translatedPort":
			if v != nil {
				var translatedPort string
				err = json.Unmarshal(*v, &translatedPort)
				if err != nil {
					return err
				}
				fpnr.TranslatedPort = &translatedPort
			}
		case "ruleCondition":
			if v != nil {
				ruleCondition, err := unmarshalBasicFirewallPolicyRuleCondition(*v)
				if err != nil {
					return err
				}
				fpnr.RuleCondition = ruleCondition
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fpnr.Name = &name
			}
		case "priority":
			if v != nil {
				var priority int32
				err = json.Unmarshal(*v, &priority)
				if err != nil {
					return err
				}
				fpnr.Priority = &priority
			}
		case "ruleType":
			if v != nil {
				var ruleType RuleType
				err = json.Unmarshal(*v, &ruleType)
				if err != nil {
					return err
				}
				fpnr.RuleType = ruleType
			}
		}
	}

	return nil
}

// FirewallPolicyNatRuleAction properties of the FirewallPolicyNatRuleAction.
type FirewallPolicyNatRuleAction struct {
	// Type - The type of action. Possible values include: 'DNAT', 'SNAT'
	Type FirewallPolicyNatRuleActionType `json:"type,omitempty"`
}

// FirewallPolicyPropertiesFormat firewall Policy definition.
type FirewallPolicyPropertiesFormat struct {
	// RuleGroups - READ-ONLY; List of references to FirewallPolicyRuleGroups.
	RuleGroups *[]SubResource `json:"ruleGroups,omitempty"`
	// ProvisioningState - The provisioning state of the firewall policy resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// BasePolicy - The parent firewall policy from which rules are inherited.
	BasePolicy *SubResource `json:"basePolicy,omitempty"`
	// Firewalls - READ-ONLY; List of references to Azure Firewalls that this Firewall Policy is associated with.
	Firewalls *[]SubResource `json:"firewalls,omitempty"`
	// ChildPolicies - READ-ONLY; List of references to Child Firewall Policies.
	ChildPolicies *[]SubResource `json:"childPolicies,omitempty"`
	// ThreatIntelMode - The operation mode for Threat Intelligence. Possible values include: 'AzureFirewallThreatIntelModeAlert', 'AzureFirewallThreatIntelModeDeny', 'AzureFirewallThreatIntelModeOff'
	ThreatIntelMode AzureFirewallThreatIntelMode `json:"threatIntelMode,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyPropertiesFormat.
func (fppf FirewallPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fppf.ProvisioningState != "" {
		objectMap["provisioningState"] = fppf.ProvisioningState
	}
	if fppf.BasePolicy != nil {
		objectMap["basePolicy"] = fppf.BasePolicy
	}
	if fppf.ThreatIntelMode != "" {
		objectMap["threatIntelMode"] = fppf.ThreatIntelMode
	}
	return json.Marshal(objectMap)
}

// BasicFirewallPolicyRule properties of the rule.
type BasicFirewallPolicyRule interface {
	AsFirewallPolicyNatRule() (*FirewallPolicyNatRule, bool)
	AsFirewallPolicyFilterRule() (*FirewallPolicyFilterRule, bool)
	AsFirewallPolicyRule() (*FirewallPolicyRule, bool)
}

// FirewallPolicyRule properties of the rule.
type FirewallPolicyRule struct {
	// Name - The name of the rule.
	Name *string `json:"name,omitempty"`
	// Priority - Priority of the Firewall Policy Rule resource.
	Priority *int32 `json:"priority,omitempty"`
	// RuleType - Possible values include: 'RuleTypeFirewallPolicyRule', 'RuleTypeFirewallPolicyNatRule', 'RuleTypeFirewallPolicyFilterRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

func unmarshalBasicFirewallPolicyRule(body []byte) (BasicFirewallPolicyRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeFirewallPolicyNatRule):
		var fpnr FirewallPolicyNatRule
		err := json.Unmarshal(body, &fpnr)
		return fpnr, err
	case string(RuleTypeFirewallPolicyFilterRule):
		var fpfr FirewallPolicyFilterRule
		err := json.Unmarshal(body, &fpfr)
		return fpfr, err
	default:
		var fpr FirewallPolicyRule
		err := json.Unmarshal(body, &fpr)
		return fpr, err
	}
}
func unmarshalBasicFirewallPolicyRuleArray(body []byte) ([]BasicFirewallPolicyRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fprArray := make([]BasicFirewallPolicyRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fpr, err := unmarshalBasicFirewallPolicyRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		fprArray[index] = fpr
	}
	return fprArray, nil
}

// MarshalJSON is the custom marshaler for FirewallPolicyRule.
func (fpr FirewallPolicyRule) MarshalJSON() ([]byte, error) {
	fpr.RuleType = RuleTypeFirewallPolicyRule
	objectMap := make(map[string]interface{})
	if fpr.Name != nil {
		objectMap["name"] = fpr.Name
	}
	if fpr.Priority != nil {
		objectMap["priority"] = fpr.Priority
	}
	if fpr.RuleType != "" {
		objectMap["ruleType"] = fpr.RuleType
	}
	return json.Marshal(objectMap)
}

// AsFirewallPolicyNatRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsFirewallPolicyNatRule() (*FirewallPolicyNatRule, bool) {
	return nil, false
}

// AsFirewallPolicyFilterRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsFirewallPolicyFilterRule() (*FirewallPolicyFilterRule, bool) {
	return nil, false
}

// AsFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsFirewallPolicyRule() (*FirewallPolicyRule, bool) {
	return &fpr, true
}

// AsBasicFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsBasicFirewallPolicyRule() (BasicFirewallPolicyRule, bool) {
	return &fpr, true
}

// BasicFirewallPolicyRuleCondition properties of a rule.
type BasicFirewallPolicyRuleCondition interface {
	AsApplicationRuleCondition() (*ApplicationRuleCondition, bool)
	AsRuleCondition() (*RuleCondition, bool)
	AsFirewallPolicyRuleCondition() (*FirewallPolicyRuleCondition, bool)
}

// FirewallPolicyRuleCondition properties of a rule.
type FirewallPolicyRuleCondition struct {
	// Name - Name of the rule condition.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule condition.
	Description *string `json:"description,omitempty"`
	// RuleConditionType - Possible values include: 'RuleConditionTypeFirewallPolicyRuleCondition', 'RuleConditionTypeApplicationRuleCondition', 'RuleConditionTypeNetworkRuleCondition'
	RuleConditionType RuleConditionType `json:"ruleConditionType,omitempty"`
}

func unmarshalBasicFirewallPolicyRuleCondition(body []byte) (BasicFirewallPolicyRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleConditionType"] {
	case string(RuleConditionTypeApplicationRuleCondition):
		var arc ApplicationRuleCondition
		err := json.Unmarshal(body, &arc)
		return arc, err
	case string(RuleConditionTypeNetworkRuleCondition):
		var rc RuleCondition
		err := json.Unmarshal(body, &rc)
		return rc, err
	default:
		var fprc FirewallPolicyRuleCondition
		err := json.Unmarshal(body, &fprc)
		return fprc, err
	}
}
func unmarshalBasicFirewallPolicyRuleConditionArray(body []byte) ([]BasicFirewallPolicyRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fprcArray := make([]BasicFirewallPolicyRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fprc, err := unmarshalBasicFirewallPolicyRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		fprcArray[index] = fprc
	}
	return fprcArray, nil
}

// MarshalJSON is the custom marshaler for FirewallPolicyRuleCondition.
func (fprc FirewallPolicyRuleCondition) MarshalJSON() ([]byte, error) {
	fprc.RuleConditionType = RuleConditionTypeFirewallPolicyRuleCondition
	objectMap := make(map[string]interface{})
	if fprc.Name != nil {
		objectMap["name"] = fprc.Name
	}
	if fprc.Description != nil {
		objectMap["description"] = fprc.Description
	}
	if fprc.RuleConditionType != "" {
		objectMap["ruleConditionType"] = fprc.RuleConditionType
	}
	return json.Marshal(objectMap)
}

// AsApplicationRuleCondition is the BasicFirewallPolicyRuleCondition implementation for FirewallPolicyRuleCondition.
func (fprc FirewallPolicyRuleCondition) AsApplicationRuleCondition() (*ApplicationRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicFirewallPolicyRuleCondition implementation for FirewallPolicyRuleCondition.
func (fprc FirewallPolicyRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsFirewallPolicyRuleCondition is the BasicFirewallPolicyRuleCondition implementation for FirewallPolicyRuleCondition.
func (fprc FirewallPolicyRuleCondition) AsFirewallPolicyRuleCondition() (*FirewallPolicyRuleCondition, bool) {
	return &fprc, true
}

// AsBasicFirewallPolicyRuleCondition is the BasicFirewallPolicyRuleCondition implementation for FirewallPolicyRuleCondition.
func (fprc FirewallPolicyRuleCondition) AsBasicFirewallPolicyRuleCondition() (BasicFirewallPolicyRuleCondition, bool) {
	return &fprc, true
}

// FirewallPolicyRuleConditionApplicationProtocol properties of the application rule protocol.
type FirewallPolicyRuleConditionApplicationProtocol struct {
	// ProtocolType - Protocol type. Possible values include: 'FirewallPolicyRuleConditionApplicationProtocolTypeHTTP', 'FirewallPolicyRuleConditionApplicationProtocolTypeHTTPS'
	ProtocolType FirewallPolicyRuleConditionApplicationProtocolType `json:"protocolType,omitempty"`
	// Port - Port number for the protocol, cannot be greater than 64000.
	Port *int32 `json:"port,omitempty"`
}

// FirewallPolicyRuleGroup rule Group resource.
type FirewallPolicyRuleGroup struct {
	autorest.Response `json:"-"`
	// FirewallPolicyRuleGroupProperties - The properties of the firewall policy rule group.
	*FirewallPolicyRuleGroupProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Rule Group type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyRuleGroup.
func (fprg FirewallPolicyRuleGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fprg.FirewallPolicyRuleGroupProperties != nil {
		objectMap["properties"] = fprg.FirewallPolicyRuleGroupProperties
	}
	if fprg.Name != nil {
		objectMap["name"] = fprg.Name
	}
	if fprg.ID != nil {
		objectMap["id"] = fprg.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyRuleGroup struct.
func (fprg *FirewallPolicyRuleGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallPolicyRuleGroupProperties FirewallPolicyRuleGroupProperties
				err = json.Unmarshal(*v, &firewallPolicyRuleGroupProperties)
				if err != nil {
					return err
				}
				fprg.FirewallPolicyRuleGroupProperties = &firewallPolicyRuleGroupProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fprg.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fprg.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fprg.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fprg.ID = &ID
			}
		}
	}

	return nil
}

// FirewallPolicyRuleGroupListResult response for ListFirewallPolicyRuleGroups API service call.
type FirewallPolicyRuleGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - List of FirewallPolicyRuleGroups in a FirewallPolicy.
	Value *[]FirewallPolicyRuleGroup `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallPolicyRuleGroupListResultIterator provides access to a complete listing of
// FirewallPolicyRuleGroup values.
type FirewallPolicyRuleGroupListResultIterator struct {
	i    int
	page FirewallPolicyRuleGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallPolicyRuleGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyRuleGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallPolicyRuleGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallPolicyRuleGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallPolicyRuleGroupListResultIterator) Response() FirewallPolicyRuleGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallPolicyRuleGroupListResultIterator) Value() FirewallPolicyRuleGroup {
	if !iter.page.NotDone() {
		return FirewallPolicyRuleGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallPolicyRuleGroupListResultIterator type.
func NewFirewallPolicyRuleGroupListResultIterator(page FirewallPolicyRuleGroupListResultPage) FirewallPolicyRuleGroupListResultIterator {
	return FirewallPolicyRuleGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fprglr FirewallPolicyRuleGroupListResult) IsEmpty() bool {
	return fprglr.Value == nil || len(*fprglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fprglr FirewallPolicyRuleGroupListResult) hasNextLink() bool {
	return fprglr.NextLink != nil && len(*fprglr.NextLink) != 0
}

// firewallPolicyRuleGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fprglr FirewallPolicyRuleGroupListResult) firewallPolicyRuleGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fprglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fprglr.NextLink)))
}

// FirewallPolicyRuleGroupListResultPage contains a page of FirewallPolicyRuleGroup values.
type FirewallPolicyRuleGroupListResultPage struct {
	fn     func(context.Context, FirewallPolicyRuleGroupListResult) (FirewallPolicyRuleGroupListResult, error)
	fprglr FirewallPolicyRuleGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallPolicyRuleGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyRuleGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fprglr)
		if err != nil {
			return err
		}
		page.fprglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallPolicyRuleGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallPolicyRuleGroupListResultPage) NotDone() bool {
	return !page.fprglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallPolicyRuleGroupListResultPage) Response() FirewallPolicyRuleGroupListResult {
	return page.fprglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallPolicyRuleGroupListResultPage) Values() []FirewallPolicyRuleGroup {
	if page.fprglr.IsEmpty() {
		return nil
	}
	return *page.fprglr.Value
}

// Creates a new instance of the FirewallPolicyRuleGroupListResultPage type.
func NewFirewallPolicyRuleGroupListResultPage(cur FirewallPolicyRuleGroupListResult, getNextPage func(context.Context, FirewallPolicyRuleGroupListResult) (FirewallPolicyRuleGroupListResult, error)) FirewallPolicyRuleGroupListResultPage {
	return FirewallPolicyRuleGroupListResultPage{
		fn:     getNextPage,
		fprglr: cur,
	}
}

// FirewallPolicyRuleGroupProperties properties of the rule group.
type FirewallPolicyRuleGroupProperties struct {
	// Priority - Priority of the Firewall Policy Rule Group resource.
	Priority *int32 `json:"priority,omitempty"`
	// Rules - Group of Firewall Policy rules.
	Rules *[]BasicFirewallPolicyRule `json:"rules,omitempty"`
	// ProvisioningState - The provisioning state of the firewall policy rule group resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyRuleGroupProperties struct.
func (fprgp *FirewallPolicyRuleGroupProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "priority":
			if v != nil {
				var priority int32
				err = json.Unmarshal(*v, &priority)
				if err != nil {
					return err
				}
				fprgp.Priority = &priority
			}
		case "rules":
			if v != nil {
				rules, err := unmarshalBasicFirewallPolicyRuleArray(*v)
				if err != nil {
					return err
				}
				fprgp.Rules = &rules
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				fprgp.ProvisioningState = provisioningState
			}
		}
	}

	return nil
}

// FirewallPolicyRuleGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type FirewallPolicyRuleGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPolicyRuleGroupsClient) (FirewallPolicyRuleGroup, error)
}

// FirewallPolicyRuleGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FirewallPolicyRuleGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPolicyRuleGroupsClient) (autorest.Response, error)
}

// FlowLogFormatParameters parameters that define the flow log format.
type FlowLogFormatParameters struct {
	// Type - The file type of flow log. Possible values include: 'JSON'
	Type FlowLogFormatType `json:"type,omitempty"`
	// Version - The version (revision) of the flow log.
	Version *int32 `json:"version,omitempty"`
}

// FlowLogInformation information on the configuration of flow log and traffic analytics (optional) .
type FlowLogInformation struct {
	autorest.Response `json:"-"`
	// TargetResourceID - The ID of the resource to configure for flow log and traffic analytics (optional) .
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// FlowLogProperties - Properties of the flow log.
	*FlowLogProperties `json:"properties,omitempty"`
	// FlowAnalyticsConfiguration - Parameters that define the configuration of traffic analytics.
	FlowAnalyticsConfiguration *TrafficAnalyticsProperties `json:"flowAnalyticsConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for FlowLogInformation.
func (fli FlowLogInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fli.TargetResourceID != nil {
		objectMap["targetResourceId"] = fli.TargetResourceID
	}
	if fli.FlowLogProperties != nil {
		objectMap["properties"] = fli.FlowLogProperties
	}
	if fli.FlowAnalyticsConfiguration != nil {
		objectMap["flowAnalyticsConfiguration"] = fli.FlowAnalyticsConfiguration
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FlowLogInformation struct.
func (fli *FlowLogInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetResourceId":
			if v != nil {
				var targetResourceID string
				err = json.Unmarshal(*v, &targetResourceID)
				if err != nil {
					return err
				}
				fli.TargetResourceID = &targetResourceID
			}
		case "properties":
			if v != nil {
				var flowLogProperties FlowLogProperties
				err = json.Unmarshal(*v, &flowLogProperties)
				if err != nil {
					return err
				}
				fli.FlowLogProperties = &flowLogProperties
			}
		case "flowAnalyticsConfiguration":
			if v != nil {
				var flowAnalyticsConfiguration TrafficAnalyticsProperties
				err = json.Unmarshal(*v, &flowAnalyticsConfiguration)
				if err != nil {
					return err
				}
				fli.FlowAnalyticsConfiguration = &flowAnalyticsConfiguration
			}
		}
	}

	return nil
}

// FlowLogProperties parameters that define the configuration of flow log.
type FlowLogProperties struct {
	// StorageID - ID of the storage account which is used to store the flow log.
	StorageID *string `json:"storageId,omitempty"`
	// Enabled - Flag to enable/disable flow logging.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - Parameters that define the retention policy for flow log.
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`
	// Format - Parameters that define the flow log format.
	Format *FlowLogFormatParameters `json:"format,omitempty"`
}

// FlowLogStatusParameters parameters that define a resource to query flow log and traffic analytics
// (optional) status.
type FlowLogStatusParameters struct {
	// TargetResourceID - The target resource where getting the flow log and traffic analytics (optional) status.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// FrontendIPConfiguration frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	autorest.Response `json:"-"`
	// FrontendIPConfigurationPropertiesFormat - Properties of the load balancer probe.
	*FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// Zones - A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfiguration.
func (fic FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fic.FrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = fic.FrontendIPConfigurationPropertiesFormat
	}
	if fic.Name != nil {
		objectMap["name"] = fic.Name
	}
	if fic.Etag != nil {
		objectMap["etag"] = fic.Etag
	}
	if fic.Zones != nil {
		objectMap["zones"] = fic.Zones
	}
	if fic.ID != nil {
		objectMap["id"] = fic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontendIPConfiguration struct.
func (fic *FrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendIPConfigurationPropertiesFormat FrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &frontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				fic.FrontendIPConfigurationPropertiesFormat = &frontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fic.Type = &typeVar
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				fic.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fic.ID = &ID
			}
		}
	}

	return nil
}

// FrontendIPConfigurationPropertiesFormat properties of Frontend IP Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	// InboundNatRules - READ-ONLY; An array of references to inbound rules that use this frontend IP.
	InboundNatRules *[]SubResource `json:"inboundNatRules,omitempty"`
	// InboundNatPools - READ-ONLY; An array of references to inbound pools that use this frontend IP.
	InboundNatPools *[]SubResource `json:"inboundNatPools,omitempty"`
	// OutboundRules - READ-ONLY; An array of references to outbound rules that use this frontend IP.
	OutboundRules *[]SubResource `json:"outboundRules,omitempty"`
	// LoadBalancingRules - READ-ONLY; An array of references to load balancing rules that use this frontend IP.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The Private IP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// PrivateIPAddressVersion - Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values include: 'IPv4', 'IPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the Public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// PublicIPPrefix - The reference of the Public IP Prefix resource.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
	// ProvisioningState - The provisioning state of the frontend IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfigurationPropertiesFormat.
func (ficpf FrontendIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ficpf.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = ficpf.PrivateIPAddress
	}
	if ficpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = ficpf.PrivateIPAllocationMethod
	}
	if ficpf.PrivateIPAddressVersion != "" {
		objectMap["privateIPAddressVersion"] = ficpf.PrivateIPAddressVersion
	}
	if ficpf.Subnet != nil {
		objectMap["subnet"] = ficpf.Subnet
	}
	if ficpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = ficpf.PublicIPAddress
	}
	if ficpf.PublicIPPrefix != nil {
		objectMap["publicIPPrefix"] = ficpf.PublicIPPrefix
	}
	if ficpf.ProvisioningState != "" {
		objectMap["provisioningState"] = ficpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// GatewayRoute gateway routing details.
type GatewayRoute struct {
	// LocalAddress - READ-ONLY; The gateway's local address.
	LocalAddress *string `json:"localAddress,omitempty"`
	// NetworkProperty - READ-ONLY; The route's network prefix.
	NetworkProperty *string `json:"network,omitempty"`
	// NextHop - READ-ONLY; The route's next hop.
	NextHop *string `json:"nextHop,omitempty"`
	// SourcePeer - READ-ONLY; The peer this route was learned from.
	SourcePeer *string `json:"sourcePeer,omitempty"`
	// Origin - READ-ONLY; The source this route was learned from.
	Origin *string `json:"origin,omitempty"`
	// AsPath - READ-ONLY; The route's AS path sequence.
	AsPath *string `json:"asPath,omitempty"`
	// Weight - READ-ONLY; The route's weight.
	Weight *int32 `json:"weight,omitempty"`
}

// GatewayRouteListResult list of virtual network gateway routes.
type GatewayRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - List of gateway routes.
	Value *[]GatewayRoute `json:"value,omitempty"`
}

// GetVpnSitesConfigurationRequest list of Vpn-Sites.
type GetVpnSitesConfigurationRequest struct {
	// VpnSites - List of resource-ids of the vpn-sites for which config is to be downloaded.
	VpnSites *[]string `json:"vpnSites,omitempty"`
	// OutputBlobSasURL - The sas-url to download the configurations for vpn-sites.
	OutputBlobSasURL *string `json:"outputBlobSasUrl,omitempty"`
}

// HTTPConfiguration HTTP configuration of the connectivity check.
type HTTPConfiguration struct {
	// Method - HTTP method. Possible values include: 'Get'
	Method HTTPMethod `json:"method,omitempty"`
	// Headers - List of HTTP headers.
	Headers *[]HTTPHeader `json:"headers,omitempty"`
	// ValidStatusCodes - Valid status codes.
	ValidStatusCodes *[]int32 `json:"validStatusCodes,omitempty"`
}

// HTTPHeader describes the HTTP header.
type HTTPHeader struct {
	// Name - The name in HTTP header.
	Name *string `json:"name,omitempty"`
	// Value - The value in HTTP header.
	Value *string `json:"value,omitempty"`
}

// HubIPAddresses IP addresses associated with azure firewall.
type HubIPAddresses struct {
	// PublicIPAddresses - List of Public IP addresses associated with azure firewall.
	PublicIPAddresses *[]AzureFirewallPublicIPAddress `json:"publicIPAddresses,omitempty"`
	// PrivateIPAddress - Private IP Address associated with azure firewall.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
}

// HubVirtualNetworkConnection hubVirtualNetworkConnection Resource.
type HubVirtualNetworkConnection struct {
	autorest.Response `json:"-"`
	// HubVirtualNetworkConnectionProperties - Properties of the hub virtual network connection.
	*HubVirtualNetworkConnectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for HubVirtualNetworkConnection.
func (hvnc HubVirtualNetworkConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvnc.HubVirtualNetworkConnectionProperties != nil {
		objectMap["properties"] = hvnc.HubVirtualNetworkConnectionProperties
	}
	if hvnc.Name != nil {
		objectMap["name"] = hvnc.Name
	}
	if hvnc.ID != nil {
		objectMap["id"] = hvnc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HubVirtualNetworkConnection struct.
func (hvnc *HubVirtualNetworkConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hubVirtualNetworkConnectionProperties HubVirtualNetworkConnectionProperties
				err = json.Unmarshal(*v, &hubVirtualNetworkConnectionProperties)
				if err != nil {
					return err
				}
				hvnc.HubVirtualNetworkConnectionProperties = &hubVirtualNetworkConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hvnc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				hvnc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hvnc.ID = &ID
			}
		}
	}

	return nil
}

// HubVirtualNetworkConnectionProperties parameters for HubVirtualNetworkConnection.
type HubVirtualNetworkConnectionProperties struct {
	// RemoteVirtualNetwork - Reference to the remote virtual network.
	RemoteVirtualNetwork *SubResource `json:"remoteVirtualNetwork,omitempty"`
	// AllowHubToRemoteVnetTransit - VirtualHub to RemoteVnet transit to enabled or not.
	AllowHubToRemoteVnetTransit *bool `json:"allowHubToRemoteVnetTransit,omitempty"`
	// AllowRemoteVnetToUseHubVnetGateways - Allow RemoteVnet to use Virtual Hub's gateways.
	AllowRemoteVnetToUseHubVnetGateways *bool `json:"allowRemoteVnetToUseHubVnetGateways,omitempty"`
	// EnableInternetSecurity - Enable internet security.
	EnableInternetSecurity *bool `json:"enableInternetSecurity,omitempty"`
	// ProvisioningState - The provisioning state of the hub virtual network connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// InboundNatPool inbound NAT pool of the load balancer.
type InboundNatPool struct {
	// InboundNatPoolPropertiesFormat - Properties of load balancer inbound nat pool.
	*InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatPool.
func (inp InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inp.InboundNatPoolPropertiesFormat != nil {
		objectMap["properties"] = inp.InboundNatPoolPropertiesFormat
	}
	if inp.Name != nil {
		objectMap["name"] = inp.Name
	}
	if inp.Etag != nil {
		objectMap["etag"] = inp.Etag
	}
	if inp.ID != nil {
		objectMap["id"] = inp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatPool struct.
func (inp *InboundNatPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatPoolPropertiesFormat InboundNatPoolPropertiesFormat
				err = json.Unmarshal(*v, &inboundNatPoolPropertiesFormat)
				if err != nil {
					return err
				}
				inp.InboundNatPoolPropertiesFormat = &inboundNatPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				inp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inp.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatPoolPropertiesFormat properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// Protocol - The reference to the transport protocol used by the inbound NAT pool. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP', 'TransportProtocolAll'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPortRangeStart - The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// BackendPort - The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// EnableTCPReset - Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`
	// ProvisioningState - The provisioning state of the inbound NAT pool resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// InboundNatRule inbound NAT rule of the load balancer.
type InboundNatRule struct {
	autorest.Response `json:"-"`
	// InboundNatRulePropertiesFormat - Properties of load balancer inbound nat rule.
	*InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRule.
func (inr InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inr.InboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = inr.InboundNatRulePropertiesFormat
	}
	if inr.Name != nil {
		objectMap["name"] = inr.Name
	}
	if inr.Etag != nil {
		objectMap["etag"] = inr.Etag
	}
	if inr.ID != nil {
		objectMap["id"] = inr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatRule struct.
func (inr *InboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatRulePropertiesFormat InboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &inboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				inr.InboundNatRulePropertiesFormat = &inboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				inr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inr.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatRuleListResult response for ListInboundNatRule API service call.
type InboundNatRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of inbound nat rules in a load balancer.
	Value *[]InboundNatRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRuleListResult.
func (inrlr InboundNatRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inrlr.Value != nil {
		objectMap["value"] = inrlr.Value
	}
	return json.Marshal(objectMap)
}

// InboundNatRuleListResultIterator provides access to a complete listing of InboundNatRule values.
type InboundNatRuleListResultIterator struct {
	i    int
	page InboundNatRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InboundNatRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InboundNatRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InboundNatRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InboundNatRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InboundNatRuleListResultIterator) Response() InboundNatRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InboundNatRuleListResultIterator) Value() InboundNatRule {
	if !iter.page.NotDone() {
		return InboundNatRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InboundNatRuleListResultIterator type.
func NewInboundNatRuleListResultIterator(page InboundNatRuleListResultPage) InboundNatRuleListResultIterator {
	return InboundNatRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (inrlr InboundNatRuleListResult) IsEmpty() bool {
	return inrlr.Value == nil || len(*inrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (inrlr InboundNatRuleListResult) hasNextLink() bool {
	return inrlr.NextLink != nil && len(*inrlr.NextLink) != 0
}

// inboundNatRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (inrlr InboundNatRuleListResult) inboundNatRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !inrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(inrlr.NextLink)))
}

// InboundNatRuleListResultPage contains a page of InboundNatRule values.
type InboundNatRuleListResultPage struct {
	fn    func(context.Context, InboundNatRuleListResult) (InboundNatRuleListResult, error)
	inrlr InboundNatRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InboundNatRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InboundNatRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.inrlr)
		if err != nil {
			return err
		}
		page.inrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InboundNatRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InboundNatRuleListResultPage) NotDone() bool {
	return !page.inrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InboundNatRuleListResultPage) Response() InboundNatRuleListResult {
	return page.inrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InboundNatRuleListResultPage) Values() []InboundNatRule {
	if page.inrlr.IsEmpty() {
		return nil
	}
	return *page.inrlr.Value
}

// Creates a new instance of the InboundNatRuleListResultPage type.
func NewInboundNatRuleListResultPage(cur InboundNatRuleListResult, getNextPage func(context.Context, InboundNatRuleListResult) (InboundNatRuleListResult, error)) InboundNatRuleListResultPage {
	return InboundNatRuleListResultPage{
		fn:    getNextPage,
		inrlr: cur,
	}
}

// InboundNatRulePropertiesFormat properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendIPConfiguration - READ-ONLY; A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
	BackendIPConfiguration *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty"`
	// Protocol - The reference to the transport protocol used by the load balancing rule. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP', 'TransportProtocolAll'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPort - The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port used for the internal endpoint. Acceptable values range from 1 to 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// EnableTCPReset - Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`
	// ProvisioningState - The provisioning state of the inbound NAT rule resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRulePropertiesFormat.
func (inrpf InboundNatRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inrpf.FrontendIPConfiguration != nil {
		objectMap["frontendIPConfiguration"] = inrpf.FrontendIPConfiguration
	}
	if inrpf.Protocol != "" {
		objectMap["protocol"] = inrpf.Protocol
	}
	if inrpf.FrontendPort != nil {
		objectMap["frontendPort"] = inrpf.FrontendPort
	}
	if inrpf.BackendPort != nil {
		objectMap["backendPort"] = inrpf.BackendPort
	}
	if inrpf.IdleTimeoutInMinutes != nil {
		objectMap["idleTimeoutInMinutes"] = inrpf.IdleTimeoutInMinutes
	}
	if inrpf.EnableFloatingIP != nil {
		objectMap["enableFloatingIP"] = inrpf.EnableFloatingIP
	}
	if inrpf.EnableTCPReset != nil {
		objectMap["enableTcpReset"] = inrpf.EnableTCPReset
	}
	if inrpf.ProvisioningState != "" {
		objectMap["provisioningState"] = inrpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// InboundNatRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InboundNatRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InboundNatRulesClient) (InboundNatRule, error)
}

// InboundNatRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InboundNatRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InboundNatRulesClient) (autorest.Response, error)
}

// IntentPolicy network Intent Policy resource.
type IntentPolicy struct {
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntentPolicy.
func (IP IntentPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Etag != nil {
		objectMap["etag"] = IP.Etag
	}
	if IP.ID != nil {
		objectMap["id"] = IP.ID
	}
	if IP.Location != nil {
		objectMap["location"] = IP.Location
	}
	if IP.Tags != nil {
		objectMap["tags"] = IP.Tags
	}
	return json.Marshal(objectMap)
}

// IntentPolicyConfiguration details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest.
type IntentPolicyConfiguration struct {
	// NetworkIntentPolicyName - The name of the Network Intent Policy for storing in target subscription.
	NetworkIntentPolicyName *string `json:"networkIntentPolicyName,omitempty"`
	// SourceNetworkIntentPolicy - Source network intent policy.
	SourceNetworkIntentPolicy *IntentPolicy `json:"sourceNetworkIntentPolicy,omitempty"`
}

// Interface a network interface in a resource group.
type Interface struct {
	autorest.Response `json:"-"`
	// InterfacePropertiesFormat - Properties of the network interface.
	*InterfacePropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InterfacePropertiesFormat != nil {
		objectMap["properties"] = i.InterfacePropertiesFormat
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Interface struct.
func (i *Interface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfacePropertiesFormat InterfacePropertiesFormat
				err = json.Unmarshal(*v, &interfacePropertiesFormat)
				if err != nil {
					return err
				}
				i.InterfacePropertiesFormat = &interfacePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		}
	}

	return nil
}

// InterfaceAssociation network interface and its custom security rules.
type InterfaceAssociation struct {
	// ID - READ-ONLY; Network interface ID.
	ID *string `json:"id,omitempty"`
	// SecurityRules - Collection of custom security rules.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceAssociation.
func (ia InterfaceAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ia.SecurityRules != nil {
		objectMap["securityRules"] = ia.SecurityRules
	}
	return json.Marshal(objectMap)
}

// InterfaceDNSSettings DNS settings of a network interface.
type InterfaceDNSSettings struct {
	// DNSServers - List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// AppliedDNSServers - If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
	AppliedDNSServers *[]string `json:"appliedDnsServers,omitempty"`
	// InternalDNSNameLabel - Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`
	// InternalFqdn - Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
	InternalFqdn *string `json:"internalFqdn,omitempty"`
	// InternalDomainNameSuffix - Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
	InternalDomainNameSuffix *string `json:"internalDomainNameSuffix,omitempty"`
}

// InterfaceIPConfiguration iPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	autorest.Response `json:"-"`
	// InterfaceIPConfigurationPropertiesFormat - Network interface IP configuration properties.
	*InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfiguration.
func (iic InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iic.InterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = iic.InterfaceIPConfigurationPropertiesFormat
	}
	if iic.Name != nil {
		objectMap["name"] = iic.Name
	}
	if iic.Etag != nil {
		objectMap["etag"] = iic.Etag
	}
	if iic.ID != nil {
		objectMap["id"] = iic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InterfaceIPConfiguration struct.
func (iic *InterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceIPConfigurationPropertiesFormat InterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				iic.InterfaceIPConfigurationPropertiesFormat = &interfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				iic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iic.ID = &ID
			}
		}
	}

	return nil
}

// InterfaceIPConfigurationListResult response for list ip configurations API service call.
type InterfaceIPConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ip configurations.
	Value *[]InterfaceIPConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfigurationListResult.
func (iiclr InterfaceIPConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iiclr.Value != nil {
		objectMap["value"] = iiclr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceIPConfigurationListResultIterator provides access to a complete listing of
// InterfaceIPConfiguration values.
type InterfaceIPConfigurationListResultIterator struct {
	i    int
	page InterfaceIPConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceIPConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceIPConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceIPConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceIPConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceIPConfigurationListResultIterator) Response() InterfaceIPConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceIPConfigurationListResultIterator) Value() InterfaceIPConfiguration {
	if !iter.page.NotDone() {
		return InterfaceIPConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceIPConfigurationListResultIterator type.
func NewInterfaceIPConfigurationListResultIterator(page InterfaceIPConfigurationListResultPage) InterfaceIPConfigurationListResultIterator {
	return InterfaceIPConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iiclr InterfaceIPConfigurationListResult) IsEmpty() bool {
	return iiclr.Value == nil || len(*iiclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iiclr InterfaceIPConfigurationListResult) hasNextLink() bool {
	return iiclr.NextLink != nil && len(*iiclr.NextLink) != 0
}

// interfaceIPConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iiclr InterfaceIPConfigurationListResult) interfaceIPConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iiclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iiclr.NextLink)))
}

// InterfaceIPConfigurationListResultPage contains a page of InterfaceIPConfiguration values.
type InterfaceIPConfigurationListResultPage struct {
	fn    func(context.Context, InterfaceIPConfigurationListResult) (InterfaceIPConfigurationListResult, error)
	iiclr InterfaceIPConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceIPConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceIPConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iiclr)
		if err != nil {
			return err
		}
		page.iiclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceIPConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceIPConfigurationListResultPage) NotDone() bool {
	return !page.iiclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceIPConfigurationListResultPage) Response() InterfaceIPConfigurationListResult {
	return page.iiclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceIPConfigurationListResultPage) Values() []InterfaceIPConfiguration {
	if page.iiclr.IsEmpty() {
		return nil
	}
	return *page.iiclr.Value
}

// Creates a new instance of the InterfaceIPConfigurationListResultPage type.
func NewInterfaceIPConfigurationListResultPage(cur InterfaceIPConfigurationListResult, getNextPage func(context.Context, InterfaceIPConfigurationListResult) (InterfaceIPConfigurationListResult, error)) InterfaceIPConfigurationListResultPage {
	return InterfaceIPConfigurationListResultPage{
		fn:    getNextPage,
		iiclr: cur,
	}
}

// InterfaceIPConfigurationPrivateLinkConnectionProperties privateLinkConnection properties for the network
// interface.
type InterfaceIPConfigurationPrivateLinkConnectionProperties struct {
	// GroupID - READ-ONLY; The group ID for current private link connection.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMemberName - READ-ONLY; The required member name for current private link connection.
	RequiredMemberName *string `json:"requiredMemberName,omitempty"`
	// Fqdns - READ-ONLY; List of FQDNs for current private link connection.
	Fqdns *[]string `json:"fqdns,omitempty"`
}

// InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	// VirtualNetworkTaps - The reference to Virtual Network Taps.
	VirtualNetworkTaps *[]VirtualNetworkTap `json:"virtualNetworkTaps,omitempty"`
	// ApplicationGatewayBackendAddressPools - The reference of ApplicationGatewayBackendAddressPool resource.
	ApplicationGatewayBackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`
	// LoadBalancerBackendAddressPools - The reference of LoadBalancerBackendAddressPool resource.
	LoadBalancerBackendAddressPools *[]BackendAddressPool `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatRules - A list of references of LoadBalancerInboundNatRules.
	LoadBalancerInboundNatRules *[]InboundNatRule `json:"loadBalancerInboundNatRules,omitempty"`
	// PrivateIPAddress - Private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// PrivateIPAddressVersion - Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. Possible values include: 'IPv4', 'IPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	// Subnet - Subnet bound to the IP configuration.
	Subnet *Subnet `json:"subnet,omitempty"`
	// Primary - Whether this is a primary customer address on the network interface.
	Primary *bool `json:"primary,omitempty"`
	// PublicIPAddress - Public IP address bound to the IP configuration.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ApplicationSecurityGroups - Application security groups in which the IP configuration is included.
	ApplicationSecurityGroups *[]ApplicationSecurityGroup `json:"applicationSecurityGroups,omitempty"`
	// ProvisioningState - The provisioning state of the network interface IP configuration. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateLinkConnectionProperties - READ-ONLY; PrivateLinkConnection properties for the network interface.
	PrivateLinkConnectionProperties *InterfaceIPConfigurationPrivateLinkConnectionProperties `json:"privateLinkConnectionProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfigurationPropertiesFormat.
func (iicpf InterfaceIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iicpf.VirtualNetworkTaps != nil {
		objectMap["virtualNetworkTaps"] = iicpf.VirtualNetworkTaps
	}
	if iicpf.ApplicationGatewayBackendAddressPools != nil {
		objectMap["applicationGatewayBackendAddressPools"] = iicpf.ApplicationGatewayBackendAddressPools
	}
	if iicpf.LoadBalancerBackendAddressPools != nil {
		objectMap["loadBalancerBackendAddressPools"] = iicpf.LoadBalancerBackendAddressPools
	}
	if iicpf.LoadBalancerInboundNatRules != nil {
		objectMap["loadBalancerInboundNatRules"] = iicpf.LoadBalancerInboundNatRules
	}
	if iicpf.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = iicpf.PrivateIPAddress
	}
	if iicpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = iicpf.PrivateIPAllocationMethod
	}
	if iicpf.PrivateIPAddressVersion != "" {
		objectMap["privateIPAddressVersion"] = iicpf.PrivateIPAddressVersion
	}
	if iicpf.Subnet != nil {
		objectMap["subnet"] = iicpf.Subnet
	}
	if iicpf.Primary != nil {
		objectMap["primary"] = iicpf.Primary
	}
	if iicpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = iicpf.PublicIPAddress
	}
	if iicpf.ApplicationSecurityGroups != nil {
		objectMap["applicationSecurityGroups"] = iicpf.ApplicationSecurityGroups
	}
	if iicpf.ProvisioningState != "" {
		objectMap["provisioningState"] = iicpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// InterfaceListResult response for the ListNetworkInterface API service call.
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of network interfaces in a resource group.
	Value *[]Interface `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceListResult.
func (ilr InterfaceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ilr.Value != nil {
		objectMap["value"] = ilr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceListResultIterator provides access to a complete listing of Interface values.
type InterfaceListResultIterator struct {
	i    int
	page InterfaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceListResultIterator) Response() InterfaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceListResultIterator) Value() Interface {
	if !iter.page.NotDone() {
		return Interface{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceListResultIterator type.
func NewInterfaceListResultIterator(page InterfaceListResultPage) InterfaceListResultIterator {
	return InterfaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InterfaceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr InterfaceListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// interfaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InterfaceListResult) interfaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InterfaceListResultPage contains a page of Interface values.
type InterfaceListResultPage struct {
	fn  func(context.Context, InterfaceListResult) (InterfaceListResult, error)
	ilr InterfaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceListResultPage) Response() InterfaceListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceListResultPage) Values() []Interface {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InterfaceListResultPage type.
func NewInterfaceListResultPage(cur InterfaceListResult, getNextPage func(context.Context, InterfaceListResult) (InterfaceListResult, error)) InterfaceListResultPage {
	return InterfaceListResultPage{
		fn:  getNextPage,
		ilr: cur,
	}
}

// InterfaceLoadBalancerListResult response for list ip configurations API service call.
type InterfaceLoadBalancerListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of load balancers.
	Value *[]LoadBalancer `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceLoadBalancerListResult.
func (ilblr InterfaceLoadBalancerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ilblr.Value != nil {
		objectMap["value"] = ilblr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceLoadBalancerListResultIterator provides access to a complete listing of LoadBalancer values.
type InterfaceLoadBalancerListResultIterator struct {
	i    int
	page InterfaceLoadBalancerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceLoadBalancerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceLoadBalancerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceLoadBalancerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceLoadBalancerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceLoadBalancerListResultIterator) Response() InterfaceLoadBalancerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceLoadBalancerListResultIterator) Value() LoadBalancer {
	if !iter.page.NotDone() {
		return LoadBalancer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceLoadBalancerListResultIterator type.
func NewInterfaceLoadBalancerListResultIterator(page InterfaceLoadBalancerListResultPage) InterfaceLoadBalancerListResultIterator {
	return InterfaceLoadBalancerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilblr InterfaceLoadBalancerListResult) IsEmpty() bool {
	return ilblr.Value == nil || len(*ilblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilblr InterfaceLoadBalancerListResult) hasNextLink() bool {
	return ilblr.NextLink != nil && len(*ilblr.NextLink) != 0
}

// interfaceLoadBalancerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilblr InterfaceLoadBalancerListResult) interfaceLoadBalancerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilblr.NextLink)))
}

// InterfaceLoadBalancerListResultPage contains a page of LoadBalancer values.
type InterfaceLoadBalancerListResultPage struct {
	fn    func(context.Context, InterfaceLoadBalancerListResult) (InterfaceLoadBalancerListResult, error)
	ilblr InterfaceLoadBalancerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceLoadBalancerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceLoadBalancerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilblr)
		if err != nil {
			return err
		}
		page.ilblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceLoadBalancerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceLoadBalancerListResultPage) NotDone() bool {
	return !page.ilblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceLoadBalancerListResultPage) Response() InterfaceLoadBalancerListResult {
	return page.ilblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceLoadBalancerListResultPage) Values() []LoadBalancer {
	if page.ilblr.IsEmpty() {
		return nil
	}
	return *page.ilblr.Value
}

// Creates a new instance of the InterfaceLoadBalancerListResultPage type.
func NewInterfaceLoadBalancerListResultPage(cur InterfaceLoadBalancerListResult, getNextPage func(context.Context, InterfaceLoadBalancerListResult) (InterfaceLoadBalancerListResult, error)) InterfaceLoadBalancerListResultPage {
	return InterfaceLoadBalancerListResultPage{
		fn:    getNextPage,
		ilblr: cur,
	}
}

// InterfacePropertiesFormat networkInterface properties.
type InterfacePropertiesFormat struct {
	// VirtualMachine - READ-ONLY; The reference of a virtual machine.
	VirtualMachine *SubResource `json:"virtualMachine,omitempty"`
	// NetworkSecurityGroup - The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// PrivateEndpoint - READ-ONLY; A reference to the private endpoint to which the network interface is linked.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// IPConfigurations - A list of IPConfigurations of the network interface.
	IPConfigurations *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// TapConfigurations - A list of TapConfigurations of the network interface.
	TapConfigurations *[]InterfaceTapConfiguration `json:"tapConfigurations,omitempty"`
	// DNSSettings - The DNS settings in network interface.
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`
	// MacAddress - The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`
	// Primary - Whether this is a primary network interface on a virtual machine.
	Primary *bool `json:"primary,omitempty"`
	// EnableAcceleratedNetworking - If the network interface is accelerated networking enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`
	// EnableIPForwarding - Indicates whether IP forwarding is enabled on this network interface.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// HostedWorkloads - READ-ONLY; A list of references to linked BareMetal resources.
	HostedWorkloads *[]string `json:"hostedWorkloads,omitempty"`
	// ResourceGUID - The resource GUID property of the network interface resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the network interface resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfacePropertiesFormat.
func (ipf InterfacePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipf.NetworkSecurityGroup != nil {
		objectMap["networkSecurityGroup"] = ipf.NetworkSecurityGroup
	}
	if ipf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = ipf.IPConfigurations
	}
	if ipf.TapConfigurations != nil {
		objectMap["tapConfigurations"] = ipf.TapConfigurations
	}
	if ipf.DNSSettings != nil {
		objectMap["dnsSettings"] = ipf.DNSSettings
	}
	if ipf.MacAddress != nil {
		objectMap["macAddress"] = ipf.MacAddress
	}
	if ipf.Primary != nil {
		objectMap["primary"] = ipf.Primary
	}
	if ipf.EnableAcceleratedNetworking != nil {
		objectMap["enableAcceleratedNetworking"] = ipf.EnableAcceleratedNetworking
	}
	if ipf.EnableIPForwarding != nil {
		objectMap["enableIPForwarding"] = ipf.EnableIPForwarding
	}
	if ipf.ResourceGUID != nil {
		objectMap["resourceGuid"] = ipf.ResourceGUID
	}
	if ipf.ProvisioningState != "" {
		objectMap["provisioningState"] = ipf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// InterfacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (Interface, error)
}

// InterfacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InterfacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (autorest.Response, error)
}

// InterfacesGetEffectiveRouteTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesGetEffectiveRouteTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (EffectiveRouteListResult, error)
}

// InterfacesListEffectiveNetworkSecurityGroupsFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type InterfacesListEffectiveNetworkSecurityGroupsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (EffectiveNetworkSecurityGroupListResult, error)
}

// InterfacesUpdateTagsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InterfacesUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (Interface, error)
}

// InterfaceTapConfiguration tap configuration in a Network Interface.
type InterfaceTapConfiguration struct {
	autorest.Response `json:"-"`
	// InterfaceTapConfigurationPropertiesFormat - Properties of the Virtual Network Tap configuration.
	*InterfaceTapConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceTapConfiguration.
func (itc InterfaceTapConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itc.InterfaceTapConfigurationPropertiesFormat != nil {
		objectMap["properties"] = itc.InterfaceTapConfigurationPropertiesFormat
	}
	if itc.Name != nil {
		objectMap["name"] = itc.Name
	}
	if itc.Etag != nil {
		objectMap["etag"] = itc.Etag
	}
	if itc.ID != nil {
		objectMap["id"] = itc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InterfaceTapConfiguration struct.
func (itc *InterfaceTapConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceTapConfigurationPropertiesFormat InterfaceTapConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceTapConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				itc.InterfaceTapConfigurationPropertiesFormat = &interfaceTapConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				itc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itc.ID = &ID
			}
		}
	}

	return nil
}

// InterfaceTapConfigurationListResult response for list tap configurations API service call.
type InterfaceTapConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of tap configurations.
	Value *[]InterfaceTapConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceTapConfigurationListResult.
func (itclr InterfaceTapConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itclr.Value != nil {
		objectMap["value"] = itclr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceTapConfigurationListResultIterator provides access to a complete listing of
// InterfaceTapConfiguration values.
type InterfaceTapConfigurationListResultIterator struct {
	i    int
	page InterfaceTapConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceTapConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceTapConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceTapConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceTapConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceTapConfigurationListResultIterator) Response() InterfaceTapConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceTapConfigurationListResultIterator) Value() InterfaceTapConfiguration {
	if !iter.page.NotDone() {
		return InterfaceTapConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceTapConfigurationListResultIterator type.
func NewInterfaceTapConfigurationListResultIterator(page InterfaceTapConfigurationListResultPage) InterfaceTapConfigurationListResultIterator {
	return InterfaceTapConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itclr InterfaceTapConfigurationListResult) IsEmpty() bool {
	return itclr.Value == nil || len(*itclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itclr InterfaceTapConfigurationListResult) hasNextLink() bool {
	return itclr.NextLink != nil && len(*itclr.NextLink) != 0
}

// interfaceTapConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itclr InterfaceTapConfigurationListResult) interfaceTapConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !itclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itclr.NextLink)))
}

// InterfaceTapConfigurationListResultPage contains a page of InterfaceTapConfiguration values.
type InterfaceTapConfigurationListResultPage struct {
	fn    func(context.Context, InterfaceTapConfigurationListResult) (InterfaceTapConfigurationListResult, error)
	itclr InterfaceTapConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceTapConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceTapConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itclr)
		if err != nil {
			return err
		}
		page.itclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceTapConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceTapConfigurationListResultPage) NotDone() bool {
	return !page.itclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceTapConfigurationListResultPage) Response() InterfaceTapConfigurationListResult {
	return page.itclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceTapConfigurationListResultPage) Values() []InterfaceTapConfiguration {
	if page.itclr.IsEmpty() {
		return nil
	}
	return *page.itclr.Value
}

// Creates a new instance of the InterfaceTapConfigurationListResultPage type.
func NewInterfaceTapConfigurationListResultPage(cur InterfaceTapConfigurationListResult, getNextPage func(context.Context, InterfaceTapConfigurationListResult) (InterfaceTapConfigurationListResult, error)) InterfaceTapConfigurationListResultPage {
	return InterfaceTapConfigurationListResultPage{
		fn:    getNextPage,
		itclr: cur,
	}
}

// InterfaceTapConfigurationPropertiesFormat properties of Virtual Network Tap configuration.
type InterfaceTapConfigurationPropertiesFormat struct {
	// VirtualNetworkTap - The reference of the Virtual Network Tap resource.
	VirtualNetworkTap *VirtualNetworkTap `json:"virtualNetworkTap,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the network interface tap configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceTapConfigurationPropertiesFormat.
func (itcpf InterfaceTapConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itcpf.VirtualNetworkTap != nil {
		objectMap["virtualNetworkTap"] = itcpf.VirtualNetworkTap
	}
	return json.Marshal(objectMap)
}

// InterfaceTapConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type InterfaceTapConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfaceTapConfigurationsClient) (InterfaceTapConfiguration, error)
}

// InterfaceTapConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfaceTapConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfaceTapConfigurationsClient) (autorest.Response, error)
}

// IPAddressAvailabilityResult response for CheckIPAddressAvailability API service call.
type IPAddressAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Private IP address availability.
	Available *bool `json:"available,omitempty"`
	// AvailableIPAddresses - Contains other available private IP addresses if the asked for address is taken.
	AvailableIPAddresses *[]string `json:"availableIPAddresses,omitempty"`
}

// IPConfiguration IP configuration.
type IPConfiguration struct {
	// IPConfigurationPropertiesFormat - Properties of the IP configuration.
	*IPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for IPConfiguration.
func (ic IPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = ic.IPConfigurationPropertiesFormat
	}
	if ic.Name != nil {
		objectMap["name"] = ic.Name
	}
	if ic.Etag != nil {
		objectMap["etag"] = ic.Etag
	}
	if ic.ID != nil {
		objectMap["id"] = ic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPConfiguration struct.
func (ic *IPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPConfigurationPropertiesFormat IPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &IPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				ic.IPConfigurationPropertiesFormat = &IPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		}
	}

	return nil
}

// IPConfigurationProfile IP configuration profile child resource.
type IPConfigurationProfile struct {
	// IPConfigurationProfilePropertiesFormat - Properties of the IP configuration profile.
	*IPConfigurationProfilePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for IPConfigurationProfile.
func (icp IPConfigurationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icp.IPConfigurationProfilePropertiesFormat != nil {
		objectMap["properties"] = icp.IPConfigurationProfilePropertiesFormat
	}
	if icp.Name != nil {
		objectMap["name"] = icp.Name
	}
	if icp.Etag != nil {
		objectMap["etag"] = icp.Etag
	}
	if icp.ID != nil {
		objectMap["id"] = icp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPConfigurationProfile struct.
func (icp *IPConfigurationProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPConfigurationProfilePropertiesFormat IPConfigurationProfilePropertiesFormat
				err = json.Unmarshal(*v, &IPConfigurationProfilePropertiesFormat)
				if err != nil {
					return err
				}
				icp.IPConfigurationProfilePropertiesFormat = &IPConfigurationProfilePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				icp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				icp.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				icp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				icp.ID = &ID
			}
		}
	}

	return nil
}

// IPConfigurationProfilePropertiesFormat IP configuration profile properties.
type IPConfigurationProfilePropertiesFormat struct {
	// Subnet - The reference of the subnet resource to create a container network interface ip configuration.
	Subnet *Subnet `json:"subnet,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the IP configuration profile resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for IPConfigurationProfilePropertiesFormat.
func (icppf IPConfigurationProfilePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icppf.Subnet != nil {
		objectMap["subnet"] = icppf.Subnet
	}
	return json.Marshal(objectMap)
}

// IPConfigurationPropertiesFormat properties of IP configuration.
type IPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - The provisioning state of the IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// IpsecPolicy an IPSec Policy configuration for a virtual network gateway connection.
type IpsecPolicy struct {
	// SaLifeTimeSeconds - The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
	SaLifeTimeSeconds *int32 `json:"saLifeTimeSeconds,omitempty"`
	// SaDataSizeKilobytes - The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
	SaDataSizeKilobytes *int32 `json:"saDataSizeKilobytes,omitempty"`
	// IpsecEncryption - The IPSec encryption algorithm (IKE phase 1). Possible values include: 'IpsecEncryptionNone', 'IpsecEncryptionDES', 'IpsecEncryptionDES3', 'IpsecEncryptionAES128', 'IpsecEncryptionAES192', 'IpsecEncryptionAES256', 'IpsecEncryptionGCMAES128', 'IpsecEncryptionGCMAES192', 'IpsecEncryptionGCMAES256'
	IpsecEncryption IpsecEncryption `json:"ipsecEncryption,omitempty"`
	// IpsecIntegrity - The IPSec integrity algorithm (IKE phase 1). Possible values include: 'IpsecIntegrityMD5', 'IpsecIntegritySHA1', 'IpsecIntegritySHA256', 'IpsecIntegrityGCMAES128', 'IpsecIntegrityGCMAES192', 'IpsecIntegrityGCMAES256'
	IpsecIntegrity IpsecIntegrity `json:"ipsecIntegrity,omitempty"`
	// IkeEncryption - The IKE encryption algorithm (IKE phase 2). Possible values include: 'DES', 'DES3', 'AES128', 'AES192', 'AES256', 'GCMAES256', 'GCMAES128'
	IkeEncryption IkeEncryption `json:"ikeEncryption,omitempty"`
	// IkeIntegrity - The IKE integrity algorithm (IKE phase 2). Possible values include: 'IkeIntegrityMD5', 'IkeIntegritySHA1', 'IkeIntegritySHA256', 'IkeIntegritySHA384', 'IkeIntegrityGCMAES256', 'IkeIntegrityGCMAES128'
	IkeIntegrity IkeIntegrity `json:"ikeIntegrity,omitempty"`
	// DhGroup - The DH Group used in IKE Phase 1 for initial SA. Possible values include: 'None', 'DHGroup1', 'DHGroup2', 'DHGroup14', 'DHGroup2048', 'ECP256', 'ECP384', 'DHGroup24'
	DhGroup DhGroup `json:"dhGroup,omitempty"`
	// PfsGroup - The Pfs Group used in IKE Phase 2 for new child SA. Possible values include: 'PfsGroupNone', 'PfsGroupPFS1', 'PfsGroupPFS2', 'PfsGroupPFS2048', 'PfsGroupECP256', 'PfsGroupECP384', 'PfsGroupPFS24', 'PfsGroupPFS14', 'PfsGroupPFSMM'
	PfsGroup PfsGroup `json:"pfsGroup,omitempty"`
}

// IPTag contains the IpTag associated with the object.
type IPTag struct {
	// IPTagType - The IP tag type. Example: FirstPartyUsage.
	IPTagType *string `json:"ipTagType,omitempty"`
	// Tag - The value of the IP tag associated with the public IP. Example: SQL.
	Tag *string `json:"tag,omitempty"`
}

// Ipv6ExpressRouteCircuitPeeringConfig contains IPv6 peering config.
type Ipv6ExpressRouteCircuitPeeringConfig struct {
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// RouteFilter - The reference of the RouteFilter resource.
	RouteFilter *SubResource `json:"routeFilter,omitempty"`
	// State - The state of peering. Possible values include: 'ExpressRouteCircuitPeeringStateDisabled', 'ExpressRouteCircuitPeeringStateEnabled'
	State ExpressRouteCircuitPeeringState `json:"state,omitempty"`
}

// ListHubVirtualNetworkConnectionsResult list of HubVirtualNetworkConnections and a URL nextLink to get
// the next set of results.
type ListHubVirtualNetworkConnectionsResult struct {
	autorest.Response `json:"-"`
	// Value - List of HubVirtualNetworkConnections.
	Value *[]HubVirtualNetworkConnection `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListHubVirtualNetworkConnectionsResultIterator provides access to a complete listing of
// HubVirtualNetworkConnection values.
type ListHubVirtualNetworkConnectionsResultIterator struct {
	i    int
	page ListHubVirtualNetworkConnectionsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListHubVirtualNetworkConnectionsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListHubVirtualNetworkConnectionsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListHubVirtualNetworkConnectionsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListHubVirtualNetworkConnectionsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListHubVirtualNetworkConnectionsResultIterator) Response() ListHubVirtualNetworkConnectionsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListHubVirtualNetworkConnectionsResultIterator) Value() HubVirtualNetworkConnection {
	if !iter.page.NotDone() {
		return HubVirtualNetworkConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListHubVirtualNetworkConnectionsResultIterator type.
func NewListHubVirtualNetworkConnectionsResultIterator(page ListHubVirtualNetworkConnectionsResultPage) ListHubVirtualNetworkConnectionsResultIterator {
	return ListHubVirtualNetworkConnectionsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lhvncr ListHubVirtualNetworkConnectionsResult) IsEmpty() bool {
	return lhvncr.Value == nil || len(*lhvncr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lhvncr ListHubVirtualNetworkConnectionsResult) hasNextLink() bool {
	return lhvncr.NextLink != nil && len(*lhvncr.NextLink) != 0
}

// listHubVirtualNetworkConnectionsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lhvncr ListHubVirtualNetworkConnectionsResult) listHubVirtualNetworkConnectionsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lhvncr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lhvncr.NextLink)))
}

// ListHubVirtualNetworkConnectionsResultPage contains a page of HubVirtualNetworkConnection values.
type ListHubVirtualNetworkConnectionsResultPage struct {
	fn     func(context.Context, ListHubVirtualNetworkConnectionsResult) (ListHubVirtualNetworkConnectionsResult, error)
	lhvncr ListHubVirtualNetworkConnectionsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListHubVirtualNetworkConnectionsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListHubVirtualNetworkConnectionsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lhvncr)
		if err != nil {
			return err
		}
		page.lhvncr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListHubVirtualNetworkConnectionsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListHubVirtualNetworkConnectionsResultPage) NotDone() bool {
	return !page.lhvncr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListHubVirtualNetworkConnectionsResultPage) Response() ListHubVirtualNetworkConnectionsResult {
	return page.lhvncr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListHubVirtualNetworkConnectionsResultPage) Values() []HubVirtualNetworkConnection {
	if page.lhvncr.IsEmpty() {
		return nil
	}
	return *page.lhvncr.Value
}

// Creates a new instance of the ListHubVirtualNetworkConnectionsResultPage type.
func NewListHubVirtualNetworkConnectionsResultPage(cur ListHubVirtualNetworkConnectionsResult, getNextPage func(context.Context, ListHubVirtualNetworkConnectionsResult) (ListHubVirtualNetworkConnectionsResult, error)) ListHubVirtualNetworkConnectionsResultPage {
	return ListHubVirtualNetworkConnectionsResultPage{
		fn:     getNextPage,
		lhvncr: cur,
	}
}

// ListP2SVpnGatewaysResult result of the request to list P2SVpnGateways. It contains a list of
// P2SVpnGateways and a URL nextLink to get the next set of results.
type ListP2SVpnGatewaysResult struct {
	autorest.Response `json:"-"`
	// Value - List of P2SVpnGateways.
	Value *[]P2SVpnGateway `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListP2SVpnGatewaysResultIterator provides access to a complete listing of P2SVpnGateway values.
type ListP2SVpnGatewaysResultIterator struct {
	i    int
	page ListP2SVpnGatewaysResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListP2SVpnGatewaysResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListP2SVpnGatewaysResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListP2SVpnGatewaysResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListP2SVpnGatewaysResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListP2SVpnGatewaysResultIterator) Response() ListP2SVpnGatewaysResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListP2SVpnGatewaysResultIterator) Value() P2SVpnGateway {
	if !iter.page.NotDone() {
		return P2SVpnGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListP2SVpnGatewaysResultIterator type.
func NewListP2SVpnGatewaysResultIterator(page ListP2SVpnGatewaysResultPage) ListP2SVpnGatewaysResultIterator {
	return ListP2SVpnGatewaysResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lpvgr ListP2SVpnGatewaysResult) IsEmpty() bool {
	return lpvgr.Value == nil || len(*lpvgr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lpvgr ListP2SVpnGatewaysResult) hasNextLink() bool {
	return lpvgr.NextLink != nil && len(*lpvgr.NextLink) != 0
}

// listP2SVpnGatewaysResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lpvgr ListP2SVpnGatewaysResult) listP2SVpnGatewaysResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lpvgr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lpvgr.NextLink)))
}

// ListP2SVpnGatewaysResultPage contains a page of P2SVpnGateway values.
type ListP2SVpnGatewaysResultPage struct {
	fn    func(context.Context, ListP2SVpnGatewaysResult) (ListP2SVpnGatewaysResult, error)
	lpvgr ListP2SVpnGatewaysResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListP2SVpnGatewaysResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListP2SVpnGatewaysResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lpvgr)
		if err != nil {
			return err
		}
		page.lpvgr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListP2SVpnGatewaysResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListP2SVpnGatewaysResultPage) NotDone() bool {
	return !page.lpvgr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListP2SVpnGatewaysResultPage) Response() ListP2SVpnGatewaysResult {
	return page.lpvgr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListP2SVpnGatewaysResultPage) Values() []P2SVpnGateway {
	if page.lpvgr.IsEmpty() {
		return nil
	}
	return *page.lpvgr.Value
}

// Creates a new instance of the ListP2SVpnGatewaysResultPage type.
func NewListP2SVpnGatewaysResultPage(cur ListP2SVpnGatewaysResult, getNextPage func(context.Context, ListP2SVpnGatewaysResult) (ListP2SVpnGatewaysResult, error)) ListP2SVpnGatewaysResultPage {
	return ListP2SVpnGatewaysResultPage{
		fn:    getNextPage,
		lpvgr: cur,
	}
}

// ListP2SVpnServerConfigurationsResult result of the request to list all P2SVpnServerConfigurations
// associated to a VirtualWan. It contains a list of P2SVpnServerConfigurations and a URL nextLink to get
// the next set of results.
type ListP2SVpnServerConfigurationsResult struct {
	autorest.Response `json:"-"`
	// Value - List of P2SVpnServerConfigurations.
	Value *[]P2SVpnServerConfiguration `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListP2SVpnServerConfigurationsResultIterator provides access to a complete listing of
// P2SVpnServerConfiguration values.
type ListP2SVpnServerConfigurationsResultIterator struct {
	i    int
	page ListP2SVpnServerConfigurationsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListP2SVpnServerConfigurationsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListP2SVpnServerConfigurationsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListP2SVpnServerConfigurationsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListP2SVpnServerConfigurationsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListP2SVpnServerConfigurationsResultIterator) Response() ListP2SVpnServerConfigurationsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListP2SVpnServerConfigurationsResultIterator) Value() P2SVpnServerConfiguration {
	if !iter.page.NotDone() {
		return P2SVpnServerConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListP2SVpnServerConfigurationsResultIterator type.
func NewListP2SVpnServerConfigurationsResultIterator(page ListP2SVpnServerConfigurationsResultPage) ListP2SVpnServerConfigurationsResultIterator {
	return ListP2SVpnServerConfigurationsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lpvscr ListP2SVpnServerConfigurationsResult) IsEmpty() bool {
	return lpvscr.Value == nil || len(*lpvscr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lpvscr ListP2SVpnServerConfigurationsResult) hasNextLink() bool {
	return lpvscr.NextLink != nil && len(*lpvscr.NextLink) != 0
}

// listP2SVpnServerConfigurationsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lpvscr ListP2SVpnServerConfigurationsResult) listP2SVpnServerConfigurationsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lpvscr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lpvscr.NextLink)))
}

// ListP2SVpnServerConfigurationsResultPage contains a page of P2SVpnServerConfiguration values.
type ListP2SVpnServerConfigurationsResultPage struct {
	fn     func(context.Context, ListP2SVpnServerConfigurationsResult) (ListP2SVpnServerConfigurationsResult, error)
	lpvscr ListP2SVpnServerConfigurationsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListP2SVpnServerConfigurationsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListP2SVpnServerConfigurationsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lpvscr)
		if err != nil {
			return err
		}
		page.lpvscr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListP2SVpnServerConfigurationsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListP2SVpnServerConfigurationsResultPage) NotDone() bool {
	return !page.lpvscr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListP2SVpnServerConfigurationsResultPage) Response() ListP2SVpnServerConfigurationsResult {
	return page.lpvscr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListP2SVpnServerConfigurationsResultPage) Values() []P2SVpnServerConfiguration {
	if page.lpvscr.IsEmpty() {
		return nil
	}
	return *page.lpvscr.Value
}

// Creates a new instance of the ListP2SVpnServerConfigurationsResultPage type.
func NewListP2SVpnServerConfigurationsResultPage(cur ListP2SVpnServerConfigurationsResult, getNextPage func(context.Context, ListP2SVpnServerConfigurationsResult) (ListP2SVpnServerConfigurationsResult, error)) ListP2SVpnServerConfigurationsResultPage {
	return ListP2SVpnServerConfigurationsResultPage{
		fn:     getNextPage,
		lpvscr: cur,
	}
}

// ListString ...
type ListString struct {
	autorest.Response `json:"-"`
	Value             *[]string `json:"value,omitempty"`
}

// ListVirtualHubsResult result of the request to list VirtualHubs. It contains a list of VirtualHubs and a
// URL nextLink to get the next set of results.
type ListVirtualHubsResult struct {
	autorest.Response `json:"-"`
	// Value - List of VirtualHubs.
	Value *[]VirtualHub `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListVirtualHubsResultIterator provides access to a complete listing of VirtualHub values.
type ListVirtualHubsResultIterator struct {
	i    int
	page ListVirtualHubsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListVirtualHubsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVirtualHubsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListVirtualHubsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListVirtualHubsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListVirtualHubsResultIterator) Response() ListVirtualHubsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListVirtualHubsResultIterator) Value() VirtualHub {
	if !iter.page.NotDone() {
		return VirtualHub{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListVirtualHubsResultIterator type.
func NewListVirtualHubsResultIterator(page ListVirtualHubsResultPage) ListVirtualHubsResultIterator {
	return ListVirtualHubsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvhr ListVirtualHubsResult) IsEmpty() bool {
	return lvhr.Value == nil || len(*lvhr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lvhr ListVirtualHubsResult) hasNextLink() bool {
	return lvhr.NextLink != nil && len(*lvhr.NextLink) != 0
}

// listVirtualHubsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvhr ListVirtualHubsResult) listVirtualHubsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lvhr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvhr.NextLink)))
}

// ListVirtualHubsResultPage contains a page of VirtualHub values.
type ListVirtualHubsResultPage struct {
	fn   func(context.Context, ListVirtualHubsResult) (ListVirtualHubsResult, error)
	lvhr ListVirtualHubsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListVirtualHubsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVirtualHubsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lvhr)
		if err != nil {
			return err
		}
		page.lvhr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListVirtualHubsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListVirtualHubsResultPage) NotDone() bool {
	return !page.lvhr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListVirtualHubsResultPage) Response() ListVirtualHubsResult {
	return page.lvhr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListVirtualHubsResultPage) Values() []VirtualHub {
	if page.lvhr.IsEmpty() {
		return nil
	}
	return *page.lvhr.Value
}

// Creates a new instance of the ListVirtualHubsResultPage type.
func NewListVirtualHubsResultPage(cur ListVirtualHubsResult, getNextPage func(context.Context, ListVirtualHubsResult) (ListVirtualHubsResult, error)) ListVirtualHubsResultPage {
	return ListVirtualHubsResultPage{
		fn:   getNextPage,
		lvhr: cur,
	}
}

// ListVirtualWANsResult result of the request to list VirtualWANs. It contains a list of VirtualWANs and a
// URL nextLink to get the next set of results.
type ListVirtualWANsResult struct {
	autorest.Response `json:"-"`
	// Value - List of VirtualWANs.
	Value *[]VirtualWAN `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListVirtualWANsResultIterator provides access to a complete listing of VirtualWAN values.
type ListVirtualWANsResultIterator struct {
	i    int
	page ListVirtualWANsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListVirtualWANsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVirtualWANsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListVirtualWANsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListVirtualWANsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListVirtualWANsResultIterator) Response() ListVirtualWANsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListVirtualWANsResultIterator) Value() VirtualWAN {
	if !iter.page.NotDone() {
		return VirtualWAN{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListVirtualWANsResultIterator type.
func NewListVirtualWANsResultIterator(page ListVirtualWANsResultPage) ListVirtualWANsResultIterator {
	return ListVirtualWANsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvwnr ListVirtualWANsResult) IsEmpty() bool {
	return lvwnr.Value == nil || len(*lvwnr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lvwnr ListVirtualWANsResult) hasNextLink() bool {
	return lvwnr.NextLink != nil && len(*lvwnr.NextLink) != 0
}

// listVirtualWANsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvwnr ListVirtualWANsResult) listVirtualWANsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lvwnr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvwnr.NextLink)))
}

// ListVirtualWANsResultPage contains a page of VirtualWAN values.
type ListVirtualWANsResultPage struct {
	fn    func(context.Context, ListVirtualWANsResult) (ListVirtualWANsResult, error)
	lvwnr ListVirtualWANsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListVirtualWANsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVirtualWANsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lvwnr)
		if err != nil {
			return err
		}
		page.lvwnr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListVirtualWANsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListVirtualWANsResultPage) NotDone() bool {
	return !page.lvwnr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListVirtualWANsResultPage) Response() ListVirtualWANsResult {
	return page.lvwnr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListVirtualWANsResultPage) Values() []VirtualWAN {
	if page.lvwnr.IsEmpty() {
		return nil
	}
	return *page.lvwnr.Value
}

// Creates a new instance of the ListVirtualWANsResultPage type.
func NewListVirtualWANsResultPage(cur ListVirtualWANsResult, getNextPage func(context.Context, ListVirtualWANsResult) (ListVirtualWANsResult, error)) ListVirtualWANsResultPage {
	return ListVirtualWANsResultPage{
		fn:    getNextPage,
		lvwnr: cur,
	}
}

// ListVpnConnectionsResult result of the request to list all vpn connections to a virtual wan vpn gateway.
// It contains a list of Vpn Connections and a URL nextLink to get the next set of results.
type ListVpnConnectionsResult struct {
	autorest.Response `json:"-"`
	// Value - List of Vpn Connections.
	Value *[]VpnConnection `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListVpnConnectionsResultIterator provides access to a complete listing of VpnConnection values.
type ListVpnConnectionsResultIterator struct {
	i    int
	page ListVpnConnectionsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListVpnConnectionsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnConnectionsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListVpnConnectionsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListVpnConnectionsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListVpnConnectionsResultIterator) Response() ListVpnConnectionsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListVpnConnectionsResultIterator) Value() VpnConnection {
	if !iter.page.NotDone() {
		return VpnConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListVpnConnectionsResultIterator type.
func NewListVpnConnectionsResultIterator(page ListVpnConnectionsResultPage) ListVpnConnectionsResultIterator {
	return ListVpnConnectionsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvcr ListVpnConnectionsResult) IsEmpty() bool {
	return lvcr.Value == nil || len(*lvcr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lvcr ListVpnConnectionsResult) hasNextLink() bool {
	return lvcr.NextLink != nil && len(*lvcr.NextLink) != 0
}

// listVpnConnectionsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvcr ListVpnConnectionsResult) listVpnConnectionsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lvcr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvcr.NextLink)))
}

// ListVpnConnectionsResultPage contains a page of VpnConnection values.
type ListVpnConnectionsResultPage struct {
	fn   func(context.Context, ListVpnConnectionsResult) (ListVpnConnectionsResult, error)
	lvcr ListVpnConnectionsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListVpnConnectionsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnConnectionsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lvcr)
		if err != nil {
			return err
		}
		page.lvcr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListVpnConnectionsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListVpnConnectionsResultPage) NotDone() bool {
	return !page.lvcr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListVpnConnectionsResultPage) Response() ListVpnConnectionsResult {
	return page.lvcr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListVpnConnectionsResultPage) Values() []VpnConnection {
	if page.lvcr.IsEmpty() {
		return nil
	}
	return *page.lvcr.Value
}

// Creates a new instance of the ListVpnConnectionsResultPage type.
func NewListVpnConnectionsResultPage(cur ListVpnConnectionsResult, getNextPage func(context.Context, ListVpnConnectionsResult) (ListVpnConnectionsResult, error)) ListVpnConnectionsResultPage {
	return ListVpnConnectionsResultPage{
		fn:   getNextPage,
		lvcr: cur,
	}
}

// ListVpnGatewaysResult result of the request to list VpnGateways. It contains a list of VpnGateways and a
// URL nextLink to get the next set of results.
type ListVpnGatewaysResult struct {
	autorest.Response `json:"-"`
	// Value - List of VpnGateways.
	Value *[]VpnGateway `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListVpnGatewaysResultIterator provides access to a complete listing of VpnGateway values.
type ListVpnGatewaysResultIterator struct {
	i    int
	page ListVpnGatewaysResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListVpnGatewaysResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnGatewaysResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListVpnGatewaysResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListVpnGatewaysResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListVpnGatewaysResultIterator) Response() ListVpnGatewaysResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListVpnGatewaysResultIterator) Value() VpnGateway {
	if !iter.page.NotDone() {
		return VpnGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListVpnGatewaysResultIterator type.
func NewListVpnGatewaysResultIterator(page ListVpnGatewaysResultPage) ListVpnGatewaysResultIterator {
	return ListVpnGatewaysResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvgr ListVpnGatewaysResult) IsEmpty() bool {
	return lvgr.Value == nil || len(*lvgr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lvgr ListVpnGatewaysResult) hasNextLink() bool {
	return lvgr.NextLink != nil && len(*lvgr.NextLink) != 0
}

// listVpnGatewaysResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvgr ListVpnGatewaysResult) listVpnGatewaysResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lvgr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvgr.NextLink)))
}

// ListVpnGatewaysResultPage contains a page of VpnGateway values.
type ListVpnGatewaysResultPage struct {
	fn   func(context.Context, ListVpnGatewaysResult) (ListVpnGatewaysResult, error)
	lvgr ListVpnGatewaysResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListVpnGatewaysResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnGatewaysResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lvgr)
		if err != nil {
			return err
		}
		page.lvgr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListVpnGatewaysResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListVpnGatewaysResultPage) NotDone() bool {
	return !page.lvgr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListVpnGatewaysResultPage) Response() ListVpnGatewaysResult {
	return page.lvgr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListVpnGatewaysResultPage) Values() []VpnGateway {
	if page.lvgr.IsEmpty() {
		return nil
	}
	return *page.lvgr.Value
}

// Creates a new instance of the ListVpnGatewaysResultPage type.
func NewListVpnGatewaysResultPage(cur ListVpnGatewaysResult, getNextPage func(context.Context, ListVpnGatewaysResult) (ListVpnGatewaysResult, error)) ListVpnGatewaysResultPage {
	return ListVpnGatewaysResultPage{
		fn:   getNextPage,
		lvgr: cur,
	}
}

// ListVpnSiteLinkConnectionsResult result of the request to list all vpn connections to a virtual wan vpn
// gateway. It contains a list of Vpn Connections and a URL nextLink to get the next set of results.
type ListVpnSiteLinkConnectionsResult struct {
	autorest.Response `json:"-"`
	// Value - List of VpnSiteLinkConnections.
	Value *[]VpnSiteLinkConnection `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListVpnSiteLinkConnectionsResultIterator provides access to a complete listing of VpnSiteLinkConnection
// values.
type ListVpnSiteLinkConnectionsResultIterator struct {
	i    int
	page ListVpnSiteLinkConnectionsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListVpnSiteLinkConnectionsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnSiteLinkConnectionsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListVpnSiteLinkConnectionsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListVpnSiteLinkConnectionsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListVpnSiteLinkConnectionsResultIterator) Response() ListVpnSiteLinkConnectionsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListVpnSiteLinkConnectionsResultIterator) Value() VpnSiteLinkConnection {
	if !iter.page.NotDone() {
		return VpnSiteLinkConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListVpnSiteLinkConnectionsResultIterator type.
func NewListVpnSiteLinkConnectionsResultIterator(page ListVpnSiteLinkConnectionsResultPage) ListVpnSiteLinkConnectionsResultIterator {
	return ListVpnSiteLinkConnectionsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvslcr ListVpnSiteLinkConnectionsResult) IsEmpty() bool {
	return lvslcr.Value == nil || len(*lvslcr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lvslcr ListVpnSiteLinkConnectionsResult) hasNextLink() bool {
	return lvslcr.NextLink != nil && len(*lvslcr.NextLink) != 0
}

// listVpnSiteLinkConnectionsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvslcr ListVpnSiteLinkConnectionsResult) listVpnSiteLinkConnectionsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lvslcr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvslcr.NextLink)))
}

// ListVpnSiteLinkConnectionsResultPage contains a page of VpnSiteLinkConnection values.
type ListVpnSiteLinkConnectionsResultPage struct {
	fn     func(context.Context, ListVpnSiteLinkConnectionsResult) (ListVpnSiteLinkConnectionsResult, error)
	lvslcr ListVpnSiteLinkConnectionsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListVpnSiteLinkConnectionsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnSiteLinkConnectionsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lvslcr)
		if err != nil {
			return err
		}
		page.lvslcr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListVpnSiteLinkConnectionsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListVpnSiteLinkConnectionsResultPage) NotDone() bool {
	return !page.lvslcr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListVpnSiteLinkConnectionsResultPage) Response() ListVpnSiteLinkConnectionsResult {
	return page.lvslcr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListVpnSiteLinkConnectionsResultPage) Values() []VpnSiteLinkConnection {
	if page.lvslcr.IsEmpty() {
		return nil
	}
	return *page.lvslcr.Value
}

// Creates a new instance of the ListVpnSiteLinkConnectionsResultPage type.
func NewListVpnSiteLinkConnectionsResultPage(cur ListVpnSiteLinkConnectionsResult, getNextPage func(context.Context, ListVpnSiteLinkConnectionsResult) (ListVpnSiteLinkConnectionsResult, error)) ListVpnSiteLinkConnectionsResultPage {
	return ListVpnSiteLinkConnectionsResultPage{
		fn:     getNextPage,
		lvslcr: cur,
	}
}

// ListVpnSiteLinksResult result of the request to list VpnSiteLinks. It contains a list of VpnSiteLinks
// and a URL nextLink to get the next set of results.
type ListVpnSiteLinksResult struct {
	autorest.Response `json:"-"`
	// Value - List of VpnSitesLinks.
	Value *[]VpnSiteLink `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListVpnSiteLinksResultIterator provides access to a complete listing of VpnSiteLink values.
type ListVpnSiteLinksResultIterator struct {
	i    int
	page ListVpnSiteLinksResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListVpnSiteLinksResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnSiteLinksResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListVpnSiteLinksResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListVpnSiteLinksResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListVpnSiteLinksResultIterator) Response() ListVpnSiteLinksResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListVpnSiteLinksResultIterator) Value() VpnSiteLink {
	if !iter.page.NotDone() {
		return VpnSiteLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListVpnSiteLinksResultIterator type.
func NewListVpnSiteLinksResultIterator(page ListVpnSiteLinksResultPage) ListVpnSiteLinksResultIterator {
	return ListVpnSiteLinksResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvslr ListVpnSiteLinksResult) IsEmpty() bool {
	return lvslr.Value == nil || len(*lvslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lvslr ListVpnSiteLinksResult) hasNextLink() bool {
	return lvslr.NextLink != nil && len(*lvslr.NextLink) != 0
}

// listVpnSiteLinksResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvslr ListVpnSiteLinksResult) listVpnSiteLinksResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lvslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvslr.NextLink)))
}

// ListVpnSiteLinksResultPage contains a page of VpnSiteLink values.
type ListVpnSiteLinksResultPage struct {
	fn    func(context.Context, ListVpnSiteLinksResult) (ListVpnSiteLinksResult, error)
	lvslr ListVpnSiteLinksResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListVpnSiteLinksResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnSiteLinksResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lvslr)
		if err != nil {
			return err
		}
		page.lvslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListVpnSiteLinksResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListVpnSiteLinksResultPage) NotDone() bool {
	return !page.lvslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListVpnSiteLinksResultPage) Response() ListVpnSiteLinksResult {
	return page.lvslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListVpnSiteLinksResultPage) Values() []VpnSiteLink {
	if page.lvslr.IsEmpty() {
		return nil
	}
	return *page.lvslr.Value
}

// Creates a new instance of the ListVpnSiteLinksResultPage type.
func NewListVpnSiteLinksResultPage(cur ListVpnSiteLinksResult, getNextPage func(context.Context, ListVpnSiteLinksResult) (ListVpnSiteLinksResult, error)) ListVpnSiteLinksResultPage {
	return ListVpnSiteLinksResultPage{
		fn:    getNextPage,
		lvslr: cur,
	}
}

// ListVpnSitesResult result of the request to list VpnSites. It contains a list of VpnSites and a URL
// nextLink to get the next set of results.
type ListVpnSitesResult struct {
	autorest.Response `json:"-"`
	// Value - List of VpnSites.
	Value *[]VpnSite `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListVpnSitesResultIterator provides access to a complete listing of VpnSite values.
type ListVpnSitesResultIterator struct {
	i    int
	page ListVpnSitesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListVpnSitesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnSitesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListVpnSitesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListVpnSitesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListVpnSitesResultIterator) Response() ListVpnSitesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListVpnSitesResultIterator) Value() VpnSite {
	if !iter.page.NotDone() {
		return VpnSite{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListVpnSitesResultIterator type.
func NewListVpnSitesResultIterator(page ListVpnSitesResultPage) ListVpnSitesResultIterator {
	return ListVpnSitesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvsr ListVpnSitesResult) IsEmpty() bool {
	return lvsr.Value == nil || len(*lvsr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lvsr ListVpnSitesResult) hasNextLink() bool {
	return lvsr.NextLink != nil && len(*lvsr.NextLink) != 0
}

// listVpnSitesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvsr ListVpnSitesResult) listVpnSitesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lvsr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvsr.NextLink)))
}

// ListVpnSitesResultPage contains a page of VpnSite values.
type ListVpnSitesResultPage struct {
	fn   func(context.Context, ListVpnSitesResult) (ListVpnSitesResult, error)
	lvsr ListVpnSitesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListVpnSitesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListVpnSitesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lvsr)
		if err != nil {
			return err
		}
		page.lvsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListVpnSitesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListVpnSitesResultPage) NotDone() bool {
	return !page.lvsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListVpnSitesResultPage) Response() ListVpnSitesResult {
	return page.lvsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListVpnSitesResultPage) Values() []VpnSite {
	if page.lvsr.IsEmpty() {
		return nil
	}
	return *page.lvsr.Value
}

// Creates a new instance of the ListVpnSitesResultPage type.
func NewListVpnSitesResultPage(cur ListVpnSitesResult, getNextPage func(context.Context, ListVpnSitesResult) (ListVpnSitesResult, error)) ListVpnSitesResultPage {
	return ListVpnSitesResultPage{
		fn:   getNextPage,
		lvsr: cur,
	}
}

// LoadBalancer loadBalancer resource.
type LoadBalancer struct {
	autorest.Response `json:"-"`
	// Sku - The load balancer SKU.
	Sku *LoadBalancerSku `json:"sku,omitempty"`
	// LoadBalancerPropertiesFormat - Properties of load balancer.
	*LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LoadBalancer.
func (lb LoadBalancer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lb.Sku != nil {
		objectMap["sku"] = lb.Sku
	}
	if lb.LoadBalancerPropertiesFormat != nil {
		objectMap["properties"] = lb.LoadBalancerPropertiesFormat
	}
	if lb.Etag != nil {
		objectMap["etag"] = lb.Etag
	}
	if lb.ID != nil {
		objectMap["id"] = lb.ID
	}
	if lb.Location != nil {
		objectMap["location"] = lb.Location
	}
	if lb.Tags != nil {
		objectMap["tags"] = lb.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancer struct.
func (lb *LoadBalancer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku LoadBalancerSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				lb.Sku = &sku
			}
		case "properties":
			if v != nil {
				var loadBalancerPropertiesFormat LoadBalancerPropertiesFormat
				err = json.Unmarshal(*v, &loadBalancerPropertiesFormat)
				if err != nil {
					return err
				}
				lb.LoadBalancerPropertiesFormat = &loadBalancerPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lb.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lb.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lb.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lb.Tags = tags
			}
		}
	}

	return nil
}

// LoadBalancerBackendAddressPoolListResult response for ListBackendAddressPool API service call.
type LoadBalancerBackendAddressPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of backend address pools in a load balancer.
	Value *[]BackendAddressPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancerBackendAddressPoolListResult.
func (lbbaplr LoadBalancerBackendAddressPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbbaplr.Value != nil {
		objectMap["value"] = lbbaplr.Value
	}
	return json.Marshal(objectMap)
}

// LoadBalancerBackendAddressPoolListResultIterator provides access to a complete listing of
// BackendAddressPool values.
type LoadBalancerBackendAddressPoolListResultIterator struct {
	i    int
	page LoadBalancerBackendAddressPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerBackendAddressPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerBackendAddressPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerBackendAddressPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerBackendAddressPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerBackendAddressPoolListResultIterator) Response() LoadBalancerBackendAddressPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerBackendAddressPoolListResultIterator) Value() BackendAddressPool {
	if !iter.page.NotDone() {
		return BackendAddressPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerBackendAddressPoolListResultIterator type.
func NewLoadBalancerBackendAddressPoolListResultIterator(page LoadBalancerBackendAddressPoolListResultPage) LoadBalancerBackendAddressPoolListResultIterator {
	return LoadBalancerBackendAddressPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lbbaplr LoadBalancerBackendAddressPoolListResult) IsEmpty() bool {
	return lbbaplr.Value == nil || len(*lbbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lbbaplr LoadBalancerBackendAddressPoolListResult) hasNextLink() bool {
	return lbbaplr.NextLink != nil && len(*lbbaplr.NextLink) != 0
}

// loadBalancerBackendAddressPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lbbaplr LoadBalancerBackendAddressPoolListResult) loadBalancerBackendAddressPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lbbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lbbaplr.NextLink)))
}

// LoadBalancerBackendAddressPoolListResultPage contains a page of BackendAddressPool values.
type LoadBalancerBackendAddressPoolListResultPage struct {
	fn      func(context.Context, LoadBalancerBackendAddressPoolListResult) (LoadBalancerBackendAddressPoolListResult, error)
	lbbaplr LoadBalancerBackendAddressPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerBackendAddressPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerBackendAddressPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lbbaplr)
		if err != nil {
			return err
		}
		page.lbbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerBackendAddressPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerBackendAddressPoolListResultPage) NotDone() bool {
	return !page.lbbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerBackendAddressPoolListResultPage) Response() LoadBalancerBackendAddressPoolListResult {
	return page.lbbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerBackendAddressPoolListResultPage) Values() []BackendAddressPool {
	if page.lbbaplr.IsEmpty() {
		return nil
	}
	return *page.lbbaplr.Value
}

// Creates a new instance of the LoadBalancerBackendAddressPoolListResultPage type.
func NewLoadBalancerBackendAddressPoolListResultPage(cur LoadBalancerBackendAddressPoolListResult, getNextPage func(context.Context, LoadBalancerBackendAddressPoolListResult) (LoadBalancerBackendAddressPoolListResult, error)) LoadBalancerBackendAddressPoolListResultPage {
	return LoadBalancerBackendAddressPoolListResultPage{
		fn:      getNextPage,
		lbbaplr: cur,
	}
}

// LoadBalancerFrontendIPConfigurationListResult response for ListFrontendIPConfiguration API service call.
type LoadBalancerFrontendIPConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of frontend IP configurations in a load balancer.
	Value *[]FrontendIPConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancerFrontendIPConfigurationListResult.
func (lbficlr LoadBalancerFrontendIPConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbficlr.Value != nil {
		objectMap["value"] = lbficlr.Value
	}
	return json.Marshal(objectMap)
}

// LoadBalancerFrontendIPConfigurationListResultIterator provides access to a complete listing of
// FrontendIPConfiguration values.
type LoadBalancerFrontendIPConfigurationListResultIterator struct {
	i    int
	page LoadBalancerFrontendIPConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerFrontendIPConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerFrontendIPConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerFrontendIPConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerFrontendIPConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerFrontendIPConfigurationListResultIterator) Response() LoadBalancerFrontendIPConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerFrontendIPConfigurationListResultIterator) Value() FrontendIPConfiguration {
	if !iter.page.NotDone() {
		return FrontendIPConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerFrontendIPConfigurationListResultIterator type.
func NewLoadBalancerFrontendIPConfigurationListResultIterator(page LoadBalancerFrontendIPConfigurationListResultPage) LoadBalancerFrontendIPConfigurationListResultIterator {
	return LoadBalancerFrontendIPConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lbficlr LoadBalancerFrontendIPConfigurationListResult) IsEmpty() bool {
	return lbficlr.Value == nil || len(*lbficlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lbficlr LoadBalancerFrontendIPConfigurationListResult) hasNextLink() bool {
	return lbficlr.NextLink != nil && len(*lbficlr.NextLink) != 0
}

// loadBalancerFrontendIPConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lbficlr LoadBalancerFrontendIPConfigurationListResult) loadBalancerFrontendIPConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lbficlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lbficlr.NextLink)))
}

// LoadBalancerFrontendIPConfigurationListResultPage contains a page of FrontendIPConfiguration values.
type LoadBalancerFrontendIPConfigurationListResultPage struct {
	fn      func(context.Context, LoadBalancerFrontendIPConfigurationListResult) (LoadBalancerFrontendIPConfigurationListResult, error)
	lbficlr LoadBalancerFrontendIPConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerFrontendIPConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerFrontendIPConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lbficlr)
		if err != nil {
			return err
		}
		page.lbficlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerFrontendIPConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerFrontendIPConfigurationListResultPage) NotDone() bool {
	return !page.lbficlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerFrontendIPConfigurationListResultPage) Response() LoadBalancerFrontendIPConfigurationListResult {
	return page.lbficlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerFrontendIPConfigurationListResultPage) Values() []FrontendIPConfiguration {
	if page.lbficlr.IsEmpty() {
		return nil
	}
	return *page.lbficlr.Value
}

// Creates a new instance of the LoadBalancerFrontendIPConfigurationListResultPage type.
func NewLoadBalancerFrontendIPConfigurationListResultPage(cur LoadBalancerFrontendIPConfigurationListResult, getNextPage func(context.Context, LoadBalancerFrontendIPConfigurationListResult) (LoadBalancerFrontendIPConfigurationListResult, error)) LoadBalancerFrontendIPConfigurationListResultPage {
	return LoadBalancerFrontendIPConfigurationListResultPage{
		fn:      getNextPage,
		lbficlr: cur,
	}
}

// LoadBalancerListResult response for ListLoadBalancers API service call.
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of load balancers in a resource group.
	Value *[]LoadBalancer `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancerListResult.
func (lblr LoadBalancerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lblr.Value != nil {
		objectMap["value"] = lblr.Value
	}
	return json.Marshal(objectMap)
}

// LoadBalancerListResultIterator provides access to a complete listing of LoadBalancer values.
type LoadBalancerListResultIterator struct {
	i    int
	page LoadBalancerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerListResultIterator) Response() LoadBalancerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerListResultIterator) Value() LoadBalancer {
	if !iter.page.NotDone() {
		return LoadBalancer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerListResultIterator type.
func NewLoadBalancerListResultIterator(page LoadBalancerListResultPage) LoadBalancerListResultIterator {
	return LoadBalancerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lblr LoadBalancerListResult) IsEmpty() bool {
	return lblr.Value == nil || len(*lblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lblr LoadBalancerListResult) hasNextLink() bool {
	return lblr.NextLink != nil && len(*lblr.NextLink) != 0
}

// loadBalancerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lblr LoadBalancerListResult) loadBalancerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lblr.NextLink)))
}

// LoadBalancerListResultPage contains a page of LoadBalancer values.
type LoadBalancerListResultPage struct {
	fn   func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)
	lblr LoadBalancerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lblr)
		if err != nil {
			return err
		}
		page.lblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerListResultPage) NotDone() bool {
	return !page.lblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerListResultPage) Response() LoadBalancerListResult {
	return page.lblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerListResultPage) Values() []LoadBalancer {
	if page.lblr.IsEmpty() {
		return nil
	}
	return *page.lblr.Value
}

// Creates a new instance of the LoadBalancerListResultPage type.
func NewLoadBalancerListResultPage(cur LoadBalancerListResult, getNextPage func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)) LoadBalancerListResultPage {
	return LoadBalancerListResultPage{
		fn:   getNextPage,
		lblr: cur,
	}
}

// LoadBalancerLoadBalancingRuleListResult response for ListLoadBalancingRule API service call.
type LoadBalancerLoadBalancingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of load balancing rules in a load balancer.
	Value *[]LoadBalancingRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancerLoadBalancingRuleListResult.
func (lblbrlr LoadBalancerLoadBalancingRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lblbrlr.Value != nil {
		objectMap["value"] = lblbrlr.Value
	}
	return json.Marshal(objectMap)
}

// LoadBalancerLoadBalancingRuleListResultIterator provides access to a complete listing of
// LoadBalancingRule values.
type LoadBalancerLoadBalancingRuleListResultIterator struct {
	i    int
	page LoadBalancerLoadBalancingRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerLoadBalancingRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerLoadBalancingRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerLoadBalancingRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerLoadBalancingRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerLoadBalancingRuleListResultIterator) Response() LoadBalancerLoadBalancingRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerLoadBalancingRuleListResultIterator) Value() LoadBalancingRule {
	if !iter.page.NotDone() {
		return LoadBalancingRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerLoadBalancingRuleListResultIterator type.
func NewLoadBalancerLoadBalancingRuleListResultIterator(page LoadBalancerLoadBalancingRuleListResultPage) LoadBalancerLoadBalancingRuleListResultIterator {
	return LoadBalancerLoadBalancingRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lblbrlr LoadBalancerLoadBalancingRuleListResult) IsEmpty() bool {
	return lblbrlr.Value == nil || len(*lblbrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lblbrlr LoadBalancerLoadBalancingRuleListResult) hasNextLink() bool {
	return lblbrlr.NextLink != nil && len(*lblbrlr.NextLink) != 0
}

// loadBalancerLoadBalancingRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lblbrlr LoadBalancerLoadBalancingRuleListResult) loadBalancerLoadBalancingRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lblbrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lblbrlr.NextLink)))
}

// LoadBalancerLoadBalancingRuleListResultPage contains a page of LoadBalancingRule values.
type LoadBalancerLoadBalancingRuleListResultPage struct {
	fn      func(context.Context, LoadBalancerLoadBalancingRuleListResult) (LoadBalancerLoadBalancingRuleListResult, error)
	lblbrlr LoadBalancerLoadBalancingRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerLoadBalancingRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerLoadBalancingRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lblbrlr)
		if err != nil {
			return err
		}
		page.lblbrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerLoadBalancingRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerLoadBalancingRuleListResultPage) NotDone() bool {
	return !page.lblbrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerLoadBalancingRuleListResultPage) Response() LoadBalancerLoadBalancingRuleListResult {
	return page.lblbrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerLoadBalancingRuleListResultPage) Values() []LoadBalancingRule {
	if page.lblbrlr.IsEmpty() {
		return nil
	}
	return *page.lblbrlr.Value
}

// Creates a new instance of the LoadBalancerLoadBalancingRuleListResultPage type.
func NewLoadBalancerLoadBalancingRuleListResultPage(cur LoadBalancerLoadBalancingRuleListResult, getNextPage func(context.Context, LoadBalancerLoadBalancingRuleListResult) (LoadBalancerLoadBalancingRuleListResult, error)) LoadBalancerLoadBalancingRuleListResultPage {
	return LoadBalancerLoadBalancingRuleListResultPage{
		fn:      getNextPage,
		lblbrlr: cur,
	}
}

// LoadBalancerOutboundRuleListResult response for ListOutboundRule API service call.
type LoadBalancerOutboundRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of outbound rules in a load balancer.
	Value *[]OutboundRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancerOutboundRuleListResult.
func (lborlr LoadBalancerOutboundRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lborlr.Value != nil {
		objectMap["value"] = lborlr.Value
	}
	return json.Marshal(objectMap)
}

// LoadBalancerOutboundRuleListResultIterator provides access to a complete listing of OutboundRule values.
type LoadBalancerOutboundRuleListResultIterator struct {
	i    int
	page LoadBalancerOutboundRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerOutboundRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerOutboundRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerOutboundRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerOutboundRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerOutboundRuleListResultIterator) Response() LoadBalancerOutboundRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerOutboundRuleListResultIterator) Value() OutboundRule {
	if !iter.page.NotDone() {
		return OutboundRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerOutboundRuleListResultIterator type.
func NewLoadBalancerOutboundRuleListResultIterator(page LoadBalancerOutboundRuleListResultPage) LoadBalancerOutboundRuleListResultIterator {
	return LoadBalancerOutboundRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lborlr LoadBalancerOutboundRuleListResult) IsEmpty() bool {
	return lborlr.Value == nil || len(*lborlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lborlr LoadBalancerOutboundRuleListResult) hasNextLink() bool {
	return lborlr.NextLink != nil && len(*lborlr.NextLink) != 0
}

// loadBalancerOutboundRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lborlr LoadBalancerOutboundRuleListResult) loadBalancerOutboundRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lborlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lborlr.NextLink)))
}

// LoadBalancerOutboundRuleListResultPage contains a page of OutboundRule values.
type LoadBalancerOutboundRuleListResultPage struct {
	fn     func(context.Context, LoadBalancerOutboundRuleListResult) (LoadBalancerOutboundRuleListResult, error)
	lborlr LoadBalancerOutboundRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerOutboundRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerOutboundRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lborlr)
		if err != nil {
			return err
		}
		page.lborlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerOutboundRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerOutboundRuleListResultPage) NotDone() bool {
	return !page.lborlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerOutboundRuleListResultPage) Response() LoadBalancerOutboundRuleListResult {
	return page.lborlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerOutboundRuleListResultPage) Values() []OutboundRule {
	if page.lborlr.IsEmpty() {
		return nil
	}
	return *page.lborlr.Value
}

// Creates a new instance of the LoadBalancerOutboundRuleListResultPage type.
func NewLoadBalancerOutboundRuleListResultPage(cur LoadBalancerOutboundRuleListResult, getNextPage func(context.Context, LoadBalancerOutboundRuleListResult) (LoadBalancerOutboundRuleListResult, error)) LoadBalancerOutboundRuleListResultPage {
	return LoadBalancerOutboundRuleListResultPage{
		fn:     getNextPage,
		lborlr: cur,
	}
}

// LoadBalancerProbeListResult response for ListProbe API service call.
type LoadBalancerProbeListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of probes in a load balancer.
	Value *[]Probe `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancerProbeListResult.
func (lbplr LoadBalancerProbeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbplr.Value != nil {
		objectMap["value"] = lbplr.Value
	}
	return json.Marshal(objectMap)
}

// LoadBalancerProbeListResultIterator provides access to a complete listing of Probe values.
type LoadBalancerProbeListResultIterator struct {
	i    int
	page LoadBalancerProbeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerProbeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerProbeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerProbeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerProbeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerProbeListResultIterator) Response() LoadBalancerProbeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerProbeListResultIterator) Value() Probe {
	if !iter.page.NotDone() {
		return Probe{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerProbeListResultIterator type.
func NewLoadBalancerProbeListResultIterator(page LoadBalancerProbeListResultPage) LoadBalancerProbeListResultIterator {
	return LoadBalancerProbeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lbplr LoadBalancerProbeListResult) IsEmpty() bool {
	return lbplr.Value == nil || len(*lbplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lbplr LoadBalancerProbeListResult) hasNextLink() bool {
	return lbplr.NextLink != nil && len(*lbplr.NextLink) != 0
}

// loadBalancerProbeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lbplr LoadBalancerProbeListResult) loadBalancerProbeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lbplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lbplr.NextLink)))
}

// LoadBalancerProbeListResultPage contains a page of Probe values.
type LoadBalancerProbeListResultPage struct {
	fn    func(context.Context, LoadBalancerProbeListResult) (LoadBalancerProbeListResult, error)
	lbplr LoadBalancerProbeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerProbeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerProbeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lbplr)
		if err != nil {
			return err
		}
		page.lbplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerProbeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerProbeListResultPage) NotDone() bool {
	return !page.lbplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerProbeListResultPage) Response() LoadBalancerProbeListResult {
	return page.lbplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerProbeListResultPage) Values() []Probe {
	if page.lbplr.IsEmpty() {
		return nil
	}
	return *page.lbplr.Value
}

// Creates a new instance of the LoadBalancerProbeListResultPage type.
func NewLoadBalancerProbeListResultPage(cur LoadBalancerProbeListResult, getNextPage func(context.Context, LoadBalancerProbeListResult) (LoadBalancerProbeListResult, error)) LoadBalancerProbeListResultPage {
	return LoadBalancerProbeListResultPage{
		fn:    getNextPage,
		lbplr: cur,
	}
}

// LoadBalancerPropertiesFormat properties of the load balancer.
type LoadBalancerPropertiesFormat struct {
	// FrontendIPConfigurations - Object representing the frontend IPs to be used for the load balancer.
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPools - Collection of backend address pools used by a load balancer.
	BackendAddressPools *[]BackendAddressPool `json:"backendAddressPools,omitempty"`
	// LoadBalancingRules - Object collection representing the load balancing rules Gets the provisioning.
	LoadBalancingRules *[]LoadBalancingRule `json:"loadBalancingRules,omitempty"`
	// Probes - Collection of probe objects used in the load balancer.
	Probes *[]Probe `json:"probes,omitempty"`
	// InboundNatRules - Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
	InboundNatPools *[]InboundNatPool `json:"inboundNatPools,omitempty"`
	// OutboundRules - The outbound rules.
	OutboundRules *[]OutboundRule `json:"outboundRules,omitempty"`
	// ResourceGUID - The resource GUID property of the load balancer resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the load balancer resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// LoadBalancersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LoadBalancersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LoadBalancersClient) (LoadBalancer, error)
}

// LoadBalancersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LoadBalancersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LoadBalancersClient) (autorest.Response, error)
}

// LoadBalancerSku SKU of a load balancer.
type LoadBalancerSku struct {
	// Name - Name of a load balancer SKU. Possible values include: 'LoadBalancerSkuNameBasic', 'LoadBalancerSkuNameStandard'
	Name LoadBalancerSkuName `json:"name,omitempty"`
}

// LoadBalancersUpdateTagsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LoadBalancersUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LoadBalancersClient) (LoadBalancer, error)
}

// LoadBalancingRule a load balancing rule for a load balancer.
type LoadBalancingRule struct {
	autorest.Response `json:"-"`
	// LoadBalancingRulePropertiesFormat - Properties of load balancer load balancing rule.
	*LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancingRule.
func (lbr LoadBalancingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbr.LoadBalancingRulePropertiesFormat != nil {
		objectMap["properties"] = lbr.LoadBalancingRulePropertiesFormat
	}
	if lbr.Name != nil {
		objectMap["name"] = lbr.Name
	}
	if lbr.Etag != nil {
		objectMap["etag"] = lbr.Etag
	}
	if lbr.ID != nil {
		objectMap["id"] = lbr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancingRule struct.
func (lbr *LoadBalancingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancingRulePropertiesFormat LoadBalancingRulePropertiesFormat
				err = json.Unmarshal(*v, &loadBalancingRulePropertiesFormat)
				if err != nil {
					return err
				}
				lbr.LoadBalancingRulePropertiesFormat = &loadBalancingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lbr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lbr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lbr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lbr.ID = &ID
			}
		}
	}

	return nil
}

// LoadBalancingRulePropertiesFormat properties of the load balancer.
type LoadBalancingRulePropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendAddressPool - A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// Probe - The reference of the load balancer probe used by the load balancing rule.
	Probe *SubResource `json:"probe,omitempty"`
	// Protocol - The reference to the transport protocol used by the load balancing rule. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP', 'TransportProtocolAll'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// LoadDistribution - The load distribution policy for this rule. Possible values include: 'LoadDistributionDefault', 'LoadDistributionSourceIP', 'LoadDistributionSourceIPProtocol'
	LoadDistribution LoadDistribution `json:"loadDistribution,omitempty"`
	// FrontendPort - The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// EnableTCPReset - Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`
	// DisableOutboundSnat - Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
	DisableOutboundSnat *bool `json:"disableOutboundSnat,omitempty"`
	// ProvisioningState - The provisioning state of the load balancing rule resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway a common class for general resource information.
type LocalNetworkGateway struct {
	autorest.Response `json:"-"`
	// LocalNetworkGatewayPropertiesFormat - Properties of the local network gateway.
	*LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LocalNetworkGateway.
func (lng LocalNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lng.LocalNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = lng.LocalNetworkGatewayPropertiesFormat
	}
	if lng.Etag != nil {
		objectMap["etag"] = lng.Etag
	}
	if lng.ID != nil {
		objectMap["id"] = lng.ID
	}
	if lng.Location != nil {
		objectMap["location"] = lng.Location
	}
	if lng.Tags != nil {
		objectMap["tags"] = lng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LocalNetworkGateway struct.
func (lng *LocalNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var localNetworkGatewayPropertiesFormat LocalNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &localNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				lng.LocalNetworkGatewayPropertiesFormat = &localNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lng.Tags = tags
			}
		}
	}

	return nil
}

// LocalNetworkGatewayListResult response for ListLocalNetworkGateways API service call.
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of local network gateways that exists in a resource group.
	Value *[]LocalNetworkGateway `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalNetworkGatewayListResult.
func (lnglr LocalNetworkGatewayListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lnglr.Value != nil {
		objectMap["value"] = lnglr.Value
	}
	return json.Marshal(objectMap)
}

// LocalNetworkGatewayListResultIterator provides access to a complete listing of LocalNetworkGateway
// values.
type LocalNetworkGatewayListResultIterator struct {
	i    int
	page LocalNetworkGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocalNetworkGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocalNetworkGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LocalNetworkGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocalNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LocalNetworkGatewayListResultIterator) Response() LocalNetworkGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocalNetworkGatewayListResultIterator) Value() LocalNetworkGateway {
	if !iter.page.NotDone() {
		return LocalNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LocalNetworkGatewayListResultIterator type.
func NewLocalNetworkGatewayListResultIterator(page LocalNetworkGatewayListResultPage) LocalNetworkGatewayListResultIterator {
	return LocalNetworkGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lnglr LocalNetworkGatewayListResult) IsEmpty() bool {
	return lnglr.Value == nil || len(*lnglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lnglr LocalNetworkGatewayListResult) hasNextLink() bool {
	return lnglr.NextLink != nil && len(*lnglr.NextLink) != 0
}

// localNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnglr LocalNetworkGatewayListResult) localNetworkGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lnglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnglr.NextLink)))
}

// LocalNetworkGatewayListResultPage contains a page of LocalNetworkGateway values.
type LocalNetworkGatewayListResultPage struct {
	fn    func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)
	lnglr LocalNetworkGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocalNetworkGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocalNetworkGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lnglr)
		if err != nil {
			return err
		}
		page.lnglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LocalNetworkGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocalNetworkGatewayListResultPage) NotDone() bool {
	return !page.lnglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LocalNetworkGatewayListResultPage) Response() LocalNetworkGatewayListResult {
	return page.lnglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LocalNetworkGatewayListResultPage) Values() []LocalNetworkGateway {
	if page.lnglr.IsEmpty() {
		return nil
	}
	return *page.lnglr.Value
}

// Creates a new instance of the LocalNetworkGatewayListResultPage type.
func NewLocalNetworkGatewayListResultPage(cur LocalNetworkGatewayListResult, getNextPage func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)) LocalNetworkGatewayListResultPage {
	return LocalNetworkGatewayListResultPage{
		fn:    getNextPage,
		lnglr: cur,
	}
}

// LocalNetworkGatewayPropertiesFormat localNetworkGateway properties.
type LocalNetworkGatewayPropertiesFormat struct {
	// LocalNetworkAddressSpace - Local network site address space.
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	// GatewayIPAddress - IP address of local network gateway.
	GatewayIPAddress *string `json:"gatewayIpAddress,omitempty"`
	// BgpSettings - Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`
	// ResourceGUID - The resource GUID property of the local network gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the local network gateway resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalNetworkGatewayPropertiesFormat.
func (lngpf LocalNetworkGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lngpf.LocalNetworkAddressSpace != nil {
		objectMap["localNetworkAddressSpace"] = lngpf.LocalNetworkAddressSpace
	}
	if lngpf.GatewayIPAddress != nil {
		objectMap["gatewayIpAddress"] = lngpf.GatewayIPAddress
	}
	if lngpf.BgpSettings != nil {
		objectMap["bgpSettings"] = lngpf.BgpSettings
	}
	if lngpf.ResourceGUID != nil {
		objectMap["resourceGuid"] = lngpf.ResourceGUID
	}
	return json.Marshal(objectMap)
}

// LocalNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LocalNetworkGatewaysClient) (LocalNetworkGateway, error)
}

// LocalNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LocalNetworkGatewaysClient) (autorest.Response, error)
}

// LocalNetworkGatewaysUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LocalNetworkGatewaysClient) (LocalNetworkGateway, error)
}

// LogSpecification description of logging specification.
type LogSpecification struct {
	// Name - The name of the specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the specification.
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Duration of the blob.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagedServiceIdentity identity for the resource.
type ManagedServiceIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the system assigned identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedServiceIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedServiceIdentity.
func (msi ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msi.Type != "" {
		objectMap["type"] = msi.Type
	}
	if msi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = msi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ManagedServiceIdentityUserAssignedIdentitiesValue ...
type ManagedServiceIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MatchCondition define match conditions.
type MatchCondition struct {
	// MatchVariables - List of match variables.
	MatchVariables *[]MatchVariable `json:"matchVariables,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'WebApplicationFirewallOperatorIPMatch', 'WebApplicationFirewallOperatorEqual', 'WebApplicationFirewallOperatorContains', 'WebApplicationFirewallOperatorLessThan', 'WebApplicationFirewallOperatorGreaterThan', 'WebApplicationFirewallOperatorLessThanOrEqual', 'WebApplicationFirewallOperatorGreaterThanOrEqual', 'WebApplicationFirewallOperatorBeginsWith', 'WebApplicationFirewallOperatorEndsWith', 'WebApplicationFirewallOperatorRegex'
	Operator WebApplicationFirewallOperator `json:"operator,omitempty"`
	// NegationConditon - Describes if this is negate condition or not.
	NegationConditon *bool `json:"negationConditon,omitempty"`
	// MatchValues - Match value.
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms.
	Transforms *[]WebApplicationFirewallTransform `json:"transforms,omitempty"`
}

// MatchedRule matched rule.
type MatchedRule struct {
	// RuleName - Name of the matched network security rule.
	RuleName *string `json:"ruleName,omitempty"`
	// Action - The network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'.
	Action *string `json:"action,omitempty"`
}

// MatchVariable define match variables.
type MatchVariable struct {
	// VariableName - Match Variable. Possible values include: 'RemoteAddr', 'RequestMethod', 'QueryString', 'PostArgs', 'RequestURI', 'RequestHeaders', 'RequestBody', 'RequestCookies'
	VariableName WebApplicationFirewallMatchVariable `json:"variableName,omitempty"`
	// Selector - Describes field of the matchVariable collection.
	Selector *string `json:"selector,omitempty"`
}

// MetricSpecification description of metrics specification.
type MetricSpecification struct {
	// Name - The name of the metric.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - The description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Units the metric to be displayed in.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - The aggregation type.
	AggregationType *string `json:"aggregationType,omitempty"`
	// Availabilities - List of availability.
	Availabilities *[]Availability `json:"availabilities,omitempty"`
	// EnableRegionalMdmAccount - Whether regional MDM account enabled.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`
	// FillGapWithZero - Whether gaps would be filled with zeros.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// MetricFilterPattern - Pattern for the filter of the metric.
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`
	// Dimensions - List of dimensions.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// IsInternal - Whether the metric is internal.
	IsInternal *bool `json:"isInternal,omitempty"`
	// SourceMdmAccount - The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// SourceMdmNamespace - The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
	// ResourceIDDimensionNameOverride - The resource Id dimension name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
}

// NatGateway nat Gateway resource.
type NatGateway struct {
	autorest.Response `json:"-"`
	// Sku - The nat gateway SKU.
	Sku *NatGatewaySku `json:"sku,omitempty"`
	// NatGatewayPropertiesFormat - Nat Gateway properties.
	*NatGatewayPropertiesFormat `json:"properties,omitempty"`
	// Zones - A list of availability zones denoting the zone in which Nat Gateway should be deployed.
	Zones *[]string `json:"zones,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for NatGateway.
func (ng NatGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ng.Sku != nil {
		objectMap["sku"] = ng.Sku
	}
	if ng.NatGatewayPropertiesFormat != nil {
		objectMap["properties"] = ng.NatGatewayPropertiesFormat
	}
	if ng.Zones != nil {
		objectMap["zones"] = ng.Zones
	}
	if ng.Etag != nil {
		objectMap["etag"] = ng.Etag
	}
	if ng.ID != nil {
		objectMap["id"] = ng.ID
	}
	if ng.Location != nil {
		objectMap["location"] = ng.Location
	}
	if ng.Tags != nil {
		objectMap["tags"] = ng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NatGateway struct.
func (ng *NatGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku NatGatewaySku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ng.Sku = &sku
			}
		case "properties":
			if v != nil {
				var natGatewayPropertiesFormat NatGatewayPropertiesFormat
				err = json.Unmarshal(*v, &natGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				ng.NatGatewayPropertiesFormat = &natGatewayPropertiesFormat
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				ng.Zones = &zones
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ng.Tags = tags
			}
		}
	}

	return nil
}

// NatGatewayListResult response for ListNatGateways API service call.
type NatGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of Nat Gateways that exists in a resource group.
	Value *[]NatGateway `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// NatGatewayListResultIterator provides access to a complete listing of NatGateway values.
type NatGatewayListResultIterator struct {
	i    int
	page NatGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NatGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NatGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NatGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NatGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NatGatewayListResultIterator) Response() NatGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NatGatewayListResultIterator) Value() NatGateway {
	if !iter.page.NotDone() {
		return NatGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NatGatewayListResultIterator type.
func NewNatGatewayListResultIterator(page NatGatewayListResultPage) NatGatewayListResultIterator {
	return NatGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nglr NatGatewayListResult) IsEmpty() bool {
	return nglr.Value == nil || len(*nglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nglr NatGatewayListResult) hasNextLink() bool {
	return nglr.NextLink != nil && len(*nglr.NextLink) != 0
}

// natGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nglr NatGatewayListResult) natGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nglr.NextLink)))
}

// NatGatewayListResultPage contains a page of NatGateway values.
type NatGatewayListResultPage struct {
	fn   func(context.Context, NatGatewayListResult) (NatGatewayListResult, error)
	nglr NatGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NatGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NatGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nglr)
		if err != nil {
			return err
		}
		page.nglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NatGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NatGatewayListResultPage) NotDone() bool {
	return !page.nglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NatGatewayListResultPage) Response() NatGatewayListResult {
	return page.nglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NatGatewayListResultPage) Values() []NatGateway {
	if page.nglr.IsEmpty() {
		return nil
	}
	return *page.nglr.Value
}

// Creates a new instance of the NatGatewayListResultPage type.
func NewNatGatewayListResultPage(cur NatGatewayListResult, getNextPage func(context.Context, NatGatewayListResult) (NatGatewayListResult, error)) NatGatewayListResultPage {
	return NatGatewayListResultPage{
		fn:   getNextPage,
		nglr: cur,
	}
}

// NatGatewayPropertiesFormat nat Gateway properties.
type NatGatewayPropertiesFormat struct {
	// IdleTimeoutInMinutes - The idle timeout of the nat gateway.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// PublicIPAddresses - An array of public ip addresses associated with the nat gateway resource.
	PublicIPAddresses *[]SubResource `json:"publicIpAddresses,omitempty"`
	// PublicIPPrefixes - An array of public ip prefixes associated with the nat gateway resource.
	PublicIPPrefixes *[]SubResource `json:"publicIpPrefixes,omitempty"`
	// Subnets - READ-ONLY; An array of references to the subnets using this nat gateway resource.
	Subnets *[]SubResource `json:"subnets,omitempty"`
	// ResourceGUID - The resource GUID property of the NAT gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the NAT gateway resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for NatGatewayPropertiesFormat.
func (ngpf NatGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ngpf.IdleTimeoutInMinutes != nil {
		objectMap["idleTimeoutInMinutes"] = ngpf.IdleTimeoutInMinutes
	}
	if ngpf.PublicIPAddresses != nil {
		objectMap["publicIpAddresses"] = ngpf.PublicIPAddresses
	}
	if ngpf.PublicIPPrefixes != nil {
		objectMap["publicIpPrefixes"] = ngpf.PublicIPPrefixes
	}
	if ngpf.ResourceGUID != nil {
		objectMap["resourceGuid"] = ngpf.ResourceGUID
	}
	if ngpf.ProvisioningState != "" {
		objectMap["provisioningState"] = ngpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// NatGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NatGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NatGatewaysClient) (NatGateway, error)
}

// NatGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NatGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NatGatewaysClient) (autorest.Response, error)
}

// NatGatewaySku SKU of nat gateway.
type NatGatewaySku struct {
	// Name - Name of Nat Gateway SKU. Possible values include: 'Standard'
	Name NatGatewaySkuName `json:"name,omitempty"`
}

// NextHopParameters parameters that define the source and destination endpoint.
type NextHopParameters struct {
	// TargetResourceID - The resource identifier of the target resource against which the action is to be performed.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// SourceIPAddress - The source IP address.
	SourceIPAddress *string `json:"sourceIPAddress,omitempty"`
	// DestinationIPAddress - The destination IP address.
	DestinationIPAddress *string `json:"destinationIPAddress,omitempty"`
	// TargetNicResourceID - The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be specified. Otherwise optional).
	TargetNicResourceID *string `json:"targetNicResourceId,omitempty"`
}

// NextHopResult the information about next hop from the specified VM.
type NextHopResult struct {
	autorest.Response `json:"-"`
	// NextHopType - Next hop type. Possible values include: 'NextHopTypeInternet', 'NextHopTypeVirtualAppliance', 'NextHopTypeVirtualNetworkGateway', 'NextHopTypeVnetLocal', 'NextHopTypeHyperNetGateway', 'NextHopTypeNone'
	NextHopType NextHopType `json:"nextHopType,omitempty"`
	// NextHopIPAddress - Next hop IP Address.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
	// RouteTableID - The resource identifier for the route table associated with the route being returned. If the route being returned does not correspond to any user created routes then this field will be the string 'System Route'.
	RouteTableID *string `json:"routeTableId,omitempty"`
}

// Operation network REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// OperationPropertiesFormat - Operation properties format.
	*OperationPropertiesFormat `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationPropertiesFormat != nil {
		objectMap["properties"] = o.OperationPropertiesFormat
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationPropertiesFormat OperationPropertiesFormat
				err = json.Unmarshal(*v, &operationPropertiesFormat)
				if err != nil {
					return err
				}
				o.OperationPropertiesFormat = &operationPropertiesFormat
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Network.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of the operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Network operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Network operations supported by the Network resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationPropertiesFormat description of operation properties format.
type OperationPropertiesFormat struct {
	// ServiceSpecification - Specification of the service.
	ServiceSpecification *OperationPropertiesFormatServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationPropertiesFormatServiceSpecification specification of the service.
type OperationPropertiesFormatServiceSpecification struct {
	// MetricSpecifications - Operation service specification.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
	// LogSpecifications - Operation log specification.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
}

// OutboundRule outbound rule of the load balancer.
type OutboundRule struct {
	autorest.Response `json:"-"`
	// OutboundRulePropertiesFormat - Properties of load balancer outbound rule.
	*OutboundRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundRule.
func (or OutboundRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.OutboundRulePropertiesFormat != nil {
		objectMap["properties"] = or.OutboundRulePropertiesFormat
	}
	if or.Name != nil {
		objectMap["name"] = or.Name
	}
	if or.Etag != nil {
		objectMap["etag"] = or.Etag
	}
	if or.ID != nil {
		objectMap["id"] = or.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OutboundRule struct.
func (or *OutboundRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outboundRulePropertiesFormat OutboundRulePropertiesFormat
				err = json.Unmarshal(*v, &outboundRulePropertiesFormat)
				if err != nil {
					return err
				}
				or.OutboundRulePropertiesFormat = &outboundRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				or.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				or.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				or.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				or.ID = &ID
			}
		}
	}

	return nil
}

// OutboundRulePropertiesFormat outbound rule of the load balancer.
type OutboundRulePropertiesFormat struct {
	// AllocatedOutboundPorts - The number of outbound ports to be used for NAT.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`
	// FrontendIPConfigurations - The Frontend IP addresses of the load balancer.
	FrontendIPConfigurations *[]SubResource `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPool - A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// ProvisioningState - The provisioning state of the outbound rule resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Protocol - The protocol for the outbound rule in load balancer. Possible values include: 'LoadBalancerOutboundRuleProtocolTCP', 'LoadBalancerOutboundRuleProtocolUDP', 'LoadBalancerOutboundRuleProtocolAll'
	Protocol LoadBalancerOutboundRuleProtocol `json:"protocol,omitempty"`
	// EnableTCPReset - Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
}

// P2SVpnGateway p2SVpnGateway Resource.
type P2SVpnGateway struct {
	autorest.Response `json:"-"`
	// P2SVpnGatewayProperties - Properties of the P2SVpnGateway.
	*P2SVpnGatewayProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for P2SVpnGateway.
func (pvg P2SVpnGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvg.P2SVpnGatewayProperties != nil {
		objectMap["properties"] = pvg.P2SVpnGatewayProperties
	}
	if pvg.ID != nil {
		objectMap["id"] = pvg.ID
	}
	if pvg.Location != nil {
		objectMap["location"] = pvg.Location
	}
	if pvg.Tags != nil {
		objectMap["tags"] = pvg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for P2SVpnGateway struct.
func (pvg *P2SVpnGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var p2SVpnGatewayProperties P2SVpnGatewayProperties
				err = json.Unmarshal(*v, &p2SVpnGatewayProperties)
				if err != nil {
					return err
				}
				pvg.P2SVpnGatewayProperties = &p2SVpnGatewayProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pvg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pvg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pvg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pvg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pvg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pvg.Tags = tags
			}
		}
	}

	return nil
}

// P2SVpnGatewayProperties parameters for P2SVpnGateway.
type P2SVpnGatewayProperties struct {
	// VirtualHub - The VirtualHub to which the gateway belongs.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`
	// ProvisioningState - The provisioning state of the P2S VPN gateway resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VpnGatewayScaleUnit - The scale unit for this p2s vpn gateway.
	VpnGatewayScaleUnit *int32 `json:"vpnGatewayScaleUnit,omitempty"`
	// P2SVpnServerConfiguration - The P2SVpnServerConfiguration to which the p2sVpnGateway is attached to.
	P2SVpnServerConfiguration *SubResource `json:"p2SVpnServerConfiguration,omitempty"`
	// VpnClientAddressPool - The reference of the address space resource which represents Address space for P2S VpnClient.
	VpnClientAddressPool *AddressSpace `json:"vpnClientAddressPool,omitempty"`
	// CustomRoutes - The reference of the address space resource which represents the custom routes specified by the customer for P2SVpnGateway and P2S VpnClient.
	CustomRoutes *AddressSpace `json:"customRoutes,omitempty"`
	// VpnClientConnectionHealth - READ-ONLY; All P2S VPN clients' connection health status.
	VpnClientConnectionHealth *VpnClientConnectionHealth `json:"vpnClientConnectionHealth,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnGatewayProperties.
func (pvgp P2SVpnGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvgp.VirtualHub != nil {
		objectMap["virtualHub"] = pvgp.VirtualHub
	}
	if pvgp.ProvisioningState != "" {
		objectMap["provisioningState"] = pvgp.ProvisioningState
	}
	if pvgp.VpnGatewayScaleUnit != nil {
		objectMap["vpnGatewayScaleUnit"] = pvgp.VpnGatewayScaleUnit
	}
	if pvgp.P2SVpnServerConfiguration != nil {
		objectMap["p2SVpnServerConfiguration"] = pvgp.P2SVpnServerConfiguration
	}
	if pvgp.VpnClientAddressPool != nil {
		objectMap["vpnClientAddressPool"] = pvgp.VpnClientAddressPool
	}
	if pvgp.CustomRoutes != nil {
		objectMap["customRoutes"] = pvgp.CustomRoutes
	}
	return json.Marshal(objectMap)
}

// P2sVpnGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type P2sVpnGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(P2sVpnGatewaysClient) (P2SVpnGateway, error)
}

// P2sVpnGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type P2sVpnGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(P2sVpnGatewaysClient) (autorest.Response, error)
}

// P2sVpnGatewaysGenerateVpnProfileFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type P2sVpnGatewaysGenerateVpnProfileFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(P2sVpnGatewaysClient) (VpnProfileResponse, error)
}

// P2sVpnGatewaysGetP2sVpnConnectionHealthFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type P2sVpnGatewaysGetP2sVpnConnectionHealthFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(P2sVpnGatewaysClient) (P2SVpnGateway, error)
}

// P2sVpnGatewaysUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type P2sVpnGatewaysUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(P2sVpnGatewaysClient) (P2SVpnGateway, error)
}

// P2SVpnProfileParameters vpn Client Parameters for package generation.
type P2SVpnProfileParameters struct {
	// AuthenticationMethod - VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
	AuthenticationMethod AuthenticationMethod `json:"authenticationMethod,omitempty"`
}

// P2SVpnServerConfigRadiusClientRootCertificate radius client root certificate of
// P2SVpnServerConfiguration.
type P2SVpnServerConfigRadiusClientRootCertificate struct {
	// P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat - Properties of the Radius client root certificate.
	*P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigRadiusClientRootCertificate.
func (pvscrcrc P2SVpnServerConfigRadiusClientRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscrcrc.P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = pvscrcrc.P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat
	}
	if pvscrcrc.Name != nil {
		objectMap["name"] = pvscrcrc.Name
	}
	if pvscrcrc.Etag != nil {
		objectMap["etag"] = pvscrcrc.Etag
	}
	if pvscrcrc.ID != nil {
		objectMap["id"] = pvscrcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for P2SVpnServerConfigRadiusClientRootCertificate struct.
func (pvscrcrc *P2SVpnServerConfigRadiusClientRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var p2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &p2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				pvscrcrc.P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat = &p2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pvscrcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pvscrcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pvscrcrc.ID = &ID
			}
		}
	}

	return nil
}

// P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat properties of the Radius client root
// certificate of P2SVpnServerConfiguration.
type P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat struct {
	// Thumbprint - The Radius client root certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the radius client root certificate resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat.
func (pvscrcrcpf P2SVpnServerConfigRadiusClientRootCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscrcrcpf.Thumbprint != nil {
		objectMap["thumbprint"] = pvscrcrcpf.Thumbprint
	}
	return json.Marshal(objectMap)
}

// P2SVpnServerConfigRadiusServerRootCertificate radius Server root certificate of
// P2SVpnServerConfiguration.
type P2SVpnServerConfigRadiusServerRootCertificate struct {
	// P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat - Properties of the P2SVpnServerConfiguration Radius Server root certificate.
	*P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigRadiusServerRootCertificate.
func (pvscrsrc P2SVpnServerConfigRadiusServerRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscrsrc.P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = pvscrsrc.P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat
	}
	if pvscrsrc.Name != nil {
		objectMap["name"] = pvscrsrc.Name
	}
	if pvscrsrc.Etag != nil {
		objectMap["etag"] = pvscrsrc.Etag
	}
	if pvscrsrc.ID != nil {
		objectMap["id"] = pvscrsrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for P2SVpnServerConfigRadiusServerRootCertificate struct.
func (pvscrsrc *P2SVpnServerConfigRadiusServerRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var p2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &p2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				pvscrsrc.P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat = &p2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pvscrsrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pvscrsrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pvscrsrc.ID = &ID
			}
		}
	}

	return nil
}

// P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat properties of Radius Server root
// certificate of P2SVpnServerConfiguration.
type P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat struct {
	// PublicCertData - The certificate public data.
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the radius server root certificate resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat.
func (pvscrsrcpf P2SVpnServerConfigRadiusServerRootCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscrsrcpf.PublicCertData != nil {
		objectMap["publicCertData"] = pvscrsrcpf.PublicCertData
	}
	return json.Marshal(objectMap)
}

// P2SVpnServerConfiguration p2SVpnServerConfiguration Resource.
type P2SVpnServerConfiguration struct {
	autorest.Response `json:"-"`
	// P2SVpnServerConfigurationProperties - Properties of the P2SVpnServer configuration.
	*P2SVpnServerConfigurationProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfiguration.
func (pvsc P2SVpnServerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvsc.P2SVpnServerConfigurationProperties != nil {
		objectMap["properties"] = pvsc.P2SVpnServerConfigurationProperties
	}
	if pvsc.Name != nil {
		objectMap["name"] = pvsc.Name
	}
	if pvsc.ID != nil {
		objectMap["id"] = pvsc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for P2SVpnServerConfiguration struct.
func (pvsc *P2SVpnServerConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var p2SVpnServerConfigurationProperties P2SVpnServerConfigurationProperties
				err = json.Unmarshal(*v, &p2SVpnServerConfigurationProperties)
				if err != nil {
					return err
				}
				pvsc.P2SVpnServerConfigurationProperties = &p2SVpnServerConfigurationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pvsc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pvsc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pvsc.ID = &ID
			}
		}
	}

	return nil
}

// P2SVpnServerConfigurationProperties parameters for P2SVpnServerConfiguration.
type P2SVpnServerConfigurationProperties struct {
	// Name - The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Paren VirtualWan resource name.
	Name *string `json:"name,omitempty"`
	// VpnProtocols - VPN protocols for the P2SVpnServerConfiguration.
	VpnProtocols *[]VpnGatewayTunnelingProtocol `json:"vpnProtocols,omitempty"`
	// P2SVpnServerConfigVpnClientRootCertificates - VPN client root certificate of P2SVpnServerConfiguration.
	P2SVpnServerConfigVpnClientRootCertificates *[]P2SVpnServerConfigVpnClientRootCertificate `json:"p2SVpnServerConfigVpnClientRootCertificates,omitempty"`
	// P2SVpnServerConfigVpnClientRevokedCertificates - VPN client revoked certificate of P2SVpnServerConfiguration.
	P2SVpnServerConfigVpnClientRevokedCertificates *[]P2SVpnServerConfigVpnClientRevokedCertificate `json:"p2SVpnServerConfigVpnClientRevokedCertificates,omitempty"`
	// P2SVpnServerConfigRadiusServerRootCertificates - Radius Server root certificate of P2SVpnServerConfiguration.
	P2SVpnServerConfigRadiusServerRootCertificates *[]P2SVpnServerConfigRadiusServerRootCertificate `json:"p2SVpnServerConfigRadiusServerRootCertificates,omitempty"`
	// P2SVpnServerConfigRadiusClientRootCertificates - Radius client root certificate of P2SVpnServerConfiguration.
	P2SVpnServerConfigRadiusClientRootCertificates *[]P2SVpnServerConfigRadiusClientRootCertificate `json:"p2SVpnServerConfigRadiusClientRootCertificates,omitempty"`
	// VpnClientIpsecPolicies - VpnClientIpsecPolicies for P2SVpnServerConfiguration.
	VpnClientIpsecPolicies *[]IpsecPolicy `json:"vpnClientIpsecPolicies,omitempty"`
	// RadiusServerAddress - The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
	RadiusServerAddress *string `json:"radiusServerAddress,omitempty"`
	// RadiusServerSecret - The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
	RadiusServerSecret *string `json:"radiusServerSecret,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the P2S VPN server configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// P2SVpnGateways - READ-ONLY; List of references to P2SVpnGateways.
	P2SVpnGateways *[]SubResource `json:"p2SVpnGateways,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigurationProperties.
func (pvscp P2SVpnServerConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscp.Name != nil {
		objectMap["name"] = pvscp.Name
	}
	if pvscp.VpnProtocols != nil {
		objectMap["vpnProtocols"] = pvscp.VpnProtocols
	}
	if pvscp.P2SVpnServerConfigVpnClientRootCertificates != nil {
		objectMap["p2SVpnServerConfigVpnClientRootCertificates"] = pvscp.P2SVpnServerConfigVpnClientRootCertificates
	}
	if pvscp.P2SVpnServerConfigVpnClientRevokedCertificates != nil {
		objectMap["p2SVpnServerConfigVpnClientRevokedCertificates"] = pvscp.P2SVpnServerConfigVpnClientRevokedCertificates
	}
	if pvscp.P2SVpnServerConfigRadiusServerRootCertificates != nil {
		objectMap["p2SVpnServerConfigRadiusServerRootCertificates"] = pvscp.P2SVpnServerConfigRadiusServerRootCertificates
	}
	if pvscp.P2SVpnServerConfigRadiusClientRootCertificates != nil {
		objectMap["p2SVpnServerConfigRadiusClientRootCertificates"] = pvscp.P2SVpnServerConfigRadiusClientRootCertificates
	}
	if pvscp.VpnClientIpsecPolicies != nil {
		objectMap["vpnClientIpsecPolicies"] = pvscp.VpnClientIpsecPolicies
	}
	if pvscp.RadiusServerAddress != nil {
		objectMap["radiusServerAddress"] = pvscp.RadiusServerAddress
	}
	if pvscp.RadiusServerSecret != nil {
		objectMap["radiusServerSecret"] = pvscp.RadiusServerSecret
	}
	if pvscp.Etag != nil {
		objectMap["etag"] = pvscp.Etag
	}
	return json.Marshal(objectMap)
}

// P2sVpnServerConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type P2sVpnServerConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(P2sVpnServerConfigurationsClient) (P2SVpnServerConfiguration, error)
}

// P2sVpnServerConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type P2sVpnServerConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(P2sVpnServerConfigurationsClient) (autorest.Response, error)
}

// P2SVpnServerConfigVpnClientRevokedCertificate VPN client revoked certificate of
// P2SVpnServerConfiguration.
type P2SVpnServerConfigVpnClientRevokedCertificate struct {
	// P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat - Properties of the vpn client revoked certificate.
	*P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigVpnClientRevokedCertificate.
func (pvscvcrc P2SVpnServerConfigVpnClientRevokedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscvcrc.P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat != nil {
		objectMap["properties"] = pvscvcrc.P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat
	}
	if pvscvcrc.Name != nil {
		objectMap["name"] = pvscvcrc.Name
	}
	if pvscvcrc.Etag != nil {
		objectMap["etag"] = pvscvcrc.Etag
	}
	if pvscvcrc.ID != nil {
		objectMap["id"] = pvscvcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for P2SVpnServerConfigVpnClientRevokedCertificate struct.
func (pvscvcrc *P2SVpnServerConfigVpnClientRevokedCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var p2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat
				err = json.Unmarshal(*v, &p2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				pvscvcrc.P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat = &p2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pvscvcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pvscvcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pvscvcrc.ID = &ID
			}
		}
	}

	return nil
}

// P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat properties of the revoked VPN client
// certificate of P2SVpnServerConfiguration.
type P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat struct {
	// Thumbprint - The revoked VPN client certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the VPN client revoked certificate resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat.
func (pvscvcrcpf P2SVpnServerConfigVpnClientRevokedCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscvcrcpf.Thumbprint != nil {
		objectMap["thumbprint"] = pvscvcrcpf.Thumbprint
	}
	return json.Marshal(objectMap)
}

// P2SVpnServerConfigVpnClientRootCertificate VPN client root certificate of P2SVpnServerConfiguration.
type P2SVpnServerConfigVpnClientRootCertificate struct {
	// P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat - Properties of the P2SVpnServerConfiguration VPN client root certificate.
	*P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigVpnClientRootCertificate.
func (pvscvcrc P2SVpnServerConfigVpnClientRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscvcrc.P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = pvscvcrc.P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat
	}
	if pvscvcrc.Name != nil {
		objectMap["name"] = pvscvcrc.Name
	}
	if pvscvcrc.Etag != nil {
		objectMap["etag"] = pvscvcrc.Etag
	}
	if pvscvcrc.ID != nil {
		objectMap["id"] = pvscvcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for P2SVpnServerConfigVpnClientRootCertificate struct.
func (pvscvcrc *P2SVpnServerConfigVpnClientRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var p2SVpnServerConfigVpnClientRootCertificatePropertiesFormat P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &p2SVpnServerConfigVpnClientRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				pvscvcrc.P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat = &p2SVpnServerConfigVpnClientRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pvscvcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pvscvcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pvscvcrc.ID = &ID
			}
		}
	}

	return nil
}

// P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat properties of VPN client root certificate of
// P2SVpnServerConfiguration.
type P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat struct {
	// PublicCertData - The certificate public data.
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the VPN client root certificate resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat.
func (pvscvcrcpf P2SVpnServerConfigVpnClientRootCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pvscvcrcpf.PublicCertData != nil {
		objectMap["publicCertData"] = pvscvcrcpf.PublicCertData
	}
	return json.Marshal(objectMap)
}

// PacketCapture parameters that define the create packet capture operation.
type PacketCapture struct {
	// PacketCaptureParameters - Properties of the packet capture.
	*PacketCaptureParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PacketCapture.
func (pc PacketCapture) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.PacketCaptureParameters != nil {
		objectMap["properties"] = pc.PacketCaptureParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PacketCapture struct.
func (pc *PacketCapture) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var packetCaptureParameters PacketCaptureParameters
				err = json.Unmarshal(*v, &packetCaptureParameters)
				if err != nil {
					return err
				}
				pc.PacketCaptureParameters = &packetCaptureParameters
			}
		}
	}

	return nil
}

// PacketCaptureFilter filter that is applied to packet capture request. Multiple filters can be applied.
type PacketCaptureFilter struct {
	// Protocol - Protocol to be filtered on. Possible values include: 'PcProtocolTCP', 'PcProtocolUDP', 'PcProtocolAny'
	Protocol PcProtocol `json:"protocol,omitempty"`
	// LocalIPAddress - Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	LocalIPAddress *string `json:"localIPAddress,omitempty"`
	// RemoteIPAddress - Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	RemoteIPAddress *string `json:"remoteIPAddress,omitempty"`
	// LocalPort - Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	LocalPort *string `json:"localPort,omitempty"`
	// RemotePort - Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
	RemotePort *string `json:"remotePort,omitempty"`
}

// PacketCaptureListResult list of packet capture sessions.
type PacketCaptureListResult struct {
	autorest.Response `json:"-"`
	// Value - Information about packet capture sessions.
	Value *[]PacketCaptureResult `json:"value,omitempty"`
}

// PacketCaptureParameters parameters that define the create packet capture operation.
type PacketCaptureParameters struct {
	// Target - The ID of the targeted resource, only VM is currently supported.
	Target *string `json:"target,omitempty"`
	// BytesToCapturePerPacket - Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int32 `json:"bytesToCapturePerPacket,omitempty"`
	// TotalBytesPerSession - Maximum size of the capture output.
	TotalBytesPerSession *int32 `json:"totalBytesPerSession,omitempty"`
	// TimeLimitInSeconds - Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32 `json:"timeLimitInSeconds,omitempty"`
	// StorageLocation - Describes the storage location for a packet capture session.
	StorageLocation *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	// Filters - A list of packet capture filters.
	Filters *[]PacketCaptureFilter `json:"filters,omitempty"`
}

// PacketCaptureQueryStatusResult status of packet capture session.
type PacketCaptureQueryStatusResult struct {
	autorest.Response `json:"-"`
	// Name - The name of the packet capture resource.
	Name *string `json:"name,omitempty"`
	// ID - The ID of the packet capture resource.
	ID *string `json:"id,omitempty"`
	// CaptureStartTime - The start time of the packet capture session.
	CaptureStartTime *date.Time `json:"captureStartTime,omitempty"`
	// PacketCaptureStatus - The status of the packet capture session. Possible values include: 'PcStatusNotStarted', 'PcStatusRunning', 'PcStatusStopped', 'PcStatusError', 'PcStatusUnknown'
	PacketCaptureStatus PcStatus `json:"packetCaptureStatus,omitempty"`
	// StopReason - The reason the current packet capture session was stopped.
	StopReason *string `json:"stopReason,omitempty"`
	// PacketCaptureError - List of errors of packet capture session.
	PacketCaptureError *[]PcError `json:"packetCaptureError,omitempty"`
}

// PacketCaptureResult information about packet capture session.
type PacketCaptureResult struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the packet capture session.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; ID of the packet capture operation.
	ID *string `json:"id,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// PacketCaptureResultProperties - Properties of the packet capture result.
	*PacketCaptureResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PacketCaptureResult.
func (pcr PacketCaptureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcr.Etag != nil {
		objectMap["etag"] = pcr.Etag
	}
	if pcr.PacketCaptureResultProperties != nil {
		objectMap["properties"] = pcr.PacketCaptureResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PacketCaptureResult struct.
func (pcr *PacketCaptureResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pcr.Etag = &etag
			}
		case "properties":
			if v != nil {
				var packetCaptureResultProperties PacketCaptureResultProperties
				err = json.Unmarshal(*v, &packetCaptureResultProperties)
				if err != nil {
					return err
				}
				pcr.PacketCaptureResultProperties = &packetCaptureResultProperties
			}
		}
	}

	return nil
}

// PacketCaptureResultProperties describes the properties of a packet capture session.
type PacketCaptureResultProperties struct {
	// ProvisioningState - The provisioning state of the packet capture session. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Target - The ID of the targeted resource, only VM is currently supported.
	Target *string `json:"target,omitempty"`
	// BytesToCapturePerPacket - Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int32 `json:"bytesToCapturePerPacket,omitempty"`
	// TotalBytesPerSession - Maximum size of the capture output.
	TotalBytesPerSession *int32 `json:"totalBytesPerSession,omitempty"`
	// TimeLimitInSeconds - Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32 `json:"timeLimitInSeconds,omitempty"`
	// StorageLocation - Describes the storage location for a packet capture session.
	StorageLocation *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	// Filters - A list of packet capture filters.
	Filters *[]PacketCaptureFilter `json:"filters,omitempty"`
}

// PacketCapturesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PacketCapturesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PacketCapturesClient) (PacketCaptureResult, error)
}

// PacketCapturesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PacketCapturesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PacketCapturesClient) (autorest.Response, error)
}

// PacketCapturesGetStatusFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PacketCapturesGetStatusFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PacketCapturesClient) (PacketCaptureQueryStatusResult, error)
}

// PacketCapturesStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PacketCapturesStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PacketCapturesClient) (autorest.Response, error)
}

// PacketCaptureStorageLocation describes the storage location for a packet capture session.
type PacketCaptureStorageLocation struct {
	// StorageID - The ID of the storage account to save the packet capture session. Required if no local file path is provided.
	StorageID *string `json:"storageId,omitempty"`
	// StoragePath - The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
	StoragePath *string `json:"storagePath,omitempty"`
	// FilePath - A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
	FilePath *string `json:"filePath,omitempty"`
}

// PatchRouteFilter route Filter Resource.
type PatchRouteFilter struct {
	// RouteFilterPropertiesFormat - Properties of the route filter.
	*RouteFilterPropertiesFormat `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchRouteFilter.
func (prf PatchRouteFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prf.RouteFilterPropertiesFormat != nil {
		objectMap["properties"] = prf.RouteFilterPropertiesFormat
	}
	if prf.Tags != nil {
		objectMap["tags"] = prf.Tags
	}
	if prf.ID != nil {
		objectMap["id"] = prf.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchRouteFilter struct.
func (prf *PatchRouteFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterPropertiesFormat RouteFilterPropertiesFormat
				err = json.Unmarshal(*v, &routeFilterPropertiesFormat)
				if err != nil {
					return err
				}
				prf.RouteFilterPropertiesFormat = &routeFilterPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				prf.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				prf.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				prf.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				prf.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				prf.ID = &ID
			}
		}
	}

	return nil
}

// PatchRouteFilterRule route Filter Rule Resource.
type PatchRouteFilterRule struct {
	// RouteFilterRulePropertiesFormat - Properties of the route filter rule.
	*RouteFilterRulePropertiesFormat `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchRouteFilterRule.
func (prfr PatchRouteFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prfr.RouteFilterRulePropertiesFormat != nil {
		objectMap["properties"] = prfr.RouteFilterRulePropertiesFormat
	}
	if prfr.ID != nil {
		objectMap["id"] = prfr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchRouteFilterRule struct.
func (prfr *PatchRouteFilterRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterRulePropertiesFormat RouteFilterRulePropertiesFormat
				err = json.Unmarshal(*v, &routeFilterRulePropertiesFormat)
				if err != nil {
					return err
				}
				prfr.RouteFilterRulePropertiesFormat = &routeFilterRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				prfr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				prfr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				prfr.ID = &ID
			}
		}
	}

	return nil
}

// PeerExpressRouteCircuitConnection peer Express Route Circuit Connection in an ExpressRouteCircuitPeering
// resource.
type PeerExpressRouteCircuitConnection struct {
	autorest.Response `json:"-"`
	// PeerExpressRouteCircuitConnectionPropertiesFormat - Properties of the peer express route circuit connection.
	*PeerExpressRouteCircuitConnectionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PeerExpressRouteCircuitConnection.
func (percc PeerExpressRouteCircuitConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if percc.PeerExpressRouteCircuitConnectionPropertiesFormat != nil {
		objectMap["properties"] = percc.PeerExpressRouteCircuitConnectionPropertiesFormat
	}
	if percc.Name != nil {
		objectMap["name"] = percc.Name
	}
	if percc.ID != nil {
		objectMap["id"] = percc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PeerExpressRouteCircuitConnection struct.
func (percc *PeerExpressRouteCircuitConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var peerExpressRouteCircuitConnectionPropertiesFormat PeerExpressRouteCircuitConnectionPropertiesFormat
				err = json.Unmarshal(*v, &peerExpressRouteCircuitConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				percc.PeerExpressRouteCircuitConnectionPropertiesFormat = &peerExpressRouteCircuitConnectionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				percc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				percc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				percc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				percc.ID = &ID
			}
		}
	}

	return nil
}

// PeerExpressRouteCircuitConnectionListResult response for ListPeeredConnections API service call
// retrieves all global reach peer circuit connections that belongs to a Private Peering for an
// ExpressRouteCircuit.
type PeerExpressRouteCircuitConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The global reach peer circuit connection associated with Private Peering in an ExpressRoute Circuit.
	Value *[]PeerExpressRouteCircuitConnection `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PeerExpressRouteCircuitConnectionListResultIterator provides access to a complete listing of
// PeerExpressRouteCircuitConnection values.
type PeerExpressRouteCircuitConnectionListResultIterator struct {
	i    int
	page PeerExpressRouteCircuitConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PeerExpressRouteCircuitConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeerExpressRouteCircuitConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PeerExpressRouteCircuitConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PeerExpressRouteCircuitConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PeerExpressRouteCircuitConnectionListResultIterator) Response() PeerExpressRouteCircuitConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PeerExpressRouteCircuitConnectionListResultIterator) Value() PeerExpressRouteCircuitConnection {
	if !iter.page.NotDone() {
		return PeerExpressRouteCircuitConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PeerExpressRouteCircuitConnectionListResultIterator type.
func NewPeerExpressRouteCircuitConnectionListResultIterator(page PeerExpressRouteCircuitConnectionListResultPage) PeerExpressRouteCircuitConnectionListResultIterator {
	return PeerExpressRouteCircuitConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (percclr PeerExpressRouteCircuitConnectionListResult) IsEmpty() bool {
	return percclr.Value == nil || len(*percclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (percclr PeerExpressRouteCircuitConnectionListResult) hasNextLink() bool {
	return percclr.NextLink != nil && len(*percclr.NextLink) != 0
}

// peerExpressRouteCircuitConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (percclr PeerExpressRouteCircuitConnectionListResult) peerExpressRouteCircuitConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !percclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(percclr.NextLink)))
}

// PeerExpressRouteCircuitConnectionListResultPage contains a page of PeerExpressRouteCircuitConnection
// values.
type PeerExpressRouteCircuitConnectionListResultPage struct {
	fn      func(context.Context, PeerExpressRouteCircuitConnectionListResult) (PeerExpressRouteCircuitConnectionListResult, error)
	percclr PeerExpressRouteCircuitConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PeerExpressRouteCircuitConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeerExpressRouteCircuitConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.percclr)
		if err != nil {
			return err
		}
		page.percclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PeerExpressRouteCircuitConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PeerExpressRouteCircuitConnectionListResultPage) NotDone() bool {
	return !page.percclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PeerExpressRouteCircuitConnectionListResultPage) Response() PeerExpressRouteCircuitConnectionListResult {
	return page.percclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PeerExpressRouteCircuitConnectionListResultPage) Values() []PeerExpressRouteCircuitConnection {
	if page.percclr.IsEmpty() {
		return nil
	}
	return *page.percclr.Value
}

// Creates a new instance of the PeerExpressRouteCircuitConnectionListResultPage type.
func NewPeerExpressRouteCircuitConnectionListResultPage(cur PeerExpressRouteCircuitConnectionListResult, getNextPage func(context.Context, PeerExpressRouteCircuitConnectionListResult) (PeerExpressRouteCircuitConnectionListResult, error)) PeerExpressRouteCircuitConnectionListResultPage {
	return PeerExpressRouteCircuitConnectionListResultPage{
		fn:      getNextPage,
		percclr: cur,
	}
}

// PeerExpressRouteCircuitConnectionPropertiesFormat properties of the peer express route circuit
// connection.
type PeerExpressRouteCircuitConnectionPropertiesFormat struct {
	// ExpressRouteCircuitPeering - Reference to Express Route Circuit Private Peering Resource of the circuit.
	ExpressRouteCircuitPeering *SubResource `json:"expressRouteCircuitPeering,omitempty"`
	// PeerExpressRouteCircuitPeering - Reference to Express Route Circuit Private Peering Resource of the peered circuit.
	PeerExpressRouteCircuitPeering *SubResource `json:"peerExpressRouteCircuitPeering,omitempty"`
	// AddressPrefix - /29 IP address space to carve out Customer addresses for tunnels.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// CircuitConnectionStatus - Express Route Circuit connection state. Possible values include: 'Connected', 'Connecting', 'Disconnected'
	CircuitConnectionStatus CircuitConnectionStatus `json:"circuitConnectionStatus,omitempty"`
	// ConnectionName - The name of the express route circuit connection resource.
	ConnectionName *string `json:"connectionName,omitempty"`
	// AuthResourceGUID - The resource guid of the authorization used for the express route circuit connection.
	AuthResourceGUID *string `json:"authResourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the peer express route circuit connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PeerExpressRouteCircuitConnectionPropertiesFormat.
func (perccpf PeerExpressRouteCircuitConnectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if perccpf.ExpressRouteCircuitPeering != nil {
		objectMap["expressRouteCircuitPeering"] = perccpf.ExpressRouteCircuitPeering
	}
	if perccpf.PeerExpressRouteCircuitPeering != nil {
		objectMap["peerExpressRouteCircuitPeering"] = perccpf.PeerExpressRouteCircuitPeering
	}
	if perccpf.AddressPrefix != nil {
		objectMap["addressPrefix"] = perccpf.AddressPrefix
	}
	if perccpf.CircuitConnectionStatus != "" {
		objectMap["circuitConnectionStatus"] = perccpf.CircuitConnectionStatus
	}
	if perccpf.ConnectionName != nil {
		objectMap["connectionName"] = perccpf.ConnectionName
	}
	if perccpf.AuthResourceGUID != nil {
		objectMap["authResourceGuid"] = perccpf.AuthResourceGUID
	}
	return json.Marshal(objectMap)
}

// PolicySettings defines contents of a web application firewall global configuration.
type PolicySettings struct {
	// EnabledState - Describes if the policy is in enabled state or disabled state. Possible values include: 'WebApplicationFirewallEnabledStateDisabled', 'WebApplicationFirewallEnabledStateEnabled'
	EnabledState WebApplicationFirewallEnabledState `json:"enabledState,omitempty"`
	// Mode - Describes if it is in detection mode or prevention mode at policy level. Possible values include: 'WebApplicationFirewallModePrevention', 'WebApplicationFirewallModeDetection'
	Mode WebApplicationFirewallMode `json:"mode,omitempty"`
}

// PrepareNetworkPoliciesRequest details of PrepareNetworkPolicies for Subnet.
type PrepareNetworkPoliciesRequest struct {
	// ServiceName - The name of the service for which subnet is being prepared for.
	ServiceName *string `json:"serviceName,omitempty"`
	// NetworkIntentPolicyConfigurations - A list of NetworkIntentPolicyConfiguration.
	NetworkIntentPolicyConfigurations *[]IntentPolicyConfiguration `json:"networkIntentPolicyConfigurations,omitempty"`
}

// PrivateEndpoint private endpoint resource.
type PrivateEndpoint struct {
	autorest.Response `json:"-"`
	// PrivateEndpointProperties - Properties of the private endpoint.
	*PrivateEndpointProperties `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peVar.PrivateEndpointProperties != nil {
		objectMap["properties"] = peVar.PrivateEndpointProperties
	}
	if peVar.Etag != nil {
		objectMap["etag"] = peVar.Etag
	}
	if peVar.ID != nil {
		objectMap["id"] = peVar.ID
	}
	if peVar.Location != nil {
		objectMap["location"] = peVar.Location
	}
	if peVar.Tags != nil {
		objectMap["tags"] = peVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpoint struct.
func (peVar *PrivateEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointProperties PrivateEndpointProperties
				err = json.Unmarshal(*v, &privateEndpointProperties)
				if err != nil {
					return err
				}
				peVar.PrivateEndpointProperties = &privateEndpointProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				peVar.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				peVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				peVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				peVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				peVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				peVar.Tags = tags
			}
		}
	}

	return nil
}

// PrivateEndpointConnection privateEndpointConnection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Properties of the private end point connection.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	if pec.Name != nil {
		objectMap["name"] = pec.Name
	}
	if pec.ID != nil {
		objectMap["id"] = pec.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pec.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointListResult response for the ListPrivateEndpoints API service call.
type PrivateEndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of private endpoint resources in a resource group.
	Value *[]PrivateEndpoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointListResult.
func (pelr PrivateEndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pelr.Value != nil {
		objectMap["value"] = pelr.Value
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointListResultIterator provides access to a complete listing of PrivateEndpoint values.
type PrivateEndpointListResultIterator struct {
	i    int
	page PrivateEndpointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointListResultIterator) Response() PrivateEndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointListResultIterator) Value() PrivateEndpoint {
	if !iter.page.NotDone() {
		return PrivateEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointListResultIterator type.
func NewPrivateEndpointListResultIterator(page PrivateEndpointListResultPage) PrivateEndpointListResultIterator {
	return PrivateEndpointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pelr PrivateEndpointListResult) IsEmpty() bool {
	return pelr.Value == nil || len(*pelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pelr PrivateEndpointListResult) hasNextLink() bool {
	return pelr.NextLink != nil && len(*pelr.NextLink) != 0
}

// privateEndpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pelr PrivateEndpointListResult) privateEndpointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pelr.NextLink)))
}

// PrivateEndpointListResultPage contains a page of PrivateEndpoint values.
type PrivateEndpointListResultPage struct {
	fn   func(context.Context, PrivateEndpointListResult) (PrivateEndpointListResult, error)
	pelr PrivateEndpointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pelr)
		if err != nil {
			return err
		}
		page.pelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointListResultPage) NotDone() bool {
	return !page.pelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointListResultPage) Response() PrivateEndpointListResult {
	return page.pelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointListResultPage) Values() []PrivateEndpoint {
	if page.pelr.IsEmpty() {
		return nil
	}
	return *page.pelr.Value
}

// Creates a new instance of the PrivateEndpointListResultPage type.
func NewPrivateEndpointListResultPage(cur PrivateEndpointListResult, getNextPage func(context.Context, PrivateEndpointListResult) (PrivateEndpointListResult, error)) PrivateEndpointListResultPage {
	return PrivateEndpointListResultPage{
		fn:   getNextPage,
		pelr: cur,
	}
}

// PrivateEndpointProperties properties of the private endpoint.
type PrivateEndpointProperties struct {
	// Subnet - The ID of the subnet from which the private IP will be allocated.
	Subnet *Subnet `json:"subnet,omitempty"`
	// NetworkInterfaces - READ-ONLY; An array of references to the network interfaces created for this private endpoint.
	NetworkInterfaces *[]Interface `json:"networkInterfaces,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateLinkServiceConnections - A grouping of information about the connection to the remote resource.
	PrivateLinkServiceConnections *[]PrivateLinkServiceConnection `json:"privateLinkServiceConnections,omitempty"`
	// ManualPrivateLinkServiceConnections - A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
	ManualPrivateLinkServiceConnections *[]PrivateLinkServiceConnection `json:"manualPrivateLinkServiceConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointProperties.
func (pep PrivateEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pep.Subnet != nil {
		objectMap["subnet"] = pep.Subnet
	}
	if pep.ProvisioningState != "" {
		objectMap["provisioningState"] = pep.ProvisioningState
	}
	if pep.PrivateLinkServiceConnections != nil {
		objectMap["privateLinkServiceConnections"] = pep.PrivateLinkServiceConnections
	}
	if pep.ManualPrivateLinkServiceConnections != nil {
		objectMap["manualPrivateLinkServiceConnections"] = pep.ManualPrivateLinkServiceConnections
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointsClient) (PrivateEndpoint, error)
}

// PrivateEndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateEndpointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointsClient) (autorest.Response, error)
}

// PrivateLinkService private link service resource.
type PrivateLinkService struct {
	autorest.Response `json:"-"`
	// PrivateLinkServiceProperties - Properties of the private link service.
	*PrivateLinkServiceProperties `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateLinkService.
func (pls PrivateLinkService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pls.PrivateLinkServiceProperties != nil {
		objectMap["properties"] = pls.PrivateLinkServiceProperties
	}
	if pls.Etag != nil {
		objectMap["etag"] = pls.Etag
	}
	if pls.ID != nil {
		objectMap["id"] = pls.ID
	}
	if pls.Location != nil {
		objectMap["location"] = pls.Location
	}
	if pls.Tags != nil {
		objectMap["tags"] = pls.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkService struct.
func (pls *PrivateLinkService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkServiceProperties PrivateLinkServiceProperties
				err = json.Unmarshal(*v, &privateLinkServiceProperties)
				if err != nil {
					return err
				}
				pls.PrivateLinkServiceProperties = &privateLinkServiceProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pls.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pls.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pls.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pls.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pls.Tags = tags
			}
		}
	}

	return nil
}

// PrivateLinkServiceConnection privateLinkServiceConnection resource.
type PrivateLinkServiceConnection struct {
	// PrivateLinkServiceConnectionProperties - Properties of the private link service connection.
	*PrivateLinkServiceConnectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnection.
func (plsc PrivateLinkServiceConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plsc.PrivateLinkServiceConnectionProperties != nil {
		objectMap["properties"] = plsc.PrivateLinkServiceConnectionProperties
	}
	if plsc.Name != nil {
		objectMap["name"] = plsc.Name
	}
	if plsc.ID != nil {
		objectMap["id"] = plsc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkServiceConnection struct.
func (plsc *PrivateLinkServiceConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkServiceConnectionProperties PrivateLinkServiceConnectionProperties
				err = json.Unmarshal(*v, &privateLinkServiceConnectionProperties)
				if err != nil {
					return err
				}
				plsc.PrivateLinkServiceConnectionProperties = &privateLinkServiceConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plsc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plsc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				plsc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plsc.ID = &ID
			}
		}
	}

	return nil
}

// PrivateLinkServiceConnectionProperties properties of the PrivateLinkServiceConnection.
type PrivateLinkServiceConnectionProperties struct {
	// ProvisioningState - The provisioning state of the private link service connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateLinkServiceID - The resource id of private link service.
	PrivateLinkServiceID *string `json:"privateLinkServiceId,omitempty"`
	// GroupIds - The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
	GroupIds *[]string `json:"groupIds,omitempty"`
	// RequestMessage - A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
	RequestMessage *string `json:"requestMessage,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of read-only information about the state of the connection to the remote resource.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *string `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// PrivateLinkServiceIPConfiguration the private link service ip configuration.
type PrivateLinkServiceIPConfiguration struct {
	// PrivateLinkServiceIPConfigurationProperties - Properties of the private link service ip configuration.
	*PrivateLinkServiceIPConfigurationProperties `json:"properties,omitempty"`
	// Name - The name of private link service ip configuration.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceIPConfiguration.
func (plsic PrivateLinkServiceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plsic.PrivateLinkServiceIPConfigurationProperties != nil {
		objectMap["properties"] = plsic.PrivateLinkServiceIPConfigurationProperties
	}
	if plsic.Name != nil {
		objectMap["name"] = plsic.Name
	}
	if plsic.ID != nil {
		objectMap["id"] = plsic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkServiceIPConfiguration struct.
func (plsic *PrivateLinkServiceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkServiceIPConfigurationProperties PrivateLinkServiceIPConfigurationProperties
				err = json.Unmarshal(*v, &privateLinkServiceIPConfigurationProperties)
				if err != nil {
					return err
				}
				plsic.PrivateLinkServiceIPConfigurationProperties = &privateLinkServiceIPConfigurationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plsic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				plsic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plsic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plsic.ID = &ID
			}
		}
	}

	return nil
}

// PrivateLinkServiceIPConfigurationProperties properties of private link service IP configuration.
type PrivateLinkServiceIPConfigurationProperties struct {
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference to the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// Primary - Whether the ip configuration is primary or not.
	Primary *bool `json:"primary,omitempty"`
	// ProvisioningState - The provisioning state of the private link service IP configuration resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateIPAddressVersion - Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. Possible values include: 'IPv4', 'IPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
}

// PrivateLinkServiceListResult response for the ListPrivateLinkService API service call.
type PrivateLinkServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of PrivateLinkService resources in a resource group.
	Value *[]PrivateLinkService `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceListResult.
func (plslr PrivateLinkServiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plslr.Value != nil {
		objectMap["value"] = plslr.Value
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceListResultIterator provides access to a complete listing of PrivateLinkService values.
type PrivateLinkServiceListResultIterator struct {
	i    int
	page PrivateLinkServiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkServiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkServiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkServiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkServiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkServiceListResultIterator) Response() PrivateLinkServiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkServiceListResultIterator) Value() PrivateLinkService {
	if !iter.page.NotDone() {
		return PrivateLinkService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkServiceListResultIterator type.
func NewPrivateLinkServiceListResultIterator(page PrivateLinkServiceListResultPage) PrivateLinkServiceListResultIterator {
	return PrivateLinkServiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plslr PrivateLinkServiceListResult) IsEmpty() bool {
	return plslr.Value == nil || len(*plslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plslr PrivateLinkServiceListResult) hasNextLink() bool {
	return plslr.NextLink != nil && len(*plslr.NextLink) != 0
}

// privateLinkServiceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plslr PrivateLinkServiceListResult) privateLinkServiceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plslr.NextLink)))
}

// PrivateLinkServiceListResultPage contains a page of PrivateLinkService values.
type PrivateLinkServiceListResultPage struct {
	fn    func(context.Context, PrivateLinkServiceListResult) (PrivateLinkServiceListResult, error)
	plslr PrivateLinkServiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkServiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkServiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plslr)
		if err != nil {
			return err
		}
		page.plslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkServiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkServiceListResultPage) NotDone() bool {
	return !page.plslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkServiceListResultPage) Response() PrivateLinkServiceListResult {
	return page.plslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkServiceListResultPage) Values() []PrivateLinkService {
	if page.plslr.IsEmpty() {
		return nil
	}
	return *page.plslr.Value
}

// Creates a new instance of the PrivateLinkServiceListResultPage type.
func NewPrivateLinkServiceListResultPage(cur PrivateLinkServiceListResult, getNextPage func(context.Context, PrivateLinkServiceListResult) (PrivateLinkServiceListResult, error)) PrivateLinkServiceListResultPage {
	return PrivateLinkServiceListResultPage{
		fn:    getNextPage,
		plslr: cur,
	}
}

// PrivateLinkServiceProperties properties of the private link service.
type PrivateLinkServiceProperties struct {
	// LoadBalancerFrontendIPConfigurations - An array of references to the load balancer IP configurations.
	LoadBalancerFrontendIPConfigurations *[]FrontendIPConfiguration `json:"loadBalancerFrontendIpConfigurations,omitempty"`
	// IPConfigurations - An array of private link service IP configurations.
	IPConfigurations *[]PrivateLinkServiceIPConfiguration `json:"ipConfigurations,omitempty"`
	// NetworkInterfaces - READ-ONLY; An array of references to the network interfaces created for this private link service.
	NetworkInterfaces *[]Interface `json:"networkInterfaces,omitempty"`
	// ProvisioningState - The provisioning state of the private link service resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - An array of list about connections to the private endpoint.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// Visibility - The visibility list of the private link service.
	Visibility *PrivateLinkServicePropertiesVisibility `json:"visibility,omitempty"`
	// AutoApproval - The auto-approval list of the private link service.
	AutoApproval *PrivateLinkServicePropertiesAutoApproval `json:"autoApproval,omitempty"`
	// Fqdns - The list of Fqdn.
	Fqdns *[]string `json:"fqdns,omitempty"`
	// Alias - READ-ONLY; The alias of the private link service.
	Alias *string `json:"alias,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceProperties.
func (plsp PrivateLinkServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plsp.LoadBalancerFrontendIPConfigurations != nil {
		objectMap["loadBalancerFrontendIpConfigurations"] = plsp.LoadBalancerFrontendIPConfigurations
	}
	if plsp.IPConfigurations != nil {
		objectMap["ipConfigurations"] = plsp.IPConfigurations
	}
	if plsp.ProvisioningState != "" {
		objectMap["provisioningState"] = plsp.ProvisioningState
	}
	if plsp.PrivateEndpointConnections != nil {
		objectMap["privateEndpointConnections"] = plsp.PrivateEndpointConnections
	}
	if plsp.Visibility != nil {
		objectMap["visibility"] = plsp.Visibility
	}
	if plsp.AutoApproval != nil {
		objectMap["autoApproval"] = plsp.AutoApproval
	}
	if plsp.Fqdns != nil {
		objectMap["fqdns"] = plsp.Fqdns
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServicePropertiesAutoApproval the auto-approval list of the private link service.
type PrivateLinkServicePropertiesAutoApproval struct {
	// Subscriptions - The list of subscriptions.
	Subscriptions *[]string `json:"subscriptions,omitempty"`
}

// PrivateLinkServicePropertiesVisibility the visibility list of the private link service.
type PrivateLinkServicePropertiesVisibility struct {
	// Subscriptions - The list of subscriptions.
	Subscriptions *[]string `json:"subscriptions,omitempty"`
}

// PrivateLinkServicesCheckPrivateLinkServiceVisibilityByResourceGroupFuture an abstraction for monitoring
// and retrieving the results of a long-running operation.
type PrivateLinkServicesCheckPrivateLinkServiceVisibilityByResourceGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkServicesClient) (PrivateLinkServiceVisibility, error)
}

// PrivateLinkServicesCheckPrivateLinkServiceVisibilityFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type PrivateLinkServicesCheckPrivateLinkServiceVisibilityFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkServicesClient) (PrivateLinkServiceVisibility, error)
}

// PrivateLinkServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateLinkServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkServicesClient) (PrivateLinkService, error)
}

// PrivateLinkServicesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateLinkServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkServicesClient) (autorest.Response, error)
}

// PrivateLinkServicesDeletePrivateEndpointConnectionFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type PrivateLinkServicesDeletePrivateEndpointConnectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateLinkServicesClient) (autorest.Response, error)
}

// PrivateLinkServiceVisibility response for the CheckPrivateLinkServiceVisibility API service call.
type PrivateLinkServiceVisibility struct {
	autorest.Response `json:"-"`
	// Visible - Private Link Service Visibility (True/False).
	Visible *bool `json:"visible,omitempty"`
}

// Probe a load balancer probe.
type Probe struct {
	autorest.Response `json:"-"`
	// ProbePropertiesFormat - Properties of load balancer probe.
	*ProbePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Probe.
func (p Probe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProbePropertiesFormat != nil {
		objectMap["properties"] = p.ProbePropertiesFormat
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Probe struct.
func (p *Probe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var probePropertiesFormat ProbePropertiesFormat
				err = json.Unmarshal(*v, &probePropertiesFormat)
				if err != nil {
					return err
				}
				p.ProbePropertiesFormat = &probePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		}
	}

	return nil
}

// ProbePropertiesFormat load balancer probe resource.
type ProbePropertiesFormat struct {
	// LoadBalancingRules - READ-ONLY; The load balancer rules that use this probe.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// Protocol - The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful. Possible values include: 'ProbeProtocolHTTP', 'ProbeProtocolTCP', 'ProbeProtocolHTTPS'
	Protocol ProbeProtocol `json:"protocol,omitempty"`
	// Port - The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32 `json:"port,omitempty"`
	// IntervalInSeconds - The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
	// NumberOfProbes - The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
	NumberOfProbes *int32 `json:"numberOfProbes,omitempty"`
	// RequestPath - The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
	RequestPath *string `json:"requestPath,omitempty"`
	// ProvisioningState - The provisioning state of the probe resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ProbePropertiesFormat.
func (ppf ProbePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppf.Protocol != "" {
		objectMap["protocol"] = ppf.Protocol
	}
	if ppf.Port != nil {
		objectMap["port"] = ppf.Port
	}
	if ppf.IntervalInSeconds != nil {
		objectMap["intervalInSeconds"] = ppf.IntervalInSeconds
	}
	if ppf.NumberOfProbes != nil {
		objectMap["numberOfProbes"] = ppf.NumberOfProbes
	}
	if ppf.RequestPath != nil {
		objectMap["requestPath"] = ppf.RequestPath
	}
	if ppf.ProvisioningState != "" {
		objectMap["provisioningState"] = ppf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// Profile network profile resource.
type Profile struct {
	autorest.Response `json:"-"`
	// ProfilePropertiesFormat - Network profile properties.
	*ProfilePropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProfilePropertiesFormat != nil {
		objectMap["properties"] = p.ProfilePropertiesFormat
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var profilePropertiesFormat ProfilePropertiesFormat
				err = json.Unmarshal(*v, &profilePropertiesFormat)
				if err != nil {
					return err
				}
				p.ProfilePropertiesFormat = &profilePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		}
	}

	return nil
}

// ProfileListResult response for ListNetworkProfiles API service call.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of network profiles that exist in a resource group.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProfileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProfileListResultIterator type.
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return ProfileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr ProfileListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(context.Context, ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProfileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProfileListResultPage type.
func NewProfileListResultPage(cur ProfileListResult, getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return ProfileListResultPage{
		fn:  getNextPage,
		plr: cur,
	}
}

// ProfilePropertiesFormat network profile properties.
type ProfilePropertiesFormat struct {
	// ContainerNetworkInterfaces - List of child container network interfaces.
	ContainerNetworkInterfaces *[]ContainerNetworkInterface `json:"containerNetworkInterfaces,omitempty"`
	// ContainerNetworkInterfaceConfigurations - List of chid container network interface configurations.
	ContainerNetworkInterfaceConfigurations *[]ContainerNetworkInterfaceConfiguration `json:"containerNetworkInterfaceConfigurations,omitempty"`
	// ResourceGUID - READ-ONLY; The resource GUID property of the network profile resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the network profile resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ProfilePropertiesFormat.
func (ppf ProfilePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ppf.ContainerNetworkInterfaces != nil {
		objectMap["containerNetworkInterfaces"] = ppf.ContainerNetworkInterfaces
	}
	if ppf.ContainerNetworkInterfaceConfigurations != nil {
		objectMap["containerNetworkInterfaceConfigurations"] = ppf.ContainerNetworkInterfaceConfigurations
	}
	return json.Marshal(objectMap)
}

// ProfilesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ProfilesClient) (autorest.Response, error)
}

// ProtocolConfiguration configuration of the protocol.
type ProtocolConfiguration struct {
	// HTTPConfiguration - HTTP configuration of the connectivity check.
	HTTPConfiguration *HTTPConfiguration `json:"HTTPConfiguration,omitempty"`
}

// ProtocolCustomSettingsFormat dDoS custom policy properties.
type ProtocolCustomSettingsFormat struct {
	// Protocol - The protocol for which the DDoS protection policy is being customized. Possible values include: 'DdosCustomPolicyProtocolTCP', 'DdosCustomPolicyProtocolUDP', 'DdosCustomPolicyProtocolSyn'
	Protocol DdosCustomPolicyProtocol `json:"protocol,omitempty"`
	// TriggerRateOverride - The customized DDoS protection trigger rate.
	TriggerRateOverride *string `json:"triggerRateOverride,omitempty"`
	// SourceRateOverride - The customized DDoS protection source rate.
	SourceRateOverride *string `json:"sourceRateOverride,omitempty"`
	// TriggerSensitivityOverride - The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t. normal traffic. Possible values include: 'Relaxed', 'Low', 'Default', 'High'
	TriggerSensitivityOverride DdosCustomPolicyTriggerSensitivityOverride `json:"triggerSensitivityOverride,omitempty"`
}

// PublicIPAddress public IP address resource.
type PublicIPAddress struct {
	autorest.Response `json:"-"`
	// Sku - The public IP address SKU.
	Sku *PublicIPAddressSku `json:"sku,omitempty"`
	// PublicIPAddressPropertiesFormat - Public IP address properties.
	*PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Zones - A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PublicIPAddress.
func (pia PublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pia.Sku != nil {
		objectMap["sku"] = pia.Sku
	}
	if pia.PublicIPAddressPropertiesFormat != nil {
		objectMap["properties"] = pia.PublicIPAddressPropertiesFormat
	}
	if pia.Etag != nil {
		objectMap["etag"] = pia.Etag
	}
	if pia.Zones != nil {
		objectMap["zones"] = pia.Zones
	}
	if pia.ID != nil {
		objectMap["id"] = pia.ID
	}
	if pia.Location != nil {
		objectMap["location"] = pia.Location
	}
	if pia.Tags != nil {
		objectMap["tags"] = pia.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicIPAddress struct.
func (pia *PublicIPAddress) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku PublicIPAddressSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pia.Sku = &sku
			}
		case "properties":
			if v != nil {
				var publicIPAddressPropertiesFormat PublicIPAddressPropertiesFormat
				err = json.Unmarshal(*v, &publicIPAddressPropertiesFormat)
				if err != nil {
					return err
				}
				pia.PublicIPAddressPropertiesFormat = &publicIPAddressPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pia.Etag = &etag
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				pia.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pia.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pia.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pia.Tags = tags
			}
		}
	}

	return nil
}

// PublicIPAddressDNSSettings contains FQDN of the DNS record associated with the public IP address.
type PublicIPAddressDNSSettings struct {
	// DomainNameLabel - The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	// Fqdn - The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
	Fqdn *string `json:"fqdn,omitempty"`
	// ReverseFqdn - The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PublicIPAddressesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPAddressesClient) (PublicIPAddress, error)
}

// PublicIPAddressesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPAddressesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPAddressesClient) (autorest.Response, error)
}

// PublicIPAddressesUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PublicIPAddressesUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPAddressesClient) (PublicIPAddress, error)
}

// PublicIPAddressListResult response for ListPublicIpAddresses API service call.
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of public IP addresses that exists in a resource group.
	Value *[]PublicIPAddress `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublicIPAddressListResultIterator provides access to a complete listing of PublicIPAddress values.
type PublicIPAddressListResultIterator struct {
	i    int
	page PublicIPAddressListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicIPAddressListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPAddressListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublicIPAddressListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicIPAddressListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicIPAddressListResultIterator) Response() PublicIPAddressListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicIPAddressListResultIterator) Value() PublicIPAddress {
	if !iter.page.NotDone() {
		return PublicIPAddress{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublicIPAddressListResultIterator type.
func NewPublicIPAddressListResultIterator(page PublicIPAddressListResultPage) PublicIPAddressListResultIterator {
	return PublicIPAddressListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pialr PublicIPAddressListResult) IsEmpty() bool {
	return pialr.Value == nil || len(*pialr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pialr PublicIPAddressListResult) hasNextLink() bool {
	return pialr.NextLink != nil && len(*pialr.NextLink) != 0
}

// publicIPAddressListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pialr PublicIPAddressListResult) publicIPAddressListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pialr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pialr.NextLink)))
}

// PublicIPAddressListResultPage contains a page of PublicIPAddress values.
type PublicIPAddressListResultPage struct {
	fn    func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)
	pialr PublicIPAddressListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicIPAddressListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPAddressListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pialr)
		if err != nil {
			return err
		}
		page.pialr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublicIPAddressListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicIPAddressListResultPage) NotDone() bool {
	return !page.pialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicIPAddressListResultPage) Response() PublicIPAddressListResult {
	return page.pialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicIPAddressListResultPage) Values() []PublicIPAddress {
	if page.pialr.IsEmpty() {
		return nil
	}
	return *page.pialr.Value
}

// Creates a new instance of the PublicIPAddressListResultPage type.
func NewPublicIPAddressListResultPage(cur PublicIPAddressListResult, getNextPage func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)) PublicIPAddressListResultPage {
	return PublicIPAddressListResultPage{
		fn:    getNextPage,
		pialr: cur,
	}
}

// PublicIPAddressPropertiesFormat public IP address properties.
type PublicIPAddressPropertiesFormat struct {
	// PublicIPAllocationMethod - The public IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PublicIPAllocationMethod IPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`
	// PublicIPAddressVersion - The public IP address version. Possible values include: 'IPv4', 'IPv6'
	PublicIPAddressVersion IPVersion `json:"publicIPAddressVersion,omitempty"`
	// IPConfiguration - READ-ONLY; The IP configuration associated with the public IP address.
	IPConfiguration *IPConfiguration `json:"ipConfiguration,omitempty"`
	// DNSSettings - The FQDN of the DNS record associated with the public IP address.
	DNSSettings *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	// DdosSettings - The DDoS protection custom policy associated with the public IP address.
	DdosSettings *DdosSettings `json:"ddosSettings,omitempty"`
	// IPTags - The list of tags associated with the public IP address.
	IPTags *[]IPTag `json:"ipTags,omitempty"`
	// IPAddress - The IP address associated with the public IP address resource.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PublicIPPrefix - The Public IP Prefix this Public IP Address should be allocated from.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
	// IdleTimeoutInMinutes - The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// ResourceGUID - The resource GUID property of the public IP address resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the public IP address resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicIPAddressPropertiesFormat.
func (piapf PublicIPAddressPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if piapf.PublicIPAllocationMethod != "" {
		objectMap["publicIPAllocationMethod"] = piapf.PublicIPAllocationMethod
	}
	if piapf.PublicIPAddressVersion != "" {
		objectMap["publicIPAddressVersion"] = piapf.PublicIPAddressVersion
	}
	if piapf.DNSSettings != nil {
		objectMap["dnsSettings"] = piapf.DNSSettings
	}
	if piapf.DdosSettings != nil {
		objectMap["ddosSettings"] = piapf.DdosSettings
	}
	if piapf.IPTags != nil {
		objectMap["ipTags"] = piapf.IPTags
	}
	if piapf.IPAddress != nil {
		objectMap["ipAddress"] = piapf.IPAddress
	}
	if piapf.PublicIPPrefix != nil {
		objectMap["publicIPPrefix"] = piapf.PublicIPPrefix
	}
	if piapf.IdleTimeoutInMinutes != nil {
		objectMap["idleTimeoutInMinutes"] = piapf.IdleTimeoutInMinutes
	}
	if piapf.ResourceGUID != nil {
		objectMap["resourceGuid"] = piapf.ResourceGUID
	}
	if piapf.ProvisioningState != "" {
		objectMap["provisioningState"] = piapf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// PublicIPAddressSku SKU of a public IP address.
type PublicIPAddressSku struct {
	// Name - Name of a public IP address SKU. Possible values include: 'PublicIPAddressSkuNameBasic', 'PublicIPAddressSkuNameStandard'
	Name PublicIPAddressSkuName `json:"name,omitempty"`
}

// PublicIPPrefix public IP prefix resource.
type PublicIPPrefix struct {
	autorest.Response `json:"-"`
	// Sku - The public IP prefix SKU.
	Sku *PublicIPPrefixSku `json:"sku,omitempty"`
	// PublicIPPrefixPropertiesFormat - Public IP prefix properties.
	*PublicIPPrefixPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Zones - A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PublicIPPrefix.
func (pip PublicIPPrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pip.Sku != nil {
		objectMap["sku"] = pip.Sku
	}
	if pip.PublicIPPrefixPropertiesFormat != nil {
		objectMap["properties"] = pip.PublicIPPrefixPropertiesFormat
	}
	if pip.Etag != nil {
		objectMap["etag"] = pip.Etag
	}
	if pip.Zones != nil {
		objectMap["zones"] = pip.Zones
	}
	if pip.ID != nil {
		objectMap["id"] = pip.ID
	}
	if pip.Location != nil {
		objectMap["location"] = pip.Location
	}
	if pip.Tags != nil {
		objectMap["tags"] = pip.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicIPPrefix struct.
func (pip *PublicIPPrefix) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku PublicIPPrefixSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pip.Sku = &sku
			}
		case "properties":
			if v != nil {
				var publicIPPrefixPropertiesFormat PublicIPPrefixPropertiesFormat
				err = json.Unmarshal(*v, &publicIPPrefixPropertiesFormat)
				if err != nil {
					return err
				}
				pip.PublicIPPrefixPropertiesFormat = &publicIPPrefixPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pip.Etag = &etag
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				pip.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pip.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pip.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pip.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pip.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pip.Tags = tags
			}
		}
	}

	return nil
}

// PublicIPPrefixesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PublicIPPrefixesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPPrefixesClient) (PublicIPPrefix, error)
}

// PublicIPPrefixesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPPrefixesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPPrefixesClient) (autorest.Response, error)
}

// PublicIPPrefixesUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PublicIPPrefixesUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PublicIPPrefixesClient) (PublicIPPrefix, error)
}

// PublicIPPrefixListResult response for ListPublicIpPrefixes API service call.
type PublicIPPrefixListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of public IP prefixes that exists in a resource group.
	Value *[]PublicIPPrefix `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublicIPPrefixListResultIterator provides access to a complete listing of PublicIPPrefix values.
type PublicIPPrefixListResultIterator struct {
	i    int
	page PublicIPPrefixListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicIPPrefixListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPPrefixListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublicIPPrefixListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicIPPrefixListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicIPPrefixListResultIterator) Response() PublicIPPrefixListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicIPPrefixListResultIterator) Value() PublicIPPrefix {
	if !iter.page.NotDone() {
		return PublicIPPrefix{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublicIPPrefixListResultIterator type.
func NewPublicIPPrefixListResultIterator(page PublicIPPrefixListResultPage) PublicIPPrefixListResultIterator {
	return PublicIPPrefixListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (piplr PublicIPPrefixListResult) IsEmpty() bool {
	return piplr.Value == nil || len(*piplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (piplr PublicIPPrefixListResult) hasNextLink() bool {
	return piplr.NextLink != nil && len(*piplr.NextLink) != 0
}

// publicIPPrefixListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (piplr PublicIPPrefixListResult) publicIPPrefixListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !piplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(piplr.NextLink)))
}

// PublicIPPrefixListResultPage contains a page of PublicIPPrefix values.
type PublicIPPrefixListResultPage struct {
	fn    func(context.Context, PublicIPPrefixListResult) (PublicIPPrefixListResult, error)
	piplr PublicIPPrefixListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicIPPrefixListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPPrefixListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.piplr)
		if err != nil {
			return err
		}
		page.piplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublicIPPrefixListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicIPPrefixListResultPage) NotDone() bool {
	return !page.piplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicIPPrefixListResultPage) Response() PublicIPPrefixListResult {
	return page.piplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicIPPrefixListResultPage) Values() []PublicIPPrefix {
	if page.piplr.IsEmpty() {
		return nil
	}
	return *page.piplr.Value
}

// Creates a new instance of the PublicIPPrefixListResultPage type.
func NewPublicIPPrefixListResultPage(cur PublicIPPrefixListResult, getNextPage func(context.Context, PublicIPPrefixListResult) (PublicIPPrefixListResult, error)) PublicIPPrefixListResultPage {
	return PublicIPPrefixListResultPage{
		fn:    getNextPage,
		piplr: cur,
	}
}

// PublicIPPrefixPropertiesFormat public IP prefix properties.
type PublicIPPrefixPropertiesFormat struct {
	// PublicIPAddressVersion - The public IP address version. Possible values include: 'IPv4', 'IPv6'
	PublicIPAddressVersion IPVersion `json:"publicIPAddressVersion,omitempty"`
	// IPTags - The list of tags associated with the public IP prefix.
	IPTags *[]IPTag `json:"ipTags,omitempty"`
	// PrefixLength - The Length of the Public IP Prefix.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
	// IPPrefix - The allocated Prefix.
	IPPrefix *string `json:"ipPrefix,omitempty"`
	// PublicIPAddresses - The list of all referenced PublicIPAddresses.
	PublicIPAddresses *[]ReferencedPublicIPAddress `json:"publicIPAddresses,omitempty"`
	// LoadBalancerFrontendIPConfiguration - READ-ONLY; The reference to load balancer frontend IP configuration associated with the public IP prefix.
	LoadBalancerFrontendIPConfiguration *SubResource `json:"loadBalancerFrontendIpConfiguration,omitempty"`
	// ResourceGUID - The resource GUID property of the public IP prefix resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the public IP prefix resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicIPPrefixPropertiesFormat.
func (pippf PublicIPPrefixPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pippf.PublicIPAddressVersion != "" {
		objectMap["publicIPAddressVersion"] = pippf.PublicIPAddressVersion
	}
	if pippf.IPTags != nil {
		objectMap["ipTags"] = pippf.IPTags
	}
	if pippf.PrefixLength != nil {
		objectMap["prefixLength"] = pippf.PrefixLength
	}
	if pippf.IPPrefix != nil {
		objectMap["ipPrefix"] = pippf.IPPrefix
	}
	if pippf.PublicIPAddresses != nil {
		objectMap["publicIPAddresses"] = pippf.PublicIPAddresses
	}
	if pippf.ResourceGUID != nil {
		objectMap["resourceGuid"] = pippf.ResourceGUID
	}
	if pippf.ProvisioningState != "" {
		objectMap["provisioningState"] = pippf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// PublicIPPrefixSku SKU of a public IP prefix.
type PublicIPPrefixSku struct {
	// Name - Name of a public IP prefix SKU. Possible values include: 'PublicIPPrefixSkuNameStandard'
	Name PublicIPPrefixSkuName `json:"name,omitempty"`
}

// QueryTroubleshootingParameters parameters that define the resource to query the troubleshooting result.
type QueryTroubleshootingParameters struct {
	// TargetResourceID - The target resource ID to query the troubleshooting result.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// ReferencedPublicIPAddress reference to a public IP address.
type ReferencedPublicIPAddress struct {
	// ID - The PublicIPAddress Reference.
	ID *string `json:"id,omitempty"`
}

// Resource common resource representation.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceNavigationLink resourceNavigationLink resource.
type ResourceNavigationLink struct {
	// ResourceNavigationLinkFormat - Resource navigation link properties format.
	*ResourceNavigationLinkFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNavigationLink.
func (rnl ResourceNavigationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnl.ResourceNavigationLinkFormat != nil {
		objectMap["properties"] = rnl.ResourceNavigationLinkFormat
	}
	if rnl.Name != nil {
		objectMap["name"] = rnl.Name
	}
	if rnl.ID != nil {
		objectMap["id"] = rnl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceNavigationLink struct.
func (rnl *ResourceNavigationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceNavigationLinkFormat ResourceNavigationLinkFormat
				err = json.Unmarshal(*v, &resourceNavigationLinkFormat)
				if err != nil {
					return err
				}
				rnl.ResourceNavigationLinkFormat = &resourceNavigationLinkFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rnl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rnl.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rnl.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rnl.ID = &ID
			}
		}
	}

	return nil
}

// ResourceNavigationLinkFormat properties of ResourceNavigationLink.
type ResourceNavigationLinkFormat struct {
	// LinkedResourceType - Resource type of the linked resource.
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`
	// Link - Link to the external resource.
	Link *string `json:"link,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource navigation link resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNavigationLinkFormat.
func (rnlf ResourceNavigationLinkFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnlf.LinkedResourceType != nil {
		objectMap["linkedResourceType"] = rnlf.LinkedResourceType
	}
	if rnlf.Link != nil {
		objectMap["link"] = rnlf.Link
	}
	return json.Marshal(objectMap)
}

// ResourceNavigationLinksListResult response for ResourceNavigationLinks_List operation.
type ResourceNavigationLinksListResult struct {
	autorest.Response `json:"-"`
	// Value - The resource navigation links in a subnet.
	Value *[]ResourceNavigationLink `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNavigationLinksListResult.
func (rnllr ResourceNavigationLinksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnllr.Value != nil {
		objectMap["value"] = rnllr.Value
	}
	return json.Marshal(objectMap)
}

// ResourceSet the base resource set for visibility and auto-approval.
type ResourceSet struct {
	// Subscriptions - The list of subscriptions.
	Subscriptions *[]string `json:"subscriptions,omitempty"`
}

// RetentionPolicyParameters parameters that define the retention policy for flow log.
type RetentionPolicyParameters struct {
	// Days - Number of days to retain flow log records.
	Days *int32 `json:"days,omitempty"`
	// Enabled - Flag to enable/disable retention.
	Enabled *bool `json:"enabled,omitempty"`
}

// Route route resource.
type Route struct {
	autorest.Response `json:"-"`
	// RoutePropertiesFormat - Properties of the route.
	*RoutePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RoutePropertiesFormat != nil {
		objectMap["properties"] = r.RoutePropertiesFormat
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Route struct.
func (r *Route) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routePropertiesFormat RoutePropertiesFormat
				err = json.Unmarshal(*v, &routePropertiesFormat)
				if err != nil {
					return err
				}
				r.RoutePropertiesFormat = &routePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		}
	}

	return nil
}

// RouteFilter route Filter Resource.
type RouteFilter struct {
	autorest.Response `json:"-"`
	// RouteFilterPropertiesFormat - Properties of the route filter.
	*RouteFilterPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RouteFilter.
func (rf RouteFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rf.RouteFilterPropertiesFormat != nil {
		objectMap["properties"] = rf.RouteFilterPropertiesFormat
	}
	if rf.ID != nil {
		objectMap["id"] = rf.ID
	}
	if rf.Location != nil {
		objectMap["location"] = rf.Location
	}
	if rf.Tags != nil {
		objectMap["tags"] = rf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteFilter struct.
func (rf *RouteFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterPropertiesFormat RouteFilterPropertiesFormat
				err = json.Unmarshal(*v, &routeFilterPropertiesFormat)
				if err != nil {
					return err
				}
				rf.RouteFilterPropertiesFormat = &routeFilterPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rf.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rf.Tags = tags
			}
		}
	}

	return nil
}

// RouteFilterListResult response for the ListRouteFilters API service call.
type RouteFilterListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of route filters in a resource group.
	Value *[]RouteFilter `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteFilterListResultIterator provides access to a complete listing of RouteFilter values.
type RouteFilterListResultIterator struct {
	i    int
	page RouteFilterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteFilterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteFilterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteFilterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteFilterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteFilterListResultIterator) Response() RouteFilterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteFilterListResultIterator) Value() RouteFilter {
	if !iter.page.NotDone() {
		return RouteFilter{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteFilterListResultIterator type.
func NewRouteFilterListResultIterator(page RouteFilterListResultPage) RouteFilterListResultIterator {
	return RouteFilterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rflr RouteFilterListResult) IsEmpty() bool {
	return rflr.Value == nil || len(*rflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rflr RouteFilterListResult) hasNextLink() bool {
	return rflr.NextLink != nil && len(*rflr.NextLink) != 0
}

// routeFilterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rflr RouteFilterListResult) routeFilterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rflr.NextLink)))
}

// RouteFilterListResultPage contains a page of RouteFilter values.
type RouteFilterListResultPage struct {
	fn   func(context.Context, RouteFilterListResult) (RouteFilterListResult, error)
	rflr RouteFilterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteFilterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteFilterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rflr)
		if err != nil {
			return err
		}
		page.rflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteFilterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteFilterListResultPage) NotDone() bool {
	return !page.rflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteFilterListResultPage) Response() RouteFilterListResult {
	return page.rflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteFilterListResultPage) Values() []RouteFilter {
	if page.rflr.IsEmpty() {
		return nil
	}
	return *page.rflr.Value
}

// Creates a new instance of the RouteFilterListResultPage type.
func NewRouteFilterListResultPage(cur RouteFilterListResult, getNextPage func(context.Context, RouteFilterListResult) (RouteFilterListResult, error)) RouteFilterListResultPage {
	return RouteFilterListResultPage{
		fn:   getNextPage,
		rflr: cur,
	}
}

// RouteFilterPropertiesFormat route Filter Resource.
type RouteFilterPropertiesFormat struct {
	// Rules - Collection of RouteFilterRules contained within a route filter.
	Rules *[]RouteFilterRule `json:"rules,omitempty"`
	// Peerings - A collection of references to express route circuit peerings.
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// Ipv6Peerings - A collection of references to express route circuit ipv6 peerings.
	Ipv6Peerings *[]ExpressRouteCircuitPeering `json:"ipv6Peerings,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the route filter resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteFilterPropertiesFormat.
func (rfpf RouteFilterPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rfpf.Rules != nil {
		objectMap["rules"] = rfpf.Rules
	}
	if rfpf.Peerings != nil {
		objectMap["peerings"] = rfpf.Peerings
	}
	if rfpf.Ipv6Peerings != nil {
		objectMap["ipv6Peerings"] = rfpf.Ipv6Peerings
	}
	return json.Marshal(objectMap)
}

// RouteFilterRule route Filter Rule Resource.
type RouteFilterRule struct {
	autorest.Response `json:"-"`
	// RouteFilterRulePropertiesFormat - Properties of the route filter rule.
	*RouteFilterRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteFilterRule.
func (rfr RouteFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rfr.RouteFilterRulePropertiesFormat != nil {
		objectMap["properties"] = rfr.RouteFilterRulePropertiesFormat
	}
	if rfr.Name != nil {
		objectMap["name"] = rfr.Name
	}
	if rfr.Location != nil {
		objectMap["location"] = rfr.Location
	}
	if rfr.ID != nil {
		objectMap["id"] = rfr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteFilterRule struct.
func (rfr *RouteFilterRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeFilterRulePropertiesFormat RouteFilterRulePropertiesFormat
				err = json.Unmarshal(*v, &routeFilterRulePropertiesFormat)
				if err != nil {
					return err
				}
				rfr.RouteFilterRulePropertiesFormat = &routeFilterRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rfr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rfr.Location = &location
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rfr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rfr.ID = &ID
			}
		}
	}

	return nil
}

// RouteFilterRuleListResult response for the ListRouteFilterRules API service call.
type RouteFilterRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of RouteFilterRules in a resource group.
	Value *[]RouteFilterRule `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteFilterRuleListResultIterator provides access to a complete listing of RouteFilterRule values.
type RouteFilterRuleListResultIterator struct {
	i    int
	page RouteFilterRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteFilterRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteFilterRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteFilterRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteFilterRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteFilterRuleListResultIterator) Response() RouteFilterRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteFilterRuleListResultIterator) Value() RouteFilterRule {
	if !iter.page.NotDone() {
		return RouteFilterRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteFilterRuleListResultIterator type.
func NewRouteFilterRuleListResultIterator(page RouteFilterRuleListResultPage) RouteFilterRuleListResultIterator {
	return RouteFilterRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rfrlr RouteFilterRuleListResult) IsEmpty() bool {
	return rfrlr.Value == nil || len(*rfrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rfrlr RouteFilterRuleListResult) hasNextLink() bool {
	return rfrlr.NextLink != nil && len(*rfrlr.NextLink) != 0
}

// routeFilterRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rfrlr RouteFilterRuleListResult) routeFilterRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rfrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rfrlr.NextLink)))
}

// RouteFilterRuleListResultPage contains a page of RouteFilterRule values.
type RouteFilterRuleListResultPage struct {
	fn    func(context.Context, RouteFilterRuleListResult) (RouteFilterRuleListResult, error)
	rfrlr RouteFilterRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteFilterRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteFilterRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rfrlr)
		if err != nil {
			return err
		}
		page.rfrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteFilterRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteFilterRuleListResultPage) NotDone() bool {
	return !page.rfrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteFilterRuleListResultPage) Response() RouteFilterRuleListResult {
	return page.rfrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteFilterRuleListResultPage) Values() []RouteFilterRule {
	if page.rfrlr.IsEmpty() {
		return nil
	}
	return *page.rfrlr.Value
}

// Creates a new instance of the RouteFilterRuleListResultPage type.
func NewRouteFilterRuleListResultPage(cur RouteFilterRuleListResult, getNextPage func(context.Context, RouteFilterRuleListResult) (RouteFilterRuleListResult, error)) RouteFilterRuleListResultPage {
	return RouteFilterRuleListResultPage{
		fn:    getNextPage,
		rfrlr: cur,
	}
}

// RouteFilterRulePropertiesFormat route Filter Rule Resource.
type RouteFilterRulePropertiesFormat struct {
	// Access - The access type of the rule. Possible values include: 'Allow', 'Deny'
	Access Access `json:"access,omitempty"`
	// RouteFilterRuleType - The rule type of the rule.
	RouteFilterRuleType *string `json:"routeFilterRuleType,omitempty"`
	// Communities - The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
	Communities *[]string `json:"communities,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the route filter rule resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteFilterRulePropertiesFormat.
func (rfrpf RouteFilterRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rfrpf.Access != "" {
		objectMap["access"] = rfrpf.Access
	}
	if rfrpf.RouteFilterRuleType != nil {
		objectMap["routeFilterRuleType"] = rfrpf.RouteFilterRuleType
	}
	if rfrpf.Communities != nil {
		objectMap["communities"] = rfrpf.Communities
	}
	return json.Marshal(objectMap)
}

// RouteFilterRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RouteFilterRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteFilterRulesClient) (RouteFilterRule, error)
}

// RouteFilterRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFilterRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteFilterRulesClient) (autorest.Response, error)
}

// RouteFilterRulesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFilterRulesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteFilterRulesClient) (RouteFilterRule, error)
}

// RouteFiltersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RouteFiltersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteFiltersClient) (RouteFilter, error)
}

// RouteFiltersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFiltersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteFiltersClient) (autorest.Response, error)
}

// RouteFiltersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteFiltersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteFiltersClient) (RouteFilter, error)
}

// RouteListResult response for the ListRoute API service call.
type RouteListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of routes in a resource group.
	Value *[]Route `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteListResultIterator provides access to a complete listing of Route values.
type RouteListResultIterator struct {
	i    int
	page RouteListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteListResultIterator) Response() RouteListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteListResultIterator) Value() Route {
	if !iter.page.NotDone() {
		return Route{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteListResultIterator type.
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return RouteListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RouteListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RouteListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// routeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RouteListResult) routeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RouteListResultPage contains a page of Route values.
type RouteListResultPage struct {
	fn  func(context.Context, RouteListResult) (RouteListResult, error)
	rlr RouteListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteListResultPage) Response() RouteListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteListResultPage) Values() []Route {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RouteListResultPage type.
func NewRouteListResultPage(cur RouteListResult, getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return RouteListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RoutePropertiesFormat route resource.
type RoutePropertiesFormat struct {
	// AddressPrefix - The destination CIDR to which the route applies.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NextHopType - The type of Azure hop the packet should be sent to. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
	// NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
	// ProvisioningState - The provisioning state of the route resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// RoutesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RoutesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoutesClient) (Route, error)
}

// RoutesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoutesClient) (autorest.Response, error)
}

// RouteTable route table resource.
type RouteTable struct {
	autorest.Response `json:"-"`
	// RouteTablePropertiesFormat - Properties of the route table.
	*RouteTablePropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RouteTable.
func (rt RouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.RouteTablePropertiesFormat != nil {
		objectMap["properties"] = rt.RouteTablePropertiesFormat
	}
	if rt.Etag != nil {
		objectMap["etag"] = rt.Etag
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteTable struct.
func (rt *RouteTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeTablePropertiesFormat RouteTablePropertiesFormat
				err = json.Unmarshal(*v, &routeTablePropertiesFormat)
				if err != nil {
					return err
				}
				rt.RouteTablePropertiesFormat = &routeTablePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rt.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		}
	}

	return nil
}

// RouteTableListResult response for the ListRouteTable API service call.
type RouteTableListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of route tables in a resource group.
	Value *[]RouteTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteTableListResultIterator provides access to a complete listing of RouteTable values.
type RouteTableListResultIterator struct {
	i    int
	page RouteTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteTableListResultIterator) Response() RouteTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteTableListResultIterator) Value() RouteTable {
	if !iter.page.NotDone() {
		return RouteTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteTableListResultIterator type.
func NewRouteTableListResultIterator(page RouteTableListResultPage) RouteTableListResultIterator {
	return RouteTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rtlr RouteTableListResult) IsEmpty() bool {
	return rtlr.Value == nil || len(*rtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rtlr RouteTableListResult) hasNextLink() bool {
	return rtlr.NextLink != nil && len(*rtlr.NextLink) != 0
}

// routeTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtlr RouteTableListResult) routeTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtlr.NextLink)))
}

// RouteTableListResultPage contains a page of RouteTable values.
type RouteTableListResultPage struct {
	fn   func(context.Context, RouteTableListResult) (RouteTableListResult, error)
	rtlr RouteTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rtlr)
		if err != nil {
			return err
		}
		page.rtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteTableListResultPage) NotDone() bool {
	return !page.rtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteTableListResultPage) Response() RouteTableListResult {
	return page.rtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteTableListResultPage) Values() []RouteTable {
	if page.rtlr.IsEmpty() {
		return nil
	}
	return *page.rtlr.Value
}

// Creates a new instance of the RouteTableListResultPage type.
func NewRouteTableListResultPage(cur RouteTableListResult, getNextPage func(context.Context, RouteTableListResult) (RouteTableListResult, error)) RouteTableListResultPage {
	return RouteTableListResultPage{
		fn:   getNextPage,
		rtlr: cur,
	}
}

// RouteTablePropertiesFormat route Table resource.
type RouteTablePropertiesFormat struct {
	// Routes - Collection of routes contained within a route table.
	Routes *[]Route `json:"routes,omitempty"`
	// Subnets - READ-ONLY; A collection of references to subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// DisableBgpRoutePropagation - Whether to disable the routes learned by BGP on that route table. True means disable.
	DisableBgpRoutePropagation *bool `json:"disableBgpRoutePropagation,omitempty"`
	// ProvisioningState - The provisioning state of the route table resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteTablePropertiesFormat.
func (rtpf RouteTablePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rtpf.Routes != nil {
		objectMap["routes"] = rtpf.Routes
	}
	if rtpf.DisableBgpRoutePropagation != nil {
		objectMap["disableBgpRoutePropagation"] = rtpf.DisableBgpRoutePropagation
	}
	if rtpf.ProvisioningState != "" {
		objectMap["provisioningState"] = rtpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// RouteTablesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RouteTablesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteTablesClient) (RouteTable, error)
}

// RouteTablesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteTablesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteTablesClient) (autorest.Response, error)
}

// RouteTablesUpdateTagsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteTablesUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RouteTablesClient) (RouteTable, error)
}

// RuleCondition rule condition of type network.
type RuleCondition struct {
	// IPProtocols - Array of FirewallPolicyRuleConditionNetworkProtocols.
	IPProtocols *[]FirewallPolicyRuleConditionNetworkProtocol `json:"ipProtocols,omitempty"`
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses or Service Tags.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// DestinationPorts - List of destination ports.
	DestinationPorts *[]string `json:"destinationPorts,omitempty"`
	// Name - Name of the rule condition.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule condition.
	Description *string `json:"description,omitempty"`
	// RuleConditionType - Possible values include: 'RuleConditionTypeFirewallPolicyRuleCondition', 'RuleConditionTypeApplicationRuleCondition', 'RuleConditionTypeNetworkRuleCondition'
	RuleConditionType RuleConditionType `json:"ruleConditionType,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleCondition.
func (rc RuleCondition) MarshalJSON() ([]byte, error) {
	rc.RuleConditionType = RuleConditionTypeNetworkRuleCondition
	objectMap := make(map[string]interface{})
	if rc.IPProtocols != nil {
		objectMap["ipProtocols"] = rc.IPProtocols
	}
	if rc.SourceAddresses != nil {
		objectMap["sourceAddresses"] = rc.SourceAddresses
	}
	if rc.DestinationAddresses != nil {
		objectMap["destinationAddresses"] = rc.DestinationAddresses
	}
	if rc.DestinationPorts != nil {
		objectMap["destinationPorts"] = rc.DestinationPorts
	}
	if rc.Name != nil {
		objectMap["name"] = rc.Name
	}
	if rc.Description != nil {
		objectMap["description"] = rc.Description
	}
	if rc.RuleConditionType != "" {
		objectMap["ruleConditionType"] = rc.RuleConditionType
	}
	return json.Marshal(objectMap)
}

// AsApplicationRuleCondition is the BasicFirewallPolicyRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsApplicationRuleCondition() (*ApplicationRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicFirewallPolicyRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return &rc, true
}

// AsFirewallPolicyRuleCondition is the BasicFirewallPolicyRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsFirewallPolicyRuleCondition() (*FirewallPolicyRuleCondition, bool) {
	return nil, false
}

// AsBasicFirewallPolicyRuleCondition is the BasicFirewallPolicyRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsBasicFirewallPolicyRuleCondition() (BasicFirewallPolicyRuleCondition, bool) {
	return &rc, true
}

// SecurityGroup networkSecurityGroup resource.
type SecurityGroup struct {
	autorest.Response `json:"-"`
	// SecurityGroupPropertiesFormat - Properties of the network security group.
	*SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecurityGroup.
func (sg SecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SecurityGroupPropertiesFormat != nil {
		objectMap["properties"] = sg.SecurityGroupPropertiesFormat
	}
	if sg.Etag != nil {
		objectMap["etag"] = sg.Etag
	}
	if sg.ID != nil {
		objectMap["id"] = sg.ID
	}
	if sg.Location != nil {
		objectMap["location"] = sg.Location
	}
	if sg.Tags != nil {
		objectMap["tags"] = sg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityGroup struct.
func (sg *SecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityGroupPropertiesFormat SecurityGroupPropertiesFormat
				err = json.Unmarshal(*v, &securityGroupPropertiesFormat)
				if err != nil {
					return err
				}
				sg.SecurityGroupPropertiesFormat = &securityGroupPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sg.Tags = tags
			}
		}
	}

	return nil
}

// SecurityGroupListResult response for ListNetworkSecurityGroups API service call.
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of NetworkSecurityGroup resources.
	Value *[]SecurityGroup `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityGroupListResultIterator provides access to a complete listing of SecurityGroup values.
type SecurityGroupListResultIterator struct {
	i    int
	page SecurityGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecurityGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityGroupListResultIterator) Response() SecurityGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityGroupListResultIterator) Value() SecurityGroup {
	if !iter.page.NotDone() {
		return SecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecurityGroupListResultIterator type.
func NewSecurityGroupListResultIterator(page SecurityGroupListResultPage) SecurityGroupListResultIterator {
	return SecurityGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sglr SecurityGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sglr SecurityGroupListResult) hasNextLink() bool {
	return sglr.NextLink != nil && len(*sglr.NextLink) != 0
}

// securityGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SecurityGroupListResult) securityGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// SecurityGroupListResultPage contains a page of SecurityGroup values.
type SecurityGroupListResultPage struct {
	fn   func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)
	sglr SecurityGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sglr)
		if err != nil {
			return err
		}
		page.sglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecurityGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityGroupListResultPage) Response() SecurityGroupListResult {
	return page.sglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityGroupListResultPage) Values() []SecurityGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// Creates a new instance of the SecurityGroupListResultPage type.
func NewSecurityGroupListResultPage(cur SecurityGroupListResult, getNextPage func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)) SecurityGroupListResultPage {
	return SecurityGroupListResultPage{
		fn:   getNextPage,
		sglr: cur,
	}
}

// SecurityGroupNetworkInterface network interface and all its associated security rules.
type SecurityGroupNetworkInterface struct {
	// ID - ID of the network interface.
	ID *string `json:"id,omitempty"`
	// SecurityRuleAssociations - All security rules associated with the network interface.
	SecurityRuleAssociations *SecurityRuleAssociations `json:"securityRuleAssociations,omitempty"`
}

// SecurityGroupPropertiesFormat network Security Group resource.
type SecurityGroupPropertiesFormat struct {
	// SecurityRules - A collection of security rules of the network security group.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
	// DefaultSecurityRules - The default security rules of network security group.
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	// NetworkInterfaces - READ-ONLY; A collection of references to network interfaces.
	NetworkInterfaces *[]Interface `json:"networkInterfaces,omitempty"`
	// Subnets - READ-ONLY; A collection of references to subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ResourceGUID - The resource GUID property of the network security group resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the network security group resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityGroupPropertiesFormat.
func (sgpf SecurityGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgpf.SecurityRules != nil {
		objectMap["securityRules"] = sgpf.SecurityRules
	}
	if sgpf.DefaultSecurityRules != nil {
		objectMap["defaultSecurityRules"] = sgpf.DefaultSecurityRules
	}
	if sgpf.ResourceGUID != nil {
		objectMap["resourceGuid"] = sgpf.ResourceGUID
	}
	if sgpf.ProvisioningState != "" {
		objectMap["provisioningState"] = sgpf.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// SecurityGroupResult network configuration diagnostic result corresponded provided traffic query.
type SecurityGroupResult struct {
	// SecurityRuleAccessResult - The network traffic is allowed or denied. Possible values include: 'SecurityRuleAccessAllow', 'SecurityRuleAccessDeny'
	SecurityRuleAccessResult SecurityRuleAccess `json:"securityRuleAccessResult,omitempty"`
	// EvaluatedNetworkSecurityGroups - READ-ONLY; List of results network security groups diagnostic.
	EvaluatedNetworkSecurityGroups *[]EvaluatedNetworkSecurityGroup `json:"evaluatedNetworkSecurityGroups,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityGroupResult.
func (sgr SecurityGroupResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgr.SecurityRuleAccessResult != "" {
		objectMap["securityRuleAccessResult"] = sgr.SecurityRuleAccessResult
	}
	return json.Marshal(objectMap)
}

// SecurityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SecurityGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityGroupsClient) (SecurityGroup, error)
}

// SecurityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityGroupsClient) (autorest.Response, error)
}

// SecurityGroupsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SecurityGroupsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityGroupsClient) (SecurityGroup, error)
}

// SecurityGroupViewParameters parameters that define the VM to check security groups for.
type SecurityGroupViewParameters struct {
	// TargetResourceID - ID of the target VM.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// SecurityGroupViewResult the information about security rules applied to the specified VM.
type SecurityGroupViewResult struct {
	autorest.Response `json:"-"`
	// NetworkInterfaces - List of network interfaces on the specified VM.
	NetworkInterfaces *[]SecurityGroupNetworkInterface `json:"networkInterfaces,omitempty"`
}

// SecurityRule network security rule.
type SecurityRule struct {
	autorest.Response `json:"-"`
	// SecurityRulePropertiesFormat - Properties of the security rule.
	*SecurityRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityRule.
func (sr SecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SecurityRulePropertiesFormat != nil {
		objectMap["properties"] = sr.SecurityRulePropertiesFormat
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityRule struct.
func (sr *SecurityRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityRulePropertiesFormat SecurityRulePropertiesFormat
				err = json.Unmarshal(*v, &securityRulePropertiesFormat)
				if err != nil {
					return err
				}
				sr.SecurityRulePropertiesFormat = &securityRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		}
	}

	return nil
}

// SecurityRuleAssociations all security rules associated with the network interface.
type SecurityRuleAssociations struct {
	// NetworkInterfaceAssociation - Network interface and it's custom security rules.
	NetworkInterfaceAssociation *InterfaceAssociation `json:"networkInterfaceAssociation,omitempty"`
	// SubnetAssociation - Subnet and it's custom security rules.
	SubnetAssociation *SubnetAssociation `json:"subnetAssociation,omitempty"`
	// DefaultSecurityRules - Collection of default security rules of the network security group.
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	// EffectiveSecurityRules - Collection of effective security rules.
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
}

// SecurityRuleListResult response for ListSecurityRule API service call. Retrieves all security rules that
// belongs to a network security group.
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The security rules in a network security group.
	Value *[]SecurityRule `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityRuleListResultIterator provides access to a complete listing of SecurityRule values.
type SecurityRuleListResultIterator struct {
	i    int
	page SecurityRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecurityRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityRuleListResultIterator) Response() SecurityRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityRuleListResultIterator) Value() SecurityRule {
	if !iter.page.NotDone() {
		return SecurityRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecurityRuleListResultIterator type.
func NewSecurityRuleListResultIterator(page SecurityRuleListResultPage) SecurityRuleListResultIterator {
	return SecurityRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srlr SecurityRuleListResult) IsEmpty() bool {
	return srlr.Value == nil || len(*srlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srlr SecurityRuleListResult) hasNextLink() bool {
	return srlr.NextLink != nil && len(*srlr.NextLink) != 0
}

// securityRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srlr SecurityRuleListResult) securityRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !srlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srlr.NextLink)))
}

// SecurityRuleListResultPage contains a page of SecurityRule values.
type SecurityRuleListResultPage struct {
	fn   func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)
	srlr SecurityRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srlr)
		if err != nil {
			return err
		}
		page.srlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecurityRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityRuleListResultPage) NotDone() bool {
	return !page.srlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityRuleListResultPage) Response() SecurityRuleListResult {
	return page.srlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityRuleListResultPage) Values() []SecurityRule {
	if page.srlr.IsEmpty() {
		return nil
	}
	return *page.srlr.Value
}

// Creates a new instance of the SecurityRuleListResultPage type.
func NewSecurityRuleListResultPage(cur SecurityRuleListResult, getNextPage func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)) SecurityRuleListResultPage {
	return SecurityRuleListResultPage{
		fn:   getNextPage,
		srlr: cur,
	}
}

// SecurityRulePropertiesFormat security rule resource.
type SecurityRulePropertiesFormat struct {
	// Description - A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Protocol - Network protocol this rule applies to. Possible values include: 'SecurityRuleProtocolTCP', 'SecurityRuleProtocolUDP', 'SecurityRuleProtocolIcmp', 'SecurityRuleProtocolEsp', 'SecurityRuleProtocolAsterisk'
	Protocol SecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourceAddressPrefix - The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// SourceAddressPrefixes - The CIDR or source IP ranges.
	SourceAddressPrefixes *[]string `json:"sourceAddressPrefixes,omitempty"`
	// SourceApplicationSecurityGroups - The application security group specified as source.
	SourceApplicationSecurityGroups *[]ApplicationSecurityGroup `json:"sourceApplicationSecurityGroups,omitempty"`
	// DestinationAddressPrefix - The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// DestinationAddressPrefixes - The destination address prefixes. CIDR or destination IP ranges.
	DestinationAddressPrefixes *[]string `json:"destinationAddressPrefixes,omitempty"`
	// DestinationApplicationSecurityGroups - The application security group specified as destination.
	DestinationApplicationSecurityGroups *[]ApplicationSecurityGroup `json:"destinationApplicationSecurityGroups,omitempty"`
	// SourcePortRanges - The source port ranges.
	SourcePortRanges *[]string `json:"sourcePortRanges,omitempty"`
	// DestinationPortRanges - The destination port ranges.
	DestinationPortRanges *[]string `json:"destinationPortRanges,omitempty"`
	// Access - The network traffic is allowed or denied. Possible values include: 'SecurityRuleAccessAllow', 'SecurityRuleAccessDeny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values include: 'SecurityRuleDirectionInbound', 'SecurityRuleDirectionOutbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
	// ProvisioningState - The provisioning state of the security rule resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// SecurityRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SecurityRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityRulesClient) (SecurityRule, error)
}

// SecurityRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityRulesClient) (autorest.Response, error)
}

// SecurityRulesEvaluationResult network security rules evaluation result.
type SecurityRulesEvaluationResult struct {
	// Name - Name of the network security rule.
	Name *string `json:"name,omitempty"`
	// ProtocolMatched - Value indicating whether protocol is matched.
	ProtocolMatched *bool `json:"protocolMatched,omitempty"`
	// SourceMatched - Value indicating whether source is matched.
	SourceMatched *bool `json:"sourceMatched,omitempty"`
	// SourcePortMatched - Value indicating whether source port is matched.
	SourcePortMatched *bool `json:"sourcePortMatched,omitempty"`
	// DestinationMatched - Value indicating whether destination is matched.
	DestinationMatched *bool `json:"destinationMatched,omitempty"`
	// DestinationPortMatched - Value indicating whether destination port is matched.
	DestinationPortMatched *bool `json:"destinationPortMatched,omitempty"`
}

// ServiceAssociationLink serviceAssociationLink resource.
type ServiceAssociationLink struct {
	// ServiceAssociationLinkPropertiesFormat - Resource navigation link properties format.
	*ServiceAssociationLinkPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceAssociationLink.
func (sal ServiceAssociationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sal.ServiceAssociationLinkPropertiesFormat != nil {
		objectMap["properties"] = sal.ServiceAssociationLinkPropertiesFormat
	}
	if sal.Name != nil {
		objectMap["name"] = sal.Name
	}
	if sal.Type != nil {
		objectMap["type"] = sal.Type
	}
	if sal.ID != nil {
		objectMap["id"] = sal.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceAssociationLink struct.
func (sal *ServiceAssociationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceAssociationLinkPropertiesFormat ServiceAssociationLinkPropertiesFormat
				err = json.Unmarshal(*v, &serviceAssociationLinkPropertiesFormat)
				if err != nil {
					return err
				}
				sal.ServiceAssociationLinkPropertiesFormat = &serviceAssociationLinkPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sal.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sal.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sal.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sal.ID = &ID
			}
		}
	}

	return nil
}

// ServiceAssociationLinkPropertiesFormat properties of ServiceAssociationLink.
type ServiceAssociationLinkPropertiesFormat struct {
	// LinkedResourceType - Resource type of the linked resource.
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`
	// Link - Link to the external resource.
	Link *string `json:"link,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the service association link resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// AllowDelete - If true, the resource can be deleted.
	AllowDelete *bool `json:"allowDelete,omitempty"`
	// Locations - A list of locations.
	Locations *[]string `json:"locations,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceAssociationLinkPropertiesFormat.
func (salpf ServiceAssociationLinkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if salpf.LinkedResourceType != nil {
		objectMap["linkedResourceType"] = salpf.LinkedResourceType
	}
	if salpf.Link != nil {
		objectMap["link"] = salpf.Link
	}
	if salpf.AllowDelete != nil {
		objectMap["allowDelete"] = salpf.AllowDelete
	}
	if salpf.Locations != nil {
		objectMap["locations"] = salpf.Locations
	}
	return json.Marshal(objectMap)
}

// ServiceAssociationLinksListResult response for ServiceAssociationLinks_List operation.
type ServiceAssociationLinksListResult struct {
	autorest.Response `json:"-"`
	// Value - The service association links in a subnet.
	Value *[]ServiceAssociationLink `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceAssociationLinksListResult.
func (sallr ServiceAssociationLinksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sallr.Value != nil {
		objectMap["value"] = sallr.Value
	}
	return json.Marshal(objectMap)
}

// ServiceDelegationPropertiesFormat properties of a service delegation.
type ServiceDelegationPropertiesFormat struct {
	// ServiceName - The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
	ServiceName *string `json:"serviceName,omitempty"`
	// Actions - Describes the actions permitted to the service upon delegation.
	Actions *[]string `json:"actions,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the service delegation resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceDelegationPropertiesFormat.
func (sdpf ServiceDelegationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdpf.ServiceName != nil {
		objectMap["serviceName"] = sdpf.ServiceName
	}
	if sdpf.Actions != nil {
		objectMap["actions"] = sdpf.Actions
	}
	return json.Marshal(objectMap)
}

// ServiceEndpointPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ServiceEndpointPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceEndpointPoliciesClient) (ServiceEndpointPolicy, error)
}

// ServiceEndpointPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServiceEndpointPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceEndpointPoliciesClient) (autorest.Response, error)
}

// ServiceEndpointPoliciesUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServiceEndpointPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceEndpointPoliciesClient) (ServiceEndpointPolicy, error)
}

// ServiceEndpointPolicy service End point policy resource.
type ServiceEndpointPolicy struct {
	autorest.Response `json:"-"`
	// ServiceEndpointPolicyPropertiesFormat - Properties of the service end point policy.
	*ServiceEndpointPolicyPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceEndpointPolicy.
func (sep ServiceEndpointPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sep.ServiceEndpointPolicyPropertiesFormat != nil {
		objectMap["properties"] = sep.ServiceEndpointPolicyPropertiesFormat
	}
	if sep.Etag != nil {
		objectMap["etag"] = sep.Etag
	}
	if sep.ID != nil {
		objectMap["id"] = sep.ID
	}
	if sep.Location != nil {
		objectMap["location"] = sep.Location
	}
	if sep.Tags != nil {
		objectMap["tags"] = sep.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceEndpointPolicy struct.
func (sep *ServiceEndpointPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceEndpointPolicyPropertiesFormat ServiceEndpointPolicyPropertiesFormat
				err = json.Unmarshal(*v, &serviceEndpointPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				sep.ServiceEndpointPolicyPropertiesFormat = &serviceEndpointPolicyPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sep.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sep.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sep.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sep.Tags = tags
			}
		}
	}

	return nil
}

// ServiceEndpointPolicyDefinition service Endpoint policy definitions.
type ServiceEndpointPolicyDefinition struct {
	autorest.Response `json:"-"`
	// ServiceEndpointPolicyDefinitionPropertiesFormat - Properties of the service endpoint policy definition.
	*ServiceEndpointPolicyDefinitionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceEndpointPolicyDefinition.
func (sepd ServiceEndpointPolicyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sepd.ServiceEndpointPolicyDefinitionPropertiesFormat != nil {
		objectMap["properties"] = sepd.ServiceEndpointPolicyDefinitionPropertiesFormat
	}
	if sepd.Name != nil {
		objectMap["name"] = sepd.Name
	}
	if sepd.Etag != nil {
		objectMap["etag"] = sepd.Etag
	}
	if sepd.ID != nil {
		objectMap["id"] = sepd.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceEndpointPolicyDefinition struct.
func (sepd *ServiceEndpointPolicyDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceEndpointPolicyDefinitionPropertiesFormat ServiceEndpointPolicyDefinitionPropertiesFormat
				err = json.Unmarshal(*v, &serviceEndpointPolicyDefinitionPropertiesFormat)
				if err != nil {
					return err
				}
				sepd.ServiceEndpointPolicyDefinitionPropertiesFormat = &serviceEndpointPolicyDefinitionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sepd.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sepd.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sepd.ID = &ID
			}
		}
	}

	return nil
}

// ServiceEndpointPolicyDefinitionListResult response for ListServiceEndpointPolicyDefinition API service
// call. Retrieves all service endpoint policy definition that belongs to a service endpoint policy.
type ServiceEndpointPolicyDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The service endpoint policy definition in a service endpoint policy.
	Value *[]ServiceEndpointPolicyDefinition `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceEndpointPolicyDefinitionListResultIterator provides access to a complete listing of
// ServiceEndpointPolicyDefinition values.
type ServiceEndpointPolicyDefinitionListResultIterator struct {
	i    int
	page ServiceEndpointPolicyDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceEndpointPolicyDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceEndpointPolicyDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceEndpointPolicyDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceEndpointPolicyDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceEndpointPolicyDefinitionListResultIterator) Response() ServiceEndpointPolicyDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceEndpointPolicyDefinitionListResultIterator) Value() ServiceEndpointPolicyDefinition {
	if !iter.page.NotDone() {
		return ServiceEndpointPolicyDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceEndpointPolicyDefinitionListResultIterator type.
func NewServiceEndpointPolicyDefinitionListResultIterator(page ServiceEndpointPolicyDefinitionListResultPage) ServiceEndpointPolicyDefinitionListResultIterator {
	return ServiceEndpointPolicyDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sepdlr ServiceEndpointPolicyDefinitionListResult) IsEmpty() bool {
	return sepdlr.Value == nil || len(*sepdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sepdlr ServiceEndpointPolicyDefinitionListResult) hasNextLink() bool {
	return sepdlr.NextLink != nil && len(*sepdlr.NextLink) != 0
}

// serviceEndpointPolicyDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sepdlr ServiceEndpointPolicyDefinitionListResult) serviceEndpointPolicyDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sepdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sepdlr.NextLink)))
}

// ServiceEndpointPolicyDefinitionListResultPage contains a page of ServiceEndpointPolicyDefinition values.
type ServiceEndpointPolicyDefinitionListResultPage struct {
	fn     func(context.Context, ServiceEndpointPolicyDefinitionListResult) (ServiceEndpointPolicyDefinitionListResult, error)
	sepdlr ServiceEndpointPolicyDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceEndpointPolicyDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceEndpointPolicyDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sepdlr)
		if err != nil {
			return err
		}
		page.sepdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceEndpointPolicyDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceEndpointPolicyDefinitionListResultPage) NotDone() bool {
	return !page.sepdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceEndpointPolicyDefinitionListResultPage) Response() ServiceEndpointPolicyDefinitionListResult {
	return page.sepdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceEndpointPolicyDefinitionListResultPage) Values() []ServiceEndpointPolicyDefinition {
	if page.sepdlr.IsEmpty() {
		return nil
	}
	return *page.sepdlr.Value
}

// Creates a new instance of the ServiceEndpointPolicyDefinitionListResultPage type.
func NewServiceEndpointPolicyDefinitionListResultPage(cur ServiceEndpointPolicyDefinitionListResult, getNextPage func(context.Context, ServiceEndpointPolicyDefinitionListResult) (ServiceEndpointPolicyDefinitionListResult, error)) ServiceEndpointPolicyDefinitionListResultPage {
	return ServiceEndpointPolicyDefinitionListResultPage{
		fn:     getNextPage,
		sepdlr: cur,
	}
}

// ServiceEndpointPolicyDefinitionPropertiesFormat service Endpoint policy definition resource.
type ServiceEndpointPolicyDefinitionPropertiesFormat struct {
	// Description - A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Service - Service endpoint name.
	Service *string `json:"service,omitempty"`
	// ServiceResources - A list of service resources.
	ServiceResources *[]string `json:"serviceResources,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the service endpoint policy definition resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceEndpointPolicyDefinitionPropertiesFormat.
func (sepdpf ServiceEndpointPolicyDefinitionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sepdpf.Description != nil {
		objectMap["description"] = sepdpf.Description
	}
	if sepdpf.Service != nil {
		objectMap["service"] = sepdpf.Service
	}
	if sepdpf.ServiceResources != nil {
		objectMap["serviceResources"] = sepdpf.ServiceResources
	}
	return json.Marshal(objectMap)
}

// ServiceEndpointPolicyDefinitionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ServiceEndpointPolicyDefinitionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceEndpointPolicyDefinitionsClient) (ServiceEndpointPolicyDefinition, error)
}

// ServiceEndpointPolicyDefinitionsDeleteFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ServiceEndpointPolicyDefinitionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServiceEndpointPolicyDefinitionsClient) (autorest.Response, error)
}

// ServiceEndpointPolicyListResult response for ListServiceEndpointPolicies API service call.
type ServiceEndpointPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ServiceEndpointPolicy resources.
	Value *[]ServiceEndpointPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceEndpointPolicyListResult.
func (seplr ServiceEndpointPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if seplr.Value != nil {
		objectMap["value"] = seplr.Value
	}
	return json.Marshal(objectMap)
}

// ServiceEndpointPolicyListResultIterator provides access to a complete listing of ServiceEndpointPolicy
// values.
type ServiceEndpointPolicyListResultIterator struct {
	i    int
	page ServiceEndpointPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceEndpointPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceEndpointPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceEndpointPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceEndpointPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceEndpointPolicyListResultIterator) Response() ServiceEndpointPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceEndpointPolicyListResultIterator) Value() ServiceEndpointPolicy {
	if !iter.page.NotDone() {
		return ServiceEndpointPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceEndpointPolicyListResultIterator type.
func NewServiceEndpointPolicyListResultIterator(page ServiceEndpointPolicyListResultPage) ServiceEndpointPolicyListResultIterator {
	return ServiceEndpointPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (seplr ServiceEndpointPolicyListResult) IsEmpty() bool {
	return seplr.Value == nil || len(*seplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (seplr ServiceEndpointPolicyListResult) hasNextLink() bool {
	return seplr.NextLink != nil && len(*seplr.NextLink) != 0
}

// serviceEndpointPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (seplr ServiceEndpointPolicyListResult) serviceEndpointPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !seplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(seplr.NextLink)))
}

// ServiceEndpointPolicyListResultPage contains a page of ServiceEndpointPolicy values.
type ServiceEndpointPolicyListResultPage struct {
	fn    func(context.Context, ServiceEndpointPolicyListResult) (ServiceEndpointPolicyListResult, error)
	seplr ServiceEndpointPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceEndpointPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceEndpointPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.seplr)
		if err != nil {
			return err
		}
		page.seplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceEndpointPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceEndpointPolicyListResultPage) NotDone() bool {
	return !page.seplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceEndpointPolicyListResultPage) Response() ServiceEndpointPolicyListResult {
	return page.seplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceEndpointPolicyListResultPage) Values() []ServiceEndpointPolicy {
	if page.seplr.IsEmpty() {
		return nil
	}
	return *page.seplr.Value
}

// Creates a new instance of the ServiceEndpointPolicyListResultPage type.
func NewServiceEndpointPolicyListResultPage(cur ServiceEndpointPolicyListResult, getNextPage func(context.Context, ServiceEndpointPolicyListResult) (ServiceEndpointPolicyListResult, error)) ServiceEndpointPolicyListResultPage {
	return ServiceEndpointPolicyListResultPage{
		fn:    getNextPage,
		seplr: cur,
	}
}

// ServiceEndpointPolicyPropertiesFormat service Endpoint Policy resource.
type ServiceEndpointPolicyPropertiesFormat struct {
	// ServiceEndpointPolicyDefinitions - A collection of service endpoint policy definitions of the service endpoint policy.
	ServiceEndpointPolicyDefinitions *[]ServiceEndpointPolicyDefinition `json:"serviceEndpointPolicyDefinitions,omitempty"`
	// Subnets - READ-ONLY; A collection of references to subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ResourceGUID - READ-ONLY; The resource GUID property of the service endpoint policy resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the service endpoint policy resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceEndpointPolicyPropertiesFormat.
func (seppf ServiceEndpointPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if seppf.ServiceEndpointPolicyDefinitions != nil {
		objectMap["serviceEndpointPolicyDefinitions"] = seppf.ServiceEndpointPolicyDefinitions
	}
	return json.Marshal(objectMap)
}

// ServiceEndpointPropertiesFormat the service endpoint properties.
type ServiceEndpointPropertiesFormat struct {
	// Service - The type of the endpoint service.
	Service *string `json:"service,omitempty"`
	// Locations - A list of locations.
	Locations *[]string `json:"locations,omitempty"`
	// ProvisioningState - The provisioning state of the service endpoint resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ServiceTagInformation the service tag information.
type ServiceTagInformation struct {
	// Properties - READ-ONLY; Properties of the service tag information.
	Properties *ServiceTagInformationPropertiesFormat `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of service tag.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of service tag.
	ID *string `json:"id,omitempty"`
}

// ServiceTagInformationPropertiesFormat properties of the service tag information.
type ServiceTagInformationPropertiesFormat struct {
	// ChangeNumber - READ-ONLY; The iteration number of service tag.
	ChangeNumber *string `json:"changeNumber,omitempty"`
	// Region - READ-ONLY; The region of service tag.
	Region *string `json:"region,omitempty"`
	// SystemService - READ-ONLY; The name of system service.
	SystemService *string `json:"systemService,omitempty"`
	// AddressPrefixes - READ-ONLY; The list of IP address prefixes.
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ServiceTagsListResult response for the ListServiceTags API service call.
type ServiceTagsListResult struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The name of the cloud.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the cloud.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The azure resource type.
	Type *string `json:"type,omitempty"`
	// ChangeNumber - READ-ONLY; The iteration number.
	ChangeNumber *string `json:"changeNumber,omitempty"`
	// Cloud - READ-ONLY; The name of the cloud.
	Cloud *string `json:"cloud,omitempty"`
	// Values - READ-ONLY; The list of service tag information resources.
	Values *[]ServiceTagInformation `json:"values,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// Subnet subnet in a virtual network resource.
type Subnet struct {
	autorest.Response `json:"-"`
	// SubnetPropertiesFormat - Properties of the subnet.
	*SubnetPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SubnetPropertiesFormat != nil {
		objectMap["properties"] = s.SubnetPropertiesFormat
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Subnet struct.
func (s *Subnet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subnetPropertiesFormat SubnetPropertiesFormat
				err = json.Unmarshal(*v, &subnetPropertiesFormat)
				if err != nil {
					return err
				}
				s.SubnetPropertiesFormat = &subnetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		}
	}

	return nil
}

// SubnetAssociation subnet and it's custom security rules.
type SubnetAssociation struct {
	// ID - READ-ONLY; Subnet ID.
	ID *string `json:"id,omitempty"`
	// SecurityRules - Collection of custom security rules.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// MarshalJSON is the custom marshaler for SubnetAssociation.
func (sa SubnetAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SecurityRules != nil {
		objectMap["securityRules"] = sa.SecurityRules
	}
	return json.Marshal(objectMap)
}

// SubnetListResult response for ListSubnets API service callRetrieves all subnet that belongs to a virtual
// network.
type SubnetListResult struct {
	autorest.Response `json:"-"`
	// Value - The subnets in a virtual network.
	Value *[]Subnet `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubnetListResultIterator provides access to a complete listing of Subnet values.
type SubnetListResultIterator struct {
	i    int
	page SubnetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubnetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubnetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubnetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubnetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubnetListResultIterator) Response() SubnetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubnetListResultIterator) Value() Subnet {
	if !iter.page.NotDone() {
		return Subnet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubnetListResultIterator type.
func NewSubnetListResultIterator(page SubnetListResultPage) SubnetListResultIterator {
	return SubnetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubnetListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SubnetListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// subnetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubnetListResult) subnetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubnetListResultPage contains a page of Subnet values.
type SubnetListResultPage struct {
	fn  func(context.Context, SubnetListResult) (SubnetListResult, error)
	slr SubnetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubnetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubnetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubnetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubnetListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubnetListResultPage) Response() SubnetListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubnetListResultPage) Values() []Subnet {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SubnetListResultPage type.
func NewSubnetListResultPage(cur SubnetListResult, getNextPage func(context.Context, SubnetListResult) (SubnetListResult, error)) SubnetListResultPage {
	return SubnetListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// SubnetPropertiesFormat properties of the subnet.
type SubnetPropertiesFormat struct {
	// AddressPrefix - The address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// AddressPrefixes - List of address prefixes for the subnet.
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
	// NetworkSecurityGroup - The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// RouteTable - The reference of the RouteTable resource.
	RouteTable *RouteTable `json:"routeTable,omitempty"`
	// NatGateway - Nat gateway associated with this subnet.
	NatGateway *SubResource `json:"natGateway,omitempty"`
	// ServiceEndpoints - An array of service endpoints.
	ServiceEndpoints *[]ServiceEndpointPropertiesFormat `json:"serviceEndpoints,omitempty"`
	// ServiceEndpointPolicies - An array of service endpoint policies.
	ServiceEndpointPolicies *[]ServiceEndpointPolicy `json:"serviceEndpointPolicies,omitempty"`
	// PrivateEndpoints - READ-ONLY; An array of references to private endpoints.
	PrivateEndpoints *[]PrivateEndpoint `json:"privateEndpoints,omitempty"`
	// IPConfigurations - READ-ONLY; An array of references to the network interface IP configurations using subnet.
	IPConfigurations *[]IPConfiguration `json:"ipConfigurations,omitempty"`
	// IPConfigurationProfiles - READ-ONLY; Array of IP configuration profiles which reference this subnet.
	IPConfigurationProfiles *[]IPConfigurationProfile `json:"ipConfigurationProfiles,omitempty"`
	// ResourceNavigationLinks - An array of references to the external resources using subnet.
	ResourceNavigationLinks *[]ResourceNavigationLink `json:"resourceNavigationLinks,omitempty"`
	// ServiceAssociationLinks - An array of references to services injecting into this subnet.
	ServiceAssociationLinks *[]ServiceAssociationLink `json:"serviceAssociationLinks,omitempty"`
	// Delegations - An array of references to the delegations on the subnet.
	Delegations *[]Delegation `json:"delegations,omitempty"`
	// Purpose - READ-ONLY; A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties.
	Purpose *string `json:"purpose,omitempty"`
	// ProvisioningState - The provisioning state of the subnet resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpointNetworkPolicies - Enable or Disable apply network policies on private end point in the subnet.
	PrivateEndpointNetworkPolicies *string `json:"privateEndpointNetworkPolicies,omitempty"`
	// PrivateLinkServiceNetworkPolicies - Enable or Disable apply network policies on private link service in the subnet.
	PrivateLinkServiceNetworkPolicies *string `json:"privateLinkServiceNetworkPolicies,omitempty"`
}

// MarshalJSON is the custom marshaler for SubnetPropertiesFormat.
func (spf SubnetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spf.AddressPrefix != nil {
		objectMap["addressPrefix"] = spf.AddressPrefix
	}
	if spf.AddressPrefixes != nil {
		objectMap["addressPrefixes"] = spf.AddressPrefixes
	}
	if spf.NetworkSecurityGroup != nil {
		objectMap["networkSecurityGroup"] = spf.NetworkSecurityGroup
	}
	if spf.RouteTable != nil {
		objectMap["routeTable"] = spf.RouteTable
	}
	if spf.NatGateway != nil {
		objectMap["natGateway"] = spf.NatGateway
	}
	if spf.ServiceEndpoints != nil {
		objectMap["serviceEndpoints"] = spf.ServiceEndpoints
	}
	if spf.ServiceEndpointPolicies != nil {
		objectMap["serviceEndpointPolicies"] = spf.ServiceEndpointPolicies
	}
	if spf.ResourceNavigationLinks != nil {
		objectMap["resourceNavigationLinks"] = spf.ResourceNavigationLinks
	}
	if spf.ServiceAssociationLinks != nil {
		objectMap["serviceAssociationLinks"] = spf.ServiceAssociationLinks
	}
	if spf.Delegations != nil {
		objectMap["delegations"] = spf.Delegations
	}
	if spf.ProvisioningState != "" {
		objectMap["provisioningState"] = spf.ProvisioningState
	}
	if spf.PrivateEndpointNetworkPolicies != nil {
		objectMap["privateEndpointNetworkPolicies"] = spf.PrivateEndpointNetworkPolicies
	}
	if spf.PrivateLinkServiceNetworkPolicies != nil {
		objectMap["privateLinkServiceNetworkPolicies"] = spf.PrivateLinkServiceNetworkPolicies
	}
	return json.Marshal(objectMap)
}

// SubnetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubnetsClient) (Subnet, error)
}

// SubnetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubnetsClient) (autorest.Response, error)
}

// SubnetsPrepareNetworkPoliciesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SubnetsPrepareNetworkPoliciesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubnetsClient) (autorest.Response, error)
}

// SubnetsUnprepareNetworkPoliciesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SubnetsUnprepareNetworkPoliciesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubnetsClient) (autorest.Response, error)
}

// SubResource reference to another subresource.
type SubResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// Topology topology of the specified resource group.
type Topology struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; GUID representing the operation id.
	ID *string `json:"id,omitempty"`
	// CreatedDateTime - READ-ONLY; The datetime when the topology was initially created for the resource group.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// LastModified - READ-ONLY; The datetime when the topology was last modified.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// Resources - A list of topology resources.
	Resources *[]TopologyResource `json:"resources,omitempty"`
}

// MarshalJSON is the custom marshaler for Topology.
func (t Topology) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Resources != nil {
		objectMap["resources"] = t.Resources
	}
	return json.Marshal(objectMap)
}

// TopologyAssociation resources that have an association with the parent resource.
type TopologyAssociation struct {
	// Name - The name of the resource that is associated with the parent resource.
	Name *string `json:"name,omitempty"`
	// ResourceID - The ID of the resource that is associated with the parent resource.
	ResourceID *string `json:"resourceId,omitempty"`
	// AssociationType - The association type of the child resource to the parent resource. Possible values include: 'Associated', 'Contains'
	AssociationType AssociationType `json:"associationType,omitempty"`
}

// TopologyParameters parameters that define the representation of topology.
type TopologyParameters struct {
	// TargetResourceGroupName - The name of the target resource group to perform topology on.
	TargetResourceGroupName *string `json:"targetResourceGroupName,omitempty"`
	// TargetVirtualNetwork - The reference of the Virtual Network resource.
	TargetVirtualNetwork *SubResource `json:"targetVirtualNetwork,omitempty"`
	// TargetSubnet - The reference of the Subnet resource.
	TargetSubnet *SubResource `json:"targetSubnet,omitempty"`
}

// TopologyResource the network resource topology information for the given resource group.
type TopologyResource struct {
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - ID of the resource.
	ID *string `json:"id,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Associations - Holds the associations the resource has with other resources in the resource group.
	Associations *[]TopologyAssociation `json:"associations,omitempty"`
}

// TrafficAnalyticsConfigurationProperties parameters that define the configuration of traffic analytics.
type TrafficAnalyticsConfigurationProperties struct {
	// Enabled - Flag to enable/disable traffic analytics.
	Enabled *bool `json:"enabled,omitempty"`
	// WorkspaceID - The resource guid of the attached workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// WorkspaceRegion - The location of the attached workspace.
	WorkspaceRegion *string `json:"workspaceRegion,omitempty"`
	// WorkspaceResourceID - Resource Id of the attached workspace.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
	// TrafficAnalyticsInterval - The interval in minutes which would decide how frequently TA service should do flow analytics.
	TrafficAnalyticsInterval *int32 `json:"trafficAnalyticsInterval,omitempty"`
}

// TrafficAnalyticsProperties parameters that define the configuration of traffic analytics.
type TrafficAnalyticsProperties struct {
	// NetworkWatcherFlowAnalyticsConfiguration - Parameters that define the configuration of traffic analytics.
	NetworkWatcherFlowAnalyticsConfiguration *TrafficAnalyticsConfigurationProperties `json:"networkWatcherFlowAnalyticsConfiguration,omitempty"`
}

// TrafficSelectorPolicy an traffic selector policy for a virtual network gateway connection.
type TrafficSelectorPolicy struct {
	// LocalAddressRanges - A collection of local address spaces in CIDR format
	LocalAddressRanges *[]string `json:"localAddressRanges,omitempty"`
	// RemoteAddressRanges - A collection of remote address spaces in CIDR format
	RemoteAddressRanges *[]string `json:"remoteAddressRanges,omitempty"`
}

// TroubleshootingDetails information gained from troubleshooting of specified resource.
type TroubleshootingDetails struct {
	// ID - The id of the get troubleshoot operation.
	ID *string `json:"id,omitempty"`
	// ReasonType - Reason type of failure.
	ReasonType *string `json:"reasonType,omitempty"`
	// Summary - A summary of troubleshooting.
	Summary *string `json:"summary,omitempty"`
	// Detail - Details on troubleshooting results.
	Detail *string `json:"detail,omitempty"`
	// RecommendedActions - List of recommended actions.
	RecommendedActions *[]TroubleshootingRecommendedActions `json:"recommendedActions,omitempty"`
}

// TroubleshootingParameters parameters that define the resource to troubleshoot.
type TroubleshootingParameters struct {
	// TargetResourceID - The target resource to troubleshoot.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// TroubleshootingProperties - Properties of the troubleshooting resource.
	*TroubleshootingProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TroubleshootingParameters.
func (tp TroubleshootingParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.TargetResourceID != nil {
		objectMap["targetResourceId"] = tp.TargetResourceID
	}
	if tp.TroubleshootingProperties != nil {
		objectMap["properties"] = tp.TroubleshootingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TroubleshootingParameters struct.
func (tp *TroubleshootingParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetResourceId":
			if v != nil {
				var targetResourceID string
				err = json.Unmarshal(*v, &targetResourceID)
				if err != nil {
					return err
				}
				tp.TargetResourceID = &targetResourceID
			}
		case "properties":
			if v != nil {
				var troubleshootingProperties TroubleshootingProperties
				err = json.Unmarshal(*v, &troubleshootingProperties)
				if err != nil {
					return err
				}
				tp.TroubleshootingProperties = &troubleshootingProperties
			}
		}
	}

	return nil
}

// TroubleshootingProperties storage location provided for troubleshoot.
type TroubleshootingProperties struct {
	// StorageID - The ID for the storage account to save the troubleshoot result.
	StorageID *string `json:"storageId,omitempty"`
	// StoragePath - The path to the blob to save the troubleshoot result in.
	StoragePath *string `json:"storagePath,omitempty"`
}

// TroubleshootingRecommendedActions recommended actions based on discovered issues.
type TroubleshootingRecommendedActions struct {
	// ActionID - ID of the recommended action.
	ActionID *string `json:"actionId,omitempty"`
	// ActionText - Description of recommended actions.
	ActionText *string `json:"actionText,omitempty"`
	// ActionURI - The uri linking to a documentation for the recommended troubleshooting actions.
	ActionURI *string `json:"actionUri,omitempty"`
	// ActionURIText - The information from the URI for the recommended troubleshooting actions.
	ActionURIText *string `json:"actionUriText,omitempty"`
}

// TroubleshootingResult troubleshooting information gained from specified resource.
type TroubleshootingResult struct {
	autorest.Response `json:"-"`
	// StartTime - The start time of the troubleshooting.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the troubleshooting.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Code - The result code of the troubleshooting.
	Code *string `json:"code,omitempty"`
	// Results - Information from troubleshooting.
	Results *[]TroubleshootingDetails `json:"results,omitempty"`
}

// TunnelConnectionHealth virtualNetworkGatewayConnection properties.
type TunnelConnectionHealth struct {
	// Tunnel - READ-ONLY; Tunnel name.
	Tunnel *string `json:"tunnel,omitempty"`
	// ConnectionStatus - READ-ONLY; Virtual Network Gateway connection status. Possible values include: 'VirtualNetworkGatewayConnectionStatusUnknown', 'VirtualNetworkGatewayConnectionStatusConnecting', 'VirtualNetworkGatewayConnectionStatusConnected', 'VirtualNetworkGatewayConnectionStatusNotConnected'
	ConnectionStatus VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	// IngressBytesTransferred - READ-ONLY; The Ingress Bytes Transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty"`
	// EgressBytesTransferred - READ-ONLY; The Egress Bytes Transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty"`
	// LastConnectionEstablishedUtcTime - READ-ONLY; The time at which connection was established in Utc format.
	LastConnectionEstablishedUtcTime *string `json:"lastConnectionEstablishedUtcTime,omitempty"`
}

// UnprepareNetworkPoliciesRequest details of UnprepareNetworkPolicies for Subnet.
type UnprepareNetworkPoliciesRequest struct {
	// ServiceName - The name of the service for which subnet is being unprepared for.
	ServiceName *string `json:"serviceName,omitempty"`
}

// Usage describes network resource usage.
type Usage struct {
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Unit - An enum describing the unit of measurement.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Unit != nil {
		objectMap["unit"] = u.Unit
	}
	if u.CurrentValue != nil {
		objectMap["currentValue"] = u.CurrentValue
	}
	if u.Limit != nil {
		objectMap["limit"] = u.Limit
	}
	if u.Name != nil {
		objectMap["name"] = u.Name
	}
	return json.Marshal(objectMap)
}

// UsageName the usage names.
type UsageName struct {
	// Value - A string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - A localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult the list usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list network resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsagesListResultIterator provides access to a complete listing of Usage values.
type UsagesListResultIterator struct {
	i    int
	page UsagesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsagesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsagesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsagesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsagesListResultIterator) Response() UsagesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsagesListResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsagesListResultIterator type.
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return UsagesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UsagesListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ulr UsagesListResult) hasNextLink() bool {
	return ulr.NextLink != nil && len(*ulr.NextLink) != 0
}

// usagesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsagesListResult) usagesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// UsagesListResultPage contains a page of Usage values.
type UsagesListResultPage struct {
	fn  func(context.Context, UsagesListResult) (UsagesListResult, error)
	ulr UsagesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsagesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ulr)
		if err != nil {
			return err
		}
		page.ulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsagesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsagesListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsagesListResultPage) Response() UsagesListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsagesListResultPage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Creates a new instance of the UsagesListResultPage type.
func NewUsagesListResultPage(cur UsagesListResult, getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return UsagesListResultPage{
		fn:  getNextPage,
		ulr: cur,
	}
}

// VerificationIPFlowParameters parameters that define the IP flow to be verified.
type VerificationIPFlowParameters struct {
	// TargetResourceID - The ID of the target resource to perform next-hop on.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// Direction - The direction of the packet represented as a 5-tuple. Possible values include: 'Inbound', 'Outbound'
	Direction Direction `json:"direction,omitempty"`
	// Protocol - Protocol to be verified on. Possible values include: 'IPFlowProtocolTCP', 'IPFlowProtocolUDP'
	Protocol IPFlowProtocol `json:"protocol,omitempty"`
	// LocalPort - The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction.
	LocalPort *string `json:"localPort,omitempty"`
	// RemotePort - The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction.
	RemotePort *string `json:"remotePort,omitempty"`
	// LocalIPAddress - The local IP address. Acceptable values are valid IPv4 addresses.
	LocalIPAddress *string `json:"localIPAddress,omitempty"`
	// RemoteIPAddress - The remote IP address. Acceptable values are valid IPv4 addresses.
	RemoteIPAddress *string `json:"remoteIPAddress,omitempty"`
	// TargetNicResourceID - The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of them, then this parameter must be specified. Otherwise optional).
	TargetNicResourceID *string `json:"targetNicResourceId,omitempty"`
}

// VerificationIPFlowResult results of IP flow verification on the target resource.
type VerificationIPFlowResult struct {
	autorest.Response `json:"-"`
	// Access - Indicates whether the traffic is allowed or denied. Possible values include: 'Allow', 'Deny'
	Access Access `json:"access,omitempty"`
	// RuleName - Name of the rule. If input is not matched against any security rule, it is not displayed.
	RuleName *string `json:"ruleName,omitempty"`
}

// VirtualHub virtualHub Resource.
type VirtualHub struct {
	autorest.Response `json:"-"`
	// VirtualHubProperties - Properties of the virtual hub.
	*VirtualHubProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualHub.
func (vh VirtualHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vh.VirtualHubProperties != nil {
		objectMap["properties"] = vh.VirtualHubProperties
	}
	if vh.ID != nil {
		objectMap["id"] = vh.ID
	}
	if vh.Location != nil {
		objectMap["location"] = vh.Location
	}
	if vh.Tags != nil {
		objectMap["tags"] = vh.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualHub struct.
func (vh *VirtualHub) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualHubProperties VirtualHubProperties
				err = json.Unmarshal(*v, &virtualHubProperties)
				if err != nil {
					return err
				}
				vh.VirtualHubProperties = &virtualHubProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vh.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vh.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vh.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vh.Tags = tags
			}
		}
	}

	return nil
}

// VirtualHubID virtual Hub identifier.
type VirtualHubID struct {
	// ID - The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
	ID *string `json:"id,omitempty"`
}

// VirtualHubProperties parameters for VirtualHub.
type VirtualHubProperties struct {
	// VirtualWan - The VirtualWAN to which the VirtualHub belongs.
	VirtualWan *SubResource `json:"virtualWan,omitempty"`
	// VpnGateway - The VpnGateway associated with this VirtualHub.
	VpnGateway *SubResource `json:"vpnGateway,omitempty"`
	// P2SVpnGateway - The P2SVpnGateway associated with this VirtualHub.
	P2SVpnGateway *SubResource `json:"p2SVpnGateway,omitempty"`
	// ExpressRouteGateway - The expressRouteGateway associated with this VirtualHub.
	ExpressRouteGateway *SubResource `json:"expressRouteGateway,omitempty"`
	// VirtualNetworkConnections - List of all vnet connections with this VirtualHub.
	VirtualNetworkConnections *[]HubVirtualNetworkConnection `json:"virtualNetworkConnections,omitempty"`
	// AddressPrefix - Address-prefix for this VirtualHub.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// RouteTable - The routeTable associated with this virtual hub.
	RouteTable *VirtualHubRouteTable `json:"routeTable,omitempty"`
	// ProvisioningState - The provisioning state of the virtual hub resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// VirtualHubRoute virtualHub route.
type VirtualHubRoute struct {
	// AddressPrefixes - List of all addressPrefixes.
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
	// NextHopIPAddress - NextHop ip address.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
}

// VirtualHubRouteTable virtualHub route table.
type VirtualHubRouteTable struct {
	// Routes - List of all routes.
	Routes *[]VirtualHubRoute `json:"routes,omitempty"`
}

// VirtualHubsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualHubsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualHubsClient) (VirtualHub, error)
}

// VirtualHubsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualHubsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualHubsClient) (autorest.Response, error)
}

// VirtualHubsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualHubsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualHubsClient) (VirtualHub, error)
}

// VirtualNetwork virtual Network resource.
type VirtualNetwork struct {
	autorest.Response `json:"-"`
	// VirtualNetworkPropertiesFormat - Properties of the virtual network.
	*VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkPropertiesFormat != nil {
		objectMap["properties"] = vn.VirtualNetworkPropertiesFormat
	}
	if vn.Etag != nil {
		objectMap["etag"] = vn.Etag
	}
	if vn.ID != nil {
		objectMap["id"] = vn.ID
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPropertiesFormat VirtualNetworkPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkPropertiesFormat)
				if err != nil {
					return err
				}
				vn.VirtualNetworkPropertiesFormat = &virtualNetworkPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vn.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkConnectionGatewayReference a reference to VirtualNetworkGateway or LocalNetworkGateway
// resource.
type VirtualNetworkConnectionGatewayReference struct {
	// ID - The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
	ID *string `json:"id,omitempty"`
}

// VirtualNetworkGateway a common class for general resource information.
type VirtualNetworkGateway struct {
	autorest.Response `json:"-"`
	// VirtualNetworkGatewayPropertiesFormat - Properties of the virtual network gateway.
	*VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGateway.
func (vng VirtualNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vng.VirtualNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = vng.VirtualNetworkGatewayPropertiesFormat
	}
	if vng.Etag != nil {
		objectMap["etag"] = vng.Etag
	}
	if vng.ID != nil {
		objectMap["id"] = vng.ID
	}
	if vng.Location != nil {
		objectMap["location"] = vng.Location
	}
	if vng.Tags != nil {
		objectMap["tags"] = vng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGateway struct.
func (vng *VirtualNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayPropertiesFormat VirtualNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				vng.VirtualNetworkGatewayPropertiesFormat = &virtualNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vng.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnection a common class for general resource information.
type VirtualNetworkGatewayConnection struct {
	autorest.Response `json:"-"`
	// VirtualNetworkGatewayConnectionPropertiesFormat - Properties of the virtual network gateway connection.
	*VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnection.
func (vngc VirtualNetworkGatewayConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngc.VirtualNetworkGatewayConnectionPropertiesFormat != nil {
		objectMap["properties"] = vngc.VirtualNetworkGatewayConnectionPropertiesFormat
	}
	if vngc.Etag != nil {
		objectMap["etag"] = vngc.Etag
	}
	if vngc.ID != nil {
		objectMap["id"] = vngc.ID
	}
	if vngc.Location != nil {
		objectMap["location"] = vngc.Location
	}
	if vngc.Tags != nil {
		objectMap["tags"] = vngc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayConnection struct.
func (vngc *VirtualNetworkGatewayConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayConnectionPropertiesFormat VirtualNetworkGatewayConnectionPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				vngc.VirtualNetworkGatewayConnectionPropertiesFormat = &virtualNetworkGatewayConnectionPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vngc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vngc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vngc.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnectionListEntity a common class for general resource information.
type VirtualNetworkGatewayConnectionListEntity struct {
	// VirtualNetworkGatewayConnectionListEntityPropertiesFormat - Properties of the virtual network gateway connection.
	*VirtualNetworkGatewayConnectionListEntityPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnectionListEntity.
func (vngcle VirtualNetworkGatewayConnectionListEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngcle.VirtualNetworkGatewayConnectionListEntityPropertiesFormat != nil {
		objectMap["properties"] = vngcle.VirtualNetworkGatewayConnectionListEntityPropertiesFormat
	}
	if vngcle.Etag != nil {
		objectMap["etag"] = vngcle.Etag
	}
	if vngcle.ID != nil {
		objectMap["id"] = vngcle.ID
	}
	if vngcle.Location != nil {
		objectMap["location"] = vngcle.Location
	}
	if vngcle.Tags != nil {
		objectMap["tags"] = vngcle.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayConnectionListEntity struct.
func (vngcle *VirtualNetworkGatewayConnectionListEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayConnectionListEntityPropertiesFormat VirtualNetworkGatewayConnectionListEntityPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayConnectionListEntityPropertiesFormat)
				if err != nil {
					return err
				}
				vngcle.VirtualNetworkGatewayConnectionListEntityPropertiesFormat = &virtualNetworkGatewayConnectionListEntityPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngcle.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngcle.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngcle.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vngcle.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vngcle.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vngcle.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnectionListEntityPropertiesFormat virtualNetworkGatewayConnection properties.
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat struct {
	// AuthorizationKey - The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// VirtualNetworkGateway1 - The reference to virtual network gateway resource.
	VirtualNetworkGateway1 *VirtualNetworkConnectionGatewayReference `json:"virtualNetworkGateway1,omitempty"`
	// VirtualNetworkGateway2 - The reference to virtual network gateway resource.
	VirtualNetworkGateway2 *VirtualNetworkConnectionGatewayReference `json:"virtualNetworkGateway2,omitempty"`
	// LocalNetworkGateway2 - The reference to local network gateway resource.
	LocalNetworkGateway2 *VirtualNetworkConnectionGatewayReference `json:"localNetworkGateway2,omitempty"`
	// ConnectionType - Gateway connection type. Possible values include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
	ConnectionType VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`
	// ConnectionProtocol - Connection protocol used for this connection. Possible values include: 'IKEv2', 'IKEv1'
	ConnectionProtocol VirtualNetworkGatewayConnectionProtocol `json:"connectionProtocol,omitempty"`
	// RoutingWeight - The routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`
	// SharedKey - The IPSec shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// ConnectionStatus - READ-ONLY; Virtual Network Gateway connection status. Possible values include: 'VirtualNetworkGatewayConnectionStatusUnknown', 'VirtualNetworkGatewayConnectionStatusConnecting', 'VirtualNetworkGatewayConnectionStatusConnected', 'VirtualNetworkGatewayConnectionStatusNotConnected'
	ConnectionStatus VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	// TunnelConnectionStatus - READ-ONLY; Collection of all tunnels' connection health status.
	TunnelConnectionStatus *[]TunnelConnectionHealth `json:"tunnelConnectionStatus,omitempty"`
	// EgressBytesTransferred - READ-ONLY; The egress bytes transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty"`
	// IngressBytesTransferred - READ-ONLY; The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty"`
	// Peer - The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`
	// EnableBgp - EnableBgp flag.
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// UsePolicyBasedTrafficSelectors - Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`
	// IpsecPolicies - The IPSec Policies to be considered by this connection.
	IpsecPolicies *[]IpsecPolicy `json:"ipsecPolicies,omitempty"`
	// TrafficSelectorPolicies - The Traffic Selector Policies to be considered by this connection.
	TrafficSelectorPolicies *[]TrafficSelectorPolicy `json:"trafficSelectorPolicies,omitempty"`
	// ResourceGUID - The resource GUID property of the virtual network gateway connection resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the virtual network gateway connection resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ExpressRouteGatewayBypass - Bypass ExpressRoute Gateway for data forwarding.
	ExpressRouteGatewayBypass *bool `json:"expressRouteGatewayBypass,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnectionListEntityPropertiesFormat.
func (vngclepf VirtualNetworkGatewayConnectionListEntityPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngclepf.AuthorizationKey != nil {
		objectMap["authorizationKey"] = vngclepf.AuthorizationKey
	}
	if vngclepf.VirtualNetworkGateway1 != nil {
		objectMap["virtualNetworkGateway1"] = vngclepf.VirtualNetworkGateway1
	}
	if vngclepf.VirtualNetworkGateway2 != nil {
		objectMap["virtualNetworkGateway2"] = vngclepf.VirtualNetworkGateway2
	}
	if vngclepf.LocalNetworkGateway2 != nil {
		objectMap["localNetworkGateway2"] = vngclepf.LocalNetworkGateway2
	}
	if vngclepf.ConnectionType != "" {
		objectMap["connectionType"] = vngclepf.ConnectionType
	}
	if vngclepf.ConnectionProtocol != "" {
		objectMap["connectionProtocol"] = vngclepf.ConnectionProtocol
	}
	if vngclepf.RoutingWeight != nil {
		objectMap["routingWeight"] = vngclepf.RoutingWeight
	}
	if vngclepf.SharedKey != nil {
		objectMap["sharedKey"] = vngclepf.SharedKey
	}
	if vngclepf.Peer != nil {
		objectMap["peer"] = vngclepf.Peer
	}
	if vngclepf.EnableBgp != nil {
		objectMap["enableBgp"] = vngclepf.EnableBgp
	}
	if vngclepf.UsePolicyBasedTrafficSelectors != nil {
		objectMap["usePolicyBasedTrafficSelectors"] = vngclepf.UsePolicyBasedTrafficSelectors
	}
	if vngclepf.IpsecPolicies != nil {
		objectMap["ipsecPolicies"] = vngclepf.IpsecPolicies
	}
	if vngclepf.TrafficSelectorPolicies != nil {
		objectMap["trafficSelectorPolicies"] = vngclepf.TrafficSelectorPolicies
	}
	if vngclepf.ResourceGUID != nil {
		objectMap["resourceGuid"] = vngclepf.ResourceGUID
	}
	if vngclepf.ExpressRouteGatewayBypass != nil {
		objectMap["expressRouteGatewayBypass"] = vngclepf.ExpressRouteGatewayBypass
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkGatewayConnectionListResult response for the ListVirtualNetworkGatewayConnections API
// service call.
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnectionListResult.
func (vngclr VirtualNetworkGatewayConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngclr.Value != nil {
		objectMap["value"] = vngclr.Value
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkGatewayConnectionListResultIterator provides access to a complete listing of
// VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultIterator struct {
	i    int
	page VirtualNetworkGatewayConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Response() VirtualNetworkGatewayConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Value() VirtualNetworkGatewayConnection {
	if !iter.page.NotDone() {
		return VirtualNetworkGatewayConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkGatewayConnectionListResultIterator type.
func NewVirtualNetworkGatewayConnectionListResultIterator(page VirtualNetworkGatewayConnectionListResultPage) VirtualNetworkGatewayConnectionListResultIterator {
	return VirtualNetworkGatewayConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vngclr VirtualNetworkGatewayConnectionListResult) IsEmpty() bool {
	return vngclr.Value == nil || len(*vngclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vngclr VirtualNetworkGatewayConnectionListResult) hasNextLink() bool {
	return vngclr.NextLink != nil && len(*vngclr.NextLink) != 0
}

// virtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vngclr VirtualNetworkGatewayConnectionListResult) virtualNetworkGatewayConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vngclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vngclr.NextLink)))
}

// VirtualNetworkGatewayConnectionListResultPage contains a page of VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultPage struct {
	fn     func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)
	vngclr VirtualNetworkGatewayConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vngclr)
		if err != nil {
			return err
		}
		page.vngclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkGatewayConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayConnectionListResultPage) NotDone() bool {
	return !page.vngclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayConnectionListResultPage) Response() VirtualNetworkGatewayConnectionListResult {
	return page.vngclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayConnectionListResultPage) Values() []VirtualNetworkGatewayConnection {
	if page.vngclr.IsEmpty() {
		return nil
	}
	return *page.vngclr.Value
}

// Creates a new instance of the VirtualNetworkGatewayConnectionListResultPage type.
func NewVirtualNetworkGatewayConnectionListResultPage(cur VirtualNetworkGatewayConnectionListResult, getNextPage func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)) VirtualNetworkGatewayConnectionListResultPage {
	return VirtualNetworkGatewayConnectionListResultPage{
		fn:     getNextPage,
		vngclr: cur,
	}
}

// VirtualNetworkGatewayConnectionPropertiesFormat virtualNetworkGatewayConnection properties.
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	// AuthorizationKey - The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// VirtualNetworkGateway1 - The reference to virtual network gateway resource.
	Virtua