package customerlockbox

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RequestsClient is the azure Customer Lockbox API Reference
type RequestsClient struct {
	BaseClient
}

// NewRequestsClient creates an instance of the RequestsClient client.
func NewRequestsClient() RequestsClient {
	return NewRequestsClientWithBaseURI(DefaultBaseURI)
}

// NewRequestsClientWithBaseURI creates an instance of the RequestsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewRequestsClientWithBaseURI(baseURI string) RequestsClient {
	return RequestsClient{NewWithBaseURI(baseURI)}
}

// Get get Customer Lockbox request
// Parameters:
// requestID - the Lockbox request ID.
// subscriptionID - the Azure subscription ID. This is a GUID-formatted string (e.g.
// 00000000-0000-0000-0000-000000000000)
// APIVersion - the API version to be used with the HTTP request.
func (client RequestsClient) Get(ctx context.Context, requestID string, subscriptionID string, APIVersion string) (result LockboxRequestResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, requestID, subscriptionID, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RequestsClient) GetPreparer(ctx context.Context, requestID string, subscriptionID string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestId":      autorest.Encode("path", requestID),
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CustomerLockbox/requests/{requestId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RequestsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RequestsClient) GetResponder(resp *http.Response) (result LockboxRequestResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all of the Lockbox requests in the given subscription.
// Parameters:
// subscriptionID - the Azure subscription ID. This is a GUID-formatted string (e.g.
// 00000000-0000-0000-0000-000000000000)
// filter - the $filter OData query parameter. Only filter by request status is supported, e.g
// $filter=properties/status eq 'Pending'
func (client RequestsClient) List(ctx context.Context, subscriptionID string, filter string) (result RequestListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestsClient.List")
		defer func() {
			sc := -1
			if result.rlr.Response.Response != nil {
				sc = result.rlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, subscriptionID, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.rlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "List", resp, "Failure sending request")
		return
	}

	result.rlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.rlr.hasNextLink() && result.rlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client RequestsClient) ListPreparer(ctx context.Context, subscriptionID string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CustomerLockbox/requests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client RequestsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client RequestsClient) ListResponder(resp *http.Response) (result RequestListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client RequestsClient) listNextResults(ctx context.Context, lastResults RequestListResult) (result RequestListResult, err error) {
	req, err := lastResults.requestListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client RequestsClient) ListComplete(ctx context.Context, subscriptionID string, filter string) (result RequestListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, subscriptionID, filter)
	return
}

// UpdateStatus update Customer Lockbox request approval status API
// Parameters:
// approval - the approval object to update request status.
// subscriptionID - the Azure subscription ID. This is a GUID-formatted string (e.g.
// 00000000-0000-0000-0000-000000000000)
// requestID - the Lockbox request ID.
// APIVersion - the API version to be used with the HTTP request.
func (client RequestsClient) UpdateStatus(ctx context.Context, approval Approval, subscriptionID string, requestID string, APIVersion string) (result Approval, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestsClient.UpdateStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateStatusPreparer(ctx, approval, subscriptionID, requestID, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "UpdateStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "UpdateStatus", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerlockbox.RequestsClient", "UpdateStatus", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateStatusPreparer prepares the UpdateStatus request.
func (client RequestsClient) UpdateStatusPreparer(ctx context.Context, approval Approval, subscriptionID string, requestID string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestId":      autorest.Encode("path", requestID),
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CustomerLockbox/requests/{requestId}/UpdateApproval", pathParameters),
		autorest.WithJSON(approval),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateStatusSender sends the UpdateStatus request. The method will close the
// http.Response Body if it receives an error.
func (client RequestsClient) UpdateStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateStatusResponder handles the response to the UpdateStatus request. The method always
// closes the http.Response Body.
func (client RequestsClient) UpdateStatusResponder(resp *http.Response) (result Approval, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
