package subscriptionapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/subscription/mgmt/2019-10-01-preview/subscription"
	"github.com/Azure/go-autorest/autorest"
)

// SubscriptionsClientAPI contains the set of methods on the SubscriptionsClient type.
type SubscriptionsClientAPI interface {
	Get(ctx context.Context, subscriptionID string) (result subscription.Model, err error)
	List(ctx context.Context) (result subscription.ListResultPage, err error)
	ListComplete(ctx context.Context) (result subscription.ListResultIterator, err error)
	ListLocations(ctx context.Context, subscriptionID string) (result subscription.LocationListResult, err error)
}

var _ SubscriptionsClientAPI = (*subscription.SubscriptionsClient)(nil)

// TenantsClientAPI contains the set of methods on the TenantsClient type.
type TenantsClientAPI interface {
	List(ctx context.Context) (result subscription.TenantListResultPage, err error)
	ListComplete(ctx context.Context) (result subscription.TenantListResultIterator, err error)
}

var _ TenantsClientAPI = (*subscription.TenantsClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Cancel(ctx context.Context, subscriptionID string) (result subscription.CanceledSubscriptionID, err error)
	CreateAlias(ctx context.Context, aliasName string, body subscription.PutAliasRequest) (result subscription.CreateAliasFuture, err error)
	CreateCspSubscription(ctx context.Context, billingAccountName string, customerName string, body subscription.ModernCspSubscriptionCreationParameters) (result subscription.CreateCspSubscriptionFuture, err error)
	CreateSubscription(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, body subscription.ModernSubscriptionCreationParameters) (result subscription.CreateSubscriptionFuture, err error)
	CreateSubscriptionInEnrollmentAccount(ctx context.Context, enrollmentAccountName string, body subscription.CreationParameters) (result subscription.CreateSubscriptionInEnrollmentAccountFuture, err error)
	DeleteAlias(ctx context.Context, aliasName string) (result autorest.Response, err error)
	Enable(ctx context.Context, subscriptionID string) (result subscription.EnabledSubscriptionID, err error)
	GetAlias(ctx context.Context, aliasName string) (result subscription.PutAliasResponse, err error)
	ListAlias(ctx context.Context) (result subscription.PutAliasListResult, err error)
	Rename(ctx context.Context, subscriptionID string, body subscription.Name) (result subscription.RenamedSubscriptionID, err error)
}

var _ ClientAPI = (*subscription.Client)(nil)

// OperationClientAPI contains the set of methods on the OperationClient type.
type OperationClientAPI interface {
	Get(ctx context.Context, operationID string) (result subscription.CreationResult, err error)
}

var _ OperationClientAPI = (*subscription.OperationClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result subscription.OperationListResult, err error)
}

var _ OperationsClientAPI = (*subscription.OperationsClient)(nil)
