// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/waf"
)

type GetRuleInput struct {
	_ struct{} `type:"structure"`

	// The RuleId of the Rule that you want to get. RuleId is returned by CreateRule
	// and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRuleInput"}

	if s.RuleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Rule that you specified in the GetRule request. For
	// more information, see the following topics:
	//
	//    * Rule: Contains MetricName, Name, an array of Predicate objects, and
	//    RuleId
	//
	//    * Predicate: Each Predicate object contains DataId, Negated, and Type
	Rule *waf.Rule `type:"structure"`
}

// String returns the string representation
func (s GetRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRule = "GetRule"

// GetRuleRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Returns the Rule that is specified by the RuleId that you included in the
// GetRule request.
//
//    // Example sending a request using GetRuleRequest.
//    req := client.GetRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRule
func (c *Client) GetRuleRequest(input *GetRuleInput) GetRuleRequest {
	op := &aws.Operation{
		Name:       opGetRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRuleInput{}
	}

	req := c.newRequest(op, input, &GetRuleOutput{})
	return GetRuleRequest{Request: req, Input: input, Copy: c.GetRuleRequest}
}

// GetRuleRequest is the request type for the
// GetRule API operation.
type GetRuleRequest struct {
	*aws.Request
	Input *GetRuleInput
	Copy  func(*GetRuleInput) GetRuleRequest
}

// Send marshals and sends the GetRule API request.
func (r GetRuleRequest) Send(ctx context.Context) (*GetRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRuleResponse{
		GetRuleOutput: r.Request.Data.(*GetRuleOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRuleResponse is the response type for the
// GetRule API operation.
type GetRuleResponse struct {
	*GetRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRule request.
func (r *GetRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
