// DO NOT EDIT: This file is autogenerated via the builtin command.

package influxql

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	"regexp"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   339,
				},
				File:   "aggregate_group_by_time_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.2128911717061432\n,,0,1970-01-01T01:00:00Z,m,0,f,0.07279997497030395\n,,0,1970-01-01T02:00:00Z,m,0,f,0.5685247543217412\n,,0,1970-01-01T03:00:00Z,m,0,f,0.29096443393390425\n,,0,1970-01-01T04:00:00Z,m,0,f,0.4356705625292191\n,,0,1970-01-01T05:00:00Z,m,0,f,0.9377323443071505\n,,0,1970-01-01T06:00:00Z,m,0,f,0.011686627909299956\n,,0,1970-01-01T07:00:00Z,m,0,f,0.4011512684588352\n,,0,1970-01-01T08:00:00Z,m,0,f,0.2467000604224705\n,,0,1970-01-01T09:00:00Z,m,0,f,0.035457662801040575\n,,0,1970-01-01T10:00:00Z,m,0,f,0.34069878765762024\n,,0,1970-01-01T11:00:00Z,m,0,f,0.0956150560348323\n,,0,1970-01-01T12:00:00Z,m,0,f,0.6807780291957698\n,,0,1970-01-01T13:00:00Z,m,0,f,0.5337946188653447\n,,0,1970-01-01T14:00:00Z,m,0,f,0.20254189091820943\n,,0,1970-01-01T15:00:00Z,m,0,f,0.9364775207397588\n,,0,1970-01-01T16:00:00Z,m,0,f,0.7339764257047982\n,,0,1970-01-01T17:00:00Z,m,0,f,0.5833903306697613\n,,0,1970-01-01T18:00:00Z,m,0,f,0.3640275286497918\n,,0,1970-01-01T19:00:00Z,m,0,f,0.6631189097103277\n,,1,1970-01-01T00:00:00Z,m,1,f,0.6769161010724867\n,,1,1970-01-01T01:00:00Z,m,1,f,0.6543314107501336\n,,1,1970-01-01T02:00:00Z,m,1,f,0.6291463500252206\n,,1,1970-01-01T03:00:00Z,m,1,f,0.3152301292534112\n,,1,1970-01-01T04:00:00Z,m,1,f,0.03392415665887264\n,,1,1970-01-01T05:00:00Z,m,1,f,0.5082438395428922\n,,1,1970-01-01T06:00:00Z,m,1,f,0.10525600178569848\n,,1,1970-01-01T07:00:00Z,m,1,f,0.09521084883546317\n,,1,1970-01-01T08:00:00Z,m,1,f,0.865591485631552\n,,1,1970-01-01T09:00:00Z,m,1,f,0.4959724763808837\n,,1,1970-01-01T10:00:00Z,m,1,f,0.05679627383763615\n,,1,1970-01-01T11:00:00Z,m,1,f,0.1220798530727814\n,,1,1970-01-01T12:00:00Z,m,1,f,0.41254260137685644\n,,1,1970-01-01T13:00:00Z,m,1,f,0.07588672428630415\n,,1,1970-01-01T14:00:00Z,m,1,f,0.24813765601579021\n,,1,1970-01-01T15:00:00Z,m,1,f,0.087428932094856\n,,1,1970-01-01T16:00:00Z,m,1,f,0.768343862050663\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9683960475385988\n,,1,1970-01-01T18:00:00Z,m,1,f,0.024459901010390767\n,,1,1970-01-01T19:00:00Z,m,1,f,0.16444015119704355\n,,2,1970-01-01T00:00:00Z,m,2,f,0.15676131286844733\n,,2,1970-01-01T01:00:00Z,m,2,f,0.6400877570876031\n,,2,1970-01-01T02:00:00Z,m,2,f,0.893878275849246\n,,2,1970-01-01T03:00:00Z,m,2,f,0.7997870081362324\n,,2,1970-01-01T04:00:00Z,m,2,f,0.08663328673289308\n,,2,1970-01-01T05:00:00Z,m,2,f,0.8342029060820773\n,,2,1970-01-01T06:00:00Z,m,2,f,0.11628112203352979\n,,2,1970-01-01T07:00:00Z,m,2,f,0.2623494322713019\n,,2,1970-01-01T08:00:00Z,m,2,f,0.2803453288904869\n,,2,1970-01-01T09:00:00Z,m,2,f,0.1117401998642663\n,,2,1970-01-01T10:00:00Z,m,2,f,0.3250295694300974\n,,2,1970-01-01T11:00:00Z,m,2,f,0.6078411671373538\n,,2,1970-01-01T12:00:00Z,m,2,f,0.2512356097508373\n,,2,1970-01-01T13:00:00Z,m,2,f,0.4438471268050767\n,,2,1970-01-01T14:00:00Z,m,2,f,0.4961524472008469\n,,2,1970-01-01T15:00:00Z,m,2,f,0.27020729375557506\n,,2,1970-01-01T16:00:00Z,m,2,f,0.08718790189805248\n,,2,1970-01-01T17:00:00Z,m,2,f,0.9737141084388389\n,,2,1970-01-01T18:00:00Z,m,2,f,0.07166549074370027\n,,2,1970-01-01T19:00:00Z,m,2,f,0.26943653430867687\n,,3,1970-01-01T00:00:00Z,m,3,f,0.14437387897405465\n,,3,1970-01-01T01:00:00Z,m,3,f,0.21057568804660023\n,,3,1970-01-01T02:00:00Z,m,3,f,0.1100457949346592\n,,3,1970-01-01T03:00:00Z,m,3,f,0.21141077792261312\n,,3,1970-01-01T04:00:00Z,m,3,f,0.19825711934860404\n,,3,1970-01-01T05:00:00Z,m,3,f,0.8253021658464177\n,,3,1970-01-01T06:00:00Z,m,3,f,0.7540703924924461\n,,3,1970-01-01T07:00:00Z,m,3,f,0.9503578735213787\n,,3,1970-01-01T08:00:00Z,m,3,f,0.0355914513304335\n,,3,1970-01-01T09:00:00Z,m,3,f,0.2745746957286906\n,,3,1970-01-01T10:00:00Z,m,3,f,0.5443182488460032\n,,3,1970-01-01T11:00:00Z,m,3,f,0.44666597783400147\n,,3,1970-01-01T12:00:00Z,m,3,f,0.8093304994650494\n,,3,1970-01-01T13:00:00Z,m,3,f,0.4029418644675999\n,,3,1970-01-01T14:00:00Z,m,3,f,0.8576441137558692\n,,3,1970-01-01T15:00:00Z,m,3,f,0.5687663277465801\n,,3,1970-01-01T16:00:00Z,m,3,f,0.7196911732820932\n,,3,1970-01-01T17:00:00Z,m,3,f,0.029762405134454425\n,,3,1970-01-01T18:00:00Z,m,3,f,0.04147327683312637\n,,3,1970-01-01T19:00:00Z,m,3,f,0.9540246504017378\n,,4,1970-01-01T00:00:00Z,m,4,f,0.5897122797730547\n,,4,1970-01-01T01:00:00Z,m,4,f,0.34947791862749694\n,,4,1970-01-01T02:00:00Z,m,4,f,0.0348965616058906\n,,4,1970-01-01T03:00:00Z,m,4,f,0.5410660442822854\n,,4,1970-01-01T04:00:00Z,m,4,f,0.5905190211554855\n,,4,1970-01-01T05:00:00Z,m,4,f,0.26747573301173966\n,,4,1970-01-01T06:00:00Z,m,4,f,0.9013278299551851\n,,4,1970-01-01T07:00:00Z,m,4,f,0.020645183363589\n,,4,1970-01-01T08:00:00Z,m,4,f,0.9444715783077008\n,,4,1970-01-01T09:00:00Z,m,4,f,0.9249340696871452\n,,4,1970-01-01T10:00:00Z,m,4,f,0.895407127686278\n,,4,1970-01-01T11:00:00Z,m,4,f,0.09158865660821072\n,,4,1970-01-01T12:00:00Z,m,4,f,0.26170334389270705\n,,4,1970-01-01T13:00:00Z,m,4,f,0.04047303046439957\n,,4,1970-01-01T14:00:00Z,m,4,f,0.6890175711780648\n,,4,1970-01-01T15:00:00Z,m,4,f,0.169203543095355\n,,4,1970-01-01T16:00:00Z,m,4,f,0.30352036330937937\n,,4,1970-01-01T17:00:00Z,m,4,f,0.7227629347521738\n,,4,1970-01-01T18:00:00Z,m,4,f,0.23071325246204685\n,,4,1970-01-01T19:00:00Z,m,4,f,0.5423975878441447\n,,5,1970-01-01T00:00:00Z,m,5,f,0.6159810548328785\n,,5,1970-01-01T01:00:00Z,m,5,f,0.5286371352099966\n,,5,1970-01-01T02:00:00Z,m,5,f,0.27037470564664345\n,,5,1970-01-01T03:00:00Z,m,5,f,0.9821155970111088\n,,5,1970-01-01T04:00:00Z,m,5,f,0.14128644025052767\n,,5,1970-01-01T05:00:00Z,m,5,f,0.15532267675041508\n,,5,1970-01-01T06:00:00Z,m,5,f,0.06470957508645864\n,,5,1970-01-01T07:00:00Z,m,5,f,0.852695602303644\n,,5,1970-01-01T08:00:00Z,m,5,f,0.9769235734819968\n,,5,1970-01-01T09:00:00Z,m,5,f,0.569772655210167\n,,5,1970-01-01T10:00:00Z,m,5,f,0.17839244855342468\n,,5,1970-01-01T11:00:00Z,m,5,f,0.5601900079688499\n,,5,1970-01-01T12:00:00Z,m,5,f,0.7674758179196\n,,5,1970-01-01T13:00:00Z,m,5,f,0.2698164186565066\n,,5,1970-01-01T14:00:00Z,m,5,f,0.019420090923226472\n,,5,1970-01-01T15:00:00Z,m,5,f,0.2671021005213226\n,,5,1970-01-01T16:00:00Z,m,5,f,0.2470396837146283\n,,5,1970-01-01T17:00:00Z,m,5,f,0.20522314571010808\n,,5,1970-01-01T18:00:00Z,m,5,f,0.47998413047851307\n,,5,1970-01-01T19:00:00Z,m,5,f,0.48347993430331904\n,,6,1970-01-01T00:00:00Z,m,6,f,0.6342972876998171\n,,6,1970-01-01T01:00:00Z,m,6,f,0.6576024605878982\n,,6,1970-01-01T02:00:00Z,m,6,f,0.6447000482746346\n,,6,1970-01-01T03:00:00Z,m,6,f,0.21678100598418243\n,,6,1970-01-01T04:00:00Z,m,6,f,0.023408287556663337\n,,6,1970-01-01T05:00:00Z,m,6,f,0.9076309223942498\n,,6,1970-01-01T06:00:00Z,m,6,f,0.5817502777240137\n,,6,1970-01-01T07:00:00Z,m,6,f,0.052824998643205875\n,,6,1970-01-01T08:00:00Z,m,6,f,0.3809330972535029\n,,6,1970-01-01T09:00:00Z,m,6,f,0.7671686650796129\n,,6,1970-01-01T10:00:00Z,m,6,f,0.07979065684298921\n,,6,1970-01-01T11:00:00Z,m,6,f,0.3998772862617565\n,,6,1970-01-01T12:00:00Z,m,6,f,0.1155491863199121\n,,6,1970-01-01T13:00:00Z,m,6,f,0.7386676189881027\n,,6,1970-01-01T14:00:00Z,m,6,f,0.34629618068681484\n,,6,1970-01-01T15:00:00Z,m,6,f,0.5525776529918931\n,,6,1970-01-01T16:00:00Z,m,6,f,0.332627727109297\n,,6,1970-01-01T17:00:00Z,m,6,f,0.5131953610405185\n,,6,1970-01-01T18:00:00Z,m,6,f,0.6424768197911961\n,,6,1970-01-01T19:00:00Z,m,6,f,0.7165748159282228\n,,7,1970-01-01T00:00:00Z,m,7,f,0.2455426279704188\n,,7,1970-01-01T01:00:00Z,m,7,f,0.40163124489623003\n,,7,1970-01-01T02:00:00Z,m,7,f,0.5975613157276424\n,,7,1970-01-01T03:00:00Z,m,7,f,0.24368494285955775\n,,7,1970-01-01T04:00:00Z,m,7,f,0.5064758608991188\n,,7,1970-01-01T05:00:00Z,m,7,f,0.8752680628605042\n,,7,1970-01-01T06:00:00Z,m,7,f,0.6073886500434565\n,,7,1970-01-01T07:00:00Z,m,7,f,0.38193775998692464\n,,7,1970-01-01T08:00:00Z,m,7,f,0.39598277949908883\n,,7,1970-01-01T09:00:00Z,m,7,f,0.15966785725202795\n,,7,1970-01-01T10:00:00Z,m,7,f,0.629484974659171\n,,7,1970-01-01T11:00:00Z,m,7,f,0.8986665286614761\n,,7,1970-01-01T12:00:00Z,m,7,f,0.8351669026338405\n,,7,1970-01-01T13:00:00Z,m,7,f,0.7207824488925798\n,,7,1970-01-01T14:00:00Z,m,7,f,0.5707878569829702\n,,7,1970-01-01T15:00:00Z,m,7,f,0.8091445743234214\n,,7,1970-01-01T16:00:00Z,m,7,f,0.3371203534810527\n,,7,1970-01-01T17:00:00Z,m,7,f,0.1741931226422866\n,,7,1970-01-01T18:00:00Z,m,7,f,0.7377303139536953\n,,7,1970-01-01T19:00:00Z,m,7,f,0.6414830272020358\n,,8,1970-01-01T00:00:00Z,m,8,f,0.507272964067779\n,,8,1970-01-01T01:00:00Z,m,8,f,0.7119639952021554\n,,8,1970-01-01T02:00:00Z,m,8,f,0.811656300965649\n,,8,1970-01-01T03:00:00Z,m,8,f,0.42116179653493335\n,,8,1970-01-01T04:00:00Z,m,8,f,0.43222575065281893\n,,8,1970-01-01T05:00:00Z,m,8,f,0.5074074618881453\n,,8,1970-01-01T06:00:00Z,m,8,f,0.5122144565697357\n,,8,1970-01-01T07:00:00Z,m,8,f,0.40715470738979853\n,,8,1970-01-01T08:00:00Z,m,8,f,0.8185589852847821\n,,8,1970-01-01T09:00:00Z,m,8,f,0.06615362288768847\n,,8,1970-01-01T10:00:00Z,m,8,f,0.95397955896684\n,,8,1970-01-01T11:00:00Z,m,8,f,0.3012853054957797\n,,8,1970-01-01T12:00:00Z,m,8,f,0.6957865828883222\n,,8,1970-01-01T13:00:00Z,m,8,f,0.18349784531489438\n,,8,1970-01-01T14:00:00Z,m,8,f,0.5326579864159198\n,,8,1970-01-01T15:00:00Z,m,8,f,0.16264304295239912\n,,8,1970-01-01T16:00:00Z,m,8,f,0.39612399186342956\n,,8,1970-01-01T17:00:00Z,m,8,f,0.8801431671211721\n,,8,1970-01-01T18:00:00Z,m,8,f,0.8905454115467667\n,,8,1970-01-01T19:00:00Z,m,8,f,0.37008895622309546\n,,9,1970-01-01T00:00:00Z,m,9,f,0.5943978030122283\n,,9,1970-01-01T01:00:00Z,m,9,f,0.9729045142730391\n,,9,1970-01-01T02:00:00Z,m,9,f,0.29963260412871184\n,,9,1970-01-01T03:00:00Z,m,9,f,0.13549246068853443\n,,9,1970-01-01T04:00:00Z,m,9,f,0.4985352282527366\n,,9,1970-01-01T05:00:00Z,m,9,f,0.70041974640892\n,,9,1970-01-01T06:00:00Z,m,9,f,0.5505166729368712\n,,9,1970-01-01T07:00:00Z,m,9,f,0.529948574619832\n,,9,1970-01-01T08:00:00Z,m,9,f,0.591106104564076\n,,9,1970-01-01T09:00:00Z,m,9,f,0.0635615209104685\n,,9,1970-01-01T10:00:00Z,m,9,f,0.49844667852584\n,,9,1970-01-01T11:00:00Z,m,9,f,0.8229130635259402\n,,9,1970-01-01T12:00:00Z,m,9,f,0.5768314206131357\n,,9,1970-01-01T13:00:00Z,m,9,f,0.7964902809518639\n,,9,1970-01-01T14:00:00Z,m,9,f,0.8577185880621226\n,,9,1970-01-01T15:00:00Z,m,9,f,0.8046611697264398\n,,9,1970-01-01T16:00:00Z,m,9,f,0.9035778001333393\n,,9,1970-01-01T17:00:00Z,m,9,f,0.25310651193805\n,,9,1970-01-01T18:00:00Z,m,9,f,0.9644663191492964\n,,9,1970-01-01T19:00:00Z,m,9,f,0.41841409390509593\n,,10,1970-01-01T00:00:00Z,m,a,f,0.18615629501863318\n,,10,1970-01-01T01:00:00Z,m,a,f,0.07946862666753376\n,,10,1970-01-01T02:00:00Z,m,a,f,0.33322548107896877\n,,10,1970-01-01T03:00:00Z,m,a,f,0.6074227273766635\n,,10,1970-01-01T04:00:00Z,m,a,f,0.8355600086380185\n,,10,1970-01-01T05:00:00Z,m,a,f,0.0696815215736273\n,,10,1970-01-01T06:00:00Z,m,a,f,0.9745054585018766\n,,10,1970-01-01T07:00:00Z,m,a,f,0.2845881026557506\n,,10,1970-01-01T08:00:00Z,m,a,f,0.38922817710857965\n,,10,1970-01-01T09:00:00Z,m,a,f,0.5614403393810139\n,,10,1970-01-01T10:00:00Z,m,a,f,0.5197270817554469\n,,10,1970-01-01T11:00:00Z,m,a,f,0.021532590173884557\n,,10,1970-01-01T12:00:00Z,m,a,f,0.16056999815441234\n,,10,1970-01-01T13:00:00Z,m,a,f,0.9518781786152178\n,,10,1970-01-01T14:00:00Z,m,a,f,0.27274707738681897\n,,10,1970-01-01T15:00:00Z,m,a,f,0.3202684728841677\n,,10,1970-01-01T16:00:00Z,m,a,f,0.30600536680315443\n,,10,1970-01-01T17:00:00Z,m,a,f,0.7144229319519285\n,,10,1970-01-01T18:00:00Z,m,a,f,0.8195988405538475\n,,10,1970-01-01T19:00:00Z,m,a,f,0.6833069146305664\n,,11,1970-01-01T00:00:00Z,m,b,f,0.08212464969207754\n,,11,1970-01-01T01:00:00Z,m,b,f,0.7049389293987478\n,,11,1970-01-01T02:00:00Z,m,b,f,0.46150233142660235\n,,11,1970-01-01T03:00:00Z,m,b,f,0.3061287983538073\n,,11,1970-01-01T04:00:00Z,m,b,f,0.5095622098330529\n,,11,1970-01-01T05:00:00Z,m,b,f,0.24885143749146582\n,,11,1970-01-01T06:00:00Z,m,b,f,0.2720705701013104\n,,11,1970-01-01T07:00:00Z,m,b,f,0.831725266287822\n,,11,1970-01-01T08:00:00Z,m,b,f,0.2980839741707451\n,,11,1970-01-01T09:00:00Z,m,b,f,0.4667397329742896\n,,11,1970-01-01T10:00:00Z,m,b,f,0.7604282480092655\n,,11,1970-01-01T11:00:00Z,m,b,f,0.08125558409370949\n,,11,1970-01-01T12:00:00Z,m,b,f,0.9673492809150086\n,,11,1970-01-01T13:00:00Z,m,b,f,0.7485101477006051\n,,11,1970-01-01T14:00:00Z,m,b,f,0.7826905277143607\n,,11,1970-01-01T15:00:00Z,m,b,f,0.002832539681341695\n,,11,1970-01-01T16:00:00Z,m,b,f,0.5904945620548707\n,,11,1970-01-01T17:00:00Z,m,b,f,0.19377318954716558\n,,11,1970-01-01T18:00:00Z,m,b,f,0.32112472445570694\n,,11,1970-01-01T19:00:00Z,m,b,f,0.8156620813866876\n,,12,1970-01-01T00:00:00Z,m,c,f,0.45823190604583425\n,,12,1970-01-01T01:00:00Z,m,c,f,0.7041395377467482\n,,12,1970-01-01T02:00:00Z,m,c,f,0.7164281522457248\n,,12,1970-01-01T03:00:00Z,m,c,f,0.664229117231648\n,,12,1970-01-01T04:00:00Z,m,c,f,0.2167198068478531\n,,12,1970-01-01T05:00:00Z,m,c,f,0.4781537327645974\n,,12,1970-01-01T06:00:00Z,m,c,f,0.915856481062239\n,,12,1970-01-01T07:00:00Z,m,c,f,0.7488973719504495\n,,12,1970-01-01T08:00:00Z,m,c,f,0.8415102413049199\n,,12,1970-01-01T09:00:00Z,m,c,f,0.9749127169681439\n,,12,1970-01-01T10:00:00Z,m,c,f,0.5203067180352847\n,,12,1970-01-01T11:00:00Z,m,c,f,0.8077896981284608\n,,12,1970-01-01T12:00:00Z,m,c,f,0.3140632603734003\n,,12,1970-01-01T13:00:00Z,m,c,f,0.4942913283054576\n,,12,1970-01-01T14:00:00Z,m,c,f,0.7803195300512884\n,,12,1970-01-01T15:00:00Z,m,c,f,0.29988813201194514\n,,12,1970-01-01T16:00:00Z,m,c,f,0.9275317190485068\n,,12,1970-01-01T17:00:00Z,m,c,f,0.8532168145174167\n,,12,1970-01-01T18:00:00Z,m,c,f,0.29567768993242205\n,,12,1970-01-01T19:00:00Z,m,c,f,0.148869586329582\n,,13,1970-01-01T00:00:00Z,m,d,f,0.8734370766635879\n,,13,1970-01-01T01:00:00Z,m,d,f,0.7450766293779155\n,,13,1970-01-01T02:00:00Z,m,d,f,0.9454605686978569\n,,13,1970-01-01T03:00:00Z,m,d,f,0.20587883115663197\n,,13,1970-01-01T04:00:00Z,m,d,f,0.5495265257832065\n,,13,1970-01-01T05:00:00Z,m,d,f,0.9985101041430109\n,,13,1970-01-01T06:00:00Z,m,d,f,0.606668520981593\n,,13,1970-01-01T07:00:00Z,m,d,f,0.1520034163165451\n,,13,1970-01-01T08:00:00Z,m,d,f,0.8960639437047637\n,,13,1970-01-01T09:00:00Z,m,d,f,0.40243673434606525\n,,13,1970-01-01T10:00:00Z,m,d,f,0.8559633842216021\n,,13,1970-01-01T11:00:00Z,m,d,f,0.8049602305582066\n,,13,1970-01-01T12:00:00Z,m,d,f,0.7472498943010795\n,,13,1970-01-01T13:00:00Z,m,d,f,0.19955816724612416\n,,13,1970-01-01T14:00:00Z,m,d,f,0.6398800958352263\n,,13,1970-01-01T15:00:00Z,m,d,f,0.9121026864646193\n,,13,1970-01-01T16:00:00Z,m,d,f,0.5138919840212206\n,,13,1970-01-01T17:00:00Z,m,d,f,0.8090917843470073\n,,13,1970-01-01T18:00:00Z,m,d,f,0.7569845252265965\n,,13,1970-01-01T19:00:00Z,m,d,f,0.28321607497510914\n,,14,1970-01-01T00:00:00Z,m,e,f,0.015015322322770903\n,,14,1970-01-01T01:00:00Z,m,e,f,0.9355541025597022\n,,14,1970-01-01T02:00:00Z,m,e,f,0.04136655165051055\n,,14,1970-01-01T03:00:00Z,m,e,f,0.5818917517534496\n,,14,1970-01-01T04:00:00Z,m,e,f,0.5003101543125776\n,,14,1970-01-01T05:00:00Z,m,e,f,0.9100689489842115\n,,14,1970-01-01T06:00:00Z,m,e,f,0.16048736645104625\n,,14,1970-01-01T07:00:00Z,m,e,f,0.9463952890222139\n,,14,1970-01-01T08:00:00Z,m,e,f,0.9639066785470444\n,,14,1970-01-01T09:00:00Z,m,e,f,0.5265981043058684\n,,14,1970-01-01T10:00:00Z,m,e,f,0.1618974442468811\n,,14,1970-01-01T11:00:00Z,m,e,f,0.23732885629224745\n,,14,1970-01-01T12:00:00Z,m,e,f,0.6209913661783305\n,,14,1970-01-01T13:00:00Z,m,e,f,0.37725772933735735\n,,14,1970-01-01T14:00:00Z,m,e,f,0.8852154063171275\n,,14,1970-01-01T15:00:00Z,m,e,f,0.7614955446339434\n,,14,1970-01-01T16:00:00Z,m,e,f,0.8089264477070236\n,,14,1970-01-01T17:00:00Z,m,e,f,0.8491087096738495\n,,14,1970-01-01T18:00:00Z,m,e,f,0.051500691978027605\n,,14,1970-01-01T19:00:00Z,m,e,f,0.16249922364133557\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,sum\n,,0,1970-01-01T00:00:00Z,m,33.802561295632636\n,,0,1970-01-01T05:00:00Z,m,38.603075816590454\n,,0,1970-01-01T10:00:00Z,m,36.99580140544222\n,,0,1970-01-01T15:00:00Z,m,37.63380091958056\n,,0,1970-01-01T20:00:00Z,m,\n\"\n\n// SELECT sum(f) FROM m WHERE time >= 0 AND time <= 20h GROUP BY time(5h)\nt_aggregate_group_by_time = (tables=<-) => tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> aggregateWindow(every: 5h, fn: sum, timeSrc: \"_start\")\n\t|> rename(columns: {_time: \"time\", _value: \"sum\"})\n\t|> drop(columns: [\"_field\", \"_start\", \"_stop\"])\n\ntest _aggregate_group_by_time = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_group_by_time,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   311,
					},
					File:   "aggregate_group_by_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.2128911717061432\n,,0,1970-01-01T01:00:00Z,m,0,f,0.07279997497030395\n,,0,1970-01-01T02:00:00Z,m,0,f,0.5685247543217412\n,,0,1970-01-01T03:00:00Z,m,0,f,0.29096443393390425\n,,0,1970-01-01T04:00:00Z,m,0,f,0.4356705625292191\n,,0,1970-01-01T05:00:00Z,m,0,f,0.9377323443071505\n,,0,1970-01-01T06:00:00Z,m,0,f,0.011686627909299956\n,,0,1970-01-01T07:00:00Z,m,0,f,0.4011512684588352\n,,0,1970-01-01T08:00:00Z,m,0,f,0.2467000604224705\n,,0,1970-01-01T09:00:00Z,m,0,f,0.035457662801040575\n,,0,1970-01-01T10:00:00Z,m,0,f,0.34069878765762024\n,,0,1970-01-01T11:00:00Z,m,0,f,0.0956150560348323\n,,0,1970-01-01T12:00:00Z,m,0,f,0.6807780291957698\n,,0,1970-01-01T13:00:00Z,m,0,f,0.5337946188653447\n,,0,1970-01-01T14:00:00Z,m,0,f,0.20254189091820943\n,,0,1970-01-01T15:00:00Z,m,0,f,0.9364775207397588\n,,0,1970-01-01T16:00:00Z,m,0,f,0.7339764257047982\n,,0,1970-01-01T17:00:00Z,m,0,f,0.5833903306697613\n,,0,1970-01-01T18:00:00Z,m,0,f,0.3640275286497918\n,,0,1970-01-01T19:00:00Z,m,0,f,0.6631189097103277\n,,1,1970-01-01T00:00:00Z,m,1,f,0.6769161010724867\n,,1,1970-01-01T01:00:00Z,m,1,f,0.6543314107501336\n,,1,1970-01-01T02:00:00Z,m,1,f,0.6291463500252206\n,,1,1970-01-01T03:00:00Z,m,1,f,0.3152301292534112\n,,1,1970-01-01T04:00:00Z,m,1,f,0.03392415665887264\n,,1,1970-01-01T05:00:00Z,m,1,f,0.5082438395428922\n,,1,1970-01-01T06:00:00Z,m,1,f,0.10525600178569848\n,,1,1970-01-01T07:00:00Z,m,1,f,0.09521084883546317\n,,1,1970-01-01T08:00:00Z,m,1,f,0.865591485631552\n,,1,1970-01-01T09:00:00Z,m,1,f,0.4959724763808837\n,,1,1970-01-01T10:00:00Z,m,1,f,0.05679627383763615\n,,1,1970-01-01T11:00:00Z,m,1,f,0.1220798530727814\n,,1,1970-01-01T12:00:00Z,m,1,f,0.41254260137685644\n,,1,1970-01-01T13:00:00Z,m,1,f,0.07588672428630415\n,,1,1970-01-01T14:00:00Z,m,1,f,0.24813765601579021\n,,1,1970-01-01T15:00:00Z,m,1,f,0.087428932094856\n,,1,1970-01-01T16:00:00Z,m,1,f,0.768343862050663\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9683960475385988\n,,1,1970-01-01T18:00:00Z,m,1,f,0.024459901010390767\n,,1,1970-01-01T19:00:00Z,m,1,f,0.16444015119704355\n,,2,1970-01-01T00:00:00Z,m,2,f,0.15676131286844733\n,,2,1970-01-01T01:00:00Z,m,2,f,0.6400877570876031\n,,2,1970-01-01T02:00:00Z,m,2,f,0.893878275849246\n,,2,1970-01-01T03:00:00Z,m,2,f,0.7997870081362324\n,,2,1970-01-01T04:00:00Z,m,2,f,0.08663328673289308\n,,2,1970-01-01T05:00:00Z,m,2,f,0.8342029060820773\n,,2,1970-01-01T06:00:00Z,m,2,f,0.11628112203352979\n,,2,1970-01-01T07:00:00Z,m,2,f,0.2623494322713019\n,,2,1970-01-01T08:00:00Z,m,2,f,0.2803453288904869\n,,2,1970-01-01T09:00:00Z,m,2,f,0.1117401998642663\n,,2,1970-01-01T10:00:00Z,m,2,f,0.3250295694300974\n,,2,1970-01-01T11:00:00Z,m,2,f,0.6078411671373538\n,,2,1970-01-01T12:00:00Z,m,2,f,0.2512356097508373\n,,2,1970-01-01T13:00:00Z,m,2,f,0.4438471268050767\n,,2,1970-01-01T14:00:00Z,m,2,f,0.4961524472008469\n,,2,1970-01-01T15:00:00Z,m,2,f,0.27020729375557506\n,,2,1970-01-01T16:00:00Z,m,2,f,0.08718790189805248\n,,2,1970-01-01T17:00:00Z,m,2,f,0.9737141084388389\n,,2,1970-01-01T18:00:00Z,m,2,f,0.07166549074370027\n,,2,1970-01-01T19:00:00Z,m,2,f,0.26943653430867687\n,,3,1970-01-01T00:00:00Z,m,3,f,0.14437387897405465\n,,3,1970-01-01T01:00:00Z,m,3,f,0.21057568804660023\n,,3,1970-01-01T02:00:00Z,m,3,f,0.1100457949346592\n,,3,1970-01-01T03:00:00Z,m,3,f,0.21141077792261312\n,,3,1970-01-01T04:00:00Z,m,3,f,0.19825711934860404\n,,3,1970-01-01T05:00:00Z,m,3,f,0.8253021658464177\n,,3,1970-01-01T06:00:00Z,m,3,f,0.7540703924924461\n,,3,1970-01-01T07:00:00Z,m,3,f,0.9503578735213787\n,,3,1970-01-01T08:00:00Z,m,3,f,0.0355914513304335\n,,3,1970-01-01T09:00:00Z,m,3,f,0.2745746957286906\n,,3,1970-01-01T10:00:00Z,m,3,f,0.5443182488460032\n,,3,1970-01-01T11:00:00Z,m,3,f,0.44666597783400147\n,,3,1970-01-01T12:00:00Z,m,3,f,0.8093304994650494\n,,3,1970-01-01T13:00:00Z,m,3,f,0.4029418644675999\n,,3,1970-01-01T14:00:00Z,m,3,f,0.8576441137558692\n,,3,1970-01-01T15:00:00Z,m,3,f,0.5687663277465801\n,,3,1970-01-01T16:00:00Z,m,3,f,0.7196911732820932\n,,3,1970-01-01T17:00:00Z,m,3,f,0.029762405134454425\n,,3,1970-01-01T18:00:00Z,m,3,f,0.04147327683312637\n,,3,1970-01-01T19:00:00Z,m,3,f,0.9540246504017378\n,,4,1970-01-01T00:00:00Z,m,4,f,0.5897122797730547\n,,4,1970-01-01T01:00:00Z,m,4,f,0.34947791862749694\n,,4,1970-01-01T02:00:00Z,m,4,f,0.0348965616058906\n,,4,1970-01-01T03:00:00Z,m,4,f,0.5410660442822854\n,,4,1970-01-01T04:00:00Z,m,4,f,0.5905190211554855\n,,4,1970-01-01T05:00:00Z,m,4,f,0.26747573301173966\n,,4,1970-01-01T06:00:00Z,m,4,f,0.9013278299551851\n,,4,1970-01-01T07:00:00Z,m,4,f,0.020645183363589\n,,4,1970-01-01T08:00:00Z,m,4,f,0.9444715783077008\n,,4,1970-01-01T09:00:00Z,m,4,f,0.9249340696871452\n,,4,1970-01-01T10:00:00Z,m,4,f,0.895407127686278\n,,4,1970-01-01T11:00:00Z,m,4,f,0.09158865660821072\n,,4,1970-01-01T12:00:00Z,m,4,f,0.26170334389270705\n,,4,1970-01-01T13:00:00Z,m,4,f,0.04047303046439957\n,,4,1970-01-01T14:00:00Z,m,4,f,0.6890175711780648\n,,4,1970-01-01T15:00:00Z,m,4,f,0.169203543095355\n,,4,1970-01-01T16:00:00Z,m,4,f,0.30352036330937937\n,,4,1970-01-01T17:00:00Z,m,4,f,0.7227629347521738\n,,4,1970-01-01T18:00:00Z,m,4,f,0.23071325246204685\n,,4,1970-01-01T19:00:00Z,m,4,f,0.5423975878441447\n,,5,1970-01-01T00:00:00Z,m,5,f,0.6159810548328785\n,,5,1970-01-01T01:00:00Z,m,5,f,0.5286371352099966\n,,5,1970-01-01T02:00:00Z,m,5,f,0.27037470564664345\n,,5,1970-01-01T03:00:00Z,m,5,f,0.9821155970111088\n,,5,1970-01-01T04:00:00Z,m,5,f,0.14128644025052767\n,,5,1970-01-01T05:00:00Z,m,5,f,0.15532267675041508\n,,5,1970-01-01T06:00:00Z,m,5,f,0.06470957508645864\n,,5,1970-01-01T07:00:00Z,m,5,f,0.852695602303644\n,,5,1970-01-01T08:00:00Z,m,5,f,0.9769235734819968\n,,5,1970-01-01T09:00:00Z,m,5,f,0.569772655210167\n,,5,1970-01-01T10:00:00Z,m,5,f,0.17839244855342468\n,,5,1970-01-01T11:00:00Z,m,5,f,0.5601900079688499\n,,5,1970-01-01T12:00:00Z,m,5,f,0.7674758179196\n,,5,1970-01-01T13:00:00Z,m,5,f,0.2698164186565066\n,,5,1970-01-01T14:00:00Z,m,5,f,0.019420090923226472\n,,5,1970-01-01T15:00:00Z,m,5,f,0.2671021005213226\n,,5,1970-01-01T16:00:00Z,m,5,f,0.2470396837146283\n,,5,1970-01-01T17:00:00Z,m,5,f,0.20522314571010808\n,,5,1970-01-01T18:00:00Z,m,5,f,0.47998413047851307\n,,5,1970-01-01T19:00:00Z,m,5,f,0.48347993430331904\n,,6,1970-01-01T00:00:00Z,m,6,f,0.6342972876998171\n,,6,1970-01-01T01:00:00Z,m,6,f,0.6576024605878982\n,,6,1970-01-01T02:00:00Z,m,6,f,0.6447000482746346\n,,6,1970-01-01T03:00:00Z,m,6,f,0.21678100598418243\n,,6,1970-01-01T04:00:00Z,m,6,f,0.023408287556663337\n,,6,1970-01-01T05:00:00Z,m,6,f,0.9076309223942498\n,,6,1970-01-01T06:00:00Z,m,6,f,0.5817502777240137\n,,6,1970-01-01T07:00:00Z,m,6,f,0.052824998643205875\n,,6,1970-01-01T08:00:00Z,m,6,f,0.3809330972535029\n,,6,1970-01-01T09:00:00Z,m,6,f,0.7671686650796129\n,,6,1970-01-01T10:00:00Z,m,6,f,0.07979065684298921\n,,6,1970-01-01T11:00:00Z,m,6,f,0.3998772862617565\n,,6,1970-01-01T12:00:00Z,m,6,f,0.1155491863199121\n,,6,1970-01-01T13:00:00Z,m,6,f,0.7386676189881027\n,,6,1970-01-01T14:00:00Z,m,6,f,0.34629618068681484\n,,6,1970-01-01T15:00:00Z,m,6,f,0.5525776529918931\n,,6,1970-01-01T16:00:00Z,m,6,f,0.332627727109297\n,,6,1970-01-01T17:00:00Z,m,6,f,0.5131953610405185\n,,6,1970-01-01T18:00:00Z,m,6,f,0.6424768197911961\n,,6,1970-01-01T19:00:00Z,m,6,f,0.7165748159282228\n,,7,1970-01-01T00:00:00Z,m,7,f,0.2455426279704188\n,,7,1970-01-01T01:00:00Z,m,7,f,0.40163124489623003\n,,7,1970-01-01T02:00:00Z,m,7,f,0.5975613157276424\n,,7,1970-01-01T03:00:00Z,m,7,f,0.24368494285955775\n,,7,1970-01-01T04:00:00Z,m,7,f,0.5064758608991188\n,,7,1970-01-01T05:00:00Z,m,7,f,0.8752680628605042\n,,7,1970-01-01T06:00:00Z,m,7,f,0.6073886500434565\n,,7,1970-01-01T07:00:00Z,m,7,f,0.38193775998692464\n,,7,1970-01-01T08:00:00Z,m,7,f,0.39598277949908883\n,,7,1970-01-01T09:00:00Z,m,7,f,0.15966785725202795\n,,7,1970-01-01T10:00:00Z,m,7,f,0.629484974659171\n,,7,1970-01-01T11:00:00Z,m,7,f,0.8986665286614761\n,,7,1970-01-01T12:00:00Z,m,7,f,0.8351669026338405\n,,7,1970-01-01T13:00:00Z,m,7,f,0.7207824488925798\n,,7,1970-01-01T14:00:00Z,m,7,f,0.5707878569829702\n,,7,1970-01-01T15:00:00Z,m,7,f,0.8091445743234214\n,,7,1970-01-01T16:00:00Z,m,7,f,0.3371203534810527\n,,7,1970-01-01T17:00:00Z,m,7,f,0.1741931226422866\n,,7,1970-01-01T18:00:00Z,m,7,f,0.7377303139536953\n,,7,1970-01-01T19:00:00Z,m,7,f,0.6414830272020358\n,,8,1970-01-01T00:00:00Z,m,8,f,0.507272964067779\n,,8,1970-01-01T01:00:00Z,m,8,f,0.7119639952021554\n,,8,1970-01-01T02:00:00Z,m,8,f,0.811656300965649\n,,8,1970-01-01T03:00:00Z,m,8,f,0.42116179653493335\n,,8,1970-01-01T04:00:00Z,m,8,f,0.43222575065281893\n,,8,1970-01-01T05:00:00Z,m,8,f,0.5074074618881453\n,,8,1970-01-01T06:00:00Z,m,8,f,0.5122144565697357\n,,8,1970-01-01T07:00:00Z,m,8,f,0.40715470738979853\n,,8,1970-01-01T08:00:00Z,m,8,f,0.8185589852847821\n,,8,1970-01-01T09:00:00Z,m,8,f,0.06615362288768847\n,,8,1970-01-01T10:00:00Z,m,8,f,0.95397955896684\n,,8,1970-01-01T11:00:00Z,m,8,f,0.3012853054957797\n,,8,1970-01-01T12:00:00Z,m,8,f,0.6957865828883222\n,,8,1970-01-01T13:00:00Z,m,8,f,0.18349784531489438\n,,8,1970-01-01T14:00:00Z,m,8,f,0.5326579864159198\n,,8,1970-01-01T15:00:00Z,m,8,f,0.16264304295239912\n,,8,1970-01-01T16:00:00Z,m,8,f,0.39612399186342956\n,,8,1970-01-01T17:00:00Z,m,8,f,0.8801431671211721\n,,8,1970-01-01T18:00:00Z,m,8,f,0.8905454115467667\n,,8,1970-01-01T19:00:00Z,m,8,f,0.37008895622309546\n,,9,1970-01-01T00:00:00Z,m,9,f,0.5943978030122283\n,,9,1970-01-01T01:00:00Z,m,9,f,0.9729045142730391\n,,9,1970-01-01T02:00:00Z,m,9,f,0.29963260412871184\n,,9,1970-01-01T03:00:00Z,m,9,f,0.13549246068853443\n,,9,1970-01-01T04:00:00Z,m,9,f,0.4985352282527366\n,,9,1970-01-01T05:00:00Z,m,9,f,0.70041974640892\n,,9,1970-01-01T06:00:00Z,m,9,f,0.5505166729368712\n,,9,1970-01-01T07:00:00Z,m,9,f,0.529948574619832\n,,9,1970-01-01T08:00:00Z,m,9,f,0.591106104564076\n,,9,1970-01-01T09:00:00Z,m,9,f,0.0635615209104685\n,,9,1970-01-01T10:00:00Z,m,9,f,0.49844667852584\n,,9,1970-01-01T11:00:00Z,m,9,f,0.8229130635259402\n,,9,1970-01-01T12:00:00Z,m,9,f,0.5768314206131357\n,,9,1970-01-01T13:00:00Z,m,9,f,0.7964902809518639\n,,9,1970-01-01T14:00:00Z,m,9,f,0.8577185880621226\n,,9,1970-01-01T15:00:00Z,m,9,f,0.8046611697264398\n,,9,1970-01-01T16:00:00Z,m,9,f,0.9035778001333393\n,,9,1970-01-01T17:00:00Z,m,9,f,0.25310651193805\n,,9,1970-01-01T18:00:00Z,m,9,f,0.9644663191492964\n,,9,1970-01-01T19:00:00Z,m,9,f,0.41841409390509593\n,,10,1970-01-01T00:00:00Z,m,a,f,0.18615629501863318\n,,10,1970-01-01T01:00:00Z,m,a,f,0.07946862666753376\n,,10,1970-01-01T02:00:00Z,m,a,f,0.33322548107896877\n,,10,1970-01-01T03:00:00Z,m,a,f,0.6074227273766635\n,,10,1970-01-01T04:00:00Z,m,a,f,0.8355600086380185\n,,10,1970-01-01T05:00:00Z,m,a,f,0.0696815215736273\n,,10,1970-01-01T06:00:00Z,m,a,f,0.9745054585018766\n,,10,1970-01-01T07:00:00Z,m,a,f,0.2845881026557506\n,,10,1970-01-01T08:00:00Z,m,a,f,0.38922817710857965\n,,10,1970-01-01T09:00:00Z,m,a,f,0.5614403393810139\n,,10,1970-01-01T10:00:00Z,m,a,f,0.5197270817554469\n,,10,1970-01-01T11:00:00Z,m,a,f,0.021532590173884557\n,,10,1970-01-01T12:00:00Z,m,a,f,0.16056999815441234\n,,10,1970-01-01T13:00:00Z,m,a,f,0.9518781786152178\n,,10,1970-01-01T14:00:00Z,m,a,f,0.27274707738681897\n,,10,1970-01-01T15:00:00Z,m,a,f,0.3202684728841677\n,,10,1970-01-01T16:00:00Z,m,a,f,0.30600536680315443\n,,10,1970-01-01T17:00:00Z,m,a,f,0.7144229319519285\n,,10,1970-01-01T18:00:00Z,m,a,f,0.8195988405538475\n,,10,1970-01-01T19:00:00Z,m,a,f,0.6833069146305664\n,,11,1970-01-01T00:00:00Z,m,b,f,0.08212464969207754\n,,11,1970-01-01T01:00:00Z,m,b,f,0.7049389293987478\n,,11,1970-01-01T02:00:00Z,m,b,f,0.46150233142660235\n,,11,1970-01-01T03:00:00Z,m,b,f,0.3061287983538073\n,,11,1970-01-01T04:00:00Z,m,b,f,0.5095622098330529\n,,11,1970-01-01T05:00:00Z,m,b,f,0.24885143749146582\n,,11,1970-01-01T06:00:00Z,m,b,f,0.2720705701013104\n,,11,1970-01-01T07:00:00Z,m,b,f,0.831725266287822\n,,11,1970-01-01T08:00:00Z,m,b,f,0.2980839741707451\n,,11,1970-01-01T09:00:00Z,m,b,f,0.4667397329742896\n,,11,1970-01-01T10:00:00Z,m,b,f,0.7604282480092655\n,,11,1970-01-01T11:00:00Z,m,b,f,0.08125558409370949\n,,11,1970-01-01T12:00:00Z,m,b,f,0.9673492809150086\n,,11,1970-01-01T13:00:00Z,m,b,f,0.7485101477006051\n,,11,1970-01-01T14:00:00Z,m,b,f,0.7826905277143607\n,,11,1970-01-01T15:00:00Z,m,b,f,0.002832539681341695\n,,11,1970-01-01T16:00:00Z,m,b,f,0.5904945620548707\n,,11,1970-01-01T17:00:00Z,m,b,f,0.19377318954716558\n,,11,1970-01-01T18:00:00Z,m,b,f,0.32112472445570694\n,,11,1970-01-01T19:00:00Z,m,b,f,0.8156620813866876\n,,12,1970-01-01T00:00:00Z,m,c,f,0.45823190604583425\n,,12,1970-01-01T01:00:00Z,m,c,f,0.7041395377467482\n,,12,1970-01-01T02:00:00Z,m,c,f,0.7164281522457248\n,,12,1970-01-01T03:00:00Z,m,c,f,0.664229117231648\n,,12,1970-01-01T04:00:00Z,m,c,f,0.2167198068478531\n,,12,1970-01-01T05:00:00Z,m,c,f,0.4781537327645974\n,,12,1970-01-01T06:00:00Z,m,c,f,0.915856481062239\n,,12,1970-01-01T07:00:00Z,m,c,f,0.7488973719504495\n,,12,1970-01-01T08:00:00Z,m,c,f,0.8415102413049199\n,,12,1970-01-01T09:00:00Z,m,c,f,0.9749127169681439\n,,12,1970-01-01T10:00:00Z,m,c,f,0.5203067180352847\n,,12,1970-01-01T11:00:00Z,m,c,f,0.8077896981284608\n,,12,1970-01-01T12:00:00Z,m,c,f,0.3140632603734003\n,,12,1970-01-01T13:00:00Z,m,c,f,0.4942913283054576\n,,12,1970-01-01T14:00:00Z,m,c,f,0.7803195300512884\n,,12,1970-01-01T15:00:00Z,m,c,f,0.29988813201194514\n,,12,1970-01-01T16:00:00Z,m,c,f,0.9275317190485068\n,,12,1970-01-01T17:00:00Z,m,c,f,0.8532168145174167\n,,12,1970-01-01T18:00:00Z,m,c,f,0.29567768993242205\n,,12,1970-01-01T19:00:00Z,m,c,f,0.148869586329582\n,,13,1970-01-01T00:00:00Z,m,d,f,0.8734370766635879\n,,13,1970-01-01T01:00:00Z,m,d,f,0.7450766293779155\n,,13,1970-01-01T02:00:00Z,m,d,f,0.9454605686978569\n,,13,1970-01-01T03:00:00Z,m,d,f,0.20587883115663197\n,,13,1970-01-01T04:00:00Z,m,d,f,0.5495265257832065\n,,13,1970-01-01T05:00:00Z,m,d,f,0.9985101041430109\n,,13,1970-01-01T06:00:00Z,m,d,f,0.606668520981593\n,,13,1970-01-01T07:00:00Z,m,d,f,0.1520034163165451\n,,13,1970-01-01T08:00:00Z,m,d,f,0.8960639437047637\n,,13,1970-01-01T09:00:00Z,m,d,f,0.40243673434606525\n,,13,1970-01-01T10:00:00Z,m,d,f,0.8559633842216021\n,,13,1970-01-01T11:00:00Z,m,d,f,0.8049602305582066\n,,13,1970-01-01T12:00:00Z,m,d,f,0.7472498943010795\n,,13,1970-01-01T13:00:00Z,m,d,f,0.19955816724612416\n,,13,1970-01-01T14:00:00Z,m,d,f,0.6398800958352263\n,,13,1970-01-01T15:00:00Z,m,d,f,0.9121026864646193\n,,13,1970-01-01T16:00:00Z,m,d,f,0.5138919840212206\n,,13,1970-01-01T17:00:00Z,m,d,f,0.8090917843470073\n,,13,1970-01-01T18:00:00Z,m,d,f,0.7569845252265965\n,,13,1970-01-01T19:00:00Z,m,d,f,0.28321607497510914\n,,14,1970-01-01T00:00:00Z,m,e,f,0.015015322322770903\n,,14,1970-01-01T01:00:00Z,m,e,f,0.9355541025597022\n,,14,1970-01-01T02:00:00Z,m,e,f,0.04136655165051055\n,,14,1970-01-01T03:00:00Z,m,e,f,0.5818917517534496\n,,14,1970-01-01T04:00:00Z,m,e,f,0.5003101543125776\n,,14,1970-01-01T05:00:00Z,m,e,f,0.9100689489842115\n,,14,1970-01-01T06:00:00Z,m,e,f,0.16048736645104625\n,,14,1970-01-01T07:00:00Z,m,e,f,0.9463952890222139\n,,14,1970-01-01T08:00:00Z,m,e,f,0.9639066785470444\n,,14,1970-01-01T09:00:00Z,m,e,f,0.5265981043058684\n,,14,1970-01-01T10:00:00Z,m,e,f,0.1618974442468811\n,,14,1970-01-01T11:00:00Z,m,e,f,0.23732885629224745\n,,14,1970-01-01T12:00:00Z,m,e,f,0.6209913661783305\n,,14,1970-01-01T13:00:00Z,m,e,f,0.37725772933735735\n,,14,1970-01-01T14:00:00Z,m,e,f,0.8852154063171275\n,,14,1970-01-01T15:00:00Z,m,e,f,0.7614955446339434\n,,14,1970-01-01T16:00:00Z,m,e,f,0.8089264477070236\n,,14,1970-01-01T17:00:00Z,m,e,f,0.8491087096738495\n,,14,1970-01-01T18:00:00Z,m,e,f,0.051500691978027605\n,,14,1970-01-01T19:00:00Z,m,e,f,0.16249922364133557\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   311,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.2128911717061432\n,,0,1970-01-01T01:00:00Z,m,0,f,0.07279997497030395\n,,0,1970-01-01T02:00:00Z,m,0,f,0.5685247543217412\n,,0,1970-01-01T03:00:00Z,m,0,f,0.29096443393390425\n,,0,1970-01-01T04:00:00Z,m,0,f,0.4356705625292191\n,,0,1970-01-01T05:00:00Z,m,0,f,0.9377323443071505\n,,0,1970-01-01T06:00:00Z,m,0,f,0.011686627909299956\n,,0,1970-01-01T07:00:00Z,m,0,f,0.4011512684588352\n,,0,1970-01-01T08:00:00Z,m,0,f,0.2467000604224705\n,,0,1970-01-01T09:00:00Z,m,0,f,0.035457662801040575\n,,0,1970-01-01T10:00:00Z,m,0,f,0.34069878765762024\n,,0,1970-01-01T11:00:00Z,m,0,f,0.0956150560348323\n,,0,1970-01-01T12:00:00Z,m,0,f,0.6807780291957698\n,,0,1970-01-01T13:00:00Z,m,0,f,0.5337946188653447\n,,0,1970-01-01T14:00:00Z,m,0,f,0.20254189091820943\n,,0,1970-01-01T15:00:00Z,m,0,f,0.9364775207397588\n,,0,1970-01-01T16:00:00Z,m,0,f,0.7339764257047982\n,,0,1970-01-01T17:00:00Z,m,0,f,0.5833903306697613\n,,0,1970-01-01T18:00:00Z,m,0,f,0.3640275286497918\n,,0,1970-01-01T19:00:00Z,m,0,f,0.6631189097103277\n,,1,1970-01-01T00:00:00Z,m,1,f,0.6769161010724867\n,,1,1970-01-01T01:00:00Z,m,1,f,0.6543314107501336\n,,1,1970-01-01T02:00:00Z,m,1,f,0.6291463500252206\n,,1,1970-01-01T03:00:00Z,m,1,f,0.3152301292534112\n,,1,1970-01-01T04:00:00Z,m,1,f,0.03392415665887264\n,,1,1970-01-01T05:00:00Z,m,1,f,0.5082438395428922\n,,1,1970-01-01T06:00:00Z,m,1,f,0.10525600178569848\n,,1,1970-01-01T07:00:00Z,m,1,f,0.09521084883546317\n,,1,1970-01-01T08:00:00Z,m,1,f,0.865591485631552\n,,1,1970-01-01T09:00:00Z,m,1,f,0.4959724763808837\n,,1,1970-01-01T10:00:00Z,m,1,f,0.05679627383763615\n,,1,1970-01-01T11:00:00Z,m,1,f,0.1220798530727814\n,,1,1970-01-01T12:00:00Z,m,1,f,0.41254260137685644\n,,1,1970-01-01T13:00:00Z,m,1,f,0.07588672428630415\n,,1,1970-01-01T14:00:00Z,m,1,f,0.24813765601579021\n,,1,1970-01-01T15:00:00Z,m,1,f,0.087428932094856\n,,1,1970-01-01T16:00:00Z,m,1,f,0.768343862050663\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9683960475385988\n,,1,1970-01-01T18:00:00Z,m,1,f,0.024459901010390767\n,,1,1970-01-01T19:00:00Z,m,1,f,0.16444015119704355\n,,2,1970-01-01T00:00:00Z,m,2,f,0.15676131286844733\n,,2,1970-01-01T01:00:00Z,m,2,f,0.6400877570876031\n,,2,1970-01-01T02:00:00Z,m,2,f,0.893878275849246\n,,2,1970-01-01T03:00:00Z,m,2,f,0.7997870081362324\n,,2,1970-01-01T04:00:00Z,m,2,f,0.08663328673289308\n,,2,1970-01-01T05:00:00Z,m,2,f,0.8342029060820773\n,,2,1970-01-01T06:00:00Z,m,2,f,0.11628112203352979\n,,2,1970-01-01T07:00:00Z,m,2,f,0.2623494322713019\n,,2,1970-01-01T08:00:00Z,m,2,f,0.2803453288904869\n,,2,1970-01-01T09:00:00Z,m,2,f,0.1117401998642663\n,,2,1970-01-01T10:00:00Z,m,2,f,0.3250295694300974\n,,2,1970-01-01T11:00:00Z,m,2,f,0.6078411671373538\n,,2,1970-01-01T12:00:00Z,m,2,f,0.2512356097508373\n,,2,1970-01-01T13:00:00Z,m,2,f,0.4438471268050767\n,,2,1970-01-01T14:00:00Z,m,2,f,0.4961524472008469\n,,2,1970-01-01T15:00:00Z,m,2,f,0.27020729375557506\n,,2,1970-01-01T16:00:00Z,m,2,f,0.08718790189805248\n,,2,1970-01-01T17:00:00Z,m,2,f,0.9737141084388389\n,,2,1970-01-01T18:00:00Z,m,2,f,0.07166549074370027\n,,2,1970-01-01T19:00:00Z,m,2,f,0.26943653430867687\n,,3,1970-01-01T00:00:00Z,m,3,f,0.14437387897405465\n,,3,1970-01-01T01:00:00Z,m,3,f,0.21057568804660023\n,,3,1970-01-01T02:00:00Z,m,3,f,0.1100457949346592\n,,3,1970-01-01T03:00:00Z,m,3,f,0.21141077792261312\n,,3,1970-01-01T04:00:00Z,m,3,f,0.19825711934860404\n,,3,1970-01-01T05:00:00Z,m,3,f,0.8253021658464177\n,,3,1970-01-01T06:00:00Z,m,3,f,0.7540703924924461\n,,3,1970-01-01T07:00:00Z,m,3,f,0.9503578735213787\n,,3,1970-01-01T08:00:00Z,m,3,f,0.0355914513304335\n,,3,1970-01-01T09:00:00Z,m,3,f,0.2745746957286906\n,,3,1970-01-01T10:00:00Z,m,3,f,0.5443182488460032\n,,3,1970-01-01T11:00:00Z,m,3,f,0.44666597783400147\n,,3,1970-01-01T12:00:00Z,m,3,f,0.8093304994650494\n,,3,1970-01-01T13:00:00Z,m,3,f,0.4029418644675999\n,,3,1970-01-01T14:00:00Z,m,3,f,0.8576441137558692\n,,3,1970-01-01T15:00:00Z,m,3,f,0.5687663277465801\n,,3,1970-01-01T16:00:00Z,m,3,f,0.7196911732820932\n,,3,1970-01-01T17:00:00Z,m,3,f,0.029762405134454425\n,,3,1970-01-01T18:00:00Z,m,3,f,0.04147327683312637\n,,3,1970-01-01T19:00:00Z,m,3,f,0.9540246504017378\n,,4,1970-01-01T00:00:00Z,m,4,f,0.5897122797730547\n,,4,1970-01-01T01:00:00Z,m,4,f,0.34947791862749694\n,,4,1970-01-01T02:00:00Z,m,4,f,0.0348965616058906\n,,4,1970-01-01T03:00:00Z,m,4,f,0.5410660442822854\n,,4,1970-01-01T04:00:00Z,m,4,f,0.5905190211554855\n,,4,1970-01-01T05:00:00Z,m,4,f,0.26747573301173966\n,,4,1970-01-01T06:00:00Z,m,4,f,0.9013278299551851\n,,4,1970-01-01T07:00:00Z,m,4,f,0.020645183363589\n,,4,1970-01-01T08:00:00Z,m,4,f,0.9444715783077008\n,,4,1970-01-01T09:00:00Z,m,4,f,0.9249340696871452\n,,4,1970-01-01T10:00:00Z,m,4,f,0.895407127686278\n,,4,1970-01-01T11:00:00Z,m,4,f,0.09158865660821072\n,,4,1970-01-01T12:00:00Z,m,4,f,0.26170334389270705\n,,4,1970-01-01T13:00:00Z,m,4,f,0.04047303046439957\n,,4,1970-01-01T14:00:00Z,m,4,f,0.6890175711780648\n,,4,1970-01-01T15:00:00Z,m,4,f,0.169203543095355\n,,4,1970-01-01T16:00:00Z,m,4,f,0.30352036330937937\n,,4,1970-01-01T17:00:00Z,m,4,f,0.7227629347521738\n,,4,1970-01-01T18:00:00Z,m,4,f,0.23071325246204685\n,,4,1970-01-01T19:00:00Z,m,4,f,0.5423975878441447\n,,5,1970-01-01T00:00:00Z,m,5,f,0.6159810548328785\n,,5,1970-01-01T01:00:00Z,m,5,f,0.5286371352099966\n,,5,1970-01-01T02:00:00Z,m,5,f,0.27037470564664345\n,,5,1970-01-01T03:00:00Z,m,5,f,0.9821155970111088\n,,5,1970-01-01T04:00:00Z,m,5,f,0.14128644025052767\n,,5,1970-01-01T05:00:00Z,m,5,f,0.15532267675041508\n,,5,1970-01-01T06:00:00Z,m,5,f,0.06470957508645864\n,,5,1970-01-01T07:00:00Z,m,5,f,0.852695602303644\n,,5,1970-01-01T08:00:00Z,m,5,f,0.9769235734819968\n,,5,1970-01-01T09:00:00Z,m,5,f,0.569772655210167\n,,5,1970-01-01T10:00:00Z,m,5,f,0.17839244855342468\n,,5,1970-01-01T11:00:00Z,m,5,f,0.5601900079688499\n,,5,1970-01-01T12:00:00Z,m,5,f,0.7674758179196\n,,5,1970-01-01T13:00:00Z,m,5,f,0.2698164186565066\n,,5,1970-01-01T14:00:00Z,m,5,f,0.019420090923226472\n,,5,1970-01-01T15:00:00Z,m,5,f,0.2671021005213226\n,,5,1970-01-01T16:00:00Z,m,5,f,0.2470396837146283\n,,5,1970-01-01T17:00:00Z,m,5,f,0.20522314571010808\n,,5,1970-01-01T18:00:00Z,m,5,f,0.47998413047851307\n,,5,1970-01-01T19:00:00Z,m,5,f,0.48347993430331904\n,,6,1970-01-01T00:00:00Z,m,6,f,0.6342972876998171\n,,6,1970-01-01T01:00:00Z,m,6,f,0.6576024605878982\n,,6,1970-01-01T02:00:00Z,m,6,f,0.6447000482746346\n,,6,1970-01-01T03:00:00Z,m,6,f,0.21678100598418243\n,,6,1970-01-01T04:00:00Z,m,6,f,0.023408287556663337\n,,6,1970-01-01T05:00:00Z,m,6,f,0.9076309223942498\n,,6,1970-01-01T06:00:00Z,m,6,f,0.5817502777240137\n,,6,1970-01-01T07:00:00Z,m,6,f,0.052824998643205875\n,,6,1970-01-01T08:00:00Z,m,6,f,0.3809330972535029\n,,6,1970-01-01T09:00:00Z,m,6,f,0.7671686650796129\n,,6,1970-01-01T10:00:00Z,m,6,f,0.07979065684298921\n,,6,1970-01-01T11:00:00Z,m,6,f,0.3998772862617565\n,,6,1970-01-01T12:00:00Z,m,6,f,0.1155491863199121\n,,6,1970-01-01T13:00:00Z,m,6,f,0.7386676189881027\n,,6,1970-01-01T14:00:00Z,m,6,f,0.34629618068681484\n,,6,1970-01-01T15:00:00Z,m,6,f,0.5525776529918931\n,,6,1970-01-01T16:00:00Z,m,6,f,0.332627727109297\n,,6,1970-01-01T17:00:00Z,m,6,f,0.5131953610405185\n,,6,1970-01-01T18:00:00Z,m,6,f,0.6424768197911961\n,,6,1970-01-01T19:00:00Z,m,6,f,0.7165748159282228\n,,7,1970-01-01T00:00:00Z,m,7,f,0.2455426279704188\n,,7,1970-01-01T01:00:00Z,m,7,f,0.40163124489623003\n,,7,1970-01-01T02:00:00Z,m,7,f,0.5975613157276424\n,,7,1970-01-01T03:00:00Z,m,7,f,0.24368494285955775\n,,7,1970-01-01T04:00:00Z,m,7,f,0.5064758608991188\n,,7,1970-01-01T05:00:00Z,m,7,f,0.8752680628605042\n,,7,1970-01-01T06:00:00Z,m,7,f,0.6073886500434565\n,,7,1970-01-01T07:00:00Z,m,7,f,0.38193775998692464\n,,7,1970-01-01T08:00:00Z,m,7,f,0.39598277949908883\n,,7,1970-01-01T09:00:00Z,m,7,f,0.15966785725202795\n,,7,1970-01-01T10:00:00Z,m,7,f,0.629484974659171\n,,7,1970-01-01T11:00:00Z,m,7,f,0.8986665286614761\n,,7,1970-01-01T12:00:00Z,m,7,f,0.8351669026338405\n,,7,1970-01-01T13:00:00Z,m,7,f,0.7207824488925798\n,,7,1970-01-01T14:00:00Z,m,7,f,0.5707878569829702\n,,7,1970-01-01T15:00:00Z,m,7,f,0.8091445743234214\n,,7,1970-01-01T16:00:00Z,m,7,f,0.3371203534810527\n,,7,1970-01-01T17:00:00Z,m,7,f,0.1741931226422866\n,,7,1970-01-01T18:00:00Z,m,7,f,0.7377303139536953\n,,7,1970-01-01T19:00:00Z,m,7,f,0.6414830272020358\n,,8,1970-01-01T00:00:00Z,m,8,f,0.507272964067779\n,,8,1970-01-01T01:00:00Z,m,8,f,0.7119639952021554\n,,8,1970-01-01T02:00:00Z,m,8,f,0.811656300965649\n,,8,1970-01-01T03:00:00Z,m,8,f,0.42116179653493335\n,,8,1970-01-01T04:00:00Z,m,8,f,0.43222575065281893\n,,8,1970-01-01T05:00:00Z,m,8,f,0.5074074618881453\n,,8,1970-01-01T06:00:00Z,m,8,f,0.5122144565697357\n,,8,1970-01-01T07:00:00Z,m,8,f,0.40715470738979853\n,,8,1970-01-01T08:00:00Z,m,8,f,0.8185589852847821\n,,8,1970-01-01T09:00:00Z,m,8,f,0.06615362288768847\n,,8,1970-01-01T10:00:00Z,m,8,f,0.95397955896684\n,,8,1970-01-01T11:00:00Z,m,8,f,0.3012853054957797\n,,8,1970-01-01T12:00:00Z,m,8,f,0.6957865828883222\n,,8,1970-01-01T13:00:00Z,m,8,f,0.18349784531489438\n,,8,1970-01-01T14:00:00Z,m,8,f,0.5326579864159198\n,,8,1970-01-01T15:00:00Z,m,8,f,0.16264304295239912\n,,8,1970-01-01T16:00:00Z,m,8,f,0.39612399186342956\n,,8,1970-01-01T17:00:00Z,m,8,f,0.8801431671211721\n,,8,1970-01-01T18:00:00Z,m,8,f,0.8905454115467667\n,,8,1970-01-01T19:00:00Z,m,8,f,0.37008895622309546\n,,9,1970-01-01T00:00:00Z,m,9,f,0.5943978030122283\n,,9,1970-01-01T01:00:00Z,m,9,f,0.9729045142730391\n,,9,1970-01-01T02:00:00Z,m,9,f,0.29963260412871184\n,,9,1970-01-01T03:00:00Z,m,9,f,0.13549246068853443\n,,9,1970-01-01T04:00:00Z,m,9,f,0.4985352282527366\n,,9,1970-01-01T05:00:00Z,m,9,f,0.70041974640892\n,,9,1970-01-01T06:00:00Z,m,9,f,0.5505166729368712\n,,9,1970-01-01T07:00:00Z,m,9,f,0.529948574619832\n,,9,1970-01-01T08:00:00Z,m,9,f,0.591106104564076\n,,9,1970-01-01T09:00:00Z,m,9,f,0.0635615209104685\n,,9,1970-01-01T10:00:00Z,m,9,f,0.49844667852584\n,,9,1970-01-01T11:00:00Z,m,9,f,0.8229130635259402\n,,9,1970-01-01T12:00:00Z,m,9,f,0.5768314206131357\n,,9,1970-01-01T13:00:00Z,m,9,f,0.7964902809518639\n,,9,1970-01-01T14:00:00Z,m,9,f,0.8577185880621226\n,,9,1970-01-01T15:00:00Z,m,9,f,0.8046611697264398\n,,9,1970-01-01T16:00:00Z,m,9,f,0.9035778001333393\n,,9,1970-01-01T17:00:00Z,m,9,f,0.25310651193805\n,,9,1970-01-01T18:00:00Z,m,9,f,0.9644663191492964\n,,9,1970-01-01T19:00:00Z,m,9,f,0.41841409390509593\n,,10,1970-01-01T00:00:00Z,m,a,f,0.18615629501863318\n,,10,1970-01-01T01:00:00Z,m,a,f,0.07946862666753376\n,,10,1970-01-01T02:00:00Z,m,a,f,0.33322548107896877\n,,10,1970-01-01T03:00:00Z,m,a,f,0.6074227273766635\n,,10,1970-01-01T04:00:00Z,m,a,f,0.8355600086380185\n,,10,1970-01-01T05:00:00Z,m,a,f,0.0696815215736273\n,,10,1970-01-01T06:00:00Z,m,a,f,0.9745054585018766\n,,10,1970-01-01T07:00:00Z,m,a,f,0.2845881026557506\n,,10,1970-01-01T08:00:00Z,m,a,f,0.38922817710857965\n,,10,1970-01-01T09:00:00Z,m,a,f,0.5614403393810139\n,,10,1970-01-01T10:00:00Z,m,a,f,0.5197270817554469\n,,10,1970-01-01T11:00:00Z,m,a,f,0.021532590173884557\n,,10,1970-01-01T12:00:00Z,m,a,f,0.16056999815441234\n,,10,1970-01-01T13:00:00Z,m,a,f,0.9518781786152178\n,,10,1970-01-01T14:00:00Z,m,a,f,0.27274707738681897\n,,10,1970-01-01T15:00:00Z,m,a,f,0.3202684728841677\n,,10,1970-01-01T16:00:00Z,m,a,f,0.30600536680315443\n,,10,1970-01-01T17:00:00Z,m,a,f,0.7144229319519285\n,,10,1970-01-01T18:00:00Z,m,a,f,0.8195988405538475\n,,10,1970-01-01T19:00:00Z,m,a,f,0.6833069146305664\n,,11,1970-01-01T00:00:00Z,m,b,f,0.08212464969207754\n,,11,1970-01-01T01:00:00Z,m,b,f,0.7049389293987478\n,,11,1970-01-01T02:00:00Z,m,b,f,0.46150233142660235\n,,11,1970-01-01T03:00:00Z,m,b,f,0.3061287983538073\n,,11,1970-01-01T04:00:00Z,m,b,f,0.5095622098330529\n,,11,1970-01-01T05:00:00Z,m,b,f,0.24885143749146582\n,,11,1970-01-01T06:00:00Z,m,b,f,0.2720705701013104\n,,11,1970-01-01T07:00:00Z,m,b,f,0.831725266287822\n,,11,1970-01-01T08:00:00Z,m,b,f,0.2980839741707451\n,,11,1970-01-01T09:00:00Z,m,b,f,0.4667397329742896\n,,11,1970-01-01T10:00:00Z,m,b,f,0.7604282480092655\n,,11,1970-01-01T11:00:00Z,m,b,f,0.08125558409370949\n,,11,1970-01-01T12:00:00Z,m,b,f,0.9673492809150086\n,,11,1970-01-01T13:00:00Z,m,b,f,0.7485101477006051\n,,11,1970-01-01T14:00:00Z,m,b,f,0.7826905277143607\n,,11,1970-01-01T15:00:00Z,m,b,f,0.002832539681341695\n,,11,1970-01-01T16:00:00Z,m,b,f,0.5904945620548707\n,,11,1970-01-01T17:00:00Z,m,b,f,0.19377318954716558\n,,11,1970-01-01T18:00:00Z,m,b,f,0.32112472445570694\n,,11,1970-01-01T19:00:00Z,m,b,f,0.8156620813866876\n,,12,1970-01-01T00:00:00Z,m,c,f,0.45823190604583425\n,,12,1970-01-01T01:00:00Z,m,c,f,0.7041395377467482\n,,12,1970-01-01T02:00:00Z,m,c,f,0.7164281522457248\n,,12,1970-01-01T03:00:00Z,m,c,f,0.664229117231648\n,,12,1970-01-01T04:00:00Z,m,c,f,0.2167198068478531\n,,12,1970-01-01T05:00:00Z,m,c,f,0.4781537327645974\n,,12,1970-01-01T06:00:00Z,m,c,f,0.915856481062239\n,,12,1970-01-01T07:00:00Z,m,c,f,0.7488973719504495\n,,12,1970-01-01T08:00:00Z,m,c,f,0.8415102413049199\n,,12,1970-01-01T09:00:00Z,m,c,f,0.9749127169681439\n,,12,1970-01-01T10:00:00Z,m,c,f,0.5203067180352847\n,,12,1970-01-01T11:00:00Z,m,c,f,0.8077896981284608\n,,12,1970-01-01T12:00:00Z,m,c,f,0.3140632603734003\n,,12,1970-01-01T13:00:00Z,m,c,f,0.4942913283054576\n,,12,1970-01-01T14:00:00Z,m,c,f,0.7803195300512884\n,,12,1970-01-01T15:00:00Z,m,c,f,0.29988813201194514\n,,12,1970-01-01T16:00:00Z,m,c,f,0.9275317190485068\n,,12,1970-01-01T17:00:00Z,m,c,f,0.8532168145174167\n,,12,1970-01-01T18:00:00Z,m,c,f,0.29567768993242205\n,,12,1970-01-01T19:00:00Z,m,c,f,0.148869586329582\n,,13,1970-01-01T00:00:00Z,m,d,f,0.8734370766635879\n,,13,1970-01-01T01:00:00Z,m,d,f,0.7450766293779155\n,,13,1970-01-01T02:00:00Z,m,d,f,0.9454605686978569\n,,13,1970-01-01T03:00:00Z,m,d,f,0.20587883115663197\n,,13,1970-01-01T04:00:00Z,m,d,f,0.5495265257832065\n,,13,1970-01-01T05:00:00Z,m,d,f,0.9985101041430109\n,,13,1970-01-01T06:00:00Z,m,d,f,0.606668520981593\n,,13,1970-01-01T07:00:00Z,m,d,f,0.1520034163165451\n,,13,1970-01-01T08:00:00Z,m,d,f,0.8960639437047637\n,,13,1970-01-01T09:00:00Z,m,d,f,0.40243673434606525\n,,13,1970-01-01T10:00:00Z,m,d,f,0.8559633842216021\n,,13,1970-01-01T11:00:00Z,m,d,f,0.8049602305582066\n,,13,1970-01-01T12:00:00Z,m,d,f,0.7472498943010795\n,,13,1970-01-01T13:00:00Z,m,d,f,0.19955816724612416\n,,13,1970-01-01T14:00:00Z,m,d,f,0.6398800958352263\n,,13,1970-01-01T15:00:00Z,m,d,f,0.9121026864646193\n,,13,1970-01-01T16:00:00Z,m,d,f,0.5138919840212206\n,,13,1970-01-01T17:00:00Z,m,d,f,0.8090917843470073\n,,13,1970-01-01T18:00:00Z,m,d,f,0.7569845252265965\n,,13,1970-01-01T19:00:00Z,m,d,f,0.28321607497510914\n,,14,1970-01-01T00:00:00Z,m,e,f,0.015015322322770903\n,,14,1970-01-01T01:00:00Z,m,e,f,0.9355541025597022\n,,14,1970-01-01T02:00:00Z,m,e,f,0.04136655165051055\n,,14,1970-01-01T03:00:00Z,m,e,f,0.5818917517534496\n,,14,1970-01-01T04:00:00Z,m,e,f,0.5003101543125776\n,,14,1970-01-01T05:00:00Z,m,e,f,0.9100689489842115\n,,14,1970-01-01T06:00:00Z,m,e,f,0.16048736645104625\n,,14,1970-01-01T07:00:00Z,m,e,f,0.9463952890222139\n,,14,1970-01-01T08:00:00Z,m,e,f,0.9639066785470444\n,,14,1970-01-01T09:00:00Z,m,e,f,0.5265981043058684\n,,14,1970-01-01T10:00:00Z,m,e,f,0.1618974442468811\n,,14,1970-01-01T11:00:00Z,m,e,f,0.23732885629224745\n,,14,1970-01-01T12:00:00Z,m,e,f,0.6209913661783305\n,,14,1970-01-01T13:00:00Z,m,e,f,0.37725772933735735\n,,14,1970-01-01T14:00:00Z,m,e,f,0.8852154063171275\n,,14,1970-01-01T15:00:00Z,m,e,f,0.7614955446339434\n,,14,1970-01-01T16:00:00Z,m,e,f,0.8089264477070236\n,,14,1970-01-01T17:00:00Z,m,e,f,0.8491087096738495\n,,14,1970-01-01T18:00:00Z,m,e,f,0.051500691978027605\n,,14,1970-01-01T19:00:00Z,m,e,f,0.16249922364133557\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.2128911717061432\n,,0,1970-01-01T01:00:00Z,m,0,f,0.07279997497030395\n,,0,1970-01-01T02:00:00Z,m,0,f,0.5685247543217412\n,,0,1970-01-01T03:00:00Z,m,0,f,0.29096443393390425\n,,0,1970-01-01T04:00:00Z,m,0,f,0.4356705625292191\n,,0,1970-01-01T05:00:00Z,m,0,f,0.9377323443071505\n,,0,1970-01-01T06:00:00Z,m,0,f,0.011686627909299956\n,,0,1970-01-01T07:00:00Z,m,0,f,0.4011512684588352\n,,0,1970-01-01T08:00:00Z,m,0,f,0.2467000604224705\n,,0,1970-01-01T09:00:00Z,m,0,f,0.035457662801040575\n,,0,1970-01-01T10:00:00Z,m,0,f,0.34069878765762024\n,,0,1970-01-01T11:00:00Z,m,0,f,0.0956150560348323\n,,0,1970-01-01T12:00:00Z,m,0,f,0.6807780291957698\n,,0,1970-01-01T13:00:00Z,m,0,f,0.5337946188653447\n,,0,1970-01-01T14:00:00Z,m,0,f,0.20254189091820943\n,,0,1970-01-01T15:00:00Z,m,0,f,0.9364775207397588\n,,0,1970-01-01T16:00:00Z,m,0,f,0.7339764257047982\n,,0,1970-01-01T17:00:00Z,m,0,f,0.5833903306697613\n,,0,1970-01-01T18:00:00Z,m,0,f,0.3640275286497918\n,,0,1970-01-01T19:00:00Z,m,0,f,0.6631189097103277\n,,1,1970-01-01T00:00:00Z,m,1,f,0.6769161010724867\n,,1,1970-01-01T01:00:00Z,m,1,f,0.6543314107501336\n,,1,1970-01-01T02:00:00Z,m,1,f,0.6291463500252206\n,,1,1970-01-01T03:00:00Z,m,1,f,0.3152301292534112\n,,1,1970-01-01T04:00:00Z,m,1,f,0.03392415665887264\n,,1,1970-01-01T05:00:00Z,m,1,f,0.5082438395428922\n,,1,1970-01-01T06:00:00Z,m,1,f,0.10525600178569848\n,,1,1970-01-01T07:00:00Z,m,1,f,0.09521084883546317\n,,1,1970-01-01T08:00:00Z,m,1,f,0.865591485631552\n,,1,1970-01-01T09:00:00Z,m,1,f,0.4959724763808837\n,,1,1970-01-01T10:00:00Z,m,1,f,0.05679627383763615\n,,1,1970-01-01T11:00:00Z,m,1,f,0.1220798530727814\n,,1,1970-01-01T12:00:00Z,m,1,f,0.41254260137685644\n,,1,1970-01-01T13:00:00Z,m,1,f,0.07588672428630415\n,,1,1970-01-01T14:00:00Z,m,1,f,0.24813765601579021\n,,1,1970-01-01T15:00:00Z,m,1,f,0.087428932094856\n,,1,1970-01-01T16:00:00Z,m,1,f,0.768343862050663\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9683960475385988\n,,1,1970-01-01T18:00:00Z,m,1,f,0.024459901010390767\n,,1,1970-01-01T19:00:00Z,m,1,f,0.16444015119704355\n,,2,1970-01-01T00:00:00Z,m,2,f,0.15676131286844733\n,,2,1970-01-01T01:00:00Z,m,2,f,0.6400877570876031\n,,2,1970-01-01T02:00:00Z,m,2,f,0.893878275849246\n,,2,1970-01-01T03:00:00Z,m,2,f,0.7997870081362324\n,,2,1970-01-01T04:00:00Z,m,2,f,0.08663328673289308\n,,2,1970-01-01T05:00:00Z,m,2,f,0.8342029060820773\n,,2,1970-01-01T06:00:00Z,m,2,f,0.11628112203352979\n,,2,1970-01-01T07:00:00Z,m,2,f,0.2623494322713019\n,,2,1970-01-01T08:00:00Z,m,2,f,0.2803453288904869\n,,2,1970-01-01T09:00:00Z,m,2,f,0.1117401998642663\n,,2,1970-01-01T10:00:00Z,m,2,f,0.3250295694300974\n,,2,1970-01-01T11:00:00Z,m,2,f,0.6078411671373538\n,,2,1970-01-01T12:00:00Z,m,2,f,0.2512356097508373\n,,2,1970-01-01T13:00:00Z,m,2,f,0.4438471268050767\n,,2,1970-01-01T14:00:00Z,m,2,f,0.4961524472008469\n,,2,1970-01-01T15:00:00Z,m,2,f,0.27020729375557506\n,,2,1970-01-01T16:00:00Z,m,2,f,0.08718790189805248\n,,2,1970-01-01T17:00:00Z,m,2,f,0.9737141084388389\n,,2,1970-01-01T18:00:00Z,m,2,f,0.07166549074370027\n,,2,1970-01-01T19:00:00Z,m,2,f,0.26943653430867687\n,,3,1970-01-01T00:00:00Z,m,3,f,0.14437387897405465\n,,3,1970-01-01T01:00:00Z,m,3,f,0.21057568804660023\n,,3,1970-01-01T02:00:00Z,m,3,f,0.1100457949346592\n,,3,1970-01-01T03:00:00Z,m,3,f,0.21141077792261312\n,,3,1970-01-01T04:00:00Z,m,3,f,0.19825711934860404\n,,3,1970-01-01T05:00:00Z,m,3,f,0.8253021658464177\n,,3,1970-01-01T06:00:00Z,m,3,f,0.7540703924924461\n,,3,1970-01-01T07:00:00Z,m,3,f,0.9503578735213787\n,,3,1970-01-01T08:00:00Z,m,3,f,0.0355914513304335\n,,3,1970-01-01T09:00:00Z,m,3,f,0.2745746957286906\n,,3,1970-01-01T10:00:00Z,m,3,f,0.5443182488460032\n,,3,1970-01-01T11:00:00Z,m,3,f,0.44666597783400147\n,,3,1970-01-01T12:00:00Z,m,3,f,0.8093304994650494\n,,3,1970-01-01T13:00:00Z,m,3,f,0.4029418644675999\n,,3,1970-01-01T14:00:00Z,m,3,f,0.8576441137558692\n,,3,1970-01-01T15:00:00Z,m,3,f,0.5687663277465801\n,,3,1970-01-01T16:00:00Z,m,3,f,0.7196911732820932\n,,3,1970-01-01T17:00:00Z,m,3,f,0.029762405134454425\n,,3,1970-01-01T18:00:00Z,m,3,f,0.04147327683312637\n,,3,1970-01-01T19:00:00Z,m,3,f,0.9540246504017378\n,,4,1970-01-01T00:00:00Z,m,4,f,0.5897122797730547\n,,4,1970-01-01T01:00:00Z,m,4,f,0.34947791862749694\n,,4,1970-01-01T02:00:00Z,m,4,f,0.0348965616058906\n,,4,1970-01-01T03:00:00Z,m,4,f,0.5410660442822854\n,,4,1970-01-01T04:00:00Z,m,4,f,0.5905190211554855\n,,4,1970-01-01T05:00:00Z,m,4,f,0.26747573301173966\n,,4,1970-01-01T06:00:00Z,m,4,f,0.9013278299551851\n,,4,1970-01-01T07:00:00Z,m,4,f,0.020645183363589\n,,4,1970-01-01T08:00:00Z,m,4,f,0.9444715783077008\n,,4,1970-01-01T09:00:00Z,m,4,f,0.9249340696871452\n,,4,1970-01-01T10:00:00Z,m,4,f,0.895407127686278\n,,4,1970-01-01T11:00:00Z,m,4,f,0.09158865660821072\n,,4,1970-01-01T12:00:00Z,m,4,f,0.26170334389270705\n,,4,1970-01-01T13:00:00Z,m,4,f,0.04047303046439957\n,,4,1970-01-01T14:00:00Z,m,4,f,0.6890175711780648\n,,4,1970-01-01T15:00:00Z,m,4,f,0.169203543095355\n,,4,1970-01-01T16:00:00Z,m,4,f,0.30352036330937937\n,,4,1970-01-01T17:00:00Z,m,4,f,0.7227629347521738\n,,4,1970-01-01T18:00:00Z,m,4,f,0.23071325246204685\n,,4,1970-01-01T19:00:00Z,m,4,f,0.5423975878441447\n,,5,1970-01-01T00:00:00Z,m,5,f,0.6159810548328785\n,,5,1970-01-01T01:00:00Z,m,5,f,0.5286371352099966\n,,5,1970-01-01T02:00:00Z,m,5,f,0.27037470564664345\n,,5,1970-01-01T03:00:00Z,m,5,f,0.9821155970111088\n,,5,1970-01-01T04:00:00Z,m,5,f,0.14128644025052767\n,,5,1970-01-01T05:00:00Z,m,5,f,0.15532267675041508\n,,5,1970-01-01T06:00:00Z,m,5,f,0.06470957508645864\n,,5,1970-01-01T07:00:00Z,m,5,f,0.852695602303644\n,,5,1970-01-01T08:00:00Z,m,5,f,0.9769235734819968\n,,5,1970-01-01T09:00:00Z,m,5,f,0.569772655210167\n,,5,1970-01-01T10:00:00Z,m,5,f,0.17839244855342468\n,,5,1970-01-01T11:00:00Z,m,5,f,0.5601900079688499\n,,5,1970-01-01T12:00:00Z,m,5,f,0.7674758179196\n,,5,1970-01-01T13:00:00Z,m,5,f,0.2698164186565066\n,,5,1970-01-01T14:00:00Z,m,5,f,0.019420090923226472\n,,5,1970-01-01T15:00:00Z,m,5,f,0.2671021005213226\n,,5,1970-01-01T16:00:00Z,m,5,f,0.2470396837146283\n,,5,1970-01-01T17:00:00Z,m,5,f,0.20522314571010808\n,,5,1970-01-01T18:00:00Z,m,5,f,0.47998413047851307\n,,5,1970-01-01T19:00:00Z,m,5,f,0.48347993430331904\n,,6,1970-01-01T00:00:00Z,m,6,f,0.6342972876998171\n,,6,1970-01-01T01:00:00Z,m,6,f,0.6576024605878982\n,,6,1970-01-01T02:00:00Z,m,6,f,0.6447000482746346\n,,6,1970-01-01T03:00:00Z,m,6,f,0.21678100598418243\n,,6,1970-01-01T04:00:00Z,m,6,f,0.023408287556663337\n,,6,1970-01-01T05:00:00Z,m,6,f,0.9076309223942498\n,,6,1970-01-01T06:00:00Z,m,6,f,0.5817502777240137\n,,6,1970-01-01T07:00:00Z,m,6,f,0.052824998643205875\n,,6,1970-01-01T08:00:00Z,m,6,f,0.3809330972535029\n,,6,1970-01-01T09:00:00Z,m,6,f,0.7671686650796129\n,,6,1970-01-01T10:00:00Z,m,6,f,0.07979065684298921\n,,6,1970-01-01T11:00:00Z,m,6,f,0.3998772862617565\n,,6,1970-01-01T12:00:00Z,m,6,f,0.1155491863199121\n,,6,1970-01-01T13:00:00Z,m,6,f,0.7386676189881027\n,,6,1970-01-01T14:00:00Z,m,6,f,0.34629618068681484\n,,6,1970-01-01T15:00:00Z,m,6,f,0.5525776529918931\n,,6,1970-01-01T16:00:00Z,m,6,f,0.332627727109297\n,,6,1970-01-01T17:00:00Z,m,6,f,0.5131953610405185\n,,6,1970-01-01T18:00:00Z,m,6,f,0.6424768197911961\n,,6,1970-01-01T19:00:00Z,m,6,f,0.7165748159282228\n,,7,1970-01-01T00:00:00Z,m,7,f,0.2455426279704188\n,,7,1970-01-01T01:00:00Z,m,7,f,0.40163124489623003\n,,7,1970-01-01T02:00:00Z,m,7,f,0.5975613157276424\n,,7,1970-01-01T03:00:00Z,m,7,f,0.24368494285955775\n,,7,1970-01-01T04:00:00Z,m,7,f,0.5064758608991188\n,,7,1970-01-01T05:00:00Z,m,7,f,0.8752680628605042\n,,7,1970-01-01T06:00:00Z,m,7,f,0.6073886500434565\n,,7,1970-01-01T07:00:00Z,m,7,f,0.38193775998692464\n,,7,1970-01-01T08:00:00Z,m,7,f,0.39598277949908883\n,,7,1970-01-01T09:00:00Z,m,7,f,0.15966785725202795\n,,7,1970-01-01T10:00:00Z,m,7,f,0.629484974659171\n,,7,1970-01-01T11:00:00Z,m,7,f,0.8986665286614761\n,,7,1970-01-01T12:00:00Z,m,7,f,0.8351669026338405\n,,7,1970-01-01T13:00:00Z,m,7,f,0.7207824488925798\n,,7,1970-01-01T14:00:00Z,m,7,f,0.5707878569829702\n,,7,1970-01-01T15:00:00Z,m,7,f,0.8091445743234214\n,,7,1970-01-01T16:00:00Z,m,7,f,0.3371203534810527\n,,7,1970-01-01T17:00:00Z,m,7,f,0.1741931226422866\n,,7,1970-01-01T18:00:00Z,m,7,f,0.7377303139536953\n,,7,1970-01-01T19:00:00Z,m,7,f,0.6414830272020358\n,,8,1970-01-01T00:00:00Z,m,8,f,0.507272964067779\n,,8,1970-01-01T01:00:00Z,m,8,f,0.7119639952021554\n,,8,1970-01-01T02:00:00Z,m,8,f,0.811656300965649\n,,8,1970-01-01T03:00:00Z,m,8,f,0.42116179653493335\n,,8,1970-01-01T04:00:00Z,m,8,f,0.43222575065281893\n,,8,1970-01-01T05:00:00Z,m,8,f,0.5074074618881453\n,,8,1970-01-01T06:00:00Z,m,8,f,0.5122144565697357\n,,8,1970-01-01T07:00:00Z,m,8,f,0.40715470738979853\n,,8,1970-01-01T08:00:00Z,m,8,f,0.8185589852847821\n,,8,1970-01-01T09:00:00Z,m,8,f,0.06615362288768847\n,,8,1970-01-01T10:00:00Z,m,8,f,0.95397955896684\n,,8,1970-01-01T11:00:00Z,m,8,f,0.3012853054957797\n,,8,1970-01-01T12:00:00Z,m,8,f,0.6957865828883222\n,,8,1970-01-01T13:00:00Z,m,8,f,0.18349784531489438\n,,8,1970-01-01T14:00:00Z,m,8,f,0.5326579864159198\n,,8,1970-01-01T15:00:00Z,m,8,f,0.16264304295239912\n,,8,1970-01-01T16:00:00Z,m,8,f,0.39612399186342956\n,,8,1970-01-01T17:00:00Z,m,8,f,0.8801431671211721\n,,8,1970-01-01T18:00:00Z,m,8,f,0.8905454115467667\n,,8,1970-01-01T19:00:00Z,m,8,f,0.37008895622309546\n,,9,1970-01-01T00:00:00Z,m,9,f,0.5943978030122283\n,,9,1970-01-01T01:00:00Z,m,9,f,0.9729045142730391\n,,9,1970-01-01T02:00:00Z,m,9,f,0.29963260412871184\n,,9,1970-01-01T03:00:00Z,m,9,f,0.13549246068853443\n,,9,1970-01-01T04:00:00Z,m,9,f,0.4985352282527366\n,,9,1970-01-01T05:00:00Z,m,9,f,0.70041974640892\n,,9,1970-01-01T06:00:00Z,m,9,f,0.5505166729368712\n,,9,1970-01-01T07:00:00Z,m,9,f,0.529948574619832\n,,9,1970-01-01T08:00:00Z,m,9,f,0.591106104564076\n,,9,1970-01-01T09:00:00Z,m,9,f,0.0635615209104685\n,,9,1970-01-01T10:00:00Z,m,9,f,0.49844667852584\n,,9,1970-01-01T11:00:00Z,m,9,f,0.8229130635259402\n,,9,1970-01-01T12:00:00Z,m,9,f,0.5768314206131357\n,,9,1970-01-01T13:00:00Z,m,9,f,0.7964902809518639\n,,9,1970-01-01T14:00:00Z,m,9,f,0.8577185880621226\n,,9,1970-01-01T15:00:00Z,m,9,f,0.8046611697264398\n,,9,1970-01-01T16:00:00Z,m,9,f,0.9035778001333393\n,,9,1970-01-01T17:00:00Z,m,9,f,0.25310651193805\n,,9,1970-01-01T18:00:00Z,m,9,f,0.9644663191492964\n,,9,1970-01-01T19:00:00Z,m,9,f,0.41841409390509593\n,,10,1970-01-01T00:00:00Z,m,a,f,0.18615629501863318\n,,10,1970-01-01T01:00:00Z,m,a,f,0.07946862666753376\n,,10,1970-01-01T02:00:00Z,m,a,f,0.33322548107896877\n,,10,1970-01-01T03:00:00Z,m,a,f,0.6074227273766635\n,,10,1970-01-01T04:00:00Z,m,a,f,0.8355600086380185\n,,10,1970-01-01T05:00:00Z,m,a,f,0.0696815215736273\n,,10,1970-01-01T06:00:00Z,m,a,f,0.9745054585018766\n,,10,1970-01-01T07:00:00Z,m,a,f,0.2845881026557506\n,,10,1970-01-01T08:00:00Z,m,a,f,0.38922817710857965\n,,10,1970-01-01T09:00:00Z,m,a,f,0.5614403393810139\n,,10,1970-01-01T10:00:00Z,m,a,f,0.5197270817554469\n,,10,1970-01-01T11:00:00Z,m,a,f,0.021532590173884557\n,,10,1970-01-01T12:00:00Z,m,a,f,0.16056999815441234\n,,10,1970-01-01T13:00:00Z,m,a,f,0.9518781786152178\n,,10,1970-01-01T14:00:00Z,m,a,f,0.27274707738681897\n,,10,1970-01-01T15:00:00Z,m,a,f,0.3202684728841677\n,,10,1970-01-01T16:00:00Z,m,a,f,0.30600536680315443\n,,10,1970-01-01T17:00:00Z,m,a,f,0.7144229319519285\n,,10,1970-01-01T18:00:00Z,m,a,f,0.8195988405538475\n,,10,1970-01-01T19:00:00Z,m,a,f,0.6833069146305664\n,,11,1970-01-01T00:00:00Z,m,b,f,0.08212464969207754\n,,11,1970-01-01T01:00:00Z,m,b,f,0.7049389293987478\n,,11,1970-01-01T02:00:00Z,m,b,f,0.46150233142660235\n,,11,1970-01-01T03:00:00Z,m,b,f,0.3061287983538073\n,,11,1970-01-01T04:00:00Z,m,b,f,0.5095622098330529\n,,11,1970-01-01T05:00:00Z,m,b,f,0.24885143749146582\n,,11,1970-01-01T06:00:00Z,m,b,f,0.2720705701013104\n,,11,1970-01-01T07:00:00Z,m,b,f,0.831725266287822\n,,11,1970-01-01T08:00:00Z,m,b,f,0.2980839741707451\n,,11,1970-01-01T09:00:00Z,m,b,f,0.4667397329742896\n,,11,1970-01-01T10:00:00Z,m,b,f,0.7604282480092655\n,,11,1970-01-01T11:00:00Z,m,b,f,0.08125558409370949\n,,11,1970-01-01T12:00:00Z,m,b,f,0.9673492809150086\n,,11,1970-01-01T13:00:00Z,m,b,f,0.7485101477006051\n,,11,1970-01-01T14:00:00Z,m,b,f,0.7826905277143607\n,,11,1970-01-01T15:00:00Z,m,b,f,0.002832539681341695\n,,11,1970-01-01T16:00:00Z,m,b,f,0.5904945620548707\n,,11,1970-01-01T17:00:00Z,m,b,f,0.19377318954716558\n,,11,1970-01-01T18:00:00Z,m,b,f,0.32112472445570694\n,,11,1970-01-01T19:00:00Z,m,b,f,0.8156620813866876\n,,12,1970-01-01T00:00:00Z,m,c,f,0.45823190604583425\n,,12,1970-01-01T01:00:00Z,m,c,f,0.7041395377467482\n,,12,1970-01-01T02:00:00Z,m,c,f,0.7164281522457248\n,,12,1970-01-01T03:00:00Z,m,c,f,0.664229117231648\n,,12,1970-01-01T04:00:00Z,m,c,f,0.2167198068478531\n,,12,1970-01-01T05:00:00Z,m,c,f,0.4781537327645974\n,,12,1970-01-01T06:00:00Z,m,c,f,0.915856481062239\n,,12,1970-01-01T07:00:00Z,m,c,f,0.7488973719504495\n,,12,1970-01-01T08:00:00Z,m,c,f,0.8415102413049199\n,,12,1970-01-01T09:00:00Z,m,c,f,0.9749127169681439\n,,12,1970-01-01T10:00:00Z,m,c,f,0.5203067180352847\n,,12,1970-01-01T11:00:00Z,m,c,f,0.8077896981284608\n,,12,1970-01-01T12:00:00Z,m,c,f,0.3140632603734003\n,,12,1970-01-01T13:00:00Z,m,c,f,0.4942913283054576\n,,12,1970-01-01T14:00:00Z,m,c,f,0.7803195300512884\n,,12,1970-01-01T15:00:00Z,m,c,f,0.29988813201194514\n,,12,1970-01-01T16:00:00Z,m,c,f,0.9275317190485068\n,,12,1970-01-01T17:00:00Z,m,c,f,0.8532168145174167\n,,12,1970-01-01T18:00:00Z,m,c,f,0.29567768993242205\n,,12,1970-01-01T19:00:00Z,m,c,f,0.148869586329582\n,,13,1970-01-01T00:00:00Z,m,d,f,0.8734370766635879\n,,13,1970-01-01T01:00:00Z,m,d,f,0.7450766293779155\n,,13,1970-01-01T02:00:00Z,m,d,f,0.9454605686978569\n,,13,1970-01-01T03:00:00Z,m,d,f,0.20587883115663197\n,,13,1970-01-01T04:00:00Z,m,d,f,0.5495265257832065\n,,13,1970-01-01T05:00:00Z,m,d,f,0.9985101041430109\n,,13,1970-01-01T06:00:00Z,m,d,f,0.606668520981593\n,,13,1970-01-01T07:00:00Z,m,d,f,0.1520034163165451\n,,13,1970-01-01T08:00:00Z,m,d,f,0.8960639437047637\n,,13,1970-01-01T09:00:00Z,m,d,f,0.40243673434606525\n,,13,1970-01-01T10:00:00Z,m,d,f,0.8559633842216021\n,,13,1970-01-01T11:00:00Z,m,d,f,0.8049602305582066\n,,13,1970-01-01T12:00:00Z,m,d,f,0.7472498943010795\n,,13,1970-01-01T13:00:00Z,m,d,f,0.19955816724612416\n,,13,1970-01-01T14:00:00Z,m,d,f,0.6398800958352263\n,,13,1970-01-01T15:00:00Z,m,d,f,0.9121026864646193\n,,13,1970-01-01T16:00:00Z,m,d,f,0.5138919840212206\n,,13,1970-01-01T17:00:00Z,m,d,f,0.8090917843470073\n,,13,1970-01-01T18:00:00Z,m,d,f,0.7569845252265965\n,,13,1970-01-01T19:00:00Z,m,d,f,0.28321607497510914\n,,14,1970-01-01T00:00:00Z,m,e,f,0.015015322322770903\n,,14,1970-01-01T01:00:00Z,m,e,f,0.9355541025597022\n,,14,1970-01-01T02:00:00Z,m,e,f,0.04136655165051055\n,,14,1970-01-01T03:00:00Z,m,e,f,0.5818917517534496\n,,14,1970-01-01T04:00:00Z,m,e,f,0.5003101543125776\n,,14,1970-01-01T05:00:00Z,m,e,f,0.9100689489842115\n,,14,1970-01-01T06:00:00Z,m,e,f,0.16048736645104625\n,,14,1970-01-01T07:00:00Z,m,e,f,0.9463952890222139\n,,14,1970-01-01T08:00:00Z,m,e,f,0.9639066785470444\n,,14,1970-01-01T09:00:00Z,m,e,f,0.5265981043058684\n,,14,1970-01-01T10:00:00Z,m,e,f,0.1618974442468811\n,,14,1970-01-01T11:00:00Z,m,e,f,0.23732885629224745\n,,14,1970-01-01T12:00:00Z,m,e,f,0.6209913661783305\n,,14,1970-01-01T13:00:00Z,m,e,f,0.37725772933735735\n,,14,1970-01-01T14:00:00Z,m,e,f,0.8852154063171275\n,,14,1970-01-01T15:00:00Z,m,e,f,0.7614955446339434\n,,14,1970-01-01T16:00:00Z,m,e,f,0.8089264477070236\n,,14,1970-01-01T17:00:00Z,m,e,f,0.8491087096738495\n,,14,1970-01-01T18:00:00Z,m,e,f,0.051500691978027605\n,,14,1970-01-01T19:00:00Z,m,e,f,0.16249922364133557\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   323,
					},
					File:   "aggregate_group_by_time_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,sum\n,,0,1970-01-01T00:00:00Z,m,33.802561295632636\n,,0,1970-01-01T05:00:00Z,m,38.603075816590454\n,,0,1970-01-01T10:00:00Z,m,36.99580140544222\n,,0,1970-01-01T15:00:00Z,m,37.63380091958056\n,,0,1970-01-01T20:00:00Z,m,\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   313,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   313,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   313,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   323,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,sum\n,,0,1970-01-01T00:00:00Z,m,33.802561295632636\n,,0,1970-01-01T05:00:00Z,m,38.603075816590454\n,,0,1970-01-01T10:00:00Z,m,36.99580140544222\n,,0,1970-01-01T15:00:00Z,m,37.63380091958056\n,,0,1970-01-01T20:00:00Z,m,\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   313,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,sum\n,,0,1970-01-01T00:00:00Z,m,33.802561295632636\n,,0,1970-01-01T05:00:00Z,m,38.603075816590454\n,,0,1970-01-01T10:00:00Z,m,36.99580140544222\n,,0,1970-01-01T15:00:00Z,m,37.63380091958056\n,,0,1970-01-01T20:00:00Z,m,\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 49,
						Line:   333,
					},
					File:   "aggregate_group_by_time_test.flux",
					Source: "t_aggregate_group_by_time = (tables=<-) => tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> aggregateWindow(every: 5h, fn: sum, timeSrc: \"_start\")\n\t|> rename(columns: {_time: \"time\", _value: \"sum\"})\n\t|> drop(columns: [\"_field\", \"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   326,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   326,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "t_aggregate_group_by_time",
						Start: ast.Position{
							Column: 1,
							Line:   326,
						},
					},
				},
				Name: "t_aggregate_group_by_time",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   333,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "(tables=<-) => tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> aggregateWindow(every: 5h, fn: sum, timeSrc: \"_start\")\n\t|> rename(columns: {_time: \"time\", _value: \"sum\"})\n\t|> drop(columns: [\"_field\", \"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 29,
							Line:   326,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   326,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "tables",
														Start: ast.Position{
															Column: 44,
															Line:   326,
														},
													},
												},
												Name: "tables",
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   327,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)",
													Start: ast.Position{
														Column: 44,
														Line:   326,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   327,
															},
															File:   "aggregate_group_by_time_test.flux",
															Source: "start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z",
															Start: ast.Position{
																Column: 11,
																Line:   327,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   327,
																},
																File:   "aggregate_group_by_time_test.flux",
																Source: "start: 1970-01-01T00:00:00Z",
																Start: ast.Position{
																	Column: 11,
																	Line:   327,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   327,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 11,
																		Line:   327,
																	},
																},
															},
															Name: "start",
														},
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   327,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "1970-01-01T00:00:00Z",
																	Start: ast.Position{
																		Column: 18,
																		Line:   327,
																	},
																},
															},
															Value: parser.MustParseTime("1970-01-01T00:00:00Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   327,
																},
																File:   "aggregate_group_by_time_test.flux",
																Source: "stop: 1970-01-01T20:00:00.000000001Z",
																Start: ast.Position{
																	Column: 40,
																	Line:   327,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   327,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 40,
																		Line:   327,
																	},
																},
															},
															Name: "stop",
														},
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   327,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "1970-01-01T20:00:00.000000001Z",
																	Start: ast.Position{
																		Column: 46,
																		Line:   327,
																	},
																},
															},
															Value: parser.MustParseTime("1970-01-01T20:00:00.000000001Z"),
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   327,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)",
														Start: ast.Position{
															Column: 5,
															Line:   327,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   327,
															},
															File:   "aggregate_group_by_time_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 5,
																Line:   327,
															},
														},
													},
													Name: "range",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   328,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")",
												Start: ast.Position{
													Column: 44,
													Line:   326,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   328,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "fn: (r) => r._measurement == \"m\"",
														Start: ast.Position{
															Column: 12,
															Line:   328,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   328,
															},
															File:   "aggregate_group_by_time_test.flux",
															Source: "fn: (r) => r._measurement == \"m\"",
															Start: ast.Position{
																Column: 12,
																Line:   328,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   328,
																},
																File:   "aggregate_group_by_time_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 12,
																	Line:   328,
																},
															},
														},
														Name: "fn",
													},
													Value: &ast.FunctionExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   328,
																},
																File:   "aggregate_group_by_time_test.flux",
																Source: "(r) => r._measurement == \"m\"",
																Start: ast.Position{
																	Column: 16,
																	Line:   328,
																},
															},
														},
														Body: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   328,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "r._measurement == \"m\"",
																	Start: ast.Position{
																		Column: 23,
																		Line:   328,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   328,
																		},
																		File:   "aggregate_group_by_time_test.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 23,
																			Line:   328,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   328,
																			},
																			File:   "aggregate_group_by_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 23,
																				Line:   328,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   328,
																			},
																			File:   "aggregate_group_by_time_test.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 25,
																				Line:   328,
																			},
																		},
																	},
																	Name: "_measurement",
																},
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   328,
																		},
																		File:   "aggregate_group_by_time_test.flux",
																		Source: "\"m\"",
																		Start: ast.Position{
																			Column: 41,
																			Line:   328,
																		},
																	},
																},
																Value: "m",
															},
														},
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   328,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   328,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   328,
																		},
																		File:   "aggregate_group_by_time_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   328,
																		},
																	},
																},
																Name: "r",
															},
															Value: nil,
														}},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   328,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"m\")",
													Start: ast.Position{
														Column: 5,
														Line:   328,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   328,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 5,
															Line:   328,
														},
													},
												},
												Name: "filter",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   329,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")",
											Start: ast.Position{
												Column: 44,
												Line:   326,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   329,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "fn: (r) => r._field == \"f\"",
													Start: ast.Position{
														Column: 12,
														Line:   329,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   329,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "fn: (r) => r._field == \"f\"",
														Start: ast.Position{
															Column: 12,
															Line:   329,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   329,
															},
															File:   "aggregate_group_by_time_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   329,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   329,
															},
															File:   "aggregate_group_by_time_test.flux",
															Source: "(r) => r._field == \"f\"",
															Start: ast.Position{
																Column: 16,
																Line:   329,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   329,
																},
																File:   "aggregate_group_by_time_test.flux",
																Source: "r._field == \"f\"",
																Start: ast.Position{
																	Column: 23,
																	Line:   329,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   329,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 23,
																		Line:   329,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   329,
																		},
																		File:   "aggregate_group_by_time_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 23,
																			Line:   329,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   329,
																		},
																		File:   "aggregate_group_by_time_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 25,
																			Line:   329,
																		},
																	},
																},
																Name: "_field",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   329,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "\"f\"",
																	Start: ast.Position{
																		Column: 35,
																		Line:   329,
																	},
																},
															},
															Value: "f",
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   329,
																},
																File:   "aggregate_group_by_time_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   329,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   329,
																	},
																	File:   "aggregate_group_by_time_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   329,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   329,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "filter(fn: (r) => r._field == \"f\")",
												Start: ast.Position{
													Column: 5,
													Line:   329,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   329,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 5,
														Line:   329,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   330,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])",
										Start: ast.Position{
											Column: 44,
											Line:   326,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   330,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "columns: [\"_measurement\", \"_field\"]",
												Start: ast.Position{
													Column: 11,
													Line:   330,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   330,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "columns: [\"_measurement\", \"_field\"]",
													Start: ast.Position{
														Column: 11,
														Line:   330,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   330,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 11,
															Line:   330,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   330,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "[\"_measurement\", \"_field\"]",
														Start: ast.Position{
															Column: 20,
															Line:   330,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   330,
															},
															File:   "aggregate_group_by_time_test.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 21,
																Line:   330,
															},
														},
													},
													Value: "_measurement",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   330,
															},
															File:   "aggregate_group_by_time_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 37,
																Line:   330,
															},
														},
													},
													Value: "_field",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   330,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "group(columns: [\"_measurement\", \"_field\"])",
											Start: ast.Position{
												Column: 5,
												Line:   330,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   330,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "group",
												Start: ast.Position{
													Column: 5,
													Line:   330,
												},
											},
										},
										Name: "group",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   331,
									},
									File:   "aggregate_group_by_time_test.flux",
									Source: "tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> aggregateWindow(every: 5h, fn: sum, timeSrc: \"_start\")",
									Start: ast.Position{
										Column: 44,
										Line:   326,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   331,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "every: 5h, fn: sum, timeSrc: \"_start\"",
											Start: ast.Position{
												Column: 21,
												Line:   331,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   331,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "every: 5h",
												Start: ast.Position{
													Column: 21,
													Line:   331,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   331,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "every",
													Start: ast.Position{
														Column: 21,
														Line:   331,
													},
												},
											},
											Name: "every",
										},
										Value: &ast.DurationLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   331,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "5h",
													Start: ast.Position{
														Column: 28,
														Line:   331,
													},
												},
											},
											Values: []ast.Duration{ast.Duration{
												Magnitude: int64(5),
												Unit:      "h",
											}},
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   331,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "fn: sum",
												Start: ast.Position{
													Column: 32,
													Line:   331,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   331,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 32,
														Line:   331,
													},
												},
											},
											Name: "fn",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   331,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "sum",
													Start: ast.Position{
														Column: 36,
														Line:   331,
													},
												},
											},
											Name: "sum",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   331,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "timeSrc: \"_start\"",
												Start: ast.Position{
													Column: 41,
													Line:   331,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   331,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "timeSrc",
													Start: ast.Position{
														Column: 41,
														Line:   331,
													},
												},
											},
											Name: "timeSrc",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   331,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 50,
														Line:   331,
													},
												},
											},
											Value: "_start",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   331,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "aggregateWindow(every: 5h, fn: sum, timeSrc: \"_start\")",
										Start: ast.Position{
											Column: 5,
											Line:   331,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   331,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "aggregateWindow",
											Start: ast.Position{
												Column: 5,
												Line:   331,
											},
										},
									},
									Name: "aggregateWindow",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   332,
								},
								File:   "aggregate_group_by_time_test.flux",
								Source: "tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> aggregateWindow(every: 5h, fn: sum, timeSrc: \"_start\")\n\t|> rename(columns: {_time: \"time\", _value: \"sum\"})",
								Start: ast.Position{
									Column: 44,
									Line:   326,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   332,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "columns: {_time: \"time\", _value: \"sum\"}",
										Start: ast.Position{
											Column: 12,
											Line:   332,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   332,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "columns: {_time: \"time\", _value: \"sum\"}",
											Start: ast.Position{
												Column: 12,
												Line:   332,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   332,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 12,
													Line:   332,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   332,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "{_time: \"time\", _value: \"sum\"}",
												Start: ast.Position{
													Column: 21,
													Line:   332,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   332,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "_time: \"time\"",
													Start: ast.Position{
														Column: 22,
														Line:   332,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   332,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "_time",
														Start: ast.Position{
															Column: 22,
															Line:   332,
														},
													},
												},
												Name: "_time",
											},
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   332,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "\"time\"",
														Start: ast.Position{
															Column: 29,
															Line:   332,
														},
													},
												},
												Value: "time",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   332,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "_value: \"sum\"",
													Start: ast.Position{
														Column: 37,
														Line:   332,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   332,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "_value",
														Start: ast.Position{
															Column: 37,
															Line:   332,
														},
													},
												},
												Name: "_value",
											},
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   332,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "\"sum\"",
														Start: ast.Position{
															Column: 45,
															Line:   332,
														},
													},
												},
												Value: "sum",
											},
										}},
										With: nil,
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   332,
									},
									File:   "aggregate_group_by_time_test.flux",
									Source: "rename(columns: {_time: \"time\", _value: \"sum\"})",
									Start: ast.Position{
										Column: 5,
										Line:   332,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   332,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "rename",
										Start: ast.Position{
											Column: 5,
											Line:   332,
										},
									},
								},
								Name: "rename",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   333,
							},
							File:   "aggregate_group_by_time_test.flux",
							Source: "tables\n\t|> range(start: 1970-01-01T00:00:00Z, stop: 1970-01-01T20:00:00.000000001Z)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> aggregateWindow(every: 5h, fn: sum, timeSrc: \"_start\")\n\t|> rename(columns: {_time: \"time\", _value: \"sum\"})\n\t|> drop(columns: [\"_field\", \"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 44,
								Line:   326,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   333,
									},
									File:   "aggregate_group_by_time_test.flux",
									Source: "columns: [\"_field\", \"_start\", \"_stop\"]",
									Start: ast.Position{
										Column: 10,
										Line:   333,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   333,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "columns: [\"_field\", \"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 10,
											Line:   333,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   333,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 10,
												Line:   333,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   333,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "[\"_field\", \"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 19,
												Line:   333,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   333,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "\"_field\"",
												Start: ast.Position{
													Column: 20,
													Line:   333,
												},
											},
										},
										Value: "_field",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   333,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "\"_start\"",
												Start: ast.Position{
													Column: 30,
													Line:   333,
												},
											},
										},
										Value: "_start",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   333,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "\"_stop\"",
												Start: ast.Position{
													Column: 40,
													Line:   333,
												},
											},
										},
										Value: "_stop",
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   333,
								},
								File:   "aggregate_group_by_time_test.flux",
								Source: "drop(columns: [\"_field\", \"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 5,
									Line:   333,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   333,
									},
									File:   "aggregate_group_by_time_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 5,
										Line:   333,
									},
								},
							},
							Name: "drop",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   326,
							},
							File:   "aggregate_group_by_time_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 30,
								Line:   326,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   326,
								},
								File:   "aggregate_group_by_time_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 30,
									Line:   326,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   326,
							},
							File:   "aggregate_group_by_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 37,
								Line:   326,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   339,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "_aggregate_group_by_time = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_group_by_time,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   335,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   335,
							},
							File:   "aggregate_group_by_time_test.flux",
							Source: "_aggregate_group_by_time",
							Start: ast.Position{
								Column: 6,
								Line:   335,
							},
						},
					},
					Name: "_aggregate_group_by_time",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   339,
							},
							File:   "aggregate_group_by_time_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_group_by_time,\n})",
							Start: ast.Position{
								Column: 33,
								Line:   335,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   339,
								},
								File:   "aggregate_group_by_time_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_group_by_time,\n})",
								Start: ast.Position{
									Column: 39,
									Line:   335,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   339,
									},
									File:   "aggregate_group_by_time_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_group_by_time,\n}",
									Start: ast.Position{
										Column: 40,
										Line:   335,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   336,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   336,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   336,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   336,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   336,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   336,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   336,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   336,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   336,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   336,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   336,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   336,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   336,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   336,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   336,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   336,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   336,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   336,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   336,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   336,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   337,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   337,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   337,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   337,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   337,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   337,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   337,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   337,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   337,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   337,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   337,
														},
														File:   "aggregate_group_by_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   337,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   337,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   337,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   337,
												},
												File:   "aggregate_group_by_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   337,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   337,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   337,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   337,
													},
													File:   "aggregate_group_by_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   337,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   338,
										},
										File:   "aggregate_group_by_time_test.flux",
										Source: "fn: t_aggregate_group_by_time",
										Start: ast.Position{
											Column: 2,
											Line:   338,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   338,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   338,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   338,
											},
											File:   "aggregate_group_by_time_test.flux",
											Source: "t_aggregate_group_by_time",
											Start: ast.Position{
												Column: 6,
												Line:   338,
											},
										},
									},
									Name: "t_aggregate_group_by_time",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   339,
					},
					File:   "aggregate_group_by_time_test.flux",
					Source: "test _aggregate_group_by_time = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_group_by_time,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   335,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_group_by_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "aggregate_group_by_time_test.flux",
					Source: "import \"internal/influxql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "\"internal/influxql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/influxql",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "aggregate_group_by_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_group_by_time_test.flux",
					Source: "package influxql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_group_by_time_test.flux",
						Source: "influxql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxql_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   705,
				},
				File:   "cumulative_sum_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,cumulative_sum\n,,0,1970-01-01T00:00:00Z,m,0,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,0.5502117115340306\n,,0,1970-01-01T02:00:00Z,m,0,1.4511048234394535\n,,0,1970-01-01T03:00:00Z,m,0,2.097255422004095\n,,0,1970-01-01T04:00:00Z,m,0,2.2312776833597288\n,,0,1970-01-01T05:00:00Z,m,0,2.536369972964114\n,,0,1970-01-01T06:00:00Z,m,0,2.704347873011682\n,,0,1970-01-01T07:00:00Z,m,0,3.3903379491205223\n,,0,1970-01-01T08:00:00Z,m,0,3.771675182555195\n,,0,1970-01-01T09:00:00Z,m,0,4.149073190575701\n,,0,1970-01-01T10:00:00Z,m,0,4.416094703170296\n,,0,1970-01-01T11:00:00Z,m,0,4.614667435527389\n,,0,1970-01-01T12:00:00Z,m,0,5.407308744598822\n,,0,1970-01-01T13:00:00Z,m,0,6.256152375910654\n,,0,1970-01-01T14:00:00Z,m,0,6.452181719489372\n,,0,1970-01-01T15:00:00Z,m,0,6.724229136279894\n,,0,1970-01-01T16:00:00Z,m,0,7.32873478622085\n,,0,1970-01-01T17:00:00Z,m,0,7.54381822102341\n,,0,1970-01-01T18:00:00Z,m,0,7.81507274632513\n,,0,1970-01-01T19:00:00Z,m,0,8.042354660643586\n,,0,1970-01-01T20:00:00Z,m,0,8.865602839374189\n,,0,1970-01-01T21:00:00Z,m,0,9.837808299980264\n,,0,1970-01-01T22:00:00Z,m,0,10.771102598282045\n,,0,1970-01-01T23:00:00Z,m,0,10.780807403324367\n,,0,1970-01-02T00:00:00Z,m,0,11.24228501844288\n,,0,1970-01-02T01:00:00Z,m,0,11.63957043278532\n,,0,1970-01-02T02:00:00Z,m,0,11.663728215225056\n,,0,1970-01-02T03:00:00Z,m,0,12.37116338553267\n,,0,1970-01-02T04:00:00Z,m,0,12.95315330292682\n,,0,1970-01-02T05:00:00Z,m,0,13.250643276008605\n,,0,1970-01-02T06:00:00Z,m,0,13.61713323302884\n,,0,1970-01-02T07:00:00Z,m,0,14.183795782969792\n,,0,1970-01-02T08:00:00Z,m,0,14.443061656005012\n,,0,1970-01-02T09:00:00Z,m,0,15.133782311016216\n,,0,1970-01-02T10:00:00Z,m,0,15.852262439418936\n,,0,1970-01-02T11:00:00Z,m,0,16.215366426371748\n,,0,1970-01-02T12:00:00Z,m,0,17.154192247212052\n,,0,1970-01-02T13:00:00Z,m,0,17.85765613186283\n,,0,1970-01-02T14:00:00Z,m,0,18.429146455044876\n,,0,1970-01-02T15:00:00Z,m,0,18.673636934858838\n,,0,1970-01-02T16:00:00Z,m,0,18.815287310517277\n,,0,1970-01-02T17:00:00Z,m,0,18.868798668978787\n,,0,1970-01-02T18:00:00Z,m,0,19.213876782314408\n,,0,1970-01-02T19:00:00Z,m,0,19.44641975713867\n,,0,1970-01-02T20:00:00Z,m,0,19.600588269864083\n,,0,1970-01-02T21:00:00Z,m,0,20.529299644386946\n,,0,1970-01-02T22:00:00Z,m,0,21.375740247028\n,,0,1970-01-02T23:00:00Z,m,0,22.15436396260722\n,,0,1970-01-03T00:00:00Z,m,0,22.87662698999149\n,,0,1970-01-03T01:00:00Z,m,0,23.446912641805948\n,,0,1970-01-03T02:00:00Z,m,0,23.89441470305999\n,,0,1970-01-03T03:00:00Z,m,0,24.089238835365222\n,,0,1970-01-03T04:00:00Z,m,0,24.234789841963533\n,,0,1970-01-03T05:00:00Z,m,0,24.60632118873131\n,,0,1970-01-03T06:00:00Z,m,0,24.76342243479113\n,,0,1970-01-03T07:00:00Z,m,0,24.81457610404482\n,,0,1970-01-03T08:00:00Z,m,0,25.310922839847866\n,,0,1970-01-03T09:00:00Z,m,0,25.4094277643875\n,,0,1970-01-03T10:00:00Z,m,0,25.48031305106398\n,,0,1970-01-03T11:00:00Z,m,0,26.433908936349063\n,,0,1970-01-03T12:00:00Z,m,0,27.38122126533224\n,,0,1970-01-03T13:00:00Z,m,0,28.013420365200933\n,,0,1970-01-03T14:00:00Z,m,0,28.544518926821898\n,,0,1970-01-03T15:00:00Z,m,0,28.684621289675437\n,,0,1970-01-03T16:00:00Z,m,0,29.19893242194478\n,,0,1970-01-03T17:00:00Z,m,0,29.340887923295092\n,,0,1970-01-03T18:00:00Z,m,0,29.375876094440358\n,,0,1970-01-03T19:00:00Z,m,0,29.840518430553495\n,,0,1970-01-03T20:00:00Z,m,0,30.568596016497587\n,,0,1970-01-03T21:00:00Z,m,0,31.52911834948428\n,,0,1970-01-03T22:00:00Z,m,0,32.158585496846946\n,,0,1970-01-03T23:00:00Z,m,0,32.25535036631466\n,,0,1970-01-04T00:00:00Z,m,0,32.740012856940254\n,,0,1970-01-04T01:00:00Z,m,0,33.64002801986436\n,,0,1970-01-04T02:00:00Z,m,0,34.45878007802953\n,,0,1970-01-04T03:00:00Z,m,0,35.09442804535487\n,,0,1970-01-04T04:00:00Z,m,0,36.01165730224184\n,,0,1970-01-04T05:00:00Z,m,0,36.270371438098586\n,,0,1970-01-04T06:00:00Z,m,0,37.20440163920558\n,,0,1970-01-04T07:00:00Z,m,0,37.83443179136016\n,,0,1970-01-04T08:00:00Z,m,0,38.82430138090735\n,,0,1970-01-04T09:00:00Z,m,0,39.48195466594223\n,,0,1970-01-04T10:00:00Z,m,0,39.591550040503265\n,,0,1970-01-04T11:00:00Z,m,0,39.79869720714972\n,,0,1970-01-04T12:00:00Z,m,0,40.292480397768976\n,,0,1970-01-04T13:00:00Z,m,0,40.616943419910065\n,,0,1970-01-04T14:00:00Z,m,0,40.75950545364327\n,,0,1970-01-04T15:00:00Z,m,0,41.13434317452579\n,,0,1970-01-04T16:00:00Z,m,0,42.072955536678165\n,,0,1970-01-04T17:00:00Z,m,0,42.367399466825574\n,,0,1970-01-04T18:00:00Z,m,0,43.17495875624241\n,,0,1970-01-04T19:00:00Z,m,0,43.98807709756972\n,,0,1970-01-04T20:00:00Z,m,0,44.59376461201288\n,,0,1970-01-04T21:00:00Z,m,0,45.14516673576493\n,,0,1970-01-04T22:00:00Z,m,0,45.43561849190662\n,,0,1970-01-04T23:00:00Z,m,0,46.212996697267116\n,,0,1970-01-05T00:00:00Z,m,0,46.35206998228008\n,,0,1970-01-05T01:00:00Z,m,0,46.72081810255463\n,,0,1970-01-05T02:00:00Z,m,0,47.57053144714934\n,,0,1970-01-05T03:00:00Z,m,0,47.85475961443108\n,,0,1970-01-05T04:00:00Z,m,0,48.43987830870233\n,,0,1970-01-05T05:00:00Z,m,0,48.71534776518658\n,,0,1970-01-05T06:00:00Z,m,0,48.75080316212925\n,,0,1970-01-05T07:00:00Z,m,0,49.16142405505885\n,,0,1970-01-05T08:00:00Z,m,0,49.52944981924283\n,,0,1970-01-05T09:00:00Z,m,0,50.2778976036069\n,,0,1970-01-05T10:00:00Z,m,0,50.49759214152938\n,,0,1970-01-05T11:00:00Z,m,0,51.23533310416766\n,,0,1970-01-05T12:00:00Z,m,0,51.66937398633295\n,,0,1970-01-05T13:00:00Z,m,0,51.71095183464651\n,,0,1970-01-05T14:00:00Z,m,0,52.611484281991075\n,,0,1970-01-05T15:00:00Z,m,0,53.23579053128648\n,,0,1970-01-05T16:00:00Z,m,0,53.64961800350353\n,,0,1970-01-05T17:00:00Z,m,0,54.305614135482955\n,,0,1970-01-05T18:00:00Z,m,0,54.40014143750177\n,,0,1970-01-05T19:00:00Z,m,0,54.75222019214466\n,,0,1970-01-05T20:00:00Z,m,0,55.22222309397733\n,,0,1970-01-05T21:00:00Z,m,0,55.35606317895453\n,,0,1970-01-05T22:00:00Z,m,0,55.61031270896288\n,,0,1970-01-05T23:00:00Z,m,0,55.65388682478966\n,,0,1970-01-06T00:00:00Z,m,0,55.92696390981365\n,,0,1970-01-06T01:00:00Z,m,0,56.00043110050868\n,,0,1970-01-06T02:00:00Z,m,0,56.193399801587056\n,,0,1970-01-06T03:00:00Z,m,0,57.04846996859816\n,,0,1970-01-06T04:00:00Z,m,0,57.949997967936085\n,,0,1970-01-06T05:00:00Z,m,0,58.71813092772145\n,,0,1970-01-06T06:00:00Z,m,0,58.85271675733672\n,,0,1970-01-06T07:00:00Z,m,0,59.35531316057092\n,,0,1970-01-06T08:00:00Z,m,0,60.321374275590806\n,,0,1970-01-06T09:00:00Z,m,0,61.062049910604024\n,,0,1970-01-06T10:00:00Z,m,0,61.54450314462472\n,,0,1970-01-06T11:00:00Z,m,0,62.08418981248373\n,,0,1970-01-06T12:00:00Z,m,0,62.324757684408326\n,,0,1970-01-06T13:00:00Z,m,0,62.87210727439746\n,,0,1970-01-06T14:00:00Z,m,0,63.86605602639549\n,,0,1970-01-06T15:00:00Z,m,0,64.63786467179935\n,,0,1970-01-06T16:00:00Z,m,0,65.01078785809091\n,,0,1970-01-06T17:00:00Z,m,0,65.98900448618066\n,,0,1970-01-06T18:00:00Z,m,0,66.29310950116337\n,,0,1970-01-06T19:00:00Z,m,0,66.65604475882448\n,,0,1970-01-06T20:00:00Z,m,0,67.11278369580661\n,,0,1970-01-06T21:00:00Z,m,0,67.54165839620606\n,,0,1970-01-06T22:00:00Z,m,0,67.96430284022401\n,,0,1970-01-06T23:00:00Z,m,0,68.27049376734182\n,,0,1970-01-07T00:00:00Z,m,0,68.93862288491061\n,,0,1970-01-07T01:00:00Z,m,0,69.48803372698875\n,,0,1970-01-07T02:00:00Z,m,0,69.80582967002523\n,,0,1970-01-07T03:00:00Z,m,0,70.03085670714789\n,,0,1970-01-07T04:00:00Z,m,0,70.06583817562658\n,,0,1970-01-07T05:00:00Z,m,0,70.22723213438681\n,,0,1970-01-07T06:00:00Z,m,0,70.86076402993893\n,,0,1970-01-07T07:00:00Z,m,0,71.44626077530116\n,,0,1970-01-07T08:00:00Z,m,0,71.87641891895679\n,,0,1970-01-07T09:00:00Z,m,0,71.94857374543777\n,,0,1970-01-07T10:00:00Z,m,0,72.0420578752723\n,,0,1970-01-07T11:00:00Z,m,0,72.94443722996388\n,,0,1970-01-07T12:00:00Z,m,0,73.84998235925006\n,,0,1970-01-07T13:00:00Z,m,0,74.17802777366649\n,,0,1970-01-07T14:00:00Z,m,0,74.23700246129805\n,,0,1970-01-07T15:00:00Z,m,0,74.60563636396598\n,,0,1970-01-07T16:00:00Z,m,0,75.36035376156504\n,,0,1970-01-07T17:00:00Z,m,0,75.81820128770799\n,,0,1970-01-07T18:00:00Z,m,0,76.3220332931636\n,,0,1970-01-07T19:00:00Z,m,0,76.79261474316948\n,,0,1970-01-07T20:00:00Z,m,0,77.32600507490261\n,,0,1970-01-07T21:00:00Z,m,0,77.48085593633222\n,,0,1970-01-07T22:00:00Z,m,0,78.16462404171915\n,,0,1970-01-07T23:00:00Z,m,0,79.07281937990595\n,,1,1970-01-01T00:00:00Z,m,1,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,0.3316845624286535\n,,1,1970-01-01T02:00:00Z,m,1,0.5636708618185042\n,,1,1970-01-01T03:00:00Z,m,1,1.0577484680529374\n,,1,1970-01-01T04:00:00Z,m,1,1.6231535071264602\n,,1,1970-01-01T05:00:00Z,m,1,2.0019826787206814\n,,1,1970-01-01T06:00:00Z,m,1,2.3937701181156563\n,,1,1970-01-01T07:00:00Z,m,1,2.967511115362197\n,,1,1970-01-01T08:00:00Z,m,1,3.584631623741339\n,,1,1970-01-01T09:00:00Z,m,1,3.8408328505068394\n,,1,1970-01-01T10:00:00Z,m,1,4.253846370327077\n,,1,1970-01-01T11:00:00Z,m,1,4.589655118024021\n,,1,1970-01-01T12:00:00Z,m,1,4.8399968375146925\n,,1,1970-01-01T13:00:00Z,m,1,5.826625823946474\n,,1,1970-01-01T14:00:00Z,m,1,6.256509819698633\n,,1,1970-01-01T15:00:00Z,m,1,6.282536067674507\n,,1,1970-01-01T16:00:00Z,m,1,7.275159293716898\n,,1,1970-01-01T17:00:00Z,m,1,8.252274598373521\n,,1,1970-01-01T18:00:00Z,m,1,8.82029425506925\n,,1,1970-01-01T19:00:00Z,m,1,8.83982071426132\n,,1,1970-01-01T20:00:00Z,m,1,9.183789963370288\n,,1,1970-01-01T21:00:00Z,m,1,9.339751393516302\n,,1,1970-01-01T22:00:00Z,m,1,10.138449714782139\n,,1,1970-01-01T23:00:00Z,m,1,10.451815366819142\n,,1,1970-01-02T00:00:00Z,m,1,11.091643505183871\n,,1,1970-01-02T01:00:00Z,m,1,11.231830238409824\n,,1,1970-01-02T02:00:00Z,m,1,11.516571217644247\n,,1,1970-01-02T03:00:00Z,m,1,11.94611730409226\n,,1,1970-01-02T04:00:00Z,m,1,12.913518929948845\n,,1,1970-01-02T05:00:00Z,m,1,13.022356792228974\n,,1,1970-01-02T06:00:00Z,m,1,13.493651401947544\n,,1,1970-01-02T07:00:00Z,m,1,14.411222288015821\n,,1,1970-01-02T08:00:00Z,m,1,14.749572744290527\n,,1,1970-01-02T09:00:00Z,m,1,15.467196528292016\n,,1,1970-01-02T10:00:00Z,m,1,15.923512520102825\n,,1,1970-01-02T11:00:00Z,m,1,16.505618077150444\n,,1,1970-01-02T12:00:00Z,m,1,16.953951538958858\n,,1,1970-01-02T13:00:00Z,m,1,17.80103420489034\n,,1,1970-01-02T14:00:00Z,m,1,17.90423928985627\n,,1,1970-01-02T15:00:00Z,m,1,18.53844317743996\n,,1,1970-01-02T16:00:00Z,m,1,19.010014561359963\n,,1,1970-01-02T17:00:00Z,m,1,19.60393414250918\n,,1,1970-01-02T18:00:00Z,m,1,19.994634536337163\n,,1,1970-01-02T19:00:00Z,m,1,20.36841264293761\n,,1,1970-01-02T20:00:00Z,m,1,20.97433062765647\n,,1,1970-01-02T21:00:00Z,m,1,21.34892193082414\n,,1,1970-01-02T22:00:00Z,m,1,21.877942725925923\n,,1,1970-01-02T23:00:00Z,m,1,22.457739251864655\n,,1,1970-01-03T00:00:00Z,m,1,22.87734528546483\n,,1,1970-01-03T01:00:00Z,m,1,23.31972790913099\n,,1,1970-01-03T02:00:00Z,m,1,24.075946433091257\n,,1,1970-01-03T03:00:00Z,m,1,24.372356439051785\n,,1,1970-01-03T04:00:00Z,m,1,24.923543040273568\n,,1,1970-01-03T05:00:00Z,m,1,25.400774209156125\n,,1,1970-01-03T06:00:00Z,m,1,25.979134656805332\n,,1,1970-01-03T07:00:00Z,m,1,26.587849382365725\n,,1,1970-01-03T08:00:00Z,m,1,27.56582224750691\n,,1,1970-01-03T09:00:00Z,m,1,28.42173464370378\n,,1,1970-01-03T10:00:00Z,m,1,28.461057447463755\n,,1,1970-01-03T11:00:00Z,m,1,28.971845243811185\n,,1,1970-01-03T12:00:00Z,m,1,29.3412425841778\n,,1,1970-01-03T13:00:00Z,m,1,29.581610927511306\n,,1,1970-01-03T14:00:00Z,m,1,30.48572495722582\n,,1,1970-01-03T15:00:00Z,m,1,30.794588363395526\n,,1,1970-01-03T16:00:00Z,m,1,31.133764085102047\n,,1,1970-01-03T17:00:00Z,m,1,31.704667286510116\n,,1,1970-01-03T18:00:00Z,m,1,31.728359620661404\n,,1,1970-01-03T19:00:00Z,m,1,32.65669934614199\n,,1,1970-01-03T20:00:00Z,m,1,33.44642944821644\n,,1,1970-01-03T21:00:00Z,m,1,33.99633621252024\n,,1,1970-01-03T22:00:00Z,m,1,34.19993432719558\n,,1,1970-01-03T23:00:00Z,m,1,34.3945598672661\n,,1,1970-01-04T00:00:00Z,m,1,34.84158943473498\n,,1,1970-01-04T01:00:00Z,m,1,35.287932864144494\n,,1,1970-01-04T02:00:00Z,m,1,35.73414936059147\n,,1,1970-01-04T03:00:00Z,m,1,36.25872336215064\n,,1,1970-01-04T04:00:00Z,m,1,36.551248914422544\n,,1,1970-01-04T05:00:00Z,m,1,37.06496587209677\n,,1,1970-01-04T06:00:00Z,m,1,37.22741323003485\n,,1,1970-01-04T07:00:00Z,m,1,37.52895020913166\n,,1,1970-01-04T08:00:00Z,m,1,37.76138291264318\n,,1,1970-01-04T09:00:00Z,m,1,37.79577611055943\n,,1,1970-01-04T10:00:00Z,m,1,38.22943911017099\n,,1,1970-01-04T11:00:00Z,m,1,39.10849648052425\n,,1,1970-01-04T12:00:00Z,m,1,40.0101788948332\n,,1,1970-01-04T13:00:00Z,m,1,40.350216274530645\n,,1,1970-01-04T14:00:00Z,m,1,40.73511156540662\n,,1,1970-01-04T15:00:00Z,m,1,41.730283425726824\n,,1,1970-01-04T16:00:00Z,m,1,42.5870284431861\n,,1,1970-01-04T17:00:00Z,m,1,42.71092052193442\n,,1,1970-01-04T18:00:00Z,m,1,43.38220709883908\n,,1,1970-01-04T19:00:00Z,m,1,43.8467507359473\n,,1,1970-01-04T20:00:00Z,m,1,44.8093452751721\n,,1,1970-01-04T21:00:00Z,m,1,45.562901155582296\n,,1,1970-01-04T22:00:00Z,m,1,46.30718281966764\n,,1,1970-01-04T23:00:00Z,m,1,46.98832010808668\n,,1,1970-01-05T00:00:00Z,m,1,47.45003155317226\n,,1,1970-01-05T01:00:00Z,m,1,48.22021761381953\n,,1,1970-01-05T02:00:00Z,m,1,48.4753912875235\n,,1,1970-01-05T03:00:00Z,m,1,49.031830785734755\n,,1,1970-01-05T04:00:00Z,m,1,49.21439117836617\n,,1,1970-01-05T05:00:00Z,m,1,49.2990416198911\n,,1,1970-01-05T06:00:00Z,m,1,49.3458703858585\n,,1,1970-01-05T07:00:00Z,m,1,49.85752395362514\n,,1,1970-01-05T08:00:00Z,m,1,50.12079908438952\n,,1,1970-01-05T09:00:00Z,m,1,50.97596284434446\n,,1,1970-01-05T10:00:00Z,m,1,51.02505054073349\n,,1,1970-01-05T11:00:00Z,m,1,51.699846007518765\n,,1,1970-01-05T12:00:00Z,m,1,52.369967089558216\n,,1,1970-01-05T13:00:00Z,m,1,53.039781758955385\n,,1,1970-01-05T14:00:00Z,m,1,53.369178885933955\n,,1,1970-01-05T15:00:00Z,m,1,54.157563597791366\n,,1,1970-01-05T16:00:00Z,m,1,55.101071462582034\n,,1,1970-01-05T17:00:00Z,m,1,55.15633906065944\n,,1,1970-01-05T18:00:00Z,m,1,55.46039669884767\n,,1,1970-01-05T19:00:00Z,m,1,55.590972431223\n,,1,1970-01-05T20:00:00Z,m,1,56.029802212666745\n,,1,1970-01-05T21:00:00Z,m,1,56.196196025653315\n,,1,1970-01-05T22:00:00Z,m,1,56.374374711218714\n,,1,1970-01-05T23:00:00Z,m,1,56.744444197538094\n,,1,1970-01-06T00:00:00Z,m,1,57.51558289287379\n,,1,1970-01-06T01:00:00Z,m,1,57.88922882906224\n,,1,1970-01-06T02:00:00Z,m,1,58.81782843555601\n,,1,1970-01-06T03:00:00Z,m,1,59.68642029694968\n,,1,1970-01-06T04:00:00Z,m,1,59.736178132130334\n,,1,1970-01-06T05:00:00Z,m,1,60.09238328887701\n,,1,1970-01-06T06:00:00Z,m,1,60.995276134547225\n,,1,1970-01-06T07:00:00Z,m,1,61.4494033247732\n,,1,1970-01-06T08:00:00Z,m,1,61.97050252064536\n,,1,1970-01-06T09:00:00Z,m,1,62.471874133240085\n,,1,1970-01-06T10:00:00Z,m,1,63.25176012670734\n,,1,1970-01-06T11:00:00Z,m,1,63.45953346972184\n,,1,1970-01-06T12:00:00Z,m,1,63.58933236052869\n,,1,1970-01-06T13:00:00Z,m,1,64.26064887885045\n,,1,1970-01-06T14:00:00Z,m,1,64.78741381742964\n,,1,1970-01-06T15:00:00Z,m,1,65.06411351444684\n,,1,1970-01-06T16:00:00Z,m,1,65.90167481804897\n,,1,1970-01-06T17:00:00Z,m,1,66.00859572832321\n,,1,1970-01-06T18:00:00Z,m,1,66.17020990732348\n,,1,1970-01-06T19:00:00Z,m,1,66.92987149306248\n,,1,1970-01-06T20:00:00Z,m,1,67.8332191249122\n,,1,1970-01-06T21:00:00Z,m,1,68.7613985802214\n,,1,1970-01-06T22:00:00Z,m,1,69.53058016479044\n,,1,1970-01-06T23:00:00Z,m,1,70.10197429323627\n,,1,1970-01-07T00:00:00Z,m,1,70.93387888405306\n,,1,1970-01-07T01:00:00Z,m,1,71.51779890552604\n,,1,1970-01-07T02:00:00Z,m,1,72.07758723295665\n,,1,1970-01-07T03:00:00Z,m,1,72.9223979527071\n,,1,1970-01-07T04:00:00Z,m,1,73.31381794401253\n,,1,1970-01-07T05:00:00Z,m,1,73.62892366518884\n,,1,1970-01-07T06:00:00Z,m,1,74.01017256881295\n,,1,1970-01-07T07:00:00Z,m,1,74.04910802166255\n,,1,1970-01-07T08:00:00Z,m,1,74.56304246007979\n,,1,1970-01-07T09:00:00Z,m,1,74.63691658778671\n,,1,1970-01-07T10:00:00Z,m,1,74.79823653630295\n,,1,1970-01-07T11:00:00Z,m,1,75.65072385887638\n,,1,1970-01-07T12:00:00Z,m,1,76.36154683945887\n,,1,1970-01-07T13:00:00Z,m,1,76.77028407259678\n,,1,1970-01-07T14:00:00Z,m,1,77.31113337869395\n,,1,1970-01-07T15:00:00Z,m,1,78.18634507210696\n,,1,1970-01-07T16:00:00Z,m,1,79.14326469694822\n,,1,1970-01-07T17:00:00Z,m,1,79.66393155651781\n,,1,1970-01-07T18:00:00Z,m,1,79.6767795090111\n,,1,1970-01-07T19:00:00Z,m,1,80.39234005999649\n,,1,1970-01-07T20:00:00Z,m,1,81.22166737490558\n,,1,1970-01-07T21:00:00Z,m,1,81.60872010394517\n,,1,1970-01-07T22:00:00Z,m,1,82.15471924481835\n,,1,1970-01-07T23:00:00Z,m,1,82.8614032926796\n\"\n\n// SELECT cumulative_sum(f) FROM m GROUP BY *\nt_cumulative_sum = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> cumulativeSum()\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\"])\n\t|> rename(columns: {_time: \"time\", _value: \"cumulative_sum\"})\n\ntest _cumulative_sum = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_cumulative_sum,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   347,
					},
					File:   "cumulative_sum_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "cumulative_sum_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   347,
						},
						File:   "cumulative_sum_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   690,
					},
					File:   "cumulative_sum_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,cumulative_sum\n,,0,1970-01-01T00:00:00Z,m,0,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,0.5502117115340306\n,,0,1970-01-01T02:00:00Z,m,0,1.4511048234394535\n,,0,1970-01-01T03:00:00Z,m,0,2.097255422004095\n,,0,1970-01-01T04:00:00Z,m,0,2.2312776833597288\n,,0,1970-01-01T05:00:00Z,m,0,2.536369972964114\n,,0,1970-01-01T06:00:00Z,m,0,2.704347873011682\n,,0,1970-01-01T07:00:00Z,m,0,3.3903379491205223\n,,0,1970-01-01T08:00:00Z,m,0,3.771675182555195\n,,0,1970-01-01T09:00:00Z,m,0,4.149073190575701\n,,0,1970-01-01T10:00:00Z,m,0,4.416094703170296\n,,0,1970-01-01T11:00:00Z,m,0,4.614667435527389\n,,0,1970-01-01T12:00:00Z,m,0,5.407308744598822\n,,0,1970-01-01T13:00:00Z,m,0,6.256152375910654\n,,0,1970-01-01T14:00:00Z,m,0,6.452181719489372\n,,0,1970-01-01T15:00:00Z,m,0,6.724229136279894\n,,0,1970-01-01T16:00:00Z,m,0,7.32873478622085\n,,0,1970-01-01T17:00:00Z,m,0,7.54381822102341\n,,0,1970-01-01T18:00:00Z,m,0,7.81507274632513\n,,0,1970-01-01T19:00:00Z,m,0,8.042354660643586\n,,0,1970-01-01T20:00:00Z,m,0,8.865602839374189\n,,0,1970-01-01T21:00:00Z,m,0,9.837808299980264\n,,0,1970-01-01T22:00:00Z,m,0,10.771102598282045\n,,0,1970-01-01T23:00:00Z,m,0,10.780807403324367\n,,0,1970-01-02T00:00:00Z,m,0,11.24228501844288\n,,0,1970-01-02T01:00:00Z,m,0,11.63957043278532\n,,0,1970-01-02T02:00:00Z,m,0,11.663728215225056\n,,0,1970-01-02T03:00:00Z,m,0,12.37116338553267\n,,0,1970-01-02T04:00:00Z,m,0,12.95315330292682\n,,0,1970-01-02T05:00:00Z,m,0,13.250643276008605\n,,0,1970-01-02T06:00:00Z,m,0,13.61713323302884\n,,0,1970-01-02T07:00:00Z,m,0,14.183795782969792\n,,0,1970-01-02T08:00:00Z,m,0,14.443061656005012\n,,0,1970-01-02T09:00:00Z,m,0,15.133782311016216\n,,0,1970-01-02T10:00:00Z,m,0,15.852262439418936\n,,0,1970-01-02T11:00:00Z,m,0,16.215366426371748\n,,0,1970-01-02T12:00:00Z,m,0,17.154192247212052\n,,0,1970-01-02T13:00:00Z,m,0,17.85765613186283\n,,0,1970-01-02T14:00:00Z,m,0,18.429146455044876\n,,0,1970-01-02T15:00:00Z,m,0,18.673636934858838\n,,0,1970-01-02T16:00:00Z,m,0,18.815287310517277\n,,0,1970-01-02T17:00:00Z,m,0,18.868798668978787\n,,0,1970-01-02T18:00:00Z,m,0,19.213876782314408\n,,0,1970-01-02T19:00:00Z,m,0,19.44641975713867\n,,0,1970-01-02T20:00:00Z,m,0,19.600588269864083\n,,0,1970-01-02T21:00:00Z,m,0,20.529299644386946\n,,0,1970-01-02T22:00:00Z,m,0,21.375740247028\n,,0,1970-01-02T23:00:00Z,m,0,22.15436396260722\n,,0,1970-01-03T00:00:00Z,m,0,22.87662698999149\n,,0,1970-01-03T01:00:00Z,m,0,23.446912641805948\n,,0,1970-01-03T02:00:00Z,m,0,23.89441470305999\n,,0,1970-01-03T03:00:00Z,m,0,24.089238835365222\n,,0,1970-01-03T04:00:00Z,m,0,24.234789841963533\n,,0,1970-01-03T05:00:00Z,m,0,24.60632118873131\n,,0,1970-01-03T06:00:00Z,m,0,24.76342243479113\n,,0,1970-01-03T07:00:00Z,m,0,24.81457610404482\n,,0,1970-01-03T08:00:00Z,m,0,25.310922839847866\n,,0,1970-01-03T09:00:00Z,m,0,25.4094277643875\n,,0,1970-01-03T10:00:00Z,m,0,25.48031305106398\n,,0,1970-01-03T11:00:00Z,m,0,26.433908936349063\n,,0,1970-01-03T12:00:00Z,m,0,27.38122126533224\n,,0,1970-01-03T13:00:00Z,m,0,28.013420365200933\n,,0,1970-01-03T14:00:00Z,m,0,28.544518926821898\n,,0,1970-01-03T15:00:00Z,m,0,28.684621289675437\n,,0,1970-01-03T16:00:00Z,m,0,29.19893242194478\n,,0,1970-01-03T17:00:00Z,m,0,29.340887923295092\n,,0,1970-01-03T18:00:00Z,m,0,29.375876094440358\n,,0,1970-01-03T19:00:00Z,m,0,29.840518430553495\n,,0,1970-01-03T20:00:00Z,m,0,30.568596016497587\n,,0,1970-01-03T21:00:00Z,m,0,31.52911834948428\n,,0,1970-01-03T22:00:00Z,m,0,32.158585496846946\n,,0,1970-01-03T23:00:00Z,m,0,32.25535036631466\n,,0,1970-01-04T00:00:00Z,m,0,32.740012856940254\n,,0,1970-01-04T01:00:00Z,m,0,33.64002801986436\n,,0,1970-01-04T02:00:00Z,m,0,34.45878007802953\n,,0,1970-01-04T03:00:00Z,m,0,35.09442804535487\n,,0,1970-01-04T04:00:00Z,m,0,36.01165730224184\n,,0,1970-01-04T05:00:00Z,m,0,36.270371438098586\n,,0,1970-01-04T06:00:00Z,m,0,37.20440163920558\n,,0,1970-01-04T07:00:00Z,m,0,37.83443179136016\n,,0,1970-01-04T08:00:00Z,m,0,38.82430138090735\n,,0,1970-01-04T09:00:00Z,m,0,39.48195466594223\n,,0,1970-01-04T10:00:00Z,m,0,39.591550040503265\n,,0,1970-01-04T11:00:00Z,m,0,39.79869720714972\n,,0,1970-01-04T12:00:00Z,m,0,40.292480397768976\n,,0,1970-01-04T13:00:00Z,m,0,40.616943419910065\n,,0,1970-01-04T14:00:00Z,m,0,40.75950545364327\n,,0,1970-01-04T15:00:00Z,m,0,41.13434317452579\n,,0,1970-01-04T16:00:00Z,m,0,42.072955536678165\n,,0,1970-01-04T17:00:00Z,m,0,42.367399466825574\n,,0,1970-01-04T18:00:00Z,m,0,43.17495875624241\n,,0,1970-01-04T19:00:00Z,m,0,43.98807709756972\n,,0,1970-01-04T20:00:00Z,m,0,44.59376461201288\n,,0,1970-01-04T21:00:00Z,m,0,45.14516673576493\n,,0,1970-01-04T22:00:00Z,m,0,45.43561849190662\n,,0,1970-01-04T23:00:00Z,m,0,46.212996697267116\n,,0,1970-01-05T00:00:00Z,m,0,46.35206998228008\n,,0,1970-01-05T01:00:00Z,m,0,46.72081810255463\n,,0,1970-01-05T02:00:00Z,m,0,47.57053144714934\n,,0,1970-01-05T03:00:00Z,m,0,47.85475961443108\n,,0,1970-01-05T04:00:00Z,m,0,48.43987830870233\n,,0,1970-01-05T05:00:00Z,m,0,48.71534776518658\n,,0,1970-01-05T06:00:00Z,m,0,48.75080316212925\n,,0,1970-01-05T07:00:00Z,m,0,49.16142405505885\n,,0,1970-01-05T08:00:00Z,m,0,49.52944981924283\n,,0,1970-01-05T09:00:00Z,m,0,50.2778976036069\n,,0,1970-01-05T10:00:00Z,m,0,50.49759214152938\n,,0,1970-01-05T11:00:00Z,m,0,51.23533310416766\n,,0,1970-01-05T12:00:00Z,m,0,51.66937398633295\n,,0,1970-01-05T13:00:00Z,m,0,51.71095183464651\n,,0,1970-01-05T14:00:00Z,m,0,52.611484281991075\n,,0,1970-01-05T15:00:00Z,m,0,53.23579053128648\n,,0,1970-01-05T16:00:00Z,m,0,53.64961800350353\n,,0,1970-01-05T17:00:00Z,m,0,54.305614135482955\n,,0,1970-01-05T18:00:00Z,m,0,54.40014143750177\n,,0,1970-01-05T19:00:00Z,m,0,54.75222019214466\n,,0,1970-01-05T20:00:00Z,m,0,55.22222309397733\n,,0,1970-01-05T21:00:00Z,m,0,55.35606317895453\n,,0,1970-01-05T22:00:00Z,m,0,55.61031270896288\n,,0,1970-01-05T23:00:00Z,m,0,55.65388682478966\n,,0,1970-01-06T00:00:00Z,m,0,55.92696390981365\n,,0,1970-01-06T01:00:00Z,m,0,56.00043110050868\n,,0,1970-01-06T02:00:00Z,m,0,56.193399801587056\n,,0,1970-01-06T03:00:00Z,m,0,57.04846996859816\n,,0,1970-01-06T04:00:00Z,m,0,57.949997967936085\n,,0,1970-01-06T05:00:00Z,m,0,58.71813092772145\n,,0,1970-01-06T06:00:00Z,m,0,58.85271675733672\n,,0,1970-01-06T07:00:00Z,m,0,59.35531316057092\n,,0,1970-01-06T08:00:00Z,m,0,60.321374275590806\n,,0,1970-01-06T09:00:00Z,m,0,61.062049910604024\n,,0,1970-01-06T10:00:00Z,m,0,61.54450314462472\n,,0,1970-01-06T11:00:00Z,m,0,62.08418981248373\n,,0,1970-01-06T12:00:00Z,m,0,62.324757684408326\n,,0,1970-01-06T13:00:00Z,m,0,62.87210727439746\n,,0,1970-01-06T14:00:00Z,m,0,63.86605602639549\n,,0,1970-01-06T15:00:00Z,m,0,64.63786467179935\n,,0,1970-01-06T16:00:00Z,m,0,65.01078785809091\n,,0,1970-01-06T17:00:00Z,m,0,65.98900448618066\n,,0,1970-01-06T18:00:00Z,m,0,66.29310950116337\n,,0,1970-01-06T19:00:00Z,m,0,66.65604475882448\n,,0,1970-01-06T20:00:00Z,m,0,67.11278369580661\n,,0,1970-01-06T21:00:00Z,m,0,67.54165839620606\n,,0,1970-01-06T22:00:00Z,m,0,67.96430284022401\n,,0,1970-01-06T23:00:00Z,m,0,68.27049376734182\n,,0,1970-01-07T00:00:00Z,m,0,68.93862288491061\n,,0,1970-01-07T01:00:00Z,m,0,69.48803372698875\n,,0,1970-01-07T02:00:00Z,m,0,69.80582967002523\n,,0,1970-01-07T03:00:00Z,m,0,70.03085670714789\n,,0,1970-01-07T04:00:00Z,m,0,70.06583817562658\n,,0,1970-01-07T05:00:00Z,m,0,70.22723213438681\n,,0,1970-01-07T06:00:00Z,m,0,70.86076402993893\n,,0,1970-01-07T07:00:00Z,m,0,71.44626077530116\n,,0,1970-01-07T08:00:00Z,m,0,71.87641891895679\n,,0,1970-01-07T09:00:00Z,m,0,71.94857374543777\n,,0,1970-01-07T10:00:00Z,m,0,72.0420578752723\n,,0,1970-01-07T11:00:00Z,m,0,72.94443722996388\n,,0,1970-01-07T12:00:00Z,m,0,73.84998235925006\n,,0,1970-01-07T13:00:00Z,m,0,74.17802777366649\n,,0,1970-01-07T14:00:00Z,m,0,74.23700246129805\n,,0,1970-01-07T15:00:00Z,m,0,74.60563636396598\n,,0,1970-01-07T16:00:00Z,m,0,75.36035376156504\n,,0,1970-01-07T17:00:00Z,m,0,75.81820128770799\n,,0,1970-01-07T18:00:00Z,m,0,76.3220332931636\n,,0,1970-01-07T19:00:00Z,m,0,76.79261474316948\n,,0,1970-01-07T20:00:00Z,m,0,77.32600507490261\n,,0,1970-01-07T21:00:00Z,m,0,77.48085593633222\n,,0,1970-01-07T22:00:00Z,m,0,78.16462404171915\n,,0,1970-01-07T23:00:00Z,m,0,79.07281937990595\n,,1,1970-01-01T00:00:00Z,m,1,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,0.3316845624286535\n,,1,1970-01-01T02:00:00Z,m,1,0.5636708618185042\n,,1,1970-01-01T03:00:00Z,m,1,1.0577484680529374\n,,1,1970-01-01T04:00:00Z,m,1,1.6231535071264602\n,,1,1970-01-01T05:00:00Z,m,1,2.0019826787206814\n,,1,1970-01-01T06:00:00Z,m,1,2.3937701181156563\n,,1,1970-01-01T07:00:00Z,m,1,2.967511115362197\n,,1,1970-01-01T08:00:00Z,m,1,3.584631623741339\n,,1,1970-01-01T09:00:00Z,m,1,3.8408328505068394\n,,1,1970-01-01T10:00:00Z,m,1,4.253846370327077\n,,1,1970-01-01T11:00:00Z,m,1,4.589655118024021\n,,1,1970-01-01T12:00:00Z,m,1,4.8399968375146925\n,,1,1970-01-01T13:00:00Z,m,1,5.826625823946474\n,,1,1970-01-01T14:00:00Z,m,1,6.256509819698633\n,,1,1970-01-01T15:00:00Z,m,1,6.282536067674507\n,,1,1970-01-01T16:00:00Z,m,1,7.275159293716898\n,,1,1970-01-01T17:00:00Z,m,1,8.252274598373521\n,,1,1970-01-01T18:00:00Z,m,1,8.82029425506925\n,,1,1970-01-01T19:00:00Z,m,1,8.83982071426132\n,,1,1970-01-01T20:00:00Z,m,1,9.183789963370288\n,,1,1970-01-01T21:00:00Z,m,1,9.339751393516302\n,,1,1970-01-01T22:00:00Z,m,1,10.138449714782139\n,,1,1970-01-01T23:00:00Z,m,1,10.451815366819142\n,,1,1970-01-02T00:00:00Z,m,1,11.091643505183871\n,,1,1970-01-02T01:00:00Z,m,1,11.231830238409824\n,,1,1970-01-02T02:00:00Z,m,1,11.516571217644247\n,,1,1970-01-02T03:00:00Z,m,1,11.94611730409226\n,,1,1970-01-02T04:00:00Z,m,1,12.913518929948845\n,,1,1970-01-02T05:00:00Z,m,1,13.022356792228974\n,,1,1970-01-02T06:00:00Z,m,1,13.493651401947544\n,,1,1970-01-02T07:00:00Z,m,1,14.411222288015821\n,,1,1970-01-02T08:00:00Z,m,1,14.749572744290527\n,,1,1970-01-02T09:00:00Z,m,1,15.467196528292016\n,,1,1970-01-02T10:00:00Z,m,1,15.923512520102825\n,,1,1970-01-02T11:00:00Z,m,1,16.505618077150444\n,,1,1970-01-02T12:00:00Z,m,1,16.953951538958858\n,,1,1970-01-02T13:00:00Z,m,1,17.80103420489034\n,,1,1970-01-02T14:00:00Z,m,1,17.90423928985627\n,,1,1970-01-02T15:00:00Z,m,1,18.53844317743996\n,,1,1970-01-02T16:00:00Z,m,1,19.010014561359963\n,,1,1970-01-02T17:00:00Z,m,1,19.60393414250918\n,,1,1970-01-02T18:00:00Z,m,1,19.994634536337163\n,,1,1970-01-02T19:00:00Z,m,1,20.36841264293761\n,,1,1970-01-02T20:00:00Z,m,1,20.97433062765647\n,,1,1970-01-02T21:00:00Z,m,1,21.34892193082414\n,,1,1970-01-02T22:00:00Z,m,1,21.877942725925923\n,,1,1970-01-02T23:00:00Z,m,1,22.457739251864655\n,,1,1970-01-03T00:00:00Z,m,1,22.87734528546483\n,,1,1970-01-03T01:00:00Z,m,1,23.31972790913099\n,,1,1970-01-03T02:00:00Z,m,1,24.075946433091257\n,,1,1970-01-03T03:00:00Z,m,1,24.372356439051785\n,,1,1970-01-03T04:00:00Z,m,1,24.923543040273568\n,,1,1970-01-03T05:00:00Z,m,1,25.400774209156125\n,,1,1970-01-03T06:00:00Z,m,1,25.979134656805332\n,,1,1970-01-03T07:00:00Z,m,1,26.587849382365725\n,,1,1970-01-03T08:00:00Z,m,1,27.56582224750691\n,,1,1970-01-03T09:00:00Z,m,1,28.42173464370378\n,,1,1970-01-03T10:00:00Z,m,1,28.461057447463755\n,,1,1970-01-03T11:00:00Z,m,1,28.971845243811185\n,,1,1970-01-03T12:00:00Z,m,1,29.3412425841778\n,,1,1970-01-03T13:00:00Z,m,1,29.581610927511306\n,,1,1970-01-03T14:00:00Z,m,1,30.48572495722582\n,,1,1970-01-03T15:00:00Z,m,1,30.794588363395526\n,,1,1970-01-03T16:00:00Z,m,1,31.133764085102047\n,,1,1970-01-03T17:00:00Z,m,1,31.704667286510116\n,,1,1970-01-03T18:00:00Z,m,1,31.728359620661404\n,,1,1970-01-03T19:00:00Z,m,1,32.65669934614199\n,,1,1970-01-03T20:00:00Z,m,1,33.44642944821644\n,,1,1970-01-03T21:00:00Z,m,1,33.99633621252024\n,,1,1970-01-03T22:00:00Z,m,1,34.19993432719558\n,,1,1970-01-03T23:00:00Z,m,1,34.3945598672661\n,,1,1970-01-04T00:00:00Z,m,1,34.84158943473498\n,,1,1970-01-04T01:00:00Z,m,1,35.287932864144494\n,,1,1970-01-04T02:00:00Z,m,1,35.73414936059147\n,,1,1970-01-04T03:00:00Z,m,1,36.25872336215064\n,,1,1970-01-04T04:00:00Z,m,1,36.551248914422544\n,,1,1970-01-04T05:00:00Z,m,1,37.06496587209677\n,,1,1970-01-04T06:00:00Z,m,1,37.22741323003485\n,,1,1970-01-04T07:00:00Z,m,1,37.52895020913166\n,,1,1970-01-04T08:00:00Z,m,1,37.76138291264318\n,,1,1970-01-04T09:00:00Z,m,1,37.79577611055943\n,,1,1970-01-04T10:00:00Z,m,1,38.22943911017099\n,,1,1970-01-04T11:00:00Z,m,1,39.10849648052425\n,,1,1970-01-04T12:00:00Z,m,1,40.0101788948332\n,,1,1970-01-04T13:00:00Z,m,1,40.350216274530645\n,,1,1970-01-04T14:00:00Z,m,1,40.73511156540662\n,,1,1970-01-04T15:00:00Z,m,1,41.730283425726824\n,,1,1970-01-04T16:00:00Z,m,1,42.5870284431861\n,,1,1970-01-04T17:00:00Z,m,1,42.71092052193442\n,,1,1970-01-04T18:00:00Z,m,1,43.38220709883908\n,,1,1970-01-04T19:00:00Z,m,1,43.8467507359473\n,,1,1970-01-04T20:00:00Z,m,1,44.8093452751721\n,,1,1970-01-04T21:00:00Z,m,1,45.562901155582296\n,,1,1970-01-04T22:00:00Z,m,1,46.30718281966764\n,,1,1970-01-04T23:00:00Z,m,1,46.98832010808668\n,,1,1970-01-05T00:00:00Z,m,1,47.45003155317226\n,,1,1970-01-05T01:00:00Z,m,1,48.22021761381953\n,,1,1970-01-05T02:00:00Z,m,1,48.4753912875235\n,,1,1970-01-05T03:00:00Z,m,1,49.031830785734755\n,,1,1970-01-05T04:00:00Z,m,1,49.21439117836617\n,,1,1970-01-05T05:00:00Z,m,1,49.2990416198911\n,,1,1970-01-05T06:00:00Z,m,1,49.3458703858585\n,,1,1970-01-05T07:00:00Z,m,1,49.85752395362514\n,,1,1970-01-05T08:00:00Z,m,1,50.12079908438952\n,,1,1970-01-05T09:00:00Z,m,1,50.97596284434446\n,,1,1970-01-05T10:00:00Z,m,1,51.02505054073349\n,,1,1970-01-05T11:00:00Z,m,1,51.699846007518765\n,,1,1970-01-05T12:00:00Z,m,1,52.369967089558216\n,,1,1970-01-05T13:00:00Z,m,1,53.039781758955385\n,,1,1970-01-05T14:00:00Z,m,1,53.369178885933955\n,,1,1970-01-05T15:00:00Z,m,1,54.157563597791366\n,,1,1970-01-05T16:00:00Z,m,1,55.101071462582034\n,,1,1970-01-05T17:00:00Z,m,1,55.15633906065944\n,,1,1970-01-05T18:00:00Z,m,1,55.46039669884767\n,,1,1970-01-05T19:00:00Z,m,1,55.590972431223\n,,1,1970-01-05T20:00:00Z,m,1,56.029802212666745\n,,1,1970-01-05T21:00:00Z,m,1,56.196196025653315\n,,1,1970-01-05T22:00:00Z,m,1,56.374374711218714\n,,1,1970-01-05T23:00:00Z,m,1,56.744444197538094\n,,1,1970-01-06T00:00:00Z,m,1,57.51558289287379\n,,1,1970-01-06T01:00:00Z,m,1,57.88922882906224\n,,1,1970-01-06T02:00:00Z,m,1,58.81782843555601\n,,1,1970-01-06T03:00:00Z,m,1,59.68642029694968\n,,1,1970-01-06T04:00:00Z,m,1,59.736178132130334\n,,1,1970-01-06T05:00:00Z,m,1,60.09238328887701\n,,1,1970-01-06T06:00:00Z,m,1,60.995276134547225\n,,1,1970-01-06T07:00:00Z,m,1,61.4494033247732\n,,1,1970-01-06T08:00:00Z,m,1,61.97050252064536\n,,1,1970-01-06T09:00:00Z,m,1,62.471874133240085\n,,1,1970-01-06T10:00:00Z,m,1,63.25176012670734\n,,1,1970-01-06T11:00:00Z,m,1,63.45953346972184\n,,1,1970-01-06T12:00:00Z,m,1,63.58933236052869\n,,1,1970-01-06T13:00:00Z,m,1,64.26064887885045\n,,1,1970-01-06T14:00:00Z,m,1,64.78741381742964\n,,1,1970-01-06T15:00:00Z,m,1,65.06411351444684\n,,1,1970-01-06T16:00:00Z,m,1,65.90167481804897\n,,1,1970-01-06T17:00:00Z,m,1,66.00859572832321\n,,1,1970-01-06T18:00:00Z,m,1,66.17020990732348\n,,1,1970-01-06T19:00:00Z,m,1,66.92987149306248\n,,1,1970-01-06T20:00:00Z,m,1,67.8332191249122\n,,1,1970-01-06T21:00:00Z,m,1,68.7613985802214\n,,1,1970-01-06T22:00:00Z,m,1,69.53058016479044\n,,1,1970-01-06T23:00:00Z,m,1,70.10197429323627\n,,1,1970-01-07T00:00:00Z,m,1,70.93387888405306\n,,1,1970-01-07T01:00:00Z,m,1,71.51779890552604\n,,1,1970-01-07T02:00:00Z,m,1,72.07758723295665\n,,1,1970-01-07T03:00:00Z,m,1,72.9223979527071\n,,1,1970-01-07T04:00:00Z,m,1,73.31381794401253\n,,1,1970-01-07T05:00:00Z,m,1,73.62892366518884\n,,1,1970-01-07T06:00:00Z,m,1,74.01017256881295\n,,1,1970-01-07T07:00:00Z,m,1,74.04910802166255\n,,1,1970-01-07T08:00:00Z,m,1,74.56304246007979\n,,1,1970-01-07T09:00:00Z,m,1,74.63691658778671\n,,1,1970-01-07T10:00:00Z,m,1,74.79823653630295\n,,1,1970-01-07T11:00:00Z,m,1,75.65072385887638\n,,1,1970-01-07T12:00:00Z,m,1,76.36154683945887\n,,1,1970-01-07T13:00:00Z,m,1,76.77028407259678\n,,1,1970-01-07T14:00:00Z,m,1,77.31113337869395\n,,1,1970-01-07T15:00:00Z,m,1,78.18634507210696\n,,1,1970-01-07T16:00:00Z,m,1,79.14326469694822\n,,1,1970-01-07T17:00:00Z,m,1,79.66393155651781\n,,1,1970-01-07T18:00:00Z,m,1,79.6767795090111\n,,1,1970-01-07T19:00:00Z,m,1,80.39234005999649\n,,1,1970-01-07T20:00:00Z,m,1,81.22166737490558\n,,1,1970-01-07T21:00:00Z,m,1,81.60872010394517\n,,1,1970-01-07T22:00:00Z,m,1,82.15471924481835\n,,1,1970-01-07T23:00:00Z,m,1,82.8614032926796\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   349,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   349,
						},
						File:   "cumulative_sum_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   349,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   690,
						},
						File:   "cumulative_sum_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,cumulative_sum\n,,0,1970-01-01T00:00:00Z,m,0,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,0.5502117115340306\n,,0,1970-01-01T02:00:00Z,m,0,1.4511048234394535\n,,0,1970-01-01T03:00:00Z,m,0,2.097255422004095\n,,0,1970-01-01T04:00:00Z,m,0,2.2312776833597288\n,,0,1970-01-01T05:00:00Z,m,0,2.536369972964114\n,,0,1970-01-01T06:00:00Z,m,0,2.704347873011682\n,,0,1970-01-01T07:00:00Z,m,0,3.3903379491205223\n,,0,1970-01-01T08:00:00Z,m,0,3.771675182555195\n,,0,1970-01-01T09:00:00Z,m,0,4.149073190575701\n,,0,1970-01-01T10:00:00Z,m,0,4.416094703170296\n,,0,1970-01-01T11:00:00Z,m,0,4.614667435527389\n,,0,1970-01-01T12:00:00Z,m,0,5.407308744598822\n,,0,1970-01-01T13:00:00Z,m,0,6.256152375910654\n,,0,1970-01-01T14:00:00Z,m,0,6.452181719489372\n,,0,1970-01-01T15:00:00Z,m,0,6.724229136279894\n,,0,1970-01-01T16:00:00Z,m,0,7.32873478622085\n,,0,1970-01-01T17:00:00Z,m,0,7.54381822102341\n,,0,1970-01-01T18:00:00Z,m,0,7.81507274632513\n,,0,1970-01-01T19:00:00Z,m,0,8.042354660643586\n,,0,1970-01-01T20:00:00Z,m,0,8.865602839374189\n,,0,1970-01-01T21:00:00Z,m,0,9.837808299980264\n,,0,1970-01-01T22:00:00Z,m,0,10.771102598282045\n,,0,1970-01-01T23:00:00Z,m,0,10.780807403324367\n,,0,1970-01-02T00:00:00Z,m,0,11.24228501844288\n,,0,1970-01-02T01:00:00Z,m,0,11.63957043278532\n,,0,1970-01-02T02:00:00Z,m,0,11.663728215225056\n,,0,1970-01-02T03:00:00Z,m,0,12.37116338553267\n,,0,1970-01-02T04:00:00Z,m,0,12.95315330292682\n,,0,1970-01-02T05:00:00Z,m,0,13.250643276008605\n,,0,1970-01-02T06:00:00Z,m,0,13.61713323302884\n,,0,1970-01-02T07:00:00Z,m,0,14.183795782969792\n,,0,1970-01-02T08:00:00Z,m,0,14.443061656005012\n,,0,1970-01-02T09:00:00Z,m,0,15.133782311016216\n,,0,1970-01-02T10:00:00Z,m,0,15.852262439418936\n,,0,1970-01-02T11:00:00Z,m,0,16.215366426371748\n,,0,1970-01-02T12:00:00Z,m,0,17.154192247212052\n,,0,1970-01-02T13:00:00Z,m,0,17.85765613186283\n,,0,1970-01-02T14:00:00Z,m,0,18.429146455044876\n,,0,1970-01-02T15:00:00Z,m,0,18.673636934858838\n,,0,1970-01-02T16:00:00Z,m,0,18.815287310517277\n,,0,1970-01-02T17:00:00Z,m,0,18.868798668978787\n,,0,1970-01-02T18:00:00Z,m,0,19.213876782314408\n,,0,1970-01-02T19:00:00Z,m,0,19.44641975713867\n,,0,1970-01-02T20:00:00Z,m,0,19.600588269864083\n,,0,1970-01-02T21:00:00Z,m,0,20.529299644386946\n,,0,1970-01-02T22:00:00Z,m,0,21.375740247028\n,,0,1970-01-02T23:00:00Z,m,0,22.15436396260722\n,,0,1970-01-03T00:00:00Z,m,0,22.87662698999149\n,,0,1970-01-03T01:00:00Z,m,0,23.446912641805948\n,,0,1970-01-03T02:00:00Z,m,0,23.89441470305999\n,,0,1970-01-03T03:00:00Z,m,0,24.089238835365222\n,,0,1970-01-03T04:00:00Z,m,0,24.234789841963533\n,,0,1970-01-03T05:00:00Z,m,0,24.60632118873131\n,,0,1970-01-03T06:00:00Z,m,0,24.76342243479113\n,,0,1970-01-03T07:00:00Z,m,0,24.81457610404482\n,,0,1970-01-03T08:00:00Z,m,0,25.310922839847866\n,,0,1970-01-03T09:00:00Z,m,0,25.4094277643875\n,,0,1970-01-03T10:00:00Z,m,0,25.48031305106398\n,,0,1970-01-03T11:00:00Z,m,0,26.433908936349063\n,,0,1970-01-03T12:00:00Z,m,0,27.38122126533224\n,,0,1970-01-03T13:00:00Z,m,0,28.013420365200933\n,,0,1970-01-03T14:00:00Z,m,0,28.544518926821898\n,,0,1970-01-03T15:00:00Z,m,0,28.684621289675437\n,,0,1970-01-03T16:00:00Z,m,0,29.19893242194478\n,,0,1970-01-03T17:00:00Z,m,0,29.340887923295092\n,,0,1970-01-03T18:00:00Z,m,0,29.375876094440358\n,,0,1970-01-03T19:00:00Z,m,0,29.840518430553495\n,,0,1970-01-03T20:00:00Z,m,0,30.568596016497587\n,,0,1970-01-03T21:00:00Z,m,0,31.52911834948428\n,,0,1970-01-03T22:00:00Z,m,0,32.158585496846946\n,,0,1970-01-03T23:00:00Z,m,0,32.25535036631466\n,,0,1970-01-04T00:00:00Z,m,0,32.740012856940254\n,,0,1970-01-04T01:00:00Z,m,0,33.64002801986436\n,,0,1970-01-04T02:00:00Z,m,0,34.45878007802953\n,,0,1970-01-04T03:00:00Z,m,0,35.09442804535487\n,,0,1970-01-04T04:00:00Z,m,0,36.01165730224184\n,,0,1970-01-04T05:00:00Z,m,0,36.270371438098586\n,,0,1970-01-04T06:00:00Z,m,0,37.20440163920558\n,,0,1970-01-04T07:00:00Z,m,0,37.83443179136016\n,,0,1970-01-04T08:00:00Z,m,0,38.82430138090735\n,,0,1970-01-04T09:00:00Z,m,0,39.48195466594223\n,,0,1970-01-04T10:00:00Z,m,0,39.591550040503265\n,,0,1970-01-04T11:00:00Z,m,0,39.79869720714972\n,,0,1970-01-04T12:00:00Z,m,0,40.292480397768976\n,,0,1970-01-04T13:00:00Z,m,0,40.616943419910065\n,,0,1970-01-04T14:00:00Z,m,0,40.75950545364327\n,,0,1970-01-04T15:00:00Z,m,0,41.13434317452579\n,,0,1970-01-04T16:00:00Z,m,0,42.072955536678165\n,,0,1970-01-04T17:00:00Z,m,0,42.367399466825574\n,,0,1970-01-04T18:00:00Z,m,0,43.17495875624241\n,,0,1970-01-04T19:00:00Z,m,0,43.98807709756972\n,,0,1970-01-04T20:00:00Z,m,0,44.59376461201288\n,,0,1970-01-04T21:00:00Z,m,0,45.14516673576493\n,,0,1970-01-04T22:00:00Z,m,0,45.43561849190662\n,,0,1970-01-04T23:00:00Z,m,0,46.212996697267116\n,,0,1970-01-05T00:00:00Z,m,0,46.35206998228008\n,,0,1970-01-05T01:00:00Z,m,0,46.72081810255463\n,,0,1970-01-05T02:00:00Z,m,0,47.57053144714934\n,,0,1970-01-05T03:00:00Z,m,0,47.85475961443108\n,,0,1970-01-05T04:00:00Z,m,0,48.43987830870233\n,,0,1970-01-05T05:00:00Z,m,0,48.71534776518658\n,,0,1970-01-05T06:00:00Z,m,0,48.75080316212925\n,,0,1970-01-05T07:00:00Z,m,0,49.16142405505885\n,,0,1970-01-05T08:00:00Z,m,0,49.52944981924283\n,,0,1970-01-05T09:00:00Z,m,0,50.2778976036069\n,,0,1970-01-05T10:00:00Z,m,0,50.49759214152938\n,,0,1970-01-05T11:00:00Z,m,0,51.23533310416766\n,,0,1970-01-05T12:00:00Z,m,0,51.66937398633295\n,,0,1970-01-05T13:00:00Z,m,0,51.71095183464651\n,,0,1970-01-05T14:00:00Z,m,0,52.611484281991075\n,,0,1970-01-05T15:00:00Z,m,0,53.23579053128648\n,,0,1970-01-05T16:00:00Z,m,0,53.64961800350353\n,,0,1970-01-05T17:00:00Z,m,0,54.305614135482955\n,,0,1970-01-05T18:00:00Z,m,0,54.40014143750177\n,,0,1970-01-05T19:00:00Z,m,0,54.75222019214466\n,,0,1970-01-05T20:00:00Z,m,0,55.22222309397733\n,,0,1970-01-05T21:00:00Z,m,0,55.35606317895453\n,,0,1970-01-05T22:00:00Z,m,0,55.61031270896288\n,,0,1970-01-05T23:00:00Z,m,0,55.65388682478966\n,,0,1970-01-06T00:00:00Z,m,0,55.92696390981365\n,,0,1970-01-06T01:00:00Z,m,0,56.00043110050868\n,,0,1970-01-06T02:00:00Z,m,0,56.193399801587056\n,,0,1970-01-06T03:00:00Z,m,0,57.04846996859816\n,,0,1970-01-06T04:00:00Z,m,0,57.949997967936085\n,,0,1970-01-06T05:00:00Z,m,0,58.71813092772145\n,,0,1970-01-06T06:00:00Z,m,0,58.85271675733672\n,,0,1970-01-06T07:00:00Z,m,0,59.35531316057092\n,,0,1970-01-06T08:00:00Z,m,0,60.321374275590806\n,,0,1970-01-06T09:00:00Z,m,0,61.062049910604024\n,,0,1970-01-06T10:00:00Z,m,0,61.54450314462472\n,,0,1970-01-06T11:00:00Z,m,0,62.08418981248373\n,,0,1970-01-06T12:00:00Z,m,0,62.324757684408326\n,,0,1970-01-06T13:00:00Z,m,0,62.87210727439746\n,,0,1970-01-06T14:00:00Z,m,0,63.86605602639549\n,,0,1970-01-06T15:00:00Z,m,0,64.63786467179935\n,,0,1970-01-06T16:00:00Z,m,0,65.01078785809091\n,,0,1970-01-06T17:00:00Z,m,0,65.98900448618066\n,,0,1970-01-06T18:00:00Z,m,0,66.29310950116337\n,,0,1970-01-06T19:00:00Z,m,0,66.65604475882448\n,,0,1970-01-06T20:00:00Z,m,0,67.11278369580661\n,,0,1970-01-06T21:00:00Z,m,0,67.54165839620606\n,,0,1970-01-06T22:00:00Z,m,0,67.96430284022401\n,,0,1970-01-06T23:00:00Z,m,0,68.27049376734182\n,,0,1970-01-07T00:00:00Z,m,0,68.93862288491061\n,,0,1970-01-07T01:00:00Z,m,0,69.48803372698875\n,,0,1970-01-07T02:00:00Z,m,0,69.80582967002523\n,,0,1970-01-07T03:00:00Z,m,0,70.03085670714789\n,,0,1970-01-07T04:00:00Z,m,0,70.06583817562658\n,,0,1970-01-07T05:00:00Z,m,0,70.22723213438681\n,,0,1970-01-07T06:00:00Z,m,0,70.86076402993893\n,,0,1970-01-07T07:00:00Z,m,0,71.44626077530116\n,,0,1970-01-07T08:00:00Z,m,0,71.87641891895679\n,,0,1970-01-07T09:00:00Z,m,0,71.94857374543777\n,,0,1970-01-07T10:00:00Z,m,0,72.0420578752723\n,,0,1970-01-07T11:00:00Z,m,0,72.94443722996388\n,,0,1970-01-07T12:00:00Z,m,0,73.84998235925006\n,,0,1970-01-07T13:00:00Z,m,0,74.17802777366649\n,,0,1970-01-07T14:00:00Z,m,0,74.23700246129805\n,,0,1970-01-07T15:00:00Z,m,0,74.60563636396598\n,,0,1970-01-07T16:00:00Z,m,0,75.36035376156504\n,,0,1970-01-07T17:00:00Z,m,0,75.81820128770799\n,,0,1970-01-07T18:00:00Z,m,0,76.3220332931636\n,,0,1970-01-07T19:00:00Z,m,0,76.79261474316948\n,,0,1970-01-07T20:00:00Z,m,0,77.32600507490261\n,,0,1970-01-07T21:00:00Z,m,0,77.48085593633222\n,,0,1970-01-07T22:00:00Z,m,0,78.16462404171915\n,,0,1970-01-07T23:00:00Z,m,0,79.07281937990595\n,,1,1970-01-01T00:00:00Z,m,1,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,0.3316845624286535\n,,1,1970-01-01T02:00:00Z,m,1,0.5636708618185042\n,,1,1970-01-01T03:00:00Z,m,1,1.0577484680529374\n,,1,1970-01-01T04:00:00Z,m,1,1.6231535071264602\n,,1,1970-01-01T05:00:00Z,m,1,2.0019826787206814\n,,1,1970-01-01T06:00:00Z,m,1,2.3937701181156563\n,,1,1970-01-01T07:00:00Z,m,1,2.967511115362197\n,,1,1970-01-01T08:00:00Z,m,1,3.584631623741339\n,,1,1970-01-01T09:00:00Z,m,1,3.8408328505068394\n,,1,1970-01-01T10:00:00Z,m,1,4.253846370327077\n,,1,1970-01-01T11:00:00Z,m,1,4.589655118024021\n,,1,1970-01-01T12:00:00Z,m,1,4.8399968375146925\n,,1,1970-01-01T13:00:00Z,m,1,5.826625823946474\n,,1,1970-01-01T14:00:00Z,m,1,6.256509819698633\n,,1,1970-01-01T15:00:00Z,m,1,6.282536067674507\n,,1,1970-01-01T16:00:00Z,m,1,7.275159293716898\n,,1,1970-01-01T17:00:00Z,m,1,8.252274598373521\n,,1,1970-01-01T18:00:00Z,m,1,8.82029425506925\n,,1,1970-01-01T19:00:00Z,m,1,8.83982071426132\n,,1,1970-01-01T20:00:00Z,m,1,9.183789963370288\n,,1,1970-01-01T21:00:00Z,m,1,9.339751393516302\n,,1,1970-01-01T22:00:00Z,m,1,10.138449714782139\n,,1,1970-01-01T23:00:00Z,m,1,10.451815366819142\n,,1,1970-01-02T00:00:00Z,m,1,11.091643505183871\n,,1,1970-01-02T01:00:00Z,m,1,11.231830238409824\n,,1,1970-01-02T02:00:00Z,m,1,11.516571217644247\n,,1,1970-01-02T03:00:00Z,m,1,11.94611730409226\n,,1,1970-01-02T04:00:00Z,m,1,12.913518929948845\n,,1,1970-01-02T05:00:00Z,m,1,13.022356792228974\n,,1,1970-01-02T06:00:00Z,m,1,13.493651401947544\n,,1,1970-01-02T07:00:00Z,m,1,14.411222288015821\n,,1,1970-01-02T08:00:00Z,m,1,14.749572744290527\n,,1,1970-01-02T09:00:00Z,m,1,15.467196528292016\n,,1,1970-01-02T10:00:00Z,m,1,15.923512520102825\n,,1,1970-01-02T11:00:00Z,m,1,16.505618077150444\n,,1,1970-01-02T12:00:00Z,m,1,16.953951538958858\n,,1,1970-01-02T13:00:00Z,m,1,17.80103420489034\n,,1,1970-01-02T14:00:00Z,m,1,17.90423928985627\n,,1,1970-01-02T15:00:00Z,m,1,18.53844317743996\n,,1,1970-01-02T16:00:00Z,m,1,19.010014561359963\n,,1,1970-01-02T17:00:00Z,m,1,19.60393414250918\n,,1,1970-01-02T18:00:00Z,m,1,19.994634536337163\n,,1,1970-01-02T19:00:00Z,m,1,20.36841264293761\n,,1,1970-01-02T20:00:00Z,m,1,20.97433062765647\n,,1,1970-01-02T21:00:00Z,m,1,21.34892193082414\n,,1,1970-01-02T22:00:00Z,m,1,21.877942725925923\n,,1,1970-01-02T23:00:00Z,m,1,22.457739251864655\n,,1,1970-01-03T00:00:00Z,m,1,22.87734528546483\n,,1,1970-01-03T01:00:00Z,m,1,23.31972790913099\n,,1,1970-01-03T02:00:00Z,m,1,24.075946433091257\n,,1,1970-01-03T03:00:00Z,m,1,24.372356439051785\n,,1,1970-01-03T04:00:00Z,m,1,24.923543040273568\n,,1,1970-01-03T05:00:00Z,m,1,25.400774209156125\n,,1,1970-01-03T06:00:00Z,m,1,25.979134656805332\n,,1,1970-01-03T07:00:00Z,m,1,26.587849382365725\n,,1,1970-01-03T08:00:00Z,m,1,27.56582224750691\n,,1,1970-01-03T09:00:00Z,m,1,28.42173464370378\n,,1,1970-01-03T10:00:00Z,m,1,28.461057447463755\n,,1,1970-01-03T11:00:00Z,m,1,28.971845243811185\n,,1,1970-01-03T12:00:00Z,m,1,29.3412425841778\n,,1,1970-01-03T13:00:00Z,m,1,29.581610927511306\n,,1,1970-01-03T14:00:00Z,m,1,30.48572495722582\n,,1,1970-01-03T15:00:00Z,m,1,30.794588363395526\n,,1,1970-01-03T16:00:00Z,m,1,31.133764085102047\n,,1,1970-01-03T17:00:00Z,m,1,31.704667286510116\n,,1,1970-01-03T18:00:00Z,m,1,31.728359620661404\n,,1,1970-01-03T19:00:00Z,m,1,32.65669934614199\n,,1,1970-01-03T20:00:00Z,m,1,33.44642944821644\n,,1,1970-01-03T21:00:00Z,m,1,33.99633621252024\n,,1,1970-01-03T22:00:00Z,m,1,34.19993432719558\n,,1,1970-01-03T23:00:00Z,m,1,34.3945598672661\n,,1,1970-01-04T00:00:00Z,m,1,34.84158943473498\n,,1,1970-01-04T01:00:00Z,m,1,35.287932864144494\n,,1,1970-01-04T02:00:00Z,m,1,35.73414936059147\n,,1,1970-01-04T03:00:00Z,m,1,36.25872336215064\n,,1,1970-01-04T04:00:00Z,m,1,36.551248914422544\n,,1,1970-01-04T05:00:00Z,m,1,37.06496587209677\n,,1,1970-01-04T06:00:00Z,m,1,37.22741323003485\n,,1,1970-01-04T07:00:00Z,m,1,37.52895020913166\n,,1,1970-01-04T08:00:00Z,m,1,37.76138291264318\n,,1,1970-01-04T09:00:00Z,m,1,37.79577611055943\n,,1,1970-01-04T10:00:00Z,m,1,38.22943911017099\n,,1,1970-01-04T11:00:00Z,m,1,39.10849648052425\n,,1,1970-01-04T12:00:00Z,m,1,40.0101788948332\n,,1,1970-01-04T13:00:00Z,m,1,40.350216274530645\n,,1,1970-01-04T14:00:00Z,m,1,40.73511156540662\n,,1,1970-01-04T15:00:00Z,m,1,41.730283425726824\n,,1,1970-01-04T16:00:00Z,m,1,42.5870284431861\n,,1,1970-01-04T17:00:00Z,m,1,42.71092052193442\n,,1,1970-01-04T18:00:00Z,m,1,43.38220709883908\n,,1,1970-01-04T19:00:00Z,m,1,43.8467507359473\n,,1,1970-01-04T20:00:00Z,m,1,44.8093452751721\n,,1,1970-01-04T21:00:00Z,m,1,45.562901155582296\n,,1,1970-01-04T22:00:00Z,m,1,46.30718281966764\n,,1,1970-01-04T23:00:00Z,m,1,46.98832010808668\n,,1,1970-01-05T00:00:00Z,m,1,47.45003155317226\n,,1,1970-01-05T01:00:00Z,m,1,48.22021761381953\n,,1,1970-01-05T02:00:00Z,m,1,48.4753912875235\n,,1,1970-01-05T03:00:00Z,m,1,49.031830785734755\n,,1,1970-01-05T04:00:00Z,m,1,49.21439117836617\n,,1,1970-01-05T05:00:00Z,m,1,49.2990416198911\n,,1,1970-01-05T06:00:00Z,m,1,49.3458703858585\n,,1,1970-01-05T07:00:00Z,m,1,49.85752395362514\n,,1,1970-01-05T08:00:00Z,m,1,50.12079908438952\n,,1,1970-01-05T09:00:00Z,m,1,50.97596284434446\n,,1,1970-01-05T10:00:00Z,m,1,51.02505054073349\n,,1,1970-01-05T11:00:00Z,m,1,51.699846007518765\n,,1,1970-01-05T12:00:00Z,m,1,52.369967089558216\n,,1,1970-01-05T13:00:00Z,m,1,53.039781758955385\n,,1,1970-01-05T14:00:00Z,m,1,53.369178885933955\n,,1,1970-01-05T15:00:00Z,m,1,54.157563597791366\n,,1,1970-01-05T16:00:00Z,m,1,55.101071462582034\n,,1,1970-01-05T17:00:00Z,m,1,55.15633906065944\n,,1,1970-01-05T18:00:00Z,m,1,55.46039669884767\n,,1,1970-01-05T19:00:00Z,m,1,55.590972431223\n,,1,1970-01-05T20:00:00Z,m,1,56.029802212666745\n,,1,1970-01-05T21:00:00Z,m,1,56.196196025653315\n,,1,1970-01-05T22:00:00Z,m,1,56.374374711218714\n,,1,1970-01-05T23:00:00Z,m,1,56.744444197538094\n,,1,1970-01-06T00:00:00Z,m,1,57.51558289287379\n,,1,1970-01-06T01:00:00Z,m,1,57.88922882906224\n,,1,1970-01-06T02:00:00Z,m,1,58.81782843555601\n,,1,1970-01-06T03:00:00Z,m,1,59.68642029694968\n,,1,1970-01-06T04:00:00Z,m,1,59.736178132130334\n,,1,1970-01-06T05:00:00Z,m,1,60.09238328887701\n,,1,1970-01-06T06:00:00Z,m,1,60.995276134547225\n,,1,1970-01-06T07:00:00Z,m,1,61.4494033247732\n,,1,1970-01-06T08:00:00Z,m,1,61.97050252064536\n,,1,1970-01-06T09:00:00Z,m,1,62.471874133240085\n,,1,1970-01-06T10:00:00Z,m,1,63.25176012670734\n,,1,1970-01-06T11:00:00Z,m,1,63.45953346972184\n,,1,1970-01-06T12:00:00Z,m,1,63.58933236052869\n,,1,1970-01-06T13:00:00Z,m,1,64.26064887885045\n,,1,1970-01-06T14:00:00Z,m,1,64.78741381742964\n,,1,1970-01-06T15:00:00Z,m,1,65.06411351444684\n,,1,1970-01-06T16:00:00Z,m,1,65.90167481804897\n,,1,1970-01-06T17:00:00Z,m,1,66.00859572832321\n,,1,1970-01-06T18:00:00Z,m,1,66.17020990732348\n,,1,1970-01-06T19:00:00Z,m,1,66.92987149306248\n,,1,1970-01-06T20:00:00Z,m,1,67.8332191249122\n,,1,1970-01-06T21:00:00Z,m,1,68.7613985802214\n,,1,1970-01-06T22:00:00Z,m,1,69.53058016479044\n,,1,1970-01-06T23:00:00Z,m,1,70.10197429323627\n,,1,1970-01-07T00:00:00Z,m,1,70.93387888405306\n,,1,1970-01-07T01:00:00Z,m,1,71.51779890552604\n,,1,1970-01-07T02:00:00Z,m,1,72.07758723295665\n,,1,1970-01-07T03:00:00Z,m,1,72.9223979527071\n,,1,1970-01-07T04:00:00Z,m,1,73.31381794401253\n,,1,1970-01-07T05:00:00Z,m,1,73.62892366518884\n,,1,1970-01-07T06:00:00Z,m,1,74.01017256881295\n,,1,1970-01-07T07:00:00Z,m,1,74.04910802166255\n,,1,1970-01-07T08:00:00Z,m,1,74.56304246007979\n,,1,1970-01-07T09:00:00Z,m,1,74.63691658778671\n,,1,1970-01-07T10:00:00Z,m,1,74.79823653630295\n,,1,1970-01-07T11:00:00Z,m,1,75.65072385887638\n,,1,1970-01-07T12:00:00Z,m,1,76.36154683945887\n,,1,1970-01-07T13:00:00Z,m,1,76.77028407259678\n,,1,1970-01-07T14:00:00Z,m,1,77.31113337869395\n,,1,1970-01-07T15:00:00Z,m,1,78.18634507210696\n,,1,1970-01-07T16:00:00Z,m,1,79.14326469694822\n,,1,1970-01-07T17:00:00Z,m,1,79.66393155651781\n,,1,1970-01-07T18:00:00Z,m,1,79.6767795090111\n,,1,1970-01-07T19:00:00Z,m,1,80.39234005999649\n,,1,1970-01-07T20:00:00Z,m,1,81.22166737490558\n,,1,1970-01-07T21:00:00Z,m,1,81.60872010394517\n,,1,1970-01-07T22:00:00Z,m,1,82.15471924481835\n,,1,1970-01-07T23:00:00Z,m,1,82.8614032926796\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   349,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,cumulative_sum\n,,0,1970-01-01T00:00:00Z,m,0,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,0.5502117115340306\n,,0,1970-01-01T02:00:00Z,m,0,1.4511048234394535\n,,0,1970-01-01T03:00:00Z,m,0,2.097255422004095\n,,0,1970-01-01T04:00:00Z,m,0,2.2312776833597288\n,,0,1970-01-01T05:00:00Z,m,0,2.536369972964114\n,,0,1970-01-01T06:00:00Z,m,0,2.704347873011682\n,,0,1970-01-01T07:00:00Z,m,0,3.3903379491205223\n,,0,1970-01-01T08:00:00Z,m,0,3.771675182555195\n,,0,1970-01-01T09:00:00Z,m,0,4.149073190575701\n,,0,1970-01-01T10:00:00Z,m,0,4.416094703170296\n,,0,1970-01-01T11:00:00Z,m,0,4.614667435527389\n,,0,1970-01-01T12:00:00Z,m,0,5.407308744598822\n,,0,1970-01-01T13:00:00Z,m,0,6.256152375910654\n,,0,1970-01-01T14:00:00Z,m,0,6.452181719489372\n,,0,1970-01-01T15:00:00Z,m,0,6.724229136279894\n,,0,1970-01-01T16:00:00Z,m,0,7.32873478622085\n,,0,1970-01-01T17:00:00Z,m,0,7.54381822102341\n,,0,1970-01-01T18:00:00Z,m,0,7.81507274632513\n,,0,1970-01-01T19:00:00Z,m,0,8.042354660643586\n,,0,1970-01-01T20:00:00Z,m,0,8.865602839374189\n,,0,1970-01-01T21:00:00Z,m,0,9.837808299980264\n,,0,1970-01-01T22:00:00Z,m,0,10.771102598282045\n,,0,1970-01-01T23:00:00Z,m,0,10.780807403324367\n,,0,1970-01-02T00:00:00Z,m,0,11.24228501844288\n,,0,1970-01-02T01:00:00Z,m,0,11.63957043278532\n,,0,1970-01-02T02:00:00Z,m,0,11.663728215225056\n,,0,1970-01-02T03:00:00Z,m,0,12.37116338553267\n,,0,1970-01-02T04:00:00Z,m,0,12.95315330292682\n,,0,1970-01-02T05:00:00Z,m,0,13.250643276008605\n,,0,1970-01-02T06:00:00Z,m,0,13.61713323302884\n,,0,1970-01-02T07:00:00Z,m,0,14.183795782969792\n,,0,1970-01-02T08:00:00Z,m,0,14.443061656005012\n,,0,1970-01-02T09:00:00Z,m,0,15.133782311016216\n,,0,1970-01-02T10:00:00Z,m,0,15.852262439418936\n,,0,1970-01-02T11:00:00Z,m,0,16.215366426371748\n,,0,1970-01-02T12:00:00Z,m,0,17.154192247212052\n,,0,1970-01-02T13:00:00Z,m,0,17.85765613186283\n,,0,1970-01-02T14:00:00Z,m,0,18.429146455044876\n,,0,1970-01-02T15:00:00Z,m,0,18.673636934858838\n,,0,1970-01-02T16:00:00Z,m,0,18.815287310517277\n,,0,1970-01-02T17:00:00Z,m,0,18.868798668978787\n,,0,1970-01-02T18:00:00Z,m,0,19.213876782314408\n,,0,1970-01-02T19:00:00Z,m,0,19.44641975713867\n,,0,1970-01-02T20:00:00Z,m,0,19.600588269864083\n,,0,1970-01-02T21:00:00Z,m,0,20.529299644386946\n,,0,1970-01-02T22:00:00Z,m,0,21.375740247028\n,,0,1970-01-02T23:00:00Z,m,0,22.15436396260722\n,,0,1970-01-03T00:00:00Z,m,0,22.87662698999149\n,,0,1970-01-03T01:00:00Z,m,0,23.446912641805948\n,,0,1970-01-03T02:00:00Z,m,0,23.89441470305999\n,,0,1970-01-03T03:00:00Z,m,0,24.089238835365222\n,,0,1970-01-03T04:00:00Z,m,0,24.234789841963533\n,,0,1970-01-03T05:00:00Z,m,0,24.60632118873131\n,,0,1970-01-03T06:00:00Z,m,0,24.76342243479113\n,,0,1970-01-03T07:00:00Z,m,0,24.81457610404482\n,,0,1970-01-03T08:00:00Z,m,0,25.310922839847866\n,,0,1970-01-03T09:00:00Z,m,0,25.4094277643875\n,,0,1970-01-03T10:00:00Z,m,0,25.48031305106398\n,,0,1970-01-03T11:00:00Z,m,0,26.433908936349063\n,,0,1970-01-03T12:00:00Z,m,0,27.38122126533224\n,,0,1970-01-03T13:00:00Z,m,0,28.013420365200933\n,,0,1970-01-03T14:00:00Z,m,0,28.544518926821898\n,,0,1970-01-03T15:00:00Z,m,0,28.684621289675437\n,,0,1970-01-03T16:00:00Z,m,0,29.19893242194478\n,,0,1970-01-03T17:00:00Z,m,0,29.340887923295092\n,,0,1970-01-03T18:00:00Z,m,0,29.375876094440358\n,,0,1970-01-03T19:00:00Z,m,0,29.840518430553495\n,,0,1970-01-03T20:00:00Z,m,0,30.568596016497587\n,,0,1970-01-03T21:00:00Z,m,0,31.52911834948428\n,,0,1970-01-03T22:00:00Z,m,0,32.158585496846946\n,,0,1970-01-03T23:00:00Z,m,0,32.25535036631466\n,,0,1970-01-04T00:00:00Z,m,0,32.740012856940254\n,,0,1970-01-04T01:00:00Z,m,0,33.64002801986436\n,,0,1970-01-04T02:00:00Z,m,0,34.45878007802953\n,,0,1970-01-04T03:00:00Z,m,0,35.09442804535487\n,,0,1970-01-04T04:00:00Z,m,0,36.01165730224184\n,,0,1970-01-04T05:00:00Z,m,0,36.270371438098586\n,,0,1970-01-04T06:00:00Z,m,0,37.20440163920558\n,,0,1970-01-04T07:00:00Z,m,0,37.83443179136016\n,,0,1970-01-04T08:00:00Z,m,0,38.82430138090735\n,,0,1970-01-04T09:00:00Z,m,0,39.48195466594223\n,,0,1970-01-04T10:00:00Z,m,0,39.591550040503265\n,,0,1970-01-04T11:00:00Z,m,0,39.79869720714972\n,,0,1970-01-04T12:00:00Z,m,0,40.292480397768976\n,,0,1970-01-04T13:00:00Z,m,0,40.616943419910065\n,,0,1970-01-04T14:00:00Z,m,0,40.75950545364327\n,,0,1970-01-04T15:00:00Z,m,0,41.13434317452579\n,,0,1970-01-04T16:00:00Z,m,0,42.072955536678165\n,,0,1970-01-04T17:00:00Z,m,0,42.367399466825574\n,,0,1970-01-04T18:00:00Z,m,0,43.17495875624241\n,,0,1970-01-04T19:00:00Z,m,0,43.98807709756972\n,,0,1970-01-04T20:00:00Z,m,0,44.59376461201288\n,,0,1970-01-04T21:00:00Z,m,0,45.14516673576493\n,,0,1970-01-04T22:00:00Z,m,0,45.43561849190662\n,,0,1970-01-04T23:00:00Z,m,0,46.212996697267116\n,,0,1970-01-05T00:00:00Z,m,0,46.35206998228008\n,,0,1970-01-05T01:00:00Z,m,0,46.72081810255463\n,,0,1970-01-05T02:00:00Z,m,0,47.57053144714934\n,,0,1970-01-05T03:00:00Z,m,0,47.85475961443108\n,,0,1970-01-05T04:00:00Z,m,0,48.43987830870233\n,,0,1970-01-05T05:00:00Z,m,0,48.71534776518658\n,,0,1970-01-05T06:00:00Z,m,0,48.75080316212925\n,,0,1970-01-05T07:00:00Z,m,0,49.16142405505885\n,,0,1970-01-05T08:00:00Z,m,0,49.52944981924283\n,,0,1970-01-05T09:00:00Z,m,0,50.2778976036069\n,,0,1970-01-05T10:00:00Z,m,0,50.49759214152938\n,,0,1970-01-05T11:00:00Z,m,0,51.23533310416766\n,,0,1970-01-05T12:00:00Z,m,0,51.66937398633295\n,,0,1970-01-05T13:00:00Z,m,0,51.71095183464651\n,,0,1970-01-05T14:00:00Z,m,0,52.611484281991075\n,,0,1970-01-05T15:00:00Z,m,0,53.23579053128648\n,,0,1970-01-05T16:00:00Z,m,0,53.64961800350353\n,,0,1970-01-05T17:00:00Z,m,0,54.305614135482955\n,,0,1970-01-05T18:00:00Z,m,0,54.40014143750177\n,,0,1970-01-05T19:00:00Z,m,0,54.75222019214466\n,,0,1970-01-05T20:00:00Z,m,0,55.22222309397733\n,,0,1970-01-05T21:00:00Z,m,0,55.35606317895453\n,,0,1970-01-05T22:00:00Z,m,0,55.61031270896288\n,,0,1970-01-05T23:00:00Z,m,0,55.65388682478966\n,,0,1970-01-06T00:00:00Z,m,0,55.92696390981365\n,,0,1970-01-06T01:00:00Z,m,0,56.00043110050868\n,,0,1970-01-06T02:00:00Z,m,0,56.193399801587056\n,,0,1970-01-06T03:00:00Z,m,0,57.04846996859816\n,,0,1970-01-06T04:00:00Z,m,0,57.949997967936085\n,,0,1970-01-06T05:00:00Z,m,0,58.71813092772145\n,,0,1970-01-06T06:00:00Z,m,0,58.85271675733672\n,,0,1970-01-06T07:00:00Z,m,0,59.35531316057092\n,,0,1970-01-06T08:00:00Z,m,0,60.321374275590806\n,,0,1970-01-06T09:00:00Z,m,0,61.062049910604024\n,,0,1970-01-06T10:00:00Z,m,0,61.54450314462472\n,,0,1970-01-06T11:00:00Z,m,0,62.08418981248373\n,,0,1970-01-06T12:00:00Z,m,0,62.324757684408326\n,,0,1970-01-06T13:00:00Z,m,0,62.87210727439746\n,,0,1970-01-06T14:00:00Z,m,0,63.86605602639549\n,,0,1970-01-06T15:00:00Z,m,0,64.63786467179935\n,,0,1970-01-06T16:00:00Z,m,0,65.01078785809091\n,,0,1970-01-06T17:00:00Z,m,0,65.98900448618066\n,,0,1970-01-06T18:00:00Z,m,0,66.29310950116337\n,,0,1970-01-06T19:00:00Z,m,0,66.65604475882448\n,,0,1970-01-06T20:00:00Z,m,0,67.11278369580661\n,,0,1970-01-06T21:00:00Z,m,0,67.54165839620606\n,,0,1970-01-06T22:00:00Z,m,0,67.96430284022401\n,,0,1970-01-06T23:00:00Z,m,0,68.27049376734182\n,,0,1970-01-07T00:00:00Z,m,0,68.93862288491061\n,,0,1970-01-07T01:00:00Z,m,0,69.48803372698875\n,,0,1970-01-07T02:00:00Z,m,0,69.80582967002523\n,,0,1970-01-07T03:00:00Z,m,0,70.03085670714789\n,,0,1970-01-07T04:00:00Z,m,0,70.06583817562658\n,,0,1970-01-07T05:00:00Z,m,0,70.22723213438681\n,,0,1970-01-07T06:00:00Z,m,0,70.86076402993893\n,,0,1970-01-07T07:00:00Z,m,0,71.44626077530116\n,,0,1970-01-07T08:00:00Z,m,0,71.87641891895679\n,,0,1970-01-07T09:00:00Z,m,0,71.94857374543777\n,,0,1970-01-07T10:00:00Z,m,0,72.0420578752723\n,,0,1970-01-07T11:00:00Z,m,0,72.94443722996388\n,,0,1970-01-07T12:00:00Z,m,0,73.84998235925006\n,,0,1970-01-07T13:00:00Z,m,0,74.17802777366649\n,,0,1970-01-07T14:00:00Z,m,0,74.23700246129805\n,,0,1970-01-07T15:00:00Z,m,0,74.60563636396598\n,,0,1970-01-07T16:00:00Z,m,0,75.36035376156504\n,,0,1970-01-07T17:00:00Z,m,0,75.81820128770799\n,,0,1970-01-07T18:00:00Z,m,0,76.3220332931636\n,,0,1970-01-07T19:00:00Z,m,0,76.79261474316948\n,,0,1970-01-07T20:00:00Z,m,0,77.32600507490261\n,,0,1970-01-07T21:00:00Z,m,0,77.48085593633222\n,,0,1970-01-07T22:00:00Z,m,0,78.16462404171915\n,,0,1970-01-07T23:00:00Z,m,0,79.07281937990595\n,,1,1970-01-01T00:00:00Z,m,1,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,0.3316845624286535\n,,1,1970-01-01T02:00:00Z,m,1,0.5636708618185042\n,,1,1970-01-01T03:00:00Z,m,1,1.0577484680529374\n,,1,1970-01-01T04:00:00Z,m,1,1.6231535071264602\n,,1,1970-01-01T05:00:00Z,m,1,2.0019826787206814\n,,1,1970-01-01T06:00:00Z,m,1,2.3937701181156563\n,,1,1970-01-01T07:00:00Z,m,1,2.967511115362197\n,,1,1970-01-01T08:00:00Z,m,1,3.584631623741339\n,,1,1970-01-01T09:00:00Z,m,1,3.8408328505068394\n,,1,1970-01-01T10:00:00Z,m,1,4.253846370327077\n,,1,1970-01-01T11:00:00Z,m,1,4.589655118024021\n,,1,1970-01-01T12:00:00Z,m,1,4.8399968375146925\n,,1,1970-01-01T13:00:00Z,m,1,5.826625823946474\n,,1,1970-01-01T14:00:00Z,m,1,6.256509819698633\n,,1,1970-01-01T15:00:00Z,m,1,6.282536067674507\n,,1,1970-01-01T16:00:00Z,m,1,7.275159293716898\n,,1,1970-01-01T17:00:00Z,m,1,8.252274598373521\n,,1,1970-01-01T18:00:00Z,m,1,8.82029425506925\n,,1,1970-01-01T19:00:00Z,m,1,8.83982071426132\n,,1,1970-01-01T20:00:00Z,m,1,9.183789963370288\n,,1,1970-01-01T21:00:00Z,m,1,9.339751393516302\n,,1,1970-01-01T22:00:00Z,m,1,10.138449714782139\n,,1,1970-01-01T23:00:00Z,m,1,10.451815366819142\n,,1,1970-01-02T00:00:00Z,m,1,11.091643505183871\n,,1,1970-01-02T01:00:00Z,m,1,11.231830238409824\n,,1,1970-01-02T02:00:00Z,m,1,11.516571217644247\n,,1,1970-01-02T03:00:00Z,m,1,11.94611730409226\n,,1,1970-01-02T04:00:00Z,m,1,12.913518929948845\n,,1,1970-01-02T05:00:00Z,m,1,13.022356792228974\n,,1,1970-01-02T06:00:00Z,m,1,13.493651401947544\n,,1,1970-01-02T07:00:00Z,m,1,14.411222288015821\n,,1,1970-01-02T08:00:00Z,m,1,14.749572744290527\n,,1,1970-01-02T09:00:00Z,m,1,15.467196528292016\n,,1,1970-01-02T10:00:00Z,m,1,15.923512520102825\n,,1,1970-01-02T11:00:00Z,m,1,16.505618077150444\n,,1,1970-01-02T12:00:00Z,m,1,16.953951538958858\n,,1,1970-01-02T13:00:00Z,m,1,17.80103420489034\n,,1,1970-01-02T14:00:00Z,m,1,17.90423928985627\n,,1,1970-01-02T15:00:00Z,m,1,18.53844317743996\n,,1,1970-01-02T16:00:00Z,m,1,19.010014561359963\n,,1,1970-01-02T17:00:00Z,m,1,19.60393414250918\n,,1,1970-01-02T18:00:00Z,m,1,19.994634536337163\n,,1,1970-01-02T19:00:00Z,m,1,20.36841264293761\n,,1,1970-01-02T20:00:00Z,m,1,20.97433062765647\n,,1,1970-01-02T21:00:00Z,m,1,21.34892193082414\n,,1,1970-01-02T22:00:00Z,m,1,21.877942725925923\n,,1,1970-01-02T23:00:00Z,m,1,22.457739251864655\n,,1,1970-01-03T00:00:00Z,m,1,22.87734528546483\n,,1,1970-01-03T01:00:00Z,m,1,23.31972790913099\n,,1,1970-01-03T02:00:00Z,m,1,24.075946433091257\n,,1,1970-01-03T03:00:00Z,m,1,24.372356439051785\n,,1,1970-01-03T04:00:00Z,m,1,24.923543040273568\n,,1,1970-01-03T05:00:00Z,m,1,25.400774209156125\n,,1,1970-01-03T06:00:00Z,m,1,25.979134656805332\n,,1,1970-01-03T07:00:00Z,m,1,26.587849382365725\n,,1,1970-01-03T08:00:00Z,m,1,27.56582224750691\n,,1,1970-01-03T09:00:00Z,m,1,28.42173464370378\n,,1,1970-01-03T10:00:00Z,m,1,28.461057447463755\n,,1,1970-01-03T11:00:00Z,m,1,28.971845243811185\n,,1,1970-01-03T12:00:00Z,m,1,29.3412425841778\n,,1,1970-01-03T13:00:00Z,m,1,29.581610927511306\n,,1,1970-01-03T14:00:00Z,m,1,30.48572495722582\n,,1,1970-01-03T15:00:00Z,m,1,30.794588363395526\n,,1,1970-01-03T16:00:00Z,m,1,31.133764085102047\n,,1,1970-01-03T17:00:00Z,m,1,31.704667286510116\n,,1,1970-01-03T18:00:00Z,m,1,31.728359620661404\n,,1,1970-01-03T19:00:00Z,m,1,32.65669934614199\n,,1,1970-01-03T20:00:00Z,m,1,33.44642944821644\n,,1,1970-01-03T21:00:00Z,m,1,33.99633621252024\n,,1,1970-01-03T22:00:00Z,m,1,34.19993432719558\n,,1,1970-01-03T23:00:00Z,m,1,34.3945598672661\n,,1,1970-01-04T00:00:00Z,m,1,34.84158943473498\n,,1,1970-01-04T01:00:00Z,m,1,35.287932864144494\n,,1,1970-01-04T02:00:00Z,m,1,35.73414936059147\n,,1,1970-01-04T03:00:00Z,m,1,36.25872336215064\n,,1,1970-01-04T04:00:00Z,m,1,36.551248914422544\n,,1,1970-01-04T05:00:00Z,m,1,37.06496587209677\n,,1,1970-01-04T06:00:00Z,m,1,37.22741323003485\n,,1,1970-01-04T07:00:00Z,m,1,37.52895020913166\n,,1,1970-01-04T08:00:00Z,m,1,37.76138291264318\n,,1,1970-01-04T09:00:00Z,m,1,37.79577611055943\n,,1,1970-01-04T10:00:00Z,m,1,38.22943911017099\n,,1,1970-01-04T11:00:00Z,m,1,39.10849648052425\n,,1,1970-01-04T12:00:00Z,m,1,40.0101788948332\n,,1,1970-01-04T13:00:00Z,m,1,40.350216274530645\n,,1,1970-01-04T14:00:00Z,m,1,40.73511156540662\n,,1,1970-01-04T15:00:00Z,m,1,41.730283425726824\n,,1,1970-01-04T16:00:00Z,m,1,42.5870284431861\n,,1,1970-01-04T17:00:00Z,m,1,42.71092052193442\n,,1,1970-01-04T18:00:00Z,m,1,43.38220709883908\n,,1,1970-01-04T19:00:00Z,m,1,43.8467507359473\n,,1,1970-01-04T20:00:00Z,m,1,44.8093452751721\n,,1,1970-01-04T21:00:00Z,m,1,45.562901155582296\n,,1,1970-01-04T22:00:00Z,m,1,46.30718281966764\n,,1,1970-01-04T23:00:00Z,m,1,46.98832010808668\n,,1,1970-01-05T00:00:00Z,m,1,47.45003155317226\n,,1,1970-01-05T01:00:00Z,m,1,48.22021761381953\n,,1,1970-01-05T02:00:00Z,m,1,48.4753912875235\n,,1,1970-01-05T03:00:00Z,m,1,49.031830785734755\n,,1,1970-01-05T04:00:00Z,m,1,49.21439117836617\n,,1,1970-01-05T05:00:00Z,m,1,49.2990416198911\n,,1,1970-01-05T06:00:00Z,m,1,49.3458703858585\n,,1,1970-01-05T07:00:00Z,m,1,49.85752395362514\n,,1,1970-01-05T08:00:00Z,m,1,50.12079908438952\n,,1,1970-01-05T09:00:00Z,m,1,50.97596284434446\n,,1,1970-01-05T10:00:00Z,m,1,51.02505054073349\n,,1,1970-01-05T11:00:00Z,m,1,51.699846007518765\n,,1,1970-01-05T12:00:00Z,m,1,52.369967089558216\n,,1,1970-01-05T13:00:00Z,m,1,53.039781758955385\n,,1,1970-01-05T14:00:00Z,m,1,53.369178885933955\n,,1,1970-01-05T15:00:00Z,m,1,54.157563597791366\n,,1,1970-01-05T16:00:00Z,m,1,55.101071462582034\n,,1,1970-01-05T17:00:00Z,m,1,55.15633906065944\n,,1,1970-01-05T18:00:00Z,m,1,55.46039669884767\n,,1,1970-01-05T19:00:00Z,m,1,55.590972431223\n,,1,1970-01-05T20:00:00Z,m,1,56.029802212666745\n,,1,1970-01-05T21:00:00Z,m,1,56.196196025653315\n,,1,1970-01-05T22:00:00Z,m,1,56.374374711218714\n,,1,1970-01-05T23:00:00Z,m,1,56.744444197538094\n,,1,1970-01-06T00:00:00Z,m,1,57.51558289287379\n,,1,1970-01-06T01:00:00Z,m,1,57.88922882906224\n,,1,1970-01-06T02:00:00Z,m,1,58.81782843555601\n,,1,1970-01-06T03:00:00Z,m,1,59.68642029694968\n,,1,1970-01-06T04:00:00Z,m,1,59.736178132130334\n,,1,1970-01-06T05:00:00Z,m,1,60.09238328887701\n,,1,1970-01-06T06:00:00Z,m,1,60.995276134547225\n,,1,1970-01-06T07:00:00Z,m,1,61.4494033247732\n,,1,1970-01-06T08:00:00Z,m,1,61.97050252064536\n,,1,1970-01-06T09:00:00Z,m,1,62.471874133240085\n,,1,1970-01-06T10:00:00Z,m,1,63.25176012670734\n,,1,1970-01-06T11:00:00Z,m,1,63.45953346972184\n,,1,1970-01-06T12:00:00Z,m,1,63.58933236052869\n,,1,1970-01-06T13:00:00Z,m,1,64.26064887885045\n,,1,1970-01-06T14:00:00Z,m,1,64.78741381742964\n,,1,1970-01-06T15:00:00Z,m,1,65.06411351444684\n,,1,1970-01-06T16:00:00Z,m,1,65.90167481804897\n,,1,1970-01-06T17:00:00Z,m,1,66.00859572832321\n,,1,1970-01-06T18:00:00Z,m,1,66.17020990732348\n,,1,1970-01-06T19:00:00Z,m,1,66.92987149306248\n,,1,1970-01-06T20:00:00Z,m,1,67.8332191249122\n,,1,1970-01-06T21:00:00Z,m,1,68.7613985802214\n,,1,1970-01-06T22:00:00Z,m,1,69.53058016479044\n,,1,1970-01-06T23:00:00Z,m,1,70.10197429323627\n,,1,1970-01-07T00:00:00Z,m,1,70.93387888405306\n,,1,1970-01-07T01:00:00Z,m,1,71.51779890552604\n,,1,1970-01-07T02:00:00Z,m,1,72.07758723295665\n,,1,1970-01-07T03:00:00Z,m,1,72.9223979527071\n,,1,1970-01-07T04:00:00Z,m,1,73.31381794401253\n,,1,1970-01-07T05:00:00Z,m,1,73.62892366518884\n,,1,1970-01-07T06:00:00Z,m,1,74.01017256881295\n,,1,1970-01-07T07:00:00Z,m,1,74.04910802166255\n,,1,1970-01-07T08:00:00Z,m,1,74.56304246007979\n,,1,1970-01-07T09:00:00Z,m,1,74.63691658778671\n,,1,1970-01-07T10:00:00Z,m,1,74.79823653630295\n,,1,1970-01-07T11:00:00Z,m,1,75.65072385887638\n,,1,1970-01-07T12:00:00Z,m,1,76.36154683945887\n,,1,1970-01-07T13:00:00Z,m,1,76.77028407259678\n,,1,1970-01-07T14:00:00Z,m,1,77.31113337869395\n,,1,1970-01-07T15:00:00Z,m,1,78.18634507210696\n,,1,1970-01-07T16:00:00Z,m,1,79.14326469694822\n,,1,1970-01-07T17:00:00Z,m,1,79.66393155651781\n,,1,1970-01-07T18:00:00Z,m,1,79.6767795090111\n,,1,1970-01-07T19:00:00Z,m,1,80.39234005999649\n,,1,1970-01-07T20:00:00Z,m,1,81.22166737490558\n,,1,1970-01-07T21:00:00Z,m,1,81.60872010394517\n,,1,1970-01-07T22:00:00Z,m,1,82.15471924481835\n,,1,1970-01-07T23:00:00Z,m,1,82.8614032926796\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 63,
						Line:   699,
					},
					File:   "cumulative_sum_test.flux",
					Source: "t_cumulative_sum = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> cumulativeSum()\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\"])\n\t|> rename(columns: {_time: \"time\", _value: \"cumulative_sum\"})",
					Start: ast.Position{
						Column: 1,
						Line:   693,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   693,
						},
						File:   "cumulative_sum_test.flux",
						Source: "t_cumulative_sum",
						Start: ast.Position{
							Column: 1,
							Line:   693,
						},
					},
				},
				Name: "t_cumulative_sum",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 63,
							Line:   699,
						},
						File:   "cumulative_sum_test.flux",
						Source: "(tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> cumulativeSum()\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\"])\n\t|> rename(columns: {_time: \"time\", _value: \"cumulative_sum\"})",
						Start: ast.Position{
							Column: 20,
							Line:   693,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   693,
													},
													File:   "cumulative_sum_test.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 35,
														Line:   693,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   694,
												},
												File:   "cumulative_sum_test.flux",
												Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)",
												Start: ast.Position{
													Column: 35,
													Line:   693,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   694,
														},
														File:   "cumulative_sum_test.flux",
														Source: "start: influxql.minTime, stop: influxql.maxTime",
														Start: ast.Position{
															Column: 11,
															Line:   694,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   694,
															},
															File:   "cumulative_sum_test.flux",
															Source: "start: influxql.minTime",
															Start: ast.Position{
																Column: 11,
																Line:   694,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   694,
																},
																File:   "cumulative_sum_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 11,
																	Line:   694,
																},
															},
														},
														Name: "start",
													},
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   694,
																},
																File:   "cumulative_sum_test.flux",
																Source: "influxql.minTime",
																Start: ast.Position{
																	Column: 18,
																	Line:   694,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   694,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "influxql",
																	Start: ast.Position{
																		Column: 18,
																		Line:   694,
																	},
																},
															},
															Name: "influxql",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   694,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "minTime",
																	Start: ast.Position{
																		Column: 27,
																		Line:   694,
																	},
																},
															},
															Name: "minTime",
														},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   694,
															},
															File:   "cumulative_sum_test.flux",
															Source: "stop: influxql.maxTime",
															Start: ast.Position{
																Column: 36,
																Line:   694,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   694,
																},
																File:   "cumulative_sum_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 36,
																	Line:   694,
																},
															},
														},
														Name: "stop",
													},
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   694,
																},
																File:   "cumulative_sum_test.flux",
																Source: "influxql.maxTime",
																Start: ast.Position{
																	Column: 42,
																	Line:   694,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   694,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "influxql",
																	Start: ast.Position{
																		Column: 42,
																		Line:   694,
																	},
																},
															},
															Name: "influxql",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   694,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "maxTime",
																	Start: ast.Position{
																		Column: 51,
																		Line:   694,
																	},
																},
															},
															Name: "maxTime",
														},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   694,
													},
													File:   "cumulative_sum_test.flux",
													Source: "range(start: influxql.minTime, stop: influxql.maxTime)",
													Start: ast.Position{
														Column: 5,
														Line:   694,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   694,
														},
														File:   "cumulative_sum_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 5,
															Line:   694,
														},
													},
												},
												Name: "range",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   695,
											},
											File:   "cumulative_sum_test.flux",
											Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")",
											Start: ast.Position{
												Column: 35,
												Line:   693,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   695,
													},
													File:   "cumulative_sum_test.flux",
													Source: "fn: (r) => r._measurement == \"m\"",
													Start: ast.Position{
														Column: 12,
														Line:   695,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   695,
														},
														File:   "cumulative_sum_test.flux",
														Source: "fn: (r) => r._measurement == \"m\"",
														Start: ast.Position{
															Column: 12,
															Line:   695,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   695,
															},
															File:   "cumulative_sum_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   695,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   695,
															},
															File:   "cumulative_sum_test.flux",
															Source: "(r) => r._measurement == \"m\"",
															Start: ast.Position{
																Column: 16,
																Line:   695,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   695,
																},
																File:   "cumulative_sum_test.flux",
																Source: "r._measurement == \"m\"",
																Start: ast.Position{
																	Column: 23,
																	Line:   695,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   695,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "r._measurement",
																	Start: ast.Position{
																		Column: 23,
																		Line:   695,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   695,
																		},
																		File:   "cumulative_sum_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 23,
																			Line:   695,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   695,
																		},
																		File:   "cumulative_sum_test.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 25,
																			Line:   695,
																		},
																	},
																},
																Name: "_measurement",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   695,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "\"m\"",
																	Start: ast.Position{
																		Column: 41,
																		Line:   695,
																	},
																},
															},
															Value: "m",
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   695,
																},
																File:   "cumulative_sum_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   695,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   695,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   695,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   695,
												},
												File:   "cumulative_sum_test.flux",
												Source: "filter(fn: (r) => r._measurement == \"m\")",
												Start: ast.Position{
													Column: 5,
													Line:   695,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   695,
													},
													File:   "cumulative_sum_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 5,
														Line:   695,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   696,
										},
										File:   "cumulative_sum_test.flux",
										Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")",
										Start: ast.Position{
											Column: 35,
											Line:   693,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   696,
												},
												File:   "cumulative_sum_test.flux",
												Source: "fn: (r) => r._field == \"f\"",
												Start: ast.Position{
													Column: 12,
													Line:   696,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   696,
													},
													File:   "cumulative_sum_test.flux",
													Source: "fn: (r) => r._field == \"f\"",
													Start: ast.Position{
														Column: 12,
														Line:   696,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   696,
														},
														File:   "cumulative_sum_test.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   696,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   696,
														},
														File:   "cumulative_sum_test.flux",
														Source: "(r) => r._field == \"f\"",
														Start: ast.Position{
															Column: 16,
															Line:   696,
														},
													},
												},
												Body: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   696,
															},
															File:   "cumulative_sum_test.flux",
															Source: "r._field == \"f\"",
															Start: ast.Position{
																Column: 23,
																Line:   696,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   696,
																},
																File:   "cumulative_sum_test.flux",
																Source: "r._field",
																Start: ast.Position{
																	Column: 23,
																	Line:   696,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   696,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 23,
																		Line:   696,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   696,
																	},
																	File:   "cumulative_sum_test.flux",
																	Source: "_field",
																	Start: ast.Position{
																		Column: 25,
																		Line:   696,
																	},
																},
															},
															Name: "_field",
														},
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   696,
																},
																File:   "cumulative_sum_test.flux",
																Source: "\"f\"",
																Start: ast.Position{
																	Column: 35,
																	Line:   696,
																},
															},
														},
														Value: "f",
													},
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   696,
															},
															File:   "cumulative_sum_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   696,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   696,
																},
																File:   "cumulative_sum_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   696,
																},
															},
														},
														Name: "r",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   696,
											},
											File:   "cumulative_sum_test.flux",
											Source: "filter(fn: (r) => r._field == \"f\")",
											Start: ast.Position{
												Column: 5,
												Line:   696,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   696,
												},
												File:   "cumulative_sum_test.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 5,
													Line:   696,
												},
											},
										},
										Name: "filter",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   697,
									},
									File:   "cumulative_sum_test.flux",
									Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> cumulativeSum()",
									Start: ast.Position{
										Column: 35,
										Line:   693,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   697,
										},
										File:   "cumulative_sum_test.flux",
										Source: "cumulativeSum()",
										Start: ast.Position{
											Column: 5,
											Line:   697,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   697,
											},
											File:   "cumulative_sum_test.flux",
											Source: "cumulativeSum",
											Start: ast.Position{
												Column: 5,
												Line:   697,
											},
										},
									},
									Name: "cumulativeSum",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   698,
								},
								File:   "cumulative_sum_test.flux",
								Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> cumulativeSum()\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\"])",
								Start: ast.Position{
									Column: 35,
									Line:   693,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   698,
										},
										File:   "cumulative_sum_test.flux",
										Source: "columns: [\"_start\", \"_stop\", \"_field\"]",
										Start: ast.Position{
											Column: 10,
											Line:   698,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   698,
											},
											File:   "cumulative_sum_test.flux",
											Source: "columns: [\"_start\", \"_stop\", \"_field\"]",
											Start: ast.Position{
												Column: 10,
												Line:   698,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   698,
												},
												File:   "cumulative_sum_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 10,
													Line:   698,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   698,
												},
												File:   "cumulative_sum_test.flux",
												Source: "[\"_start\", \"_stop\", \"_field\"]",
												Start: ast.Position{
													Column: 19,
													Line:   698,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   698,
													},
													File:   "cumulative_sum_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 20,
														Line:   698,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   698,
													},
													File:   "cumulative_sum_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 30,
														Line:   698,
													},
												},
											},
											Value: "_stop",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   698,
													},
													File:   "cumulative_sum_test.flux",
													Source: "\"_field\"",
													Start: ast.Position{
														Column: 39,
														Line:   698,
													},
												},
											},
											Value: "_field",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   698,
									},
									File:   "cumulative_sum_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\", \"_field\"])",
									Start: ast.Position{
										Column: 5,
										Line:   698,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   698,
										},
										File:   "cumulative_sum_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 5,
											Line:   698,
										},
									},
								},
								Name: "drop",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   699,
							},
							File:   "cumulative_sum_test.flux",
							Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> cumulativeSum()\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\"])\n\t|> rename(columns: {_time: \"time\", _value: \"cumulative_sum\"})",
							Start: ast.Position{
								Column: 35,
								Line:   693,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   699,
									},
									File:   "cumulative_sum_test.flux",
									Source: "columns: {_time: \"time\", _value: \"cumulative_sum\"}",
									Start: ast.Position{
										Column: 12,
										Line:   699,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   699,
										},
										File:   "cumulative_sum_test.flux",
										Source: "columns: {_time: \"time\", _value: \"cumulative_sum\"}",
										Start: ast.Position{
											Column: 12,
											Line:   699,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   699,
											},
											File:   "cumulative_sum_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 12,
												Line:   699,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   699,
											},
											File:   "cumulative_sum_test.flux",
											Source: "{_time: \"time\", _value: \"cumulative_sum\"}",
											Start: ast.Position{
												Column: 21,
												Line:   699,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   699,
												},
												File:   "cumulative_sum_test.flux",
												Source: "_time: \"time\"",
												Start: ast.Position{
													Column: 22,
													Line:   699,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   699,
													},
													File:   "cumulative_sum_test.flux",
													Source: "_time",
													Start: ast.Position{
														Column: 22,
														Line:   699,
													},
												},
											},
											Name: "_time",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   699,
													},
													File:   "cumulative_sum_test.flux",
													Source: "\"time\"",
													Start: ast.Position{
														Column: 29,
														Line:   699,
													},
												},
											},
											Value: "time",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   699,
												},
												File:   "cumulative_sum_test.flux",
												Source: "_value: \"cumulative_sum\"",
												Start: ast.Position{
													Column: 37,
													Line:   699,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   699,
													},
													File:   "cumulative_sum_test.flux",
													Source: "_value",
													Start: ast.Position{
														Column: 37,
														Line:   699,
													},
												},
											},
											Name: "_value",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   699,
													},
													File:   "cumulative_sum_test.flux",
													Source: "\"cumulative_sum\"",
													Start: ast.Position{
														Column: 45,
														Line:   699,
													},
												},
											},
											Value: "cumulative_sum",
										},
									}},
									With: nil,
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   699,
								},
								File:   "cumulative_sum_test.flux",
								Source: "rename(columns: {_time: \"time\", _value: \"cumulative_sum\"})",
								Start: ast.Position{
									Column: 5,
									Line:   699,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   699,
									},
									File:   "cumulative_sum_test.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 5,
										Line:   699,
									},
								},
							},
							Name: "rename",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   693,
							},
							File:   "cumulative_sum_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   693,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   693,
								},
								File:   "cumulative_sum_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   693,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   693,
							},
							File:   "cumulative_sum_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   693,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   705,
						},
						File:   "cumulative_sum_test.flux",
						Source: "_cumulative_sum = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_cumulative_sum,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   701,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   701,
							},
							File:   "cumulative_sum_test.flux",
							Source: "_cumulative_sum",
							Start: ast.Position{
								Column: 6,
								Line:   701,
							},
						},
					},
					Name: "_cumulative_sum",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   705,
							},
							File:   "cumulative_sum_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_cumulative_sum,\n})",
							Start: ast.Position{
								Column: 24,
								Line:   701,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   705,
								},
								File:   "cumulative_sum_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_cumulative_sum,\n})",
								Start: ast.Position{
									Column: 30,
									Line:   701,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   705,
									},
									File:   "cumulative_sum_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_cumulative_sum,\n}",
									Start: ast.Position{
										Column: 31,
										Line:   701,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   702,
										},
										File:   "cumulative_sum_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   702,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   702,
											},
											File:   "cumulative_sum_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   702,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   702,
												},
												File:   "cumulative_sum_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   702,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   702,
													},
													File:   "cumulative_sum_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   702,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   702,
														},
														File:   "cumulative_sum_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   702,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   702,
														},
														File:   "cumulative_sum_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   702,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   702,
											},
											File:   "cumulative_sum_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   702,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   702,
												},
												File:   "cumulative_sum_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   702,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   702,
													},
													File:   "cumulative_sum_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   702,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   702,
													},
													File:   "cumulative_sum_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   702,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   703,
										},
										File:   "cumulative_sum_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   703,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   703,
											},
											File:   "cumulative_sum_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   703,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   703,
												},
												File:   "cumulative_sum_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   703,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   703,
													},
													File:   "cumulative_sum_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   703,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   703,
														},
														File:   "cumulative_sum_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   703,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   703,
														},
														File:   "cumulative_sum_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   703,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   703,
											},
											File:   "cumulative_sum_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   703,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   703,
												},
												File:   "cumulative_sum_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   703,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   703,
													},
													File:   "cumulative_sum_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   703,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   703,
													},
													File:   "cumulative_sum_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   703,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   704,
										},
										File:   "cumulative_sum_test.flux",
										Source: "fn: t_cumulative_sum",
										Start: ast.Position{
											Column: 2,
											Line:   704,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   704,
											},
											File:   "cumulative_sum_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   704,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   704,
											},
											File:   "cumulative_sum_test.flux",
											Source: "t_cumulative_sum",
											Start: ast.Position{
												Column: 6,
												Line:   704,
											},
										},
									},
									Name: "t_cumulative_sum",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   705,
					},
					File:   "cumulative_sum_test.flux",
					Source: "test _cumulative_sum = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_cumulative_sum,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   701,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "cumulative_sum_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "cumulative_sum_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "cumulative_sum_test.flux",
					Source: "import \"internal/influxql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "cumulative_sum_test.flux",
						Source: "\"internal/influxql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/influxql",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "cumulative_sum_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "cumulative_sum_test.flux",
					Source: "package influxql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "cumulative_sum_test.flux",
						Source: "influxql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxql_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   702,
				},
				File:   "elapsed_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,elapsed\n,,0,1970-01-01T01:00:00Z,m,0,3600000000000\n,,0,1970-01-01T02:00:00Z,m,0,3600000000000\n,,0,1970-01-01T03:00:00Z,m,0,3600000000000\n,,0,1970-01-01T04:00:00Z,m,0,3600000000000\n,,0,1970-01-01T05:00:00Z,m,0,3600000000000\n,,0,1970-01-01T06:00:00Z,m,0,3600000000000\n,,0,1970-01-01T07:00:00Z,m,0,3600000000000\n,,0,1970-01-01T08:00:00Z,m,0,3600000000000\n,,0,1970-01-01T09:00:00Z,m,0,3600000000000\n,,0,1970-01-01T10:00:00Z,m,0,3600000000000\n,,0,1970-01-01T11:00:00Z,m,0,3600000000000\n,,0,1970-01-01T12:00:00Z,m,0,3600000000000\n,,0,1970-01-01T13:00:00Z,m,0,3600000000000\n,,0,1970-01-01T14:00:00Z,m,0,3600000000000\n,,0,1970-01-01T15:00:00Z,m,0,3600000000000\n,,0,1970-01-01T16:00:00Z,m,0,3600000000000\n,,0,1970-01-01T17:00:00Z,m,0,3600000000000\n,,0,1970-01-01T18:00:00Z,m,0,3600000000000\n,,0,1970-01-01T19:00:00Z,m,0,3600000000000\n,,0,1970-01-01T20:00:00Z,m,0,3600000000000\n,,0,1970-01-01T21:00:00Z,m,0,3600000000000\n,,0,1970-01-01T22:00:00Z,m,0,3600000000000\n,,0,1970-01-01T23:00:00Z,m,0,3600000000000\n,,0,1970-01-02T00:00:00Z,m,0,3600000000000\n,,0,1970-01-02T01:00:00Z,m,0,3600000000000\n,,0,1970-01-02T02:00:00Z,m,0,3600000000000\n,,0,1970-01-02T03:00:00Z,m,0,3600000000000\n,,0,1970-01-02T04:00:00Z,m,0,3600000000000\n,,0,1970-01-02T05:00:00Z,m,0,3600000000000\n,,0,1970-01-02T06:00:00Z,m,0,3600000000000\n,,0,1970-01-02T07:00:00Z,m,0,3600000000000\n,,0,1970-01-02T08:00:00Z,m,0,3600000000000\n,,0,1970-01-02T09:00:00Z,m,0,3600000000000\n,,0,1970-01-02T10:00:00Z,m,0,3600000000000\n,,0,1970-01-02T11:00:00Z,m,0,3600000000000\n,,0,1970-01-02T12:00:00Z,m,0,3600000000000\n,,0,1970-01-02T13:00:00Z,m,0,3600000000000\n,,0,1970-01-02T14:00:00Z,m,0,3600000000000\n,,0,1970-01-02T15:00:00Z,m,0,3600000000000\n,,0,1970-01-02T16:00:00Z,m,0,3600000000000\n,,0,1970-01-02T17:00:00Z,m,0,3600000000000\n,,0,1970-01-02T18:00:00Z,m,0,3600000000000\n,,0,1970-01-02T19:00:00Z,m,0,3600000000000\n,,0,1970-01-02T20:00:00Z,m,0,3600000000000\n,,0,1970-01-02T21:00:00Z,m,0,3600000000000\n,,0,1970-01-02T22:00:00Z,m,0,3600000000000\n,,0,1970-01-02T23:00:00Z,m,0,3600000000000\n,,0,1970-01-03T00:00:00Z,m,0,3600000000000\n,,0,1970-01-03T01:00:00Z,m,0,3600000000000\n,,0,1970-01-03T02:00:00Z,m,0,3600000000000\n,,0,1970-01-03T03:00:00Z,m,0,3600000000000\n,,0,1970-01-03T04:00:00Z,m,0,3600000000000\n,,0,1970-01-03T05:00:00Z,m,0,3600000000000\n,,0,1970-01-03T06:00:00Z,m,0,3600000000000\n,,0,1970-01-03T07:00:00Z,m,0,3600000000000\n,,0,1970-01-03T08:00:00Z,m,0,3600000000000\n,,0,1970-01-03T09:00:00Z,m,0,3600000000000\n,,0,1970-01-03T10:00:00Z,m,0,3600000000000\n,,0,1970-01-03T11:00:00Z,m,0,3600000000000\n,,0,1970-01-03T12:00:00Z,m,0,3600000000000\n,,0,1970-01-03T13:00:00Z,m,0,3600000000000\n,,0,1970-01-03T14:00:00Z,m,0,3600000000000\n,,0,1970-01-03T15:00:00Z,m,0,3600000000000\n,,0,1970-01-03T16:00:00Z,m,0,3600000000000\n,,0,1970-01-03T17:00:00Z,m,0,3600000000000\n,,0,1970-01-03T18:00:00Z,m,0,3600000000000\n,,0,1970-01-03T19:00:00Z,m,0,3600000000000\n,,0,1970-01-03T20:00:00Z,m,0,3600000000000\n,,0,1970-01-03T21:00:00Z,m,0,3600000000000\n,,0,1970-01-03T22:00:00Z,m,0,3600000000000\n,,0,1970-01-03T23:00:00Z,m,0,3600000000000\n,,0,1970-01-04T00:00:00Z,m,0,3600000000000\n,,0,1970-01-04T01:00:00Z,m,0,3600000000000\n,,0,1970-01-04T02:00:00Z,m,0,3600000000000\n,,0,1970-01-04T03:00:00Z,m,0,3600000000000\n,,0,1970-01-04T04:00:00Z,m,0,3600000000000\n,,0,1970-01-04T05:00:00Z,m,0,3600000000000\n,,0,1970-01-04T06:00:00Z,m,0,3600000000000\n,,0,1970-01-04T07:00:00Z,m,0,3600000000000\n,,0,1970-01-04T08:00:00Z,m,0,3600000000000\n,,0,1970-01-04T09:00:00Z,m,0,3600000000000\n,,0,1970-01-04T10:00:00Z,m,0,3600000000000\n,,0,1970-01-04T11:00:00Z,m,0,3600000000000\n,,0,1970-01-04T12:00:00Z,m,0,3600000000000\n,,0,1970-01-04T13:00:00Z,m,0,3600000000000\n,,0,1970-01-04T14:00:00Z,m,0,3600000000000\n,,0,1970-01-04T15:00:00Z,m,0,3600000000000\n,,0,1970-01-04T16:00:00Z,m,0,3600000000000\n,,0,1970-01-04T17:00:00Z,m,0,3600000000000\n,,0,1970-01-04T18:00:00Z,m,0,3600000000000\n,,0,1970-01-04T19:00:00Z,m,0,3600000000000\n,,0,1970-01-04T20:00:00Z,m,0,3600000000000\n,,0,1970-01-04T21:00:00Z,m,0,3600000000000\n,,0,1970-01-04T22:00:00Z,m,0,3600000000000\n,,0,1970-01-04T23:00:00Z,m,0,3600000000000\n,,0,1970-01-05T00:00:00Z,m,0,3600000000000\n,,0,1970-01-05T01:00:00Z,m,0,3600000000000\n,,0,1970-01-05T02:00:00Z,m,0,3600000000000\n,,0,1970-01-05T03:00:00Z,m,0,3600000000000\n,,0,1970-01-05T04:00:00Z,m,0,3600000000000\n,,0,1970-01-05T05:00:00Z,m,0,3600000000000\n,,0,1970-01-05T06:00:00Z,m,0,3600000000000\n,,0,1970-01-05T07:00:00Z,m,0,3600000000000\n,,0,1970-01-05T08:00:00Z,m,0,3600000000000\n,,0,1970-01-05T09:00:00Z,m,0,3600000000000\n,,0,1970-01-05T10:00:00Z,m,0,3600000000000\n,,0,1970-01-05T11:00:00Z,m,0,3600000000000\n,,0,1970-01-05T12:00:00Z,m,0,3600000000000\n,,0,1970-01-05T13:00:00Z,m,0,3600000000000\n,,0,1970-01-05T14:00:00Z,m,0,3600000000000\n,,0,1970-01-05T15:00:00Z,m,0,3600000000000\n,,0,1970-01-05T16:00:00Z,m,0,3600000000000\n,,0,1970-01-05T17:00:00Z,m,0,3600000000000\n,,0,1970-01-05T18:00:00Z,m,0,3600000000000\n,,0,1970-01-05T19:00:00Z,m,0,3600000000000\n,,0,1970-01-05T20:00:00Z,m,0,3600000000000\n,,0,1970-01-05T21:00:00Z,m,0,3600000000000\n,,0,1970-01-05T22:00:00Z,m,0,3600000000000\n,,0,1970-01-05T23:00:00Z,m,0,3600000000000\n,,0,1970-01-06T00:00:00Z,m,0,3600000000000\n,,0,1970-01-06T01:00:00Z,m,0,3600000000000\n,,0,1970-01-06T02:00:00Z,m,0,3600000000000\n,,0,1970-01-06T03:00:00Z,m,0,3600000000000\n,,0,1970-01-06T04:00:00Z,m,0,3600000000000\n,,0,1970-01-06T05:00:00Z,m,0,3600000000000\n,,0,1970-01-06T06:00:00Z,m,0,3600000000000\n,,0,1970-01-06T07:00:00Z,m,0,3600000000000\n,,0,1970-01-06T08:00:00Z,m,0,3600000000000\n,,0,1970-01-06T09:00:00Z,m,0,3600000000000\n,,0,1970-01-06T10:00:00Z,m,0,3600000000000\n,,0,1970-01-06T11:00:00Z,m,0,3600000000000\n,,0,1970-01-06T12:00:00Z,m,0,3600000000000\n,,0,1970-01-06T13:00:00Z,m,0,3600000000000\n,,0,1970-01-06T14:00:00Z,m,0,3600000000000\n,,0,1970-01-06T15:00:00Z,m,0,3600000000000\n,,0,1970-01-06T16:00:00Z,m,0,3600000000000\n,,0,1970-01-06T17:00:00Z,m,0,3600000000000\n,,0,1970-01-06T18:00:00Z,m,0,3600000000000\n,,0,1970-01-06T19:00:00Z,m,0,3600000000000\n,,0,1970-01-06T20:00:00Z,m,0,3600000000000\n,,0,1970-01-06T21:00:00Z,m,0,3600000000000\n,,0,1970-01-06T22:00:00Z,m,0,3600000000000\n,,0,1970-01-06T23:00:00Z,m,0,3600000000000\n,,0,1970-01-07T00:00:00Z,m,0,3600000000000\n,,0,1970-01-07T01:00:00Z,m,0,3600000000000\n,,0,1970-01-07T02:00:00Z,m,0,3600000000000\n,,0,1970-01-07T03:00:00Z,m,0,3600000000000\n,,0,1970-01-07T04:00:00Z,m,0,3600000000000\n,,0,1970-01-07T05:00:00Z,m,0,3600000000000\n,,0,1970-01-07T06:00:00Z,m,0,3600000000000\n,,0,1970-01-07T07:00:00Z,m,0,3600000000000\n,,0,1970-01-07T08:00:00Z,m,0,3600000000000\n,,0,1970-01-07T09:00:00Z,m,0,3600000000000\n,,0,1970-01-07T10:00:00Z,m,0,3600000000000\n,,0,1970-01-07T11:00:00Z,m,0,3600000000000\n,,0,1970-01-07T12:00:00Z,m,0,3600000000000\n,,0,1970-01-07T13:00:00Z,m,0,3600000000000\n,,0,1970-01-07T14:00:00Z,m,0,3600000000000\n,,0,1970-01-07T15:00:00Z,m,0,3600000000000\n,,0,1970-01-07T16:00:00Z,m,0,3600000000000\n,,0,1970-01-07T17:00:00Z,m,0,3600000000000\n,,0,1970-01-07T18:00:00Z,m,0,3600000000000\n,,0,1970-01-07T19:00:00Z,m,0,3600000000000\n,,0,1970-01-07T20:00:00Z,m,0,3600000000000\n,,0,1970-01-07T21:00:00Z,m,0,3600000000000\n,,0,1970-01-07T22:00:00Z,m,0,3600000000000\n,,0,1970-01-07T23:00:00Z,m,0,3600000000000\n,,1,1970-01-01T01:00:00Z,m,1,3600000000000\n,,1,1970-01-01T02:00:00Z,m,1,3600000000000\n,,1,1970-01-01T03:00:00Z,m,1,3600000000000\n,,1,1970-01-01T04:00:00Z,m,1,3600000000000\n,,1,1970-01-01T05:00:00Z,m,1,3600000000000\n,,1,1970-01-01T06:00:00Z,m,1,3600000000000\n,,1,1970-01-01T07:00:00Z,m,1,3600000000000\n,,1,1970-01-01T08:00:00Z,m,1,3600000000000\n,,1,1970-01-01T09:00:00Z,m,1,3600000000000\n,,1,1970-01-01T10:00:00Z,m,1,3600000000000\n,,1,1970-01-01T11:00:00Z,m,1,3600000000000\n,,1,1970-01-01T12:00:00Z,m,1,3600000000000\n,,1,1970-01-01T13:00:00Z,m,1,3600000000000\n,,1,1970-01-01T14:00:00Z,m,1,3600000000000\n,,1,1970-01-01T15:00:00Z,m,1,3600000000000\n,,1,1970-01-01T16:00:00Z,m,1,3600000000000\n,,1,1970-01-01T17:00:00Z,m,1,3600000000000\n,,1,1970-01-01T18:00:00Z,m,1,3600000000000\n,,1,1970-01-01T19:00:00Z,m,1,3600000000000\n,,1,1970-01-01T20:00:00Z,m,1,3600000000000\n,,1,1970-01-01T21:00:00Z,m,1,3600000000000\n,,1,1970-01-01T22:00:00Z,m,1,3600000000000\n,,1,1970-01-01T23:00:00Z,m,1,3600000000000\n,,1,1970-01-02T00:00:00Z,m,1,3600000000000\n,,1,1970-01-02T01:00:00Z,m,1,3600000000000\n,,1,1970-01-02T02:00:00Z,m,1,3600000000000\n,,1,1970-01-02T03:00:00Z,m,1,3600000000000\n,,1,1970-01-02T04:00:00Z,m,1,3600000000000\n,,1,1970-01-02T05:00:00Z,m,1,3600000000000\n,,1,1970-01-02T06:00:00Z,m,1,3600000000000\n,,1,1970-01-02T07:00:00Z,m,1,3600000000000\n,,1,1970-01-02T08:00:00Z,m,1,3600000000000\n,,1,1970-01-02T09:00:00Z,m,1,3600000000000\n,,1,1970-01-02T10:00:00Z,m,1,3600000000000\n,,1,1970-01-02T11:00:00Z,m,1,3600000000000\n,,1,1970-01-02T12:00:00Z,m,1,3600000000000\n,,1,1970-01-02T13:00:00Z,m,1,3600000000000\n,,1,1970-01-02T14:00:00Z,m,1,3600000000000\n,,1,1970-01-02T15:00:00Z,m,1,3600000000000\n,,1,1970-01-02T16:00:00Z,m,1,3600000000000\n,,1,1970-01-02T17:00:00Z,m,1,3600000000000\n,,1,1970-01-02T18:00:00Z,m,1,3600000000000\n,,1,1970-01-02T19:00:00Z,m,1,3600000000000\n,,1,1970-01-02T20:00:00Z,m,1,3600000000000\n,,1,1970-01-02T21:00:00Z,m,1,3600000000000\n,,1,1970-01-02T22:00:00Z,m,1,3600000000000\n,,1,1970-01-02T23:00:00Z,m,1,3600000000000\n,,1,1970-01-03T00:00:00Z,m,1,3600000000000\n,,1,1970-01-03T01:00:00Z,m,1,3600000000000\n,,1,1970-01-03T02:00:00Z,m,1,3600000000000\n,,1,1970-01-03T03:00:00Z,m,1,3600000000000\n,,1,1970-01-03T04:00:00Z,m,1,3600000000000\n,,1,1970-01-03T05:00:00Z,m,1,3600000000000\n,,1,1970-01-03T06:00:00Z,m,1,3600000000000\n,,1,1970-01-03T07:00:00Z,m,1,3600000000000\n,,1,1970-01-03T08:00:00Z,m,1,3600000000000\n,,1,1970-01-03T09:00:00Z,m,1,3600000000000\n,,1,1970-01-03T10:00:00Z,m,1,3600000000000\n,,1,1970-01-03T11:00:00Z,m,1,3600000000000\n,,1,1970-01-03T12:00:00Z,m,1,3600000000000\n,,1,1970-01-03T13:00:00Z,m,1,3600000000000\n,,1,1970-01-03T14:00:00Z,m,1,3600000000000\n,,1,1970-01-03T15:00:00Z,m,1,3600000000000\n,,1,1970-01-03T16:00:00Z,m,1,3600000000000\n,,1,1970-01-03T17:00:00Z,m,1,3600000000000\n,,1,1970-01-03T18:00:00Z,m,1,3600000000000\n,,1,1970-01-03T19:00:00Z,m,1,3600000000000\n,,1,1970-01-03T20:00:00Z,m,1,3600000000000\n,,1,1970-01-03T21:00:00Z,m,1,3600000000000\n,,1,1970-01-03T22:00:00Z,m,1,3600000000000\n,,1,1970-01-03T23:00:00Z,m,1,3600000000000\n,,1,1970-01-04T00:00:00Z,m,1,3600000000000\n,,1,1970-01-04T01:00:00Z,m,1,3600000000000\n,,1,1970-01-04T02:00:00Z,m,1,3600000000000\n,,1,1970-01-04T03:00:00Z,m,1,3600000000000\n,,1,1970-01-04T04:00:00Z,m,1,3600000000000\n,,1,1970-01-04T05:00:00Z,m,1,3600000000000\n,,1,1970-01-04T06:00:00Z,m,1,3600000000000\n,,1,1970-01-04T07:00:00Z,m,1,3600000000000\n,,1,1970-01-04T08:00:00Z,m,1,3600000000000\n,,1,1970-01-04T09:00:00Z,m,1,3600000000000\n,,1,1970-01-04T10:00:00Z,m,1,3600000000000\n,,1,1970-01-04T11:00:00Z,m,1,3600000000000\n,,1,1970-01-04T12:00:00Z,m,1,3600000000000\n,,1,1970-01-04T13:00:00Z,m,1,3600000000000\n,,1,1970-01-04T14:00:00Z,m,1,3600000000000\n,,1,1970-01-04T15:00:00Z,m,1,3600000000000\n,,1,1970-01-04T16:00:00Z,m,1,3600000000000\n,,1,1970-01-04T17:00:00Z,m,1,3600000000000\n,,1,1970-01-04T18:00:00Z,m,1,3600000000000\n,,1,1970-01-04T19:00:00Z,m,1,3600000000000\n,,1,1970-01-04T20:00:00Z,m,1,3600000000000\n,,1,1970-01-04T21:00:00Z,m,1,3600000000000\n,,1,1970-01-04T22:00:00Z,m,1,3600000000000\n,,1,1970-01-04T23:00:00Z,m,1,3600000000000\n,,1,1970-01-05T00:00:00Z,m,1,3600000000000\n,,1,1970-01-05T01:00:00Z,m,1,3600000000000\n,,1,1970-01-05T02:00:00Z,m,1,3600000000000\n,,1,1970-01-05T03:00:00Z,m,1,3600000000000\n,,1,1970-01-05T04:00:00Z,m,1,3600000000000\n,,1,1970-01-05T05:00:00Z,m,1,3600000000000\n,,1,1970-01-05T06:00:00Z,m,1,3600000000000\n,,1,1970-01-05T07:00:00Z,m,1,3600000000000\n,,1,1970-01-05T08:00:00Z,m,1,3600000000000\n,,1,1970-01-05T09:00:00Z,m,1,3600000000000\n,,1,1970-01-05T10:00:00Z,m,1,3600000000000\n,,1,1970-01-05T11:00:00Z,m,1,3600000000000\n,,1,1970-01-05T12:00:00Z,m,1,3600000000000\n,,1,1970-01-05T13:00:00Z,m,1,3600000000000\n,,1,1970-01-05T14:00:00Z,m,1,3600000000000\n,,1,1970-01-05T15:00:00Z,m,1,3600000000000\n,,1,1970-01-05T16:00:00Z,m,1,3600000000000\n,,1,1970-01-05T17:00:00Z,m,1,3600000000000\n,,1,1970-01-05T18:00:00Z,m,1,3600000000000\n,,1,1970-01-05T19:00:00Z,m,1,3600000000000\n,,1,1970-01-05T20:00:00Z,m,1,3600000000000\n,,1,1970-01-05T21:00:00Z,m,1,3600000000000\n,,1,1970-01-05T22:00:00Z,m,1,3600000000000\n,,1,1970-01-05T23:00:00Z,m,1,3600000000000\n,,1,1970-01-06T00:00:00Z,m,1,3600000000000\n,,1,1970-01-06T01:00:00Z,m,1,3600000000000\n,,1,1970-01-06T02:00:00Z,m,1,3600000000000\n,,1,1970-01-06T03:00:00Z,m,1,3600000000000\n,,1,1970-01-06T04:00:00Z,m,1,3600000000000\n,,1,1970-01-06T05:00:00Z,m,1,3600000000000\n,,1,1970-01-06T06:00:00Z,m,1,3600000000000\n,,1,1970-01-06T07:00:00Z,m,1,3600000000000\n,,1,1970-01-06T08:00:00Z,m,1,3600000000000\n,,1,1970-01-06T09:00:00Z,m,1,3600000000000\n,,1,1970-01-06T10:00:00Z,m,1,3600000000000\n,,1,1970-01-06T11:00:00Z,m,1,3600000000000\n,,1,1970-01-06T12:00:00Z,m,1,3600000000000\n,,1,1970-01-06T13:00:00Z,m,1,3600000000000\n,,1,1970-01-06T14:00:00Z,m,1,3600000000000\n,,1,1970-01-06T15:00:00Z,m,1,3600000000000\n,,1,1970-01-06T16:00:00Z,m,1,3600000000000\n,,1,1970-01-06T17:00:00Z,m,1,3600000000000\n,,1,1970-01-06T18:00:00Z,m,1,3600000000000\n,,1,1970-01-06T19:00:00Z,m,1,3600000000000\n,,1,1970-01-06T20:00:00Z,m,1,3600000000000\n,,1,1970-01-06T21:00:00Z,m,1,3600000000000\n,,1,1970-01-06T22:00:00Z,m,1,3600000000000\n,,1,1970-01-06T23:00:00Z,m,1,3600000000000\n,,1,1970-01-07T00:00:00Z,m,1,3600000000000\n,,1,1970-01-07T01:00:00Z,m,1,3600000000000\n,,1,1970-01-07T02:00:00Z,m,1,3600000000000\n,,1,1970-01-07T03:00:00Z,m,1,3600000000000\n,,1,1970-01-07T04:00:00Z,m,1,3600000000000\n,,1,1970-01-07T05:00:00Z,m,1,3600000000000\n,,1,1970-01-07T06:00:00Z,m,1,3600000000000\n,,1,1970-01-07T07:00:00Z,m,1,3600000000000\n,,1,1970-01-07T08:00:00Z,m,1,3600000000000\n,,1,1970-01-07T09:00:00Z,m,1,3600000000000\n,,1,1970-01-07T10:00:00Z,m,1,3600000000000\n,,1,1970-01-07T11:00:00Z,m,1,3600000000000\n,,1,1970-01-07T12:00:00Z,m,1,3600000000000\n,,1,1970-01-07T13:00:00Z,m,1,3600000000000\n,,1,1970-01-07T14:00:00Z,m,1,3600000000000\n,,1,1970-01-07T15:00:00Z,m,1,3600000000000\n,,1,1970-01-07T16:00:00Z,m,1,3600000000000\n,,1,1970-01-07T17:00:00Z,m,1,3600000000000\n,,1,1970-01-07T18:00:00Z,m,1,3600000000000\n,,1,1970-01-07T19:00:00Z,m,1,3600000000000\n,,1,1970-01-07T20:00:00Z,m,1,3600000000000\n,,1,1970-01-07T21:00:00Z,m,1,3600000000000\n,,1,1970-01-07T22:00:00Z,m,1,3600000000000\n,,1,1970-01-07T23:00:00Z,m,1,3600000000000\n\"\n\n// SELECT elapsed(f) FROM m GROUP BY *\nt_elapsed = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")\n\t|> elapsed(unit: 1ns)\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\", \"_value\"])\n\t|> rename(columns: {_time: \"time\"})\n\ntest _elapsed = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_elapsed,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   347,
					},
					File:   "elapsed_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "elapsed_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   347,
						},
						File:   "elapsed_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   688,
					},
					File:   "elapsed_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,elapsed\n,,0,1970-01-01T01:00:00Z,m,0,3600000000000\n,,0,1970-01-01T02:00:00Z,m,0,3600000000000\n,,0,1970-01-01T03:00:00Z,m,0,3600000000000\n,,0,1970-01-01T04:00:00Z,m,0,3600000000000\n,,0,1970-01-01T05:00:00Z,m,0,3600000000000\n,,0,1970-01-01T06:00:00Z,m,0,3600000000000\n,,0,1970-01-01T07:00:00Z,m,0,3600000000000\n,,0,1970-01-01T08:00:00Z,m,0,3600000000000\n,,0,1970-01-01T09:00:00Z,m,0,3600000000000\n,,0,1970-01-01T10:00:00Z,m,0,3600000000000\n,,0,1970-01-01T11:00:00Z,m,0,3600000000000\n,,0,1970-01-01T12:00:00Z,m,0,3600000000000\n,,0,1970-01-01T13:00:00Z,m,0,3600000000000\n,,0,1970-01-01T14:00:00Z,m,0,3600000000000\n,,0,1970-01-01T15:00:00Z,m,0,3600000000000\n,,0,1970-01-01T16:00:00Z,m,0,3600000000000\n,,0,1970-01-01T17:00:00Z,m,0,3600000000000\n,,0,1970-01-01T18:00:00Z,m,0,3600000000000\n,,0,1970-01-01T19:00:00Z,m,0,3600000000000\n,,0,1970-01-01T20:00:00Z,m,0,3600000000000\n,,0,1970-01-01T21:00:00Z,m,0,3600000000000\n,,0,1970-01-01T22:00:00Z,m,0,3600000000000\n,,0,1970-01-01T23:00:00Z,m,0,3600000000000\n,,0,1970-01-02T00:00:00Z,m,0,3600000000000\n,,0,1970-01-02T01:00:00Z,m,0,3600000000000\n,,0,1970-01-02T02:00:00Z,m,0,3600000000000\n,,0,1970-01-02T03:00:00Z,m,0,3600000000000\n,,0,1970-01-02T04:00:00Z,m,0,3600000000000\n,,0,1970-01-02T05:00:00Z,m,0,3600000000000\n,,0,1970-01-02T06:00:00Z,m,0,3600000000000\n,,0,1970-01-02T07:00:00Z,m,0,3600000000000\n,,0,1970-01-02T08:00:00Z,m,0,3600000000000\n,,0,1970-01-02T09:00:00Z,m,0,3600000000000\n,,0,1970-01-02T10:00:00Z,m,0,3600000000000\n,,0,1970-01-02T11:00:00Z,m,0,3600000000000\n,,0,1970-01-02T12:00:00Z,m,0,3600000000000\n,,0,1970-01-02T13:00:00Z,m,0,3600000000000\n,,0,1970-01-02T14:00:00Z,m,0,3600000000000\n,,0,1970-01-02T15:00:00Z,m,0,3600000000000\n,,0,1970-01-02T16:00:00Z,m,0,3600000000000\n,,0,1970-01-02T17:00:00Z,m,0,3600000000000\n,,0,1970-01-02T18:00:00Z,m,0,3600000000000\n,,0,1970-01-02T19:00:00Z,m,0,3600000000000\n,,0,1970-01-02T20:00:00Z,m,0,3600000000000\n,,0,1970-01-02T21:00:00Z,m,0,3600000000000\n,,0,1970-01-02T22:00:00Z,m,0,3600000000000\n,,0,1970-01-02T23:00:00Z,m,0,3600000000000\n,,0,1970-01-03T00:00:00Z,m,0,3600000000000\n,,0,1970-01-03T01:00:00Z,m,0,3600000000000\n,,0,1970-01-03T02:00:00Z,m,0,3600000000000\n,,0,1970-01-03T03:00:00Z,m,0,3600000000000\n,,0,1970-01-03T04:00:00Z,m,0,3600000000000\n,,0,1970-01-03T05:00:00Z,m,0,3600000000000\n,,0,1970-01-03T06:00:00Z,m,0,3600000000000\n,,0,1970-01-03T07:00:00Z,m,0,3600000000000\n,,0,1970-01-03T08:00:00Z,m,0,3600000000000\n,,0,1970-01-03T09:00:00Z,m,0,3600000000000\n,,0,1970-01-03T10:00:00Z,m,0,3600000000000\n,,0,1970-01-03T11:00:00Z,m,0,3600000000000\n,,0,1970-01-03T12:00:00Z,m,0,3600000000000\n,,0,1970-01-03T13:00:00Z,m,0,3600000000000\n,,0,1970-01-03T14:00:00Z,m,0,3600000000000\n,,0,1970-01-03T15:00:00Z,m,0,3600000000000\n,,0,1970-01-03T16:00:00Z,m,0,3600000000000\n,,0,1970-01-03T17:00:00Z,m,0,3600000000000\n,,0,1970-01-03T18:00:00Z,m,0,3600000000000\n,,0,1970-01-03T19:00:00Z,m,0,3600000000000\n,,0,1970-01-03T20:00:00Z,m,0,3600000000000\n,,0,1970-01-03T21:00:00Z,m,0,3600000000000\n,,0,1970-01-03T22:00:00Z,m,0,3600000000000\n,,0,1970-01-03T23:00:00Z,m,0,3600000000000\n,,0,1970-01-04T00:00:00Z,m,0,3600000000000\n,,0,1970-01-04T01:00:00Z,m,0,3600000000000\n,,0,1970-01-04T02:00:00Z,m,0,3600000000000\n,,0,1970-01-04T03:00:00Z,m,0,3600000000000\n,,0,1970-01-04T04:00:00Z,m,0,3600000000000\n,,0,1970-01-04T05:00:00Z,m,0,3600000000000\n,,0,1970-01-04T06:00:00Z,m,0,3600000000000\n,,0,1970-01-04T07:00:00Z,m,0,3600000000000\n,,0,1970-01-04T08:00:00Z,m,0,3600000000000\n,,0,1970-01-04T09:00:00Z,m,0,3600000000000\n,,0,1970-01-04T10:00:00Z,m,0,3600000000000\n,,0,1970-01-04T11:00:00Z,m,0,3600000000000\n,,0,1970-01-04T12:00:00Z,m,0,3600000000000\n,,0,1970-01-04T13:00:00Z,m,0,3600000000000\n,,0,1970-01-04T14:00:00Z,m,0,3600000000000\n,,0,1970-01-04T15:00:00Z,m,0,3600000000000\n,,0,1970-01-04T16:00:00Z,m,0,3600000000000\n,,0,1970-01-04T17:00:00Z,m,0,3600000000000\n,,0,1970-01-04T18:00:00Z,m,0,3600000000000\n,,0,1970-01-04T19:00:00Z,m,0,3600000000000\n,,0,1970-01-04T20:00:00Z,m,0,3600000000000\n,,0,1970-01-04T21:00:00Z,m,0,3600000000000\n,,0,1970-01-04T22:00:00Z,m,0,3600000000000\n,,0,1970-01-04T23:00:00Z,m,0,3600000000000\n,,0,1970-01-05T00:00:00Z,m,0,3600000000000\n,,0,1970-01-05T01:00:00Z,m,0,3600000000000\n,,0,1970-01-05T02:00:00Z,m,0,3600000000000\n,,0,1970-01-05T03:00:00Z,m,0,3600000000000\n,,0,1970-01-05T04:00:00Z,m,0,3600000000000\n,,0,1970-01-05T05:00:00Z,m,0,3600000000000\n,,0,1970-01-05T06:00:00Z,m,0,3600000000000\n,,0,1970-01-05T07:00:00Z,m,0,3600000000000\n,,0,1970-01-05T08:00:00Z,m,0,3600000000000\n,,0,1970-01-05T09:00:00Z,m,0,3600000000000\n,,0,1970-01-05T10:00:00Z,m,0,3600000000000\n,,0,1970-01-05T11:00:00Z,m,0,3600000000000\n,,0,1970-01-05T12:00:00Z,m,0,3600000000000\n,,0,1970-01-05T13:00:00Z,m,0,3600000000000\n,,0,1970-01-05T14:00:00Z,m,0,3600000000000\n,,0,1970-01-05T15:00:00Z,m,0,3600000000000\n,,0,1970-01-05T16:00:00Z,m,0,3600000000000\n,,0,1970-01-05T17:00:00Z,m,0,3600000000000\n,,0,1970-01-05T18:00:00Z,m,0,3600000000000\n,,0,1970-01-05T19:00:00Z,m,0,3600000000000\n,,0,1970-01-05T20:00:00Z,m,0,3600000000000\n,,0,1970-01-05T21:00:00Z,m,0,3600000000000\n,,0,1970-01-05T22:00:00Z,m,0,3600000000000\n,,0,1970-01-05T23:00:00Z,m,0,3600000000000\n,,0,1970-01-06T00:00:00Z,m,0,3600000000000\n,,0,1970-01-06T01:00:00Z,m,0,3600000000000\n,,0,1970-01-06T02:00:00Z,m,0,3600000000000\n,,0,1970-01-06T03:00:00Z,m,0,3600000000000\n,,0,1970-01-06T04:00:00Z,m,0,3600000000000\n,,0,1970-01-06T05:00:00Z,m,0,3600000000000\n,,0,1970-01-06T06:00:00Z,m,0,3600000000000\n,,0,1970-01-06T07:00:00Z,m,0,3600000000000\n,,0,1970-01-06T08:00:00Z,m,0,3600000000000\n,,0,1970-01-06T09:00:00Z,m,0,3600000000000\n,,0,1970-01-06T10:00:00Z,m,0,3600000000000\n,,0,1970-01-06T11:00:00Z,m,0,3600000000000\n,,0,1970-01-06T12:00:00Z,m,0,3600000000000\n,,0,1970-01-06T13:00:00Z,m,0,3600000000000\n,,0,1970-01-06T14:00:00Z,m,0,3600000000000\n,,0,1970-01-06T15:00:00Z,m,0,3600000000000\n,,0,1970-01-06T16:00:00Z,m,0,3600000000000\n,,0,1970-01-06T17:00:00Z,m,0,3600000000000\n,,0,1970-01-06T18:00:00Z,m,0,3600000000000\n,,0,1970-01-06T19:00:00Z,m,0,3600000000000\n,,0,1970-01-06T20:00:00Z,m,0,3600000000000\n,,0,1970-01-06T21:00:00Z,m,0,3600000000000\n,,0,1970-01-06T22:00:00Z,m,0,3600000000000\n,,0,1970-01-06T23:00:00Z,m,0,3600000000000\n,,0,1970-01-07T00:00:00Z,m,0,3600000000000\n,,0,1970-01-07T01:00:00Z,m,0,3600000000000\n,,0,1970-01-07T02:00:00Z,m,0,3600000000000\n,,0,1970-01-07T03:00:00Z,m,0,3600000000000\n,,0,1970-01-07T04:00:00Z,m,0,3600000000000\n,,0,1970-01-07T05:00:00Z,m,0,3600000000000\n,,0,1970-01-07T06:00:00Z,m,0,3600000000000\n,,0,1970-01-07T07:00:00Z,m,0,3600000000000\n,,0,1970-01-07T08:00:00Z,m,0,3600000000000\n,,0,1970-01-07T09:00:00Z,m,0,3600000000000\n,,0,1970-01-07T10:00:00Z,m,0,3600000000000\n,,0,1970-01-07T11:00:00Z,m,0,3600000000000\n,,0,1970-01-07T12:00:00Z,m,0,3600000000000\n,,0,1970-01-07T13:00:00Z,m,0,3600000000000\n,,0,1970-01-07T14:00:00Z,m,0,3600000000000\n,,0,1970-01-07T15:00:00Z,m,0,3600000000000\n,,0,1970-01-07T16:00:00Z,m,0,3600000000000\n,,0,1970-01-07T17:00:00Z,m,0,3600000000000\n,,0,1970-01-07T18:00:00Z,m,0,3600000000000\n,,0,1970-01-07T19:00:00Z,m,0,3600000000000\n,,0,1970-01-07T20:00:00Z,m,0,3600000000000\n,,0,1970-01-07T21:00:00Z,m,0,3600000000000\n,,0,1970-01-07T22:00:00Z,m,0,3600000000000\n,,0,1970-01-07T23:00:00Z,m,0,3600000000000\n,,1,1970-01-01T01:00:00Z,m,1,3600000000000\n,,1,1970-01-01T02:00:00Z,m,1,3600000000000\n,,1,1970-01-01T03:00:00Z,m,1,3600000000000\n,,1,1970-01-01T04:00:00Z,m,1,3600000000000\n,,1,1970-01-01T05:00:00Z,m,1,3600000000000\n,,1,1970-01-01T06:00:00Z,m,1,3600000000000\n,,1,1970-01-01T07:00:00Z,m,1,3600000000000\n,,1,1970-01-01T08:00:00Z,m,1,3600000000000\n,,1,1970-01-01T09:00:00Z,m,1,3600000000000\n,,1,1970-01-01T10:00:00Z,m,1,3600000000000\n,,1,1970-01-01T11:00:00Z,m,1,3600000000000\n,,1,1970-01-01T12:00:00Z,m,1,3600000000000\n,,1,1970-01-01T13:00:00Z,m,1,3600000000000\n,,1,1970-01-01T14:00:00Z,m,1,3600000000000\n,,1,1970-01-01T15:00:00Z,m,1,3600000000000\n,,1,1970-01-01T16:00:00Z,m,1,3600000000000\n,,1,1970-01-01T17:00:00Z,m,1,3600000000000\n,,1,1970-01-01T18:00:00Z,m,1,3600000000000\n,,1,1970-01-01T19:00:00Z,m,1,3600000000000\n,,1,1970-01-01T20:00:00Z,m,1,3600000000000\n,,1,1970-01-01T21:00:00Z,m,1,3600000000000\n,,1,1970-01-01T22:00:00Z,m,1,3600000000000\n,,1,1970-01-01T23:00:00Z,m,1,3600000000000\n,,1,1970-01-02T00:00:00Z,m,1,3600000000000\n,,1,1970-01-02T01:00:00Z,m,1,3600000000000\n,,1,1970-01-02T02:00:00Z,m,1,3600000000000\n,,1,1970-01-02T03:00:00Z,m,1,3600000000000\n,,1,1970-01-02T04:00:00Z,m,1,3600000000000\n,,1,1970-01-02T05:00:00Z,m,1,3600000000000\n,,1,1970-01-02T06:00:00Z,m,1,3600000000000\n,,1,1970-01-02T07:00:00Z,m,1,3600000000000\n,,1,1970-01-02T08:00:00Z,m,1,3600000000000\n,,1,1970-01-02T09:00:00Z,m,1,3600000000000\n,,1,1970-01-02T10:00:00Z,m,1,3600000000000\n,,1,1970-01-02T11:00:00Z,m,1,3600000000000\n,,1,1970-01-02T12:00:00Z,m,1,3600000000000\n,,1,1970-01-02T13:00:00Z,m,1,3600000000000\n,,1,1970-01-02T14:00:00Z,m,1,3600000000000\n,,1,1970-01-02T15:00:00Z,m,1,3600000000000\n,,1,1970-01-02T16:00:00Z,m,1,3600000000000\n,,1,1970-01-02T17:00:00Z,m,1,3600000000000\n,,1,1970-01-02T18:00:00Z,m,1,3600000000000\n,,1,1970-01-02T19:00:00Z,m,1,3600000000000\n,,1,1970-01-02T20:00:00Z,m,1,3600000000000\n,,1,1970-01-02T21:00:00Z,m,1,3600000000000\n,,1,1970-01-02T22:00:00Z,m,1,3600000000000\n,,1,1970-01-02T23:00:00Z,m,1,3600000000000\n,,1,1970-01-03T00:00:00Z,m,1,3600000000000\n,,1,1970-01-03T01:00:00Z,m,1,3600000000000\n,,1,1970-01-03T02:00:00Z,m,1,3600000000000\n,,1,1970-01-03T03:00:00Z,m,1,3600000000000\n,,1,1970-01-03T04:00:00Z,m,1,3600000000000\n,,1,1970-01-03T05:00:00Z,m,1,3600000000000\n,,1,1970-01-03T06:00:00Z,m,1,3600000000000\n,,1,1970-01-03T07:00:00Z,m,1,3600000000000\n,,1,1970-01-03T08:00:00Z,m,1,3600000000000\n,,1,1970-01-03T09:00:00Z,m,1,3600000000000\n,,1,1970-01-03T10:00:00Z,m,1,3600000000000\n,,1,1970-01-03T11:00:00Z,m,1,3600000000000\n,,1,1970-01-03T12:00:00Z,m,1,3600000000000\n,,1,1970-01-03T13:00:00Z,m,1,3600000000000\n,,1,1970-01-03T14:00:00Z,m,1,3600000000000\n,,1,1970-01-03T15:00:00Z,m,1,3600000000000\n,,1,1970-01-03T16:00:00Z,m,1,3600000000000\n,,1,1970-01-03T17:00:00Z,m,1,3600000000000\n,,1,1970-01-03T18:00:00Z,m,1,3600000000000\n,,1,1970-01-03T19:00:00Z,m,1,3600000000000\n,,1,1970-01-03T20:00:00Z,m,1,3600000000000\n,,1,1970-01-03T21:00:00Z,m,1,3600000000000\n,,1,1970-01-03T22:00:00Z,m,1,3600000000000\n,,1,1970-01-03T23:00:00Z,m,1,3600000000000\n,,1,1970-01-04T00:00:00Z,m,1,3600000000000\n,,1,1970-01-04T01:00:00Z,m,1,3600000000000\n,,1,1970-01-04T02:00:00Z,m,1,3600000000000\n,,1,1970-01-04T03:00:00Z,m,1,3600000000000\n,,1,1970-01-04T04:00:00Z,m,1,3600000000000\n,,1,1970-01-04T05:00:00Z,m,1,3600000000000\n,,1,1970-01-04T06:00:00Z,m,1,3600000000000\n,,1,1970-01-04T07:00:00Z,m,1,3600000000000\n,,1,1970-01-04T08:00:00Z,m,1,3600000000000\n,,1,1970-01-04T09:00:00Z,m,1,3600000000000\n,,1,1970-01-04T10:00:00Z,m,1,3600000000000\n,,1,1970-01-04T11:00:00Z,m,1,3600000000000\n,,1,1970-01-04T12:00:00Z,m,1,3600000000000\n,,1,1970-01-04T13:00:00Z,m,1,3600000000000\n,,1,1970-01-04T14:00:00Z,m,1,3600000000000\n,,1,1970-01-04T15:00:00Z,m,1,3600000000000\n,,1,1970-01-04T16:00:00Z,m,1,3600000000000\n,,1,1970-01-04T17:00:00Z,m,1,3600000000000\n,,1,1970-01-04T18:00:00Z,m,1,3600000000000\n,,1,1970-01-04T19:00:00Z,m,1,3600000000000\n,,1,1970-01-04T20:00:00Z,m,1,3600000000000\n,,1,1970-01-04T21:00:00Z,m,1,3600000000000\n,,1,1970-01-04T22:00:00Z,m,1,3600000000000\n,,1,1970-01-04T23:00:00Z,m,1,3600000000000\n,,1,1970-01-05T00:00:00Z,m,1,3600000000000\n,,1,1970-01-05T01:00:00Z,m,1,3600000000000\n,,1,1970-01-05T02:00:00Z,m,1,3600000000000\n,,1,1970-01-05T03:00:00Z,m,1,3600000000000\n,,1,1970-01-05T04:00:00Z,m,1,3600000000000\n,,1,1970-01-05T05:00:00Z,m,1,3600000000000\n,,1,1970-01-05T06:00:00Z,m,1,3600000000000\n,,1,1970-01-05T07:00:00Z,m,1,3600000000000\n,,1,1970-01-05T08:00:00Z,m,1,3600000000000\n,,1,1970-01-05T09:00:00Z,m,1,3600000000000\n,,1,1970-01-05T10:00:00Z,m,1,3600000000000\n,,1,1970-01-05T11:00:00Z,m,1,3600000000000\n,,1,1970-01-05T12:00:00Z,m,1,3600000000000\n,,1,1970-01-05T13:00:00Z,m,1,3600000000000\n,,1,1970-01-05T14:00:00Z,m,1,3600000000000\n,,1,1970-01-05T15:00:00Z,m,1,3600000000000\n,,1,1970-01-05T16:00:00Z,m,1,3600000000000\n,,1,1970-01-05T17:00:00Z,m,1,3600000000000\n,,1,1970-01-05T18:00:00Z,m,1,3600000000000\n,,1,1970-01-05T19:00:00Z,m,1,3600000000000\n,,1,1970-01-05T20:00:00Z,m,1,3600000000000\n,,1,1970-01-05T21:00:00Z,m,1,3600000000000\n,,1,1970-01-05T22:00:00Z,m,1,3600000000000\n,,1,1970-01-05T23:00:00Z,m,1,3600000000000\n,,1,1970-01-06T00:00:00Z,m,1,3600000000000\n,,1,1970-01-06T01:00:00Z,m,1,3600000000000\n,,1,1970-01-06T02:00:00Z,m,1,3600000000000\n,,1,1970-01-06T03:00:00Z,m,1,3600000000000\n,,1,1970-01-06T04:00:00Z,m,1,3600000000000\n,,1,1970-01-06T05:00:00Z,m,1,3600000000000\n,,1,1970-01-06T06:00:00Z,m,1,3600000000000\n,,1,1970-01-06T07:00:00Z,m,1,3600000000000\n,,1,1970-01-06T08:00:00Z,m,1,3600000000000\n,,1,1970-01-06T09:00:00Z,m,1,3600000000000\n,,1,1970-01-06T10:00:00Z,m,1,3600000000000\n,,1,1970-01-06T11:00:00Z,m,1,3600000000000\n,,1,1970-01-06T12:00:00Z,m,1,3600000000000\n,,1,1970-01-06T13:00:00Z,m,1,3600000000000\n,,1,1970-01-06T14:00:00Z,m,1,3600000000000\n,,1,1970-01-06T15:00:00Z,m,1,3600000000000\n,,1,1970-01-06T16:00:00Z,m,1,3600000000000\n,,1,1970-01-06T17:00:00Z,m,1,3600000000000\n,,1,1970-01-06T18:00:00Z,m,1,3600000000000\n,,1,1970-01-06T19:00:00Z,m,1,3600000000000\n,,1,1970-01-06T20:00:00Z,m,1,3600000000000\n,,1,1970-01-06T21:00:00Z,m,1,3600000000000\n,,1,1970-01-06T22:00:00Z,m,1,3600000000000\n,,1,1970-01-06T23:00:00Z,m,1,3600000000000\n,,1,1970-01-07T00:00:00Z,m,1,3600000000000\n,,1,1970-01-07T01:00:00Z,m,1,3600000000000\n,,1,1970-01-07T02:00:00Z,m,1,3600000000000\n,,1,1970-01-07T03:00:00Z,m,1,3600000000000\n,,1,1970-01-07T04:00:00Z,m,1,3600000000000\n,,1,1970-01-07T05:00:00Z,m,1,3600000000000\n,,1,1970-01-07T06:00:00Z,m,1,3600000000000\n,,1,1970-01-07T07:00:00Z,m,1,3600000000000\n,,1,1970-01-07T08:00:00Z,m,1,3600000000000\n,,1,1970-01-07T09:00:00Z,m,1,3600000000000\n,,1,1970-01-07T10:00:00Z,m,1,3600000000000\n,,1,1970-01-07T11:00:00Z,m,1,3600000000000\n,,1,1970-01-07T12:00:00Z,m,1,3600000000000\n,,1,1970-01-07T13:00:00Z,m,1,3600000000000\n,,1,1970-01-07T14:00:00Z,m,1,3600000000000\n,,1,1970-01-07T15:00:00Z,m,1,3600000000000\n,,1,1970-01-07T16:00:00Z,m,1,3600000000000\n,,1,1970-01-07T17:00:00Z,m,1,3600000000000\n,,1,1970-01-07T18:00:00Z,m,1,3600000000000\n,,1,1970-01-07T19:00:00Z,m,1,3600000000000\n,,1,1970-01-07T20:00:00Z,m,1,3600000000000\n,,1,1970-01-07T21:00:00Z,m,1,3600000000000\n,,1,1970-01-07T22:00:00Z,m,1,3600000000000\n,,1,1970-01-07T23:00:00Z,m,1,3600000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   349,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   349,
						},
						File:   "elapsed_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   349,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   688,
						},
						File:   "elapsed_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,elapsed\n,,0,1970-01-01T01:00:00Z,m,0,3600000000000\n,,0,1970-01-01T02:00:00Z,m,0,3600000000000\n,,0,1970-01-01T03:00:00Z,m,0,3600000000000\n,,0,1970-01-01T04:00:00Z,m,0,3600000000000\n,,0,1970-01-01T05:00:00Z,m,0,3600000000000\n,,0,1970-01-01T06:00:00Z,m,0,3600000000000\n,,0,1970-01-01T07:00:00Z,m,0,3600000000000\n,,0,1970-01-01T08:00:00Z,m,0,3600000000000\n,,0,1970-01-01T09:00:00Z,m,0,3600000000000\n,,0,1970-01-01T10:00:00Z,m,0,3600000000000\n,,0,1970-01-01T11:00:00Z,m,0,3600000000000\n,,0,1970-01-01T12:00:00Z,m,0,3600000000000\n,,0,1970-01-01T13:00:00Z,m,0,3600000000000\n,,0,1970-01-01T14:00:00Z,m,0,3600000000000\n,,0,1970-01-01T15:00:00Z,m,0,3600000000000\n,,0,1970-01-01T16:00:00Z,m,0,3600000000000\n,,0,1970-01-01T17:00:00Z,m,0,3600000000000\n,,0,1970-01-01T18:00:00Z,m,0,3600000000000\n,,0,1970-01-01T19:00:00Z,m,0,3600000000000\n,,0,1970-01-01T20:00:00Z,m,0,3600000000000\n,,0,1970-01-01T21:00:00Z,m,0,3600000000000\n,,0,1970-01-01T22:00:00Z,m,0,3600000000000\n,,0,1970-01-01T23:00:00Z,m,0,3600000000000\n,,0,1970-01-02T00:00:00Z,m,0,3600000000000\n,,0,1970-01-02T01:00:00Z,m,0,3600000000000\n,,0,1970-01-02T02:00:00Z,m,0,3600000000000\n,,0,1970-01-02T03:00:00Z,m,0,3600000000000\n,,0,1970-01-02T04:00:00Z,m,0,3600000000000\n,,0,1970-01-02T05:00:00Z,m,0,3600000000000\n,,0,1970-01-02T06:00:00Z,m,0,3600000000000\n,,0,1970-01-02T07:00:00Z,m,0,3600000000000\n,,0,1970-01-02T08:00:00Z,m,0,3600000000000\n,,0,1970-01-02T09:00:00Z,m,0,3600000000000\n,,0,1970-01-02T10:00:00Z,m,0,3600000000000\n,,0,1970-01-02T11:00:00Z,m,0,3600000000000\n,,0,1970-01-02T12:00:00Z,m,0,3600000000000\n,,0,1970-01-02T13:00:00Z,m,0,3600000000000\n,,0,1970-01-02T14:00:00Z,m,0,3600000000000\n,,0,1970-01-02T15:00:00Z,m,0,3600000000000\n,,0,1970-01-02T16:00:00Z,m,0,3600000000000\n,,0,1970-01-02T17:00:00Z,m,0,3600000000000\n,,0,1970-01-02T18:00:00Z,m,0,3600000000000\n,,0,1970-01-02T19:00:00Z,m,0,3600000000000\n,,0,1970-01-02T20:00:00Z,m,0,3600000000000\n,,0,1970-01-02T21:00:00Z,m,0,3600000000000\n,,0,1970-01-02T22:00:00Z,m,0,3600000000000\n,,0,1970-01-02T23:00:00Z,m,0,3600000000000\n,,0,1970-01-03T00:00:00Z,m,0,3600000000000\n,,0,1970-01-03T01:00:00Z,m,0,3600000000000\n,,0,1970-01-03T02:00:00Z,m,0,3600000000000\n,,0,1970-01-03T03:00:00Z,m,0,3600000000000\n,,0,1970-01-03T04:00:00Z,m,0,3600000000000\n,,0,1970-01-03T05:00:00Z,m,0,3600000000000\n,,0,1970-01-03T06:00:00Z,m,0,3600000000000\n,,0,1970-01-03T07:00:00Z,m,0,3600000000000\n,,0,1970-01-03T08:00:00Z,m,0,3600000000000\n,,0,1970-01-03T09:00:00Z,m,0,3600000000000\n,,0,1970-01-03T10:00:00Z,m,0,3600000000000\n,,0,1970-01-03T11:00:00Z,m,0,3600000000000\n,,0,1970-01-03T12:00:00Z,m,0,3600000000000\n,,0,1970-01-03T13:00:00Z,m,0,3600000000000\n,,0,1970-01-03T14:00:00Z,m,0,3600000000000\n,,0,1970-01-03T15:00:00Z,m,0,3600000000000\n,,0,1970-01-03T16:00:00Z,m,0,3600000000000\n,,0,1970-01-03T17:00:00Z,m,0,3600000000000\n,,0,1970-01-03T18:00:00Z,m,0,3600000000000\n,,0,1970-01-03T19:00:00Z,m,0,3600000000000\n,,0,1970-01-03T20:00:00Z,m,0,3600000000000\n,,0,1970-01-03T21:00:00Z,m,0,3600000000000\n,,0,1970-01-03T22:00:00Z,m,0,3600000000000\n,,0,1970-01-03T23:00:00Z,m,0,3600000000000\n,,0,1970-01-04T00:00:00Z,m,0,3600000000000\n,,0,1970-01-04T01:00:00Z,m,0,3600000000000\n,,0,1970-01-04T02:00:00Z,m,0,3600000000000\n,,0,1970-01-04T03:00:00Z,m,0,3600000000000\n,,0,1970-01-04T04:00:00Z,m,0,3600000000000\n,,0,1970-01-04T05:00:00Z,m,0,3600000000000\n,,0,1970-01-04T06:00:00Z,m,0,3600000000000\n,,0,1970-01-04T07:00:00Z,m,0,3600000000000\n,,0,1970-01-04T08:00:00Z,m,0,3600000000000\n,,0,1970-01-04T09:00:00Z,m,0,3600000000000\n,,0,1970-01-04T10:00:00Z,m,0,3600000000000\n,,0,1970-01-04T11:00:00Z,m,0,3600000000000\n,,0,1970-01-04T12:00:00Z,m,0,3600000000000\n,,0,1970-01-04T13:00:00Z,m,0,3600000000000\n,,0,1970-01-04T14:00:00Z,m,0,3600000000000\n,,0,1970-01-04T15:00:00Z,m,0,3600000000000\n,,0,1970-01-04T16:00:00Z,m,0,3600000000000\n,,0,1970-01-04T17:00:00Z,m,0,3600000000000\n,,0,1970-01-04T18:00:00Z,m,0,3600000000000\n,,0,1970-01-04T19:00:00Z,m,0,3600000000000\n,,0,1970-01-04T20:00:00Z,m,0,3600000000000\n,,0,1970-01-04T21:00:00Z,m,0,3600000000000\n,,0,1970-01-04T22:00:00Z,m,0,3600000000000\n,,0,1970-01-04T23:00:00Z,m,0,3600000000000\n,,0,1970-01-05T00:00:00Z,m,0,3600000000000\n,,0,1970-01-05T01:00:00Z,m,0,3600000000000\n,,0,1970-01-05T02:00:00Z,m,0,3600000000000\n,,0,1970-01-05T03:00:00Z,m,0,3600000000000\n,,0,1970-01-05T04:00:00Z,m,0,3600000000000\n,,0,1970-01-05T05:00:00Z,m,0,3600000000000\n,,0,1970-01-05T06:00:00Z,m,0,3600000000000\n,,0,1970-01-05T07:00:00Z,m,0,3600000000000\n,,0,1970-01-05T08:00:00Z,m,0,3600000000000\n,,0,1970-01-05T09:00:00Z,m,0,3600000000000\n,,0,1970-01-05T10:00:00Z,m,0,3600000000000\n,,0,1970-01-05T11:00:00Z,m,0,3600000000000\n,,0,1970-01-05T12:00:00Z,m,0,3600000000000\n,,0,1970-01-05T13:00:00Z,m,0,3600000000000\n,,0,1970-01-05T14:00:00Z,m,0,3600000000000\n,,0,1970-01-05T15:00:00Z,m,0,3600000000000\n,,0,1970-01-05T16:00:00Z,m,0,3600000000000\n,,0,1970-01-05T17:00:00Z,m,0,3600000000000\n,,0,1970-01-05T18:00:00Z,m,0,3600000000000\n,,0,1970-01-05T19:00:00Z,m,0,3600000000000\n,,0,1970-01-05T20:00:00Z,m,0,3600000000000\n,,0,1970-01-05T21:00:00Z,m,0,3600000000000\n,,0,1970-01-05T22:00:00Z,m,0,3600000000000\n,,0,1970-01-05T23:00:00Z,m,0,3600000000000\n,,0,1970-01-06T00:00:00Z,m,0,3600000000000\n,,0,1970-01-06T01:00:00Z,m,0,3600000000000\n,,0,1970-01-06T02:00:00Z,m,0,3600000000000\n,,0,1970-01-06T03:00:00Z,m,0,3600000000000\n,,0,1970-01-06T04:00:00Z,m,0,3600000000000\n,,0,1970-01-06T05:00:00Z,m,0,3600000000000\n,,0,1970-01-06T06:00:00Z,m,0,3600000000000\n,,0,1970-01-06T07:00:00Z,m,0,3600000000000\n,,0,1970-01-06T08:00:00Z,m,0,3600000000000\n,,0,1970-01-06T09:00:00Z,m,0,3600000000000\n,,0,1970-01-06T10:00:00Z,m,0,3600000000000\n,,0,1970-01-06T11:00:00Z,m,0,3600000000000\n,,0,1970-01-06T12:00:00Z,m,0,3600000000000\n,,0,1970-01-06T13:00:00Z,m,0,3600000000000\n,,0,1970-01-06T14:00:00Z,m,0,3600000000000\n,,0,1970-01-06T15:00:00Z,m,0,3600000000000\n,,0,1970-01-06T16:00:00Z,m,0,3600000000000\n,,0,1970-01-06T17:00:00Z,m,0,3600000000000\n,,0,1970-01-06T18:00:00Z,m,0,3600000000000\n,,0,1970-01-06T19:00:00Z,m,0,3600000000000\n,,0,1970-01-06T20:00:00Z,m,0,3600000000000\n,,0,1970-01-06T21:00:00Z,m,0,3600000000000\n,,0,1970-01-06T22:00:00Z,m,0,3600000000000\n,,0,1970-01-06T23:00:00Z,m,0,3600000000000\n,,0,1970-01-07T00:00:00Z,m,0,3600000000000\n,,0,1970-01-07T01:00:00Z,m,0,3600000000000\n,,0,1970-01-07T02:00:00Z,m,0,3600000000000\n,,0,1970-01-07T03:00:00Z,m,0,3600000000000\n,,0,1970-01-07T04:00:00Z,m,0,3600000000000\n,,0,1970-01-07T05:00:00Z,m,0,3600000000000\n,,0,1970-01-07T06:00:00Z,m,0,3600000000000\n,,0,1970-01-07T07:00:00Z,m,0,3600000000000\n,,0,1970-01-07T08:00:00Z,m,0,3600000000000\n,,0,1970-01-07T09:00:00Z,m,0,3600000000000\n,,0,1970-01-07T10:00:00Z,m,0,3600000000000\n,,0,1970-01-07T11:00:00Z,m,0,3600000000000\n,,0,1970-01-07T12:00:00Z,m,0,3600000000000\n,,0,1970-01-07T13:00:00Z,m,0,3600000000000\n,,0,1970-01-07T14:00:00Z,m,0,3600000000000\n,,0,1970-01-07T15:00:00Z,m,0,3600000000000\n,,0,1970-01-07T16:00:00Z,m,0,3600000000000\n,,0,1970-01-07T17:00:00Z,m,0,3600000000000\n,,0,1970-01-07T18:00:00Z,m,0,3600000000000\n,,0,1970-01-07T19:00:00Z,m,0,3600000000000\n,,0,1970-01-07T20:00:00Z,m,0,3600000000000\n,,0,1970-01-07T21:00:00Z,m,0,3600000000000\n,,0,1970-01-07T22:00:00Z,m,0,3600000000000\n,,0,1970-01-07T23:00:00Z,m,0,3600000000000\n,,1,1970-01-01T01:00:00Z,m,1,3600000000000\n,,1,1970-01-01T02:00:00Z,m,1,3600000000000\n,,1,1970-01-01T03:00:00Z,m,1,3600000000000\n,,1,1970-01-01T04:00:00Z,m,1,3600000000000\n,,1,1970-01-01T05:00:00Z,m,1,3600000000000\n,,1,1970-01-01T06:00:00Z,m,1,3600000000000\n,,1,1970-01-01T07:00:00Z,m,1,3600000000000\n,,1,1970-01-01T08:00:00Z,m,1,3600000000000\n,,1,1970-01-01T09:00:00Z,m,1,3600000000000\n,,1,1970-01-01T10:00:00Z,m,1,3600000000000\n,,1,1970-01-01T11:00:00Z,m,1,3600000000000\n,,1,1970-01-01T12:00:00Z,m,1,3600000000000\n,,1,1970-01-01T13:00:00Z,m,1,3600000000000\n,,1,1970-01-01T14:00:00Z,m,1,3600000000000\n,,1,1970-01-01T15:00:00Z,m,1,3600000000000\n,,1,1970-01-01T16:00:00Z,m,1,3600000000000\n,,1,1970-01-01T17:00:00Z,m,1,3600000000000\n,,1,1970-01-01T18:00:00Z,m,1,3600000000000\n,,1,1970-01-01T19:00:00Z,m,1,3600000000000\n,,1,1970-01-01T20:00:00Z,m,1,3600000000000\n,,1,1970-01-01T21:00:00Z,m,1,3600000000000\n,,1,1970-01-01T22:00:00Z,m,1,3600000000000\n,,1,1970-01-01T23:00:00Z,m,1,3600000000000\n,,1,1970-01-02T00:00:00Z,m,1,3600000000000\n,,1,1970-01-02T01:00:00Z,m,1,3600000000000\n,,1,1970-01-02T02:00:00Z,m,1,3600000000000\n,,1,1970-01-02T03:00:00Z,m,1,3600000000000\n,,1,1970-01-02T04:00:00Z,m,1,3600000000000\n,,1,1970-01-02T05:00:00Z,m,1,3600000000000\n,,1,1970-01-02T06:00:00Z,m,1,3600000000000\n,,1,1970-01-02T07:00:00Z,m,1,3600000000000\n,,1,1970-01-02T08:00:00Z,m,1,3600000000000\n,,1,1970-01-02T09:00:00Z,m,1,3600000000000\n,,1,1970-01-02T10:00:00Z,m,1,3600000000000\n,,1,1970-01-02T11:00:00Z,m,1,3600000000000\n,,1,1970-01-02T12:00:00Z,m,1,3600000000000\n,,1,1970-01-02T13:00:00Z,m,1,3600000000000\n,,1,1970-01-02T14:00:00Z,m,1,3600000000000\n,,1,1970-01-02T15:00:00Z,m,1,3600000000000\n,,1,1970-01-02T16:00:00Z,m,1,3600000000000\n,,1,1970-01-02T17:00:00Z,m,1,3600000000000\n,,1,1970-01-02T18:00:00Z,m,1,3600000000000\n,,1,1970-01-02T19:00:00Z,m,1,3600000000000\n,,1,1970-01-02T20:00:00Z,m,1,3600000000000\n,,1,1970-01-02T21:00:00Z,m,1,3600000000000\n,,1,1970-01-02T22:00:00Z,m,1,3600000000000\n,,1,1970-01-02T23:00:00Z,m,1,3600000000000\n,,1,1970-01-03T00:00:00Z,m,1,3600000000000\n,,1,1970-01-03T01:00:00Z,m,1,3600000000000\n,,1,1970-01-03T02:00:00Z,m,1,3600000000000\n,,1,1970-01-03T03:00:00Z,m,1,3600000000000\n,,1,1970-01-03T04:00:00Z,m,1,3600000000000\n,,1,1970-01-03T05:00:00Z,m,1,3600000000000\n,,1,1970-01-03T06:00:00Z,m,1,3600000000000\n,,1,1970-01-03T07:00:00Z,m,1,3600000000000\n,,1,1970-01-03T08:00:00Z,m,1,3600000000000\n,,1,1970-01-03T09:00:00Z,m,1,3600000000000\n,,1,1970-01-03T10:00:00Z,m,1,3600000000000\n,,1,1970-01-03T11:00:00Z,m,1,3600000000000\n,,1,1970-01-03T12:00:00Z,m,1,3600000000000\n,,1,1970-01-03T13:00:00Z,m,1,3600000000000\n,,1,1970-01-03T14:00:00Z,m,1,3600000000000\n,,1,1970-01-03T15:00:00Z,m,1,3600000000000\n,,1,1970-01-03T16:00:00Z,m,1,3600000000000\n,,1,1970-01-03T17:00:00Z,m,1,3600000000000\n,,1,1970-01-03T18:00:00Z,m,1,3600000000000\n,,1,1970-01-03T19:00:00Z,m,1,3600000000000\n,,1,1970-01-03T20:00:00Z,m,1,3600000000000\n,,1,1970-01-03T21:00:00Z,m,1,3600000000000\n,,1,1970-01-03T22:00:00Z,m,1,3600000000000\n,,1,1970-01-03T23:00:00Z,m,1,3600000000000\n,,1,1970-01-04T00:00:00Z,m,1,3600000000000\n,,1,1970-01-04T01:00:00Z,m,1,3600000000000\n,,1,1970-01-04T02:00:00Z,m,1,3600000000000\n,,1,1970-01-04T03:00:00Z,m,1,3600000000000\n,,1,1970-01-04T04:00:00Z,m,1,3600000000000\n,,1,1970-01-04T05:00:00Z,m,1,3600000000000\n,,1,1970-01-04T06:00:00Z,m,1,3600000000000\n,,1,1970-01-04T07:00:00Z,m,1,3600000000000\n,,1,1970-01-04T08:00:00Z,m,1,3600000000000\n,,1,1970-01-04T09:00:00Z,m,1,3600000000000\n,,1,1970-01-04T10:00:00Z,m,1,3600000000000\n,,1,1970-01-04T11:00:00Z,m,1,3600000000000\n,,1,1970-01-04T12:00:00Z,m,1,3600000000000\n,,1,1970-01-04T13:00:00Z,m,1,3600000000000\n,,1,1970-01-04T14:00:00Z,m,1,3600000000000\n,,1,1970-01-04T15:00:00Z,m,1,3600000000000\n,,1,1970-01-04T16:00:00Z,m,1,3600000000000\n,,1,1970-01-04T17:00:00Z,m,1,3600000000000\n,,1,1970-01-04T18:00:00Z,m,1,3600000000000\n,,1,1970-01-04T19:00:00Z,m,1,3600000000000\n,,1,1970-01-04T20:00:00Z,m,1,3600000000000\n,,1,1970-01-04T21:00:00Z,m,1,3600000000000\n,,1,1970-01-04T22:00:00Z,m,1,3600000000000\n,,1,1970-01-04T23:00:00Z,m,1,3600000000000\n,,1,1970-01-05T00:00:00Z,m,1,3600000000000\n,,1,1970-01-05T01:00:00Z,m,1,3600000000000\n,,1,1970-01-05T02:00:00Z,m,1,3600000000000\n,,1,1970-01-05T03:00:00Z,m,1,3600000000000\n,,1,1970-01-05T04:00:00Z,m,1,3600000000000\n,,1,1970-01-05T05:00:00Z,m,1,3600000000000\n,,1,1970-01-05T06:00:00Z,m,1,3600000000000\n,,1,1970-01-05T07:00:00Z,m,1,3600000000000\n,,1,1970-01-05T08:00:00Z,m,1,3600000000000\n,,1,1970-01-05T09:00:00Z,m,1,3600000000000\n,,1,1970-01-05T10:00:00Z,m,1,3600000000000\n,,1,1970-01-05T11:00:00Z,m,1,3600000000000\n,,1,1970-01-05T12:00:00Z,m,1,3600000000000\n,,1,1970-01-05T13:00:00Z,m,1,3600000000000\n,,1,1970-01-05T14:00:00Z,m,1,3600000000000\n,,1,1970-01-05T15:00:00Z,m,1,3600000000000\n,,1,1970-01-05T16:00:00Z,m,1,3600000000000\n,,1,1970-01-05T17:00:00Z,m,1,3600000000000\n,,1,1970-01-05T18:00:00Z,m,1,3600000000000\n,,1,1970-01-05T19:00:00Z,m,1,3600000000000\n,,1,1970-01-05T20:00:00Z,m,1,3600000000000\n,,1,1970-01-05T21:00:00Z,m,1,3600000000000\n,,1,1970-01-05T22:00:00Z,m,1,3600000000000\n,,1,1970-01-05T23:00:00Z,m,1,3600000000000\n,,1,1970-01-06T00:00:00Z,m,1,3600000000000\n,,1,1970-01-06T01:00:00Z,m,1,3600000000000\n,,1,1970-01-06T02:00:00Z,m,1,3600000000000\n,,1,1970-01-06T03:00:00Z,m,1,3600000000000\n,,1,1970-01-06T04:00:00Z,m,1,3600000000000\n,,1,1970-01-06T05:00:00Z,m,1,3600000000000\n,,1,1970-01-06T06:00:00Z,m,1,3600000000000\n,,1,1970-01-06T07:00:00Z,m,1,3600000000000\n,,1,1970-01-06T08:00:00Z,m,1,3600000000000\n,,1,1970-01-06T09:00:00Z,m,1,3600000000000\n,,1,1970-01-06T10:00:00Z,m,1,3600000000000\n,,1,1970-01-06T11:00:00Z,m,1,3600000000000\n,,1,1970-01-06T12:00:00Z,m,1,3600000000000\n,,1,1970-01-06T13:00:00Z,m,1,3600000000000\n,,1,1970-01-06T14:00:00Z,m,1,3600000000000\n,,1,1970-01-06T15:00:00Z,m,1,3600000000000\n,,1,1970-01-06T16:00:00Z,m,1,3600000000000\n,,1,1970-01-06T17:00:00Z,m,1,3600000000000\n,,1,1970-01-06T18:00:00Z,m,1,3600000000000\n,,1,1970-01-06T19:00:00Z,m,1,3600000000000\n,,1,1970-01-06T20:00:00Z,m,1,3600000000000\n,,1,1970-01-06T21:00:00Z,m,1,3600000000000\n,,1,1970-01-06T22:00:00Z,m,1,3600000000000\n,,1,1970-01-06T23:00:00Z,m,1,3600000000000\n,,1,1970-01-07T00:00:00Z,m,1,3600000000000\n,,1,1970-01-07T01:00:00Z,m,1,3600000000000\n,,1,1970-01-07T02:00:00Z,m,1,3600000000000\n,,1,1970-01-07T03:00:00Z,m,1,3600000000000\n,,1,1970-01-07T04:00:00Z,m,1,3600000000000\n,,1,1970-01-07T05:00:00Z,m,1,3600000000000\n,,1,1970-01-07T06:00:00Z,m,1,3600000000000\n,,1,1970-01-07T07:00:00Z,m,1,3600000000000\n,,1,1970-01-07T08:00:00Z,m,1,3600000000000\n,,1,1970-01-07T09:00:00Z,m,1,3600000000000\n,,1,1970-01-07T10:00:00Z,m,1,3600000000000\n,,1,1970-01-07T11:00:00Z,m,1,3600000000000\n,,1,1970-01-07T12:00:00Z,m,1,3600000000000\n,,1,1970-01-07T13:00:00Z,m,1,3600000000000\n,,1,1970-01-07T14:00:00Z,m,1,3600000000000\n,,1,1970-01-07T15:00:00Z,m,1,3600000000000\n,,1,1970-01-07T16:00:00Z,m,1,3600000000000\n,,1,1970-01-07T17:00:00Z,m,1,3600000000000\n,,1,1970-01-07T18:00:00Z,m,1,3600000000000\n,,1,1970-01-07T19:00:00Z,m,1,3600000000000\n,,1,1970-01-07T20:00:00Z,m,1,3600000000000\n,,1,1970-01-07T21:00:00Z,m,1,3600000000000\n,,1,1970-01-07T22:00:00Z,m,1,3600000000000\n,,1,1970-01-07T23:00:00Z,m,1,3600000000000\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   349,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,time,_measurement,t0,elapsed\n,,0,1970-01-01T01:00:00Z,m,0,3600000000000\n,,0,1970-01-01T02:00:00Z,m,0,3600000000000\n,,0,1970-01-01T03:00:00Z,m,0,3600000000000\n,,0,1970-01-01T04:00:00Z,m,0,3600000000000\n,,0,1970-01-01T05:00:00Z,m,0,3600000000000\n,,0,1970-01-01T06:00:00Z,m,0,3600000000000\n,,0,1970-01-01T07:00:00Z,m,0,3600000000000\n,,0,1970-01-01T08:00:00Z,m,0,3600000000000\n,,0,1970-01-01T09:00:00Z,m,0,3600000000000\n,,0,1970-01-01T10:00:00Z,m,0,3600000000000\n,,0,1970-01-01T11:00:00Z,m,0,3600000000000\n,,0,1970-01-01T12:00:00Z,m,0,3600000000000\n,,0,1970-01-01T13:00:00Z,m,0,3600000000000\n,,0,1970-01-01T14:00:00Z,m,0,3600000000000\n,,0,1970-01-01T15:00:00Z,m,0,3600000000000\n,,0,1970-01-01T16:00:00Z,m,0,3600000000000\n,,0,1970-01-01T17:00:00Z,m,0,3600000000000\n,,0,1970-01-01T18:00:00Z,m,0,3600000000000\n,,0,1970-01-01T19:00:00Z,m,0,3600000000000\n,,0,1970-01-01T20:00:00Z,m,0,3600000000000\n,,0,1970-01-01T21:00:00Z,m,0,3600000000000\n,,0,1970-01-01T22:00:00Z,m,0,3600000000000\n,,0,1970-01-01T23:00:00Z,m,0,3600000000000\n,,0,1970-01-02T00:00:00Z,m,0,3600000000000\n,,0,1970-01-02T01:00:00Z,m,0,3600000000000\n,,0,1970-01-02T02:00:00Z,m,0,3600000000000\n,,0,1970-01-02T03:00:00Z,m,0,3600000000000\n,,0,1970-01-02T04:00:00Z,m,0,3600000000000\n,,0,1970-01-02T05:00:00Z,m,0,3600000000000\n,,0,1970-01-02T06:00:00Z,m,0,3600000000000\n,,0,1970-01-02T07:00:00Z,m,0,3600000000000\n,,0,1970-01-02T08:00:00Z,m,0,3600000000000\n,,0,1970-01-02T09:00:00Z,m,0,3600000000000\n,,0,1970-01-02T10:00:00Z,m,0,3600000000000\n,,0,1970-01-02T11:00:00Z,m,0,3600000000000\n,,0,1970-01-02T12:00:00Z,m,0,3600000000000\n,,0,1970-01-02T13:00:00Z,m,0,3600000000000\n,,0,1970-01-02T14:00:00Z,m,0,3600000000000\n,,0,1970-01-02T15:00:00Z,m,0,3600000000000\n,,0,1970-01-02T16:00:00Z,m,0,3600000000000\n,,0,1970-01-02T17:00:00Z,m,0,3600000000000\n,,0,1970-01-02T18:00:00Z,m,0,3600000000000\n,,0,1970-01-02T19:00:00Z,m,0,3600000000000\n,,0,1970-01-02T20:00:00Z,m,0,3600000000000\n,,0,1970-01-02T21:00:00Z,m,0,3600000000000\n,,0,1970-01-02T22:00:00Z,m,0,3600000000000\n,,0,1970-01-02T23:00:00Z,m,0,3600000000000\n,,0,1970-01-03T00:00:00Z,m,0,3600000000000\n,,0,1970-01-03T01:00:00Z,m,0,3600000000000\n,,0,1970-01-03T02:00:00Z,m,0,3600000000000\n,,0,1970-01-03T03:00:00Z,m,0,3600000000000\n,,0,1970-01-03T04:00:00Z,m,0,3600000000000\n,,0,1970-01-03T05:00:00Z,m,0,3600000000000\n,,0,1970-01-03T06:00:00Z,m,0,3600000000000\n,,0,1970-01-03T07:00:00Z,m,0,3600000000000\n,,0,1970-01-03T08:00:00Z,m,0,3600000000000\n,,0,1970-01-03T09:00:00Z,m,0,3600000000000\n,,0,1970-01-03T10:00:00Z,m,0,3600000000000\n,,0,1970-01-03T11:00:00Z,m,0,3600000000000\n,,0,1970-01-03T12:00:00Z,m,0,3600000000000\n,,0,1970-01-03T13:00:00Z,m,0,3600000000000\n,,0,1970-01-03T14:00:00Z,m,0,3600000000000\n,,0,1970-01-03T15:00:00Z,m,0,3600000000000\n,,0,1970-01-03T16:00:00Z,m,0,3600000000000\n,,0,1970-01-03T17:00:00Z,m,0,3600000000000\n,,0,1970-01-03T18:00:00Z,m,0,3600000000000\n,,0,1970-01-03T19:00:00Z,m,0,3600000000000\n,,0,1970-01-03T20:00:00Z,m,0,3600000000000\n,,0,1970-01-03T21:00:00Z,m,0,3600000000000\n,,0,1970-01-03T22:00:00Z,m,0,3600000000000\n,,0,1970-01-03T23:00:00Z,m,0,3600000000000\n,,0,1970-01-04T00:00:00Z,m,0,3600000000000\n,,0,1970-01-04T01:00:00Z,m,0,3600000000000\n,,0,1970-01-04T02:00:00Z,m,0,3600000000000\n,,0,1970-01-04T03:00:00Z,m,0,3600000000000\n,,0,1970-01-04T04:00:00Z,m,0,3600000000000\n,,0,1970-01-04T05:00:00Z,m,0,3600000000000\n,,0,1970-01-04T06:00:00Z,m,0,3600000000000\n,,0,1970-01-04T07:00:00Z,m,0,3600000000000\n,,0,1970-01-04T08:00:00Z,m,0,3600000000000\n,,0,1970-01-04T09:00:00Z,m,0,3600000000000\n,,0,1970-01-04T10:00:00Z,m,0,3600000000000\n,,0,1970-01-04T11:00:00Z,m,0,3600000000000\n,,0,1970-01-04T12:00:00Z,m,0,3600000000000\n,,0,1970-01-04T13:00:00Z,m,0,3600000000000\n,,0,1970-01-04T14:00:00Z,m,0,3600000000000\n,,0,1970-01-04T15:00:00Z,m,0,3600000000000\n,,0,1970-01-04T16:00:00Z,m,0,3600000000000\n,,0,1970-01-04T17:00:00Z,m,0,3600000000000\n,,0,1970-01-04T18:00:00Z,m,0,3600000000000\n,,0,1970-01-04T19:00:00Z,m,0,3600000000000\n,,0,1970-01-04T20:00:00Z,m,0,3600000000000\n,,0,1970-01-04T21:00:00Z,m,0,3600000000000\n,,0,1970-01-04T22:00:00Z,m,0,3600000000000\n,,0,1970-01-04T23:00:00Z,m,0,3600000000000\n,,0,1970-01-05T00:00:00Z,m,0,3600000000000\n,,0,1970-01-05T01:00:00Z,m,0,3600000000000\n,,0,1970-01-05T02:00:00Z,m,0,3600000000000\n,,0,1970-01-05T03:00:00Z,m,0,3600000000000\n,,0,1970-01-05T04:00:00Z,m,0,3600000000000\n,,0,1970-01-05T05:00:00Z,m,0,3600000000000\n,,0,1970-01-05T06:00:00Z,m,0,3600000000000\n,,0,1970-01-05T07:00:00Z,m,0,3600000000000\n,,0,1970-01-05T08:00:00Z,m,0,3600000000000\n,,0,1970-01-05T09:00:00Z,m,0,3600000000000\n,,0,1970-01-05T10:00:00Z,m,0,3600000000000\n,,0,1970-01-05T11:00:00Z,m,0,3600000000000\n,,0,1970-01-05T12:00:00Z,m,0,3600000000000\n,,0,1970-01-05T13:00:00Z,m,0,3600000000000\n,,0,1970-01-05T14:00:00Z,m,0,3600000000000\n,,0,1970-01-05T15:00:00Z,m,0,3600000000000\n,,0,1970-01-05T16:00:00Z,m,0,3600000000000\n,,0,1970-01-05T17:00:00Z,m,0,3600000000000\n,,0,1970-01-05T18:00:00Z,m,0,3600000000000\n,,0,1970-01-05T19:00:00Z,m,0,3600000000000\n,,0,1970-01-05T20:00:00Z,m,0,3600000000000\n,,0,1970-01-05T21:00:00Z,m,0,3600000000000\n,,0,1970-01-05T22:00:00Z,m,0,3600000000000\n,,0,1970-01-05T23:00:00Z,m,0,3600000000000\n,,0,1970-01-06T00:00:00Z,m,0,3600000000000\n,,0,1970-01-06T01:00:00Z,m,0,3600000000000\n,,0,1970-01-06T02:00:00Z,m,0,3600000000000\n,,0,1970-01-06T03:00:00Z,m,0,3600000000000\n,,0,1970-01-06T04:00:00Z,m,0,3600000000000\n,,0,1970-01-06T05:00:00Z,m,0,3600000000000\n,,0,1970-01-06T06:00:00Z,m,0,3600000000000\n,,0,1970-01-06T07:00:00Z,m,0,3600000000000\n,,0,1970-01-06T08:00:00Z,m,0,3600000000000\n,,0,1970-01-06T09:00:00Z,m,0,3600000000000\n,,0,1970-01-06T10:00:00Z,m,0,3600000000000\n,,0,1970-01-06T11:00:00Z,m,0,3600000000000\n,,0,1970-01-06T12:00:00Z,m,0,3600000000000\n,,0,1970-01-06T13:00:00Z,m,0,3600000000000\n,,0,1970-01-06T14:00:00Z,m,0,3600000000000\n,,0,1970-01-06T15:00:00Z,m,0,3600000000000\n,,0,1970-01-06T16:00:00Z,m,0,3600000000000\n,,0,1970-01-06T17:00:00Z,m,0,3600000000000\n,,0,1970-01-06T18:00:00Z,m,0,3600000000000\n,,0,1970-01-06T19:00:00Z,m,0,3600000000000\n,,0,1970-01-06T20:00:00Z,m,0,3600000000000\n,,0,1970-01-06T21:00:00Z,m,0,3600000000000\n,,0,1970-01-06T22:00:00Z,m,0,3600000000000\n,,0,1970-01-06T23:00:00Z,m,0,3600000000000\n,,0,1970-01-07T00:00:00Z,m,0,3600000000000\n,,0,1970-01-07T01:00:00Z,m,0,3600000000000\n,,0,1970-01-07T02:00:00Z,m,0,3600000000000\n,,0,1970-01-07T03:00:00Z,m,0,3600000000000\n,,0,1970-01-07T04:00:00Z,m,0,3600000000000\n,,0,1970-01-07T05:00:00Z,m,0,3600000000000\n,,0,1970-01-07T06:00:00Z,m,0,3600000000000\n,,0,1970-01-07T07:00:00Z,m,0,3600000000000\n,,0,1970-01-07T08:00:00Z,m,0,3600000000000\n,,0,1970-01-07T09:00:00Z,m,0,3600000000000\n,,0,1970-01-07T10:00:00Z,m,0,3600000000000\n,,0,1970-01-07T11:00:00Z,m,0,3600000000000\n,,0,1970-01-07T12:00:00Z,m,0,3600000000000\n,,0,1970-01-07T13:00:00Z,m,0,3600000000000\n,,0,1970-01-07T14:00:00Z,m,0,3600000000000\n,,0,1970-01-07T15:00:00Z,m,0,3600000000000\n,,0,1970-01-07T16:00:00Z,m,0,3600000000000\n,,0,1970-01-07T17:00:00Z,m,0,3600000000000\n,,0,1970-01-07T18:00:00Z,m,0,3600000000000\n,,0,1970-01-07T19:00:00Z,m,0,3600000000000\n,,0,1970-01-07T20:00:00Z,m,0,3600000000000\n,,0,1970-01-07T21:00:00Z,m,0,3600000000000\n,,0,1970-01-07T22:00:00Z,m,0,3600000000000\n,,0,1970-01-07T23:00:00Z,m,0,3600000000000\n,,1,1970-01-01T01:00:00Z,m,1,3600000000000\n,,1,1970-01-01T02:00:00Z,m,1,3600000000000\n,,1,1970-01-01T03:00:00Z,m,1,3600000000000\n,,1,1970-01-01T04:00:00Z,m,1,3600000000000\n,,1,1970-01-01T05:00:00Z,m,1,3600000000000\n,,1,1970-01-01T06:00:00Z,m,1,3600000000000\n,,1,1970-01-01T07:00:00Z,m,1,3600000000000\n,,1,1970-01-01T08:00:00Z,m,1,3600000000000\n,,1,1970-01-01T09:00:00Z,m,1,3600000000000\n,,1,1970-01-01T10:00:00Z,m,1,3600000000000\n,,1,1970-01-01T11:00:00Z,m,1,3600000000000\n,,1,1970-01-01T12:00:00Z,m,1,3600000000000\n,,1,1970-01-01T13:00:00Z,m,1,3600000000000\n,,1,1970-01-01T14:00:00Z,m,1,3600000000000\n,,1,1970-01-01T15:00:00Z,m,1,3600000000000\n,,1,1970-01-01T16:00:00Z,m,1,3600000000000\n,,1,1970-01-01T17:00:00Z,m,1,3600000000000\n,,1,1970-01-01T18:00:00Z,m,1,3600000000000\n,,1,1970-01-01T19:00:00Z,m,1,3600000000000\n,,1,1970-01-01T20:00:00Z,m,1,3600000000000\n,,1,1970-01-01T21:00:00Z,m,1,3600000000000\n,,1,1970-01-01T22:00:00Z,m,1,3600000000000\n,,1,1970-01-01T23:00:00Z,m,1,3600000000000\n,,1,1970-01-02T00:00:00Z,m,1,3600000000000\n,,1,1970-01-02T01:00:00Z,m,1,3600000000000\n,,1,1970-01-02T02:00:00Z,m,1,3600000000000\n,,1,1970-01-02T03:00:00Z,m,1,3600000000000\n,,1,1970-01-02T04:00:00Z,m,1,3600000000000\n,,1,1970-01-02T05:00:00Z,m,1,3600000000000\n,,1,1970-01-02T06:00:00Z,m,1,3600000000000\n,,1,1970-01-02T07:00:00Z,m,1,3600000000000\n,,1,1970-01-02T08:00:00Z,m,1,3600000000000\n,,1,1970-01-02T09:00:00Z,m,1,3600000000000\n,,1,1970-01-02T10:00:00Z,m,1,3600000000000\n,,1,1970-01-02T11:00:00Z,m,1,3600000000000\n,,1,1970-01-02T12:00:00Z,m,1,3600000000000\n,,1,1970-01-02T13:00:00Z,m,1,3600000000000\n,,1,1970-01-02T14:00:00Z,m,1,3600000000000\n,,1,1970-01-02T15:00:00Z,m,1,3600000000000\n,,1,1970-01-02T16:00:00Z,m,1,3600000000000\n,,1,1970-01-02T17:00:00Z,m,1,3600000000000\n,,1,1970-01-02T18:00:00Z,m,1,3600000000000\n,,1,1970-01-02T19:00:00Z,m,1,3600000000000\n,,1,1970-01-02T20:00:00Z,m,1,3600000000000\n,,1,1970-01-02T21:00:00Z,m,1,3600000000000\n,,1,1970-01-02T22:00:00Z,m,1,3600000000000\n,,1,1970-01-02T23:00:00Z,m,1,3600000000000\n,,1,1970-01-03T00:00:00Z,m,1,3600000000000\n,,1,1970-01-03T01:00:00Z,m,1,3600000000000\n,,1,1970-01-03T02:00:00Z,m,1,3600000000000\n,,1,1970-01-03T03:00:00Z,m,1,3600000000000\n,,1,1970-01-03T04:00:00Z,m,1,3600000000000\n,,1,1970-01-03T05:00:00Z,m,1,3600000000000\n,,1,1970-01-03T06:00:00Z,m,1,3600000000000\n,,1,1970-01-03T07:00:00Z,m,1,3600000000000\n,,1,1970-01-03T08:00:00Z,m,1,3600000000000\n,,1,1970-01-03T09:00:00Z,m,1,3600000000000\n,,1,1970-01-03T10:00:00Z,m,1,3600000000000\n,,1,1970-01-03T11:00:00Z,m,1,3600000000000\n,,1,1970-01-03T12:00:00Z,m,1,3600000000000\n,,1,1970-01-03T13:00:00Z,m,1,3600000000000\n,,1,1970-01-03T14:00:00Z,m,1,3600000000000\n,,1,1970-01-03T15:00:00Z,m,1,3600000000000\n,,1,1970-01-03T16:00:00Z,m,1,3600000000000\n,,1,1970-01-03T17:00:00Z,m,1,3600000000000\n,,1,1970-01-03T18:00:00Z,m,1,3600000000000\n,,1,1970-01-03T19:00:00Z,m,1,3600000000000\n,,1,1970-01-03T20:00:00Z,m,1,3600000000000\n,,1,1970-01-03T21:00:00Z,m,1,3600000000000\n,,1,1970-01-03T22:00:00Z,m,1,3600000000000\n,,1,1970-01-03T23:00:00Z,m,1,3600000000000\n,,1,1970-01-04T00:00:00Z,m,1,3600000000000\n,,1,1970-01-04T01:00:00Z,m,1,3600000000000\n,,1,1970-01-04T02:00:00Z,m,1,3600000000000\n,,1,1970-01-04T03:00:00Z,m,1,3600000000000\n,,1,1970-01-04T04:00:00Z,m,1,3600000000000\n,,1,1970-01-04T05:00:00Z,m,1,3600000000000\n,,1,1970-01-04T06:00:00Z,m,1,3600000000000\n,,1,1970-01-04T07:00:00Z,m,1,3600000000000\n,,1,1970-01-04T08:00:00Z,m,1,3600000000000\n,,1,1970-01-04T09:00:00Z,m,1,3600000000000\n,,1,1970-01-04T10:00:00Z,m,1,3600000000000\n,,1,1970-01-04T11:00:00Z,m,1,3600000000000\n,,1,1970-01-04T12:00:00Z,m,1,3600000000000\n,,1,1970-01-04T13:00:00Z,m,1,3600000000000\n,,1,1970-01-04T14:00:00Z,m,1,3600000000000\n,,1,1970-01-04T15:00:00Z,m,1,3600000000000\n,,1,1970-01-04T16:00:00Z,m,1,3600000000000\n,,1,1970-01-04T17:00:00Z,m,1,3600000000000\n,,1,1970-01-04T18:00:00Z,m,1,3600000000000\n,,1,1970-01-04T19:00:00Z,m,1,3600000000000\n,,1,1970-01-04T20:00:00Z,m,1,3600000000000\n,,1,1970-01-04T21:00:00Z,m,1,3600000000000\n,,1,1970-01-04T22:00:00Z,m,1,3600000000000\n,,1,1970-01-04T23:00:00Z,m,1,3600000000000\n,,1,1970-01-05T00:00:00Z,m,1,3600000000000\n,,1,1970-01-05T01:00:00Z,m,1,3600000000000\n,,1,1970-01-05T02:00:00Z,m,1,3600000000000\n,,1,1970-01-05T03:00:00Z,m,1,3600000000000\n,,1,1970-01-05T04:00:00Z,m,1,3600000000000\n,,1,1970-01-05T05:00:00Z,m,1,3600000000000\n,,1,1970-01-05T06:00:00Z,m,1,3600000000000\n,,1,1970-01-05T07:00:00Z,m,1,3600000000000\n,,1,1970-01-05T08:00:00Z,m,1,3600000000000\n,,1,1970-01-05T09:00:00Z,m,1,3600000000000\n,,1,1970-01-05T10:00:00Z,m,1,3600000000000\n,,1,1970-01-05T11:00:00Z,m,1,3600000000000\n,,1,1970-01-05T12:00:00Z,m,1,3600000000000\n,,1,1970-01-05T13:00:00Z,m,1,3600000000000\n,,1,1970-01-05T14:00:00Z,m,1,3600000000000\n,,1,1970-01-05T15:00:00Z,m,1,3600000000000\n,,1,1970-01-05T16:00:00Z,m,1,3600000000000\n,,1,1970-01-05T17:00:00Z,m,1,3600000000000\n,,1,1970-01-05T18:00:00Z,m,1,3600000000000\n,,1,1970-01-05T19:00:00Z,m,1,3600000000000\n,,1,1970-01-05T20:00:00Z,m,1,3600000000000\n,,1,1970-01-05T21:00:00Z,m,1,3600000000000\n,,1,1970-01-05T22:00:00Z,m,1,3600000000000\n,,1,1970-01-05T23:00:00Z,m,1,3600000000000\n,,1,1970-01-06T00:00:00Z,m,1,3600000000000\n,,1,1970-01-06T01:00:00Z,m,1,3600000000000\n,,1,1970-01-06T02:00:00Z,m,1,3600000000000\n,,1,1970-01-06T03:00:00Z,m,1,3600000000000\n,,1,1970-01-06T04:00:00Z,m,1,3600000000000\n,,1,1970-01-06T05:00:00Z,m,1,3600000000000\n,,1,1970-01-06T06:00:00Z,m,1,3600000000000\n,,1,1970-01-06T07:00:00Z,m,1,3600000000000\n,,1,1970-01-06T08:00:00Z,m,1,3600000000000\n,,1,1970-01-06T09:00:00Z,m,1,3600000000000\n,,1,1970-01-06T10:00:00Z,m,1,3600000000000\n,,1,1970-01-06T11:00:00Z,m,1,3600000000000\n,,1,1970-01-06T12:00:00Z,m,1,3600000000000\n,,1,1970-01-06T13:00:00Z,m,1,3600000000000\n,,1,1970-01-06T14:00:00Z,m,1,3600000000000\n,,1,1970-01-06T15:00:00Z,m,1,3600000000000\n,,1,1970-01-06T16:00:00Z,m,1,3600000000000\n,,1,1970-01-06T17:00:00Z,m,1,3600000000000\n,,1,1970-01-06T18:00:00Z,m,1,3600000000000\n,,1,1970-01-06T19:00:00Z,m,1,3600000000000\n,,1,1970-01-06T20:00:00Z,m,1,3600000000000\n,,1,1970-01-06T21:00:00Z,m,1,3600000000000\n,,1,1970-01-06T22:00:00Z,m,1,3600000000000\n,,1,1970-01-06T23:00:00Z,m,1,3600000000000\n,,1,1970-01-07T00:00:00Z,m,1,3600000000000\n,,1,1970-01-07T01:00:00Z,m,1,3600000000000\n,,1,1970-01-07T02:00:00Z,m,1,3600000000000\n,,1,1970-01-07T03:00:00Z,m,1,3600000000000\n,,1,1970-01-07T04:00:00Z,m,1,3600000000000\n,,1,1970-01-07T05:00:00Z,m,1,3600000000000\n,,1,1970-01-07T06:00:00Z,m,1,3600000000000\n,,1,1970-01-07T07:00:00Z,m,1,3600000000000\n,,1,1970-01-07T08:00:00Z,m,1,3600000000000\n,,1,1970-01-07T09:00:00Z,m,1,3600000000000\n,,1,1970-01-07T10:00:00Z,m,1,3600000000000\n,,1,1970-01-07T11:00:00Z,m,1,3600000000000\n,,1,1970-01-07T12:00:00Z,m,1,3600000000000\n,,1,1970-01-07T13:00:00Z,m,1,3600000000000\n,,1,1970-01-07T14:00:00Z,m,1,3600000000000\n,,1,1970-01-07T15:00:00Z,m,1,3600000000000\n,,1,1970-01-07T16:00:00Z,m,1,3600000000000\n,,1,1970-01-07T17:00:00Z,m,1,3600000000000\n,,1,1970-01-07T18:00:00Z,m,1,3600000000000\n,,1,1970-01-07T19:00:00Z,m,1,3600000000000\n,,1,1970-01-07T20:00:00Z,m,1,3600000000000\n,,1,1970-01-07T21:00:00Z,m,1,3600000000000\n,,1,1970-01-07T22:00:00Z,m,1,3600000000000\n,,1,1970-01-07T23:00:00Z,m,1,3600000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   696,
					},
					File:   "elapsed_test.flux",
					Source: "t_elapsed = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")\n\t|> elapsed(unit: 1ns)\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\", \"_value\"])\n\t|> rename(columns: {_time: \"time\"})",
					Start: ast.Position{
						Column: 1,
						Line:   691,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   691,
						},
						File:   "elapsed_test.flux",
						Source: "t_elapsed",
						Start: ast.Position{
							Column: 1,
							Line:   691,
						},
					},
				},
				Name: "t_elapsed",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   696,
						},
						File:   "elapsed_test.flux",
						Source: "(tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")\n\t|> elapsed(unit: 1ns)\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\", \"_value\"])\n\t|> rename(columns: {_time: \"time\"})",
						Start: ast.Position{
							Column: 13,
							Line:   691,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   691,
												},
												File:   "elapsed_test.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 28,
													Line:   691,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   692,
											},
											File:   "elapsed_test.flux",
											Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)",
											Start: ast.Position{
												Column: 28,
												Line:   691,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   692,
													},
													File:   "elapsed_test.flux",
													Source: "start: influxql.minTime, stop: influxql.maxTime",
													Start: ast.Position{
														Column: 11,
														Line:   692,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   692,
														},
														File:   "elapsed_test.flux",
														Source: "start: influxql.minTime",
														Start: ast.Position{
															Column: 11,
															Line:   692,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   692,
															},
															File:   "elapsed_test.flux",
															Source: "start",
															Start: ast.Position{
																Column: 11,
																Line:   692,
															},
														},
													},
													Name: "start",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   692,
															},
															File:   "elapsed_test.flux",
															Source: "influxql.minTime",
															Start: ast.Position{
																Column: 18,
																Line:   692,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   692,
																},
																File:   "elapsed_test.flux",
																Source: "influxql",
																Start: ast.Position{
																	Column: 18,
																	Line:   692,
																},
															},
														},
														Name: "influxql",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   692,
																},
																File:   "elapsed_test.flux",
																Source: "minTime",
																Start: ast.Position{
																	Column: 27,
																	Line:   692,
																},
															},
														},
														Name: "minTime",
													},
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   692,
														},
														File:   "elapsed_test.flux",
														Source: "stop: influxql.maxTime",
														Start: ast.Position{
															Column: 36,
															Line:   692,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   692,
															},
															File:   "elapsed_test.flux",
															Source: "stop",
															Start: ast.Position{
																Column: 36,
																Line:   692,
															},
														},
													},
													Name: "stop",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   692,
															},
															File:   "elapsed_test.flux",
															Source: "influxql.maxTime",
															Start: ast.Position{
																Column: 42,
																Line:   692,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   692,
																},
																File:   "elapsed_test.flux",
																Source: "influxql",
																Start: ast.Position{
																	Column: 42,
																	Line:   692,
																},
															},
														},
														Name: "influxql",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   692,
																},
																File:   "elapsed_test.flux",
																Source: "maxTime",
																Start: ast.Position{
																	Column: 51,
																	Line:   692,
																},
															},
														},
														Name: "maxTime",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   692,
												},
												File:   "elapsed_test.flux",
												Source: "range(start: influxql.minTime, stop: influxql.maxTime)",
												Start: ast.Position{
													Column: 5,
													Line:   692,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   692,
													},
													File:   "elapsed_test.flux",
													Source: "range",
													Start: ast.Position{
														Column: 5,
														Line:   692,
													},
												},
											},
											Name: "range",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   693,
										},
										File:   "elapsed_test.flux",
										Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")",
										Start: ast.Position{
											Column: 28,
											Line:   691,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   693,
												},
												File:   "elapsed_test.flux",
												Source: "fn: (r) => r._measurement == \"m\" and r._field == \"f\"",
												Start: ast.Position{
													Column: 12,
													Line:   693,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   693,
													},
													File:   "elapsed_test.flux",
													Source: "fn: (r) => r._measurement == \"m\" and r._field == \"f\"",
													Start: ast.Position{
														Column: 12,
														Line:   693,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   693,
														},
														File:   "elapsed_test.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   693,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   693,
														},
														File:   "elapsed_test.flux",
														Source: "(r) => r._measurement == \"m\" and r._field == \"f\"",
														Start: ast.Position{
															Column: 16,
															Line:   693,
														},
													},
												},
												Body: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   693,
															},
															File:   "elapsed_test.flux",
															Source: "r._measurement == \"m\" and r._field == \"f\"",
															Start: ast.Position{
																Column: 23,
																Line:   693,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   693,
																},
																File:   "elapsed_test.flux",
																Source: "r._measurement == \"m\"",
																Start: ast.Position{
																	Column: 23,
																	Line:   693,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   693,
																	},
																	File:   "elapsed_test.flux",
																	Source: "r._measurement",
																	Start: ast.Position{
																		Column: 23,
																		Line:   693,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   693,
																		},
																		File:   "elapsed_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 23,
																			Line:   693,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   693,
																		},
																		File:   "elapsed_test.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 25,
																			Line:   693,
																		},
																	},
																},
																Name: "_measurement",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   693,
																	},
																	File:   "elapsed_test.flux",
																	Source: "\"m\"",
																	Start: ast.Position{
																		Column: 41,
																		Line:   693,
																	},
																},
															},
															Value: "m",
														},
													},
													Operator: 1,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   693,
																},
																File:   "elapsed_test.flux",
																Source: "r._field == \"f\"",
																Start: ast.Position{
																	Column: 49,
																	Line:   693,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   693,
																	},
																	File:   "elapsed_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 49,
																		Line:   693,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   693,
																		},
																		File:   "elapsed_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 49,
																			Line:   693,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   693,
																		},
																		File:   "elapsed_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 51,
																			Line:   693,
																		},
																	},
																},
																Name: "_field",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   693,
																	},
																	File:   "elapsed_test.flux",
																	Source: "\"f\"",
																	Start: ast.Position{
																		Column: 61,
																		Line:   693,
																	},
																},
															},
															Value: "f",
														},
													},
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   693,
															},
															File:   "elapsed_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   693,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   693,
																},
																File:   "elapsed_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   693,
																},
															},
														},
														Name: "r",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   693,
											},
											File:   "elapsed_test.flux",
											Source: "filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")",
											Start: ast.Position{
												Column: 5,
												Line:   693,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   693,
												},
												File:   "elapsed_test.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 5,
													Line:   693,
												},
											},
										},
										Name: "filter",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   694,
									},
									File:   "elapsed_test.flux",
									Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")\n\t|> elapsed(unit: 1ns)",
									Start: ast.Position{
										Column: 28,
										Line:   691,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   694,
											},
											File:   "elapsed_test.flux",
											Source: "unit: 1ns",
											Start: ast.Position{
												Column: 13,
												Line:   694,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   694,
												},
												File:   "elapsed_test.flux",
												Source: "unit: 1ns",
												Start: ast.Position{
													Column: 13,
													Line:   694,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   694,
													},
													File:   "elapsed_test.flux",
													Source: "unit",
													Start: ast.Position{
														Column: 13,
														Line:   694,
													},
												},
											},
											Name: "unit",
										},
										Value: &ast.DurationLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   694,
													},
													File:   "elapsed_test.flux",
													Source: "1ns",
													Start: ast.Position{
														Column: 19,
														Line:   694,
													},
												},
											},
											Values: []ast.Duration{ast.Duration{
												Magnitude: int64(1),
												Unit:      "ns",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   694,
										},
										File:   "elapsed_test.flux",
										Source: "elapsed(unit: 1ns)",
										Start: ast.Position{
											Column: 5,
											Line:   694,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   694,
											},
											File:   "elapsed_test.flux",
											Source: "elapsed",
											Start: ast.Position{
												Column: 5,
												Line:   694,
											},
										},
									},
									Name: "elapsed",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   695,
								},
								File:   "elapsed_test.flux",
								Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")\n\t|> elapsed(unit: 1ns)\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\", \"_value\"])",
								Start: ast.Position{
									Column: 28,
									Line:   691,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   695,
										},
										File:   "elapsed_test.flux",
										Source: "columns: [\"_start\", \"_stop\", \"_field\", \"_value\"]",
										Start: ast.Position{
											Column: 10,
											Line:   695,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   695,
											},
											File:   "elapsed_test.flux",
											Source: "columns: [\"_start\", \"_stop\", \"_field\", \"_value\"]",
											Start: ast.Position{
												Column: 10,
												Line:   695,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   695,
												},
												File:   "elapsed_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 10,
													Line:   695,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   695,
												},
												File:   "elapsed_test.flux",
												Source: "[\"_start\", \"_stop\", \"_field\", \"_value\"]",
												Start: ast.Position{
													Column: 19,
													Line:   695,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   695,
													},
													File:   "elapsed_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 20,
														Line:   695,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   695,
													},
													File:   "elapsed_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 30,
														Line:   695,
													},
												},
											},
											Value: "_stop",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   695,
													},
													File:   "elapsed_test.flux",
													Source: "\"_field\"",
													Start: ast.Position{
														Column: 39,
														Line:   695,
													},
												},
											},
											Value: "_field",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   695,
													},
													File:   "elapsed_test.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 49,
														Line:   695,
													},
												},
											},
											Value: "_value",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   695,
									},
									File:   "elapsed_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\", \"_field\", \"_value\"])",
									Start: ast.Position{
										Column: 5,
										Line:   695,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   695,
										},
										File:   "elapsed_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 5,
											Line:   695,
										},
									},
								},
								Name: "drop",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   696,
							},
							File:   "elapsed_test.flux",
							Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\" and r._field == \"f\")\n\t|> elapsed(unit: 1ns)\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\", \"_value\"])\n\t|> rename(columns: {_time: \"time\"})",
							Start: ast.Position{
								Column: 28,
								Line:   691,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   696,
									},
									File:   "elapsed_test.flux",
									Source: "columns: {_time: \"time\"}",
									Start: ast.Position{
										Column: 12,
										Line:   696,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   696,
										},
										File:   "elapsed_test.flux",
										Source: "columns: {_time: \"time\"}",
										Start: ast.Position{
											Column: 12,
											Line:   696,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   696,
											},
											File:   "elapsed_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 12,
												Line:   696,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   696,
											},
											File:   "elapsed_test.flux",
											Source: "{_time: \"time\"}",
											Start: ast.Position{
												Column: 21,
												Line:   696,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   696,
												},
												File:   "elapsed_test.flux",
												Source: "_time: \"time\"",
												Start: ast.Position{
													Column: 22,
													Line:   696,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   696,
													},
													File:   "elapsed_test.flux",
													Source: "_time",
													Start: ast.Position{
														Column: 22,
														Line:   696,
													},
												},
											},
											Name: "_time",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   696,
													},
													File:   "elapsed_test.flux",
													Source: "\"time\"",
													Start: ast.Position{
														Column: 29,
														Line:   696,
													},
												},
											},
											Value: "time",
										},
									}},
									With: nil,
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   696,
								},
								File:   "elapsed_test.flux",
								Source: "rename(columns: {_time: \"time\"})",
								Start: ast.Position{
									Column: 5,
									Line:   696,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   696,
									},
									File:   "elapsed_test.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 5,
										Line:   696,
									},
								},
							},
							Name: "rename",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   691,
							},
							File:   "elapsed_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 14,
								Line:   691,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   691,
								},
								File:   "elapsed_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 14,
									Line:   691,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   691,
							},
							File:   "elapsed_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 21,
								Line:   691,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   702,
						},
						File:   "elapsed_test.flux",
						Source: "_elapsed = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_elapsed,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   698,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   698,
							},
							File:   "elapsed_test.flux",
							Source: "_elapsed",
							Start: ast.Position{
								Column: 6,
								Line:   698,
							},
						},
					},
					Name: "_elapsed",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   702,
							},
							File:   "elapsed_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_elapsed,\n})",
							Start: ast.Position{
								Column: 17,
								Line:   698,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   702,
								},
								File:   "elapsed_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_elapsed,\n})",
								Start: ast.Position{
									Column: 23,
									Line:   698,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   702,
									},
									File:   "elapsed_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_elapsed,\n}",
									Start: ast.Position{
										Column: 24,
										Line:   698,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   699,
										},
										File:   "elapsed_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   699,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   699,
											},
											File:   "elapsed_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   699,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   699,
												},
												File:   "elapsed_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   699,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   699,
													},
													File:   "elapsed_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   699,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   699,
														},
														File:   "elapsed_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   699,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   699,
														},
														File:   "elapsed_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   699,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   699,
											},
											File:   "elapsed_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   699,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   699,
												},
												File:   "elapsed_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   699,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   699,
													},
													File:   "elapsed_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   699,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   699,
													},
													File:   "elapsed_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   699,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   700,
										},
										File:   "elapsed_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   700,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   700,
											},
											File:   "elapsed_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   700,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   700,
												},
												File:   "elapsed_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   700,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   700,
													},
													File:   "elapsed_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   700,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   700,
														},
														File:   "elapsed_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   700,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   700,
														},
														File:   "elapsed_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   700,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   700,
											},
											File:   "elapsed_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   700,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   700,
												},
												File:   "elapsed_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   700,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   700,
													},
													File:   "elapsed_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   700,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   700,
													},
													File:   "elapsed_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   700,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   701,
										},
										File:   "elapsed_test.flux",
										Source: "fn: t_elapsed",
										Start: ast.Position{
											Column: 2,
											Line:   701,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   701,
											},
											File:   "elapsed_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   701,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   701,
											},
											File:   "elapsed_test.flux",
											Source: "t_elapsed",
											Start: ast.Position{
												Column: 6,
												Line:   701,
											},
										},
									},
									Name: "t_elapsed",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   702,
					},
					File:   "elapsed_test.flux",
					Source: "test _elapsed = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_elapsed,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   698,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "elapsed_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "elapsed_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "elapsed_test.flux",
					Source: "import \"internal/influxql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "elapsed_test.flux",
						Source: "\"internal/influxql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/influxql",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "elapsed_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "elapsed_test.flux",
					Source: "package influxql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "elapsed_test.flux",
						Source: "influxql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxql_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   255,
				},
				File:   "filter_by_regex_tag_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,hex,0x0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,hex,0x1,n,1\n,,2,1970-01-01T00:00:00.000000016Z,hex,0x10,n,16\n,,3,1970-01-01T00:00:00.000000017Z,hex,0x11,n,17\n,,4,1970-01-01T00:00:00.000000018Z,hex,0x12,n,18\n,,5,1970-01-01T00:00:00.000000019Z,hex,0x13,n,19\n,,6,1970-01-01T00:00:00.00000002Z,hex,0x14,n,20\n,,7,1970-01-01T00:00:00.000000021Z,hex,0x15,n,21\n,,8,1970-01-01T00:00:00.000000022Z,hex,0x16,n,22\n,,9,1970-01-01T00:00:00.000000023Z,hex,0x17,n,23\n,,10,1970-01-01T00:00:00.000000024Z,hex,0x18,n,24\n,,11,1970-01-01T00:00:00.000000025Z,hex,0x19,n,25\n,,12,1970-01-01T00:00:00.000000026Z,hex,0x1a,n,26\n,,13,1970-01-01T00:00:00.000000027Z,hex,0x1b,n,27\n,,14,1970-01-01T00:00:00.000000028Z,hex,0x1c,n,28\n,,15,1970-01-01T00:00:00.000000029Z,hex,0x1d,n,29\n,,16,1970-01-01T00:00:00.00000003Z,hex,0x1e,n,30\n,,17,1970-01-01T00:00:00.000000031Z,hex,0x1f,n,31\n,,18,1970-01-01T00:00:00.000000002Z,hex,0x2,n,2\n,,19,1970-01-01T00:00:00.000000032Z,hex,0x20,n,32\n,,20,1970-01-01T00:00:00.000000033Z,hex,0x21,n,33\n,,21,1970-01-01T00:00:00.000000034Z,hex,0x22,n,34\n,,22,1970-01-01T00:00:00.000000035Z,hex,0x23,n,35\n,,23,1970-01-01T00:00:00.000000036Z,hex,0x24,n,36\n,,24,1970-01-01T00:00:00.000000037Z,hex,0x25,n,37\n,,25,1970-01-01T00:00:00.000000038Z,hex,0x26,n,38\n,,26,1970-01-01T00:00:00.000000039Z,hex,0x27,n,39\n,,27,1970-01-01T00:00:00.00000004Z,hex,0x28,n,40\n,,28,1970-01-01T00:00:00.000000041Z,hex,0x29,n,41\n,,29,1970-01-01T00:00:00.000000042Z,hex,0x2a,n,42\n,,30,1970-01-01T00:00:00.000000043Z,hex,0x2b,n,43\n,,31,1970-01-01T00:00:00.000000044Z,hex,0x2c,n,44\n,,32,1970-01-01T00:00:00.000000045Z,hex,0x2d,n,45\n,,33,1970-01-01T00:00:00.000000046Z,hex,0x2e,n,46\n,,34,1970-01-01T00:00:00.000000047Z,hex,0x2f,n,47\n,,35,1970-01-01T00:00:00.000000003Z,hex,0x3,n,3\n,,36,1970-01-01T00:00:00.000000048Z,hex,0x30,n,48\n,,37,1970-01-01T00:00:00.000000049Z,hex,0x31,n,49\n,,38,1970-01-01T00:00:00.00000005Z,hex,0x32,n,50\n,,39,1970-01-01T00:00:00.000000051Z,hex,0x33,n,51\n,,40,1970-01-01T00:00:00.000000052Z,hex,0x34,n,52\n,,41,1970-01-01T00:00:00.000000053Z,hex,0x35,n,53\n,,42,1970-01-01T00:00:00.000000054Z,hex,0x36,n,54\n,,43,1970-01-01T00:00:00.000000055Z,hex,0x37,n,55\n,,44,1970-01-01T00:00:00.000000056Z,hex,0x38,n,56\n,,45,1970-01-01T00:00:00.000000057Z,hex,0x39,n,57\n,,46,1970-01-01T00:00:00.000000058Z,hex,0x3a,n,58\n,,47,1970-01-01T00:00:00.000000059Z,hex,0x3b,n,59\n,,48,1970-01-01T00:00:00.00000006Z,hex,0x3c,n,60\n,,49,1970-01-01T00:00:00.000000061Z,hex,0x3d,n,61\n,,50,1970-01-01T00:00:00.000000062Z,hex,0x3e,n,62\n,,51,1970-01-01T00:00:00.000000063Z,hex,0x3f,n,63\n,,52,1970-01-01T00:00:00.000000004Z,hex,0x4,n,4\n,,53,1970-01-01T00:00:00.000000064Z,hex,0x40,n,64\n,,54,1970-01-01T00:00:00.000000065Z,hex,0x41,n,65\n,,55,1970-01-01T00:00:00.000000066Z,hex,0x42,n,66\n,,56,1970-01-01T00:00:00.000000067Z,hex,0x43,n,67\n,,57,1970-01-01T00:00:00.000000068Z,hex,0x44,n,68\n,,58,1970-01-01T00:00:00.000000069Z,hex,0x45,n,69\n,,59,1970-01-01T00:00:00.00000007Z,hex,0x46,n,70\n,,60,1970-01-01T00:00:00.000000071Z,hex,0x47,n,71\n,,61,1970-01-01T00:00:00.000000072Z,hex,0x48,n,72\n,,62,1970-01-01T00:00:00.000000073Z,hex,0x49,n,73\n,,63,1970-01-01T00:00:00.000000074Z,hex,0x4a,n,74\n,,64,1970-01-01T00:00:00.000000075Z,hex,0x4b,n,75\n,,65,1970-01-01T00:00:00.000000076Z,hex,0x4c,n,76\n,,66,1970-01-01T00:00:00.000000077Z,hex,0x4d,n,77\n,,67,1970-01-01T00:00:00.000000078Z,hex,0x4e,n,78\n,,68,1970-01-01T00:00:00.000000079Z,hex,0x4f,n,79\n,,69,1970-01-01T00:00:00.000000005Z,hex,0x5,n,5\n,,70,1970-01-01T00:00:00.00000008Z,hex,0x50,n,80\n,,71,1970-01-01T00:00:00.000000081Z,hex,0x51,n,81\n,,72,1970-01-01T00:00:00.000000082Z,hex,0x52,n,82\n,,73,1970-01-01T00:00:00.000000083Z,hex,0x53,n,83\n,,74,1970-01-01T00:00:00.000000084Z,hex,0x54,n,84\n,,75,1970-01-01T00:00:00.000000085Z,hex,0x55,n,85\n,,76,1970-01-01T00:00:00.000000086Z,hex,0x56,n,86\n,,77,1970-01-01T00:00:00.000000087Z,hex,0x57,n,87\n,,78,1970-01-01T00:00:00.000000088Z,hex,0x58,n,88\n,,79,1970-01-01T00:00:00.000000089Z,hex,0x59,n,89\n,,80,1970-01-01T00:00:00.00000009Z,hex,0x5a,n,90\n,,81,1970-01-01T00:00:00.000000091Z,hex,0x5b,n,91\n,,82,1970-01-01T00:00:00.000000092Z,hex,0x5c,n,92\n,,83,1970-01-01T00:00:00.000000093Z,hex,0x5d,n,93\n,,84,1970-01-01T00:00:00.000000094Z,hex,0x5e,n,94\n,,85,1970-01-01T00:00:00.000000095Z,hex,0x5f,n,95\n,,86,1970-01-01T00:00:00.000000006Z,hex,0x6,n,6\n,,87,1970-01-01T00:00:00.000000096Z,hex,0x60,n,96\n,,88,1970-01-01T00:00:00.000000097Z,hex,0x61,n,97\n,,89,1970-01-01T00:00:00.000000098Z,hex,0x62,n,98\n,,90,1970-01-01T00:00:00.000000099Z,hex,0x63,n,99\n,,91,1970-01-01T00:00:00.0000001Z,hex,0x64,n,100\n,,92,1970-01-01T00:00:00.000000101Z,hex,0x65,n,101\n,,93,1970-01-01T00:00:00.000000102Z,hex,0x66,n,102\n,,94,1970-01-01T00:00:00.000000103Z,hex,0x67,n,103\n,,95,1970-01-01T00:00:00.000000104Z,hex,0x68,n,104\n,,96,1970-01-01T00:00:00.000000105Z,hex,0x69,n,105\n,,97,1970-01-01T00:00:00.000000106Z,hex,0x6a,n,106\n,,98,1970-01-01T00:00:00.000000107Z,hex,0x6b,n,107\n,,99,1970-01-01T00:00:00.000000108Z,hex,0x6c,n,108\n,,100,1970-01-01T00:00:00.000000109Z,hex,0x6d,n,109\n,,101,1970-01-01T00:00:00.00000011Z,hex,0x6e,n,110\n,,102,1970-01-01T00:00:00.000000111Z,hex,0x6f,n,111\n,,103,1970-01-01T00:00:00.000000007Z,hex,0x7,n,7\n,,104,1970-01-01T00:00:00.000000112Z,hex,0x70,n,112\n,,105,1970-01-01T00:00:00.000000113Z,hex,0x71,n,113\n,,106,1970-01-01T00:00:00.000000114Z,hex,0x72,n,114\n,,107,1970-01-01T00:00:00.000000115Z,hex,0x73,n,115\n,,108,1970-01-01T00:00:00.000000116Z,hex,0x74,n,116\n,,109,1970-01-01T00:00:00.000000117Z,hex,0x75,n,117\n,,110,1970-01-01T00:00:00.000000118Z,hex,0x76,n,118\n,,111,1970-01-01T00:00:00.000000119Z,hex,0x77,n,119\n,,112,1970-01-01T00:00:00.00000012Z,hex,0x78,n,120\n,,113,1970-01-01T00:00:00.000000121Z,hex,0x79,n,121\n,,114,1970-01-01T00:00:00.000000122Z,hex,0x7a,n,122\n,,115,1970-01-01T00:00:00.000000123Z,hex,0x7b,n,123\n,,116,1970-01-01T00:00:00.000000124Z,hex,0x7c,n,124\n,,117,1970-01-01T00:00:00.000000125Z,hex,0x7d,n,125\n,,118,1970-01-01T00:00:00.000000126Z,hex,0x7e,n,126\n,,119,1970-01-01T00:00:00.000000127Z,hex,0x7f,n,127\n,,120,1970-01-01T00:00:00.000000008Z,hex,0x8,n,8\n,,121,1970-01-01T00:00:00.000000128Z,hex,0x80,n,128\n,,122,1970-01-01T00:00:00.000000129Z,hex,0x81,n,129\n,,123,1970-01-01T00:00:00.00000013Z,hex,0x82,n,130\n,,124,1970-01-01T00:00:00.000000131Z,hex,0x83,n,131\n,,125,1970-01-01T00:00:00.000000132Z,hex,0x84,n,132\n,,126,1970-01-01T00:00:00.000000133Z,hex,0x85,n,133\n,,127,1970-01-01T00:00:00.000000134Z,hex,0x86,n,134\n,,128,1970-01-01T00:00:00.000000135Z,hex,0x87,n,135\n,,129,1970-01-01T00:00:00.000000136Z,hex,0x88,n,136\n,,130,1970-01-01T00:00:00.000000137Z,hex,0x89,n,137\n,,131,1970-01-01T00:00:00.000000138Z,hex,0x8a,n,138\n,,132,1970-01-01T00:00:00.000000139Z,hex,0x8b,n,139\n,,133,1970-01-01T00:00:00.00000014Z,hex,0x8c,n,140\n,,134,1970-01-01T00:00:00.000000141Z,hex,0x8d,n,141\n,,135,1970-01-01T00:00:00.000000142Z,hex,0x8e,n,142\n,,136,1970-01-01T00:00:00.000000143Z,hex,0x8f,n,143\n,,137,1970-01-01T00:00:00.000000009Z,hex,0x9,n,9\n,,138,1970-01-01T00:00:00.000000144Z,hex,0x90,n,144\n,,139,1970-01-01T00:00:00.000000145Z,hex,0x91,n,145\n,,140,1970-01-01T00:00:00.000000146Z,hex,0x92,n,146\n,,141,1970-01-01T00:00:00.000000147Z,hex,0x93,n,147\n,,142,1970-01-01T00:00:00.000000148Z,hex,0x94,n,148\n,,143,1970-01-01T00:00:00.000000149Z,hex,0x95,n,149\n,,144,1970-01-01T00:00:00.00000015Z,hex,0x96,n,150\n,,145,1970-01-01T00:00:00.000000151Z,hex,0x97,n,151\n,,146,1970-01-01T00:00:00.000000152Z,hex,0x98,n,152\n,,147,1970-01-01T00:00:00.000000153Z,hex,0x99,n,153\n,,148,1970-01-01T00:00:00.000000154Z,hex,0x9a,n,154\n,,149,1970-01-01T00:00:00.000000155Z,hex,0x9b,n,155\n,,150,1970-01-01T00:00:00.000000156Z,hex,0x9c,n,156\n,,151,1970-01-01T00:00:00.000000157Z,hex,0x9d,n,157\n,,152,1970-01-01T00:00:00.000000158Z,hex,0x9e,n,158\n,,153,1970-01-01T00:00:00.000000159Z,hex,0x9f,n,159\n,,154,1970-01-01T00:00:00.00000001Z,hex,0xa,n,10\n,,155,1970-01-01T00:00:00.00000016Z,hex,0xa0,n,160\n,,156,1970-01-01T00:00:00.000000161Z,hex,0xa1,n,161\n,,157,1970-01-01T00:00:00.000000162Z,hex,0xa2,n,162\n,,158,1970-01-01T00:00:00.000000163Z,hex,0xa3,n,163\n,,159,1970-01-01T00:00:00.000000164Z,hex,0xa4,n,164\n,,160,1970-01-01T00:00:00.000000165Z,hex,0xa5,n,165\n,,161,1970-01-01T00:00:00.000000166Z,hex,0xa6,n,166\n,,162,1970-01-01T00:00:00.000000167Z,hex,0xa7,n,167\n,,163,1970-01-01T00:00:00.000000168Z,hex,0xa8,n,168\n,,164,1970-01-01T00:00:00.000000169Z,hex,0xa9,n,169\n,,165,1970-01-01T00:00:00.00000017Z,hex,0xaa,n,170\n,,166,1970-01-01T00:00:00.000000171Z,hex,0xab,n,171\n,,167,1970-01-01T00:00:00.000000172Z,hex,0xac,n,172\n,,168,1970-01-01T00:00:00.000000173Z,hex,0xad,n,173\n,,169,1970-01-01T00:00:00.000000174Z,hex,0xae,n,174\n,,170,1970-01-01T00:00:00.000000175Z,hex,0xaf,n,175\n,,171,1970-01-01T00:00:00.000000011Z,hex,0xb,n,11\n,,172,1970-01-01T00:00:00.000000176Z,hex,0xb0,n,176\n,,173,1970-01-01T00:00:00.000000177Z,hex,0xb1,n,177\n,,174,1970-01-01T00:00:00.000000178Z,hex,0xb2,n,178\n,,175,1970-01-01T00:00:00.000000179Z,hex,0xb3,n,179\n,,176,1970-01-01T00:00:00.00000018Z,hex,0xb4,n,180\n,,177,1970-01-01T00:00:00.000000181Z,hex,0xb5,n,181\n,,178,1970-01-01T00:00:00.000000182Z,hex,0xb6,n,182\n,,179,1970-01-01T00:00:00.000000183Z,hex,0xb7,n,183\n,,180,1970-01-01T00:00:00.000000184Z,hex,0xb8,n,184\n,,181,1970-01-01T00:00:00.000000185Z,hex,0xb9,n,185\n,,182,1970-01-01T00:00:00.000000186Z,hex,0xba,n,186\n,,183,1970-01-01T00:00:00.000000187Z,hex,0xbb,n,187\n,,184,1970-01-01T00:00:00.000000188Z,hex,0xbc,n,188\n,,185,1970-01-01T00:00:00.000000189Z,hex,0xbd,n,189\n,,186,1970-01-01T00:00:00.00000019Z,hex,0xbe,n,190\n,,187,1970-01-01T00:00:00.000000191Z,hex,0xbf,n,191\n,,188,1970-01-01T00:00:00.000000012Z,hex,0xc,n,12\n,,189,1970-01-01T00:00:00.000000192Z,hex,0xc0,n,192\n,,190,1970-01-01T00:00:00.000000193Z,hex,0xc1,n,193\n,,191,1970-01-01T00:00:00.000000194Z,hex,0xc2,n,194\n,,192,1970-01-01T00:00:00.000000195Z,hex,0xc3,n,195\n,,193,1970-01-01T00:00:00.000000196Z,hex,0xc4,n,196\n,,194,1970-01-01T00:00:00.000000197Z,hex,0xc5,n,197\n,,195,1970-01-01T00:00:00.000000198Z,hex,0xc6,n,198\n,,196,1970-01-01T00:00:00.000000199Z,hex,0xc7,n,199\n,,197,1970-01-01T00:00:00.000000013Z,hex,0xd,n,13\n,,198,1970-01-01T00:00:00.000000014Z,hex,0xe,n,14\n,,199,1970-01-01T00:00:00.000000015Z,hex,0xf,n,15\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000003Z,hex,3\n,,0,1970-01-01T00:00:00.00000002Z,hex,20\n,,0,1970-01-01T00:00:00.000000025Z,hex,25\n,,0,1970-01-01T00:00:00.000000041Z,hex,41\n,,0,1970-01-01T00:00:00.000000085Z,hex,85\n,,0,1970-01-01T00:00:00.000000086Z,hex,86\n,,0,1970-01-01T00:00:00.00000009Z,hex,90\n,,0,1970-01-01T00:00:00.000000101Z,hex,101\n,,0,1970-01-01T00:00:00.000000112Z,hex,112\n,,0,1970-01-01T00:00:00.000000123Z,hex,123\n,,0,1970-01-01T00:00:00.000000125Z,hex,125\n,,0,1970-01-01T00:00:00.000000129Z,hex,129\n,,0,1970-01-01T00:00:00.00000013Z,hex,130\n,,0,1970-01-01T00:00:00.000000137Z,hex,137\n,,0,1970-01-01T00:00:00.00000016Z,hex,160\n,,0,1970-01-01T00:00:00.000000163Z,hex,163\n,,0,1970-01-01T00:00:00.000000183Z,hex,183\n,,0,1970-01-01T00:00:00.000000185Z,hex,185\n,,0,1970-01-01T00:00:00.000000193Z,hex,193\n,,0,1970-01-01T00:00:00.000000199Z,hex,199\n\"\n\n// SELECT n FROM hex WHERE t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/\nt_filter_by_regex_tag = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})\n\ntest _filter_by_regex_tag = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_regex_tag,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   211,
					},
					File:   "filter_by_regex_tag_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,hex,0x0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,hex,0x1,n,1\n,,2,1970-01-01T00:00:00.000000016Z,hex,0x10,n,16\n,,3,1970-01-01T00:00:00.000000017Z,hex,0x11,n,17\n,,4,1970-01-01T00:00:00.000000018Z,hex,0x12,n,18\n,,5,1970-01-01T00:00:00.000000019Z,hex,0x13,n,19\n,,6,1970-01-01T00:00:00.00000002Z,hex,0x14,n,20\n,,7,1970-01-01T00:00:00.000000021Z,hex,0x15,n,21\n,,8,1970-01-01T00:00:00.000000022Z,hex,0x16,n,22\n,,9,1970-01-01T00:00:00.000000023Z,hex,0x17,n,23\n,,10,1970-01-01T00:00:00.000000024Z,hex,0x18,n,24\n,,11,1970-01-01T00:00:00.000000025Z,hex,0x19,n,25\n,,12,1970-01-01T00:00:00.000000026Z,hex,0x1a,n,26\n,,13,1970-01-01T00:00:00.000000027Z,hex,0x1b,n,27\n,,14,1970-01-01T00:00:00.000000028Z,hex,0x1c,n,28\n,,15,1970-01-01T00:00:00.000000029Z,hex,0x1d,n,29\n,,16,1970-01-01T00:00:00.00000003Z,hex,0x1e,n,30\n,,17,1970-01-01T00:00:00.000000031Z,hex,0x1f,n,31\n,,18,1970-01-01T00:00:00.000000002Z,hex,0x2,n,2\n,,19,1970-01-01T00:00:00.000000032Z,hex,0x20,n,32\n,,20,1970-01-01T00:00:00.000000033Z,hex,0x21,n,33\n,,21,1970-01-01T00:00:00.000000034Z,hex,0x22,n,34\n,,22,1970-01-01T00:00:00.000000035Z,hex,0x23,n,35\n,,23,1970-01-01T00:00:00.000000036Z,hex,0x24,n,36\n,,24,1970-01-01T00:00:00.000000037Z,hex,0x25,n,37\n,,25,1970-01-01T00:00:00.000000038Z,hex,0x26,n,38\n,,26,1970-01-01T00:00:00.000000039Z,hex,0x27,n,39\n,,27,1970-01-01T00:00:00.00000004Z,hex,0x28,n,40\n,,28,1970-01-01T00:00:00.000000041Z,hex,0x29,n,41\n,,29,1970-01-01T00:00:00.000000042Z,hex,0x2a,n,42\n,,30,1970-01-01T00:00:00.000000043Z,hex,0x2b,n,43\n,,31,1970-01-01T00:00:00.000000044Z,hex,0x2c,n,44\n,,32,1970-01-01T00:00:00.000000045Z,hex,0x2d,n,45\n,,33,1970-01-01T00:00:00.000000046Z,hex,0x2e,n,46\n,,34,1970-01-01T00:00:00.000000047Z,hex,0x2f,n,47\n,,35,1970-01-01T00:00:00.000000003Z,hex,0x3,n,3\n,,36,1970-01-01T00:00:00.000000048Z,hex,0x30,n,48\n,,37,1970-01-01T00:00:00.000000049Z,hex,0x31,n,49\n,,38,1970-01-01T00:00:00.00000005Z,hex,0x32,n,50\n,,39,1970-01-01T00:00:00.000000051Z,hex,0x33,n,51\n,,40,1970-01-01T00:00:00.000000052Z,hex,0x34,n,52\n,,41,1970-01-01T00:00:00.000000053Z,hex,0x35,n,53\n,,42,1970-01-01T00:00:00.000000054Z,hex,0x36,n,54\n,,43,1970-01-01T00:00:00.000000055Z,hex,0x37,n,55\n,,44,1970-01-01T00:00:00.000000056Z,hex,0x38,n,56\n,,45,1970-01-01T00:00:00.000000057Z,hex,0x39,n,57\n,,46,1970-01-01T00:00:00.000000058Z,hex,0x3a,n,58\n,,47,1970-01-01T00:00:00.000000059Z,hex,0x3b,n,59\n,,48,1970-01-01T00:00:00.00000006Z,hex,0x3c,n,60\n,,49,1970-01-01T00:00:00.000000061Z,hex,0x3d,n,61\n,,50,1970-01-01T00:00:00.000000062Z,hex,0x3e,n,62\n,,51,1970-01-01T00:00:00.000000063Z,hex,0x3f,n,63\n,,52,1970-01-01T00:00:00.000000004Z,hex,0x4,n,4\n,,53,1970-01-01T00:00:00.000000064Z,hex,0x40,n,64\n,,54,1970-01-01T00:00:00.000000065Z,hex,0x41,n,65\n,,55,1970-01-01T00:00:00.000000066Z,hex,0x42,n,66\n,,56,1970-01-01T00:00:00.000000067Z,hex,0x43,n,67\n,,57,1970-01-01T00:00:00.000000068Z,hex,0x44,n,68\n,,58,1970-01-01T00:00:00.000000069Z,hex,0x45,n,69\n,,59,1970-01-01T00:00:00.00000007Z,hex,0x46,n,70\n,,60,1970-01-01T00:00:00.000000071Z,hex,0x47,n,71\n,,61,1970-01-01T00:00:00.000000072Z,hex,0x48,n,72\n,,62,1970-01-01T00:00:00.000000073Z,hex,0x49,n,73\n,,63,1970-01-01T00:00:00.000000074Z,hex,0x4a,n,74\n,,64,1970-01-01T00:00:00.000000075Z,hex,0x4b,n,75\n,,65,1970-01-01T00:00:00.000000076Z,hex,0x4c,n,76\n,,66,1970-01-01T00:00:00.000000077Z,hex,0x4d,n,77\n,,67,1970-01-01T00:00:00.000000078Z,hex,0x4e,n,78\n,,68,1970-01-01T00:00:00.000000079Z,hex,0x4f,n,79\n,,69,1970-01-01T00:00:00.000000005Z,hex,0x5,n,5\n,,70,1970-01-01T00:00:00.00000008Z,hex,0x50,n,80\n,,71,1970-01-01T00:00:00.000000081Z,hex,0x51,n,81\n,,72,1970-01-01T00:00:00.000000082Z,hex,0x52,n,82\n,,73,1970-01-01T00:00:00.000000083Z,hex,0x53,n,83\n,,74,1970-01-01T00:00:00.000000084Z,hex,0x54,n,84\n,,75,1970-01-01T00:00:00.000000085Z,hex,0x55,n,85\n,,76,1970-01-01T00:00:00.000000086Z,hex,0x56,n,86\n,,77,1970-01-01T00:00:00.000000087Z,hex,0x57,n,87\n,,78,1970-01-01T00:00:00.000000088Z,hex,0x58,n,88\n,,79,1970-01-01T00:00:00.000000089Z,hex,0x59,n,89\n,,80,1970-01-01T00:00:00.00000009Z,hex,0x5a,n,90\n,,81,1970-01-01T00:00:00.000000091Z,hex,0x5b,n,91\n,,82,1970-01-01T00:00:00.000000092Z,hex,0x5c,n,92\n,,83,1970-01-01T00:00:00.000000093Z,hex,0x5d,n,93\n,,84,1970-01-01T00:00:00.000000094Z,hex,0x5e,n,94\n,,85,1970-01-01T00:00:00.000000095Z,hex,0x5f,n,95\n,,86,1970-01-01T00:00:00.000000006Z,hex,0x6,n,6\n,,87,1970-01-01T00:00:00.000000096Z,hex,0x60,n,96\n,,88,1970-01-01T00:00:00.000000097Z,hex,0x61,n,97\n,,89,1970-01-01T00:00:00.000000098Z,hex,0x62,n,98\n,,90,1970-01-01T00:00:00.000000099Z,hex,0x63,n,99\n,,91,1970-01-01T00:00:00.0000001Z,hex,0x64,n,100\n,,92,1970-01-01T00:00:00.000000101Z,hex,0x65,n,101\n,,93,1970-01-01T00:00:00.000000102Z,hex,0x66,n,102\n,,94,1970-01-01T00:00:00.000000103Z,hex,0x67,n,103\n,,95,1970-01-01T00:00:00.000000104Z,hex,0x68,n,104\n,,96,1970-01-01T00:00:00.000000105Z,hex,0x69,n,105\n,,97,1970-01-01T00:00:00.000000106Z,hex,0x6a,n,106\n,,98,1970-01-01T00:00:00.000000107Z,hex,0x6b,n,107\n,,99,1970-01-01T00:00:00.000000108Z,hex,0x6c,n,108\n,,100,1970-01-01T00:00:00.000000109Z,hex,0x6d,n,109\n,,101,1970-01-01T00:00:00.00000011Z,hex,0x6e,n,110\n,,102,1970-01-01T00:00:00.000000111Z,hex,0x6f,n,111\n,,103,1970-01-01T00:00:00.000000007Z,hex,0x7,n,7\n,,104,1970-01-01T00:00:00.000000112Z,hex,0x70,n,112\n,,105,1970-01-01T00:00:00.000000113Z,hex,0x71,n,113\n,,106,1970-01-01T00:00:00.000000114Z,hex,0x72,n,114\n,,107,1970-01-01T00:00:00.000000115Z,hex,0x73,n,115\n,,108,1970-01-01T00:00:00.000000116Z,hex,0x74,n,116\n,,109,1970-01-01T00:00:00.000000117Z,hex,0x75,n,117\n,,110,1970-01-01T00:00:00.000000118Z,hex,0x76,n,118\n,,111,1970-01-01T00:00:00.000000119Z,hex,0x77,n,119\n,,112,1970-01-01T00:00:00.00000012Z,hex,0x78,n,120\n,,113,1970-01-01T00:00:00.000000121Z,hex,0x79,n,121\n,,114,1970-01-01T00:00:00.000000122Z,hex,0x7a,n,122\n,,115,1970-01-01T00:00:00.000000123Z,hex,0x7b,n,123\n,,116,1970-01-01T00:00:00.000000124Z,hex,0x7c,n,124\n,,117,1970-01-01T00:00:00.000000125Z,hex,0x7d,n,125\n,,118,1970-01-01T00:00:00.000000126Z,hex,0x7e,n,126\n,,119,1970-01-01T00:00:00.000000127Z,hex,0x7f,n,127\n,,120,1970-01-01T00:00:00.000000008Z,hex,0x8,n,8\n,,121,1970-01-01T00:00:00.000000128Z,hex,0x80,n,128\n,,122,1970-01-01T00:00:00.000000129Z,hex,0x81,n,129\n,,123,1970-01-01T00:00:00.00000013Z,hex,0x82,n,130\n,,124,1970-01-01T00:00:00.000000131Z,hex,0x83,n,131\n,,125,1970-01-01T00:00:00.000000132Z,hex,0x84,n,132\n,,126,1970-01-01T00:00:00.000000133Z,hex,0x85,n,133\n,,127,1970-01-01T00:00:00.000000134Z,hex,0x86,n,134\n,,128,1970-01-01T00:00:00.000000135Z,hex,0x87,n,135\n,,129,1970-01-01T00:00:00.000000136Z,hex,0x88,n,136\n,,130,1970-01-01T00:00:00.000000137Z,hex,0x89,n,137\n,,131,1970-01-01T00:00:00.000000138Z,hex,0x8a,n,138\n,,132,1970-01-01T00:00:00.000000139Z,hex,0x8b,n,139\n,,133,1970-01-01T00:00:00.00000014Z,hex,0x8c,n,140\n,,134,1970-01-01T00:00:00.000000141Z,hex,0x8d,n,141\n,,135,1970-01-01T00:00:00.000000142Z,hex,0x8e,n,142\n,,136,1970-01-01T00:00:00.000000143Z,hex,0x8f,n,143\n,,137,1970-01-01T00:00:00.000000009Z,hex,0x9,n,9\n,,138,1970-01-01T00:00:00.000000144Z,hex,0x90,n,144\n,,139,1970-01-01T00:00:00.000000145Z,hex,0x91,n,145\n,,140,1970-01-01T00:00:00.000000146Z,hex,0x92,n,146\n,,141,1970-01-01T00:00:00.000000147Z,hex,0x93,n,147\n,,142,1970-01-01T00:00:00.000000148Z,hex,0x94,n,148\n,,143,1970-01-01T00:00:00.000000149Z,hex,0x95,n,149\n,,144,1970-01-01T00:00:00.00000015Z,hex,0x96,n,150\n,,145,1970-01-01T00:00:00.000000151Z,hex,0x97,n,151\n,,146,1970-01-01T00:00:00.000000152Z,hex,0x98,n,152\n,,147,1970-01-01T00:00:00.000000153Z,hex,0x99,n,153\n,,148,1970-01-01T00:00:00.000000154Z,hex,0x9a,n,154\n,,149,1970-01-01T00:00:00.000000155Z,hex,0x9b,n,155\n,,150,1970-01-01T00:00:00.000000156Z,hex,0x9c,n,156\n,,151,1970-01-01T00:00:00.000000157Z,hex,0x9d,n,157\n,,152,1970-01-01T00:00:00.000000158Z,hex,0x9e,n,158\n,,153,1970-01-01T00:00:00.000000159Z,hex,0x9f,n,159\n,,154,1970-01-01T00:00:00.00000001Z,hex,0xa,n,10\n,,155,1970-01-01T00:00:00.00000016Z,hex,0xa0,n,160\n,,156,1970-01-01T00:00:00.000000161Z,hex,0xa1,n,161\n,,157,1970-01-01T00:00:00.000000162Z,hex,0xa2,n,162\n,,158,1970-01-01T00:00:00.000000163Z,hex,0xa3,n,163\n,,159,1970-01-01T00:00:00.000000164Z,hex,0xa4,n,164\n,,160,1970-01-01T00:00:00.000000165Z,hex,0xa5,n,165\n,,161,1970-01-01T00:00:00.000000166Z,hex,0xa6,n,166\n,,162,1970-01-01T00:00:00.000000167Z,hex,0xa7,n,167\n,,163,1970-01-01T00:00:00.000000168Z,hex,0xa8,n,168\n,,164,1970-01-01T00:00:00.000000169Z,hex,0xa9,n,169\n,,165,1970-01-01T00:00:00.00000017Z,hex,0xaa,n,170\n,,166,1970-01-01T00:00:00.000000171Z,hex,0xab,n,171\n,,167,1970-01-01T00:00:00.000000172Z,hex,0xac,n,172\n,,168,1970-01-01T00:00:00.000000173Z,hex,0xad,n,173\n,,169,1970-01-01T00:00:00.000000174Z,hex,0xae,n,174\n,,170,1970-01-01T00:00:00.000000175Z,hex,0xaf,n,175\n,,171,1970-01-01T00:00:00.000000011Z,hex,0xb,n,11\n,,172,1970-01-01T00:00:00.000000176Z,hex,0xb0,n,176\n,,173,1970-01-01T00:00:00.000000177Z,hex,0xb1,n,177\n,,174,1970-01-01T00:00:00.000000178Z,hex,0xb2,n,178\n,,175,1970-01-01T00:00:00.000000179Z,hex,0xb3,n,179\n,,176,1970-01-01T00:00:00.00000018Z,hex,0xb4,n,180\n,,177,1970-01-01T00:00:00.000000181Z,hex,0xb5,n,181\n,,178,1970-01-01T00:00:00.000000182Z,hex,0xb6,n,182\n,,179,1970-01-01T00:00:00.000000183Z,hex,0xb7,n,183\n,,180,1970-01-01T00:00:00.000000184Z,hex,0xb8,n,184\n,,181,1970-01-01T00:00:00.000000185Z,hex,0xb9,n,185\n,,182,1970-01-01T00:00:00.000000186Z,hex,0xba,n,186\n,,183,1970-01-01T00:00:00.000000187Z,hex,0xbb,n,187\n,,184,1970-01-01T00:00:00.000000188Z,hex,0xbc,n,188\n,,185,1970-01-01T00:00:00.000000189Z,hex,0xbd,n,189\n,,186,1970-01-01T00:00:00.00000019Z,hex,0xbe,n,190\n,,187,1970-01-01T00:00:00.000000191Z,hex,0xbf,n,191\n,,188,1970-01-01T00:00:00.000000012Z,hex,0xc,n,12\n,,189,1970-01-01T00:00:00.000000192Z,hex,0xc0,n,192\n,,190,1970-01-01T00:00:00.000000193Z,hex,0xc1,n,193\n,,191,1970-01-01T00:00:00.000000194Z,hex,0xc2,n,194\n,,192,1970-01-01T00:00:00.000000195Z,hex,0xc3,n,195\n,,193,1970-01-01T00:00:00.000000196Z,hex,0xc4,n,196\n,,194,1970-01-01T00:00:00.000000197Z,hex,0xc5,n,197\n,,195,1970-01-01T00:00:00.000000198Z,hex,0xc6,n,198\n,,196,1970-01-01T00:00:00.000000199Z,hex,0xc7,n,199\n,,197,1970-01-01T00:00:00.000000013Z,hex,0xd,n,13\n,,198,1970-01-01T00:00:00.000000014Z,hex,0xe,n,14\n,,199,1970-01-01T00:00:00.000000015Z,hex,0xf,n,15\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   211,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,hex,0x0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,hex,0x1,n,1\n,,2,1970-01-01T00:00:00.000000016Z,hex,0x10,n,16\n,,3,1970-01-01T00:00:00.000000017Z,hex,0x11,n,17\n,,4,1970-01-01T00:00:00.000000018Z,hex,0x12,n,18\n,,5,1970-01-01T00:00:00.000000019Z,hex,0x13,n,19\n,,6,1970-01-01T00:00:00.00000002Z,hex,0x14,n,20\n,,7,1970-01-01T00:00:00.000000021Z,hex,0x15,n,21\n,,8,1970-01-01T00:00:00.000000022Z,hex,0x16,n,22\n,,9,1970-01-01T00:00:00.000000023Z,hex,0x17,n,23\n,,10,1970-01-01T00:00:00.000000024Z,hex,0x18,n,24\n,,11,1970-01-01T00:00:00.000000025Z,hex,0x19,n,25\n,,12,1970-01-01T00:00:00.000000026Z,hex,0x1a,n,26\n,,13,1970-01-01T00:00:00.000000027Z,hex,0x1b,n,27\n,,14,1970-01-01T00:00:00.000000028Z,hex,0x1c,n,28\n,,15,1970-01-01T00:00:00.000000029Z,hex,0x1d,n,29\n,,16,1970-01-01T00:00:00.00000003Z,hex,0x1e,n,30\n,,17,1970-01-01T00:00:00.000000031Z,hex,0x1f,n,31\n,,18,1970-01-01T00:00:00.000000002Z,hex,0x2,n,2\n,,19,1970-01-01T00:00:00.000000032Z,hex,0x20,n,32\n,,20,1970-01-01T00:00:00.000000033Z,hex,0x21,n,33\n,,21,1970-01-01T00:00:00.000000034Z,hex,0x22,n,34\n,,22,1970-01-01T00:00:00.000000035Z,hex,0x23,n,35\n,,23,1970-01-01T00:00:00.000000036Z,hex,0x24,n,36\n,,24,1970-01-01T00:00:00.000000037Z,hex,0x25,n,37\n,,25,1970-01-01T00:00:00.000000038Z,hex,0x26,n,38\n,,26,1970-01-01T00:00:00.000000039Z,hex,0x27,n,39\n,,27,1970-01-01T00:00:00.00000004Z,hex,0x28,n,40\n,,28,1970-01-01T00:00:00.000000041Z,hex,0x29,n,41\n,,29,1970-01-01T00:00:00.000000042Z,hex,0x2a,n,42\n,,30,1970-01-01T00:00:00.000000043Z,hex,0x2b,n,43\n,,31,1970-01-01T00:00:00.000000044Z,hex,0x2c,n,44\n,,32,1970-01-01T00:00:00.000000045Z,hex,0x2d,n,45\n,,33,1970-01-01T00:00:00.000000046Z,hex,0x2e,n,46\n,,34,1970-01-01T00:00:00.000000047Z,hex,0x2f,n,47\n,,35,1970-01-01T00:00:00.000000003Z,hex,0x3,n,3\n,,36,1970-01-01T00:00:00.000000048Z,hex,0x30,n,48\n,,37,1970-01-01T00:00:00.000000049Z,hex,0x31,n,49\n,,38,1970-01-01T00:00:00.00000005Z,hex,0x32,n,50\n,,39,1970-01-01T00:00:00.000000051Z,hex,0x33,n,51\n,,40,1970-01-01T00:00:00.000000052Z,hex,0x34,n,52\n,,41,1970-01-01T00:00:00.000000053Z,hex,0x35,n,53\n,,42,1970-01-01T00:00:00.000000054Z,hex,0x36,n,54\n,,43,1970-01-01T00:00:00.000000055Z,hex,0x37,n,55\n,,44,1970-01-01T00:00:00.000000056Z,hex,0x38,n,56\n,,45,1970-01-01T00:00:00.000000057Z,hex,0x39,n,57\n,,46,1970-01-01T00:00:00.000000058Z,hex,0x3a,n,58\n,,47,1970-01-01T00:00:00.000000059Z,hex,0x3b,n,59\n,,48,1970-01-01T00:00:00.00000006Z,hex,0x3c,n,60\n,,49,1970-01-01T00:00:00.000000061Z,hex,0x3d,n,61\n,,50,1970-01-01T00:00:00.000000062Z,hex,0x3e,n,62\n,,51,1970-01-01T00:00:00.000000063Z,hex,0x3f,n,63\n,,52,1970-01-01T00:00:00.000000004Z,hex,0x4,n,4\n,,53,1970-01-01T00:00:00.000000064Z,hex,0x40,n,64\n,,54,1970-01-01T00:00:00.000000065Z,hex,0x41,n,65\n,,55,1970-01-01T00:00:00.000000066Z,hex,0x42,n,66\n,,56,1970-01-01T00:00:00.000000067Z,hex,0x43,n,67\n,,57,1970-01-01T00:00:00.000000068Z,hex,0x44,n,68\n,,58,1970-01-01T00:00:00.000000069Z,hex,0x45,n,69\n,,59,1970-01-01T00:00:00.00000007Z,hex,0x46,n,70\n,,60,1970-01-01T00:00:00.000000071Z,hex,0x47,n,71\n,,61,1970-01-01T00:00:00.000000072Z,hex,0x48,n,72\n,,62,1970-01-01T00:00:00.000000073Z,hex,0x49,n,73\n,,63,1970-01-01T00:00:00.000000074Z,hex,0x4a,n,74\n,,64,1970-01-01T00:00:00.000000075Z,hex,0x4b,n,75\n,,65,1970-01-01T00:00:00.000000076Z,hex,0x4c,n,76\n,,66,1970-01-01T00:00:00.000000077Z,hex,0x4d,n,77\n,,67,1970-01-01T00:00:00.000000078Z,hex,0x4e,n,78\n,,68,1970-01-01T00:00:00.000000079Z,hex,0x4f,n,79\n,,69,1970-01-01T00:00:00.000000005Z,hex,0x5,n,5\n,,70,1970-01-01T00:00:00.00000008Z,hex,0x50,n,80\n,,71,1970-01-01T00:00:00.000000081Z,hex,0x51,n,81\n,,72,1970-01-01T00:00:00.000000082Z,hex,0x52,n,82\n,,73,1970-01-01T00:00:00.000000083Z,hex,0x53,n,83\n,,74,1970-01-01T00:00:00.000000084Z,hex,0x54,n,84\n,,75,1970-01-01T00:00:00.000000085Z,hex,0x55,n,85\n,,76,1970-01-01T00:00:00.000000086Z,hex,0x56,n,86\n,,77,1970-01-01T00:00:00.000000087Z,hex,0x57,n,87\n,,78,1970-01-01T00:00:00.000000088Z,hex,0x58,n,88\n,,79,1970-01-01T00:00:00.000000089Z,hex,0x59,n,89\n,,80,1970-01-01T00:00:00.00000009Z,hex,0x5a,n,90\n,,81,1970-01-01T00:00:00.000000091Z,hex,0x5b,n,91\n,,82,1970-01-01T00:00:00.000000092Z,hex,0x5c,n,92\n,,83,1970-01-01T00:00:00.000000093Z,hex,0x5d,n,93\n,,84,1970-01-01T00:00:00.000000094Z,hex,0x5e,n,94\n,,85,1970-01-01T00:00:00.000000095Z,hex,0x5f,n,95\n,,86,1970-01-01T00:00:00.000000006Z,hex,0x6,n,6\n,,87,1970-01-01T00:00:00.000000096Z,hex,0x60,n,96\n,,88,1970-01-01T00:00:00.000000097Z,hex,0x61,n,97\n,,89,1970-01-01T00:00:00.000000098Z,hex,0x62,n,98\n,,90,1970-01-01T00:00:00.000000099Z,hex,0x63,n,99\n,,91,1970-01-01T00:00:00.0000001Z,hex,0x64,n,100\n,,92,1970-01-01T00:00:00.000000101Z,hex,0x65,n,101\n,,93,1970-01-01T00:00:00.000000102Z,hex,0x66,n,102\n,,94,1970-01-01T00:00:00.000000103Z,hex,0x67,n,103\n,,95,1970-01-01T00:00:00.000000104Z,hex,0x68,n,104\n,,96,1970-01-01T00:00:00.000000105Z,hex,0x69,n,105\n,,97,1970-01-01T00:00:00.000000106Z,hex,0x6a,n,106\n,,98,1970-01-01T00:00:00.000000107Z,hex,0x6b,n,107\n,,99,1970-01-01T00:00:00.000000108Z,hex,0x6c,n,108\n,,100,1970-01-01T00:00:00.000000109Z,hex,0x6d,n,109\n,,101,1970-01-01T00:00:00.00000011Z,hex,0x6e,n,110\n,,102,1970-01-01T00:00:00.000000111Z,hex,0x6f,n,111\n,,103,1970-01-01T00:00:00.000000007Z,hex,0x7,n,7\n,,104,1970-01-01T00:00:00.000000112Z,hex,0x70,n,112\n,,105,1970-01-01T00:00:00.000000113Z,hex,0x71,n,113\n,,106,1970-01-01T00:00:00.000000114Z,hex,0x72,n,114\n,,107,1970-01-01T00:00:00.000000115Z,hex,0x73,n,115\n,,108,1970-01-01T00:00:00.000000116Z,hex,0x74,n,116\n,,109,1970-01-01T00:00:00.000000117Z,hex,0x75,n,117\n,,110,1970-01-01T00:00:00.000000118Z,hex,0x76,n,118\n,,111,1970-01-01T00:00:00.000000119Z,hex,0x77,n,119\n,,112,1970-01-01T00:00:00.00000012Z,hex,0x78,n,120\n,,113,1970-01-01T00:00:00.000000121Z,hex,0x79,n,121\n,,114,1970-01-01T00:00:00.000000122Z,hex,0x7a,n,122\n,,115,1970-01-01T00:00:00.000000123Z,hex,0x7b,n,123\n,,116,1970-01-01T00:00:00.000000124Z,hex,0x7c,n,124\n,,117,1970-01-01T00:00:00.000000125Z,hex,0x7d,n,125\n,,118,1970-01-01T00:00:00.000000126Z,hex,0x7e,n,126\n,,119,1970-01-01T00:00:00.000000127Z,hex,0x7f,n,127\n,,120,1970-01-01T00:00:00.000000008Z,hex,0x8,n,8\n,,121,1970-01-01T00:00:00.000000128Z,hex,0x80,n,128\n,,122,1970-01-01T00:00:00.000000129Z,hex,0x81,n,129\n,,123,1970-01-01T00:00:00.00000013Z,hex,0x82,n,130\n,,124,1970-01-01T00:00:00.000000131Z,hex,0x83,n,131\n,,125,1970-01-01T00:00:00.000000132Z,hex,0x84,n,132\n,,126,1970-01-01T00:00:00.000000133Z,hex,0x85,n,133\n,,127,1970-01-01T00:00:00.000000134Z,hex,0x86,n,134\n,,128,1970-01-01T00:00:00.000000135Z,hex,0x87,n,135\n,,129,1970-01-01T00:00:00.000000136Z,hex,0x88,n,136\n,,130,1970-01-01T00:00:00.000000137Z,hex,0x89,n,137\n,,131,1970-01-01T00:00:00.000000138Z,hex,0x8a,n,138\n,,132,1970-01-01T00:00:00.000000139Z,hex,0x8b,n,139\n,,133,1970-01-01T00:00:00.00000014Z,hex,0x8c,n,140\n,,134,1970-01-01T00:00:00.000000141Z,hex,0x8d,n,141\n,,135,1970-01-01T00:00:00.000000142Z,hex,0x8e,n,142\n,,136,1970-01-01T00:00:00.000000143Z,hex,0x8f,n,143\n,,137,1970-01-01T00:00:00.000000009Z,hex,0x9,n,9\n,,138,1970-01-01T00:00:00.000000144Z,hex,0x90,n,144\n,,139,1970-01-01T00:00:00.000000145Z,hex,0x91,n,145\n,,140,1970-01-01T00:00:00.000000146Z,hex,0x92,n,146\n,,141,1970-01-01T00:00:00.000000147Z,hex,0x93,n,147\n,,142,1970-01-01T00:00:00.000000148Z,hex,0x94,n,148\n,,143,1970-01-01T00:00:00.000000149Z,hex,0x95,n,149\n,,144,1970-01-01T00:00:00.00000015Z,hex,0x96,n,150\n,,145,1970-01-01T00:00:00.000000151Z,hex,0x97,n,151\n,,146,1970-01-01T00:00:00.000000152Z,hex,0x98,n,152\n,,147,1970-01-01T00:00:00.000000153Z,hex,0x99,n,153\n,,148,1970-01-01T00:00:00.000000154Z,hex,0x9a,n,154\n,,149,1970-01-01T00:00:00.000000155Z,hex,0x9b,n,155\n,,150,1970-01-01T00:00:00.000000156Z,hex,0x9c,n,156\n,,151,1970-01-01T00:00:00.000000157Z,hex,0x9d,n,157\n,,152,1970-01-01T00:00:00.000000158Z,hex,0x9e,n,158\n,,153,1970-01-01T00:00:00.000000159Z,hex,0x9f,n,159\n,,154,1970-01-01T00:00:00.00000001Z,hex,0xa,n,10\n,,155,1970-01-01T00:00:00.00000016Z,hex,0xa0,n,160\n,,156,1970-01-01T00:00:00.000000161Z,hex,0xa1,n,161\n,,157,1970-01-01T00:00:00.000000162Z,hex,0xa2,n,162\n,,158,1970-01-01T00:00:00.000000163Z,hex,0xa3,n,163\n,,159,1970-01-01T00:00:00.000000164Z,hex,0xa4,n,164\n,,160,1970-01-01T00:00:00.000000165Z,hex,0xa5,n,165\n,,161,1970-01-01T00:00:00.000000166Z,hex,0xa6,n,166\n,,162,1970-01-01T00:00:00.000000167Z,hex,0xa7,n,167\n,,163,1970-01-01T00:00:00.000000168Z,hex,0xa8,n,168\n,,164,1970-01-01T00:00:00.000000169Z,hex,0xa9,n,169\n,,165,1970-01-01T00:00:00.00000017Z,hex,0xaa,n,170\n,,166,1970-01-01T00:00:00.000000171Z,hex,0xab,n,171\n,,167,1970-01-01T00:00:00.000000172Z,hex,0xac,n,172\n,,168,1970-01-01T00:00:00.000000173Z,hex,0xad,n,173\n,,169,1970-01-01T00:00:00.000000174Z,hex,0xae,n,174\n,,170,1970-01-01T00:00:00.000000175Z,hex,0xaf,n,175\n,,171,1970-01-01T00:00:00.000000011Z,hex,0xb,n,11\n,,172,1970-01-01T00:00:00.000000176Z,hex,0xb0,n,176\n,,173,1970-01-01T00:00:00.000000177Z,hex,0xb1,n,177\n,,174,1970-01-01T00:00:00.000000178Z,hex,0xb2,n,178\n,,175,1970-01-01T00:00:00.000000179Z,hex,0xb3,n,179\n,,176,1970-01-01T00:00:00.00000018Z,hex,0xb4,n,180\n,,177,1970-01-01T00:00:00.000000181Z,hex,0xb5,n,181\n,,178,1970-01-01T00:00:00.000000182Z,hex,0xb6,n,182\n,,179,1970-01-01T00:00:00.000000183Z,hex,0xb7,n,183\n,,180,1970-01-01T00:00:00.000000184Z,hex,0xb8,n,184\n,,181,1970-01-01T00:00:00.000000185Z,hex,0xb9,n,185\n,,182,1970-01-01T00:00:00.000000186Z,hex,0xba,n,186\n,,183,1970-01-01T00:00:00.000000187Z,hex,0xbb,n,187\n,,184,1970-01-01T00:00:00.000000188Z,hex,0xbc,n,188\n,,185,1970-01-01T00:00:00.000000189Z,hex,0xbd,n,189\n,,186,1970-01-01T00:00:00.00000019Z,hex,0xbe,n,190\n,,187,1970-01-01T00:00:00.000000191Z,hex,0xbf,n,191\n,,188,1970-01-01T00:00:00.000000012Z,hex,0xc,n,12\n,,189,1970-01-01T00:00:00.000000192Z,hex,0xc0,n,192\n,,190,1970-01-01T00:00:00.000000193Z,hex,0xc1,n,193\n,,191,1970-01-01T00:00:00.000000194Z,hex,0xc2,n,194\n,,192,1970-01-01T00:00:00.000000195Z,hex,0xc3,n,195\n,,193,1970-01-01T00:00:00.000000196Z,hex,0xc4,n,196\n,,194,1970-01-01T00:00:00.000000197Z,hex,0xc5,n,197\n,,195,1970-01-01T00:00:00.000000198Z,hex,0xc6,n,198\n,,196,1970-01-01T00:00:00.000000199Z,hex,0xc7,n,199\n,,197,1970-01-01T00:00:00.000000013Z,hex,0xd,n,13\n,,198,1970-01-01T00:00:00.000000014Z,hex,0xe,n,14\n,,199,1970-01-01T00:00:00.000000015Z,hex,0xf,n,15\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t,_field,_value\n,,0,1970-01-01T00:00:00Z,hex,0x0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,hex,0x1,n,1\n,,2,1970-01-01T00:00:00.000000016Z,hex,0x10,n,16\n,,3,1970-01-01T00:00:00.000000017Z,hex,0x11,n,17\n,,4,1970-01-01T00:00:00.000000018Z,hex,0x12,n,18\n,,5,1970-01-01T00:00:00.000000019Z,hex,0x13,n,19\n,,6,1970-01-01T00:00:00.00000002Z,hex,0x14,n,20\n,,7,1970-01-01T00:00:00.000000021Z,hex,0x15,n,21\n,,8,1970-01-01T00:00:00.000000022Z,hex,0x16,n,22\n,,9,1970-01-01T00:00:00.000000023Z,hex,0x17,n,23\n,,10,1970-01-01T00:00:00.000000024Z,hex,0x18,n,24\n,,11,1970-01-01T00:00:00.000000025Z,hex,0x19,n,25\n,,12,1970-01-01T00:00:00.000000026Z,hex,0x1a,n,26\n,,13,1970-01-01T00:00:00.000000027Z,hex,0x1b,n,27\n,,14,1970-01-01T00:00:00.000000028Z,hex,0x1c,n,28\n,,15,1970-01-01T00:00:00.000000029Z,hex,0x1d,n,29\n,,16,1970-01-01T00:00:00.00000003Z,hex,0x1e,n,30\n,,17,1970-01-01T00:00:00.000000031Z,hex,0x1f,n,31\n,,18,1970-01-01T00:00:00.000000002Z,hex,0x2,n,2\n,,19,1970-01-01T00:00:00.000000032Z,hex,0x20,n,32\n,,20,1970-01-01T00:00:00.000000033Z,hex,0x21,n,33\n,,21,1970-01-01T00:00:00.000000034Z,hex,0x22,n,34\n,,22,1970-01-01T00:00:00.000000035Z,hex,0x23,n,35\n,,23,1970-01-01T00:00:00.000000036Z,hex,0x24,n,36\n,,24,1970-01-01T00:00:00.000000037Z,hex,0x25,n,37\n,,25,1970-01-01T00:00:00.000000038Z,hex,0x26,n,38\n,,26,1970-01-01T00:00:00.000000039Z,hex,0x27,n,39\n,,27,1970-01-01T00:00:00.00000004Z,hex,0x28,n,40\n,,28,1970-01-01T00:00:00.000000041Z,hex,0x29,n,41\n,,29,1970-01-01T00:00:00.000000042Z,hex,0x2a,n,42\n,,30,1970-01-01T00:00:00.000000043Z,hex,0x2b,n,43\n,,31,1970-01-01T00:00:00.000000044Z,hex,0x2c,n,44\n,,32,1970-01-01T00:00:00.000000045Z,hex,0x2d,n,45\n,,33,1970-01-01T00:00:00.000000046Z,hex,0x2e,n,46\n,,34,1970-01-01T00:00:00.000000047Z,hex,0x2f,n,47\n,,35,1970-01-01T00:00:00.000000003Z,hex,0x3,n,3\n,,36,1970-01-01T00:00:00.000000048Z,hex,0x30,n,48\n,,37,1970-01-01T00:00:00.000000049Z,hex,0x31,n,49\n,,38,1970-01-01T00:00:00.00000005Z,hex,0x32,n,50\n,,39,1970-01-01T00:00:00.000000051Z,hex,0x33,n,51\n,,40,1970-01-01T00:00:00.000000052Z,hex,0x34,n,52\n,,41,1970-01-01T00:00:00.000000053Z,hex,0x35,n,53\n,,42,1970-01-01T00:00:00.000000054Z,hex,0x36,n,54\n,,43,1970-01-01T00:00:00.000000055Z,hex,0x37,n,55\n,,44,1970-01-01T00:00:00.000000056Z,hex,0x38,n,56\n,,45,1970-01-01T00:00:00.000000057Z,hex,0x39,n,57\n,,46,1970-01-01T00:00:00.000000058Z,hex,0x3a,n,58\n,,47,1970-01-01T00:00:00.000000059Z,hex,0x3b,n,59\n,,48,1970-01-01T00:00:00.00000006Z,hex,0x3c,n,60\n,,49,1970-01-01T00:00:00.000000061Z,hex,0x3d,n,61\n,,50,1970-01-01T00:00:00.000000062Z,hex,0x3e,n,62\n,,51,1970-01-01T00:00:00.000000063Z,hex,0x3f,n,63\n,,52,1970-01-01T00:00:00.000000004Z,hex,0x4,n,4\n,,53,1970-01-01T00:00:00.000000064Z,hex,0x40,n,64\n,,54,1970-01-01T00:00:00.000000065Z,hex,0x41,n,65\n,,55,1970-01-01T00:00:00.000000066Z,hex,0x42,n,66\n,,56,1970-01-01T00:00:00.000000067Z,hex,0x43,n,67\n,,57,1970-01-01T00:00:00.000000068Z,hex,0x44,n,68\n,,58,1970-01-01T00:00:00.000000069Z,hex,0x45,n,69\n,,59,1970-01-01T00:00:00.00000007Z,hex,0x46,n,70\n,,60,1970-01-01T00:00:00.000000071Z,hex,0x47,n,71\n,,61,1970-01-01T00:00:00.000000072Z,hex,0x48,n,72\n,,62,1970-01-01T00:00:00.000000073Z,hex,0x49,n,73\n,,63,1970-01-01T00:00:00.000000074Z,hex,0x4a,n,74\n,,64,1970-01-01T00:00:00.000000075Z,hex,0x4b,n,75\n,,65,1970-01-01T00:00:00.000000076Z,hex,0x4c,n,76\n,,66,1970-01-01T00:00:00.000000077Z,hex,0x4d,n,77\n,,67,1970-01-01T00:00:00.000000078Z,hex,0x4e,n,78\n,,68,1970-01-01T00:00:00.000000079Z,hex,0x4f,n,79\n,,69,1970-01-01T00:00:00.000000005Z,hex,0x5,n,5\n,,70,1970-01-01T00:00:00.00000008Z,hex,0x50,n,80\n,,71,1970-01-01T00:00:00.000000081Z,hex,0x51,n,81\n,,72,1970-01-01T00:00:00.000000082Z,hex,0x52,n,82\n,,73,1970-01-01T00:00:00.000000083Z,hex,0x53,n,83\n,,74,1970-01-01T00:00:00.000000084Z,hex,0x54,n,84\n,,75,1970-01-01T00:00:00.000000085Z,hex,0x55,n,85\n,,76,1970-01-01T00:00:00.000000086Z,hex,0x56,n,86\n,,77,1970-01-01T00:00:00.000000087Z,hex,0x57,n,87\n,,78,1970-01-01T00:00:00.000000088Z,hex,0x58,n,88\n,,79,1970-01-01T00:00:00.000000089Z,hex,0x59,n,89\n,,80,1970-01-01T00:00:00.00000009Z,hex,0x5a,n,90\n,,81,1970-01-01T00:00:00.000000091Z,hex,0x5b,n,91\n,,82,1970-01-01T00:00:00.000000092Z,hex,0x5c,n,92\n,,83,1970-01-01T00:00:00.000000093Z,hex,0x5d,n,93\n,,84,1970-01-01T00:00:00.000000094Z,hex,0x5e,n,94\n,,85,1970-01-01T00:00:00.000000095Z,hex,0x5f,n,95\n,,86,1970-01-01T00:00:00.000000006Z,hex,0x6,n,6\n,,87,1970-01-01T00:00:00.000000096Z,hex,0x60,n,96\n,,88,1970-01-01T00:00:00.000000097Z,hex,0x61,n,97\n,,89,1970-01-01T00:00:00.000000098Z,hex,0x62,n,98\n,,90,1970-01-01T00:00:00.000000099Z,hex,0x63,n,99\n,,91,1970-01-01T00:00:00.0000001Z,hex,0x64,n,100\n,,92,1970-01-01T00:00:00.000000101Z,hex,0x65,n,101\n,,93,1970-01-01T00:00:00.000000102Z,hex,0x66,n,102\n,,94,1970-01-01T00:00:00.000000103Z,hex,0x67,n,103\n,,95,1970-01-01T00:00:00.000000104Z,hex,0x68,n,104\n,,96,1970-01-01T00:00:00.000000105Z,hex,0x69,n,105\n,,97,1970-01-01T00:00:00.000000106Z,hex,0x6a,n,106\n,,98,1970-01-01T00:00:00.000000107Z,hex,0x6b,n,107\n,,99,1970-01-01T00:00:00.000000108Z,hex,0x6c,n,108\n,,100,1970-01-01T00:00:00.000000109Z,hex,0x6d,n,109\n,,101,1970-01-01T00:00:00.00000011Z,hex,0x6e,n,110\n,,102,1970-01-01T00:00:00.000000111Z,hex,0x6f,n,111\n,,103,1970-01-01T00:00:00.000000007Z,hex,0x7,n,7\n,,104,1970-01-01T00:00:00.000000112Z,hex,0x70,n,112\n,,105,1970-01-01T00:00:00.000000113Z,hex,0x71,n,113\n,,106,1970-01-01T00:00:00.000000114Z,hex,0x72,n,114\n,,107,1970-01-01T00:00:00.000000115Z,hex,0x73,n,115\n,,108,1970-01-01T00:00:00.000000116Z,hex,0x74,n,116\n,,109,1970-01-01T00:00:00.000000117Z,hex,0x75,n,117\n,,110,1970-01-01T00:00:00.000000118Z,hex,0x76,n,118\n,,111,1970-01-01T00:00:00.000000119Z,hex,0x77,n,119\n,,112,1970-01-01T00:00:00.00000012Z,hex,0x78,n,120\n,,113,1970-01-01T00:00:00.000000121Z,hex,0x79,n,121\n,,114,1970-01-01T00:00:00.000000122Z,hex,0x7a,n,122\n,,115,1970-01-01T00:00:00.000000123Z,hex,0x7b,n,123\n,,116,1970-01-01T00:00:00.000000124Z,hex,0x7c,n,124\n,,117,1970-01-01T00:00:00.000000125Z,hex,0x7d,n,125\n,,118,1970-01-01T00:00:00.000000126Z,hex,0x7e,n,126\n,,119,1970-01-01T00:00:00.000000127Z,hex,0x7f,n,127\n,,120,1970-01-01T00:00:00.000000008Z,hex,0x8,n,8\n,,121,1970-01-01T00:00:00.000000128Z,hex,0x80,n,128\n,,122,1970-01-01T00:00:00.000000129Z,hex,0x81,n,129\n,,123,1970-01-01T00:00:00.00000013Z,hex,0x82,n,130\n,,124,1970-01-01T00:00:00.000000131Z,hex,0x83,n,131\n,,125,1970-01-01T00:00:00.000000132Z,hex,0x84,n,132\n,,126,1970-01-01T00:00:00.000000133Z,hex,0x85,n,133\n,,127,1970-01-01T00:00:00.000000134Z,hex,0x86,n,134\n,,128,1970-01-01T00:00:00.000000135Z,hex,0x87,n,135\n,,129,1970-01-01T00:00:00.000000136Z,hex,0x88,n,136\n,,130,1970-01-01T00:00:00.000000137Z,hex,0x89,n,137\n,,131,1970-01-01T00:00:00.000000138Z,hex,0x8a,n,138\n,,132,1970-01-01T00:00:00.000000139Z,hex,0x8b,n,139\n,,133,1970-01-01T00:00:00.00000014Z,hex,0x8c,n,140\n,,134,1970-01-01T00:00:00.000000141Z,hex,0x8d,n,141\n,,135,1970-01-01T00:00:00.000000142Z,hex,0x8e,n,142\n,,136,1970-01-01T00:00:00.000000143Z,hex,0x8f,n,143\n,,137,1970-01-01T00:00:00.000000009Z,hex,0x9,n,9\n,,138,1970-01-01T00:00:00.000000144Z,hex,0x90,n,144\n,,139,1970-01-01T00:00:00.000000145Z,hex,0x91,n,145\n,,140,1970-01-01T00:00:00.000000146Z,hex,0x92,n,146\n,,141,1970-01-01T00:00:00.000000147Z,hex,0x93,n,147\n,,142,1970-01-01T00:00:00.000000148Z,hex,0x94,n,148\n,,143,1970-01-01T00:00:00.000000149Z,hex,0x95,n,149\n,,144,1970-01-01T00:00:00.00000015Z,hex,0x96,n,150\n,,145,1970-01-01T00:00:00.000000151Z,hex,0x97,n,151\n,,146,1970-01-01T00:00:00.000000152Z,hex,0x98,n,152\n,,147,1970-01-01T00:00:00.000000153Z,hex,0x99,n,153\n,,148,1970-01-01T00:00:00.000000154Z,hex,0x9a,n,154\n,,149,1970-01-01T00:00:00.000000155Z,hex,0x9b,n,155\n,,150,1970-01-01T00:00:00.000000156Z,hex,0x9c,n,156\n,,151,1970-01-01T00:00:00.000000157Z,hex,0x9d,n,157\n,,152,1970-01-01T00:00:00.000000158Z,hex,0x9e,n,158\n,,153,1970-01-01T00:00:00.000000159Z,hex,0x9f,n,159\n,,154,1970-01-01T00:00:00.00000001Z,hex,0xa,n,10\n,,155,1970-01-01T00:00:00.00000016Z,hex,0xa0,n,160\n,,156,1970-01-01T00:00:00.000000161Z,hex,0xa1,n,161\n,,157,1970-01-01T00:00:00.000000162Z,hex,0xa2,n,162\n,,158,1970-01-01T00:00:00.000000163Z,hex,0xa3,n,163\n,,159,1970-01-01T00:00:00.000000164Z,hex,0xa4,n,164\n,,160,1970-01-01T00:00:00.000000165Z,hex,0xa5,n,165\n,,161,1970-01-01T00:00:00.000000166Z,hex,0xa6,n,166\n,,162,1970-01-01T00:00:00.000000167Z,hex,0xa7,n,167\n,,163,1970-01-01T00:00:00.000000168Z,hex,0xa8,n,168\n,,164,1970-01-01T00:00:00.000000169Z,hex,0xa9,n,169\n,,165,1970-01-01T00:00:00.00000017Z,hex,0xaa,n,170\n,,166,1970-01-01T00:00:00.000000171Z,hex,0xab,n,171\n,,167,1970-01-01T00:00:00.000000172Z,hex,0xac,n,172\n,,168,1970-01-01T00:00:00.000000173Z,hex,0xad,n,173\n,,169,1970-01-01T00:00:00.000000174Z,hex,0xae,n,174\n,,170,1970-01-01T00:00:00.000000175Z,hex,0xaf,n,175\n,,171,1970-01-01T00:00:00.000000011Z,hex,0xb,n,11\n,,172,1970-01-01T00:00:00.000000176Z,hex,0xb0,n,176\n,,173,1970-01-01T00:00:00.000000177Z,hex,0xb1,n,177\n,,174,1970-01-01T00:00:00.000000178Z,hex,0xb2,n,178\n,,175,1970-01-01T00:00:00.000000179Z,hex,0xb3,n,179\n,,176,1970-01-01T00:00:00.00000018Z,hex,0xb4,n,180\n,,177,1970-01-01T00:00:00.000000181Z,hex,0xb5,n,181\n,,178,1970-01-01T00:00:00.000000182Z,hex,0xb6,n,182\n,,179,1970-01-01T00:00:00.000000183Z,hex,0xb7,n,183\n,,180,1970-01-01T00:00:00.000000184Z,hex,0xb8,n,184\n,,181,1970-01-01T00:00:00.000000185Z,hex,0xb9,n,185\n,,182,1970-01-01T00:00:00.000000186Z,hex,0xba,n,186\n,,183,1970-01-01T00:00:00.000000187Z,hex,0xbb,n,187\n,,184,1970-01-01T00:00:00.000000188Z,hex,0xbc,n,188\n,,185,1970-01-01T00:00:00.000000189Z,hex,0xbd,n,189\n,,186,1970-01-01T00:00:00.00000019Z,hex,0xbe,n,190\n,,187,1970-01-01T00:00:00.000000191Z,hex,0xbf,n,191\n,,188,1970-01-01T00:00:00.000000012Z,hex,0xc,n,12\n,,189,1970-01-01T00:00:00.000000192Z,hex,0xc0,n,192\n,,190,1970-01-01T00:00:00.000000193Z,hex,0xc1,n,193\n,,191,1970-01-01T00:00:00.000000194Z,hex,0xc2,n,194\n,,192,1970-01-01T00:00:00.000000195Z,hex,0xc3,n,195\n,,193,1970-01-01T00:00:00.000000196Z,hex,0xc4,n,196\n,,194,1970-01-01T00:00:00.000000197Z,hex,0xc5,n,197\n,,195,1970-01-01T00:00:00.000000198Z,hex,0xc6,n,198\n,,196,1970-01-01T00:00:00.000000199Z,hex,0xc7,n,199\n,,197,1970-01-01T00:00:00.000000013Z,hex,0xd,n,13\n,,198,1970-01-01T00:00:00.000000014Z,hex,0xe,n,14\n,,199,1970-01-01T00:00:00.000000015Z,hex,0xf,n,15\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   238,
					},
					File:   "filter_by_regex_tag_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000003Z,hex,3\n,,0,1970-01-01T00:00:00.00000002Z,hex,20\n,,0,1970-01-01T00:00:00.000000025Z,hex,25\n,,0,1970-01-01T00:00:00.000000041Z,hex,41\n,,0,1970-01-01T00:00:00.000000085Z,hex,85\n,,0,1970-01-01T00:00:00.000000086Z,hex,86\n,,0,1970-01-01T00:00:00.00000009Z,hex,90\n,,0,1970-01-01T00:00:00.000000101Z,hex,101\n,,0,1970-01-01T00:00:00.000000112Z,hex,112\n,,0,1970-01-01T00:00:00.000000123Z,hex,123\n,,0,1970-01-01T00:00:00.000000125Z,hex,125\n,,0,1970-01-01T00:00:00.000000129Z,hex,129\n,,0,1970-01-01T00:00:00.00000013Z,hex,130\n,,0,1970-01-01T00:00:00.000000137Z,hex,137\n,,0,1970-01-01T00:00:00.00000016Z,hex,160\n,,0,1970-01-01T00:00:00.000000163Z,hex,163\n,,0,1970-01-01T00:00:00.000000183Z,hex,183\n,,0,1970-01-01T00:00:00.000000185Z,hex,185\n,,0,1970-01-01T00:00:00.000000193Z,hex,193\n,,0,1970-01-01T00:00:00.000000199Z,hex,199\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   213,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   213,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   213,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   238,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000003Z,hex,3\n,,0,1970-01-01T00:00:00.00000002Z,hex,20\n,,0,1970-01-01T00:00:00.000000025Z,hex,25\n,,0,1970-01-01T00:00:00.000000041Z,hex,41\n,,0,1970-01-01T00:00:00.000000085Z,hex,85\n,,0,1970-01-01T00:00:00.000000086Z,hex,86\n,,0,1970-01-01T00:00:00.00000009Z,hex,90\n,,0,1970-01-01T00:00:00.000000101Z,hex,101\n,,0,1970-01-01T00:00:00.000000112Z,hex,112\n,,0,1970-01-01T00:00:00.000000123Z,hex,123\n,,0,1970-01-01T00:00:00.000000125Z,hex,125\n,,0,1970-01-01T00:00:00.000000129Z,hex,129\n,,0,1970-01-01T00:00:00.00000013Z,hex,130\n,,0,1970-01-01T00:00:00.000000137Z,hex,137\n,,0,1970-01-01T00:00:00.00000016Z,hex,160\n,,0,1970-01-01T00:00:00.000000163Z,hex,163\n,,0,1970-01-01T00:00:00.000000183Z,hex,183\n,,0,1970-01-01T00:00:00.000000185Z,hex,185\n,,0,1970-01-01T00:00:00.000000193Z,hex,193\n,,0,1970-01-01T00:00:00.000000199Z,hex,199\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   213,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000003Z,hex,3\n,,0,1970-01-01T00:00:00.00000002Z,hex,20\n,,0,1970-01-01T00:00:00.000000025Z,hex,25\n,,0,1970-01-01T00:00:00.000000041Z,hex,41\n,,0,1970-01-01T00:00:00.000000085Z,hex,85\n,,0,1970-01-01T00:00:00.000000086Z,hex,86\n,,0,1970-01-01T00:00:00.00000009Z,hex,90\n,,0,1970-01-01T00:00:00.000000101Z,hex,101\n,,0,1970-01-01T00:00:00.000000112Z,hex,112\n,,0,1970-01-01T00:00:00.000000123Z,hex,123\n,,0,1970-01-01T00:00:00.000000125Z,hex,125\n,,0,1970-01-01T00:00:00.000000129Z,hex,129\n,,0,1970-01-01T00:00:00.00000013Z,hex,130\n,,0,1970-01-01T00:00:00.000000137Z,hex,137\n,,0,1970-01-01T00:00:00.00000016Z,hex,160\n,,0,1970-01-01T00:00:00.000000163Z,hex,163\n,,0,1970-01-01T00:00:00.000000183Z,hex,183\n,,0,1970-01-01T00:00:00.000000185Z,hex,185\n,,0,1970-01-01T00:00:00.000000193Z,hex,193\n,,0,1970-01-01T00:00:00.000000199Z,hex,199\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 50,
						Line:   249,
					},
					File:   "filter_by_regex_tag_test.flux",
					Source: "t_filter_by_regex_tag = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
					Start: ast.Position{
						Column: 1,
						Line:   241,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   241,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "t_filter_by_regex_tag",
						Start: ast.Position{
							Column: 1,
							Line:   241,
						},
					},
				},
				Name: "t_filter_by_regex_tag",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   249,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "(tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
						Start: ast.Position{
							Column: 25,
							Line:   241,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   241,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "tables",
															Start: ast.Position{
																Column: 40,
																Line:   241,
															},
														},
													},
													Name: "tables",
												},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   242,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)",
														Start: ast.Position{
															Column: 40,
															Line:   241,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   242,
																},
																File:   "filter_by_regex_tag_test.flux",
																Source: "start: influxql.minTime, stop: influxql.maxTime",
																Start: ast.Position{
																	Column: 11,
																	Line:   242,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   242,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "start: influxql.minTime",
																	Start: ast.Position{
																		Column: 11,
																		Line:   242,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 16,
																			Line:   242,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "start",
																		Start: ast.Position{
																			Column: 11,
																			Line:   242,
																		},
																	},
																},
																Name: "start",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   242,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "influxql.minTime",
																		Start: ast.Position{
																			Column: 18,
																			Line:   242,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   242,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "influxql",
																			Start: ast.Position{
																				Column: 18,
																				Line:   242,
																			},
																		},
																	},
																	Name: "influxql",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   242,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "minTime",
																			Start: ast.Position{
																				Column: 27,
																				Line:   242,
																			},
																		},
																	},
																	Name: "minTime",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   242,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "stop: influxql.maxTime",
																	Start: ast.Position{
																		Column: 36,
																		Line:   242,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   242,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "stop",
																		Start: ast.Position{
																			Column: 36,
																			Line:   242,
																		},
																	},
																},
																Name: "stop",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   242,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "influxql.maxTime",
																		Start: ast.Position{
																			Column: 42,
																			Line:   242,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 50,
																				Line:   242,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "influxql",
																			Start: ast.Position{
																				Column: 42,
																				Line:   242,
																			},
																		},
																	},
																	Name: "influxql",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   242,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "maxTime",
																			Start: ast.Position{
																				Column: 51,
																				Line:   242,
																			},
																		},
																	},
																	Name: "maxTime",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   242,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "range(start: influxql.minTime, stop: influxql.maxTime)",
															Start: ast.Position{
																Column: 5,
																Line:   242,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   242,
																},
																File:   "filter_by_regex_tag_test.flux",
																Source: "range",
																Start: ast.Position{
																	Column: 5,
																	Line:   242,
																},
															},
														},
														Name: "range",
													},
												},
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   243,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")",
													Start: ast.Position{
														Column: 40,
														Line:   241,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   243,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "fn: (r) => r._measurement == \"hex\"",
															Start: ast.Position{
																Column: 12,
																Line:   243,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   243,
																},
																File:   "filter_by_regex_tag_test.flux",
																Source: "fn: (r) => r._measurement == \"hex\"",
																Start: ast.Position{
																	Column: 12,
																	Line:   243,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   243,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "fn",
																	Start: ast.Position{
																		Column: 12,
																		Line:   243,
																	},
																},
															},
															Name: "fn",
														},
														Value: &ast.FunctionExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   243,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "(r) => r._measurement == \"hex\"",
																	Start: ast.Position{
																		Column: 16,
																		Line:   243,
																	},
																},
															},
															Body: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   243,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "r._measurement == \"hex\"",
																		Start: ast.Position{
																			Column: 23,
																			Line:   243,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   243,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "r._measurement",
																			Start: ast.Position{
																				Column: 23,
																				Line:   243,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   243,
																				},
																				File:   "filter_by_regex_tag_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 23,
																					Line:   243,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   243,
																				},
																				File:   "filter_by_regex_tag_test.flux",
																				Source: "_measurement",
																				Start: ast.Position{
																					Column: 25,
																					Line:   243,
																				},
																			},
																		},
																		Name: "_measurement",
																	},
																},
																Operator: 17,
																Right: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   243,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "\"hex\"",
																			Start: ast.Position{
																				Column: 41,
																				Line:   243,
																			},
																		},
																	},
																	Value: "hex",
																},
															},
															Params: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   243,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   243,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 18,
																				Line:   243,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 17,
																				Line:   243,
																			},
																		},
																	},
																	Name: "r",
																},
																Value: nil,
															}},
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   243,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "filter(fn: (r) => r._measurement == \"hex\")",
														Start: ast.Position{
															Column: 5,
															Line:   243,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   243,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "filter",
															Start: ast.Position{
																Column: 5,
																Line:   243,
															},
														},
													},
													Name: "filter",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   244,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")",
												Start: ast.Position{
													Column: 40,
													Line:   241,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   244,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "fn: (r) => r._field == \"n\"",
														Start: ast.Position{
															Column: 12,
															Line:   244,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   244,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "fn: (r) => r._field == \"n\"",
															Start: ast.Position{
																Column: 12,
																Line:   244,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   244,
																},
																File:   "filter_by_regex_tag_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 12,
																	Line:   244,
																},
															},
														},
														Name: "fn",
													},
													Value: &ast.FunctionExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   244,
																},
																File:   "filter_by_regex_tag_test.flux",
																Source: "(r) => r._field == \"n\"",
																Start: ast.Position{
																	Column: 16,
																	Line:   244,
																},
															},
														},
														Body: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   244,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "r._field == \"n\"",
																	Start: ast.Position{
																		Column: 23,
																		Line:   244,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   244,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "r._field",
																		Start: ast.Position{
																			Column: 23,
																			Line:   244,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   244,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 23,
																				Line:   244,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   244,
																			},
																			File:   "filter_by_regex_tag_test.flux",
																			Source: "_field",
																			Start: ast.Position{
																				Column: 25,
																				Line:   244,
																			},
																		},
																	},
																	Name: "_field",
																},
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   244,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "\"n\"",
																		Start: ast.Position{
																			Column: 35,
																			Line:   244,
																		},
																	},
																},
																Value: "n",
															},
														},
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   244,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   244,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   244,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   244,
																		},
																	},
																},
																Name: "r",
															},
															Value: nil,
														}},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   244,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "filter(fn: (r) => r._field == \"n\")",
													Start: ast.Position{
														Column: 5,
														Line:   244,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   244,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 5,
															Line:   244,
														},
													},
												},
												Name: "filter",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 135,
												Line:   245,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)",
											Start: ast.Position{
												Column: 40,
												Line:   241,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 134,
														Line:   245,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/",
													Start: ast.Position{
														Column: 12,
														Line:   245,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 134,
															Line:   245,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/",
														Start: ast.Position{
															Column: 12,
															Line:   245,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   245,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   245,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 134,
																Line:   245,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "(r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/",
															Start: ast.Position{
																Column: 16,
																Line:   245,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 134,
																	Line:   245,
																},
																File:   "filter_by_regex_tag_test.flux",
																Source: "r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/",
																Start: ast.Position{
																	Column: 23,
																	Line:   245,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   245,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "r.t",
																	Start: ast.Position{
																		Column: 23,
																		Line:   245,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   245,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 23,
																			Line:   245,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   245,
																		},
																		File:   "filter_by_regex_tag_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 25,
																			Line:   245,
																		},
																	},
																},
																Name: "t",
															},
														},
														Operator: 19,
														Right: &ast.RegexpLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 134,
																		Line:   245,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "/^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/",
																	Start: ast.Position{
																		Column: 30,
																		Line:   245,
																	},
																},
															},
															Value: regexp.MustCompile("^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$"),
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   245,
																},
																File:   "filter_by_regex_tag_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   245,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   245,
																	},
																	File:   "filter_by_regex_tag_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   245,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 135,
													Line:   245,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)",
												Start: ast.Position{
													Column: 5,
													Line:   245,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   245,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 5,
														Line:   245,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   246,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)\n\t|> group(columns: [\"_measurement\", \"_field\"])",
										Start: ast.Position{
											Column: 40,
											Line:   241,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   246,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "columns: [\"_measurement\", \"_field\"]",
												Start: ast.Position{
													Column: 11,
													Line:   246,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   246,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "columns: [\"_measurement\", \"_field\"]",
													Start: ast.Position{
														Column: 11,
														Line:   246,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   246,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 11,
															Line:   246,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   246,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "[\"_measurement\", \"_field\"]",
														Start: ast.Position{
															Column: 20,
															Line:   246,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   246,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 21,
																Line:   246,
															},
														},
													},
													Value: "_measurement",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   246,
															},
															File:   "filter_by_regex_tag_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 37,
																Line:   246,
															},
														},
													},
													Value: "_field",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   246,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "group(columns: [\"_measurement\", \"_field\"])",
											Start: ast.Position{
												Column: 5,
												Line:   246,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   246,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "group",
												Start: ast.Position{
													Column: 5,
													Line:   246,
												},
											},
										},
										Name: "group",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   247,
									},
									File:   "filter_by_regex_tag_test.flux",
									Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])",
									Start: ast.Position{
										Column: 40,
										Line:   241,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   247,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "columns: [\"_time\"]",
											Start: ast.Position{
												Column: 10,
												Line:   247,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   247,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "columns: [\"_time\"]",
												Start: ast.Position{
													Column: 10,
													Line:   247,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   247,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 10,
														Line:   247,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   247,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "[\"_time\"]",
													Start: ast.Position{
														Column: 19,
														Line:   247,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   247,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "\"_time\"",
														Start: ast.Position{
															Column: 20,
															Line:   247,
														},
													},
												},
												Value: "_time",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   247,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "sort(columns: [\"_time\"])",
										Start: ast.Position{
											Column: 5,
											Line:   247,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   247,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "sort",
											Start: ast.Position{
												Column: 5,
												Line:   247,
											},
										},
									},
									Name: "sort",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   248,
								},
								File:   "filter_by_regex_tag_test.flux",
								Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
								Start: ast.Position{
									Column: 40,
									Line:   241,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   248,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
										Start: ast.Position{
											Column: 10,
											Line:   248,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   248,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
											Start: ast.Position{
												Column: 10,
												Line:   248,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   248,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 10,
													Line:   248,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   248,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "[\"_time\", \"_value\", \"_measurement\"]",
												Start: ast.Position{
													Column: 19,
													Line:   248,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   248,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 20,
														Line:   248,
													},
												},
											},
											Value: "_time",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   248,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 29,
														Line:   248,
													},
												},
											},
											Value: "_value",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   248,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "\"_measurement\"",
													Start: ast.Position{
														Column: 39,
														Line:   248,
													},
												},
											},
											Value: "_measurement",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   248,
									},
									File:   "filter_by_regex_tag_test.flux",
									Source: "keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
									Start: ast.Position{
										Column: 5,
										Line:   248,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   248,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "keep",
										Start: ast.Position{
											Column: 5,
											Line:   248,
										},
									},
								},
								Name: "keep",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   249,
							},
							File:   "filter_by_regex_tag_test.flux",
							Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"hex\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r.t =~ /^(0x7b|0x70|0x55|0x19|0x65|0xa3|0x89|0xc1|0x3|0x14|0x29|0x81|0xb7|0xb9|0x82|0x56|0xa0|0xc7|0x5a|0x7d)$/)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
							Start: ast.Position{
								Column: 40,
								Line:   241,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   249,
									},
									File:   "filter_by_regex_tag_test.flux",
									Source: "columns: {_time: \"time\", _value: \"n\"}",
									Start: ast.Position{
										Column: 12,
										Line:   249,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   249,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "columns: {_time: \"time\", _value: \"n\"}",
										Start: ast.Position{
											Column: 12,
											Line:   249,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   249,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 12,
												Line:   249,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   249,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "{_time: \"time\", _value: \"n\"}",
											Start: ast.Position{
												Column: 21,
												Line:   249,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   249,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "_time: \"time\"",
												Start: ast.Position{
													Column: 22,
													Line:   249,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   249,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "_time",
													Start: ast.Position{
														Column: 22,
														Line:   249,
													},
												},
											},
											Name: "_time",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   249,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "\"time\"",
													Start: ast.Position{
														Column: 29,
														Line:   249,
													},
												},
											},
											Value: "time",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   249,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "_value: \"n\"",
												Start: ast.Position{
													Column: 37,
													Line:   249,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   249,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "_value",
													Start: ast.Position{
														Column: 37,
														Line:   249,
													},
												},
											},
											Name: "_value",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   249,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "\"n\"",
													Start: ast.Position{
														Column: 45,
														Line:   249,
													},
												},
											},
											Value: "n",
										},
									}},
									With: nil,
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   249,
								},
								File:   "filter_by_regex_tag_test.flux",
								Source: "rename(columns: {_time: \"time\", _value: \"n\"})",
								Start: ast.Position{
									Column: 5,
									Line:   249,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   249,
									},
									File:   "filter_by_regex_tag_test.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 5,
										Line:   249,
									},
								},
							},
							Name: "rename",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   241,
							},
							File:   "filter_by_regex_tag_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 26,
								Line:   241,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   241,
								},
								File:   "filter_by_regex_tag_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 26,
									Line:   241,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   241,
							},
							File:   "filter_by_regex_tag_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 33,
								Line:   241,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   255,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "_filter_by_regex_tag = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_regex_tag,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   251,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   251,
							},
							File:   "filter_by_regex_tag_test.flux",
							Source: "_filter_by_regex_tag",
							Start: ast.Position{
								Column: 6,
								Line:   251,
							},
						},
					},
					Name: "_filter_by_regex_tag",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   255,
							},
							File:   "filter_by_regex_tag_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_regex_tag,\n})",
							Start: ast.Position{
								Column: 29,
								Line:   251,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   255,
								},
								File:   "filter_by_regex_tag_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_regex_tag,\n})",
								Start: ast.Position{
									Column: 35,
									Line:   251,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   255,
									},
									File:   "filter_by_regex_tag_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_regex_tag,\n}",
									Start: ast.Position{
										Column: 36,
										Line:   251,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   252,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   252,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   252,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   252,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   252,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   252,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   252,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   252,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   252,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   252,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   252,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   252,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   252,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   252,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   252,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   252,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   252,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   252,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   252,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   252,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   253,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   253,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   253,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   253,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   253,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   253,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   253,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   253,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   253,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   253,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   253,
														},
														File:   "filter_by_regex_tag_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   253,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   253,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   253,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   253,
												},
												File:   "filter_by_regex_tag_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   253,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   253,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   253,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   253,
													},
													File:   "filter_by_regex_tag_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   253,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   254,
										},
										File:   "filter_by_regex_tag_test.flux",
										Source: "fn: t_filter_by_regex_tag",
										Start: ast.Position{
											Column: 2,
											Line:   254,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   254,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   254,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   254,
											},
											File:   "filter_by_regex_tag_test.flux",
											Source: "t_filter_by_regex_tag",
											Start: ast.Position{
												Column: 6,
												Line:   254,
											},
										},
									},
									Name: "t_filter_by_regex_tag",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   255,
					},
					File:   "filter_by_regex_tag_test.flux",
					Source: "test _filter_by_regex_tag = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_regex_tag,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   251,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "filter_by_regex_tag_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "filter_by_regex_tag_test.flux",
					Source: "import \"internal/influxql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "\"internal/influxql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/influxql",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "filter_by_regex_tag_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "filter_by_regex_tag_test.flux",
					Source: "package influxql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "filter_by_regex_tag_test.flux",
						Source: "influxql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxql_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   62,
				},
				File:   "filter_by_values_with_and_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,ctr,n,0\n,,0,1970-01-01T00:00:00.000000001Z,ctr,n,1\n,,0,1970-01-01T00:00:00.000000002Z,ctr,n,2\n,,0,1970-01-01T00:00:00.000000003Z,ctr,n,3\n,,0,1970-01-01T00:00:00.000000004Z,ctr,n,4\n,,0,1970-01-01T00:00:00.000000005Z,ctr,n,5\n,,0,1970-01-01T00:00:00.000000006Z,ctr,n,6\n,,0,1970-01-01T00:00:00.000000007Z,ctr,n,7\n,,0,1970-01-01T00:00:00.000000008Z,ctr,n,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,n,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,n,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,n,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,n,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,n,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,n,14\n,,0,1970-01-01T00:00:00.000000015Z,ctr,n,15\n,,0,1970-01-01T00:00:00.000000016Z,ctr,n,16\n,,0,1970-01-01T00:00:00.000000017Z,ctr,n,17\n,,0,1970-01-01T00:00:00.000000018Z,ctr,n,18\n,,0,1970-01-01T00:00:00.000000019Z,ctr,n,19\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000008Z,ctr,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,14\n\"\n\n// SELECT n FROM ctr WHERE n >= 8 AND n <= 14\nt_filter_by_values_with_and = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})\n\ntest _filter_by_values_with_and = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_values_with_and,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "filter_by_values_with_and_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,ctr,n,0\n,,0,1970-01-01T00:00:00.000000001Z,ctr,n,1\n,,0,1970-01-01T00:00:00.000000002Z,ctr,n,2\n,,0,1970-01-01T00:00:00.000000003Z,ctr,n,3\n,,0,1970-01-01T00:00:00.000000004Z,ctr,n,4\n,,0,1970-01-01T00:00:00.000000005Z,ctr,n,5\n,,0,1970-01-01T00:00:00.000000006Z,ctr,n,6\n,,0,1970-01-01T00:00:00.000000007Z,ctr,n,7\n,,0,1970-01-01T00:00:00.000000008Z,ctr,n,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,n,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,n,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,n,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,n,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,n,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,n,14\n,,0,1970-01-01T00:00:00.000000015Z,ctr,n,15\n,,0,1970-01-01T00:00:00.000000016Z,ctr,n,16\n,,0,1970-01-01T00:00:00.000000017Z,ctr,n,17\n,,0,1970-01-01T00:00:00.000000018Z,ctr,n,18\n,,0,1970-01-01T00:00:00.000000019Z,ctr,n,19\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,ctr,n,0\n,,0,1970-01-01T00:00:00.000000001Z,ctr,n,1\n,,0,1970-01-01T00:00:00.000000002Z,ctr,n,2\n,,0,1970-01-01T00:00:00.000000003Z,ctr,n,3\n,,0,1970-01-01T00:00:00.000000004Z,ctr,n,4\n,,0,1970-01-01T00:00:00.000000005Z,ctr,n,5\n,,0,1970-01-01T00:00:00.000000006Z,ctr,n,6\n,,0,1970-01-01T00:00:00.000000007Z,ctr,n,7\n,,0,1970-01-01T00:00:00.000000008Z,ctr,n,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,n,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,n,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,n,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,n,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,n,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,n,14\n,,0,1970-01-01T00:00:00.000000015Z,ctr,n,15\n,,0,1970-01-01T00:00:00.000000016Z,ctr,n,16\n,,0,1970-01-01T00:00:00.000000017Z,ctr,n,17\n,,0,1970-01-01T00:00:00.000000018Z,ctr,n,18\n,,0,1970-01-01T00:00:00.000000019Z,ctr,n,19\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,ctr,n,0\n,,0,1970-01-01T00:00:00.000000001Z,ctr,n,1\n,,0,1970-01-01T00:00:00.000000002Z,ctr,n,2\n,,0,1970-01-01T00:00:00.000000003Z,ctr,n,3\n,,0,1970-01-01T00:00:00.000000004Z,ctr,n,4\n,,0,1970-01-01T00:00:00.000000005Z,ctr,n,5\n,,0,1970-01-01T00:00:00.000000006Z,ctr,n,6\n,,0,1970-01-01T00:00:00.000000007Z,ctr,n,7\n,,0,1970-01-01T00:00:00.000000008Z,ctr,n,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,n,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,n,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,n,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,n,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,n,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,n,14\n,,0,1970-01-01T00:00:00.000000015Z,ctr,n,15\n,,0,1970-01-01T00:00:00.000000016Z,ctr,n,16\n,,0,1970-01-01T00:00:00.000000017Z,ctr,n,17\n,,0,1970-01-01T00:00:00.000000018Z,ctr,n,18\n,,0,1970-01-01T00:00:00.000000019Z,ctr,n,19\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   45,
					},
					File:   "filter_by_values_with_and_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000008Z,ctr,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,14\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   33,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   45,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000008Z,ctr,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,14\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   33,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00.000000008Z,ctr,8\n,,0,1970-01-01T00:00:00.000000009Z,ctr,9\n,,0,1970-01-01T00:00:00.00000001Z,ctr,10\n,,0,1970-01-01T00:00:00.000000011Z,ctr,11\n,,0,1970-01-01T00:00:00.000000012Z,ctr,12\n,,0,1970-01-01T00:00:00.000000013Z,ctr,13\n,,0,1970-01-01T00:00:00.000000014Z,ctr,14\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 50,
						Line:   56,
					},
					File:   "filter_by_values_with_and_test.flux",
					Source: "t_filter_by_values_with_and = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   48,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "t_filter_by_values_with_and",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "t_filter_by_values_with_and",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   56,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "(tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
						Start: ast.Position{
							Column: 31,
							Line:   48,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   48,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "tables",
															Start: ast.Position{
																Column: 46,
																Line:   48,
															},
														},
													},
													Name: "tables",
												},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   49,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)",
														Start: ast.Position{
															Column: 46,
															Line:   48,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   49,
																},
																File:   "filter_by_values_with_and_test.flux",
																Source: "start: influxql.minTime, stop: influxql.maxTime",
																Start: ast.Position{
																	Column: 11,
																	Line:   49,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   49,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "start: influxql.minTime",
																	Start: ast.Position{
																		Column: 11,
																		Line:   49,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 16,
																			Line:   49,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "start",
																		Start: ast.Position{
																			Column: 11,
																			Line:   49,
																		},
																	},
																},
																Name: "start",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   49,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "influxql.minTime",
																		Start: ast.Position{
																			Column: 18,
																			Line:   49,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   49,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "influxql",
																			Start: ast.Position{
																				Column: 18,
																				Line:   49,
																			},
																		},
																	},
																	Name: "influxql",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   49,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "minTime",
																			Start: ast.Position{
																				Column: 27,
																				Line:   49,
																			},
																		},
																	},
																	Name: "minTime",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   49,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "stop: influxql.maxTime",
																	Start: ast.Position{
																		Column: 36,
																		Line:   49,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   49,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "stop",
																		Start: ast.Position{
																			Column: 36,
																			Line:   49,
																		},
																	},
																},
																Name: "stop",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   49,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "influxql.maxTime",
																		Start: ast.Position{
																			Column: 42,
																			Line:   49,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 50,
																				Line:   49,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "influxql",
																			Start: ast.Position{
																				Column: 42,
																				Line:   49,
																			},
																		},
																	},
																	Name: "influxql",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   49,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "maxTime",
																			Start: ast.Position{
																				Column: 51,
																				Line:   49,
																			},
																		},
																	},
																	Name: "maxTime",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   49,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "range(start: influxql.minTime, stop: influxql.maxTime)",
															Start: ast.Position{
																Column: 5,
																Line:   49,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   49,
																},
																File:   "filter_by_values_with_and_test.flux",
																Source: "range",
																Start: ast.Position{
																	Column: 5,
																	Line:   49,
																},
															},
														},
														Name: "range",
													},
												},
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   50,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")",
													Start: ast.Position{
														Column: 46,
														Line:   48,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   50,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "fn: (r) => r._measurement == \"ctr\"",
															Start: ast.Position{
																Column: 12,
																Line:   50,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   50,
																},
																File:   "filter_by_values_with_and_test.flux",
																Source: "fn: (r) => r._measurement == \"ctr\"",
																Start: ast.Position{
																	Column: 12,
																	Line:   50,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   50,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "fn",
																	Start: ast.Position{
																		Column: 12,
																		Line:   50,
																	},
																},
															},
															Name: "fn",
														},
														Value: &ast.FunctionExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   50,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "(r) => r._measurement == \"ctr\"",
																	Start: ast.Position{
																		Column: 16,
																		Line:   50,
																	},
																},
															},
															Body: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   50,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "r._measurement == \"ctr\"",
																		Start: ast.Position{
																			Column: 23,
																			Line:   50,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   50,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "r._measurement",
																			Start: ast.Position{
																				Column: 23,
																				Line:   50,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   50,
																				},
																				File:   "filter_by_values_with_and_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 23,
																					Line:   50,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   50,
																				},
																				File:   "filter_by_values_with_and_test.flux",
																				Source: "_measurement",
																				Start: ast.Position{
																					Column: 25,
																					Line:   50,
																				},
																			},
																		},
																		Name: "_measurement",
																	},
																},
																Operator: 17,
																Right: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   50,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "\"ctr\"",
																			Start: ast.Position{
																				Column: 41,
																				Line:   50,
																			},
																		},
																	},
																	Value: "ctr",
																},
															},
															Params: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   50,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   50,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 18,
																				Line:   50,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 17,
																				Line:   50,
																			},
																		},
																	},
																	Name: "r",
																},
																Value: nil,
															}},
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   50,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "filter(fn: (r) => r._measurement == \"ctr\")",
														Start: ast.Position{
															Column: 5,
															Line:   50,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   50,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "filter",
															Start: ast.Position{
																Column: 5,
																Line:   50,
															},
														},
													},
													Name: "filter",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   51,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")",
												Start: ast.Position{
													Column: 46,
													Line:   48,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   51,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "fn: (r) => r._field == \"n\"",
														Start: ast.Position{
															Column: 12,
															Line:   51,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   51,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "fn: (r) => r._field == \"n\"",
															Start: ast.Position{
																Column: 12,
																Line:   51,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   51,
																},
																File:   "filter_by_values_with_and_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 12,
																	Line:   51,
																},
															},
														},
														Name: "fn",
													},
													Value: &ast.FunctionExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   51,
																},
																File:   "filter_by_values_with_and_test.flux",
																Source: "(r) => r._field == \"n\"",
																Start: ast.Position{
																	Column: 16,
																	Line:   51,
																},
															},
														},
														Body: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   51,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "r._field == \"n\"",
																	Start: ast.Position{
																		Column: 23,
																		Line:   51,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   51,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "r._field",
																		Start: ast.Position{
																			Column: 23,
																			Line:   51,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   51,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 23,
																				Line:   51,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   51,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "_field",
																			Start: ast.Position{
																				Column: 25,
																				Line:   51,
																			},
																		},
																	},
																	Name: "_field",
																},
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   51,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "\"n\"",
																		Start: ast.Position{
																			Column: 35,
																			Line:   51,
																		},
																	},
																},
																Value: "n",
															},
														},
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   51,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   51,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   51,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   51,
																		},
																	},
																},
																Name: "r",
															},
															Value: nil,
														}},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   51,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "filter(fn: (r) => r._field == \"n\")",
													Start: ast.Position{
														Column: 5,
														Line:   51,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   51,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 5,
															Line:   51,
														},
													},
												},
												Name: "filter",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   52,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)",
											Start: ast.Position{
												Column: 46,
												Line:   48,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   52,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "fn: (r) => r._value >= 8 and r._value <= 14",
													Start: ast.Position{
														Column: 12,
														Line:   52,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   52,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "fn: (r) => r._value >= 8 and r._value <= 14",
														Start: ast.Position{
															Column: 12,
															Line:   52,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   52,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   52,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   52,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "(r) => r._value >= 8 and r._value <= 14",
															Start: ast.Position{
																Column: 16,
																Line:   52,
															},
														},
													},
													Body: &ast.LogicalExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   52,
																},
																File:   "filter_by_values_with_and_test.flux",
																Source: "r._value >= 8 and r._value <= 14",
																Start: ast.Position{
																	Column: 23,
																	Line:   52,
																},
															},
														},
														Left: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   52,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "r._value >= 8",
																	Start: ast.Position{
																		Column: 23,
																		Line:   52,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   52,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 23,
																			Line:   52,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   52,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 23,
																				Line:   52,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   52,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 25,
																				Line:   52,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
															Operator: 9,
															Right: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   52,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "8",
																		Start: ast.Position{
																			Column: 35,
																			Line:   52,
																		},
																	},
																},
																Value: int64(8),
															},
														},
														Operator: 1,
														Right: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   52,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "r._value <= 14",
																	Start: ast.Position{
																		Column: 41,
																		Line:   52,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   52,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 41,
																			Line:   52,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 42,
																				Line:   52,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 41,
																				Line:   52,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   52,
																			},
																			File:   "filter_by_values_with_and_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 43,
																				Line:   52,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
															Operator: 7,
															Right: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   52,
																		},
																		File:   "filter_by_values_with_and_test.flux",
																		Source: "14",
																		Start: ast.Position{
																			Column: 53,
																			Line:   52,
																		},
																	},
																},
																Value: int64(14),
															},
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   52,
																},
																File:   "filter_by_values_with_and_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   52,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   52,
																	},
																	File:   "filter_by_values_with_and_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   52,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   52,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "filter(fn: (r) => r._value >= 8 and r._value <= 14)",
												Start: ast.Position{
													Column: 5,
													Line:   52,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   52,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 5,
														Line:   52,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   53,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)\n\t|> group(columns: [\"_measurement\", \"_field\"])",
										Start: ast.Position{
											Column: 46,
											Line:   48,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   53,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "columns: [\"_measurement\", \"_field\"]",
												Start: ast.Position{
													Column: 11,
													Line:   53,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   53,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "columns: [\"_measurement\", \"_field\"]",
													Start: ast.Position{
														Column: 11,
														Line:   53,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   53,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 11,
															Line:   53,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   53,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "[\"_measurement\", \"_field\"]",
														Start: ast.Position{
															Column: 20,
															Line:   53,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   53,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 21,
																Line:   53,
															},
														},
													},
													Value: "_measurement",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   53,
															},
															File:   "filter_by_values_with_and_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 37,
																Line:   53,
															},
														},
													},
													Value: "_field",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   53,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "group(columns: [\"_measurement\", \"_field\"])",
											Start: ast.Position{
												Column: 5,
												Line:   53,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   53,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "group",
												Start: ast.Position{
													Column: 5,
													Line:   53,
												},
											},
										},
										Name: "group",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   54,
									},
									File:   "filter_by_values_with_and_test.flux",
									Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])",
									Start: ast.Position{
										Column: 46,
										Line:   48,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   54,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "columns: [\"_time\"]",
											Start: ast.Position{
												Column: 10,
												Line:   54,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   54,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "columns: [\"_time\"]",
												Start: ast.Position{
													Column: 10,
													Line:   54,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 10,
														Line:   54,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   54,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "[\"_time\"]",
													Start: ast.Position{
														Column: 19,
														Line:   54,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   54,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "\"_time\"",
														Start: ast.Position{
															Column: 20,
															Line:   54,
														},
													},
												},
												Value: "_time",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   54,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "sort(columns: [\"_time\"])",
										Start: ast.Position{
											Column: 5,
											Line:   54,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   54,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "sort",
											Start: ast.Position{
												Column: 5,
												Line:   54,
											},
										},
									},
									Name: "sort",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   55,
								},
								File:   "filter_by_values_with_and_test.flux",
								Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
								Start: ast.Position{
									Column: 46,
									Line:   48,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   55,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
										Start: ast.Position{
											Column: 10,
											Line:   55,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   55,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
											Start: ast.Position{
												Column: 10,
												Line:   55,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   55,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 10,
													Line:   55,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   55,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "[\"_time\", \"_value\", \"_measurement\"]",
												Start: ast.Position{
													Column: 19,
													Line:   55,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   55,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 20,
														Line:   55,
													},
												},
											},
											Value: "_time",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   55,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 29,
														Line:   55,
													},
												},
											},
											Value: "_value",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   55,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "\"_measurement\"",
													Start: ast.Position{
														Column: 39,
														Line:   55,
													},
												},
											},
											Value: "_measurement",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   55,
									},
									File:   "filter_by_values_with_and_test.flux",
									Source: "keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
									Start: ast.Position{
										Column: 5,
										Line:   55,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   55,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "keep",
										Start: ast.Position{
											Column: 5,
											Line:   55,
										},
									},
								},
								Name: "keep",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   56,
							},
							File:   "filter_by_values_with_and_test.flux",
							Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"ctr\")\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> filter(fn: (r) => r._value >= 8 and r._value <= 14)\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
							Start: ast.Position{
								Column: 46,
								Line:   48,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   56,
									},
									File:   "filter_by_values_with_and_test.flux",
									Source: "columns: {_time: \"time\", _value: \"n\"}",
									Start: ast.Position{
										Column: 12,
										Line:   56,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   56,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "columns: {_time: \"time\", _value: \"n\"}",
										Start: ast.Position{
											Column: 12,
											Line:   56,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   56,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 12,
												Line:   56,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   56,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "{_time: \"time\", _value: \"n\"}",
											Start: ast.Position{
												Column: 21,
												Line:   56,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   56,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "_time: \"time\"",
												Start: ast.Position{
													Column: 22,
													Line:   56,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   56,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "_time",
													Start: ast.Position{
														Column: 22,
														Line:   56,
													},
												},
											},
											Name: "_time",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   56,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "\"time\"",
													Start: ast.Position{
														Column: 29,
														Line:   56,
													},
												},
											},
											Value: "time",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   56,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "_value: \"n\"",
												Start: ast.Position{
													Column: 37,
													Line:   56,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   56,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "_value",
													Start: ast.Position{
														Column: 37,
														Line:   56,
													},
												},
											},
											Name: "_value",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   56,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "\"n\"",
													Start: ast.Position{
														Column: 45,
														Line:   56,
													},
												},
											},
											Value: "n",
										},
									}},
									With: nil,
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   56,
								},
								File:   "filter_by_values_with_and_test.flux",
								Source: "rename(columns: {_time: \"time\", _value: \"n\"})",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   56,
									},
									File:   "filter_by_values_with_and_test.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 5,
										Line:   56,
									},
								},
							},
							Name: "rename",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   48,
							},
							File:   "filter_by_values_with_and_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 32,
								Line:   48,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   48,
								},
								File:   "filter_by_values_with_and_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 32,
									Line:   48,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   48,
							},
							File:   "filter_by_values_with_and_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 39,
								Line:   48,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   62,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "_filter_by_values_with_and = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_values_with_and,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   58,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   58,
							},
							File:   "filter_by_values_with_and_test.flux",
							Source: "_filter_by_values_with_and",
							Start: ast.Position{
								Column: 6,
								Line:   58,
							},
						},
					},
					Name: "_filter_by_values_with_and",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   62,
							},
							File:   "filter_by_values_with_and_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_values_with_and,\n})",
							Start: ast.Position{
								Column: 35,
								Line:   58,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   62,
								},
								File:   "filter_by_values_with_and_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_values_with_and,\n})",
								Start: ast.Position{
									Column: 41,
									Line:   58,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   62,
									},
									File:   "filter_by_values_with_and_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_values_with_and,\n}",
									Start: ast.Position{
										Column: 42,
										Line:   58,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   59,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   59,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   59,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   59,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   59,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   59,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   59,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   59,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   59,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   59,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   59,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   59,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   59,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   59,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   59,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   59,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   59,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   59,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   59,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   59,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   60,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   60,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   60,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   60,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   60,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   60,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   60,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   60,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   60,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   60,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   60,
														},
														File:   "filter_by_values_with_and_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   60,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   60,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   60,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   60,
												},
												File:   "filter_by_values_with_and_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   60,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   60,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   60,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   60,
													},
													File:   "filter_by_values_with_and_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   60,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   61,
										},
										File:   "filter_by_values_with_and_test.flux",
										Source: "fn: t_filter_by_values_with_and",
										Start: ast.Position{
											Column: 2,
											Line:   61,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   61,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   61,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   61,
											},
											File:   "filter_by_values_with_and_test.flux",
											Source: "t_filter_by_values_with_and",
											Start: ast.Position{
												Column: 6,
												Line:   61,
											},
										},
									},
									Name: "t_filter_by_values_with_and",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   62,
					},
					File:   "filter_by_values_with_and_test.flux",
					Source: "test _filter_by_values_with_and = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_filter_by_values_with_and,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   58,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "filter_by_values_with_and_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "filter_by_values_with_and_test.flux",
					Source: "import \"internal/influxql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "\"internal/influxql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/influxql",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "filter_by_values_with_and_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "filter_by_values_with_and_test.flux",
					Source: "package influxql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "filter_by_values_with_and_test.flux",
						Source: "influxql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxql_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   74,
				},
				File:   "regex_measurement_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,m_0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,n,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,n,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,n,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,n,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,n,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,n,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,n,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,n,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,n,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,n,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,n,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,n,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,n,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,n,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,n,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,n,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,n,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,n,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,n,9\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00Z,m_0,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,9\n\"\n\n// SELECT n FROM /^m/\nt_regex_measurement = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})\n\ntest _regex_measurement = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_regex_measurement,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "regex_measurement_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,m_0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,n,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,n,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,n,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,n,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,n,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,n,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,n,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,n,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,n,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,n,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,n,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,n,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,n,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,n,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,n,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,n,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,n,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,n,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,n,9\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "regex_measurement_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "regex_measurement_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,m_0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,n,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,n,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,n,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,n,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,n,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,n,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,n,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,n,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,n,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,n,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,n,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,n,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,n,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,n,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,n,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,n,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,n,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,n,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,n,9\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,1970-01-01T00:00:00Z,m_0,n,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,n,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,n,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,n,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,n,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,n,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,n,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,n,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,n,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,n,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,n,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,n,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,n,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,n,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,n,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,n,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,n,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,n,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,n,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,n,9\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   58,
					},
					File:   "regex_measurement_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00Z,m_0,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,9\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   33,
						},
						File:   "regex_measurement_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   58,
						},
						File:   "regex_measurement_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00Z,m_0,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,9\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   33,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,n\n,,0,1970-01-01T00:00:00Z,m_0,0\n,,1,1970-01-01T00:00:00.000000001Z,m_1,1\n,,2,1970-01-01T00:00:00.00000001Z,m_10,10\n,,3,1970-01-01T00:00:00.000000011Z,m_11,11\n,,4,1970-01-01T00:00:00.000000012Z,m_12,12\n,,5,1970-01-01T00:00:00.000000013Z,m_13,13\n,,6,1970-01-01T00:00:00.000000014Z,m_14,14\n,,7,1970-01-01T00:00:00.000000015Z,m_15,15\n,,8,1970-01-01T00:00:00.000000016Z,m_16,16\n,,9,1970-01-01T00:00:00.000000017Z,m_17,17\n,,10,1970-01-01T00:00:00.000000018Z,m_18,18\n,,11,1970-01-01T00:00:00.000000019Z,m_19,19\n,,12,1970-01-01T00:00:00.000000002Z,m_2,2\n,,13,1970-01-01T00:00:00.000000003Z,m_3,3\n,,14,1970-01-01T00:00:00.000000004Z,m_4,4\n,,15,1970-01-01T00:00:00.000000005Z,m_5,5\n,,16,1970-01-01T00:00:00.000000006Z,m_6,6\n,,17,1970-01-01T00:00:00.000000007Z,m_7,7\n,,18,1970-01-01T00:00:00.000000008Z,m_8,8\n,,19,1970-01-01T00:00:00.000000009Z,m_9,9\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 50,
						Line:   68,
					},
					File:   "regex_measurement_test.flux",
					Source: "t_regex_measurement = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
					Start: ast.Position{
						Column: 1,
						Line:   61,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   61,
						},
						File:   "regex_measurement_test.flux",
						Source: "t_regex_measurement",
						Start: ast.Position{
							Column: 1,
							Line:   61,
						},
					},
				},
				Name: "t_regex_measurement",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   68,
						},
						File:   "regex_measurement_test.flux",
						Source: "(tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
						Start: ast.Position{
							Column: 23,
							Line:   61,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   61,
														},
														File:   "regex_measurement_test.flux",
														Source: "tables",
														Start: ast.Position{
															Column: 38,
															Line:   61,
														},
													},
												},
												Name: "tables",
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   62,
													},
													File:   "regex_measurement_test.flux",
													Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)",
													Start: ast.Position{
														Column: 38,
														Line:   61,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   62,
															},
															File:   "regex_measurement_test.flux",
															Source: "start: influxql.minTime, stop: influxql.maxTime",
															Start: ast.Position{
																Column: 11,
																Line:   62,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   62,
																},
																File:   "regex_measurement_test.flux",
																Source: "start: influxql.minTime",
																Start: ast.Position{
																	Column: 11,
																	Line:   62,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   62,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 11,
																		Line:   62,
																	},
																},
															},
															Name: "start",
														},
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   62,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "influxql.minTime",
																	Start: ast.Position{
																		Column: 18,
																		Line:   62,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   62,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "influxql",
																		Start: ast.Position{
																			Column: 18,
																			Line:   62,
																		},
																	},
																},
																Name: "influxql",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   62,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "minTime",
																		Start: ast.Position{
																			Column: 27,
																			Line:   62,
																		},
																	},
																},
																Name: "minTime",
															},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   62,
																},
																File:   "regex_measurement_test.flux",
																Source: "stop: influxql.maxTime",
																Start: ast.Position{
																	Column: 36,
																	Line:   62,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   62,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 36,
																		Line:   62,
																	},
																},
															},
															Name: "stop",
														},
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   62,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "influxql.maxTime",
																	Start: ast.Position{
																		Column: 42,
																		Line:   62,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   62,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "influxql",
																		Start: ast.Position{
																			Column: 42,
																			Line:   62,
																		},
																	},
																},
																Name: "influxql",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   62,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "maxTime",
																		Start: ast.Position{
																			Column: 51,
																			Line:   62,
																		},
																	},
																},
																Name: "maxTime",
															},
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   62,
														},
														File:   "regex_measurement_test.flux",
														Source: "range(start: influxql.minTime, stop: influxql.maxTime)",
														Start: ast.Position{
															Column: 5,
															Line:   62,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   62,
															},
															File:   "regex_measurement_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 5,
																Line:   62,
															},
														},
													},
													Name: "range",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   63,
												},
												File:   "regex_measurement_test.flux",
												Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)",
												Start: ast.Position{
													Column: 38,
													Line:   61,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   63,
														},
														File:   "regex_measurement_test.flux",
														Source: "fn: (r) => r._measurement =~ /^m/",
														Start: ast.Position{
															Column: 12,
															Line:   63,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   63,
															},
															File:   "regex_measurement_test.flux",
															Source: "fn: (r) => r._measurement =~ /^m/",
															Start: ast.Position{
																Column: 12,
																Line:   63,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   63,
																},
																File:   "regex_measurement_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 12,
																	Line:   63,
																},
															},
														},
														Name: "fn",
													},
													Value: &ast.FunctionExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   63,
																},
																File:   "regex_measurement_test.flux",
																Source: "(r) => r._measurement =~ /^m/",
																Start: ast.Position{
																	Column: 16,
																	Line:   63,
																},
															},
														},
														Body: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   63,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "r._measurement =~ /^m/",
																	Start: ast.Position{
																		Column: 23,
																		Line:   63,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   63,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 23,
																			Line:   63,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   63,
																			},
																			File:   "regex_measurement_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 23,
																				Line:   63,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   63,
																			},
																			File:   "regex_measurement_test.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 25,
																				Line:   63,
																			},
																		},
																	},
																	Name: "_measurement",
																},
															},
															Operator: 19,
															Right: &ast.RegexpLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   63,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "/^m/",
																		Start: ast.Position{
																			Column: 41,
																			Line:   63,
																		},
																	},
																},
																Value: regexp.MustCompile("^m"),
															},
														},
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   63,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   63,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   63,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   63,
																		},
																	},
																},
																Name: "r",
															},
															Value: nil,
														}},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   63,
													},
													File:   "regex_measurement_test.flux",
													Source: "filter(fn: (r) => r._measurement =~ /^m/)",
													Start: ast.Position{
														Column: 5,
														Line:   63,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   63,
														},
														File:   "regex_measurement_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 5,
															Line:   63,
														},
													},
												},
												Name: "filter",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   64,
											},
											File:   "regex_measurement_test.flux",
											Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")",
											Start: ast.Position{
												Column: 38,
												Line:   61,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   64,
													},
													File:   "regex_measurement_test.flux",
													Source: "fn: (r) => r._field == \"n\"",
													Start: ast.Position{
														Column: 12,
														Line:   64,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   64,
														},
														File:   "regex_measurement_test.flux",
														Source: "fn: (r) => r._field == \"n\"",
														Start: ast.Position{
															Column: 12,
															Line:   64,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   64,
															},
															File:   "regex_measurement_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   64,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   64,
															},
															File:   "regex_measurement_test.flux",
															Source: "(r) => r._field == \"n\"",
															Start: ast.Position{
																Column: 16,
																Line:   64,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   64,
																},
																File:   "regex_measurement_test.flux",
																Source: "r._field == \"n\"",
																Start: ast.Position{
																	Column: 23,
																	Line:   64,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   64,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 23,
																		Line:   64,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   64,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 23,
																			Line:   64,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   64,
																		},
																		File:   "regex_measurement_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 25,
																			Line:   64,
																		},
																	},
																},
																Name: "_field",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   64,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "\"n\"",
																	Start: ast.Position{
																		Column: 35,
																		Line:   64,
																	},
																},
															},
															Value: "n",
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   64,
																},
																File:   "regex_measurement_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   64,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   64,
																	},
																	File:   "regex_measurement_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   64,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   64,
												},
												File:   "regex_measurement_test.flux",
												Source: "filter(fn: (r) => r._field == \"n\")",
												Start: ast.Position{
													Column: 5,
													Line:   64,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   64,
													},
													File:   "regex_measurement_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 5,
														Line:   64,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   65,
										},
										File:   "regex_measurement_test.flux",
										Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> group(columns: [\"_measurement\", \"_field\"])",
										Start: ast.Position{
											Column: 38,
											Line:   61,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   65,
												},
												File:   "regex_measurement_test.flux",
												Source: "columns: [\"_measurement\", \"_field\"]",
												Start: ast.Position{
													Column: 11,
													Line:   65,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   65,
													},
													File:   "regex_measurement_test.flux",
													Source: "columns: [\"_measurement\", \"_field\"]",
													Start: ast.Position{
														Column: 11,
														Line:   65,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   65,
														},
														File:   "regex_measurement_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 11,
															Line:   65,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   65,
														},
														File:   "regex_measurement_test.flux",
														Source: "[\"_measurement\", \"_field\"]",
														Start: ast.Position{
															Column: 20,
															Line:   65,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   65,
															},
															File:   "regex_measurement_test.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 21,
																Line:   65,
															},
														},
													},
													Value: "_measurement",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   65,
															},
															File:   "regex_measurement_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 37,
																Line:   65,
															},
														},
													},
													Value: "_field",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   65,
											},
											File:   "regex_measurement_test.flux",
											Source: "group(columns: [\"_measurement\", \"_field\"])",
											Start: ast.Position{
												Column: 5,
												Line:   65,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   65,
												},
												File:   "regex_measurement_test.flux",
												Source: "group",
												Start: ast.Position{
													Column: 5,
													Line:   65,
												},
											},
										},
										Name: "group",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   66,
									},
									File:   "regex_measurement_test.flux",
									Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])",
									Start: ast.Position{
										Column: 38,
										Line:   61,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   66,
											},
											File:   "regex_measurement_test.flux",
											Source: "columns: [\"_time\"]",
											Start: ast.Position{
												Column: 10,
												Line:   66,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   66,
												},
												File:   "regex_measurement_test.flux",
												Source: "columns: [\"_time\"]",
												Start: ast.Position{
													Column: 10,
													Line:   66,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   66,
													},
													File:   "regex_measurement_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 10,
														Line:   66,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   66,
													},
													File:   "regex_measurement_test.flux",
													Source: "[\"_time\"]",
													Start: ast.Position{
														Column: 19,
														Line:   66,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   66,
														},
														File:   "regex_measurement_test.flux",
														Source: "\"_time\"",
														Start: ast.Position{
															Column: 20,
															Line:   66,
														},
													},
												},
												Value: "_time",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   66,
										},
										File:   "regex_measurement_test.flux",
										Source: "sort(columns: [\"_time\"])",
										Start: ast.Position{
											Column: 5,
											Line:   66,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   66,
											},
											File:   "regex_measurement_test.flux",
											Source: "sort",
											Start: ast.Position{
												Column: 5,
												Line:   66,
											},
										},
									},
									Name: "sort",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   67,
								},
								File:   "regex_measurement_test.flux",
								Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
								Start: ast.Position{
									Column: 38,
									Line:   61,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   67,
										},
										File:   "regex_measurement_test.flux",
										Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
										Start: ast.Position{
											Column: 10,
											Line:   67,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   67,
											},
											File:   "regex_measurement_test.flux",
											Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
											Start: ast.Position{
												Column: 10,
												Line:   67,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   67,
												},
												File:   "regex_measurement_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 10,
													Line:   67,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   67,
												},
												File:   "regex_measurement_test.flux",
												Source: "[\"_time\", \"_value\", \"_measurement\"]",
												Start: ast.Position{
													Column: 19,
													Line:   67,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   67,
													},
													File:   "regex_measurement_test.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 20,
														Line:   67,
													},
												},
											},
											Value: "_time",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   67,
													},
													File:   "regex_measurement_test.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 29,
														Line:   67,
													},
												},
											},
											Value: "_value",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   67,
													},
													File:   "regex_measurement_test.flux",
													Source: "\"_measurement\"",
													Start: ast.Position{
														Column: 39,
														Line:   67,
													},
												},
											},
											Value: "_measurement",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   67,
									},
									File:   "regex_measurement_test.flux",
									Source: "keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
									Start: ast.Position{
										Column: 5,
										Line:   67,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   67,
										},
										File:   "regex_measurement_test.flux",
										Source: "keep",
										Start: ast.Position{
											Column: 5,
											Line:   67,
										},
									},
								},
								Name: "keep",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   68,
							},
							File:   "regex_measurement_test.flux",
							Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement =~ /^m/)\n\t|> filter(fn: (r) => r._field == \"n\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> sort(columns: [\"_time\"])\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"n\"})",
							Start: ast.Position{
								Column: 38,
								Line:   61,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   68,
									},
									File:   "regex_measurement_test.flux",
									Source: "columns: {_time: \"time\", _value: \"n\"}",
									Start: ast.Position{
										Column: 12,
										Line:   68,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   68,
										},
										File:   "regex_measurement_test.flux",
										Source: "columns: {_time: \"time\", _value: \"n\"}",
										Start: ast.Position{
											Column: 12,
											Line:   68,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   68,
											},
											File:   "regex_measurement_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 12,
												Line:   68,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   68,
											},
											File:   "regex_measurement_test.flux",
											Source: "{_time: \"time\", _value: \"n\"}",
											Start: ast.Position{
												Column: 21,
												Line:   68,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   68,
												},
												File:   "regex_measurement_test.flux",
												Source: "_time: \"time\"",
												Start: ast.Position{
													Column: 22,
													Line:   68,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   68,
													},
													File:   "regex_measurement_test.flux",
													Source: "_time",
													Start: ast.Position{
														Column: 22,
														Line:   68,
													},
												},
											},
											Name: "_time",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   68,
													},
													File:   "regex_measurement_test.flux",
													Source: "\"time\"",
													Start: ast.Position{
														Column: 29,
														Line:   68,
													},
												},
											},
											Value: "time",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   68,
												},
												File:   "regex_measurement_test.flux",
												Source: "_value: \"n\"",
												Start: ast.Position{
													Column: 37,
													Line:   68,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   68,
													},
													File:   "regex_measurement_test.flux",
													Source: "_value",
													Start: ast.Position{
														Column: 37,
														Line:   68,
													},
												},
											},
											Name: "_value",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   68,
													},
													File:   "regex_measurement_test.flux",
													Source: "\"n\"",
													Start: ast.Position{
														Column: 45,
														Line:   68,
													},
												},
											},
											Value: "n",
										},
									}},
									With: nil,
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   68,
								},
								File:   "regex_measurement_test.flux",
								Source: "rename(columns: {_time: \"time\", _value: \"n\"})",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   68,
									},
									File:   "regex_measurement_test.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 5,
										Line:   68,
									},
								},
							},
							Name: "rename",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   61,
							},
							File:   "regex_measurement_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 24,
								Line:   61,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   61,
								},
								File:   "regex_measurement_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 24,
									Line:   61,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   61,
							},
							File:   "regex_measurement_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 31,
								Line:   61,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   74,
						},
						File:   "regex_measurement_test.flux",
						Source: "_regex_measurement = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_regex_measurement,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   70,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   70,
							},
							File:   "regex_measurement_test.flux",
							Source: "_regex_measurement",
							Start: ast.Position{
								Column: 6,
								Line:   70,
							},
						},
					},
					Name: "_regex_measurement",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   74,
							},
							File:   "regex_measurement_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_regex_measurement,\n})",
							Start: ast.Position{
								Column: 27,
								Line:   70,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   74,
								},
								File:   "regex_measurement_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_regex_measurement,\n})",
								Start: ast.Position{
									Column: 33,
									Line:   70,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   74,
									},
									File:   "regex_measurement_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_regex_measurement,\n}",
									Start: ast.Position{
										Column: 34,
										Line:   70,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   71,
										},
										File:   "regex_measurement_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   71,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   71,
											},
											File:   "regex_measurement_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   71,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   71,
												},
												File:   "regex_measurement_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   71,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   71,
													},
													File:   "regex_measurement_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   71,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   71,
														},
														File:   "regex_measurement_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   71,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   71,
														},
														File:   "regex_measurement_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   71,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   71,
											},
											File:   "regex_measurement_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   71,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   71,
												},
												File:   "regex_measurement_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   71,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   71,
													},
													File:   "regex_measurement_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   71,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   71,
													},
													File:   "regex_measurement_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   71,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   72,
										},
										File:   "regex_measurement_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   72,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   72,
											},
											File:   "regex_measurement_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   72,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   72,
												},
												File:   "regex_measurement_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   72,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   72,
													},
													File:   "regex_measurement_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   72,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   72,
														},
														File:   "regex_measurement_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   72,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   72,
														},
														File:   "regex_measurement_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   72,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   72,
											},
											File:   "regex_measurement_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   72,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   72,
												},
												File:   "regex_measurement_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   72,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   72,
													},
													File:   "regex_measurement_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   72,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   72,
													},
													File:   "regex_measurement_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   72,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   73,
										},
										File:   "regex_measurement_test.flux",
										Source: "fn: t_regex_measurement",
										Start: ast.Position{
											Column: 2,
											Line:   73,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   73,
											},
											File:   "regex_measurement_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   73,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   73,
											},
											File:   "regex_measurement_test.flux",
											Source: "t_regex_measurement",
											Start: ast.Position{
												Column: 6,
												Line:   73,
											},
										},
									},
									Name: "t_regex_measurement",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   74,
					},
					File:   "regex_measurement_test.flux",
					Source: "test _regex_measurement = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_regex_measurement,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "regex_measurement_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "regex_measurement_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "regex_measurement_test.flux",
					Source: "import \"internal/influxql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "regex_measurement_test.flux",
						Source: "\"internal/influxql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/influxql",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "regex_measurement_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "regex_measurement_test.flux",
					Source: "package influxql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "regex_measurement_test.flux",
						Source: "influxql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxql_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   435,
				},
				File:   "selector_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,0,,,,,,,\n,result,table,_time,_measurement,t0,t1,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,0,f,0.21546887461084024\n,,0,1970-01-01T00:00:01Z,m,0,0,f,0.9576896132790585\n,,0,1970-01-01T00:00:02Z,m,0,0,f,0.294953913000311\n,,0,1970-01-01T00:00:03Z,m,0,0,f,0.4651741324883778\n,,0,1970-01-01T00:00:04Z,m,0,0,f,0.9873388815871567\n,,0,1970-01-01T00:00:05Z,m,0,0,f,0.3845474109517986\n,,0,1970-01-01T00:00:06Z,m,0,0,f,0.2922442980858412\n,,0,1970-01-01T00:00:07Z,m,0,0,f,0.03298588199059829\n,,0,1970-01-01T00:00:08Z,m,0,0,f,0.969396406468683\n,,0,1970-01-01T00:00:09Z,m,0,0,f,0.8126386582005671\n,,0,1970-01-01T00:00:10Z,m,0,0,f,0.875468209815408\n,,0,1970-01-01T00:00:11Z,m,0,0,f,0.43242435584494165\n,,0,1970-01-01T00:00:12Z,m,0,0,f,0.43936224189298456\n,,0,1970-01-01T00:00:13Z,m,0,0,f,0.1224409595139043\n,,0,1970-01-01T00:00:14Z,m,0,0,f,0.15733684152804783\n,,0,1970-01-01T00:00:15Z,m,0,0,f,0.08882282140312904\n,,0,1970-01-01T00:00:16Z,m,0,0,f,0.23989257176325227\n,,0,1970-01-01T00:00:17Z,m,0,0,f,0.6955232509082638\n,,0,1970-01-01T00:00:18Z,m,0,0,f,0.43554475339119303\n,,0,1970-01-01T00:00:19Z,m,0,0,f,0.3051713218684253\n,,0,1970-01-01T00:00:20Z,m,0,0,f,0.7413025816537797\n,,0,1970-01-01T00:00:21Z,m,0,0,f,0.24567297998270615\n,,0,1970-01-01T00:00:22Z,m,0,0,f,0.491391504478891\n,,0,1970-01-01T00:00:23Z,m,0,0,f,0.13872180750181634\n,,0,1970-01-01T00:00:24Z,m,0,0,f,0.06729135892978601\n,,0,1970-01-01T00:00:25Z,m,0,0,f,0.2711347220286289\n,,0,1970-01-01T00:00:26Z,m,0,0,f,0.5465962906385142\n,,0,1970-01-01T00:00:27Z,m,0,0,f,0.1721498986023557\n,,0,1970-01-01T00:00:28Z,m,0,0,f,0.928541805026285\n,,0,1970-01-01T00:00:29Z,m,0,0,f,0.4390512841392946\n,,0,1970-01-01T00:00:30Z,m,0,0,f,0.7891509564074856\n,,0,1970-01-01T00:00:31Z,m,0,0,f,0.03752404112396554\n,,0,1970-01-01T00:00:32Z,m,0,0,f,0.8731292945164265\n,,0,1970-01-01T00:00:33Z,m,0,0,f,0.6590129312109282\n,,0,1970-01-01T00:00:34Z,m,0,0,f,0.7298034951937612\n,,0,1970-01-01T00:00:35Z,m,0,0,f,0.6880331199538888\n,,0,1970-01-01T00:00:36Z,m,0,0,f,0.7884092917020722\n,,0,1970-01-01T00:00:37Z,m,0,0,f,0.9071621838398441\n,,0,1970-01-01T00:00:38Z,m,0,0,f,0.5029003668295414\n,,0,1970-01-01T00:00:39Z,m,0,0,f,0.5545818527629861\n,,0,1970-01-01T00:00:40Z,m,0,0,f,0.763728196635538\n,,0,1970-01-01T00:00:41Z,m,0,0,f,0.5870046094520823\n,,0,1970-01-01T00:00:42Z,m,0,0,f,0.7675553560334312\n,,0,1970-01-01T00:00:43Z,m,0,0,f,0.8279726730049255\n,,0,1970-01-01T00:00:44Z,m,0,0,f,0.7013474149025897\n,,0,1970-01-01T00:00:45Z,m,0,0,f,0.08556981440432106\n,,0,1970-01-01T00:00:46Z,m,0,0,f,0.8520957093766447\n,,0,1970-01-01T00:00:47Z,m,0,0,f,0.41873957390346783\n,,0,1970-01-01T00:00:48Z,m,0,0,f,0.04405459160245573\n,,0,1970-01-01T00:00:49Z,m,0,0,f,0.8184927094237151\n,,0,1970-01-01T00:00:50Z,m,0,0,f,0.0975526753791771\n,,0,1970-01-01T00:00:51Z,m,0,0,f,0.4984015942759995\n,,0,1970-01-01T00:00:52Z,m,0,0,f,0.24094630162586889\n,,0,1970-01-01T00:00:53Z,m,0,0,f,0.1461722759564162\n,,0,1970-01-01T00:00:54Z,m,0,0,f,0.0008451156568219057\n,,0,1970-01-01T00:00:55Z,m,0,0,f,0.4633414547017063\n,,0,1970-01-01T00:00:56Z,m,0,0,f,0.4539668492775038\n,,0,1970-01-01T00:00:57Z,m,0,0,f,0.4868916379116324\n,,0,1970-01-01T00:00:58Z,m,0,0,f,0.9566203795860617\n,,0,1970-01-01T00:00:59Z,m,0,0,f,0.9599106283927733\n,,0,1970-01-01T00:01:00Z,m,0,0,f,0.7293729603954808\n,,0,1970-01-01T00:01:01Z,m,0,0,f,0.6455698152977222\n,,0,1970-01-01T00:01:02Z,m,0,0,f,0.11441321827059112\n,,0,1970-01-01T00:01:03Z,m,0,0,f,0.9955326395256039\n,,0,1970-01-01T00:01:04Z,m,0,0,f,0.44266439346958053\n,,0,1970-01-01T00:01:05Z,m,0,0,f,0.7183012898949253\n,,0,1970-01-01T00:01:06Z,m,0,0,f,0.30706108459030473\n,,0,1970-01-01T00:01:07Z,m,0,0,f,0.5034183578538529\n,,0,1970-01-01T00:01:08Z,m,0,0,f,0.945541035399725\n,,0,1970-01-01T00:01:09Z,m,0,0,f,0.4233995128157775\n,,0,1970-01-01T00:01:10Z,m,0,0,f,0.7647066005216012\n,,0,1970-01-01T00:01:11Z,m,0,0,f,0.4427721542156412\n,,0,1970-01-01T00:01:12Z,m,0,0,f,0.5759588898144714\n,,0,1970-01-01T00:01:13Z,m,0,0,f,0.4891738037219912\n,,0,1970-01-01T00:01:14Z,m,0,0,f,0.3162573404966396\n,,0,1970-01-01T00:01:15Z,m,0,0,f,0.12429098278245032\n,,0,1970-01-01T00:01:16Z,m,0,0,f,0.5500314687416078\n,,0,1970-01-01T00:01:17Z,m,0,0,f,0.07874290942037632\n,,0,1970-01-01T00:01:18Z,m,0,0,f,0.2432131181375912\n,,0,1970-01-01T00:01:19Z,m,0,0,f,0.2059157686630176\n,,0,1970-01-01T00:01:20Z,m,0,0,f,0.44865547217512164\n,,0,1970-01-01T00:01:21Z,m,0,0,f,0.7168101661064027\n,,0,1970-01-01T00:01:22Z,m,0,0,f,0.36652553198536764\n,,0,1970-01-01T00:01:23Z,m,0,0,f,0.12875338574773973\n,,0,1970-01-01T00:01:24Z,m,0,0,f,0.14050907817041347\n,,0,1970-01-01T00:01:25Z,m,0,0,f,0.4095172637990756\n,,0,1970-01-01T00:01:26Z,m,0,0,f,0.2460700738777719\n,,0,1970-01-01T00:01:27Z,m,0,0,f,0.7823912602040078\n,,0,1970-01-01T00:01:28Z,m,0,0,f,0.707534534477093\n,,0,1970-01-01T00:01:29Z,m,0,0,f,0.6714337668672199\n,,0,1970-01-01T00:01:30Z,m,0,0,f,0.6443730852735031\n,,0,1970-01-01T00:01:31Z,m,0,0,f,0.8349467641212396\n,,0,1970-01-01T00:01:32Z,m,0,0,f,0.7443365385220384\n,,0,1970-01-01T00:01:33Z,m,0,0,f,0.778092873581952\n,,0,1970-01-01T00:01:34Z,m,0,0,f,0.21451835990529106\n,,0,1970-01-01T00:01:35Z,m,0,0,f,0.15132579382756906\n,,0,1970-01-01T00:01:36Z,m,0,0,f,0.889690688725347\n,,0,1970-01-01T00:01:37Z,m,0,0,f,0.08177608166572663\n,,0,1970-01-01T00:01:38Z,m,0,0,f,0.6156947898336163\n,,0,1970-01-01T00:01:39Z,m,0,0,f,0.8839098227070676\n,,1,1970-01-01T00:00:00Z,m,0,1,f,0.47284307199688513\n,,1,1970-01-01T00:00:01Z,m,0,1,f,0.6115110431660992\n,,1,1970-01-01T00:00:02Z,m,0,1,f,0.9139676390179812\n,,1,1970-01-01T00:00:03Z,m,0,1,f,0.4419580502994864\n,,1,1970-01-01T00:00:04Z,m,0,1,f,0.22346720477114235\n,,1,1970-01-01T00:00:05Z,m,0,1,f,0.01657253263970824\n,,1,1970-01-01T00:00:06Z,m,0,1,f,0.5275526538985256\n,,1,1970-01-01T00:00:07Z,m,0,1,f,0.2801453905589357\n,,1,1970-01-01T00:00:08Z,m,0,1,f,0.40358058571546174\n,,1,1970-01-01T00:00:09Z,m,0,1,f,0.5581225312763497\n,,1,1970-01-01T00:00:10Z,m,0,1,f,0.5618381020173508\n,,1,1970-01-01T00:00:11Z,m,0,1,f,0.08048303365885615\n,,1,1970-01-01T00:00:12Z,m,0,1,f,0.5001751201461243\n,,1,1970-01-01T00:00:13Z,m,0,1,f,0.22639175489524663\n,,1,1970-01-01T00:00:14Z,m,0,1,f,0.26537476142069744\n,,1,1970-01-01T00:00:15Z,m,0,1,f,0.8045352065828273\n,,1,1970-01-01T00:00:16Z,m,0,1,f,0.401634967963577\n,,1,1970-01-01T00:00:17Z,m,0,1,f,0.9411501472896155\n,,1,1970-01-01T00:00:18Z,m,0,1,f,0.2930734491556474\n,,1,1970-01-01T00:00:19Z,m,0,1,f,0.18157543568371715\n,,1,1970-01-01T00:00:20Z,m,0,1,f,0.9385325130161203\n,,1,1970-01-01T00:00:21Z,m,0,1,f,0.17010332650185725\n,,1,1970-01-01T00:00:22Z,m,0,1,f,0.04213339793024455\n,,1,1970-01-01T00:00:23Z,m,0,1,f,0.5626619227163632\n,,1,1970-01-01T00:00:24Z,m,0,1,f,0.6941739177125473\n,,1,1970-01-01T00:00:25Z,m,0,1,f,0.5438842736369963\n,,1,1970-01-01T00:00:26Z,m,0,1,f,0.6524346931171858\n,,1,1970-01-01T00:00:27Z,m,0,1,f,0.062106354006262784\n,,1,1970-01-01T00:00:28Z,m,0,1,f,0.6808062354975885\n,,1,1970-01-01T00:00:29Z,m,0,1,f,0.4566938577876695\n,,1,1970-01-01T00:00:30Z,m,0,1,f,0.15426646385258916\n,,1,1970-01-01T00:00:31Z,m,0,1,f,0.7378414694167669\n,,1,1970-01-01T00:00:32Z,m,0,1,f,0.35905015546070745\n,,1,1970-01-01T00:00:33Z,m,0,1,f,0.25717348995611955\n,,1,1970-01-01T00:00:34Z,m,0,1,f,0.8669066045043076\n,,1,1970-01-01T00:00:35Z,m,0,1,f,0.7414665987538746\n,,1,1970-01-01T00:00:36Z,m,0,1,f,0.7580463272135385\n,,1,1970-01-01T00:00:37Z,m,0,1,f,0.223202540983848\n,,1,1970-01-01T00:00:38Z,m,0,1,f,0.09675623584194015\n,,1,1970-01-01T00:00:39Z,m,0,1,f,0.33037602371875235\n,,1,1970-01-01T00:00:40Z,m,0,1,f,0.02419699334564844\n,,1,1970-01-01T00:00:41Z,m,0,1,f,0.30660540046813134\n,,1,1970-01-01T00:00:42Z,m,0,1,f,0.28087743747358407\n,,1,1970-01-01T00:00:43Z,m,0,1,f,0.8125957553254125\n,,1,1970-01-01T00:00:44Z,m,0,1,f,0.3996499465775914\n,,1,1970-01-01T00:00:45Z,m,0,1,f,0.002859922694346698\n,,1,1970-01-01T00:00:46Z,m,0,1,f,0.7743871384683348\n,,1,1970-01-01T00:00:47Z,m,0,1,f,0.3428194666142575\n,,1,1970-01-01T00:00:48Z,m,0,1,f,0.24529106535786452\n,,1,1970-01-01T00:00:49Z,m,0,1,f,0.42074581063787847\n,,1,1970-01-01T00:00:50Z,m,0,1,f,0.8230512029974123\n,,1,1970-01-01T00:00:51Z,m,0,1,f,0.7612451595826552\n,,1,1970-01-01T00:00:52Z,m,0,1,f,0.0025044233308020394\n,,1,1970-01-01T00:00:53Z,m,0,1,f,0.8123608833291784\n,,1,1970-01-01T00:00:54Z,m,0,1,f,0.094280039506472\n,,1,1970-01-01T00:00:55Z,m,0,1,f,0.7414773533860608\n,,1,1970-01-01T00:00:56Z,m,0,1,f,0.048248944868655844\n,,1,1970-01-01T00:00:57Z,m,0,1,f,0.7876232215876143\n,,1,1970-01-01T00:00:58Z,m,0,1,f,0.7708955207540708\n,,1,1970-01-01T00:00:59Z,m,0,1,f,0.3210082428062905\n,,1,1970-01-01T00:01:00Z,m,0,1,f,0.6199485490487467\n,,1,1970-01-01T00:01:01Z,m,0,1,f,0.4526111772487005\n,,1,1970-01-01T00:01:02Z,m,0,1,f,0.06993036738408297\n,,1,1970-01-01T00:01:03Z,m,0,1,f,0.5391803940621971\n,,1,1970-01-01T00:01:04Z,m,0,1,f,0.3786026404218388\n,,1,1970-01-01T00:01:05Z,m,0,1,f,0.16987447951514412\n,,1,1970-01-01T00:01:06Z,m,0,1,f,0.9622624203254517\n,,1,1970-01-01T00:01:07Z,m,0,1,f,0.10609876802280566\n,,1,1970-01-01T00:01:08Z,m,0,1,f,0.34039196604520483\n,,1,1970-01-01T00:01:09Z,m,0,1,f,0.326997943237989\n,,1,1970-01-01T00:01:10Z,m,0,1,f,0.40582069426239586\n,,1,1970-01-01T00:01:11Z,m,0,1,f,0.09664389869310906\n,,1,1970-01-01T00:01:12Z,m,0,1,f,0.0874716642419619\n,,1,1970-01-01T00:01:13Z,m,0,1,f,0.9574787428982809\n,,1,1970-01-01T00:01:14Z,m,0,1,f,0.792171281216902\n,,1,1970-01-01T00:01:15Z,m,0,1,f,0.8154053514727819\n,,1,1970-01-01T00:01:16Z,m,0,1,f,0.9446634309508735\n,,1,1970-01-01T00:01:17Z,m,0,1,f,0.7914039734656017\n,,1,1970-01-01T00:01:18Z,m,0,1,f,0.5642005948380394\n,,1,1970-01-01T00:01:19Z,m,0,1,f,0.9394901508564378\n,,1,1970-01-01T00:01:20Z,m,0,1,f,0.09420964672484634\n,,1,1970-01-01T00:01:21Z,m,0,1,f,0.8997154088951347\n,,1,1970-01-01T00:01:22Z,m,0,1,f,0.8929163087698091\n,,1,1970-01-01T00:01:23Z,m,0,1,f,0.14602512562046865\n,,1,1970-01-01T00:01:24Z,m,0,1,f,0.061755078411980135\n,,1,1970-01-01T00:01:25Z,m,0,1,f,0.050027231315704974\n,,1,1970-01-01T00:01:26Z,m,0,1,f,0.06579399435541186\n,,1,1970-01-01T00:01:27Z,m,0,1,f,0.5485533330294929\n,,1,1970-01-01T00:01:28Z,m,0,1,f,0.08600793471366114\n,,1,1970-01-01T00:01:29Z,m,0,1,f,0.0048224932897884395\n,,1,1970-01-01T00:01:30Z,m,0,1,f,0.031000679866955753\n,,1,1970-01-01T00:01:31Z,m,0,1,f,0.7590758510991269\n,,1,1970-01-01T00:01:32Z,m,0,1,f,0.28752964131696107\n,,1,1970-01-01T00:01:33Z,m,0,1,f,0.0803113942730073\n,,1,1970-01-01T00:01:34Z,m,0,1,f,0.7653660195907919\n,,1,1970-01-01T00:01:35Z,m,0,1,f,0.169201547040183\n,,1,1970-01-01T00:01:36Z,m,0,1,f,0.2812417370494343\n,,1,1970-01-01T00:01:37Z,m,0,1,f,0.5556525309491438\n,,1,1970-01-01T00:01:38Z,m,0,1,f,0.21336394958285926\n,,1,1970-01-01T00:01:39Z,m,0,1,f,0.843202199200085\n,,2,1970-01-01T00:00:00Z,m,1,0,f,0.6745411981120504\n,,2,1970-01-01T00:00:01Z,m,1,0,f,0.4341136360856983\n,,2,1970-01-01T00:00:02Z,m,1,0,f,0.0779873994184798\n,,2,1970-01-01T00:00:03Z,m,1,0,f,0.6045688060594187\n,,2,1970-01-01T00:00:04Z,m,1,0,f,0.609806908577383\n,,2,1970-01-01T00:00:05Z,m,1,0,f,0.2371373109677929\n,,2,1970-01-01T00:00:06Z,m,1,0,f,0.15959047192822226\n,,2,1970-01-01T00:00:07Z,m,1,0,f,0.7696930667476671\n,,2,1970-01-01T00:00:08Z,m,1,0,f,0.44489788239949923\n,,2,1970-01-01T00:00:09Z,m,1,0,f,0.20113730484499945\n,,2,1970-01-01T00:00:10Z,m,1,0,f,0.9004310672214374\n,,2,1970-01-01T00:00:11Z,m,1,0,f,0.08071979045152104\n,,2,1970-01-01T00:00:12Z,m,1,0,f,0.35878401311181407\n,,2,1970-01-01T00:00:13Z,m,1,0,f,0.8046013839899406\n,,2,1970-01-01T00:00:14Z,m,1,0,f,0.09869242829873062\n,,2,1970-01-01T00:00:15Z,m,1,0,f,0.27053244466215826\n,,2,1970-01-01T00:00:16Z,m,1,0,f,0.6672055373259661\n,,2,1970-01-01T00:00:17Z,m,1,0,f,0.9015798497859395\n,,2,1970-01-01T00:00:18Z,m,1,0,f,0.6514438661906353\n,,2,1970-01-01T00:00:19Z,m,1,0,f,0.03319201114385362\n,,2,1970-01-01T00:00:20Z,m,1,0,f,0.44109087427118215\n,,2,1970-01-01T00:00:21Z,m,1,0,f,0.1441063884747634\n,,2,1970-01-01T00:00:22Z,m,1,0,f,0.23335939084421864\n,,2,1970-01-01T00:00:23Z,m,1,0,f,0.6904277645853616\n,,2,1970-01-01T00:00:24Z,m,1,0,f,0.5145930899531316\n,,2,1970-01-01T00:00:25Z,m,1,0,f,0.4299752694354613\n,,2,1970-01-01T00:00:26Z,m,1,0,f,0.9207494524068397\n,,2,1970-01-01T00:00:27Z,m,1,0,f,0.4990764483657634\n,,2,1970-01-01T00:00:28Z,m,1,0,f,0.7370053493218158\n,,2,1970-01-01T00:00:29Z,m,1,0,f,0.8159190359865772\n,,2,1970-01-01T00:00:30Z,m,1,0,f,0.5730300999100897\n,,2,1970-01-01T00:00:31Z,m,1,0,f,0.4957548727598841\n,,2,1970-01-01T00:00:32Z,m,1,0,f,0.4475722509767004\n,,2,1970-01-01T00:00:33Z,m,1,0,f,0.09000105562869058\n,,2,1970-01-01T00:00:34Z,m,1,0,f,0.5765896961954948\n,,2,1970-01-01T00:00:35Z,m,1,0,f,0.007292186311595296\n,,2,1970-01-01T00:00:36Z,m,1,0,f,0.6862338192326899\n,,2,1970-01-01T00:00:37Z,m,1,0,f,0.6323091325867545\n,,2,1970-01-01T00:00:38Z,m,1,0,f,0.22250144688828086\n,,2,1970-01-01T00:00:39Z,m,1,0,f,0.7767158293696542\n,,2,1970-01-01T00:00:40Z,m,1,0,f,0.5040765046136644\n,,2,1970-01-01T00:00:41Z,m,1,0,f,0.7198824794590694\n,,2,1970-01-01T00:00:42Z,m,1,0,f,0.16487220863546403\n,,2,1970-01-01T00:00:43Z,m,1,0,f,0.6185190195253291\n,,2,1970-01-01T00:00:44Z,m,1,0,f,0.417935209198883\n,,2,1970-01-01T00:00:45Z,m,1,0,f,0.143322367253724\n,,2,1970-01-01T00:00:46Z,m,1,0,f,0.7110860020844423\n,,2,1970-01-01T00:00:47Z,m,1,0,f,0.5190433935276061\n,,2,1970-01-01T00:00:48Z,m,1,0,f,0.5947710020498977\n,,2,1970-01-01T00:00:49Z,m,1,0,f,0.18632874860445664\n,,2,1970-01-01T00:00:50Z,m,1,0,f,0.050671657609869296\n,,2,1970-01-01T00:00:51Z,m,1,0,f,0.336667976831678\n,,2,1970-01-01T00:00:52Z,m,1,0,f,0.16893598340949662\n,,2,1970-01-01T00:00:53Z,m,1,0,f,0.6319794509787114\n,,2,1970-01-01T00:00:54Z,m,1,0,f,0.3434433122927547\n,,2,1970-01-01T00:00:55Z,m,1,0,f,0.13766344408813833\n,,2,1970-01-01T00:00:56Z,m,1,0,f,0.7028890267599247\n,,2,1970-01-01T00:00:57Z,m,1,0,f,0.5893915586856076\n,,2,1970-01-01T00:00:58Z,m,1,0,f,0.08495375348679511\n,,2,1970-01-01T00:00:59Z,m,1,0,f,0.5635570663754376\n,,2,1970-01-01T00:01:00Z,m,1,0,f,0.06973804413592974\n,,2,1970-01-01T00:01:01Z,m,1,0,f,0.4594087627832006\n,,2,1970-01-01T00:01:02Z,m,1,0,f,0.9484143072574632\n,,2,1970-01-01T00:01:03Z,m,1,0,f,0.7210862651644585\n,,2,1970-01-01T00:01:04Z,m,1,0,f,0.4306492881221061\n,,2,1970-01-01T00:01:05Z,m,1,0,f,0.9768511587696722\n,,2,1970-01-01T00:01:06Z,m,1,0,f,0.036770411149115535\n,,2,1970-01-01T00:01:07Z,m,1,0,f,0.199704171721732\n,,2,1970-01-01T00:01:08Z,m,1,0,f,0.044989678879272736\n,,2,1970-01-01T00:01:09Z,m,1,0,f,0.4204918747032285\n,,2,1970-01-01T00:01:10Z,m,1,0,f,0.7660528673315015\n,,2,1970-01-01T00:01:11Z,m,1,0,f,0.07495082447510862\n,,2,1970-01-01T00:01:12Z,m,1,0,f,0.979672949703\n,,2,1970-01-01T00:01:13Z,m,1,0,f,0.43531431314587743\n,,2,1970-01-01T00:01:14Z,m,1,0,f,0.16473009865933294\n,,2,1970-01-01T00:01:15Z,m,1,0,f,0.9714924938553514\n,,2,1970-01-01T00:01:16Z,m,1,0,f,0.8548205740914873\n,,2,1970-01-01T00:01:17Z,m,1,0,f,0.988621458104506\n,,2,1970-01-01T00:01:18Z,m,1,0,f,0.42316749552422783\n,,2,1970-01-01T00:01:19Z,m,1,0,f,0.5599137447927957\n,,2,1970-01-01T00:01:20Z,m,1,0,f,0.7513515954882367\n,,2,1970-01-01T00:01:21Z,m,1,0,f,0.07681127373236643\n,,2,1970-01-01T00:01:22Z,m,1,0,f,0.04219934813632237\n,,2,1970-01-01T00:01:23Z,m,1,0,f,0.27672511415229256\n,,2,1970-01-01T00:01:24Z,m,1,0,f,0.6618414211834359\n,,2,1970-01-01T00:01:25Z,m,1,0,f,0.04819580958061359\n,,2,1970-01-01T00:01:26Z,m,1,0,f,0.8514613397306017\n,,2,1970-01-01T00:01:27Z,m,1,0,f,0.654705748814002\n,,2,1970-01-01T00:01:28Z,m,1,0,f,0.9967833661484294\n,,2,1970-01-01T00:01:29Z,m,1,0,f,0.9631421129969118\n,,2,1970-01-01T00:01:30Z,m,1,0,f,0.6286421005881492\n,,2,1970-01-01T00:01:31Z,m,1,0,f,0.3783501632738452\n,,2,1970-01-01T00:01:32Z,m,1,0,f,0.05114898778086843\n,,2,1970-01-01T00:01:33Z,m,1,0,f,0.2473880323048304\n,,2,1970-01-01T00:01:34Z,m,1,0,f,0.7842674808782694\n,,2,1970-01-01T00:01:35Z,m,1,0,f,0.6130952139646441\n,,2,1970-01-01T00:01:36Z,m,1,0,f,0.9762618521418323\n,,2,1970-01-01T00:01:37Z,m,1,0,f,0.9219480325346383\n,,2,1970-01-01T00:01:38Z,m,1,0,f,0.7986205925631757\n,,2,1970-01-01T00:01:39Z,m,1,0,f,0.578541588985068\n,,3,1970-01-01T00:00:00Z,m,1,1,f,0.3609497652786835\n,,3,1970-01-01T00:00:01Z,m,1,1,f,0.6431495269328852\n,,3,1970-01-01T00:00:02Z,m,1,1,f,0.30119517109360755\n,,3,1970-01-01T00:00:03Z,m,1,1,f,0.029905756669452933\n,,3,1970-01-01T00:00:04Z,m,1,1,f,0.32578997668820153\n,,3,1970-01-01T00:00:05Z,m,1,1,f,0.7482046757377168\n,,3,1970-01-01T00:00:06Z,m,1,1,f,0.42006674019623874\n,,3,1970-01-01T00:00:07Z,m,1,1,f,0.8892383923700209\n,,3,1970-01-01T00:00:08Z,m,1,1,f,0.2734890146915862\n,,3,1970-01-01T00:00:09Z,m,1,1,f,0.2126705472958595\n,,3,1970-01-01T00:00:10Z,m,1,1,f,0.4081541720871348\n,,3,1970-01-01T00:00:11Z,m,1,1,f,0.7517886726430452\n,,3,1970-01-01T00:00:12Z,m,1,1,f,0.6344255763748975\n,,3,1970-01-01T00:00:13Z,m,1,1,f,0.13439033950657941\n,,3,1970-01-01T00:00:14Z,m,1,1,f,0.13080770333361982\n,,3,1970-01-01T00:00:15Z,m,1,1,f,0.42098106260813917\n,,3,1970-01-01T00:00:16Z,m,1,1,f,0.6126625007965338\n,,3,1970-01-01T00:00:17Z,m,1,1,f,0.6566130686317417\n,,3,1970-01-01T00:00:18Z,m,1,1,f,0.8724405943016941\n,,3,1970-01-01T00:00:19Z,m,1,1,f,0.5240118690102152\n,,3,1970-01-01T00:00:20Z,m,1,1,f,0.16295208705669978\n,,3,1970-01-01T00:00:21Z,m,1,1,f,0.3087465430934554\n,,3,1970-01-01T00:00:22Z,m,1,1,f,0.5285274343484349\n,,3,1970-01-01T00:00:23Z,m,1,1,f,0.634731960510953\n,,3,1970-01-01T00:00:24Z,m,1,1,f,0.21258839107347696\n,,3,1970-01-01T00:00:25Z,m,1,1,f,0.418565981182859\n,,3,1970-01-01T00:00:26Z,m,1,1,f,0.2537565365571897\n,,3,1970-01-01T00:00:27Z,m,1,1,f,0.5464331287426728\n,,3,1970-01-01T00:00:28Z,m,1,1,f,0.9960454475764904\n,,3,1970-01-01T00:00:29Z,m,1,1,f,0.09275146190386824\n,,3,1970-01-01T00:00:30Z,m,1,1,f,0.6976442897720185\n,,3,1970-01-01T00:00:31Z,m,1,1,f,0.74713521249196\n,,3,1970-01-01T00:00:32Z,m,1,1,f,0.984508958500529\n,,3,1970-01-01T00:00:33Z,m,1,1,f,0.735978145078593\n,,3,1970-01-01T00:00:34Z,m,1,1,f,0.03272325327489153\n,,3,1970-01-01T00:00:35Z,m,1,1,f,0.2789090231376286\n,,3,1970-01-01T00:00:36Z,m,1,1,f,0.9009986444969635\n,,3,1970-01-01T00:00:37Z,m,1,1,f,0.848311973911401\n,,3,1970-01-01T00:00:38Z,m,1,1,f,0.3433130690616337\n,,3,1970-01-01T00:00:39Z,m,1,1,f,0.9705860405696857\n,,3,1970-01-01T00:00:40Z,m,1,1,f,0.4971554061394775\n,,3,1970-01-01T00:00:41Z,m,1,1,f,0.5010737989466268\n,,3,1970-01-01T00:00:42Z,m,1,1,f,0.6786336325659156\n,,3,1970-01-01T00:00:43Z,m,1,1,f,0.45685893681365386\n,,3,1970-01-01T00:00:44Z,m,1,1,f,0.06785712875301617\n,,3,1970-01-01T00:00:45Z,m,1,1,f,0.3686928354464234\n,,3,1970-01-01T00:00:46Z,m,1,1,f,0.16238519747752908\n,,3,1970-01-01T00:00:47Z,m,1,1,f,0.09616346590744834\n,,3,1970-01-01T00:00:48Z,m,1,1,f,0.982361090570932\n,,3,1970-01-01T00:00:49Z,m,1,1,f,0.24546880258756468\n,,3,1970-01-01T00:00:50Z,m,1,1,f,0.4063470659819713\n,,3,1970-01-01T00:00:51Z,m,1,1,f,0.02333966735385356\n,,3,1970-01-01T00:00:52Z,m,1,1,f,0.7485740576779872\n,,3,1970-01-01T00:00:53Z,m,1,1,f,0.6166837184691856\n,,3,1970-01-01T00:00:54Z,m,1,1,f,0.05978509722242629\n,,3,1970-01-01T00:00:55Z,m,1,1,f,0.8745680789623674\n,,3,1970-01-01T00:00:56Z,m,1,1,f,0.7043364028176561\n,,3,1970-01-01T00:00:57Z,m,1,1,f,0.5100762819992395\n,,3,1970-01-01T00:00:58Z,m,1,1,f,0.16311060736490562\n,,3,1970-01-01T00:00:59Z,m,1,1,f,0.8629619678924975\n,,3,1970-01-01T00:01:00Z,m,1,1,f,0.10822795841933747\n,,3,1970-01-01T00:01:01Z,m,1,1,f,0.009391242035550616\n,,3,1970-01-01T00:01:02Z,m,1,1,f,0.8963338627277064\n,,3,1970-01-01T00:01:03Z,m,1,1,f,0.2741500937920746\n,,3,1970-01-01T00:01:04Z,m,1,1,f,0.8919325188107933\n,,3,1970-01-01T00:01:05Z,m,1,1,f,0.6654225234319311\n,,3,1970-01-01T00:01:06Z,m,1,1,f,0.02781722451099708\n,,3,1970-01-01T00:01:07Z,m,1,1,f,0.1620103430803485\n,,3,1970-01-01T00:01:08Z,m,1,1,f,0.4825820756588489\n,,3,1970-01-01T00:01:09Z,m,1,1,f,0.6564731088934671\n,,3,1970-01-01T00:01:10Z,m,1,1,f,0.5500077260845426\n,,3,1970-01-01T00:01:11Z,m,1,1,f,0.40462752766482185\n,,3,1970-01-01T00:01:12Z,m,1,1,f,0.8674131498299248\n,,3,1970-01-01T00:01:13Z,m,1,1,f,0.8902851603994412\n,,3,1970-01-01T00:01:14Z,m,1,1,f,0.1599747356552478\n,,3,1970-01-01T00:01:15Z,m,1,1,f,0.4023835778260672\n,,3,1970-01-01T00:01:16Z,m,1,1,f,0.8892986579330658\n,,3,1970-01-01T00:01:17Z,m,1,1,f,0.05870852811550652\n,,3,1970-01-01T00:01:18Z,m,1,1,f,0.08810359195444939\n,,3,1970-01-01T00:01:19Z,m,1,1,f,0.5799459169235229\n,,3,1970-01-01T00:01:20Z,m,1,1,f,0.675990461828967\n,,3,1970-01-01T00:01:21Z,m,1,1,f,0.680028234810394\n,,3,1970-01-01T00:01:22Z,m,1,1,f,0.3828707005637953\n,,3,1970-01-01T00:01:23Z,m,1,1,f,0.369157111114499\n,,3,1970-01-01T00:01:24Z,m,1,1,f,0.12328872455169967\n,,3,1970-01-01T00:01:25Z,m,1,1,f,0.43126638642422993\n,,3,1970-01-01T00:01:26Z,m,1,1,f,0.24418662053793608\n,,3,1970-01-01T00:01:27Z,m,1,1,f,0.22094836458502065\n,,3,1970-01-01T00:01:28Z,m,1,1,f,0.10278220106833619\n,,3,1970-01-01T00:01:29Z,m,1,1,f,0.7194160988953583\n,,3,1970-01-01T00:01:30Z,m,1,1,f,0.9646344422230495\n,,3,1970-01-01T00:01:31Z,m,1,1,f,0.462370535565091\n,,3,1970-01-01T00:01:32Z,m,1,1,f,0.9386791098643801\n,,3,1970-01-01T00:01:33Z,m,1,1,f,0.03801280884674329\n,,3,1970-01-01T00:01:34Z,m,1,1,f,0.35603844514090255\n,,3,1970-01-01T00:01:35Z,m,1,1,f,0.5083881660913203\n,,3,1970-01-01T00:01:36Z,m,1,1,f,0.4326239900843389\n,,3,1970-01-01T00:01:37Z,m,1,1,f,0.09453891565081506\n,,3,1970-01-01T00:01:38Z,m,1,1,f,0.023503857583366802\n,,3,1970-01-01T00:01:39Z,m,1,1,f,0.9492834672803911\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,max\n,,0,1970-01-01T00:01:28Z,m,0.9967833661484294\n\"\n\n// SELECT max(f) FROM m\nt_selector = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> max()\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"max\"})\n\ntest _selector = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_selector,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   411,
					},
					File:   "selector_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,0,,,,,,,\n,result,table,_time,_measurement,t0,t1,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,0,f,0.21546887461084024\n,,0,1970-01-01T00:00:01Z,m,0,0,f,0.9576896132790585\n,,0,1970-01-01T00:00:02Z,m,0,0,f,0.294953913000311\n,,0,1970-01-01T00:00:03Z,m,0,0,f,0.4651741324883778\n,,0,1970-01-01T00:00:04Z,m,0,0,f,0.9873388815871567\n,,0,1970-01-01T00:00:05Z,m,0,0,f,0.3845474109517986\n,,0,1970-01-01T00:00:06Z,m,0,0,f,0.2922442980858412\n,,0,1970-01-01T00:00:07Z,m,0,0,f,0.03298588199059829\n,,0,1970-01-01T00:00:08Z,m,0,0,f,0.969396406468683\n,,0,1970-01-01T00:00:09Z,m,0,0,f,0.8126386582005671\n,,0,1970-01-01T00:00:10Z,m,0,0,f,0.875468209815408\n,,0,1970-01-01T00:00:11Z,m,0,0,f,0.43242435584494165\n,,0,1970-01-01T00:00:12Z,m,0,0,f,0.43936224189298456\n,,0,1970-01-01T00:00:13Z,m,0,0,f,0.1224409595139043\n,,0,1970-01-01T00:00:14Z,m,0,0,f,0.15733684152804783\n,,0,1970-01-01T00:00:15Z,m,0,0,f,0.08882282140312904\n,,0,1970-01-01T00:00:16Z,m,0,0,f,0.23989257176325227\n,,0,1970-01-01T00:00:17Z,m,0,0,f,0.6955232509082638\n,,0,1970-01-01T00:00:18Z,m,0,0,f,0.43554475339119303\n,,0,1970-01-01T00:00:19Z,m,0,0,f,0.3051713218684253\n,,0,1970-01-01T00:00:20Z,m,0,0,f,0.7413025816537797\n,,0,1970-01-01T00:00:21Z,m,0,0,f,0.24567297998270615\n,,0,1970-01-01T00:00:22Z,m,0,0,f,0.491391504478891\n,,0,1970-01-01T00:00:23Z,m,0,0,f,0.13872180750181634\n,,0,1970-01-01T00:00:24Z,m,0,0,f,0.06729135892978601\n,,0,1970-01-01T00:00:25Z,m,0,0,f,0.2711347220286289\n,,0,1970-01-01T00:00:26Z,m,0,0,f,0.5465962906385142\n,,0,1970-01-01T00:00:27Z,m,0,0,f,0.1721498986023557\n,,0,1970-01-01T00:00:28Z,m,0,0,f,0.928541805026285\n,,0,1970-01-01T00:00:29Z,m,0,0,f,0.4390512841392946\n,,0,1970-01-01T00:00:30Z,m,0,0,f,0.7891509564074856\n,,0,1970-01-01T00:00:31Z,m,0,0,f,0.03752404112396554\n,,0,1970-01-01T00:00:32Z,m,0,0,f,0.8731292945164265\n,,0,1970-01-01T00:00:33Z,m,0,0,f,0.6590129312109282\n,,0,1970-01-01T00:00:34Z,m,0,0,f,0.7298034951937612\n,,0,1970-01-01T00:00:35Z,m,0,0,f,0.6880331199538888\n,,0,1970-01-01T00:00:36Z,m,0,0,f,0.7884092917020722\n,,0,1970-01-01T00:00:37Z,m,0,0,f,0.9071621838398441\n,,0,1970-01-01T00:00:38Z,m,0,0,f,0.5029003668295414\n,,0,1970-01-01T00:00:39Z,m,0,0,f,0.5545818527629861\n,,0,1970-01-01T00:00:40Z,m,0,0,f,0.763728196635538\n,,0,1970-01-01T00:00:41Z,m,0,0,f,0.5870046094520823\n,,0,1970-01-01T00:00:42Z,m,0,0,f,0.7675553560334312\n,,0,1970-01-01T00:00:43Z,m,0,0,f,0.8279726730049255\n,,0,1970-01-01T00:00:44Z,m,0,0,f,0.7013474149025897\n,,0,1970-01-01T00:00:45Z,m,0,0,f,0.08556981440432106\n,,0,1970-01-01T00:00:46Z,m,0,0,f,0.8520957093766447\n,,0,1970-01-01T00:00:47Z,m,0,0,f,0.41873957390346783\n,,0,1970-01-01T00:00:48Z,m,0,0,f,0.04405459160245573\n,,0,1970-01-01T00:00:49Z,m,0,0,f,0.8184927094237151\n,,0,1970-01-01T00:00:50Z,m,0,0,f,0.0975526753791771\n,,0,1970-01-01T00:00:51Z,m,0,0,f,0.4984015942759995\n,,0,1970-01-01T00:00:52Z,m,0,0,f,0.24094630162586889\n,,0,1970-01-01T00:00:53Z,m,0,0,f,0.1461722759564162\n,,0,1970-01-01T00:00:54Z,m,0,0,f,0.0008451156568219057\n,,0,1970-01-01T00:00:55Z,m,0,0,f,0.4633414547017063\n,,0,1970-01-01T00:00:56Z,m,0,0,f,0.4539668492775038\n,,0,1970-01-01T00:00:57Z,m,0,0,f,0.4868916379116324\n,,0,1970-01-01T00:00:58Z,m,0,0,f,0.9566203795860617\n,,0,1970-01-01T00:00:59Z,m,0,0,f,0.9599106283927733\n,,0,1970-01-01T00:01:00Z,m,0,0,f,0.7293729603954808\n,,0,1970-01-01T00:01:01Z,m,0,0,f,0.6455698152977222\n,,0,1970-01-01T00:01:02Z,m,0,0,f,0.11441321827059112\n,,0,1970-01-01T00:01:03Z,m,0,0,f,0.9955326395256039\n,,0,1970-01-01T00:01:04Z,m,0,0,f,0.44266439346958053\n,,0,1970-01-01T00:01:05Z,m,0,0,f,0.7183012898949253\n,,0,1970-01-01T00:01:06Z,m,0,0,f,0.30706108459030473\n,,0,1970-01-01T00:01:07Z,m,0,0,f,0.5034183578538529\n,,0,1970-01-01T00:01:08Z,m,0,0,f,0.945541035399725\n,,0,1970-01-01T00:01:09Z,m,0,0,f,0.4233995128157775\n,,0,1970-01-01T00:01:10Z,m,0,0,f,0.7647066005216012\n,,0,1970-01-01T00:01:11Z,m,0,0,f,0.4427721542156412\n,,0,1970-01-01T00:01:12Z,m,0,0,f,0.5759588898144714\n,,0,1970-01-01T00:01:13Z,m,0,0,f,0.4891738037219912\n,,0,1970-01-01T00:01:14Z,m,0,0,f,0.3162573404966396\n,,0,1970-01-01T00:01:15Z,m,0,0,f,0.12429098278245032\n,,0,1970-01-01T00:01:16Z,m,0,0,f,0.5500314687416078\n,,0,1970-01-01T00:01:17Z,m,0,0,f,0.07874290942037632\n,,0,1970-01-01T00:01:18Z,m,0,0,f,0.2432131181375912\n,,0,1970-01-01T00:01:19Z,m,0,0,f,0.2059157686630176\n,,0,1970-01-01T00:01:20Z,m,0,0,f,0.44865547217512164\n,,0,1970-01-01T00:01:21Z,m,0,0,f,0.7168101661064027\n,,0,1970-01-01T00:01:22Z,m,0,0,f,0.36652553198536764\n,,0,1970-01-01T00:01:23Z,m,0,0,f,0.12875338574773973\n,,0,1970-01-01T00:01:24Z,m,0,0,f,0.14050907817041347\n,,0,1970-01-01T00:01:25Z,m,0,0,f,0.4095172637990756\n,,0,1970-01-01T00:01:26Z,m,0,0,f,0.2460700738777719\n,,0,1970-01-01T00:01:27Z,m,0,0,f,0.7823912602040078\n,,0,1970-01-01T00:01:28Z,m,0,0,f,0.707534534477093\n,,0,1970-01-01T00:01:29Z,m,0,0,f,0.6714337668672199\n,,0,1970-01-01T00:01:30Z,m,0,0,f,0.6443730852735031\n,,0,1970-01-01T00:01:31Z,m,0,0,f,0.8349467641212396\n,,0,1970-01-01T00:01:32Z,m,0,0,f,0.7443365385220384\n,,0,1970-01-01T00:01:33Z,m,0,0,f,0.778092873581952\n,,0,1970-01-01T00:01:34Z,m,0,0,f,0.21451835990529106\n,,0,1970-01-01T00:01:35Z,m,0,0,f,0.15132579382756906\n,,0,1970-01-01T00:01:36Z,m,0,0,f,0.889690688725347\n,,0,1970-01-01T00:01:37Z,m,0,0,f,0.08177608166572663\n,,0,1970-01-01T00:01:38Z,m,0,0,f,0.6156947898336163\n,,0,1970-01-01T00:01:39Z,m,0,0,f,0.8839098227070676\n,,1,1970-01-01T00:00:00Z,m,0,1,f,0.47284307199688513\n,,1,1970-01-01T00:00:01Z,m,0,1,f,0.6115110431660992\n,,1,1970-01-01T00:00:02Z,m,0,1,f,0.9139676390179812\n,,1,1970-01-01T00:00:03Z,m,0,1,f,0.4419580502994864\n,,1,1970-01-01T00:00:04Z,m,0,1,f,0.22346720477114235\n,,1,1970-01-01T00:00:05Z,m,0,1,f,0.01657253263970824\n,,1,1970-01-01T00:00:06Z,m,0,1,f,0.5275526538985256\n,,1,1970-01-01T00:00:07Z,m,0,1,f,0.2801453905589357\n,,1,1970-01-01T00:00:08Z,m,0,1,f,0.40358058571546174\n,,1,1970-01-01T00:00:09Z,m,0,1,f,0.5581225312763497\n,,1,1970-01-01T00:00:10Z,m,0,1,f,0.5618381020173508\n,,1,1970-01-01T00:00:11Z,m,0,1,f,0.08048303365885615\n,,1,1970-01-01T00:00:12Z,m,0,1,f,0.5001751201461243\n,,1,1970-01-01T00:00:13Z,m,0,1,f,0.22639175489524663\n,,1,1970-01-01T00:00:14Z,m,0,1,f,0.26537476142069744\n,,1,1970-01-01T00:00:15Z,m,0,1,f,0.8045352065828273\n,,1,1970-01-01T00:00:16Z,m,0,1,f,0.401634967963577\n,,1,1970-01-01T00:00:17Z,m,0,1,f,0.9411501472896155\n,,1,1970-01-01T00:00:18Z,m,0,1,f,0.2930734491556474\n,,1,1970-01-01T00:00:19Z,m,0,1,f,0.18157543568371715\n,,1,1970-01-01T00:00:20Z,m,0,1,f,0.9385325130161203\n,,1,1970-01-01T00:00:21Z,m,0,1,f,0.17010332650185725\n,,1,1970-01-01T00:00:22Z,m,0,1,f,0.04213339793024455\n,,1,1970-01-01T00:00:23Z,m,0,1,f,0.5626619227163632\n,,1,1970-01-01T00:00:24Z,m,0,1,f,0.6941739177125473\n,,1,1970-01-01T00:00:25Z,m,0,1,f,0.5438842736369963\n,,1,1970-01-01T00:00:26Z,m,0,1,f,0.6524346931171858\n,,1,1970-01-01T00:00:27Z,m,0,1,f,0.062106354006262784\n,,1,1970-01-01T00:00:28Z,m,0,1,f,0.6808062354975885\n,,1,1970-01-01T00:00:29Z,m,0,1,f,0.4566938577876695\n,,1,1970-01-01T00:00:30Z,m,0,1,f,0.15426646385258916\n,,1,1970-01-01T00:00:31Z,m,0,1,f,0.7378414694167669\n,,1,1970-01-01T00:00:32Z,m,0,1,f,0.35905015546070745\n,,1,1970-01-01T00:00:33Z,m,0,1,f,0.25717348995611955\n,,1,1970-01-01T00:00:34Z,m,0,1,f,0.8669066045043076\n,,1,1970-01-01T00:00:35Z,m,0,1,f,0.7414665987538746\n,,1,1970-01-01T00:00:36Z,m,0,1,f,0.7580463272135385\n,,1,1970-01-01T00:00:37Z,m,0,1,f,0.223202540983848\n,,1,1970-01-01T00:00:38Z,m,0,1,f,0.09675623584194015\n,,1,1970-01-01T00:00:39Z,m,0,1,f,0.33037602371875235\n,,1,1970-01-01T00:00:40Z,m,0,1,f,0.02419699334564844\n,,1,1970-01-01T00:00:41Z,m,0,1,f,0.30660540046813134\n,,1,1970-01-01T00:00:42Z,m,0,1,f,0.28087743747358407\n,,1,1970-01-01T00:00:43Z,m,0,1,f,0.8125957553254125\n,,1,1970-01-01T00:00:44Z,m,0,1,f,0.3996499465775914\n,,1,1970-01-01T00:00:45Z,m,0,1,f,0.002859922694346698\n,,1,1970-01-01T00:00:46Z,m,0,1,f,0.7743871384683348\n,,1,1970-01-01T00:00:47Z,m,0,1,f,0.3428194666142575\n,,1,1970-01-01T00:00:48Z,m,0,1,f,0.24529106535786452\n,,1,1970-01-01T00:00:49Z,m,0,1,f,0.42074581063787847\n,,1,1970-01-01T00:00:50Z,m,0,1,f,0.8230512029974123\n,,1,1970-01-01T00:00:51Z,m,0,1,f,0.7612451595826552\n,,1,1970-01-01T00:00:52Z,m,0,1,f,0.0025044233308020394\n,,1,1970-01-01T00:00:53Z,m,0,1,f,0.8123608833291784\n,,1,1970-01-01T00:00:54Z,m,0,1,f,0.094280039506472\n,,1,1970-01-01T00:00:55Z,m,0,1,f,0.7414773533860608\n,,1,1970-01-01T00:00:56Z,m,0,1,f,0.048248944868655844\n,,1,1970-01-01T00:00:57Z,m,0,1,f,0.7876232215876143\n,,1,1970-01-01T00:00:58Z,m,0,1,f,0.7708955207540708\n,,1,1970-01-01T00:00:59Z,m,0,1,f,0.3210082428062905\n,,1,1970-01-01T00:01:00Z,m,0,1,f,0.6199485490487467\n,,1,1970-01-01T00:01:01Z,m,0,1,f,0.4526111772487005\n,,1,1970-01-01T00:01:02Z,m,0,1,f,0.06993036738408297\n,,1,1970-01-01T00:01:03Z,m,0,1,f,0.5391803940621971\n,,1,1970-01-01T00:01:04Z,m,0,1,f,0.3786026404218388\n,,1,1970-01-01T00:01:05Z,m,0,1,f,0.16987447951514412\n,,1,1970-01-01T00:01:06Z,m,0,1,f,0.9622624203254517\n,,1,1970-01-01T00:01:07Z,m,0,1,f,0.10609876802280566\n,,1,1970-01-01T00:01:08Z,m,0,1,f,0.34039196604520483\n,,1,1970-01-01T00:01:09Z,m,0,1,f,0.326997943237989\n,,1,1970-01-01T00:01:10Z,m,0,1,f,0.40582069426239586\n,,1,1970-01-01T00:01:11Z,m,0,1,f,0.09664389869310906\n,,1,1970-01-01T00:01:12Z,m,0,1,f,0.0874716642419619\n,,1,1970-01-01T00:01:13Z,m,0,1,f,0.9574787428982809\n,,1,1970-01-01T00:01:14Z,m,0,1,f,0.792171281216902\n,,1,1970-01-01T00:01:15Z,m,0,1,f,0.8154053514727819\n,,1,1970-01-01T00:01:16Z,m,0,1,f,0.9446634309508735\n,,1,1970-01-01T00:01:17Z,m,0,1,f,0.7914039734656017\n,,1,1970-01-01T00:01:18Z,m,0,1,f,0.5642005948380394\n,,1,1970-01-01T00:01:19Z,m,0,1,f,0.9394901508564378\n,,1,1970-01-01T00:01:20Z,m,0,1,f,0.09420964672484634\n,,1,1970-01-01T00:01:21Z,m,0,1,f,0.8997154088951347\n,,1,1970-01-01T00:01:22Z,m,0,1,f,0.8929163087698091\n,,1,1970-01-01T00:01:23Z,m,0,1,f,0.14602512562046865\n,,1,1970-01-01T00:01:24Z,m,0,1,f,0.061755078411980135\n,,1,1970-01-01T00:01:25Z,m,0,1,f,0.050027231315704974\n,,1,1970-01-01T00:01:26Z,m,0,1,f,0.06579399435541186\n,,1,1970-01-01T00:01:27Z,m,0,1,f,0.5485533330294929\n,,1,1970-01-01T00:01:28Z,m,0,1,f,0.08600793471366114\n,,1,1970-01-01T00:01:29Z,m,0,1,f,0.0048224932897884395\n,,1,1970-01-01T00:01:30Z,m,0,1,f,0.031000679866955753\n,,1,1970-01-01T00:01:31Z,m,0,1,f,0.7590758510991269\n,,1,1970-01-01T00:01:32Z,m,0,1,f,0.28752964131696107\n,,1,1970-01-01T00:01:33Z,m,0,1,f,0.0803113942730073\n,,1,1970-01-01T00:01:34Z,m,0,1,f,0.7653660195907919\n,,1,1970-01-01T00:01:35Z,m,0,1,f,0.169201547040183\n,,1,1970-01-01T00:01:36Z,m,0,1,f,0.2812417370494343\n,,1,1970-01-01T00:01:37Z,m,0,1,f,0.5556525309491438\n,,1,1970-01-01T00:01:38Z,m,0,1,f,0.21336394958285926\n,,1,1970-01-01T00:01:39Z,m,0,1,f,0.843202199200085\n,,2,1970-01-01T00:00:00Z,m,1,0,f,0.6745411981120504\n,,2,1970-01-01T00:00:01Z,m,1,0,f,0.4341136360856983\n,,2,1970-01-01T00:00:02Z,m,1,0,f,0.0779873994184798\n,,2,1970-01-01T00:00:03Z,m,1,0,f,0.6045688060594187\n,,2,1970-01-01T00:00:04Z,m,1,0,f,0.609806908577383\n,,2,1970-01-01T00:00:05Z,m,1,0,f,0.2371373109677929\n,,2,1970-01-01T00:00:06Z,m,1,0,f,0.15959047192822226\n,,2,1970-01-01T00:00:07Z,m,1,0,f,0.7696930667476671\n,,2,1970-01-01T00:00:08Z,m,1,0,f,0.44489788239949923\n,,2,1970-01-01T00:00:09Z,m,1,0,f,0.20113730484499945\n,,2,1970-01-01T00:00:10Z,m,1,0,f,0.9004310672214374\n,,2,1970-01-01T00:00:11Z,m,1,0,f,0.08071979045152104\n,,2,1970-01-01T00:00:12Z,m,1,0,f,0.35878401311181407\n,,2,1970-01-01T00:00:13Z,m,1,0,f,0.8046013839899406\n,,2,1970-01-01T00:00:14Z,m,1,0,f,0.09869242829873062\n,,2,1970-01-01T00:00:15Z,m,1,0,f,0.27053244466215826\n,,2,1970-01-01T00:00:16Z,m,1,0,f,0.6672055373259661\n,,2,1970-01-01T00:00:17Z,m,1,0,f,0.9015798497859395\n,,2,1970-01-01T00:00:18Z,m,1,0,f,0.6514438661906353\n,,2,1970-01-01T00:00:19Z,m,1,0,f,0.03319201114385362\n,,2,1970-01-01T00:00:20Z,m,1,0,f,0.44109087427118215\n,,2,1970-01-01T00:00:21Z,m,1,0,f,0.1441063884747634\n,,2,1970-01-01T00:00:22Z,m,1,0,f,0.23335939084421864\n,,2,1970-01-01T00:00:23Z,m,1,0,f,0.6904277645853616\n,,2,1970-01-01T00:00:24Z,m,1,0,f,0.5145930899531316\n,,2,1970-01-01T00:00:25Z,m,1,0,f,0.4299752694354613\n,,2,1970-01-01T00:00:26Z,m,1,0,f,0.9207494524068397\n,,2,1970-01-01T00:00:27Z,m,1,0,f,0.4990764483657634\n,,2,1970-01-01T00:00:28Z,m,1,0,f,0.7370053493218158\n,,2,1970-01-01T00:00:29Z,m,1,0,f,0.8159190359865772\n,,2,1970-01-01T00:00:30Z,m,1,0,f,0.5730300999100897\n,,2,1970-01-01T00:00:31Z,m,1,0,f,0.4957548727598841\n,,2,1970-01-01T00:00:32Z,m,1,0,f,0.4475722509767004\n,,2,1970-01-01T00:00:33Z,m,1,0,f,0.09000105562869058\n,,2,1970-01-01T00:00:34Z,m,1,0,f,0.5765896961954948\n,,2,1970-01-01T00:00:35Z,m,1,0,f,0.007292186311595296\n,,2,1970-01-01T00:00:36Z,m,1,0,f,0.6862338192326899\n,,2,1970-01-01T00:00:37Z,m,1,0,f,0.6323091325867545\n,,2,1970-01-01T00:00:38Z,m,1,0,f,0.22250144688828086\n,,2,1970-01-01T00:00:39Z,m,1,0,f,0.7767158293696542\n,,2,1970-01-01T00:00:40Z,m,1,0,f,0.5040765046136644\n,,2,1970-01-01T00:00:41Z,m,1,0,f,0.7198824794590694\n,,2,1970-01-01T00:00:42Z,m,1,0,f,0.16487220863546403\n,,2,1970-01-01T00:00:43Z,m,1,0,f,0.6185190195253291\n,,2,1970-01-01T00:00:44Z,m,1,0,f,0.417935209198883\n,,2,1970-01-01T00:00:45Z,m,1,0,f,0.143322367253724\n,,2,1970-01-01T00:00:46Z,m,1,0,f,0.7110860020844423\n,,2,1970-01-01T00:00:47Z,m,1,0,f,0.5190433935276061\n,,2,1970-01-01T00:00:48Z,m,1,0,f,0.5947710020498977\n,,2,1970-01-01T00:00:49Z,m,1,0,f,0.18632874860445664\n,,2,1970-01-01T00:00:50Z,m,1,0,f,0.050671657609869296\n,,2,1970-01-01T00:00:51Z,m,1,0,f,0.336667976831678\n,,2,1970-01-01T00:00:52Z,m,1,0,f,0.16893598340949662\n,,2,1970-01-01T00:00:53Z,m,1,0,f,0.6319794509787114\n,,2,1970-01-01T00:00:54Z,m,1,0,f,0.3434433122927547\n,,2,1970-01-01T00:00:55Z,m,1,0,f,0.13766344408813833\n,,2,1970-01-01T00:00:56Z,m,1,0,f,0.7028890267599247\n,,2,1970-01-01T00:00:57Z,m,1,0,f,0.5893915586856076\n,,2,1970-01-01T00:00:58Z,m,1,0,f,0.08495375348679511\n,,2,1970-01-01T00:00:59Z,m,1,0,f,0.5635570663754376\n,,2,1970-01-01T00:01:00Z,m,1,0,f,0.06973804413592974\n,,2,1970-01-01T00:01:01Z,m,1,0,f,0.4594087627832006\n,,2,1970-01-01T00:01:02Z,m,1,0,f,0.9484143072574632\n,,2,1970-01-01T00:01:03Z,m,1,0,f,0.7210862651644585\n,,2,1970-01-01T00:01:04Z,m,1,0,f,0.4306492881221061\n,,2,1970-01-01T00:01:05Z,m,1,0,f,0.9768511587696722\n,,2,1970-01-01T00:01:06Z,m,1,0,f,0.036770411149115535\n,,2,1970-01-01T00:01:07Z,m,1,0,f,0.199704171721732\n,,2,1970-01-01T00:01:08Z,m,1,0,f,0.044989678879272736\n,,2,1970-01-01T00:01:09Z,m,1,0,f,0.4204918747032285\n,,2,1970-01-01T00:01:10Z,m,1,0,f,0.7660528673315015\n,,2,1970-01-01T00:01:11Z,m,1,0,f,0.07495082447510862\n,,2,1970-01-01T00:01:12Z,m,1,0,f,0.979672949703\n,,2,1970-01-01T00:01:13Z,m,1,0,f,0.43531431314587743\n,,2,1970-01-01T00:01:14Z,m,1,0,f,0.16473009865933294\n,,2,1970-01-01T00:01:15Z,m,1,0,f,0.9714924938553514\n,,2,1970-01-01T00:01:16Z,m,1,0,f,0.8548205740914873\n,,2,1970-01-01T00:01:17Z,m,1,0,f,0.988621458104506\n,,2,1970-01-01T00:01:18Z,m,1,0,f,0.42316749552422783\n,,2,1970-01-01T00:01:19Z,m,1,0,f,0.5599137447927957\n,,2,1970-01-01T00:01:20Z,m,1,0,f,0.7513515954882367\n,,2,1970-01-01T00:01:21Z,m,1,0,f,0.07681127373236643\n,,2,1970-01-01T00:01:22Z,m,1,0,f,0.04219934813632237\n,,2,1970-01-01T00:01:23Z,m,1,0,f,0.27672511415229256\n,,2,1970-01-01T00:01:24Z,m,1,0,f,0.6618414211834359\n,,2,1970-01-01T00:01:25Z,m,1,0,f,0.04819580958061359\n,,2,1970-01-01T00:01:26Z,m,1,0,f,0.8514613397306017\n,,2,1970-01-01T00:01:27Z,m,1,0,f,0.654705748814002\n,,2,1970-01-01T00:01:28Z,m,1,0,f,0.9967833661484294\n,,2,1970-01-01T00:01:29Z,m,1,0,f,0.9631421129969118\n,,2,1970-01-01T00:01:30Z,m,1,0,f,0.6286421005881492\n,,2,1970-01-01T00:01:31Z,m,1,0,f,0.3783501632738452\n,,2,1970-01-01T00:01:32Z,m,1,0,f,0.05114898778086843\n,,2,1970-01-01T00:01:33Z,m,1,0,f,0.2473880323048304\n,,2,1970-01-01T00:01:34Z,m,1,0,f,0.7842674808782694\n,,2,1970-01-01T00:01:35Z,m,1,0,f,0.6130952139646441\n,,2,1970-01-01T00:01:36Z,m,1,0,f,0.9762618521418323\n,,2,1970-01-01T00:01:37Z,m,1,0,f,0.9219480325346383\n,,2,1970-01-01T00:01:38Z,m,1,0,f,0.7986205925631757\n,,2,1970-01-01T00:01:39Z,m,1,0,f,0.578541588985068\n,,3,1970-01-01T00:00:00Z,m,1,1,f,0.3609497652786835\n,,3,1970-01-01T00:00:01Z,m,1,1,f,0.6431495269328852\n,,3,1970-01-01T00:00:02Z,m,1,1,f,0.30119517109360755\n,,3,1970-01-01T00:00:03Z,m,1,1,f,0.029905756669452933\n,,3,1970-01-01T00:00:04Z,m,1,1,f,0.32578997668820153\n,,3,1970-01-01T00:00:05Z,m,1,1,f,0.7482046757377168\n,,3,1970-01-01T00:00:06Z,m,1,1,f,0.42006674019623874\n,,3,1970-01-01T00:00:07Z,m,1,1,f,0.8892383923700209\n,,3,1970-01-01T00:00:08Z,m,1,1,f,0.2734890146915862\n,,3,1970-01-01T00:00:09Z,m,1,1,f,0.2126705472958595\n,,3,1970-01-01T00:00:10Z,m,1,1,f,0.4081541720871348\n,,3,1970-01-01T00:00:11Z,m,1,1,f,0.7517886726430452\n,,3,1970-01-01T00:00:12Z,m,1,1,f,0.6344255763748975\n,,3,1970-01-01T00:00:13Z,m,1,1,f,0.13439033950657941\n,,3,1970-01-01T00:00:14Z,m,1,1,f,0.13080770333361982\n,,3,1970-01-01T00:00:15Z,m,1,1,f,0.42098106260813917\n,,3,1970-01-01T00:00:16Z,m,1,1,f,0.6126625007965338\n,,3,1970-01-01T00:00:17Z,m,1,1,f,0.6566130686317417\n,,3,1970-01-01T00:00:18Z,m,1,1,f,0.8724405943016941\n,,3,1970-01-01T00:00:19Z,m,1,1,f,0.5240118690102152\n,,3,1970-01-01T00:00:20Z,m,1,1,f,0.16295208705669978\n,,3,1970-01-01T00:00:21Z,m,1,1,f,0.3087465430934554\n,,3,1970-01-01T00:00:22Z,m,1,1,f,0.5285274343484349\n,,3,1970-01-01T00:00:23Z,m,1,1,f,0.634731960510953\n,,3,1970-01-01T00:00:24Z,m,1,1,f,0.21258839107347696\n,,3,1970-01-01T00:00:25Z,m,1,1,f,0.418565981182859\n,,3,1970-01-01T00:00:26Z,m,1,1,f,0.2537565365571897\n,,3,1970-01-01T00:00:27Z,m,1,1,f,0.5464331287426728\n,,3,1970-01-01T00:00:28Z,m,1,1,f,0.9960454475764904\n,,3,1970-01-01T00:00:29Z,m,1,1,f,0.09275146190386824\n,,3,1970-01-01T00:00:30Z,m,1,1,f,0.6976442897720185\n,,3,1970-01-01T00:00:31Z,m,1,1,f,0.74713521249196\n,,3,1970-01-01T00:00:32Z,m,1,1,f,0.984508958500529\n,,3,1970-01-01T00:00:33Z,m,1,1,f,0.735978145078593\n,,3,1970-01-01T00:00:34Z,m,1,1,f,0.03272325327489153\n,,3,1970-01-01T00:00:35Z,m,1,1,f,0.2789090231376286\n,,3,1970-01-01T00:00:36Z,m,1,1,f,0.9009986444969635\n,,3,1970-01-01T00:00:37Z,m,1,1,f,0.848311973911401\n,,3,1970-01-01T00:00:38Z,m,1,1,f,0.3433130690616337\n,,3,1970-01-01T00:00:39Z,m,1,1,f,0.9705860405696857\n,,3,1970-01-01T00:00:40Z,m,1,1,f,0.4971554061394775\n,,3,1970-01-01T00:00:41Z,m,1,1,f,0.5010737989466268\n,,3,1970-01-01T00:00:42Z,m,1,1,f,0.6786336325659156\n,,3,1970-01-01T00:00:43Z,m,1,1,f,0.45685893681365386\n,,3,1970-01-01T00:00:44Z,m,1,1,f,0.06785712875301617\n,,3,1970-01-01T00:00:45Z,m,1,1,f,0.3686928354464234\n,,3,1970-01-01T00:00:46Z,m,1,1,f,0.16238519747752908\n,,3,1970-01-01T00:00:47Z,m,1,1,f,0.09616346590744834\n,,3,1970-01-01T00:00:48Z,m,1,1,f,0.982361090570932\n,,3,1970-01-01T00:00:49Z,m,1,1,f,0.24546880258756468\n,,3,1970-01-01T00:00:50Z,m,1,1,f,0.4063470659819713\n,,3,1970-01-01T00:00:51Z,m,1,1,f,0.02333966735385356\n,,3,1970-01-01T00:00:52Z,m,1,1,f,0.7485740576779872\n,,3,1970-01-01T00:00:53Z,m,1,1,f,0.6166837184691856\n,,3,1970-01-01T00:00:54Z,m,1,1,f,0.05978509722242629\n,,3,1970-01-01T00:00:55Z,m,1,1,f,0.8745680789623674\n,,3,1970-01-01T00:00:56Z,m,1,1,f,0.7043364028176561\n,,3,1970-01-01T00:00:57Z,m,1,1,f,0.5100762819992395\n,,3,1970-01-01T00:00:58Z,m,1,1,f,0.16311060736490562\n,,3,1970-01-01T00:00:59Z,m,1,1,f,0.8629619678924975\n,,3,1970-01-01T00:01:00Z,m,1,1,f,0.10822795841933747\n,,3,1970-01-01T00:01:01Z,m,1,1,f,0.009391242035550616\n,,3,1970-01-01T00:01:02Z,m,1,1,f,0.8963338627277064\n,,3,1970-01-01T00:01:03Z,m,1,1,f,0.2741500937920746\n,,3,1970-01-01T00:01:04Z,m,1,1,f,0.8919325188107933\n,,3,1970-01-01T00:01:05Z,m,1,1,f,0.6654225234319311\n,,3,1970-01-01T00:01:06Z,m,1,1,f,0.02781722451099708\n,,3,1970-01-01T00:01:07Z,m,1,1,f,0.1620103430803485\n,,3,1970-01-01T00:01:08Z,m,1,1,f,0.4825820756588489\n,,3,1970-01-01T00:01:09Z,m,1,1,f,0.6564731088934671\n,,3,1970-01-01T00:01:10Z,m,1,1,f,0.5500077260845426\n,,3,1970-01-01T00:01:11Z,m,1,1,f,0.40462752766482185\n,,3,1970-01-01T00:01:12Z,m,1,1,f,0.8674131498299248\n,,3,1970-01-01T00:01:13Z,m,1,1,f,0.8902851603994412\n,,3,1970-01-01T00:01:14Z,m,1,1,f,0.1599747356552478\n,,3,1970-01-01T00:01:15Z,m,1,1,f,0.4023835778260672\n,,3,1970-01-01T00:01:16Z,m,1,1,f,0.8892986579330658\n,,3,1970-01-01T00:01:17Z,m,1,1,f,0.05870852811550652\n,,3,1970-01-01T00:01:18Z,m,1,1,f,0.08810359195444939\n,,3,1970-01-01T00:01:19Z,m,1,1,f,0.5799459169235229\n,,3,1970-01-01T00:01:20Z,m,1,1,f,0.675990461828967\n,,3,1970-01-01T00:01:21Z,m,1,1,f,0.680028234810394\n,,3,1970-01-01T00:01:22Z,m,1,1,f,0.3828707005637953\n,,3,1970-01-01T00:01:23Z,m,1,1,f,0.369157111114499\n,,3,1970-01-01T00:01:24Z,m,1,1,f,0.12328872455169967\n,,3,1970-01-01T00:01:25Z,m,1,1,f,0.43126638642422993\n,,3,1970-01-01T00:01:26Z,m,1,1,f,0.24418662053793608\n,,3,1970-01-01T00:01:27Z,m,1,1,f,0.22094836458502065\n,,3,1970-01-01T00:01:28Z,m,1,1,f,0.10278220106833619\n,,3,1970-01-01T00:01:29Z,m,1,1,f,0.7194160988953583\n,,3,1970-01-01T00:01:30Z,m,1,1,f,0.9646344422230495\n,,3,1970-01-01T00:01:31Z,m,1,1,f,0.462370535565091\n,,3,1970-01-01T00:01:32Z,m,1,1,f,0.9386791098643801\n,,3,1970-01-01T00:01:33Z,m,1,1,f,0.03801280884674329\n,,3,1970-01-01T00:01:34Z,m,1,1,f,0.35603844514090255\n,,3,1970-01-01T00:01:35Z,m,1,1,f,0.5083881660913203\n,,3,1970-01-01T00:01:36Z,m,1,1,f,0.4326239900843389\n,,3,1970-01-01T00:01:37Z,m,1,1,f,0.09453891565081506\n,,3,1970-01-01T00:01:38Z,m,1,1,f,0.023503857583366802\n,,3,1970-01-01T00:01:39Z,m,1,1,f,0.9492834672803911\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "selector_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   411,
						},
						File:   "selector_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,0,,,,,,,\n,result,table,_time,_measurement,t0,t1,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,0,f,0.21546887461084024\n,,0,1970-01-01T00:00:01Z,m,0,0,f,0.9576896132790585\n,,0,1970-01-01T00:00:02Z,m,0,0,f,0.294953913000311\n,,0,1970-01-01T00:00:03Z,m,0,0,f,0.4651741324883778\n,,0,1970-01-01T00:00:04Z,m,0,0,f,0.9873388815871567\n,,0,1970-01-01T00:00:05Z,m,0,0,f,0.3845474109517986\n,,0,1970-01-01T00:00:06Z,m,0,0,f,0.2922442980858412\n,,0,1970-01-01T00:00:07Z,m,0,0,f,0.03298588199059829\n,,0,1970-01-01T00:00:08Z,m,0,0,f,0.969396406468683\n,,0,1970-01-01T00:00:09Z,m,0,0,f,0.8126386582005671\n,,0,1970-01-01T00:00:10Z,m,0,0,f,0.875468209815408\n,,0,1970-01-01T00:00:11Z,m,0,0,f,0.43242435584494165\n,,0,1970-01-01T00:00:12Z,m,0,0,f,0.43936224189298456\n,,0,1970-01-01T00:00:13Z,m,0,0,f,0.1224409595139043\n,,0,1970-01-01T00:00:14Z,m,0,0,f,0.15733684152804783\n,,0,1970-01-01T00:00:15Z,m,0,0,f,0.08882282140312904\n,,0,1970-01-01T00:00:16Z,m,0,0,f,0.23989257176325227\n,,0,1970-01-01T00:00:17Z,m,0,0,f,0.6955232509082638\n,,0,1970-01-01T00:00:18Z,m,0,0,f,0.43554475339119303\n,,0,1970-01-01T00:00:19Z,m,0,0,f,0.3051713218684253\n,,0,1970-01-01T00:00:20Z,m,0,0,f,0.7413025816537797\n,,0,1970-01-01T00:00:21Z,m,0,0,f,0.24567297998270615\n,,0,1970-01-01T00:00:22Z,m,0,0,f,0.491391504478891\n,,0,1970-01-01T00:00:23Z,m,0,0,f,0.13872180750181634\n,,0,1970-01-01T00:00:24Z,m,0,0,f,0.06729135892978601\n,,0,1970-01-01T00:00:25Z,m,0,0,f,0.2711347220286289\n,,0,1970-01-01T00:00:26Z,m,0,0,f,0.5465962906385142\n,,0,1970-01-01T00:00:27Z,m,0,0,f,0.1721498986023557\n,,0,1970-01-01T00:00:28Z,m,0,0,f,0.928541805026285\n,,0,1970-01-01T00:00:29Z,m,0,0,f,0.4390512841392946\n,,0,1970-01-01T00:00:30Z,m,0,0,f,0.7891509564074856\n,,0,1970-01-01T00:00:31Z,m,0,0,f,0.03752404112396554\n,,0,1970-01-01T00:00:32Z,m,0,0,f,0.8731292945164265\n,,0,1970-01-01T00:00:33Z,m,0,0,f,0.6590129312109282\n,,0,1970-01-01T00:00:34Z,m,0,0,f,0.7298034951937612\n,,0,1970-01-01T00:00:35Z,m,0,0,f,0.6880331199538888\n,,0,1970-01-01T00:00:36Z,m,0,0,f,0.7884092917020722\n,,0,1970-01-01T00:00:37Z,m,0,0,f,0.9071621838398441\n,,0,1970-01-01T00:00:38Z,m,0,0,f,0.5029003668295414\n,,0,1970-01-01T00:00:39Z,m,0,0,f,0.5545818527629861\n,,0,1970-01-01T00:00:40Z,m,0,0,f,0.763728196635538\n,,0,1970-01-01T00:00:41Z,m,0,0,f,0.5870046094520823\n,,0,1970-01-01T00:00:42Z,m,0,0,f,0.7675553560334312\n,,0,1970-01-01T00:00:43Z,m,0,0,f,0.8279726730049255\n,,0,1970-01-01T00:00:44Z,m,0,0,f,0.7013474149025897\n,,0,1970-01-01T00:00:45Z,m,0,0,f,0.08556981440432106\n,,0,1970-01-01T00:00:46Z,m,0,0,f,0.8520957093766447\n,,0,1970-01-01T00:00:47Z,m,0,0,f,0.41873957390346783\n,,0,1970-01-01T00:00:48Z,m,0,0,f,0.04405459160245573\n,,0,1970-01-01T00:00:49Z,m,0,0,f,0.8184927094237151\n,,0,1970-01-01T00:00:50Z,m,0,0,f,0.0975526753791771\n,,0,1970-01-01T00:00:51Z,m,0,0,f,0.4984015942759995\n,,0,1970-01-01T00:00:52Z,m,0,0,f,0.24094630162586889\n,,0,1970-01-01T00:00:53Z,m,0,0,f,0.1461722759564162\n,,0,1970-01-01T00:00:54Z,m,0,0,f,0.0008451156568219057\n,,0,1970-01-01T00:00:55Z,m,0,0,f,0.4633414547017063\n,,0,1970-01-01T00:00:56Z,m,0,0,f,0.4539668492775038\n,,0,1970-01-01T00:00:57Z,m,0,0,f,0.4868916379116324\n,,0,1970-01-01T00:00:58Z,m,0,0,f,0.9566203795860617\n,,0,1970-01-01T00:00:59Z,m,0,0,f,0.9599106283927733\n,,0,1970-01-01T00:01:00Z,m,0,0,f,0.7293729603954808\n,,0,1970-01-01T00:01:01Z,m,0,0,f,0.6455698152977222\n,,0,1970-01-01T00:01:02Z,m,0,0,f,0.11441321827059112\n,,0,1970-01-01T00:01:03Z,m,0,0,f,0.9955326395256039\n,,0,1970-01-01T00:01:04Z,m,0,0,f,0.44266439346958053\n,,0,1970-01-01T00:01:05Z,m,0,0,f,0.7183012898949253\n,,0,1970-01-01T00:01:06Z,m,0,0,f,0.30706108459030473\n,,0,1970-01-01T00:01:07Z,m,0,0,f,0.5034183578538529\n,,0,1970-01-01T00:01:08Z,m,0,0,f,0.945541035399725\n,,0,1970-01-01T00:01:09Z,m,0,0,f,0.4233995128157775\n,,0,1970-01-01T00:01:10Z,m,0,0,f,0.7647066005216012\n,,0,1970-01-01T00:01:11Z,m,0,0,f,0.4427721542156412\n,,0,1970-01-01T00:01:12Z,m,0,0,f,0.5759588898144714\n,,0,1970-01-01T00:01:13Z,m,0,0,f,0.4891738037219912\n,,0,1970-01-01T00:01:14Z,m,0,0,f,0.3162573404966396\n,,0,1970-01-01T00:01:15Z,m,0,0,f,0.12429098278245032\n,,0,1970-01-01T00:01:16Z,m,0,0,f,0.5500314687416078\n,,0,1970-01-01T00:01:17Z,m,0,0,f,0.07874290942037632\n,,0,1970-01-01T00:01:18Z,m,0,0,f,0.2432131181375912\n,,0,1970-01-01T00:01:19Z,m,0,0,f,0.2059157686630176\n,,0,1970-01-01T00:01:20Z,m,0,0,f,0.44865547217512164\n,,0,1970-01-01T00:01:21Z,m,0,0,f,0.7168101661064027\n,,0,1970-01-01T00:01:22Z,m,0,0,f,0.36652553198536764\n,,0,1970-01-01T00:01:23Z,m,0,0,f,0.12875338574773973\n,,0,1970-01-01T00:01:24Z,m,0,0,f,0.14050907817041347\n,,0,1970-01-01T00:01:25Z,m,0,0,f,0.4095172637990756\n,,0,1970-01-01T00:01:26Z,m,0,0,f,0.2460700738777719\n,,0,1970-01-01T00:01:27Z,m,0,0,f,0.7823912602040078\n,,0,1970-01-01T00:01:28Z,m,0,0,f,0.707534534477093\n,,0,1970-01-01T00:01:29Z,m,0,0,f,0.6714337668672199\n,,0,1970-01-01T00:01:30Z,m,0,0,f,0.6443730852735031\n,,0,1970-01-01T00:01:31Z,m,0,0,f,0.8349467641212396\n,,0,1970-01-01T00:01:32Z,m,0,0,f,0.7443365385220384\n,,0,1970-01-01T00:01:33Z,m,0,0,f,0.778092873581952\n,,0,1970-01-01T00:01:34Z,m,0,0,f,0.21451835990529106\n,,0,1970-01-01T00:01:35Z,m,0,0,f,0.15132579382756906\n,,0,1970-01-01T00:01:36Z,m,0,0,f,0.889690688725347\n,,0,1970-01-01T00:01:37Z,m,0,0,f,0.08177608166572663\n,,0,1970-01-01T00:01:38Z,m,0,0,f,0.6156947898336163\n,,0,1970-01-01T00:01:39Z,m,0,0,f,0.8839098227070676\n,,1,1970-01-01T00:00:00Z,m,0,1,f,0.47284307199688513\n,,1,1970-01-01T00:00:01Z,m,0,1,f,0.6115110431660992\n,,1,1970-01-01T00:00:02Z,m,0,1,f,0.9139676390179812\n,,1,1970-01-01T00:00:03Z,m,0,1,f,0.4419580502994864\n,,1,1970-01-01T00:00:04Z,m,0,1,f,0.22346720477114235\n,,1,1970-01-01T00:00:05Z,m,0,1,f,0.01657253263970824\n,,1,1970-01-01T00:00:06Z,m,0,1,f,0.5275526538985256\n,,1,1970-01-01T00:00:07Z,m,0,1,f,0.2801453905589357\n,,1,1970-01-01T00:00:08Z,m,0,1,f,0.40358058571546174\n,,1,1970-01-01T00:00:09Z,m,0,1,f,0.5581225312763497\n,,1,1970-01-01T00:00:10Z,m,0,1,f,0.5618381020173508\n,,1,1970-01-01T00:00:11Z,m,0,1,f,0.08048303365885615\n,,1,1970-01-01T00:00:12Z,m,0,1,f,0.5001751201461243\n,,1,1970-01-01T00:00:13Z,m,0,1,f,0.22639175489524663\n,,1,1970-01-01T00:00:14Z,m,0,1,f,0.26537476142069744\n,,1,1970-01-01T00:00:15Z,m,0,1,f,0.8045352065828273\n,,1,1970-01-01T00:00:16Z,m,0,1,f,0.401634967963577\n,,1,1970-01-01T00:00:17Z,m,0,1,f,0.9411501472896155\n,,1,1970-01-01T00:00:18Z,m,0,1,f,0.2930734491556474\n,,1,1970-01-01T00:00:19Z,m,0,1,f,0.18157543568371715\n,,1,1970-01-01T00:00:20Z,m,0,1,f,0.9385325130161203\n,,1,1970-01-01T00:00:21Z,m,0,1,f,0.17010332650185725\n,,1,1970-01-01T00:00:22Z,m,0,1,f,0.04213339793024455\n,,1,1970-01-01T00:00:23Z,m,0,1,f,0.5626619227163632\n,,1,1970-01-01T00:00:24Z,m,0,1,f,0.6941739177125473\n,,1,1970-01-01T00:00:25Z,m,0,1,f,0.5438842736369963\n,,1,1970-01-01T00:00:26Z,m,0,1,f,0.6524346931171858\n,,1,1970-01-01T00:00:27Z,m,0,1,f,0.062106354006262784\n,,1,1970-01-01T00:00:28Z,m,0,1,f,0.6808062354975885\n,,1,1970-01-01T00:00:29Z,m,0,1,f,0.4566938577876695\n,,1,1970-01-01T00:00:30Z,m,0,1,f,0.15426646385258916\n,,1,1970-01-01T00:00:31Z,m,0,1,f,0.7378414694167669\n,,1,1970-01-01T00:00:32Z,m,0,1,f,0.35905015546070745\n,,1,1970-01-01T00:00:33Z,m,0,1,f,0.25717348995611955\n,,1,1970-01-01T00:00:34Z,m,0,1,f,0.8669066045043076\n,,1,1970-01-01T00:00:35Z,m,0,1,f,0.7414665987538746\n,,1,1970-01-01T00:00:36Z,m,0,1,f,0.7580463272135385\n,,1,1970-01-01T00:00:37Z,m,0,1,f,0.223202540983848\n,,1,1970-01-01T00:00:38Z,m,0,1,f,0.09675623584194015\n,,1,1970-01-01T00:00:39Z,m,0,1,f,0.33037602371875235\n,,1,1970-01-01T00:00:40Z,m,0,1,f,0.02419699334564844\n,,1,1970-01-01T00:00:41Z,m,0,1,f,0.30660540046813134\n,,1,1970-01-01T00:00:42Z,m,0,1,f,0.28087743747358407\n,,1,1970-01-01T00:00:43Z,m,0,1,f,0.8125957553254125\n,,1,1970-01-01T00:00:44Z,m,0,1,f,0.3996499465775914\n,,1,1970-01-01T00:00:45Z,m,0,1,f,0.002859922694346698\n,,1,1970-01-01T00:00:46Z,m,0,1,f,0.7743871384683348\n,,1,1970-01-01T00:00:47Z,m,0,1,f,0.3428194666142575\n,,1,1970-01-01T00:00:48Z,m,0,1,f,0.24529106535786452\n,,1,1970-01-01T00:00:49Z,m,0,1,f,0.42074581063787847\n,,1,1970-01-01T00:00:50Z,m,0,1,f,0.8230512029974123\n,,1,1970-01-01T00:00:51Z,m,0,1,f,0.7612451595826552\n,,1,1970-01-01T00:00:52Z,m,0,1,f,0.0025044233308020394\n,,1,1970-01-01T00:00:53Z,m,0,1,f,0.8123608833291784\n,,1,1970-01-01T00:00:54Z,m,0,1,f,0.094280039506472\n,,1,1970-01-01T00:00:55Z,m,0,1,f,0.7414773533860608\n,,1,1970-01-01T00:00:56Z,m,0,1,f,0.048248944868655844\n,,1,1970-01-01T00:00:57Z,m,0,1,f,0.7876232215876143\n,,1,1970-01-01T00:00:58Z,m,0,1,f,0.7708955207540708\n,,1,1970-01-01T00:00:59Z,m,0,1,f,0.3210082428062905\n,,1,1970-01-01T00:01:00Z,m,0,1,f,0.6199485490487467\n,,1,1970-01-01T00:01:01Z,m,0,1,f,0.4526111772487005\n,,1,1970-01-01T00:01:02Z,m,0,1,f,0.06993036738408297\n,,1,1970-01-01T00:01:03Z,m,0,1,f,0.5391803940621971\n,,1,1970-01-01T00:01:04Z,m,0,1,f,0.3786026404218388\n,,1,1970-01-01T00:01:05Z,m,0,1,f,0.16987447951514412\n,,1,1970-01-01T00:01:06Z,m,0,1,f,0.9622624203254517\n,,1,1970-01-01T00:01:07Z,m,0,1,f,0.10609876802280566\n,,1,1970-01-01T00:01:08Z,m,0,1,f,0.34039196604520483\n,,1,1970-01-01T00:01:09Z,m,0,1,f,0.326997943237989\n,,1,1970-01-01T00:01:10Z,m,0,1,f,0.40582069426239586\n,,1,1970-01-01T00:01:11Z,m,0,1,f,0.09664389869310906\n,,1,1970-01-01T00:01:12Z,m,0,1,f,0.0874716642419619\n,,1,1970-01-01T00:01:13Z,m,0,1,f,0.9574787428982809\n,,1,1970-01-01T00:01:14Z,m,0,1,f,0.792171281216902\n,,1,1970-01-01T00:01:15Z,m,0,1,f,0.8154053514727819\n,,1,1970-01-01T00:01:16Z,m,0,1,f,0.9446634309508735\n,,1,1970-01-01T00:01:17Z,m,0,1,f,0.7914039734656017\n,,1,1970-01-01T00:01:18Z,m,0,1,f,0.5642005948380394\n,,1,1970-01-01T00:01:19Z,m,0,1,f,0.9394901508564378\n,,1,1970-01-01T00:01:20Z,m,0,1,f,0.09420964672484634\n,,1,1970-01-01T00:01:21Z,m,0,1,f,0.8997154088951347\n,,1,1970-01-01T00:01:22Z,m,0,1,f,0.8929163087698091\n,,1,1970-01-01T00:01:23Z,m,0,1,f,0.14602512562046865\n,,1,1970-01-01T00:01:24Z,m,0,1,f,0.061755078411980135\n,,1,1970-01-01T00:01:25Z,m,0,1,f,0.050027231315704974\n,,1,1970-01-01T00:01:26Z,m,0,1,f,0.06579399435541186\n,,1,1970-01-01T00:01:27Z,m,0,1,f,0.5485533330294929\n,,1,1970-01-01T00:01:28Z,m,0,1,f,0.08600793471366114\n,,1,1970-01-01T00:01:29Z,m,0,1,f,0.0048224932897884395\n,,1,1970-01-01T00:01:30Z,m,0,1,f,0.031000679866955753\n,,1,1970-01-01T00:01:31Z,m,0,1,f,0.7590758510991269\n,,1,1970-01-01T00:01:32Z,m,0,1,f,0.28752964131696107\n,,1,1970-01-01T00:01:33Z,m,0,1,f,0.0803113942730073\n,,1,1970-01-01T00:01:34Z,m,0,1,f,0.7653660195907919\n,,1,1970-01-01T00:01:35Z,m,0,1,f,0.169201547040183\n,,1,1970-01-01T00:01:36Z,m,0,1,f,0.2812417370494343\n,,1,1970-01-01T00:01:37Z,m,0,1,f,0.5556525309491438\n,,1,1970-01-01T00:01:38Z,m,0,1,f,0.21336394958285926\n,,1,1970-01-01T00:01:39Z,m,0,1,f,0.843202199200085\n,,2,1970-01-01T00:00:00Z,m,1,0,f,0.6745411981120504\n,,2,1970-01-01T00:00:01Z,m,1,0,f,0.4341136360856983\n,,2,1970-01-01T00:00:02Z,m,1,0,f,0.0779873994184798\n,,2,1970-01-01T00:00:03Z,m,1,0,f,0.6045688060594187\n,,2,1970-01-01T00:00:04Z,m,1,0,f,0.609806908577383\n,,2,1970-01-01T00:00:05Z,m,1,0,f,0.2371373109677929\n,,2,1970-01-01T00:00:06Z,m,1,0,f,0.15959047192822226\n,,2,1970-01-01T00:00:07Z,m,1,0,f,0.7696930667476671\n,,2,1970-01-01T00:00:08Z,m,1,0,f,0.44489788239949923\n,,2,1970-01-01T00:00:09Z,m,1,0,f,0.20113730484499945\n,,2,1970-01-01T00:00:10Z,m,1,0,f,0.9004310672214374\n,,2,1970-01-01T00:00:11Z,m,1,0,f,0.08071979045152104\n,,2,1970-01-01T00:00:12Z,m,1,0,f,0.35878401311181407\n,,2,1970-01-01T00:00:13Z,m,1,0,f,0.8046013839899406\n,,2,1970-01-01T00:00:14Z,m,1,0,f,0.09869242829873062\n,,2,1970-01-01T00:00:15Z,m,1,0,f,0.27053244466215826\n,,2,1970-01-01T00:00:16Z,m,1,0,f,0.6672055373259661\n,,2,1970-01-01T00:00:17Z,m,1,0,f,0.9015798497859395\n,,2,1970-01-01T00:00:18Z,m,1,0,f,0.6514438661906353\n,,2,1970-01-01T00:00:19Z,m,1,0,f,0.03319201114385362\n,,2,1970-01-01T00:00:20Z,m,1,0,f,0.44109087427118215\n,,2,1970-01-01T00:00:21Z,m,1,0,f,0.1441063884747634\n,,2,1970-01-01T00:00:22Z,m,1,0,f,0.23335939084421864\n,,2,1970-01-01T00:00:23Z,m,1,0,f,0.6904277645853616\n,,2,1970-01-01T00:00:24Z,m,1,0,f,0.5145930899531316\n,,2,1970-01-01T00:00:25Z,m,1,0,f,0.4299752694354613\n,,2,1970-01-01T00:00:26Z,m,1,0,f,0.9207494524068397\n,,2,1970-01-01T00:00:27Z,m,1,0,f,0.4990764483657634\n,,2,1970-01-01T00:00:28Z,m,1,0,f,0.7370053493218158\n,,2,1970-01-01T00:00:29Z,m,1,0,f,0.8159190359865772\n,,2,1970-01-01T00:00:30Z,m,1,0,f,0.5730300999100897\n,,2,1970-01-01T00:00:31Z,m,1,0,f,0.4957548727598841\n,,2,1970-01-01T00:00:32Z,m,1,0,f,0.4475722509767004\n,,2,1970-01-01T00:00:33Z,m,1,0,f,0.09000105562869058\n,,2,1970-01-01T00:00:34Z,m,1,0,f,0.5765896961954948\n,,2,1970-01-01T00:00:35Z,m,1,0,f,0.007292186311595296\n,,2,1970-01-01T00:00:36Z,m,1,0,f,0.6862338192326899\n,,2,1970-01-01T00:00:37Z,m,1,0,f,0.6323091325867545\n,,2,1970-01-01T00:00:38Z,m,1,0,f,0.22250144688828086\n,,2,1970-01-01T00:00:39Z,m,1,0,f,0.7767158293696542\n,,2,1970-01-01T00:00:40Z,m,1,0,f,0.5040765046136644\n,,2,1970-01-01T00:00:41Z,m,1,0,f,0.7198824794590694\n,,2,1970-01-01T00:00:42Z,m,1,0,f,0.16487220863546403\n,,2,1970-01-01T00:00:43Z,m,1,0,f,0.6185190195253291\n,,2,1970-01-01T00:00:44Z,m,1,0,f,0.417935209198883\n,,2,1970-01-01T00:00:45Z,m,1,0,f,0.143322367253724\n,,2,1970-01-01T00:00:46Z,m,1,0,f,0.7110860020844423\n,,2,1970-01-01T00:00:47Z,m,1,0,f,0.5190433935276061\n,,2,1970-01-01T00:00:48Z,m,1,0,f,0.5947710020498977\n,,2,1970-01-01T00:00:49Z,m,1,0,f,0.18632874860445664\n,,2,1970-01-01T00:00:50Z,m,1,0,f,0.050671657609869296\n,,2,1970-01-01T00:00:51Z,m,1,0,f,0.336667976831678\n,,2,1970-01-01T00:00:52Z,m,1,0,f,0.16893598340949662\n,,2,1970-01-01T00:00:53Z,m,1,0,f,0.6319794509787114\n,,2,1970-01-01T00:00:54Z,m,1,0,f,0.3434433122927547\n,,2,1970-01-01T00:00:55Z,m,1,0,f,0.13766344408813833\n,,2,1970-01-01T00:00:56Z,m,1,0,f,0.7028890267599247\n,,2,1970-01-01T00:00:57Z,m,1,0,f,0.5893915586856076\n,,2,1970-01-01T00:00:58Z,m,1,0,f,0.08495375348679511\n,,2,1970-01-01T00:00:59Z,m,1,0,f,0.5635570663754376\n,,2,1970-01-01T00:01:00Z,m,1,0,f,0.06973804413592974\n,,2,1970-01-01T00:01:01Z,m,1,0,f,0.4594087627832006\n,,2,1970-01-01T00:01:02Z,m,1,0,f,0.9484143072574632\n,,2,1970-01-01T00:01:03Z,m,1,0,f,0.7210862651644585\n,,2,1970-01-01T00:01:04Z,m,1,0,f,0.4306492881221061\n,,2,1970-01-01T00:01:05Z,m,1,0,f,0.9768511587696722\n,,2,1970-01-01T00:01:06Z,m,1,0,f,0.036770411149115535\n,,2,1970-01-01T00:01:07Z,m,1,0,f,0.199704171721732\n,,2,1970-01-01T00:01:08Z,m,1,0,f,0.044989678879272736\n,,2,1970-01-01T00:01:09Z,m,1,0,f,0.4204918747032285\n,,2,1970-01-01T00:01:10Z,m,1,0,f,0.7660528673315015\n,,2,1970-01-01T00:01:11Z,m,1,0,f,0.07495082447510862\n,,2,1970-01-01T00:01:12Z,m,1,0,f,0.979672949703\n,,2,1970-01-01T00:01:13Z,m,1,0,f,0.43531431314587743\n,,2,1970-01-01T00:01:14Z,m,1,0,f,0.16473009865933294\n,,2,1970-01-01T00:01:15Z,m,1,0,f,0.9714924938553514\n,,2,1970-01-01T00:01:16Z,m,1,0,f,0.8548205740914873\n,,2,1970-01-01T00:01:17Z,m,1,0,f,0.988621458104506\n,,2,1970-01-01T00:01:18Z,m,1,0,f,0.42316749552422783\n,,2,1970-01-01T00:01:19Z,m,1,0,f,0.5599137447927957\n,,2,1970-01-01T00:01:20Z,m,1,0,f,0.7513515954882367\n,,2,1970-01-01T00:01:21Z,m,1,0,f,0.07681127373236643\n,,2,1970-01-01T00:01:22Z,m,1,0,f,0.04219934813632237\n,,2,1970-01-01T00:01:23Z,m,1,0,f,0.27672511415229256\n,,2,1970-01-01T00:01:24Z,m,1,0,f,0.6618414211834359\n,,2,1970-01-01T00:01:25Z,m,1,0,f,0.04819580958061359\n,,2,1970-01-01T00:01:26Z,m,1,0,f,0.8514613397306017\n,,2,1970-01-01T00:01:27Z,m,1,0,f,0.654705748814002\n,,2,1970-01-01T00:01:28Z,m,1,0,f,0.9967833661484294\n,,2,1970-01-01T00:01:29Z,m,1,0,f,0.9631421129969118\n,,2,1970-01-01T00:01:30Z,m,1,0,f,0.6286421005881492\n,,2,1970-01-01T00:01:31Z,m,1,0,f,0.3783501632738452\n,,2,1970-01-01T00:01:32Z,m,1,0,f,0.05114898778086843\n,,2,1970-01-01T00:01:33Z,m,1,0,f,0.2473880323048304\n,,2,1970-01-01T00:01:34Z,m,1,0,f,0.7842674808782694\n,,2,1970-01-01T00:01:35Z,m,1,0,f,0.6130952139646441\n,,2,1970-01-01T00:01:36Z,m,1,0,f,0.9762618521418323\n,,2,1970-01-01T00:01:37Z,m,1,0,f,0.9219480325346383\n,,2,1970-01-01T00:01:38Z,m,1,0,f,0.7986205925631757\n,,2,1970-01-01T00:01:39Z,m,1,0,f,0.578541588985068\n,,3,1970-01-01T00:00:00Z,m,1,1,f,0.3609497652786835\n,,3,1970-01-01T00:00:01Z,m,1,1,f,0.6431495269328852\n,,3,1970-01-01T00:00:02Z,m,1,1,f,0.30119517109360755\n,,3,1970-01-01T00:00:03Z,m,1,1,f,0.029905756669452933\n,,3,1970-01-01T00:00:04Z,m,1,1,f,0.32578997668820153\n,,3,1970-01-01T00:00:05Z,m,1,1,f,0.7482046757377168\n,,3,1970-01-01T00:00:06Z,m,1,1,f,0.42006674019623874\n,,3,1970-01-01T00:00:07Z,m,1,1,f,0.8892383923700209\n,,3,1970-01-01T00:00:08Z,m,1,1,f,0.2734890146915862\n,,3,1970-01-01T00:00:09Z,m,1,1,f,0.2126705472958595\n,,3,1970-01-01T00:00:10Z,m,1,1,f,0.4081541720871348\n,,3,1970-01-01T00:00:11Z,m,1,1,f,0.7517886726430452\n,,3,1970-01-01T00:00:12Z,m,1,1,f,0.6344255763748975\n,,3,1970-01-01T00:00:13Z,m,1,1,f,0.13439033950657941\n,,3,1970-01-01T00:00:14Z,m,1,1,f,0.13080770333361982\n,,3,1970-01-01T00:00:15Z,m,1,1,f,0.42098106260813917\n,,3,1970-01-01T00:00:16Z,m,1,1,f,0.6126625007965338\n,,3,1970-01-01T00:00:17Z,m,1,1,f,0.6566130686317417\n,,3,1970-01-01T00:00:18Z,m,1,1,f,0.8724405943016941\n,,3,1970-01-01T00:00:19Z,m,1,1,f,0.5240118690102152\n,,3,1970-01-01T00:00:20Z,m,1,1,f,0.16295208705669978\n,,3,1970-01-01T00:00:21Z,m,1,1,f,0.3087465430934554\n,,3,1970-01-01T00:00:22Z,m,1,1,f,0.5285274343484349\n,,3,1970-01-01T00:00:23Z,m,1,1,f,0.634731960510953\n,,3,1970-01-01T00:00:24Z,m,1,1,f,0.21258839107347696\n,,3,1970-01-01T00:00:25Z,m,1,1,f,0.418565981182859\n,,3,1970-01-01T00:00:26Z,m,1,1,f,0.2537565365571897\n,,3,1970-01-01T00:00:27Z,m,1,1,f,0.5464331287426728\n,,3,1970-01-01T00:00:28Z,m,1,1,f,0.9960454475764904\n,,3,1970-01-01T00:00:29Z,m,1,1,f,0.09275146190386824\n,,3,1970-01-01T00:00:30Z,m,1,1,f,0.6976442897720185\n,,3,1970-01-01T00:00:31Z,m,1,1,f,0.74713521249196\n,,3,1970-01-01T00:00:32Z,m,1,1,f,0.984508958500529\n,,3,1970-01-01T00:00:33Z,m,1,1,f,0.735978145078593\n,,3,1970-01-01T00:00:34Z,m,1,1,f,0.03272325327489153\n,,3,1970-01-01T00:00:35Z,m,1,1,f,0.2789090231376286\n,,3,1970-01-01T00:00:36Z,m,1,1,f,0.9009986444969635\n,,3,1970-01-01T00:00:37Z,m,1,1,f,0.848311973911401\n,,3,1970-01-01T00:00:38Z,m,1,1,f,0.3433130690616337\n,,3,1970-01-01T00:00:39Z,m,1,1,f,0.9705860405696857\n,,3,1970-01-01T00:00:40Z,m,1,1,f,0.4971554061394775\n,,3,1970-01-01T00:00:41Z,m,1,1,f,0.5010737989466268\n,,3,1970-01-01T00:00:42Z,m,1,1,f,0.6786336325659156\n,,3,1970-01-01T00:00:43Z,m,1,1,f,0.45685893681365386\n,,3,1970-01-01T00:00:44Z,m,1,1,f,0.06785712875301617\n,,3,1970-01-01T00:00:45Z,m,1,1,f,0.3686928354464234\n,,3,1970-01-01T00:00:46Z,m,1,1,f,0.16238519747752908\n,,3,1970-01-01T00:00:47Z,m,1,1,f,0.09616346590744834\n,,3,1970-01-01T00:00:48Z,m,1,1,f,0.982361090570932\n,,3,1970-01-01T00:00:49Z,m,1,1,f,0.24546880258756468\n,,3,1970-01-01T00:00:50Z,m,1,1,f,0.4063470659819713\n,,3,1970-01-01T00:00:51Z,m,1,1,f,0.02333966735385356\n,,3,1970-01-01T00:00:52Z,m,1,1,f,0.7485740576779872\n,,3,1970-01-01T00:00:53Z,m,1,1,f,0.6166837184691856\n,,3,1970-01-01T00:00:54Z,m,1,1,f,0.05978509722242629\n,,3,1970-01-01T00:00:55Z,m,1,1,f,0.8745680789623674\n,,3,1970-01-01T00:00:56Z,m,1,1,f,0.7043364028176561\n,,3,1970-01-01T00:00:57Z,m,1,1,f,0.5100762819992395\n,,3,1970-01-01T00:00:58Z,m,1,1,f,0.16311060736490562\n,,3,1970-01-01T00:00:59Z,m,1,1,f,0.8629619678924975\n,,3,1970-01-01T00:01:00Z,m,1,1,f,0.10822795841933747\n,,3,1970-01-01T00:01:01Z,m,1,1,f,0.009391242035550616\n,,3,1970-01-01T00:01:02Z,m,1,1,f,0.8963338627277064\n,,3,1970-01-01T00:01:03Z,m,1,1,f,0.2741500937920746\n,,3,1970-01-01T00:01:04Z,m,1,1,f,0.8919325188107933\n,,3,1970-01-01T00:01:05Z,m,1,1,f,0.6654225234319311\n,,3,1970-01-01T00:01:06Z,m,1,1,f,0.02781722451099708\n,,3,1970-01-01T00:01:07Z,m,1,1,f,0.1620103430803485\n,,3,1970-01-01T00:01:08Z,m,1,1,f,0.4825820756588489\n,,3,1970-01-01T00:01:09Z,m,1,1,f,0.6564731088934671\n,,3,1970-01-01T00:01:10Z,m,1,1,f,0.5500077260845426\n,,3,1970-01-01T00:01:11Z,m,1,1,f,0.40462752766482185\n,,3,1970-01-01T00:01:12Z,m,1,1,f,0.8674131498299248\n,,3,1970-01-01T00:01:13Z,m,1,1,f,0.8902851603994412\n,,3,1970-01-01T00:01:14Z,m,1,1,f,0.1599747356552478\n,,3,1970-01-01T00:01:15Z,m,1,1,f,0.4023835778260672\n,,3,1970-01-01T00:01:16Z,m,1,1,f,0.8892986579330658\n,,3,1970-01-01T00:01:17Z,m,1,1,f,0.05870852811550652\n,,3,1970-01-01T00:01:18Z,m,1,1,f,0.08810359195444939\n,,3,1970-01-01T00:01:19Z,m,1,1,f,0.5799459169235229\n,,3,1970-01-01T00:01:20Z,m,1,1,f,0.675990461828967\n,,3,1970-01-01T00:01:21Z,m,1,1,f,0.680028234810394\n,,3,1970-01-01T00:01:22Z,m,1,1,f,0.3828707005637953\n,,3,1970-01-01T00:01:23Z,m,1,1,f,0.369157111114499\n,,3,1970-01-01T00:01:24Z,m,1,1,f,0.12328872455169967\n,,3,1970-01-01T00:01:25Z,m,1,1,f,0.43126638642422993\n,,3,1970-01-01T00:01:26Z,m,1,1,f,0.24418662053793608\n,,3,1970-01-01T00:01:27Z,m,1,1,f,0.22094836458502065\n,,3,1970-01-01T00:01:28Z,m,1,1,f,0.10278220106833619\n,,3,1970-01-01T00:01:29Z,m,1,1,f,0.7194160988953583\n,,3,1970-01-01T00:01:30Z,m,1,1,f,0.9646344422230495\n,,3,1970-01-01T00:01:31Z,m,1,1,f,0.462370535565091\n,,3,1970-01-01T00:01:32Z,m,1,1,f,0.9386791098643801\n,,3,1970-01-01T00:01:33Z,m,1,1,f,0.03801280884674329\n,,3,1970-01-01T00:01:34Z,m,1,1,f,0.35603844514090255\n,,3,1970-01-01T00:01:35Z,m,1,1,f,0.5083881660913203\n,,3,1970-01-01T00:01:36Z,m,1,1,f,0.4326239900843389\n,,3,1970-01-01T00:01:37Z,m,1,1,f,0.09453891565081506\n,,3,1970-01-01T00:01:38Z,m,1,1,f,0.023503857583366802\n,,3,1970-01-01T00:01:39Z,m,1,1,f,0.9492834672803911\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,0,,,,,,,\n,result,table,_time,_measurement,t0,t1,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,0,f,0.21546887461084024\n,,0,1970-01-01T00:00:01Z,m,0,0,f,0.9576896132790585\n,,0,1970-01-01T00:00:02Z,m,0,0,f,0.294953913000311\n,,0,1970-01-01T00:00:03Z,m,0,0,f,0.4651741324883778\n,,0,1970-01-01T00:00:04Z,m,0,0,f,0.9873388815871567\n,,0,1970-01-01T00:00:05Z,m,0,0,f,0.3845474109517986\n,,0,1970-01-01T00:00:06Z,m,0,0,f,0.2922442980858412\n,,0,1970-01-01T00:00:07Z,m,0,0,f,0.03298588199059829\n,,0,1970-01-01T00:00:08Z,m,0,0,f,0.969396406468683\n,,0,1970-01-01T00:00:09Z,m,0,0,f,0.8126386582005671\n,,0,1970-01-01T00:00:10Z,m,0,0,f,0.875468209815408\n,,0,1970-01-01T00:00:11Z,m,0,0,f,0.43242435584494165\n,,0,1970-01-01T00:00:12Z,m,0,0,f,0.43936224189298456\n,,0,1970-01-01T00:00:13Z,m,0,0,f,0.1224409595139043\n,,0,1970-01-01T00:00:14Z,m,0,0,f,0.15733684152804783\n,,0,1970-01-01T00:00:15Z,m,0,0,f,0.08882282140312904\n,,0,1970-01-01T00:00:16Z,m,0,0,f,0.23989257176325227\n,,0,1970-01-01T00:00:17Z,m,0,0,f,0.6955232509082638\n,,0,1970-01-01T00:00:18Z,m,0,0,f,0.43554475339119303\n,,0,1970-01-01T00:00:19Z,m,0,0,f,0.3051713218684253\n,,0,1970-01-01T00:00:20Z,m,0,0,f,0.7413025816537797\n,,0,1970-01-01T00:00:21Z,m,0,0,f,0.24567297998270615\n,,0,1970-01-01T00:00:22Z,m,0,0,f,0.491391504478891\n,,0,1970-01-01T00:00:23Z,m,0,0,f,0.13872180750181634\n,,0,1970-01-01T00:00:24Z,m,0,0,f,0.06729135892978601\n,,0,1970-01-01T00:00:25Z,m,0,0,f,0.2711347220286289\n,,0,1970-01-01T00:00:26Z,m,0,0,f,0.5465962906385142\n,,0,1970-01-01T00:00:27Z,m,0,0,f,0.1721498986023557\n,,0,1970-01-01T00:00:28Z,m,0,0,f,0.928541805026285\n,,0,1970-01-01T00:00:29Z,m,0,0,f,0.4390512841392946\n,,0,1970-01-01T00:00:30Z,m,0,0,f,0.7891509564074856\n,,0,1970-01-01T00:00:31Z,m,0,0,f,0.03752404112396554\n,,0,1970-01-01T00:00:32Z,m,0,0,f,0.8731292945164265\n,,0,1970-01-01T00:00:33Z,m,0,0,f,0.6590129312109282\n,,0,1970-01-01T00:00:34Z,m,0,0,f,0.7298034951937612\n,,0,1970-01-01T00:00:35Z,m,0,0,f,0.6880331199538888\n,,0,1970-01-01T00:00:36Z,m,0,0,f,0.7884092917020722\n,,0,1970-01-01T00:00:37Z,m,0,0,f,0.9071621838398441\n,,0,1970-01-01T00:00:38Z,m,0,0,f,0.5029003668295414\n,,0,1970-01-01T00:00:39Z,m,0,0,f,0.5545818527629861\n,,0,1970-01-01T00:00:40Z,m,0,0,f,0.763728196635538\n,,0,1970-01-01T00:00:41Z,m,0,0,f,0.5870046094520823\n,,0,1970-01-01T00:00:42Z,m,0,0,f,0.7675553560334312\n,,0,1970-01-01T00:00:43Z,m,0,0,f,0.8279726730049255\n,,0,1970-01-01T00:00:44Z,m,0,0,f,0.7013474149025897\n,,0,1970-01-01T00:00:45Z,m,0,0,f,0.08556981440432106\n,,0,1970-01-01T00:00:46Z,m,0,0,f,0.8520957093766447\n,,0,1970-01-01T00:00:47Z,m,0,0,f,0.41873957390346783\n,,0,1970-01-01T00:00:48Z,m,0,0,f,0.04405459160245573\n,,0,1970-01-01T00:00:49Z,m,0,0,f,0.8184927094237151\n,,0,1970-01-01T00:00:50Z,m,0,0,f,0.0975526753791771\n,,0,1970-01-01T00:00:51Z,m,0,0,f,0.4984015942759995\n,,0,1970-01-01T00:00:52Z,m,0,0,f,0.24094630162586889\n,,0,1970-01-01T00:00:53Z,m,0,0,f,0.1461722759564162\n,,0,1970-01-01T00:00:54Z,m,0,0,f,0.0008451156568219057\n,,0,1970-01-01T00:00:55Z,m,0,0,f,0.4633414547017063\n,,0,1970-01-01T00:00:56Z,m,0,0,f,0.4539668492775038\n,,0,1970-01-01T00:00:57Z,m,0,0,f,0.4868916379116324\n,,0,1970-01-01T00:00:58Z,m,0,0,f,0.9566203795860617\n,,0,1970-01-01T00:00:59Z,m,0,0,f,0.9599106283927733\n,,0,1970-01-01T00:01:00Z,m,0,0,f,0.7293729603954808\n,,0,1970-01-01T00:01:01Z,m,0,0,f,0.6455698152977222\n,,0,1970-01-01T00:01:02Z,m,0,0,f,0.11441321827059112\n,,0,1970-01-01T00:01:03Z,m,0,0,f,0.9955326395256039\n,,0,1970-01-01T00:01:04Z,m,0,0,f,0.44266439346958053\n,,0,1970-01-01T00:01:05Z,m,0,0,f,0.7183012898949253\n,,0,1970-01-01T00:01:06Z,m,0,0,f,0.30706108459030473\n,,0,1970-01-01T00:01:07Z,m,0,0,f,0.5034183578538529\n,,0,1970-01-01T00:01:08Z,m,0,0,f,0.945541035399725\n,,0,1970-01-01T00:01:09Z,m,0,0,f,0.4233995128157775\n,,0,1970-01-01T00:01:10Z,m,0,0,f,0.7647066005216012\n,,0,1970-01-01T00:01:11Z,m,0,0,f,0.4427721542156412\n,,0,1970-01-01T00:01:12Z,m,0,0,f,0.5759588898144714\n,,0,1970-01-01T00:01:13Z,m,0,0,f,0.4891738037219912\n,,0,1970-01-01T00:01:14Z,m,0,0,f,0.3162573404966396\n,,0,1970-01-01T00:01:15Z,m,0,0,f,0.12429098278245032\n,,0,1970-01-01T00:01:16Z,m,0,0,f,0.5500314687416078\n,,0,1970-01-01T00:01:17Z,m,0,0,f,0.07874290942037632\n,,0,1970-01-01T00:01:18Z,m,0,0,f,0.2432131181375912\n,,0,1970-01-01T00:01:19Z,m,0,0,f,0.2059157686630176\n,,0,1970-01-01T00:01:20Z,m,0,0,f,0.44865547217512164\n,,0,1970-01-01T00:01:21Z,m,0,0,f,0.7168101661064027\n,,0,1970-01-01T00:01:22Z,m,0,0,f,0.36652553198536764\n,,0,1970-01-01T00:01:23Z,m,0,0,f,0.12875338574773973\n,,0,1970-01-01T00:01:24Z,m,0,0,f,0.14050907817041347\n,,0,1970-01-01T00:01:25Z,m,0,0,f,0.4095172637990756\n,,0,1970-01-01T00:01:26Z,m,0,0,f,0.2460700738777719\n,,0,1970-01-01T00:01:27Z,m,0,0,f,0.7823912602040078\n,,0,1970-01-01T00:01:28Z,m,0,0,f,0.707534534477093\n,,0,1970-01-01T00:01:29Z,m,0,0,f,0.6714337668672199\n,,0,1970-01-01T00:01:30Z,m,0,0,f,0.6443730852735031\n,,0,1970-01-01T00:01:31Z,m,0,0,f,0.8349467641212396\n,,0,1970-01-01T00:01:32Z,m,0,0,f,0.7443365385220384\n,,0,1970-01-01T00:01:33Z,m,0,0,f,0.778092873581952\n,,0,1970-01-01T00:01:34Z,m,0,0,f,0.21451835990529106\n,,0,1970-01-01T00:01:35Z,m,0,0,f,0.15132579382756906\n,,0,1970-01-01T00:01:36Z,m,0,0,f,0.889690688725347\n,,0,1970-01-01T00:01:37Z,m,0,0,f,0.08177608166572663\n,,0,1970-01-01T00:01:38Z,m,0,0,f,0.6156947898336163\n,,0,1970-01-01T00:01:39Z,m,0,0,f,0.8839098227070676\n,,1,1970-01-01T00:00:00Z,m,0,1,f,0.47284307199688513\n,,1,1970-01-01T00:00:01Z,m,0,1,f,0.6115110431660992\n,,1,1970-01-01T00:00:02Z,m,0,1,f,0.9139676390179812\n,,1,1970-01-01T00:00:03Z,m,0,1,f,0.4419580502994864\n,,1,1970-01-01T00:00:04Z,m,0,1,f,0.22346720477114235\n,,1,1970-01-01T00:00:05Z,m,0,1,f,0.01657253263970824\n,,1,1970-01-01T00:00:06Z,m,0,1,f,0.5275526538985256\n,,1,1970-01-01T00:00:07Z,m,0,1,f,0.2801453905589357\n,,1,1970-01-01T00:00:08Z,m,0,1,f,0.40358058571546174\n,,1,1970-01-01T00:00:09Z,m,0,1,f,0.5581225312763497\n,,1,1970-01-01T00:00:10Z,m,0,1,f,0.5618381020173508\n,,1,1970-01-01T00:00:11Z,m,0,1,f,0.08048303365885615\n,,1,1970-01-01T00:00:12Z,m,0,1,f,0.5001751201461243\n,,1,1970-01-01T00:00:13Z,m,0,1,f,0.22639175489524663\n,,1,1970-01-01T00:00:14Z,m,0,1,f,0.26537476142069744\n,,1,1970-01-01T00:00:15Z,m,0,1,f,0.8045352065828273\n,,1,1970-01-01T00:00:16Z,m,0,1,f,0.401634967963577\n,,1,1970-01-01T00:00:17Z,m,0,1,f,0.9411501472896155\n,,1,1970-01-01T00:00:18Z,m,0,1,f,0.2930734491556474\n,,1,1970-01-01T00:00:19Z,m,0,1,f,0.18157543568371715\n,,1,1970-01-01T00:00:20Z,m,0,1,f,0.9385325130161203\n,,1,1970-01-01T00:00:21Z,m,0,1,f,0.17010332650185725\n,,1,1970-01-01T00:00:22Z,m,0,1,f,0.04213339793024455\n,,1,1970-01-01T00:00:23Z,m,0,1,f,0.5626619227163632\n,,1,1970-01-01T00:00:24Z,m,0,1,f,0.6941739177125473\n,,1,1970-01-01T00:00:25Z,m,0,1,f,0.5438842736369963\n,,1,1970-01-01T00:00:26Z,m,0,1,f,0.6524346931171858\n,,1,1970-01-01T00:00:27Z,m,0,1,f,0.062106354006262784\n,,1,1970-01-01T00:00:28Z,m,0,1,f,0.6808062354975885\n,,1,1970-01-01T00:00:29Z,m,0,1,f,0.4566938577876695\n,,1,1970-01-01T00:00:30Z,m,0,1,f,0.15426646385258916\n,,1,1970-01-01T00:00:31Z,m,0,1,f,0.7378414694167669\n,,1,1970-01-01T00:00:32Z,m,0,1,f,0.35905015546070745\n,,1,1970-01-01T00:00:33Z,m,0,1,f,0.25717348995611955\n,,1,1970-01-01T00:00:34Z,m,0,1,f,0.8669066045043076\n,,1,1970-01-01T00:00:35Z,m,0,1,f,0.7414665987538746\n,,1,1970-01-01T00:00:36Z,m,0,1,f,0.7580463272135385\n,,1,1970-01-01T00:00:37Z,m,0,1,f,0.223202540983848\n,,1,1970-01-01T00:00:38Z,m,0,1,f,0.09675623584194015\n,,1,1970-01-01T00:00:39Z,m,0,1,f,0.33037602371875235\n,,1,1970-01-01T00:00:40Z,m,0,1,f,0.02419699334564844\n,,1,1970-01-01T00:00:41Z,m,0,1,f,0.30660540046813134\n,,1,1970-01-01T00:00:42Z,m,0,1,f,0.28087743747358407\n,,1,1970-01-01T00:00:43Z,m,0,1,f,0.8125957553254125\n,,1,1970-01-01T00:00:44Z,m,0,1,f,0.3996499465775914\n,,1,1970-01-01T00:00:45Z,m,0,1,f,0.002859922694346698\n,,1,1970-01-01T00:00:46Z,m,0,1,f,0.7743871384683348\n,,1,1970-01-01T00:00:47Z,m,0,1,f,0.3428194666142575\n,,1,1970-01-01T00:00:48Z,m,0,1,f,0.24529106535786452\n,,1,1970-01-01T00:00:49Z,m,0,1,f,0.42074581063787847\n,,1,1970-01-01T00:00:50Z,m,0,1,f,0.8230512029974123\n,,1,1970-01-01T00:00:51Z,m,0,1,f,0.7612451595826552\n,,1,1970-01-01T00:00:52Z,m,0,1,f,0.0025044233308020394\n,,1,1970-01-01T00:00:53Z,m,0,1,f,0.8123608833291784\n,,1,1970-01-01T00:00:54Z,m,0,1,f,0.094280039506472\n,,1,1970-01-01T00:00:55Z,m,0,1,f,0.7414773533860608\n,,1,1970-01-01T00:00:56Z,m,0,1,f,0.048248944868655844\n,,1,1970-01-01T00:00:57Z,m,0,1,f,0.7876232215876143\n,,1,1970-01-01T00:00:58Z,m,0,1,f,0.7708955207540708\n,,1,1970-01-01T00:00:59Z,m,0,1,f,0.3210082428062905\n,,1,1970-01-01T00:01:00Z,m,0,1,f,0.6199485490487467\n,,1,1970-01-01T00:01:01Z,m,0,1,f,0.4526111772487005\n,,1,1970-01-01T00:01:02Z,m,0,1,f,0.06993036738408297\n,,1,1970-01-01T00:01:03Z,m,0,1,f,0.5391803940621971\n,,1,1970-01-01T00:01:04Z,m,0,1,f,0.3786026404218388\n,,1,1970-01-01T00:01:05Z,m,0,1,f,0.16987447951514412\n,,1,1970-01-01T00:01:06Z,m,0,1,f,0.9622624203254517\n,,1,1970-01-01T00:01:07Z,m,0,1,f,0.10609876802280566\n,,1,1970-01-01T00:01:08Z,m,0,1,f,0.34039196604520483\n,,1,1970-01-01T00:01:09Z,m,0,1,f,0.326997943237989\n,,1,1970-01-01T00:01:10Z,m,0,1,f,0.40582069426239586\n,,1,1970-01-01T00:01:11Z,m,0,1,f,0.09664389869310906\n,,1,1970-01-01T00:01:12Z,m,0,1,f,0.0874716642419619\n,,1,1970-01-01T00:01:13Z,m,0,1,f,0.9574787428982809\n,,1,1970-01-01T00:01:14Z,m,0,1,f,0.792171281216902\n,,1,1970-01-01T00:01:15Z,m,0,1,f,0.8154053514727819\n,,1,1970-01-01T00:01:16Z,m,0,1,f,0.9446634309508735\n,,1,1970-01-01T00:01:17Z,m,0,1,f,0.7914039734656017\n,,1,1970-01-01T00:01:18Z,m,0,1,f,0.5642005948380394\n,,1,1970-01-01T00:01:19Z,m,0,1,f,0.9394901508564378\n,,1,1970-01-01T00:01:20Z,m,0,1,f,0.09420964672484634\n,,1,1970-01-01T00:01:21Z,m,0,1,f,0.8997154088951347\n,,1,1970-01-01T00:01:22Z,m,0,1,f,0.8929163087698091\n,,1,1970-01-01T00:01:23Z,m,0,1,f,0.14602512562046865\n,,1,1970-01-01T00:01:24Z,m,0,1,f,0.061755078411980135\n,,1,1970-01-01T00:01:25Z,m,0,1,f,0.050027231315704974\n,,1,1970-01-01T00:01:26Z,m,0,1,f,0.06579399435541186\n,,1,1970-01-01T00:01:27Z,m,0,1,f,0.5485533330294929\n,,1,1970-01-01T00:01:28Z,m,0,1,f,0.08600793471366114\n,,1,1970-01-01T00:01:29Z,m,0,1,f,0.0048224932897884395\n,,1,1970-01-01T00:01:30Z,m,0,1,f,0.031000679866955753\n,,1,1970-01-01T00:01:31Z,m,0,1,f,0.7590758510991269\n,,1,1970-01-01T00:01:32Z,m,0,1,f,0.28752964131696107\n,,1,1970-01-01T00:01:33Z,m,0,1,f,0.0803113942730073\n,,1,1970-01-01T00:01:34Z,m,0,1,f,0.7653660195907919\n,,1,1970-01-01T00:01:35Z,m,0,1,f,0.169201547040183\n,,1,1970-01-01T00:01:36Z,m,0,1,f,0.2812417370494343\n,,1,1970-01-01T00:01:37Z,m,0,1,f,0.5556525309491438\n,,1,1970-01-01T00:01:38Z,m,0,1,f,0.21336394958285926\n,,1,1970-01-01T00:01:39Z,m,0,1,f,0.843202199200085\n,,2,1970-01-01T00:00:00Z,m,1,0,f,0.6745411981120504\n,,2,1970-01-01T00:00:01Z,m,1,0,f,0.4341136360856983\n,,2,1970-01-01T00:00:02Z,m,1,0,f,0.0779873994184798\n,,2,1970-01-01T00:00:03Z,m,1,0,f,0.6045688060594187\n,,2,1970-01-01T00:00:04Z,m,1,0,f,0.609806908577383\n,,2,1970-01-01T00:00:05Z,m,1,0,f,0.2371373109677929\n,,2,1970-01-01T00:00:06Z,m,1,0,f,0.15959047192822226\n,,2,1970-01-01T00:00:07Z,m,1,0,f,0.7696930667476671\n,,2,1970-01-01T00:00:08Z,m,1,0,f,0.44489788239949923\n,,2,1970-01-01T00:00:09Z,m,1,0,f,0.20113730484499945\n,,2,1970-01-01T00:00:10Z,m,1,0,f,0.9004310672214374\n,,2,1970-01-01T00:00:11Z,m,1,0,f,0.08071979045152104\n,,2,1970-01-01T00:00:12Z,m,1,0,f,0.35878401311181407\n,,2,1970-01-01T00:00:13Z,m,1,0,f,0.8046013839899406\n,,2,1970-01-01T00:00:14Z,m,1,0,f,0.09869242829873062\n,,2,1970-01-01T00:00:15Z,m,1,0,f,0.27053244466215826\n,,2,1970-01-01T00:00:16Z,m,1,0,f,0.6672055373259661\n,,2,1970-01-01T00:00:17Z,m,1,0,f,0.9015798497859395\n,,2,1970-01-01T00:00:18Z,m,1,0,f,0.6514438661906353\n,,2,1970-01-01T00:00:19Z,m,1,0,f,0.03319201114385362\n,,2,1970-01-01T00:00:20Z,m,1,0,f,0.44109087427118215\n,,2,1970-01-01T00:00:21Z,m,1,0,f,0.1441063884747634\n,,2,1970-01-01T00:00:22Z,m,1,0,f,0.23335939084421864\n,,2,1970-01-01T00:00:23Z,m,1,0,f,0.6904277645853616\n,,2,1970-01-01T00:00:24Z,m,1,0,f,0.5145930899531316\n,,2,1970-01-01T00:00:25Z,m,1,0,f,0.4299752694354613\n,,2,1970-01-01T00:00:26Z,m,1,0,f,0.9207494524068397\n,,2,1970-01-01T00:00:27Z,m,1,0,f,0.4990764483657634\n,,2,1970-01-01T00:00:28Z,m,1,0,f,0.7370053493218158\n,,2,1970-01-01T00:00:29Z,m,1,0,f,0.8159190359865772\n,,2,1970-01-01T00:00:30Z,m,1,0,f,0.5730300999100897\n,,2,1970-01-01T00:00:31Z,m,1,0,f,0.4957548727598841\n,,2,1970-01-01T00:00:32Z,m,1,0,f,0.4475722509767004\n,,2,1970-01-01T00:00:33Z,m,1,0,f,0.09000105562869058\n,,2,1970-01-01T00:00:34Z,m,1,0,f,0.5765896961954948\n,,2,1970-01-01T00:00:35Z,m,1,0,f,0.007292186311595296\n,,2,1970-01-01T00:00:36Z,m,1,0,f,0.6862338192326899\n,,2,1970-01-01T00:00:37Z,m,1,0,f,0.6323091325867545\n,,2,1970-01-01T00:00:38Z,m,1,0,f,0.22250144688828086\n,,2,1970-01-01T00:00:39Z,m,1,0,f,0.7767158293696542\n,,2,1970-01-01T00:00:40Z,m,1,0,f,0.5040765046136644\n,,2,1970-01-01T00:00:41Z,m,1,0,f,0.7198824794590694\n,,2,1970-01-01T00:00:42Z,m,1,0,f,0.16487220863546403\n,,2,1970-01-01T00:00:43Z,m,1,0,f,0.6185190195253291\n,,2,1970-01-01T00:00:44Z,m,1,0,f,0.417935209198883\n,,2,1970-01-01T00:00:45Z,m,1,0,f,0.143322367253724\n,,2,1970-01-01T00:00:46Z,m,1,0,f,0.7110860020844423\n,,2,1970-01-01T00:00:47Z,m,1,0,f,0.5190433935276061\n,,2,1970-01-01T00:00:48Z,m,1,0,f,0.5947710020498977\n,,2,1970-01-01T00:00:49Z,m,1,0,f,0.18632874860445664\n,,2,1970-01-01T00:00:50Z,m,1,0,f,0.050671657609869296\n,,2,1970-01-01T00:00:51Z,m,1,0,f,0.336667976831678\n,,2,1970-01-01T00:00:52Z,m,1,0,f,0.16893598340949662\n,,2,1970-01-01T00:00:53Z,m,1,0,f,0.6319794509787114\n,,2,1970-01-01T00:00:54Z,m,1,0,f,0.3434433122927547\n,,2,1970-01-01T00:00:55Z,m,1,0,f,0.13766344408813833\n,,2,1970-01-01T00:00:56Z,m,1,0,f,0.7028890267599247\n,,2,1970-01-01T00:00:57Z,m,1,0,f,0.5893915586856076\n,,2,1970-01-01T00:00:58Z,m,1,0,f,0.08495375348679511\n,,2,1970-01-01T00:00:59Z,m,1,0,f,0.5635570663754376\n,,2,1970-01-01T00:01:00Z,m,1,0,f,0.06973804413592974\n,,2,1970-01-01T00:01:01Z,m,1,0,f,0.4594087627832006\n,,2,1970-01-01T00:01:02Z,m,1,0,f,0.9484143072574632\n,,2,1970-01-01T00:01:03Z,m,1,0,f,0.7210862651644585\n,,2,1970-01-01T00:01:04Z,m,1,0,f,0.4306492881221061\n,,2,1970-01-01T00:01:05Z,m,1,0,f,0.9768511587696722\n,,2,1970-01-01T00:01:06Z,m,1,0,f,0.036770411149115535\n,,2,1970-01-01T00:01:07Z,m,1,0,f,0.199704171721732\n,,2,1970-01-01T00:01:08Z,m,1,0,f,0.044989678879272736\n,,2,1970-01-01T00:01:09Z,m,1,0,f,0.4204918747032285\n,,2,1970-01-01T00:01:10Z,m,1,0,f,0.7660528673315015\n,,2,1970-01-01T00:01:11Z,m,1,0,f,0.07495082447510862\n,,2,1970-01-01T00:01:12Z,m,1,0,f,0.979672949703\n,,2,1970-01-01T00:01:13Z,m,1,0,f,0.43531431314587743\n,,2,1970-01-01T00:01:14Z,m,1,0,f,0.16473009865933294\n,,2,1970-01-01T00:01:15Z,m,1,0,f,0.9714924938553514\n,,2,1970-01-01T00:01:16Z,m,1,0,f,0.8548205740914873\n,,2,1970-01-01T00:01:17Z,m,1,0,f,0.988621458104506\n,,2,1970-01-01T00:01:18Z,m,1,0,f,0.42316749552422783\n,,2,1970-01-01T00:01:19Z,m,1,0,f,0.5599137447927957\n,,2,1970-01-01T00:01:20Z,m,1,0,f,0.7513515954882367\n,,2,1970-01-01T00:01:21Z,m,1,0,f,0.07681127373236643\n,,2,1970-01-01T00:01:22Z,m,1,0,f,0.04219934813632237\n,,2,1970-01-01T00:01:23Z,m,1,0,f,0.27672511415229256\n,,2,1970-01-01T00:01:24Z,m,1,0,f,0.6618414211834359\n,,2,1970-01-01T00:01:25Z,m,1,0,f,0.04819580958061359\n,,2,1970-01-01T00:01:26Z,m,1,0,f,0.8514613397306017\n,,2,1970-01-01T00:01:27Z,m,1,0,f,0.654705748814002\n,,2,1970-01-01T00:01:28Z,m,1,0,f,0.9967833661484294\n,,2,1970-01-01T00:01:29Z,m,1,0,f,0.9631421129969118\n,,2,1970-01-01T00:01:30Z,m,1,0,f,0.6286421005881492\n,,2,1970-01-01T00:01:31Z,m,1,0,f,0.3783501632738452\n,,2,1970-01-01T00:01:32Z,m,1,0,f,0.05114898778086843\n,,2,1970-01-01T00:01:33Z,m,1,0,f,0.2473880323048304\n,,2,1970-01-01T00:01:34Z,m,1,0,f,0.7842674808782694\n,,2,1970-01-01T00:01:35Z,m,1,0,f,0.6130952139646441\n,,2,1970-01-01T00:01:36Z,m,1,0,f,0.9762618521418323\n,,2,1970-01-01T00:01:37Z,m,1,0,f,0.9219480325346383\n,,2,1970-01-01T00:01:38Z,m,1,0,f,0.7986205925631757\n,,2,1970-01-01T00:01:39Z,m,1,0,f,0.578541588985068\n,,3,1970-01-01T00:00:00Z,m,1,1,f,0.3609497652786835\n,,3,1970-01-01T00:00:01Z,m,1,1,f,0.6431495269328852\n,,3,1970-01-01T00:00:02Z,m,1,1,f,0.30119517109360755\n,,3,1970-01-01T00:00:03Z,m,1,1,f,0.029905756669452933\n,,3,1970-01-01T00:00:04Z,m,1,1,f,0.32578997668820153\n,,3,1970-01-01T00:00:05Z,m,1,1,f,0.7482046757377168\n,,3,1970-01-01T00:00:06Z,m,1,1,f,0.42006674019623874\n,,3,1970-01-01T00:00:07Z,m,1,1,f,0.8892383923700209\n,,3,1970-01-01T00:00:08Z,m,1,1,f,0.2734890146915862\n,,3,1970-01-01T00:00:09Z,m,1,1,f,0.2126705472958595\n,,3,1970-01-01T00:00:10Z,m,1,1,f,0.4081541720871348\n,,3,1970-01-01T00:00:11Z,m,1,1,f,0.7517886726430452\n,,3,1970-01-01T00:00:12Z,m,1,1,f,0.6344255763748975\n,,3,1970-01-01T00:00:13Z,m,1,1,f,0.13439033950657941\n,,3,1970-01-01T00:00:14Z,m,1,1,f,0.13080770333361982\n,,3,1970-01-01T00:00:15Z,m,1,1,f,0.42098106260813917\n,,3,1970-01-01T00:00:16Z,m,1,1,f,0.6126625007965338\n,,3,1970-01-01T00:00:17Z,m,1,1,f,0.6566130686317417\n,,3,1970-01-01T00:00:18Z,m,1,1,f,0.8724405943016941\n,,3,1970-01-01T00:00:19Z,m,1,1,f,0.5240118690102152\n,,3,1970-01-01T00:00:20Z,m,1,1,f,0.16295208705669978\n,,3,1970-01-01T00:00:21Z,m,1,1,f,0.3087465430934554\n,,3,1970-01-01T00:00:22Z,m,1,1,f,0.5285274343484349\n,,3,1970-01-01T00:00:23Z,m,1,1,f,0.634731960510953\n,,3,1970-01-01T00:00:24Z,m,1,1,f,0.21258839107347696\n,,3,1970-01-01T00:00:25Z,m,1,1,f,0.418565981182859\n,,3,1970-01-01T00:00:26Z,m,1,1,f,0.2537565365571897\n,,3,1970-01-01T00:00:27Z,m,1,1,f,0.5464331287426728\n,,3,1970-01-01T00:00:28Z,m,1,1,f,0.9960454475764904\n,,3,1970-01-01T00:00:29Z,m,1,1,f,0.09275146190386824\n,,3,1970-01-01T00:00:30Z,m,1,1,f,0.6976442897720185\n,,3,1970-01-01T00:00:31Z,m,1,1,f,0.74713521249196\n,,3,1970-01-01T00:00:32Z,m,1,1,f,0.984508958500529\n,,3,1970-01-01T00:00:33Z,m,1,1,f,0.735978145078593\n,,3,1970-01-01T00:00:34Z,m,1,1,f,0.03272325327489153\n,,3,1970-01-01T00:00:35Z,m,1,1,f,0.2789090231376286\n,,3,1970-01-01T00:00:36Z,m,1,1,f,0.9009986444969635\n,,3,1970-01-01T00:00:37Z,m,1,1,f,0.848311973911401\n,,3,1970-01-01T00:00:38Z,m,1,1,f,0.3433130690616337\n,,3,1970-01-01T00:00:39Z,m,1,1,f,0.9705860405696857\n,,3,1970-01-01T00:00:40Z,m,1,1,f,0.4971554061394775\n,,3,1970-01-01T00:00:41Z,m,1,1,f,0.5010737989466268\n,,3,1970-01-01T00:00:42Z,m,1,1,f,0.6786336325659156\n,,3,1970-01-01T00:00:43Z,m,1,1,f,0.45685893681365386\n,,3,1970-01-01T00:00:44Z,m,1,1,f,0.06785712875301617\n,,3,1970-01-01T00:00:45Z,m,1,1,f,0.3686928354464234\n,,3,1970-01-01T00:00:46Z,m,1,1,f,0.16238519747752908\n,,3,1970-01-01T00:00:47Z,m,1,1,f,0.09616346590744834\n,,3,1970-01-01T00:00:48Z,m,1,1,f,0.982361090570932\n,,3,1970-01-01T00:00:49Z,m,1,1,f,0.24546880258756468\n,,3,1970-01-01T00:00:50Z,m,1,1,f,0.4063470659819713\n,,3,1970-01-01T00:00:51Z,m,1,1,f,0.02333966735385356\n,,3,1970-01-01T00:00:52Z,m,1,1,f,0.7485740576779872\n,,3,1970-01-01T00:00:53Z,m,1,1,f,0.6166837184691856\n,,3,1970-01-01T00:00:54Z,m,1,1,f,0.05978509722242629\n,,3,1970-01-01T00:00:55Z,m,1,1,f,0.8745680789623674\n,,3,1970-01-01T00:00:56Z,m,1,1,f,0.7043364028176561\n,,3,1970-01-01T00:00:57Z,m,1,1,f,0.5100762819992395\n,,3,1970-01-01T00:00:58Z,m,1,1,f,0.16311060736490562\n,,3,1970-01-01T00:00:59Z,m,1,1,f,0.8629619678924975\n,,3,1970-01-01T00:01:00Z,m,1,1,f,0.10822795841933747\n,,3,1970-01-01T00:01:01Z,m,1,1,f,0.009391242035550616\n,,3,1970-01-01T00:01:02Z,m,1,1,f,0.8963338627277064\n,,3,1970-01-01T00:01:03Z,m,1,1,f,0.2741500937920746\n,,3,1970-01-01T00:01:04Z,m,1,1,f,0.8919325188107933\n,,3,1970-01-01T00:01:05Z,m,1,1,f,0.6654225234319311\n,,3,1970-01-01T00:01:06Z,m,1,1,f,0.02781722451099708\n,,3,1970-01-01T00:01:07Z,m,1,1,f,0.1620103430803485\n,,3,1970-01-01T00:01:08Z,m,1,1,f,0.4825820756588489\n,,3,1970-01-01T00:01:09Z,m,1,1,f,0.6564731088934671\n,,3,1970-01-01T00:01:10Z,m,1,1,f,0.5500077260845426\n,,3,1970-01-01T00:01:11Z,m,1,1,f,0.40462752766482185\n,,3,1970-01-01T00:01:12Z,m,1,1,f,0.8674131498299248\n,,3,1970-01-01T00:01:13Z,m,1,1,f,0.8902851603994412\n,,3,1970-01-01T00:01:14Z,m,1,1,f,0.1599747356552478\n,,3,1970-01-01T00:01:15Z,m,1,1,f,0.4023835778260672\n,,3,1970-01-01T00:01:16Z,m,1,1,f,0.8892986579330658\n,,3,1970-01-01T00:01:17Z,m,1,1,f,0.05870852811550652\n,,3,1970-01-01T00:01:18Z,m,1,1,f,0.08810359195444939\n,,3,1970-01-01T00:01:19Z,m,1,1,f,0.5799459169235229\n,,3,1970-01-01T00:01:20Z,m,1,1,f,0.675990461828967\n,,3,1970-01-01T00:01:21Z,m,1,1,f,0.680028234810394\n,,3,1970-01-01T00:01:22Z,m,1,1,f,0.3828707005637953\n,,3,1970-01-01T00:01:23Z,m,1,1,f,0.369157111114499\n,,3,1970-01-01T00:01:24Z,m,1,1,f,0.12328872455169967\n,,3,1970-01-01T00:01:25Z,m,1,1,f,0.43126638642422993\n,,3,1970-01-01T00:01:26Z,m,1,1,f,0.24418662053793608\n,,3,1970-01-01T00:01:27Z,m,1,1,f,0.22094836458502065\n,,3,1970-01-01T00:01:28Z,m,1,1,f,0.10278220106833619\n,,3,1970-01-01T00:01:29Z,m,1,1,f,0.7194160988953583\n,,3,1970-01-01T00:01:30Z,m,1,1,f,0.9646344422230495\n,,3,1970-01-01T00:01:31Z,m,1,1,f,0.462370535565091\n,,3,1970-01-01T00:01:32Z,m,1,1,f,0.9386791098643801\n,,3,1970-01-01T00:01:33Z,m,1,1,f,0.03801280884674329\n,,3,1970-01-01T00:01:34Z,m,1,1,f,0.35603844514090255\n,,3,1970-01-01T00:01:35Z,m,1,1,f,0.5083881660913203\n,,3,1970-01-01T00:01:36Z,m,1,1,f,0.4326239900843389\n,,3,1970-01-01T00:01:37Z,m,1,1,f,0.09453891565081506\n,,3,1970-01-01T00:01:38Z,m,1,1,f,0.023503857583366802\n,,3,1970-01-01T00:01:39Z,m,1,1,f,0.9492834672803911\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   419,
					},
					File:   "selector_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,max\n,,0,1970-01-01T00:01:28Z,m,0.9967833661484294\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   413,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   413,
						},
						File:   "selector_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   413,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   419,
						},
						File:   "selector_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,max\n,,0,1970-01-01T00:01:28Z,m,0.9967833661484294\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   413,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,double\n#group,false,false,false,true,false\n#default,0,,,,\n,result,table,time,_measurement,max\n,,0,1970-01-01T00:01:28Z,m,0.9967833661484294\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 52,
						Line:   429,
					},
					File:   "selector_test.flux",
					Source: "t_selector = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> max()\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"max\"})",
					Start: ast.Position{
						Column: 1,
						Line:   422,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   422,
						},
						File:   "selector_test.flux",
						Source: "t_selector",
						Start: ast.Position{
							Column: 1,
							Line:   422,
						},
					},
				},
				Name: "t_selector",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 52,
							Line:   429,
						},
						File:   "selector_test.flux",
						Source: "(tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> max()\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"max\"})",
						Start: ast.Position{
							Column: 14,
							Line:   422,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   422,
														},
														File:   "selector_test.flux",
														Source: "tables",
														Start: ast.Position{
															Column: 29,
															Line:   422,
														},
													},
												},
												Name: "tables",
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   423,
													},
													File:   "selector_test.flux",
													Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)",
													Start: ast.Position{
														Column: 29,
														Line:   422,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   423,
															},
															File:   "selector_test.flux",
															Source: "start: influxql.minTime, stop: influxql.maxTime",
															Start: ast.Position{
																Column: 11,
																Line:   423,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   423,
																},
																File:   "selector_test.flux",
																Source: "start: influxql.minTime",
																Start: ast.Position{
																	Column: 11,
																	Line:   423,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   423,
																	},
																	File:   "selector_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 11,
																		Line:   423,
																	},
																},
															},
															Name: "start",
														},
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   423,
																	},
																	File:   "selector_test.flux",
																	Source: "influxql.minTime",
																	Start: ast.Position{
																		Column: 18,
																		Line:   423,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   423,
																		},
																		File:   "selector_test.flux",
																		Source: "influxql",
																		Start: ast.Position{
																			Column: 18,
																			Line:   423,
																		},
																	},
																},
																Name: "influxql",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   423,
																		},
																		File:   "selector_test.flux",
																		Source: "minTime",
																		Start: ast.Position{
																			Column: 27,
																			Line:   423,
																		},
																	},
																},
																Name: "minTime",
															},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   423,
																},
																File:   "selector_test.flux",
																Source: "stop: influxql.maxTime",
																Start: ast.Position{
																	Column: 36,
																	Line:   423,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   423,
																	},
																	File:   "selector_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 36,
																		Line:   423,
																	},
																},
															},
															Name: "stop",
														},
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   423,
																	},
																	File:   "selector_test.flux",
																	Source: "influxql.maxTime",
																	Start: ast.Position{
																		Column: 42,
																		Line:   423,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   423,
																		},
																		File:   "selector_test.flux",
																		Source: "influxql",
																		Start: ast.Position{
																			Column: 42,
																			Line:   423,
																		},
																	},
																},
																Name: "influxql",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   423,
																		},
																		File:   "selector_test.flux",
																		Source: "maxTime",
																		Start: ast.Position{
																			Column: 51,
																			Line:   423,
																		},
																	},
																},
																Name: "maxTime",
															},
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   423,
														},
														File:   "selector_test.flux",
														Source: "range(start: influxql.minTime, stop: influxql.maxTime)",
														Start: ast.Position{
															Column: 5,
															Line:   423,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   423,
															},
															File:   "selector_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 5,
																Line:   423,
															},
														},
													},
													Name: "range",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   424,
												},
												File:   "selector_test.flux",
												Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")",
												Start: ast.Position{
													Column: 29,
													Line:   422,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   424,
														},
														File:   "selector_test.flux",
														Source: "fn: (r) => r._measurement == \"m\"",
														Start: ast.Position{
															Column: 12,
															Line:   424,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   424,
															},
															File:   "selector_test.flux",
															Source: "fn: (r) => r._measurement == \"m\"",
															Start: ast.Position{
																Column: 12,
																Line:   424,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   424,
																},
																File:   "selector_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 12,
																	Line:   424,
																},
															},
														},
														Name: "fn",
													},
													Value: &ast.FunctionExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   424,
																},
																File:   "selector_test.flux",
																Source: "(r) => r._measurement == \"m\"",
																Start: ast.Position{
																	Column: 16,
																	Line:   424,
																},
															},
														},
														Body: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   424,
																	},
																	File:   "selector_test.flux",
																	Source: "r._measurement == \"m\"",
																	Start: ast.Position{
																		Column: 23,
																		Line:   424,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   424,
																		},
																		File:   "selector_test.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 23,
																			Line:   424,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   424,
																			},
																			File:   "selector_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 23,
																				Line:   424,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   424,
																			},
																			File:   "selector_test.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 25,
																				Line:   424,
																			},
																		},
																	},
																	Name: "_measurement",
																},
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   424,
																		},
																		File:   "selector_test.flux",
																		Source: "\"m\"",
																		Start: ast.Position{
																			Column: 41,
																			Line:   424,
																		},
																	},
																},
																Value: "m",
															},
														},
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   424,
																	},
																	File:   "selector_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   424,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   424,
																		},
																		File:   "selector_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   424,
																		},
																	},
																},
																Name: "r",
															},
															Value: nil,
														}},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   424,
													},
													File:   "selector_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"m\")",
													Start: ast.Position{
														Column: 5,
														Line:   424,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   424,
														},
														File:   "selector_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 5,
															Line:   424,
														},
													},
												},
												Name: "filter",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   425,
											},
											File:   "selector_test.flux",
											Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")",
											Start: ast.Position{
												Column: 29,
												Line:   422,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   425,
													},
													File:   "selector_test.flux",
													Source: "fn: (r) => r._field == \"f\"",
													Start: ast.Position{
														Column: 12,
														Line:   425,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   425,
														},
														File:   "selector_test.flux",
														Source: "fn: (r) => r._field == \"f\"",
														Start: ast.Position{
															Column: 12,
															Line:   425,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   425,
															},
															File:   "selector_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   425,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   425,
															},
															File:   "selector_test.flux",
															Source: "(r) => r._field == \"f\"",
															Start: ast.Position{
																Column: 16,
																Line:   425,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   425,
																},
																File:   "selector_test.flux",
																Source: "r._field == \"f\"",
																Start: ast.Position{
																	Column: 23,
																	Line:   425,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   425,
																	},
																	File:   "selector_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 23,
																		Line:   425,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   425,
																		},
																		File:   "selector_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 23,
																			Line:   425,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   425,
																		},
																		File:   "selector_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 25,
																			Line:   425,
																		},
																	},
																},
																Name: "_field",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   425,
																	},
																	File:   "selector_test.flux",
																	Source: "\"f\"",
																	Start: ast.Position{
																		Column: 35,
																		Line:   425,
																	},
																},
															},
															Value: "f",
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   425,
																},
																File:   "selector_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   425,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   425,
																	},
																	File:   "selector_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   425,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   425,
												},
												File:   "selector_test.flux",
												Source: "filter(fn: (r) => r._field == \"f\")",
												Start: ast.Position{
													Column: 5,
													Line:   425,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   425,
													},
													File:   "selector_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 5,
														Line:   425,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   426,
										},
										File:   "selector_test.flux",
										Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])",
										Start: ast.Position{
											Column: 29,
											Line:   422,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   426,
												},
												File:   "selector_test.flux",
												Source: "columns: [\"_measurement\", \"_field\"]",
												Start: ast.Position{
													Column: 11,
													Line:   426,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   426,
													},
													File:   "selector_test.flux",
													Source: "columns: [\"_measurement\", \"_field\"]",
													Start: ast.Position{
														Column: 11,
														Line:   426,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   426,
														},
														File:   "selector_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 11,
															Line:   426,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   426,
														},
														File:   "selector_test.flux",
														Source: "[\"_measurement\", \"_field\"]",
														Start: ast.Position{
															Column: 20,
															Line:   426,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   426,
															},
															File:   "selector_test.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 21,
																Line:   426,
															},
														},
													},
													Value: "_measurement",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   426,
															},
															File:   "selector_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 37,
																Line:   426,
															},
														},
													},
													Value: "_field",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   426,
											},
											File:   "selector_test.flux",
											Source: "group(columns: [\"_measurement\", \"_field\"])",
											Start: ast.Position{
												Column: 5,
												Line:   426,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   426,
												},
												File:   "selector_test.flux",
												Source: "group",
												Start: ast.Position{
													Column: 5,
													Line:   426,
												},
											},
										},
										Name: "group",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   427,
									},
									File:   "selector_test.flux",
									Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> max()",
									Start: ast.Position{
										Column: 29,
										Line:   422,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   427,
										},
										File:   "selector_test.flux",
										Source: "max()",
										Start: ast.Position{
											Column: 5,
											Line:   427,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   427,
											},
											File:   "selector_test.flux",
											Source: "max",
											Start: ast.Position{
												Column: 5,
												Line:   427,
											},
										},
									},
									Name: "max",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   428,
								},
								File:   "selector_test.flux",
								Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> max()\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
								Start: ast.Position{
									Column: 29,
									Line:   422,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   428,
										},
										File:   "selector_test.flux",
										Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
										Start: ast.Position{
											Column: 10,
											Line:   428,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   428,
											},
											File:   "selector_test.flux",
											Source: "columns: [\"_time\", \"_value\", \"_measurement\"]",
											Start: ast.Position{
												Column: 10,
												Line:   428,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   428,
												},
												File:   "selector_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 10,
													Line:   428,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   428,
												},
												File:   "selector_test.flux",
												Source: "[\"_time\", \"_value\", \"_measurement\"]",
												Start: ast.Position{
													Column: 19,
													Line:   428,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   428,
													},
													File:   "selector_test.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 20,
														Line:   428,
													},
												},
											},
											Value: "_time",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   428,
													},
													File:   "selector_test.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 29,
														Line:   428,
													},
												},
											},
											Value: "_value",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   428,
													},
													File:   "selector_test.flux",
													Source: "\"_measurement\"",
													Start: ast.Position{
														Column: 39,
														Line:   428,
													},
												},
											},
											Value: "_measurement",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   428,
									},
									File:   "selector_test.flux",
									Source: "keep(columns: [\"_time\", \"_value\", \"_measurement\"])",
									Start: ast.Position{
										Column: 5,
										Line:   428,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   428,
										},
										File:   "selector_test.flux",
										Source: "keep",
										Start: ast.Position{
											Column: 5,
											Line:   428,
										},
									},
								},
								Name: "keep",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 52,
								Line:   429,
							},
							File:   "selector_test.flux",
							Source: "tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> group(columns: [\"_measurement\", \"_field\"])\n\t|> max()\n\t|> keep(columns: [\"_time\", \"_value\", \"_measurement\"])\n\t|> rename(columns: {_time: \"time\", _value: \"max\"})",
							Start: ast.Position{
								Column: 29,
								Line:   422,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   429,
									},
									File:   "selector_test.flux",
									Source: "columns: {_time: \"time\", _value: \"max\"}",
									Start: ast.Position{
										Column: 12,
										Line:   429,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   429,
										},
										File:   "selector_test.flux",
										Source: "columns: {_time: \"time\", _value: \"max\"}",
										Start: ast.Position{
											Column: 12,
											Line:   429,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   429,
											},
											File:   "selector_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 12,
												Line:   429,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   429,
											},
											File:   "selector_test.flux",
											Source: "{_time: \"time\", _value: \"max\"}",
											Start: ast.Position{
												Column: 21,
												Line:   429,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   429,
												},
												File:   "selector_test.flux",
												Source: "_time: \"time\"",
												Start: ast.Position{
													Column: 22,
													Line:   429,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   429,
													},
													File:   "selector_test.flux",
													Source: "_time",
													Start: ast.Position{
														Column: 22,
														Line:   429,
													},
												},
											},
											Name: "_time",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   429,
													},
													File:   "selector_test.flux",
													Source: "\"time\"",
													Start: ast.Position{
														Column: 29,
														Line:   429,
													},
												},
											},
											Value: "time",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   429,
												},
												File:   "selector_test.flux",
												Source: "_value: \"max\"",
												Start: ast.Position{
													Column: 37,
													Line:   429,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   429,
													},
													File:   "selector_test.flux",
													Source: "_value",
													Start: ast.Position{
														Column: 37,
														Line:   429,
													},
												},
											},
											Name: "_value",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   429,
													},
													File:   "selector_test.flux",
													Source: "\"max\"",
													Start: ast.Position{
														Column: 45,
														Line:   429,
													},
												},
											},
											Value: "max",
										},
									}},
									With: nil,
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   429,
								},
								File:   "selector_test.flux",
								Source: "rename(columns: {_time: \"time\", _value: \"max\"})",
								Start: ast.Position{
									Column: 5,
									Line:   429,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   429,
									},
									File:   "selector_test.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 5,
										Line:   429,
									},
								},
							},
							Name: "rename",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   422,
							},
							File:   "selector_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   422,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   422,
								},
								File:   "selector_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   422,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   422,
							},
							File:   "selector_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   422,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   435,
						},
						File:   "selector_test.flux",
						Source: "_selector = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_selector,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   431,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   431,
							},
							File:   "selector_test.flux",
							Source: "_selector",
							Start: ast.Position{
								Column: 6,
								Line:   431,
							},
						},
					},
					Name: "_selector",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   435,
							},
							File:   "selector_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_selector,\n})",
							Start: ast.Position{
								Column: 18,
								Line:   431,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   435,
								},
								File:   "selector_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_selector,\n})",
								Start: ast.Position{
									Column: 24,
									Line:   431,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   435,
									},
									File:   "selector_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_selector,\n}",
									Start: ast.Position{
										Column: 25,
										Line:   431,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   432,
										},
										File:   "selector_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   432,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   432,
											},
											File:   "selector_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   432,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   432,
												},
												File:   "selector_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   432,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   432,
													},
													File:   "selector_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   432,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   432,
														},
														File:   "selector_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   432,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   432,
														},
														File:   "selector_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   432,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   432,
											},
											File:   "selector_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   432,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   432,
												},
												File:   "selector_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   432,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   432,
													},
													File:   "selector_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   432,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   432,
													},
													File:   "selector_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   432,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   433,
										},
										File:   "selector_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   433,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   433,
											},
											File:   "selector_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   433,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   433,
												},
												File:   "selector_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   433,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   433,
													},
													File:   "selector_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   433,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   433,
														},
														File:   "selector_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   433,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   433,
														},
														File:   "selector_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   433,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   433,
											},
											File:   "selector_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   433,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   433,
												},
												File:   "selector_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   433,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   433,
													},
													File:   "selector_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   433,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   433,
													},
													File:   "selector_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   433,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   434,
										},
										File:   "selector_test.flux",
										Source: "fn: t_selector",
										Start: ast.Position{
											Column: 2,
											Line:   434,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   434,
											},
											File:   "selector_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   434,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   434,
											},
											File:   "selector_test.flux",
											Source: "t_selector",
											Start: ast.Position{
												Column: 6,
												Line:   434,
											},
										},
									},
									Name: "t_selector",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   435,
					},
					File:   "selector_test.flux",
					Source: "test _selector = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_selector,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   431,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "selector_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "selector_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "selector_test.flux",
					Source: "import \"internal/influxql\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "selector_test.flux",
						Source: "\"internal/influxql\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "internal/influxql",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "selector_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "selector_test.flux",
					Source: "package influxql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "selector_test.flux",
						Source: "influxql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxql_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   703,
				},
				File:   "series_agg_test.flux",
				Source: "package influxql_test\n\nimport \"testing\"\nimport \"internal/influxql\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,0,,,,,\n,result,table,_time,_measurement,t0,difference\n,,0,1970-01-01T01:00:00Z,m,0,0.16152781154936718\n,,0,1970-01-01T02:00:00Z,m,0,0.5450233503637238\n,,0,1970-01-01T03:00:00Z,m,0,-0.25474251334078146\n,,0,1970-01-01T04:00:00Z,m,0,-0.5121283372090074\n,,0,1970-01-01T05:00:00Z,m,0,0.171070028248751\n,,0,1970-01-01T06:00:00Z,m,0,-0.13711438955681704\n,,0,1970-01-01T07:00:00Z,m,0,0.5180121760612726\n,,0,1970-01-01T08:00:00Z,m,0,-0.30465284267416787\n,,0,1970-01-01T09:00:00Z,m,0,-0.003939225414167302\n,,0,1970-01-01T10:00:00Z,m,0,-0.11037649542590938\n,,0,1970-01-01T11:00:00Z,m,0,-0.06844878023750281\n,,0,1970-01-01T12:00:00Z,m,0,0.5940685767143397\n,,0,1970-01-01T13:00:00Z,m,0,0.056202322240399005\n,,0,1970-01-01T14:00:00Z,m,0,-0.6528142877331138\n,,0,1970-01-01T15:00:00Z,m,0,0.07601807321180445\n,,0,1970-01-01T16:00:00Z,m,0,0.3324582331504331\n,,0,1970-01-01T17:00:00Z,m,0,-0.3894222151383956\n,,0,1970-01-01T18:00:00Z,m,0,0.056171090499160053\n,,0,1970-01-01T19:00:00Z,m,0,-0.04397261098326383\n,,0,1970-01-01T20:00:00Z,m,0,0.5959662644121464\n,,0,1970-01-01T21:00:00Z,m,0,0.1489572818754724\n,,0,1970-01-01T22:00:00Z,m,0,-0.03891116230429392\n,,0,1970-01-01T23:00:00Z,m,0,-0.9235894932594585\n,,0,1970-01-02T00:00:00Z,m,0,0.4517728100761904\n,,0,1970-01-02T01:00:00Z,m,0,-0.0641922007760733\n,,0,1970-01-02T02:00:00Z,m,0,-0.3731276319027032\n,,0,1970-01-02T03:00:00Z,m,0,0.6832773878678778\n,,0,1970-01-02T04:00:00Z,m,0,-0.1254452529134633\n,,0,1970-01-02T05:00:00Z,m,0,-0.28449994431236597\n,,0,1970-01-02T06:00:00Z,m,0,0.0689999839384498\n,,0,1970-01-02T07:00:00Z,m,0,0.2001725929207172\n,,0,1970-01-02T08:00:00Z,m,0,-0.3073966769057318\n,,0,1970-01-02T09:00:00Z,m,0,0.4314547819759824\n,,0,1970-01-02T10:00:00Z,m,0,0.027759473391518963\n,,0,1970-01-02T11:00:00Z,m,0,-0.3553761414499085\n,,0,1970-01-02T12:00:00Z,m,0,0.575721833887491\n,,0,1970-01-02T13:00:00Z,m,0,-0.2353619361895265\n,,0,1970-01-02T14:00:00Z,m,0,-0.13197356146872874\n,,0,1970-01-02T15:00:00Z,m,0,-0.3269998433680877\n,,0,1970-01-02T16:00:00Z,m,0,-0.1028401041555228\n,,0,1970-01-02T17:00:00Z,m,0,-0.08813901719692763\n,,0,1970-01-02T18:00:00Z,m,0,0.29156675487410866\n,,0,1970-01-02T19:00:00Z,m,0,-0.11253513851135713\n,,0,1970-01-02T20:00:00Z,m,0,-0.07837446209885049\n,,0,1970-01-02T21:00:00Z,m,0,0.7745428617974516\n,,0,1970-01-02T22:00:00Z,m,0,-0.08227077188180965\n,,0,1970-01-02T23:00:00Z,m,0,-0.06781688706183298\n,,0,1970-01-03T00:00:00Z,m,0,-0.0563606881949511\n,,0,1970-01-03T01:00:00Z,m,0,-0.1519773755698124\n,,0,1970-01-03T02:00:00Z,m,0,-0.12278359056041532\n,,0,1970-01-03T03:00:00Z,m,0,-0.2526779289488099\n,,0,1970-01-03T04:00:00Z,m,0,-0.049273125706920995\n,,0,1970-01-03T05:00:00Z,m,0,0.22598034016946644\n,,0,1970-01-03T06:00:00Z,m,0,-0.2144301007079583\n,,0,1970-01-03T07:00:00Z,m,0,-0.10594757680612822\n,,0,1970-01-03T08:00:00Z,m,0,0.44519306654935276\n,,0,1970-01-03T09:00:00Z,m,0,-0.3978418112634088\n,,0,1970-01-03T10:00:00Z,m,0,-0.027619637863156757\n,,0,1970-01-03T11:00:00Z,m,0,0.8827105986086048\n,,0,1970-01-03T12:00:00Z,m,0,-0.006283556301904358\n,,0,1970-01-03T13:00:00Z,m,0,-0.3151132291144867\n,,0,1970-01-03T14:00:00Z,m,0,-0.10110053824772658\n,,0,1970-01-03T15:00:00Z,m,0,-0.39099619876742636\n,,0,1970-01-03T16:00:00Z,m,0,0.3742087694158019\n,,0,1970-01-03T17:00:00Z,m,0,-0.37235563091902857\n,,0,1970-01-03T18:00:00Z,m,0,-0.10696733020504756\n,,0,1970-01-03T19:00:00Z,m,0,0.42965416496787395\n,,0,1970-01-03T20:00:00Z,m,0,0.26343524983095407\n,,0,1970-01-03T21:00:00Z,m,0,0.23244474704259765\n,,0,1970-01-03T22:00:00Z,m,0,-0.33105518562402303\n,,0,1970-01-03T23:00:00Z,m,0,-0.5327022778949554\n,,0,1970-01-04T00:00:00Z,m,0,0.38789762115788384\n,,0,1970-01-04T01:00:00Z,m,0,0.4153526722985134\n,,0,1970-01-04T02:00:00Z,m,0,-0.08126310475894427\n,,0,1970-01-04T03:00:00Z,m,0,-0.18310409083982693\n,,0,1970-01-04T04:00:00Z,m,0,0.28158128956163186\n,,0,1970-01-04T05:00:00Z,m,0,-0.6585151210302238\n,,0,1970-01-04T06:00:00Z,m,0,0.675316065250243\n,,0,1970-01-04T07:00:00Z,m,0,-0.3040000489524105\n,,0,1970-01-04T08:00:00Z,m,0,0.3598394373926129\n,,0,1970-01-04T09:00:00Z,m,0,-0.3322163045123082\n,,0,1970-01-04T10:00:00Z,m,0,-0.5480579104738514\n,,0,1970-01-04T11:00:00Z,m,0,0.09755179208542454\n,,0,1970-01-04T12:00:00Z,m,0,0.28663602397279697\n,,0,1970-01-04T13:00:00Z,m,0,-0.16932016847816495\n,,0,1970-01-04T14:00:00Z,m,0,-0.1819009884078798\n,,0,1970-01-04T15:00:00Z,m,0,0.23227568714930777\n,,0,1970-01-04T16:00:00Z,m,0,0.5637746412698614\n,,0,1970-01-04T17:00:00Z,m,0,-0.6441684320049655\n,,0,1970-01-04T18:00:00Z,m,0,0.5131153592694276\n,,0,1970-01-04T19:00:00Z,m,0,0.00555905191046957\n,,0,1970-01-04T20:00:00Z,m,0,-0.20743082688414927\n,,0,1970-01-04T21:00:00Z,m,0,-0.05428539069111327\n,,0,1970-01-04T22:00:00Z,m,0,-0.2609503676103645\n,,0,1970-01-04T23:00:00Z,m,0,0.48692644921881756\n,,0,1970-01-05T00:00:00Z,m,0,-0.6383049203475358\n,,0,1970-01-05T01:00:00Z,m,0,0.22967483526158936\n,,0,1970-01-05T02:00:00Z,m,0,0.4809652243201579\n,,0,1970-01-05T03:00:00Z,m,0,-0.5654851773129727\n,,0,1970-01-05T04:00:00Z,m,0,0.300890526989511\n,,0,1970-01-05T05:00:00Z,m,0,-0.30964923778700754\n,,0,1970-01-05T06:00:00Z,m,0,-0.24001405954156793\n,,0,1970-01-05T07:00:00Z,m,0,0.3751654959869245\n,,0,1970-01-05T08:00:00Z,m,0,-0.04259512874562421\n,,0,1970-01-05T09:00:00Z,m,0,0.38042202018009796\n,,0,1970-01-05T10:00:00Z,m,0,-0.5287532464415945\n,,0,1970-01-05T11:00:00Z,m,0,0.5180464247158002\n,,0,1970-01-05T12:00:00Z,m,0,-0.30370008047298586\n,,0,1970-01-05T13:00:00Z,m,0,-0.3924630338517342\n,,0,1970-01-05T14:00:00Z,m,0,0.8589545990310088\n,,0,1970-01-05T15:00:00Z,m,0,-0.2762261980491616\n,,0,1970-01-05T16:00:00Z,m,0,-0.21047877707835977\n,,0,1970-01-05T17:00:00Z,m,0,0.24216865976238228\n,,0,1970-01-05T18:00:00Z,m,0,-0.5614688299606095\n,,0,1970-01-05T19:00:00Z,m,0,0.2575514526240722\n,,0,1970-01-05T20:00:00Z,m,0,0.1179241471897744\n,,0,1970-01-05T21:00:00Z,m,0,-0.3361628168554647\n,,0,1970-01-05T22:00:00Z,m,0,0.12040944503115034\n,,0,1970-01-05T23:00:00Z,m,0,-0.21067541418157384\n,,0,1970-01-06T00:00:00Z,m,0,0.22950296919721283\n,,0,1970-01-06T01:00:00Z,m,0,-0.19960989432895943\n,,0,1970-01-06T02:00:00Z,m,0,0.11950151038334711\n,,0,1970-01-06T03:00:00Z,m,0,0.6621014659327279\n,,0,1970-01-06T04:00:00Z,m,0,0.04645783232682055\n,,0,1970-01-06T05:00:00Z,m,0,-0.1333950395525606\n,,0,1970-01-06T06:00:00Z,m,0,-0.6335471301700871\n,,0,1970-01-06T07:00:00Z,m,0,0.3680105736189194\n,,0,1970-01-06T08:00:00Z,m,0,0.46346471178568727\n,,0,1970-01-06T09:00:00Z,m,0,-0.22538548000666392\n,,0,1970-01-06T10:00:00Z,m,0,-0.2582224009925222\n,,0,1970-01-06T11:00:00Z,m,0,0.05723343383830931\n,,0,1970-01-06T12:00:00Z,m,0,-0.29911879593440893\n,,0,1970-01-06T13:00:00Z,m,0,0.3067817180645308\n,,0,1970-01-06T14:00:00Z,m,0,0.44659916200890304\n,,0,1970-01-06T15:00:00Z,m,0,-0.22214010659417205\n,,0,1970-01-06T16:00:00Z,m,0,-0.3988854591123088\n,,0,1970-01-06T17:00:00Z,m,0,0.605293441798205\n,,0,1970-01-06T18:00:00Z,m,0,-0.6741116131070507\n,,0,1970-01-06T19:00:00Z,m,0,0.058830242678397315\n,,0,1970-01-06T20:00:00Z,m,0,0.09380367932103367\n,,0,1970-01-06T21:00:00Z,m,0,-0.027864236582688606\n,,0,1970-01-06T22:00:00Z,m,0,-0.006230256381503485\n,,0,1970-01-06T23:00:00Z,m,0,-0.11645351690012767\n,,0,1970-01-07T00:00:00Z,m,0,0.361938190450973\n,,0,1970-01-07T01:00:00Z,m,0,-0.11871827549065661\n,,0,1970-01-07T02:00:00Z,m,0,-0.2316148990416534\n,,0,1970-01-07T03:00:00Z,m,0,-0.09276890591382678\n,,0,1970-01-07T04:00:00Z,m,0,-0.19004556864396652\n,,0,1970-01-07T05:00:00Z,m,0,0.1264124902815403\n,,0,1970-01-07T06:00:00Z,m,0,0.4721379367918953\n,,0,1970-01-07T07:00:00Z,m,0,-0.048035150189905895\n,,0,1970-01-07T08:00:00Z,m,0,-0.15533860170659058\n,,0,1970-01-07T09:00:00Z,m,0,-0.35800331717464423\n,,0,1970-01-07T10:00:00Z,m,0,0.021329303353554138\n,,0,1970-01-07T11:00:00Z,m,0,0.8088952248570407\n,,0,1970-01-07T12:00:00Z,m,0,0.0031657745946064297\n,,0,1970-01-07T13:00:00Z,m,0,-0.577499714869756\n,,0,1970-01-07T14:00:00Z,m,0,-0.2690707267848586\n,,0,1970-01-07T15:00:00Z,m,0,0.3096592150363687\n,,0,1970-01-07T16:00:00Z,m,0,0.38608349493111094\n,,0,1970-01-07T17:00:00Z,m,0,-0.29686987145609023\n,,0,1970-01-07T18:00:00Z,m,0,0.04598447931264926\n,,0,1970-01-07T19:00:00Z,m,0,-0.033250555449723884\n,,0,1970-01-07T20:00:00Z,m,0,0.06280888172725052\n,,0,1970-01-07T21:00:00Z,m,0,-0.37853947030352747\n,,0,1970-01-07T22:00:00Z,m,0,0.5289172439573226\n,,0,1970-01-07T23:00:00Z,m,0,0.2244272327998662\n,,1,1970-01-01T01:00:00Z,m,1,0.02909066464577137\n,,1,1970-01-01T02:00:00Z,m,1,0.05159868585263827\n,,1,1970-01-01T03:00:00Z,m,1,0.2620913068445826\n,,1,1970-01-01T04:00:00Z,m,1,0.07132743283908949\n,,1,1970-01-01T05:00:00Z,m,1,-0.18657586747930188\n,,1,1970-01-01T06:00:00Z,m,1,0.012958267800754153\n,,1,1970-01-01T07:00:00Z,m,1,0.18195355785156597\n,,1,1970-01-01T08:00:00Z,m,1,0.043379511132600856\n,,1,1970-01-01T09:00:00Z,m,1,-0.3609192816136414\n,,1,1970-01-01T10:00:00Z,m,1,0.15681229305473693\n,,1,1970-01-01T11:00:00Z,m,1,-0.07720477212329341\n,,1,1970-01-01T12:00:00Z,m,1,-0.08546702820627317\n,,1,1970-01-01T13:00:00Z,m,1,0.7362872669411108\n,,1,1970-01-01T14:00:00Z,m,1,-0.5567449906796225\n,,1,1970-01-01T15:00:00Z,m,1,-0.4038577477762845\n,,1,1970-01-01T16:00:00Z,m,1,0.9665969780665161\n,,1,1970-01-01T17:00:00Z,m,1,-0.015507921385767731\n,,1,1970-01-01T18:00:00Z,m,1,-0.4090956479608955\n,,1,1970-01-01T19:00:00Z,m,1,-0.5484931975036571\n,,1,1970-01-01T20:00:00Z,m,1,0.3244427899168979\n,,1,1970-01-01T21:00:00Z,m,1,-0.18800781896295435\n,,1,1970-01-01T22:00:00Z,m,1,0.6427368911198227\n,,1,1970-01-01T23:00:00Z,m,1,-0.4853326692288338\n,,1,1970-01-02T00:00:00Z,m,1,0.3264624863277259\n,,1,1970-01-02T01:00:00Z,m,1,-0.4996414051387769\n,,1,1970-01-02T02:00:00Z,m,1,0.1445542460084714\n,,1,1970-01-02T03:00:00Z,m,1,0.14480510721359047\n,,1,1970-01-02T04:00:00Z,m,1,0.5378555394085716\n,,1,1970-01-02T05:00:00Z,m,1,-0.8585637635764564\n,,1,1970-01-02T06:00:00Z,m,1,0.3624567474384401\n,,1,1970-01-02T07:00:00Z,m,1,0.44627627634970934\n,,1,1970-01-02T08:00:00Z,m,1,-0.5792204297935727\n,,1,1970-01-02T09:00:00Z,m,1,0.3792733277267841\n,,1,1970-01-02T10:00:00Z,m,1,-0.2613077921906796\n,,1,1970-01-02T11:00:00Z,m,1,0.12578956523680979\n,,1,1970-01-02T12:00:00Z,m,1,-0.13377209523920808\n,,1,1970-01-02T13:00:00Z,m,1,0.39874920412307\n,,1,1970-01-02T14:00:00Z,m,1,-0.7438775809655482\n,,1,1970-01-02T15:00:00Z,m,1,0.5309988026177533\n,,1,1970-01-02T16:00:00Z,m,1,-0.1626325036636812\n,,1,1970-01-02T17:00:00Z,m,1,0.12234819722920887\n,,1,1970-01-02T18:00:00Z,m,1,-0.20321918732123062\n,,1,1970-01-02T19:00:00Z,m,1,-0.016922287227538024\n,,1,1970-01-02T20:00:00Z,m,1,0.23213987811841608\n,,1,1970-01-02T21:00:00Z,m,1,-0.2313266815511934\n,,1,1970-01-02T22:00:00Z,m,1,0.15442949193411526\n,,1,1970-01-02T23:00:00Z,m,1,0.050775730836947086\n,,1,1970-01-03T00:00:00Z,m,1,-0.1601904923385572\n,,1,1970-01-03T01:00:00Z,m,1,0.022776590065983815\n,,1,1970-01-03T02:00:00Z,m,1,0.31383590029410996\n,,1,1970-01-03T03:00:00Z,m,1,-0.4598085179997402\n,,1,1970-01-03T04:00:00Z,m,1,0.25477659526125485\n,,1,1970-01-03T05:00:00Z,m,1,-0.0739554323392253\n,,1,1970-01-03T06:00:00Z,m,1,0.10112927876665034\n,,1,1970-01-03T07:00:00Z,m,1,0.030354277911185057\n,,1,1970-01-03T08:00:00Z,m,1,0.369258139580795\n,,1,1970-01-03T09:00:00Z,m,1,-0.1220604689443201\n,,1,1970-01-03T10:00:00Z,m,1,-0.8165895924368894\n,,1,1970-01-03T11:00:00Z,m,1,0.4714649925874532\n,,1,1970-01-03T12:00:00Z,m,1,-0.14139045598081607\n,,1,1970-01-03T13:00:00Z,m,1,-0.12902899703310686\n,,1,1970-01-03T14:00:00Z,m,1,0.663745686381005\n,,1,1970-01-03T15:00:00Z,m,1,-0.5952506235448074\n,,1,1970-01-03T16:00:00Z,m,1,0.030312315536815404\n,,1,1970-01-03T17:00:00Z,m,1,0.2317274797015456\n,,1,1970-01-03T18:00:00Z,m,1,-0.5472108672567783\n,,1,1970-01-03T19:00:00Z,m,1,0.9046473913293003\n,,1,1970-01-03T20:00:00Z,m,1,-0.13860962340613558\n,,1,1970-01-03T21:00:00Z,m,1,-0.239823337770655\n,,1,1970-01-03T22:00:00Z,m,1,-0.3463086496284618\n,,1,1970-01-03T23:00:00Z,m,1,-0.008972574604808131\n,,1,1970-01-04T00:00:00Z,m,1,0.2524040273983428\n,,1,1970-01-04T01:00:00Z,m,1,-0.0006861380593559119\n,,1,1970-01-04T02:00:00Z,m,1,-0.000126932962539128\n,,1,1970-01-04T03:00:00Z,m,1,0.07835750511218742\n,,1,1970-01-04T04:00:00Z,m,1,-0.23204844928726087\n,,1,1970-01-04T05:00:00Z,m,1,0.22119140540232607\n,,1,1970-01-04T06:00:00Z,m,1,-0.3512695997361519\n,,1,1970-01-04T07:00:00Z,m,1,0.13908962115873594\n,,1,1970-01-04T08:00:00Z,m,1,-0.06910427558529345\n,,1,1970-01-04T09:00:00Z,m,1,-0.1980395055952653\n,,1,1970-01-04T10:00:00Z,m,1,0.3992698016953096\n,,1,1970-01-04T11:00:00Z,m,1,0.4453943707416921\n,,1,1970-01-04T12:00:00Z,m,1,0.022625043955692314\n,,1,1970-01-04T13:00:00Z,m,1,-0.5616450346115054\n,,1,1970-01-04T14:00:00Z,m,1,0.04485791117853494\n,,1,1970-01-04T15:00:00Z,m,1,0.6102765694442316\n,,1,1970-01-04T16:00:00Z,m,1,-0.1384268428609372\n,,1,1970-01-04T17:00:00Z,m,1,-0.7328529387109506\n,,1,1970-01-04T18:00:00Z,m,1,0.54739449815634\n,,1,1970-01-04T19:00:00Z,m,1,-0.20674293979643804\n,,1,1970-01-04T20:00:00Z,m,1,0.4980509021165697\n,,1,1970-01-04T21:00:00Z,m,1,-0.2090386588145987\n,,1,1970-01-04T22:00:00Z,m,1,-0.009274216324850038\n,,1,1970-01-04T23:00:00Z,m,1,-0.06314437566630249\n,,1,1970-01-05T00:00:00Z,m,1,-0.2194258433334671\n,,1,1970-01-05T01:00:00Z,m,1,0.30847461556169203\n,,1,1970-01-05T02:00:00Z,m,1,-0.5150123869432979\n,,1,1970-01-05T03:00:00Z,m,1,0.30126582450728373\n,,1,1970-01-05T04:00:00Z,m,1,-0.37387910557983883\n,,1,1970-01-05T05:00:00Z,m,1,-0.09790995110648555\n,,1,1970-01-05T06:00:00Z,m,1,-0.03782167555753284\n,,1,1970-01-05T07:00:00Z,m,1,0.464824801799248\n,,1,1970-01-05T08:00:00Z,m,1,-0.2483784370022628\n,,1,1970-01-05T09:00:00Z,m,1,0.5918886291905594\n,,1,1970-01-05T10:00:00Z,m,1,-0.8060760635659092\n,,1,1970-01-05T11:00:00Z,m,1,0.6257077703962484\n,,1,1970-01-05T12:00:00Z,m,1,-0.004674384745827598\n,,1,1970-01-05T13:00:00Z,m,1,-0.0003064126422843705\n,,1,1970-01-05T14:00:00Z,m,1,-0.3404175424185952\n,,1,1970-01-05T15:00:00Z,m,1,0.45898758487884034\n,,1,1970-01-05T16:00:00Z,m,1,0.15512315293325551\n,,1,1970-01-05T17:00:00Z,m,1,-0.8882402667132574\n,,1,1970-01-05T18:00:00Z,m,1,0.24879004011081554\n,,1,1970-01-05T19:00:00Z,m,1,-0.1734819058128948\n,,1,1970-01-05T20:00:00Z,m,1,0.3082540490684122\n,,1,1970-01-05T21:00:00Z,m,1,-0.2724359684571728\n,,1,1970-01-05T22:00:00Z,m,1,0.011784872578827432\n,,1,1970-01-05T23:00:00Z,m,1,0.19189080075398407\n,,1,1970-01-06T00:00:00Z,m,1,0.4010692090163104\n,,1,1970-01-06T01:00:00Z,m,1,-0.3974927591472375\n,,1,1970-01-06T02:00:00Z,m,1,0.5549536703053173\n,,1,1970-01-06T03:00:00Z,m,1,-0.060007745100103094\n,,1,1970-01-06T04:00:00Z,m,1,-0.818834026213009\n,,1,1970-01-06T05:00:00Z,m,1,0.30644732156601706\n,,1,1970-01-06T06:00:00Z,m,1,0.5466876889235377\n,,1,1970-01-06T07:00:00Z,m,1,-0.4487656554442424\n,,1,1970-01-06T08:00:00Z,m,1,0.06697200564618833\n,,1,1970-01-06T09:00:00Z,m,1,-0.019727583277435956\n,,1,1970-01-06T10:00:00Z,m,1,0.2785143808725318\n,,1,1970-01-06T11:00:00Z,m,1,-0.5721126504527568\n,,1,1970-01-06T12:00:00Z,m,1,-0.07797445220765423\n,,1,1970-01-06T13:00:00Z,m,1,0.5415176275149132\n,,1,1970-01-06T14:00:00Z,m,1,-0.1445515797425707\n,,1,1970-01-06T15:00:00Z,m,1,-0.2500652415619768\n,,1,1970-01-06T16:00:00Z,m,1,0.5608616065849172\n,,1,1970-01-06T17:00:00Z,m,1,-0.7306403933278911\n,,1,1970-01-06T18:00:00Z,m,1,0.054693268726029295\n,,1,1970-01-06T19:00:00Z,m,1,0.5980474067387233\n,,1,1970-01-06T20:00:00Z,m,1,0.14368604611073088\n,,1,1970-01-06T21:00:00Z,m,1,0.024831823459466107\n,,1,1970-01-06T22:00:00Z,m,1,-0.15899787074014582\n,,1,1970-01-06T23:00:00Z,m,1,-0.19778745612321147\n,,1,1970-01-07T00:00:00Z,m,1,0.2605104623709601\n,,1,1970-01-07T01:00:00Z,m,1,-0.24798456934381652\n,,1,1970-01-07T02:00:00Z,m,1,-0.02413169404236115\n,,1,1970-01-07T03:00:00Z,m,1,0.2850223923198476\n,,1,1970-01-07T04:00:00Z,m,1,-0.4533907284450288\n,,1,1970-01-07T05:00:00Z,m,1,-0.07631427012911585\n,,1,1970-01-07T06:00:00Z,m,1,0.06614318244779838\n,,1,1970-01-07T07:00:00Z,m,1,-0.34231345077450664\n,,1,1970-01-07T08:00:00Z,m,1,0.4749989855676307\n,,1,1970-01-07T09:00:00Z,m,1,-0.4400603107103018\n,,1,1970-01-07T10:00:00Z,m,1,0.08744582080929783\n,,1,1970-01-07T11:00:00Z,m,1,0.6911673740571932\n,,1,1970-01-07T12:00:00Z,m,1,-0.1416643419909407\n,,1,1970-01-07T13:00:00Z,m,1,-0.3020857474445764\n,,1,1970-01-07T14:00:00Z,m,1,0.13211207295926208\n,,1,1970-01-07T15:00:00Z,m,1,0.33436238731583623\n,,1,1970-01-07T16:00:00Z,m,1,0.08170793142825539\n,,1,1970-01-07T17:00:00Z,m,1,-0.4362527652716799\n,,1,1970-01-07T18:00:00Z,m,1,-0.5078189070762902\n,,1,1970-01-07T19:00:00Z,m,1,0.7027125984921005\n,,1,1970-01-07T20:00:00Z,m,1,0.11376676392370555\n,,1,1970-01-07T21:00:00Z,m,1,-0.4422745858695098\n,,1,1970-01-07T22:00:00Z,m,1,0.15894641183358554\n,,1,1970-01-07T23:00:00Z,m,1,0.16068490698806603\n\"\n\n// SELECT difference(f) FROM m GROUP BY *\nt_difference = (tables=<-) => tables\n\t|> range(start: influxql.minTime, stop: influxql.maxTime)\n\t|> filter(fn: (r) => r._measurement == \"m\")\n\t|> filter(fn: (r) => r._field == \"f\")\n\t|> difference()\n\t|> drop(columns: [\"_start\", \"_stop\", \"_field\"])\n\t|> rename(columns: {_value: \"difference\"})\n\ntest _difference = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_difference,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   347,
					},
					File:   "series_agg_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01:00:00Z,m,1,f,0.4423826236661577\n,,1,1970-01-03T02:00:00Z,m,1,f,0.7562185239602677\n,,1,1970-01-03T03:00:00Z,m,1,f,0.29641000596052747\n,,1,1970-01-03T04:00:00Z,m,1,f,0.5511866012217823\n,,1,1970-01-03T05:00:00Z,m,1,f,0.477231168882557\n,,1,1970-01-03T06:00:00Z,m,1,f,0.5783604476492074\n,,1,1970-01-03T07:00:00Z,m,1,f,0.6087147255603924\n,,1,1970-01-03T08:00:00Z,m,1,f,0.9779728651411874\n,,1,1970-01-03T09:00:00Z,m,1,f,0.8559123961968673\n,,1,1970-01-03T10:00:00Z,m,1,f,0.039322803759977897\n,,1,1970-01-03T11:00:00Z,m,1,f,0.5107877963474311\n,,1,1970-01-03T12:00:00Z,m,1,f,0.36939734036661503\n,,1,1970-01-03T13:00:00Z,m,1,f,0.24036834333350818\n,,1,1970-01-03T14:00:00Z,m,1,f,0.9041140297145132\n,,1,1970-01-03T15:00:00Z,m,1,f,0.3088634061697057\n,,1,1970-01-03T16:00:00Z,m,1,f,0.3391757217065211\n,,1,1970-01-03T17:00:00Z,m,1,f,0.5709032014080667\n,,1,1970-01-03T18:00:00Z,m,1,f,0.023692334151288443\n,,1,1970-01-03T19:00:00Z,m,1,f,0.9283397254805887\n,,1,1970-01-03T20:00:00Z,m,1,f,0.7897301020744532\n,,1,1970-01-03T21:00:00Z,m,1,f,0.5499067643037981\n,,1,1970-01-03T22:00:00Z,m,1,f,0.20359811467533634\n,,1,1970-01-03T23:00:00Z,m,1,f,0.1946255400705282\n,,1,1970-01-04T00:00:00Z,m,1,f,0.44702956746887096\n,,1,1970-01-04T01:00:00Z,m,1,f,0.44634342940951505\n,,1,1970-01-04T02:00:00Z,m,1,f,0.4462164964469759\n,,1,1970-01-04T03:00:00Z,m,1,f,0.5245740015591633\n,,1,1970-01-04T04:00:00Z,m,1,f,0.29252555227190247\n,,1,1970-01-04T05:00:00Z,m,1,f,0.5137169576742285\n,,1,1970-01-04T06:00:00Z,m,1,f,0.1624473579380766\n,,1,1970-01-04T07:00:00Z,m,1,f,0.30153697909681254\n,,1,1970-01-04T08:00:00Z,m,1,f,0.2324327035115191\n,,1,1970-01-04T09:00:00Z,m,1,f,0.034393197916253775\n,,1,1970-01-04T10:00:00Z,m,1,f,0.4336629996115634\n,,1,1970-01-04T11:00:00Z,m,1,f,0.8790573703532555\n,,1,1970-01-04T12:00:00Z,m,1,f,0.9016824143089478\n,,1,1970-01-04T13:00:00Z,m,1,f,0.34003737969744235\n,,1,1970-01-04T14:00:00Z,m,1,f,0.3848952908759773\n,,1,1970-01-04T15:00:00Z,m,1,f,0.9951718603202089\n,,1,1970-01-04T16:00:00Z,m,1,f,0.8567450174592717\n,,1,1970-01-04T17:00:00Z,m,1,f,0.12389207874832112\n,,1,1970-01-04T18:00:00Z,m,1,f,0.6712865769046611\n,,1,1970-01-04T19:00:00Z,m,1,f,0.46454363710822305\n,,1,1970-01-04T20:00:00Z,m,1,f,0.9625945392247928\n,,1,1970-01-04T21:00:00Z,m,1,f,0.7535558804101941\n,,1,1970-01-04T22:00:00Z,m,1,f,0.744281664085344\n,,1,1970-01-04T23:00:00Z,m,1,f,0.6811372884190415\n,,1,1970-01-05T00:00:00Z,m,1,f,0.46171144508557443\n,,1,1970-01-05T01:00:00Z,m,1,f,0.7701860606472665\n,,1,1970-01-05T02:00:00Z,m,1,f,0.25517367370396854\n,,1,1970-01-05T03:00:00Z,m,1,f,0.5564394982112523\n,,1,1970-01-05T04:00:00Z,m,1,f,0.18256039263141344\n,,1,1970-01-05T05:00:00Z,m,1,f,0.08465044152492789\n,,1,1970-01-05T06:00:00Z,m,1,f,0.04682876596739505\n,,1,1970-01-05T07:00:00Z,m,1,f,0.5116535677666431\n,,1,1970-01-05T08:00:00Z,m,1,f,0.26327513076438025\n,,1,1970-01-05T09:00:00Z,m,1,f,0.8551637599549397\n,,1,1970-01-05T10:00:00Z,m,1,f,0.04908769638903045\n,,1,1970-01-05T11:00:00Z,m,1,f,0.6747954667852788\n,,1,1970-01-05T12:00:00Z,m,1,f,0.6701210820394512\n,,1,1970-01-05T13:00:00Z,m,1,f,0.6698146693971668\n,,1,1970-01-05T14:00:00Z,m,1,f,0.32939712697857165\n,,1,1970-01-05T15:00:00Z,m,1,f,0.788384711857412\n,,1,1970-01-05T16:00:00Z,m,1,f,0.9435078647906675\n,,1,1970-01-05T17:00:00Z,m,1,f,0.05526759807741008\n,,1,1970-01-05T18:00:00Z,m,1,f,0.3040576381882256\n,,1,1970-01-05T19:00:00Z,m,1,f,0.13057573237533082\n,,1,1970-01-05T20:00:00Z,m,1,f,0.438829781443743\n,,1,1970-01-05T21:00:00Z,m,1,f,0.16639381298657024\n,,1,1970-01-05T22:00:00Z,m,1,f,0.17817868556539768\n,,1,1970-01-05T23:00:00Z,m,1,f,0.37006948631938175\n,,1,1970-01-06T00:00:00Z,m,1,f,0.7711386953356921\n,,1,1970-01-06T01:00:00Z,m,1,f,0.37364593618845465\n,,1,1970-01-06T02:00:00Z,m,1,f,0.9285996064937719\n,,1,1970-01-06T03:00:00Z,m,1,f,0.8685918613936688\n,,1,1970-01-06T04:00:00Z,m,1,f,0.049757835180659744\n,,1,1970-01-06T05:00:00Z,m,1,f,0.3562051567466768\n,,1,1970-01-06T06:00:00Z,m,1,f,0.9028928456702144\n,,1,1970-01-06T07:00:00Z,m,1,f,0.45412719022597203\n,,1,1970-01-06T08:00:00Z,m,1,f,0.5210991958721604\n,,1,1970-01-06T09:00:00Z,m,1,f,0.5013716125947244\n,,1,1970-01-06T10:00:00Z,m,1,f,0.7798859934672562\n,,1,1970-01-06T11:00:00Z,m,1,f,0.20777334301449937\n,,1,1970-01-06T12:00:00Z,m,1,f,0.12979889080684515\n,,1,1970-01-06T13:00:00Z,m,1,f,0.6713165183217583\n,,1,1970-01-06T14:00:00Z,m,1,f,0.5267649385791876\n,,1,1970-01-06T15:00:00Z,m,1,f,0.2766996970172108\n,,1,1970-01-06T16:00:00Z,m,1,f,0.837561303602128\n,,1,1970-01-06T17:00:00Z,m,1,f,0.10692091027423688\n,,1,1970-01-06T18:00:00Z,m,1,f,0.16161417900026617\n,,1,1970-01-06T19:00:00Z,m,1,f,0.7596615857389895\n,,1,1970-01-06T20:00:00Z,m,1,f,0.9033476318497203\n,,1,1970-01-06T21:00:00Z,m,1,f,0.9281794553091864\n,,1,1970-01-06T22:00:00Z,m,1,f,0.7691815845690406\n,,1,1970-01-06T23:00:00Z,m,1,f,0.5713941284458292\n,,1,1970-01-07T00:00:00Z,m,1,f,0.8319045908167892\n,,1,1970-01-07T01:00:00Z,m,1,f,0.5839200214729727\n,,1,1970-01-07T02:00:00Z,m,1,f,0.5597883274306116\n,,1,1970-01-07T03:00:00Z,m,1,f,0.8448107197504592\n,,1,1970-01-07T04:00:00Z,m,1,f,0.39141999130543037\n,,1,1970-01-07T05:00:00Z,m,1,f,0.3151057211763145\n,,1,1970-01-07T06:00:00Z,m,1,f,0.3812489036241129\n,,1,1970-01-07T07:00:00Z,m,1,f,0.03893545284960627\n,,1,1970-01-07T08:00:00Z,m,1,f,0.513934438417237\n,,1,1970-01-07T09:00:00Z,m,1,f,0.07387412770693513\n,,1,1970-01-07T10:00:00Z,m,1,f,0.16131994851623296\n,,1,1970-01-07T11:00:00Z,m,1,f,0.8524873225734262\n,,1,1970-01-07T12:00:00Z,m,1,f,0.7108229805824855\n,,1,1970-01-07T13:00:00Z,m,1,f,0.4087372331379091\n,,1,1970-01-07T14:00:00Z,m,1,f,0.5408493060971712\n,,1,1970-01-07T15:00:00Z,m,1,f,0.8752116934130074\n,,1,1970-01-07T16:00:00Z,m,1,f,0.9569196248412628\n,,1,1970-01-07T17:00:00Z,m,1,f,0.5206668595695829\n,,1,1970-01-07T18:00:00Z,m,1,f,0.012847952493292788\n,,1,1970-01-07T19:00:00Z,m,1,f,0.7155605509853933\n,,1,1970-01-07T20:00:00Z,m,1,f,0.8293273149090988\n,,1,1970-01-07T21:00:00Z,m,1,f,0.38705272903958904\n,,1,1970-01-07T22:00:00Z,m,1,f,0.5459991408731746\n,,1,1970-01-07T23:00:00Z,m,1,f,0.7066840478612406\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "series_agg_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   347,
						},
						File:   "series_agg_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,0,,,,,,\n,result,table,_time,_measurement,t0,_field,_value\n,,0,1970-01-01T00:00:00Z,m,0,f,0.19434194999233168\n,,0,1970-01-01T01:00:00Z,m,0,f,0.35586976154169886\n,,0,1970-01-01T02:00:00Z,m,0,f,0.9008931119054228\n,,0,1970-01-01T03:00:00Z,m,0,f,0.6461505985646413\n,,0,1970-01-01T04:00:00Z,m,0,f,0.1340222613556339\n,,0,1970-01-01T05:00:00Z,m,0,f,0.3050922896043849\n,,0,1970-01-01T06:00:00Z,m,0,f,0.16797790004756785\n,,0,1970-01-01T07:00:00Z,m,0,f,0.6859900761088404\n,,0,1970-01-01T08:00:00Z,m,0,f,0.3813372334346726\n,,0,1970-01-01T09:00:00Z,m,0,f,0.37739800802050527\n,,0,1970-01-01T10:00:00Z,m,0,f,0.2670215125945959\n,,0,1970-01-01T11:00:00Z,m,0,f,0.19857273235709308\n,,0,1970-01-01T12:00:00Z,m,0,f,0.7926413090714327\n,,0,1970-01-01T13:00:00Z,m,0,f,0.8488436313118317\n,,0,1970-01-01T14:00:00Z,m,0,f,0.1960293435787179\n,,0,1970-01-01T15:00:00Z,m,0,f,0.27204741679052236\n,,0,1970-01-01T16:00:00Z,m,0,f,0.6045056499409555\n,,0,1970-01-01T17:00:00Z,m,0,f,0.21508343480255984\n,,0,1970-01-01T18:00:00Z,m,0,f,0.2712545253017199\n,,0,1970-01-01T19:00:00Z,m,0,f,0.22728191431845607\n,,0,1970-01-01T20:00:00Z,m,0,f,0.8232481787306024\n,,0,1970-01-01T21:00:00Z,m,0,f,0.9722054606060748\n,,0,1970-01-01T22:00:00Z,m,0,f,0.9332942983017809\n,,0,1970-01-01T23:00:00Z,m,0,f,0.009704805042322441\n,,0,1970-01-02T00:00:00Z,m,0,f,0.4614776151185129\n,,0,1970-01-02T01:00:00Z,m,0,f,0.3972854143424396\n,,0,1970-01-02T02:00:00Z,m,0,f,0.024157782439736365\n,,0,1970-01-02T03:00:00Z,m,0,f,0.7074351703076142\n,,0,1970-01-02T04:00:00Z,m,0,f,0.5819899173941508\n,,0,1970-01-02T05:00:00Z,m,0,f,0.2974899730817849\n,,0,1970-01-02T06:00:00Z,m,0,f,0.3664899570202347\n,,0,1970-01-02T07:00:00Z,m,0,f,0.5666625499409519\n,,0,1970-01-02T08:00:00Z,m,0,f,0.2592658730352201\n,,0,1970-01-02T09:00:00Z,m,0,f,0.6907206550112025\n,,0,1970-01-02T10:00:00Z,m,0,f,0.7184801284027215\n,,0,1970-01-02T11:00:00Z,m,0,f,0.363103986952813\n,,0,1970-01-02T12:00:00Z,m,0,f,0.938825820840304\n,,0,1970-01-02T13:00:00Z,m,0,f,0.7034638846507775\n,,0,1970-01-02T14:00:00Z,m,0,f,0.5714903231820487\n,,0,1970-01-02T15:00:00Z,m,0,f,0.24449047981396105\n,,0,1970-01-02T16:00:00Z,m,0,f,0.14165037565843824\n,,0,1970-01-02T17:00:00Z,m,0,f,0.05351135846151062\n,,0,1970-01-02T18:00:00Z,m,0,f,0.3450781133356193\n,,0,1970-01-02T19:00:00Z,m,0,f,0.23254297482426214\n,,0,1970-01-02T20:00:00Z,m,0,f,0.15416851272541165\n,,0,1970-01-02T21:00:00Z,m,0,f,0.9287113745228632\n,,0,1970-01-02T22:00:00Z,m,0,f,0.8464406026410536\n,,0,1970-01-02T23:00:00Z,m,0,f,0.7786237155792206\n,,0,1970-01-03T00:00:00Z,m,0,f,0.7222630273842695\n,,0,1970-01-03T01:00:00Z,m,0,f,0.5702856518144571\n,,0,1970-01-03T02:00:00Z,m,0,f,0.4475020612540418\n,,0,1970-01-03T03:00:00Z,m,0,f,0.19482413230523188\n,,0,1970-01-03T04:00:00Z,m,0,f,0.14555100659831088\n,,0,1970-01-03T05:00:00Z,m,0,f,0.3715313467677773\n,,0,1970-01-03T06:00:00Z,m,0,f,0.15710124605981904\n,,0,1970-01-03T07:00:00Z,m,0,f,0.05115366925369082\n,,0,1970-01-03T08:00:00Z,m,0,f,0.49634673580304356\n,,0,1970-01-03T09:00:00Z,m,0,f,0.09850492453963475\n,,0,1970-01-03T10:00:00Z,m,0,f,0.07088528667647799\n,,0,1970-01-03T11:00:00Z,m,0,f,0.9535958852850828\n,,0,1970-01-03T12:00:00Z,m,0,f,0.9473123289831784\n,,0,1970-01-03T13:00:00Z,m,0,f,0.6321990998686917\n,,0,1970-01-03T14:00:00Z,m,0,f,0.5310985616209651\n,,0,1970-01-03T15:00:00Z,m,0,f,0.14010236285353878\n,,0,1970-01-03T16:00:00Z,m,0,f,0.5143111322693407\n,,0,1970-01-03T17:00:00Z,m,0,f,0.1419555013503121\n,,0,1970-01-03T18:00:00Z,m,0,f,0.034988171145264535\n,,0,1970-01-03T19:00:00Z,m,0,f,0.4646423361131385\n,,0,1970-01-03T20:00:00Z,m,0,f,0.7280775859440926\n,,0,1970-01-03T21:00:00Z,m,0,f,0.9605223329866902\n,,0,1970-01-03T22:00:00Z,m,0,f,0.6294671473626672\n,,0,1970-01-03T23:00:00Z,m,0,f,0.09676486946771183\n,,0,1970-01-04T00:00:00Z,m,0,f,0.4846624906255957\n,,0,1970-01-04T01:00:00Z,m,0,f,0.9000151629241091\n,,0,1970-01-04T02:00:00Z,m,0,f,0.8187520581651648\n,,0,1970-01-04T03:00:00Z,m,0,f,0.6356479673253379\n,,0,1970-01-04T04:00:00Z,m,0,f,0.9172292568869698\n,,0,1970-01-04T05:00:00Z,m,0,f,0.25871413585674596\n,,0,1970-01-04T06:00:00Z,m,0,f,0.934030201106989\n,,0,1970-01-04T07:00:00Z,m,0,f,0.6300301521545785\n,,0,1970-01-04T08:00:00Z,m,0,f,0.9898695895471914\n,,0,1970-01-04T09:00:00Z,m,0,f,0.6576532850348832\n,,0,1970-01-04T10:00:00Z,m,0,f,0.1095953745610317\n,,0,1970-01-04T11:00:00Z,m,0,f,0.20714716664645624\n,,0,1970-01-04T12:00:00Z,m,0,f,0.49378319061925324\n,,0,1970-01-04T13:00:00Z,m,0,f,0.3244630221410883\n,,0,1970-01-04T14:00:00Z,m,0,f,0.1425620337332085\n,,0,1970-01-04T15:00:00Z,m,0,f,0.37483772088251627\n,,0,1970-01-04T16:00:00Z,m,0,f,0.9386123621523778\n,,0,1970-01-04T17:00:00Z,m,0,f,0.2944439301474122\n,,0,1970-01-04T18:00:00Z,m,0,f,0.8075592894168399\n,,0,1970-01-04T19:00:00Z,m,0,f,0.8131183413273094\n,,0,1970-01-04T20:00:00Z,m,0,f,0.6056875144431602\n,,0,1970-01-04T21:00:00Z,m,0,f,0.5514021237520469\n,,0,1970-01-04T22:00:00Z,m,0,f,0.2904517561416824\n,,0,1970-01-04T23:00:00Z,m,0,f,0.7773782053605\n,,0,1970-01-05T00:00:00Z,m,0,f,0.1390732850129641\n,,0,1970-01-05T01:00:00Z,m,0,f,0.36874812027455345\n,,0,1970-01-05T02:00:00Z,m,0,f,0.8497133445947114\n,,0,1970-01-05T03:00:00Z,m,0,f,0.2842281672817387\n,,0,1970-01-05T04:00:00Z,m,0,f,0.5851186942712497\n,,0,1970-01-05T05:00:00Z,m,0,f,0.2754694564842422\n,,0,1970-01-05T06:00:00Z,m,0,f,0.03545539694267428\n,,0,1970-01-05T07:00:00Z,m,0,f,0.4106208929295988\n,,0,1970-01-05T08:00:00Z,m,0,f,0.3680257641839746\n,,0,1970-01-05T09:00:00Z,m,0,f,0.7484477843640726\n,,0,1970-01-05T10:00:00Z,m,0,f,0.2196945379224781\n,,0,1970-01-05T11:00:00Z,m,0,f,0.7377409626382783\n,,0,1970-01-05T12:00:00Z,m,0,f,0.4340408821652924\n,,0,1970-01-05T13:00:00Z,m,0,f,0.04157784831355819\n,,0,1970-01-05T14:00:00Z,m,0,f,0.9005324473445669\n,,0,1970-01-05T15:00:00Z,m,0,f,0.6243062492954053\n,,0,1970-01-05T16:00:00Z,m,0,f,0.4138274722170456\n,,0,1970-01-05T17:00:00Z,m,0,f,0.6559961319794279\n,,0,1970-01-05T18:00:00Z,m,0,f,0.09452730201881836\n,,0,1970-01-05T19:00:00Z,m,0,f,0.35207875464289057\n,,0,1970-01-05T20:00:00Z,m,0,f,0.47000290183266497\n,,0,1970-01-05T21:00:00Z,m,0,f,0.13384008497720026\n,,0,1970-01-05T22:00:00Z,m,0,f,0.2542495300083506\n,,0,1970-01-05T23:00:00Z,m,0,f,0.04357411582677676\n,,0,1970-01-06T00:00:00Z,m,0,f,0.2730770850239896\n,,0,1970-01-06T01:00:00Z,m,0,f,0.07346719069503016\n,,0,1970-01-06T02:00:00Z,m,0,f,0.19296870107837727\n,,0,1970-01-06T03:00:00Z,m,0,f,0.8550701670111052\n,,0,1970-01-06T04:00:00Z,m,0,f,0.9015279993379257\n,,0,1970-01-06T05:00:00Z,m,0,f,0.7681329597853651\n,,0,1970-01-06T06:00:00Z,m,0,f,0.13458582961527799\n,,0,1970-01-06T07:00:00Z,m,0,f,0.5025964032341974\n,,0,1970-01-06T08:00:00Z,m,0,f,0.9660611150198847\n,,0,1970-01-06T09:00:00Z,m,0,f,0.7406756350132208\n,,0,1970-01-06T10:00:00Z,m,0,f,0.48245323402069856\n,,0,1970-01-06T11:00:00Z,m,0,f,0.5396866678590079\n,,0,1970-01-06T12:00:00Z,m,0,f,0.24056787192459894\n,,0,1970-01-06T13:00:00Z,m,0,f,0.5473495899891297\n,,0,1970-01-06T14:00:00Z,m,0,f,0.9939487519980328\n,,0,1970-01-06T15:00:00Z,m,0,f,0.7718086454038607\n,,0,1970-01-06T16:00:00Z,m,0,f,0.3729231862915519\n,,0,1970-01-06T17:00:00Z,m,0,f,0.978216628089757\n,,0,1970-01-06T18:00:00Z,m,0,f,0.30410501498270626\n,,0,1970-01-06T19:00:00Z,m,0,f,0.36293525766110357\n,,0,1970-01-06T20:00:00Z,m,0,f,0.45673893698213724\n,,0,1970-01-06T21:00:00Z,m,0,f,0.42887470039944864\n,,0,1970-01-06T22:00:00Z,m,0,f,0.42264444401794515\n,,0,1970-01-06T23:00:00Z,m,0,f,0.3061909271178175\n,,0,1970-01-07T00:00:00Z,m,0,f,0.6681291175687905\n,,0,1970-01-07T01:00:00Z,m,0,f,0.5494108420781338\n,,0,1970-01-07T02:00:00Z,m,0,f,0.31779594303648045\n,,0,1970-01-07T03:00:00Z,m,0,f,0.22502703712265368\n,,0,1970-01-07T04:00:00Z,m,0,f,0.03498146847868716\n,,0,1970-01-07T05:00:00Z,m,0,f,0.16139395876022747\n,,0,1970-01-07T06:00:00Z,m,0,f,0.6335318955521227\n,,0,1970-01-07T07:00:00Z,m,0,f,0.5854967453622169\n,,0,1970-01-07T08:00:00Z,m,0,f,0.43015814365562627\n,,0,1970-01-07T09:00:00Z,m,0,f,0.07215482648098204\n,,0,1970-01-07T10:00:00Z,m,0,f,0.09348412983453618\n,,0,1970-01-07T11:00:00Z,m,0,f,0.9023793546915768\n,,0,1970-01-07T12:00:00Z,m,0,f,0.9055451292861832\n,,0,1970-01-07T13:00:00Z,m,0,f,0.3280454144164272\n,,0,1970-01-07T14:00:00Z,m,0,f,0.05897468763156862\n,,0,1970-01-07T15:00:00Z,m,0,f,0.3686339026679373\n,,0,1970-01-07T16:00:00Z,m,0,f,0.7547173975990482\n,,0,1970-01-07T17:00:00Z,m,0,f,0.457847526142958\n,,0,1970-01-07T18:00:00Z,m,0,f,0.5038320054556072\n,,0,1970-01-07T19:00:00Z,m,0,f,0.47058145000588336\n,,0,1970-01-07T20:00:00Z,m,0,f,0.5333903317331339\n,,0,1970-01-07T21:00:00Z,m,0,f,0.1548508614296064\n,,0,1970-01-07T22:00:00Z,m,0,f,0.6837681053869291\n,,0,1970-01-07T23:00:00Z,m,0,f,0.9081953381867953\n,,1,1970-01-01T00:00:00Z,m,1,f,0.15129694889144107\n,,1,1970-01-01T01:00:00Z,m,1,f,0.18038761353721244\n,,1,1970-01-01T02:00:00Z,m,1,f,0.23198629938985071\n,,1,1970-01-01T03:00:00Z,m,1,f,0.4940776062344333\n,,1,1970-01-01T04:00:00Z,m,1,f,0.5654050390735228\n,,1,1970-01-01T05:00:00Z,m,1,f,0.3788291715942209\n,,1,1970-01-01T06:00:00Z,m,1,f,0.39178743939497507\n,,1,1970-01-01T07:00:00Z,m,1,f,0.573740997246541\n,,1,1970-01-01T08:00:00Z,m,1,f,0.6171205083791419\n,,1,1970-01-01T09:00:00Z,m,1,f,0.2562012267655005\n,,1,1970-01-01T10:00:00Z,m,1,f,0.41301351982023743\n,,1,1970-01-01T11:00:00Z,m,1,f,0.335808747696944\n,,1,1970-01-01T12:00:00Z,m,1,f,0.25034171949067086\n,,1,1970-01-01T13:00:00Z,m,1,f,0.9866289864317817\n,,1,1970-01-01T14:00:00Z,m,1,f,0.42988399575215924\n,,1,1970-01-01T15:00:00Z,m,1,f,0.02602624797587471\n,,1,1970-01-01T16:00:00Z,m,1,f,0.9926232260423908\n,,1,1970-01-01T17:00:00Z,m,1,f,0.9771153046566231\n,,1,1970-01-01T18:00:00Z,m,1,f,0.5680196566957276\n,,1,1970-01-01T19:00:00Z,m,1,f,0.01952645919207055\n,,1,1970-01-01T20:00:00Z,m,1,f,0.3439692491089684\n,,1,1970-01-01T21:00:00Z,m,1,f,0.15596143014601407\n,,1,1970-01-01T22:00:00Z,m,1,f,0.7986983212658367\n,,1,1970-01-01T23:00:00Z,m,1,f,0.31336565203700295\n,,1,1970-01-02T00:00:00Z,m,1,f,0.6398281383647288\n,,1,1970-01-02T01:00:00Z,m,1,f,0.14018673322595193\n,,1,1970-01-02T02:00:00Z,m,1,f,0.2847409792344233\n,,1,1970-01-02T03:00:00Z,m,1,f,0.4295460864480138\n,,1,1970-01-02T04:00:00Z,m,1,f,0.9674016258565854\n,,1,1970-01-02T05:00:00Z,m,1,f,0.108837862280129\n,,1,1970-01-02T06:00:00Z,m,1,f,0.47129460971856907\n,,1,1970-01-02T07:00:00Z,m,1,f,0.9175708860682784\n,,1,1970-01-02T08:00:00Z,m,1,f,0.3383504562747057\n,,1,1970-01-02T09:00:00Z,m,1,f,0.7176237840014899\n,,1,1970-01-02T10:00:00Z,m,1,f,0.45631599181081023\n,,1,1970-01-02T11:00:00Z,m,1,f,0.58210555704762\n,,1,1970-01-02T12:00:00Z,m,1,f,0.44833346180841194\n,,1,1970-01-02T13:00:00Z,m,1,f,0.847082665931482\n,,1,1970-01-02T14:00:00Z,m,1,f,0.1032050849659337\n,,1,1970-01-02T15:00:00Z,m,1,f,0.6342038875836871\n,,1,1970-01-02T16:00:00Z,m,1,f,0.47157138392000586\n,,1,1970-01-02T17:00:00Z,m,1,f,0.5939195811492147\n,,1,1970-01-02T18:00:00Z,m,1,f,0.3907003938279841\n,,1,1970-01-02T19:00:00Z,m,1,f,0.3737781066004461\n,,1,1970-01-02T20:00:00Z,m,1,f,0.6059179847188622\n,,1,1970-01-02T21:00:00Z,m,1,f,0.37459130316766875\n,,1,1970-01-02T22:00:00Z,m,1,f,0.529020795101784\n,,1,1970-01-02T23:00:00Z,m,1,f,0.5797965259387311\n,,1,1970-01-03T00:00:00Z,m,1,f,0.4196060336001739\n,,1,1970-01-03T01