// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: frontend.proto

// Protobuf package should not be changed when moving around go packages
// in order to not break backward compatibility.

package frontendv1pb

import (
	context "context"
	fmt "fmt"
	stats "github.com/cortexproject/cortex/pkg/querier/stats"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	httpgrpc "github.com/weaveworks/common/httpgrpc"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Type int32

const (
	HTTP_REQUEST Type = 0
	GET_ID       Type = 1
)

var Type_name = map[int32]string{
	0: "HTTP_REQUEST",
	1: "GET_ID",
}

var Type_value = map[string]int32{
	"HTTP_REQUEST": 0,
	"GET_ID":       1,
}

func (Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{0}
}

type FrontendToClient struct {
	HttpRequest *httpgrpc.HTTPRequest `protobuf:"bytes,1,opt,name=httpRequest,proto3" json:"httpRequest,omitempty"`
	Type        Type                  `protobuf:"varint,2,opt,name=type,proto3,enum=frontend.Type" json:"type,omitempty"`
	// Whether query statistics tracking should be enabled. The response will include
	// statistics only when this option is enabled.
	StatsEnabled bool `protobuf:"varint,3,opt,name=statsEnabled,proto3" json:"statsEnabled,omitempty"`
}

func (m *FrontendToClient) Reset()      { *m = FrontendToClient{} }
func (*FrontendToClient) ProtoMessage() {}
func (*FrontendToClient) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{0}
}
func (m *FrontendToClient) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FrontendToClient) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FrontendToClient.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FrontendToClient) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FrontendToClient.Merge(m, src)
}
func (m *FrontendToClient) XXX_Size() int {
	return m.Size()
}
func (m *FrontendToClient) XXX_DiscardUnknown() {
	xxx_messageInfo_FrontendToClient.DiscardUnknown(m)
}

var xxx_messageInfo_FrontendToClient proto.InternalMessageInfo

func (m *FrontendToClient) GetHttpRequest() *httpgrpc.HTTPRequest {
	if m != nil {
		return m.HttpRequest
	}
	return nil
}

func (m *FrontendToClient) GetType() Type {
	if m != nil {
		return m.Type
	}
	return HTTP_REQUEST
}

func (m *FrontendToClient) GetStatsEnabled() bool {
	if m != nil {
		return m.StatsEnabled
	}
	return false
}

type ClientToFrontend struct {
	HttpResponse *httpgrpc.HTTPResponse `protobuf:"bytes,1,opt,name=httpResponse,proto3" json:"httpResponse,omitempty"`
	ClientID     string                 `protobuf:"bytes,2,opt,name=clientID,proto3" json:"clientID,omitempty"`
	Stats        *stats.Stats           `protobuf:"bytes,3,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (m *ClientToFrontend) Reset()      { *m = ClientToFrontend{} }
func (*ClientToFrontend) ProtoMessage() {}
func (*ClientToFrontend) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{1}
}
func (m *ClientToFrontend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClientToFrontend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClientToFrontend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClientToFrontend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientToFrontend.Merge(m, src)
}
func (m *ClientToFrontend) XXX_Size() int {
	return m.Size()
}
func (m *ClientToFrontend) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientToFrontend.DiscardUnknown(m)
}

var xxx_messageInfo_ClientToFrontend proto.InternalMessageInfo

func (m *ClientToFrontend) GetHttpResponse() *httpgrpc.HTTPResponse {
	if m != nil {
		return m.HttpResponse
	}
	return nil
}

func (m *ClientToFrontend) GetClientID() string {
	if m != nil {
		return m.ClientID
	}
	return ""
}

func (m *ClientToFrontend) GetStats() *stats.Stats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func init() {
	proto.RegisterEnum("frontend.Type", Type_name, Type_value)
	proto.RegisterType((*FrontendToClient)(nil), "frontend.FrontendToClient")
	proto.RegisterType((*ClientToFrontend)(nil), "frontend.ClientToFrontend")
}

func init() { proto.RegisterFile("frontend.proto", fileDescriptor_eca3873955a29cfe) }

var fileDescriptor_eca3873955a29cfe = []byte{
	// 441 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x5c, 0x91, 0xc1, 0x6e, 0xd3, 0x30,
	0x18, 0xc7, 0xfd, 0xc1, 0x18, 0xc5, 0x8d, 0xaa, 0xc8, 0x12, 0xa8, 0xca, 0xc1, 0xaa, 0x22, 0x0e,
	0x15, 0x12, 0x09, 0x14, 0x24, 0x24, 0x24, 0x2e, 0x63, 0x65, 0xec, 0x36, 0xdc, 0x70, 0xe1, 0x32,
	0x35, 0x99, 0x97, 0x95, 0xad, 0xb1, 0x67, 0xbb, 0x1b, 0xbb, 0xf1, 0x04, 0x08, 0x89, 0x97, 0xe0,
	0x51, 0x38, 0xf6, 0xb8, 0x23, 0x4d, 0x2f, 0x1c, 0xf7, 0x08, 0xa8, 0x76, 0x9a, 0x65, 0xbd, 0x58,
	0xfe, 0xfb, 0xff, 0x7d, 0xfe, 0xff, 0xfc, 0x19, 0x77, 0x8e, 0x95, 0x28, 0x0c, 0x2f, 0x8e, 0x22,
	0xa9, 0x84, 0x11, 0xa4, 0xb5, 0xd6, 0xc1, 0xf3, 0x7c, 0x62, 0x4e, 0x66, 0x69, 0x94, 0x89, 0x69,
	0x9c, 0x8b, 0x5c, 0xc4, 0xb6, 0x20, 0x9d, 0x1d, 0x5b, 0x65, 0x85, 0xdd, 0xb9, 0xc6, 0xe0, 0x75,
	0xa3, 0xfc, 0x92, 0x8f, 0x2f, 0xf8, 0xa5, 0x50, 0xa7, 0x3a, 0xce, 0xc4, 0x74, 0x2a, 0x8a, 0xf8,
	0xc4, 0x18, 0x99, 0x2b, 0x99, 0xd5, 0x9b, 0xaa, 0xeb, 0x5d, 0xa3, 0x2b, 0x13, 0xca, 0xf0, 0x6f,
	0x52, 0x89, 0xaf, 0x3c, 0x33, 0x95, 0x8a, 0xe5, 0x69, 0x1e, 0x9f, 0xcf, 0xb8, 0x9a, 0x70, 0x15,
	0x6b, 0x33, 0x36, 0xda, 0xad, 0xae, 0x3d, 0xfc, 0x05, 0xd8, 0xff, 0x50, 0x01, 0x27, 0xe2, 0xfd,
	0xd9, 0x84, 0x17, 0x86, 0xbc, 0xc1, 0xed, 0x55, 0x0a, 0xe3, 0xe7, 0x33, 0xae, 0x4d, 0x17, 0x7a,
	0xd0, 0x6f, 0x0f, 0x1e, 0x47, 0x75, 0xf2, 0xc7, 0x24, 0x39, 0xa8, 0x4c, 0xd6, 0xac, 0x24, 0x21,
	0xde, 0x32, 0x57, 0x92, 0x77, 0xef, 0xf5, 0xa0, 0xdf, 0x19, 0x74, 0xa2, 0x7a, 0x34, 0xc9, 0x95,
	0xe4, 0xcc, 0x7a, 0x24, 0xc4, 0x9e, 0x05, 0x18, 0x16, 0xe3, 0xf4, 0x8c, 0x1f, 0x75, 0xef, 0xf7,
	0xa0, 0xdf, 0x62, 0x77, 0xce, 0xc2, 0x1f, 0x80, 0x7d, 0xc7, 0x92, 0x88, 0x35, 0x1d, 0x79, 0x8b,
	0x3d, 0x97, 0xa5, 0xa5, 0x28, 0x34, 0xaf, 0xb0, 0x9e, 0x6c, 0x62, 0x39, 0x97, 0xdd, 0xa9, 0x25,
	0x01, 0x6e, 0x65, 0xf6, 0xbe, 0xfd, 0x5d, 0x0b, 0xf7, 0x88, 0xd5, 0x9a, 0x84, 0xf8, 0x81, 0x0d,
	0xb7, 0x24, 0xed, 0x81, 0x17, 0xb9, 0xf9, 0x8c, 0x56, 0x2b, 0x73, 0xd6, 0xb3, 0xa7, 0x78, 0x6b,
	0xf5, 0x04, 0xe2, 0x63, 0x6f, 0x95, 0x72, 0xc8, 0x86, 0x9f, 0x3e, 0x0f, 0x47, 0x89, 0x8f, 0x08,
	0xc6, 0xdb, 0x7b, 0xc3, 0xe4, 0x70, 0x7f, 0xd7, 0x87, 0xc1, 0x08, 0xb7, 0x6a, 0xda, 0x3d, 0xfc,
	0xf0, 0x40, 0x89, 0x8c, 0x6b, 0x4d, 0x82, 0xdb, 0x39, 0x6c, 0x3e, 0x2a, 0x68, 0x78, 0x9b, 0xdf,
	0x10, 0xa2, 0x3e, 0xbc, 0x80, 0x9d, 0x9d, 0xf9, 0x82, 0xa2, 0xeb, 0x05, 0x45, 0x37, 0x0b, 0x0a,
	0xdf, 0x4b, 0x0a, 0xbf, 0x4b, 0x0a, 0x7f, 0x4a, 0x0a, 0xf3, 0x92, 0xc2, 0xdf, 0x92, 0xc2, 0xbf,
	0x92, 0xa2, 0x9b, 0x92, 0xc2, 0xcf, 0x25, 0x45, 0xf3, 0x25, 0x45, 0xd7, 0x4b, 0x8a, 0xbe, 0x78,
	0xeb, 0x6b, 0x2f, 0x5e, 0xca, 0x34, 0xdd, 0xb6, 0x9f, 0xfd, 0xea, 0x7f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x97, 0x76, 0xa9, 0x36, 0xac, 0x02, 0x00, 0x00,
}

func (x Type) String() string {
	s, ok := Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *FrontendToClient) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FrontendToClient)
	if !ok {
		that2, ok := that.(FrontendToClient)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HttpRequest.Equal(that1.HttpRequest) {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.StatsEnabled != that1.StatsEnabled {
		return false
	}
	return true
}
func (this *ClientToFrontend) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClientToFrontend)
	if !ok {
		that2, ok := that.(ClientToFrontend)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HttpResponse.Equal(that1.HttpResponse) {
		return false
	}
	if this.ClientID != that1.ClientID {
		return false
	}
	if !this.Stats.Equal(that1.Stats) {
		return false
	}
	return true
}
func (this *FrontendToClient) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&frontendv1pb.FrontendToClient{")
	if this.HttpRequest != nil {
		s = append(s, "HttpRequest: "+fmt.Sprintf("%#v", this.HttpRequest)+",\n")
	}
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "StatsEnabled: "+fmt.Sprintf("%#v", this.StatsEnabled)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ClientToFrontend) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&frontendv1pb.ClientToFrontend{")
	if this.HttpResponse != nil {
		s = append(s, "HttpResponse: "+fmt.Sprintf("%#v", this.HttpResponse)+",\n")
	}
	s = append(s, "ClientID: "+fmt.Sprintf("%#v", this.ClientID)+",\n")
	if this.Stats != nil {
		s = append(s, "Stats: "+fmt.Sprintf("%#v", this.Stats)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringFrontend(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FrontendClient is the client API for Frontend service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FrontendClient interface {
	// After calling this method, client enters a loop, in which it waits for
	// a "FrontendToClient" message and replies with single "ClientToFrontend" message.
	Process(ctx context.Context, opts ...grpc.CallOption) (Frontend_ProcessClient, error)
}

type frontendClient struct {
	cc *grpc.ClientConn
}

func NewFrontendClient(cc *grpc.ClientConn) FrontendClient {
	return &frontendClient{cc}
}

func (c *frontendClient) Process(ctx context.Context, opts ...grpc.CallOption) (Frontend_ProcessClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Frontend_serviceDesc.Streams[0], "/frontend.Frontend/Process", opts...)
	if err != nil {
		return nil, err
	}
	x := &frontendProcessClient{stream}
	return x, nil
}

type Frontend_ProcessClient interface {
	Send(*ClientToFrontend) error
	Recv() (*FrontendToClient, error)
	grpc.ClientStream
}

type frontendProcessClient struct {
	grpc.ClientStream
}

func (x *frontendProcessClient) Send(m *ClientToFrontend) error {
	return x.ClientStream.SendMsg(m)
}

func (x *frontendProcessClient) Recv() (*FrontendToClient, error) {
	m := new(FrontendToClient)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// FrontendServer is the server API for Frontend service.
type FrontendServer interface {
	// After calling this method, client enters a loop, in which it waits for
	// a "FrontendToClient" message and replies with single "ClientToFrontend" message.
	Process(Frontend_ProcessServer) error
}

// UnimplementedFrontendServer can be embedded to have forward compatible implementations.
type UnimplementedFrontendServer struct {
}

func (*UnimplementedFrontendServer) Process(srv Frontend_ProcessServer) error {
	return status.Errorf(codes.Unimplemented, "method Process not implemented")
}

func RegisterFrontendServer(s *grpc.Server, srv FrontendServer) {
	s.RegisterService(&_Frontend_serviceDesc, srv)
}

func _Frontend_Process_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FrontendServer).Process(&frontendProcessServer{stream})
}

type Frontend_ProcessServer interface {
	Send(*FrontendToClient) error
	Recv() (*ClientToFrontend, error)
	grpc.ServerStream
}

type frontendProcessServer struct {
	grpc.ServerStream
}

func (x *frontendProcessServer) Send(m *FrontendToClient) error {
	return x.ServerStream.SendMsg(m)
}

func (x *frontendProcessServer) Recv() (*ClientToFrontend, error) {
	m := new(ClientToFrontend)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Frontend_serviceDesc = grpc.ServiceDesc{
	ServiceName: "frontend.Frontend",
	HandlerType: (*FrontendServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Process",
			Handler:       _Frontend_Process_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "frontend.proto",
}

func (m *FrontendToClient) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FrontendToClient) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FrontendToClient) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StatsEnabled {
		i--
		if m.StatsEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Type != 0 {
		i = encodeVarintFrontend(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x10
	}
	if m.HttpRequest != nil {
		{
			size, err := m.HttpRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClientToFrontend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClientToFrontend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClientToFrontend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size, err := m.Stats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ClientID) > 0 {
		i -= len(m.ClientID)
		copy(dAtA[i:], m.ClientID)
		i = encodeVarintFrontend(dAtA, i, uint64(len(m.ClientID)))
		i--
		dAtA[i] = 0x12
	}
	if m.HttpResponse != nil {
		{
			size, err := m.HttpResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintFrontend(dAtA []byte, offset int, v uint64) int {
	offset -= sovFrontend(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *FrontendToClient) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpRequest != nil {
		l = m.HttpRequest.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovFrontend(uint64(m.Type))
	}
	if m.StatsEnabled {
		n += 2
	}
	return n
}

func (m *ClientToFrontend) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpResponse != nil {
		l = m.HttpResponse.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	l = len(m.ClientID)
	if l > 0 {
		n += 1 + l + sovFrontend(uint64(l))
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}

func sovFrontend(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozFrontend(x uint64) (n int) {
	return sovFrontend(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *FrontendToClient) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FrontendToClient{`,
		`HttpRequest:` + strings.Replace(fmt.Sprintf("%v", this.HttpRequest), "HTTPRequest", "httpgrpc.HTTPRequest", 1) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`StatsEnabled:` + fmt.Sprintf("%v", this.StatsEnabled) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClientToFrontend) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClientToFrontend{`,
		`HttpResponse:` + strings.Replace(fmt.Sprintf("%v", this.HttpResponse), "HTTPResponse", "httpgrpc.HTTPResponse", 1) + `,`,
		`ClientID:` + fmt.Sprintf("%v", this.ClientID) + `,`,
		`Stats:` + strings.Replace(fmt.Sprintf("%v", this.Stats), "Stats", "stats.Stats", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringFrontend(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *FrontendToClient) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FrontendToClient: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FrontendToClient: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpRequest == nil {
				m.HttpRequest = &httpgrpc.HTTPRequest{}
			}
			if err := m.HttpRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StatsEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientToFrontend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientToFrontend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientToFrontend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpResponse == nil {
				m.HttpResponse = &httpgrpc.HTTPResponse{}
			}
			if err := m.HttpResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &stats.Stats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipFrontend(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthFrontend
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthFrontend
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowFrontend
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipFrontend(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthFrontend
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthFrontend = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowFrontend   = fmt.Errorf("proto: integer overflow")
)
