// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/actions/sdk/v2/interactionmodel/intent.proto

package interactionmodel

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_type "google.golang.org/genproto/googleapis/actions/sdk/v2/interactionmodel/type"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Intents map open-ended user input to structured objects. Spoken
// phrases are matched to intents with Google's Natural Language Understanding
// (NLU). Intent matches can trigger events in your conversation design to
// progress the user's conversation.
// The intent name is specified in the name of the file.
type Intent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of parameters within the training phrases. All parameters must be
	// defined here to be used in the training phrase.
	Parameters []*Intent_IntentParameter `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Training phrases allow Google’s NLU to automatically match intents with
	// user input. The more unique phrases that are provided, the better chance
	// this intent will be matched.
	// The following is the format of training phrase part which are annotated.
	// Note that `auto` field is optional and the default behavior when `auto` is
	// not specified is equivalent to `auto=false`.
	// `($<paramName> '<sample text>' auto=<true or false>)`
	// `auto = true` means the part was auto annotated by NLU.
	// `auto = false` means the part was annotated by the user. This is the
	//     default when auto is not specified.
	// Example:
	// "Book a flight from ($source 'San Francisco' auto=false) to ($dest
	// 'Vancouver')"
	TrainingPhrases []string `protobuf:"bytes,2,rep,name=training_phrases,json=trainingPhrases,proto3" json:"training_phrases,omitempty"`
}

func (x *Intent) Reset() {
	*x = Intent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent) ProtoMessage() {}

func (x *Intent) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent.ProtoReflect.Descriptor instead.
func (*Intent) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescGZIP(), []int{0}
}

func (x *Intent) GetParameters() []*Intent_IntentParameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Intent) GetTrainingPhrases() []string {
	if x != nil {
		return x.TrainingPhrases
	}
	return nil
}

// Definition of a parameter which can be used inside training phrases.
type Intent_IntentParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique name of the intent parameter. Can be used in conditions and
	// responses to reference intent parameters extracted by NLU with
	// $intent.params.[name].resolved
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the intent parameter.
	//
	// Types that are assignable to ParameterType:
	//	*Intent_IntentParameter_Type
	ParameterType isIntent_IntentParameter_ParameterType `protobuf_oneof:"parameter_type"`
}

func (x *Intent_IntentParameter) Reset() {
	*x = Intent_IntentParameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_IntentParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_IntentParameter) ProtoMessage() {}

func (x *Intent_IntentParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_IntentParameter.ProtoReflect.Descriptor instead.
func (*Intent_IntentParameter) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Intent_IntentParameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Intent_IntentParameter) GetParameterType() isIntent_IntentParameter_ParameterType {
	if m != nil {
		return m.ParameterType
	}
	return nil
}

func (x *Intent_IntentParameter) GetType() *_type.ClassReference {
	if x, ok := x.GetParameterType().(*Intent_IntentParameter_Type); ok {
		return x.Type
	}
	return nil
}

type isIntent_IntentParameter_ParameterType interface {
	isIntent_IntentParameter_ParameterType()
}

type Intent_IntentParameter_Type struct {
	// Optional. Declares the data type of this parameter.
	// This should not be set for built-in intents.
	Type *_type.ClassReference `protobuf:"bytes,2,opt,name=type,proto3,oneof"`
}

func (*Intent_IntentParameter_Type) isIntent_IntentParameter_ParameterType() {}

var File_google_actions_sdk_v2_interactionmodel_intent_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x41, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64,
	0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xaa, 0x02, 0x0a, 0x06, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x29, 0x0a, 0x10,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x1a, 0x94, 0x01, 0x0a, 0x0f, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x42, 0x10, 0x0a, 0x0e,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x93,
	0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x0b, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f,
	0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x3b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescData = file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDesc
)

func file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDescData
}

var file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_actions_sdk_v2_interactionmodel_intent_proto_goTypes = []interface{}{
	(*Intent)(nil),                 // 0: google.actions.sdk.v2.interactionmodel.Intent
	(*Intent_IntentParameter)(nil), // 1: google.actions.sdk.v2.interactionmodel.Intent.IntentParameter
	(*_type.ClassReference)(nil),   // 2: google.actions.sdk.v2.interactionmodel.type.ClassReference
}
var file_google_actions_sdk_v2_interactionmodel_intent_proto_depIdxs = []int32{
	1, // 0: google.actions.sdk.v2.interactionmodel.Intent.parameters:type_name -> google.actions.sdk.v2.interactionmodel.Intent.IntentParameter
	2, // 1: google.actions.sdk.v2.interactionmodel.Intent.IntentParameter.type:type_name -> google.actions.sdk.v2.interactionmodel.type.ClassReference
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_interactionmodel_intent_proto_init() }
func file_google_actions_sdk_v2_interactionmodel_intent_proto_init() {
	if File_google_actions_sdk_v2_interactionmodel_intent_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_IntentParameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Intent_IntentParameter_Type)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_interactionmodel_intent_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_interactionmodel_intent_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_interactionmodel_intent_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_interactionmodel_intent_proto = out.File
	file_google_actions_sdk_v2_interactionmodel_intent_proto_rawDesc = nil
	file_google_actions_sdk_v2_interactionmodel_intent_proto_goTypes = nil
	file_google_actions_sdk_v2_interactionmodel_intent_proto_depIdxs = nil
}
