// +build !ignore_autogenerated_openshift

// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	unsafe "unsafe"

	v1 "github.com/openshift/api/image/v1"
	image "github.com/openshift/origin/pkg/image/apis/image"
	api_core_v1 "k8s.io/api/core/v1"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	core "k8s.io/kubernetes/pkg/apis/core"
	core_v1 "k8s.io/kubernetes/pkg/apis/core/v1"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_Image_To_image_Image,
		Convert_image_Image_To_v1_Image,
		Convert_v1_ImageBlobReferences_To_image_ImageBlobReferences,
		Convert_image_ImageBlobReferences_To_v1_ImageBlobReferences,
		Convert_v1_ImageImportSpec_To_image_ImageImportSpec,
		Convert_image_ImageImportSpec_To_v1_ImageImportSpec,
		Convert_v1_ImageImportStatus_To_image_ImageImportStatus,
		Convert_image_ImageImportStatus_To_v1_ImageImportStatus,
		Convert_v1_ImageLayer_To_image_ImageLayer,
		Convert_image_ImageLayer_To_v1_ImageLayer,
		Convert_v1_ImageLayerData_To_image_ImageLayerData,
		Convert_image_ImageLayerData_To_v1_ImageLayerData,
		Convert_v1_ImageList_To_image_ImageList,
		Convert_image_ImageList_To_v1_ImageList,
		Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy,
		Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy,
		Convert_v1_ImageSignature_To_image_ImageSignature,
		Convert_image_ImageSignature_To_v1_ImageSignature,
		Convert_v1_ImageStream_To_image_ImageStream,
		Convert_image_ImageStream_To_v1_ImageStream,
		Convert_v1_ImageStreamImage_To_image_ImageStreamImage,
		Convert_image_ImageStreamImage_To_v1_ImageStreamImage,
		Convert_v1_ImageStreamImport_To_image_ImageStreamImport,
		Convert_image_ImageStreamImport_To_v1_ImageStreamImport,
		Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec,
		Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec,
		Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus,
		Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus,
		Convert_v1_ImageStreamLayers_To_image_ImageStreamLayers,
		Convert_image_ImageStreamLayers_To_v1_ImageStreamLayers,
		Convert_v1_ImageStreamList_To_image_ImageStreamList,
		Convert_image_ImageStreamList_To_v1_ImageStreamList,
		Convert_v1_ImageStreamMapping_To_image_ImageStreamMapping,
		Convert_image_ImageStreamMapping_To_v1_ImageStreamMapping,
		Convert_v1_ImageStreamSpec_To_image_ImageStreamSpec,
		Convert_image_ImageStreamSpec_To_v1_ImageStreamSpec,
		Convert_v1_ImageStreamStatus_To_image_ImageStreamStatus,
		Convert_image_ImageStreamStatus_To_v1_ImageStreamStatus,
		Convert_v1_ImageStreamTag_To_image_ImageStreamTag,
		Convert_image_ImageStreamTag_To_v1_ImageStreamTag,
		Convert_v1_ImageStreamTagList_To_image_ImageStreamTagList,
		Convert_image_ImageStreamTagList_To_v1_ImageStreamTagList,
		Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec,
		Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec,
		Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus,
		Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus,
		Convert_v1_SignatureCondition_To_image_SignatureCondition,
		Convert_image_SignatureCondition_To_v1_SignatureCondition,
		Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity,
		Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity,
		Convert_v1_SignatureIssuer_To_image_SignatureIssuer,
		Convert_image_SignatureIssuer_To_v1_SignatureIssuer,
		Convert_v1_SignatureSubject_To_image_SignatureSubject,
		Convert_image_SignatureSubject_To_v1_SignatureSubject,
		Convert_v1_TagEvent_To_image_TagEvent,
		Convert_image_TagEvent_To_v1_TagEvent,
		Convert_v1_TagEventCondition_To_image_TagEventCondition,
		Convert_image_TagEventCondition_To_v1_TagEventCondition,
		Convert_v1_TagImportPolicy_To_image_TagImportPolicy,
		Convert_image_TagImportPolicy_To_v1_TagImportPolicy,
		Convert_v1_TagReference_To_image_TagReference,
		Convert_image_TagReference_To_v1_TagReference,
		Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy,
		Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy,
	)
}

func autoConvert_v1_Image_To_image_Image(in *v1.Image, out *image.Image, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DockerImageReference = in.DockerImageReference
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.DockerImageMetadata, &out.DockerImageMetadata, 0); err != nil {
		return err
	}
	out.DockerImageMetadataVersion = in.DockerImageMetadataVersion
	out.DockerImageManifest = in.DockerImageManifest
	out.DockerImageLayers = *(*[]image.ImageLayer)(unsafe.Pointer(&in.DockerImageLayers))
	out.Signatures = *(*[]image.ImageSignature)(unsafe.Pointer(&in.Signatures))
	out.DockerImageSignatures = *(*[][]byte)(unsafe.Pointer(&in.DockerImageSignatures))
	out.DockerImageManifestMediaType = in.DockerImageManifestMediaType
	out.DockerImageConfig = in.DockerImageConfig
	return nil
}

func autoConvert_image_Image_To_v1_Image(in *image.Image, out *v1.Image, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DockerImageReference = in.DockerImageReference
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.DockerImageMetadata, &out.DockerImageMetadata, 0); err != nil {
		return err
	}
	out.DockerImageMetadataVersion = in.DockerImageMetadataVersion
	out.DockerImageManifest = in.DockerImageManifest
	out.DockerImageLayers = *(*[]v1.ImageLayer)(unsafe.Pointer(&in.DockerImageLayers))
	out.Signatures = *(*[]v1.ImageSignature)(unsafe.Pointer(&in.Signatures))
	out.DockerImageSignatures = *(*[][]byte)(unsafe.Pointer(&in.DockerImageSignatures))
	out.DockerImageManifestMediaType = in.DockerImageManifestMediaType
	out.DockerImageConfig = in.DockerImageConfig
	return nil
}

func autoConvert_v1_ImageBlobReferences_To_image_ImageBlobReferences(in *v1.ImageBlobReferences, out *image.ImageBlobReferences, s conversion.Scope) error {
	out.ImageMissing = in.ImageMissing
	out.Layers = *(*[]string)(unsafe.Pointer(&in.Layers))
	out.Config = (*string)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_v1_ImageBlobReferences_To_image_ImageBlobReferences is an autogenerated conversion function.
func Convert_v1_ImageBlobReferences_To_image_ImageBlobReferences(in *v1.ImageBlobReferences, out *image.ImageBlobReferences, s conversion.Scope) error {
	return autoConvert_v1_ImageBlobReferences_To_image_ImageBlobReferences(in, out, s)
}

func autoConvert_image_ImageBlobReferences_To_v1_ImageBlobReferences(in *image.ImageBlobReferences, out *v1.ImageBlobReferences, s conversion.Scope) error {
	out.ImageMissing = in.ImageMissing
	out.Layers = *(*[]string)(unsafe.Pointer(&in.Layers))
	out.Config = (*string)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_image_ImageBlobReferences_To_v1_ImageBlobReferences is an autogenerated conversion function.
func Convert_image_ImageBlobReferences_To_v1_ImageBlobReferences(in *image.ImageBlobReferences, out *v1.ImageBlobReferences, s conversion.Scope) error {
	return autoConvert_image_ImageBlobReferences_To_v1_ImageBlobReferences(in, out, s)
}

func autoConvert_v1_ImageImportSpec_To_image_ImageImportSpec(in *v1.ImageImportSpec, out *image.ImageImportSpec, s conversion.Scope) error {
	if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(core.LocalObjectReference)
		if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if err := Convert_v1_TagImportPolicy_To_image_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_v1_ImageImportSpec_To_image_ImageImportSpec is an autogenerated conversion function.
func Convert_v1_ImageImportSpec_To_image_ImageImportSpec(in *v1.ImageImportSpec, out *image.ImageImportSpec, s conversion.Scope) error {
	return autoConvert_v1_ImageImportSpec_To_image_ImageImportSpec(in, out, s)
}

func autoConvert_image_ImageImportSpec_To_v1_ImageImportSpec(in *image.ImageImportSpec, out *v1.ImageImportSpec, s conversion.Scope) error {
	if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api_core_v1.LocalObjectReference)
		if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if err := Convert_image_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_image_ImageImportSpec_To_v1_ImageImportSpec is an autogenerated conversion function.
func Convert_image_ImageImportSpec_To_v1_ImageImportSpec(in *image.ImageImportSpec, out *v1.ImageImportSpec, s conversion.Scope) error {
	return autoConvert_image_ImageImportSpec_To_v1_ImageImportSpec(in, out, s)
}

func autoConvert_v1_ImageImportStatus_To_image_ImageImportStatus(in *v1.ImageImportStatus, out *image.ImageImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(image.Image)
		if err := Convert_v1_Image_To_image_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	out.Tag = in.Tag
	return nil
}

// Convert_v1_ImageImportStatus_To_image_ImageImportStatus is an autogenerated conversion function.
func Convert_v1_ImageImportStatus_To_image_ImageImportStatus(in *v1.ImageImportStatus, out *image.ImageImportStatus, s conversion.Scope) error {
	return autoConvert_v1_ImageImportStatus_To_image_ImageImportStatus(in, out, s)
}

func autoConvert_image_ImageImportStatus_To_v1_ImageImportStatus(in *image.ImageImportStatus, out *v1.ImageImportStatus, s conversion.Scope) error {
	out.Tag = in.Tag
	out.Status = in.Status
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(v1.Image)
		if err := Convert_image_Image_To_v1_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	return nil
}

// Convert_image_ImageImportStatus_To_v1_ImageImportStatus is an autogenerated conversion function.
func Convert_image_ImageImportStatus_To_v1_ImageImportStatus(in *image.ImageImportStatus, out *v1.ImageImportStatus, s conversion.Scope) error {
	return autoConvert_image_ImageImportStatus_To_v1_ImageImportStatus(in, out, s)
}

func autoConvert_v1_ImageLayer_To_image_ImageLayer(in *v1.ImageLayer, out *image.ImageLayer, s conversion.Scope) error {
	out.Name = in.Name
	out.LayerSize = in.LayerSize
	out.MediaType = in.MediaType
	return nil
}

// Convert_v1_ImageLayer_To_image_ImageLayer is an autogenerated conversion function.
func Convert_v1_ImageLayer_To_image_ImageLayer(in *v1.ImageLayer, out *image.ImageLayer, s conversion.Scope) error {
	return autoConvert_v1_ImageLayer_To_image_ImageLayer(in, out, s)
}

func autoConvert_image_ImageLayer_To_v1_ImageLayer(in *image.ImageLayer, out *v1.ImageLayer, s conversion.Scope) error {
	out.Name = in.Name
	out.LayerSize = in.LayerSize
	out.MediaType = in.MediaType
	return nil
}

// Convert_image_ImageLayer_To_v1_ImageLayer is an autogenerated conversion function.
func Convert_image_ImageLayer_To_v1_ImageLayer(in *image.ImageLayer, out *v1.ImageLayer, s conversion.Scope) error {
	return autoConvert_image_ImageLayer_To_v1_ImageLayer(in, out, s)
}

func autoConvert_v1_ImageLayerData_To_image_ImageLayerData(in *v1.ImageLayerData, out *image.ImageLayerData, s conversion.Scope) error {
	out.LayerSize = (*int64)(unsafe.Pointer(in.LayerSize))
	out.MediaType = in.MediaType
	return nil
}

// Convert_v1_ImageLayerData_To_image_ImageLayerData is an autogenerated conversion function.
func Convert_v1_ImageLayerData_To_image_ImageLayerData(in *v1.ImageLayerData, out *image.ImageLayerData, s conversion.Scope) error {
	return autoConvert_v1_ImageLayerData_To_image_ImageLayerData(in, out, s)
}

func autoConvert_image_ImageLayerData_To_v1_ImageLayerData(in *image.ImageLayerData, out *v1.ImageLayerData, s conversion.Scope) error {
	out.LayerSize = (*int64)(unsafe.Pointer(in.LayerSize))
	out.MediaType = in.MediaType
	return nil
}

// Convert_image_ImageLayerData_To_v1_ImageLayerData is an autogenerated conversion function.
func Convert_image_ImageLayerData_To_v1_ImageLayerData(in *image.ImageLayerData, out *v1.ImageLayerData, s conversion.Scope) error {
	return autoConvert_image_ImageLayerData_To_v1_ImageLayerData(in, out, s)
}

func autoConvert_v1_ImageList_To_image_ImageList(in *v1.ImageList, out *image.ImageList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]image.Image, len(*in))
		for i := range *in {
			if err := Convert_v1_Image_To_image_Image(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ImageList_To_image_ImageList is an autogenerated conversion function.
func Convert_v1_ImageList_To_image_ImageList(in *v1.ImageList, out *image.ImageList, s conversion.Scope) error {
	return autoConvert_v1_ImageList_To_image_ImageList(in, out, s)
}

func autoConvert_image_ImageList_To_v1_ImageList(in *image.ImageList, out *v1.ImageList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.Image, len(*in))
		for i := range *in {
			if err := Convert_image_Image_To_v1_Image(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_image_ImageList_To_v1_ImageList is an autogenerated conversion function.
func Convert_image_ImageList_To_v1_ImageList(in *image.ImageList, out *v1.ImageList, s conversion.Scope) error {
	return autoConvert_image_ImageList_To_v1_ImageList(in, out, s)
}

func autoConvert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(in *v1.ImageLookupPolicy, out *image.ImageLookupPolicy, s conversion.Scope) error {
	out.Local = in.Local
	return nil
}

// Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy is an autogenerated conversion function.
func Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(in *v1.ImageLookupPolicy, out *image.ImageLookupPolicy, s conversion.Scope) error {
	return autoConvert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(in, out, s)
}

func autoConvert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(in *image.ImageLookupPolicy, out *v1.ImageLookupPolicy, s conversion.Scope) error {
	out.Local = in.Local
	return nil
}

// Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy is an autogenerated conversion function.
func Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(in *image.ImageLookupPolicy, out *v1.ImageLookupPolicy, s conversion.Scope) error {
	return autoConvert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(in, out, s)
}

func autoConvert_v1_ImageSignature_To_image_ImageSignature(in *v1.ImageSignature, out *image.ImageSignature, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Type = in.Type
	out.Content = *(*[]byte)(unsafe.Pointer(&in.Content))
	out.Conditions = *(*[]image.SignatureCondition)(unsafe.Pointer(&in.Conditions))
	out.ImageIdentity = in.ImageIdentity
	out.SignedClaims = *(*map[string]string)(unsafe.Pointer(&in.SignedClaims))
	out.Created = (*meta_v1.Time)(unsafe.Pointer(in.Created))
	out.IssuedBy = (*image.SignatureIssuer)(unsafe.Pointer(in.IssuedBy))
	out.IssuedTo = (*image.SignatureSubject)(unsafe.Pointer(in.IssuedTo))
	return nil
}

// Convert_v1_ImageSignature_To_image_ImageSignature is an autogenerated conversion function.
func Convert_v1_ImageSignature_To_image_ImageSignature(in *v1.ImageSignature, out *image.ImageSignature, s conversion.Scope) error {
	return autoConvert_v1_ImageSignature_To_image_ImageSignature(in, out, s)
}

func autoConvert_image_ImageSignature_To_v1_ImageSignature(in *image.ImageSignature, out *v1.ImageSignature, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Type = in.Type
	out.Content = *(*[]byte)(unsafe.Pointer(&in.Content))
	out.Conditions = *(*[]v1.SignatureCondition)(unsafe.Pointer(&in.Conditions))
	out.ImageIdentity = in.ImageIdentity
	out.SignedClaims = *(*map[string]string)(unsafe.Pointer(&in.SignedClaims))
	out.Created = (*meta_v1.Time)(unsafe.Pointer(in.Created))
	out.IssuedBy = (*v1.SignatureIssuer)(unsafe.Pointer(in.IssuedBy))
	out.IssuedTo = (*v1.SignatureSubject)(unsafe.Pointer(in.IssuedTo))
	return nil
}

// Convert_image_ImageSignature_To_v1_ImageSignature is an autogenerated conversion function.
func Convert_image_ImageSignature_To_v1_ImageSignature(in *image.ImageSignature, out *v1.ImageSignature, s conversion.Scope) error {
	return autoConvert_image_ImageSignature_To_v1_ImageSignature(in, out, s)
}

func autoConvert_v1_ImageStream_To_image_ImageStream(in *v1.ImageStream, out *image.ImageStream, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ImageStreamSpec_To_image_ImageStreamSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamStatus_To_image_ImageStreamStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStream_To_image_ImageStream is an autogenerated conversion function.
func Convert_v1_ImageStream_To_image_ImageStream(in *v1.ImageStream, out *image.ImageStream, s conversion.Scope) error {
	return autoConvert_v1_ImageStream_To_image_ImageStream(in, out, s)
}

func autoConvert_image_ImageStream_To_v1_ImageStream(in *image.ImageStream, out *v1.ImageStream, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_image_ImageStreamSpec_To_v1_ImageStreamSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_image_ImageStreamStatus_To_v1_ImageStreamStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStream_To_v1_ImageStream is an autogenerated conversion function.
func Convert_image_ImageStream_To_v1_ImageStream(in *image.ImageStream, out *v1.ImageStream, s conversion.Scope) error {
	return autoConvert_image_ImageStream_To_v1_ImageStream(in, out, s)
}

func autoConvert_v1_ImageStreamImage_To_image_ImageStreamImage(in *v1.ImageStreamImage, out *image.ImageStreamImage, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_Image_To_image_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStreamImage_To_image_ImageStreamImage is an autogenerated conversion function.
func Convert_v1_ImageStreamImage_To_image_ImageStreamImage(in *v1.ImageStreamImage, out *image.ImageStreamImage, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImage_To_image_ImageStreamImage(in, out, s)
}

func autoConvert_image_ImageStreamImage_To_v1_ImageStreamImage(in *image.ImageStreamImage, out *v1.ImageStreamImage, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_image_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStreamImage_To_v1_ImageStreamImage is an autogenerated conversion function.
func Convert_image_ImageStreamImage_To_v1_ImageStreamImage(in *image.ImageStreamImage, out *v1.ImageStreamImage, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImage_To_v1_ImageStreamImage(in, out, s)
}

func autoConvert_v1_ImageStreamImport_To_image_ImageStreamImport(in *v1.ImageStreamImport, out *image.ImageStreamImport, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStreamImport_To_image_ImageStreamImport is an autogenerated conversion function.
func Convert_v1_ImageStreamImport_To_image_ImageStreamImport(in *v1.ImageStreamImport, out *image.ImageStreamImport, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImport_To_image_ImageStreamImport(in, out, s)
}

func autoConvert_image_ImageStreamImport_To_v1_ImageStreamImport(in *image.ImageStreamImport, out *v1.ImageStreamImport, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStreamImport_To_v1_ImageStreamImport is an autogenerated conversion function.
func Convert_image_ImageStreamImport_To_v1_ImageStreamImport(in *image.ImageStreamImport, out *v1.ImageStreamImport, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImport_To_v1_ImageStreamImport(in, out, s)
}

func autoConvert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(in *v1.ImageStreamImportSpec, out *image.ImageStreamImportSpec, s conversion.Scope) error {
	out.Import = in.Import
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(image.RepositoryImportSpec)
		if err := Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]image.ImageImportSpec, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportSpec_To_image_ImageImportSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec is an autogenerated conversion function.
func Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(in *v1.ImageStreamImportSpec, out *image.ImageStreamImportSpec, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(in, out, s)
}

func autoConvert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in *image.ImageStreamImportSpec, out *v1.ImageStreamImportSpec, s conversion.Scope) error {
	out.Import = in.Import
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(v1.RepositoryImportSpec)
		if err := Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]v1.ImageImportSpec, len(*in))
		for i := range *in {
			if err := Convert_image_ImageImportSpec_To_v1_ImageImportSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec is an autogenerated conversion function.
func Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in *image.ImageStreamImportSpec, out *v1.ImageStreamImportSpec, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in, out, s)
}

func autoConvert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(in *v1.ImageStreamImportStatus, out *image.ImageStreamImportStatus, s conversion.Scope) error {
	if in.Import != nil {
		in, out := &in.Import, &out.Import
		*out = new(image.ImageStream)
		if err := Convert_v1_ImageStream_To_image_ImageStream(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Import = nil
	}
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(image.RepositoryImportStatus)
		if err := Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]image.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportStatus_To_image_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus is an autogenerated conversion function.
func Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(in *v1.ImageStreamImportStatus, out *image.ImageStreamImportStatus, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(in, out, s)
}

func autoConvert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in *image.ImageStreamImportStatus, out *v1.ImageStreamImportStatus, s conversion.Scope) error {
	if in.Import != nil {
		in, out := &in.Import, &out.Import
		*out = new(v1.ImageStream)
		if err := Convert_image_ImageStream_To_v1_ImageStream(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Import = nil
	}
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(v1.RepositoryImportStatus)
		if err := Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]v1.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_image_ImageImportStatus_To_v1_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus is an autogenerated conversion function.
func Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in *image.ImageStreamImportStatus, out *v1.ImageStreamImportStatus, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in, out, s)
}

func autoConvert_v1_ImageStreamLayers_To_image_ImageStreamLayers(in *v1.ImageStreamLayers, out *image.ImageStreamLayers, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Blobs = *(*map[string]image.ImageLayerData)(unsafe.Pointer(&in.Blobs))
	out.Images = *(*map[string]image.ImageBlobReferences)(unsafe.Pointer(&in.Images))
	return nil
}

// Convert_v1_ImageStreamLayers_To_image_ImageStreamLayers is an autogenerated conversion function.
func Convert_v1_ImageStreamLayers_To_image_ImageStreamLayers(in *v1.ImageStreamLayers, out *image.ImageStreamLayers, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamLayers_To_image_ImageStreamLayers(in, out, s)
}

func autoConvert_image_ImageStreamLayers_To_v1_ImageStreamLayers(in *image.ImageStreamLayers, out *v1.ImageStreamLayers, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Blobs = *(*map[string]v1.ImageLayerData)(unsafe.Pointer(&in.Blobs))
	out.Images = *(*map[string]v1.ImageBlobReferences)(unsafe.Pointer(&in.Images))
	return nil
}

// Convert_image_ImageStreamLayers_To_v1_ImageStreamLayers is an autogenerated conversion function.
func Convert_image_ImageStreamLayers_To_v1_ImageStreamLayers(in *image.ImageStreamLayers, out *v1.ImageStreamLayers, s conversion.Scope) error {
	return autoConvert_image_ImageStreamLayers_To_v1_ImageStreamLayers(in, out, s)
}

func autoConvert_v1_ImageStreamList_To_image_ImageStreamList(in *v1.ImageStreamList, out *image.ImageStreamList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]image.ImageStream, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageStream_To_image_ImageStream(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ImageStreamList_To_image_ImageStreamList is an autogenerated conversion function.
func Convert_v1_ImageStreamList_To_image_ImageStreamList(in *v1.ImageStreamList, out *image.ImageStreamList, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamList_To_image_ImageStreamList(in, out, s)
}

func autoConvert_image_ImageStreamList_To_v1_ImageStreamList(in *image.ImageStreamList, out *v1.ImageStreamList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.ImageStream, len(*in))
		for i := range *in {
			if err := Convert_image_ImageStream_To_v1_ImageStream(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_image_ImageStreamList_To_v1_ImageStreamList is an autogenerated conversion function.
func Convert_image_ImageStreamList_To_v1_ImageStreamList(in *image.ImageStreamList, out *v1.ImageStreamList, s conversion.Scope) error {
	return autoConvert_image_ImageStreamList_To_v1_ImageStreamList(in, out, s)
}

func autoConvert_v1_ImageStreamMapping_To_image_ImageStreamMapping(in *v1.ImageStreamMapping, out *image.ImageStreamMapping, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_Image_To_image_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	out.Tag = in.Tag
	return nil
}

func autoConvert_image_ImageStreamMapping_To_v1_ImageStreamMapping(in *image.ImageStreamMapping, out *v1.ImageStreamMapping, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	// INFO: in.DockerImageRepository opted out of conversion generation
	if err := Convert_image_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	out.Tag = in.Tag
	return nil
}

func autoConvert_v1_ImageStreamSpec_To_image_ImageStreamSpec(in *v1.ImageStreamSpec, out *image.ImageStreamSpec, s conversion.Scope) error {
	if err := Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	out.DockerImageRepository = in.DockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types ([]github.com/openshift/api/image/v1.TagReference vs map[string]github.com/openshift/origin/pkg/image/apis/image.TagReference)
	return nil
}

func autoConvert_image_ImageStreamSpec_To_v1_ImageStreamSpec(in *image.ImageStreamSpec, out *v1.ImageStreamSpec, s conversion.Scope) error {
	if err := Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	out.DockerImageRepository = in.DockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types (map[string]github.com/openshift/origin/pkg/image/apis/image.TagReference vs []github.com/openshift/api/image/v1.TagReference)
	return nil
}

func autoConvert_v1_ImageStreamStatus_To_image_ImageStreamStatus(in *v1.ImageStreamStatus, out *image.ImageStreamStatus, s conversion.Scope) error {
	out.DockerImageRepository = in.DockerImageRepository
	out.PublicDockerImageRepository = in.PublicDockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types ([]github.com/openshift/api/image/v1.NamedTagEventList vs map[string]github.com/openshift/origin/pkg/image/apis/image.TagEventList)
	return nil
}

func autoConvert_image_ImageStreamStatus_To_v1_ImageStreamStatus(in *image.ImageStreamStatus, out *v1.ImageStreamStatus, s conversion.Scope) error {
	out.DockerImageRepository = in.DockerImageRepository
	out.PublicDockerImageRepository = in.PublicDockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types (map[string]github.com/openshift/origin/pkg/image/apis/image.TagEventList vs []github.com/openshift/api/image/v1.NamedTagEventList)
	return nil
}

func autoConvert_v1_ImageStreamTag_To_image_ImageStreamTag(in *v1.ImageStreamTag, out *image.ImageStreamTag, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Tag != nil {
		in, out := &in.Tag, &out.Tag
		*out = new(image.TagReference)
		if err := Convert_v1_TagReference_To_image_TagReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Tag = nil
	}
	out.Generation = in.Generation
	if err := Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	out.Conditions = *(*[]image.TagEventCondition)(unsafe.Pointer(&in.Conditions))
	if err := Convert_v1_Image_To_image_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStreamTag_To_image_ImageStreamTag is an autogenerated conversion function.
func Convert_v1_ImageStreamTag_To_image_ImageStreamTag(in *v1.ImageStreamTag, out *image.ImageStreamTag, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamTag_To_image_ImageStreamTag(in, out, s)
}

func autoConvert_image_ImageStreamTag_To_v1_ImageStreamTag(in *image.ImageStreamTag, out *v1.ImageStreamTag, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Tag != nil {
		in, out := &in.Tag, &out.Tag
		*out = new(v1.TagReference)
		if err := Convert_image_TagReference_To_v1_TagReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Tag = nil
	}
	out.Generation = in.Generation
	out.Conditions = *(*[]v1.TagEventCondition)(unsafe.Pointer(&in.Conditions))
	if err := Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStreamTag_To_v1_ImageStreamTag is an autogenerated conversion function.
func Convert_image_ImageStreamTag_To_v1_ImageStreamTag(in *image.ImageStreamTag, out *v1.ImageStreamTag, s conversion.Scope) error {
	return autoConvert_image_ImageStreamTag_To_v1_ImageStreamTag(in, out, s)
}

func autoConvert_v1_ImageStreamTagList_To_image_ImageStreamTagList(in *v1.ImageStreamTagList, out *image.ImageStreamTagList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]image.ImageStreamTag, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageStreamTag_To_image_ImageStreamTag(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ImageStreamTagList_To_image_ImageStreamTagList is an autogenerated conversion function.
func Convert_v1_ImageStreamTagList_To_image_ImageStreamTagList(in *v1.ImageStreamTagList, out *image.ImageStreamTagList, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamTagList_To_image_ImageStreamTagList(in, out, s)
}

func autoConvert_image_ImageStreamTagList_To_v1_ImageStreamTagList(in *image.ImageStreamTagList, out *v1.ImageStreamTagList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.ImageStreamTag, len(*in))
		for i := range *in {
			if err := Convert_image_ImageStreamTag_To_v1_ImageStreamTag(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_image_ImageStreamTagList_To_v1_ImageStreamTagList is an autogenerated conversion function.
func Convert_image_ImageStreamTagList_To_v1_ImageStreamTagList(in *image.ImageStreamTagList, out *v1.ImageStreamTagList, s conversion.Scope) error {
	return autoConvert_image_ImageStreamTagList_To_v1_ImageStreamTagList(in, out, s)
}

func autoConvert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(in *v1.RepositoryImportSpec, out *image.RepositoryImportSpec, s conversion.Scope) error {
	if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if err := Convert_v1_TagImportPolicy_To_image_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec is an autogenerated conversion function.
func Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(in *v1.RepositoryImportSpec, out *image.RepositoryImportSpec, s conversion.Scope) error {
	return autoConvert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(in, out, s)
}

func autoConvert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(in *image.RepositoryImportSpec, out *v1.RepositoryImportSpec, s conversion.Scope) error {
	if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if err := Convert_image_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec is an autogenerated conversion function.
func Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(in *image.RepositoryImportSpec, out *v1.RepositoryImportSpec, s conversion.Scope) error {
	return autoConvert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(in, out, s)
}

func autoConvert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(in *v1.RepositoryImportStatus, out *image.RepositoryImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]image.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportStatus_To_image_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.AdditionalTags = *(*[]string)(unsafe.Pointer(&in.AdditionalTags))
	return nil
}

// Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus is an autogenerated conversion function.
func Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(in *v1.RepositoryImportStatus, out *image.RepositoryImportStatus, s conversion.Scope) error {
	return autoConvert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(in, out, s)
}

func autoConvert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(in *image.RepositoryImportStatus, out *v1.RepositoryImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]v1.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_image_ImageImportStatus_To_v1_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.AdditionalTags = *(*[]string)(unsafe.Pointer(&in.AdditionalTags))
	return nil
}

// Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus is an autogenerated conversion function.
func Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(in *image.RepositoryImportStatus, out *v1.RepositoryImportStatus, s conversion.Scope) error {
	return autoConvert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(in, out, s)
}

func autoConvert_v1_SignatureCondition_To_image_SignatureCondition(in *v1.SignatureCondition, out *image.SignatureCondition, s conversion.Scope) error {
	out.Type = image.SignatureConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_SignatureCondition_To_image_SignatureCondition is an autogenerated conversion function.
func Convert_v1_SignatureCondition_To_image_SignatureCondition(in *v1.SignatureCondition, out *image.SignatureCondition, s conversion.Scope) error {
	return autoConvert_v1_SignatureCondition_To_image_SignatureCondition(in, out, s)
}

func autoConvert_image_SignatureCondition_To_v1_SignatureCondition(in *image.SignatureCondition, out *v1.SignatureCondition, s conversion.Scope) error {
	out.Type = v1.SignatureConditionType(in.Type)
	out.Status = api_core_v1.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_image_SignatureCondition_To_v1_SignatureCondition is an autogenerated conversion function.
func Convert_image_SignatureCondition_To_v1_SignatureCondition(in *image.SignatureCondition, out *v1.SignatureCondition, s conversion.Scope) error {
	return autoConvert_image_SignatureCondition_To_v1_SignatureCondition(in, out, s)
}

func autoConvert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(in *v1.SignatureGenericEntity, out *image.SignatureGenericEntity, s conversion.Scope) error {
	out.Organization = in.Organization
	out.CommonName = in.CommonName
	return nil
}

// Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity is an autogenerated conversion function.
func Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(in *v1.SignatureGenericEntity, out *image.SignatureGenericEntity, s conversion.Scope) error {
	return autoConvert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(in, out, s)
}

func autoConvert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(in *image.SignatureGenericEntity, out *v1.SignatureGenericEntity, s conversion.Scope) error {
	out.Organization = in.Organization
	out.CommonName = in.CommonName
	return nil
}

// Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity is an autogenerated conversion function.
func Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(in *image.SignatureGenericEntity, out *v1.SignatureGenericEntity, s conversion.Scope) error {
	return autoConvert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(in, out, s)
}

func autoConvert_v1_SignatureIssuer_To_image_SignatureIssuer(in *v1.SignatureIssuer, out *image.SignatureIssuer, s conversion.Scope) error {
	if err := Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_SignatureIssuer_To_image_SignatureIssuer is an autogenerated conversion function.
func Convert_v1_SignatureIssuer_To_image_SignatureIssuer(in *v1.SignatureIssuer, out *image.SignatureIssuer, s conversion.Scope) error {
	return autoConvert_v1_SignatureIssuer_To_image_SignatureIssuer(in, out, s)
}

func autoConvert_image_SignatureIssuer_To_v1_SignatureIssuer(in *image.SignatureIssuer, out *v1.SignatureIssuer, s conversion.Scope) error {
	if err := Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_SignatureIssuer_To_v1_SignatureIssuer is an autogenerated conversion function.
func Convert_image_SignatureIssuer_To_v1_SignatureIssuer(in *image.SignatureIssuer, out *v1.SignatureIssuer, s conversion.Scope) error {
	return autoConvert_image_SignatureIssuer_To_v1_SignatureIssuer(in, out, s)
}

func autoConvert_v1_SignatureSubject_To_image_SignatureSubject(in *v1.SignatureSubject, out *image.SignatureSubject, s conversion.Scope) error {
	if err := Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	out.PublicKeyID = in.PublicKeyID
	return nil
}

// Convert_v1_SignatureSubject_To_image_SignatureSubject is an autogenerated conversion function.
func Convert_v1_SignatureSubject_To_image_SignatureSubject(in *v1.SignatureSubject, out *image.SignatureSubject, s conversion.Scope) error {
	return autoConvert_v1_SignatureSubject_To_image_SignatureSubject(in, out, s)
}

func autoConvert_image_SignatureSubject_To_v1_SignatureSubject(in *image.SignatureSubject, out *v1.SignatureSubject, s conversion.Scope) error {
	if err := Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	out.PublicKeyID = in.PublicKeyID
	return nil
}

// Convert_image_SignatureSubject_To_v1_SignatureSubject is an autogenerated conversion function.
func Convert_image_SignatureSubject_To_v1_SignatureSubject(in *image.SignatureSubject, out *v1.SignatureSubject, s conversion.Scope) error {
	return autoConvert_image_SignatureSubject_To_v1_SignatureSubject(in, out, s)
}

func autoConvert_v1_TagEvent_To_image_TagEvent(in *v1.TagEvent, out *image.TagEvent, s conversion.Scope) error {
	out.Created = in.Created
	out.DockerImageReference = in.DockerImageReference
	out.Image = in.Image
	out.Generation = in.Generation
	return nil
}

// Convert_v1_TagEvent_To_image_TagEvent is an autogenerated conversion function.
func Convert_v1_TagEvent_To_image_TagEvent(in *v1.TagEvent, out *image.TagEvent, s conversion.Scope) error {
	return autoConvert_v1_TagEvent_To_image_TagEvent(in, out, s)
}

func autoConvert_image_TagEvent_To_v1_TagEvent(in *image.TagEvent, out *v1.TagEvent, s conversion.Scope) error {
	out.Created = in.Created
	out.DockerImageReference = in.DockerImageReference
	out.Image = in.Image
	out.Generation = in.Generation
	return nil
}

// Convert_image_TagEvent_To_v1_TagEvent is an autogenerated conversion function.
func Convert_image_TagEvent_To_v1_TagEvent(in *image.TagEvent, out *v1.TagEvent, s conversion.Scope) error {
	return autoConvert_image_TagEvent_To_v1_TagEvent(in, out, s)
}

func autoConvert_v1_TagEventCondition_To_image_TagEventCondition(in *v1.TagEventCondition, out *image.TagEventCondition, s conversion.Scope) error {
	out.Type = image.TagEventConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	out.Generation = in.Generation
	return nil
}

// Convert_v1_TagEventCondition_To_image_TagEventCondition is an autogenerated conversion function.
func Convert_v1_TagEventCondition_To_image_TagEventCondition(in *v1.TagEventCondition, out *image.TagEventCondition, s conversion.Scope) error {
	return autoConvert_v1_TagEventCondition_To_image_TagEventCondition(in, out, s)
}

func autoConvert_image_TagEventCondition_To_v1_TagEventCondition(in *image.TagEventCondition, out *v1.TagEventCondition, s conversion.Scope) error {
	out.Type = v1.TagEventConditionType(in.Type)
	out.Status = api_core_v1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	out.Generation = in.Generation
	return nil
}

// Convert_image_TagEventCondition_To_v1_TagEventCondition is an autogenerated conversion function.
func Convert_image_TagEventCondition_To_v1_TagEventCondition(in *image.TagEventCondition, out *v1.TagEventCondition, s conversion.Scope) error {
	return autoConvert_image_TagEventCondition_To_v1_TagEventCondition(in, out, s)
}

func autoConvert_v1_TagImportPolicy_To_image_TagImportPolicy(in *v1.TagImportPolicy, out *image.TagImportPolicy, s conversion.Scope) error {
	out.Insecure = in.Insecure
	out.Scheduled = in.Scheduled
	return nil
}

// Convert_v1_TagImportPolicy_To_image_TagImportPolicy is an autogenerated conversion function.
func Convert_v1_TagImportPolicy_To_image_TagImportPolicy(in *v1.TagImportPolicy, out *image.TagImportPolicy, s conversion.Scope) error {
	return autoConvert_v1_TagImportPolicy_To_image_TagImportPolicy(in, out, s)
}

func autoConvert_image_TagImportPolicy_To_v1_TagImportPolicy(in *image.TagImportPolicy, out *v1.TagImportPolicy, s conversion.Scope) error {
	out.Insecure = in.Insecure
	out.Scheduled = in.Scheduled
	return nil
}

// Convert_image_TagImportPolicy_To_v1_TagImportPolicy is an autogenerated conversion function.
func Convert_image_TagImportPolicy_To_v1_TagImportPolicy(in *image.TagImportPolicy, out *v1.TagImportPolicy, s conversion.Scope) error {
	return autoConvert_image_TagImportPolicy_To_v1_TagImportPolicy(in, out, s)
}

func autoConvert_v1_TagReference_To_image_TagReference(in *v1.TagReference, out *image.TagReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Reference = in.Reference
	out.Generation = (*int64)(unsafe.Pointer(in.Generation))
	if err := Convert_v1_TagImportPolicy_To_image_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_TagReference_To_image_TagReference is an autogenerated conversion function.
func Convert_v1_TagReference_To_image_TagReference(in *v1.TagReference, out *image.TagReference, s conversion.Scope) error {
	return autoConvert_v1_TagReference_To_image_TagReference(in, out, s)
}

func autoConvert_image_TagReference_To_v1_TagReference(in *image.TagReference, out *v1.TagReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Reference = in.Reference
	out.Generation = (*int64)(unsafe.Pointer(in.Generation))
	if err := Convert_image_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_TagReference_To_v1_TagReference is an autogenerated conversion function.
func Convert_image_TagReference_To_v1_TagReference(in *image.TagReference, out *v1.TagReference, s conversion.Scope) error {
	return autoConvert_image_TagReference_To_v1_TagReference(in, out, s)
}

func autoConvert_v1_TagReferencePolicy_To_image_TagReferencePolicy(in *v1.TagReferencePolicy, out *image.TagReferencePolicy, s conversion.Scope) error {
	out.Type = image.TagReferencePolicyType(in.Type)
	return nil
}

// Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy is an autogenerated conversion function.
func Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(in *v1.TagReferencePolicy, out *image.TagReferencePolicy, s conversion.Scope) error {
	return autoConvert_v1_TagReferencePolicy_To_image_TagReferencePolicy(in, out, s)
}

func autoConvert_image_TagReferencePolicy_To_v1_TagReferencePolicy(in *image.TagReferencePolicy, out *v1.TagReferencePolicy, s conversion.Scope) error {
	out.Type = v1.TagReferencePolicyType(in.Type)
	return nil
}

// Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy is an autogenerated conversion function.
func Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(in *image.TagReferencePolicy, out *v1.TagReferencePolicy, s conversion.Scope) error {
	return autoConvert_image_TagReferencePolicy_To_v1_TagReferencePolicy(in, out, s)
}
