package automation

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/satori/go.uuid"
	"io"
	"net/http"
)

// AccountState enumerates the values for account state.
type AccountState string

const (
	// Ok ...
	Ok AccountState = "Ok"
	// Suspended ...
	Suspended AccountState = "Suspended"
	// Unavailable ...
	Unavailable AccountState = "Unavailable"
)

// AgentRegistrationKeyName enumerates the values for agent registration key name.
type AgentRegistrationKeyName string

const (
	// Primary ...
	Primary AgentRegistrationKeyName = "Primary"
	// Secondary ...
	Secondary AgentRegistrationKeyName = "Secondary"
)

// ContentSourceType enumerates the values for content source type.
type ContentSourceType string

const (
	// EmbeddedContent ...
	EmbeddedContent ContentSourceType = "embeddedContent"
	// URI ...
	URI ContentSourceType = "uri"
)

// DscConfigurationProvisioningState enumerates the values for dsc configuration provisioning state.
type DscConfigurationProvisioningState string

const (
	// Succeeded ...
	Succeeded DscConfigurationProvisioningState = "Succeeded"
)

// DscConfigurationState enumerates the values for dsc configuration state.
type DscConfigurationState string

const (
	// DscConfigurationStateEdit ...
	DscConfigurationStateEdit DscConfigurationState = "Edit"
	// DscConfigurationStateNew ...
	DscConfigurationStateNew DscConfigurationState = "New"
	// DscConfigurationStatePublished ...
	DscConfigurationStatePublished DscConfigurationState = "Published"
)

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// Ambiguous ...
	Ambiguous HTTPStatusCode = "Ambiguous"
	// BadGateway ...
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest ...
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// ExpectationFailed ...
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden ...
	Forbidden HTTPStatusCode = "Forbidden"
	// Found ...
	Found HTTPStatusCode = "Found"
	// GatewayTimeout ...
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone ...
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported ...
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError ...
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired ...
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed ...
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// Moved ...
	Moved HTTPStatusCode = "Moved"
	// MovedPermanently ...
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices ...
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent ...
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation ...
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable ...
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented ...
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified ...
	NotModified HTTPStatusCode = "NotModified"
	// OK ...
	OK HTTPStatusCode = "OK"
	// PartialContent ...
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired ...
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed ...
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired ...
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect ...
	Redirect HTTPStatusCode = "Redirect"
	// RedirectKeepVerb ...
	RedirectKeepVerb HTTPStatusCode = "RedirectKeepVerb"
	// RedirectMethod ...
	RedirectMethod HTTPStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable ...
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge ...
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout ...
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong ...
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent ...
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther ...
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable ...
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols ...
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect ...
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized ...
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType ...
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused ...
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired ...
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy ...
	UseProxy HTTPStatusCode = "UseProxy"
)

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusActivating ...
	JobStatusActivating JobStatus = "Activating"
	// JobStatusBlocked ...
	JobStatusBlocked JobStatus = "Blocked"
	// JobStatusCompleted ...
	JobStatusCompleted JobStatus = "Completed"
	// JobStatusDisconnected ...
	JobStatusDisconnected JobStatus = "Disconnected"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "Failed"
	// JobStatusNew ...
	JobStatusNew JobStatus = "New"
	// JobStatusRemoving ...
	JobStatusRemoving JobStatus = "Removing"
	// JobStatusResuming ...
	JobStatusResuming JobStatus = "Resuming"
	// JobStatusRunning ...
	JobStatusRunning JobStatus = "Running"
	// JobStatusStopped ...
	JobStatusStopped JobStatus = "Stopped"
	// JobStatusStopping ...
	JobStatusStopping JobStatus = "Stopping"
	// JobStatusSuspended ...
	JobStatusSuspended JobStatus = "Suspended"
	// JobStatusSuspending ...
	JobStatusSuspending JobStatus = "Suspending"
)

// JobStreamType enumerates the values for job stream type.
type JobStreamType string

const (
	// Any ...
	Any JobStreamType = "Any"
	// Debug ...
	Debug JobStreamType = "Debug"
	// Error ...
	Error JobStreamType = "Error"
	// Output ...
	Output JobStreamType = "Output"
	// Progress ...
	Progress JobStreamType = "Progress"
	// Verbose ...
	Verbose JobStreamType = "Verbose"
	// Warning ...
	Warning JobStreamType = "Warning"
)

// ModuleProvisioningState enumerates the values for module provisioning state.
type ModuleProvisioningState string

const (
	// ModuleProvisioningStateActivitiesStored ...
	ModuleProvisioningStateActivitiesStored ModuleProvisioningState = "ActivitiesStored"
	// ModuleProvisioningStateCancelled ...
	ModuleProvisioningStateCancelled ModuleProvisioningState = "Cancelled"
	// ModuleProvisioningStateConnectionTypeImported ...
	ModuleProvisioningStateConnectionTypeImported ModuleProvisioningState = "ConnectionTypeImported"
	// ModuleProvisioningStateContentDownloaded ...
	ModuleProvisioningStateContentDownloaded ModuleProvisioningState = "ContentDownloaded"
	// ModuleProvisioningStateContentRetrieved ...
	ModuleProvisioningStateContentRetrieved ModuleProvisioningState = "ContentRetrieved"
	// ModuleProvisioningStateContentStored ...
	ModuleProvisioningStateContentStored ModuleProvisioningState = "ContentStored"
	// ModuleProvisioningStateContentValidated ...
	ModuleProvisioningStateContentValidated ModuleProvisioningState = "ContentValidated"
	// ModuleProvisioningStateCreated ...
	ModuleProvisioningStateCreated ModuleProvisioningState = "Created"
	// ModuleProvisioningStateCreating ...
	ModuleProvisioningStateCreating ModuleProvisioningState = "Creating"
	// ModuleProvisioningStateFailed ...
	ModuleProvisioningStateFailed ModuleProvisioningState = "Failed"
	// ModuleProvisioningStateModuleDataStored ...
	ModuleProvisioningStateModuleDataStored ModuleProvisioningState = "ModuleDataStored"
	// ModuleProvisioningStateModuleImportRunbookComplete ...
	ModuleProvisioningStateModuleImportRunbookComplete ModuleProvisioningState = "ModuleImportRunbookComplete"
	// ModuleProvisioningStateRunningImportModuleRunbook ...
	ModuleProvisioningStateRunningImportModuleRunbook ModuleProvisioningState = "RunningImportModuleRunbook"
	// ModuleProvisioningStateStartingImportModuleRunbook ...
	ModuleProvisioningStateStartingImportModuleRunbook ModuleProvisioningState = "StartingImportModuleRunbook"
	// ModuleProvisioningStateSucceeded ...
	ModuleProvisioningStateSucceeded ModuleProvisioningState = "Succeeded"
	// ModuleProvisioningStateUpdating ...
	ModuleProvisioningStateUpdating ModuleProvisioningState = "Updating"
)

// RunbookProvisioningState enumerates the values for runbook provisioning state.
type RunbookProvisioningState string

const (
	// RunbookProvisioningStateSucceeded ...
	RunbookProvisioningStateSucceeded RunbookProvisioningState = "Succeeded"
)

// RunbookState enumerates the values for runbook state.
type RunbookState string

const (
	// RunbookStateEdit ...
	RunbookStateEdit RunbookState = "Edit"
	// RunbookStateNew ...
	RunbookStateNew RunbookState = "New"
	// RunbookStatePublished ...
	RunbookStatePublished RunbookState = "Published"
)

// RunbookTypeEnum enumerates the values for runbook type enum.
type RunbookTypeEnum string

const (
	// Graph ...
	Graph RunbookTypeEnum = "Graph"
	// GraphPowerShell ...
	GraphPowerShell RunbookTypeEnum = "GraphPowerShell"
	// GraphPowerShellWorkflow ...
	GraphPowerShellWorkflow RunbookTypeEnum = "GraphPowerShellWorkflow"
	// PowerShell ...
	PowerShell RunbookTypeEnum = "PowerShell"
	// PowerShellWorkflow ...
	PowerShellWorkflow RunbookTypeEnum = "PowerShellWorkflow"
	// Script ...
	Script RunbookTypeEnum = "Script"
)

// ScheduleDay enumerates the values for schedule day.
type ScheduleDay string

const (
	// Friday ...
	Friday ScheduleDay = "Friday"
	// Monday ...
	Monday ScheduleDay = "Monday"
	// Saturday ...
	Saturday ScheduleDay = "Saturday"
	// Sunday ...
	Sunday ScheduleDay = "Sunday"
	// Thursday ...
	Thursday ScheduleDay = "Thursday"
	// Tuesday ...
	Tuesday ScheduleDay = "Tuesday"
	// Wednesday ...
	Wednesday ScheduleDay = "Wednesday"
)

// ScheduleFrequency enumerates the values for schedule frequency.
type ScheduleFrequency string

const (
	// Day ...
	Day ScheduleFrequency = "Day"
	// Hour ...
	Hour ScheduleFrequency = "Hour"
	// Month ...
	Month ScheduleFrequency = "Month"
	// OneTime ...
	OneTime ScheduleFrequency = "OneTime"
	// Week ...
	Week ScheduleFrequency = "Week"
)

// SkuNameEnum enumerates the values for sku name enum.
type SkuNameEnum string

const (
	// Basic ...
	Basic SkuNameEnum = "Basic"
	// Free ...
	Free SkuNameEnum = "Free"
)

// Account definition of the automation account type.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - Gets or sets the automation account properties.
	*AccountProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				a.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// AccountCreateOrUpdateParameters the parameters supplied to the create or update automation account operation.
type AccountCreateOrUpdateParameters struct {
	// AccountCreateOrUpdateProperties - Gets or sets account create or update properties.
	*AccountCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AccountCreateOrUpdateParameters.
func (acoup AccountCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acoup.AccountCreateOrUpdateProperties != nil {
		objectMap["properties"] = acoup.AccountCreateOrUpdateProperties
	}
	if acoup.Name != nil {
		objectMap["name"] = acoup.Name
	}
	if acoup.Location != nil {
		objectMap["location"] = acoup.Location
	}
	if acoup.Tags != nil {
		objectMap["tags"] = acoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountCreateOrUpdateParameters struct.
func (acoup *AccountCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountCreateOrUpdateProperties AccountCreateOrUpdateProperties
				err = json.Unmarshal(*v, &accountCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				acoup.AccountCreateOrUpdateProperties = &accountCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				acoup.Tags = tags
			}
		}
	}

	return nil
}

// AccountCreateOrUpdateProperties the parameters supplied to the create or update account properties.
type AccountCreateOrUpdateProperties struct {
	// Sku - Gets or sets account SKU.
	Sku *Sku `json:"sku,omitempty"`
}

// AccountListResult the response model for the list account operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets list of accounts.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer() (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) Next() error {
	next, err := page.fn(page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// AccountProperties definition of the account property.
type AccountProperties struct {
	// Sku - Gets or sets the SKU of account.
	Sku *Sku `json:"sku,omitempty"`
	// LastModifiedBy - Gets or sets the last modified by.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// State - Gets status of account. Possible values include: 'Ok', 'Unavailable', 'Suspended'
	State AccountState `json:"state,omitempty"`
	// CreationTime - Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// AccountUpdateParameters the parameters supplied to the update automation account operation.
type AccountUpdateParameters struct {
	// AccountUpdateProperties - Gets or sets account update properties.
	*AccountUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.AccountUpdateProperties != nil {
		objectMap["properties"] = aup.AccountUpdateProperties
	}
	if aup.Name != nil {
		objectMap["name"] = aup.Name
	}
	if aup.Location != nil {
		objectMap["location"] = aup.Location
	}
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateParameters struct.
func (aup *AccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountUpdateProperties AccountUpdateProperties
				err = json.Unmarshal(*v, &accountUpdateProperties)
				if err != nil {
					return err
				}
				aup.AccountUpdateProperties = &accountUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		}
	}

	return nil
}

// AccountUpdateProperties the parameters supplied to the update account properties.
type AccountUpdateProperties struct {
	// Sku - Gets or sets account SKU.
	Sku *Sku `json:"sku,omitempty"`
}

// Activity definition of the activity.
type Activity struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets the name of the activity.
	Name *string `json:"name,omitempty"`
	// ActivityProperties - Gets or sets the properties of the activity.
	*ActivityProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Activity struct.
func (a *Activity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "properties":
			if v != nil {
				var activityProperties ActivityProperties
				err = json.Unmarshal(*v, &activityProperties)
				if err != nil {
					return err
				}
				a.ActivityProperties = &activityProperties
			}
		}
	}

	return nil
}

// ActivityListResult the response model for the list activity operation.
type ActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of activities.
	Value *[]Activity `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActivityListResultIterator provides access to a complete listing of Activity values.
type ActivityListResultIterator struct {
	i    int
	page ActivityListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActivityListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActivityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActivityListResultIterator) Response() ActivityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActivityListResultIterator) Value() Activity {
	if !iter.page.NotDone() {
		return Activity{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ActivityListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// activityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ActivityListResult) activityListResultPreparer() (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ActivityListResultPage contains a page of Activity values.
type ActivityListResultPage struct {
	fn  func(ActivityListResult) (ActivityListResult, error)
	alr ActivityListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActivityListResultPage) Next() error {
	next, err := page.fn(page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActivityListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActivityListResultPage) Response() ActivityListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActivityListResultPage) Values() []Activity {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// ActivityOutputType definition of the activity output type.
type ActivityOutputType struct {
	// Name - Gets or sets the name of the activity output type.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the activity output type.
	Type *string `json:"type,omitempty"`
}

// ActivityParameter definition of the activity parameter.
type ActivityParameter struct {
	// Name - Gets or sets the name of the activity parameter.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the activity parameter.
	Type *string `json:"type,omitempty"`
	// IsMandatory - Gets or sets a Boolean value that indicates true if the parameter is required. If the value is false, the parameter is optional.
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// IsDynamic - Gets or sets a Boolean value that indicates true if the parameter is dynamic.
	IsDynamic *bool `json:"isDynamic,omitempty"`
	// Position - Gets or sets the position of the activity parameter.
	Position *bool `json:"position,omitempty"`
	// ValueFromPipeline - Gets or sets a Boolean value that indicates true if the parameter can take values from the incoming pipeline objects. This setting is used if the cmdlet must access the complete input object. false indicates that the parameter cannot take values from the complete input object.
	ValueFromPipeline *bool `json:"valueFromPipeline,omitempty"`
	// ValueFromPipelineByPropertyName - Gets or sets a Boolean value that indicates true if the parameter can be filled from a property of the incoming pipeline object that has the same name as this parameter. false indicates that the parameter cannot be filled from the incoming pipeline object property with the same name.
	ValueFromPipelineByPropertyName *bool `json:"valueFromPipelineByPropertyName,omitempty"`
	// ValueFromRemainingArguments - Gets or sets a Boolean value that indicates true if the cmdlet parameter accepts all the remaining command-line arguments that are associated with this parameter in the form of an array. false if the cmdlet parameter does not accept all the remaining argument values.
	ValueFromRemainingArguments *bool `json:"valueFromRemainingArguments,omitempty"`
}

// ActivityParameterSet definition of the activity parameter set.
type ActivityParameterSet struct {
	// Name - Gets or sets the name of the activity parameter set.
	Name *string `json:"name,omitempty"`
	// Parameters - Gets or sets the parameters of the activity parameter set.
	Parameters *[]ActivityParameter `json:"parameters,omitempty"`
}

// ActivityProperties properties of the activity.
type ActivityProperties struct {
	// Definition - Gets or sets the user name of the activity.
	Definition *string `json:"definition,omitempty"`
	// ParameterSets - Gets or sets the parameter sets of the activity.
	ParameterSets *[]ActivityParameterSet `json:"parameterSets,omitempty"`
	// OutputTypes - Gets or sets the output types of the activity.
	OutputTypes *[]ActivityOutputType `json:"outputTypes,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// AdvancedSchedule the properties of the create Advanced Schedule.
type AdvancedSchedule struct {
	// WeekDays - Days of the week that the job should execute on.
	WeekDays *[]string `json:"weekDays,omitempty"`
	// MonthDays - Days of the month that the job should execute on. Must be between 1 and 31.
	MonthDays *[]int32 `json:"monthDays,omitempty"`
	// MonthlyOccurrences - Occurrences of days within a month.
	MonthlyOccurrences *[]AdvancedScheduleMonthlyOccurrence `json:"monthlyOccurrences,omitempty"`
}

// AdvancedScheduleMonthlyOccurrence the properties of the create advanced schedule monthly occurrence.
type AdvancedScheduleMonthlyOccurrence struct {
	// Occurrence - Occurrence of the week within the month. Must be between 1 and 5
	Occurrence *int32 `json:"occurrence,omitempty"`
	// Day - Day of the occurrence. Must be one of monday, tuesday, wednesday,thursday, friday, saturday, sunday. Possible values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'
	Day ScheduleDay `json:"day,omitempty"`
}

// AgentRegistration definition of the agent registration infomration type.
type AgentRegistration struct {
	autorest.Response `json:"-"`
	// DscMetaConfiguration - Gets or sets the dsc meta configuration.
	DscMetaConfiguration *string `json:"dscMetaConfiguration,omitempty"`
	// Endpoint - Gets or sets the dsc server endpoint.
	Endpoint *string `json:"endpoint,omitempty"`
	// Keys - Gets or sets the agent registration keys.
	Keys *AgentRegistrationKeys `json:"keys,omitempty"`
	// ID - Gets or sets the id.
	ID *string `json:"id,omitempty"`
}

// AgentRegistrationKeys definition of the agent registration keys.
type AgentRegistrationKeys struct {
	// Primary - Gets or sets the primary key.
	Primary *string `json:"primary,omitempty"`
	// Secondary - Gets or sets the secondary key.
	Secondary *string `json:"secondary,omitempty"`
}

// AgentRegistrationRegenerateKeyParameter the parameters supplied to the regenerate keys operation.
type AgentRegistrationRegenerateKeyParameter struct {
	// KeyName - Gets or sets the agent registration key name - Primary or Secondary. Possible values include: 'Primary', 'Secondary'
	KeyName AgentRegistrationKeyName `json:"keyName,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AgentRegistrationRegenerateKeyParameter.
func (arrkp AgentRegistrationRegenerateKeyParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["keyName"] = arrkp.KeyName
	if arrkp.Name != nil {
		objectMap["name"] = arrkp.Name
	}
	if arrkp.Location != nil {
		objectMap["location"] = arrkp.Location
	}
	if arrkp.Tags != nil {
		objectMap["tags"] = arrkp.Tags
	}
	return json.Marshal(objectMap)
}

// Certificate definition of the certificate.
type Certificate struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets the name of the certificate.
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// CertificateProperties - Gets or sets the properties of the certificate.
	*CertificateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Certificate struct.
func (c *Certificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var certificateProperties CertificateProperties
				err = json.Unmarshal(*v, &certificateProperties)
				if err != nil {
					return err
				}
				c.CertificateProperties = &certificateProperties
			}
		}
	}

	return nil
}

// CertificateCreateOrUpdateParameters the parameters supplied to the create or update or replace certificate
// operation.
type CertificateCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the certificate.
	Name *string `json:"name,omitempty"`
	// CertificateCreateOrUpdateProperties - Gets or sets the properties of the certificate.
	*CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CertificateCreateOrUpdateParameters struct.
func (ccoup *CertificateCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "properties":
			if v != nil {
				var certificateCreateOrUpdateProperties CertificateCreateOrUpdateProperties
				err = json.Unmarshal(*v, &certificateCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.CertificateCreateOrUpdateProperties = &certificateCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// CertificateCreateOrUpdateProperties the properties of the create certificate operation.
type CertificateCreateOrUpdateProperties struct {
	// Base64Value - Gets or sets the base64 encoded value of the certificate.
	Base64Value *string `json:"base64Value,omitempty"`
	// Description - Gets or sets the description of the certificate.
	Description *string `json:"description,omitempty"`
	// Thumbprint - Gets or sets the thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsExportable - Gets or sets the is exportable flag of the certificate.
	IsExportable *bool `json:"isExportable,omitempty"`
}

// CertificateListResult the response model for the list certificate operation.
type CertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of certificates.
	Value *[]Certificate `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateListResultIterator provides access to a complete listing of Certificate values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer() (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CertificateListResultPage contains a page of Certificate values.
type CertificateListResultPage struct {
	fn  func(CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) Next() error {
	next, err := page.fn(page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []Certificate {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// CertificateProperties properties of the certificate.
type CertificateProperties struct {
	// Thumbprint - Gets the thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ExpiryTime - Gets the expiry time of the certificate.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// IsExportable - Gets the is exportable flag of the certificate.
	IsExportable *bool `json:"isExportable,omitempty"`
	// CreationTime - Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// CertificateUpdateParameters the parameters supplied to the update certificate operation.
type CertificateUpdateParameters struct {
	// Name - Gets or sets the name of the certificate.
	Name *string `json:"name,omitempty"`
	// CertificateUpdateProperties - Gets or sets the properties of the certificate.
	*CertificateUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CertificateUpdateParameters struct.
func (cup *CertificateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cup.Name = &name
			}
		case "properties":
			if v != nil {
				var certificateUpdateProperties CertificateUpdateProperties
				err = json.Unmarshal(*v, &certificateUpdateProperties)
				if err != nil {
					return err
				}
				cup.CertificateUpdateProperties = &certificateUpdateProperties
			}
		}
	}

	return nil
}

// CertificateUpdateProperties the properties of the update certificate operation
type CertificateUpdateProperties struct {
	// Description - Gets or sets the description of the certificate.
	Description *string `json:"description,omitempty"`
}

// Connection definition of the connection.
type Connection struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets the name of the connection.
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// ConnectionProperties - Gets or sets the properties of the connection.
	*ConnectionProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Connection struct.
func (c *Connection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var connectionProperties ConnectionProperties
				err = json.Unmarshal(*v, &connectionProperties)
				if err != nil {
					return err
				}
				c.ConnectionProperties = &connectionProperties
			}
		}
	}

	return nil
}

// ConnectionCreateOrUpdateParameters the parameters supplied to the create or update connection operation.
type ConnectionCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the connection.
	Name *string `json:"name,omitempty"`
	// ConnectionCreateOrUpdateProperties - Gets or sets the properties of the connection.
	*ConnectionCreateOrUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectionCreateOrUpdateParameters struct.
func (ccoup *ConnectionCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "properties":
			if v != nil {
				var connectionCreateOrUpdateProperties ConnectionCreateOrUpdateProperties
				err = json.Unmarshal(*v, &connectionCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.ConnectionCreateOrUpdateProperties = &connectionCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// ConnectionCreateOrUpdateProperties the properties of the create connection properties
type ConnectionCreateOrUpdateProperties struct {
	// Description - Gets or sets the description of the connection.
	Description *string `json:"description,omitempty"`
	// ConnectionType - Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`
	// FieldDefinitionValues - Gets or sets the field definition properties of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues"`
}

// MarshalJSON is the custom marshaler for ConnectionCreateOrUpdateProperties.
func (ccoup ConnectionCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.Description != nil {
		objectMap["description"] = ccoup.Description
	}
	if ccoup.ConnectionType != nil {
		objectMap["connectionType"] = ccoup.ConnectionType
	}
	if ccoup.FieldDefinitionValues != nil {
		objectMap["fieldDefinitionValues"] = ccoup.FieldDefinitionValues
	}
	return json.Marshal(objectMap)
}

// ConnectionListResult the response model for the list connection operation.
type ConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of connection.
	Value *[]Connection `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectionListResultIterator provides access to a complete listing of Connection values.
type ConnectionListResultIterator struct {
	i    int
	page ConnectionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionListResultIterator) Response() ConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionListResultIterator) Value() Connection {
	if !iter.page.NotDone() {
		return Connection{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ConnectionListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// connectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ConnectionListResult) connectionListResultPreparer() (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ConnectionListResultPage contains a page of Connection values.
type ConnectionListResultPage struct {
	fn  func(ConnectionListResult) (ConnectionListResult, error)
	clr ConnectionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionListResultPage) Next() error {
	next, err := page.fn(page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionListResultPage) Response() ConnectionListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionListResultPage) Values() []Connection {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// ConnectionProperties definition of the connection properties.
type ConnectionProperties struct {
	// ConnectionType - Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`
	// FieldDefinitionValues - Gets the field definition values of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues"`
	// CreationTime - Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionProperties.
func (cp ConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ConnectionType != nil {
		objectMap["connectionType"] = cp.ConnectionType
	}
	if cp.FieldDefinitionValues != nil {
		objectMap["fieldDefinitionValues"] = cp.FieldDefinitionValues
	}
	if cp.CreationTime != nil {
		objectMap["creationTime"] = cp.CreationTime
	}
	if cp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = cp.LastModifiedTime
	}
	if cp.Description != nil {
		objectMap["description"] = cp.Description
	}
	return json.Marshal(objectMap)
}

// ConnectionType definition of the connection type.
type ConnectionType struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets the name of the connection type.
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// ConnectionTypeProperties - Gets or sets the properties of the connection type.
	*ConnectionTypeProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectionType struct.
func (ct *ConnectionType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ct.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ct.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ct.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var connectionTypeProperties ConnectionTypeProperties
				err = json.Unmarshal(*v, &connectionTypeProperties)
				if err != nil {
					return err
				}
				ct.ConnectionTypeProperties = &connectionTypeProperties
			}
		}
	}

	return nil
}

// ConnectionTypeAssociationProperty the connection type property associated with the entity.
type ConnectionTypeAssociationProperty struct {
	// Name - Gets or sets the name of the connection type.
	Name *string `json:"name,omitempty"`
}

// ConnectionTypeCreateOrUpdateParameters the parameters supplied to the create or update connection type
// operation.
type ConnectionTypeCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the connection type.
	Name *string `json:"name,omitempty"`
	// ConnectionTypeCreateOrUpdateProperties - Gets or sets the value of the connection type.
	*ConnectionTypeCreateOrUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectionTypeCreateOrUpdateParameters struct.
func (ctcoup *ConnectionTypeCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ctcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var connectionTypeCreateOrUpdateProperties ConnectionTypeCreateOrUpdateProperties
				err = json.Unmarshal(*v, &connectionTypeCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ctcoup.ConnectionTypeCreateOrUpdateProperties = &connectionTypeCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// ConnectionTypeCreateOrUpdateProperties the properties of the create connection type.
type ConnectionTypeCreateOrUpdateProperties struct {
	// IsGlobal - Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool `json:"isGlobal,omitempty"`
	// FieldDefinitions - Gets or sets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition `json:"fieldDefinitions"`
}

// MarshalJSON is the custom marshaler for ConnectionTypeCreateOrUpdateProperties.
func (ctcoup ConnectionTypeCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcoup.IsGlobal != nil {
		objectMap["isGlobal"] = ctcoup.IsGlobal
	}
	if ctcoup.FieldDefinitions != nil {
		objectMap["fieldDefinitions"] = ctcoup.FieldDefinitions
	}
	return json.Marshal(objectMap)
}

// ConnectionTypeListResult the response model for the list connection type operation.
type ConnectionTypeListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of connection types.
	Value *[]ConnectionType `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectionTypeListResultIterator provides access to a complete listing of ConnectionType values.
type ConnectionTypeListResultIterator struct {
	i    int
	page ConnectionTypeListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionTypeListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionTypeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionTypeListResultIterator) Response() ConnectionTypeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionTypeListResultIterator) Value() ConnectionType {
	if !iter.page.NotDone() {
		return ConnectionType{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ctlr ConnectionTypeListResult) IsEmpty() bool {
	return ctlr.Value == nil || len(*ctlr.Value) == 0
}

// connectionTypeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ctlr ConnectionTypeListResult) connectionTypeListResultPreparer() (*http.Request, error) {
	if ctlr.NextLink == nil || len(to.String(ctlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ctlr.NextLink)))
}

// ConnectionTypeListResultPage contains a page of ConnectionType values.
type ConnectionTypeListResultPage struct {
	fn   func(ConnectionTypeListResult) (ConnectionTypeListResult, error)
	ctlr ConnectionTypeListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionTypeListResultPage) Next() error {
	next, err := page.fn(page.ctlr)
	if err != nil {
		return err
	}
	page.ctlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionTypeListResultPage) NotDone() bool {
	return !page.ctlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionTypeListResultPage) Response() ConnectionTypeListResult {
	return page.ctlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionTypeListResultPage) Values() []ConnectionType {
	if page.ctlr.IsEmpty() {
		return nil
	}
	return *page.ctlr.Value
}

// ConnectionTypeProperties properties of the connection type.
type ConnectionTypeProperties struct {
	// IsGlobal - Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool `json:"isGlobal,omitempty"`
	// FieldDefinitions - Gets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition `json:"fieldDefinitions"`
	// CreationTime - Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionTypeProperties.
func (ctp ConnectionTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctp.IsGlobal != nil {
		objectMap["isGlobal"] = ctp.IsGlobal
	}
	if ctp.FieldDefinitions != nil {
		objectMap["fieldDefinitions"] = ctp.FieldDefinitions
	}
	if ctp.CreationTime != nil {
		objectMap["creationTime"] = ctp.CreationTime
	}
	if ctp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = ctp.LastModifiedTime
	}
	if ctp.Description != nil {
		objectMap["description"] = ctp.Description
	}
	return json.Marshal(objectMap)
}

// ConnectionUpdateParameters the parameters supplied to the update connection operation.
type ConnectionUpdateParameters struct {
	// Name - Gets or sets the name of the connection.
	Name *string `json:"name,omitempty"`
	// ConnectionUpdateProperties - Gets or sets the properties of the connection.
	*ConnectionUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectionUpdateParameters struct.
func (cup *ConnectionUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cup.Name = &name
			}
		case "properties":
			if v != nil {
				var connectionUpdateProperties ConnectionUpdateProperties
				err = json.Unmarshal(*v, &connectionUpdateProperties)
				if err != nil {
					return err
				}
				cup.ConnectionUpdateProperties = &connectionUpdateProperties
			}
		}
	}

	return nil
}

// ConnectionUpdateProperties the properties of the update connection operation.
type ConnectionUpdateProperties struct {
	// Description - Gets or sets the description of the connection.
	Description *string `json:"description,omitempty"`
	// FieldDefinitionValues - Gets or sets the field definition values of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues"`
}

// MarshalJSON is the custom marshaler for ConnectionUpdateProperties.
func (cup ConnectionUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.Description != nil {
		objectMap["description"] = cup.Description
	}
	if cup.FieldDefinitionValues != nil {
		objectMap["fieldDefinitionValues"] = cup.FieldDefinitionValues
	}
	return json.Marshal(objectMap)
}

// ContentHash definition of the runbook property type.
type ContentHash struct {
	// Algorithm - Gets or sets the content hash algorithm used to hash the content.
	Algorithm *string `json:"algorithm,omitempty"`
	// Value - Gets or sets expected hash value of the content.
	Value *string `json:"value,omitempty"`
}

// ContentLink definition of the content link.
type ContentLink struct {
	// URI - Gets or sets the uri of the runbook content.
	URI *string `json:"uri,omitempty"`
	// ContentHash - Gets or sets the hash.
	ContentHash *ContentHash `json:"contentHash,omitempty"`
	// Version - Gets or sets the version of the content.
	Version *string `json:"version,omitempty"`
}

// ContentSource definition of the content source.
type ContentSource struct {
	// Hash - Gets or sets the hash.
	Hash *ContentHash `json:"hash,omitempty"`
	// Type - Gets or sets the content source type. Possible values include: 'EmbeddedContent', 'URI'
	Type ContentSourceType `json:"type,omitempty"`
	// Value - Gets or sets the value of the content. This is based on the content source type.
	Value *string `json:"value,omitempty"`
	// Version - Gets or sets the version of the content.
	Version *string `json:"version,omitempty"`
}

// Credential definition of the credential.
type Credential struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets the name of the credential.
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// CredentialProperties - Gets or sets the properties of the credential.
	*CredentialProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Credential struct.
func (c *Credential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var credentialProperties CredentialProperties
				err = json.Unmarshal(*v, &credentialProperties)
				if err != nil {
					return err
				}
				c.CredentialProperties = &credentialProperties
			}
		}
	}

	return nil
}

// CredentialCreateOrUpdateParameters the parameters supplied to the create or update credential operation.
type CredentialCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`
	// CredentialCreateOrUpdateProperties - Gets or sets the properties of the credential.
	*CredentialCreateOrUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CredentialCreateOrUpdateParameters struct.
func (ccoup *CredentialCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "properties":
			if v != nil {
				var credentialCreateOrUpdateProperties CredentialCreateOrUpdateProperties
				err = json.Unmarshal(*v, &credentialCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.CredentialCreateOrUpdateProperties = &credentialCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// CredentialCreateOrUpdateProperties the properties of the create cerdential operation.
type CredentialCreateOrUpdateProperties struct {
	// UserName - Gets or sets the user name of the credential.
	UserName *string `json:"userName,omitempty"`
	// Password - Gets or sets the password of the credential.
	Password *string `json:"password,omitempty"`
	// Description - Gets or sets the description of the credential.
	Description *string `json:"description,omitempty"`
}

// CredentialListResult the response model for the list credential operation.
type CredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of credentials.
	Value *[]Credential `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// CredentialListResultIterator provides access to a complete listing of Credential values.
type CredentialListResultIterator struct {
	i    int
	page CredentialListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CredentialListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CredentialListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CredentialListResultIterator) Response() CredentialListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CredentialListResultIterator) Value() Credential {
	if !iter.page.NotDone() {
		return Credential{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CredentialListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// credentialListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CredentialListResult) credentialListResultPreparer() (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CredentialListResultPage contains a page of Credential values.
type CredentialListResultPage struct {
	fn  func(CredentialListResult) (CredentialListResult, error)
	clr CredentialListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CredentialListResultPage) Next() error {
	next, err := page.fn(page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CredentialListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CredentialListResultPage) Response() CredentialListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CredentialListResultPage) Values() []Credential {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// CredentialProperties definition of the credential properties
type CredentialProperties struct {
	// UserName - Gets the user name of the credential.
	UserName *string `json:"userName,omitempty"`
	// CreationTime - Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// CredentialUpdateParameters the parameters supplied to the Update credential operation.
type CredentialUpdateParameters struct {
	// Name - Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`
	// CredentialUpdateProperties - Gets or sets the properties of the variable.
	*CredentialUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CredentialUpdateParameters struct.
func (cup *CredentialUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cup.Name = &name
			}
		case "properties":
			if v != nil {
				var credentialUpdateProperties CredentialUpdateProperties
				err = json.Unmarshal(*v, &credentialUpdateProperties)
				if err != nil {
					return err
				}
				cup.CredentialUpdateProperties = &credentialUpdateProperties
			}
		}
	}

	return nil
}

// CredentialUpdateProperties the properties of the Update credential
type CredentialUpdateProperties struct {
	// UserName - Gets or sets the user name of the credential.
	UserName *string `json:"userName,omitempty"`
	// Password - Gets or sets the password of the credential.
	Password *string `json:"password,omitempty"`
	// Description - Gets or sets the description of the credential.
	Description *string `json:"description,omitempty"`
}

// DscCompilationJob definition of the Dsc Compilation job.
type DscCompilationJob struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// DscCompilationJobProperties - Gets or sets the properties of the Dsc Compilation job.
	*DscCompilationJobProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DscCompilationJob struct.
func (dcj *DscCompilationJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcj.ID = &ID
			}
		case "properties":
			if v != nil {
				var dscCompilationJobProperties DscCompilationJobProperties
				err = json.Unmarshal(*v, &dscCompilationJobProperties)
				if err != nil {
					return err
				}
				dcj.DscCompilationJobProperties = &dscCompilationJobProperties
			}
		}
	}

	return nil
}

// DscCompilationJobCreateParameters the parameters supplied to the create compilation job operation.
type DscCompilationJobCreateParameters struct {
	// DscCompilationJobCreateProperties - Gets or sets the list of compilation job properties.
	*DscCompilationJobCreateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscCompilationJobCreateParameters.
func (dcjcp DscCompilationJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcjcp.DscCompilationJobCreateProperties != nil {
		objectMap["properties"] = dcjcp.DscCompilationJobCreateProperties
	}
	if dcjcp.Name != nil {
		objectMap["name"] = dcjcp.Name
	}
	if dcjcp.Location != nil {
		objectMap["location"] = dcjcp.Location
	}
	if dcjcp.Tags != nil {
		objectMap["tags"] = dcjcp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscCompilationJobCreateParameters struct.
func (dcjcp *DscCompilationJobCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscCompilationJobCreateProperties DscCompilationJobCreateProperties
				err = json.Unmarshal(*v, &dscCompilationJobCreateProperties)
				if err != nil {
					return err
				}
				dcjcp.DscCompilationJobCreateProperties = &dscCompilationJobCreateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcjcp.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcjcp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcjcp.Tags = tags
			}
		}
	}

	return nil
}

// DscCompilationJobCreateProperties the parameters supplied to the create compilation job operation.
type DscCompilationJobCreateProperties struct {
	// Configuration - Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// NewNodeConfigurationBuildVersionRequired - If a new build version of NodeConfiguration is required.
	NewNodeConfigurationBuildVersionRequired *bool `json:"newNodeConfigurationBuildVersionRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for DscCompilationJobCreateProperties.
func (dcjcp DscCompilationJobCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcjcp.Configuration != nil {
		objectMap["configuration"] = dcjcp.Configuration
	}
	if dcjcp.Parameters != nil {
		objectMap["parameters"] = dcjcp.Parameters
	}
	if dcjcp.NewNodeConfigurationBuildVersionRequired != nil {
		objectMap["newNodeConfigurationBuildVersionRequired"] = dcjcp.NewNodeConfigurationBuildVersionRequired
	}
	return json.Marshal(objectMap)
}

// DscCompilationJobListResult the response model for the list job operation.
type DscCompilationJobListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of Dsc Compilation jobs.
	Value *[]DscCompilationJob `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscCompilationJobListResultIterator provides access to a complete listing of DscCompilationJob values.
type DscCompilationJobListResultIterator struct {
	i    int
	page DscCompilationJobListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscCompilationJobListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscCompilationJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscCompilationJobListResultIterator) Response() DscCompilationJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscCompilationJobListResultIterator) Value() DscCompilationJob {
	if !iter.page.NotDone() {
		return DscCompilationJob{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dcjlr DscCompilationJobListResult) IsEmpty() bool {
	return dcjlr.Value == nil || len(*dcjlr.Value) == 0
}

// dscCompilationJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcjlr DscCompilationJobListResult) dscCompilationJobListResultPreparer() (*http.Request, error) {
	if dcjlr.NextLink == nil || len(to.String(dcjlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcjlr.NextLink)))
}

// DscCompilationJobListResultPage contains a page of DscCompilationJob values.
type DscCompilationJobListResultPage struct {
	fn    func(DscCompilationJobListResult) (DscCompilationJobListResult, error)
	dcjlr DscCompilationJobListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscCompilationJobListResultPage) Next() error {
	next, err := page.fn(page.dcjlr)
	if err != nil {
		return err
	}
	page.dcjlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscCompilationJobListResultPage) NotDone() bool {
	return !page.dcjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscCompilationJobListResultPage) Response() DscCompilationJobListResult {
	return page.dcjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscCompilationJobListResultPage) Values() []DscCompilationJob {
	if page.dcjlr.IsEmpty() {
		return nil
	}
	return *page.dcjlr.Value
}

// DscCompilationJobProperties definition of Dsc Compilation job properties.
type DscCompilationJobProperties struct {
	// Configuration - Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// StartedBy - Gets the compilation job started by.
	StartedBy *string `json:"startedBy,omitempty"`
	// JobID - Gets the id of the job.
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// CreationTime - Gets the creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Status - Gets or sets the status of the job. Possible values include: 'JobStatusNew', 'JobStatusActivating', 'JobStatusRunning', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusStopped', 'JobStatusBlocked', 'JobStatusSuspended', 'JobStatusDisconnected', 'JobStatusSuspending', 'JobStatusStopping', 'JobStatusResuming', 'JobStatusRemoving'
	Status JobStatus `json:"status,omitempty"`
	// StatusDetails - Gets or sets the status details of the job.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// StartTime - Gets the start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets the end time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Exception - Gets the exception of the job.
	Exception *string `json:"exception,omitempty"`
	// LastModifiedTime - Gets the last modified time of the job.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastStatusModifiedTime - Gets the last status modified time of the job.
	LastStatusModifiedTime *date.Time `json:"lastStatusModifiedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for DscCompilationJobProperties.
func (dcjp DscCompilationJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcjp.Configuration != nil {
		objectMap["configuration"] = dcjp.Configuration
	}
	if dcjp.StartedBy != nil {
		objectMap["startedBy"] = dcjp.StartedBy
	}
	if dcjp.JobID != nil {
		objectMap["jobId"] = dcjp.JobID
	}
	if dcjp.CreationTime != nil {
		objectMap["creationTime"] = dcjp.CreationTime
	}
	objectMap["status"] = dcjp.Status
	if dcjp.StatusDetails != nil {
		objectMap["statusDetails"] = dcjp.StatusDetails
	}
	if dcjp.StartTime != nil {
		objectMap["startTime"] = dcjp.StartTime
	}
	if dcjp.EndTime != nil {
		objectMap["endTime"] = dcjp.EndTime
	}
	if dcjp.Exception != nil {
		objectMap["exception"] = dcjp.Exception
	}
	if dcjp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = dcjp.LastModifiedTime
	}
	if dcjp.LastStatusModifiedTime != nil {
		objectMap["lastStatusModifiedTime"] = dcjp.LastStatusModifiedTime
	}
	if dcjp.Parameters != nil {
		objectMap["parameters"] = dcjp.Parameters
	}
	return json.Marshal(objectMap)
}

// DscConfiguration definition of the configuration type.
type DscConfiguration struct {
	autorest.Response `json:"-"`
	// DscConfigurationProperties - Gets or sets the configuration properties.
	*DscConfigurationProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscConfiguration.
func (dc DscConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.DscConfigurationProperties != nil {
		objectMap["properties"] = dc.DscConfigurationProperties
	}
	if dc.Etag != nil {
		objectMap["etag"] = dc.Etag
	}
	if dc.ID != nil {
		objectMap["id"] = dc.ID
	}
	if dc.Name != nil {
		objectMap["name"] = dc.Name
	}
	if dc.Type != nil {
		objectMap["type"] = dc.Type
	}
	if dc.Location != nil {
		objectMap["location"] = dc.Location
	}
	if dc.Tags != nil {
		objectMap["tags"] = dc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscConfiguration struct.
func (dc *DscConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscConfigurationProperties DscConfigurationProperties
				err = json.Unmarshal(*v, &dscConfigurationProperties)
				if err != nil {
					return err
				}
				dc.DscConfigurationProperties = &dscConfigurationProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dc.Tags = tags
			}
		}
	}

	return nil
}

// DscConfigurationAssociationProperty the Dsc configuration property associated with the entity.
type DscConfigurationAssociationProperty struct {
	// Name - Gets or sets the name of the Dsc configuration.
	Name *string `json:"name,omitempty"`
}

// DscConfigurationCreateOrUpdateParameters the parameters supplied to the create or update configuration
// operation.
type DscConfigurationCreateOrUpdateParameters struct {
	// DscConfigurationCreateOrUpdateProperties - Gets or sets configuration create or update properties.
	*DscConfigurationCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscConfigurationCreateOrUpdateParameters.
func (dccoup DscConfigurationCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dccoup.DscConfigurationCreateOrUpdateProperties != nil {
		objectMap["properties"] = dccoup.DscConfigurationCreateOrUpdateProperties
	}
	if dccoup.Name != nil {
		objectMap["name"] = dccoup.Name
	}
	if dccoup.Location != nil {
		objectMap["location"] = dccoup.Location
	}
	if dccoup.Tags != nil {
		objectMap["tags"] = dccoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscConfigurationCreateOrUpdateParameters struct.
func (dccoup *DscConfigurationCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscConfigurationCreateOrUpdateProperties DscConfigurationCreateOrUpdateProperties
				err = json.Unmarshal(*v, &dscConfigurationCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				dccoup.DscConfigurationCreateOrUpdateProperties = &dscConfigurationCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dccoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dccoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dccoup.Tags = tags
			}
		}
	}

	return nil
}

// DscConfigurationCreateOrUpdateProperties the properties to create or update configuration.
type DscConfigurationCreateOrUpdateProperties struct {
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// Source - Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`
	// Parameters - Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter `json:"parameters"`
	// Description - Gets or sets the description of the configuration.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for DscConfigurationCreateOrUpdateProperties.
func (dccoup DscConfigurationCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dccoup.LogVerbose != nil {
		objectMap["logVerbose"] = dccoup.LogVerbose
	}
	if dccoup.LogProgress != nil {
		objectMap["logProgress"] = dccoup.LogProgress
	}
	if dccoup.Source != nil {
		objectMap["source"] = dccoup.Source
	}
	if dccoup.Parameters != nil {
		objectMap["parameters"] = dccoup.Parameters
	}
	if dccoup.Description != nil {
		objectMap["description"] = dccoup.Description
	}
	return json.Marshal(objectMap)
}

// DscConfigurationListResult the response model for the list configuration operation.
type DscConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of configurations.
	Value *[]DscConfiguration `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscConfigurationListResultIterator provides access to a complete listing of DscConfiguration values.
type DscConfigurationListResultIterator struct {
	i    int
	page DscConfigurationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscConfigurationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscConfigurationListResultIterator) Response() DscConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscConfigurationListResultIterator) Value() DscConfiguration {
	if !iter.page.NotDone() {
		return DscConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dclr DscConfigurationListResult) IsEmpty() bool {
	return dclr.Value == nil || len(*dclr.Value) == 0
}

// dscConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dclr DscConfigurationListResult) dscConfigurationListResultPreparer() (*http.Request, error) {
	if dclr.NextLink == nil || len(to.String(dclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dclr.NextLink)))
}

// DscConfigurationListResultPage contains a page of DscConfiguration values.
type DscConfigurationListResultPage struct {
	fn   func(DscConfigurationListResult) (DscConfigurationListResult, error)
	dclr DscConfigurationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscConfigurationListResultPage) Next() error {
	next, err := page.fn(page.dclr)
	if err != nil {
		return err
	}
	page.dclr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscConfigurationListResultPage) NotDone() bool {
	return !page.dclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscConfigurationListResultPage) Response() DscConfigurationListResult {
	return page.dclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscConfigurationListResultPage) Values() []DscConfiguration {
	if page.dclr.IsEmpty() {
		return nil
	}
	return *page.dclr.Value
}

// DscConfigurationParameter definition of the configuration parameter type.
type DscConfigurationParameter struct {
	// Type - Gets or sets the type of the parameter.
	Type *string `json:"type,omitempty"`
	// IsMandatory - Gets or sets a Boolean value to indicate whether the parameter is madatory or not.
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// Position - Get or sets the position of the parameter.
	Position *int32 `json:"position,omitempty"`
	// DefaultValue - Gets or sets the default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// DscConfigurationProperties definition of the configuration property type.
type DscConfigurationProperties struct {
	// ProvisioningState - Gets or sets the provisioning state of the configuration. Possible values include: 'Succeeded'
	ProvisioningState DscConfigurationProvisioningState `json:"provisioningState,omitempty"`
	// JobCount - Gets or sets the job count of the configuration.
	JobCount *int32 `json:"jobCount,omitempty"`
	// Parameters - Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter `json:"parameters"`
	// Source - Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`
	// State - Gets or sets the state of the configuration. Possible values include: 'DscConfigurationStateNew', 'DscConfigurationStateEdit', 'DscConfigurationStatePublished'
	State DscConfigurationState `json:"state,omitempty"`
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for DscConfigurationProperties.
func (dcp DscConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["provisioningState"] = dcp.ProvisioningState
	if dcp.JobCount != nil {
		objectMap["jobCount"] = dcp.JobCount
	}
	if dcp.Parameters != nil {
		objectMap["parameters"] = dcp.Parameters
	}
	if dcp.Source != nil {
		objectMap["source"] = dcp.Source
	}
	objectMap["state"] = dcp.State
	if dcp.LogVerbose != nil {
		objectMap["logVerbose"] = dcp.LogVerbose
	}
	if dcp.CreationTime != nil {
		objectMap["creationTime"] = dcp.CreationTime
	}
	if dcp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = dcp.LastModifiedTime
	}
	if dcp.Description != nil {
		objectMap["description"] = dcp.Description
	}
	return json.Marshal(objectMap)
}

// DscMetaConfiguration definition of the DSC Meta Configuration.
type DscMetaConfiguration struct {
	// ConfigurationModeFrequencyMins - Gets or sets the ConfigurationModeFrequencyMins value of the meta configuration.
	ConfigurationModeFrequencyMins *int32 `json:"configurationModeFrequencyMins,omitempty"`
	// RebootNodeIfNeeded - Gets or sets the RebootNodeIfNeeded value of the meta configuration.
	RebootNodeIfNeeded *bool `json:"rebootNodeIfNeeded,omitempty"`
	// ConfigurationMode - Gets or sets the ConfigurationMode value of the meta configuration.
	ConfigurationMode *string `json:"configurationMode,omitempty"`
	// ActionAfterReboot - Gets or sets the ActionAfterReboot value of the meta configuration.
	ActionAfterReboot *string `json:"actionAfterReboot,omitempty"`
	// CertificateID - Gets or sets the CertificateId value of the meta configuration.
	CertificateID *string `json:"certificateId,omitempty"`
	// RefreshFrequencyMins - Gets or sets the RefreshFrequencyMins value of the meta configuration.
	RefreshFrequencyMins *int32 `json:"refreshFrequencyMins,omitempty"`
	// AllowModuleOverwrite - Gets or sets the AllowModuleOverwrite value of the meta configuration.
	AllowModuleOverwrite *bool `json:"allowModuleOverwrite,omitempty"`
}

// DscNode definition of the dsc node type.
type DscNode struct {
	autorest.Response `json:"-"`
	// LastSeen - Gets or sets the last seen time of the node.
	LastSeen *date.Time `json:"lastSeen,omitempty"`
	// RegistrationTime - Gets or sets the registration time of the node.
	RegistrationTime *date.Time `json:"registrationTime,omitempty"`
	// IP - Gets or sets the ip of the node.
	IP *string `json:"ip,omitempty"`
	// AccountID - Gets or sets the account id of the node.
	AccountID *string `json:"accountId,omitempty"`
	// NodeConfiguration - Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`
	// Status - Gets or sets the status of the node.
	Status *string `json:"status,omitempty"`
	// NodeID - Gets or sets the node id.
	NodeID *string `json:"nodeId,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ExtensionHandler - Gets or sets the list of extensionHandler properties for a Node.
	ExtensionHandler *[]DscNodeExtensionHandlerAssociationProperty `json:"extensionHandler,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscNode.
func (dn DscNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dn.LastSeen != nil {
		objectMap["lastSeen"] = dn.LastSeen
	}
	if dn.RegistrationTime != nil {
		objectMap["registrationTime"] = dn.RegistrationTime
	}
	if dn.IP != nil {
		objectMap["ip"] = dn.IP
	}
	if dn.AccountID != nil {
		objectMap["accountId"] = dn.AccountID
	}
	if dn.NodeConfiguration != nil {
		objectMap["nodeConfiguration"] = dn.NodeConfiguration
	}
	if dn.Status != nil {
		objectMap["status"] = dn.Status
	}
	if dn.NodeID != nil {
		objectMap["nodeId"] = dn.NodeID
	}
	if dn.Etag != nil {
		objectMap["etag"] = dn.Etag
	}
	if dn.ExtensionHandler != nil {
		objectMap["extensionHandler"] = dn.ExtensionHandler
	}
	if dn.ID != nil {
		objectMap["id"] = dn.ID
	}
	if dn.Name != nil {
		objectMap["name"] = dn.Name
	}
	if dn.Type != nil {
		objectMap["type"] = dn.Type
	}
	if dn.Location != nil {
		objectMap["location"] = dn.Location
	}
	if dn.Tags != nil {
		objectMap["tags"] = dn.Tags
	}
	return json.Marshal(objectMap)
}

// DscNodeConfiguration definition of the dsc node configuration.
type DscNodeConfiguration struct {
	autorest.Response `json:"-"`
	// Name - Gets or sets the node configuration name.
	Name *string `json:"name,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// CreationTime - Gets or sets creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Configuration - Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
}

// DscNodeConfigurationAssociationProperty the dsc nodeconfiguration property associated with the entity.
type DscNodeConfigurationAssociationProperty struct {
	// Name - Gets or sets the name of the dsc nodeconfiguration.
	Name *string `json:"name,omitempty"`
}

// DscNodeConfigurationCreateOrUpdateParameters the parameters supplied to the create or update node configuration
// operation.
type DscNodeConfigurationCreateOrUpdateParameters struct {
	// Source - Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`
	// Name - Gets or sets the type of the parameter.
	Name *string `json:"name,omitempty"`
	// Configuration - Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// NewNodeConfigurationBuildVersionRequired - If a new build version of NodeConfiguration is required.
	NewNodeConfigurationBuildVersionRequired *bool `json:"newNodeConfigurationBuildVersionRequired,omitempty"`
}

// DscNodeConfigurationListResult the response model for the list job operation.
type DscNodeConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of Dsc node configurations.
	Value *[]DscNodeConfiguration `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscNodeConfigurationListResultIterator provides access to a complete listing of DscNodeConfiguration values.
type DscNodeConfigurationListResultIterator struct {
	i    int
	page DscNodeConfigurationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscNodeConfigurationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscNodeConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscNodeConfigurationListResultIterator) Response() DscNodeConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscNodeConfigurationListResultIterator) Value() DscNodeConfiguration {
	if !iter.page.NotDone() {
		return DscNodeConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dnclr DscNodeConfigurationListResult) IsEmpty() bool {
	return dnclr.Value == nil || len(*dnclr.Value) == 0
}

// dscNodeConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dnclr DscNodeConfigurationListResult) dscNodeConfigurationListResultPreparer() (*http.Request, error) {
	if dnclr.NextLink == nil || len(to.String(dnclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dnclr.NextLink)))
}

// DscNodeConfigurationListResultPage contains a page of DscNodeConfiguration values.
type DscNodeConfigurationListResultPage struct {
	fn    func(DscNodeConfigurationListResult) (DscNodeConfigurationListResult, error)
	dnclr DscNodeConfigurationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscNodeConfigurationListResultPage) Next() error {
	next, err := page.fn(page.dnclr)
	if err != nil {
		return err
	}
	page.dnclr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscNodeConfigurationListResultPage) NotDone() bool {
	return !page.dnclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscNodeConfigurationListResultPage) Response() DscNodeConfigurationListResult {
	return page.dnclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscNodeConfigurationListResultPage) Values() []DscNodeConfiguration {
	if page.dnclr.IsEmpty() {
		return nil
	}
	return *page.dnclr.Value
}

// DscNodeExtensionHandlerAssociationProperty the dsc extensionHandler property associated with the node
type DscNodeExtensionHandlerAssociationProperty struct {
	// Name - Gets or sets the name of the extension handler.
	Name *string `json:"name,omitempty"`
	// Version - Gets or sets the version of the extension handler.
	Version *string `json:"version,omitempty"`
}

// DscNodeListResult the response model for the list dsc nodes operation.
type DscNodeListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of dsc nodes.
	Value *[]DscNode `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscNodeListResultIterator provides access to a complete listing of DscNode values.
type DscNodeListResultIterator struct {
	i    int
	page DscNodeListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscNodeListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscNodeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscNodeListResultIterator) Response() DscNodeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscNodeListResultIterator) Value() DscNode {
	if !iter.page.NotDone() {
		return DscNode{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dnlr DscNodeListResult) IsEmpty() bool {
	return dnlr.Value == nil || len(*dnlr.Value) == 0
}

// dscNodeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dnlr DscNodeListResult) dscNodeListResultPreparer() (*http.Request, error) {
	if dnlr.NextLink == nil || len(to.String(dnlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dnlr.NextLink)))
}

// DscNodeListResultPage contains a page of DscNode values.
type DscNodeListResultPage struct {
	fn   func(DscNodeListResult) (DscNodeListResult, error)
	dnlr DscNodeListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscNodeListResultPage) Next() error {
	next, err := page.fn(page.dnlr)
	if err != nil {
		return err
	}
	page.dnlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscNodeListResultPage) NotDone() bool {
	return !page.dnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscNodeListResultPage) Response() DscNodeListResult {
	return page.dnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscNodeListResultPage) Values() []DscNode {
	if page.dnlr.IsEmpty() {
		return nil
	}
	return *page.dnlr.Value
}

// DscNodeReport definition of the dsc node report type.
type DscNodeReport struct {
	autorest.Response `json:"-"`
	// EndTime - Gets or sets the end time of the node report.
	EndTime *date.Time `json:"endTime,omitempty"`
	// LastModifiedTime - Gets or sets the lastModifiedTime of the node report.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// StartTime - Gets or sets the start time of the node report.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Type - Gets or sets the type of the node report.
	Type *string `json:"type,omitempty"`
	// ReportID - Gets or sets the id of the node report.
	ReportID *string `json:"reportId,omitempty"`
	// Status - Gets or sets the status of the node report.
	Status *string `json:"status,omitempty"`
	// RefreshMode - Gets or sets the refreshMode of the node report.
	RefreshMode *string `json:"refreshMode,omitempty"`
	// RebootRequested - Gets or sets the rebootRequested of the node report.
	RebootRequested *string `json:"rebootRequested,omitempty"`
	// ReportFormatVersion - Gets or sets the reportFormatVersion of the node report.
	ReportFormatVersion *string `json:"reportFormatVersion,omitempty"`
	// ConfigurationVersion - Gets or sets the configurationVersion of the node report.
	ConfigurationVersion *string `json:"configurationVersion,omitempty"`
	// ID - Gets or sets the id.
	ID *string `json:"id,omitempty"`
	// Errors - Gets or sets the errors for the node report.
	Errors *[]DscReportError `json:"errors,omitempty"`
	// Resources - Gets or sets the resource for the node report.
	Resources *[]DscReportResource `json:"resources,omitempty"`
	// MetaConfiguration - Gets or sets the metaConfiguration of the node at the time of the report.
	MetaConfiguration *DscMetaConfiguration `json:"metaConfiguration,omitempty"`
	// HostName - Gets or sets the hostname of the node that sent the report.
	HostName *string `json:"hostName,omitempty"`
	// IPV4Addresses - Gets or sets the IPv4 address of the node that sent the report.
	IPV4Addresses *[]string `json:"iPV4Addresses,omitempty"`
	// IPV6Addresses - Gets or sets the IPv6 address of the node that sent the report.
	IPV6Addresses *[]string `json:"iPV6Addresses,omitempty"`
	// NumberOfResources - Gets or sets the number of resource in the node report.
	NumberOfResources *int32 `json:"numberOfResources,omitempty"`
	// RawErrors - Gets or sets the unparsed errors for the node report.
	RawErrors *string `json:"rawErrors,omitempty"`
}

// DscNodeReportListResult the response model for the list dsc nodes operation.
type DscNodeReportListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of dsc node reports.
	Value *[]DscNodeReport `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscNodeReportListResultIterator provides access to a complete listing of DscNodeReport values.
type DscNodeReportListResultIterator struct {
	i    int
	page DscNodeReportListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscNodeReportListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscNodeReportListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscNodeReportListResultIterator) Response() DscNodeReportListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscNodeReportListResultIterator) Value() DscNodeReport {
	if !iter.page.NotDone() {
		return DscNodeReport{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dnrlr DscNodeReportListResult) IsEmpty() bool {
	return dnrlr.Value == nil || len(*dnrlr.Value) == 0
}

// dscNodeReportListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dnrlr DscNodeReportListResult) dscNodeReportListResultPreparer() (*http.Request, error) {
	if dnrlr.NextLink == nil || len(to.String(dnrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dnrlr.NextLink)))
}

// DscNodeReportListResultPage contains a page of DscNodeReport values.
type DscNodeReportListResultPage struct {
	fn    func(DscNodeReportListResult) (DscNodeReportListResult, error)
	dnrlr DscNodeReportListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscNodeReportListResultPage) Next() error {
	next, err := page.fn(page.dnrlr)
	if err != nil {
		return err
	}
	page.dnrlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscNodeReportListResultPage) NotDone() bool {
	return !page.dnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscNodeReportListResultPage) Response() DscNodeReportListResult {
	return page.dnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscNodeReportListResultPage) Values() []DscNodeReport {
	if page.dnrlr.IsEmpty() {
		return nil
	}
	return *page.dnrlr.Value
}

// DscNodeUpdateParameters the parameters supplied to the update dsc node operation.
type DscNodeUpdateParameters struct {
	// NodeID - Gets or sets the id of the dsc node.
	NodeID *string `json:"nodeId,omitempty"`
	// NodeConfiguration - Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`
}

// DscReportError definition of the dsc node report error type.
type DscReportError struct {
	// ErrorSource - Gets or sets the source of the error.
	ErrorSource *string `json:"errorSource,omitempty"`
	// ResourceID - Gets or sets the resource ID which generated the error.
	ResourceID *string `json:"resourceId,omitempty"`
	// ErrorCode - Gets or sets the error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Gets or sets the error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Locale - Gets or sets the locale of the error.
	Locale *string `json:"locale,omitempty"`
	// ErrorDetails - Gets or sets the error details.
	ErrorDetails *string `json:"errorDetails,omitempty"`
}

// DscReportResource definition of the DSC Report Resource.
type DscReportResource struct {
	// ResourceID - Gets or sets the ID of the resource.
	ResourceID *string `json:"resourceId,omitempty"`
	// SourceInfo - Gets or sets the source info of the resource.
	SourceInfo *string `json:"sourceInfo,omitempty"`
	// DependsOn - Gets or sets the Resource Navigation values for resources the resource depends on.
	DependsOn *[]DscReportResourceNavigation `json:"dependsOn,omitempty"`
	// ModuleName - Gets or sets the module name of the resource.
	ModuleName *string `json:"moduleName,omitempty"`
	// ModuleVersion - Gets or sets the module version of the resource.
	ModuleVersion *string `json:"moduleVersion,omitempty"`
	// ResourceName - Gets or sets the name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// Error - Gets or sets the error of the resource.
	Error *string `json:"error,omitempty"`
	// Status - Gets or sets the status of the resource.
	Status *string `json:"status,omitempty"`
	// DurationInSeconds - Gets or sets the duration in seconds for the resource.
	DurationInSeconds *float64 `json:"durationInSeconds,omitempty"`
	// StartDate - Gets or sets the start date of the resource.
	StartDate *date.Time `json:"startDate,omitempty"`
}

// DscReportResourceNavigation navigation for DSC Report Resource.
type DscReportResourceNavigation struct {
	// ResourceID - Gets or sets the ID of the resource to navigate to.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ErrorResponse error response of an operation failure
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// FieldDefinition definition of the connection fields.
type FieldDefinition struct {
	// IsEncrypted - Gets or sets the isEncrypted flag of the connection field definition.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
	// IsOptional - Gets or sets the isOptional flag of the connection field definition.
	IsOptional *bool `json:"isOptional,omitempty"`
	// Type - Gets or sets the type of the connection field definition.
	Type *string `json:"type,omitempty"`
}

// HybridRunbookWorker definition of hybrid runbook worker.
type HybridRunbookWorker struct {
	// Name - Gets or sets the worker machine name.
	Name *string `json:"name,omitempty"`
	// IP - Gets or sets the assigned machine IP address.
	IP *string `json:"ip,omitempty"`
	// RegistrationTime - Gets or sets the registration time of the worker machine.
	RegistrationTime *date.Time `json:"registrationTime,omitempty"`
}

// HybridRunbookWorkerGroup definition of hybrid runbook worker group.
type HybridRunbookWorkerGroup struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of the group.
	Name *string `json:"name,omitempty"`
	// HybridRunbookWorkers - Gets or sets the list of hybrid runbook workers.
	HybridRunbookWorkers *[]HybridRunbookWorker `json:"hybridRunbookWorkers,omitempty"`
	// Credential - Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty `json:"credential,omitempty"`
}

// HybridRunbookWorkerGroupsListResult the response model for the list hybrid runbook worker groups.
type HybridRunbookWorkerGroupsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of hybrid runbook worker groups.
	Value *[]HybridRunbookWorkerGroup `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// HybridRunbookWorkerGroupsListResultIterator provides access to a complete listing of HybridRunbookWorkerGroup
// values.
type HybridRunbookWorkerGroupsListResultIterator struct {
	i    int
	page HybridRunbookWorkerGroupsListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HybridRunbookWorkerGroupsListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HybridRunbookWorkerGroupsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HybridRunbookWorkerGroupsListResultIterator) Response() HybridRunbookWorkerGroupsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HybridRunbookWorkerGroupsListResultIterator) Value() HybridRunbookWorkerGroup {
	if !iter.page.NotDone() {
		return HybridRunbookWorkerGroup{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (hrwglr HybridRunbookWorkerGroupsListResult) IsEmpty() bool {
	return hrwglr.Value == nil || len(*hrwglr.Value) == 0
}

// hybridRunbookWorkerGroupsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hrwglr HybridRunbookWorkerGroupsListResult) hybridRunbookWorkerGroupsListResultPreparer() (*http.Request, error) {
	if hrwglr.NextLink == nil || len(to.String(hrwglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hrwglr.NextLink)))
}

// HybridRunbookWorkerGroupsListResultPage contains a page of HybridRunbookWorkerGroup values.
type HybridRunbookWorkerGroupsListResultPage struct {
	fn     func(HybridRunbookWorkerGroupsListResult) (HybridRunbookWorkerGroupsListResult, error)
	hrwglr HybridRunbookWorkerGroupsListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HybridRunbookWorkerGroupsListResultPage) Next() error {
	next, err := page.fn(page.hrwglr)
	if err != nil {
		return err
	}
	page.hrwglr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HybridRunbookWorkerGroupsListResultPage) NotDone() bool {
	return !page.hrwglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HybridRunbookWorkerGroupsListResultPage) Response() HybridRunbookWorkerGroupsListResult {
	return page.hrwglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HybridRunbookWorkerGroupsListResultPage) Values() []HybridRunbookWorkerGroup {
	if page.hrwglr.IsEmpty() {
		return nil
	}
	return *page.hrwglr.Value
}

// HybridRunbookWorkerGroupUpdateParameters parameters supplied to the update operation.
type HybridRunbookWorkerGroupUpdateParameters struct {
	// Credential - Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty `json:"credential,omitempty"`
}

// Job definition of the job.
type Job struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// JobProperties - Gets or sets the properties of the job.
	*JobProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		}
	}

	return nil
}

// JobCreateParameters the parameters supplied to the create job operation.
type JobCreateParameters struct {
	// JobCreateProperties - Gets or sets the list of job properties.
	*JobCreateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobCreateParameters.
func (jcp JobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcp.JobCreateProperties != nil {
		objectMap["properties"] = jcp.JobCreateProperties
	}
	if jcp.Name != nil {
		objectMap["name"] = jcp.Name
	}
	if jcp.Location != nil {
		objectMap["location"] = jcp.Location
	}
	if jcp.Tags != nil {
		objectMap["tags"] = jcp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCreateParameters struct.
func (jcp *JobCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobCreateProperties JobCreateProperties
				err = json.Unmarshal(*v, &jobCreateProperties)
				if err != nil {
					return err
				}
				jcp.JobCreateProperties = &jobCreateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jcp.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jcp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jcp.Tags = tags
			}
		}
	}

	return nil
}

// JobCreateProperties the parameters supplied to the create job operation.
type JobCreateProperties struct {
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCreateProperties.
func (jcp JobCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcp.Runbook != nil {
		objectMap["runbook"] = jcp.Runbook
	}
	if jcp.Parameters != nil {
		objectMap["parameters"] = jcp.Parameters
	}
	if jcp.RunOn != nil {
		objectMap["runOn"] = jcp.RunOn
	}
	return json.Marshal(objectMap)
}

// JobListResult the response model for the list job operation.
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of jobs.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListResultIterator provides access to a complete listing of Job values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer() (*http.Request, error) {
	if jlr.NextLink == nil || len(to.String(jlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// JobListResultPage contains a page of Job values.
type JobListResultPage struct {
	fn  func(JobListResult) (JobListResult, error)
	jlr JobListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) Next() error {
	next, err := page.fn(page.jlr)
	if err != nil {
		return err
	}
	page.jlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []Job {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// JobProperties definition of job properties.
type JobProperties struct {
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// StartedBy - Gets or sets the job started by.
	StartedBy *string `json:"startedBy,omitempty"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
	// JobID - Gets or sets the id of the job.
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// CreationTime - Gets or sets the creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Status - Gets or sets the status of the job. Possible values include: 'JobStatusNew', 'JobStatusActivating', 'JobStatusRunning', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusStopped', 'JobStatusBlocked', 'JobStatusSuspended', 'JobStatusDisconnected', 'JobStatusSuspending', 'JobStatusStopping', 'JobStatusResuming', 'JobStatusRemoving'
	Status JobStatus `json:"status,omitempty"`
	// StatusDetails - Gets or sets the status details of the job.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// StartTime - Gets or sets the start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets or sets the end time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Exception - Gets or sets the exception of the job.
	Exception *string `json:"exception,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time of the job.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastStatusModifiedTime - Gets or sets the last status modified time of the job.
	LastStatusModifiedTime *date.Time `json:"lastStatusModifiedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Runbook != nil {
		objectMap["runbook"] = jp.Runbook
	}
	if jp.StartedBy != nil {
		objectMap["startedBy"] = jp.StartedBy
	}
	if jp.RunOn != nil {
		objectMap["runOn"] = jp.RunOn
	}
	if jp.JobID != nil {
		objectMap["jobId"] = jp.JobID
	}
	if jp.CreationTime != nil {
		objectMap["creationTime"] = jp.CreationTime
	}
	objectMap["status"] = jp.Status
	if jp.StatusDetails != nil {
		objectMap["statusDetails"] = jp.StatusDetails
	}
	if jp.StartTime != nil {
		objectMap["startTime"] = jp.StartTime
	}
	if jp.EndTime != nil {
		objectMap["endTime"] = jp.EndTime
	}
	if jp.Exception != nil {
		objectMap["exception"] = jp.Exception
	}
	if jp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = jp.LastModifiedTime
	}
	if jp.LastStatusModifiedTime != nil {
		objectMap["lastStatusModifiedTime"] = jp.LastStatusModifiedTime
	}
	if jp.Parameters != nil {
		objectMap["parameters"] = jp.Parameters
	}
	return json.Marshal(objectMap)
}

// JobSchedule definition of the job schedule.
type JobSchedule struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets the name of the variable.
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// JobScheduleProperties - Gets or sets the properties of the job schedule.
	*JobScheduleProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobSchedule struct.
func (js *JobSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				js.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var jobScheduleProperties JobScheduleProperties
				err = json.Unmarshal(*v, &jobScheduleProperties)
				if err != nil {
					return err
				}
				js.JobScheduleProperties = &jobScheduleProperties
			}
		}
	}

	return nil
}

// JobScheduleCreateParameters the parameters supplied to the create job schedule operation.
type JobScheduleCreateParameters struct {
	// JobScheduleCreateProperties - Gets or sets the list of job schedule properties.
	*JobScheduleCreateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobScheduleCreateParameters struct.
func (jscp *JobScheduleCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobScheduleCreateProperties JobScheduleCreateProperties
				err = json.Unmarshal(*v, &jobScheduleCreateProperties)
				if err != nil {
					return err
				}
				jscp.JobScheduleCreateProperties = &jobScheduleCreateProperties
			}
		}
	}

	return nil
}

// JobScheduleCreateProperties the parameters supplied to the create job schedule operation.
type JobScheduleCreateProperties struct {
	// Schedule - Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty `json:"schedule,omitempty"`
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string `json:"runOn,omitempty"`
	// Parameters - Gets or sets a list of job properties.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for JobScheduleCreateProperties.
func (jscp JobScheduleCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jscp.Schedule != nil {
		objectMap["schedule"] = jscp.Schedule
	}
	if jscp.Runbook != nil {
		objectMap["runbook"] = jscp.Runbook
	}
	if jscp.RunOn != nil {
		objectMap["runOn"] = jscp.RunOn
	}
	if jscp.Parameters != nil {
		objectMap["parameters"] = jscp.Parameters
	}
	return json.Marshal(objectMap)
}

// JobScheduleListResult the response model for the list job schedule operation.
type JobScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of job schedules.
	Value *[]JobSchedule `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobScheduleListResultIterator provides access to a complete listing of JobSchedule values.
type JobScheduleListResultIterator struct {
	i    int
	page JobScheduleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobScheduleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobScheduleListResultIterator) Response() JobScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobScheduleListResultIterator) Value() JobSchedule {
	if !iter.page.NotDone() {
		return JobSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobScheduleListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// jobScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobScheduleListResult) jobScheduleListResultPreparer() (*http.Request, error) {
	if jslr.NextLink == nil || len(to.String(jslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobScheduleListResultPage contains a page of JobSchedule values.
type JobScheduleListResultPage struct {
	fn   func(JobScheduleListResult) (JobScheduleListResult, error)
	jslr JobScheduleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobScheduleListResultPage) Next() error {
	next, err := page.fn(page.jslr)
	if err != nil {
		return err
	}
	page.jslr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobScheduleListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobScheduleListResultPage) Response() JobScheduleListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobScheduleListResultPage) Values() []JobSchedule {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// JobScheduleProperties definition of job schedule parameters.
type JobScheduleProperties struct {
	// JobScheduleID - Gets or sets the id of job schedule.
	JobScheduleID *string `json:"jobScheduleId,omitempty"`
	// Schedule - Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty `json:"schedule,omitempty"`
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string `json:"runOn,omitempty"`
	// Parameters - Gets or sets the parameters of the job schedule.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for JobScheduleProperties.
func (jsp JobScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jsp.JobScheduleID != nil {
		objectMap["jobScheduleId"] = jsp.JobScheduleID
	}
	if jsp.Schedule != nil {
		objectMap["schedule"] = jsp.Schedule
	}
	if jsp.Runbook != nil {
		objectMap["runbook"] = jsp.Runbook
	}
	if jsp.RunOn != nil {
		objectMap["runOn"] = jsp.RunOn
	}
	if jsp.Parameters != nil {
		objectMap["parameters"] = jsp.Parameters
	}
	return json.Marshal(objectMap)
}

// JobStream definition of the job stream.
type JobStream struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// JobStreamProperties - Gets or sets the id of the job stream.
	*JobStreamProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobStream struct.
func (js *JobStream) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "properties":
			if v != nil {
				var jobStreamProperties JobStreamProperties
				err = json.Unmarshal(*v, &jobStreamProperties)
				if err != nil {
					return err
				}
				js.JobStreamProperties = &jobStreamProperties
			}
		}
	}

	return nil
}

// JobStreamListResult the response model for the list job stream operation.
type JobStreamListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of job streams.
	Value *[]JobStream `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobStreamListResultIterator provides access to a complete listing of JobStream values.
type JobStreamListResultIterator struct {
	i    int
	page JobStreamListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobStreamListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobStreamListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobStreamListResultIterator) Response() JobStreamListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobStreamListResultIterator) Value() JobStream {
	if !iter.page.NotDone() {
		return JobStream{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobStreamListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// jobStreamListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobStreamListResult) jobStreamListResultPreparer() (*http.Request, error) {
	if jslr.NextLink == nil || len(to.String(jslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobStreamListResultPage contains a page of JobStream values.
type JobStreamListResultPage struct {
	fn   func(JobStreamListResult) (JobStreamListResult, error)
	jslr JobStreamListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobStreamListResultPage) Next() error {
	next, err := page.fn(page.jslr)
	if err != nil {
		return err
	}
	page.jslr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobStreamListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobStreamListResultPage) Response() JobStreamListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobStreamListResultPage) Values() []JobStream {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// JobStreamProperties definition of the job stream.
type JobStreamProperties struct {
	// JobStreamID - Gets or sets the id of the job stream.
	JobStreamID *string `json:"jobStreamId,omitempty"`
	// Time - Gets or sets the creation time of the job.
	Time *date.Time `json:"time,omitempty"`
	// StreamType - Gets or sets the stream type. Possible values include: 'Progress', 'Output', 'Warning', 'Error', 'Debug', 'Verbose', 'Any'
	StreamType JobStreamType `json:"streamType,omitempty"`
	// StreamText - Gets or sets the stream text.
	StreamText *string `json:"streamText,omitempty"`
	// Summary - Gets or sets the summary.
	Summary *string `json:"summary,omitempty"`
	// Value - Gets or sets the values of the job stream.
	Value map[string]interface{} `json:"value"`
}

// MarshalJSON is the custom marshaler for JobStreamProperties.
func (jsp JobStreamProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jsp.JobStreamID != nil {
		objectMap["jobStreamId"] = jsp.JobStreamID
	}
	if jsp.Time != nil {
		objectMap["time"] = jsp.Time
	}
	objectMap["streamType"] = jsp.StreamType
	if jsp.StreamText != nil {
		objectMap["streamText"] = jsp.StreamText
	}
	if jsp.Summary != nil {
		objectMap["summary"] = jsp.Summary
	}
	if jsp.Value != nil {
		objectMap["value"] = jsp.Value
	}
	return json.Marshal(objectMap)
}

// Module definition of the module type.
type Module struct {
	autorest.Response `json:"-"`
	// ModuleProperties - Gets or sets the module properties.
	*ModuleProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Module.
func (mVar Module) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.ModuleProperties != nil {
		objectMap["properties"] = mVar.ModuleProperties
	}
	if mVar.Etag != nil {
		objectMap["etag"] = mVar.Etag
	}
	if mVar.ID != nil {
		objectMap["id"] = mVar.ID
	}
	if mVar.Name != nil {
		objectMap["name"] = mVar.Name
	}
	if mVar.Type != nil {
		objectMap["type"] = mVar.Type
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Module struct.
func (mVar *Module) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var moduleProperties ModuleProperties
				err = json.Unmarshal(*v, &moduleProperties)
				if err != nil {
					return err
				}
				mVar.ModuleProperties = &moduleProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mVar.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		}
	}

	return nil
}

// ModuleCreateOrUpdateParameters the parameters supplied to the create or update module operation.
type ModuleCreateOrUpdateParameters struct {
	// ModuleCreateOrUpdateProperties - Gets or sets the module create properties.
	*ModuleCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ModuleCreateOrUpdateParameters.
func (mcoup ModuleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcoup.ModuleCreateOrUpdateProperties != nil {
		objectMap["properties"] = mcoup.ModuleCreateOrUpdateProperties
	}
	if mcoup.Name != nil {
		objectMap["name"] = mcoup.Name
	}
	if mcoup.Location != nil {
		objectMap["location"] = mcoup.Location
	}
	if mcoup.Tags != nil {
		objectMap["tags"] = mcoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ModuleCreateOrUpdateParameters struct.
func (mcoup *ModuleCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var moduleCreateOrUpdateProperties ModuleCreateOrUpdateProperties
				err = json.Unmarshal(*v, &moduleCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				mcoup.ModuleCreateOrUpdateProperties = &moduleCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mcoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mcoup.Tags = tags
			}
		}
	}

	return nil
}

// ModuleCreateOrUpdateProperties the parameters supplied to the create or update module properties.
type ModuleCreateOrUpdateProperties struct {
	// ContentLink - Gets or sets the module content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// ModuleErrorInfo definition of the module error info type.
type ModuleErrorInfo struct {
	// Code - Gets or sets the error code.
	Code *string `json:"code,omitempty"`
	// Message - Gets or sets the error message.
	Message *string `json:"message,omitempty"`
}

// ModuleListResult the response model for the list module operation.
type ModuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of modules.
	Value *[]Module `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ModuleListResultIterator provides access to a complete listing of Module values.
type ModuleListResultIterator struct {
	i    int
	page ModuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ModuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ModuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ModuleListResultIterator) Response() ModuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ModuleListResultIterator) Value() Module {
	if !iter.page.NotDone() {
		return Module{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (mlr ModuleListResult) IsEmpty() bool {
	return mlr.Value == nil || len(*mlr.Value) == 0
}

// moduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mlr ModuleListResult) moduleListResultPreparer() (*http.Request, error) {
	if mlr.NextLink == nil || len(to.String(mlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mlr.NextLink)))
}

// ModuleListResultPage contains a page of Module values.
type ModuleListResultPage struct {
	fn  func(ModuleListResult) (ModuleListResult, error)
	mlr ModuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ModuleListResultPage) Next() error {
	next, err := page.fn(page.mlr)
	if err != nil {
		return err
	}
	page.mlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ModuleListResultPage) NotDone() bool {
	return !page.mlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ModuleListResultPage) Response() ModuleListResult {
	return page.mlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ModuleListResultPage) Values() []Module {
	if page.mlr.IsEmpty() {
		return nil
	}
	return *page.mlr.Value
}

// ModuleProperties definition of the module property type.
type ModuleProperties struct {
	// IsGlobal - Gets or sets the isGlobal flag of the module.
	IsGlobal *bool `json:"isGlobal,omitempty"`
	// Version - Gets or sets the version of the module.
	Version *string `json:"version,omitempty"`
	// SizeInBytes - Gets or sets the size in bytes of the module.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// ActivityCount - Gets or sets the activity count of the module.
	ActivityCount *int32 `json:"activityCount,omitempty"`
	// ProvisioningState - Gets or sets the provisioning state of the module. Possible values include: 'ModuleProvisioningStateCreated', 'ModuleProvisioningStateCreating', 'ModuleProvisioningStateStartingImportModuleRunbook', 'ModuleProvisioningStateRunningImportModuleRunbook', 'ModuleProvisioningStateContentRetrieved', 'ModuleProvisioningStateContentDownloaded', 'ModuleProvisioningStateContentValidated', 'ModuleProvisioningStateConnectionTypeImported', 'ModuleProvisioningStateContentStored', 'ModuleProvisioningStateModuleDataStored', 'ModuleProvisioningStateActivitiesStored', 'ModuleProvisioningStateModuleImportRunbookComplete', 'ModuleProvisioningStateSucceeded', 'ModuleProvisioningStateFailed', 'ModuleProvisioningStateCancelled', 'ModuleProvisioningStateUpdating'
	ProvisioningState ModuleProvisioningState `json:"provisioningState,omitempty"`
	// ContentLink - Gets or sets the contentLink of the module.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
	// Error - Gets or sets the error info of the module.
	Error *ModuleErrorInfo `json:"error,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// ModuleUpdateParameters the parameters supplied to the update module operation.
type ModuleUpdateParameters struct {
	// ModuleUpdateProperties - Gets or sets the module update properties.
	*ModuleUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ModuleUpdateParameters.
func (mup ModuleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mup.ModuleUpdateProperties != nil {
		objectMap["properties"] = mup.ModuleUpdateProperties
	}
	if mup.Name != nil {
		objectMap["name"] = mup.Name
	}
	if mup.Location != nil {
		objectMap["location"] = mup.Location
	}
	if mup.Tags != nil {
		objectMap["tags"] = mup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ModuleUpdateParameters struct.
func (mup *ModuleUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var moduleUpdateProperties ModuleUpdateProperties
				err = json.Unmarshal(*v, &moduleUpdateProperties)
				if err != nil {
					return err
				}
				mup.ModuleUpdateProperties = &moduleUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mup.Tags = tags
			}
		}
	}

	return nil
}

// ModuleUpdateProperties the parameters supplied to the update properties.
type ModuleUpdateProperties struct {
	// ContentLink - Gets or sets the module content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// Operation automation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Provider, Resource and Operation values
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay provider, Resource and Operation values
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Automation
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Runbooks, Jobs etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult the response model for the list of Automation operations
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Automation operations supported by the Automation resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RunAsCredentialAssociationProperty definition of runas credential to use for hybrid worker.
type RunAsCredentialAssociationProperty struct {
	// Name - Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`
}

// Runbook definition of the runbook type.
type Runbook struct {
	autorest.Response `json:"-"`
	// RunbookProperties - Gets or sets the runbook properties.
	*RunbookProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Runbook.
func (r Runbook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RunbookProperties != nil {
		objectMap["properties"] = r.RunbookProperties
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Runbook struct.
func (r *Runbook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runbookProperties RunbookProperties
				err = json.Unmarshal(*v, &runbookProperties)
				if err != nil {
					return err
				}
				r.RunbookProperties = &runbookProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// RunbookAssociationProperty the runbook property associated with the entity.
type RunbookAssociationProperty struct {
	// Name - Gets or sets the name of the runbook.
	Name *string `json:"name,omitempty"`
}

// RunbookCreateOrUpdateDraftParameters the parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateDraftParameters struct {
	// RunbookContent - Content of the Runbook.
	RunbookContent *string `json:"runbookContent,omitempty"`
}

// RunbookCreateOrUpdateDraftProperties the parameters supplied to the create or update dratft runbook properties.
type RunbookCreateOrUpdateDraftProperties struct {
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// RunbookType - Gets or sets the type of the runbook. Possible values include: 'Script', 'Graph', 'PowerShellWorkflow', 'PowerShell', 'GraphPowerShellWorkflow', 'GraphPowerShell'
	RunbookType RunbookTypeEnum `json:"runbookType,omitempty"`
	// Draft - Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`
	// Description - Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`
	// LogActivityTrace - Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
}

// RunbookCreateOrUpdateParameters the parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateParameters struct {
	// RunbookCreateOrUpdateProperties - Gets or sets runbook create or update properties.
	*RunbookCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RunbookCreateOrUpdateParameters.
func (rcoup RunbookCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcoup.RunbookCreateOrUpdateProperties != nil {
		objectMap["properties"] = rcoup.RunbookCreateOrUpdateProperties
	}
	if rcoup.Name != nil {
		objectMap["name"] = rcoup.Name
	}
	if rcoup.Location != nil {
		objectMap["location"] = rcoup.Location
	}
	if rcoup.Tags != nil {
		objectMap["tags"] = rcoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RunbookCreateOrUpdateParameters struct.
func (rcoup *RunbookCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runbookCreateOrUpdateProperties RunbookCreateOrUpdateProperties
				err = json.Unmarshal(*v, &runbookCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				rcoup.RunbookCreateOrUpdateProperties = &runbookCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rcoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rcoup.Tags = tags
			}
		}
	}

	return nil
}

// RunbookCreateOrUpdateProperties the parameters supplied to the create or update runbook properties.
type RunbookCreateOrUpdateProperties struct {
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// RunbookType - Gets or sets the type of the runbook. Possible values include: 'Script', 'Graph', 'PowerShellWorkflow', 'PowerShell', 'GraphPowerShellWorkflow', 'GraphPowerShell'
	RunbookType RunbookTypeEnum `json:"runbookType,omitempty"`
	// Draft - Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`
	// PublishContentLink - Gets or sets the published runbook content link.
	PublishContentLink *ContentLink `json:"publishContentLink,omitempty"`
	// Description - Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`
	// LogActivityTrace - Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
}

// RunbookDraft definition of the runbook type.
type RunbookDraft struct {
	autorest.Response `json:"-"`
	// InEdit - Gets or sets whether runbook is in edit mode.
	InEdit *bool `json:"inEdit,omitempty"`
	// DraftContentLink - Gets or sets the draft runbook content link.
	DraftContentLink *ContentLink `json:"draftContentLink,omitempty"`
	// CreationTime - Gets or sets the creation time of the runbook draft.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time of the runbook draft.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Parameters - Gets or sets the runbook draft parameters.
	Parameters map[string]*RunbookParameter `json:"parameters"`
	// OutputTypes - Gets or sets the runbook output types.
	OutputTypes *[]string `json:"outputTypes,omitempty"`
}

// MarshalJSON is the custom marshaler for RunbookDraft.
func (rd RunbookDraft) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.InEdit != nil {
		objectMap["inEdit"] = rd.InEdit
	}
	if rd.DraftContentLink != nil {
		objectMap["draftContentLink"] = rd.DraftContentLink
	}
	if rd.CreationTime != nil {
		objectMap["creationTime"] = rd.CreationTime
	}
	if rd.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = rd.LastModifiedTime
	}
	if rd.Parameters != nil {
		objectMap["parameters"] = rd.Parameters
	}
	if rd.OutputTypes != nil {
		objectMap["outputTypes"] = rd.OutputTypes
	}
	return json.Marshal(objectMap)
}

// RunbookDraftCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RunbookDraftCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RunbookDraftCreateOrUpdateFuture) Result(client RunbookDraftClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("automation.RunbookDraftCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "automation.RunbookDraftCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RunbookDraftPublishFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RunbookDraftPublishFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RunbookDraftPublishFuture) Result(client RunbookDraftClient) (r Runbook, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftPublishFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return r, azure.NewAsyncOpIncompleteError("automation.RunbookDraftPublishFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		r, err = client.PublishResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "automation.RunbookDraftPublishFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftPublishFuture", "Result", resp, "Failure sending request")
		return
	}
	r, err = client.PublishResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftPublishFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// RunbookDraftUndoEditResult the response model for the undoedit runbook operation.
type RunbookDraftUndoEditResult struct {
	autorest.Response `json:"-"`
	// StatusCode - Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently', 'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	RequestID  *string        `json:"requestId,omitempty"`
}

// RunbookListResult the response model for the list runbook operation.
type RunbookListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of runbooks.
	Value *[]Runbook `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RunbookListResultIterator provides access to a complete listing of Runbook values.
type RunbookListResultIterator struct {
	i    int
	page RunbookListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RunbookListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RunbookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RunbookListResultIterator) Response() RunbookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RunbookListResultIterator) Value() Runbook {
	if !iter.page.NotDone() {
		return Runbook{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RunbookListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// runbookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RunbookListResult) runbookListResultPreparer() (*http.Request, error) {
	if rlr.NextLink == nil || len(to.String(rlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RunbookListResultPage contains a page of Runbook values.
type RunbookListResultPage struct {
	fn  func(RunbookListResult) (RunbookListResult, error)
	rlr RunbookListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RunbookListResultPage) Next() error {
	next, err := page.fn(page.rlr)
	if err != nil {
		return err
	}
	page.rlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RunbookListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RunbookListResultPage) Response() RunbookListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RunbookListResultPage) Values() []Runbook {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// RunbookParameter definition of the runbook parameter type.
type RunbookParameter struct {
	// Type - Gets or sets the type of the parameter.
	Type *string `json:"type,omitempty"`
	// IsMandatory - Gets or sets a Boolean value to indicate whether the parameter is madatory or not.
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// Position - Get or sets the position of the parameter.
	Position *int32 `json:"position,omitempty"`
	// DefaultValue - Gets or sets the default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// RunbookProperties definition of the runbook property type.
type RunbookProperties struct {
	// RunbookType - Gets or sets the type of the runbook. Possible values include: 'Script', 'Graph', 'PowerShellWorkflow', 'PowerShell', 'GraphPowerShellWorkflow', 'GraphPowerShell'
	RunbookType RunbookTypeEnum `json:"runbookType,omitempty"`
	// PublishContentLink - Gets or sets the published runbook content link.
	PublishContentLink *ContentLink `json:"publishContentLink,omitempty"`
	// State - Gets or sets the state of the runbook. Possible values include: 'RunbookStateNew', 'RunbookStateEdit', 'RunbookStatePublished'
	State RunbookState `json:"state,omitempty"`
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// LogActivityTrace - Gets or sets the option to log activity trace of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
	// JobCount - Gets or sets the job count of the runbook.
	JobCount *int32 `json:"jobCount,omitempty"`
	// Parameters - Gets or sets the runbook parameters.
	Parameters map[string]*RunbookParameter `json:"parameters"`
	// OutputTypes - Gets or sets the runbook output types.
	OutputTypes *[]string `json:"outputTypes,omitempty"`
	// Draft - Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`
	// ProvisioningState - Gets or sets the provisioning state of the runbook. Possible values include: 'RunbookProvisioningStateSucceeded'
	ProvisioningState RunbookProvisioningState `json:"provisioningState,omitempty"`
	// LastModifiedBy - Gets or sets the last modified by.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for RunbookProperties.
func (rp RunbookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["runbookType"] = rp.RunbookType
	if rp.PublishContentLink != nil {
		objectMap["publishContentLink"] = rp.PublishContentLink
	}
	objectMap["state"] = rp.State
	if rp.LogVerbose != nil {
		objectMap["logVerbose"] = rp.LogVerbose
	}
	if rp.LogProgress != nil {
		objectMap["logProgress"] = rp.LogProgress
	}
	if rp.LogActivityTrace != nil {
		objectMap["logActivityTrace"] = rp.LogActivityTrace
	}
	if rp.JobCount != nil {
		objectMap["jobCount"] = rp.JobCount
	}
	if rp.Parameters != nil {
		objectMap["parameters"] = rp.Parameters
	}
	if rp.OutputTypes != nil {
		objectMap["outputTypes"] = rp.OutputTypes
	}
	if rp.Draft != nil {
		objectMap["draft"] = rp.Draft
	}
	objectMap["provisioningState"] = rp.ProvisioningState
	if rp.LastModifiedBy != nil {
		objectMap["lastModifiedBy"] = rp.LastModifiedBy
	}
	if rp.CreationTime != nil {
		objectMap["creationTime"] = rp.CreationTime
	}
	if rp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = rp.LastModifiedTime
	}
	if rp.Description != nil {
		objectMap["description"] = rp.Description
	}
	return json.Marshal(objectMap)
}

// RunbookUpdateParameters the parameters supplied to the update runbook operation.
type RunbookUpdateParameters struct {
	// RunbookUpdateProperties - Gets or sets the runbook update properties.
	*RunbookUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RunbookUpdateParameters.
func (rup RunbookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.RunbookUpdateProperties != nil {
		objectMap["properties"] = rup.RunbookUpdateProperties
	}
	if rup.Name != nil {
		objectMap["name"] = rup.Name
	}
	if rup.Location != nil {
		objectMap["location"] = rup.Location
	}
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RunbookUpdateParameters struct.
func (rup *RunbookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runbookUpdateProperties RunbookUpdateProperties
				err = json.Unmarshal(*v, &runbookUpdateProperties)
				if err != nil {
					return err
				}
				rup.RunbookUpdateProperties = &runbookUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rup.Tags = tags
			}
		}
	}

	return nil
}

// RunbookUpdateProperties the parameters supplied to the update runbook properties.
type RunbookUpdateProperties struct {
	// Description - Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// LogActivityTrace - Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
}

// Schedule definition of the schedule.
type Schedule struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets name of the schedule.
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// ScheduleProperties - Gets or sets the properties of the schedule.
	*ScheduleProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Schedule struct.
func (s *Schedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var scheduleProperties ScheduleProperties
				err = json.Unmarshal(*v, &scheduleProperties)
				if err != nil {
					return err
				}
				s.ScheduleProperties = &scheduleProperties
			}
		}
	}

	return nil
}

// ScheduleAssociationProperty the schedule property associated with the entity.
type ScheduleAssociationProperty struct {
	// Name - Gets or sets the name of the schedule.
	Name *string `json:"name,omitempty"`
}

// ScheduleCreateOrUpdateParameters the parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the schedule.
	Name *string `json:"name,omitempty"`
	// ScheduleCreateOrUpdateProperties - Gets or sets the list of schedule properties.
	*ScheduleCreateOrUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ScheduleCreateOrUpdateParameters struct.
func (scoup *ScheduleCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scoup.Name = &name
			}
		case "properties":
			if v != nil {
				var scheduleCreateOrUpdateProperties ScheduleCreateOrUpdateProperties
				err = json.Unmarshal(*v, &scheduleCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				scoup.ScheduleCreateOrUpdateProperties = &scheduleCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// ScheduleCreateOrUpdateProperties the parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateProperties struct {
	// Description - Gets or sets the description of the schedule.
	Description *string `json:"description,omitempty"`
	// StartTime - Gets or sets the start time of the schedule.
	StartTime *date.Time `json:"startTime,omitempty"`
	// ExpiryTime - Gets or sets the end time of the schedule.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Interval - Gets or sets the interval of the schedule.
	Interval interface{} `json:"interval,omitempty"`
	// Frequency - Possible values include: 'OneTime', 'Day', 'Hour', 'Week', 'Month'
	Frequency ScheduleFrequency `json:"frequency,omitempty"`
	// TimeZone - Gets or sets the time zone of the schedule.
	TimeZone *string `json:"timeZone,omitempty"`
	// AdvancedSchedule - Gets or sets the AdvancedSchedule.
	AdvancedSchedule *AdvancedSchedule `json:"advancedSchedule,omitempty"`
}

// ScheduleListResult the response model for the list schedule operation.
type ScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of schedules.
	Value *[]Schedule `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScheduleListResultIterator provides access to a complete listing of Schedule values.
type ScheduleListResultIterator struct {
	i    int
	page ScheduleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScheduleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScheduleListResultIterator) Response() ScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScheduleListResultIterator) Value() Schedule {
	if !iter.page.NotDone() {
		return Schedule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ScheduleListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// scheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ScheduleListResult) scheduleListResultPreparer() (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ScheduleListResultPage contains a page of Schedule values.
type ScheduleListResultPage struct {
	fn  func(ScheduleListResult) (ScheduleListResult, error)
	slr ScheduleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScheduleListResultPage) Next() error {
	next, err := page.fn(page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScheduleListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScheduleListResultPage) Response() ScheduleListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScheduleListResultPage) Values() []Schedule {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// ScheduleProperties definition of schedule parameters.
type ScheduleProperties struct {
	// StartTime - Gets or sets the start time of the schedule.
	StartTime *date.Time `json:"startTime,omitempty"`
	// StartTimeOffsetMinutes - Gets the start time's offset in minutes.
	StartTimeOffsetMinutes *float64 `json:"startTimeOffsetMinutes,omitempty"`
	// ExpiryTime - Gets or sets the end time of the schedule.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// ExpiryTimeOffsetMinutes - Gets or sets the expiry time's offset in minutes.
	ExpiryTimeOffsetMinutes *float64 `json:"expiryTimeOffsetMinutes,omitempty"`
	// IsEnabled - Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// NextRun - Gets or sets the next run time of the schedule.
	NextRun *date.Time `json:"nextRun,omitempty"`
	// NextRunOffsetMinutes - Gets or sets the next run time's offset in minutes.
	NextRunOffsetMinutes *float64 `json:"nextRunOffsetMinutes,omitempty"`
	// Interval - Gets or sets the interval of the schedule.
	Interval interface{} `json:"interval,omitempty"`
	// Frequency - Gets or sets the frequency of the schedule. Possible values include: 'OneTime', 'Day', 'Hour', 'Week', 'Month'
	Frequency ScheduleFrequency `json:"frequency,omitempty"`
	// TimeZone - Gets or sets the time zone of the schedule.
	TimeZone *string `json:"timeZone,omitempty"`
	// AdvancedSchedule - Gets or sets the advanced schedule.
	AdvancedSchedule *AdvancedSchedule `json:"advancedSchedule,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// ScheduleUpdateParameters the parameters supplied to the update schedule operation.
type ScheduleUpdateParameters struct {
	// Name - Gets or sets the name of the schedule.
	Name *string `json:"name,omitempty"`
	// ScheduleUpdateProperties - Gets or sets the list of schedule properties.
	*ScheduleUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ScheduleUpdateParameters struct.
func (sup *ScheduleUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sup.Name = &name
			}
		case "properties":
			if v != nil {
				var scheduleUpdateProperties ScheduleUpdateProperties
				err = json.Unmarshal(*v, &scheduleUpdateProperties)
				if err != nil {
					return err
				}
				sup.ScheduleUpdateProperties = &scheduleUpdateProperties
			}
		}
	}

	return nil
}

// ScheduleUpdateProperties the parameters supplied to the update schedule operation.
type ScheduleUpdateProperties struct {
	// Description - Gets or sets the description of the schedule.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// Sku the account SKU.
type Sku struct {
	// Name - Gets or sets the SKU name of the account. Possible values include: 'Free', 'Basic'
	Name SkuNameEnum `json:"name,omitempty"`
	// Family - Gets or sets the SKU family.
	Family *string `json:"family,omitempty"`
	// Capacity - Gets or sets the SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// Statistics definition of the statistic.
type Statistics struct {
	// CounterProperty - Gets the property value of the statistic.
	CounterProperty *string `json:"counterProperty,omitempty"`
	// CounterValue - Gets the value of the statistic.
	CounterValue *int64 `json:"counterValue,omitempty"`
	// StartTime - Gets the startTime of the statistic.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets the endTime of the statistic.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ID - Gets the id.
	ID *string `json:"id,omitempty"`
}

// StatisticsListResult the response model for the list statistics operation.
type StatisticsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of statistics.
	Value *[]Statistics `json:"value,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// SubResource the Sub Resource definition.
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// TestJob definition of the test job.
type TestJob struct {
	autorest.Response `json:"-"`
	// CreationTime - Gets or sets the creation time of the test job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Status - Gets or sets the status of the test job.
	Status *string `json:"status,omitempty"`
	// StatusDetails - Gets or sets the status details of the test job.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
	// StartTime - Gets or sets the start time of the test job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets or sets the end time of the test job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Exception - Gets or sets the exception of the test job.
	Exception *string `json:"exception,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time of the test job.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastStatusModifiedTime - Gets or sets the last status modified time of the test job.
	LastStatusModifiedTime *date.Time `json:"lastStatusModifiedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the test job.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for TestJob.
func (tj TestJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tj.CreationTime != nil {
		objectMap["creationTime"] = tj.CreationTime
	}
	if tj.Status != nil {
		objectMap["status"] = tj.Status
	}
	if tj.StatusDetails != nil {
		objectMap["statusDetails"] = tj.StatusDetails
	}
	if tj.RunOn != nil {
		objectMap["runOn"] = tj.RunOn
	}
	if tj.StartTime != nil {
		objectMap["startTime"] = tj.StartTime
	}
	if tj.EndTime != nil {
		objectMap["endTime"] = tj.EndTime
	}
	if tj.Exception != nil {
		objectMap["exception"] = tj.Exception
	}
	if tj.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = tj.LastModifiedTime
	}
	if tj.LastStatusModifiedTime != nil {
		objectMap["lastStatusModifiedTime"] = tj.LastStatusModifiedTime
	}
	if tj.Parameters != nil {
		objectMap["parameters"] = tj.Parameters
	}
	return json.Marshal(objectMap)
}

// TestJobCreateParameters the parameters supplied to the create test job operation.
type TestJobCreateParameters struct {
	// RunbookName - Gets or sets the runbook name.
	RunbookName *string `json:"runbookName,omitempty"`
	// Parameters - Gets or sets the parameters of the test job.
	Parameters map[string]*string `json:"parameters"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
}

// MarshalJSON is the custom marshaler for TestJobCreateParameters.
func (tjcp TestJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tjcp.RunbookName != nil {
		objectMap["runbookName"] = tjcp.RunbookName
	}
	if tjcp.Parameters != nil {
		objectMap["parameters"] = tjcp.Parameters
	}
	if tjcp.RunOn != nil {
		objectMap["runOn"] = tjcp.RunOn
	}
	return json.Marshal(objectMap)
}

// TypeField information about a field of a type.
type TypeField struct {
	// Name - Gets or sets the name of the field.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the field.
	Type *string `json:"type,omitempty"`
}

// TypeFieldListResult the response model for the list fields operation.
type TypeFieldListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of fields.
	Value *[]TypeField `json:"value,omitempty"`
}

// Usage definition of Usage.
type Usage struct {
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the usage counter name.
	Name *UsageCounterName `json:"name,omitempty"`
	// Unit - Gets or sets the usage unit name.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Gets or sets the current usage value.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - Gets or sets max limit. -1 for unlimited
	Limit *int64 `json:"limit,omitempty"`
	// ThrottleStatus - Gets or sets the throttle status.
	ThrottleStatus *string `json:"throttleStatus,omitempty"`
}

// UsageCounterName definition of usage counter name.
type UsageCounterName struct {
	// Value - Gets or sets the usage counter name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Gets or sets the localized usage counter name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsageListResult the response model for the get usage operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets usage.
	Value *[]Usage `json:"value,omitempty"`
}

// Variable definition of the varible.
type Variable struct {
	autorest.Response `json:"-"`
	// ID - Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets the name of the variable.
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// VariableProperties - Gets or sets the properties of the variable.
	*VariableProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Variable struct.
func (vVar *Variable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var variableProperties VariableProperties
				err = json.Unmarshal(*v, &variableProperties)
				if err != nil {
					return err
				}
				vVar.VariableProperties = &variableProperties
			}
		}
	}

	return nil
}

// VariableCreateOrUpdateParameters the parameters supplied to the create or update variable operation.
type VariableCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the variable.
	Name *string `json:"name,omitempty"`
	// VariableCreateOrUpdateProperties - Gets or sets the properties of the variable.
	*VariableCreateOrUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for VariableCreateOrUpdateParameters struct.
func (vcoup *VariableCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var variableCreateOrUpdateProperties VariableCreateOrUpdateProperties
				err = json.Unmarshal(*v, &variableCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				vcoup.VariableCreateOrUpdateProperties = &variableCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// VariableCreateOrUpdateProperties the properties of the create variable operation.
type VariableCreateOrUpdateProperties struct {
	// Value - Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
	// Description - Gets or sets the description of the variable.
	Description *string `json:"description,omitempty"`
	// IsEncrypted - Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
}

// VariableListResult the response model for the list variables operation.
type VariableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of variables.
	Value *[]Variable `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// VariableListResultIterator provides access to a complete listing of Variable values.
type VariableListResultIterator struct {
	i    int
	page VariableListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VariableListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VariableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VariableListResultIterator) Response() VariableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VariableListResultIterator) Value() Variable {
	if !iter.page.NotDone() {
		return Variable{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr VariableListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// variableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr VariableListResult) variableListResultPreparer() (*http.Request, error) {
	if vlr.NextLink == nil || len(to.String(vlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// VariableListResultPage contains a page of Variable values.
type VariableListResultPage struct {
	fn  func(VariableListResult) (VariableListResult, error)
	vlr VariableListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VariableListResultPage) Next() error {
	next, err := page.fn(page.vlr)
	if err != nil {
		return err
	}
	page.vlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VariableListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VariableListResultPage) Response() VariableListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VariableListResultPage) Values() []Variable {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// VariableProperties definition of the varible properties
type VariableProperties struct {
	// Value - Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
	// IsEncrypted - Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// VariableUpdateParameters the parameters supplied to the update variable operation.
type VariableUpdateParameters struct {
	// Name - Gets or sets the name of the variable.
	Name *string `json:"name,omitempty"`
	// VariableUpdateProperties - Gets or sets the value of the variable.
	*VariableUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for VariableUpdateParameters struct.
func (vup *VariableUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vup.Name = &name
			}
		case "properties":
			if v != nil {
				var variableUpdateProperties VariableUpdateProperties
				err = json.Unmarshal(*v, &variableUpdateProperties)
				if err != nil {
					return err
				}
				vup.VariableUpdateProperties = &variableUpdateProperties
			}
		}
	}

	return nil
}

// VariableUpdateProperties the properties of the update variable
type VariableUpdateProperties struct {
	// Value - Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
	// Description - Gets or sets the description of the variable.
	Description *string `json:"description,omitempty"`
}

// Webhook definition of the webhook type.
type Webhook struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of the webhook.
	Name *string `json:"name,omitempty"`
	// WebhookProperties - Gets or sets the webhook properties.
	*WebhookProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Webhook struct.
func (w *Webhook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "properties":
			if v != nil {
				var webhookProperties WebhookProperties
				err = json.Unmarshal(*v, &webhookProperties)
				if err != nil {
					return err
				}
				w.WebhookProperties = &webhookProperties
			}
		}
	}

	return nil
}

// WebhookCreateOrUpdateParameters the parameters supplied to the create or update webhook operation.
type WebhookCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the webhook.
	Name *string `json:"name,omitempty"`
	// WebhookCreateOrUpdateProperties - Gets or sets the properties of the webhook.
	*WebhookCreateOrUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for WebhookCreateOrUpdateParameters struct.
func (wcoup *WebhookCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var webhookCreateOrUpdateProperties WebhookCreateOrUpdateProperties
				err = json.Unmarshal(*v, &webhookCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				wcoup.WebhookCreateOrUpdateProperties = &webhookCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// WebhookCreateOrUpdateProperties the properties of the create webhook operation.
type WebhookCreateOrUpdateProperties struct {
	// IsEnabled - Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// URI - Gets or sets the uri.
	URI *string `json:"uri,omitempty"`
	// ExpiryTime - Gets or sets the expiry time.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookCreateOrUpdateProperties.
func (wcoup WebhookCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcoup.IsEnabled != nil {
		objectMap["isEnabled"] = wcoup.IsEnabled
	}
	if wcoup.URI != nil {
		objectMap["uri"] = wcoup.URI
	}
	if wcoup.ExpiryTime != nil {
		objectMap["expiryTime"] = wcoup.ExpiryTime
	}
	if wcoup.Parameters != nil {
		objectMap["parameters"] = wcoup.Parameters
	}
	if wcoup.Runbook != nil {
		objectMap["runbook"] = wcoup.Runbook
	}
	if wcoup.RunOn != nil {
		objectMap["runOn"] = wcoup.RunOn
	}
	return json.Marshal(objectMap)
}

// WebhookListResult the response model for the list webhook operation.
type WebhookListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of webhooks.
	Value *[]Webhook `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebhookListResultIterator provides access to a complete listing of Webhook values.
type WebhookListResultIterator struct {
	i    int
	page WebhookListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebhookListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebhookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebhookListResultIterator) Response() WebhookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebhookListResultIterator) Value() Webhook {
	if !iter.page.NotDone() {
		return Webhook{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WebhookListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// webhookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WebhookListResult) webhookListResultPreparer() (*http.Request, error) {
	if wlr.NextLink == nil || len(to.String(wlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WebhookListResultPage contains a page of Webhook values.
type WebhookListResultPage struct {
	fn  func(WebhookListResult) (WebhookListResult, error)
	wlr WebhookListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebhookListResultPage) Next() error {
	next, err := page.fn(page.wlr)
	if err != nil {
		return err
	}
	page.wlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebhookListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebhookListResultPage) Response() WebhookListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebhookListResultPage) Values() []Webhook {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// WebhookProperties definition of the webhook properties
type WebhookProperties struct {
	// IsEnabled - Gets or sets the value of the enabled flag of the webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// URI - Gets or sets the webhook uri.
	URI *string `json:"uri,omitempty"`
	// ExpiryTime - Gets or sets the expiry time.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// LastInvokedTime - Gets or sets the last invoked time.
	LastInvokedTime *date.Time `json:"lastInvokedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job that is created when the webhook calls the runbook it is associated with.
	Parameters map[string]*string `json:"parameters"`
	// Runbook - Gets or sets the runbook the webhook is associated with.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookProperties.
func (wp WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.IsEnabled != nil {
		objectMap["isEnabled"] = wp.IsEnabled
	}
	if wp.URI != nil {
		objectMap["uri"] = wp.URI
	}
	if wp.ExpiryTime != nil {
		objectMap["expiryTime"] = wp.ExpiryTime
	}
	if wp.LastInvokedTime != nil {
		objectMap["lastInvokedTime"] = wp.LastInvokedTime
	}
	if wp.Parameters != nil {
		objectMap["parameters"] = wp.Parameters
	}
	if wp.Runbook != nil {
		objectMap["runbook"] = wp.Runbook
	}
	if wp.RunOn != nil {
		objectMap["runOn"] = wp.RunOn
	}
	if wp.CreationTime != nil {
		objectMap["creationTime"] = wp.CreationTime
	}
	if wp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = wp.LastModifiedTime
	}
	if wp.Description != nil {
		objectMap["description"] = wp.Description
	}
	return json.Marshal(objectMap)
}

// WebhookUpdateParameters the parameters supplied to the update webhook operation.
type WebhookUpdateParameters struct {
	// Name - Gets or sets the name of the webhook.
	Name *string `json:"name,omitempty"`
	// WebhookUpdateProperties - Gets or sets the value of the webhook.
	*WebhookUpdateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for WebhookUpdateParameters struct.
func (wup *WebhookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wup.Name = &name
			}
		case "properties":
			if v != nil {
				var webhookUpdateProperties WebhookUpdateProperties
				err = json.Unmarshal(*v, &webhookUpdateProperties)
				if err != nil {
					return err
				}
				wup.WebhookUpdateProperties = &webhookUpdateProperties
			}
		}
	}

	return nil
}

// WebhookUpdateProperties the properties of the update webhook.
type WebhookUpdateProperties struct {
	// IsEnabled - Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RunOn - Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// Description - Gets or sets the description of the webhook.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookUpdateProperties.
func (wup WebhookUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.IsEnabled != nil {
		objectMap["isEnabled"] = wup.IsEnabled
	}
	if wup.RunOn != nil {
		objectMap["runOn"] = wup.RunOn
	}
	if wup.Parameters != nil {
		objectMap["parameters"] = wup.Parameters
	}
	if wup.Description != nil {
		objectMap["description"] = wup.Description
	}
	return json.Marshal(objectMap)
}
