// Code generated by protoc-gen-go. DO NOT EDIT.
// source: opencensus/proto/trace/v1/trace.proto

package v1

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type Span_SpanKind int32

const (
	// Unspecified.
	Span_SPAN_KIND_UNSPECIFIED Span_SpanKind = 0
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	Span_SERVER Span_SpanKind = 1
	// Indicates that the span covers the client-side wrapper around an RPC or
	// other remote request.
	Span_CLIENT Span_SpanKind = 2
)

var Span_SpanKind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "SERVER",
	2: "CLIENT",
}

var Span_SpanKind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"SERVER":                1,
	"CLIENT":                2,
}

func (x Span_SpanKind) String() string {
	return proto.EnumName(Span_SpanKind_name, int32(x))
}

func (Span_SpanKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 0}
}

// Indicates whether the message was sent or received.
type Span_TimeEvent_MessageEvent_Type int32

const (
	// Unknown event type.
	Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED Span_TimeEvent_MessageEvent_Type = 0
	// Indicates a sent message.
	Span_TimeEvent_MessageEvent_SENT Span_TimeEvent_MessageEvent_Type = 1
	// Indicates a received message.
	Span_TimeEvent_MessageEvent_RECEIVED Span_TimeEvent_MessageEvent_Type = 2
)

var Span_TimeEvent_MessageEvent_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "SENT",
	2: "RECEIVED",
}

var Span_TimeEvent_MessageEvent_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"SENT":             1,
	"RECEIVED":         2,
}

func (x Span_TimeEvent_MessageEvent_Type) String() string {
	return proto.EnumName(Span_TimeEvent_MessageEvent_Type_name, int32(x))
}

func (Span_TimeEvent_MessageEvent_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 2, 1, 0}
}

// The relationship of the current span relative to the linked span: child,
// parent, or unspecified.
type Span_Link_Type int32

const (
	// The relationship of the two spans is unknown, or known but other
	// than parent-child.
	Span_Link_TYPE_UNSPECIFIED Span_Link_Type = 0
	// The linked span is a child of the current span.
	Span_Link_CHILD_LINKED_SPAN Span_Link_Type = 1
	// The linked span is a parent of the current span.
	Span_Link_PARENT_LINKED_SPAN Span_Link_Type = 2
)

var Span_Link_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CHILD_LINKED_SPAN",
	2: "PARENT_LINKED_SPAN",
}

var Span_Link_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":   0,
	"CHILD_LINKED_SPAN":  1,
	"PARENT_LINKED_SPAN": 2,
}

func (x Span_Link_Type) String() string {
	return proto.EnumName(Span_Link_Type_name, int32(x))
}

func (Span_Link_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 4, 0}
}

// A span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Often, a trace contains a root span
// that describes the end-to-end latency, and one or more subspans for
// its sub-operations. A trace can also contain multiple root spans,
// or none at all. Spans do not need to be contiguous - there may be
// gaps or overlaps between spans in a trace.
//
// The next id is 16.
// TODO(bdrutu): Add an example.
type Span struct {
	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array.
	//
	// This field is required.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array.
	//
	// This field is required.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The Tracestate on the span.
	Tracestate *Span_Tracestate `protobuf:"bytes,15,opt,name=tracestate,proto3" json:"tracestate,omitempty"`
	// The `span_id` of this span's parent span. If this is a root span, then this
	// field must be empty. The ID is an 8-byte array.
	ParentSpanId []byte `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// A description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name at the same call point in an application.
	// This makes it easier to correlate spans in different traces.
	//
	// This field is required.
	Name *TruncatableString `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `CLIENT`
	// and `SERVER` to identify queueing latency associated with the span.
	Kind Span_SpanKind `protobuf:"varint,14,opt,name=kind,proto3,enum=opencensus.proto.trace.v1.Span_SpanKind" json:"kind,omitempty"`
	// The start time of the span. On the client side, this is the time kept by
	// the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	StartTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the span. On the client side, this is the time kept by
	// the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	EndTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// A set of attributes on the span.
	Attributes *Span_Attributes `protobuf:"bytes,7,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// A stack trace captured at the start of the span.
	StackTrace *StackTrace `protobuf:"bytes,8,opt,name=stack_trace,json=stackTrace,proto3" json:"stack_trace,omitempty"`
	// The included time events.
	TimeEvents *Span_TimeEvents `protobuf:"bytes,9,opt,name=time_events,json=timeEvents,proto3" json:"time_events,omitempty"`
	// The included links.
	Links *Span_Links `protobuf:"bytes,10,opt,name=links,proto3" json:"links,omitempty"`
	// An optional final status for this span.
	Status *Status `protobuf:"bytes,11,opt,name=status,proto3" json:"status,omitempty"`
	// A highly recommended but not required flag that identifies when a trace
	// crosses a process boundary. True when the parent_span belongs to the
	// same process as the current span.
	SameProcessAsParentSpan *wrappers.BoolValue `protobuf:"bytes,12,opt,name=same_process_as_parent_span,json=sameProcessAsParentSpan,proto3" json:"same_process_as_parent_span,omitempty"`
	// An optional number of child spans that were generated while this span
	// was active. If set, allows an implementation to detect missing child spans.
	ChildSpanCount       *wrappers.UInt32Value `protobuf:"bytes,13,opt,name=child_span_count,json=childSpanCount,proto3" json:"child_span_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Span) Reset()         { *m = Span{} }
func (m *Span) String() string { return proto.CompactTextString(m) }
func (*Span) ProtoMessage()    {}
func (*Span) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0}
}

func (m *Span) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span.Unmarshal(m, b)
}
func (m *Span) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span.Marshal(b, m, deterministic)
}
func (m *Span) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span.Merge(m, src)
}
func (m *Span) XXX_Size() int {
	return xxx_messageInfo_Span.Size(m)
}
func (m *Span) XXX_DiscardUnknown() {
	xxx_messageInfo_Span.DiscardUnknown(m)
}

var xxx_messageInfo_Span proto.InternalMessageInfo

func (m *Span) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span) GetTracestate() *Span_Tracestate {
	if m != nil {
		return m.Tracestate
	}
	return nil
}

func (m *Span) GetParentSpanId() []byte {
	if m != nil {
		return m.ParentSpanId
	}
	return nil
}

func (m *Span) GetName() *TruncatableString {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Span) GetKind() Span_SpanKind {
	if m != nil {
		return m.Kind
	}
	return Span_SPAN_KIND_UNSPECIFIED
}

func (m *Span) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Span) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Span) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span) GetStackTrace() *StackTrace {
	if m != nil {
		return m.StackTrace
	}
	return nil
}

func (m *Span) GetTimeEvents() *Span_TimeEvents {
	if m != nil {
		return m.TimeEvents
	}
	return nil
}

func (m *Span) GetLinks() *Span_Links {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *Span) GetStatus() *Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Span) GetSameProcessAsParentSpan() *wrappers.BoolValue {
	if m != nil {
		return m.SameProcessAsParentSpan
	}
	return nil
}

func (m *Span) GetChildSpanCount() *wrappers.UInt32Value {
	if m != nil {
		return m.ChildSpanCount
	}
	return nil
}

// This field conveys information about request position in multiple distributed tracing graphs.
// It is a list of Tracestate.Entry with a maximum of 32 members in the list.
//
// See the https://github.com/w3c/distributed-tracing for more details about this field.
type Span_Tracestate struct {
	// A list of entries that represent the Tracestate.
	Entries              []*Span_Tracestate_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Span_Tracestate) Reset()         { *m = Span_Tracestate{} }
func (m *Span_Tracestate) String() string { return proto.CompactTextString(m) }
func (*Span_Tracestate) ProtoMessage()    {}
func (*Span_Tracestate) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 0}
}

func (m *Span_Tracestate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_Tracestate.Unmarshal(m, b)
}
func (m *Span_Tracestate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_Tracestate.Marshal(b, m, deterministic)
}
func (m *Span_Tracestate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Tracestate.Merge(m, src)
}
func (m *Span_Tracestate) XXX_Size() int {
	return xxx_messageInfo_Span_Tracestate.Size(m)
}
func (m *Span_Tracestate) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Tracestate.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Tracestate proto.InternalMessageInfo

func (m *Span_Tracestate) GetEntries() []*Span_Tracestate_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type Span_Tracestate_Entry struct {
	// The key must begin with a lowercase letter, and can only contain
	// lowercase letters 'a'-'z', digits '0'-'9', underscores '_', dashes
	// '-', asterisks '*', and forward slashes '/'.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value is opaque string up to 256 characters printable ASCII
	// RFC0020 characters (i.e., the range 0x20 to 0x7E) except ',' and '='.
	// Note that this also excludes tabs, newlines, carriage returns, etc.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Span_Tracestate_Entry) Reset()         { *m = Span_Tracestate_Entry{} }
func (m *Span_Tracestate_Entry) String() string { return proto.CompactTextString(m) }
func (*Span_Tracestate_Entry) ProtoMessage()    {}
func (*Span_Tracestate_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 0, 0}
}

func (m *Span_Tracestate_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_Tracestate_Entry.Unmarshal(m, b)
}
func (m *Span_Tracestate_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_Tracestate_Entry.Marshal(b, m, deterministic)
}
func (m *Span_Tracestate_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Tracestate_Entry.Merge(m, src)
}
func (m *Span_Tracestate_Entry) XXX_Size() int {
	return xxx_messageInfo_Span_Tracestate_Entry.Size(m)
}
func (m *Span_Tracestate_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Tracestate_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Tracestate_Entry proto.InternalMessageInfo

func (m *Span_Tracestate_Entry) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Span_Tracestate_Entry) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A set of attributes, each with a key and a value.
type Span_Attributes struct {
	// The set of attributes. The value can be a string, an integer, or the
	// Boolean values `true` and `false`. For example:
	//
	//     "/instance_id": "my-instance"
	//     "/http/user_agent": ""
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	AttributeMap map[string]*AttributeValue `protobuf:"bytes,1,rep,name=attribute_map,json=attributeMap,proto3" json:"attribute_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The number of attributes that were discarded. Attributes can be discarded
	// because their keys are too long or because there are too many attributes.
	// If this value is 0, then no attributes were dropped.
	DroppedAttributesCount int32    `protobuf:"varint,2,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Span_Attributes) Reset()         { *m = Span_Attributes{} }
func (m *Span_Attributes) String() string { return proto.CompactTextString(m) }
func (*Span_Attributes) ProtoMessage()    {}
func (*Span_Attributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 1}
}

func (m *Span_Attributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_Attributes.Unmarshal(m, b)
}
func (m *Span_Attributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_Attributes.Marshal(b, m, deterministic)
}
func (m *Span_Attributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Attributes.Merge(m, src)
}
func (m *Span_Attributes) XXX_Size() int {
	return xxx_messageInfo_Span_Attributes.Size(m)
}
func (m *Span_Attributes) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Attributes.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Attributes proto.InternalMessageInfo

func (m *Span_Attributes) GetAttributeMap() map[string]*AttributeValue {
	if m != nil {
		return m.AttributeMap
	}
	return nil
}

func (m *Span_Attributes) GetDroppedAttributesCount() int32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// A time-stamped annotation or message event in the Span.
type Span_TimeEvent struct {
	// The time the event occurred.
	Time *timestamp.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// A `TimeEvent` can contain either an `Annotation` object or a
	// `MessageEvent` object, but not both.
	//
	// Types that are valid to be assigned to Value:
	//	*Span_TimeEvent_Annotation_
	//	*Span_TimeEvent_MessageEvent_
	Value                isSpan_TimeEvent_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Span_TimeEvent) Reset()         { *m = Span_TimeEvent{} }
func (m *Span_TimeEvent) String() string { return proto.CompactTextString(m) }
func (*Span_TimeEvent) ProtoMessage()    {}
func (*Span_TimeEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 2}
}

func (m *Span_TimeEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_TimeEvent.Unmarshal(m, b)
}
func (m *Span_TimeEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_TimeEvent.Marshal(b, m, deterministic)
}
func (m *Span_TimeEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_TimeEvent.Merge(m, src)
}
func (m *Span_TimeEvent) XXX_Size() int {
	return xxx_messageInfo_Span_TimeEvent.Size(m)
}
func (m *Span_TimeEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_TimeEvent.DiscardUnknown(m)
}

var xxx_messageInfo_Span_TimeEvent proto.InternalMessageInfo

func (m *Span_TimeEvent) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

type isSpan_TimeEvent_Value interface {
	isSpan_TimeEvent_Value()
}

type Span_TimeEvent_Annotation_ struct {
	Annotation *Span_TimeEvent_Annotation `protobuf:"bytes,2,opt,name=annotation,proto3,oneof"`
}

type Span_TimeEvent_MessageEvent_ struct {
	MessageEvent *Span_TimeEvent_MessageEvent `protobuf:"bytes,3,opt,name=message_event,json=messageEvent,proto3,oneof"`
}

func (*Span_TimeEvent_Annotation_) isSpan_TimeEvent_Value() {}

func (*Span_TimeEvent_MessageEvent_) isSpan_TimeEvent_Value() {}

func (m *Span_TimeEvent) GetValue() isSpan_TimeEvent_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Span_TimeEvent) GetAnnotation() *Span_TimeEvent_Annotation {
	if x, ok := m.GetValue().(*Span_TimeEvent_Annotation_); ok {
		return x.Annotation
	}
	return nil
}

func (m *Span_TimeEvent) GetMessageEvent() *Span_TimeEvent_MessageEvent {
	if x, ok := m.GetValue().(*Span_TimeEvent_MessageEvent_); ok {
		return x.MessageEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Span_TimeEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Span_TimeEvent_OneofMarshaler, _Span_TimeEvent_OneofUnmarshaler, _Span_TimeEvent_OneofSizer, []interface{}{
		(*Span_TimeEvent_Annotation_)(nil),
		(*Span_TimeEvent_MessageEvent_)(nil),
	}
}

func _Span_TimeEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Span_TimeEvent)
	// value
	switch x := m.Value.(type) {
	case *Span_TimeEvent_Annotation_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Annotation); err != nil {
			return err
		}
	case *Span_TimeEvent_MessageEvent_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MessageEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Span_TimeEvent.Value has unexpected type %T", x)
	}
	return nil
}

func _Span_TimeEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Span_TimeEvent)
	switch tag {
	case 2: // value.annotation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Span_TimeEvent_Annotation)
		err := b.DecodeMessage(msg)
		m.Value = &Span_TimeEvent_Annotation_{msg}
		return true, err
	case 3: // value.message_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Span_TimeEvent_MessageEvent)
		err := b.DecodeMessage(msg)
		m.Value = &Span_TimeEvent_MessageEvent_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Span_TimeEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Span_TimeEvent)
	// value
	switch x := m.Value.(type) {
	case *Span_TimeEvent_Annotation_:
		s := proto.Size(x.Annotation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Span_TimeEvent_MessageEvent_:
		s := proto.Size(x.MessageEvent)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A text annotation with a set of attributes.
type Span_TimeEvent_Annotation struct {
	// A user-supplied message describing the event.
	Description *TruncatableString `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// A set of attributes on the annotation.
	Attributes           *Span_Attributes `protobuf:"bytes,2,opt,name=attributes,proto3" json:"attributes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Span_TimeEvent_Annotation) Reset()         { *m = Span_TimeEvent_Annotation{} }
func (m *Span_TimeEvent_Annotation) String() string { return proto.CompactTextString(m) }
func (*Span_TimeEvent_Annotation) ProtoMessage()    {}
func (*Span_TimeEvent_Annotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 2, 0}
}

func (m *Span_TimeEvent_Annotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_TimeEvent_Annotation.Unmarshal(m, b)
}
func (m *Span_TimeEvent_Annotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_TimeEvent_Annotation.Marshal(b, m, deterministic)
}
func (m *Span_TimeEvent_Annotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_TimeEvent_Annotation.Merge(m, src)
}
func (m *Span_TimeEvent_Annotation) XXX_Size() int {
	return xxx_messageInfo_Span_TimeEvent_Annotation.Size(m)
}
func (m *Span_TimeEvent_Annotation) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_TimeEvent_Annotation.DiscardUnknown(m)
}

var xxx_messageInfo_Span_TimeEvent_Annotation proto.InternalMessageInfo

func (m *Span_TimeEvent_Annotation) GetDescription() *TruncatableString {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *Span_TimeEvent_Annotation) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// An event describing a message sent/received between Spans.
type Span_TimeEvent_MessageEvent struct {
	// The type of MessageEvent. Indicates whether the message was sent or
	// received.
	Type Span_TimeEvent_MessageEvent_Type `protobuf:"varint,1,opt,name=type,proto3,enum=opencensus.proto.trace.v1.Span_TimeEvent_MessageEvent_Type" json:"type,omitempty"`
	// An identifier for the MessageEvent's message that can be used to match
	// SENT and RECEIVED MessageEvents. For example, this field could
	// represent a sequence ID for a streaming RPC. It is recommended to be
	// unique within a Span.
	Id uint64 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// The number of uncompressed bytes sent or received.
	UncompressedSize uint64 `protobuf:"varint,3,opt,name=uncompressed_size,json=uncompressedSize,proto3" json:"uncompressed_size,omitempty"`
	// The number of compressed bytes sent or received. If zero, assumed to
	// be the same size as uncompressed.
	CompressedSize       uint64   `protobuf:"varint,4,opt,name=compressed_size,json=compressedSize,proto3" json:"compressed_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Span_TimeEvent_MessageEvent) Reset()         { *m = Span_TimeEvent_MessageEvent{} }
func (m *Span_TimeEvent_MessageEvent) String() string { return proto.CompactTextString(m) }
func (*Span_TimeEvent_MessageEvent) ProtoMessage()    {}
func (*Span_TimeEvent_MessageEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 2, 1}
}

func (m *Span_TimeEvent_MessageEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_TimeEvent_MessageEvent.Unmarshal(m, b)
}
func (m *Span_TimeEvent_MessageEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_TimeEvent_MessageEvent.Marshal(b, m, deterministic)
}
func (m *Span_TimeEvent_MessageEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_TimeEvent_MessageEvent.Merge(m, src)
}
func (m *Span_TimeEvent_MessageEvent) XXX_Size() int {
	return xxx_messageInfo_Span_TimeEvent_MessageEvent.Size(m)
}
func (m *Span_TimeEvent_MessageEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_TimeEvent_MessageEvent.DiscardUnknown(m)
}

var xxx_messageInfo_Span_TimeEvent_MessageEvent proto.InternalMessageInfo

func (m *Span_TimeEvent_MessageEvent) GetType() Span_TimeEvent_MessageEvent_Type {
	if m != nil {
		return m.Type
	}
	return Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED
}

func (m *Span_TimeEvent_MessageEvent) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Span_TimeEvent_MessageEvent) GetUncompressedSize() uint64 {
	if m != nil {
		return m.UncompressedSize
	}
	return 0
}

func (m *Span_TimeEvent_MessageEvent) GetCompressedSize() uint64 {
	if m != nil {
		return m.CompressedSize
	}
	return 0
}

// A collection of `TimeEvent`s. A `TimeEvent` is a time-stamped annotation
// on the span, consisting of either user-supplied key-value pairs, or
// details of a message sent/received between Spans.
type Span_TimeEvents struct {
	// A collection of `TimeEvent`s.
	TimeEvent []*Span_TimeEvent `protobuf:"bytes,1,rep,name=time_event,json=timeEvent,proto3" json:"time_event,omitempty"`
	// The number of dropped annotations in all the included time events.
	// If the value is 0, then no annotations were dropped.
	DroppedAnnotationsCount int32 `protobuf:"varint,2,opt,name=dropped_annotations_count,json=droppedAnnotationsCount,proto3" json:"dropped_annotations_count,omitempty"`
	// The number of dropped message events in all the included time events.
	// If the value is 0, then no message events were dropped.
	DroppedMessageEventsCount int32    `protobuf:"varint,3,opt,name=dropped_message_events_count,json=droppedMessageEventsCount,proto3" json:"dropped_message_events_count,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *Span_TimeEvents) Reset()         { *m = Span_TimeEvents{} }
func (m *Span_TimeEvents) String() string { return proto.CompactTextString(m) }
func (*Span_TimeEvents) ProtoMessage()    {}
func (*Span_TimeEvents) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 3}
}

func (m *Span_TimeEvents) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_TimeEvents.Unmarshal(m, b)
}
func (m *Span_TimeEvents) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_TimeEvents.Marshal(b, m, deterministic)
}
func (m *Span_TimeEvents) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_TimeEvents.Merge(m, src)
}
func (m *Span_TimeEvents) XXX_Size() int {
	return xxx_messageInfo_Span_TimeEvents.Size(m)
}
func (m *Span_TimeEvents) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_TimeEvents.DiscardUnknown(m)
}

var xxx_messageInfo_Span_TimeEvents proto.InternalMessageInfo

func (m *Span_TimeEvents) GetTimeEvent() []*Span_TimeEvent {
	if m != nil {
		return m.TimeEvent
	}
	return nil
}

func (m *Span_TimeEvents) GetDroppedAnnotationsCount() int32 {
	if m != nil {
		return m.DroppedAnnotationsCount
	}
	return 0
}

func (m *Span_TimeEvents) GetDroppedMessageEventsCount() int32 {
	if m != nil {
		return m.DroppedMessageEventsCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The relationship of the current span relative to the linked span.
	Type Span_Link_Type `protobuf:"varint,3,opt,name=type,proto3,enum=opencensus.proto.trace.v1.Span_Link_Type" json:"type,omitempty"`
	// A set of attributes on the link.
	Attributes           *Span_Attributes `protobuf:"bytes,4,opt,name=attributes,proto3" json:"attributes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Span_Link) Reset()         { *m = Span_Link{} }
func (m *Span_Link) String() string { return proto.CompactTextString(m) }
func (*Span_Link) ProtoMessage()    {}
func (*Span_Link) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 4}
}

func (m *Span_Link) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_Link.Unmarshal(m, b)
}
func (m *Span_Link) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_Link.Marshal(b, m, deterministic)
}
func (m *Span_Link) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Link.Merge(m, src)
}
func (m *Span_Link) XXX_Size() int {
	return xxx_messageInfo_Span_Link.Size(m)
}
func (m *Span_Link) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Link.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Link proto.InternalMessageInfo

func (m *Span_Link) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span_Link) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span_Link) GetType() Span_Link_Type {
	if m != nil {
		return m.Type
	}
	return Span_Link_TYPE_UNSPECIFIED
}

func (m *Span_Link) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A collection of links, which are references from this span to a span
// in the same or different trace.
type Span_Links struct {
	// A collection of links.
	Link []*Span_Link `protobuf:"bytes,1,rep,name=link,proto3" json:"link,omitempty"`
	// The number of dropped links after the maximum size was enforced. If
	// this value is 0, then no links were dropped.
	DroppedLinksCount    int32    `protobuf:"varint,2,opt,name=dropped_links_count,json=droppedLinksCount,proto3" json:"dropped_links_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Span_Links) Reset()         { *m = Span_Links{} }
func (m *Span_Links) String() string { return proto.CompactTextString(m) }
func (*Span_Links) ProtoMessage()    {}
func (*Span_Links) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{0, 5}
}

func (m *Span_Links) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_Links.Unmarshal(m, b)
}
func (m *Span_Links) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_Links.Marshal(b, m, deterministic)
}
func (m *Span_Links) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Links.Merge(m, src)
}
func (m *Span_Links) XXX_Size() int {
	return xxx_messageInfo_Span_Links.Size(m)
}
func (m *Span_Links) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Links.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Links proto.InternalMessageInfo

func (m *Span_Links) GetLink() []*Span_Link {
	if m != nil {
		return m.Link
	}
	return nil
}

func (m *Span_Links) GetDroppedLinksCount() int32 {
	if m != nil {
		return m.DroppedLinksCount
	}
	return 0
}

// The `Status` type defines a logical error model that is suitable for different
// programming environments, including REST APIs and RPC APIs. This proto's fields
// are a subset of those of
// [google.rpc.Status](https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto),
// which is used by [gRPC](https://github.com/grpc).
type Status struct {
	// The status code.
	Code int32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// A developer-facing error message, which should be in English.
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Status) Reset()         { *m = Status{} }
func (m *Status) String() string { return proto.CompactTextString(m) }
func (*Status) ProtoMessage()    {}
func (*Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{1}
}

func (m *Status) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Status.Unmarshal(m, b)
}
func (m *Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Status.Marshal(b, m, deterministic)
}
func (m *Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Status.Merge(m, src)
}
func (m *Status) XXX_Size() int {
	return xxx_messageInfo_Status.Size(m)
}
func (m *Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Status proto.InternalMessageInfo

func (m *Status) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Status) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// The value of an Attribute.
type AttributeValue struct {
	// The type of the value.
	//
	// Types that are valid to be assigned to Value:
	//	*AttributeValue_StringValue
	//	*AttributeValue_IntValue
	//	*AttributeValue_BoolValue
	//	*AttributeValue_DoubleValue
	Value                isAttributeValue_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *AttributeValue) Reset()         { *m = AttributeValue{} }
func (m *AttributeValue) String() string { return proto.CompactTextString(m) }
func (*AttributeValue) ProtoMessage()    {}
func (*AttributeValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{2}
}

func (m *AttributeValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeValue.Unmarshal(m, b)
}
func (m *AttributeValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeValue.Marshal(b, m, deterministic)
}
func (m *AttributeValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeValue.Merge(m, src)
}
func (m *AttributeValue) XXX_Size() int {
	return xxx_messageInfo_AttributeValue.Size(m)
}
func (m *AttributeValue) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeValue.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeValue proto.InternalMessageInfo

type isAttributeValue_Value interface {
	isAttributeValue_Value()
}

type AttributeValue_StringValue struct {
	StringValue *TruncatableString `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type AttributeValue_IntValue struct {
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type AttributeValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type AttributeValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*AttributeValue_StringValue) isAttributeValue_Value() {}

func (*AttributeValue_IntValue) isAttributeValue_Value() {}

func (*AttributeValue_BoolValue) isAttributeValue_Value() {}

func (*AttributeValue_DoubleValue) isAttributeValue_Value() {}

func (m *AttributeValue) GetValue() isAttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *AttributeValue) GetStringValue() *TruncatableString {
	if x, ok := m.GetValue().(*AttributeValue_StringValue); ok {
		return x.StringValue
	}
	return nil
}

func (m *AttributeValue) GetIntValue() int64 {
	if x, ok := m.GetValue().(*AttributeValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *AttributeValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*AttributeValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *AttributeValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*AttributeValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AttributeValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AttributeValue_OneofMarshaler, _AttributeValue_OneofUnmarshaler, _AttributeValue_OneofSizer, []interface{}{
		(*AttributeValue_StringValue)(nil),
		(*AttributeValue_IntValue)(nil),
		(*AttributeValue_BoolValue)(nil),
		(*AttributeValue_DoubleValue)(nil),
	}
}

func _AttributeValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *AttributeValue_StringValue:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringValue); err != nil {
			return err
		}
	case *AttributeValue_IntValue:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntValue))
	case *AttributeValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *AttributeValue_DoubleValue:
		b.EncodeVarint(4<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case nil:
	default:
		return fmt.Errorf("AttributeValue.Value has unexpected type %T", x)
	}
	return nil
}

func _AttributeValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AttributeValue)
	switch tag {
	case 1: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TruncatableString)
		err := b.DecodeMessage(msg)
		m.Value = &AttributeValue_StringValue{msg}
		return true, err
	case 2: // value.int_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &AttributeValue_IntValue{int64(x)}
		return true, err
	case 3: // value.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &AttributeValue_BoolValue{x != 0}
		return true, err
	case 4: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &AttributeValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	default:
		return false, nil
	}
}

func _AttributeValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *AttributeValue_StringValue:
		s := proto.Size(x.StringValue)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AttributeValue_IntValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.IntValue))
	case *AttributeValue_BoolValue:
		n += 1 // tag and wire
		n += 1
	case *AttributeValue_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The call stack which originated this span.
type StackTrace struct {
	// Stack frames in this stack trace.
	StackFrames *StackTrace_StackFrames `protobuf:"bytes,1,opt,name=stack_frames,json=stackFrames,proto3" json:"stack_frames,omitempty"`
	// The hash ID is used to conserve network bandwidth for duplicate
	// stack traces within a single trace.
	//
	// Often multiple spans will have identical stack traces.
	// The first occurrence of a stack trace should contain both
	// `stack_frames` and a value in `stack_trace_hash_id`.
	//
	// Subsequent spans within the same request can refer
	// to that stack trace by setting only `stack_trace_hash_id`.
	//
	// TODO: describe how to deal with the case where stack_trace_hash_id is
	// zero because it was not set.
	StackTraceHashId     uint64   `protobuf:"varint,2,opt,name=stack_trace_hash_id,json=stackTraceHashId,proto3" json:"stack_trace_hash_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StackTrace) Reset()         { *m = StackTrace{} }
func (m *StackTrace) String() string { return proto.CompactTextString(m) }
func (*StackTrace) ProtoMessage()    {}
func (*StackTrace) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{3}
}

func (m *StackTrace) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StackTrace.Unmarshal(m, b)
}
func (m *StackTrace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StackTrace.Marshal(b, m, deterministic)
}
func (m *StackTrace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StackTrace.Merge(m, src)
}
func (m *StackTrace) XXX_Size() int {
	return xxx_messageInfo_StackTrace.Size(m)
}
func (m *StackTrace) XXX_DiscardUnknown() {
	xxx_messageInfo_StackTrace.DiscardUnknown(m)
}

var xxx_messageInfo_StackTrace proto.InternalMessageInfo

func (m *StackTrace) GetStackFrames() *StackTrace_StackFrames {
	if m != nil {
		return m.StackFrames
	}
	return nil
}

func (m *StackTrace) GetStackTraceHashId() uint64 {
	if m != nil {
		return m.StackTraceHashId
	}
	return 0
}

// A single stack frame in a stack trace.
type StackTrace_StackFrame struct {
	// The fully-qualified name that uniquely identifies the function or
	// method that is active in this frame.
	FunctionName *TruncatableString `protobuf:"bytes,1,opt,name=function_name,json=functionName,proto3" json:"function_name,omitempty"`
	// An un-mangled function name, if `function_name` is
	// [mangled](http://www.avabodh.com/cxxin/namemangling.html). The name can
	// be fully qualified.
	OriginalFunctionName *TruncatableString `protobuf:"bytes,2,opt,name=original_function_name,json=originalFunctionName,proto3" json:"original_function_name,omitempty"`
	// The name of the source file where the function call appears.
	FileName *TruncatableString `protobuf:"bytes,3,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// The line number in `file_name` where the function call appears.
	LineNumber int64 `protobuf:"varint,4,opt,name=line_number,json=lineNumber,proto3" json:"line_number,omitempty"`
	// The column number where the function call appears, if available.
	// This is important in JavaScript because of its anonymous functions.
	ColumnNumber int64 `protobuf:"varint,5,opt,name=column_number,json=columnNumber,proto3" json:"column_number,omitempty"`
	// The binary module from where the code was loaded.
	LoadModule *Module `protobuf:"bytes,6,opt,name=load_module,json=loadModule,proto3" json:"load_module,omitempty"`
	// The version of the deployed source code.
	SourceVersion        *TruncatableString `protobuf:"bytes,7,opt,name=source_version,json=sourceVersion,proto3" json:"source_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StackTrace_StackFrame) Reset()         { *m = StackTrace_StackFrame{} }
func (m *StackTrace_StackFrame) String() string { return proto.CompactTextString(m) }
func (*StackTrace_StackFrame) ProtoMessage()    {}
func (*StackTrace_StackFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{3, 0}
}

func (m *StackTrace_StackFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StackTrace_StackFrame.Unmarshal(m, b)
}
func (m *StackTrace_StackFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StackTrace_StackFrame.Marshal(b, m, deterministic)
}
func (m *StackTrace_StackFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StackTrace_StackFrame.Merge(m, src)
}
func (m *StackTrace_StackFrame) XXX_Size() int {
	return xxx_messageInfo_StackTrace_StackFrame.Size(m)
}
func (m *StackTrace_StackFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_StackTrace_StackFrame.DiscardUnknown(m)
}

var xxx_messageInfo_StackTrace_StackFrame proto.InternalMessageInfo

func (m *StackTrace_StackFrame) GetFunctionName() *TruncatableString {
	if m != nil {
		return m.FunctionName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetOriginalFunctionName() *TruncatableString {
	if m != nil {
		return m.OriginalFunctionName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetFileName() *TruncatableString {
	if m != nil {
		return m.FileName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetLineNumber() int64 {
	if m != nil {
		return m.LineNumber
	}
	return 0
}

func (m *StackTrace_StackFrame) GetColumnNumber() int64 {
	if m != nil {
		return m.ColumnNumber
	}
	return 0
}

func (m *StackTrace_StackFrame) GetLoadModule() *Module {
	if m != nil {
		return m.LoadModule
	}
	return nil
}

func (m *StackTrace_StackFrame) GetSourceVersion() *TruncatableString {
	if m != nil {
		return m.SourceVersion
	}
	return nil
}

// A collection of stack frames, which can be truncated.
type StackTrace_StackFrames struct {
	// Stack frames in this call stack.
	Frame []*StackTrace_StackFrame `protobuf:"bytes,1,rep,name=frame,proto3" json:"frame,omitempty"`
	// The number of stack frames that were dropped because there
	// were too many stack frames.
	// If this value is 0, then no stack frames were dropped.
	DroppedFramesCount   int32    `protobuf:"varint,2,opt,name=dropped_frames_count,json=droppedFramesCount,proto3" json:"dropped_frames_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StackTrace_StackFrames) Reset()         { *m = StackTrace_StackFrames{} }
func (m *StackTrace_StackFrames) String() string { return proto.CompactTextString(m) }
func (*StackTrace_StackFrames) ProtoMessage()    {}
func (*StackTrace_StackFrames) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{3, 1}
}

func (m *StackTrace_StackFrames) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StackTrace_StackFrames.Unmarshal(m, b)
}
func (m *StackTrace_StackFrames) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StackTrace_StackFrames.Marshal(b, m, deterministic)
}
func (m *StackTrace_StackFrames) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StackTrace_StackFrames.Merge(m, src)
}
func (m *StackTrace_StackFrames) XXX_Size() int {
	return xxx_messageInfo_StackTrace_StackFrames.Size(m)
}
func (m *StackTrace_StackFrames) XXX_DiscardUnknown() {
	xxx_messageInfo_StackTrace_StackFrames.DiscardUnknown(m)
}

var xxx_messageInfo_StackTrace_StackFrames proto.InternalMessageInfo

func (m *StackTrace_StackFrames) GetFrame() []*StackTrace_StackFrame {
	if m != nil {
		return m.Frame
	}
	return nil
}

func (m *StackTrace_StackFrames) GetDroppedFramesCount() int32 {
	if m != nil {
		return m.DroppedFramesCount
	}
	return 0
}

// A description of a binary module.
type Module struct {
	// TODO: document the meaning of this field.
	// For example: main binary, kernel modules, and dynamic libraries
	// such as libc.so, sharedlib.so.
	Module *TruncatableString `protobuf:"bytes,1,opt,name=module,proto3" json:"module,omitempty"`
	// A unique identifier for the module, usually a hash of its
	// contents.
	BuildId              *TruncatableString `protobuf:"bytes,2,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Module) Reset()         { *m = Module{} }
func (m *Module) String() string { return proto.CompactTextString(m) }
func (*Module) ProtoMessage()    {}
func (*Module) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{4}
}

func (m *Module) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Module.Unmarshal(m, b)
}
func (m *Module) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Module.Marshal(b, m, deterministic)
}
func (m *Module) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Module.Merge(m, src)
}
func (m *Module) XXX_Size() int {
	return xxx_messageInfo_Module.Size(m)
}
func (m *Module) XXX_DiscardUnknown() {
	xxx_messageInfo_Module.DiscardUnknown(m)
}

var xxx_messageInfo_Module proto.InternalMessageInfo

func (m *Module) GetModule() *TruncatableString {
	if m != nil {
		return m.Module
	}
	return nil
}

func (m *Module) GetBuildId() *TruncatableString {
	if m != nil {
		return m.BuildId
	}
	return nil
}

// A string that might be shortened to a specified length.
type TruncatableString struct {
	// The shortened string. For example, if the original string was 500 bytes long and
	// the limit of the string was 128 bytes, then this value contains the first 128
	// bytes of the 500-byte string. Note that truncation always happens on a
	// character boundary, to ensure that a truncated string is still valid UTF-8.
	// Because it may contain multi-byte characters, the size of the truncated string
	// may be less than the truncation limit.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of bytes removed from the original string. If this
	// value is 0, then the string was not shortened.
	TruncatedByteCount   int32    `protobuf:"varint,2,opt,name=truncated_byte_count,json=truncatedByteCount,proto3" json:"truncated_byte_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TruncatableString) Reset()         { *m = TruncatableString{} }
func (m *TruncatableString) String() string { return proto.CompactTextString(m) }
func (*TruncatableString) ProtoMessage()    {}
func (*TruncatableString) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ea38bbb821bf584, []int{5}
}

func (m *TruncatableString) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TruncatableString.Unmarshal(m, b)
}
func (m *TruncatableString) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TruncatableString.Marshal(b, m, deterministic)
}
func (m *TruncatableString) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TruncatableString.Merge(m, src)
}
func (m *TruncatableString) XXX_Size() int {
	return xxx_messageInfo_TruncatableString.Size(m)
}
func (m *TruncatableString) XXX_DiscardUnknown() {
	xxx_messageInfo_TruncatableString.DiscardUnknown(m)
}

var xxx_messageInfo_TruncatableString proto.InternalMessageInfo

func (m *TruncatableString) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *TruncatableString) GetTruncatedByteCount() int32 {
	if m != nil {
		return m.TruncatedByteCount
	}
	return 0
}

func init() {
	proto.RegisterEnum("opencensus.proto.trace.v1.Span_SpanKind", Span_SpanKind_name, Span_SpanKind_value)
	proto.RegisterEnum("opencensus.proto.trace.v1.Span_TimeEvent_MessageEvent_Type", Span_TimeEvent_MessageEvent_Type_name, Span_TimeEvent_MessageEvent_Type_value)
	proto.RegisterEnum("opencensus.proto.trace.v1.Span_Link_Type", Span_Link_Type_name, Span_Link_Type_value)
	proto.RegisterType((*Span)(nil), "opencensus.proto.trace.v1.Span")
	proto.RegisterType((*Span_Tracestate)(nil), "opencensus.proto.trace.v1.Span.Tracestate")
	proto.RegisterType((*Span_Tracestate_Entry)(nil), "opencensus.proto.trace.v1.Span.Tracestate.Entry")
	proto.RegisterType((*Span_Attributes)(nil), "opencensus.proto.trace.v1.Span.Attributes")
	proto.RegisterMapType((map[string]*AttributeValue)(nil), "opencensus.proto.trace.v1.Span.Attributes.AttributeMapEntry")
	proto.RegisterType((*Span_TimeEvent)(nil), "opencensus.proto.trace.v1.Span.TimeEvent")
	proto.RegisterType((*Span_TimeEvent_Annotation)(nil), "opencensus.proto.trace.v1.Span.TimeEvent.Annotation")
	proto.RegisterType((*Span_TimeEvent_MessageEvent)(nil), "opencensus.proto.trace.v1.Span.TimeEvent.MessageEvent")
	proto.RegisterType((*Span_TimeEvents)(nil), "opencensus.proto.trace.v1.Span.TimeEvents")
	proto.RegisterType((*Span_Link)(nil), "opencensus.proto.trace.v1.Span.Link")
	proto.RegisterType((*Span_Links)(nil), "opencensus.proto.trace.v1.Span.Links")
	proto.RegisterType((*Status)(nil), "opencensus.proto.trace.v1.Status")
	proto.RegisterType((*AttributeValue)(nil), "opencensus.proto.trace.v1.AttributeValue")
	proto.RegisterType((*StackTrace)(nil), "opencensus.proto.trace.v1.StackTrace")
	proto.RegisterType((*StackTrace_StackFrame)(nil), "opencensus.proto.trace.v1.StackTrace.StackFrame")
	proto.RegisterType((*StackTrace_StackFrames)(nil), "opencensus.proto.trace.v1.StackTrace.StackFrames")
	proto.RegisterType((*Module)(nil), "opencensus.proto.trace.v1.Module")
	proto.RegisterType((*TruncatableString)(nil), "opencensus.proto.trace.v1.TruncatableString")
}

func init() {
	proto.RegisterFile("opencensus/proto/trace/v1/trace.proto", fileDescriptor_8ea38bbb821bf584)
}

var fileDescriptor_8ea38bbb821bf584 = []byte{
	// 1524 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0x5b, 0x6f, 0x1b, 0xb7,
	0x12, 0xf6, 0xea, 0xae, 0x91, 0xac, 0xc8, 0x8c, 0x93, 0xc8, 0x3a, 0x39, 0x27, 0x3e, 0x4a, 0x82,
	0xe3, 0x9c, 0xd6, 0x72, 0xe2, 0xa4, 0x41, 0xae, 0x48, 0x7d, 0x91, 0x2b, 0xc5, 0x8e, 0xaa, 0x50,
	0x8a, 0xd1, 0x0b, 0x8a, 0xc5, 0x4a, 0x4b, 0xcb, 0x5b, 0x4b, 0xdc, 0xed, 0x92, 0xeb, 0xc2, 0x79,
	0xeb, 0x53, 0x51, 0xf4, 0xad, 0x40, 0xd1, 0x3f, 0xd0, 0x87, 0xfe, 0x9d, 0xa2, 0xbf, 0xa3, 0xbf,
	0xa0, 0x2f, 0x05, 0xc9, 0xbd, 0xc9, 0x49, 0x6c, 0x55, 0x79, 0x31, 0xb8, 0xe4, 0x7c, 0x1f, 0x39,
	0x9c, 0x6f, 0x86, 0x63, 0xc1, 0x4d, 0xdb, 0x21, 0x74, 0x40, 0x28, 0xf3, 0xd8, 0x9a, 0xe3, 0xda,
	0xdc, 0x5e, 0xe3, 0xae, 0x31, 0x20, 0x6b, 0xc7, 0x77, 0xd4, 0xa0, 0x2e, 0x27, 0xd1, 0x52, 0x64,
	0xa6, 0x66, 0xea, 0x6a, 0xf5, 0xf8, 0x4e, 0xf5, 0xda, 0xd0, 0xb6, 0x87, 0x23, 0xa2, 0xd0, 0x7d,
	0xef, 0x60, 0x8d, 0x5b, 0x63, 0xc2, 0xb8, 0x31, 0x76, 0x94, 0x65, 0xf5, 0x3f, 0xa7, 0x0d, 0xbe,
	0x75, 0x0d, 0xc7, 0x21, 0xae, 0xcf, 0x54, 0xfb, 0xee, 0x12, 0xa4, 0xba, 0x8e, 0x41, 0xd1, 0x12,
	0xe4, 0x24, 0xab, 0x6e, 0x99, 0x15, 0x6d, 0x59, 0x5b, 0x29, 0xe2, 0xac, 0xfc, 0x6e, 0x99, 0xe8,
	0x0a, 0x64, 0x99, 0x63, 0x50, 0xb1, 0x92, 0x90, 0x2b, 0x19, 0xf1, 0xd9, 0x32, 0xd1, 0x73, 0x00,
	0x69, 0xc3, 0xb8, 0xc1, 0x49, 0xe5, 0xc2, 0xb2, 0xb6, 0x52, 0x58, 0xff, 0x7f, 0xfd, 0x9d, 0xa7,
	0xad, 0x8b, 0x8d, 0xea, 0xbd, 0x10, 0x81, 0x63, 0x68, 0x74, 0x03, 0x4a, 0x8e, 0xe1, 0x12, 0xca,
	0xf5, 0x60, 0xaf, 0xa4, 0xdc, 0xab, 0xa8, 0x66, 0xbb, 0x6a, 0xc7, 0x8f, 0x21, 0x45, 0x8d, 0x31,
	0xa9, 0xa4, 0xe4, 0x5e, 0x1f, 0x9e, 0xb1, 0x57, 0xcf, 0xf5, 0xe8, 0xc0, 0xe0, 0x46, 0x7f, 0x44,
	0xba, 0xdc, 0xb5, 0xe8, 0x10, 0x4b, 0x24, 0x7a, 0x02, 0xa9, 0x23, 0x8b, 0x9a, 0x95, 0xd2, 0xb2,
	0xb6, 0x52, 0x5a, 0x5f, 0x39, 0xef, 0xb4, 0xe2, 0xcf, 0xae, 0x45, 0x4d, 0x2c, 0x51, 0xe8, 0x21,
	0x00, 0xe3, 0x86, 0xcb, 0x75, 0x71, 0xcf, 0x95, 0xb4, 0x3c, 0x45, 0xb5, 0xae, 0xee, 0xb8, 0x1e,
	0xdc, 0x71, 0xbd, 0x17, 0x04, 0x01, 0xe7, 0xa5, 0xb5, 0xf8, 0x46, 0x1f, 0x41, 0x8e, 0x50, 0x53,
	0x01, 0x33, 0xe7, 0x02, 0xb3, 0x84, 0x9a, 0x12, 0xf6, 0x1c, 0xc0, 0xe0, 0xdc, 0xb5, 0xfa, 0x1e,
	0x27, 0xac, 0x92, 0x9d, 0xee, 0x8e, 0x37, 0x42, 0x04, 0x8e, 0xa1, 0xd1, 0x0e, 0x14, 0x18, 0x37,
	0x06, 0x47, 0xba, 0xb4, 0xae, 0xe4, 0x24, 0xd9, 0xcd, 0xb3, 0xc8, 0x84, 0xb5, 0x0c, 0x18, 0x06,
	0x16, 0x8e, 0xd1, 0x2e, 0x14, 0x84, 0x1b, 0x3a, 0x39, 0x26, 0x94, 0xb3, 0x4a, 0x7e, 0xca, 0xc0,
	0x5b, 0x63, 0xd2, 0x90, 0x08, 0x0c, 0x3c, 0x1c, 0xa3, 0xc7, 0x90, 0x1e, 0x59, 0xf4, 0x88, 0x55,
	0xe0, 0xfc, 0xe3, 0x08, 0x9a, 0x3d, 0x61, 0x8c, 0x15, 0x06, 0x3d, 0x84, 0x8c, 0x90, 0x8f, 0xc7,
	0x2a, 0x05, 0x89, 0xfe, 0xef, 0xd9, 0xce, 0x70, 0x8f, 0x61, 0x1f, 0x80, 0x3e, 0x83, 0x7f, 0x31,
	0x63, 0x4c, 0x74, 0xc7, 0xb5, 0x07, 0x84, 0x31, 0xdd, 0x60, 0x7a, 0x4c, 0x80, 0x95, 0xe2, 0x3b,
	0x42, 0xb4, 0x69, 0xdb, 0xa3, 0x7d, 0x63, 0xe4, 0x11, 0x7c, 0x45, 0xc0, 0x3b, 0x0a, 0xbd, 0xc1,
	0x3a, 0xa1, 0x4c, 0xd1, 0x0e, 0x94, 0x07, 0x87, 0xd6, 0xc8, 0x54, 0x4a, 0x1e, 0xd8, 0x1e, 0xe5,
	0x95, 0x79, 0x49, 0x77, 0xf5, 0x0d, 0xba, 0x57, 0x2d, 0xca, 0xef, 0xae, 0x2b, 0xc2, 0x92, 0x44,
	0x09, 0x8a, 0x2d, 0x81, 0xa9, 0xfe, 0xa0, 0x01, 0x44, 0xd9, 0x82, 0x9e, 0x43, 0x96, 0x50, 0xee,
	0x5a, 0x84, 0x55, 0xb4, 0xe5, 0xe4, 0x4a, 0x61, 0xfd, 0xf6, 0xf4, 0xa9, 0x56, 0x6f, 0x50, 0xee,
	0x9e, 0xe0, 0x80, 0xa0, 0xba, 0x06, 0x69, 0x39, 0x83, 0xca, 0x90, 0x3c, 0x22, 0x27, 0x32, 0xe3,
	0xf3, 0x58, 0x0c, 0xd1, 0x22, 0xa4, 0x8f, 0xc5, 0x71, 0x64, 0xae, 0xe7, 0xb1, 0xfa, 0xa8, 0xfe,
	0x9c, 0x00, 0x88, 0x54, 0x85, 0x0c, 0x98, 0x0f, 0x75, 0xa5, 0x8f, 0x0d, 0xc7, 0x3f, 0xd1, 0x93,
	0xe9, 0x85, 0x19, 0x0d, 0x5f, 0x18, 0x8e, 0x3a, 0x5d, 0xd1, 0x88, 0x4d, 0xa1, 0x07, 0x50, 0x31,
	0x5d, 0xdb, 0x71, 0x88, 0xa9, 0x47, 0x12, 0xf6, 0x6f, 0x53, 0x1c, 0x2d, 0x8d, 0x2f, 0xfb, 0xeb,
	0x11, 0xa9, 0xba, 0xb7, 0xaf, 0x61, 0xe1, 0x0d, 0xf2, 0xb7, 0x38, 0xfa, 0x2c, 0xee, 0x68, 0x61,
	0xfd, 0xd6, 0x19, 0x67, 0x0f, 0xe9, 0x54, 0xa0, 0x14, 0xee, 0x51, 0xe2, 0x81, 0x56, 0xfd, 0x35,
	0x0d, 0xf9, 0x50, 0xd8, 0xa8, 0x0e, 0x29, 0x99, 0xdf, 0xda, 0xb9, 0xf9, 0x2d, 0xed, 0xd0, 0x3e,
	0x80, 0x41, 0xa9, 0xcd, 0x0d, 0x6e, 0xd9, 0xd4, 0x3f, 0xc7, 0xbd, 0xa9, 0xf3, 0xa8, 0xbe, 0x11,
	0x62, 0x9b, 0x73, 0x38, 0xc6, 0x84, 0xbe, 0x82, 0xf9, 0x31, 0x61, 0xcc, 0x18, 0xfa, 0x39, 0x2a,
	0x6b, 0x69, 0x61, 0xfd, 0xfe, 0xf4, 0xd4, 0x2f, 0x14, 0x5c, 0x7e, 0x34, 0xe7, 0x70, 0x71, 0x1c,
	0xfb, 0xae, 0xfe, 0xa6, 0x01, 0x44, 0x7b, 0xa3, 0x36, 0x14, 0x4c, 0xc2, 0x06, 0xae, 0xe5, 0x48,
	0x37, 0xb4, 0x19, 0x6a, 0x73, 0x9c, 0xe0, 0x54, 0xc9, 0x4b, 0xbc, 0x4f, 0xc9, 0xab, 0xfe, 0xa5,
	0x41, 0x31, 0xee, 0x0b, 0xfa, 0x14, 0x52, 0xfc, 0xc4, 0x51, 0x21, 0x2a, 0xad, 0x3f, 0x9e, 0xed,
	0x46, 0xea, 0xbd, 0x13, 0x87, 0x60, 0x49, 0x84, 0x4a, 0x90, 0xf0, 0x1f, 0xc6, 0x14, 0x4e, 0x58,
	0x26, 0xfa, 0x00, 0x16, 0x3c, 0x3a, 0xb0, 0xc7, 0x8e, 0x4b, 0x18, 0x23, 0xa6, 0xce, 0xac, 0xd7,
	0x44, 0xde, 0x7f, 0x0a, 0x97, 0xe3, 0x0b, 0x5d, 0xeb, 0x35, 0x41, 0xff, 0x83, 0x0b, 0xa7, 0x4d,
	0x53, 0xd2, 0xb4, 0x34, 0x69, 0x58, 0xbb, 0x07, 0x29, 0xb1, 0x27, 0x5a, 0x84, 0x72, 0xef, 0xf3,
	0x4e, 0x43, 0x7f, 0xd5, 0xee, 0x76, 0x1a, 0x5b, 0xad, 0x9d, 0x56, 0x63, 0xbb, 0x3c, 0x87, 0x72,
	0x90, 0xea, 0x36, 0xda, 0xbd, 0xb2, 0x86, 0x8a, 0x90, 0xc3, 0x8d, 0xad, 0x46, 0x6b, 0xbf, 0xb1,
	0x5d, 0x4e, 0x6c, 0x66, 0x7d, 0x89, 0x57, 0xff, 0x10, 0xa5, 0x24, 0xaa, 0xb9, 0x4d, 0x80, 0xa8,
	0x80, 0xfb, 0xb9, 0x7b, 0x6b, 0xea, 0xab, 0xc0, 0xf9, 0xb0, 0x7c, 0xa3, 0x47, 0xb0, 0x14, 0x66,
	0x69, 0xa8, 0x88, 0xc9, 0x34, 0xbd, 0x12, 0xa4, 0x69, 0xb4, 0x2e, 0xf3, 0x14, 0x3d, 0x83, 0xab,
	0x01, 0x76, 0x42, 0xad, 0x01, 0x3c, 0x29, 0xe1, 0x01, 0x7f, 0xfc, 0xfe, 0xfd, 0x44, 0xff, 0x29,
	0x01, 0x29, 0xf1, 0x1c, 0xcc, 0xd4, 0xbc, 0x3c, 0xf5, 0x85, 0x90, 0x94, 0x42, 0xb8, 0x35, 0xcd,
	0xb3, 0x13, 0x0f, 0xfb, 0xa4, 0x48, 0x53, 0xef, 0x23, 0xd2, 0xda, 0xee, 0x99, 0xc1, 0xbd, 0x04,
	0x0b, 0x5b, 0xcd, 0xd6, 0xde, 0xb6, 0xbe, 0xd7, 0x6a, 0xef, 0x36, 0xb6, 0xf5, 0x6e, 0x67, 0xa3,
	0x5d, 0xd6, 0xd0, 0x65, 0x40, 0x9d, 0x0d, 0xdc, 0x68, 0xf7, 0x26, 0xe6, 0x13, 0xd5, 0x6f, 0x20,
	0x2d, 0x9f, 0x48, 0xf4, 0x00, 0x52, 0xe2, 0x91, 0xf4, 0xc3, 0x7b, 0x63, 0x1a, 0x07, 0xb1, 0x44,
	0xa0, 0x3a, 0x5c, 0x0c, 0x02, 0x23, 0x9f, 0xd9, 0x89, 0x70, 0x2e, 0xf8, 0x4b, 0x72, 0x13, 0x19,
	0x87, 0xda, 0x53, 0xc8, 0x05, 0x7d, 0x12, 0x5a, 0x82, 0x4b, 0xe2, 0x20, 0xfa, 0x6e, 0xab, 0xbd,
	0x7d, 0xca, 0x11, 0x80, 0x4c, 0xb7, 0x81, 0xf7, 0x1b, 0xb8, 0xac, 0x89, 0xf1, 0xd6, 0x5e, 0x4b,
	0x68, 0x36, 0x51, 0xbb, 0x0f, 0x19, 0xf5, 0x36, 0x23, 0x04, 0xa9, 0x81, 0x6d, 0xaa, 0xe4, 0x4c,
	0x63, 0x39, 0x46, 0x15, 0xc8, 0xfa, 0xea, 0xf0, 0x5f, 0xa4, 0xe0, 0xb3, 0xf6, 0xbb, 0x06, 0xa5,
	0xc9, 0xca, 0x8c, 0x5e, 0x42, 0x91, 0xc9, 0x8a, 0xa2, 0xab, 0xd2, 0x3e, 0x43, 0x2d, 0x6a, 0xce,
	0xe1, 0x82, 0xe2, 0x50, 0x94, 0xff, 0x86, 0xbc, 0x45, 0xb9, 0x1e, 0x3d, 0x15, 0xc9, 0xe6, 0x1c,
	0xce, 0x59, 0x94, 0xab, 0xe5, 0x6b, 0x00, 0x7d, 0xdb, 0x1e, 0xf9, 0xeb, 0x42, 0x4c, 0xb9, 0xe6,
	0x1c, 0xce, 0xf7, 0x83, 0x36, 0x01, 0x5d, 0x87, 0xa2, 0x69, 0x7b, 0xfd, 0x11, 0xf1, 0x4d, 0x84,
	0x54, 0x34, 0xb1, 0x89, 0x9a, 0x95, 0x46, 0x61, 0xa2, 0xd6, 0x7e, 0xcc, 0x00, 0x44, 0x5d, 0x17,
	0xea, 0x09, 0x7f, 0x44, 0xc7, 0x76, 0xe0, 0x1a, 0x63, 0xf9, 0xf0, 0x0b, 0x7f, 0xee, 0x4c, 0xd5,
	0xb2, 0xa9, 0xe1, 0x8e, 0x04, 0x62, 0xd5, 0xf8, 0xa9, 0x0f, 0xb4, 0x0a, 0x17, 0x63, 0x7d, 0xa0,
	0x7e, 0x68, 0xb0, 0x43, 0x3d, 0xac, 0x61, 0xe5, 0xa8, 0xd1, 0x6b, 0x1a, 0xec, 0xb0, 0x65, 0x56,
	0xff, 0x4c, 0xfa, 0x67, 0x92, 0x70, 0xf4, 0x12, 0xe6, 0x0f, 0x3c, 0x3a, 0x10, 0x89, 0xac, 0xcb,
	0x66, 0x7c, 0x96, 0x82, 0x5f, 0x0c, 0x28, 0xda, 0x82, 0xb2, 0x0f, 0x97, 0x6d, 0xd7, 0x1a, 0x5a,
	0xd4, 0x18, 0xe9, 0x93, 0xdc, 0x89, 0x19, 0xb8, 0x17, 0x03, 0xae, 0x9d, 0xf8, 0x1e, 0x2d, 0xc8,
	0x1f, 0x58, 0x23, 0xa2, 0x68, 0x93, 0x33, 0xd0, 0xe6, 0x04, 0x5c, 0x52, 0x5d, 0x83, 0xc2, 0xc8,
	0xa2, 0x44, 0xa7, 0xde, 0xb8, 0x4f, 0x5c, 0x19, 0xd1, 0x24, 0x06, 0x31, 0xd5, 0x96, 0x33, 0xe8,
	0x3a, 0xcc, 0x0f, 0xec, 0x91, 0x37, 0xa6, 0x81, 0x49, 0x5a, 0x9a, 0x14, 0xd5, 0xa4, 0x6f, 0xb4,
	0x09, 0x85, 0x91, 0x6d, 0x98, 0xfa, 0xd8, 0x36, 0xbd, 0x51, 0xf0, 0x3f, 0xc1, 0x59, 0x0d, 0xec,
	0x0b, 0x69, 0x88, 0x41, 0xa0, 0xd4, 0x18, 0x75, 0xa1, 0xc4, 0x6c, 0xcf, 0x1d, 0x10, 0xfd, 0x98,
	0xb8, 0x4c, 0xbc, 0xbe, 0xd9, 0x19, 0x3c, 0x9b, 0x57, 0x1c, 0xfb, 0x8a, 0xa2, 0xfa, 0xbd, 0x06,
	0x85, 0x98, 0x76, 0xd0, 0x0e, 0xa4, 0xa5, 0xfc, 0xa6, 0x69, 0x3b, 0xdf, 0xa6, 0x3e, 0xac, 0xe0,
	0xe8, 0x36, 0x2c, 0x06, 0x65, 0x45, 0xc9, 0x79, 0xa2, 0xae, 0x20, 0x7f, 0x4d, 0x6d, 0xaa, 0x0a,
	0xcb, 0x2f, 0x1a, 0x64, 0x7c, 0x4f, 0xb7, 0x21, 0xe3, 0x5f, 0xd4, 0x2c, 0x72, 0xf3, 0xb1, 0xe8,
	0x13, 0xc8, 0xf5, 0x3d, 0xd1, 0x9a, 0xfb, 0x72, 0xff, 0xa7, 0x3c, 0x59, 0x89, 0x6e, 0x99, 0xb5,
	0x2f, 0x61, 0xe1, 0x8d, 0xd5, 0xa8, 0x75, 0xd6, 0x62, 0xad, 0xb3, 0x70, 0x9b, 0x2b, 0x53, 0x62,
	0xea, 0xfd, 0x13, 0x4e, 0x26, 0xdd, 0x0e, 0xd7, 0x36, 0x4f, 0x38, 0x91, 0x6e, 0x6f, 0x3a, 0x70,
	0xd5, 0xb2, 0xdf, 0x7d, 0xae, 0x4d, 0xf5, 0x5f, 0x41, 0x47, 0x4c, 0x76, 0xb4, 0x2f, 0x36, 0x87,
	0x16, 0x3f, 0xf4, 0xfa, 0xf5, 0x81, 0x3d, 0x5e, 0x53, 0xf6, 0xab, 0x16, 0x65, 0xdc, 0xf5, 0xc6,
	0x84, 0xaa, 0xf7, 0x76, 0x2d, 0xa2, 0x5a, 0x55, 0xbf, 0x33, 0x0c, 0x09, 0x5d, 0x1d, 0x46, 0x3f,
	0x37, 0xf4, 0x33, 0x72, 0xfa, 0xee, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xb1, 0x5e, 0xa6, 0x6a,
	0x92, 0x10, 0x00, 0x00,
}
