/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package metrics

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/apimachinery/pkg/api/resource"
	pkg1_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	pkg2_types "k8s.io/apimachinery/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg1_v1.TypeMeta
		var v2 pkg2_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *NodeMetrics) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [21]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = x.Name != ""
			yyq2[3] = x.GenerateName != ""
			yyq2[4] = x.Namespace != ""
			yyq2[5] = x.SelfLink != ""
			yyq2[6] = x.UID != ""
			yyq2[7] = x.ResourceVersion != ""
			yyq2[8] = x.Generation != 0
			yyq2[9] = true
			yyq2[10] = x.ObjectMeta.DeletionTimestamp != nil && x.DeletionTimestamp != nil
			yyq2[11] = x.ObjectMeta.DeletionGracePeriodSeconds != nil && x.DeletionGracePeriodSeconds != nil
			yyq2[12] = len(x.Labels) != 0
			yyq2[13] = len(x.Annotations) != 0
			yyq2[14] = len(x.OwnerReferences) != 0
			yyq2[15] = x.ObjectMeta.Initializers != nil && x.Initializers != nil
			yyq2[16] = len(x.Finalizers) != 0
			yyq2[17] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(21)
			} else {
				yynn2 = 3
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yy31 := &x.CreationTimestamp
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else if z.HasExtensions() && z.EncExt(yy31) {
					} else if yym32 {
						z.EncBinaryMarshal(yy31)
					} else if !yym32 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy31)
					} else {
						z.EncFallback(yy31)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy33 := &x.CreationTimestamp
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else if z.HasExtensions() && z.EncExt(yy33) {
					} else if yym34 {
						z.EncBinaryMarshal(yy33)
					} else if !yym34 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy33)
					} else {
						z.EncFallback(yy33)
					}
				}
			}
			var yyn35 bool
			if x.ObjectMeta.DeletionTimestamp == nil {
				yyn35 = true
				goto LABEL35
			}
		LABEL35:
			if yyr2 || yy2arr2 {
				if yyn35 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[10] {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym36 := z.EncBinary()
							_ = yym36
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym36 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym36 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn35 {
						r.EncodeNil()
					} else {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym37 := z.EncBinary()
							_ = yym37
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym37 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym37 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					}
				}
			}
			var yyn38 bool
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				yyn38 = true
				goto LABEL38
			}
		LABEL38:
			if yyr2 || yy2arr2 {
				if yyn38 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[11] {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy39 := *x.DeletionGracePeriodSeconds
							yym40 := z.EncBinary()
							_ = yym40
							if false {
							} else {
								r.EncodeInt(int64(yy39))
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn38 {
						r.EncodeNil()
					} else {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy41 := *x.DeletionGracePeriodSeconds
							yym42 := z.EncBinary()
							_ = yym42
							if false {
							} else {
								r.EncodeInt(int64(yy41))
							}
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym50 := z.EncBinary()
						_ = yym50
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym51 := z.EncBinary()
						_ = yym51
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			var yyn52 bool
			if x.ObjectMeta.Initializers == nil {
				yyn52 = true
				goto LABEL52
			}
		LABEL52:
			if yyr2 || yy2arr2 {
				if yyn52 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[15] {
						if x.Initializers == nil {
							r.EncodeNil()
						} else {
							yym53 := z.EncBinary()
							_ = yym53
							if false {
							} else if z.HasExtensions() && z.EncExt(x.Initializers) {
							} else {
								z.EncFallback(x.Initializers)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initializers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn52 {
						r.EncodeNil()
					} else {
						if x.Initializers == nil {
							r.EncodeNil()
						} else {
							yym54 := z.EncBinary()
							_ = yym54
							if false {
							} else if z.HasExtensions() && z.EncExt(x.Initializers) {
							} else {
								z.EncFallback(x.Initializers)
							}
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym56 := z.EncBinary()
						_ = yym56
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym57 := z.EncBinary()
						_ = yym57
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[17] {
					yym59 := z.EncBinary()
					_ = yym59
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym60 := z.EncBinary()
					_ = yym60
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy62 := &x.Timestamp
				yym63 := z.EncBinary()
				_ = yym63
				if false {
				} else if z.HasExtensions() && z.EncExt(yy62) {
				} else if yym63 {
					z.EncBinaryMarshal(yy62)
				} else if !yym63 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy62)
				} else {
					z.EncFallback(yy62)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Timestamp"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy64 := &x.Timestamp
				yym65 := z.EncBinary()
				_ = yym65
				if false {
				} else if z.HasExtensions() && z.EncExt(yy64) {
				} else if yym65 {
					z.EncBinaryMarshal(yy64)
				} else if !yym65 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy64)
				} else {
					z.EncFallback(yy64)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy67 := &x.Window
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else if z.HasExtensions() && z.EncExt(yy67) {
				} else if !yym68 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy67)
				} else {
					z.EncFallback(yy67)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Window"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy69 := &x.Window
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else if z.HasExtensions() && z.EncExt(yy69) {
				} else if !yym70 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy69)
				} else {
					z.EncFallback(yy69)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Usage == nil {
					r.EncodeNil()
				} else {
					x.Usage.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Usage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Usage == nil {
					r.EncodeNil()
				} else {
					x.Usage.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeMetrics) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeMetrics) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv8 := &x.Name
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				yyv10 := &x.GenerateName
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				yyv12 := &x.Namespace
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				yyv14 := &x.SelfLink
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					*((*string)(yyv14)) = r.DecodeString()
				}
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				yyv16 := &x.UID
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv16) {
				} else {
					*((*string)(yyv16)) = r.DecodeString()
				}
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				yyv18 := &x.ResourceVersion
				yym19 := z.DecBinary()
				_ = yym19
				if false {
				} else {
					*((*string)(yyv18)) = r.DecodeString()
				}
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				yyv20 := &x.Generation
				yym21 := z.DecBinary()
				_ = yym21
				if false {
				} else {
					*((*int64)(yyv20)) = int64(r.DecodeInt(64))
				}
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg1_v1.Time{}
			} else {
				yyv22 := &x.CreationTimestamp
				yym23 := z.DecBinary()
				_ = yym23
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv22) {
				} else if yym23 {
					z.DecBinaryUnmarshal(yyv22)
				} else if !yym23 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv22)
				} else {
					z.DecFallback(yyv22, false)
				}
			}
		case "deletionTimestamp":
			if x.ObjectMeta.DeletionTimestamp == nil {
				x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg1_v1.Time)
				}
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym25 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym25 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv28 := &x.Labels
				yym29 := z.DecBinary()
				_ = yym29
				if false {
				} else {
					z.F.DecMapStringStringX(yyv28, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv30 := &x.Annotations
				yym31 := z.DecBinary()
				_ = yym31
				if false {
				} else {
					z.F.DecMapStringStringX(yyv30, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv32 := &x.OwnerReferences
				yym33 := z.DecBinary()
				_ = yym33
				if false {
				} else {
					h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv32), d)
				}
			}
		case "initializers":
			if x.ObjectMeta.Initializers == nil {
				x.ObjectMeta.Initializers = new(pkg1_v1.Initializers)
			}
			if r.TryDecodeAsNil() {
				if x.Initializers != nil {
					x.Initializers = nil
				}
			} else {
				if x.Initializers == nil {
					x.Initializers = new(pkg1_v1.Initializers)
				}
				yym35 := z.DecBinary()
				_ = yym35
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Initializers) {
				} else {
					z.DecFallback(x.Initializers, false)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv36 := &x.Finalizers
				yym37 := z.DecBinary()
				_ = yym37
				if false {
				} else {
					z.F.DecSliceStringX(yyv36, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				yyv38 := &x.ClusterName
				yym39 := z.DecBinary()
				_ = yym39
				if false {
				} else {
					*((*string)(yyv38)) = r.DecodeString()
				}
			}
		case "Timestamp":
			if r.TryDecodeAsNil() {
				x.Timestamp = pkg1_v1.Time{}
			} else {
				yyv40 := &x.Timestamp
				yym41 := z.DecBinary()
				_ = yym41
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv40) {
				} else if yym41 {
					z.DecBinaryUnmarshal(yyv40)
				} else if !yym41 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv40)
				} else {
					z.DecFallback(yyv40, false)
				}
			}
		case "Window":
			if r.TryDecodeAsNil() {
				x.Window = pkg1_v1.Duration{}
			} else {
				yyv42 := &x.Window
				yym43 := z.DecBinary()
				_ = yym43
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv42) {
				} else if !yym43 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv42)
				} else {
					z.DecFallback(yyv42, false)
				}
			}
		case "Usage":
			if r.TryDecodeAsNil() {
				x.Usage = nil
			} else {
				yyv44 := &x.Usage
				yyv44.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeMetrics) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj45 int
	var yyb45 bool
	var yyhl45 bool = l >= 0
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv46 := &x.Kind
		yym47 := z.DecBinary()
		_ = yym47
		if false {
		} else {
			*((*string)(yyv46)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv48 := &x.APIVersion
		yym49 := z.DecBinary()
		_ = yym49
		if false {
		} else {
			*((*string)(yyv48)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv50 := &x.Name
		yym51 := z.DecBinary()
		_ = yym51
		if false {
		} else {
			*((*string)(yyv50)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		yyv52 := &x.GenerateName
		yym53 := z.DecBinary()
		_ = yym53
		if false {
		} else {
			*((*string)(yyv52)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		yyv54 := &x.Namespace
		yym55 := z.DecBinary()
		_ = yym55
		if false {
		} else {
			*((*string)(yyv54)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		yyv56 := &x.SelfLink
		yym57 := z.DecBinary()
		_ = yym57
		if false {
		} else {
			*((*string)(yyv56)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		yyv58 := &x.UID
		yym59 := z.DecBinary()
		_ = yym59
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv58) {
		} else {
			*((*string)(yyv58)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		yyv60 := &x.ResourceVersion
		yym61 := z.DecBinary()
		_ = yym61
		if false {
		} else {
			*((*string)(yyv60)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		yyv62 := &x.Generation
		yym63 := z.DecBinary()
		_ = yym63
		if false {
		} else {
			*((*int64)(yyv62)) = int64(r.DecodeInt(64))
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg1_v1.Time{}
	} else {
		yyv64 := &x.CreationTimestamp
		yym65 := z.DecBinary()
		_ = yym65
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv64) {
		} else if yym65 {
			z.DecBinaryUnmarshal(yyv64)
		} else if !yym65 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv64)
		} else {
			z.DecFallback(yyv64, false)
		}
	}
	if x.ObjectMeta.DeletionTimestamp == nil {
		x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg1_v1.Time)
		}
		yym67 := z.DecBinary()
		_ = yym67
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym67 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym67 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
		x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym69 := z.DecBinary()
		_ = yym69
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv70 := &x.Labels
		yym71 := z.DecBinary()
		_ = yym71
		if false {
		} else {
			z.F.DecMapStringStringX(yyv70, false, d)
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv72 := &x.Annotations
		yym73 := z.DecBinary()
		_ = yym73
		if false {
		} else {
			z.F.DecMapStringStringX(yyv72, false, d)
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv74 := &x.OwnerReferences
		yym75 := z.DecBinary()
		_ = yym75
		if false {
		} else {
			h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv74), d)
		}
	}
	if x.ObjectMeta.Initializers == nil {
		x.ObjectMeta.Initializers = new(pkg1_v1.Initializers)
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Initializers != nil {
			x.Initializers = nil
		}
	} else {
		if x.Initializers == nil {
			x.Initializers = new(pkg1_v1.Initializers)
		}
		yym77 := z.DecBinary()
		_ = yym77
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Initializers) {
		} else {
			z.DecFallback(x.Initializers, false)
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv78 := &x.Finalizers
		yym79 := z.DecBinary()
		_ = yym79
		if false {
		} else {
			z.F.DecSliceStringX(yyv78, false, d)
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		yyv80 := &x.ClusterName
		yym81 := z.DecBinary()
		_ = yym81
		if false {
		} else {
			*((*string)(yyv80)) = r.DecodeString()
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Timestamp = pkg1_v1.Time{}
	} else {
		yyv82 := &x.Timestamp
		yym83 := z.DecBinary()
		_ = yym83
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv82) {
		} else if yym83 {
			z.DecBinaryUnmarshal(yyv82)
		} else if !yym83 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv82)
		} else {
			z.DecFallback(yyv82, false)
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Window = pkg1_v1.Duration{}
	} else {
		yyv84 := &x.Window
		yym85 := z.DecBinary()
		_ = yym85
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv84) {
		} else if !yym85 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv84)
		} else {
			z.DecFallback(yyv84, false)
		}
	}
	yyj45++
	if yyhl45 {
		yyb45 = yyj45 > l
	} else {
		yyb45 = r.CheckBreak()
	}
	if yyb45 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Usage = nil
	} else {
		yyv86 := &x.Usage
		yyv86.CodecDecodeSelf(d)
	}
	for {
		yyj45++
		if yyhl45 {
			yyb45 = yyj45 > l
		} else {
			yyb45 = r.CheckBreak()
		}
		if yyb45 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj45-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeMetricsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = x.SelfLink != ""
			yyq2[3] = x.ResourceVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSliceNodeMetrics(([]NodeMetrics)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						h.encSliceNodeMetrics(([]NodeMetrics)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeMetricsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeMetricsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				yyv8 := &x.SelfLink
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				yyv10 := &x.ResourceVersion
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "Items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv12 := &x.Items
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					h.decSliceNodeMetrics((*[]NodeMetrics)(yyv12), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeMetricsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj14 int
	var yyb14 bool
	var yyhl14 bool = l >= 0
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv15 := &x.Kind
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv17 := &x.APIVersion
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*string)(yyv17)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		yyv19 := &x.SelfLink
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(yyv19)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		yyv21 := &x.ResourceVersion
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*string)(yyv21)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv23 := &x.Items
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			h.decSliceNodeMetrics((*[]NodeMetrics)(yyv23), d)
		}
	}
	for {
		yyj14++
		if yyhl14 {
			yyb14 = yyj14 > l
		} else {
			yyb14 = r.CheckBreak()
		}
		if yyb14 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj14-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodMetrics) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [21]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = x.Name != ""
			yyq2[3] = x.GenerateName != ""
			yyq2[4] = x.Namespace != ""
			yyq2[5] = x.SelfLink != ""
			yyq2[6] = x.UID != ""
			yyq2[7] = x.ResourceVersion != ""
			yyq2[8] = x.Generation != 0
			yyq2[9] = true
			yyq2[10] = x.ObjectMeta.DeletionTimestamp != nil && x.DeletionTimestamp != nil
			yyq2[11] = x.ObjectMeta.DeletionGracePeriodSeconds != nil && x.DeletionGracePeriodSeconds != nil
			yyq2[12] = len(x.Labels) != 0
			yyq2[13] = len(x.Annotations) != 0
			yyq2[14] = len(x.OwnerReferences) != 0
			yyq2[15] = x.ObjectMeta.Initializers != nil && x.Initializers != nil
			yyq2[16] = len(x.Finalizers) != 0
			yyq2[17] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(21)
			} else {
				yynn2 = 3
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yy31 := &x.CreationTimestamp
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else if z.HasExtensions() && z.EncExt(yy31) {
					} else if yym32 {
						z.EncBinaryMarshal(yy31)
					} else if !yym32 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy31)
					} else {
						z.EncFallback(yy31)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy33 := &x.CreationTimestamp
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else if z.HasExtensions() && z.EncExt(yy33) {
					} else if yym34 {
						z.EncBinaryMarshal(yy33)
					} else if !yym34 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy33)
					} else {
						z.EncFallback(yy33)
					}
				}
			}
			var yyn35 bool
			if x.ObjectMeta.DeletionTimestamp == nil {
				yyn35 = true
				goto LABEL35
			}
		LABEL35:
			if yyr2 || yy2arr2 {
				if yyn35 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[10] {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym36 := z.EncBinary()
							_ = yym36
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym36 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym36 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn35 {
						r.EncodeNil()
					} else {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym37 := z.EncBinary()
							_ = yym37
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym37 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym37 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					}
				}
			}
			var yyn38 bool
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				yyn38 = true
				goto LABEL38
			}
		LABEL38:
			if yyr2 || yy2arr2 {
				if yyn38 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[11] {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy39 := *x.DeletionGracePeriodSeconds
							yym40 := z.EncBinary()
							_ = yym40
							if false {
							} else {
								r.EncodeInt(int64(yy39))
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn38 {
						r.EncodeNil()
					} else {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy41 := *x.DeletionGracePeriodSeconds
							yym42 := z.EncBinary()
							_ = yym42
							if false {
							} else {
								r.EncodeInt(int64(yy41))
							}
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym50 := z.EncBinary()
						_ = yym50
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym51 := z.EncBinary()
						_ = yym51
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			var yyn52 bool
			if x.ObjectMeta.Initializers == nil {
				yyn52 = true
				goto LABEL52
			}
		LABEL52:
			if yyr2 || yy2arr2 {
				if yyn52 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[15] {
						if x.Initializers == nil {
							r.EncodeNil()
						} else {
							yym53 := z.EncBinary()
							_ = yym53
							if false {
							} else if z.HasExtensions() && z.EncExt(x.Initializers) {
							} else {
								z.EncFallback(x.Initializers)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initializers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn52 {
						r.EncodeNil()
					} else {
						if x.Initializers == nil {
							r.EncodeNil()
						} else {
							yym54 := z.EncBinary()
							_ = yym54
							if false {
							} else if z.HasExtensions() && z.EncExt(x.Initializers) {
							} else {
								z.EncFallback(x.Initializers)
							}
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym56 := z.EncBinary()
						_ = yym56
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym57 := z.EncBinary()
						_ = yym57
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[17] {
					yym59 := z.EncBinary()
					_ = yym59
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym60 := z.EncBinary()
					_ = yym60
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy62 := &x.Timestamp
				yym63 := z.EncBinary()
				_ = yym63
				if false {
				} else if z.HasExtensions() && z.EncExt(yy62) {
				} else if yym63 {
					z.EncBinaryMarshal(yy62)
				} else if !yym63 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy62)
				} else {
					z.EncFallback(yy62)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Timestamp"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy64 := &x.Timestamp
				yym65 := z.EncBinary()
				_ = yym65
				if false {
				} else if z.HasExtensions() && z.EncExt(yy64) {
				} else if yym65 {
					z.EncBinaryMarshal(yy64)
				} else if !yym65 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy64)
				} else {
					z.EncFallback(yy64)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy67 := &x.Window
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else if z.HasExtensions() && z.EncExt(yy67) {
				} else if !yym68 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy67)
				} else {
					z.EncFallback(yy67)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Window"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy69 := &x.Window
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else if z.HasExtensions() && z.EncExt(yy69) {
				} else if !yym70 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy69)
				} else {
					z.EncFallback(yy69)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym72 := z.EncBinary()
					_ = yym72
					if false {
					} else {
						h.encSliceContainerMetrics(([]ContainerMetrics)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym73 := z.EncBinary()
					_ = yym73
					if false {
					} else {
						h.encSliceContainerMetrics(([]ContainerMetrics)(x.Containers), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodMetrics) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodMetrics) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv8 := &x.Name
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				yyv10 := &x.GenerateName
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				yyv12 := &x.Namespace
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				yyv14 := &x.SelfLink
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					*((*string)(yyv14)) = r.DecodeString()
				}
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				yyv16 := &x.UID
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv16) {
				} else {
					*((*string)(yyv16)) = r.DecodeString()
				}
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				yyv18 := &x.ResourceVersion
				yym19 := z.DecBinary()
				_ = yym19
				if false {
				} else {
					*((*string)(yyv18)) = r.DecodeString()
				}
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				yyv20 := &x.Generation
				yym21 := z.DecBinary()
				_ = yym21
				if false {
				} else {
					*((*int64)(yyv20)) = int64(r.DecodeInt(64))
				}
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg1_v1.Time{}
			} else {
				yyv22 := &x.CreationTimestamp
				yym23 := z.DecBinary()
				_ = yym23
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv22) {
				} else if yym23 {
					z.DecBinaryUnmarshal(yyv22)
				} else if !yym23 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv22)
				} else {
					z.DecFallback(yyv22, false)
				}
			}
		case "deletionTimestamp":
			if x.ObjectMeta.DeletionTimestamp == nil {
				x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg1_v1.Time)
				}
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym25 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym25 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv28 := &x.Labels
				yym29 := z.DecBinary()
				_ = yym29
				if false {
				} else {
					z.F.DecMapStringStringX(yyv28, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv30 := &x.Annotations
				yym31 := z.DecBinary()
				_ = yym31
				if false {
				} else {
					z.F.DecMapStringStringX(yyv30, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv32 := &x.OwnerReferences
				yym33 := z.DecBinary()
				_ = yym33
				if false {
				} else {
					h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv32), d)
				}
			}
		case "initializers":
			if x.ObjectMeta.Initializers == nil {
				x.ObjectMeta.Initializers = new(pkg1_v1.Initializers)
			}
			if r.TryDecodeAsNil() {
				if x.Initializers != nil {
					x.Initializers = nil
				}
			} else {
				if x.Initializers == nil {
					x.Initializers = new(pkg1_v1.Initializers)
				}
				yym35 := z.DecBinary()
				_ = yym35
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Initializers) {
				} else {
					z.DecFallback(x.Initializers, false)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv36 := &x.Finalizers
				yym37 := z.DecBinary()
				_ = yym37
				if false {
				} else {
					z.F.DecSliceStringX(yyv36, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				yyv38 := &x.ClusterName
				yym39 := z.DecBinary()
				_ = yym39
				if false {
				} else {
					*((*string)(yyv38)) = r.DecodeString()
				}
			}
		case "Timestamp":
			if r.TryDecodeAsNil() {
				x.Timestamp = pkg1_v1.Time{}
			} else {
				yyv40 := &x.Timestamp
				yym41 := z.DecBinary()
				_ = yym41
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv40) {
				} else if yym41 {
					z.DecBinaryUnmarshal(yyv40)
				} else if !yym41 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv40)
				} else {
					z.DecFallback(yyv40, false)
				}
			}
		case "Window":
			if r.TryDecodeAsNil() {
				x.Window = pkg1_v1.Duration{}
			} else {
				yyv42 := &x.Window
				yym43 := z.DecBinary()
				_ = yym43
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv42) {
				} else if !yym43 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv42)
				} else {
					z.DecFallback(yyv42, false)
				}
			}
		case "Containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv44 := &x.Containers
				yym45 := z.DecBinary()
				_ = yym45
				if false {
				} else {
					h.decSliceContainerMetrics((*[]ContainerMetrics)(yyv44), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodMetrics) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj46 int
	var yyb46 bool
	var yyhl46 bool = l >= 0
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv47 := &x.Kind
		yym48 := z.DecBinary()
		_ = yym48
		if false {
		} else {
			*((*string)(yyv47)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv49 := &x.APIVersion
		yym50 := z.DecBinary()
		_ = yym50
		if false {
		} else {
			*((*string)(yyv49)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv51 := &x.Name
		yym52 := z.DecBinary()
		_ = yym52
		if false {
		} else {
			*((*string)(yyv51)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		yyv53 := &x.GenerateName
		yym54 := z.DecBinary()
		_ = yym54
		if false {
		} else {
			*((*string)(yyv53)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		yyv55 := &x.Namespace
		yym56 := z.DecBinary()
		_ = yym56
		if false {
		} else {
			*((*string)(yyv55)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		yyv57 := &x.SelfLink
		yym58 := z.DecBinary()
		_ = yym58
		if false {
		} else {
			*((*string)(yyv57)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		yyv59 := &x.UID
		yym60 := z.DecBinary()
		_ = yym60
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv59) {
		} else {
			*((*string)(yyv59)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		yyv61 := &x.ResourceVersion
		yym62 := z.DecBinary()
		_ = yym62
		if false {
		} else {
			*((*string)(yyv61)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		yyv63 := &x.Generation
		yym64 := z.DecBinary()
		_ = yym64
		if false {
		} else {
			*((*int64)(yyv63)) = int64(r.DecodeInt(64))
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg1_v1.Time{}
	} else {
		yyv65 := &x.CreationTimestamp
		yym66 := z.DecBinary()
		_ = yym66
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv65) {
		} else if yym66 {
			z.DecBinaryUnmarshal(yyv65)
		} else if !yym66 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv65)
		} else {
			z.DecFallback(yyv65, false)
		}
	}
	if x.ObjectMeta.DeletionTimestamp == nil {
		x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg1_v1.Time)
		}
		yym68 := z.DecBinary()
		_ = yym68
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym68 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym68 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
		x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym70 := z.DecBinary()
		_ = yym70
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv71 := &x.Labels
		yym72 := z.DecBinary()
		_ = yym72
		if false {
		} else {
			z.F.DecMapStringStringX(yyv71, false, d)
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv73 := &x.Annotations
		yym74 := z.DecBinary()
		_ = yym74
		if false {
		} else {
			z.F.DecMapStringStringX(yyv73, false, d)
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv75 := &x.OwnerReferences
		yym76 := z.DecBinary()
		_ = yym76
		if false {
		} else {
			h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv75), d)
		}
	}
	if x.ObjectMeta.Initializers == nil {
		x.ObjectMeta.Initializers = new(pkg1_v1.Initializers)
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Initializers != nil {
			x.Initializers = nil
		}
	} else {
		if x.Initializers == nil {
			x.Initializers = new(pkg1_v1.Initializers)
		}
		yym78 := z.DecBinary()
		_ = yym78
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Initializers) {
		} else {
			z.DecFallback(x.Initializers, false)
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv79 := &x.Finalizers
		yym80 := z.DecBinary()
		_ = yym80
		if false {
		} else {
			z.F.DecSliceStringX(yyv79, false, d)
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		yyv81 := &x.ClusterName
		yym82 := z.DecBinary()
		_ = yym82
		if false {
		} else {
			*((*string)(yyv81)) = r.DecodeString()
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Timestamp = pkg1_v1.Time{}
	} else {
		yyv83 := &x.Timestamp
		yym84 := z.DecBinary()
		_ = yym84
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv83) {
		} else if yym84 {
			z.DecBinaryUnmarshal(yyv83)
		} else if !yym84 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv83)
		} else {
			z.DecFallback(yyv83, false)
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Window = pkg1_v1.Duration{}
	} else {
		yyv85 := &x.Window
		yym86 := z.DecBinary()
		_ = yym86
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv85) {
		} else if !yym86 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv85)
		} else {
			z.DecFallback(yyv85, false)
		}
	}
	yyj46++
	if yyhl46 {
		yyb46 = yyj46 > l
	} else {
		yyb46 = r.CheckBreak()
	}
	if yyb46 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv87 := &x.Containers
		yym88 := z.DecBinary()
		_ = yym88
		if false {
		} else {
			h.decSliceContainerMetrics((*[]ContainerMetrics)(yyv87), d)
		}
	}
	for {
		yyj46++
		if yyhl46 {
			yyb46 = yyj46 > l
		} else {
			yyb46 = r.CheckBreak()
		}
		if yyb46 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj46-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodMetricsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = x.SelfLink != ""
			yyq2[3] = x.ResourceVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSlicePodMetrics(([]PodMetrics)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						h.encSlicePodMetrics(([]PodMetrics)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodMetricsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodMetricsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				yyv8 := &x.SelfLink
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				yyv10 := &x.ResourceVersion
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "Items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv12 := &x.Items
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					h.decSlicePodMetrics((*[]PodMetrics)(yyv12), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodMetricsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj14 int
	var yyb14 bool
	var yyhl14 bool = l >= 0
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv15 := &x.Kind
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv17 := &x.APIVersion
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*string)(yyv17)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		yyv19 := &x.SelfLink
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(yyv19)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		yyv21 := &x.ResourceVersion
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*string)(yyv21)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv23 := &x.Items
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			h.decSlicePodMetrics((*[]PodMetrics)(yyv23), d)
		}
	}
	for {
		yyj14++
		if yyhl14 {
			yyb14 = yyj14 > l
		} else {
			yyb14 = r.CheckBreak()
		}
		if yyb14 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj14-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerMetrics) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Usage == nil {
					r.EncodeNil()
				} else {
					x.Usage.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Usage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Usage == nil {
					r.EncodeNil()
				} else {
					x.Usage.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerMetrics) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerMetrics) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "Usage":
			if r.TryDecodeAsNil() {
				x.Usage = nil
			} else {
				yyv6 := &x.Usage
				yyv6.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerMetrics) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv8 := &x.Name
		yym9 := z.DecBinary()
		_ = yym9
		if false {
		} else {
			*((*string)(yyv8)) = r.DecodeString()
		}
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Usage = nil
	} else {
		yyv10 := &x.Usage
		yyv10.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			h.encResourceList((ResourceList)(x), e)
		}
	}
}

func (x *ResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		h.decResourceList((*ResourceList)(x), d)
	}
}

func (x ResourceName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ResourceName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x codecSelfer1234) encSlicev1_OwnerReference(v []pkg1_v1.OwnerReference, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy2 := &yyv1
		yym3 := z.EncBinary()
		_ = yym3
		if false {
		} else if z.HasExtensions() && z.EncExt(yy2) {
		} else {
			z.EncFallback(yy2)
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicev1_OwnerReference(v *[]pkg1_v1.OwnerReference, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []pkg1_v1.OwnerReference{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else if yyl1 > 0 {
		var yyrr1, yyrl1 int
		var yyrt1 bool
		_, _ = yyrl1, yyrt1
		yyrr1 = yyl1 // len(yyv1)
		if yyl1 > cap(yyv1) {

			yyrg1 := len(yyv1) > 0
			yyv21 := yyv1
			yyrl1, yyrt1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 80)
			if yyrt1 {
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]pkg1_v1.OwnerReference, yyrl1)
				}
			} else {
				yyv1 = make([]pkg1_v1.OwnerReference, yyrl1)
			}
			yyc1 = true
			yyrr1 = len(yyv1)
			if yyrg1 {
				copy(yyv1, yyv21)
			}
		} else if yyl1 != len(yyv1) {
			yyv1 = yyv1[:yyl1]
			yyc1 = true
		}
		yyj1 := 0
		for ; yyj1 < yyrr1; yyj1++ {
			yyh1.ElemContainerState(yyj1)
			if r.TryDecodeAsNil() {
				yyv1[yyj1] = pkg1_v1.OwnerReference{}
			} else {
				yyv2 := &yyv1[yyj1]
				yym3 := z.DecBinary()
				_ = yym3
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2) {
				} else {
					z.DecFallback(yyv2, false)
				}
			}

		}
		if yyrt1 {
			for ; yyj1 < yyl1; yyj1++ {
				yyv1 = append(yyv1, pkg1_v1.OwnerReference{})
				yyh1.ElemContainerState(yyj1)
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = pkg1_v1.OwnerReference{}
				} else {
					yyv4 := &yyv1[yyj1]
					yym5 := z.DecBinary()
					_ = yym5
					if false {
					} else if z.HasExtensions() && z.DecExt(yyv4) {
					} else {
						z.DecFallback(yyv4, false)
					}
				}

			}
		}

	} else {
		yyj1 := 0
		for ; !r.CheckBreak(); yyj1++ {

			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, pkg1_v1.OwnerReference{}) // var yyz1 pkg1_v1.OwnerReference
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			if yyj1 < len(yyv1) {
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = pkg1_v1.OwnerReference{}
				} else {
					yyv6 := &yyv1[yyj1]
					yym7 := z.DecBinary()
					_ = yym7
					if false {
					} else if z.HasExtensions() && z.DecExt(yyv6) {
					} else {
						z.DecFallback(yyv6, false)
					}
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []pkg1_v1.OwnerReference{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer1234) encSliceNodeMetrics(v []NodeMetrics, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNodeMetrics(v *[]NodeMetrics, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []NodeMetrics{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else if yyl1 > 0 {
		var yyrr1, yyrl1 int
		var yyrt1 bool
		_, _ = yyrl1, yyrt1
		yyrr1 = yyl1 // len(yyv1)
		if yyl1 > cap(yyv1) {

			yyrg1 := len(yyv1) > 0
			yyv21 := yyv1
			yyrl1, yyrt1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 304)
			if yyrt1 {
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]NodeMetrics, yyrl1)
				}
			} else {
				yyv1 = make([]NodeMetrics, yyrl1)
			}
			yyc1 = true
			yyrr1 = len(yyv1)
			if yyrg1 {
				copy(yyv1, yyv21)
			}
		} else if yyl1 != len(yyv1) {
			yyv1 = yyv1[:yyl1]
			yyc1 = true
		}
		yyj1 := 0
		for ; yyj1 < yyrr1; yyj1++ {
			yyh1.ElemContainerState(yyj1)
			if r.TryDecodeAsNil() {
				yyv1[yyj1] = NodeMetrics{}
			} else {
				yyv2 := &yyv1[yyj1]
				yyv2.CodecDecodeSelf(d)
			}

		}
		if yyrt1 {
			for ; yyj1 < yyl1; yyj1++ {
				yyv1 = append(yyv1, NodeMetrics{})
				yyh1.ElemContainerState(yyj1)
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = NodeMetrics{}
				} else {
					yyv3 := &yyv1[yyj1]
					yyv3.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1 := 0
		for ; !r.CheckBreak(); yyj1++ {

			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, NodeMetrics{}) // var yyz1 NodeMetrics
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			if yyj1 < len(yyv1) {
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = NodeMetrics{}
				} else {
					yyv4 := &yyv1[yyj1]
					yyv4.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []NodeMetrics{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer1234) encSliceContainerMetrics(v []ContainerMetrics, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceContainerMetrics(v *[]ContainerMetrics, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []ContainerMetrics{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else if yyl1 > 0 {
		var yyrr1, yyrl1 int
		var yyrt1 bool
		_, _ = yyrl1, yyrt1
		yyrr1 = yyl1 // len(yyv1)
		if yyl1 > cap(yyv1) {

			yyrg1 := len(yyv1) > 0
			yyv21 := yyv1
			yyrl1, yyrt1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1 {
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]ContainerMetrics, yyrl1)
				}
			} else {
				yyv1 = make([]ContainerMetrics, yyrl1)
			}
			yyc1 = true
			yyrr1 = len(yyv1)
			if yyrg1 {
				copy(yyv1, yyv21)
			}
		} else if yyl1 != len(yyv1) {
			yyv1 = yyv1[:yyl1]
			yyc1 = true
		}
		yyj1 := 0
		for ; yyj1 < yyrr1; yyj1++ {
			yyh1.ElemContainerState(yyj1)
			if r.TryDecodeAsNil() {
				yyv1[yyj1] = ContainerMetrics{}
			} else {
				yyv2 := &yyv1[yyj1]
				yyv2.CodecDecodeSelf(d)
			}

		}
		if yyrt1 {
			for ; yyj1 < yyl1; yyj1++ {
				yyv1 = append(yyv1, ContainerMetrics{})
				yyh1.ElemContainerState(yyj1)
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = ContainerMetrics{}
				} else {
					yyv3 := &yyv1[yyj1]
					yyv3.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1 := 0
		for ; !r.CheckBreak(); yyj1++ {

			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, ContainerMetrics{}) // var yyz1 ContainerMetrics
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			if yyj1 < len(yyv1) {
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = ContainerMetrics{}
				} else {
					yyv4 := &yyv1[yyj1]
					yyv4.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []ContainerMetrics{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer1234) encSlicePodMetrics(v []PodMetrics, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePodMetrics(v *[]PodMetrics, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []PodMetrics{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else if yyl1 > 0 {
		var yyrr1, yyrl1 int
		var yyrt1 bool
		_, _ = yyrl1, yyrt1
		yyrr1 = yyl1 // len(yyv1)
		if yyl1 > cap(yyv1) {

			yyrg1 := len(yyv1) > 0
			yyv21 := yyv1
			yyrl1, yyrt1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 320)
			if yyrt1 {
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]PodMetrics, yyrl1)
				}
			} else {
				yyv1 = make([]PodMetrics, yyrl1)
			}
			yyc1 = true
			yyrr1 = len(yyv1)
			if yyrg1 {
				copy(yyv1, yyv21)
			}
		} else if yyl1 != len(yyv1) {
			yyv1 = yyv1[:yyl1]
			yyc1 = true
		}
		yyj1 := 0
		for ; yyj1 < yyrr1; yyj1++ {
			yyh1.ElemContainerState(yyj1)
			if r.TryDecodeAsNil() {
				yyv1[yyj1] = PodMetrics{}
			} else {
				yyv2 := &yyv1[yyj1]
				yyv2.CodecDecodeSelf(d)
			}

		}
		if yyrt1 {
			for ; yyj1 < yyl1; yyj1++ {
				yyv1 = append(yyv1, PodMetrics{})
				yyh1.ElemContainerState(yyj1)
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = PodMetrics{}
				} else {
					yyv3 := &yyv1[yyj1]
					yyv3.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1 := 0
		for ; !r.CheckBreak(); yyj1++ {

			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, PodMetrics{}) // var yyz1 PodMetrics
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			if yyj1 < len(yyv1) {
				if r.TryDecodeAsNil() {
					yyv1[yyj1] = PodMetrics{}
				} else {
					yyv4 := &yyv1[yyj1]
					yyv4.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []PodMetrics{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer1234) encResourceList(v ResourceList, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yyk1.CodecEncodeSelf(e)
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yy3 := &yyv1
		yym4 := z.EncBinary()
		_ = yym4
		if false {
		} else if z.HasExtensions() && z.EncExt(yy3) {
		} else if !yym4 && z.IsJSONHandle() {
			z.EncJSONMarshal(yy3)
		} else {
			z.EncFallback(yy3)
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decResourceList(v *ResourceList, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := r.ReadMapStart()
	yybh1 := z.DecBasicHandle()
	if yyv1 == nil {
		yyrl1, _ := z.DecInferLen(yyl1, yybh1.MaxInitLen, 72)
		yyv1 = make(map[ResourceName]pkg3_resource.Quantity, yyrl1)
		*v = yyv1
	}
	var yymk1 ResourceName
	var yymv1 pkg3_resource.Quantity
	var yymg1 bool
	if yybh1.MapValueReset {
		yymg1 = true
	}
	if yyl1 > 0 {
		for yyj1 := 0; yyj1 < yyl1; yyj1++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1 = ""
			} else {
				yyv2 := &yymk1
				yyv2.CodecDecodeSelf(d)
			}

			if yymg1 {
				yymv1 = yyv1[yymk1]
			} else {
				yymv1 = pkg3_resource.Quantity{}
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1 = pkg3_resource.Quantity{}
			} else {
				yyv3 := &yymv1
				yym4 := z.DecBinary()
				_ = yym4
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3) {
				} else if !yym4 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3)
				} else {
					z.DecFallback(yyv3, false)
				}
			}

			if yyv1 != nil {
				yyv1[yymk1] = yymv1
			}
		}
	} else if yyl1 < 0 {
		for yyj1 := 0; !r.CheckBreak(); yyj1++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1 = ""
			} else {
				yyv5 := &yymk1
				yyv5.CodecDecodeSelf(d)
			}

			if yymg1 {
				yymv1 = yyv1[yymk1]
			} else {
				yymv1 = pkg3_resource.Quantity{}
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1 = pkg3_resource.Quantity{}
			} else {
				yyv6 := &yymv1
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv6) {
				} else if !yym7 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv6)
				} else {
					z.DecFallback(yyv6, false)
				}
			}

			if yyv1 != nil {
				yyv1[yymk1] = yymv1
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}
