#!/bin/bash
#
# This file is part of the KubeVirt project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Copyright 2017 Red Hat, Inc.
#

set -xe

mkdir -p /var/log/kubevirt
touch /var/log/kubevirt/qemu-kube.log
chown qemu:qemu /var/log/kubevirt/qemu-kube.log

# If no main interface is specified, take the first non-loopback device
if [[ -z "$LIBVIRTD_DEFAULT_NETWORK_DEVICE" ]]; then
    LIBVIRTD_DEFAULT_NETWORK_DEVICE=$(ip -o -4 a | tr -s ' ' | cut -d' ' -f 2 | grep -v -e '^lo[0-9:]*$' | head -1)
    echo "Selected \"$LIBVIRTD_DEFAULT_NETWORK_DEVICE\" as primary interface"
fi

# We create the network on a file basis to not
# have to wait for libvirtd to come up
if [[ -n "$LIBVIRTD_DEFAULT_NETWORK_DEVICE" ]]; then
    echo "Setting libvirt default network to \"$LIBVIRTD_DEFAULT_NETWORK_DEVICE\""
    mkdir -p /etc/libvirt/qemu/networks/autostart
    cat >/etc/libvirt/qemu/networks/default.xml <<EOX
<!-- Generated by libvirtd.sh container script -->
<network>
  <name>default</name>
  <forward mode="bridge">
    <interface dev="$LIBVIRTD_DEFAULT_NETWORK_DEVICE" />
  </forward>
</network>
EOX
    ln -s -f /etc/libvirt/qemu/networks/default.xml /etc/libvirt/qemu/networks/autostart/default.xml
fi

echo "cgroup_controllers = [ ]" >>/etc/libvirt/qemu.conf

# Be sure that libvirt always will be look the same directory for hugepages mount
if [ -d "/dev/hugepages" ]; then
    echo 'hugetlbfs_mount = "/dev/hugepages"' >>/etc/libvirt/qemu.conf
fi

# Log to stderr
echo "log_outputs = \"1:stderr\"" >> /etc/libvirt/libvirtd.conf

/usr/sbin/libvirtd