# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectionMonitorSource(Model):
    """Describes the source of connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource used as the source by
     connection monitor.
    :type resource_id: str
    :param port: The source port used by connection monitor.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, *, resource_id: str, port: int=None, **kwargs) -> None:
        super(ConnectionMonitorSource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port
